# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ... import meta as _meta

__all__ = [
    'ContainerResourceMetricSourceArgs',
    'ContainerResourceMetricStatusArgs',
    'CrossVersionObjectReferenceArgs',
    'ExternalMetricSourceArgs',
    'ExternalMetricStatusArgs',
    'HorizontalPodAutoscalerArgs',
    'HorizontalPodAutoscalerConditionArgs',
    'HorizontalPodAutoscalerSpecArgs',
    'HorizontalPodAutoscalerStatusArgs',
    'MetricSpecArgs',
    'MetricStatusArgs',
    'ObjectMetricSourceArgs',
    'ObjectMetricStatusArgs',
    'PodsMetricSourceArgs',
    'PodsMetricStatusArgs',
    'ResourceMetricSourceArgs',
    'ResourceMetricStatusArgs',
]

@pulumi.input_type
class ContainerResourceMetricSourceArgs:
    def __init__(__self__, *,
                 container: pulumi.Input[str],
                 name: pulumi.Input[str],
                 target_average_utilization: Optional[pulumi.Input[int]] = None,
                 target_average_value: Optional[pulumi.Input[str]] = None):
        """
        ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param pulumi.Input[str] container: container is the name of the container in the pods of the scaling target
        :param pulumi.Input[str] name: name is the name of the resource in question.
        :param pulumi.Input[int] target_average_utilization: targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        :param pulumi.Input[str] target_average_value: targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the "pods" metric source type.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        if target_average_utilization is not None:
            pulumi.set(__self__, "target_average_utilization", target_average_utilization)
        if target_average_value is not None:
            pulumi.set(__self__, "target_average_value", target_average_value)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetAverageUtilization")
    def target_average_utilization(self) -> Optional[pulumi.Input[int]]:
        """
        targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        """
        return pulumi.get(self, "target_average_utilization")

    @target_average_utilization.setter
    def target_average_utilization(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_average_utilization", value)

    @property
    @pulumi.getter(name="targetAverageValue")
    def target_average_value(self) -> Optional[pulumi.Input[str]]:
        """
        targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the "pods" metric source type.
        """
        return pulumi.get(self, "target_average_value")

    @target_average_value.setter
    def target_average_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_average_value", value)


@pulumi.input_type
class ContainerResourceMetricStatusArgs:
    def __init__(__self__, *,
                 container: pulumi.Input[str],
                 current_average_value: pulumi.Input[str],
                 name: pulumi.Input[str],
                 current_average_utilization: Optional[pulumi.Input[int]] = None):
        """
        ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param pulumi.Input[str] container: container is the name of the container in the pods of the scaling target
        :param pulumi.Input[str] current_average_value: currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the "pods" metric source type. It will always be set, regardless of the corresponding metric specification.
        :param pulumi.Input[str] name: name is the name of the resource in question.
        :param pulumi.Input[int] current_average_utilization: currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "current_average_value", current_average_value)
        pulumi.set(__self__, "name", name)
        if current_average_utilization is not None:
            pulumi.set(__self__, "current_average_utilization", current_average_utilization)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="currentAverageValue")
    def current_average_value(self) -> pulumi.Input[str]:
        """
        currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the "pods" metric source type. It will always be set, regardless of the corresponding metric specification.
        """
        return pulumi.get(self, "current_average_value")

    @current_average_value.setter
    def current_average_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "current_average_value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="currentAverageUtilization")
    def current_average_utilization(self) -> Optional[pulumi.Input[int]]:
        """
        currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.
        """
        return pulumi.get(self, "current_average_utilization")

    @current_average_utilization.setter
    def current_average_utilization(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_average_utilization", value)


@pulumi.input_type
class CrossVersionObjectReferenceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 name: pulumi.Input[str],
                 api_version: Optional[pulumi.Input[str]] = None):
        """
        CrossVersionObjectReference contains enough information to let you identify the referred resource.
        :param pulumi.Input[str] kind: Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        :param pulumi.Input[str] name: Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param pulumi.Input[str] api_version: API version of the referent
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        API version of the referent
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)


@pulumi.input_type
class ExternalMetricSourceArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[str],
                 metric_selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None,
                 target_average_value: Optional[pulumi.Input[str]] = None,
                 target_value: Optional[pulumi.Input[str]] = None):
        """
        ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster). Exactly one "target" type should be set.
        :param pulumi.Input[str] metric_name: metricName is the name of the metric in question.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] metric_selector: metricSelector is used to identify a specific time series within a given metric.
        :param pulumi.Input[str] target_average_value: targetAverageValue is the target per-pod value of global metric (as a quantity). Mutually exclusive with TargetValue.
        :param pulumi.Input[str] target_value: targetValue is the target value of the metric (as a quantity). Mutually exclusive with TargetAverageValue.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        if metric_selector is not None:
            pulumi.set(__self__, "metric_selector", metric_selector)
        if target_average_value is not None:
            pulumi.set(__self__, "target_average_value", target_average_value)
        if target_value is not None:
            pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        metricName is the name of the metric in question.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="metricSelector")
    def metric_selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        metricSelector is used to identify a specific time series within a given metric.
        """
        return pulumi.get(self, "metric_selector")

    @metric_selector.setter
    def metric_selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "metric_selector", value)

    @property
    @pulumi.getter(name="targetAverageValue")
    def target_average_value(self) -> Optional[pulumi.Input[str]]:
        """
        targetAverageValue is the target per-pod value of global metric (as a quantity). Mutually exclusive with TargetValue.
        """
        return pulumi.get(self, "target_average_value")

    @target_average_value.setter
    def target_average_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_average_value", value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> Optional[pulumi.Input[str]]:
        """
        targetValue is the target value of the metric (as a quantity). Mutually exclusive with TargetAverageValue.
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_value", value)


@pulumi.input_type
class ExternalMetricStatusArgs:
    def __init__(__self__, *,
                 current_value: pulumi.Input[str],
                 metric_name: pulumi.Input[str],
                 current_average_value: Optional[pulumi.Input[str]] = None,
                 metric_selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None):
        """
        ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.
        :param pulumi.Input[str] current_value: currentValue is the current value of the metric (as a quantity)
        :param pulumi.Input[str] metric_name: metricName is the name of a metric used for autoscaling in metric system.
        :param pulumi.Input[str] current_average_value: currentAverageValue is the current value of metric averaged over autoscaled pods.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] metric_selector: metricSelector is used to identify a specific time series within a given metric.
        """
        pulumi.set(__self__, "current_value", current_value)
        pulumi.set(__self__, "metric_name", metric_name)
        if current_average_value is not None:
            pulumi.set(__self__, "current_average_value", current_average_value)
        if metric_selector is not None:
            pulumi.set(__self__, "metric_selector", metric_selector)

    @property
    @pulumi.getter(name="currentValue")
    def current_value(self) -> pulumi.Input[str]:
        """
        currentValue is the current value of the metric (as a quantity)
        """
        return pulumi.get(self, "current_value")

    @current_value.setter
    def current_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "current_value", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        metricName is the name of a metric used for autoscaling in metric system.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="currentAverageValue")
    def current_average_value(self) -> Optional[pulumi.Input[str]]:
        """
        currentAverageValue is the current value of metric averaged over autoscaled pods.
        """
        return pulumi.get(self, "current_average_value")

    @current_average_value.setter
    def current_average_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_average_value", value)

    @property
    @pulumi.getter(name="metricSelector")
    def metric_selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        metricSelector is used to identify a specific time series within a given metric.
        """
        return pulumi.get(self, "metric_selector")

    @metric_selector.setter
    def metric_selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "metric_selector", value)


@pulumi.input_type
class HorizontalPodAutoscalerArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['HorizontalPodAutoscalerSpecArgs']] = None,
                 status: Optional[pulumi.Input['HorizontalPodAutoscalerStatusArgs']] = None):
        """
        HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['HorizontalPodAutoscalerSpecArgs'] spec: spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        :param pulumi.Input['HorizontalPodAutoscalerStatusArgs'] status: status is the current information about the autoscaler.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'autoscaling/v2beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'HorizontalPodAutoscaler')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['HorizontalPodAutoscalerSpecArgs']]:
        """
        spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['HorizontalPodAutoscalerSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['HorizontalPodAutoscalerStatusArgs']]:
        """
        status is the current information about the autoscaler.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['HorizontalPodAutoscalerStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class HorizontalPodAutoscalerConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 type: pulumi.Input[str],
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.
        :param pulumi.Input[str] status: status is the status of the condition (True, False, Unknown)
        :param pulumi.Input[str] type: type describes the current condition
        :param pulumi.Input[str] last_transition_time: lastTransitionTime is the last time the condition transitioned from one status to another
        :param pulumi.Input[str] message: message is a human-readable explanation containing details about the transition
        :param pulumi.Input[str] reason: reason is the reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        status is the status of the condition (True, False, Unknown)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        type describes the current condition
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        lastTransitionTime is the last time the condition transitioned from one status to another
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        message is a human-readable explanation containing details about the transition
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        reason is the reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class HorizontalPodAutoscalerSpecArgs:
    def __init__(__self__, *,
                 max_replicas: pulumi.Input[int],
                 scale_target_ref: pulumi.Input['CrossVersionObjectReferenceArgs'],
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['MetricSpecArgs']]]] = None,
                 min_replicas: Optional[pulumi.Input[int]] = None):
        """
        HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
        :param pulumi.Input[int] max_replicas: maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param pulumi.Input['CrossVersionObjectReferenceArgs'] scale_target_ref: scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        :param pulumi.Input[Sequence[pulumi.Input['MetricSpecArgs']]] metrics: metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond.
        :param pulumi.Input[int] min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        """
        pulumi.set(__self__, "max_replicas", max_replicas)
        pulumi.set(__self__, "scale_target_ref", scale_target_ref)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> pulumi.Input[int]:
        """
        maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        """
        return pulumi.get(self, "max_replicas")

    @max_replicas.setter
    def max_replicas(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_replicas", value)

    @property
    @pulumi.getter(name="scaleTargetRef")
    def scale_target_ref(self) -> pulumi.Input['CrossVersionObjectReferenceArgs']:
        """
        scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        """
        return pulumi.get(self, "scale_target_ref")

    @scale_target_ref.setter
    def scale_target_ref(self, value: pulumi.Input['CrossVersionObjectReferenceArgs']):
        pulumi.set(self, "scale_target_ref", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricSpecArgs']]]]:
        """
        metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricSpecArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        """
        return pulumi.get(self, "min_replicas")

    @min_replicas.setter
    def min_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_replicas", value)


@pulumi.input_type
class HorizontalPodAutoscalerStatusArgs:
    def __init__(__self__, *,
                 conditions: pulumi.Input[Sequence[pulumi.Input['HorizontalPodAutoscalerConditionArgs']]],
                 current_replicas: pulumi.Input[int],
                 desired_replicas: pulumi.Input[int],
                 current_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['MetricStatusArgs']]]] = None,
                 last_scale_time: Optional[pulumi.Input[str]] = None,
                 observed_generation: Optional[pulumi.Input[int]] = None):
        """
        HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input['HorizontalPodAutoscalerConditionArgs']]] conditions: conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
        :param pulumi.Input[int] current_replicas: currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
        :param pulumi.Input[int] desired_replicas: desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input['MetricStatusArgs']]] current_metrics: currentMetrics is the last read state of the metrics used by this autoscaler.
        :param pulumi.Input[str] last_scale_time: lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
        :param pulumi.Input[int] observed_generation: observedGeneration is the most recent generation observed by this autoscaler.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "current_replicas", current_replicas)
        pulumi.set(__self__, "desired_replicas", desired_replicas)
        if current_metrics is not None:
            pulumi.set(__self__, "current_metrics", current_metrics)
        if last_scale_time is not None:
            pulumi.set(__self__, "last_scale_time", last_scale_time)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['HorizontalPodAutoscalerConditionArgs']]]:
        """
        conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['HorizontalPodAutoscalerConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="currentReplicas")
    def current_replicas(self) -> pulumi.Input[int]:
        """
        currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
        """
        return pulumi.get(self, "current_replicas")

    @current_replicas.setter
    def current_replicas(self, value: pulumi.Input[int]):
        pulumi.set(self, "current_replicas", value)

    @property
    @pulumi.getter(name="desiredReplicas")
    def desired_replicas(self) -> pulumi.Input[int]:
        """
        desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
        """
        return pulumi.get(self, "desired_replicas")

    @desired_replicas.setter
    def desired_replicas(self, value: pulumi.Input[int]):
        pulumi.set(self, "desired_replicas", value)

    @property
    @pulumi.getter(name="currentMetrics")
    def current_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricStatusArgs']]]]:
        """
        currentMetrics is the last read state of the metrics used by this autoscaler.
        """
        return pulumi.get(self, "current_metrics")

    @current_metrics.setter
    def current_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricStatusArgs']]]]):
        pulumi.set(self, "current_metrics", value)

    @property
    @pulumi.getter(name="lastScaleTime")
    def last_scale_time(self) -> Optional[pulumi.Input[str]]:
        """
        lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
        """
        return pulumi.get(self, "last_scale_time")

    @last_scale_time.setter
    def last_scale_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_scale_time", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[int]]:
        """
        observedGeneration is the most recent generation observed by this autoscaler.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "observed_generation", value)


@pulumi.input_type
class MetricSpecArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 container_resource: Optional[pulumi.Input['ContainerResourceMetricSourceArgs']] = None,
                 external: Optional[pulumi.Input['ExternalMetricSourceArgs']] = None,
                 object: Optional[pulumi.Input['ObjectMetricSourceArgs']] = None,
                 pods: Optional[pulumi.Input['PodsMetricSourceArgs']] = None,
                 resource: Optional[pulumi.Input['ResourceMetricSourceArgs']] = None):
        """
        MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
        :param pulumi.Input[str] type: type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        :param pulumi.Input['ContainerResourceMetricSourceArgs'] container_resource: container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
        :param pulumi.Input['ExternalMetricSourceArgs'] external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param pulumi.Input['ObjectMetricSourceArgs'] object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param pulumi.Input['PodsMetricSourceArgs'] pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param pulumi.Input['ResourceMetricSourceArgs'] resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        pulumi.set(__self__, "type", type)
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional[pulumi.Input['ContainerResourceMetricSourceArgs']]:
        """
        container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
        """
        return pulumi.get(self, "container_resource")

    @container_resource.setter
    def container_resource(self, value: Optional[pulumi.Input['ContainerResourceMetricSourceArgs']]):
        pulumi.set(self, "container_resource", value)

    @property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input['ExternalMetricSourceArgs']]:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input['ExternalMetricSourceArgs']]):
        pulumi.set(self, "external", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input['ObjectMetricSourceArgs']]:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input['ObjectMetricSourceArgs']]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def pods(self) -> Optional[pulumi.Input['PodsMetricSourceArgs']]:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @pods.setter
    def pods(self, value: Optional[pulumi.Input['PodsMetricSourceArgs']]):
        pulumi.set(self, "pods", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input['ResourceMetricSourceArgs']]:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input['ResourceMetricSourceArgs']]):
        pulumi.set(self, "resource", value)


@pulumi.input_type
class MetricStatusArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 container_resource: Optional[pulumi.Input['ContainerResourceMetricStatusArgs']] = None,
                 external: Optional[pulumi.Input['ExternalMetricStatusArgs']] = None,
                 object: Optional[pulumi.Input['ObjectMetricStatusArgs']] = None,
                 pods: Optional[pulumi.Input['PodsMetricStatusArgs']] = None,
                 resource: Optional[pulumi.Input['ResourceMetricStatusArgs']] = None):
        """
        MetricStatus describes the last-read state of a single metric.
        :param pulumi.Input[str] type: type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        :param pulumi.Input['ContainerResourceMetricStatusArgs'] container_resource: container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param pulumi.Input['ExternalMetricStatusArgs'] external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param pulumi.Input['ObjectMetricStatusArgs'] object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param pulumi.Input['PodsMetricStatusArgs'] pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param pulumi.Input['ResourceMetricStatusArgs'] resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        pulumi.set(__self__, "type", type)
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional[pulumi.Input['ContainerResourceMetricStatusArgs']]:
        """
        container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "container_resource")

    @container_resource.setter
    def container_resource(self, value: Optional[pulumi.Input['ContainerResourceMetricStatusArgs']]):
        pulumi.set(self, "container_resource", value)

    @property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input['ExternalMetricStatusArgs']]:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input['ExternalMetricStatusArgs']]):
        pulumi.set(self, "external", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input['ObjectMetricStatusArgs']]:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input['ObjectMetricStatusArgs']]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def pods(self) -> Optional[pulumi.Input['PodsMetricStatusArgs']]:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @pods.setter
    def pods(self, value: Optional[pulumi.Input['PodsMetricStatusArgs']]):
        pulumi.set(self, "pods", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input['ResourceMetricStatusArgs']]:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input['ResourceMetricStatusArgs']]):
        pulumi.set(self, "resource", value)


@pulumi.input_type
class ObjectMetricSourceArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[str],
                 target: pulumi.Input['CrossVersionObjectReferenceArgs'],
                 target_value: pulumi.Input[str],
                 average_value: Optional[pulumi.Input[str]] = None,
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None):
        """
        ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param pulumi.Input[str] metric_name: metricName is the name of the metric in question.
        :param pulumi.Input['CrossVersionObjectReferenceArgs'] target: target is the described Kubernetes object.
        :param pulumi.Input[str] target_value: targetValue is the target value of the metric (as a quantity).
        :param pulumi.Input[str] average_value: averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] selector: selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "target_value", target_value)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        metricName is the name of the metric in question.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input['CrossVersionObjectReferenceArgs']:
        """
        target is the described Kubernetes object.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['CrossVersionObjectReferenceArgs']):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[str]:
        """
        targetValue is the target value of the metric (as a quantity).
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_value", value)

    @property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[pulumi.Input[str]]:
        """
        averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @average_value.setter
    def average_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "average_value", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class ObjectMetricStatusArgs:
    def __init__(__self__, *,
                 current_value: pulumi.Input[str],
                 metric_name: pulumi.Input[str],
                 target: pulumi.Input['CrossVersionObjectReferenceArgs'],
                 average_value: Optional[pulumi.Input[str]] = None,
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None):
        """
        ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param pulumi.Input[str] current_value: currentValue is the current value of the metric (as a quantity).
        :param pulumi.Input[str] metric_name: metricName is the name of the metric in question.
        :param pulumi.Input['CrossVersionObjectReferenceArgs'] target: target is the described Kubernetes object.
        :param pulumi.Input[str] average_value: averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] selector: selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the ObjectMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        pulumi.set(__self__, "current_value", current_value)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "target", target)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="currentValue")
    def current_value(self) -> pulumi.Input[str]:
        """
        currentValue is the current value of the metric (as a quantity).
        """
        return pulumi.get(self, "current_value")

    @current_value.setter
    def current_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "current_value", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        metricName is the name of the metric in question.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input['CrossVersionObjectReferenceArgs']:
        """
        target is the described Kubernetes object.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['CrossVersionObjectReferenceArgs']):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[pulumi.Input[str]]:
        """
        averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @average_value.setter
    def average_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "average_value", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the ObjectMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class PodsMetricSourceArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[str],
                 target_average_value: pulumi.Input[str],
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None):
        """
        PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
        :param pulumi.Input[str] metric_name: metricName is the name of the metric in question
        :param pulumi.Input[str] target_average_value: targetAverageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] selector: selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "target_average_value", target_average_value)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        metricName is the name of the metric in question
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="targetAverageValue")
    def target_average_value(self) -> pulumi.Input[str]:
        """
        targetAverageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "target_average_value")

    @target_average_value.setter
    def target_average_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_average_value", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class PodsMetricStatusArgs:
    def __init__(__self__, *,
                 current_average_value: pulumi.Input[str],
                 metric_name: pulumi.Input[str],
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None):
        """
        PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
        :param pulumi.Input[str] current_average_value: currentAverageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        :param pulumi.Input[str] metric_name: metricName is the name of the metric in question
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] selector: selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the PodsMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        pulumi.set(__self__, "current_average_value", current_average_value)
        pulumi.set(__self__, "metric_name", metric_name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="currentAverageValue")
    def current_average_value(self) -> pulumi.Input[str]:
        """
        currentAverageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "current_average_value")

    @current_average_value.setter
    def current_average_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "current_average_value", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        metricName is the name of the metric in question
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the PodsMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class ResourceMetricSourceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 target_average_utilization: Optional[pulumi.Input[int]] = None,
                 target_average_value: Optional[pulumi.Input[str]] = None):
        """
        ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param pulumi.Input[str] name: name is the name of the resource in question.
        :param pulumi.Input[int] target_average_utilization: targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        :param pulumi.Input[str] target_average_value: targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the "pods" metric source type.
        """
        pulumi.set(__self__, "name", name)
        if target_average_utilization is not None:
            pulumi.set(__self__, "target_average_utilization", target_average_utilization)
        if target_average_value is not None:
            pulumi.set(__self__, "target_average_value", target_average_value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetAverageUtilization")
    def target_average_utilization(self) -> Optional[pulumi.Input[int]]:
        """
        targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        """
        return pulumi.get(self, "target_average_utilization")

    @target_average_utilization.setter
    def target_average_utilization(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_average_utilization", value)

    @property
    @pulumi.getter(name="targetAverageValue")
    def target_average_value(self) -> Optional[pulumi.Input[str]]:
        """
        targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the "pods" metric source type.
        """
        return pulumi.get(self, "target_average_value")

    @target_average_value.setter
    def target_average_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_average_value", value)


@pulumi.input_type
class ResourceMetricStatusArgs:
    def __init__(__self__, *,
                 current_average_value: pulumi.Input[str],
                 name: pulumi.Input[str],
                 current_average_utilization: Optional[pulumi.Input[int]] = None):
        """
        ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param pulumi.Input[str] current_average_value: currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the "pods" metric source type. It will always be set, regardless of the corresponding metric specification.
        :param pulumi.Input[str] name: name is the name of the resource in question.
        :param pulumi.Input[int] current_average_utilization: currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.
        """
        pulumi.set(__self__, "current_average_value", current_average_value)
        pulumi.set(__self__, "name", name)
        if current_average_utilization is not None:
            pulumi.set(__self__, "current_average_utilization", current_average_utilization)

    @property
    @pulumi.getter(name="currentAverageValue")
    def current_average_value(self) -> pulumi.Input[str]:
        """
        currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the "pods" metric source type. It will always be set, regardless of the corresponding metric specification.
        """
        return pulumi.get(self, "current_average_value")

    @current_average_value.setter
    def current_average_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "current_average_value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="currentAverageUtilization")
    def current_average_utilization(self) -> Optional[pulumi.Input[int]]:
        """
        currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.
        """
        return pulumi.get(self, "current_average_utilization")

    @current_average_utilization.setter
    def current_average_utilization(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_average_utilization", value)


