# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'ContainerResourceMetricSource',
    'ContainerResourceMetricStatus',
    'CrossVersionObjectReference',
    'ExternalMetricSource',
    'ExternalMetricStatus',
    'HPAScalingPolicy',
    'HPAScalingRules',
    'HorizontalPodAutoscaler',
    'HorizontalPodAutoscalerBehavior',
    'HorizontalPodAutoscalerCondition',
    'HorizontalPodAutoscalerSpec',
    'HorizontalPodAutoscalerStatus',
    'MetricIdentifier',
    'MetricSpec',
    'MetricStatus',
    'MetricTarget',
    'MetricValueStatus',
    'ObjectMetricSource',
    'ObjectMetricStatus',
    'PodsMetricSource',
    'PodsMetricStatus',
    'ResourceMetricSource',
    'ResourceMetricStatus',
]

@pulumi.output_type
class ContainerResourceMetricSource(dict):
    """
    ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
    """
    def __init__(__self__, *,
                 container: str,
                 name: str,
                 target: 'outputs.MetricTarget'):
        """
        ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param str container: container is the name of the container in the pods of the scaling target
        :param str name: name is the name of the resource in question.
        :param 'MetricTargetArgs' target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def target(self) -> 'outputs.MetricTarget':
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ContainerResourceMetricStatus(dict):
    """
    ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
    """
    def __init__(__self__, *,
                 container: str,
                 current: 'outputs.MetricValueStatus',
                 name: str):
        """
        ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param str container: Container is the name of the container in the pods of the scaling target
        :param 'MetricValueStatusArgs' current: current contains the current value for the given metric
        :param str name: Name is the name of the resource in question.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        Container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def current(self) -> 'outputs.MetricValueStatus':
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is the name of the resource in question.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CrossVersionObjectReference(dict):
    """
    CrossVersionObjectReference contains enough information to let you identify the referred resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrossVersionObjectReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrossVersionObjectReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrossVersionObjectReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 name: str,
                 api_version: Optional[str] = None):
        """
        CrossVersionObjectReference contains enough information to let you identify the referred resource.
        :param str kind: Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        :param str name: Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param str api_version: API version of the referent
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        API version of the referent
        """
        return pulumi.get(self, "api_version")


@pulumi.output_type
class ExternalMetricSource(dict):
    """
    ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
    """
    def __init__(__self__, *,
                 metric: 'outputs.MetricIdentifier',
                 target: 'outputs.MetricTarget'):
        """
        ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        :param 'MetricTargetArgs' target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def target(self) -> 'outputs.MetricTarget':
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ExternalMetricStatus(dict):
    """
    ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.
    """
    def __init__(__self__, *,
                 current: 'outputs.MetricValueStatus',
                 metric: 'outputs.MetricIdentifier'):
        """
        ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.
        :param 'MetricValueStatusArgs' current: current contains the current value for the given metric
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter
    def current(self) -> 'outputs.MetricValueStatus':
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class HPAScalingPolicy(dict):
    """
    HPAScalingPolicy is a single policy which must hold true for a specified past interval.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "periodSeconds":
            suggest = "period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HPAScalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HPAScalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HPAScalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 period_seconds: int,
                 type: str,
                 value: int):
        """
        HPAScalingPolicy is a single policy which must hold true for a specified past interval.
        :param int period_seconds: PeriodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        :param str type: Type is used to specify the scaling policy.
        :param int value: Value contains the amount of change which is permitted by the policy. It must be greater than zero
        """
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> int:
        """
        PeriodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type is used to specify the scaling policy.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        Value contains the amount of change which is permitted by the policy. It must be greater than zero
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HPAScalingRules(dict):
    """
    HPAScalingRules configures the scaling behavior for one direction. These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectPolicy":
            suggest = "select_policy"
        elif key == "stabilizationWindowSeconds":
            suggest = "stabilization_window_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HPAScalingRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HPAScalingRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HPAScalingRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policies: Optional[Sequence['outputs.HPAScalingPolicy']] = None,
                 select_policy: Optional[str] = None,
                 stabilization_window_seconds: Optional[int] = None):
        """
        HPAScalingRules configures the scaling behavior for one direction. These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.
        :param Sequence['HPAScalingPolicyArgs'] policies: policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
        :param str select_policy: selectPolicy is used to specify which policy should be used. If not set, the default value MaxPolicySelect is used.
        :param int stabilization_window_seconds: StabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
        """
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if select_policy is not None:
            pulumi.set(__self__, "select_policy", select_policy)
        if stabilization_window_seconds is not None:
            pulumi.set(__self__, "stabilization_window_seconds", stabilization_window_seconds)

    @property
    @pulumi.getter
    def policies(self) -> Optional[Sequence['outputs.HPAScalingPolicy']]:
        """
        policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="selectPolicy")
    def select_policy(self) -> Optional[str]:
        """
        selectPolicy is used to specify which policy should be used. If not set, the default value MaxPolicySelect is used.
        """
        return pulumi.get(self, "select_policy")

    @property
    @pulumi.getter(name="stabilizationWindowSeconds")
    def stabilization_window_seconds(self) -> Optional[int]:
        """
        StabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
        """
        return pulumi.get(self, "stabilization_window_seconds")


@pulumi.output_type
class HorizontalPodAutoscaler(dict):
    """
    HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.HorizontalPodAutoscalerSpec'] = None,
                 status: Optional['outputs.HorizontalPodAutoscalerStatus'] = None):
        """
        HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'HorizontalPodAutoscalerSpecArgs' spec: spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        :param 'HorizontalPodAutoscalerStatusArgs' status: status is the current information about the autoscaler.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'autoscaling/v2beta2')
        if kind is not None:
            pulumi.set(__self__, "kind", 'HorizontalPodAutoscaler')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.HorizontalPodAutoscalerSpec']:
        """
        spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.HorizontalPodAutoscalerStatus']:
        """
        status is the current information about the autoscaler.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class HorizontalPodAutoscalerBehavior(dict):
    """
    HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleDown":
            suggest = "scale_down"
        elif key == "scaleUp":
            suggest = "scale_up"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerBehavior. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerBehavior.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerBehavior.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_down: Optional['outputs.HPAScalingRules'] = None,
                 scale_up: Optional['outputs.HPAScalingRules'] = None):
        """
        HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).
        :param 'HPAScalingRulesArgs' scale_down: scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        :param 'HPAScalingRulesArgs' scale_up: scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
                 * increase no more than 4 pods per 60 seconds
                 * double the number of pods per 60 seconds
               No stabilization is used.
        """
        if scale_down is not None:
            pulumi.set(__self__, "scale_down", scale_down)
        if scale_up is not None:
            pulumi.set(__self__, "scale_up", scale_up)

    @property
    @pulumi.getter(name="scaleDown")
    def scale_down(self) -> Optional['outputs.HPAScalingRules']:
        """
        scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        """
        return pulumi.get(self, "scale_down")

    @property
    @pulumi.getter(name="scaleUp")
    def scale_up(self) -> Optional['outputs.HPAScalingRules']:
        """
        scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
          * increase no more than 4 pods per 60 seconds
          * double the number of pods per 60 seconds
        No stabilization is used.
        """
        return pulumi.get(self, "scale_up")


@pulumi.output_type
class HorizontalPodAutoscalerCondition(dict):
    """
    HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 type: str,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.
        :param str status: status is the status of the condition (True, False, Unknown)
        :param str type: type describes the current condition
        :param str last_transition_time: lastTransitionTime is the last time the condition transitioned from one status to another
        :param str message: message is a human-readable explanation containing details about the transition
        :param str reason: reason is the reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        status is the status of the condition (True, False, Unknown)
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type describes the current condition
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        lastTransitionTime is the last time the condition transitioned from one status to another
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        message is a human-readable explanation containing details about the transition
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        reason is the reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class HorizontalPodAutoscalerSpec(dict):
    """
    HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicas":
            suggest = "max_replicas"
        elif key == "scaleTargetRef":
            suggest = "scale_target_ref"
        elif key == "minReplicas":
            suggest = "min_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_replicas: int,
                 scale_target_ref: 'outputs.CrossVersionObjectReference',
                 behavior: Optional['outputs.HorizontalPodAutoscalerBehavior'] = None,
                 metrics: Optional[Sequence['outputs.MetricSpec']] = None,
                 min_replicas: Optional[int] = None):
        """
        HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
        :param int max_replicas: maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param 'CrossVersionObjectReferenceArgs' scale_target_ref: scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        :param 'HorizontalPodAutoscalerBehaviorArgs' behavior: behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        :param Sequence['MetricSpecArgs'] metrics: metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        :param int min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        """
        pulumi.set(__self__, "max_replicas", max_replicas)
        pulumi.set(__self__, "scale_target_ref", scale_target_ref)
        if behavior is not None:
            pulumi.set(__self__, "behavior", behavior)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> int:
        """
        maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        """
        return pulumi.get(self, "max_replicas")

    @property
    @pulumi.getter(name="scaleTargetRef")
    def scale_target_ref(self) -> 'outputs.CrossVersionObjectReference':
        """
        scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        """
        return pulumi.get(self, "scale_target_ref")

    @property
    @pulumi.getter
    def behavior(self) -> Optional['outputs.HorizontalPodAutoscalerBehavior']:
        """
        behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        """
        return pulumi.get(self, "behavior")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.MetricSpec']]:
        """
        metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[int]:
        """
        minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        """
        return pulumi.get(self, "min_replicas")


@pulumi.output_type
class HorizontalPodAutoscalerStatus(dict):
    """
    HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentReplicas":
            suggest = "current_replicas"
        elif key == "desiredReplicas":
            suggest = "desired_replicas"
        elif key == "currentMetrics":
            suggest = "current_metrics"
        elif key == "lastScaleTime":
            suggest = "last_scale_time"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.HorizontalPodAutoscalerCondition'],
                 current_replicas: int,
                 desired_replicas: int,
                 current_metrics: Optional[Sequence['outputs.MetricStatus']] = None,
                 last_scale_time: Optional[str] = None,
                 observed_generation: Optional[int] = None):
        """
        HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.
        :param Sequence['HorizontalPodAutoscalerConditionArgs'] conditions: conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
        :param int current_replicas: currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
        :param int desired_replicas: desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
        :param Sequence['MetricStatusArgs'] current_metrics: currentMetrics is the last read state of the metrics used by this autoscaler.
        :param str last_scale_time: lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
        :param int observed_generation: observedGeneration is the most recent generation observed by this autoscaler.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "current_replicas", current_replicas)
        pulumi.set(__self__, "desired_replicas", desired_replicas)
        if current_metrics is not None:
            pulumi.set(__self__, "current_metrics", current_metrics)
        if last_scale_time is not None:
            pulumi.set(__self__, "last_scale_time", last_scale_time)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.HorizontalPodAutoscalerCondition']:
        """
        conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="currentReplicas")
    def current_replicas(self) -> int:
        """
        currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
        """
        return pulumi.get(self, "current_replicas")

    @property
    @pulumi.getter(name="desiredReplicas")
    def desired_replicas(self) -> int:
        """
        desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
        """
        return pulumi.get(self, "desired_replicas")

    @property
    @pulumi.getter(name="currentMetrics")
    def current_metrics(self) -> Optional[Sequence['outputs.MetricStatus']]:
        """
        currentMetrics is the last read state of the metrics used by this autoscaler.
        """
        return pulumi.get(self, "current_metrics")

    @property
    @pulumi.getter(name="lastScaleTime")
    def last_scale_time(self) -> Optional[str]:
        """
        lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
        """
        return pulumi.get(self, "last_scale_time")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        """
        observedGeneration is the most recent generation observed by this autoscaler.
        """
        return pulumi.get(self, "observed_generation")


@pulumi.output_type
class MetricIdentifier(dict):
    """
    MetricIdentifier defines the name and optionally selector for a metric
    """
    def __init__(__self__, *,
                 name: str,
                 selector: Optional['_meta.v1.outputs.LabelSelector'] = None):
        """
        MetricIdentifier defines the name and optionally selector for a metric
        :param str name: name is the name of the given metric
        :param '_meta.v1.LabelSelectorArgs' selector: selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        pulumi.set(__self__, "name", name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name is the name of the given metric
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class MetricSpec(dict):
    """
    MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerResource":
            suggest = "container_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 container_resource: Optional['outputs.ContainerResourceMetricSource'] = None,
                 external: Optional['outputs.ExternalMetricSource'] = None,
                 object: Optional['outputs.ObjectMetricSource'] = None,
                 pods: Optional['outputs.PodsMetricSource'] = None,
                 resource: Optional['outputs.ResourceMetricSource'] = None):
        """
        MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
        :param str type: type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        :param 'ContainerResourceMetricSourceArgs' container_resource: container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
        :param 'ExternalMetricSourceArgs' external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param 'ObjectMetricSourceArgs' object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'PodsMetricSourceArgs' pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param 'ResourceMetricSourceArgs' resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        pulumi.set(__self__, "type", type)
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional['outputs.ContainerResourceMetricSource']:
        """
        container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
        """
        return pulumi.get(self, "container_resource")

    @property
    @pulumi.getter
    def external(self) -> Optional['outputs.ExternalMetricSource']:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @property
    @pulumi.getter
    def object(self) -> Optional['outputs.ObjectMetricSource']:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def pods(self) -> Optional['outputs.PodsMetricSource']:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @property
    @pulumi.getter
    def resource(self) -> Optional['outputs.ResourceMetricSource']:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class MetricStatus(dict):
    """
    MetricStatus describes the last-read state of a single metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerResource":
            suggest = "container_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 container_resource: Optional['outputs.ContainerResourceMetricStatus'] = None,
                 external: Optional['outputs.ExternalMetricStatus'] = None,
                 object: Optional['outputs.ObjectMetricStatus'] = None,
                 pods: Optional['outputs.PodsMetricStatus'] = None,
                 resource: Optional['outputs.ResourceMetricStatus'] = None):
        """
        MetricStatus describes the last-read state of a single metric.
        :param str type: type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        :param 'ContainerResourceMetricStatusArgs' container_resource: container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param 'ExternalMetricStatusArgs' external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param 'ObjectMetricStatusArgs' object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'PodsMetricStatusArgs' pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param 'ResourceMetricStatusArgs' resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        pulumi.set(__self__, "type", type)
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional['outputs.ContainerResourceMetricStatus']:
        """
        container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "container_resource")

    @property
    @pulumi.getter
    def external(self) -> Optional['outputs.ExternalMetricStatus']:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @property
    @pulumi.getter
    def object(self) -> Optional['outputs.ObjectMetricStatus']:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def pods(self) -> Optional['outputs.PodsMetricStatus']:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @property
    @pulumi.getter
    def resource(self) -> Optional['outputs.ResourceMetricStatus']:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class MetricTarget(dict):
    """
    MetricTarget defines the target value, average value, or average utilization of a specific metric
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "averageUtilization":
            suggest = "average_utilization"
        elif key == "averageValue":
            suggest = "average_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 average_utilization: Optional[int] = None,
                 average_value: Optional[str] = None,
                 value: Optional[str] = None):
        """
        MetricTarget defines the target value, average value, or average utilization of a specific metric
        :param str type: type represents whether the metric type is Utilization, Value, or AverageValue
        :param int average_utilization: averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
        :param str average_value: averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        :param str value: value is the target value of the metric (as a quantity).
        """
        pulumi.set(__self__, "type", type)
        if average_utilization is not None:
            pulumi.set(__self__, "average_utilization", average_utilization)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type represents whether the metric type is Utilization, Value, or AverageValue
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="averageUtilization")
    def average_utilization(self) -> Optional[int]:
        """
        averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
        """
        return pulumi.get(self, "average_utilization")

    @property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[str]:
        """
        averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        value is the target value of the metric (as a quantity).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MetricValueStatus(dict):
    """
    MetricValueStatus holds the current value for a metric
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "averageUtilization":
            suggest = "average_utilization"
        elif key == "averageValue":
            suggest = "average_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricValueStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricValueStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricValueStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 average_utilization: Optional[int] = None,
                 average_value: Optional[str] = None,
                 value: Optional[str] = None):
        """
        MetricValueStatus holds the current value for a metric
        :param int average_utilization: currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        :param str average_value: averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        :param str value: value is the current value of the metric (as a quantity).
        """
        if average_utilization is not None:
            pulumi.set(__self__, "average_utilization", average_utilization)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="averageUtilization")
    def average_utilization(self) -> Optional[int]:
        """
        currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        """
        return pulumi.get(self, "average_utilization")

    @property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[str]:
        """
        averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        value is the current value of the metric (as a quantity).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ObjectMetricSource(dict):
    """
    ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "describedObject":
            suggest = "described_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectMetricSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectMetricSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectMetricSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 described_object: 'outputs.CrossVersionObjectReference',
                 metric: 'outputs.MetricIdentifier',
                 target: 'outputs.MetricTarget'):
        """
        ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        :param 'MetricTargetArgs' target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "described_object", described_object)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="describedObject")
    def described_object(self) -> 'outputs.CrossVersionObjectReference':
        return pulumi.get(self, "described_object")

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def target(self) -> 'outputs.MetricTarget':
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ObjectMetricStatus(dict):
    """
    ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "describedObject":
            suggest = "described_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectMetricStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectMetricStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectMetricStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current: 'outputs.MetricValueStatus',
                 described_object: 'outputs.CrossVersionObjectReference',
                 metric: 'outputs.MetricIdentifier'):
        """
        ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'MetricValueStatusArgs' current: current contains the current value for the given metric
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "described_object", described_object)
        pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter
    def current(self) -> 'outputs.MetricValueStatus':
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @property
    @pulumi.getter(name="describedObject")
    def described_object(self) -> 'outputs.CrossVersionObjectReference':
        return pulumi.get(self, "described_object")

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class PodsMetricSource(dict):
    """
    PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
    """
    def __init__(__self__, *,
                 metric: 'outputs.MetricIdentifier',
                 target: 'outputs.MetricTarget'):
        """
        PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        :param 'MetricTargetArgs' target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def target(self) -> 'outputs.MetricTarget':
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class PodsMetricStatus(dict):
    """
    PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
    """
    def __init__(__self__, *,
                 current: 'outputs.MetricValueStatus',
                 metric: 'outputs.MetricIdentifier'):
        """
        PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
        :param 'MetricValueStatusArgs' current: current contains the current value for the given metric
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter
    def current(self) -> 'outputs.MetricValueStatus':
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class ResourceMetricSource(dict):
    """
    ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
    """
    def __init__(__self__, *,
                 name: str,
                 target: 'outputs.MetricTarget'):
        """
        ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param str name: name is the name of the resource in question.
        :param 'MetricTargetArgs' target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def target(self) -> 'outputs.MetricTarget':
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ResourceMetricStatus(dict):
    """
    ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
    """
    def __init__(__self__, *,
                 current: 'outputs.MetricValueStatus',
                 name: str):
        """
        ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param 'MetricValueStatusArgs' current: current contains the current value for the given metric
        :param str name: Name is the name of the resource in question.
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def current(self) -> 'outputs.MetricValueStatus':
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is the name of the resource in question.
        """
        return pulumi.get(self, "name")


