# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ... import meta as _meta
from ._enums import *

__all__ = [
    'AWSElasticBlockStoreVolumeSourceArgs',
    'AffinityArgs',
    'AttachedVolumeArgs',
    'AzureDiskVolumeSourceArgs',
    'AzureFilePersistentVolumeSourceArgs',
    'AzureFileVolumeSourceArgs',
    'CSIPersistentVolumeSourceArgs',
    'CSIVolumeSourceArgs',
    'CapabilitiesArgs',
    'CephFSPersistentVolumeSourceArgs',
    'CephFSVolumeSourceArgs',
    'CinderPersistentVolumeSourceArgs',
    'CinderVolumeSourceArgs',
    'ClientIPConfigArgs',
    'ConfigMapArgs',
    'ConfigMapEnvSourceArgs',
    'ConfigMapKeySelectorArgs',
    'ConfigMapNodeConfigSourceArgs',
    'ConfigMapProjectionArgs',
    'ConfigMapVolumeSourceArgs',
    'ContainerArgs',
    'ContainerImageArgs',
    'ContainerPortArgs',
    'ContainerStateArgs',
    'ContainerStateRunningArgs',
    'ContainerStateTerminatedArgs',
    'ContainerStateWaitingArgs',
    'ContainerStatusArgs',
    'DaemonEndpointArgs',
    'DownwardAPIProjectionArgs',
    'DownwardAPIVolumeFileArgs',
    'DownwardAPIVolumeSourceArgs',
    'EmptyDirVolumeSourceArgs',
    'EndpointAddressArgs',
    'EndpointPortArgs',
    'EndpointSubsetArgs',
    'EndpointsArgs',
    'EnvFromSourceArgs',
    'EnvVarArgs',
    'EnvVarSourceArgs',
    'EphemeralContainerArgs',
    'EphemeralVolumeSourceArgs',
    'EventArgs',
    'EventSeriesArgs',
    'EventSourceArgs',
    'ExecActionArgs',
    'FCVolumeSourceArgs',
    'FlexPersistentVolumeSourceArgs',
    'FlexVolumeSourceArgs',
    'FlockerVolumeSourceArgs',
    'GCEPersistentDiskVolumeSourceArgs',
    'GitRepoVolumeSourceArgs',
    'GlusterfsPersistentVolumeSourceArgs',
    'GlusterfsVolumeSourceArgs',
    'HTTPGetActionArgs',
    'HTTPHeaderArgs',
    'HandlerArgs',
    'HostAliasArgs',
    'HostPathVolumeSourceArgs',
    'ISCSIPersistentVolumeSourceArgs',
    'ISCSIVolumeSourceArgs',
    'KeyToPathArgs',
    'LifecycleArgs',
    'LimitRangeArgs',
    'LimitRangeItemArgs',
    'LimitRangeSpecArgs',
    'LoadBalancerIngressArgs',
    'LoadBalancerStatusArgs',
    'LocalObjectReferenceArgs',
    'LocalVolumeSourceArgs',
    'NFSVolumeSourceArgs',
    'NamespaceArgs',
    'NamespaceConditionArgs',
    'NamespaceSpecArgs',
    'NamespaceStatusArgs',
    'NodeArgs',
    'NodeAddressArgs',
    'NodeAffinityArgs',
    'NodeConditionArgs',
    'NodeConfigSourceArgs',
    'NodeConfigStatusArgs',
    'NodeDaemonEndpointsArgs',
    'NodeSelectorArgs',
    'NodeSelectorRequirementArgs',
    'NodeSelectorTermArgs',
    'NodeSpecArgs',
    'NodeStatusArgs',
    'NodeSystemInfoArgs',
    'ObjectFieldSelectorArgs',
    'ObjectReferenceArgs',
    'PersistentVolumeArgs',
    'PersistentVolumeClaimArgs',
    'PersistentVolumeClaimConditionArgs',
    'PersistentVolumeClaimSpecArgs',
    'PersistentVolumeClaimStatusArgs',
    'PersistentVolumeClaimTemplateArgs',
    'PersistentVolumeClaimVolumeSourceArgs',
    'PersistentVolumeSpecArgs',
    'PersistentVolumeStatusArgs',
    'PhotonPersistentDiskVolumeSourceArgs',
    'PodArgs',
    'PodAffinityArgs',
    'PodAffinityTermArgs',
    'PodAntiAffinityArgs',
    'PodConditionArgs',
    'PodDNSConfigArgs',
    'PodDNSConfigOptionArgs',
    'PodIPArgs',
    'PodReadinessGateArgs',
    'PodSecurityContextArgs',
    'PodSpecArgs',
    'PodStatusArgs',
    'PodTemplateArgs',
    'PodTemplateSpecArgs',
    'PortStatusArgs',
    'PortworxVolumeSourceArgs',
    'PreferredSchedulingTermArgs',
    'ProbeArgs',
    'ProjectedVolumeSourceArgs',
    'QuobyteVolumeSourceArgs',
    'RBDPersistentVolumeSourceArgs',
    'RBDVolumeSourceArgs',
    'ReplicationControllerArgs',
    'ReplicationControllerConditionArgs',
    'ReplicationControllerSpecArgs',
    'ReplicationControllerStatusArgs',
    'ResourceFieldSelectorArgs',
    'ResourceQuotaArgs',
    'ResourceQuotaSpecArgs',
    'ResourceQuotaStatusArgs',
    'ResourceRequirementsArgs',
    'SELinuxOptionsArgs',
    'ScaleIOPersistentVolumeSourceArgs',
    'ScaleIOVolumeSourceArgs',
    'ScopeSelectorArgs',
    'ScopedResourceSelectorRequirementArgs',
    'SeccompProfileArgs',
    'SecretArgs',
    'SecretEnvSourceArgs',
    'SecretKeySelectorArgs',
    'SecretProjectionArgs',
    'SecretReferenceArgs',
    'SecretVolumeSourceArgs',
    'SecurityContextArgs',
    'ServiceArgs',
    'ServiceAccountArgs',
    'ServiceAccountTokenProjectionArgs',
    'ServicePortArgs',
    'ServiceSpecArgs',
    'ServiceStatusArgs',
    'SessionAffinityConfigArgs',
    'StorageOSPersistentVolumeSourceArgs',
    'StorageOSVolumeSourceArgs',
    'SysctlArgs',
    'TCPSocketActionArgs',
    'TaintArgs',
    'TolerationArgs',
    'TopologySelectorLabelRequirementArgs',
    'TopologySelectorTermArgs',
    'TopologySpreadConstraintArgs',
    'TypedLocalObjectReferenceArgs',
    'VolumeArgs',
    'VolumeDeviceArgs',
    'VolumeMountArgs',
    'VolumeNodeAffinityArgs',
    'VolumeProjectionArgs',
    'VsphereVirtualDiskVolumeSourceArgs',
    'WeightedPodAffinityTermArgs',
    'WindowsSecurityContextOptionsArgs',
]

@pulumi.input_type
class AWSElasticBlockStoreVolumeSourceArgs:
    def __init__(__self__, *,
                 volume_id: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 partition: Optional[pulumi.Input[int]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        Represents a Persistent Disk resource in AWS.

        An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[str] volume_id: Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param pulumi.Input[str] fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param pulumi.Input[int] partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
        :param pulumi.Input[bool] read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". If omitted, the default is "false". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        pulumi.set(__self__, "volume_id", volume_id)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="volumeID")
    def volume_id(self) -> pulumi.Input[str]:
        """
        Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[int]]:
        """
        The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". If omitted, the default is "false". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class AffinityArgs:
    def __init__(__self__, *,
                 node_affinity: Optional[pulumi.Input['NodeAffinityArgs']] = None,
                 pod_affinity: Optional[pulumi.Input['PodAffinityArgs']] = None,
                 pod_anti_affinity: Optional[pulumi.Input['PodAntiAffinityArgs']] = None):
        """
        Affinity is a group of affinity scheduling rules.
        :param pulumi.Input['NodeAffinityArgs'] node_affinity: Describes node affinity scheduling rules for the pod.
        :param pulumi.Input['PodAffinityArgs'] pod_affinity: Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
        :param pulumi.Input['PodAntiAffinityArgs'] pod_anti_affinity: Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
        """
        if node_affinity is not None:
            pulumi.set(__self__, "node_affinity", node_affinity)
        if pod_affinity is not None:
            pulumi.set(__self__, "pod_affinity", pod_affinity)
        if pod_anti_affinity is not None:
            pulumi.set(__self__, "pod_anti_affinity", pod_anti_affinity)

    @property
    @pulumi.getter(name="nodeAffinity")
    def node_affinity(self) -> Optional[pulumi.Input['NodeAffinityArgs']]:
        """
        Describes node affinity scheduling rules for the pod.
        """
        return pulumi.get(self, "node_affinity")

    @node_affinity.setter
    def node_affinity(self, value: Optional[pulumi.Input['NodeAffinityArgs']]):
        pulumi.set(self, "node_affinity", value)

    @property
    @pulumi.getter(name="podAffinity")
    def pod_affinity(self) -> Optional[pulumi.Input['PodAffinityArgs']]:
        """
        Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
        """
        return pulumi.get(self, "pod_affinity")

    @pod_affinity.setter
    def pod_affinity(self, value: Optional[pulumi.Input['PodAffinityArgs']]):
        pulumi.set(self, "pod_affinity", value)

    @property
    @pulumi.getter(name="podAntiAffinity")
    def pod_anti_affinity(self) -> Optional[pulumi.Input['PodAntiAffinityArgs']]:
        """
        Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
        """
        return pulumi.get(self, "pod_anti_affinity")

    @pod_anti_affinity.setter
    def pod_anti_affinity(self, value: Optional[pulumi.Input['PodAntiAffinityArgs']]):
        pulumi.set(self, "pod_anti_affinity", value)


@pulumi.input_type
class AttachedVolumeArgs:
    def __init__(__self__, *,
                 device_path: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        AttachedVolume describes a volume attached to a node
        :param pulumi.Input[str] device_path: DevicePath represents the device path where the volume should be available
        :param pulumi.Input[str] name: Name of the attached volume
        """
        pulumi.set(__self__, "device_path", device_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> pulumi.Input[str]:
        """
        DevicePath represents the device path where the volume should be available
        """
        return pulumi.get(self, "device_path")

    @device_path.setter
    def device_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the attached volume
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AzureDiskVolumeSourceArgs:
    def __init__(__self__, *,
                 disk_name: pulumi.Input[str],
                 disk_uri: pulumi.Input[str],
                 caching_mode: Optional[pulumi.Input[str]] = None,
                 fs_type: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
        :param pulumi.Input[str] disk_name: The Name of the data disk in the blob storage
        :param pulumi.Input[str] disk_uri: The URI the data disk in the blob storage
        :param pulumi.Input[str] caching_mode: Host Caching mode: None, Read Only, Read Write.
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param pulumi.Input[str] kind: Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
        :param pulumi.Input[bool] read_only: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "disk_uri", disk_uri)
        if caching_mode is not None:
            pulumi.set(__self__, "caching_mode", caching_mode)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> pulumi.Input[str]:
        """
        The Name of the data disk in the blob storage
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "disk_name", value)

    @property
    @pulumi.getter(name="diskURI")
    def disk_uri(self) -> pulumi.Input[str]:
        """
        The URI the data disk in the blob storage
        """
        return pulumi.get(self, "disk_uri")

    @disk_uri.setter
    def disk_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "disk_uri", value)

    @property
    @pulumi.getter(name="cachingMode")
    def caching_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Host Caching mode: None, Read Only, Read Write.
        """
        return pulumi.get(self, "caching_mode")

    @caching_mode.setter
    def caching_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "caching_mode", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class AzureFilePersistentVolumeSourceArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[str],
                 share_name: pulumi.Input[str],
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_namespace: Optional[pulumi.Input[str]] = None):
        """
        AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
        :param pulumi.Input[str] secret_name: the name of secret that contains Azure Storage Account Name and Key
        :param pulumi.Input[str] share_name: Share Name
        :param pulumi.Input[bool] read_only: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param pulumi.Input[str] secret_namespace: the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "share_name", share_name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_namespace is not None:
            pulumi.set(__self__, "secret_namespace", secret_namespace)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[str]:
        """
        the name of secret that contains Azure Storage Account Name and Key
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Input[str]:
        """
        Share Name
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretNamespace")
    def secret_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod
        """
        return pulumi.get(self, "secret_namespace")

    @secret_namespace.setter
    def secret_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_namespace", value)


@pulumi.input_type
class AzureFileVolumeSourceArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[str],
                 share_name: pulumi.Input[str],
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
        :param pulumi.Input[str] secret_name: the name of secret that contains Azure Storage Account Name and Key
        :param pulumi.Input[str] share_name: Share Name
        :param pulumi.Input[bool] read_only: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "share_name", share_name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[str]:
        """
        the name of secret that contains Azure Storage Account Name and Key
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Input[str]:
        """
        Share Name
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class CSIPersistentVolumeSourceArgs:
    def __init__(__self__, *,
                 driver: pulumi.Input[str],
                 volume_handle: pulumi.Input[str],
                 controller_expand_secret_ref: Optional[pulumi.Input['SecretReferenceArgs']] = None,
                 controller_publish_secret_ref: Optional[pulumi.Input['SecretReferenceArgs']] = None,
                 fs_type: Optional[pulumi.Input[str]] = None,
                 node_publish_secret_ref: Optional[pulumi.Input['SecretReferenceArgs']] = None,
                 node_stage_secret_ref: Optional[pulumi.Input['SecretReferenceArgs']] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 volume_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Represents storage that is managed by an external CSI volume driver (Beta feature)
        :param pulumi.Input[str] driver: Driver is the name of the driver to use for this volume. Required.
        :param pulumi.Input[str] volume_handle: VolumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
        :param pulumi.Input['SecretReferenceArgs'] controller_expand_secret_ref: ControllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This is an alpha field and requires enabling ExpandCSIVolumes feature gate. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param pulumi.Input['SecretReferenceArgs'] controller_publish_secret_ref: ControllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
        :param pulumi.Input['SecretReferenceArgs'] node_publish_secret_ref: NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param pulumi.Input['SecretReferenceArgs'] node_stage_secret_ref: NodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param pulumi.Input[bool] read_only: Optional: The value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] volume_attributes: Attributes of the volume to publish.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "volume_handle", volume_handle)
        if controller_expand_secret_ref is not None:
            pulumi.set(__self__, "controller_expand_secret_ref", controller_expand_secret_ref)
        if controller_publish_secret_ref is not None:
            pulumi.set(__self__, "controller_publish_secret_ref", controller_publish_secret_ref)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if node_publish_secret_ref is not None:
            pulumi.set(__self__, "node_publish_secret_ref", node_publish_secret_ref)
        if node_stage_secret_ref is not None:
            pulumi.set(__self__, "node_stage_secret_ref", node_stage_secret_ref)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_attributes is not None:
            pulumi.set(__self__, "volume_attributes", volume_attributes)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[str]:
        """
        Driver is the name of the driver to use for this volume. Required.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter(name="volumeHandle")
    def volume_handle(self) -> pulumi.Input[str]:
        """
        VolumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
        """
        return pulumi.get(self, "volume_handle")

    @volume_handle.setter
    def volume_handle(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_handle", value)

    @property
    @pulumi.getter(name="controllerExpandSecretRef")
    def controller_expand_secret_ref(self) -> Optional[pulumi.Input['SecretReferenceArgs']]:
        """
        ControllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This is an alpha field and requires enabling ExpandCSIVolumes feature gate. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "controller_expand_secret_ref")

    @controller_expand_secret_ref.setter
    def controller_expand_secret_ref(self, value: Optional[pulumi.Input['SecretReferenceArgs']]):
        pulumi.set(self, "controller_expand_secret_ref", value)

    @property
    @pulumi.getter(name="controllerPublishSecretRef")
    def controller_publish_secret_ref(self) -> Optional[pulumi.Input['SecretReferenceArgs']]:
        """
        ControllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "controller_publish_secret_ref")

    @controller_publish_secret_ref.setter
    def controller_publish_secret_ref(self, value: Optional[pulumi.Input['SecretReferenceArgs']]):
        pulumi.set(self, "controller_publish_secret_ref", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="nodePublishSecretRef")
    def node_publish_secret_ref(self) -> Optional[pulumi.Input['SecretReferenceArgs']]:
        """
        NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "node_publish_secret_ref")

    @node_publish_secret_ref.setter
    def node_publish_secret_ref(self, value: Optional[pulumi.Input['SecretReferenceArgs']]):
        pulumi.set(self, "node_publish_secret_ref", value)

    @property
    @pulumi.getter(name="nodeStageSecretRef")
    def node_stage_secret_ref(self) -> Optional[pulumi.Input['SecretReferenceArgs']]:
        """
        NodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "node_stage_secret_ref")

    @node_stage_secret_ref.setter
    def node_stage_secret_ref(self, value: Optional[pulumi.Input['SecretReferenceArgs']]):
        pulumi.set(self, "node_stage_secret_ref", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional: The value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="volumeAttributes")
    def volume_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Attributes of the volume to publish.
        """
        return pulumi.get(self, "volume_attributes")

    @volume_attributes.setter
    def volume_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "volume_attributes", value)


@pulumi.input_type
class CSIVolumeSourceArgs:
    def __init__(__self__, *,
                 driver: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 node_publish_secret_ref: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 volume_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Represents a source location of a volume to mount, managed by an external CSI driver
        :param pulumi.Input[str] driver: Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
        :param pulumi.Input['LocalObjectReferenceArgs'] node_publish_secret_ref: NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
        :param pulumi.Input[bool] read_only: Specifies a read-only configuration for the volume. Defaults to false (read/write).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] volume_attributes: VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.
        """
        pulumi.set(__self__, "driver", driver)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if node_publish_secret_ref is not None:
            pulumi.set(__self__, "node_publish_secret_ref", node_publish_secret_ref)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_attributes is not None:
            pulumi.set(__self__, "volume_attributes", volume_attributes)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[str]:
        """
        Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="nodePublishSecretRef")
    def node_publish_secret_ref(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
        """
        return pulumi.get(self, "node_publish_secret_ref")

    @node_publish_secret_ref.setter
    def node_publish_secret_ref(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "node_publish_secret_ref", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies a read-only configuration for the volume. Defaults to false (read/write).
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="volumeAttributes")
    def volume_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.
        """
        return pulumi.get(self, "volume_attributes")

    @volume_attributes.setter
    def volume_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "volume_attributes", value)


@pulumi.input_type
class CapabilitiesArgs:
    def __init__(__self__, *,
                 add: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 drop: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Adds and removes POSIX capabilities from running containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] add: Added capabilities
        :param pulumi.Input[Sequence[pulumi.Input[str]]] drop: Removed capabilities
        """
        if add is not None:
            pulumi.set(__self__, "add", add)
        if drop is not None:
            pulumi.set(__self__, "drop", drop)

    @property
    @pulumi.getter
    def add(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Added capabilities
        """
        return pulumi.get(self, "add")

    @add.setter
    def add(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "add", value)

    @property
    @pulumi.getter
    def drop(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Removed capabilities
        """
        return pulumi.get(self, "drop")

    @drop.setter
    def drop(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "drop", value)


@pulumi.input_type
class CephFSPersistentVolumeSourceArgs:
    def __init__(__self__, *,
                 monitors: pulumi.Input[Sequence[pulumi.Input[str]]],
                 path: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_file: Optional[pulumi.Input[str]] = None,
                 secret_ref: Optional[pulumi.Input['SecretReferenceArgs']] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitors: Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param pulumi.Input[str] path: Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        :param pulumi.Input[bool] read_only: Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param pulumi.Input[str] secret_file: Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param pulumi.Input['SecretReferenceArgs'] secret_ref: Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param pulumi.Input[str] user: Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        pulumi.set(__self__, "monitors", monitors)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_file is not None:
            pulumi.set(__self__, "secret_file", secret_file)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def monitors(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "monitors")

    @monitors.setter
    def monitors(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "monitors", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretFile")
    def secret_file(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_file")

    @secret_file.setter
    def secret_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_file", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['SecretReferenceArgs']]:
        """
        Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['SecretReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class CephFSVolumeSourceArgs:
    def __init__(__self__, *,
                 monitors: pulumi.Input[Sequence[pulumi.Input[str]]],
                 path: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_file: Optional[pulumi.Input[str]] = None,
                 secret_ref: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitors: Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param pulumi.Input[str] path: Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        :param pulumi.Input[bool] read_only: Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param pulumi.Input[str] secret_file: Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param pulumi.Input['LocalObjectReferenceArgs'] secret_ref: Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param pulumi.Input[str] user: Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        pulumi.set(__self__, "monitors", monitors)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_file is not None:
            pulumi.set(__self__, "secret_file", secret_file)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def monitors(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "monitors")

    @monitors.setter
    def monitors(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "monitors", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretFile")
    def secret_file(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_file")

    @secret_file.setter
    def secret_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_file", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class CinderPersistentVolumeSourceArgs:
    def __init__(__self__, *,
                 volume_id: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_ref: Optional[pulumi.Input['SecretReferenceArgs']] = None):
        """
        Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[str] volume_id: volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param pulumi.Input[bool] read_only: Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param pulumi.Input['SecretReferenceArgs'] secret_ref: Optional: points to a secret object containing parameters used to connect to OpenStack.
        """
        pulumi.set(__self__, "volume_id", volume_id)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter(name="volumeID")
    def volume_id(self) -> pulumi.Input[str]:
        """
        volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['SecretReferenceArgs']]:
        """
        Optional: points to a secret object containing parameters used to connect to OpenStack.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['SecretReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)


@pulumi.input_type
class CinderVolumeSourceArgs:
    def __init__(__self__, *,
                 volume_id: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_ref: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None):
        """
        Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[str] volume_id: volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param pulumi.Input[bool] read_only: Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param pulumi.Input['LocalObjectReferenceArgs'] secret_ref: Optional: points to a secret object containing parameters used to connect to OpenStack.
        """
        pulumi.set(__self__, "volume_id", volume_id)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter(name="volumeID")
    def volume_id(self) -> pulumi.Input[str]:
        """
        volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        Optional: points to a secret object containing parameters used to connect to OpenStack.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)


@pulumi.input_type
class ClientIPConfigArgs:
    def __init__(__self__, *,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        ClientIPConfig represents the configurations of Client IP based session affinity.
        :param pulumi.Input[int] timeout_seconds: timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).
        """
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class ConfigMapArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 binary_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 immutable: Optional[pulumi.Input[bool]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        ConfigMap holds configuration data for pods to consume.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param pulumi.Input[bool] immutable: Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if binary_data is not None:
            pulumi.set(__self__, "binary_data", binary_data)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if immutable is not None:
            pulumi.set(__self__, "immutable", immutable)
        if kind is not None:
            pulumi.set(__self__, "kind", 'ConfigMap')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter(name="binaryData")
    def binary_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        """
        return pulumi.get(self, "binary_data")

    @binary_data.setter
    def binary_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "binary_data", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def immutable(self) -> Optional[pulumi.Input[bool]]:
        """
        Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        """
        return pulumi.get(self, "immutable")

    @immutable.setter
    def immutable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "immutable", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class ConfigMapEnvSourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

        The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
        :param pulumi.Input[str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[bool] optional: Specify whether the ConfigMap must be defined
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the ConfigMap must be defined
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class ConfigMapKeySelectorArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        Selects a key from a ConfigMap.
        :param pulumi.Input[str] key: The key to select.
        :param pulumi.Input[str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[bool] optional: Specify whether the ConfigMap or its key must be defined
        """
        pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key to select.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the ConfigMap or its key must be defined
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class ConfigMapNodeConfigSourceArgs:
    def __init__(__self__, *,
                 kubelet_config_key: pulumi.Input[str],
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 resource_version: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.
        :param pulumi.Input[str] kubelet_config_key: KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
        :param pulumi.Input[str] name: Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
        :param pulumi.Input[str] namespace: Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
        :param pulumi.Input[str] resource_version: ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        :param pulumi.Input[str] uid: UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        """
        pulumi.set(__self__, "kubelet_config_key", kubelet_config_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="kubeletConfigKey")
    def kubelet_config_key(self) -> pulumi.Input[str]:
        """
        KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
        """
        return pulumi.get(self, "kubelet_config_key")

    @kubelet_config_key.setter
    def kubelet_config_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "kubelet_config_key", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[str]]:
        """
        ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ConfigMapProjectionArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        Adapts a ConfigMap into a projected volume.

        The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.
        :param pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]] items: If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param pulumi.Input[str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[bool] optional: Specify whether the ConfigMap or its keys must be defined
        """
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]:
        """
        If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the ConfigMap or its keys must be defined
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class ConfigMapVolumeSourceArgs:
    def __init__(__self__, *,
                 default_mode: Optional[pulumi.Input[int]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        Adapts a ConfigMap into a volume.

        The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[int] default_mode: Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]] items: If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param pulumi.Input[str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[bool] optional: Specify whether the ConfigMap or its keys must be defined
        """
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @default_mode.setter
    def default_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_mode", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]:
        """
        If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the ConfigMap or its keys must be defined
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class ContainerArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]]] = None,
                 env_from: Optional[pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 image_pull_policy: Optional[pulumi.Input[str]] = None,
                 lifecycle: Optional[pulumi.Input['LifecycleArgs']] = None,
                 liveness_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]] = None,
                 readiness_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 resources: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 security_context: Optional[pulumi.Input['SecurityContextArgs']] = None,
                 startup_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 stdin: Optional[pulumi.Input[bool]] = None,
                 stdin_once: Optional[pulumi.Input[bool]] = None,
                 termination_message_path: Optional[pulumi.Input[str]] = None,
                 termination_message_policy: Optional[pulumi.Input[str]] = None,
                 tty: Optional[pulumi.Input[bool]] = None,
                 volume_devices: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        A single application container that you want to run within a pod.
        :param pulumi.Input[str] name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]] env: List of environment variables to set in the container. Cannot be updated.
        :param pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]] env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param pulumi.Input[str] image: Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        :param pulumi.Input[str] image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param pulumi.Input['LifecycleArgs'] lifecycle: Actions that the management system should take in response to container lifecycle events. Cannot be updated.
        :param pulumi.Input['ProbeArgs'] liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]] ports: List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated.
        :param pulumi.Input['ProbeArgs'] readiness_probe: Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input['ResourceRequirementsArgs'] resources: Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        :param pulumi.Input['SecurityContextArgs'] security_context: Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        :param pulumi.Input['ProbeArgs'] startup_probe: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input[bool] stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        :param pulumi.Input[bool] stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        :param pulumi.Input[str] termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        :param pulumi.Input[str] termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        :param pulumi.Input[bool] tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]] volume_devices: volumeDevices is the list of block devices to be used by the container.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]] volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param pulumi.Input[str] working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if env_from is not None:
            pulumi.set(__self__, "env_from", env_from)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if stdin is not None:
            pulumi.set(__self__, "stdin", stdin)
        if stdin_once is not None:
            pulumi.set(__self__, "stdin_once", stdin_once)
        if termination_message_path is not None:
            pulumi.set(__self__, "termination_message_path", termination_message_path)
        if termination_message_policy is not None:
            pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        if tty is not None:
            pulumi.set(__self__, "tty", tty)
        if volume_devices is not None:
            pulumi.set(__self__, "volume_devices", volume_devices)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]]]:
        """
        List of environment variables to set in the container. Cannot be updated.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]]]:
        """
        List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        """
        return pulumi.get(self, "env_from")

    @env_from.setter
    def env_from(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]]]):
        pulumi.set(self, "env_from", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional[pulumi.Input['LifecycleArgs']]:
        """
        Actions that the management system should take in response to container lifecycle events. Cannot be updated.
        """
        return pulumi.get(self, "lifecycle")

    @lifecycle.setter
    def lifecycle(self, value: Optional[pulumi.Input['LifecycleArgs']]):
        pulumi.set(self, "lifecycle", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]]:
        """
        List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "readiness_probe")

    @readiness_probe.setter
    def readiness_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "readiness_probe", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['SecurityContextArgs']]:
        """
        Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['SecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "startup_probe")

    @startup_probe.setter
    def startup_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "startup_probe", value)

    @property
    @pulumi.getter
    def stdin(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        """
        return pulumi.get(self, "stdin")

    @stdin.setter
    def stdin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stdin", value)

    @property
    @pulumi.getter(name="stdinOnce")
    def stdin_once(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        """
        return pulumi.get(self, "stdin_once")

    @stdin_once.setter
    def stdin_once(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stdin_once", value)

    @property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_path")

    @termination_message_path.setter
    def termination_message_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "termination_message_path", value)

    @property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_policy")

    @termination_message_policy.setter
    def termination_message_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "termination_message_policy", value)

    @property
    @pulumi.getter
    def tty(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        """
        return pulumi.get(self, "tty")

    @tty.setter
    def tty(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tty", value)

    @property
    @pulumi.getter(name="volumeDevices")
    def volume_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]]]:
        """
        volumeDevices is the list of block devices to be used by the container.
        """
        return pulumi.get(self, "volume_devices")

    @volume_devices.setter
    def volume_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]]]):
        pulumi.set(self, "volume_devices", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]]:
        """
        Pod volumes to mount into the container's filesystem. Cannot be updated.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class ContainerImageArgs:
    def __init__(__self__, *,
                 names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 size_bytes: Optional[pulumi.Input[int]] = None):
        """
        Describe a container image
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: Names by which this image is known. e.g. ["k8s.gcr.io/hyperkube:v1.0.7", "dockerhub.io/google_containers/hyperkube:v1.0.7"]
        :param pulumi.Input[int] size_bytes: The size of the image in bytes.
        """
        pulumi.set(__self__, "names", names)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)

    @property
    @pulumi.getter
    def names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Names by which this image is known. e.g. ["k8s.gcr.io/hyperkube:v1.0.7", "dockerhub.io/google_containers/hyperkube:v1.0.7"]
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the image in bytes.
        """
        return pulumi.get(self, "size_bytes")

    @size_bytes.setter
    def size_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_bytes", value)


@pulumi.input_type
class ContainerPortArgs:
    def __init__(__self__, *,
                 container_port: pulumi.Input[int],
                 host_ip: Optional[pulumi.Input[str]] = None,
                 host_port: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        ContainerPort represents a network port in a single container.
        :param pulumi.Input[int] container_port: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param pulumi.Input[str] host_ip: What host IP to bind the external port to.
        :param pulumi.Input[int] host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
        :param pulumi.Input[str] name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
        :param pulumi.Input[str] protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
        """
        pulumi.set(__self__, "container_port", container_port)
        if host_ip is not None:
            pulumi.set(__self__, "host_ip", host_ip)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> pulumi.Input[int]:
        """
        Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        """
        return pulumi.get(self, "container_port")

    @container_port.setter
    def container_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "container_port", value)

    @property
    @pulumi.getter(name="hostIP")
    def host_ip(self) -> Optional[pulumi.Input[str]]:
        """
        What host IP to bind the external port to.
        """
        return pulumi.get(self, "host_ip")

    @host_ip.setter
    def host_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_ip", value)

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[pulumi.Input[int]]:
        """
        Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
        """
        return pulumi.get(self, "host_port")

    @host_port.setter
    def host_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "host_port", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class ContainerStateArgs:
    def __init__(__self__, *,
                 running: Optional[pulumi.Input['ContainerStateRunningArgs']] = None,
                 terminated: Optional[pulumi.Input['ContainerStateTerminatedArgs']] = None,
                 waiting: Optional[pulumi.Input['ContainerStateWaitingArgs']] = None):
        """
        ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.
        :param pulumi.Input['ContainerStateRunningArgs'] running: Details about a running container
        :param pulumi.Input['ContainerStateTerminatedArgs'] terminated: Details about a terminated container
        :param pulumi.Input['ContainerStateWaitingArgs'] waiting: Details about a waiting container
        """
        if running is not None:
            pulumi.set(__self__, "running", running)
        if terminated is not None:
            pulumi.set(__self__, "terminated", terminated)
        if waiting is not None:
            pulumi.set(__self__, "waiting", waiting)

    @property
    @pulumi.getter
    def running(self) -> Optional[pulumi.Input['ContainerStateRunningArgs']]:
        """
        Details about a running container
        """
        return pulumi.get(self, "running")

    @running.setter
    def running(self, value: Optional[pulumi.Input['ContainerStateRunningArgs']]):
        pulumi.set(self, "running", value)

    @property
    @pulumi.getter
    def terminated(self) -> Optional[pulumi.Input['ContainerStateTerminatedArgs']]:
        """
        Details about a terminated container
        """
        return pulumi.get(self, "terminated")

    @terminated.setter
    def terminated(self, value: Optional[pulumi.Input['ContainerStateTerminatedArgs']]):
        pulumi.set(self, "terminated", value)

    @property
    @pulumi.getter
    def waiting(self) -> Optional[pulumi.Input['ContainerStateWaitingArgs']]:
        """
        Details about a waiting container
        """
        return pulumi.get(self, "waiting")

    @waiting.setter
    def waiting(self, value: Optional[pulumi.Input['ContainerStateWaitingArgs']]):
        pulumi.set(self, "waiting", value)


@pulumi.input_type
class ContainerStateRunningArgs:
    def __init__(__self__, *,
                 started_at: Optional[pulumi.Input[str]] = None):
        """
        ContainerStateRunning is a running state of a container.
        :param pulumi.Input[str] started_at: Time at which the container was last (re-)started
        """
        if started_at is not None:
            pulumi.set(__self__, "started_at", started_at)

    @property
    @pulumi.getter(name="startedAt")
    def started_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the container was last (re-)started
        """
        return pulumi.get(self, "started_at")

    @started_at.setter
    def started_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "started_at", value)


@pulumi.input_type
class ContainerStateTerminatedArgs:
    def __init__(__self__, *,
                 exit_code: pulumi.Input[int],
                 container_id: Optional[pulumi.Input[str]] = None,
                 finished_at: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 signal: Optional[pulumi.Input[int]] = None,
                 started_at: Optional[pulumi.Input[str]] = None):
        """
        ContainerStateTerminated is a terminated state of a container.
        :param pulumi.Input[int] exit_code: Exit status from the last termination of the container
        :param pulumi.Input[str] container_id: Container's ID in the format 'docker://<container_id>'
        :param pulumi.Input[str] finished_at: Time at which the container last terminated
        :param pulumi.Input[str] message: Message regarding the last termination of the container
        :param pulumi.Input[str] reason: (brief) reason from the last termination of the container
        :param pulumi.Input[int] signal: Signal from the last termination of the container
        :param pulumi.Input[str] started_at: Time at which previous execution of the container started
        """
        pulumi.set(__self__, "exit_code", exit_code)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if finished_at is not None:
            pulumi.set(__self__, "finished_at", finished_at)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if signal is not None:
            pulumi.set(__self__, "signal", signal)
        if started_at is not None:
            pulumi.set(__self__, "started_at", started_at)

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> pulumi.Input[int]:
        """
        Exit status from the last termination of the container
        """
        return pulumi.get(self, "exit_code")

    @exit_code.setter
    def exit_code(self, value: pulumi.Input[int]):
        pulumi.set(self, "exit_code", value)

    @property
    @pulumi.getter(name="containerID")
    def container_id(self) -> Optional[pulumi.Input[str]]:
        """
        Container's ID in the format 'docker://<container_id>'
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_id", value)

    @property
    @pulumi.getter(name="finishedAt")
    def finished_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the container last terminated
        """
        return pulumi.get(self, "finished_at")

    @finished_at.setter
    def finished_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "finished_at", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Message regarding the last termination of the container
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        (brief) reason from the last termination of the container
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def signal(self) -> Optional[pulumi.Input[int]]:
        """
        Signal from the last termination of the container
        """
        return pulumi.get(self, "signal")

    @signal.setter
    def signal(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "signal", value)

    @property
    @pulumi.getter(name="startedAt")
    def started_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which previous execution of the container started
        """
        return pulumi.get(self, "started_at")

    @started_at.setter
    def started_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "started_at", value)


@pulumi.input_type
class ContainerStateWaitingArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        ContainerStateWaiting is a waiting state of a container.
        :param pulumi.Input[str] message: Message regarding why the container is not yet running.
        :param pulumi.Input[str] reason: (brief) reason the container is not yet running.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Message regarding why the container is not yet running.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        (brief) reason the container is not yet running.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class ContainerStatusArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 image_id: pulumi.Input[str],
                 name: pulumi.Input[str],
                 ready: pulumi.Input[bool],
                 restart_count: pulumi.Input[int],
                 container_id: Optional[pulumi.Input[str]] = None,
                 last_state: Optional[pulumi.Input['ContainerStateArgs']] = None,
                 started: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input['ContainerStateArgs']] = None):
        """
        ContainerStatus contains details for the current status of this container.
        :param pulumi.Input[str] image: The image the container is running. More info: https://kubernetes.io/docs/concepts/containers/images
        :param pulumi.Input[str] image_id: ImageID of the container's image.
        :param pulumi.Input[str] name: This must be a DNS_LABEL. Each container in a pod must have a unique name. Cannot be updated.
        :param pulumi.Input[bool] ready: Specifies whether the container has passed its readiness probe.
        :param pulumi.Input[int] restart_count: The number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed. Note that this is calculated from dead containers. But those containers are subject to garbage collection. This value will get capped at 5 by GC.
        :param pulumi.Input[str] container_id: Container's ID in the format 'docker://<container_id>'.
        :param pulumi.Input['ContainerStateArgs'] last_state: Details about the container's last termination condition.
        :param pulumi.Input[bool] started: Specifies whether the container has passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. Is always true when no startupProbe is defined.
        :param pulumi.Input['ContainerStateArgs'] state: Details about the container's current condition.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ready", ready)
        pulumi.set(__self__, "restart_count", restart_count)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if last_state is not None:
            pulumi.set(__self__, "last_state", last_state)
        if started is not None:
            pulumi.set(__self__, "started", started)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        The image the container is running. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="imageID")
    def image_id(self) -> pulumi.Input[str]:
        """
        ImageID of the container's image.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        This must be a DNS_LABEL. Each container in a pod must have a unique name. Cannot be updated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ready(self) -> pulumi.Input[bool]:
        """
        Specifies whether the container has passed its readiness probe.
        """
        return pulumi.get(self, "ready")

    @ready.setter
    def ready(self, value: pulumi.Input[bool]):
        pulumi.set(self, "ready", value)

    @property
    @pulumi.getter(name="restartCount")
    def restart_count(self) -> pulumi.Input[int]:
        """
        The number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed. Note that this is calculated from dead containers. But those containers are subject to garbage collection. This value will get capped at 5 by GC.
        """
        return pulumi.get(self, "restart_count")

    @restart_count.setter
    def restart_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "restart_count", value)

    @property
    @pulumi.getter(name="containerID")
    def container_id(self) -> Optional[pulumi.Input[str]]:
        """
        Container's ID in the format 'docker://<container_id>'.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_id", value)

    @property
    @pulumi.getter(name="lastState")
    def last_state(self) -> Optional[pulumi.Input['ContainerStateArgs']]:
        """
        Details about the container's last termination condition.
        """
        return pulumi.get(self, "last_state")

    @last_state.setter
    def last_state(self, value: Optional[pulumi.Input['ContainerStateArgs']]):
        pulumi.set(self, "last_state", value)

    @property
    @pulumi.getter
    def started(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the container has passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. Is always true when no startupProbe is defined.
        """
        return pulumi.get(self, "started")

    @started.setter
    def started(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "started", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['ContainerStateArgs']]:
        """
        Details about the container's current condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['ContainerStateArgs']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class DaemonEndpointArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int]):
        """
        DaemonEndpoint contains information about a single Daemon endpoint.
        :param pulumi.Input[int] port: Port number of the given endpoint.
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="Port")
    def port(self) -> pulumi.Input[int]:
        """
        Port number of the given endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class DownwardAPIProjectionArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['DownwardAPIVolumeFileArgs']]]] = None):
        """
        Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode.
        :param pulumi.Input[Sequence[pulumi.Input['DownwardAPIVolumeFileArgs']]] items: Items is a list of DownwardAPIVolume file
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DownwardAPIVolumeFileArgs']]]]:
        """
        Items is a list of DownwardAPIVolume file
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DownwardAPIVolumeFileArgs']]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class DownwardAPIVolumeFileArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 field_ref: Optional[pulumi.Input['ObjectFieldSelectorArgs']] = None,
                 mode: Optional[pulumi.Input[int]] = None,
                 resource_field_ref: Optional[pulumi.Input['ResourceFieldSelectorArgs']] = None):
        """
        DownwardAPIVolumeFile represents information to create the file containing the pod field
        :param pulumi.Input[str] path: Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
        :param pulumi.Input['ObjectFieldSelectorArgs'] field_ref: Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
        :param pulumi.Input[int] mode: Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param pulumi.Input['ResourceFieldSelectorArgs'] resource_field_ref: Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
        """
        pulumi.set(__self__, "path", path)
        if field_ref is not None:
            pulumi.set(__self__, "field_ref", field_ref)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if resource_field_ref is not None:
            pulumi.set(__self__, "resource_field_ref", resource_field_ref)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> Optional[pulumi.Input['ObjectFieldSelectorArgs']]:
        """
        Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
        """
        return pulumi.get(self, "field_ref")

    @field_ref.setter
    def field_ref(self, value: Optional[pulumi.Input['ObjectFieldSelectorArgs']]):
        pulumi.set(self, "field_ref", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[int]]:
        """
        Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="resourceFieldRef")
    def resource_field_ref(self) -> Optional[pulumi.Input['ResourceFieldSelectorArgs']]:
        """
        Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
        """
        return pulumi.get(self, "resource_field_ref")

    @resource_field_ref.setter
    def resource_field_ref(self, value: Optional[pulumi.Input['ResourceFieldSelectorArgs']]):
        pulumi.set(self, "resource_field_ref", value)


@pulumi.input_type
class DownwardAPIVolumeSourceArgs:
    def __init__(__self__, *,
                 default_mode: Optional[pulumi.Input[int]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['DownwardAPIVolumeFileArgs']]]] = None):
        """
        DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[int] default_mode: Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param pulumi.Input[Sequence[pulumi.Input['DownwardAPIVolumeFileArgs']]] items: Items is a list of downward API volume file
        """
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @default_mode.setter
    def default_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_mode", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DownwardAPIVolumeFileArgs']]]]:
        """
        Items is a list of downward API volume file
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DownwardAPIVolumeFileArgs']]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class EmptyDirVolumeSourceArgs:
    def __init__(__self__, *,
                 medium: Optional[pulumi.Input[str]] = None,
                 size_limit: Optional[pulumi.Input[str]] = None):
        """
        Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[str] medium: What type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        :param pulumi.Input[str] size_limit: Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @property
    @pulumi.getter
    def medium(self) -> Optional[pulumi.Input[str]]:
        """
        What type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        """
        return pulumi.get(self, "medium")

    @medium.setter
    def medium(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "medium", value)

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[pulumi.Input[str]]:
        """
        Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
        """
        return pulumi.get(self, "size_limit")

    @size_limit.setter
    def size_limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_limit", value)


@pulumi.input_type
class EndpointAddressArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 hostname: Optional[pulumi.Input[str]] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 target_ref: Optional[pulumi.Input['ObjectReferenceArgs']] = None):
        """
        EndpointAddress is a tuple that describes single IP address.
        :param pulumi.Input[str] ip: The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.
        :param pulumi.Input[str] hostname: The Hostname of this endpoint
        :param pulumi.Input[str] node_name: Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
        :param pulumi.Input['ObjectReferenceArgs'] target_ref: Reference to object providing the endpoint.
        """
        pulumi.set(__self__, "ip", ip)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if target_ref is not None:
            pulumi.set(__self__, "target_ref", target_ref)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The Hostname of this endpoint
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter(name="targetRef")
    def target_ref(self) -> Optional[pulumi.Input['ObjectReferenceArgs']]:
        """
        Reference to object providing the endpoint.
        """
        return pulumi.get(self, "target_ref")

    @target_ref.setter
    def target_ref(self, value: Optional[pulumi.Input['ObjectReferenceArgs']]):
        pulumi.set(self, "target_ref", value)


@pulumi.input_type
class EndpointPortArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 app_protocol: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        EndpointPort is a tuple that describes a single port.
        :param pulumi.Input[int] port: The port number of the endpoint.
        :param pulumi.Input[str] app_protocol: The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol. This is a beta field that is guarded by the ServiceAppProtocol feature gate and enabled by default.
        :param pulumi.Input[str] name: The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
        :param pulumi.Input[str] protocol: The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
        """
        pulumi.set(__self__, "port", port)
        if app_protocol is not None:
            pulumi.set(__self__, "app_protocol", app_protocol)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port number of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol. This is a beta field that is guarded by the ServiceAppProtocol feature gate and enabled by default.
        """
        return pulumi.get(self, "app_protocol")

    @app_protocol.setter
    def app_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_protocol", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class EndpointSubsetArgs:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAddressArgs']]]] = None,
                 not_ready_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAddressArgs']]]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPortArgs']]]] = None):
        """
        EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:
          {
            Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
            Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
          }
        The resulting set of endpoints can be viewed as:
            a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
            b: [ 10.10.1.1:309, 10.10.2.2:309 ]
        :param pulumi.Input[Sequence[pulumi.Input['EndpointAddressArgs']]] addresses: IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointAddressArgs']]] not_ready_addresses: IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointPortArgs']]] ports: Port numbers available on the related IP addresses.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if not_ready_addresses is not None:
            pulumi.set(__self__, "not_ready_addresses", not_ready_addresses)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAddressArgs']]]]:
        """
        IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAddressArgs']]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter(name="notReadyAddresses")
    def not_ready_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAddressArgs']]]]:
        """
        IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
        """
        return pulumi.get(self, "not_ready_addresses")

    @not_ready_addresses.setter
    def not_ready_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAddressArgs']]]]):
        pulumi.set(self, "not_ready_addresses", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPortArgs']]]]:
        """
        Port numbers available on the related IP addresses.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPortArgs']]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class EndpointsArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 subsets: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointSubsetArgs']]]] = None):
        """
        Endpoints is a collection of endpoints that implement the actual service. Example:
          Name: "mysvc",
          Subsets: [
            {
              Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
              Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
            },
            {
              Addresses: [{"ip": "10.10.3.3"}],
              Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
            },
         ]
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input['EndpointSubsetArgs']]] subsets: The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Endpoints')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if subsets is not None:
            pulumi.set(__self__, "subsets", subsets)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def subsets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointSubsetArgs']]]]:
        """
        The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
        """
        return pulumi.get(self, "subsets")

    @subsets.setter
    def subsets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointSubsetArgs']]]]):
        pulumi.set(self, "subsets", value)


@pulumi.input_type
class EnvFromSourceArgs:
    def __init__(__self__, *,
                 config_map_ref: Optional[pulumi.Input['ConfigMapEnvSourceArgs']] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 secret_ref: Optional[pulumi.Input['SecretEnvSourceArgs']] = None):
        """
        EnvFromSource represents the source of a set of ConfigMaps
        :param pulumi.Input['ConfigMapEnvSourceArgs'] config_map_ref: The ConfigMap to select from
        :param pulumi.Input[str] prefix: An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
        :param pulumi.Input['SecretEnvSourceArgs'] secret_ref: The Secret to select from
        """
        if config_map_ref is not None:
            pulumi.set(__self__, "config_map_ref", config_map_ref)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> Optional[pulumi.Input['ConfigMapEnvSourceArgs']]:
        """
        The ConfigMap to select from
        """
        return pulumi.get(self, "config_map_ref")

    @config_map_ref.setter
    def config_map_ref(self, value: Optional[pulumi.Input['ConfigMapEnvSourceArgs']]):
        pulumi.set(self, "config_map_ref", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['SecretEnvSourceArgs']]:
        """
        The Secret to select from
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['SecretEnvSourceArgs']]):
        pulumi.set(self, "secret_ref", value)


@pulumi.input_type
class EnvVarArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None,
                 value_from: Optional[pulumi.Input['EnvVarSourceArgs']] = None):
        """
        EnvVar represents an environment variable present in a Container.
        :param pulumi.Input[str] name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param pulumi.Input[str] value: Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        :param pulumi.Input['EnvVarSourceArgs'] value_from: Source for the environment variable's value. Cannot be used if value is not empty.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_from is not None:
            pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> Optional[pulumi.Input['EnvVarSourceArgs']]:
        """
        Source for the environment variable's value. Cannot be used if value is not empty.
        """
        return pulumi.get(self, "value_from")

    @value_from.setter
    def value_from(self, value: Optional[pulumi.Input['EnvVarSourceArgs']]):
        pulumi.set(self, "value_from", value)


@pulumi.input_type
class EnvVarSourceArgs:
    def __init__(__self__, *,
                 config_map_key_ref: Optional[pulumi.Input['ConfigMapKeySelectorArgs']] = None,
                 field_ref: Optional[pulumi.Input['ObjectFieldSelectorArgs']] = None,
                 resource_field_ref: Optional[pulumi.Input['ResourceFieldSelectorArgs']] = None,
                 secret_key_ref: Optional[pulumi.Input['SecretKeySelectorArgs']] = None):
        """
        EnvVarSource represents a source for the value of an EnvVar.
        :param pulumi.Input['ConfigMapKeySelectorArgs'] config_map_key_ref: Selects a key of a ConfigMap.
        :param pulumi.Input['ObjectFieldSelectorArgs'] field_ref: Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
        :param pulumi.Input['ResourceFieldSelectorArgs'] resource_field_ref: Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
        :param pulumi.Input['SecretKeySelectorArgs'] secret_key_ref: Selects a key of a secret in the pod's namespace
        """
        if config_map_key_ref is not None:
            pulumi.set(__self__, "config_map_key_ref", config_map_key_ref)
        if field_ref is not None:
            pulumi.set(__self__, "field_ref", field_ref)
        if resource_field_ref is not None:
            pulumi.set(__self__, "resource_field_ref", resource_field_ref)
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="configMapKeyRef")
    def config_map_key_ref(self) -> Optional[pulumi.Input['ConfigMapKeySelectorArgs']]:
        """
        Selects a key of a ConfigMap.
        """
        return pulumi.get(self, "config_map_key_ref")

    @config_map_key_ref.setter
    def config_map_key_ref(self, value: Optional[pulumi.Input['ConfigMapKeySelectorArgs']]):
        pulumi.set(self, "config_map_key_ref", value)

    @property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> Optional[pulumi.Input['ObjectFieldSelectorArgs']]:
        """
        Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
        """
        return pulumi.get(self, "field_ref")

    @field_ref.setter
    def field_ref(self, value: Optional[pulumi.Input['ObjectFieldSelectorArgs']]):
        pulumi.set(self, "field_ref", value)

    @property
    @pulumi.getter(name="resourceFieldRef")
    def resource_field_ref(self) -> Optional[pulumi.Input['ResourceFieldSelectorArgs']]:
        """
        Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
        """
        return pulumi.get(self, "resource_field_ref")

    @resource_field_ref.setter
    def resource_field_ref(self, value: Optional[pulumi.Input['ResourceFieldSelectorArgs']]):
        pulumi.set(self, "resource_field_ref", value)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional[pulumi.Input['SecretKeySelectorArgs']]:
        """
        Selects a key of a secret in the pod's namespace
        """
        return pulumi.get(self, "secret_key_ref")

    @secret_key_ref.setter
    def secret_key_ref(self, value: Optional[pulumi.Input['SecretKeySelectorArgs']]):
        pulumi.set(self, "secret_key_ref", value)


@pulumi.input_type
class EphemeralContainerArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]]] = None,
                 env_from: Optional[pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 image_pull_policy: Optional[pulumi.Input[str]] = None,
                 lifecycle: Optional[pulumi.Input['LifecycleArgs']] = None,
                 liveness_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]] = None,
                 readiness_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 resources: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 security_context: Optional[pulumi.Input['SecurityContextArgs']] = None,
                 startup_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 stdin: Optional[pulumi.Input[bool]] = None,
                 stdin_once: Optional[pulumi.Input[bool]] = None,
                 target_container_name: Optional[pulumi.Input[str]] = None,
                 termination_message_path: Optional[pulumi.Input[str]] = None,
                 termination_message_policy: Optional[pulumi.Input[str]] = None,
                 tty: Optional[pulumi.Input[bool]] = None,
                 volume_devices: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        An EphemeralContainer is a container that may be added temporarily to an existing pod for user-initiated activities such as debugging. Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a pod is removed or restarted. If an ephemeral container causes a pod to exceed its resource allocation, the pod may be evicted. Ephemeral containers may not be added by directly updating the pod spec. They must be added via the pod's ephemeralcontainers subresource, and they will appear in the pod spec once added. This is an alpha feature enabled by the EphemeralContainers feature flag.
        :param pulumi.Input[str] name: Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]] env: List of environment variables to set in the container. Cannot be updated.
        :param pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]] env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param pulumi.Input[str] image: Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images
        :param pulumi.Input[str] image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param pulumi.Input['LifecycleArgs'] lifecycle: Lifecycle is not allowed for ephemeral containers.
        :param pulumi.Input['ProbeArgs'] liveness_probe: Probes are not allowed for ephemeral containers.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]] ports: Ports are not allowed for ephemeral containers.
        :param pulumi.Input['ProbeArgs'] readiness_probe: Probes are not allowed for ephemeral containers.
        :param pulumi.Input['ResourceRequirementsArgs'] resources: Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.
        :param pulumi.Input['SecurityContextArgs'] security_context: SecurityContext is not allowed for ephemeral containers.
        :param pulumi.Input['ProbeArgs'] startup_probe: Probes are not allowed for ephemeral containers.
        :param pulumi.Input[bool] stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        :param pulumi.Input[bool] stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        :param pulumi.Input[str] target_container_name: If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container is run in whatever namespaces are shared for the pod. Note that the container runtime must support this feature.
        :param pulumi.Input[str] termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        :param pulumi.Input[str] termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        :param pulumi.Input[bool] tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]] volume_devices: volumeDevices is the list of block devices to be used by the container.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]] volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param pulumi.Input[str] working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if env_from is not None:
            pulumi.set(__self__, "env_from", env_from)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if stdin is not None:
            pulumi.set(__self__, "stdin", stdin)
        if stdin_once is not None:
            pulumi.set(__self__, "stdin_once", stdin_once)
        if target_container_name is not None:
            pulumi.set(__self__, "target_container_name", target_container_name)
        if termination_message_path is not None:
            pulumi.set(__self__, "termination_message_path", termination_message_path)
        if termination_message_policy is not None:
            pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        if tty is not None:
            pulumi.set(__self__, "tty", tty)
        if volume_devices is not None:
            pulumi.set(__self__, "volume_devices", volume_devices)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]]]:
        """
        List of environment variables to set in the container. Cannot be updated.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]]]:
        """
        List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        """
        return pulumi.get(self, "env_from")

    @env_from.setter
    def env_from(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]]]):
        pulumi.set(self, "env_from", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional[pulumi.Input['LifecycleArgs']]:
        """
        Lifecycle is not allowed for ephemeral containers.
        """
        return pulumi.get(self, "lifecycle")

    @lifecycle.setter
    def lifecycle(self, value: Optional[pulumi.Input['LifecycleArgs']]):
        pulumi.set(self, "lifecycle", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        Probes are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]]:
        """
        Ports are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        Probes are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "readiness_probe")

    @readiness_probe.setter
    def readiness_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "readiness_probe", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['SecurityContextArgs']]:
        """
        SecurityContext is not allowed for ephemeral containers.
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['SecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        Probes are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "startup_probe")

    @startup_probe.setter
    def startup_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "startup_probe", value)

    @property
    @pulumi.getter
    def stdin(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        """
        return pulumi.get(self, "stdin")

    @stdin.setter
    def stdin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stdin", value)

    @property
    @pulumi.getter(name="stdinOnce")
    def stdin_once(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        """
        return pulumi.get(self, "stdin_once")

    @stdin_once.setter
    def stdin_once(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stdin_once", value)

    @property
    @pulumi.getter(name="targetContainerName")
    def target_container_name(self) -> Optional[pulumi.Input[str]]:
        """
        If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container is run in whatever namespaces are shared for the pod. Note that the container runtime must support this feature.
        """
        return pulumi.get(self, "target_container_name")

    @target_container_name.setter
    def target_container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_container_name", value)

    @property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_path")

    @termination_message_path.setter
    def termination_message_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "termination_message_path", value)

    @property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_policy")

    @termination_message_policy.setter
    def termination_message_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "termination_message_policy", value)

    @property
    @pulumi.getter
    def tty(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        """
        return pulumi.get(self, "tty")

    @tty.setter
    def tty(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tty", value)

    @property
    @pulumi.getter(name="volumeDevices")
    def volume_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]]]:
        """
        volumeDevices is the list of block devices to be used by the container.
        """
        return pulumi.get(self, "volume_devices")

    @volume_devices.setter
    def volume_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]]]):
        pulumi.set(self, "volume_devices", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]]:
        """
        Pod volumes to mount into the container's filesystem. Cannot be updated.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class EphemeralVolumeSourceArgs:
    def __init__(__self__, *,
                 volume_claim_template: Optional[pulumi.Input['PersistentVolumeClaimTemplateArgs']] = None):
        """
        Represents an ephemeral volume that is handled by a normal storage driver.
        :param pulumi.Input['PersistentVolumeClaimTemplateArgs'] volume_claim_template: Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).
               
               An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.
               
               This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.
               
               Required, must not be nil.
        """
        if volume_claim_template is not None:
            pulumi.set(__self__, "volume_claim_template", volume_claim_template)

    @property
    @pulumi.getter(name="volumeClaimTemplate")
    def volume_claim_template(self) -> Optional[pulumi.Input['PersistentVolumeClaimTemplateArgs']]:
        """
        Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).

        An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.

        This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.

        Required, must not be nil.
        """
        return pulumi.get(self, "volume_claim_template")

    @volume_claim_template.setter
    def volume_claim_template(self, value: Optional[pulumi.Input['PersistentVolumeClaimTemplateArgs']]):
        pulumi.set(self, "volume_claim_template", value)


@pulumi.input_type
class EventArgs:
    def __init__(__self__, *,
                 involved_object: pulumi.Input['ObjectReferenceArgs'],
                 metadata: pulumi.Input['_meta.v1.ObjectMetaArgs'],
                 action: Optional[pulumi.Input[str]] = None,
                 api_version: Optional[pulumi.Input[str]] = None,
                 count: Optional[pulumi.Input[int]] = None,
                 event_time: Optional[pulumi.Input[str]] = None,
                 first_timestamp: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 last_timestamp: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 related: Optional[pulumi.Input['ObjectReferenceArgs']] = None,
                 reporting_component: Optional[pulumi.Input[str]] = None,
                 reporting_instance: Optional[pulumi.Input[str]] = None,
                 series: Optional[pulumi.Input['EventSeriesArgs']] = None,
                 source: Optional[pulumi.Input['EventSourceArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
        :param pulumi.Input['ObjectReferenceArgs'] involved_object: The object that this event is about.
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[str] action: What action was taken/failed regarding to the Regarding object.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[int] count: The number of times this event has occurred.
        :param pulumi.Input[str] event_time: Time when this Event was first observed.
        :param pulumi.Input[str] first_timestamp: The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[str] last_timestamp: The time at which the most recent occurrence of this event was recorded.
        :param pulumi.Input[str] message: A human-readable description of the status of this operation.
        :param pulumi.Input[str] reason: This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        :param pulumi.Input['ObjectReferenceArgs'] related: Optional secondary object for more complex actions.
        :param pulumi.Input[str] reporting_component: Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        :param pulumi.Input[str] reporting_instance: ID of the controller instance, e.g. `kubelet-xyzf`.
        :param pulumi.Input['EventSeriesArgs'] series: Data about the Event series this event represents or nil if it's a singleton Event.
        :param pulumi.Input['EventSourceArgs'] source: The component reporting this event. Should be a short machine understandable string.
        :param pulumi.Input[str] type: Type of this event (Normal, Warning), new types could be added in the future
        """
        pulumi.set(__self__, "involved_object", involved_object)
        pulumi.set(__self__, "metadata", metadata)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if count is not None:
            pulumi.set(__self__, "count", count)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if first_timestamp is not None:
            pulumi.set(__self__, "first_timestamp", first_timestamp)
        if kind is not None:
            pulumi.set(__self__, "kind", 'Event')
        if last_timestamp is not None:
            pulumi.set(__self__, "last_timestamp", last_timestamp)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if related is not None:
            pulumi.set(__self__, "related", related)
        if reporting_component is not None:
            pulumi.set(__self__, "reporting_component", reporting_component)
        if reporting_instance is not None:
            pulumi.set(__self__, "reporting_instance", reporting_instance)
        if series is not None:
            pulumi.set(__self__, "series", series)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="involvedObject")
    def involved_object(self) -> pulumi.Input['ObjectReferenceArgs']:
        """
        The object that this event is about.
        """
        return pulumi.get(self, "involved_object")

    @involved_object.setter
    def involved_object(self, value: pulumi.Input['ObjectReferenceArgs']):
        pulumi.set(self, "involved_object", value)

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Input['_meta.v1.ObjectMetaArgs']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input['_meta.v1.ObjectMetaArgs']):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        What action was taken/failed regarding to the Regarding object.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times this event has occurred.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when this Event was first observed.
        """
        return pulumi.get(self, "event_time")

    @event_time.setter
    def event_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_time", value)

    @property
    @pulumi.getter(name="firstTimestamp")
    def first_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        """
        return pulumi.get(self, "first_timestamp")

    @first_timestamp.setter
    def first_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_timestamp", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="lastTimestamp")
    def last_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the most recent occurrence of this event was recorded.
        """
        return pulumi.get(self, "last_timestamp")

    @last_timestamp.setter
    def last_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_timestamp", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the status of this operation.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def related(self) -> Optional[pulumi.Input['ObjectReferenceArgs']]:
        """
        Optional secondary object for more complex actions.
        """
        return pulumi.get(self, "related")

    @related.setter
    def related(self, value: Optional[pulumi.Input['ObjectReferenceArgs']]):
        pulumi.set(self, "related", value)

    @property
    @pulumi.getter(name="reportingComponent")
    def reporting_component(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        """
        return pulumi.get(self, "reporting_component")

    @reporting_component.setter
    def reporting_component(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reporting_component", value)

    @property
    @pulumi.getter(name="reportingInstance")
    def reporting_instance(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the controller instance, e.g. `kubelet-xyzf`.
        """
        return pulumi.get(self, "reporting_instance")

    @reporting_instance.setter
    def reporting_instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reporting_instance", value)

    @property
    @pulumi.getter
    def series(self) -> Optional[pulumi.Input['EventSeriesArgs']]:
        """
        Data about the Event series this event represents or nil if it's a singleton Event.
        """
        return pulumi.get(self, "series")

    @series.setter
    def series(self, value: Optional[pulumi.Input['EventSeriesArgs']]):
        pulumi.set(self, "series", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['EventSourceArgs']]:
        """
        The component reporting this event. Should be a short machine understandable string.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['EventSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of this event (Normal, Warning), new types could be added in the future
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class EventSeriesArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 last_observed_time: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
        :param pulumi.Input[int] count: Number of occurrences in this series up to the last heartbeat time
        :param pulumi.Input[str] last_observed_time: Time of the last occurrence observed
        :param pulumi.Input[str] state: State of this Series: Ongoing or Finished Deprecated. Planned removal for 1.18
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if last_observed_time is not None:
            pulumi.set(__self__, "last_observed_time", last_observed_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of occurrences in this series up to the last heartbeat time
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="lastObservedTime")
    def last_observed_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time of the last occurrence observed
        """
        return pulumi.get(self, "last_observed_time")

    @last_observed_time.setter
    def last_observed_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_observed_time", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of this Series: Ongoing or Finished Deprecated. Planned removal for 1.18
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class EventSourceArgs:
    def __init__(__self__, *,
                 component: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None):
        """
        EventSource contains information for an event.
        :param pulumi.Input[str] component: Component from which the event is generated.
        :param pulumi.Input[str] host: Node name on which the event is generated.
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def component(self) -> Optional[pulumi.Input[str]]:
        """
        Component from which the event is generated.
        """
        return pulumi.get(self, "component")

    @component.setter
    def component(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Node name on which the event is generated.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)


@pulumi.input_type
class ExecActionArgs:
    def __init__(__self__, *,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ExecAction describes a "run in container" action.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)


@pulumi.input_type
class FCVolumeSourceArgs:
    def __init__(__self__, *,
                 fs_type: Optional[pulumi.Input[str]] = None,
                 lun: Optional[pulumi.Input[int]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 target_wwns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wwids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param pulumi.Input[int] lun: Optional: FC target lun number
        :param pulumi.Input[bool] read_only: Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_wwns: Optional: FC target worldwide names (WWNs)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wwids: Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if target_wwns is not None:
            pulumi.set(__self__, "target_wwns", target_wwns)
        if wwids is not None:
            pulumi.set(__self__, "wwids", wwids)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter
    def lun(self) -> Optional[pulumi.Input[int]]:
        """
        Optional: FC target lun number
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="targetWWNs")
    def target_wwns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional: FC target worldwide names (WWNs)
        """
        return pulumi.get(self, "target_wwns")

    @target_wwns.setter
    def target_wwns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_wwns", value)

    @property
    @pulumi.getter
    def wwids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
        """
        return pulumi.get(self, "wwids")

    @wwids.setter
    def wwids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "wwids", value)


@pulumi.input_type
class FlexPersistentVolumeSourceArgs:
    def __init__(__self__, *,
                 driver: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_ref: Optional[pulumi.Input['SecretReferenceArgs']] = None):
        """
        FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.
        :param pulumi.Input[str] driver: Driver is the name of the driver to use for this volume.
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] options: Optional: Extra command options if any.
        :param pulumi.Input[bool] read_only: Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param pulumi.Input['SecretReferenceArgs'] secret_ref: Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        pulumi.set(__self__, "driver", driver)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[str]:
        """
        Driver is the name of the driver to use for this volume.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional: Extra command options if any.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['SecretReferenceArgs']]:
        """
        Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['SecretReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)


@pulumi.input_type
class FlexVolumeSourceArgs:
    def __init__(__self__, *,
                 driver: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_ref: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None):
        """
        FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
        :param pulumi.Input[str] driver: Driver is the name of the driver to use for this volume.
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] options: Optional: Extra command options if any.
        :param pulumi.Input[bool] read_only: Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param pulumi.Input['LocalObjectReferenceArgs'] secret_ref: Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        pulumi.set(__self__, "driver", driver)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[str]:
        """
        Driver is the name of the driver to use for this volume.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional: Extra command options if any.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)


@pulumi.input_type
class FlockerVolumeSourceArgs:
    def __init__(__self__, *,
                 dataset_name: Optional[pulumi.Input[str]] = None,
                 dataset_uuid: Optional[pulumi.Input[str]] = None):
        """
        Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.
        :param pulumi.Input[str] dataset_name: Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
        :param pulumi.Input[str] dataset_uuid: UUID of the dataset. This is unique identifier of a Flocker dataset
        """
        if dataset_name is not None:
            pulumi.set(__self__, "dataset_name", dataset_name)
        if dataset_uuid is not None:
            pulumi.set(__self__, "dataset_uuid", dataset_uuid)

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
        """
        return pulumi.get(self, "dataset_name")

    @dataset_name.setter
    def dataset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_name", value)

    @property
    @pulumi.getter(name="datasetUUID")
    def dataset_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        UUID of the dataset. This is unique identifier of a Flocker dataset
        """
        return pulumi.get(self, "dataset_uuid")

    @dataset_uuid.setter
    def dataset_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_uuid", value)


@pulumi.input_type
class GCEPersistentDiskVolumeSourceArgs:
    def __init__(__self__, *,
                 pd_name: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 partition: Optional[pulumi.Input[int]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        Represents a Persistent Disk resource in Google Compute Engine.

        A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.
        :param pulumi.Input[str] pd_name: Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param pulumi.Input[str] fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param pulumi.Input[int] partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param pulumi.Input[bool] read_only: ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        pulumi.set(__self__, "pd_name", pd_name)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="pdName")
    def pd_name(self) -> pulumi.Input[str]:
        """
        Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "pd_name")

    @pd_name.setter
    def pd_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "pd_name", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[int]]:
        """
        The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class GitRepoVolumeSourceArgs:
    def __init__(__self__, *,
                 repository: pulumi.Input[str],
                 directory: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[str]] = None):
        """
        Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

        DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
        :param pulumi.Input[str] repository: Repository URL
        :param pulumi.Input[str] directory: Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
        :param pulumi.Input[str] revision: Commit hash for the specified revision.
        """
        pulumi.set(__self__, "repository", repository)
        if directory is not None:
            pulumi.set(__self__, "directory", directory)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        Repository URL
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def directory(self) -> Optional[pulumi.Input[str]]:
        """
        Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
        """
        return pulumi.get(self, "directory")

    @directory.setter
    def directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directory", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        Commit hash for the specified revision.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)


@pulumi.input_type
class GlusterfsPersistentVolumeSourceArgs:
    def __init__(__self__, *,
                 endpoints: pulumi.Input[str],
                 path: pulumi.Input[str],
                 endpoints_namespace: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
        :param pulumi.Input[str] endpoints: EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param pulumi.Input[str] path: Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param pulumi.Input[str] endpoints_namespace: EndpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param pulumi.Input[bool] read_only: ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "path", path)
        if endpoints_namespace is not None:
            pulumi.set(__self__, "endpoints_namespace", endpoints_namespace)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Input[str]:
        """
        EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="endpointsNamespace")
    def endpoints_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        EndpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "endpoints_namespace")

    @endpoints_namespace.setter
    def endpoints_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoints_namespace", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class GlusterfsVolumeSourceArgs:
    def __init__(__self__, *,
                 endpoints: pulumi.Input[str],
                 path: pulumi.Input[str],
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
        :param pulumi.Input[str] endpoints: EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param pulumi.Input[str] path: Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param pulumi.Input[bool] read_only: ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Input[str]:
        """
        EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class HTTPGetActionArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[Union[int, str]],
                 host: Optional[pulumi.Input[str]] = None,
                 http_headers: Optional[pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 scheme: Optional[pulumi.Input[str]] = None):
        """
        HTTPGetAction describes an action based on HTTP Get requests.
        :param pulumi.Input[Union[int, str]] port: Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param pulumi.Input[str] host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        :param pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param pulumi.Input[str] path: Path to access on the HTTP server.
        :param pulumi.Input[str] scheme: Scheme to use for connecting to the host. Defaults to HTTP.
        """
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[Union[int, str]]:
        """
        Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[Union[int, str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]]]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @http_headers.setter
    def http_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]]]):
        pulumi.set(self, "http_headers", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to access on the HTTP server.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Scheme to use for connecting to the host. Defaults to HTTP.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheme", value)


@pulumi.input_type
class HTTPHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        HTTPHeader describes a custom header to be used in HTTP probes
        :param pulumi.Input[str] name: The header field name
        :param pulumi.Input[str] value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HandlerArgs:
    def __init__(__self__, *,
                 exec_: Optional[pulumi.Input['ExecActionArgs']] = None,
                 http_get: Optional[pulumi.Input['HTTPGetActionArgs']] = None,
                 tcp_socket: Optional[pulumi.Input['TCPSocketActionArgs']] = None):
        """
        Handler defines a specific action that should be taken
        :param pulumi.Input['ExecActionArgs'] exec_: One and only one of the following should be specified. Exec specifies the action to take.
        :param pulumi.Input['HTTPGetActionArgs'] http_get: HTTPGet specifies the http request to perform.
        :param pulumi.Input['TCPSocketActionArgs'] tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported
        """
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional[pulumi.Input['ExecActionArgs']]:
        """
        One and only one of the following should be specified. Exec specifies the action to take.
        """
        return pulumi.get(self, "exec_")

    @exec_.setter
    def exec_(self, value: Optional[pulumi.Input['ExecActionArgs']]):
        pulumi.set(self, "exec_", value)

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional[pulumi.Input['HTTPGetActionArgs']]:
        """
        HTTPGet specifies the http request to perform.
        """
        return pulumi.get(self, "http_get")

    @http_get.setter
    def http_get(self, value: Optional[pulumi.Input['HTTPGetActionArgs']]):
        pulumi.set(self, "http_get", value)

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional[pulumi.Input['TCPSocketActionArgs']]:
        """
        TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported
        """
        return pulumi.get(self, "tcp_socket")

    @tcp_socket.setter
    def tcp_socket(self, value: Optional[pulumi.Input['TCPSocketActionArgs']]):
        pulumi.set(self, "tcp_socket", value)


@pulumi.input_type
class HostAliasArgs:
    def __init__(__self__, *,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip: Optional[pulumi.Input[str]] = None):
        """
        HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: Hostnames for the above IP address.
        :param pulumi.Input[str] ip: IP address of the host file entry.
        """
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Hostnames for the above IP address.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the host file entry.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class HostPathVolumeSourceArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 type: Optional[pulumi.Input[str]] = None):
        """
        Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.
        :param pulumi.Input[str] path: Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        :param pulumi.Input[str] type: Type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        pulumi.set(__self__, "path", path)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ISCSIPersistentVolumeSourceArgs:
    def __init__(__self__, *,
                 iqn: pulumi.Input[str],
                 lun: pulumi.Input[int],
                 target_portal: pulumi.Input[str],
                 chap_auth_discovery: Optional[pulumi.Input[bool]] = None,
                 chap_auth_session: Optional[pulumi.Input[bool]] = None,
                 fs_type: Optional[pulumi.Input[str]] = None,
                 initiator_name: Optional[pulumi.Input[str]] = None,
                 iscsi_interface: Optional[pulumi.Input[str]] = None,
                 portals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_ref: Optional[pulumi.Input['SecretReferenceArgs']] = None):
        """
        ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[str] iqn: Target iSCSI Qualified Name.
        :param pulumi.Input[int] lun: iSCSI Target Lun number.
        :param pulumi.Input[str] target_portal: iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param pulumi.Input[bool] chap_auth_discovery: whether support iSCSI Discovery CHAP authentication
        :param pulumi.Input[bool] chap_auth_session: whether support iSCSI Session CHAP authentication
        :param pulumi.Input[str] fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param pulumi.Input[str] initiator_name: Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        :param pulumi.Input[str] iscsi_interface: iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] portals: iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param pulumi.Input[bool] read_only: ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        :param pulumi.Input['SecretReferenceArgs'] secret_ref: CHAP Secret for iSCSI target and initiator authentication
        """
        pulumi.set(__self__, "iqn", iqn)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "target_portal", target_portal)
        if chap_auth_discovery is not None:
            pulumi.set(__self__, "chap_auth_discovery", chap_auth_discovery)
        if chap_auth_session is not None:
            pulumi.set(__self__, "chap_auth_session", chap_auth_session)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if initiator_name is not None:
            pulumi.set(__self__, "initiator_name", initiator_name)
        if iscsi_interface is not None:
            pulumi.set(__self__, "iscsi_interface", iscsi_interface)
        if portals is not None:
            pulumi.set(__self__, "portals", portals)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter
    def iqn(self) -> pulumi.Input[str]:
        """
        Target iSCSI Qualified Name.
        """
        return pulumi.get(self, "iqn")

    @iqn.setter
    def iqn(self, value: pulumi.Input[str]):
        pulumi.set(self, "iqn", value)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[int]:
        """
        iSCSI Target Lun number.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="targetPortal")
    def target_portal(self) -> pulumi.Input[str]:
        """
        iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "target_portal")

    @target_portal.setter
    def target_portal(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_portal", value)

    @property
    @pulumi.getter(name="chapAuthDiscovery")
    def chap_auth_discovery(self) -> Optional[pulumi.Input[bool]]:
        """
        whether support iSCSI Discovery CHAP authentication
        """
        return pulumi.get(self, "chap_auth_discovery")

    @chap_auth_discovery.setter
    def chap_auth_discovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "chap_auth_discovery", value)

    @property
    @pulumi.getter(name="chapAuthSession")
    def chap_auth_session(self) -> Optional[pulumi.Input[bool]]:
        """
        whether support iSCSI Session CHAP authentication
        """
        return pulumi.get(self, "chap_auth_session")

    @chap_auth_session.setter
    def chap_auth_session(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "chap_auth_session", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="initiatorName")
    def initiator_name(self) -> Optional[pulumi.Input[str]]:
        """
        Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        """
        return pulumi.get(self, "initiator_name")

    @initiator_name.setter
    def initiator_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initiator_name", value)

    @property
    @pulumi.getter(name="iscsiInterface")
    def iscsi_interface(self) -> Optional[pulumi.Input[str]]:
        """
        iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        """
        return pulumi.get(self, "iscsi_interface")

    @iscsi_interface.setter
    def iscsi_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iscsi_interface", value)

    @property
    @pulumi.getter
    def portals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "portals")

    @portals.setter
    def portals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "portals", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['SecretReferenceArgs']]:
        """
        CHAP Secret for iSCSI target and initiator authentication
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['SecretReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)


@pulumi.input_type
class ISCSIVolumeSourceArgs:
    def __init__(__self__, *,
                 iqn: pulumi.Input[str],
                 lun: pulumi.Input[int],
                 target_portal: pulumi.Input[str],
                 chap_auth_discovery: Optional[pulumi.Input[bool]] = None,
                 chap_auth_session: Optional[pulumi.Input[bool]] = None,
                 fs_type: Optional[pulumi.Input[str]] = None,
                 initiator_name: Optional[pulumi.Input[str]] = None,
                 iscsi_interface: Optional[pulumi.Input[str]] = None,
                 portals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_ref: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None):
        """
        Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[str] iqn: Target iSCSI Qualified Name.
        :param pulumi.Input[int] lun: iSCSI Target Lun number.
        :param pulumi.Input[str] target_portal: iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param pulumi.Input[bool] chap_auth_discovery: whether support iSCSI Discovery CHAP authentication
        :param pulumi.Input[bool] chap_auth_session: whether support iSCSI Session CHAP authentication
        :param pulumi.Input[str] fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param pulumi.Input[str] initiator_name: Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        :param pulumi.Input[str] iscsi_interface: iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] portals: iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param pulumi.Input[bool] read_only: ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        :param pulumi.Input['LocalObjectReferenceArgs'] secret_ref: CHAP Secret for iSCSI target and initiator authentication
        """
        pulumi.set(__self__, "iqn", iqn)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "target_portal", target_portal)
        if chap_auth_discovery is not None:
            pulumi.set(__self__, "chap_auth_discovery", chap_auth_discovery)
        if chap_auth_session is not None:
            pulumi.set(__self__, "chap_auth_session", chap_auth_session)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if initiator_name is not None:
            pulumi.set(__self__, "initiator_name", initiator_name)
        if iscsi_interface is not None:
            pulumi.set(__self__, "iscsi_interface", iscsi_interface)
        if portals is not None:
            pulumi.set(__self__, "portals", portals)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter
    def iqn(self) -> pulumi.Input[str]:
        """
        Target iSCSI Qualified Name.
        """
        return pulumi.get(self, "iqn")

    @iqn.setter
    def iqn(self, value: pulumi.Input[str]):
        pulumi.set(self, "iqn", value)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[int]:
        """
        iSCSI Target Lun number.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="targetPortal")
    def target_portal(self) -> pulumi.Input[str]:
        """
        iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "target_portal")

    @target_portal.setter
    def target_portal(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_portal", value)

    @property
    @pulumi.getter(name="chapAuthDiscovery")
    def chap_auth_discovery(self) -> Optional[pulumi.Input[bool]]:
        """
        whether support iSCSI Discovery CHAP authentication
        """
        return pulumi.get(self, "chap_auth_discovery")

    @chap_auth_discovery.setter
    def chap_auth_discovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "chap_auth_discovery", value)

    @property
    @pulumi.getter(name="chapAuthSession")
    def chap_auth_session(self) -> Optional[pulumi.Input[bool]]:
        """
        whether support iSCSI Session CHAP authentication
        """
        return pulumi.get(self, "chap_auth_session")

    @chap_auth_session.setter
    def chap_auth_session(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "chap_auth_session", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="initiatorName")
    def initiator_name(self) -> Optional[pulumi.Input[str]]:
        """
        Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        """
        return pulumi.get(self, "initiator_name")

    @initiator_name.setter
    def initiator_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initiator_name", value)

    @property
    @pulumi.getter(name="iscsiInterface")
    def iscsi_interface(self) -> Optional[pulumi.Input[str]]:
        """
        iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        """
        return pulumi.get(self, "iscsi_interface")

    @iscsi_interface.setter
    def iscsi_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iscsi_interface", value)

    @property
    @pulumi.getter
    def portals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "portals")

    @portals.setter
    def portals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "portals", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        CHAP Secret for iSCSI target and initiator authentication
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)


@pulumi.input_type
class KeyToPathArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 path: pulumi.Input[str],
                 mode: Optional[pulumi.Input[int]] = None):
        """
        Maps a string key to a path within a volume.
        :param pulumi.Input[str] key: The key to project.
        :param pulumi.Input[str] path: The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        :param pulumi.Input[int] mode: Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "path", path)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key to project.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[int]]:
        """
        Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class LifecycleArgs:
    def __init__(__self__, *,
                 post_start: Optional[pulumi.Input['HandlerArgs']] = None,
                 pre_stop: Optional[pulumi.Input['HandlerArgs']] = None):
        """
        Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
        :param pulumi.Input['HandlerArgs'] post_start: PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        :param pulumi.Input['HandlerArgs'] pre_stop: PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        """
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)

    @property
    @pulumi.getter(name="postStart")
    def post_start(self) -> Optional[pulumi.Input['HandlerArgs']]:
        """
        PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        """
        return pulumi.get(self, "post_start")

    @post_start.setter
    def post_start(self, value: Optional[pulumi.Input['HandlerArgs']]):
        pulumi.set(self, "post_start", value)

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> Optional[pulumi.Input['HandlerArgs']]:
        """
        PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        """
        return pulumi.get(self, "pre_stop")

    @pre_stop.setter
    def pre_stop(self, value: Optional[pulumi.Input['HandlerArgs']]):
        pulumi.set(self, "pre_stop", value)


@pulumi.input_type
class LimitRangeArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['LimitRangeSpecArgs']] = None):
        """
        LimitRange sets resource usage limits for each kind of resource in a Namespace.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['LimitRangeSpecArgs'] spec: Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'LimitRange')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['LimitRangeSpecArgs']]:
        """
        Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['LimitRangeSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class LimitRangeItemArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 default: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 default_request: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_limit_request_ratio: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 min: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
        :param pulumi.Input[str] type: Type of resource that this limit applies to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] default: Default resource requirement limit value by resource name if resource limit is omitted.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] default_request: DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] max: Max usage constraints on this kind by resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] max_limit_request_ratio: MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] min: Min usage constraints on this kind by resource name.
        """
        pulumi.set(__self__, "type", type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if default_request is not None:
            pulumi.set(__self__, "default_request", default_request)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if max_limit_request_ratio is not None:
            pulumi.set(__self__, "max_limit_request_ratio", max_limit_request_ratio)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of resource that this limit applies to.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Default resource requirement limit value by resource name if resource limit is omitted.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="defaultRequest")
    def default_request(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
        """
        return pulumi.get(self, "default_request")

    @default_request.setter
    def default_request(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "default_request", value)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Max usage constraints on this kind by resource name.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter(name="maxLimitRequestRatio")
    def max_limit_request_ratio(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
        """
        return pulumi.get(self, "max_limit_request_ratio")

    @max_limit_request_ratio.setter
    def max_limit_request_ratio(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "max_limit_request_ratio", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Min usage constraints on this kind by resource name.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "min", value)


@pulumi.input_type
class LimitRangeSpecArgs:
    def __init__(__self__, *,
                 limits: pulumi.Input[Sequence[pulumi.Input['LimitRangeItemArgs']]]):
        """
        LimitRangeSpec defines a min/max usage limit for resources that match on kind.
        :param pulumi.Input[Sequence[pulumi.Input['LimitRangeItemArgs']]] limits: Limits is the list of LimitRangeItem objects that are enforced.
        """
        pulumi.set(__self__, "limits", limits)

    @property
    @pulumi.getter
    def limits(self) -> pulumi.Input[Sequence[pulumi.Input['LimitRangeItemArgs']]]:
        """
        Limits is the list of LimitRangeItem objects that are enforced.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: pulumi.Input[Sequence[pulumi.Input['LimitRangeItemArgs']]]):
        pulumi.set(self, "limits", value)


@pulumi.input_type
class LoadBalancerIngressArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['PortStatusArgs']]]] = None):
        """
        LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.
        :param pulumi.Input[str] hostname: Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
        :param pulumi.Input[str] ip: IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
        :param pulumi.Input[Sequence[pulumi.Input['PortStatusArgs']]] ports: Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortStatusArgs']]]]:
        """
        Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortStatusArgs']]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class LoadBalancerStatusArgs:
    def __init__(__self__, *,
                 ingress: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerIngressArgs']]]] = None):
        """
        LoadBalancerStatus represents the status of a load-balancer.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerIngressArgs']]] ingress: Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.
        """
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerIngressArgs']]]]:
        """
        Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerIngressArgs']]]]):
        pulumi.set(self, "ingress", value)


@pulumi.input_type
class LocalObjectReferenceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
        :param pulumi.Input[str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LocalVolumeSourceArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None):
        """
        Local represents directly-attached storage with node affinity (Beta feature)
        :param pulumi.Input[str] path: The full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).
        :param pulumi.Input[str] fs_type: Filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a fileystem if unspecified.
        """
        pulumi.set(__self__, "path", path)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a fileystem if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)


@pulumi.input_type
class NFSVolumeSourceArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 server: pulumi.Input[str],
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.
        :param pulumi.Input[str] path: Path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        :param pulumi.Input[str] server: Server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        :param pulumi.Input[bool] read_only: ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "server", server)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[str]:
        """
        Server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['NamespaceSpecArgs']] = None,
                 status: Optional[pulumi.Input['NamespaceStatusArgs']] = None):
        """
        Namespace provides a scope for Names. Use of multiple namespaces is optional.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['NamespaceSpecArgs'] spec: Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['NamespaceStatusArgs'] status: Status describes the current status of a Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Namespace')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['NamespaceSpecArgs']]:
        """
        Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['NamespaceSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['NamespaceStatusArgs']]:
        """
        Status describes the current status of a Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['NamespaceStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class NamespaceConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 type: pulumi.Input[str],
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        NamespaceCondition contains details about state of namespace.
        :param pulumi.Input[str] status: Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[str] type: Type of namespace controller condition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of namespace controller condition.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class NamespaceSpecArgs:
    def __init__(__self__, *,
                 finalizers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        NamespaceSpec describes the attributes on a Namespace.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] finalizers: Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)

    @property
    @pulumi.getter
    def finalizers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        return pulumi.get(self, "finalizers")

    @finalizers.setter
    def finalizers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "finalizers", value)


@pulumi.input_type
class NamespaceStatusArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceConditionArgs']]]] = None,
                 phase: Optional[pulumi.Input[str]] = None):
        """
        NamespaceStatus is information about the current status of a Namespace.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceConditionArgs']]] conditions: Represents the latest available observations of a namespace's current state.
        :param pulumi.Input[str] phase: Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceConditionArgs']]]]:
        """
        Represents the latest available observations of a namespace's current state.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def phase(self) -> Optional[pulumi.Input[str]]:
        """
        Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase", value)


@pulumi.input_type
class NodeArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['NodeSpecArgs']] = None,
                 status: Optional[pulumi.Input['NodeStatusArgs']] = None):
        """
        Node is a worker node in Kubernetes. Each node will have a unique identifier in the cache (i.e. in etcd).
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['NodeSpecArgs'] spec: Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['NodeStatusArgs'] status: Most recently observed status of the node. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Node')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['NodeSpecArgs']]:
        """
        Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['NodeSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['NodeStatusArgs']]:
        """
        Most recently observed status of the node. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['NodeStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class NodeAddressArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        NodeAddress contains information for the node's address.
        :param pulumi.Input[str] address: The node address.
        :param pulumi.Input[str] type: Node address type, one of Hostname, ExternalIP or InternalIP.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The node address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Node address type, one of Hostname, ExternalIP or InternalIP.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class NodeAffinityArgs:
    def __init__(__self__, *,
                 preferred_during_scheduling_ignored_during_execution: Optional[pulumi.Input[Sequence[pulumi.Input['PreferredSchedulingTermArgs']]]] = None,
                 required_during_scheduling_ignored_during_execution: Optional[pulumi.Input['NodeSelectorArgs']] = None):
        """
        Node affinity is a group of node affinity scheduling rules.
        :param pulumi.Input[Sequence[pulumi.Input['PreferredSchedulingTermArgs']]] preferred_during_scheduling_ignored_during_execution: The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.
        :param pulumi.Input['NodeSelectorArgs'] required_during_scheduling_ignored_during_execution: If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.
        """
        if preferred_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "preferred_during_scheduling_ignored_during_execution", preferred_during_scheduling_ignored_during_execution)
        if required_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "required_during_scheduling_ignored_during_execution", required_during_scheduling_ignored_during_execution)

    @property
    @pulumi.getter(name="preferredDuringSchedulingIgnoredDuringExecution")
    def preferred_during_scheduling_ignored_during_execution(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PreferredSchedulingTermArgs']]]]:
        """
        The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.
        """
        return pulumi.get(self, "preferred_during_scheduling_ignored_during_execution")

    @preferred_during_scheduling_ignored_during_execution.setter
    def preferred_during_scheduling_ignored_during_execution(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PreferredSchedulingTermArgs']]]]):
        pulumi.set(self, "preferred_during_scheduling_ignored_during_execution", value)

    @property
    @pulumi.getter(name="requiredDuringSchedulingIgnoredDuringExecution")
    def required_during_scheduling_ignored_during_execution(self) -> Optional[pulumi.Input['NodeSelectorArgs']]:
        """
        If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.
        """
        return pulumi.get(self, "required_during_scheduling_ignored_during_execution")

    @required_during_scheduling_ignored_during_execution.setter
    def required_during_scheduling_ignored_during_execution(self, value: Optional[pulumi.Input['NodeSelectorArgs']]):
        pulumi.set(self, "required_during_scheduling_ignored_during_execution", value)


@pulumi.input_type
class NodeConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 type: pulumi.Input[str],
                 last_heartbeat_time: Optional[pulumi.Input[str]] = None,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        NodeCondition contains condition information for a node.
        :param pulumi.Input[str] status: Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[str] type: Type of node condition.
        :param pulumi.Input[str] last_heartbeat_time: Last time we got an update on a given condition.
        :param pulumi.Input[str] last_transition_time: Last time the condition transit from one status to another.
        :param pulumi.Input[str] message: Human readable message indicating details about last transition.
        :param pulumi.Input[str] reason: (brief) reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_heartbeat_time is not None:
            pulumi.set(__self__, "last_heartbeat_time", last_heartbeat_time)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of node condition.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastHeartbeatTime")
    def last_heartbeat_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time we got an update on a given condition.
        """
        return pulumi.get(self, "last_heartbeat_time")

    @last_heartbeat_time.setter
    def last_heartbeat_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_heartbeat_time", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time the condition transit from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        (brief) reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class NodeConfigSourceArgs:
    def __init__(__self__, *,
                 config_map: Optional[pulumi.Input['ConfigMapNodeConfigSourceArgs']] = None):
        """
        NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil.
        :param pulumi.Input['ConfigMapNodeConfigSourceArgs'] config_map: ConfigMap is a reference to a Node's ConfigMap
        """
        if config_map is not None:
            pulumi.set(__self__, "config_map", config_map)

    @property
    @pulumi.getter(name="configMap")
    def config_map(self) -> Optional[pulumi.Input['ConfigMapNodeConfigSourceArgs']]:
        """
        ConfigMap is a reference to a Node's ConfigMap
        """
        return pulumi.get(self, "config_map")

    @config_map.setter
    def config_map(self, value: Optional[pulumi.Input['ConfigMapNodeConfigSourceArgs']]):
        pulumi.set(self, "config_map", value)


@pulumi.input_type
class NodeConfigStatusArgs:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input['NodeConfigSourceArgs']] = None,
                 assigned: Optional[pulumi.Input['NodeConfigSourceArgs']] = None,
                 error: Optional[pulumi.Input[str]] = None,
                 last_known_good: Optional[pulumi.Input['NodeConfigSourceArgs']] = None):
        """
        NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource.
        :param pulumi.Input['NodeConfigSourceArgs'] active: Active reports the checkpointed config the node is actively using. Active will represent either the current version of the Assigned config, or the current LastKnownGood config, depending on whether attempting to use the Assigned config results in an error.
        :param pulumi.Input['NodeConfigSourceArgs'] assigned: Assigned reports the checkpointed config the node will try to use. When Node.Spec.ConfigSource is updated, the node checkpoints the associated config payload to local disk, along with a record indicating intended config. The node refers to this record to choose its config checkpoint, and reports this record in Assigned. Assigned only updates in the status after the record has been checkpointed to disk. When the Kubelet is restarted, it tries to make the Assigned config the Active config by loading and validating the checkpointed payload identified by Assigned.
        :param pulumi.Input[str] error: Error describes any problems reconciling the Spec.ConfigSource to the Active config. Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting to load or validate the Assigned config, etc. Errors may occur at different points while syncing config. Earlier errors (e.g. download or checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error by fixing the config assigned in Spec.ConfigSource. You can find additional information for debugging by searching the error message in the Kubelet log. Error is a human-readable description of the error state; machines can check whether or not Error is empty, but should not rely on the stability of the Error text across Kubelet versions.
        :param pulumi.Input['NodeConfigSourceArgs'] last_known_good: LastKnownGood reports the checkpointed config the node will fall back to when it encounters an error attempting to use the Assigned config. The Assigned config becomes the LastKnownGood config when the node determines that the Assigned config is stable and correct. This is currently implemented as a 10-minute soak period starting when the local record of Assigned config is updated. If the Assigned config is Active at the end of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil, because the local default config is always assumed good. You should not make assumptions about the node's method of determining config stability and correctness, as this may change or become configurable in the future.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if assigned is not None:
            pulumi.set(__self__, "assigned", assigned)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if last_known_good is not None:
            pulumi.set(__self__, "last_known_good", last_known_good)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input['NodeConfigSourceArgs']]:
        """
        Active reports the checkpointed config the node is actively using. Active will represent either the current version of the Assigned config, or the current LastKnownGood config, depending on whether attempting to use the Assigned config results in an error.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input['NodeConfigSourceArgs']]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def assigned(self) -> Optional[pulumi.Input['NodeConfigSourceArgs']]:
        """
        Assigned reports the checkpointed config the node will try to use. When Node.Spec.ConfigSource is updated, the node checkpoints the associated config payload to local disk, along with a record indicating intended config. The node refers to this record to choose its config checkpoint, and reports this record in Assigned. Assigned only updates in the status after the record has been checkpointed to disk. When the Kubelet is restarted, it tries to make the Assigned config the Active config by loading and validating the checkpointed payload identified by Assigned.
        """
        return pulumi.get(self, "assigned")

    @assigned.setter
    def assigned(self, value: Optional[pulumi.Input['NodeConfigSourceArgs']]):
        pulumi.set(self, "assigned", value)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input[str]]:
        """
        Error describes any problems reconciling the Spec.ConfigSource to the Active config. Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting to load or validate the Assigned config, etc. Errors may occur at different points while syncing config. Earlier errors (e.g. download or checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error by fixing the config assigned in Spec.ConfigSource. You can find additional information for debugging by searching the error message in the Kubelet log. Error is a human-readable description of the error state; machines can check whether or not Error is empty, but should not rely on the stability of the Error text across Kubelet versions.
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error", value)

    @property
    @pulumi.getter(name="lastKnownGood")
    def last_known_good(self) -> Optional[pulumi.Input['NodeConfigSourceArgs']]:
        """
        LastKnownGood reports the checkpointed config the node will fall back to when it encounters an error attempting to use the Assigned config. The Assigned config becomes the LastKnownGood config when the node determines that the Assigned config is stable and correct. This is currently implemented as a 10-minute soak period starting when the local record of Assigned config is updated. If the Assigned config is Active at the end of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil, because the local default config is always assumed good. You should not make assumptions about the node's method of determining config stability and correctness, as this may change or become configurable in the future.
        """
        return pulumi.get(self, "last_known_good")

    @last_known_good.setter
    def last_known_good(self, value: Optional[pulumi.Input['NodeConfigSourceArgs']]):
        pulumi.set(self, "last_known_good", value)


@pulumi.input_type
class NodeDaemonEndpointsArgs:
    def __init__(__self__, *,
                 kubelet_endpoint: Optional[pulumi.Input['DaemonEndpointArgs']] = None):
        """
        NodeDaemonEndpoints lists ports opened by daemons running on the Node.
        :param pulumi.Input['DaemonEndpointArgs'] kubelet_endpoint: Endpoint on which Kubelet is listening.
        """
        if kubelet_endpoint is not None:
            pulumi.set(__self__, "kubelet_endpoint", kubelet_endpoint)

    @property
    @pulumi.getter(name="kubeletEndpoint")
    def kubelet_endpoint(self) -> Optional[pulumi.Input['DaemonEndpointArgs']]:
        """
        Endpoint on which Kubelet is listening.
        """
        return pulumi.get(self, "kubelet_endpoint")

    @kubelet_endpoint.setter
    def kubelet_endpoint(self, value: Optional[pulumi.Input['DaemonEndpointArgs']]):
        pulumi.set(self, "kubelet_endpoint", value)


@pulumi.input_type
class NodeSelectorArgs:
    def __init__(__self__, *,
                 node_selector_terms: pulumi.Input[Sequence[pulumi.Input['NodeSelectorTermArgs']]]):
        """
        A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.
        :param pulumi.Input[Sequence[pulumi.Input['NodeSelectorTermArgs']]] node_selector_terms: Required. A list of node selector terms. The terms are ORed.
        """
        pulumi.set(__self__, "node_selector_terms", node_selector_terms)

    @property
    @pulumi.getter(name="nodeSelectorTerms")
    def node_selector_terms(self) -> pulumi.Input[Sequence[pulumi.Input['NodeSelectorTermArgs']]]:
        """
        Required. A list of node selector terms. The terms are ORed.
        """
        return pulumi.get(self, "node_selector_terms")

    @node_selector_terms.setter
    def node_selector_terms(self, value: pulumi.Input[Sequence[pulumi.Input['NodeSelectorTermArgs']]]):
        pulumi.set(self, "node_selector_terms", value)


@pulumi.input_type
class NodeSelectorRequirementArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 operator: pulumi.Input[str],
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
        :param pulumi.Input[str] key: The label key that the selector applies to.
        :param pulumi.Input[str] operator: Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The label key that the selector applies to.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[str]:
        """
        Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class NodeSelectorTermArgs:
    def __init__(__self__, *,
                 match_expressions: Optional[pulumi.Input[Sequence[pulumi.Input['NodeSelectorRequirementArgs']]]] = None,
                 match_fields: Optional[pulumi.Input[Sequence[pulumi.Input['NodeSelectorRequirementArgs']]]] = None):
        """
        A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
        :param pulumi.Input[Sequence[pulumi.Input['NodeSelectorRequirementArgs']]] match_expressions: A list of node selector requirements by node's labels.
        :param pulumi.Input[Sequence[pulumi.Input['NodeSelectorRequirementArgs']]] match_fields: A list of node selector requirements by node's fields.
        """
        if match_expressions is not None:
            pulumi.set(__self__, "match_expressions", match_expressions)
        if match_fields is not None:
            pulumi.set(__self__, "match_fields", match_fields)

    @property
    @pulumi.getter(name="matchExpressions")
    def match_expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeSelectorRequirementArgs']]]]:
        """
        A list of node selector requirements by node's labels.
        """
        return pulumi.get(self, "match_expressions")

    @match_expressions.setter
    def match_expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeSelectorRequirementArgs']]]]):
        pulumi.set(self, "match_expressions", value)

    @property
    @pulumi.getter(name="matchFields")
    def match_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeSelectorRequirementArgs']]]]:
        """
        A list of node selector requirements by node's fields.
        """
        return pulumi.get(self, "match_fields")

    @match_fields.setter
    def match_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeSelectorRequirementArgs']]]]):
        pulumi.set(self, "match_fields", value)


@pulumi.input_type
class NodeSpecArgs:
    def __init__(__self__, *,
                 config_source: Optional[pulumi.Input['NodeConfigSourceArgs']] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 provider_id: Optional[pulumi.Input[str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['TaintArgs']]]] = None,
                 unschedulable: Optional[pulumi.Input[bool]] = None):
        """
        NodeSpec describes the attributes that a node is created with.
        :param pulumi.Input['NodeConfigSourceArgs'] config_source: If specified, the source to get node configuration from The DynamicKubeletConfig feature gate must be enabled for the Kubelet to use this field
        :param pulumi.Input[str] external_id: Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966
        :param pulumi.Input[str] pod_cidr: PodCIDR represents the pod IP range assigned to the node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_cidrs: podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.
        :param pulumi.Input[str] provider_id: ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
        :param pulumi.Input[Sequence[pulumi.Input['TaintArgs']]] taints: If specified, the node's taints.
        :param pulumi.Input[bool] unschedulable: Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
        """
        if config_source is not None:
            pulumi.set(__self__, "config_source", config_source)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_cidrs is not None:
            pulumi.set(__self__, "pod_cidrs", pod_cidrs)
        if provider_id is not None:
            pulumi.set(__self__, "provider_id", provider_id)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)

    @property
    @pulumi.getter(name="configSource")
    def config_source(self) -> Optional[pulumi.Input['NodeConfigSourceArgs']]:
        """
        If specified, the source to get node configuration from The DynamicKubeletConfig feature gate must be enabled for the Kubelet to use this field
        """
        return pulumi.get(self, "config_source")

    @config_source.setter
    def config_source(self, value: Optional[pulumi.Input['NodeConfigSourceArgs']]):
        pulumi.set(self, "config_source", value)

    @property
    @pulumi.getter(name="externalID")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="podCIDR")
    def pod_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        PodCIDR represents the pod IP range assigned to the node.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="podCIDRs")
    def pod_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.
        """
        return pulumi.get(self, "pod_cidrs")

    @pod_cidrs.setter
    def pod_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_cidrs", value)

    @property
    @pulumi.getter(name="providerID")
    def provider_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_id", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaintArgs']]]]:
        """
        If specified, the node's taints.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def unschedulable(self) -> Optional[pulumi.Input[bool]]:
        """
        Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
        """
        return pulumi.get(self, "unschedulable")

    @unschedulable.setter
    def unschedulable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unschedulable", value)


@pulumi.input_type
class NodeStatusArgs:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input['NodeAddressArgs']]]] = None,
                 allocatable: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 capacity: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NodeConditionArgs']]]] = None,
                 config: Optional[pulumi.Input['NodeConfigStatusArgs']] = None,
                 daemon_endpoints: Optional[pulumi.Input['NodeDaemonEndpointsArgs']] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerImageArgs']]]] = None,
                 node_info: Optional[pulumi.Input['NodeSystemInfoArgs']] = None,
                 phase: Optional[pulumi.Input[str]] = None,
                 volumes_attached: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedVolumeArgs']]]] = None,
                 volumes_in_use: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        NodeStatus is information about the current status of a node.
        :param pulumi.Input[Sequence[pulumi.Input['NodeAddressArgs']]] addresses: List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See http://pr.k8s.io/79391 for an example.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] allocatable: Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] capacity: Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
        :param pulumi.Input[Sequence[pulumi.Input['NodeConditionArgs']]] conditions: Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/concepts/nodes/node/#condition
        :param pulumi.Input['NodeConfigStatusArgs'] config: Status of the config assigned to the node via the dynamic Kubelet config feature.
        :param pulumi.Input['NodeDaemonEndpointsArgs'] daemon_endpoints: Endpoints of daemons running on the Node.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerImageArgs']]] images: List of container images on this node
        :param pulumi.Input['NodeSystemInfoArgs'] node_info: Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#info
        :param pulumi.Input[str] phase: NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.
        :param pulumi.Input[Sequence[pulumi.Input['AttachedVolumeArgs']]] volumes_attached: List of volumes that are attached to the node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] volumes_in_use: List of attachable volumes in use (mounted) by the node.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if allocatable is not None:
            pulumi.set(__self__, "allocatable", allocatable)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if daemon_endpoints is not None:
            pulumi.set(__self__, "daemon_endpoints", daemon_endpoints)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if node_info is not None:
            pulumi.set(__self__, "node_info", node_info)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if volumes_attached is not None:
            pulumi.set(__self__, "volumes_attached", volumes_attached)
        if volumes_in_use is not None:
            pulumi.set(__self__, "volumes_in_use", volumes_in_use)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeAddressArgs']]]]:
        """
        List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See http://pr.k8s.io/79391 for an example.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeAddressArgs']]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def allocatable(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.
        """
        return pulumi.get(self, "allocatable")

    @allocatable.setter
    def allocatable(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "allocatable", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeConditionArgs']]]]:
        """
        Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/concepts/nodes/node/#condition
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['NodeConfigStatusArgs']]:
        """
        Status of the config assigned to the node via the dynamic Kubelet config feature.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['NodeConfigStatusArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="daemonEndpoints")
    def daemon_endpoints(self) -> Optional[pulumi.Input['NodeDaemonEndpointsArgs']]:
        """
        Endpoints of daemons running on the Node.
        """
        return pulumi.get(self, "daemon_endpoints")

    @daemon_endpoints.setter
    def daemon_endpoints(self, value: Optional[pulumi.Input['NodeDaemonEndpointsArgs']]):
        pulumi.set(self, "daemon_endpoints", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerImageArgs']]]]:
        """
        List of container images on this node
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerImageArgs']]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="nodeInfo")
    def node_info(self) -> Optional[pulumi.Input['NodeSystemInfoArgs']]:
        """
        Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#info
        """
        return pulumi.get(self, "node_info")

    @node_info.setter
    def node_info(self, value: Optional[pulumi.Input['NodeSystemInfoArgs']]):
        pulumi.set(self, "node_info", value)

    @property
    @pulumi.getter
    def phase(self) -> Optional[pulumi.Input[str]]:
        """
        NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase", value)

    @property
    @pulumi.getter(name="volumesAttached")
    def volumes_attached(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AttachedVolumeArgs']]]]:
        """
        List of volumes that are attached to the node.
        """
        return pulumi.get(self, "volumes_attached")

    @volumes_attached.setter
    def volumes_attached(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedVolumeArgs']]]]):
        pulumi.set(self, "volumes_attached", value)

    @property
    @pulumi.getter(name="volumesInUse")
    def volumes_in_use(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of attachable volumes in use (mounted) by the node.
        """
        return pulumi.get(self, "volumes_in_use")

    @volumes_in_use.setter
    def volumes_in_use(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "volumes_in_use", value)


@pulumi.input_type
class NodeSystemInfoArgs:
    def __init__(__self__, *,
                 architecture: pulumi.Input[str],
                 boot_id: pulumi.Input[str],
                 container_runtime_version: pulumi.Input[str],
                 kernel_version: pulumi.Input[str],
                 kube_proxy_version: pulumi.Input[str],
                 kubelet_version: pulumi.Input[str],
                 machine_id: pulumi.Input[str],
                 operating_system: pulumi.Input[str],
                 os_image: pulumi.Input[str],
                 system_uuid: pulumi.Input[str]):
        """
        NodeSystemInfo is a set of ids/uuids to uniquely identify the node.
        :param pulumi.Input[str] architecture: The Architecture reported by the node
        :param pulumi.Input[str] boot_id: Boot ID reported by the node.
        :param pulumi.Input[str] container_runtime_version: ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0).
        :param pulumi.Input[str] kernel_version: Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
        :param pulumi.Input[str] kube_proxy_version: KubeProxy Version reported by the node.
        :param pulumi.Input[str] kubelet_version: Kubelet Version reported by the node.
        :param pulumi.Input[str] machine_id: MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
        :param pulumi.Input[str] operating_system: The Operating System reported by the node
        :param pulumi.Input[str] os_image: OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
        :param pulumi.Input[str] system_uuid: SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "boot_id", boot_id)
        pulumi.set(__self__, "container_runtime_version", container_runtime_version)
        pulumi.set(__self__, "kernel_version", kernel_version)
        pulumi.set(__self__, "kube_proxy_version", kube_proxy_version)
        pulumi.set(__self__, "kubelet_version", kubelet_version)
        pulumi.set(__self__, "machine_id", machine_id)
        pulumi.set(__self__, "operating_system", operating_system)
        pulumi.set(__self__, "os_image", os_image)
        pulumi.set(__self__, "system_uuid", system_uuid)

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Input[str]:
        """
        The Architecture reported by the node
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: pulumi.Input[str]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter(name="bootID")
    def boot_id(self) -> pulumi.Input[str]:
        """
        Boot ID reported by the node.
        """
        return pulumi.get(self, "boot_id")

    @boot_id.setter
    def boot_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "boot_id", value)

    @property
    @pulumi.getter(name="containerRuntimeVersion")
    def container_runtime_version(self) -> pulumi.Input[str]:
        """
        ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0).
        """
        return pulumi.get(self, "container_runtime_version")

    @container_runtime_version.setter
    def container_runtime_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_runtime_version", value)

    @property
    @pulumi.getter(name="kernelVersion")
    def kernel_version(self) -> pulumi.Input[str]:
        """
        Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
        """
        return pulumi.get(self, "kernel_version")

    @kernel_version.setter
    def kernel_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "kernel_version", value)

    @property
    @pulumi.getter(name="kubeProxyVersion")
    def kube_proxy_version(self) -> pulumi.Input[str]:
        """
        KubeProxy Version reported by the node.
        """
        return pulumi.get(self, "kube_proxy_version")

    @kube_proxy_version.setter
    def kube_proxy_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "kube_proxy_version", value)

    @property
    @pulumi.getter(name="kubeletVersion")
    def kubelet_version(self) -> pulumi.Input[str]:
        """
        Kubelet Version reported by the node.
        """
        return pulumi.get(self, "kubelet_version")

    @kubelet_version.setter
    def kubelet_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "kubelet_version", value)

    @property
    @pulumi.getter(name="machineID")
    def machine_id(self) -> pulumi.Input[str]:
        """
        MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
        """
        return pulumi.get(self, "machine_id")

    @machine_id.setter
    def machine_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_id", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Input[str]:
        """
        The Operating System reported by the node
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: pulumi.Input[str]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> pulumi.Input[str]:
        """
        OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
        """
        return pulumi.get(self, "os_image")

    @os_image.setter
    def os_image(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_image", value)

    @property
    @pulumi.getter(name="systemUUID")
    def system_uuid(self) -> pulumi.Input[str]:
        """
        SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid
        """
        return pulumi.get(self, "system_uuid")

    @system_uuid.setter
    def system_uuid(self, value: pulumi.Input[str]):
        pulumi.set(self, "system_uuid", value)


@pulumi.input_type
class ObjectFieldSelectorArgs:
    def __init__(__self__, *,
                 field_path: pulumi.Input[str],
                 api_version: Optional[pulumi.Input[str]] = None):
        """
        ObjectFieldSelector selects an APIVersioned field of an object.
        :param pulumi.Input[str] field_path: Path of the field to select in the specified API version.
        :param pulumi.Input[str] api_version: Version of the schema the FieldPath is written in terms of, defaults to "v1".
        """
        pulumi.set(__self__, "field_path", field_path)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)

    @property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> pulumi.Input[str]:
        """
        Path of the field to select in the specified API version.
        """
        return pulumi.get(self, "field_path")

    @field_path.setter
    def field_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "field_path", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the schema the FieldPath is written in terms of, defaults to "v1".
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)


@pulumi.input_type
class ObjectReferenceArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 field_path: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource_version: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        ObjectReference contains enough information to let you inspect or modify the referred object.
        :param pulumi.Input[str] api_version: API version of the referent.
        :param pulumi.Input[str] field_path: If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.
        :param pulumi.Input[str] kind: Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[str] namespace: Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
        :param pulumi.Input[str] resource_version: Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        :param pulumi.Input[str] uid: UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if field_path is not None:
            pulumi.set(__self__, "field_path", field_path)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        API version of the referent.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> Optional[pulumi.Input[str]]:
        """
        If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.
        """
        return pulumi.get(self, "field_path")

    @field_path.setter
    def field_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_path", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class PersistentVolumeArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['PersistentVolumeSpecArgs']] = None,
                 status: Optional[pulumi.Input['PersistentVolumeStatusArgs']] = None):
        """
        PersistentVolume (PV) is a storage resource provisioned by an administrator. It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['PersistentVolumeSpecArgs'] spec: Spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
        :param pulumi.Input['PersistentVolumeStatusArgs'] status: Status represents the current information/status for the persistent volume. Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PersistentVolume')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['PersistentVolumeSpecArgs']]:
        """
        Spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['PersistentVolumeSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['PersistentVolumeStatusArgs']]:
        """
        Status represents the current information/status for the persistent volume. Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['PersistentVolumeStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class PersistentVolumeClaimArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['PersistentVolumeClaimSpecArgs']] = None,
                 status: Optional[pulumi.Input['PersistentVolumeClaimStatusArgs']] = None):
        """
        PersistentVolumeClaim is a user's request for and claim to a persistent volume
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['PersistentVolumeClaimSpecArgs'] spec: Spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        :param pulumi.Input['PersistentVolumeClaimStatusArgs'] status: Status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PersistentVolumeClaim')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['PersistentVolumeClaimSpecArgs']]:
        """
        Spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['PersistentVolumeClaimSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['PersistentVolumeClaimStatusArgs']]:
        """
        Status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['PersistentVolumeClaimStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class PersistentVolumeClaimConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 type: pulumi.Input[str],
                 last_probe_time: Optional[pulumi.Input[str]] = None,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        PersistentVolumeClaimCondition contails details about state of pvc
        :param pulumi.Input[str] last_probe_time: Last time we probed the condition.
        :param pulumi.Input[str] last_transition_time: Last time the condition transitioned from one status to another.
        :param pulumi.Input[str] message: Human-readable message indicating details about last transition.
        :param pulumi.Input[str] reason: Unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports "ResizeStarted" that means the underlying persistent volume is being resized.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_probe_time is not None:
            pulumi.set(__self__, "last_probe_time", last_probe_time)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastProbeTime")
    def last_probe_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time we probed the condition.
        """
        return pulumi.get(self, "last_probe_time")

    @last_probe_time.setter
    def last_probe_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_probe_time", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports "ResizeStarted" that means the underlying persistent volume is being resized.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class PersistentVolumeClaimSpecArgs:
    def __init__(__self__, *,
                 access_modes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_source: Optional[pulumi.Input['TypedLocalObjectReferenceArgs']] = None,
                 resources: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None,
                 storage_class_name: Optional[pulumi.Input[str]] = None,
                 volume_mode: Optional[pulumi.Input[str]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None):
        """
        PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes
        :param pulumi.Input[Sequence[pulumi.Input[str]]] access_modes: AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        :param pulumi.Input['TypedLocalObjectReferenceArgs'] data_source: This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source.
        :param pulumi.Input['ResourceRequirementsArgs'] resources: Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] selector: A label query over volumes to consider for binding.
        :param pulumi.Input[str] storage_class_name: Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
        :param pulumi.Input[str] volume_mode: volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.
        :param pulumi.Input[str] volume_name: VolumeName is the binding reference to the PersistentVolume backing this claim.
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if storage_class_name is not None:
            pulumi.set(__self__, "storage_class_name", storage_class_name)
        if volume_mode is not None:
            pulumi.set(__self__, "volume_mode", volume_mode)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        """
        return pulumi.get(self, "access_modes")

    @access_modes.setter
    def access_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "access_modes", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input['TypedLocalObjectReferenceArgs']]:
        """
        This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input['TypedLocalObjectReferenceArgs']]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        A label query over volumes to consider for binding.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="storageClassName")
    def storage_class_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
        """
        return pulumi.get(self, "storage_class_name")

    @storage_class_name.setter
    def storage_class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class_name", value)

    @property
    @pulumi.getter(name="volumeMode")
    def volume_mode(self) -> Optional[pulumi.Input[str]]:
        """
        volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.
        """
        return pulumi.get(self, "volume_mode")

    @volume_mode.setter
    def volume_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_mode", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[str]]:
        """
        VolumeName is the binding reference to the PersistentVolume backing this claim.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_name", value)


@pulumi.input_type
class PersistentVolumeClaimStatusArgs:
    def __init__(__self__, *,
                 access_modes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 capacity: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['PersistentVolumeClaimConditionArgs']]]] = None,
                 phase: Optional[pulumi.Input[str]] = None):
        """
        PersistentVolumeClaimStatus is the current status of a persistent volume claim.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] access_modes: AccessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] capacity: Represents the actual resources of the underlying volume.
        :param pulumi.Input[Sequence[pulumi.Input['PersistentVolumeClaimConditionArgs']]] conditions: Current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'ResizeStarted'.
        :param pulumi.Input[str] phase: Phase represents the current phase of PersistentVolumeClaim.
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)

    @property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AccessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        """
        return pulumi.get(self, "access_modes")

    @access_modes.setter
    def access_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "access_modes", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Represents the actual resources of the underlying volume.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PersistentVolumeClaimConditionArgs']]]]:
        """
        Current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'ResizeStarted'.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PersistentVolumeClaimConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def phase(self) -> Optional[pulumi.Input[str]]:
        """
        Phase represents the current phase of PersistentVolumeClaim.
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase", value)


@pulumi.input_type
class PersistentVolumeClaimTemplateArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['PersistentVolumeClaimSpecArgs'],
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects as part of an EphemeralVolumeSource.
        :param pulumi.Input['PersistentVolumeClaimSpecArgs'] spec: The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        pulumi.set(__self__, "spec", spec)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['PersistentVolumeClaimSpecArgs']:
        """
        The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['PersistentVolumeClaimSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class PersistentVolumeClaimVolumeSourceArgs:
    def __init__(__self__, *,
                 claim_name: pulumi.Input[str],
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).
        :param pulumi.Input[str] claim_name: ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        :param pulumi.Input[bool] read_only: Will force the ReadOnly setting in VolumeMounts. Default false.
        """
        pulumi.set(__self__, "claim_name", claim_name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="claimName")
    def claim_name(self) -> pulumi.Input[str]:
        """
        ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "claim_name")

    @claim_name.setter
    def claim_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "claim_name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Will force the ReadOnly setting in VolumeMounts. Default false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class PersistentVolumeSpecArgs:
    def __init__(__self__, *,
                 access_modes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 aws_elastic_block_store: Optional[pulumi.Input['AWSElasticBlockStoreVolumeSourceArgs']] = None,
                 azure_disk: Optional[pulumi.Input['AzureDiskVolumeSourceArgs']] = None,
                 azure_file: Optional[pulumi.Input['AzureFilePersistentVolumeSourceArgs']] = None,
                 capacity: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cephfs: Optional[pulumi.Input['CephFSPersistentVolumeSourceArgs']] = None,
                 cinder: Optional[pulumi.Input['CinderPersistentVolumeSourceArgs']] = None,
                 claim_ref: Optional[pulumi.Input['ObjectReferenceArgs']] = None,
                 csi: Optional[pulumi.Input['CSIPersistentVolumeSourceArgs']] = None,
                 fc: Optional[pulumi.Input['FCVolumeSourceArgs']] = None,
                 flex_volume: Optional[pulumi.Input['FlexPersistentVolumeSourceArgs']] = None,
                 flocker: Optional[pulumi.Input['FlockerVolumeSourceArgs']] = None,
                 gce_persistent_disk: Optional[pulumi.Input['GCEPersistentDiskVolumeSourceArgs']] = None,
                 glusterfs: Optional[pulumi.Input['GlusterfsPersistentVolumeSourceArgs']] = None,
                 host_path: Optional[pulumi.Input['HostPathVolumeSourceArgs']] = None,
                 iscsi: Optional[pulumi.Input['ISCSIPersistentVolumeSourceArgs']] = None,
                 local: Optional[pulumi.Input['LocalVolumeSourceArgs']] = None,
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 nfs: Optional[pulumi.Input['NFSVolumeSourceArgs']] = None,
                 node_affinity: Optional[pulumi.Input['VolumeNodeAffinityArgs']] = None,
                 persistent_volume_reclaim_policy: Optional[pulumi.Input[str]] = None,
                 photon_persistent_disk: Optional[pulumi.Input['PhotonPersistentDiskVolumeSourceArgs']] = None,
                 portworx_volume: Optional[pulumi.Input['PortworxVolumeSourceArgs']] = None,
                 quobyte: Optional[pulumi.Input['QuobyteVolumeSourceArgs']] = None,
                 rbd: Optional[pulumi.Input['RBDPersistentVolumeSourceArgs']] = None,
                 scale_io: Optional[pulumi.Input['ScaleIOPersistentVolumeSourceArgs']] = None,
                 storage_class_name: Optional[pulumi.Input[str]] = None,
                 storageos: Optional[pulumi.Input['StorageOSPersistentVolumeSourceArgs']] = None,
                 volume_mode: Optional[pulumi.Input[str]] = None,
                 vsphere_volume: Optional[pulumi.Input['VsphereVirtualDiskVolumeSourceArgs']] = None):
        """
        PersistentVolumeSpec is the specification of a persistent volume.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] access_modes: AccessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        :param pulumi.Input['AWSElasticBlockStoreVolumeSourceArgs'] aws_elastic_block_store: AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param pulumi.Input['AzureDiskVolumeSourceArgs'] azure_disk: AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
        :param pulumi.Input['AzureFilePersistentVolumeSourceArgs'] azure_file: AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] capacity: A description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
        :param pulumi.Input['CephFSPersistentVolumeSourceArgs'] cephfs: CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
        :param pulumi.Input['CinderPersistentVolumeSourceArgs'] cinder: Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param pulumi.Input['ObjectReferenceArgs'] claim_ref: ClaimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        :param pulumi.Input['CSIPersistentVolumeSourceArgs'] csi: CSI represents storage that is handled by an external CSI driver (Beta feature).
        :param pulumi.Input['FCVolumeSourceArgs'] fc: FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
        :param pulumi.Input['FlexPersistentVolumeSourceArgs'] flex_volume: FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
        :param pulumi.Input['FlockerVolumeSourceArgs'] flocker: Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running
        :param pulumi.Input['GCEPersistentDiskVolumeSourceArgs'] gce_persistent_disk: GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param pulumi.Input['GlusterfsPersistentVolumeSourceArgs'] glusterfs: Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: https://examples.k8s.io/volumes/glusterfs/README.md
        :param pulumi.Input['HostPathVolumeSourceArgs'] host_path: HostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        :param pulumi.Input['ISCSIPersistentVolumeSourceArgs'] iscsi: ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.
        :param pulumi.Input['LocalVolumeSourceArgs'] local: Local represents directly-attached storage with node affinity
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        :param pulumi.Input['NFSVolumeSourceArgs'] nfs: NFS represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        :param pulumi.Input['VolumeNodeAffinityArgs'] node_affinity: NodeAffinity defines constraints that limit what nodes this volume can be accessed from. This field influences the scheduling of pods that use this volume.
        :param pulumi.Input[str] persistent_volume_reclaim_policy: What happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        :param pulumi.Input['PhotonPersistentDiskVolumeSourceArgs'] photon_persistent_disk: PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
        :param pulumi.Input['PortworxVolumeSourceArgs'] portworx_volume: PortworxVolume represents a portworx volume attached and mounted on kubelets host machine
        :param pulumi.Input['QuobyteVolumeSourceArgs'] quobyte: Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
        :param pulumi.Input['RBDPersistentVolumeSourceArgs'] rbd: RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
        :param pulumi.Input['ScaleIOPersistentVolumeSourceArgs'] scale_io: ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
        :param pulumi.Input[str] storage_class_name: Name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.
        :param pulumi.Input['StorageOSPersistentVolumeSourceArgs'] storageos: StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://examples.k8s.io/volumes/storageos/README.md
        :param pulumi.Input[str] volume_mode: volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec.
        :param pulumi.Input['VsphereVirtualDiskVolumeSourceArgs'] vsphere_volume: VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if aws_elastic_block_store is not None:
            pulumi.set(__self__, "aws_elastic_block_store", aws_elastic_block_store)
        if azure_disk is not None:
            pulumi.set(__self__, "azure_disk", azure_disk)
        if azure_file is not None:
            pulumi.set(__self__, "azure_file", azure_file)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if cephfs is not None:
            pulumi.set(__self__, "cephfs", cephfs)
        if cinder is not None:
            pulumi.set(__self__, "cinder", cinder)
        if claim_ref is not None:
            pulumi.set(__self__, "claim_ref", claim_ref)
        if csi is not None:
            pulumi.set(__self__, "csi", csi)
        if fc is not None:
            pulumi.set(__self__, "fc", fc)
        if flex_volume is not None:
            pulumi.set(__self__, "flex_volume", flex_volume)
        if flocker is not None:
            pulumi.set(__self__, "flocker", flocker)
        if gce_persistent_disk is not None:
            pulumi.set(__self__, "gce_persistent_disk", gce_persistent_disk)
        if glusterfs is not None:
            pulumi.set(__self__, "glusterfs", glusterfs)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if iscsi is not None:
            pulumi.set(__self__, "iscsi", iscsi)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if node_affinity is not None:
            pulumi.set(__self__, "node_affinity", node_affinity)
        if persistent_volume_reclaim_policy is not None:
            pulumi.set(__self__, "persistent_volume_reclaim_policy", persistent_volume_reclaim_policy)
        if photon_persistent_disk is not None:
            pulumi.set(__self__, "photon_persistent_disk", photon_persistent_disk)
        if portworx_volume is not None:
            pulumi.set(__self__, "portworx_volume", portworx_volume)
        if quobyte is not None:
            pulumi.set(__self__, "quobyte", quobyte)
        if rbd is not None:
            pulumi.set(__self__, "rbd", rbd)
        if scale_io is not None:
            pulumi.set(__self__, "scale_io", scale_io)
        if storage_class_name is not None:
            pulumi.set(__self__, "storage_class_name", storage_class_name)
        if storageos is not None:
            pulumi.set(__self__, "storageos", storageos)
        if volume_mode is not None:
            pulumi.set(__self__, "volume_mode", volume_mode)
        if vsphere_volume is not None:
            pulumi.set(__self__, "vsphere_volume", vsphere_volume)

    @property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AccessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        """
        return pulumi.get(self, "access_modes")

    @access_modes.setter
    def access_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "access_modes", value)

    @property
    @pulumi.getter(name="awsElasticBlockStore")
    def aws_elastic_block_store(self) -> Optional[pulumi.Input['AWSElasticBlockStoreVolumeSourceArgs']]:
        """
        AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "aws_elastic_block_store")

    @aws_elastic_block_store.setter
    def aws_elastic_block_store(self, value: Optional[pulumi.Input['AWSElasticBlockStoreVolumeSourceArgs']]):
        pulumi.set(self, "aws_elastic_block_store", value)

    @property
    @pulumi.getter(name="azureDisk")
    def azure_disk(self) -> Optional[pulumi.Input['AzureDiskVolumeSourceArgs']]:
        """
        AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
        """
        return pulumi.get(self, "azure_disk")

    @azure_disk.setter
    def azure_disk(self, value: Optional[pulumi.Input['AzureDiskVolumeSourceArgs']]):
        pulumi.set(self, "azure_disk", value)

    @property
    @pulumi.getter(name="azureFile")
    def azure_file(self) -> Optional[pulumi.Input['AzureFilePersistentVolumeSourceArgs']]:
        """
        AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
        """
        return pulumi.get(self, "azure_file")

    @azure_file.setter
    def azure_file(self, value: Optional[pulumi.Input['AzureFilePersistentVolumeSourceArgs']]):
        pulumi.set(self, "azure_file", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def cephfs(self) -> Optional[pulumi.Input['CephFSPersistentVolumeSourceArgs']]:
        """
        CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
        """
        return pulumi.get(self, "cephfs")

    @cephfs.setter
    def cephfs(self, value: Optional[pulumi.Input['CephFSPersistentVolumeSourceArgs']]):
        pulumi.set(self, "cephfs", value)

    @property
    @pulumi.getter
    def cinder(self) -> Optional[pulumi.Input['CinderPersistentVolumeSourceArgs']]:
        """
        Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "cinder")

    @cinder.setter
    def cinder(self, value: Optional[pulumi.Input['CinderPersistentVolumeSourceArgs']]):
        pulumi.set(self, "cinder", value)

    @property
    @pulumi.getter(name="claimRef")
    def claim_ref(self) -> Optional[pulumi.Input['ObjectReferenceArgs']]:
        """
        ClaimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        """
        return pulumi.get(self, "claim_ref")

    @claim_ref.setter
    def claim_ref(self, value: Optional[pulumi.Input['ObjectReferenceArgs']]):
        pulumi.set(self, "claim_ref", value)

    @property
    @pulumi.getter
    def csi(self) -> Optional[pulumi.Input['CSIPersistentVolumeSourceArgs']]:
        """
        CSI represents storage that is handled by an external CSI driver (Beta feature).
        """
        return pulumi.get(self, "csi")

    @csi.setter
    def csi(self, value: Optional[pulumi.Input['CSIPersistentVolumeSourceArgs']]):
        pulumi.set(self, "csi", value)

    @property
    @pulumi.getter
    def fc(self) -> Optional[pulumi.Input['FCVolumeSourceArgs']]:
        """
        FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
        """
        return pulumi.get(self, "fc")

    @fc.setter
    def fc(self, value: Optional[pulumi.Input['FCVolumeSourceArgs']]):
        pulumi.set(self, "fc", value)

    @property
    @pulumi.getter(name="flexVolume")
    def flex_volume(self) -> Optional[pulumi.Input['FlexPersistentVolumeSourceArgs']]:
        """
        FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
        """
        return pulumi.get(self, "flex_volume")

    @flex_volume.setter
    def flex_volume(self, value: Optional[pulumi.Input['FlexPersistentVolumeSourceArgs']]):
        pulumi.set(self, "flex_volume", value)

    @property
    @pulumi.getter
    def flocker(self) -> Optional[pulumi.Input['FlockerVolumeSourceArgs']]:
        """
        Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running
        """
        return pulumi.get(self, "flocker")

    @flocker.setter
    def flocker(self, value: Optional[pulumi.Input['FlockerVolumeSourceArgs']]):
        pulumi.set(self, "flocker", value)

    @property
    @pulumi.getter(name="gcePersistentDisk")
    def gce_persistent_disk(self) -> Optional[pulumi.Input['GCEPersistentDiskVolumeSourceArgs']]:
        """
        GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "gce_persistent_disk")

    @gce_persistent_disk.setter
    def gce_persistent_disk(self, value: Optional[pulumi.Input['GCEPersistentDiskVolumeSourceArgs']]):
        pulumi.set(self, "gce_persistent_disk", value)

    @property
    @pulumi.getter
    def glusterfs(self) -> Optional[pulumi.Input['GlusterfsPersistentVolumeSourceArgs']]:
        """
        Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: https://examples.k8s.io/volumes/glusterfs/README.md
        """
        return pulumi.get(self, "glusterfs")

    @glusterfs.setter
    def glusterfs(self, value: Optional[pulumi.Input['GlusterfsPersistentVolumeSourceArgs']]):
        pulumi.set(self, "glusterfs", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input['HostPathVolumeSourceArgs']]:
        """
        HostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input['HostPathVolumeSourceArgs']]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter
    def iscsi(self) -> Optional[pulumi.Input['ISCSIPersistentVolumeSourceArgs']]:
        """
        ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.
        """
        return pulumi.get(self, "iscsi")

    @iscsi.setter
    def iscsi(self, value: Optional[pulumi.Input['ISCSIPersistentVolumeSourceArgs']]):
        pulumi.set(self, "iscsi", value)

    @property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input['LocalVolumeSourceArgs']]:
        """
        Local represents directly-attached storage with node affinity
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input['LocalVolumeSourceArgs']]):
        pulumi.set(self, "local", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter
    def nfs(self) -> Optional[pulumi.Input['NFSVolumeSourceArgs']]:
        """
        NFS represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "nfs")

    @nfs.setter
    def nfs(self, value: Optional[pulumi.Input['NFSVolumeSourceArgs']]):
        pulumi.set(self, "nfs", value)

    @property
    @pulumi.getter(name="nodeAffinity")
    def node_affinity(self) -> Optional[pulumi.Input['VolumeNodeAffinityArgs']]:
        """
        NodeAffinity defines constraints that limit what nodes this volume can be accessed from. This field influences the scheduling of pods that use this volume.
        """
        return pulumi.get(self, "node_affinity")

    @node_affinity.setter
    def node_affinity(self, value: Optional[pulumi.Input['VolumeNodeAffinityArgs']]):
        pulumi.set(self, "node_affinity", value)

    @property
    @pulumi.getter(name="persistentVolumeReclaimPolicy")
    def persistent_volume_reclaim_policy(self) -> Optional[pulumi.Input[str]]:
        """
        What happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        """
        return pulumi.get(self, "persistent_volume_reclaim_policy")

    @persistent_volume_reclaim_policy.setter
    def persistent_volume_reclaim_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "persistent_volume_reclaim_policy", value)

    @property
    @pulumi.getter(name="photonPersistentDisk")
    def photon_persistent_disk(self) -> Optional[pulumi.Input['PhotonPersistentDiskVolumeSourceArgs']]:
        """
        PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
        """
        return pulumi.get(self, "photon_persistent_disk")

    @photon_persistent_disk.setter
    def photon_persistent_disk(self, value: Optional[pulumi.Input['PhotonPersistentDiskVolumeSourceArgs']]):
        pulumi.set(self, "photon_persistent_disk", value)

    @property
    @pulumi.getter(name="portworxVolume")
    def portworx_volume(self) -> Optional[pulumi.Input['PortworxVolumeSourceArgs']]:
        """
        PortworxVolume represents a portworx volume attached and mounted on kubelets host machine
        """
        return pulumi.get(self, "portworx_volume")

    @portworx_volume.setter
    def portworx_volume(self, value: Optional[pulumi.Input['PortworxVolumeSourceArgs']]):
        pulumi.set(self, "portworx_volume", value)

    @property
    @pulumi.getter
    def quobyte(self) -> Optional[pulumi.Input['QuobyteVolumeSourceArgs']]:
        """
        Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
        """
        return pulumi.get(self, "quobyte")

    @quobyte.setter
    def quobyte(self, value: Optional[pulumi.Input['QuobyteVolumeSourceArgs']]):
        pulumi.set(self, "quobyte", value)

    @property
    @pulumi.getter
    def rbd(self) -> Optional[pulumi.Input['RBDPersistentVolumeSourceArgs']]:
        """
        RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
        """
        return pulumi.get(self, "rbd")

    @rbd.setter
    def rbd(self, value: Optional[pulumi.Input['RBDPersistentVolumeSourceArgs']]):
        pulumi.set(self, "rbd", value)

    @property
    @pulumi.getter(name="scaleIO")
    def scale_io(self) -> Optional[pulumi.Input['ScaleIOPersistentVolumeSourceArgs']]:
        """
        ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
        """
        return pulumi.get(self, "scale_io")

    @scale_io.setter
    def scale_io(self, value: Optional[pulumi.Input['ScaleIOPersistentVolumeSourceArgs']]):
        pulumi.set(self, "scale_io", value)

    @property
    @pulumi.getter(name="storageClassName")
    def storage_class_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.
        """
        return pulumi.get(self, "storage_class_name")

    @storage_class_name.setter
    def storage_class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class_name", value)

    @property
    @pulumi.getter
    def storageos(self) -> Optional[pulumi.Input['StorageOSPersistentVolumeSourceArgs']]:
        """
        StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://examples.k8s.io/volumes/storageos/README.md
        """
        return pulumi.get(self, "storageos")

    @storageos.setter
    def storageos(self, value: Optional[pulumi.Input['StorageOSPersistentVolumeSourceArgs']]):
        pulumi.set(self, "storageos", value)

    @property
    @pulumi.getter(name="volumeMode")
    def volume_mode(self) -> Optional[pulumi.Input[str]]:
        """
        volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec.
        """
        return pulumi.get(self, "volume_mode")

    @volume_mode.setter
    def volume_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_mode", value)

    @property
    @pulumi.getter(name="vsphereVolume")
    def vsphere_volume(self) -> Optional[pulumi.Input['VsphereVirtualDiskVolumeSourceArgs']]:
        """
        VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
        """
        return pulumi.get(self, "vsphere_volume")

    @vsphere_volume.setter
    def vsphere_volume(self, value: Optional[pulumi.Input['VsphereVirtualDiskVolumeSourceArgs']]):
        pulumi.set(self, "vsphere_volume", value)


@pulumi.input_type
class PersistentVolumeStatusArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[str]] = None,
                 phase: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        PersistentVolumeStatus is the current status of a persistent volume.
        :param pulumi.Input[str] message: A human-readable message indicating details about why the volume is in this state.
        :param pulumi.Input[str] phase: Phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
        :param pulumi.Input[str] reason: Reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable message indicating details about why the volume is in this state.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def phase(self) -> Optional[pulumi.Input[str]]:
        """
        Phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class PhotonPersistentDiskVolumeSourceArgs:
    def __init__(__self__, *,
                 pd_id: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None):
        """
        Represents a Photon Controller persistent disk resource.
        :param pulumi.Input[str] pd_id: ID that identifies Photon Controller persistent disk
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        pulumi.set(__self__, "pd_id", pd_id)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)

    @property
    @pulumi.getter(name="pdID")
    def pd_id(self) -> pulumi.Input[str]:
        """
        ID that identifies Photon Controller persistent disk
        """
        return pulumi.get(self, "pd_id")

    @pd_id.setter
    def pd_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "pd_id", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)


@pulumi.input_type
class PodArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['PodSpecArgs']] = None,
                 status: Optional[pulumi.Input['PodStatusArgs']] = None):
        """
        Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The Pod is scheduled ("PodScheduled"" '.status.condition' is true).
        2. The Pod is initialized ("Initialized" '.status.condition' is true).
        3. The Pod is ready ("Ready" '.status.condition' is true) and the '.status.phase' is
           set to "Running".
        Or (for Jobs): The Pod succeeded ('.status.phase' set to "Succeeded").

        If the Pod has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['PodSpecArgs'] spec: Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['PodStatusArgs'] status: Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Pod')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['PodSpecArgs']]:
        """
        Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['PodSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['PodStatusArgs']]:
        """
        Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['PodStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class PodAffinityArgs:
    def __init__(__self__, *,
                 preferred_during_scheduling_ignored_during_execution: Optional[pulumi.Input[Sequence[pulumi.Input['WeightedPodAffinityTermArgs']]]] = None,
                 required_during_scheduling_ignored_during_execution: Optional[pulumi.Input[Sequence[pulumi.Input['PodAffinityTermArgs']]]] = None):
        """
        Pod affinity is a group of inter pod affinity scheduling rules.
        :param pulumi.Input[Sequence[pulumi.Input['WeightedPodAffinityTermArgs']]] preferred_during_scheduling_ignored_during_execution: The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
        :param pulumi.Input[Sequence[pulumi.Input['PodAffinityTermArgs']]] required_during_scheduling_ignored_during_execution: If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
        """
        if preferred_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "preferred_during_scheduling_ignored_during_execution", preferred_during_scheduling_ignored_during_execution)
        if required_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "required_during_scheduling_ignored_during_execution", required_during_scheduling_ignored_during_execution)

    @property
    @pulumi.getter(name="preferredDuringSchedulingIgnoredDuringExecution")
    def preferred_during_scheduling_ignored_during_execution(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WeightedPodAffinityTermArgs']]]]:
        """
        The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
        """
        return pulumi.get(self, "preferred_during_scheduling_ignored_during_execution")

    @preferred_during_scheduling_ignored_during_execution.setter
    def preferred_during_scheduling_ignored_during_execution(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WeightedPodAffinityTermArgs']]]]):
        pulumi.set(self, "preferred_during_scheduling_ignored_during_execution", value)

    @property
    @pulumi.getter(name="requiredDuringSchedulingIgnoredDuringExecution")
    def required_during_scheduling_ignored_during_execution(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PodAffinityTermArgs']]]]:
        """
        If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
        """
        return pulumi.get(self, "required_during_scheduling_ignored_during_execution")

    @required_during_scheduling_ignored_during_execution.setter
    def required_during_scheduling_ignored_during_execution(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PodAffinityTermArgs']]]]):
        pulumi.set(self, "required_during_scheduling_ignored_during_execution", value)


@pulumi.input_type
class PodAffinityTermArgs:
    def __init__(__self__, *,
                 topology_key: pulumi.Input[str],
                 label_selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None,
                 namespace_selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running
        :param pulumi.Input[str] topology_key: This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] label_selector: A label query over a set of resources, in this case pods.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] namespace_selector: A label query over the set of namespaces that the term applies to. The term is applied to the union of the namespaces selected by this field and the ones listed in the namespaces field. null selector and null or empty namespaces list means "this pod's namespace". An empty selector ({}) matches all namespaces. This field is alpha-level and is only honored when PodAffinityNamespaceSelector feature is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: namespaces specifies a static list of namespace names that the term applies to. The term is applied to the union of the namespaces listed in this field and the ones selected by namespaceSelector. null or empty namespaces list and null namespaceSelector means "this pod's namespace"
        """
        pulumi.set(__self__, "topology_key", topology_key)
        if label_selector is not None:
            pulumi.set(__self__, "label_selector", label_selector)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter(name="topologyKey")
    def topology_key(self) -> pulumi.Input[str]:
        """
        This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.
        """
        return pulumi.get(self, "topology_key")

    @topology_key.setter
    def topology_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "topology_key", value)

    @property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        A label query over a set of resources, in this case pods.
        """
        return pulumi.get(self, "label_selector")

    @label_selector.setter
    def label_selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "label_selector", value)

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        A label query over the set of namespaces that the term applies to. The term is applied to the union of the namespaces selected by this field and the ones listed in the namespaces field. null selector and null or empty namespaces list means "this pod's namespace". An empty selector ({}) matches all namespaces. This field is alpha-level and is only honored when PodAffinityNamespaceSelector feature is enabled.
        """
        return pulumi.get(self, "namespace_selector")

    @namespace_selector.setter
    def namespace_selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "namespace_selector", value)

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        namespaces specifies a static list of namespace names that the term applies to. The term is applied to the union of the namespaces listed in this field and the ones selected by namespaceSelector. null or empty namespaces list and null namespaceSelector means "this pod's namespace"
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "namespaces", value)


@pulumi.input_type
class PodAntiAffinityArgs:
    def __init__(__self__, *,
                 preferred_during_scheduling_ignored_during_execution: Optional[pulumi.Input[Sequence[pulumi.Input['WeightedPodAffinityTermArgs']]]] = None,
                 required_during_scheduling_ignored_during_execution: Optional[pulumi.Input[Sequence[pulumi.Input['PodAffinityTermArgs']]]] = None):
        """
        Pod anti affinity is a group of inter pod anti affinity scheduling rules.
        :param pulumi.Input[Sequence[pulumi.Input['WeightedPodAffinityTermArgs']]] preferred_during_scheduling_ignored_during_execution: The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
        :param pulumi.Input[Sequence[pulumi.Input['PodAffinityTermArgs']]] required_during_scheduling_ignored_during_execution: If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
        """
        if preferred_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "preferred_during_scheduling_ignored_during_execution", preferred_during_scheduling_ignored_during_execution)
        if required_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "required_during_scheduling_ignored_during_execution", required_during_scheduling_ignored_during_execution)

    @property
    @pulumi.getter(name="preferredDuringSchedulingIgnoredDuringExecution")
    def preferred_during_scheduling_ignored_during_execution(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WeightedPodAffinityTermArgs']]]]:
        """
        The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
        """
        return pulumi.get(self, "preferred_during_scheduling_ignored_during_execution")

    @preferred_during_scheduling_ignored_during_execution.setter
    def preferred_during_scheduling_ignored_during_execution(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WeightedPodAffinityTermArgs']]]]):
        pulumi.set(self, "preferred_during_scheduling_ignored_during_execution", value)

    @property
    @pulumi.getter(name="requiredDuringSchedulingIgnoredDuringExecution")
    def required_during_scheduling_ignored_during_execution(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PodAffinityTermArgs']]]]:
        """
        If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
        """
        return pulumi.get(self, "required_during_scheduling_ignored_during_execution")

    @required_during_scheduling_ignored_during_execution.setter
    def required_during_scheduling_ignored_during_execution(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PodAffinityTermArgs']]]]):
        pulumi.set(self, "required_during_scheduling_ignored_during_execution", value)


@pulumi.input_type
class PodConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 type: pulumi.Input[str],
                 last_probe_time: Optional[pulumi.Input[str]] = None,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        PodCondition contains details for the current condition of this pod.
        :param pulumi.Input[str] status: Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
        :param pulumi.Input[str] type: Type is the type of the condition. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
        :param pulumi.Input[str] last_probe_time: Last time we probed the condition.
        :param pulumi.Input[str] last_transition_time: Last time the condition transitioned from one status to another.
        :param pulumi.Input[str] message: Human-readable message indicating details about last transition.
        :param pulumi.Input[str] reason: Unique, one-word, CamelCase reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_probe_time is not None:
            pulumi.set(__self__, "last_probe_time", last_probe_time)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type is the type of the condition. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastProbeTime")
    def last_probe_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time we probed the condition.
        """
        return pulumi.get(self, "last_probe_time")

    @last_probe_time.setter
    def last_probe_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_probe_time", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class PodDNSConfigArgs:
    def __init__(__self__, *,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['PodDNSConfigOptionArgs']]]] = None,
                 searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nameservers: A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
        :param pulumi.Input[Sequence[pulumi.Input['PodDNSConfigOptionArgs']]] options: A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] searches: A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
        """
        if nameservers is not None:
            pulumi.set(__self__, "nameservers", nameservers)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if searches is not None:
            pulumi.set(__self__, "searches", searches)

    @property
    @pulumi.getter
    def nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
        """
        return pulumi.get(self, "nameservers")

    @nameservers.setter
    def nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nameservers", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PodDNSConfigOptionArgs']]]]:
        """
        A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PodDNSConfigOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def searches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
        """
        return pulumi.get(self, "searches")

    @searches.setter
    def searches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "searches", value)


@pulumi.input_type
class PodDNSConfigOptionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        PodDNSConfigOption defines DNS resolver options of a pod.
        :param pulumi.Input[str] name: Required.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PodIPArgs:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input[str]] = None):
        """
        IP address information for entries in the (plural) PodIPs field. Each entry includes:
           IP: An IP address allocated to the pod. Routable at least within the cluster.
        :param pulumi.Input[str] ip: ip is an IP address (IPv4 or IPv6) assigned to the pod
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        ip is an IP address (IPv4 or IPv6) assigned to the pod
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class PodReadinessGateArgs:
    def __init__(__self__, *,
                 condition_type: pulumi.Input[str]):
        """
        PodReadinessGate contains the reference to a pod condition
        :param pulumi.Input[str] condition_type: ConditionType refers to a condition in the pod's condition list with matching type.
        """
        pulumi.set(__self__, "condition_type", condition_type)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Input[str]:
        """
        ConditionType refers to a condition in the pod's condition list with matching type.
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition_type", value)


@pulumi.input_type
class PodSecurityContextArgs:
    def __init__(__self__, *,
                 fs_group: Optional[pulumi.Input[int]] = None,
                 fs_group_change_policy: Optional[pulumi.Input[str]] = None,
                 run_as_group: Optional[pulumi.Input[int]] = None,
                 run_as_non_root: Optional[pulumi.Input[bool]] = None,
                 run_as_user: Optional[pulumi.Input[int]] = None,
                 se_linux_options: Optional[pulumi.Input['SELinuxOptionsArgs']] = None,
                 seccomp_profile: Optional[pulumi.Input['SeccompProfileArgs']] = None,
                 supplemental_groups: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 sysctls: Optional[pulumi.Input[Sequence[pulumi.Input['SysctlArgs']]]] = None,
                 windows_options: Optional[pulumi.Input['WindowsSecurityContextOptionsArgs']] = None):
        """
        PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext.
        :param pulumi.Input[int] fs_group: A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:
               
               1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----
               
               If unset, the Kubelet will not modify the ownership and permissions of any volume.
        :param pulumi.Input[str] fs_group_change_policy: fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are "OnRootMismatch" and "Always". If not specified, "Always" is used.
        :param pulumi.Input[int] run_as_group: The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
        :param pulumi.Input[bool] run_as_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        :param pulumi.Input[int] run_as_user: The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
        :param pulumi.Input['SELinuxOptionsArgs'] se_linux_options: The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
        :param pulumi.Input['SeccompProfileArgs'] seccomp_profile: The seccomp options to use by the containers in this pod.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] supplemental_groups: A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.
        :param pulumi.Input[Sequence[pulumi.Input['SysctlArgs']]] sysctls: Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch.
        :param pulumi.Input['WindowsSecurityContextOptionsArgs'] windows_options: The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        if fs_group is not None:
            pulumi.set(__self__, "fs_group", fs_group)
        if fs_group_change_policy is not None:
            pulumi.set(__self__, "fs_group_change_policy", fs_group_change_policy)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_non_root is not None:
            pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if se_linux_options is not None:
            pulumi.set(__self__, "se_linux_options", se_linux_options)
        if seccomp_profile is not None:
            pulumi.set(__self__, "seccomp_profile", seccomp_profile)
        if supplemental_groups is not None:
            pulumi.set(__self__, "supplemental_groups", supplemental_groups)
        if sysctls is not None:
            pulumi.set(__self__, "sysctls", sysctls)
        if windows_options is not None:
            pulumi.set(__self__, "windows_options", windows_options)

    @property
    @pulumi.getter(name="fsGroup")
    def fs_group(self) -> Optional[pulumi.Input[int]]:
        """
        A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:

        1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----

        If unset, the Kubelet will not modify the ownership and permissions of any volume.
        """
        return pulumi.get(self, "fs_group")

    @fs_group.setter
    def fs_group(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fs_group", value)

    @property
    @pulumi.getter(name="fsGroupChangePolicy")
    def fs_group_change_policy(self) -> Optional[pulumi.Input[str]]:
        """
        fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are "OnRootMismatch" and "Always". If not specified, "Always" is used.
        """
        return pulumi.get(self, "fs_group_change_policy")

    @fs_group_change_policy.setter
    def fs_group_change_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_group_change_policy", value)

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[pulumi.Input[int]]:
        """
        The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
        """
        return pulumi.get(self, "run_as_group")

    @run_as_group.setter
    def run_as_group(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_group", value)

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        return pulumi.get(self, "run_as_non_root")

    @run_as_non_root.setter
    def run_as_non_root(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "run_as_non_root", value)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[int]]:
        """
        The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_user", value)

    @property
    @pulumi.getter(name="seLinuxOptions")
    def se_linux_options(self) -> Optional[pulumi.Input['SELinuxOptionsArgs']]:
        """
        The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
        """
        return pulumi.get(self, "se_linux_options")

    @se_linux_options.setter
    def se_linux_options(self, value: Optional[pulumi.Input['SELinuxOptionsArgs']]):
        pulumi.set(self, "se_linux_options", value)

    @property
    @pulumi.getter(name="seccompProfile")
    def seccomp_profile(self) -> Optional[pulumi.Input['SeccompProfileArgs']]:
        """
        The seccomp options to use by the containers in this pod.
        """
        return pulumi.get(self, "seccomp_profile")

    @seccomp_profile.setter
    def seccomp_profile(self, value: Optional[pulumi.Input['SeccompProfileArgs']]):
        pulumi.set(self, "seccomp_profile", value)

    @property
    @pulumi.getter(name="supplementalGroups")
    def supplemental_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.
        """
        return pulumi.get(self, "supplemental_groups")

    @supplemental_groups.setter
    def supplemental_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "supplemental_groups", value)

    @property
    @pulumi.getter
    def sysctls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SysctlArgs']]]]:
        """
        Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch.
        """
        return pulumi.get(self, "sysctls")

    @sysctls.setter
    def sysctls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SysctlArgs']]]]):
        pulumi.set(self, "sysctls", value)

    @property
    @pulumi.getter(name="windowsOptions")
    def windows_options(self) -> Optional[pulumi.Input['WindowsSecurityContextOptionsArgs']]:
        """
        The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        return pulumi.get(self, "windows_options")

    @windows_options.setter
    def windows_options(self, value: Optional[pulumi.Input['WindowsSecurityContextOptionsArgs']]):
        pulumi.set(self, "windows_options", value)


@pulumi.input_type
class PodSpecArgs:
    def __init__(__self__, *,
                 containers: pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]],
                 active_deadline_seconds: Optional[pulumi.Input[int]] = None,
                 affinity: Optional[pulumi.Input['AffinityArgs']] = None,
                 automount_service_account_token: Optional[pulumi.Input[bool]] = None,
                 dns_config: Optional[pulumi.Input['PodDNSConfigArgs']] = None,
                 dns_policy: Optional[pulumi.Input[str]] = None,
                 enable_service_links: Optional[pulumi.Input[bool]] = None,
                 ephemeral_containers: Optional[pulumi.Input[Sequence[pulumi.Input['EphemeralContainerArgs']]]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['HostAliasArgs']]]] = None,
                 host_ipc: Optional[pulumi.Input[bool]] = None,
                 host_network: Optional[pulumi.Input[bool]] = None,
                 host_pid: Optional[pulumi.Input[bool]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 image_pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['LocalObjectReferenceArgs']]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 overhead: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 preemption_policy: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 priority_class_name: Optional[pulumi.Input[str]] = None,
                 readiness_gates: Optional[pulumi.Input[Sequence[pulumi.Input['PodReadinessGateArgs']]]] = None,
                 restart_policy: Optional[pulumi.Input[str]] = None,
                 runtime_class_name: Optional[pulumi.Input[str]] = None,
                 scheduler_name: Optional[pulumi.Input[str]] = None,
                 security_context: Optional[pulumi.Input['PodSecurityContextArgs']] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 set_hostname_as_fqdn: Optional[pulumi.Input[bool]] = None,
                 share_process_namespace: Optional[pulumi.Input[bool]] = None,
                 subdomain: Optional[pulumi.Input[str]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[int]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input['TolerationArgs']]]] = None,
                 topology_spread_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['TopologySpreadConstraintArgs']]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]] = None):
        """
        PodSpec is a description of a pod.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]] containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.
        :param pulumi.Input[int] active_deadline_seconds: Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
        :param pulumi.Input['AffinityArgs'] affinity: If specified, the pod's scheduling constraints
        :param pulumi.Input[bool] automount_service_account_token: AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
        :param pulumi.Input['PodDNSConfigArgs'] dns_config: Specifies the DNS parameters of a pod. Parameters specified here will be merged to the generated DNS configuration based on DNSPolicy.
        :param pulumi.Input[str] dns_policy: Set DNS policy for the pod. Defaults to "ClusterFirst". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.
        :param pulumi.Input[bool] enable_service_links: EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links. Optional: Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input['EphemeralContainerArgs']]] ephemeral_containers: List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource. This field is alpha-level and is only honored by servers that enable the EphemeralContainers feature.
        :param pulumi.Input[Sequence[pulumi.Input['HostAliasArgs']]] host_aliases: HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified. This is only valid for non-hostNetwork pods.
        :param pulumi.Input[bool] host_ipc: Use the host's ipc namespace. Optional: Default to false.
        :param pulumi.Input[bool] host_network: Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.
        :param pulumi.Input[bool] host_pid: Use the host's pid namespace. Optional: Default to false.
        :param pulumi.Input[str] hostname: Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.
        :param pulumi.Input[Sequence[pulumi.Input['LocalObjectReferenceArgs']]] image_pull_secrets: ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
        :param pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]] init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        :param pulumi.Input[str] node_name: NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_selector: NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] overhead: Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This field is alpha-level as of Kubernetes v1.16, and is only honored by servers that enable the PodOverhead feature.
        :param pulumi.Input[str] preemption_policy: PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.
        :param pulumi.Input[int] priority: The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.
        :param pulumi.Input[str] priority_class_name: If specified, indicates the pod's priority. "system-node-critical" and "system-cluster-critical" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
        :param pulumi.Input[Sequence[pulumi.Input['PodReadinessGateArgs']]] readiness_gates: If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to "True" More info: https://git.k8s.io/enhancements/keps/sig-network/0007-pod-ready%2B%2B.md
        :param pulumi.Input[str] restart_policy: Restart policy for all containers within the pod. One of Always, OnFailure, Never. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        :param pulumi.Input[str] runtime_class_name: RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the "legacy" RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md This is a beta feature as of Kubernetes v1.14.
        :param pulumi.Input[str] scheduler_name: If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.
        :param pulumi.Input['PodSecurityContextArgs'] security_context: SecurityContext holds pod-level security attributes and common container settings. Optional: Defaults to empty.  See type description for default values of each field.
        :param pulumi.Input[str] service_account: DeprecatedServiceAccount is a depreciated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.
        :param pulumi.Input[str] service_account_name: ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        :param pulumi.Input[bool] set_hostname_as_fqdn: If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default to false.
        :param pulumi.Input[bool] share_process_namespace: Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.
        :param pulumi.Input[str] subdomain: If specified, the fully qualified Pod hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>". If not specified, the pod will not have a domainname at all.
        :param pulumi.Input[int] termination_grace_period_seconds: Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.
        :param pulumi.Input[Sequence[pulumi.Input['TolerationArgs']]] tolerations: If specified, the pod's tolerations.
        :param pulumi.Input[Sequence[pulumi.Input['TopologySpreadConstraintArgs']]] topology_spread_constraints: TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]] volumes: List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes
        """
        pulumi.set(__self__, "containers", containers)
        if active_deadline_seconds is not None:
            pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        if affinity is not None:
            pulumi.set(__self__, "affinity", affinity)
        if automount_service_account_token is not None:
            pulumi.set(__self__, "automount_service_account_token", automount_service_account_token)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if enable_service_links is not None:
            pulumi.set(__self__, "enable_service_links", enable_service_links)
        if ephemeral_containers is not None:
            pulumi.set(__self__, "ephemeral_containers", ephemeral_containers)
        if host_aliases is not None:
            pulumi.set(__self__, "host_aliases", host_aliases)
        if host_ipc is not None:
            pulumi.set(__self__, "host_ipc", host_ipc)
        if host_network is not None:
            pulumi.set(__self__, "host_network", host_network)
        if host_pid is not None:
            pulumi.set(__self__, "host_pid", host_pid)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if overhead is not None:
            pulumi.set(__self__, "overhead", overhead)
        if preemption_policy is not None:
            pulumi.set(__self__, "preemption_policy", preemption_policy)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if priority_class_name is not None:
            pulumi.set(__self__, "priority_class_name", priority_class_name)
        if readiness_gates is not None:
            pulumi.set(__self__, "readiness_gates", readiness_gates)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if runtime_class_name is not None:
            pulumi.set(__self__, "runtime_class_name", runtime_class_name)
        if scheduler_name is not None:
            pulumi.set(__self__, "scheduler_name", scheduler_name)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if set_hostname_as_fqdn is not None:
            pulumi.set(__self__, "set_hostname_as_fqdn", set_hostname_as_fqdn)
        if share_process_namespace is not None:
            pulumi.set(__self__, "share_process_namespace", share_process_namespace)
        if subdomain is not None:
            pulumi.set(__self__, "subdomain", subdomain)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)
        if topology_spread_constraints is not None:
            pulumi.set(__self__, "topology_spread_constraints", topology_spread_constraints)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]:
        """
        List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
        """
        return pulumi.get(self, "active_deadline_seconds")

    @active_deadline_seconds.setter
    def active_deadline_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "active_deadline_seconds", value)

    @property
    @pulumi.getter
    def affinity(self) -> Optional[pulumi.Input['AffinityArgs']]:
        """
        If specified, the pod's scheduling constraints
        """
        return pulumi.get(self, "affinity")

    @affinity.setter
    def affinity(self, value: Optional[pulumi.Input['AffinityArgs']]):
        pulumi.set(self, "affinity", value)

    @property
    @pulumi.getter(name="automountServiceAccountToken")
    def automount_service_account_token(self) -> Optional[pulumi.Input[bool]]:
        """
        AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
        """
        return pulumi.get(self, "automount_service_account_token")

    @automount_service_account_token.setter
    def automount_service_account_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automount_service_account_token", value)

    @property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional[pulumi.Input['PodDNSConfigArgs']]:
        """
        Specifies the DNS parameters of a pod. Parameters specified here will be merged to the generated DNS configuration based on DNSPolicy.
        """
        return pulumi.get(self, "dns_config")

    @dns_config.setter
    def dns_config(self, value: Optional[pulumi.Input['PodDNSConfigArgs']]):
        pulumi.set(self, "dns_config", value)

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Set DNS policy for the pod. Defaults to "ClusterFirst". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.
        """
        return pulumi.get(self, "dns_policy")

    @dns_policy.setter
    def dns_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_policy", value)

    @property
    @pulumi.getter(name="enableServiceLinks")
    def enable_service_links(self) -> Optional[pulumi.Input[bool]]:
        """
        EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links. Optional: Defaults to true.
        """
        return pulumi.get(self, "enable_service_links")

    @enable_service_links.setter
    def enable_service_links(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_service_links", value)

    @property
    @pulumi.getter(name="ephemeralContainers")
    def ephemeral_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EphemeralContainerArgs']]]]:
        """
        List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource. This field is alpha-level and is only honored by servers that enable the EphemeralContainers feature.
        """
        return pulumi.get(self, "ephemeral_containers")

    @ephemeral_containers.setter
    def ephemeral_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EphemeralContainerArgs']]]]):
        pulumi.set(self, "ephemeral_containers", value)

    @property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostAliasArgs']]]]:
        """
        HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified. This is only valid for non-hostNetwork pods.
        """
        return pulumi.get(self, "host_aliases")

    @host_aliases.setter
    def host_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostAliasArgs']]]]):
        pulumi.set(self, "host_aliases", value)

    @property
    @pulumi.getter(name="hostIPC")
    def host_ipc(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the host's ipc namespace. Optional: Default to false.
        """
        return pulumi.get(self, "host_ipc")

    @host_ipc.setter
    def host_ipc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_ipc", value)

    @property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.
        """
        return pulumi.get(self, "host_network")

    @host_network.setter
    def host_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_network", value)

    @property
    @pulumi.getter(name="hostPID")
    def host_pid(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the host's pid namespace. Optional: Default to false.
        """
        return pulumi.get(self, "host_pid")

    @host_pid.setter
    def host_pid(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_pid", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocalObjectReferenceArgs']]]]:
        """
        ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
        """
        return pulumi.get(self, "image_pull_secrets")

    @image_pull_secrets.setter
    def image_pull_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocalObjectReferenceArgs']]]]):
        pulumi.set(self, "image_pull_secrets", value)

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]]:
        """
        List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[str]]:
        """
        NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_selector", value)

    @property
    @pulumi.getter
    def overhead(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This field is alpha-level as of Kubernetes v1.16, and is only honored by servers that enable the PodOverhead feature.
        """
        return pulumi.get(self, "overhead")

    @overhead.setter
    def overhead(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "overhead", value)

    @property
    @pulumi.getter(name="preemptionPolicy")
    def preemption_policy(self) -> Optional[pulumi.Input[str]]:
        """
        PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.
        """
        return pulumi.get(self, "preemption_policy")

    @preemption_policy.setter
    def preemption_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preemption_policy", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="priorityClassName")
    def priority_class_name(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, indicates the pod's priority. "system-node-critical" and "system-cluster-critical" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
        """
        return pulumi.get(self, "priority_class_name")

    @priority_class_name.setter
    def priority_class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority_class_name", value)

    @property
    @pulumi.getter(name="readinessGates")
    def readiness_gates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PodReadinessGateArgs']]]]:
        """
        If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to "True" More info: https://git.k8s.io/enhancements/keps/sig-network/0007-pod-ready%2B%2B.md
        """
        return pulumi.get(self, "readiness_gates")

    @readiness_gates.setter
    def readiness_gates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PodReadinessGateArgs']]]]):
        pulumi.set(self, "readiness_gates", value)

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Restart policy for all containers within the pod. One of Always, OnFailure, Never. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart_policy", value)

    @property
    @pulumi.getter(name="runtimeClassName")
    def runtime_class_name(self) -> Optional[pulumi.Input[str]]:
        """
        RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the "legacy" RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md This is a beta feature as of Kubernetes v1.14.
        """
        return pulumi.get(self, "runtime_class_name")

    @runtime_class_name.setter
    def runtime_class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_class_name", value)

    @property
    @pulumi.getter(name="schedulerName")
    def scheduler_name(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.
        """
        return pulumi.get(self, "scheduler_name")

    @scheduler_name.setter
    def scheduler_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduler_name", value)

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['PodSecurityContextArgs']]:
        """
        SecurityContext holds pod-level security attributes and common container settings. Optional: Defaults to empty.  See type description for default values of each field.
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['PodSecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        DeprecatedServiceAccount is a depreciated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_name", value)

    @property
    @pulumi.getter(name="setHostnameAsFQDN")
    def set_hostname_as_fqdn(self) -> Optional[pulumi.Input[bool]]:
        """
        If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default to false.
        """
        return pulumi.get(self, "set_hostname_as_fqdn")

    @set_hostname_as_fqdn.setter
    def set_hostname_as_fqdn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "set_hostname_as_fqdn", value)

    @property
    @pulumi.getter(name="shareProcessNamespace")
    def share_process_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.
        """
        return pulumi.get(self, "share_process_namespace")

    @share_process_namespace.setter
    def share_process_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "share_process_namespace", value)

    @property
    @pulumi.getter
    def subdomain(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, the fully qualified Pod hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>". If not specified, the pod will not have a domainname at all.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subdomain", value)

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TolerationArgs']]]]:
        """
        If specified, the pod's tolerations.
        """
        return pulumi.get(self, "tolerations")

    @tolerations.setter
    def tolerations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TolerationArgs']]]]):
        pulumi.set(self, "tolerations", value)

    @property
    @pulumi.getter(name="topologySpreadConstraints")
    def topology_spread_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopologySpreadConstraintArgs']]]]:
        """
        TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed.
        """
        return pulumi.get(self, "topology_spread_constraints")

    @topology_spread_constraints.setter
    def topology_spread_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopologySpreadConstraintArgs']]]]):
        pulumi.set(self, "topology_spread_constraints", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]:
        """
        List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class PodStatusArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['PodConditionArgs']]]] = None,
                 container_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]]] = None,
                 ephemeral_container_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]]] = None,
                 host_ip: Optional[pulumi.Input[str]] = None,
                 init_container_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 nominated_node_name: Optional[pulumi.Input[str]] = None,
                 phase: Optional[pulumi.Input[str]] = None,
                 pod_ip: Optional[pulumi.Input[str]] = None,
                 pod_ips: Optional[pulumi.Input[Sequence[pulumi.Input['PodIPArgs']]]] = None,
                 qos_class: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        PodStatus represents information about the status of a pod. Status may trail the actual state of a system, especially if the node that hosts the pod cannot contact the control plane.
        :param pulumi.Input[Sequence[pulumi.Input['PodConditionArgs']]] conditions: Current service state of pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
        :param pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]] container_statuses: The list has one entry per container in the manifest. Each entry is currently the output of `docker inspect`. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
        :param pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]] ephemeral_container_statuses: Status for any ephemeral containers that have run in this pod. This field is alpha-level and is only populated by servers that enable the EphemeralContainers feature.
        :param pulumi.Input[str] host_ip: IP address of the host to which the pod is assigned. Empty if not yet scheduled.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]] init_container_statuses: The list has one entry per init container in the manifest. The most recent successful init container will have ready = true, the most recently started container will have startTime set. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
        :param pulumi.Input[str] message: A human readable message indicating details about why the pod is in this condition.
        :param pulumi.Input[str] nominated_node_name: nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be scheduled right away as preemption victims receive their graceful termination periods. This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to give the resources on this node to a higher priority pod that is created after preemption. As a result, this field may be different than PodSpec.nodeName when the pod is scheduled.
        :param pulumi.Input[str] phase: The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle. The conditions array, the reason and message fields, and the individual container status arrays contain more detail about the pod's status. There are five possible phase values:
               
               Pending: The pod has been accepted by the Kubernetes system, but one or more of the container images has not been created. This includes time before being scheduled as well as time spent downloading images over the network, which could take a while. Running: The pod has been bound to a node, and all of the containers have been created. At least one container is still running, or is in the process of starting or restarting. Succeeded: All containers in the pod have terminated in success, and will not be restarted. Failed: All containers in the pod have terminated, and at least one container has terminated in failure. The container either exited with non-zero status or was terminated by the system. Unknown: For some reason the state of the pod could not be obtained, typically due to an error in communicating with the host of the pod.
               
               More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase
        :param pulumi.Input[str] pod_ip: IP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.
        :param pulumi.Input[Sequence[pulumi.Input['PodIPArgs']]] pod_ips: podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been allocated yet.
        :param pulumi.Input[str] qos_class: The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md
        :param pulumi.Input[str] reason: A brief CamelCase message indicating details about why the pod is in this state. e.g. 'Evicted'
        :param pulumi.Input[str] start_time: RFC 3339 date and time at which the object was acknowledged by the Kubelet. This is before the Kubelet pulled the container image(s) for the pod.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if container_statuses is not None:
            pulumi.set(__self__, "container_statuses", container_statuses)
        if ephemeral_container_statuses is not None:
            pulumi.set(__self__, "ephemeral_container_statuses", ephemeral_container_statuses)
        if host_ip is not None:
            pulumi.set(__self__, "host_ip", host_ip)
        if init_container_statuses is not None:
            pulumi.set(__self__, "init_container_statuses", init_container_statuses)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if nominated_node_name is not None:
            pulumi.set(__self__, "nominated_node_name", nominated_node_name)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if pod_ip is not None:
            pulumi.set(__self__, "pod_ip", pod_ip)
        if pod_ips is not None:
            pulumi.set(__self__, "pod_ips", pod_ips)
        if qos_class is not None:
            pulumi.set(__self__, "qos_class", qos_class)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PodConditionArgs']]]]:
        """
        Current service state of pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PodConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="containerStatuses")
    def container_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]]]:
        """
        The list has one entry per container in the manifest. Each entry is currently the output of `docker inspect`. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
        """
        return pulumi.get(self, "container_statuses")

    @container_statuses.setter
    def container_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]]]):
        pulumi.set(self, "container_statuses", value)

    @property
    @pulumi.getter(name="ephemeralContainerStatuses")
    def ephemeral_container_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]]]:
        """
        Status for any ephemeral containers that have run in this pod. This field is alpha-level and is only populated by servers that enable the EphemeralContainers feature.
        """
        return pulumi.get(self, "ephemeral_container_statuses")

    @ephemeral_container_statuses.setter
    def ephemeral_container_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]]]):
        pulumi.set(self, "ephemeral_container_statuses", value)

    @property
    @pulumi.getter(name="hostIP")
    def host_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the host to which the pod is assigned. Empty if not yet scheduled.
        """
        return pulumi.get(self, "host_ip")

    @host_ip.setter
    def host_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_ip", value)

    @property
    @pulumi.getter(name="initContainerStatuses")
    def init_container_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]]]:
        """
        The list has one entry per init container in the manifest. The most recent successful init container will have ready = true, the most recently started container will have startTime set. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
        """
        return pulumi.get(self, "init_container_statuses")

    @init_container_statuses.setter
    def init_container_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerStatusArgs']]]]):
        pulumi.set(self, "init_container_statuses", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A human readable message indicating details about why the pod is in this condition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="nominatedNodeName")
    def nominated_node_name(self) -> Optional[pulumi.Input[str]]:
        """
        nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be scheduled right away as preemption victims receive their graceful termination periods. This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to give the resources on this node to a higher priority pod that is created after preemption. As a result, this field may be different than PodSpec.nodeName when the pod is scheduled.
        """
        return pulumi.get(self, "nominated_node_name")

    @nominated_node_name.setter
    def nominated_node_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nominated_node_name", value)

    @property
    @pulumi.getter
    def phase(self) -> Optional[pulumi.Input[str]]:
        """
        The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle. The conditions array, the reason and message fields, and the individual container status arrays contain more detail about the pod's status. There are five possible phase values:

        Pending: The pod has been accepted by the Kubernetes system, but one or more of the container images has not been created. This includes time before being scheduled as well as time spent downloading images over the network, which could take a while. Running: The pod has been bound to a node, and all of the containers have been created. At least one container is still running, or is in the process of starting or restarting. Succeeded: All containers in the pod have terminated in success, and will not be restarted. Failed: All containers in the pod have terminated, and at least one container has terminated in failure. The container either exited with non-zero status or was terminated by the system. Unknown: For some reason the state of the pod could not be obtained, typically due to an error in communicating with the host of the pod.

        More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase", value)

    @property
    @pulumi.getter(name="podIP")
    def pod_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.
        """
        return pulumi.get(self, "pod_ip")

    @pod_ip.setter
    def pod_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_ip", value)

    @property
    @pulumi.getter(name="podIPs")
    def pod_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PodIPArgs']]]]:
        """
        podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been allocated yet.
        """
        return pulumi.get(self, "pod_ips")

    @pod_ips.setter
    def pod_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PodIPArgs']]]]):
        pulumi.set(self, "pod_ips", value)

    @property
    @pulumi.getter(name="qosClass")
    def qos_class(self) -> Optional[pulumi.Input[str]]:
        """
        The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md
        """
        return pulumi.get(self, "qos_class")

    @qos_class.setter
    def qos_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qos_class", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        A brief CamelCase message indicating details about why the pod is in this state. e.g. 'Evicted'
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        RFC 3339 date and time at which the object was acknowledged by the Kubelet. This is before the Kubelet pulled the container image(s) for the pod.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class PodTemplateArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 template: Optional[pulumi.Input['PodTemplateSpecArgs']] = None):
        """
        PodTemplate describes a template for creating copies of a predefined pod.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['PodTemplateSpecArgs'] template: Template defines the pods that will be created from this pod template. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PodTemplate')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['PodTemplateSpecArgs']]:
        """
        Template defines the pods that will be created from this pod template. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['PodTemplateSpecArgs']]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class PodTemplateSpecArgs:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['PodSpecArgs']] = None):
        """
        PodTemplateSpec describes the data a pod should have when created from a template
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['PodSpecArgs'] spec: Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['PodSpecArgs']]:
        """
        Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['PodSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class PortStatusArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 error: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: Port is the port number of the service port of which status is recorded here
        :param pulumi.Input[str] protocol: Protocol is the protocol of the service port of which status is recorded here The supported values are: "TCP", "UDP", "SCTP"
        :param pulumi.Input[str] error: Error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
                 CamelCase names
               - cloud provider specific error values must have names that comply with the
                 format foo.example.com/CamelCase.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Port is the port number of the service port of which status is recorded here
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Protocol is the protocol of the service port of which status is recorded here The supported values are: "TCP", "UDP", "SCTP"
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input[str]]:
        """
        Error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
          CamelCase names
        - cloud provider specific error values must have names that comply with the
          format foo.example.com/CamelCase.
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error", value)


@pulumi.input_type
class PortworxVolumeSourceArgs:
    def __init__(__self__, *,
                 volume_id: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        PortworxVolumeSource represents a Portworx volume resource.
        :param pulumi.Input[str] volume_id: VolumeID uniquely identifies a Portworx volume
        :param pulumi.Input[str] fs_type: FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.
        :param pulumi.Input[bool] read_only: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        pulumi.set(__self__, "volume_id", volume_id)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="volumeID")
    def volume_id(self) -> pulumi.Input[str]:
        """
        VolumeID uniquely identifies a Portworx volume
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class PreferredSchedulingTermArgs:
    def __init__(__self__, *,
                 preference: pulumi.Input['NodeSelectorTermArgs'],
                 weight: pulumi.Input[int]):
        """
        An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
        :param pulumi.Input['NodeSelectorTermArgs'] preference: A node selector term, associated with the corresponding weight.
        :param pulumi.Input[int] weight: Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.
        """
        pulumi.set(__self__, "preference", preference)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def preference(self) -> pulumi.Input['NodeSelectorTermArgs']:
        """
        A node selector term, associated with the corresponding weight.
        """
        return pulumi.get(self, "preference")

    @preference.setter
    def preference(self, value: pulumi.Input['NodeSelectorTermArgs']):
        pulumi.set(self, "preference", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[int]:
        """
        Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[int]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ProbeArgs:
    def __init__(__self__, *,
                 exec_: Optional[pulumi.Input['ExecActionArgs']] = None,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 http_get: Optional[pulumi.Input['HTTPGetActionArgs']] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 tcp_socket: Optional[pulumi.Input['TCPSocketActionArgs']] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[int]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
        :param pulumi.Input['ExecActionArgs'] exec_: One and only one of the following should be specified. Exec specifies the action to take.
        :param pulumi.Input[int] failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param pulumi.Input['HTTPGetActionArgs'] http_get: HTTPGet specifies the http request to perform.
        :param pulumi.Input[int] initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input[int] period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.
        :param pulumi.Input[int] success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.
        :param pulumi.Input['TCPSocketActionArgs'] tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported
        :param pulumi.Input[int] termination_grace_period_seconds: Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate.
        :param pulumi.Input[int] timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional[pulumi.Input['ExecActionArgs']]:
        """
        One and only one of the following should be specified. Exec specifies the action to take.
        """
        return pulumi.get(self, "exec_")

    @exec_.setter
    def exec_(self, value: Optional[pulumi.Input['ExecActionArgs']]):
        pulumi.set(self, "exec_", value)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional[pulumi.Input['HTTPGetActionArgs']]:
        """
        HTTPGet specifies the http request to perform.
        """
        return pulumi.get(self, "http_get")

    @http_get.setter
    def http_get(self, value: Optional[pulumi.Input['HTTPGetActionArgs']]):
        pulumi.set(self, "http_get", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional[pulumi.Input['TCPSocketActionArgs']]:
        """
        TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported
        """
        return pulumi.get(self, "tcp_socket")

    @tcp_socket.setter
    def tcp_socket(self, value: Optional[pulumi.Input['TCPSocketActionArgs']]):
        pulumi.set(self, "tcp_socket", value)

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class ProjectedVolumeSourceArgs:
    def __init__(__self__, *,
                 sources: pulumi.Input[Sequence[pulumi.Input['VolumeProjectionArgs']]],
                 default_mode: Optional[pulumi.Input[int]] = None):
        """
        Represents a projected volume source
        :param pulumi.Input[Sequence[pulumi.Input['VolumeProjectionArgs']]] sources: list of volume projections
        :param pulumi.Input[int] default_mode: Mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        pulumi.set(__self__, "sources", sources)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input['VolumeProjectionArgs']]]:
        """
        list of volume projections
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input['VolumeProjectionArgs']]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @default_mode.setter
    def default_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_mode", value)


@pulumi.input_type
class QuobyteVolumeSourceArgs:
    def __init__(__self__, *,
                 registry: pulumi.Input[str],
                 volume: pulumi.Input[str],
                 group: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 tenant: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling.
        :param pulumi.Input[str] registry: Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes
        :param pulumi.Input[str] volume: Volume is a string that references an already created Quobyte volume by name.
        :param pulumi.Input[str] group: Group to map volume access to Default is no group
        :param pulumi.Input[bool] read_only: ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.
        :param pulumi.Input[str] tenant: Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin
        :param pulumi.Input[str] user: User to map volume access to Defaults to serivceaccount user
        """
        pulumi.set(__self__, "registry", registry)
        pulumi.set(__self__, "volume", volume)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def registry(self) -> pulumi.Input[str]:
        """
        Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input[str]:
        """
        Volume is a string that references an already created Quobyte volume by name.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        Group to map volume access to Default is no group
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        User to map volume access to Defaults to serivceaccount user
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class RBDPersistentVolumeSourceArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 monitors: pulumi.Input[Sequence[pulumi.Input[str]]],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 keyring: Optional[pulumi.Input[str]] = None,
                 pool: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_ref: Optional[pulumi.Input['SecretReferenceArgs']] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[str] image: The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitors: A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input[str] fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
        :param pulumi.Input[str] keyring: Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input[str] pool: The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input[bool] read_only: ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input['SecretReferenceArgs'] secret_ref: SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input[str] user: The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "monitors", monitors)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if keyring is not None:
            pulumi.set(__self__, "keyring", keyring)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def monitors(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "monitors")

    @monitors.setter
    def monitors(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "monitors", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter
    def keyring(self) -> Optional[pulumi.Input[str]]:
        """
        Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "keyring")

    @keyring.setter
    def keyring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyring", value)

    @property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input[str]]:
        """
        The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['SecretReferenceArgs']]:
        """
        SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['SecretReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class RBDVolumeSourceArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 monitors: pulumi.Input[Sequence[pulumi.Input[str]]],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 keyring: Optional[pulumi.Input[str]] = None,
                 pool: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_ref: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[str] image: The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitors: A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input[str] fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
        :param pulumi.Input[str] keyring: Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input[str] pool: The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input[bool] read_only: ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input['LocalObjectReferenceArgs'] secret_ref: SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        :param pulumi.Input[str] user: The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "monitors", monitors)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if keyring is not None:
            pulumi.set(__self__, "keyring", keyring)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def monitors(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "monitors")

    @monitors.setter
    def monitors(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "monitors", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter
    def keyring(self) -> Optional[pulumi.Input[str]]:
        """
        Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "keyring")

    @keyring.setter
    def keyring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyring", value)

    @property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input[str]]:
        """
        The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ReplicationControllerArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['ReplicationControllerSpecArgs']] = None,
                 status: Optional[pulumi.Input['ReplicationControllerStatusArgs']] = None):
        """
        ReplicationController represents the configuration of a replication controller.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: If the Labels of a ReplicationController are empty, they are defaulted to be the same as the Pod(s) that the replication controller manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['ReplicationControllerSpecArgs'] spec: Spec defines the specification of the desired behavior of the replication controller. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['ReplicationControllerStatusArgs'] status: Status is the most recently observed status of the replication controller. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ReplicationController')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        If the Labels of a ReplicationController are empty, they are defaulted to be the same as the Pod(s) that the replication controller manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['ReplicationControllerSpecArgs']]:
        """
        Spec defines the specification of the desired behavior of the replication controller. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['ReplicationControllerSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['ReplicationControllerStatusArgs']]:
        """
        Status is the most recently observed status of the replication controller. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['ReplicationControllerStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ReplicationControllerConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 type: pulumi.Input[str],
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        ReplicationControllerCondition describes the state of a replication controller at a certain point.
        :param pulumi.Input[str] status: Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[str] type: Type of replication controller condition.
        :param pulumi.Input[str] last_transition_time: The last time the condition transitioned from one status to another.
        :param pulumi.Input[str] message: A human readable message indicating details about the transition.
        :param pulumi.Input[str] reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of replication controller condition.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class ReplicationControllerSpecArgs:
    def __init__(__self__, *,
                 min_ready_seconds: Optional[pulumi.Input[int]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input['PodTemplateSpecArgs']] = None):
        """
        ReplicationControllerSpec is the specification of a replication controller.
        :param pulumi.Input[int] min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param pulumi.Input[int] replicas: Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] selector: Selector is a label query over pods that should match the Replicas count. If Selector is empty, it is defaulted to the labels present on the Pod template. Label keys and values that must match in order to be controlled by this replication controller, if empty defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param pulumi.Input['PodTemplateSpecArgs'] template: Template is the object that describes the pod that will be created if insufficient replicas are detected. This takes precedence over a TemplateRef. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @min_ready_seconds.setter
    def min_ready_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_ready_seconds", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Selector is a label query over pods that should match the Replicas count. If Selector is empty, it is defaulted to the labels present on the Pod template. Label keys and values that must match in order to be controlled by this replication controller, if empty defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['PodTemplateSpecArgs']]:
        """
        Template is the object that describes the pod that will be created if insufficient replicas are detected. This takes precedence over a TemplateRef. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['PodTemplateSpecArgs']]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class ReplicationControllerStatusArgs:
    def __init__(__self__, *,
                 replicas: pulumi.Input[int],
                 available_replicas: Optional[pulumi.Input[int]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationControllerConditionArgs']]]] = None,
                 fully_labeled_replicas: Optional[pulumi.Input[int]] = None,
                 observed_generation: Optional[pulumi.Input[int]] = None,
                 ready_replicas: Optional[pulumi.Input[int]] = None):
        """
        ReplicationControllerStatus represents the current status of a replication controller.
        :param pulumi.Input[int] replicas: Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
        :param pulumi.Input[int] available_replicas: The number of available replicas (ready for at least minReadySeconds) for this replication controller.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationControllerConditionArgs']]] conditions: Represents the latest available observations of a replication controller's current state.
        :param pulumi.Input[int] fully_labeled_replicas: The number of pods that have labels matching the labels of the pod template of the replication controller.
        :param pulumi.Input[int] observed_generation: ObservedGeneration reflects the generation of the most recently observed replication controller.
        :param pulumi.Input[int] ready_replicas: The number of ready replicas for this replication controller.
        """
        pulumi.set(__self__, "replicas", replicas)
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if fully_labeled_replicas is not None:
            pulumi.set(__self__, "fully_labeled_replicas", fully_labeled_replicas)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Input[int]:
        """
        Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: pulumi.Input[int]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The number of available replicas (ready for at least minReadySeconds) for this replication controller.
        """
        return pulumi.get(self, "available_replicas")

    @available_replicas.setter
    def available_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_replicas", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationControllerConditionArgs']]]]:
        """
        Represents the latest available observations of a replication controller's current state.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationControllerConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="fullyLabeledReplicas")
    def fully_labeled_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The number of pods that have labels matching the labels of the pod template of the replication controller.
        """
        return pulumi.get(self, "fully_labeled_replicas")

    @fully_labeled_replicas.setter
    def fully_labeled_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fully_labeled_replicas", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[int]]:
        """
        ObservedGeneration reflects the generation of the most recently observed replication controller.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The number of ready replicas for this replication controller.
        """
        return pulumi.get(self, "ready_replicas")

    @ready_replicas.setter
    def ready_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ready_replicas", value)


@pulumi.input_type
class ResourceFieldSelectorArgs:
    def __init__(__self__, *,
                 resource: pulumi.Input[str],
                 container_name: Optional[pulumi.Input[str]] = None,
                 divisor: Optional[pulumi.Input[str]] = None):
        """
        ResourceFieldSelector represents container resources (cpu, memory) and their output format
        :param pulumi.Input[str] resource: Required: resource to select
        :param pulumi.Input[str] container_name: Container name: required for volumes, optional for env vars
        :param pulumi.Input[str] divisor: Specifies the output format of the exposed resources, defaults to "1"
        """
        pulumi.set(__self__, "resource", resource)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if divisor is not None:
            pulumi.set(__self__, "divisor", divisor)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input[str]:
        """
        Required: resource to select
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Container name: required for volumes, optional for env vars
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter
    def divisor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the output format of the exposed resources, defaults to "1"
        """
        return pulumi.get(self, "divisor")

    @divisor.setter
    def divisor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "divisor", value)


@pulumi.input_type
class ResourceQuotaArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['ResourceQuotaSpecArgs']] = None,
                 status: Optional[pulumi.Input['ResourceQuotaStatusArgs']] = None):
        """
        ResourceQuota sets aggregate quota restrictions enforced per namespace
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['ResourceQuotaSpecArgs'] spec: Spec defines the desired quota. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['ResourceQuotaStatusArgs'] status: Status defines the actual enforced quota and its current usage. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceQuota')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['ResourceQuotaSpecArgs']]:
        """
        Spec defines the desired quota. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['ResourceQuotaSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['ResourceQuotaStatusArgs']]:
        """
        Status defines the actual enforced quota and its current usage. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['ResourceQuotaStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ResourceQuotaSpecArgs:
    def __init__(__self__, *,
                 hard: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 scope_selector: Optional[pulumi.Input['ScopeSelectorArgs']] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ResourceQuotaSpec defines the desired hard limits to enforce for Quota.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] hard: hard is the set of desired hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
        :param pulumi.Input['ScopeSelectorArgs'] scope_selector: scopeSelector is also a collection of filters like scopes that must match each object tracked by a quota but expressed using ScopeSelectorOperator in combination with possible values. For a resource to match, both scopes AND scopeSelector (if specified in spec), must be matched.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.
        """
        if hard is not None:
            pulumi.set(__self__, "hard", hard)
        if scope_selector is not None:
            pulumi.set(__self__, "scope_selector", scope_selector)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def hard(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        hard is the set of desired hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
        """
        return pulumi.get(self, "hard")

    @hard.setter
    def hard(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "hard", value)

    @property
    @pulumi.getter(name="scopeSelector")
    def scope_selector(self) -> Optional[pulumi.Input['ScopeSelectorArgs']]:
        """
        scopeSelector is also a collection of filters like scopes that must match each object tracked by a quota but expressed using ScopeSelectorOperator in combination with possible values. For a resource to match, both scopes AND scopeSelector (if specified in spec), must be matched.
        """
        return pulumi.get(self, "scope_selector")

    @scope_selector.setter
    def scope_selector(self, value: Optional[pulumi.Input['ScopeSelectorArgs']]):
        pulumi.set(self, "scope_selector", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class ResourceQuotaStatusArgs:
    def __init__(__self__, *,
                 hard: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 used: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        ResourceQuotaStatus defines the enforced hard limits and observed use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] hard: Hard is the set of enforced hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] used: Used is the current observed total usage of the resource in the namespace.
        """
        if hard is not None:
            pulumi.set(__self__, "hard", hard)
        if used is not None:
            pulumi.set(__self__, "used", used)

    @property
    @pulumi.getter
    def hard(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Hard is the set of enforced hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
        """
        return pulumi.get(self, "hard")

    @hard.setter
    def hard(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "hard", value)

    @property
    @pulumi.getter
    def used(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Used is the current observed total usage of the resource in the namespace.
        """
        return pulumi.get(self, "used")

    @used.setter
    def used(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "used", value)


@pulumi.input_type
class ResourceRequirementsArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 requests: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        ResourceRequirements describes the compute resource requirements.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] limits: Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] requests: Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


@pulumi.input_type
class SELinuxOptionsArgs:
    def __init__(__self__, *,
                 level: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        SELinuxOptions are the labels to be applied to the container
        :param pulumi.Input[str] level: Level is SELinux level label that applies to the container.
        :param pulumi.Input[str] role: Role is a SELinux role label that applies to the container.
        :param pulumi.Input[str] type: Type is a SELinux type label that applies to the container.
        :param pulumi.Input[str] user: User is a SELinux user label that applies to the container.
        """
        if level is not None:
            pulumi.set(__self__, "level", level)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        Level is SELinux level label that applies to the container.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role is a SELinux role label that applies to the container.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type is a SELinux type label that applies to the container.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        User is a SELinux user label that applies to the container.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ScaleIOPersistentVolumeSourceArgs:
    def __init__(__self__, *,
                 gateway: pulumi.Input[str],
                 secret_ref: pulumi.Input['SecretReferenceArgs'],
                 system: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 protection_domain: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 ssl_enabled: Optional[pulumi.Input[bool]] = None,
                 storage_mode: Optional[pulumi.Input[str]] = None,
                 storage_pool: Optional[pulumi.Input[str]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None):
        """
        ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume
        :param pulumi.Input[str] gateway: The host address of the ScaleIO API Gateway.
        :param pulumi.Input['SecretReferenceArgs'] secret_ref: SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
        :param pulumi.Input[str] system: The name of the storage system as configured in ScaleIO.
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs"
        :param pulumi.Input[str] protection_domain: The name of the ScaleIO Protection Domain for the configured storage.
        :param pulumi.Input[bool] read_only: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param pulumi.Input[bool] ssl_enabled: Flag to enable/disable SSL communication with Gateway, default false
        :param pulumi.Input[str] storage_mode: Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
        :param pulumi.Input[str] storage_pool: The ScaleIO Storage Pool associated with the protection domain.
        :param pulumi.Input[str] volume_name: The name of a volume already created in the ScaleIO system that is associated with this volume source.
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "secret_ref", secret_ref)
        pulumi.set(__self__, "system", system)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if protection_domain is not None:
            pulumi.set(__self__, "protection_domain", protection_domain)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if storage_mode is not None:
            pulumi.set(__self__, "storage_mode", storage_mode)
        if storage_pool is not None:
            pulumi.set(__self__, "storage_pool", storage_pool)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Input[str]:
        """
        The host address of the ScaleIO API Gateway.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> pulumi.Input['SecretReferenceArgs']:
        """
        SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: pulumi.Input['SecretReferenceArgs']):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter
    def system(self) -> pulumi.Input[str]:
        """
        The name of the storage system as configured in ScaleIO.
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: pulumi.Input[str]):
        pulumi.set(self, "system", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs"
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="protectionDomain")
    def protection_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ScaleIO Protection Domain for the configured storage.
        """
        return pulumi.get(self, "protection_domain")

    @protection_domain.setter
    def protection_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_domain", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable/disable SSL communication with Gateway, default false
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enabled", value)

    @property
    @pulumi.getter(name="storageMode")
    def storage_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
        """
        return pulumi.get(self, "storage_mode")

    @storage_mode.setter
    def storage_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_mode", value)

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> Optional[pulumi.Input[str]]:
        """
        The ScaleIO Storage Pool associated with the protection domain.
        """
        return pulumi.get(self, "storage_pool")

    @storage_pool.setter
    def storage_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_pool", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a volume already created in the ScaleIO system that is associated with this volume source.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_name", value)


@pulumi.input_type
class ScaleIOVolumeSourceArgs:
    def __init__(__self__, *,
                 gateway: pulumi.Input[str],
                 secret_ref: pulumi.Input['LocalObjectReferenceArgs'],
                 system: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 protection_domain: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 ssl_enabled: Optional[pulumi.Input[bool]] = None,
                 storage_mode: Optional[pulumi.Input[str]] = None,
                 storage_pool: Optional[pulumi.Input[str]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None):
        """
        ScaleIOVolumeSource represents a persistent ScaleIO volume
        :param pulumi.Input[str] gateway: The host address of the ScaleIO API Gateway.
        :param pulumi.Input['LocalObjectReferenceArgs'] secret_ref: SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
        :param pulumi.Input[str] system: The name of the storage system as configured in ScaleIO.
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs".
        :param pulumi.Input[str] protection_domain: The name of the ScaleIO Protection Domain for the configured storage.
        :param pulumi.Input[bool] read_only: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param pulumi.Input[bool] ssl_enabled: Flag to enable/disable SSL communication with Gateway, default false
        :param pulumi.Input[str] storage_mode: Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
        :param pulumi.Input[str] storage_pool: The ScaleIO Storage Pool associated with the protection domain.
        :param pulumi.Input[str] volume_name: The name of a volume already created in the ScaleIO system that is associated with this volume source.
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "secret_ref", secret_ref)
        pulumi.set(__self__, "system", system)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if protection_domain is not None:
            pulumi.set(__self__, "protection_domain", protection_domain)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if storage_mode is not None:
            pulumi.set(__self__, "storage_mode", storage_mode)
        if storage_pool is not None:
            pulumi.set(__self__, "storage_pool", storage_pool)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Input[str]:
        """
        The host address of the ScaleIO API Gateway.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> pulumi.Input['LocalObjectReferenceArgs']:
        """
        SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: pulumi.Input['LocalObjectReferenceArgs']):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter
    def system(self) -> pulumi.Input[str]:
        """
        The name of the storage system as configured in ScaleIO.
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: pulumi.Input[str]):
        pulumi.set(self, "system", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs".
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="protectionDomain")
    def protection_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ScaleIO Protection Domain for the configured storage.
        """
        return pulumi.get(self, "protection_domain")

    @protection_domain.setter
    def protection_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_domain", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable/disable SSL communication with Gateway, default false
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enabled", value)

    @property
    @pulumi.getter(name="storageMode")
    def storage_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
        """
        return pulumi.get(self, "storage_mode")

    @storage_mode.setter
    def storage_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_mode", value)

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> Optional[pulumi.Input[str]]:
        """
        The ScaleIO Storage Pool associated with the protection domain.
        """
        return pulumi.get(self, "storage_pool")

    @storage_pool.setter
    def storage_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_pool", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a volume already created in the ScaleIO system that is associated with this volume source.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_name", value)


@pulumi.input_type
class ScopeSelectorArgs:
    def __init__(__self__, *,
                 match_expressions: Optional[pulumi.Input[Sequence[pulumi.Input['ScopedResourceSelectorRequirementArgs']]]] = None):
        """
        A scope selector represents the AND of the selectors represented by the scoped-resource selector requirements.
        :param pulumi.Input[Sequence[pulumi.Input['ScopedResourceSelectorRequirementArgs']]] match_expressions: A list of scope selector requirements by scope of the resources.
        """
        if match_expressions is not None:
            pulumi.set(__self__, "match_expressions", match_expressions)

    @property
    @pulumi.getter(name="matchExpressions")
    def match_expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScopedResourceSelectorRequirementArgs']]]]:
        """
        A list of scope selector requirements by scope of the resources.
        """
        return pulumi.get(self, "match_expressions")

    @match_expressions.setter
    def match_expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScopedResourceSelectorRequirementArgs']]]]):
        pulumi.set(self, "match_expressions", value)


@pulumi.input_type
class ScopedResourceSelectorRequirementArgs:
    def __init__(__self__, *,
                 operator: pulumi.Input[str],
                 scope_name: pulumi.Input[str],
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values.
        :param pulumi.Input[str] operator: Represents a scope's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.
        :param pulumi.Input[str] scope_name: The name of the scope that the selector applies to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "scope_name", scope_name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[str]:
        """
        Represents a scope's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="scopeName")
    def scope_name(self) -> pulumi.Input[str]:
        """
        The name of the scope that the selector applies to.
        """
        return pulumi.get(self, "scope_name")

    @scope_name.setter
    def scope_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope_name", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class SeccompProfileArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 localhost_profile: Optional[pulumi.Input[str]] = None):
        """
        SeccompProfile defines a pod/container's seccomp profile settings. Only one profile source may be set.
        :param pulumi.Input[str] type: type indicates which kind of seccomp profile will be applied. Valid options are:
               
               Localhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied.
        :param pulumi.Input[str] localhost_profile: localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must only be set if type is "Localhost".
        """
        pulumi.set(__self__, "type", type)
        if localhost_profile is not None:
            pulumi.set(__self__, "localhost_profile", localhost_profile)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        type indicates which kind of seccomp profile will be applied. Valid options are:

        Localhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="localhostProfile")
    def localhost_profile(self) -> Optional[pulumi.Input[str]]:
        """
        localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must only be set if type is "Localhost".
        """
        return pulumi.get(self, "localhost_profile")

    @localhost_profile.setter
    def localhost_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "localhost_profile", value)


@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 immutable: Optional[pulumi.Input[bool]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 string_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Secret holds secret data of a certain type. The total bytes of the values in the Data field must be less than MaxSecretSize bytes.

        Note: While Pulumi automatically encrypts the 'data' and 'stringData'
        fields, this encryption only applies to Pulumi's context, including the state file, 
        the Service, the CLI, etc. Kubernetes does not encrypt Secret resources by default,
        and the contents are visible to users with access to the Secret in Kubernetes using
        tools like 'kubectl'.

        For more information on securing Kubernetes Secrets, see the following links:
        https://kubernetes.io/docs/concepts/configuration/secret/#security-properties
        https://kubernetes.io/docs/concepts/configuration/secret/#risks
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] data: Data contains the secret data. Each key must consist of alphanumeric characters, '-', '_' or '.'. The serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string) data value here. Described in https://tools.ietf.org/html/rfc4648#section-4
        :param pulumi.Input[bool] immutable: Immutable, if set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] string_data: stringData allows specifying non-binary secret data in string form. It is provided as a write-only input field for convenience. All keys and values are merged into the data field on write, overwriting any existing values. The stringData field is never output when reading from the API.
        :param pulumi.Input[str] type: Used to facilitate programmatic handling of secret data.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if data is not None:
            pulumi.set(__self__, "data", data)
        if immutable is not None:
            pulumi.set(__self__, "immutable", immutable)
        if kind is not None:
            pulumi.set(__self__, "kind", 'Secret')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if string_data is not None:
            pulumi.set(__self__, "string_data", string_data)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Data contains the secret data. Each key must consist of alphanumeric characters, '-', '_' or '.'. The serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string) data value here. Described in https://tools.ietf.org/html/rfc4648#section-4
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def immutable(self) -> Optional[pulumi.Input[bool]]:
        """
        Immutable, if set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        """
        return pulumi.get(self, "immutable")

    @immutable.setter
    def immutable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "immutable", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="stringData")
    def string_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        stringData allows specifying non-binary secret data in string form. It is provided as a write-only input field for convenience. All keys and values are merged into the data field on write, overwriting any existing values. The stringData field is never output when reading from the API.
        """
        return pulumi.get(self, "string_data")

    @string_data.setter
    def string_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "string_data", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Used to facilitate programmatic handling of secret data.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class SecretEnvSourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        SecretEnvSource selects a Secret to populate the environment variables with.

        The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
        :param pulumi.Input[str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[bool] optional: Specify whether the Secret must be defined
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the Secret must be defined
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class SecretKeySelectorArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        SecretKeySelector selects a key of a Secret.
        :param pulumi.Input[str] key: The key of the secret to select from.  Must be a valid secret key.
        :param pulumi.Input[str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[bool] optional: Specify whether the Secret or its key must be defined
        """
        pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key of the secret to select from.  Must be a valid secret key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the Secret or its key must be defined
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class SecretProjectionArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        Adapts a secret into a projected volume.

        The contents of the target Secret's Data field will be presented in a projected volume as files using the keys in the Data field as the file names. Note that this is identical to a secret volume source without the default mode.
        :param pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]] items: If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param pulumi.Input[str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[bool] optional: Specify whether the Secret or its key must be defined
        """
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]:
        """
        If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the Secret or its key must be defined
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class SecretReferenceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace
        :param pulumi.Input[str] name: Name is unique within a namespace to reference a secret resource.
        :param pulumi.Input[str] namespace: Namespace defines the space within which the secret name must be unique.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name is unique within a namespace to reference a secret resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace defines the space within which the secret name must be unique.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class SecretVolumeSourceArgs:
    def __init__(__self__, *,
                 default_mode: Optional[pulumi.Input[int]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]] = None,
                 optional: Optional[pulumi.Input[bool]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None):
        """
        Adapts a Secret into a volume.

        The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names. Secret volumes support ownership management and SELinux relabeling.
        :param pulumi.Input[int] default_mode: Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]] items: If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param pulumi.Input[bool] optional: Specify whether the Secret or its keys must be defined
        :param pulumi.Input[str] secret_name: Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @default_mode.setter
    def default_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_mode", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]:
        """
        If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the Secret or its keys must be defined
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_name", value)


@pulumi.input_type
class SecurityContextArgs:
    def __init__(__self__, *,
                 allow_privilege_escalation: Optional[pulumi.Input[bool]] = None,
                 capabilities: Optional[pulumi.Input['CapabilitiesArgs']] = None,
                 privileged: Optional[pulumi.Input[bool]] = None,
                 proc_mount: Optional[pulumi.Input[str]] = None,
                 read_only_root_filesystem: Optional[pulumi.Input[bool]] = None,
                 run_as_group: Optional[pulumi.Input[int]] = None,
                 run_as_non_root: Optional[pulumi.Input[bool]] = None,
                 run_as_user: Optional[pulumi.Input[int]] = None,
                 se_linux_options: Optional[pulumi.Input['SELinuxOptionsArgs']] = None,
                 seccomp_profile: Optional[pulumi.Input['SeccompProfileArgs']] = None,
                 windows_options: Optional[pulumi.Input['WindowsSecurityContextOptionsArgs']] = None):
        """
        SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.
        :param pulumi.Input[bool] allow_privilege_escalation: AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
        :param pulumi.Input['CapabilitiesArgs'] capabilities: The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.
        :param pulumi.Input[bool] privileged: Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
        :param pulumi.Input[str] proc_mount: procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled.
        :param pulumi.Input[bool] read_only_root_filesystem: Whether this container has a read-only root filesystem. Default is false.
        :param pulumi.Input[int] run_as_group: The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        :param pulumi.Input[bool] run_as_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        :param pulumi.Input[int] run_as_user: The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        :param pulumi.Input['SELinuxOptionsArgs'] se_linux_options: The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        :param pulumi.Input['SeccompProfileArgs'] seccomp_profile: The seccomp options to use by this container. If seccomp options are provided at both the pod & container level, the container options override the pod options.
        :param pulumi.Input['WindowsSecurityContextOptionsArgs'] windows_options: The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        if allow_privilege_escalation is not None:
            pulumi.set(__self__, "allow_privilege_escalation", allow_privilege_escalation)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if proc_mount is not None:
            pulumi.set(__self__, "proc_mount", proc_mount)
        if read_only_root_filesystem is not None:
            pulumi.set(__self__, "read_only_root_filesystem", read_only_root_filesystem)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_non_root is not None:
            pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if se_linux_options is not None:
            pulumi.set(__self__, "se_linux_options", se_linux_options)
        if seccomp_profile is not None:
            pulumi.set(__self__, "seccomp_profile", seccomp_profile)
        if windows_options is not None:
            pulumi.set(__self__, "windows_options", windows_options)

    @property
    @pulumi.getter(name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> Optional[pulumi.Input[bool]]:
        """
        AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
        """
        return pulumi.get(self, "allow_privilege_escalation")

    @allow_privilege_escalation.setter
    def allow_privilege_escalation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_privilege_escalation", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['CapabilitiesArgs']]:
        """
        The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['CapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[bool]]:
        """
        Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
        """
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="procMount")
    def proc_mount(self) -> Optional[pulumi.Input[str]]:
        """
        procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled.
        """
        return pulumi.get(self, "proc_mount")

    @proc_mount.setter
    def proc_mount(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proc_mount", value)

    @property
    @pulumi.getter(name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this container has a read-only root filesystem. Default is false.
        """
        return pulumi.get(self, "read_only_root_filesystem")

    @read_only_root_filesystem.setter
    def read_only_root_filesystem(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only_root_filesystem", value)

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[pulumi.Input[int]]:
        """
        The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        return pulumi.get(self, "run_as_group")

    @run_as_group.setter
    def run_as_group(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_group", value)

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        return pulumi.get(self, "run_as_non_root")

    @run_as_non_root.setter
    def run_as_non_root(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "run_as_non_root", value)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[int]]:
        """
        The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_user", value)

    @property
    @pulumi.getter(name="seLinuxOptions")
    def se_linux_options(self) -> Optional[pulumi.Input['SELinuxOptionsArgs']]:
        """
        The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        return pulumi.get(self, "se_linux_options")

    @se_linux_options.setter
    def se_linux_options(self, value: Optional[pulumi.Input['SELinuxOptionsArgs']]):
        pulumi.set(self, "se_linux_options", value)

    @property
    @pulumi.getter(name="seccompProfile")
    def seccomp_profile(self) -> Optional[pulumi.Input['SeccompProfileArgs']]:
        """
        The seccomp options to use by this container. If seccomp options are provided at both the pod & container level, the container options override the pod options.
        """
        return pulumi.get(self, "seccomp_profile")

    @seccomp_profile.setter
    def seccomp_profile(self, value: Optional[pulumi.Input['SeccompProfileArgs']]):
        pulumi.set(self, "seccomp_profile", value)

    @property
    @pulumi.getter(name="windowsOptions")
    def windows_options(self) -> Optional[pulumi.Input['WindowsSecurityContextOptionsArgs']]:
        """
        The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        return pulumi.get(self, "windows_options")

    @windows_options.setter
    def windows_options(self, value: Optional[pulumi.Input['WindowsSecurityContextOptionsArgs']]):
        pulumi.set(self, "windows_options", value)


@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['ServiceSpecArgs']] = None,
                 status: Optional[pulumi.Input['ServiceStatusArgs']] = None):
        """
        Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. Service object exists.
        2. Related Endpoint objects are created. Each time we get an update, wait 10 seconds
           for any stragglers.
        3. The endpoints objects target some number of living objects (unless the Service is
           an "empty headless" Service [1] or a Service with '.spec.type: ExternalName').
        4. External IP address is allocated (if Service has '.spec.type: LoadBalancer').

        Known limitations: 
        Services targeting ReplicaSets (and, by extension, Deployments,
        StatefulSets, etc.) with '.spec.replicas' set to 0 are not handled, and will time
        out. To work around this limitation, set 'pulumi.com/skipAwait: "true"' on
        '.metadata.annotations' for the Service. Work to handle this case is in progress [2].

        [1] https://kubernetes.io/docs/concepts/services-networking/service/#headless-services
        [2] https://github.com/pulumi/pulumi-kubernetes/pull/703

        If the Service has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['ServiceSpecArgs'] spec: Spec defines the behavior of a service. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['ServiceStatusArgs'] status: Most recently observed status of the service. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Service')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['ServiceSpecArgs']]:
        """
        Spec defines the behavior of a service. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['ServiceSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['ServiceStatusArgs']]:
        """
        Most recently observed status of the service. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['ServiceStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ServiceAccountArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 automount_service_account_token: Optional[pulumi.Input[bool]] = None,
                 image_pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['LocalObjectReferenceArgs']]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectReferenceArgs']]]] = None):
        """
        ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[bool] automount_service_account_token: AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level.
        :param pulumi.Input[Sequence[pulumi.Input['LocalObjectReferenceArgs']]] image_pull_secrets: ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet. More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input['ObjectReferenceArgs']]] secrets: Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount. More info: https://kubernetes.io/docs/concepts/configuration/secret
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if automount_service_account_token is not None:
            pulumi.set(__self__, "automount_service_account_token", automount_service_account_token)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if kind is not None:
            pulumi.set(__self__, "kind", 'ServiceAccount')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter(name="automountServiceAccountToken")
    def automount_service_account_token(self) -> Optional[pulumi.Input[bool]]:
        """
        AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level.
        """
        return pulumi.get(self, "automount_service_account_token")

    @automount_service_account_token.setter
    def automount_service_account_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automount_service_account_token", value)

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocalObjectReferenceArgs']]]]:
        """
        ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet. More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
        """
        return pulumi.get(self, "image_pull_secrets")

    @image_pull_secrets.setter
    def image_pull_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocalObjectReferenceArgs']]]]):
        pulumi.set(self, "image_pull_secrets", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectReferenceArgs']]]]:
        """
        Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount. More info: https://kubernetes.io/docs/concepts/configuration/secret
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectReferenceArgs']]]]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class ServiceAccountTokenProjectionArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 audience: Optional[pulumi.Input[str]] = None,
                 expiration_seconds: Optional[pulumi.Input[int]] = None):
        """
        ServiceAccountTokenProjection represents a projected service account token volume. This projection can be used to insert a service account token into the pods runtime filesystem for use against APIs (Kubernetes API Server or otherwise).
        :param pulumi.Input[str] path: Path is the path relative to the mount point of the file to project the token into.
        :param pulumi.Input[str] audience: Audience is the intended audience of the token. A recipient of a token must identify itself with an identifier specified in the audience of the token, and otherwise should reject the token. The audience defaults to the identifier of the apiserver.
        :param pulumi.Input[int] expiration_seconds: ExpirationSeconds is the requested duration of validity of the service account token. As the token approaches expiration, the kubelet volume plugin will proactively rotate the service account token. The kubelet will start trying to rotate the token if the token is older than 80 percent of its time to live or if the token is older than 24 hours.Defaults to 1 hour and must be at least 10 minutes.
        """
        pulumi.set(__self__, "path", path)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if expiration_seconds is not None:
            pulumi.set(__self__, "expiration_seconds", expiration_seconds)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Path is the path relative to the mount point of the file to project the token into.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Audience is the intended audience of the token. A recipient of a token must identify itself with an identifier specified in the audience of the token, and otherwise should reject the token. The audience defaults to the identifier of the apiserver.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter(name="expirationSeconds")
    def expiration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        ExpirationSeconds is the requested duration of validity of the service account token. As the token approaches expiration, the kubelet volume plugin will proactively rotate the service account token. The kubelet will start trying to rotate the token if the token is older than 80 percent of its time to live or if the token is older than 24 hours.Defaults to 1 hour and must be at least 10 minutes.
        """
        return pulumi.get(self, "expiration_seconds")

    @expiration_seconds.setter
    def expiration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiration_seconds", value)


@pulumi.input_type
class ServicePortArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 app_protocol: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 target_port: Optional[pulumi.Input[Union[int, str]]] = None):
        """
        ServicePort contains information on service's port.
        :param pulumi.Input[int] port: The port that will be exposed by this service.
        :param pulumi.Input[str] app_protocol: The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol. This is a beta field that is guarded by the ServiceAppProtocol feature gate and enabled by default.
        :param pulumi.Input[str] name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. When considering the endpoints for a Service, this must match the 'name' field in the EndpointPort. Optional if only one ServicePort is defined on this service.
        :param pulumi.Input[int] node_port: The port on each node on which this service is exposed when type is NodePort or LoadBalancer.  Usually assigned by the system. If a value is specified, in-range, and not in use it will be used, otherwise the operation will fail.  If not specified, a port will be allocated if this Service requires one.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type from NodePort to ClusterIP). More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        :param pulumi.Input[str] protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP.
        :param pulumi.Input[Union[int, str]] target_port: Number or name of the port to access on the pods targeted by the service. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. If this is a string, it will be looked up as a named port in the target Pod's container ports. If this is not specified, the value of the 'port' field is used (an identity map). This field is ignored for services with clusterIP=None, and should be omitted or set equal to the 'port' field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service
        """
        pulumi.set(__self__, "port", port)
        if app_protocol is not None:
            pulumi.set(__self__, "app_protocol", app_protocol)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_port is not None:
            pulumi.set(__self__, "node_port", node_port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port that will be exposed by this service.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol. This is a beta field that is guarded by the ServiceAppProtocol feature gate and enabled by default.
        """
        return pulumi.get(self, "app_protocol")

    @app_protocol.setter
    def app_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_protocol", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. When considering the endpoints for a Service, this must match the 'name' field in the EndpointPort. Optional if only one ServicePort is defined on this service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodePort")
    def node_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port on each node on which this service is exposed when type is NodePort or LoadBalancer.  Usually assigned by the system. If a value is specified, in-range, and not in use it will be used, otherwise the operation will fail.  If not specified, a port will be allocated if this Service requires one.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type from NodePort to ClusterIP). More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        """
        return pulumi.get(self, "node_port")

    @node_port.setter
    def node_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[pulumi.Input[Union[int, str]]]:
        """
        Number or name of the port to access on the pods targeted by the service. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. If this is a string, it will be looked up as a named port in the target Pod's container ports. If this is not specified, the value of the 'port' field is used (an identity map). This field is ignored for services with clusterIP=None, and should be omitted or set equal to the 'port' field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: Optional[pulumi.Input[Union[int, str]]]):
        pulumi.set(self, "target_port", value)


@pulumi.input_type
class ServiceSpecArgs:
    def __init__(__self__, *,
                 allocate_load_balancer_node_ports: Optional[pulumi.Input[bool]] = None,
                 cluster_ip: Optional[pulumi.Input[str]] = None,
                 cluster_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 external_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 external_name: Optional[pulumi.Input[str]] = None,
                 external_traffic_policy: Optional[pulumi.Input[str]] = None,
                 health_check_node_port: Optional[pulumi.Input[int]] = None,
                 internal_traffic_policy: Optional[pulumi.Input[str]] = None,
                 ip_families: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_family: Optional[pulumi.Input[str]] = None,
                 ip_family_policy: Optional[pulumi.Input[str]] = None,
                 load_balancer_class: Optional[pulumi.Input[str]] = None,
                 load_balancer_ip: Optional[pulumi.Input[str]] = None,
                 load_balancer_source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePortArgs']]]] = None,
                 publish_not_ready_addresses: Optional[pulumi.Input[bool]] = None,
                 selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 session_affinity_config: Optional[pulumi.Input['SessionAffinityConfigArgs']] = None,
                 topology_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ServiceSpecType']]] = None):
        """
        ServiceSpec describes the attributes that a user creates on a service.
        :param pulumi.Input[bool] allocate_load_balancer_node_ports: allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is "true". It may be set to "false" if the cluster load-balancer does not rely on NodePorts. allocateLoadBalancerNodePorts may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type. This field is alpha-level and is only honored by servers that enable the ServiceLBNodePortControl feature.
        :param pulumi.Input[str] cluster_ip: clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are "None", empty string (""), or a valid IP address. Setting this to "None" makes a "headless service" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cluster_ips: ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are "None", empty string (""), or a valid IP address.  Setting this to "None" makes a "headless service" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.
               
               Unless the "IPv6DualStack" feature gate is enabled, this field is limited to one value, which must be the same as the clusterIP field.  If the feature gate is enabled, this field may hold a maximum of two entries (dual-stack IPs, in either order).  These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        :param pulumi.Input[Sequence[pulumi.Input[str]]] external_ips: externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
        :param pulumi.Input[str] external_name: externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be "ExternalName".
        :param pulumi.Input[str] external_traffic_policy: externalTrafficPolicy denotes if this Service desires to route external traffic to node-local or cluster-wide endpoints. "Local" preserves the client source IP and avoids a second hop for LoadBalancer and Nodeport type services, but risks potentially imbalanced traffic spreading. "Cluster" obscures the client source IP and may cause a second hop to another node, but should have good overall load-spreading.
        :param pulumi.Input[int] health_check_node_port: healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type).
        :param pulumi.Input[str] internal_traffic_policy: InternalTrafficPolicy specifies if the cluster internal traffic should be routed to all endpoints or node-local endpoints only. "Cluster" routes internal traffic to a Service to all endpoints. "Local" routes traffic to node-local endpoints only, traffic is dropped if no node-local endpoints are ready. The default value is "Cluster".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_families: IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service, and is gated by the "IPv6DualStack" feature gate.  This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail.  This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service.  Valid values are "IPv4" and "IPv6".  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to "headless" services.  This field will be wiped when updating a Service to type ExternalName.
               
               This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
        :param pulumi.Input[str] ip_family: ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is available in the cluster.  If no IP family is requested, the cluster's primary IP family will be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.
        :param pulumi.Input[str] ip_family_policy: IPFamilyPolicy represents the dual-stack-ness requested or required by this Service, and is gated by the "IPv6DualStack" feature gate.  If there is no value provided, then this field will be set to SingleStack. Services can be "SingleStack" (a single IP family), "PreferDualStack" (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or "RequireDualStack" (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field.  This field will be wiped when updating a service to type ExternalName.
        :param pulumi.Input[str] load_balancer_class: loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. "internal-vip" or "example.com/internal-vip". Unprefixed names are reserved for end-users. This field can only be set when the Service type is 'LoadBalancer'. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type 'LoadBalancer'. Once set, it can not be changed. This field will be wiped when a service is updated to a non 'LoadBalancer' type.
        :param pulumi.Input[str] load_balancer_ip: Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancer_source_ranges: If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature." More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        :param pulumi.Input[Sequence[pulumi.Input['ServicePortArgs']]] ports: The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        :param pulumi.Input[bool] publish_not_ready_addresses: publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet's Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered "ready" even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] selector: Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
        :param pulumi.Input[str] session_affinity: Supports "ClientIP" and "None". Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        :param pulumi.Input['SessionAffinityConfigArgs'] session_affinity_config: sessionAffinityConfig contains the configurations of session affinity.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topology_keys: topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value "*" may be used to mean "any topology". This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied. This field is alpha-level and is only honored by servers that enable the ServiceTopology feature. This field is deprecated and will be removed in a future version.
        :param pulumi.Input[Union[str, 'ServiceSpecType']] type: type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. "ExternalName" aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
        """
        if allocate_load_balancer_node_ports is not None:
            pulumi.set(__self__, "allocate_load_balancer_node_ports", allocate_load_balancer_node_ports)
        if cluster_ip is not None:
            pulumi.set(__self__, "cluster_ip", cluster_ip)
        if cluster_ips is not None:
            pulumi.set(__self__, "cluster_ips", cluster_ips)
        if external_ips is not None:
            pulumi.set(__self__, "external_ips", external_ips)
        if external_name is not None:
            pulumi.set(__self__, "external_name", external_name)
        if external_traffic_policy is not None:
            pulumi.set(__self__, "external_traffic_policy", external_traffic_policy)
        if health_check_node_port is not None:
            pulumi.set(__self__, "health_check_node_port", health_check_node_port)
        if internal_traffic_policy is not None:
            pulumi.set(__self__, "internal_traffic_policy", internal_traffic_policy)
        if ip_families is not None:
            pulumi.set(__self__, "ip_families", ip_families)
        if ip_family is not None:
            pulumi.set(__self__, "ip_family", ip_family)
        if ip_family_policy is not None:
            pulumi.set(__self__, "ip_family_policy", ip_family_policy)
        if load_balancer_class is not None:
            pulumi.set(__self__, "load_balancer_class", load_balancer_class)
        if load_balancer_ip is not None:
            pulumi.set(__self__, "load_balancer_ip", load_balancer_ip)
        if load_balancer_source_ranges is not None:
            pulumi.set(__self__, "load_balancer_source_ranges", load_balancer_source_ranges)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if publish_not_ready_addresses is not None:
            pulumi.set(__self__, "publish_not_ready_addresses", publish_not_ready_addresses)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if session_affinity_config is not None:
            pulumi.set(__self__, "session_affinity_config", session_affinity_config)
        if topology_keys is not None:
            pulumi.set(__self__, "topology_keys", topology_keys)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="allocateLoadBalancerNodePorts")
    def allocate_load_balancer_node_ports(self) -> Optional[pulumi.Input[bool]]:
        """
        allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is "true". It may be set to "false" if the cluster load-balancer does not rely on NodePorts. allocateLoadBalancerNodePorts may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type. This field is alpha-level and is only honored by servers that enable the ServiceLBNodePortControl feature.
        """
        return pulumi.get(self, "allocate_load_balancer_node_ports")

    @allocate_load_balancer_node_ports.setter
    def allocate_load_balancer_node_ports(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocate_load_balancer_node_ports", value)

    @property
    @pulumi.getter(name="clusterIP")
    def cluster_ip(self) -> Optional[pulumi.Input[str]]:
        """
        clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are "None", empty string (""), or a valid IP address. Setting this to "None" makes a "headless service" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        """
        return pulumi.get(self, "cluster_ip")

    @cluster_ip.setter
    def cluster_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ip", value)

    @property
    @pulumi.getter(name="clusterIPs")
    def cluster_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are "None", empty string (""), or a valid IP address.  Setting this to "None" makes a "headless service" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.

        Unless the "IPv6DualStack" feature gate is enabled, this field is limited to one value, which must be the same as the clusterIP field.  If the feature gate is enabled, this field may hold a maximum of two entries (dual-stack IPs, in either order).  These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        """
        return pulumi.get(self, "cluster_ips")

    @cluster_ips.setter
    def cluster_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cluster_ips", value)

    @property
    @pulumi.getter(name="externalIPs")
    def external_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
        """
        return pulumi.get(self, "external_ips")

    @external_ips.setter
    def external_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "external_ips", value)

    @property
    @pulumi.getter(name="externalName")
    def external_name(self) -> Optional[pulumi.Input[str]]:
        """
        externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be "ExternalName".
        """
        return pulumi.get(self, "external_name")

    @external_name.setter
    def external_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_name", value)

    @property
    @pulumi.getter(name="externalTrafficPolicy")
    def external_traffic_policy(self) -> Optional[pulumi.Input[str]]:
        """
        externalTrafficPolicy denotes if this Service desires to route external traffic to node-local or cluster-wide endpoints. "Local" preserves the client source IP and avoids a second hop for LoadBalancer and Nodeport type services, but risks potentially imbalanced traffic spreading. "Cluster" obscures the client source IP and may cause a second hop to another node, but should have good overall load-spreading.
        """
        return pulumi.get(self, "external_traffic_policy")

    @external_traffic_policy.setter
    def external_traffic_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_traffic_policy", value)

    @property
    @pulumi.getter(name="healthCheckNodePort")
    def health_check_node_port(self) -> Optional[pulumi.Input[int]]:
        """
        healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type).
        """
        return pulumi.get(self, "health_check_node_port")

    @health_check_node_port.setter
    def health_check_node_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_node_port", value)

    @property
    @pulumi.getter(name="internalTrafficPolicy")
    def internal_traffic_policy(self) -> Optional[pulumi.Input[str]]:
        """
        InternalTrafficPolicy specifies if the cluster internal traffic should be routed to all endpoints or node-local endpoints only. "Cluster" routes internal traffic to a Service to all endpoints. "Local" routes traffic to node-local endpoints only, traffic is dropped if no node-local endpoints are ready. The default value is "Cluster".
        """
        return pulumi.get(self, "internal_traffic_policy")

    @internal_traffic_policy.setter
    def internal_traffic_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_traffic_policy", value)

    @property
    @pulumi.getter(name="ipFamilies")
    def ip_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service, and is gated by the "IPv6DualStack" feature gate.  This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail.  This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service.  Valid values are "IPv4" and "IPv6".  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to "headless" services.  This field will be wiped when updating a Service to type ExternalName.

        This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
        """
        return pulumi.get(self, "ip_families")

    @ip_families.setter
    def ip_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_families", value)

    @property
    @pulumi.getter(name="ipFamily")
    def ip_family(self) -> Optional[pulumi.Input[str]]:
        """
        ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is available in the cluster.  If no IP family is requested, the cluster's primary IP family will be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.
        """
        return pulumi.get(self, "ip_family")

    @ip_family.setter
    def ip_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_family", value)

    @property
    @pulumi.getter(name="ipFamilyPolicy")
    def ip_family_policy(self) -> Optional[pulumi.Input[str]]:
        """
        IPFamilyPolicy represents the dual-stack-ness requested or required by this Service, and is gated by the "IPv6DualStack" feature gate.  If there is no value provided, then this field will be set to SingleStack. Services can be "SingleStack" (a single IP family), "PreferDualStack" (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or "RequireDualStack" (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field.  This field will be wiped when updating a service to type ExternalName.
        """
        return pulumi.get(self, "ip_family_policy")

    @ip_family_policy.setter
    def ip_family_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_family_policy", value)

    @property
    @pulumi.getter(name="loadBalancerClass")
    def load_balancer_class(self) -> Optional[pulumi.Input[str]]:
        """
        loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. "internal-vip" or "example.com/internal-vip". Unprefixed names are reserved for end-users. This field can only be set when the Service type is 'LoadBalancer'. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type 'LoadBalancer'. Once set, it can not be changed. This field will be wiped when a service is updated to a non 'LoadBalancer' type.
        """
        return pulumi.get(self, "load_balancer_class")

    @load_balancer_class.setter
    def load_balancer_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_class", value)

    @property
    @pulumi.getter(name="loadBalancerIP")
    def load_balancer_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.
        """
        return pulumi.get(self, "load_balancer_ip")

    @load_balancer_ip.setter
    def load_balancer_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_ip", value)

    @property
    @pulumi.getter(name="loadBalancerSourceRanges")
    def load_balancer_source_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature." More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        """
        return pulumi.get(self, "load_balancer_source_ranges")

    @load_balancer_source_ranges.setter
    def load_balancer_source_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "load_balancer_source_ranges", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePortArgs']]]]:
        """
        The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="publishNotReadyAddresses")
    def publish_not_ready_addresses(self) -> Optional[pulumi.Input[bool]]:
        """
        publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet's Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered "ready" even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
        """
        return pulumi.get(self, "publish_not_ready_addresses")

    @publish_not_ready_addresses.setter
    def publish_not_ready_addresses(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish_not_ready_addresses", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        Supports "ClientIP" and "None". Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter(name="sessionAffinityConfig")
    def session_affinity_config(self) -> Optional[pulumi.Input['SessionAffinityConfigArgs']]:
        """
        sessionAffinityConfig contains the configurations of session affinity.
        """
        return pulumi.get(self, "session_affinity_config")

    @session_affinity_config.setter
    def session_affinity_config(self, value: Optional[pulumi.Input['SessionAffinityConfigArgs']]):
        pulumi.set(self, "session_affinity_config", value)

    @property
    @pulumi.getter(name="topologyKeys")
    def topology_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value "*" may be used to mean "any topology". This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied. This field is alpha-level and is only honored by servers that enable the ServiceTopology feature. This field is deprecated and will be removed in a future version.
        """
        return pulumi.get(self, "topology_keys")

    @topology_keys.setter
    def topology_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topology_keys", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ServiceSpecType']]]:
        """
        type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. "ExternalName" aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ServiceSpecType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceStatusArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]]] = None,
                 load_balancer: Optional[pulumi.Input['LoadBalancerStatusArgs']] = None):
        """
        ServiceStatus represents the current status of a service.
        :param pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]] conditions: Current service state
        :param pulumi.Input['LoadBalancerStatusArgs'] load_balancer: LoadBalancer contains the current status of the load-balancer, if one is present.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]]]:
        """
        Current service state
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['LoadBalancerStatusArgs']]:
        """
        LoadBalancer contains the current status of the load-balancer, if one is present.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['LoadBalancerStatusArgs']]):
        pulumi.set(self, "load_balancer", value)


@pulumi.input_type
class SessionAffinityConfigArgs:
    def __init__(__self__, *,
                 client_ip: Optional[pulumi.Input['ClientIPConfigArgs']] = None):
        """
        SessionAffinityConfig represents the configurations of session affinity.
        :param pulumi.Input['ClientIPConfigArgs'] client_ip: clientIP contains the configurations of Client IP based session affinity.
        """
        if client_ip is not None:
            pulumi.set(__self__, "client_ip", client_ip)

    @property
    @pulumi.getter(name="clientIP")
    def client_ip(self) -> Optional[pulumi.Input['ClientIPConfigArgs']]:
        """
        clientIP contains the configurations of Client IP based session affinity.
        """
        return pulumi.get(self, "client_ip")

    @client_ip.setter
    def client_ip(self, value: Optional[pulumi.Input['ClientIPConfigArgs']]):
        pulumi.set(self, "client_ip", value)


@pulumi.input_type
class StorageOSPersistentVolumeSourceArgs:
    def __init__(__self__, *,
                 fs_type: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_ref: Optional[pulumi.Input['ObjectReferenceArgs']] = None,
                 volume_name: Optional[pulumi.Input[str]] = None,
                 volume_namespace: Optional[pulumi.Input[str]] = None):
        """
        Represents a StorageOS persistent volume resource.
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param pulumi.Input[bool] read_only: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param pulumi.Input['ObjectReferenceArgs'] secret_ref: SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.
        :param pulumi.Input[str] volume_name: VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.
        :param pulumi.Input[str] volume_namespace: VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)
        if volume_namespace is not None:
            pulumi.set(__self__, "volume_namespace", volume_namespace)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['ObjectReferenceArgs']]:
        """
        SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['ObjectReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[str]]:
        """
        VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_name", value)

    @property
    @pulumi.getter(name="volumeNamespace")
    def volume_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.
        """
        return pulumi.get(self, "volume_namespace")

    @volume_namespace.setter
    def volume_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_namespace", value)


@pulumi.input_type
class StorageOSVolumeSourceArgs:
    def __init__(__self__, *,
                 fs_type: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secret_ref: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None,
                 volume_name: Optional[pulumi.Input[str]] = None,
                 volume_namespace: Optional[pulumi.Input[str]] = None):
        """
        Represents a StorageOS persistent volume resource.
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param pulumi.Input[bool] read_only: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param pulumi.Input['LocalObjectReferenceArgs'] secret_ref: SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.
        :param pulumi.Input[str] volume_name: VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.
        :param pulumi.Input[str] volume_namespace: VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)
        if volume_namespace is not None:
            pulumi.set(__self__, "volume_namespace", volume_namespace)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[str]]:
        """
        VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_name", value)

    @property
    @pulumi.getter(name="volumeNamespace")
    def volume_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.
        """
        return pulumi.get(self, "volume_namespace")

    @volume_namespace.setter
    def volume_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_namespace", value)


@pulumi.input_type
class SysctlArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Sysctl defines a kernel parameter to be set
        :param pulumi.Input[str] name: Name of a property to set
        :param pulumi.Input[str] value: Value of a property to set
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of a property to set
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of a property to set
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TCPSocketActionArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[Union[int, str]],
                 host: Optional[pulumi.Input[str]] = None):
        """
        TCPSocketAction describes an action based on opening a socket
        :param pulumi.Input[Union[int, str]] port: Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param pulumi.Input[str] host: Optional: Host name to connect to, defaults to the pod IP.
        """
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[Union[int, str]]:
        """
        Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[Union[int, str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: Host name to connect to, defaults to the pod IP.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)


@pulumi.input_type
class TaintArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 key: pulumi.Input[str],
                 time_added: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        The node this Taint is attached to has the "effect" on any pod that does not tolerate the Taint.
        :param pulumi.Input[str] effect: Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule, PreferNoSchedule and NoExecute.
        :param pulumi.Input[str] key: Required. The taint key to be applied to a node.
        :param pulumi.Input[str] time_added: TimeAdded represents the time at which the taint was added. It is only written for NoExecute taints.
        :param pulumi.Input[str] value: The taint value corresponding to the taint key.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        if time_added is not None:
            pulumi.set(__self__, "time_added", time_added)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule, PreferNoSchedule and NoExecute.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Required. The taint key to be applied to a node.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="timeAdded")
    def time_added(self) -> Optional[pulumi.Input[str]]:
        """
        TimeAdded represents the time at which the taint was added. It is only written for NoExecute taints.
        """
        return pulumi.get(self, "time_added")

    @time_added.setter
    def time_added(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_added", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The taint value corresponding to the taint key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TolerationArgs:
    def __init__(__self__, *,
                 effect: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 toleration_seconds: Optional[pulumi.Input[int]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
        :param pulumi.Input[str] effect: Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
        :param pulumi.Input[str] key: Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
        :param pulumi.Input[str] operator: Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
        :param pulumi.Input[int] toleration_seconds: TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
        :param pulumi.Input[str] value: Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if toleration_seconds is not None:
            pulumi.set(__self__, "toleration_seconds", toleration_seconds)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[str]]:
        """
        Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        """
        Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="tolerationSeconds")
    def toleration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
        """
        return pulumi.get(self, "toleration_seconds")

    @toleration_seconds.setter
    def toleration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "toleration_seconds", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TopologySelectorLabelRequirementArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        A topology selector requirement is a selector that matches given label. This is an alpha feature and may change in the future.
        :param pulumi.Input[str] key: The label key that the selector applies to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: An array of string values. One value must match the label to be selected. Each entry in Values is ORed.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The label key that the selector applies to.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        An array of string values. One value must match the label to be selected. Each entry in Values is ORed.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class TopologySelectorTermArgs:
    def __init__(__self__, *,
                 match_label_expressions: Optional[pulumi.Input[Sequence[pulumi.Input['TopologySelectorLabelRequirementArgs']]]] = None):
        """
        A topology selector term represents the result of label queries. A null or empty topology selector term matches no objects. The requirements of them are ANDed. It provides a subset of functionality as NodeSelectorTerm. This is an alpha feature and may change in the future.
        :param pulumi.Input[Sequence[pulumi.Input['TopologySelectorLabelRequirementArgs']]] match_label_expressions: A list of topology selector requirements by labels.
        """
        if match_label_expressions is not None:
            pulumi.set(__self__, "match_label_expressions", match_label_expressions)

    @property
    @pulumi.getter(name="matchLabelExpressions")
    def match_label_expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopologySelectorLabelRequirementArgs']]]]:
        """
        A list of topology selector requirements by labels.
        """
        return pulumi.get(self, "match_label_expressions")

    @match_label_expressions.setter
    def match_label_expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopologySelectorLabelRequirementArgs']]]]):
        pulumi.set(self, "match_label_expressions", value)


@pulumi.input_type
class TopologySpreadConstraintArgs:
    def __init__(__self__, *,
                 max_skew: pulumi.Input[int],
                 topology_key: pulumi.Input[str],
                 when_unsatisfiable: pulumi.Input[str],
                 label_selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None):
        """
        TopologySpreadConstraint specifies how to spread matching pods among the given topology.
        :param pulumi.Input[int] max_skew: MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 1/1/0: | zone1 | zone2 | zone3 | |   P   |   P   |       | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.
        :param pulumi.Input[str] topology_key: TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a "bucket", and try to put balanced number of pods into each bucket. It's a required field.
        :param pulumi.Input[str] when_unsatisfiable: WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint. - DoNotSchedule (default) tells the scheduler not to schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any location,
                 but giving higher precedence to topologies that would help reduce the
                 skew.
               A constraint is considered "Unsatisfiable" for an incoming pod if and only if every possible node assigment for that pod would violate "MaxSkew" on some topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] label_selector: LabelSelector is used to find matching pods. Pods that match this label selector are counted to determine the number of pods in their corresponding topology domain.
        """
        pulumi.set(__self__, "max_skew", max_skew)
        pulumi.set(__self__, "topology_key", topology_key)
        pulumi.set(__self__, "when_unsatisfiable", when_unsatisfiable)
        if label_selector is not None:
            pulumi.set(__self__, "label_selector", label_selector)

    @property
    @pulumi.getter(name="maxSkew")
    def max_skew(self) -> pulumi.Input[int]:
        """
        MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 1/1/0: | zone1 | zone2 | zone3 | |   P   |   P   |       | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.
        """
        return pulumi.get(self, "max_skew")

    @max_skew.setter
    def max_skew(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_skew", value)

    @property
    @pulumi.getter(name="topologyKey")
    def topology_key(self) -> pulumi.Input[str]:
        """
        TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a "bucket", and try to put balanced number of pods into each bucket. It's a required field.
        """
        return pulumi.get(self, "topology_key")

    @topology_key.setter
    def topology_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "topology_key", value)

    @property
    @pulumi.getter(name="whenUnsatisfiable")
    def when_unsatisfiable(self) -> pulumi.Input[str]:
        """
        WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint. - DoNotSchedule (default) tells the scheduler not to schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any location,
          but giving higher precedence to topologies that would help reduce the
          skew.
        A constraint is considered "Unsatisfiable" for an incoming pod if and only if every possible node assigment for that pod would violate "MaxSkew" on some topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.
        """
        return pulumi.get(self, "when_unsatisfiable")

    @when_unsatisfiable.setter
    def when_unsatisfiable(self, value: pulumi.Input[str]):
        pulumi.set(self, "when_unsatisfiable", value)

    @property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        LabelSelector is used to find matching pods. Pods that match this label selector are counted to determine the number of pods in their corresponding topology domain.
        """
        return pulumi.get(self, "label_selector")

    @label_selector.setter
    def label_selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "label_selector", value)


@pulumi.input_type
class TypedLocalObjectReferenceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 name: pulumi.Input[str],
                 api_group: Optional[pulumi.Input[str]] = None):
        """
        TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace.
        :param pulumi.Input[str] kind: Kind is the type of resource being referenced
        :param pulumi.Input[str] name: Name is the name of resource being referenced
        :param pulumi.Input[str] api_group: APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Kind is the type of resource being referenced
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name is the name of resource being referenced
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[pulumi.Input[str]]:
        """
        APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        """
        return pulumi.get(self, "api_group")

    @api_group.setter
    def api_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_group", value)


@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 aws_elastic_block_store: Optional[pulumi.Input['AWSElasticBlockStoreVolumeSourceArgs']] = None,
                 azure_disk: Optional[pulumi.Input['AzureDiskVolumeSourceArgs']] = None,
                 azure_file: Optional[pulumi.Input['AzureFileVolumeSourceArgs']] = None,
                 cephfs: Optional[pulumi.Input['CephFSVolumeSourceArgs']] = None,
                 cinder: Optional[pulumi.Input['CinderVolumeSourceArgs']] = None,
                 config_map: Optional[pulumi.Input['ConfigMapVolumeSourceArgs']] = None,
                 csi: Optional[pulumi.Input['CSIVolumeSourceArgs']] = None,
                 downward_api: Optional[pulumi.Input['DownwardAPIVolumeSourceArgs']] = None,
                 empty_dir: Optional[pulumi.Input['EmptyDirVolumeSourceArgs']] = None,
                 ephemeral: Optional[pulumi.Input['EphemeralVolumeSourceArgs']] = None,
                 fc: Optional[pulumi.Input['FCVolumeSourceArgs']] = None,
                 flex_volume: Optional[pulumi.Input['FlexVolumeSourceArgs']] = None,
                 flocker: Optional[pulumi.Input['FlockerVolumeSourceArgs']] = None,
                 gce_persistent_disk: Optional[pulumi.Input['GCEPersistentDiskVolumeSourceArgs']] = None,
                 git_repo: Optional[pulumi.Input['GitRepoVolumeSourceArgs']] = None,
                 glusterfs: Optional[pulumi.Input['GlusterfsVolumeSourceArgs']] = None,
                 host_path: Optional[pulumi.Input['HostPathVolumeSourceArgs']] = None,
                 iscsi: Optional[pulumi.Input['ISCSIVolumeSourceArgs']] = None,
                 nfs: Optional[pulumi.Input['NFSVolumeSourceArgs']] = None,
                 persistent_volume_claim: Optional[pulumi.Input['PersistentVolumeClaimVolumeSourceArgs']] = None,
                 photon_persistent_disk: Optional[pulumi.Input['PhotonPersistentDiskVolumeSourceArgs']] = None,
                 portworx_volume: Optional[pulumi.Input['PortworxVolumeSourceArgs']] = None,
                 projected: Optional[pulumi.Input['ProjectedVolumeSourceArgs']] = None,
                 quobyte: Optional[pulumi.Input['QuobyteVolumeSourceArgs']] = None,
                 rbd: Optional[pulumi.Input['RBDVolumeSourceArgs']] = None,
                 scale_io: Optional[pulumi.Input['ScaleIOVolumeSourceArgs']] = None,
                 secret: Optional[pulumi.Input['SecretVolumeSourceArgs']] = None,
                 storageos: Optional[pulumi.Input['StorageOSVolumeSourceArgs']] = None,
                 vsphere_volume: Optional[pulumi.Input['VsphereVirtualDiskVolumeSourceArgs']] = None):
        """
        Volume represents a named volume in a pod that may be accessed by any container in the pod.
        :param pulumi.Input[str] name: Volume's name. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input['AWSElasticBlockStoreVolumeSourceArgs'] aws_elastic_block_store: AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param pulumi.Input['AzureDiskVolumeSourceArgs'] azure_disk: AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
        :param pulumi.Input['AzureFileVolumeSourceArgs'] azure_file: AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
        :param pulumi.Input['CephFSVolumeSourceArgs'] cephfs: CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
        :param pulumi.Input['CinderVolumeSourceArgs'] cinder: Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param pulumi.Input['ConfigMapVolumeSourceArgs'] config_map: ConfigMap represents a configMap that should populate this volume
        :param pulumi.Input['CSIVolumeSourceArgs'] csi: CSI (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).
        :param pulumi.Input['DownwardAPIVolumeSourceArgs'] downward_api: DownwardAPI represents downward API about the pod that should populate this volume
        :param pulumi.Input['EmptyDirVolumeSourceArgs'] empty_dir: EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        :param pulumi.Input['EphemeralVolumeSourceArgs'] ephemeral: Ephemeral represents a volume that is handled by a cluster storage driver. The volume's lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.
               
               Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity
                  tracking are needed,
               c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through
                  a PersistentVolumeClaim (see EphemeralVolumeSource for more
                  information on the connection between this volume type
                  and PersistentVolumeClaim).
               
               Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.
               
               Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.
               
               A pod can use both types of ephemeral volumes and persistent volumes at the same time.
               
               This is a beta feature and only available when the GenericEphemeralVolume feature gate is enabled.
        :param pulumi.Input['FCVolumeSourceArgs'] fc: FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
        :param pulumi.Input['FlexVolumeSourceArgs'] flex_volume: FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
        :param pulumi.Input['FlockerVolumeSourceArgs'] flocker: Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running
        :param pulumi.Input['GCEPersistentDiskVolumeSourceArgs'] gce_persistent_disk: GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param pulumi.Input['GitRepoVolumeSourceArgs'] git_repo: GitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
        :param pulumi.Input['GlusterfsVolumeSourceArgs'] glusterfs: Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md
        :param pulumi.Input['HostPathVolumeSourceArgs'] host_path: HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        :param pulumi.Input['ISCSIVolumeSourceArgs'] iscsi: ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md
        :param pulumi.Input['NFSVolumeSourceArgs'] nfs: NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        :param pulumi.Input['PersistentVolumeClaimVolumeSourceArgs'] persistent_volume_claim: PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        :param pulumi.Input['PhotonPersistentDiskVolumeSourceArgs'] photon_persistent_disk: PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
        :param pulumi.Input['PortworxVolumeSourceArgs'] portworx_volume: PortworxVolume represents a portworx volume attached and mounted on kubelets host machine
        :param pulumi.Input['ProjectedVolumeSourceArgs'] projected: Items for all in one resources secrets, configmaps, and downward API
        :param pulumi.Input['QuobyteVolumeSourceArgs'] quobyte: Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
        :param pulumi.Input['RBDVolumeSourceArgs'] rbd: RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
        :param pulumi.Input['ScaleIOVolumeSourceArgs'] scale_io: ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
        :param pulumi.Input['SecretVolumeSourceArgs'] secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        :param pulumi.Input['StorageOSVolumeSourceArgs'] storageos: StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
        :param pulumi.Input['VsphereVirtualDiskVolumeSourceArgs'] vsphere_volume: VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
        """
        pulumi.set(__self__, "name", name)
        if aws_elastic_block_store is not None:
            pulumi.set(__self__, "aws_elastic_block_store", aws_elastic_block_store)
        if azure_disk is not None:
            pulumi.set(__self__, "azure_disk", azure_disk)
        if azure_file is not None:
            pulumi.set(__self__, "azure_file", azure_file)
        if cephfs is not None:
            pulumi.set(__self__, "cephfs", cephfs)
        if cinder is not None:
            pulumi.set(__self__, "cinder", cinder)
        if config_map is not None:
            pulumi.set(__self__, "config_map", config_map)
        if csi is not None:
            pulumi.set(__self__, "csi", csi)
        if downward_api is not None:
            pulumi.set(__self__, "downward_api", downward_api)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if ephemeral is not None:
            pulumi.set(__self__, "ephemeral", ephemeral)
        if fc is not None:
            pulumi.set(__self__, "fc", fc)
        if flex_volume is not None:
            pulumi.set(__self__, "flex_volume", flex_volume)
        if flocker is not None:
            pulumi.set(__self__, "flocker", flocker)
        if gce_persistent_disk is not None:
            pulumi.set(__self__, "gce_persistent_disk", gce_persistent_disk)
        if git_repo is not None:
            pulumi.set(__self__, "git_repo", git_repo)
        if glusterfs is not None:
            pulumi.set(__self__, "glusterfs", glusterfs)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if iscsi is not None:
            pulumi.set(__self__, "iscsi", iscsi)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if persistent_volume_claim is not None:
            pulumi.set(__self__, "persistent_volume_claim", persistent_volume_claim)
        if photon_persistent_disk is not None:
            pulumi.set(__self__, "photon_persistent_disk", photon_persistent_disk)
        if portworx_volume is not None:
            pulumi.set(__self__, "portworx_volume", portworx_volume)
        if projected is not None:
            pulumi.set(__self__, "projected", projected)
        if quobyte is not None:
            pulumi.set(__self__, "quobyte", quobyte)
        if rbd is not None:
            pulumi.set(__self__, "rbd", rbd)
        if scale_io is not None:
            pulumi.set(__self__, "scale_io", scale_io)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if storageos is not None:
            pulumi.set(__self__, "storageos", storageos)
        if vsphere_volume is not None:
            pulumi.set(__self__, "vsphere_volume", vsphere_volume)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Volume's name. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="awsElasticBlockStore")
    def aws_elastic_block_store(self) -> Optional[pulumi.Input['AWSElasticBlockStoreVolumeSourceArgs']]:
        """
        AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "aws_elastic_block_store")

    @aws_elastic_block_store.setter
    def aws_elastic_block_store(self, value: Optional[pulumi.Input['AWSElasticBlockStoreVolumeSourceArgs']]):
        pulumi.set(self, "aws_elastic_block_store", value)

    @property
    @pulumi.getter(name="azureDisk")
    def azure_disk(self) -> Optional[pulumi.Input['AzureDiskVolumeSourceArgs']]:
        """
        AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
        """
        return pulumi.get(self, "azure_disk")

    @azure_disk.setter
    def azure_disk(self, value: Optional[pulumi.Input['AzureDiskVolumeSourceArgs']]):
        pulumi.set(self, "azure_disk", value)

    @property
    @pulumi.getter(name="azureFile")
    def azure_file(self) -> Optional[pulumi.Input['AzureFileVolumeSourceArgs']]:
        """
        AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
        """
        return pulumi.get(self, "azure_file")

    @azure_file.setter
    def azure_file(self, value: Optional[pulumi.Input['AzureFileVolumeSourceArgs']]):
        pulumi.set(self, "azure_file", value)

    @property
    @pulumi.getter
    def cephfs(self) -> Optional[pulumi.Input['CephFSVolumeSourceArgs']]:
        """
        CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
        """
        return pulumi.get(self, "cephfs")

    @cephfs.setter
    def cephfs(self, value: Optional[pulumi.Input['CephFSVolumeSourceArgs']]):
        pulumi.set(self, "cephfs", value)

    @property
    @pulumi.getter
    def cinder(self) -> Optional[pulumi.Input['CinderVolumeSourceArgs']]:
        """
        Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "cinder")

    @cinder.setter
    def cinder(self, value: Optional[pulumi.Input['CinderVolumeSourceArgs']]):
        pulumi.set(self, "cinder", value)

    @property
    @pulumi.getter(name="configMap")
    def config_map(self) -> Optional[pulumi.Input['ConfigMapVolumeSourceArgs']]:
        """
        ConfigMap represents a configMap that should populate this volume
        """
        return pulumi.get(self, "config_map")

    @config_map.setter
    def config_map(self, value: Optional[pulumi.Input['ConfigMapVolumeSourceArgs']]):
        pulumi.set(self, "config_map", value)

    @property
    @pulumi.getter
    def csi(self) -> Optional[pulumi.Input['CSIVolumeSourceArgs']]:
        """
        CSI (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).
        """
        return pulumi.get(self, "csi")

    @csi.setter
    def csi(self, value: Optional[pulumi.Input['CSIVolumeSourceArgs']]):
        pulumi.set(self, "csi", value)

    @property
    @pulumi.getter(name="downwardAPI")
    def downward_api(self) -> Optional[pulumi.Input['DownwardAPIVolumeSourceArgs']]:
        """
        DownwardAPI represents downward API about the pod that should populate this volume
        """
        return pulumi.get(self, "downward_api")

    @downward_api.setter
    def downward_api(self, value: Optional[pulumi.Input['DownwardAPIVolumeSourceArgs']]):
        pulumi.set(self, "downward_api", value)

    @property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional[pulumi.Input['EmptyDirVolumeSourceArgs']]:
        """
        EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        """
        return pulumi.get(self, "empty_dir")

    @empty_dir.setter
    def empty_dir(self, value: Optional[pulumi.Input['EmptyDirVolumeSourceArgs']]):
        pulumi.set(self, "empty_dir", value)

    @property
    @pulumi.getter
    def ephemeral(self) -> Optional[pulumi.Input['EphemeralVolumeSourceArgs']]:
        """
        Ephemeral represents a volume that is handled by a cluster storage driver. The volume's lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.

        Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity
           tracking are needed,
        c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through
           a PersistentVolumeClaim (see EphemeralVolumeSource for more
           information on the connection between this volume type
           and PersistentVolumeClaim).

        Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.

        Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.

        A pod can use both types of ephemeral volumes and persistent volumes at the same time.

        This is a beta feature and only available when the GenericEphemeralVolume feature gate is enabled.
        """
        return pulumi.get(self, "ephemeral")

    @ephemeral.setter
    def ephemeral(self, value: Optional[pulumi.Input['EphemeralVolumeSourceArgs']]):
        pulumi.set(self, "ephemeral", value)

    @property
    @pulumi.getter
    def fc(self) -> Optional[pulumi.Input['FCVolumeSourceArgs']]:
        """
        FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
        """
        return pulumi.get(self, "fc")

    @fc.setter
    def fc(self, value: Optional[pulumi.Input['FCVolumeSourceArgs']]):
        pulumi.set(self, "fc", value)

    @property
    @pulumi.getter(name="flexVolume")
    def flex_volume(self) -> Optional[pulumi.Input['FlexVolumeSourceArgs']]:
        """
        FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
        """
        return pulumi.get(self, "flex_volume")

    @flex_volume.setter
    def flex_volume(self, value: Optional[pulumi.Input['FlexVolumeSourceArgs']]):
        pulumi.set(self, "flex_volume", value)

    @property
    @pulumi.getter
    def flocker(self) -> Optional[pulumi.Input['FlockerVolumeSourceArgs']]:
        """
        Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running
        """
        return pulumi.get(self, "flocker")

    @flocker.setter
    def flocker(self, value: Optional[pulumi.Input['FlockerVolumeSourceArgs']]):
        pulumi.set(self, "flocker", value)

    @property
    @pulumi.getter(name="gcePersistentDisk")
    def gce_persistent_disk(self) -> Optional[pulumi.Input['GCEPersistentDiskVolumeSourceArgs']]:
        """
        GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "gce_persistent_disk")

    @gce_persistent_disk.setter
    def gce_persistent_disk(self, value: Optional[pulumi.Input['GCEPersistentDiskVolumeSourceArgs']]):
        pulumi.set(self, "gce_persistent_disk", value)

    @property
    @pulumi.getter(name="gitRepo")
    def git_repo(self) -> Optional[pulumi.Input['GitRepoVolumeSourceArgs']]:
        """
        GitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
        """
        return pulumi.get(self, "git_repo")

    @git_repo.setter
    def git_repo(self, value: Optional[pulumi.Input['GitRepoVolumeSourceArgs']]):
        pulumi.set(self, "git_repo", value)

    @property
    @pulumi.getter
    def glusterfs(self) -> Optional[pulumi.Input['GlusterfsVolumeSourceArgs']]:
        """
        Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md
        """
        return pulumi.get(self, "glusterfs")

    @glusterfs.setter
    def glusterfs(self, value: Optional[pulumi.Input['GlusterfsVolumeSourceArgs']]):
        pulumi.set(self, "glusterfs", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input['HostPathVolumeSourceArgs']]:
        """
        HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input['HostPathVolumeSourceArgs']]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter
    def iscsi(self) -> Optional[pulumi.Input['ISCSIVolumeSourceArgs']]:
        """
        ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md
        """
        return pulumi.get(self, "iscsi")

    @iscsi.setter
    def iscsi(self, value: Optional[pulumi.Input['ISCSIVolumeSourceArgs']]):
        pulumi.set(self, "iscsi", value)

    @property
    @pulumi.getter
    def nfs(self) -> Optional[pulumi.Input['NFSVolumeSourceArgs']]:
        """
        NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "nfs")

    @nfs.setter
    def nfs(self, value: Optional[pulumi.Input['NFSVolumeSourceArgs']]):
        pulumi.set(self, "nfs", value)

    @property
    @pulumi.getter(name="persistentVolumeClaim")
    def persistent_volume_claim(self) -> Optional[pulumi.Input['PersistentVolumeClaimVolumeSourceArgs']]:
        """
        PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "persistent_volume_claim")

    @persistent_volume_claim.setter
    def persistent_volume_claim(self, value: Optional[pulumi.Input['PersistentVolumeClaimVolumeSourceArgs']]):
        pulumi.set(self, "persistent_volume_claim", value)

    @property
    @pulumi.getter(name="photonPersistentDisk")
    def photon_persistent_disk(self) -> Optional[pulumi.Input['PhotonPersistentDiskVolumeSourceArgs']]:
        """
        PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
        """
        return pulumi.get(self, "photon_persistent_disk")

    @photon_persistent_disk.setter
    def photon_persistent_disk(self, value: Optional[pulumi.Input['PhotonPersistentDiskVolumeSourceArgs']]):
        pulumi.set(self, "photon_persistent_disk", value)

    @property
    @pulumi.getter(name="portworxVolume")
    def portworx_volume(self) -> Optional[pulumi.Input['PortworxVolumeSourceArgs']]:
        """
        PortworxVolume represents a portworx volume attached and mounted on kubelets host machine
        """
        return pulumi.get(self, "portworx_volume")

    @portworx_volume.setter
    def portworx_volume(self, value: Optional[pulumi.Input['PortworxVolumeSourceArgs']]):
        pulumi.set(self, "portworx_volume", value)

    @property
    @pulumi.getter
    def projected(self) -> Optional[pulumi.Input['ProjectedVolumeSourceArgs']]:
        """
        Items for all in one resources secrets, configmaps, and downward API
        """
        return pulumi.get(self, "projected")

    @projected.setter
    def projected(self, value: Optional[pulumi.Input['ProjectedVolumeSourceArgs']]):
        pulumi.set(self, "projected", value)

    @property
    @pulumi.getter
    def quobyte(self) -> Optional[pulumi.Input['QuobyteVolumeSourceArgs']]:
        """
        Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
        """
        return pulumi.get(self, "quobyte")

    @quobyte.setter
    def quobyte(self, value: Optional[pulumi.Input['QuobyteVolumeSourceArgs']]):
        pulumi.set(self, "quobyte", value)

    @property
    @pulumi.getter
    def rbd(self) -> Optional[pulumi.Input['RBDVolumeSourceArgs']]:
        """
        RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
        """
        return pulumi.get(self, "rbd")

    @rbd.setter
    def rbd(self, value: Optional[pulumi.Input['RBDVolumeSourceArgs']]):
        pulumi.set(self, "rbd", value)

    @property
    @pulumi.getter(name="scaleIO")
    def scale_io(self) -> Optional[pulumi.Input['ScaleIOVolumeSourceArgs']]:
        """
        ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
        """
        return pulumi.get(self, "scale_io")

    @scale_io.setter
    def scale_io(self, value: Optional[pulumi.Input['ScaleIOVolumeSourceArgs']]):
        pulumi.set(self, "scale_io", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input['SecretVolumeSourceArgs']]:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input['SecretVolumeSourceArgs']]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def storageos(self) -> Optional[pulumi.Input['StorageOSVolumeSourceArgs']]:
        """
        StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
        """
        return pulumi.get(self, "storageos")

    @storageos.setter
    def storageos(self, value: Optional[pulumi.Input['StorageOSVolumeSourceArgs']]):
        pulumi.set(self, "storageos", value)

    @property
    @pulumi.getter(name="vsphereVolume")
    def vsphere_volume(self) -> Optional[pulumi.Input['VsphereVirtualDiskVolumeSourceArgs']]:
        """
        VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
        """
        return pulumi.get(self, "vsphere_volume")

    @vsphere_volume.setter
    def vsphere_volume(self, value: Optional[pulumi.Input['VsphereVirtualDiskVolumeSourceArgs']]):
        pulumi.set(self, "vsphere_volume", value)


@pulumi.input_type
class VolumeDeviceArgs:
    def __init__(__self__, *,
                 device_path: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        volumeDevice describes a mapping of a raw block device within a container.
        :param pulumi.Input[str] device_path: devicePath is the path inside of the container that the device will be mapped to.
        :param pulumi.Input[str] name: name must match the name of a persistentVolumeClaim in the pod
        """
        pulumi.set(__self__, "device_path", device_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> pulumi.Input[str]:
        """
        devicePath is the path inside of the container that the device will be mapped to.
        """
        return pulumi.get(self, "device_path")

    @device_path.setter
    def device_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name must match the name of a persistentVolumeClaim in the pod
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class VolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: pulumi.Input[str],
                 name: pulumi.Input[str],
                 mount_propagation: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 sub_path: Optional[pulumi.Input[str]] = None,
                 sub_path_expr: Optional[pulumi.Input[str]] = None):
        """
        VolumeMount describes a mounting of a Volume within a container.
        :param pulumi.Input[str] mount_path: Path within the container at which the volume should be mounted.  Must not contain ':'.
        :param pulumi.Input[str] name: This must match the Name of a Volume.
        :param pulumi.Input[str] mount_propagation: mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10.
        :param pulumi.Input[bool] read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
        :param pulumi.Input[str] sub_path: Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
        :param pulumi.Input[str] sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). SubPathExpr and SubPath are mutually exclusive.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        if mount_propagation is not None:
            pulumi.set(__self__, "mount_propagation", mount_propagation)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)
        if sub_path_expr is not None:
            pulumi.set(__self__, "sub_path_expr", sub_path_expr)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[str]:
        """
        Path within the container at which the volume should be mounted.  Must not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="mountPropagation")
    def mount_propagation(self) -> Optional[pulumi.Input[str]]:
        """
        mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10.
        """
        return pulumi.get(self, "mount_propagation")

    @mount_propagation.setter
    def mount_propagation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_propagation", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
        """
        return pulumi.get(self, "sub_path")

    @sub_path.setter
    def sub_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_path", value)

    @property
    @pulumi.getter(name="subPathExpr")
    def sub_path_expr(self) -> Optional[pulumi.Input[str]]:
        """
        Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). SubPathExpr and SubPath are mutually exclusive.
        """
        return pulumi.get(self, "sub_path_expr")

    @sub_path_expr.setter
    def sub_path_expr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_path_expr", value)


@pulumi.input_type
class VolumeNodeAffinityArgs:
    def __init__(__self__, *,
                 required: Optional[pulumi.Input['NodeSelectorArgs']] = None):
        """
        VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from.
        :param pulumi.Input['NodeSelectorArgs'] required: Required specifies hard node constraints that must be met.
        """
        if required is not None:
            pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input['NodeSelectorArgs']]:
        """
        Required specifies hard node constraints that must be met.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input['NodeSelectorArgs']]):
        pulumi.set(self, "required", value)


@pulumi.input_type
class VolumeProjectionArgs:
    def __init__(__self__, *,
                 config_map: Optional[pulumi.Input['ConfigMapProjectionArgs']] = None,
                 downward_api: Optional[pulumi.Input['DownwardAPIProjectionArgs']] = None,
                 secret: Optional[pulumi.Input['SecretProjectionArgs']] = None,
                 service_account_token: Optional[pulumi.Input['ServiceAccountTokenProjectionArgs']] = None):
        """
        Projection that may be projected along with other supported volume types
        :param pulumi.Input['ConfigMapProjectionArgs'] config_map: information about the configMap data to project
        :param pulumi.Input['DownwardAPIProjectionArgs'] downward_api: information about the downwardAPI data to project
        :param pulumi.Input['SecretProjectionArgs'] secret: information about the secret data to project
        :param pulumi.Input['ServiceAccountTokenProjectionArgs'] service_account_token: information about the serviceAccountToken data to project
        """
        if config_map is not None:
            pulumi.set(__self__, "config_map", config_map)
        if downward_api is not None:
            pulumi.set(__self__, "downward_api", downward_api)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if service_account_token is not None:
            pulumi.set(__self__, "service_account_token", service_account_token)

    @property
    @pulumi.getter(name="configMap")
    def config_map(self) -> Optional[pulumi.Input['ConfigMapProjectionArgs']]:
        """
        information about the configMap data to project
        """
        return pulumi.get(self, "config_map")

    @config_map.setter
    def config_map(self, value: Optional[pulumi.Input['ConfigMapProjectionArgs']]):
        pulumi.set(self, "config_map", value)

    @property
    @pulumi.getter(name="downwardAPI")
    def downward_api(self) -> Optional[pulumi.Input['DownwardAPIProjectionArgs']]:
        """
        information about the downwardAPI data to project
        """
        return pulumi.get(self, "downward_api")

    @downward_api.setter
    def downward_api(self, value: Optional[pulumi.Input['DownwardAPIProjectionArgs']]):
        pulumi.set(self, "downward_api", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input['SecretProjectionArgs']]:
        """
        information about the secret data to project
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input['SecretProjectionArgs']]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="serviceAccountToken")
    def service_account_token(self) -> Optional[pulumi.Input['ServiceAccountTokenProjectionArgs']]:
        """
        information about the serviceAccountToken data to project
        """
        return pulumi.get(self, "service_account_token")

    @service_account_token.setter
    def service_account_token(self, value: Optional[pulumi.Input['ServiceAccountTokenProjectionArgs']]):
        pulumi.set(self, "service_account_token", value)


@pulumi.input_type
class VsphereVirtualDiskVolumeSourceArgs:
    def __init__(__self__, *,
                 volume_path: pulumi.Input[str],
                 fs_type: Optional[pulumi.Input[str]] = None,
                 storage_policy_id: Optional[pulumi.Input[str]] = None,
                 storage_policy_name: Optional[pulumi.Input[str]] = None):
        """
        Represents a vSphere volume resource.
        :param pulumi.Input[str] volume_path: Path that identifies vSphere volume vmdk
        :param pulumi.Input[str] fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param pulumi.Input[str] storage_policy_id: Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.
        :param pulumi.Input[str] storage_policy_name: Storage Policy Based Management (SPBM) profile name.
        """
        pulumi.set(__self__, "volume_path", volume_path)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if storage_policy_id is not None:
            pulumi.set(__self__, "storage_policy_id", storage_policy_id)
        if storage_policy_name is not None:
            pulumi.set(__self__, "storage_policy_name", storage_policy_name)

    @property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> pulumi.Input[str]:
        """
        Path that identifies vSphere volume vmdk
        """
        return pulumi.get(self, "volume_path")

    @volume_path.setter
    def volume_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_path", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="storagePolicyID")
    def storage_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.
        """
        return pulumi.get(self, "storage_policy_id")

    @storage_policy_id.setter
    def storage_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_policy_id", value)

    @property
    @pulumi.getter(name="storagePolicyName")
    def storage_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Storage Policy Based Management (SPBM) profile name.
        """
        return pulumi.get(self, "storage_policy_name")

    @storage_policy_name.setter
    def storage_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_policy_name", value)


@pulumi.input_type
class WeightedPodAffinityTermArgs:
    def __init__(__self__, *,
                 pod_affinity_term: pulumi.Input['PodAffinityTermArgs'],
                 weight: pulumi.Input[int]):
        """
        The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)
        :param pulumi.Input['PodAffinityTermArgs'] pod_affinity_term: Required. A pod affinity term, associated with the corresponding weight.
        :param pulumi.Input[int] weight: weight associated with matching the corresponding podAffinityTerm, in the range 1-100.
        """
        pulumi.set(__self__, "pod_affinity_term", pod_affinity_term)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="podAffinityTerm")
    def pod_affinity_term(self) -> pulumi.Input['PodAffinityTermArgs']:
        """
        Required. A pod affinity term, associated with the corresponding weight.
        """
        return pulumi.get(self, "pod_affinity_term")

    @pod_affinity_term.setter
    def pod_affinity_term(self, value: pulumi.Input['PodAffinityTermArgs']):
        pulumi.set(self, "pod_affinity_term", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[int]:
        """
        weight associated with matching the corresponding podAffinityTerm, in the range 1-100.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[int]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class WindowsSecurityContextOptionsArgs:
    def __init__(__self__, *,
                 gmsa_credential_spec: Optional[pulumi.Input[str]] = None,
                 gmsa_credential_spec_name: Optional[pulumi.Input[str]] = None,
                 run_as_user_name: Optional[pulumi.Input[str]] = None):
        """
        WindowsSecurityContextOptions contain Windows-specific options and credentials.
        :param pulumi.Input[str] gmsa_credential_spec: GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.
        :param pulumi.Input[str] gmsa_credential_spec_name: GMSACredentialSpecName is the name of the GMSA credential spec to use.
        :param pulumi.Input[str] run_as_user_name: The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        if gmsa_credential_spec is not None:
            pulumi.set(__self__, "gmsa_credential_spec", gmsa_credential_spec)
        if gmsa_credential_spec_name is not None:
            pulumi.set(__self__, "gmsa_credential_spec_name", gmsa_credential_spec_name)
        if run_as_user_name is not None:
            pulumi.set(__self__, "run_as_user_name", run_as_user_name)

    @property
    @pulumi.getter(name="gmsaCredentialSpec")
    def gmsa_credential_spec(self) -> Optional[pulumi.Input[str]]:
        """
        GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.
        """
        return pulumi.get(self, "gmsa_credential_spec")

    @gmsa_credential_spec.setter
    def gmsa_credential_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gmsa_credential_spec", value)

    @property
    @pulumi.getter(name="gmsaCredentialSpecName")
    def gmsa_credential_spec_name(self) -> Optional[pulumi.Input[str]]:
        """
        GMSACredentialSpecName is the name of the GMSA credential spec to use.
        """
        return pulumi.get(self, "gmsa_credential_spec_name")

    @gmsa_credential_spec_name.setter
    def gmsa_credential_spec_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gmsa_credential_spec_name", value)

    @property
    @pulumi.getter(name="runAsUserName")
    def run_as_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        return pulumi.get(self, "run_as_user_name")

    @run_as_user_name.setter
    def run_as_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_as_user_name", value)


