"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagConditionField = exports.TagConditionLogicType = exports.TagCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Condition for applying a custom tag to a package.
 *
 * @experimental
 */
class TagCondition {
    /**
     * (experimental) Create an && condition which applies only when all condition arguments are true.
     *
     * @experimental
     */
    static and(...conds) {
        return new TagConditionLogic(TagConditionLogicType.AND, conds);
    }
    /**
     * (experimental) Create an || condition which applies if any of the condition arguments are true.
     *
     * @experimental
     */
    static or(...conds) {
        return new TagConditionLogic(TagConditionLogicType.OR, conds);
    }
    /**
     * (experimental) Create a !
     *
     * condition which applies if the condition argument is false
     *
     * @experimental
     */
    static not(...conds) {
        return new TagConditionLogic(TagConditionLogicType.NOT, conds);
    }
    /**
     * (experimental) Target a field within the `package.json` to assert against. Nested fields can be accessed by passing multiple keys. `TagCondition.field('key1', 'key2')` will access `packageJson?.key1?.key2`.
     *
     * @experimental
     */
    static field(...keys) {
        return new TagConditionField(keys);
    }
}
exports.TagCondition = TagCondition;
_a = JSII_RTTI_SYMBOL_1;
TagCondition[_a] = { fqn: "construct-hub.TagCondition", version: "0.3.145" };
/**
 * (experimental) Logic operators for performing specific conditional logic.
 *
 * @experimental
 */
var TagConditionLogicType;
(function (TagConditionLogicType) {
    TagConditionLogicType["AND"] = "AND";
    TagConditionLogicType["OR"] = "OR";
    TagConditionLogicType["NOT"] = "NOT";
    TagConditionLogicType["EQUALS"] = "EQUALS";
    TagConditionLogicType["INCLUDES"] = "INCLUDES";
    TagConditionLogicType["STARTS_WITH"] = "STARTS_WITH";
})(TagConditionLogicType = exports.TagConditionLogicType || (exports.TagConditionLogicType = {}));
class TagConditionLogic extends TagCondition {
    constructor(type, children) {
        super();
        this.type = type;
        this.children = children;
        this.isLogic = true;
    }
    bind() {
        return {
            type: this.type,
            children: this.children.map(cond => cond.bind()),
        };
    }
}
class TagConditionPredicate extends TagCondition {
    constructor(type, key, value) {
        super();
        this.type = type;
        this.key = key;
        this.value = value;
        this.isPredicate = true;
    }
    bind() {
        return {
            type: this.type,
            key: this.key,
            value: this.value,
        };
    }
}
/**
 * (experimental) Target a field to use in logic to dictate whether a tag is relevant.
 *
 * @experimental
 */
class TagConditionField {
    /**
     * @experimental
     */
    constructor(field) {
        this.field = field;
    }
    /**
     * (experimental) Create a === condition which applies if the specified field within the package's package.json is equal to the passed value.
     *
     * @experimental
     */
    eq(value) {
        return new TagConditionPredicate(TagConditionLogicType.EQUALS, this.field, value);
    }
    /**
     * (experimental) Create a `field.includes(value)` condition which applies if the specified field within the package's package.json includes the value. This works for arrays or strings.
     *
     * @experimental
     */
    includes(value) {
        return new TagConditionPredicate(TagConditionLogicType.INCLUDES, this.field, value);
    }
    /**
     * (experimental) Create a `field.startsWith(value)` condition which applies if the specified field within the package's package.json begins with the value. This works only for string values.
     *
     * @experimental
     */
    startsWith(value) {
        return new TagConditionPredicate(TagConditionLogicType.STARTS_WITH, this.field, value);
    }
}
exports.TagConditionField = TagConditionField;
_b = JSII_RTTI_SYMBOL_1;
TagConditionField[_b] = { fqn: "construct-hub.TagConditionField", version: "0.3.145" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcGFja2FnZS10YWcvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQXlEQSxNQUFzQixZQUFZOzs7Ozs7SUFFaEMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEtBQXFCO1FBQ2pDLE9BQU8sSUFBSSxpQkFBaUIsQ0FBQyxxQkFBcUIsQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDakUsQ0FBQzs7Ozs7O0lBR0QsTUFBTSxDQUFDLEVBQUUsQ0FBQyxHQUFHLEtBQXFCO1FBQ2hDLE9BQU8sSUFBSSxpQkFBaUIsQ0FBQyxxQkFBcUIsQ0FBQyxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDaEUsQ0FBQzs7Ozs7Ozs7SUFHRCxNQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsS0FBcUI7UUFDakMsT0FBTyxJQUFJLGlCQUFpQixDQUFDLHFCQUFxQixDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsQ0FBQztJQUNqRSxDQUFDOzs7Ozs7SUFHRCxNQUFNLENBQUMsS0FBSyxDQUFDLEdBQUcsSUFBYztRQUM1QixPQUFPLElBQUksaUJBQWlCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDckMsQ0FBQzs7QUFuQkgsb0NBc0JDOzs7Ozs7OztBQUdELElBQVkscUJBT1g7QUFQRCxXQUFZLHFCQUFxQjtJQUMvQixvQ0FBVyxDQUFBO0lBQ1gsa0NBQVMsQ0FBQTtJQUNULG9DQUFXLENBQUE7SUFDWCwwQ0FBaUIsQ0FBQTtJQUNqQiw4Q0FBcUIsQ0FBQTtJQUNyQixvREFBMkIsQ0FBQTtBQUM3QixDQUFDLEVBUFcscUJBQXFCLEdBQXJCLDZCQUFxQixLQUFyQiw2QkFBcUIsUUFPaEM7QUFFRCxNQUFNLGlCQUFrQixTQUFRLFlBQVk7SUFFMUMsWUFDbUIsSUFBMkIsRUFDM0IsUUFBd0I7UUFFekMsS0FBSyxFQUFFLENBQUM7UUFIUyxTQUFJLEdBQUosSUFBSSxDQUF1QjtRQUMzQixhQUFRLEdBQVIsUUFBUSxDQUFnQjtRQUgzQixZQUFPLEdBQUcsSUFBSSxDQUFDO0lBTS9CLENBQUM7SUFFTSxJQUFJO1FBQ1QsT0FBTztZQUNMLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNmLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztTQUNqRCxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBRUQsTUFBTSxxQkFBc0IsU0FBUSxZQUFZO0lBRTlDLFlBQ21CLElBQTJCLEVBQzNCLEdBQWEsRUFDYixLQUFhO1FBRTlCLEtBQUssRUFBRSxDQUFDO1FBSlMsU0FBSSxHQUFKLElBQUksQ0FBdUI7UUFDM0IsUUFBRyxHQUFILEdBQUcsQ0FBVTtRQUNiLFVBQUssR0FBTCxLQUFLLENBQVE7UUFKaEIsZ0JBQVcsR0FBRyxJQUFJLENBQUM7SUFPbkMsQ0FBQztJQUVNLElBQUk7UUFDVCxPQUFPO1lBQ0wsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO1lBQ2IsS0FBSyxFQUFFLElBQUksQ0FBQyxLQUFLO1NBQ2xCLENBQUM7SUFDSixDQUFDO0NBQ0Y7Ozs7OztBQUdELE1BQWEsaUJBQWlCOzs7O0lBQzVCLFlBQW9DLEtBQWU7UUFBZixVQUFLLEdBQUwsS0FBSyxDQUFVO0lBQUcsQ0FBQzs7Ozs7O0lBR2hELEVBQUUsQ0FBQyxLQUFVO1FBQ2xCLE9BQU8sSUFBSSxxQkFBcUIsQ0FDOUIscUJBQXFCLENBQUMsTUFBTSxFQUM1QixJQUFJLENBQUMsS0FBSyxFQUNWLEtBQUssQ0FDTixDQUFDO0lBQ0osQ0FBQzs7Ozs7O0lBR00sUUFBUSxDQUFDLEtBQVU7UUFDeEIsT0FBTyxJQUFJLHFCQUFxQixDQUM5QixxQkFBcUIsQ0FBQyxRQUFRLEVBQzlCLElBQUksQ0FBQyxLQUFLLEVBQ1YsS0FBSyxDQUNOLENBQUM7SUFDSixDQUFDOzs7Ozs7SUFHTSxVQUFVLENBQUMsS0FBYTtRQUM3QixPQUFPLElBQUkscUJBQXFCLENBQzlCLHFCQUFxQixDQUFDLFdBQVcsRUFDakMsSUFBSSxDQUFDLEtBQUssRUFDVixLQUFLLENBQ04sQ0FBQztJQUNKLENBQUM7O0FBNUJILDhDQTZCQyIsInNvdXJjZXNDb250ZW50IjpbImludGVyZmFjZSBQYWNrYWdlVGFnUHJlc2VudGF0aW9uQmFzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGxhYmVsOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvbG9yPzogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEtleXdvcmQgZXh0ZW5kcyBQYWNrYWdlVGFnUHJlc2VudGF0aW9uQmFzZSB7fVxuXG5leHBvcnQgaW50ZXJmYWNlIEhpZ2hsaWdodCBleHRlbmRzIFBhY2thZ2VUYWdQcmVzZW50YXRpb25CYXNle1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaWNvbj86IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBTZWFyY2hGaWx0ZXIge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkaXNwbGF5OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBncm91cEJ5OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUGFja2FnZVRhZ0Jhc2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpZDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGhpZ2hsaWdodD86IEhpZ2hsaWdodDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGtleXdvcmQ/OiBLZXl3b3JkO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzZWFyY2hGaWx0ZXI/OiBTZWFyY2hGaWx0ZXI7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgUGFja2FnZVRhZyBleHRlbmRzIFBhY2thZ2VUYWdCYXNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb25kaXRpb246IFRhZ0NvbmRpdGlvbjtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFRhZ0NvbmRpdGlvbkNvbmZpZyB7XG4gIHJlYWRvbmx5IHR5cGU6IFRhZ0NvbmRpdGlvbkxvZ2ljVHlwZTtcbiAgcmVhZG9ubHkga2V5Pzogc3RyaW5nW107XG4gIHJlYWRvbmx5IHZhbHVlPzogc3RyaW5nO1xuICByZWFkb25seSBjaGlsZHJlbj86IFRhZ0NvbmRpdGlvbkNvbmZpZ1tdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFBhY2thZ2VUYWdDb25maWcgZXh0ZW5kcyBQYWNrYWdlVGFnQmFzZSB7XG4gIHJlYWRvbmx5IGNvbmRpdGlvbjogVGFnQ29uZGl0aW9uQ29uZmlnO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBUYWdDb25kaXRpb24ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHN0YXRpYyBhbmQoLi4uY29uZHM6IFRhZ0NvbmRpdGlvbltdKTogVGFnQ29uZGl0aW9uIHtcbiAgICByZXR1cm4gbmV3IFRhZ0NvbmRpdGlvbkxvZ2ljKFRhZ0NvbmRpdGlvbkxvZ2ljVHlwZS5BTkQsIGNvbmRzKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgc3RhdGljIG9yKC4uLmNvbmRzOiBUYWdDb25kaXRpb25bXSk6IFRhZ0NvbmRpdGlvbiB7XG4gICAgcmV0dXJuIG5ldyBUYWdDb25kaXRpb25Mb2dpYyhUYWdDb25kaXRpb25Mb2dpY1R5cGUuT1IsIGNvbmRzKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBzdGF0aWMgbm90KC4uLmNvbmRzOiBUYWdDb25kaXRpb25bXSk6IFRhZ0NvbmRpdGlvbiB7XG4gICAgcmV0dXJuIG5ldyBUYWdDb25kaXRpb25Mb2dpYyhUYWdDb25kaXRpb25Mb2dpY1R5cGUuTk9ULCBjb25kcyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBzdGF0aWMgZmllbGQoLi4ua2V5czogc3RyaW5nW10pOiBUYWdDb25kaXRpb25GaWVsZCB7XG4gICAgcmV0dXJuIG5ldyBUYWdDb25kaXRpb25GaWVsZChrZXlzKTtcbiAgfVxuXG4gIHB1YmxpYyBhYnN0cmFjdCBiaW5kKCk6IFRhZ0NvbmRpdGlvbkNvbmZpZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBUYWdDb25kaXRpb25Mb2dpY1R5cGUge1xuICBBTkQgPSAnQU5EJyxcbiAgT1IgPSAnT1InLFxuICBOT1QgPSAnTk9UJyxcbiAgRVFVQUxTID0gJ0VRVUFMUycsXG4gIElOQ0xVREVTID0gJ0lOQ0xVREVTJyxcbiAgU1RBUlRTX1dJVEggPSAnU1RBUlRTX1dJVEgnLFxufVxuXG5jbGFzcyBUYWdDb25kaXRpb25Mb2dpYyBleHRlbmRzIFRhZ0NvbmRpdGlvbiB7XG4gIHB1YmxpYyByZWFkb25seSBpc0xvZ2ljID0gdHJ1ZTtcbiAgcHVibGljIGNvbnN0cnVjdG9yKFxuICAgIHByaXZhdGUgcmVhZG9ubHkgdHlwZTogVGFnQ29uZGl0aW9uTG9naWNUeXBlLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgY2hpbGRyZW46IFRhZ0NvbmRpdGlvbltdLFxuICApIHtcbiAgICBzdXBlcigpO1xuICB9XG5cbiAgcHVibGljIGJpbmQoKTogVGFnQ29uZGl0aW9uQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgdHlwZTogdGhpcy50eXBlLFxuICAgICAgY2hpbGRyZW46IHRoaXMuY2hpbGRyZW4ubWFwKGNvbmQgPT4gY29uZC5iaW5kKCkpLFxuICAgIH07XG4gIH1cbn1cblxuY2xhc3MgVGFnQ29uZGl0aW9uUHJlZGljYXRlIGV4dGVuZHMgVGFnQ29uZGl0aW9uIHtcbiAgcHVibGljIHJlYWRvbmx5IGlzUHJlZGljYXRlID0gdHJ1ZTtcbiAgcHVibGljIGNvbnN0cnVjdG9yKFxuICAgIHByaXZhdGUgcmVhZG9ubHkgdHlwZTogVGFnQ29uZGl0aW9uTG9naWNUeXBlLFxuICAgIHByaXZhdGUgcmVhZG9ubHkga2V5OiBzdHJpbmdbXSxcbiAgICBwcml2YXRlIHJlYWRvbmx5IHZhbHVlOiBzdHJpbmcsXG4gICkge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICBwdWJsaWMgYmluZCgpOiBUYWdDb25kaXRpb25Db25maWcge1xuICAgIHJldHVybiB7XG4gICAgICB0eXBlOiB0aGlzLnR5cGUsXG4gICAgICBrZXk6IHRoaXMua2V5LFxuICAgICAgdmFsdWU6IHRoaXMudmFsdWUsXG4gICAgfTtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgVGFnQ29uZGl0aW9uRmllbGQge1xuICBwdWJsaWMgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBmaWVsZDogc3RyaW5nW10pIHt9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGVxKHZhbHVlOiBhbnkpOiBUYWdDb25kaXRpb24ge1xuICAgIHJldHVybiBuZXcgVGFnQ29uZGl0aW9uUHJlZGljYXRlKFxuICAgICAgVGFnQ29uZGl0aW9uTG9naWNUeXBlLkVRVUFMUyxcbiAgICAgIHRoaXMuZmllbGQsXG4gICAgICB2YWx1ZSxcbiAgICApO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBpbmNsdWRlcyh2YWx1ZTogYW55KTogVGFnQ29uZGl0aW9uIHtcbiAgICByZXR1cm4gbmV3IFRhZ0NvbmRpdGlvblByZWRpY2F0ZShcbiAgICAgIFRhZ0NvbmRpdGlvbkxvZ2ljVHlwZS5JTkNMVURFUyxcbiAgICAgIHRoaXMuZmllbGQsXG4gICAgICB2YWx1ZSxcbiAgICApO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGFydHNXaXRoKHZhbHVlOiBzdHJpbmcpOiBUYWdDb25kaXRpb24ge1xuICAgIHJldHVybiBuZXcgVGFnQ29uZGl0aW9uUHJlZGljYXRlKFxuICAgICAgVGFnQ29uZGl0aW9uTG9naWNUeXBlLlNUQVJUU19XSVRILFxuICAgICAgdGhpcy5maWVsZCxcbiAgICAgIHZhbHVlLFxuICAgICk7XG4gIH1cbn1cbiJdfQ==