# Agentpy - Agent-based modeling in Python

[![PyPI](https://img.shields.io/pypi/v/agentpy)](https://pypi.org/project/agentpy/)
[![GitHub](https://img.shields.io/github/license/joelforamitti/agentpy)](https://github.com/JoelForamitti/agentpy/blob/master/LICENSE)
[![Build Status](https://travis-ci.com/JoelForamitti/agentpy.svg?branch=master)](https://travis-ci.com/JoelForamitti/agentpy)
[![Documentation Status](https://readthedocs.org/projects/agentpy/badge/?version=latest)](https://agentpy.readthedocs.io/en/latest/?badge=latest)
[![codecov](https://codecov.io/gh/JoelForamitti/agentpy/branch/master/graph/badge.svg?token=NTW99HNGB0)](https://codecov.io/gh/JoelForamitti/agentpy)

Agentpy is an open-source library for the development and analysis of agent-based models in Python. 
The framework integrates the tasks of model design, numerical experiments, 
and data analysis within a single environment, and is optimized for interactive computing 
with [IPython](http://ipython.org/) and [Jupyter](https://jupyter.org/). If
you have questions or ideas for improvements, please visit the 
[discussion forum](https://github.com/JoelForamitti/agentpy/discussions)
or subscribe to the [agentpy mailing list](https://groups.google.com/g/agentpy).

**Installation:** `pip install agentpy`

**Documentation:** https://agentpy.readthedocs.io

**Tutorials and examples:** https://agentpy.readthedocs.io/en/latest/model_library.html

**Comparison with other frameworks**: https://agentpy.readthedocs.io/en/latest/comparison.html

---

*A screenshot of [Jupyter Lab](https://jupyter.org/) with two interactive tutorials from the 
[agentpy model library](https://agentpy.readthedocs.io/en/latest/model_library.html):*

![](docs/agentpy_example.png)