from contracts_lib_py.wallet import Wallet
from contracts_lib_py.web3_provider import Web3Provider
from tests.resources.helper_functions import get_publisher_account


def test_sign_tx():
    # account_address = '0x00Bd138aBD70e2F00903268F3Db08f2D25677C9e'
    account = get_publisher_account()
    wallet = Wallet(Web3Provider.get_web3(), account.key_file, account.password, address=account.address)

    tx_dict = {
        'from': '0x00Bd138aBD70e2F00903268F3Db08f2D25677C9e',
        'to': '0xc354ba9AD5dF1023C2640b14A09E61a500F21546',
        'gas': 153432,
        'data': '0x534eb706ff3b98759dc7421dad1f42c4fbc00ceab99e4d849f884fa680398c8e65bcaf1a'
                '3f4b0356b3399ae841a2c6fce00787cf27dcf08e3b3e65065fea2498e621848f0000000000'
                '00000000000000000000000000000000000000000000000000008000000000000000000000'
                '000000000000000000000000000000000000000000a0000000000000000000000000000000'
                '00000000000000000000000000000000000000000000000000000000000000000000000000'
                '000000000000000000000078687474703a2f2f6c6f63616c686f73743a353030302f617069'
                '2f76312f61717561726975732f6173736574732f64646f2f6469643a6f703a666633623938'
                '37353964633734323164616431663432633466626330306365616239396534643834396638'
                '3834666136383033393863386536356263616631610000000000000000',
        'nonce': 730,
        'gasPrice': 1000000000
    }
    Wallet._last_tx_count[account.address] = tx_dict['nonce'] - 1

    tx_hash = (
        '0xf901ac8202da843b9aca008302575894c354ba9ad5df1023c2640b14a09e61a500f2154680b90144'
        '534eb706ff3b98759dc7421dad1f42c4fbc00ceab99e4d849f884fa680398c8e65bcaf1a3f4b0356b3'
        '399ae841a2c6fce00787cf27dcf08e3b3e65065fea2498e621848f0000000000000000000000000000'
        '0000000000000000000000000000000000800000000000000000000000000000000000000000000000'
        '0000000000000000a00000000000000000000000000000000000000000000000000000000000000000'
        '0000000000000000000000000000000000000000000000000000000000000078687474703a2f2f6c6f'
        '63616c686f73743a353030302f6170692f76312f61717561726975732f6173736574732f64646f2f64'
        '69643a6f703a6666336239383735396463373432316461643166343263346662633030636561623939'
        '653464383439663838346661363830333938633865363562636166316100000000000000001ba043de'
        'acb9f33860eccbb13f38a57801b1d9123f4cbb95b444427cecf0bfe120f0a0017d36b2082df2b87093'
        'fb751e5cb0efeaed7701ce77d67174494b22d8ade7f7'
    )

    signed_tx = wallet.sign_tx(tx_dict)
    assert signed_tx.hex() == tx_hash
