// This is adapted from code generated by GPT-3, using the following prompt:
// Please write the code for a javascript program that can traverse the DOM and return each text node and its bounding box. If the text has multiple bounding boxes, it should combine them into one. The output should be Javascript code that can run in Chrome.

function computeViewport() {
  return {
    vw: Math.max(
      document.documentElement.clientWidth || 0,
      window.innerWidth || 0
    ),
    vh: Math.max(
      document.documentElement.clientHeight || 0,
      window.innerHeight || 0
    ),

    // https://stackoverflow.com/questions/1145850/how-to-get-height-of-entire-document-with-javascript
    dh: Math.max(
      document.body.scrollHeight,
      document.body.offsetHeight,
      document.documentElement.clientHeight,
      document.documentElement.scrollHeight,
      document.documentElement.offsetHeight
    ),
  };
}

function findLeafNodes(node) {
  var textNodes = [];
  var walk = document.createTreeWalker(
    document.body,
    NodeFilter.SHOW_TEXT,
    null,
    false
  );

  while (walk.nextNode()) {
    var node = walk.currentNode;
    var range = document.createRange();
    range.selectNodeContents(node);
    var rects = Array.from(range.getClientRects());
    if (rects.length > 0) {
      var box = rects.reduce(function (previousValue, currentValue) {
        return {
          top: Math.min(previousValue.top, currentValue.top),
          right: Math.max(previousValue.right, currentValue.right),
          bottom: Math.max(previousValue.bottom, currentValue.bottom),
          left: Math.min(previousValue.left, currentValue.left),
        };
      });

      textNodes.push({
        text: node.textContent,
        box,
      });
    }
  }

  return textNodes;
}

function computeBoundingBoxes(node) {
  const word_boxes = findLeafNodes(node);
  return {
    ...computeViewport(),
    word_boxes,
  };
}
