"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElastiCacheCluster = void 0;
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_elasticache_1 = require("@aws-cdk/aws-elasticache");
const cdk = require("@aws-cdk/core");
class ElastiCacheCluster extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const elastiCacheClusterSecurityGroup = new aws_ec2_1.SecurityGroup(scope, 'ElastiCacheSecurityGroup', {
            vpc: props.vpc,
            description: 'ElastiCache Security Group',
        });
        this.elastiCacheClusterSecurityGroup = elastiCacheClusterSecurityGroup;
        const elastiCacheClusterSubnetGroup = new aws_elasticache_1.CfnSubnetGroup(scope, 'ElastiCacheRedisSubnetGroup', {
            subnetIds: props.vpc.selectSubnets({
                subnetType: aws_ec2_1.SubnetType.ISOLATED,
            }).subnetIds,
            description: 'ElastiCache Subnet Group',
        });
        this.elastiCacheCluster = new aws_elasticache_1.CfnCacheCluster(this, 'ElastiCacheCluster', {
            clusterName: `${id}-elstiCacheCluster`,
            cacheNodeType: 'cache.t2.micro',
            engine: 'redis',
            numCacheNodes: 1,
            vpcSecurityGroupIds: [elastiCacheClusterSecurityGroup.securityGroupId],
            cacheSubnetGroupName: elastiCacheClusterSubnetGroup.ref,
        });
        this.elastiCacheCluster.addDependsOn(elastiCacheClusterSubnetGroup);
        elastiCacheClusterSecurityGroup.connections.allowFrom(props.appSecurityGroup, aws_ec2_1.Port.tcp(6379));
    }
}
exports.ElastiCacheCluster = ElastiCacheCluster;
//# sourceMappingURL=data:application/json;base64,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