"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CeleryBeat = void 0;
const ecs = require("@aws-cdk/aws-ecs");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
class CeleryBeat extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const taskDefinition = new ecs.TaskDefinition(scope, `TaskDefinitionFor${id}`, {
            compatibility: ecs.Compatibility.FARGATE,
            cpu: '256',
            memoryMiB: '512',
        });
        taskDefinition.addContainer(`TaskContainerFor${id}`, {
            image: props.image,
            // TODO: figure out what the best practice is here
            // running as the `app` user results in permissions error
            user: 'root',
            command: props.command,
            environment: props.environment,
            logging: ecs.LogDriver.awsLogs({
                logRetention: logs.RetentionDays.ONE_DAY,
                streamPrefix: `${id}Container`,
            }),
        });
        new ecs.FargateService(scope, `FargateService${id}`, {
            cluster: props.cluster,
            taskDefinition,
            // only run one instance of celery beat
            desiredCount: 1,
            securityGroups: props.securityGroups,
        });
    }
}
exports.CeleryBeat = CeleryBeat;
//# sourceMappingURL=data:application/json;base64,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