"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CeleryWorker = void 0;
const ecs = require("@aws-cdk/aws-ecs");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
class CeleryWorker extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const taskDefinition = new ecs.TaskDefinition(scope, `TaskDefinitionFor${id}`, {
            compatibility: ecs.Compatibility.FARGATE,
            cpu: '256',
            memoryMiB: '512',
        });
        taskDefinition.addContainer(`TaskContainerFor${id}`, {
            image: props.image,
            command: props.command,
            environment: props.environment,
            logging: ecs.LogDriver.awsLogs({
                logRetention: logs.RetentionDays.ONE_DAY,
                streamPrefix: `${id}Container`,
            }),
        });
        new ecs.FargateService(scope, `FargateService${id}`, {
            cluster: props.cluster,
            taskDefinition,
            desiredCount: 1,
            securityGroups: props.securityGroups,
        });
        // TODO: scaling options
    }
}
exports.CeleryWorker = CeleryWorker;
//# sourceMappingURL=data:application/json;base64,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