import * as eks from '@aws-cdk/aws-eks';
import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
export interface IrsaProps {
    readonly cluster: eks.Cluster;
}
/**
 * Pod Role setup with IRSA (IAM Roles for Service Accounts)
 * https://docs.aws.amazon.com/eks/latest/userguide/iam-roles-for-service-accounts-technical-overview.html
 */
export declare class Irsa extends cdk.Construct {
    podRole: iam.Role;
    constructor(scope: cdk.Construct, id: string, props: IrsaProps);
}
