"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.appIngress = void 0;
exports.appIngress = {
    apiVersion: 'networking.k8s.io/v1',
    kind: 'Ingress',
    metadata: {
        name: 'app-ingress',
        namespace: 'app',
        annotations: {
            'kubernetes.io/ingress.class': 'alb',
            'alb.ingress.kubernetes.io/scheme': 'internet-facing',
            'alb.ingress.kubernetes.io/tags': 'Environment=test',
        },
    },
    spec: {
        rules: [
            {
                http: {
                    paths: [
                        {
                            path: '/',
                            pathType: 'Prefix',
                            backend: {
                                service: {
                                    name: 'api-http',
                                    port: {
                                        number: 80,
                                    },
                                },
                            },
                        },
                    ],
                },
            },
        ],
    },
};
//# sourceMappingURL=data:application/json;base64,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