"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MigrateJob = void 0;
const cdk = require("@aws-cdk/core");
class MigrateJob extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const migrateJobManifest = {
            apiVersion: 'batch/v1',
            kind: 'Job',
            metadata: {
                namespace: props.namespace,
                name: 'django-migrate',
            },
            spec: {
                template: {
                    spec: {
                        serviceAccountName: 'pod-service-account',
                        containers: [
                            {
                                name: 'migrate',
                                image: props.backendImage.imageUri,
                                env: props.env,
                                args: ['python3', 'manage.py', 'migrate'],
                            },
                        ],
                        restartPolicy: 'Never',
                    },
                },
            },
        };
        props.cluster.addManifest('migrate-job', migrateJobManifest);
    }
}
exports.MigrateJob = MigrateJob;
//# sourceMappingURL=data:application/json;base64,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