import * as ecrAssets from '@aws-cdk/aws-ecr-assets';
import * as eks from '@aws-cdk/aws-eks';
import * as cdk from '@aws-cdk/core';
interface WebResourcesProps {
    env: {
        [key: string]: string;
    }[];
    cluster: eks.ICluster;
    backendImage: ecrAssets.DockerImageAsset;
    namespace: string;
    webCommand: string[];
}
/**
 * This construct provides the Kubernetes manifests for the Django web application
 *
 * It includes a service and a deployment manifest that share some common names and labels
 *
 * The service is references by the Ingress object called `app-ingress`
 *
 */
export declare class WebResources extends cdk.Construct {
    serviceManifest: any;
    deploymentManifest: any;
    constructor(scope: cdk.Construct, id: string, props: WebResourcesProps);
}
export {};
