"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebResources = void 0;
const cdk = require("@aws-cdk/core");
/**
 * This construct provides the Kubernetes manifests for the Django web application
 *
 * It includes a service and a deployment manifest that share some common names and labels
 *
 * The service is references by the Ingress object called `app-ingress`
 *
 */
class WebResources extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const name = 'api-http';
        const selector = { app: name };
        const webDeploymentManifest = {
            apiVersion: 'apps/v1',
            kind: 'Deployment',
            metadata: {
                namespace: props.namespace,
                name,
            },
            spec: {
                replicas: 1,
                selector: {
                    matchLabels: selector,
                },
                template: {
                    metadata: {
                        labels: selector,
                    },
                    spec: {
                        serviceAccountName: 'pod-service-account',
                        containers: [
                            {
                                name,
                                image: props.backendImage.imageUri,
                                env: props.env,
                                args: props.webCommand,
                                ports: [
                                    {
                                        containerPort: 8000,
                                        name: 'http',
                                    },
                                ],
                            },
                        ],
                        restartPolicy: 'Always',
                    },
                },
            },
        };
        const webServiceManifest = {
            apiVersion: 'v1',
            kind: 'Service',
            metadata: {
                labels: selector,
                name,
                namespace: props.namespace,
            },
            spec: {
                selector,
                type: 'NodePort',
                ports: [
                    {
                        port: 80,
                        targetPort: 8000,
                        protocol: 'TCP',
                    },
                ],
            },
        };
        this.deploymentManifest = webDeploymentManifest;
        this.serviceManifest = webServiceManifest;
    }
}
exports.WebResources = WebResources;
//# sourceMappingURL=data:application/json;base64,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