"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const index_1 = require("../index");
const env = {
    region: process.env.AWS_DEFAULT_REGION || 'us-east-1',
    account: process.env.AWS_ACCOUNT_ID,
};
const app = new cdk.App();
const stack = new cdk.Stack(app, 'DjangoEksStack', { env });
const construct = new index_1.DjangoEks(stack, 'DjangoEksSample', {
    imageDirectory: './test/django-step-by-step/backend',
    webCommand: [
        './scripts/start_prod.sh',
    ],
});
/**
 * Add tagging for this construct and all child constructs
 */
cdk.Tags.of(construct).add('stack', 'DjangoEksStack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGphbmdvLWVrcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9pbnRlZy9pbnRlZy5kamFuZ28tZWtzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDO0FBQ3JDLG9DQUFxQztBQUVyQyxNQUFNLEdBQUcsR0FBRztJQUNWLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGtCQUFrQixJQUFJLFdBQVc7SUFDckQsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsY0FBYztDQUNwQyxDQUFDO0FBRUYsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxnQkFBZ0IsRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUM7QUFFNUQsTUFBTSxTQUFTLEdBQUcsSUFBSSxpQkFBUyxDQUFDLEtBQUssRUFBRSxpQkFBaUIsRUFBRTtJQUN4RCxjQUFjLEVBQUUsb0NBQW9DO0lBQ3BELFVBQVUsRUFBRTtRQUNWLHlCQUF5QjtLQUMxQjtDQUNGLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ0gsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgRGphbmdvRWtzIH0gZnJvbSAnLi4vaW5kZXgnO1xuXG5jb25zdCBlbnYgPSB7XG4gIHJlZ2lvbjogcHJvY2Vzcy5lbnYuQVdTX0RFRkFVTFRfUkVHSU9OIHx8ICd1cy1lYXN0LTEnLFxuICBhY2NvdW50OiBwcm9jZXNzLmVudi5BV1NfQUNDT1VOVF9JRCxcbn07XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnRGphbmdvRWtzU3RhY2snLCB7IGVudiB9KTtcblxuY29uc3QgY29uc3RydWN0ID0gbmV3IERqYW5nb0VrcyhzdGFjaywgJ0RqYW5nb0Vrc1NhbXBsZScsIHtcbiAgaW1hZ2VEaXJlY3Rvcnk6ICcuL3Rlc3QvZGphbmdvLXN0ZXAtYnktc3RlcC9iYWNrZW5kJyxcbiAgd2ViQ29tbWFuZDogW1xuICAgICcuL3NjcmlwdHMvc3RhcnRfcHJvZC5zaCcsXG4gIF0sXG59KTtcblxuLyoqXG4gKiBBZGQgdGFnZ2luZyBmb3IgdGhpcyBjb25zdHJ1Y3QgYW5kIGFsbCBjaGlsZCBjb25zdHJ1Y3RzXG4gKi9cbmNkay5UYWdzLm9mKGNvbnN0cnVjdCkuYWRkKCdzdGFjaycsICdEamFuZ29Fa3NTdGFjaycpO1xuXG4iXX0=