"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessLogDeliveryBucket = exports.Suppress = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class Suppress {
    static bucket(construct, rulesToSuppress) {
        const cfnResource = construct === null || construct === void 0 ? void 0 : construct.node.defaultChild;
        cfnResource === null || cfnResource === void 0 ? void 0 : cfnResource.addMetadata('cdk_nag', { rules_to_suppress: rulesToSuppress });
    }
    static securityGroup(construct, rulesToSuppress) {
        const cfnResource = construct === null || construct === void 0 ? void 0 : construct.node.defaultChild;
        cfnResource === null || cfnResource === void 0 ? void 0 : cfnResource.addMetadata('cdk_nag', { rules_to_suppress: rulesToSuppress });
    }
    static iamPolicy(construct, rulesToSuppress) {
        const cfnResource = construct === null || construct === void 0 ? void 0 : construct.node.defaultChild;
        cfnResource === null || cfnResource === void 0 ? void 0 : cfnResource.addMetadata('cdk_nag', { rules_to_suppress: rulesToSuppress });
    }
}
exports.Suppress = Suppress;
/**
 * The generic access log and log delivery bucket.
 */
class AccessLogDeliveryBucket extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        var _a;
        super(scope, id);
        this.bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, id, {
            encryption: aws_cdk_lib_1.aws_s3.BucketEncryption.S3_MANAGED,
            accessControl: aws_cdk_lib_1.aws_s3.BucketAccessControl.LOG_DELIVERY_WRITE,
            serverAccessLogsPrefix: (_a = props.serverAccessLogsPrefix) !== null && _a !== void 0 ? _a : 'access-log-',
            blockPublicAccess: {
                blockPublicAcls: true,
                blockPublicPolicy: true,
                ignorePublicAcls: true,
                restrictPublicBuckets: true,
            },
        });
        Suppress.bucket(this.bucket, [
            { id: 'AwsSolutions-S1', reason: 'implicitly set current bucket as the acces log bucket' },
        ]);
    }
}
exports.AccessLogDeliveryBucket = AccessLogDeliveryBucket;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2RrbmFnLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2Nka25hZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2Q0FJcUI7QUFDckIsMkNBQXVDO0FBT3ZDLE1BQWEsUUFBUTtJQUNuQixNQUFNLENBQUMsTUFBTSxDQUFDLFNBQW9CLEVBQUUsZUFBaUM7UUFDbkUsTUFBTSxXQUFXLEdBQUcsU0FBUyxhQUFULFNBQVMsdUJBQVQsU0FBUyxDQUFFLElBQUksQ0FBQyxZQUE0QixDQUFDO1FBQ2pFLFdBQVcsYUFBWCxXQUFXLHVCQUFYLFdBQVcsQ0FBRSxXQUFXLENBQUMsU0FBUyxFQUFFLEVBQUUsaUJBQWlCLEVBQUUsZUFBZSxFQUFFLEVBQUU7SUFDOUUsQ0FBQztJQUNELE1BQU0sQ0FBQyxhQUFhLENBQUMsU0FBb0IsRUFBRSxlQUFpQztRQUMxRSxNQUFNLFdBQVcsR0FBRyxTQUFTLGFBQVQsU0FBUyx1QkFBVCxTQUFTLENBQUUsSUFBSSxDQUFDLFlBQW9DLENBQUM7UUFDekUsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFdBQVcsQ0FBQyxTQUFTLEVBQUUsRUFBRSxpQkFBaUIsRUFBRSxlQUFlLEVBQUUsRUFBRTtJQUM5RSxDQUFDO0lBQ0QsTUFBTSxDQUFDLFNBQVMsQ0FBQyxTQUFvQixFQUFFLGVBQWlDO1FBQ3RFLE1BQU0sV0FBVyxHQUFHLFNBQVMsYUFBVCxTQUFTLHVCQUFULFNBQVMsQ0FBRSxJQUFJLENBQUMsWUFBNkIsQ0FBQztRQUNsRSxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUsV0FBVyxDQUFDLFNBQVMsRUFBRSxFQUFFLGlCQUFpQixFQUFFLGVBQWUsRUFBRSxFQUFFO0lBQzlFLENBQUM7Q0FDRjtBQWJELDRCQWFDO0FBT0Q7O0dBRUc7QUFDSCxNQUFhLHVCQUF3QixTQUFRLHNCQUFTO0lBRXBELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBcUIsRUFBRTs7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksb0JBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRTtZQUNwQyxVQUFVLEVBQUUsb0JBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVO1lBQzFDLGFBQWEsRUFBRSxvQkFBRSxDQUFDLG1CQUFtQixDQUFDLGtCQUFrQjtZQUN4RCxzQkFBc0IsUUFBRSxLQUFLLENBQUMsc0JBQXNCLG1DQUFJLGFBQWE7WUFDckUsaUJBQWlCLEVBQUU7Z0JBQ2pCLGVBQWUsRUFBRSxJQUFJO2dCQUNyQixpQkFBaUIsRUFBRSxJQUFJO2dCQUN2QixnQkFBZ0IsRUFBRSxJQUFJO2dCQUN0QixxQkFBcUIsRUFBRSxJQUFJO2FBQzVCO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsUUFBUSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFO1lBQzNCLEVBQUUsRUFBRSxFQUFFLGlCQUFpQixFQUFFLE1BQU0sRUFBRSx1REFBdUQsRUFBRTtTQUMzRixDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFuQkQsMERBbUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgYXdzX2VjMiBhcyBlYzIsXG4gIGF3c19pYW0gYXMgaWFtLFxuICBhd3NfczMgYXMgczMsXG59IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5pbnRlcmZhY2UgcnVsZVRvU3VwcHJlc3Mge1xuICByZWFkb25seSBpZDogc3RyaW5nO1xuICByZWFkb25seSByZWFzb246IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIFN1cHByZXNzIHtcbiAgc3RhdGljIGJ1Y2tldChjb25zdHJ1Y3Q6IENvbnN0cnVjdCwgcnVsZXNUb1N1cHByZXNzOiBydWxlVG9TdXBwcmVzc1tdICkge1xuICAgIGNvbnN0IGNmblJlc291cmNlID0gY29uc3RydWN0Py5ub2RlLmRlZmF1bHRDaGlsZCBhcyBzMy5DZm5CdWNrZXQ7XG4gICAgY2ZuUmVzb3VyY2U/LmFkZE1ldGFkYXRhKCdjZGtfbmFnJywgeyBydWxlc190b19zdXBwcmVzczogcnVsZXNUb1N1cHByZXNzIH0pO1xuICB9XG4gIHN0YXRpYyBzZWN1cml0eUdyb3VwKGNvbnN0cnVjdDogQ29uc3RydWN0LCBydWxlc1RvU3VwcHJlc3M6IHJ1bGVUb1N1cHByZXNzW10pIHtcbiAgICBjb25zdCBjZm5SZXNvdXJjZSA9IGNvbnN0cnVjdD8ubm9kZS5kZWZhdWx0Q2hpbGQgYXMgZWMyLkNmblNlY3VyaXR5R3JvdXA7XG4gICAgY2ZuUmVzb3VyY2U/LmFkZE1ldGFkYXRhKCdjZGtfbmFnJywgeyBydWxlc190b19zdXBwcmVzczogcnVsZXNUb1N1cHByZXNzIH0pO1xuICB9XG4gIHN0YXRpYyBpYW1Qb2xpY3koY29uc3RydWN0OiBDb25zdHJ1Y3QsIHJ1bGVzVG9TdXBwcmVzczogcnVsZVRvU3VwcHJlc3NbXSkge1xuICAgIGNvbnN0IGNmblJlc291cmNlID0gY29uc3RydWN0Py5ub2RlLmRlZmF1bHRDaGlsZCBhcyBpYW0uQ2ZuUG9saWN5O1xuICAgIGNmblJlc291cmNlPy5hZGRNZXRhZGF0YSgnY2RrX25hZycsIHsgcnVsZXNfdG9fc3VwcHJlc3M6IHJ1bGVzVG9TdXBwcmVzcyB9KTtcbiAgfVxufVxuXG5cbmV4cG9ydCBpbnRlcmZhY2UgQnVja2V0UHJvcHMge1xuICByZWFkb25seSBzZXJ2ZXJBY2Nlc3NMb2dzUHJlZml4Pzogc3RyaW5nO1xufVxuXG4vKipcbiAqIFRoZSBnZW5lcmljIGFjY2VzcyBsb2cgYW5kIGxvZyBkZWxpdmVyeSBidWNrZXQuXG4gKi9cbmV4cG9ydCBjbGFzcyBBY2Nlc3NMb2dEZWxpdmVyeUJ1Y2tldCBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHJlYWRvbmx5IGJ1Y2tldDogczMuQnVja2V0O1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQnVja2V0UHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgdGhpcy5idWNrZXQgPSBuZXcgczMuQnVja2V0KHRoaXMsIGlkLCB7XG4gICAgICBlbmNyeXB0aW9uOiBzMy5CdWNrZXRFbmNyeXB0aW9uLlMzX01BTkFHRUQsXG4gICAgICBhY2Nlc3NDb250cm9sOiBzMy5CdWNrZXRBY2Nlc3NDb250cm9sLkxPR19ERUxJVkVSWV9XUklURSxcbiAgICAgIHNlcnZlckFjY2Vzc0xvZ3NQcmVmaXg6IHByb3BzLnNlcnZlckFjY2Vzc0xvZ3NQcmVmaXggPz8gJ2FjY2Vzcy1sb2ctJyxcbiAgICAgIGJsb2NrUHVibGljQWNjZXNzOiB7XG4gICAgICAgIGJsb2NrUHVibGljQWNsczogdHJ1ZSxcbiAgICAgICAgYmxvY2tQdWJsaWNQb2xpY3k6IHRydWUsXG4gICAgICAgIGlnbm9yZVB1YmxpY0FjbHM6IHRydWUsXG4gICAgICAgIHJlc3RyaWN0UHVibGljQnVja2V0czogdHJ1ZSxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgU3VwcHJlc3MuYnVja2V0KHRoaXMuYnVja2V0LCBbXG4gICAgICB7IGlkOiAnQXdzU29sdXRpb25zLVMxJywgcmVhc29uOiAnaW1wbGljaXRseSBzZXQgY3VycmVudCBidWNrZXQgYXMgdGhlIGFjY2VzIGxvZyBidWNrZXQnIH0sXG4gICAgXSk7XG4gIH1cbn1cbiJdfQ==