# Generated by Django 4.1.5 on 2023-01-18 02:10

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('oasis', '0002_geographiclocation_typeclient_documenttype_client_and_more'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='UserProfile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('document_id', models.BigIntegerField(validators=[django.core.validators.MinValueValidator(limit_value=1, message='The document id is invalid.')])),
                ('first_name', models.CharField(max_length=100)),
                ('last_name', models.CharField(max_length=100)),
                ('location', models.CharField(blank=True, max_length=150)),
                ('address', models.CharField(blank=True, max_length=100, null=True)),
                ('phone', models.CharField(blank=True, max_length=30, null=True)),
                ('mobile', models.CharField(blank=True, max_length=30, null=True)),
                ('type', models.IntegerField(choices=[(0, 'Not bound'), (1, 'Customer'), (2, 'Partner')], default=0)),
                ('enabled', models.BooleanField(default=True)),
                ('document_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='profile', related_query_name='document_types', to='oasis.documenttype')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='profile', related_query_name='user', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddConstraint(
            model_name='userprofile',
            constraint=models.UniqueConstraint(fields=('document_type', 'document_id'), name='UNQ_UserProfile_Document'),
        ),
    ]
