# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['simple_ddl_parser']

package_data = \
{'': ['*']}

install_requires = \
['ply>=3.11,<4.0']

entry_points = \
{'console_scripts': ['sdp = simple_ddl_parser.cli:main']}

setup_kwargs = {
    'name': 'simple-ddl-parser',
    'version': '0.7.2',
    'description': 'Simple DDL Parser to parse SQL & HQL ddl files to json/python dict with full information about columns: types, defaults, primary keys, etc.',
    'long_description': '\nSimple DDL Parser\n-----------------\n\n\n.. image:: https://img.shields.io/pypi/v/simple-ddl-parser\n   :target: https://img.shields.io/pypi/v/simple-ddl-parser\n   :alt: badge1\n \n.. image:: https://img.shields.io/pypi/l/simple-ddl-parser\n   :target: https://img.shields.io/pypi/l/simple-ddl-parser\n   :alt: badge2\n \n.. image:: https://img.shields.io/pypi/pyversions/simple-ddl-parser\n   :target: https://img.shields.io/pypi/pyversions/simple-ddl-parser\n   :alt: badge3\n \n\nBuild with ply (lex & yacc in python). A lot of samples in \'tests/\'\n\nHow to install\n^^^^^^^^^^^^^^\n\n.. code-block:: bash\n\n\n       pip install simple-ddl-parser\n\nHow to use\n----------\n\nFrom python code\n^^^^^^^^^^^^^^^^\n\n.. code-block:: python\n\n       from simple_ddl_parser import DDLParser\n\n\n       parse_results = DDLParser("""create table dev.data_sync_history(\n           data_sync_id bigint not null,\n           sync_count bigint not null,\n           sync_mark timestamp  not  null,\n           sync_start timestamp  not null,\n           sync_end timestamp  not null,\n           message varchar(2000) null,\n           primary key (data_sync_id, sync_start)\n       ); """).run()\n\n       print(parse_results)\n\nTo parse from file\n^^^^^^^^^^^^^^^^^^\n\n.. code-block:: python\n\n\n       from simple_ddl_parser import parse_from_file\n\n       result = parse_from_file(\'tests/sql/test_one_statement.sql\')\n       print(result)\n\nFrom command line\n^^^^^^^^^^^^^^^^^\n\nsimple-ddl-parser is installed to environment as command **sdp**\n\n.. code-block:: bash\n\n\n       sdp path_to_ddl_file\n\n       # for example:\n\n       sdp tests/sql/test_two_tables.sql\n\nYou will see the output in **schemas** folder in file with name **test_two_tables_schema.json**\n\nIf you want to have also output in console - use **-v** flag for verbose.\n\n.. code-block:: bash\n\n\n       sdp tests/sql/test_two_tables.sql -v\n\nIf you don\'t want to dump schema in file and just print result to the console, use **--no-dump** flag:\n\n.. code-block:: bash\n\n\n       sdp tests/sql/test_two_tables.sql --no-dump\n\nYou can provide target path where you want to dump result with argument **-t**\\ , **--targer**\\ :\n\n.. code-block:: bash\n\n\n       sdp tests/sql/test_two_tables.sql -t dump_results/\n\nHow does it work?\n^^^^^^^^^^^^^^^^^\n\nParser tested on different DDLs for PostgreSQL & Hive.\nTypes that are used in your DB does not matter, so parser must also work successfuly to any DDL for SQL DB. Parser is NOT case sensitive, it did not expect that all queries will be in upper case or lower case. So you can write statements like this:\n\n.. code-block:: sql\n\n   Alter Table Persons ADD CONSTRAINT CHK_PersonAge CHECK (Age>=18 AND City=\'Sandnes\');\n\nIt will be parsed as is without errors.\n\nIf you have samples that cause an error - please open the issue (but don\'t forget to add ddl example), I will be glad to fix it.\n\nA lot of statements and output result you can find in tests, for example:\n\n`test_alter_statements.py <tests/test_alter_statements.py>`_ \n\nThis parser take as input SQL DDL statements or files, for example like this:\n\n.. code-block:: sql\n\n\n       CREATE TABLE employees (\n           id SERIAL PRIMARY KEY,\n           first_name VARCHAR (50),\n           last_name VARCHAR (50),\n           birth_date DATE CHECK (birth_date > \'1900-01-01\'),\n           joined_date DATE CHECK (joined_date > birth_date),\n           salary numeric CHECK(salary > 0),\n           phone_numbers varchar(16) array,\n           tags varchar ARRAY[1]\n       );\n       CREATE TABLE dev.Persons (\n           ID int NOT NULL,\n           LastName varchar(255) NOT NULL,\n           FirstName varchar(255),\n           Age int,\n           City varchar(255),\n           Country varchar(255),\n           CONSTRAINT CHK_Person CHECK (Age>=19 AND City=\'Sandnes\')\n       );\n\n       ALTER TABLE dev.Persons ADD CHECK (Age>=18 AND City=\'Sandnes\');\n\n       ALTER TABLE dev.Persons Add CONSTRAINT ck_person  CHECK (Age>=18 AND City=\'Sandnes\');\n       Alter Table dev.Persons ADD CONSTRAINT fk_group FOREIGN KEY (id) REFERENCES employees (id); \n       create unique index person_pk on dev.Persons (ID) ;\n       create index person_ix2 on dev.Persons (City, Country);\n\nAnd produce output like this (information about table name, schema, columns, types and properties):\n\n.. code-block:: python\n\n   [{\n     \'table_name\': \'employees\',\n     \'index\': [],\n     \'primary_key\': [\'id\'],\n     \'schema\': None,\n     \'alter\': {},\n     \'checks\': [],\n     \'columns\': [{\'check\': None,\n                  \'default\': None,\n                  \'name\': \'id\',\n                  \'nullable\': False,\n                  \'references\': None,\n                  \'size\': None,\n                  \'type\': \'SERIAL\',\n                  \'unique\': False},\n                 {\'check\': None,\n                  \'default\': None,\n                  \'name\': \'first_name\',\n                  \'nullable\': True,\n                  \'references\': None,\n                  \'size\': 50,\n                  \'type\': \'VARCHAR\',\n                  \'unique\': False},\n                 {\'check\': None,\n                  \'default\': None,\n                  \'name\': \'last_name\',\n                  \'nullable\': True,\n                  \'references\': None,\n                  \'size\': 50,\n                  \'type\': \'VARCHAR\',\n                  \'unique\': False},\n                 {\'check\': "birth_date > \'1900-01-01\'",\n                  \'default\': None,\n                  \'name\': \'birth_date\',\n                  \'nullable\': True,\n                  \'references\': None,\n                  \'size\': None,\n                  \'type\': \'DATE\',\n                  \'unique\': False},\n                 {\'check\': \'joined_date > birth_date\',\n                  \'default\': None,\n                  \'name\': \'joined_date\',\n                  \'nullable\': True,\n                  \'references\': None,\n                  \'size\': None,\n                  \'type\': \'DATE\',\n                  \'unique\': False},\n                 {\'check\': None,\n                  \'default\': None,\n                  \'name\': \'phone_numbers\',\n                  \'nullable\': True,\n                  \'references\': None,\n                  \'size\': 16,\n                  \'type\': \'varchar[]\',\n                  \'unique\': False},\n                 {\'check\': None,\n                  \'default\': None,\n                  \'name\': \'tags\',\n                  \'nullable\': True,\n                  \'references\': None,\n                  \'size\': None,\n                  \'type\': \'varchar[1]\',\n                  \'unique\': False}]},\n\n       {\'table_name\': \'Persons\',\n       \'index\': [{\'columns\': [\'ID\'], \'index_name\': \'person_pk\', \'unique\': True},\n                   {\'columns\': [\'City\', \'Country\'],\n                   \'index_name\': \'person_ix2\',\n                   \'unique\': False}],\n       \'primary_key\': [],\n       \'schema\': \'dev\',\n       \'alter\': {\'checks\': [{\'constraint_name\': None,\n                           \'statement\': [\'Age>=18\', \'AND\', "City=\'Sandnes\'"]},\n                          {\'constraint_name\': \'ck_person\',\n                           \'statement\': [\'Age>=18\', \'AND\', "City=\'Sandnes\'"]}],\n               \'columns\': [{\'constraint_name\': \'fk_group\',\n                            \'name\': \'id\',\n                            \'references\': {\'column\': \'id\',\n                                           \'schema\': None,\n                                           \'table\': \'employees\'}}]},\n     \'checks\': [{\'constraint_name\': \'CHK_Person\',\n                 \'statement\': "Age>=19 AND City=\'Sandnes\'"}],\n     \'columns\': [{\'check\': None,\n                  \'default\': None,\n                  \'name\': \'ID\',\n                  \'nullable\': False,\n                  \'references\': None,\n                  \'size\': None,\n                  \'type\': \'int\',\n                  \'unique\': False},\n                 {\'check\': None,\n                  \'default\': None,\n                  \'name\': \'LastName\',\n                  \'nullable\': False,\n                  \'references\': None,\n                  \'size\': 255,\n                  \'type\': \'varchar\',\n                  \'unique\': False},\n                 {\'check\': None,\n                  \'default\': None,\n                  \'name\': \'FirstName\',\n                  \'nullable\': True,\n                  \'references\': None,\n                  \'size\': 255,\n                  \'type\': \'varchar\',\n                  \'unique\': False},\n                 {\'check\': None,\n                  \'default\': None,\n                  \'name\': \'Age\',\n                  \'nullable\': True,\n                  \'references\': None,\n                  \'size\': None,\n                  \'type\': \'int\',\n                  \'unique\': False},\n                 {\'check\': None,\n                  \'default\': None,\n                  \'name\': \'City\',\n                  \'nullable\': True,\n                  \'references\': None,\n                  \'size\': 255,\n                  \'type\': \'varchar\',\n                  \'unique\': False},\n                 {\'check\': None,\n                  \'default\': None,\n                  \'name\': \'Country\',\n                  \'nullable\': True,\n                  \'references\': None,\n                  \'size\': 255,\n                  \'type\': \'varchar\',\n                  \'unique\': False}]\n                  }]\n\nSEQUENCES\n^^^^^^^^^\n\nWhen we parse SEQUENCES each property stored as a separate dict KEY, for example for sequence:\n\n.. code-block:: sql\n\n       CREATE SEQUENCE dev.incremental_ids\n       INCREMENT 1\n       START 1\n       MINVALUE 1\n       MAXVALUE 9223372036854775807\n       CACHE 1;\n\nWill be output:\n\n.. code-block:: python\n\n       [\n           {\'schema\': \'dev\', \'incremental_ids\': \'document_id_seq\', \'increment\': 1, \'start\': 1, \'minvalue\': 1, \'maxvalue\': 9223372036854775807, \'cache\': 1}\n       ]\n\nALTER statements\n^^^^^^^^^^^^^^^^\n\nRight now added support only for ALTER statements with FOREIGEIN key\n\nFor example, if in your ddl after table defenitions (create table statements) you have ALTER table statements like this:\n\n.. code-block:: sql\n\n\n   ALTER TABLE "material_attachments" ADD FOREIGN KEY ("material_id", "material_title") REFERENCES "materials" ("id", "title");\n\nThis statements will be parsed and information about them putted inside \'alter\' key in table\'s dict.\nFor example, please check alter statement tests - **tests/test_alter_statements.py**\n\nMore examples & tests\n^^^^^^^^^^^^^^^^^^^^^\n\nYou can find in **tests/** folder.\n\nDump result in json\n^^^^^^^^^^^^^^^^^^^\n\nTo dump result in json use argument .run(dump=True)\n\nYou also can provide a path where you want to have a dumps with schema with argument .run(dump_path=\'folder_that_use_for_dumps/\')\n\nSupported Statements\n^^^^^^^^^^^^^^^^^^^^\n\n\n* \n  CREATE TABLE [ IF NOT EXISTS ] + columns defenition, columns attributes: column name + type + type size(for example, varchar(255)), UNIQUE, PRIMARY KEY, DEFAULT, CHECK, NULL/NOT NULL, REFERENCES\n\n* \n  STATEMENTS: PRIMARY KEY, CHECK, FOREIGN KEY in table defenitions (in create table();)\n\n* \n  ALTER TABLE STATEMENTS: ADD CHECK (with CONSTRAINT), ADD FOREIGN KEY (with CONSTRAINT)\n\nTODO in next Releases (if you don\'t see feature that you need - open the issue)\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n\n#. Provide API to get result as Python Object\n#. Add online demo (UI) to parse ddl\n#. Ignore block comments with ``/* ... */`` in DDLs\n#. Add support for PARTITION statement\n\nHistorical context\n^^^^^^^^^^^^^^^^^^\n\nThis library is an extracted parser code from https://github.com/xnuinside/fakeme (Library for fake relation data generation, that I used in several work projects, but did not have time to make from it normal open source library)\n\nFor one of the work projects I needed to convert SQL ddl to Python ORM models in auto way and I tried to use https://github.com/andialbrecht/sqlparse but it works not well enough with ddl for my case (for example, if in ddl used lower case - nothing works, primary keys inside ddl are mapped as column name not reserved word and etc.).\nSo I remembered about Parser in Fakeme and just extracted it & improved. \n\nHow to run tests\n^^^^^^^^^^^^^^^^\n\n.. code-block:: bash\n\n\n       git clone https://github.com/xnuinside/simple-ddl-parser.git\n       cd simple-ddl-parser\n       poetry install # if you use poetry\n       # or use `pip install .`\n       pytest tests/ -vv\n\nHow to contribute\n-----------------\n\nPlease describe issue that you want to solve and open the PR, I will review it as soon as possible.\n\nAny questions? Ping me in Telegram: https://t.me/xnuinside \n\nChangelog\n---------\n\n**v0.7.1**\n\n\n#. Ignore inline with \'--\' comments\n\n**v0.7.0**\n\n\n#. Redone logic of parse CREATE TABLE statements, now they parsed as one statement (not line by line as previous)\n#. Fixed several minor bugs with edge cases in default values and checks\n#. Added support for ALTER FOREIGN KEY statement for several fields in one statement\n\n**v0.6.1**\n\n\n#. Fix minor bug with schema in index statements\n\n**v0.6.0**\n\n\n#. Added support for SEQUENCE statemensts\n#. Added support for ARRAYs in types\n#. Added support for CREATE INDEX statements\n\n**v0.5.0**\n\n\n#. Added support for UNIQUE column attribute\n#. Add command line arg to pass folder with ddls (parse multiple files)\n#. Added support for CHECK Constratint\n#. Added support for FOREIGN Constratint in ALTER TABLE\n\n**v0.4.0**\n\n\n#. Added support schema for table in REFERENCES statement in column defenition\n#. Added base support fot Alter table statements (added \'alters\' key in table)\n#. Added command line arg to pass path to get the output results\n#. Fixed incorrect null fields parsing\n\n**v0.3.0**\n\n\n#. Added support for REFERENCES statement in column defenition\n#. Added command line\n',
    'author': 'Iuliia Volkova',
    'author_email': 'xnuinside@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/xnuinside/simple-ddl-parser',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
