# Generated by Django 3.2 on 2021-05-05 11:53

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Continent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('abbreviation', models.CharField(max_length=2, unique=True)),
            ],
            options={
                'verbose_name_plural': 'continents',
            },
        ),
        migrations.CreateModel(
            name='Currency',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, null=True)),
                ('name_plural', models.CharField(max_length=255, null=True)),
                ('symbol_exonym', models.CharField(max_length=100, null=True)),
                ('symbol_endonym', models.CharField(max_length=100, null=True)),
                ('iso_4217', models.CharField(blank=True, max_length=10, null=True, unique=True)),
            ],
            options={
                'verbose_name_plural': 'currencies',
            },
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_exonym', models.CharField(max_length=255, null=True)),
                ('name_endonym', models.CharField(max_length=255, null=True)),
                ('iso_639_1', models.CharField(max_length=2, null=True, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='Timezone',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('utc_offset', models.DurationField()),
                ('utc_dst_offset', models.DurationField(help_text='Daylight saving offset', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_exonym', models.CharField(max_length=255, unique=True)),
                ('name_endonym', models.CharField(max_length=255)),
                ('iso_3166_1_alpha_2', models.CharField(max_length=2, null=True, validators=[django.core.validators.RegexValidator(message='Exactly two uppercase letters required.', regex='^[A-Z]{2}$')])),
                ('capital_exonym', models.CharField(max_length=255, null=True)),
                ('capital_endonym', models.CharField(max_length=255, null=True)),
                ('calling_code', models.CharField(max_length=20)),
                ('continent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_handy_models.continent')),
                ('currencies', models.ManyToManyField(to='django_handy_models.Currency')),
                ('languages', models.ManyToManyField(to='django_handy_models.Language')),
            ],
            options={
                'verbose_name_plural': 'countries',
            },
        ),
    ]
