"""Fluent Solver TUI Commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.views = self.__class__.views(path + ["views"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        self.server = self.__class__.server(path + ["server"], service)
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        self.report = self.__class__.report(path + ["report"], service)
        self.display = self.__class__.display(path + ["display"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        super().__init__(path, service)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)
    def parallel_setting(self, *args, **kwargs):
        """
        Enter the parallel processing menu.
        """
        return PyMenu(self.service, "/parallel_setting").execute(*args, **kwargs)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)

    class views(TUIMenu):
        """
        Enter the view manipulation menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.camera = self.__class__.camera(path + ["camera"], service)
            super().__init__(path, service)
        def default_view(self, *args, **kwargs):
            """
            Resets view to front and center.
            """
            return PyMenu(self.service, "/views/default_view").execute(*args, **kwargs)
        def list_views(self, *args, **kwargs):
            """
            Lists predefined and saved views.
            """
            return PyMenu(self.service, "/views/list_views").execute(*args, **kwargs)
        def next_view(self, *args, **kwargs):
            """
            Return to the camera position after the current position in the stack.
            """
            return PyMenu(self.service, "/views/next_view").execute(*args, **kwargs)
        def read_views(self, *args, **kwargs):
            """
            Reads views from a view file.
            """
            return PyMenu(self.service, "/views/read_views").execute(*args, **kwargs)
        def delete_view(self, *args, **kwargs):
            """
            Removes a view from the list.
            """
            return PyMenu(self.service, "/views/delete_view").execute(*args, **kwargs)
        def save_view(self, *args, **kwargs):
            """
            Saves the current view to the view list.
            """
            return PyMenu(self.service, "/views/save_view").execute(*args, **kwargs)
        def restore_view(self, *args, **kwargs):
            """
            Uses a saved view.
            """
            return PyMenu(self.service, "/views/restore_view").execute(*args, **kwargs)
        def last_view(self, *args, **kwargs):
            """
            Returns to the camera position before the last manipulation.
            """
            return PyMenu(self.service, "/views/last_view").execute(*args, **kwargs)
        def write_views(self, *args, **kwargs):
            """
            Writes selected views to a view file.
            """
            return PyMenu(self.service, "/views/write_views").execute(*args, **kwargs)
        def auto_scale(self, *args, **kwargs):
            """
            Scales and centers the current scene without changing its orientation.
            """
            return PyMenu(self.service, "/views/auto_scale").execute(*args, **kwargs)

        class camera(TUIMenu):
            """
            Enters the camera menu to modify the current viewing parameters.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def orbit_camera(self, *args, **kwargs):
                """
                Adjusts the camera position without modifying the target.
                """
                return PyMenu(self.service, "/views/camera/orbit_camera").execute(*args, **kwargs)
            def pan_camera(self, *args, **kwargs):
                """
                Adjusts the camera target without modifying the position.
                """
                return PyMenu(self.service, "/views/camera/pan_camera").execute(*args, **kwargs)
            def zoom_camera(self, *args, **kwargs):
                """
                Adjusts the camera’s field of view. This operation is similar to dollying the camera in or out of the scene. Dollying causes objects in front to move past you. Zooming changes the perspective effect in the scene (and can be disconcerting).
                """
                return PyMenu(self.service, "/views/camera/zoom_camera").execute(*args, **kwargs)
            def dolly_camera(self, *args, **kwargs):
                """
                Adjusts the camera position and target.
                """
                return PyMenu(self.service, "/views/camera/dolly_camera").execute(*args, **kwargs)
            def target(self, *args, **kwargs):
                """
                Sets the point to be the center of the camera view.
                """
                return PyMenu(self.service, "/views/camera/target").execute(*args, **kwargs)
            def roll_camera(self, *args, **kwargs):
                """
                Adjusts the camera up-vector.
                """
                return PyMenu(self.service, "/views/camera/roll_camera").execute(*args, **kwargs)
            def field(self, *args, **kwargs):
                """
                Sets the field of view (width and height).
                """
                return PyMenu(self.service, "/views/camera/field").execute(*args, **kwargs)
            def up_vector(self, *args, **kwargs):
                """
                Sets the camera up-vector.
                """
                return PyMenu(self.service, "/views/camera/up_vector").execute(*args, **kwargs)
            def position(self, *args, **kwargs):
                """
                Sets the camera position.
                """
                return PyMenu(self.service, "/views/camera/position").execute(*args, **kwargs)
            def projection(self, *args, **kwargs):
                """
                Set the camera projection type.
                """
                return PyMenu(self.service, "/views/camera/projection").execute(*args, **kwargs)

    class icing(TUIMenu):
        """
        FENSAP-ICE options.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def flow(self, *args, **kwargs):
            """
            Flow solver menu.
            """
            return PyMenu(self.service, "/icing/flow").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            File menu.
            """
            return PyMenu(self.service, "/icing/file").execute(*args, **kwargs)
        def ice(self, *args, **kwargs):
            """
            Ice accretion menu.
            """
            return PyMenu(self.service, "/icing/ice").execute(*args, **kwargs)
        def drop(self, *args, **kwargs):
            """
            Droplet impingement menu.
            """
            return PyMenu(self.service, "/icing/drop").execute(*args, **kwargs)
        def multishot(self, *args, **kwargs):
            """
            Multi-shot accretion menu.
            """
            return PyMenu(self.service, "/icing/multishot").execute(*args, **kwargs)
        def settings(self, *args, **kwargs):
            """
            Global settings menu.
            """
            return PyMenu(self.service, "/icing/settings").execute(*args, **kwargs)

    class file(TUIMenu):
        """
        Enter the file menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.auto_save = self.__class__.auto_save(path + ["auto_save"], service)
            self.transient_export = self.__class__.transient_export(path + ["transient_export"], service)
            self.em_mapping = self.__class__.em_mapping(path + ["em_mapping"], service)
            self.fsi = self.__class__.fsi(path + ["fsi"], service)
            self.parametric_project = self.__class__.parametric_project(path + ["parametric_project"], service)
            self.import_ = self.__class__.import_(path + ["import"], service)
            self.interpolate = self.__class__.interpolate(path + ["interpolate"], service)
            self.export = self.__class__.export(path + ["export"], service)
            self.cffio_options = self.__class__.cffio_options(path + ["cffio_options"], service)
            self.table_manager = self.__class__.table_manager(path + ["table_manager"], service)
            self.project = self.__class__.project(path + ["project[beta]"], service)
            self.solution_files = self.__class__.solution_files(path + ["solution_files"], service)
            super().__init__(path, service)
        def read_macros(self, *args, **kwargs):
            """
            Reads macro definitions from a file.
            """
            return PyMenu(self.service, "/file/read_macros").execute(*args, **kwargs)
        def write_pdf(self, *args, **kwargs):
            """
            Writes a pdf file.
            """
            return PyMenu(self.service, "/file/write_pdf").execute(*args, **kwargs)
        def read_rays(self, *args, **kwargs):
            """
            Reads a ray file.
            """
            return PyMenu(self.service, "/file/read_rays").execute(*args, **kwargs)
        def reload_setup(self, *args, **kwargs):
            """
            Discards any changes in the current ANSYS Fluent in Workbench session and removes any corresponding data from the Solution cell. This command is only available when running ANSYS Fluent in Workbench.
            """
            return PyMenu(self.service, "/file/reload_setup").execute(*args, **kwargs)
        def stop_macro(self, *args, **kwargs):
            """
            Stops recording input to a macro.
            """
            return PyMenu(self.service, "/file/stop_macro").execute(*args, **kwargs)
        def close_without_save(self, *args, **kwargs):
            """
            Exits ANSYS Fluent without saving data in Workbench. This command is only available when running ANSYS Fluent in Workbench.
            """
            return PyMenu(self.service, "/file/close_without_save").execute(*args, **kwargs)
        def read_case(self, *args, **kwargs):
            """
            Read a case file.
            """
            return PyMenu(self.service, "/file/read_case").execute(*args, **kwargs)
        def write_boundary_mesh(self, *args, **kwargs):
            """
            Writes the boundary mesh to a file.
            """
            return PyMenu(self.service, "/file/write_boundary_mesh").execute(*args, **kwargs)
        def sync_workbench(self, *args, **kwargs):
            """
            Directly updates Workbench with the most recent Fluent changes. This command is only available when running ANSYS Fluent in Workbench.
            """
            return PyMenu(self.service, "/file/sync_workbench").execute(*args, **kwargs)
        def write_cleanup_script(self, *args, **kwargs):
            """
            Writes the cleanup-script-file for ANSYS Fluent.
            """
            return PyMenu(self.service, "/file/write_cleanup_script").execute(*args, **kwargs)
        def set_idle_timeout(self, *args, **kwargs):
            """
            Set the idle timeout.
            """
            return PyMenu(self.service, "/file/set_idle_timeout").execute(*args, **kwargs)
        def write_settings(self, *args, **kwargs):
            """
            Writes out current boundary conditions in use.
            """
            return PyMenu(self.service, "/file/write_settings").execute(*args, **kwargs)
        def read_field_functions(self, *args, **kwargs):
            """
            Reads custom field function definitions from a file.
            """
            return PyMenu(self.service, "/file/read_field_functions").execute(*args, **kwargs)
        def write_profile(self, *args, **kwargs):
            """
            Writes surface data as a boundary profile file.
            """
            return PyMenu(self.service, "/file/write_profile").execute(*args, **kwargs)
        def show_configuration(self, *args, **kwargs):
            """
            Display current release and version information.
            """
            return PyMenu(self.service, "/file/show_configuration").execute(*args, **kwargs)
        def read_settings(self, *args, **kwargs):
            """
            Reads and sets boundary conditions from a specified file.
            """
            return PyMenu(self.service, "/file/read_settings").execute(*args, **kwargs)
        def replace_mesh(self, *args, **kwargs):
            """
            Replaces the mesh with a new one while preserving settings.
            """
            return PyMenu(self.service, "/file/replace_mesh").execute(*args, **kwargs)
        def read_profile(self, *args, **kwargs):
            """
            Reads boundary profile data.
            """
            return PyMenu(self.service, "/file/read_profile").execute(*args, **kwargs)
        def read_data(self, *args, **kwargs):
            """
            Reads a data file.
            """
            return PyMenu(self.service, "/file/read_data").execute(*args, **kwargs)
        def set_err_on_inval_cmd(self, *args, **kwargs):
            """
            Set whether to abort journal replay on invalid command.
            """
            return PyMenu(self.service, "/file/set_err_on_inval_cmd").execute(*args, **kwargs)
        def read_case_data(self, *args, **kwargs):
            """
            Reads a case and a data file.
            """
            return PyMenu(self.service, "/file/read_case_data").execute(*args, **kwargs)
        def stop_transcript(self, *args, **kwargs):
            """
            Stop recording input and output and close the transcript file.
            """
            return PyMenu(self.service, "/file/stop_transcript").execute(*args, **kwargs)
        def read_transient_table(self, *args, **kwargs):
            """
            Reads table of transient boundary profile data.
            """
            return PyMenu(self.service, "/file/read_transient_table").execute(*args, **kwargs)
        def async_optimize(self, *args, **kwargs):
            """
            Chooses whether to optimize file I/O using scratch disks and asynchronous operations.
            """
            return PyMenu(self.service, "/file/async_optimize").execute(*args, **kwargs)
        def binary_legacy_files(self, *args, **kwargs):
            """
            Indicate whether to write binary or text format case and data files.
            """
            return PyMenu(self.service, "/file/binary_legacy_files").execute(*args, **kwargs)
        def set_batch_options(self, *args, **kwargs):
            """
            Sets the batch options.
            """
            return PyMenu(self.service, "/file/set_batch_options").execute(*args, **kwargs)
        def read_journal(self, *args, **kwargs):
            """
            Read a journal file.
            """
            return PyMenu(self.service, "/file/read_journal").execute(*args, **kwargs)
        def single_precision_coordinates(self, *args, **kwargs):
            """
            Specifies whether the nodal coordinates should be written in single precision (rather than the default double precision). This text command is only available in the single-precision version of ANSYS Fluent.
            """
            return PyMenu(self.service, "/file/single_precision_coordinates").execute(*args, **kwargs)
        def write_case_data(self, *args, **kwargs):
            """
            Writes a case and a data file.
            """
            return PyMenu(self.service, "/file/write_case_data").execute(*args, **kwargs)
        def read_case_info(self, *args, **kwargs):
            """
            Read basic case info.
            """
            return PyMenu(self.service, "/file/read_case_info").execute(*args, **kwargs)
        def data_file_options(self, *args, **kwargs):
            """
            Sets derived quantities to be written in data file.
            """
            return PyMenu(self.service, "/file/data_file_options").execute(*args, **kwargs)
        def cff_files(self, *args, **kwargs):
            """
            Indicate whether to write ANSYS common fluids format (CFF) files or legacy case and data files.
            """
            return PyMenu(self.service, "/file/cff_files").execute(*args, **kwargs)
        def write_fan_profile(self, *args, **kwargs):
            """
            Computes radial profiles for a fan zone and writes them to a profile file.
            """
            return PyMenu(self.service, "/file/write_fan_profile").execute(*args, **kwargs)
        def read_case_light(self, *args, **kwargs):
            """
            Read a case file while skipping mesh elements.
            """
            return PyMenu(self.service, "/file/read_case_light").execute(*args, **kwargs)
        def read_pdf(self, *args, **kwargs):
            """
            Reads a PDF file.
            """
            return PyMenu(self.service, "/file/read_pdf").execute(*args, **kwargs)
        def start_transcript(self, *args, **kwargs):
            """
            Start recording input and output in a file.
            """
            return PyMenu(self.service, "/file/start_transcript").execute(*args, **kwargs)
        def read_injections(self, *args, **kwargs):
            """
            Reads all DPM injections from a file.
            """
            return PyMenu(self.service, "/file/read_injections").execute(*args, **kwargs)
        def write_case_light(self, *args, **kwargs):
            """
            Save the case file in light-weight mode,i.e. mesh not touched.
            """
            return PyMenu(self.service, "/file/write_case_light").execute(*args, **kwargs)
        def write_injections(self, *args, **kwargs):
            """
            Writes out selected DPM injections to a file.
            """
            return PyMenu(self.service, "/file/write_injections").execute(*args, **kwargs)
        def execute_macro(self, *args, **kwargs):
            """
            Runs a previously defined macro.
            """
            return PyMenu(self.service, "/file/execute_macro").execute(*args, **kwargs)
        def load_act_tool(self, *args, **kwargs):
            """
            Load ACT Start Page.
            """
            return PyMenu(self.service, "/file/load_act_tool").execute(*args, **kwargs)
        def write_currently_defined_profiles(self, *args, **kwargs):
            """
            Write currently defined profiles. To use \*.csv format specify filename with .csv suffix.
            """
            return PyMenu(self.service, "/file/write_currently_defined_profiles").execute(*args, **kwargs)
        def write_isat_table(self, *args, **kwargs):
            """
            Writes ISAT Table.
            """
            return PyMenu(self.service, "/file/write_isat_table").execute(*args, **kwargs)
        def confirm_overwrite(self, *args, **kwargs):
            """
            Indicate whether or not to confirm attempts to overwrite existing files.
            """
            return PyMenu(self.service, "/file/confirm_overwrite").execute(*args, **kwargs)
        def write_pdat(self, *args, **kwargs):
            """
            Enables / disables the attempt to save .pdat files. Note that this text command is no longer supported.
            """
            return PyMenu(self.service, "/file/write_pdat").execute(*args, **kwargs)
        def read_isat_table(self, *args, **kwargs):
            """
            Reads ISAT Table.
            """
            return PyMenu(self.service, "/file/read_isat_table").execute(*args, **kwargs)
        def start_journal(self, *args, **kwargs):
            """
            Start recording all input in a file.
            """
            return PyMenu(self.service, "/file/start_journal").execute(*args, **kwargs)
        def set_tui_version(self, *args, **kwargs):
            """
            Set the version of the TUI commands.
            """
            return PyMenu(self.service, "/file/set_tui_version").execute(*args, **kwargs)
        def stop_journal(self, *args, **kwargs):
            """
            Stop recording input and close the journal file.
            """
            return PyMenu(self.service, "/file/stop_journal").execute(*args, **kwargs)
        def export_to_cfd_post(self, *args, **kwargs):
            """
            Exports data files that are compatible with CFD-Post and EnSight (that is, .cdat and .cst files) and opens CFD-Post, if desired.
            """
            return PyMenu(self.service, "/file/export_to_cfd_post").execute(*args, **kwargs)
        def write_merge_profiles(self, *args, **kwargs):
            """
            Writes a .csv file with the selected surfaces consolidated into one set of data points.
            """
            return PyMenu(self.service, "/file/write_merge_profiles").execute(*args, **kwargs)
        def read_viewfactors(self, *args, **kwargs):
            """
            Reads view factors from a file.
            """
            return PyMenu(self.service, "/file/read_viewfactors").execute(*args, **kwargs)
        def read_surface_clusters(self, *args, **kwargs):
            """
            Reads surface clusters from a file.
            """
            return PyMenu(self.service, "/file/read_surface_clusters").execute(*args, **kwargs)
        def write_case(self, *args, **kwargs):
            """
            Write a case file.
            """
            return PyMenu(self.service, "/file/write_case").execute(*args, **kwargs)
        def write_circumferential_averaged_profile(self, *args, **kwargs):
            """
            Write surface data as a boundary profile file. To use \*.csv format specify filename with .csv suffix.
            """
            return PyMenu(self.service, "/file/write_circumferential_averaged_profile").execute(*args, **kwargs)
        def write_flamelet(self, *args, **kwargs):
            """
            Writes a flamelet file.
            """
            return PyMenu(self.service, "/file/write_flamelet").execute(*args, **kwargs)
        def write_macros(self, *args, **kwargs):
            """
            Writes the currently defined macros to a file.
            """
            return PyMenu(self.service, "/file/write_macros").execute(*args, **kwargs)
        def write_data(self, *args, **kwargs):
            """
            Writes a data file.
            """
            return PyMenu(self.service, "/file/write_data").execute(*args, **kwargs)
        def write_field_functions(self, *args, **kwargs):
            """
            Writes the currently defined custom field functions to a file.
            """
            return PyMenu(self.service, "/file/write_field_functions").execute(*args, **kwargs)
        def define_macro(self, *args, **kwargs):
            """
            Saves input to a named macro.
            """
            return PyMenu(self.service, "/file/define_macro").execute(*args, **kwargs)
        def set_target_reference_frame_for_write_profiles(self, *args, **kwargs):
            """
            Set reference frame options, which will be used for position transformation during writing of profiles.
            """
            return PyMenu(self.service, "/file/set_target_reference_frame_for_write_profiles").execute(*args, **kwargs)

        class auto_save(TUIMenu):
            """
            Enters the auto save menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def save_data_file_every(self, *args, **kwargs):
                """
                Specifies the type and frequency of the data file to be saved.
                """
                return PyMenu(self.service, "/file/auto_save/save_data_file_every").execute(*args, **kwargs)
            def case_frequency(self, *args, **kwargs):
                """
                Specifies the frequency (in iterations, time steps, or flow time) with which case files are saved.
                """
                return PyMenu(self.service, "/file/auto_save/case_frequency").execute(*args, **kwargs)
            def append_file_name_with(self, *args, **kwargs):
                """
                Sets the suffix for auto-saved files. The file name can be appended by flow-time, time-step value, or by user-specified flags in file name.
                """
                return PyMenu(self.service, "/file/auto_save/append_file_name_with").execute(*args, **kwargs)
            def retain_most_recent_files(self, *args, **kwargs):
                """
                Sets autosave to retain the 5 most recent files.
                """
                return PyMenu(self.service, "/file/auto_save/retain_most_recent_files").execute(*args, **kwargs)
            def root_name(self, *args, **kwargs):
                """
                Specifies the root name for the files that are saved.
                """
                return PyMenu(self.service, "/file/auto_save/root_name").execute(*args, **kwargs)
            def max_files(self, *args, **kwargs):
                """
                Sets the maximum number of files. Once the maximum is reached, files will be erased as new files are written.
                """
                return PyMenu(self.service, "/file/auto_save/max_files").execute(*args, **kwargs)
            def data_frequency(self, *args, **kwargs):
                """
                Specifies the frequency (in iterations, time steps, or flow time) with which data files are saved.
                """
                return PyMenu(self.service, "/file/auto_save/data_frequency").execute(*args, **kwargs)

        class transient_export(TUIMenu):
            """
            Enter the export menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.settings = self.__class__.settings(path + ["settings"], service)
                super().__init__(path, service)
            def particle_history_data(self, *args, **kwargs):
                """
                Sets up an automatic particle-history data export.
                """
                return PyMenu(self.service, "/file/transient_export/particle_history_data").execute(*args, **kwargs)
            def dx(self, *args, **kwargs):
                """
                Writes an IBM Data Explorer format file.
                """
                return PyMenu(self.service, "/file/transient_export/dx").execute(*args, **kwargs)
            def fieldview_unstruct(self, *args, **kwargs):
                """
                Writes a FIELDVIEW unstructured combined file.
                """
                return PyMenu(self.service, "/file/transient_export/fieldview_unstruct").execute(*args, **kwargs)
            def avs(self, *args, **kwargs):
                """
                Writes an AVS UCD file.
                """
                return PyMenu(self.service, "/file/transient_export/avs").execute(*args, **kwargs)
            def abaqus(self, *args, **kwargs):
                """
                Writes an ABAQUS file.
                """
                return PyMenu(self.service, "/file/transient_export/abaqus").execute(*args, **kwargs)
            def ensight_gold_parallel_volume(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files for cell zones in a parallel format suitable for ANSYS Ensight Enterprise.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_gold_parallel_volume").execute(*args, **kwargs)
            def mechanical_apdl_input(self, *args, **kwargs):
                """
                Writes a Mechanical APDL input file.
                """
                return PyMenu(self.service, "/file/transient_export/mechanical_apdl_input").execute(*args, **kwargs)
            def ideas(self, *args, **kwargs):
                """
                Writes an I-deas universal file.
                """
                return PyMenu(self.service, "/file/transient_export/ideas").execute(*args, **kwargs)
            def fieldview_xdb(self, *args, **kwargs):
                """
                Write a FieldView XDB format file.
                """
                return PyMenu(self.service, "/file/transient_export/fieldview_xdb").execute(*args, **kwargs)
            def common_fluids_format_post(self, *args, **kwargs):
                """
                Write an CFF Post-Only file.
                """
                return PyMenu(self.service, "/file/transient_export/common_fluids_format_post").execute(*args, **kwargs)
            def taitherm(self, *args, **kwargs):
                """
                Writes a TAITherm file.
                """
                return PyMenu(self.service, "/file/transient_export/taitherm").execute(*args, **kwargs)
            def fast_solution(self, *args, **kwargs):
                """
                Writes a FAST/Plot3D unstructured solution file.
                """
                return PyMenu(self.service, "/file/transient_export/fast_solution").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes transient exports.
                """
                return PyMenu(self.service, "/file/transient_export/delete").execute(*args, **kwargs)
            def ensight_gold_from_existing_files(self, *args, **kwargs):
                """
                Writes EnSight Gold files using ANSYS Fluent case files.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_gold_from_existing_files").execute(*args, **kwargs)
            def fast(self, *args, **kwargs):
                """
                Writes a FAST/Plot3D unstructured mesh velocity scalar file.
                """
                return PyMenu(self.service, "/file/transient_export/fast").execute(*args, **kwargs)
            def cdat_for_cfd_post__and__ensight(self, *args, **kwargs):
                """
                Write a CDAT for CFD-Post & EnSight file.
                """
                return PyMenu(self.service, "/file/transient_export/cdat_for_cfd_post__and__ensight").execute(*args, **kwargs)
            def nastran(self, *args, **kwargs):
                """
                Writes a NASTRAN file.
                """
                return PyMenu(self.service, "/file/transient_export/nastran").execute(*args, **kwargs)
            def fieldview_unstruct_surfaces(self, *args, **kwargs):
                """
                Writes FIELDVIEW unstructured combined file for surfaces.
                """
                return PyMenu(self.service, "/file/transient_export/fieldview_unstruct_surfaces").execute(*args, **kwargs)
            def ascii(self, *args, **kwargs):
                """
                Writes an ASCII file.
                """
                return PyMenu(self.service, "/file/transient_export/ascii").execute(*args, **kwargs)
            def ensight_gold_parallel_surfaces(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files for surfaces in a parallel format suitable for ANSYS Ensight Enterprise.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_gold_parallel_surfaces").execute(*args, **kwargs)
            def tecplot(self, *args, **kwargs):
                """
                Write a Tecplot+3DV format file.
                """
                return PyMenu(self.service, "/file/transient_export/tecplot").execute(*args, **kwargs)
            def ensight_dvs_volume(self, *args, **kwargs):
                """
                Write post-processing data(geometry, velocity and scalars) for cell zones and boundaries attached to them using EnSight Dynamic Visualization Store Interface.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_dvs_volume").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits transient exports.
                """
                return PyMenu(self.service, "/file/transient_export/edit").execute(*args, **kwargs)
            def patran_neutral(self, *args, **kwargs):
                """
                Writes a PATRAN neutral file.
                """
                return PyMenu(self.service, "/file/transient_export/patran_neutral").execute(*args, **kwargs)
            def cgns(self, *args, **kwargs):
                """
                Writes a CGNS file.
                """
                return PyMenu(self.service, "/file/transient_export/cgns").execute(*args, **kwargs)
            def fieldview_unstruct_mesh(self, *args, **kwargs):
                """
                Writes a FIELDVIEW unstructured mesh only file.
                """
                return PyMenu(self.service, "/file/transient_export/fieldview_unstruct_mesh").execute(*args, **kwargs)
            def fieldview_unstruct_data(self, *args, **kwargs):
                """
                Writes a FIELDVIEW unstructured results only file.
                """
                return PyMenu(self.service, "/file/transient_export/fieldview_unstruct_data").execute(*args, **kwargs)
            def ensight_dvs_surfaces(self, *args, **kwargs):
                """
                Write post-processing data(geometry, velocity and scalars) for surfaces using EnSight Dynamic Visualization Store Interface.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_dvs_surfaces").execute(*args, **kwargs)
            def ensight_gold_transient(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_gold_transient").execute(*args, **kwargs)

            class settings(TUIMenu):
                """
                Enters the automatic export settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def cfd_post_compatible(self, *args, **kwargs):
                    """
                    Specifies when case files are written with the .cdat and .cst files exported for Ansys CFD-Post. Note that this setting is ignored if the Write Case File Every Time option is enabled in the Automatic Export dialog box, which is always the case starting in Release 2021 R1.
                    """
                    return PyMenu(self.service, "/file/transient_export/settings/cfd_post_compatible").execute(*args, **kwargs)

        class em_mapping(TUIMenu):
            """
            Enters the electromagnetic loss mapping menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def remove_loss_only(self, *args, **kwargs):
                """
                Removes the loss data provided by Maxwell and keeps all other solution data.
                """
                return PyMenu(self.service, "/file/em_mapping/remove_loss_only").execute(*args, **kwargs)
            def surface_energy_source(self, *args, **kwargs):
                """
                Loss data provided by Ansoft will be assigned to Fluent for selected wall zones.
                """
                return PyMenu(self.service, "/file/em_mapping/surface_energy_source").execute(*args, **kwargs)
            def volumetric_energy_source(self, *args, **kwargs):
                """
                Loss data provided by Ansoft will be assigned to Fluent for selected cell zones.
                """
                return PyMenu(self.service, "/file/em_mapping/volumetric_energy_source").execute(*args, **kwargs)
            def maintain_loss_on_initialization(self, *args, **kwargs):
                """
                Maintains the loss data provided by Maxwell even if solution is initialized.
                """
                return PyMenu(self.service, "/file/em_mapping/maintain_loss_on_initialization").execute(*args, **kwargs)

        class fsi(TUIMenu):
            """
            Enters the fluid-structure interaction menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def display_fsi_mesh(self, *args, **kwargs):
                """
                Displays the mesh for a fluid-structure interaction.
                """
                return PyMenu(self.service, "/file/fsi/display_fsi_mesh").execute(*args, **kwargs)
            def write_fsi_mesh(self, *args, **kwargs):
                """
                Writes a fluid-structure interaction mesh file.
                """
                return PyMenu(self.service, "/file/fsi/write_fsi_mesh").execute(*args, **kwargs)
            def read_fsi_mesh(self, *args, **kwargs):
                """
                Reads an FEM mesh for one-way data mapping from ANSYS Fluent.
                """
                return PyMenu(self.service, "/file/fsi/read_fsi_mesh").execute(*args, **kwargs)
            def conserve_force(self, *args, **kwargs):
                """
                Conserve the forces for linear line, tri and tet elements.
                """
                return PyMenu(self.service, "/file/fsi/conserve_force").execute(*args, **kwargs)

        class parametric_project(TUIMenu):
            """
            Enter to open, save, archive parametric project.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def save_as(self, *args, **kwargs):
                """
                Save As Project.
                """
                return PyMenu(self.service, "/file/parametric_project/save_as").execute(*args, **kwargs)
            def archive(self, *args, **kwargs):
                """
                Archive Project.
                """
                return PyMenu(self.service, "/file/parametric_project/archive").execute(*args, **kwargs)
            def save_a_copy(self, *args, **kwargs):
                """
                Save a Copy.
                """
                return PyMenu(self.service, "/file/parametric_project/save_a_copy").execute(*args, **kwargs)
            def save(self, *args, **kwargs):
                """
                Save Project.
                """
                return PyMenu(self.service, "/file/parametric_project/save").execute(*args, **kwargs)
            def open(self, *args, **kwargs):
                """
                Open project.
                """
                return PyMenu(self.service, "/file/parametric_project/open").execute(*args, **kwargs)

        class import_(TUIMenu):
            """
            Enter the import menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.lstc = self.__class__.lstc(path + ["lstc"], service)
                self.patran = self.__class__.patran(path + ["patran"], service)
                self.nastran = self.__class__.nastran(path + ["nastran"], service)
                self.partition = self.__class__.partition(path + ["partition"], service)
                self.mechanical_apdl = self.__class__.mechanical_apdl(path + ["mechanical_apdl"], service)
                self.plot3d = self.__class__.plot3d(path + ["plot3d"], service)
                self.tecplot = self.__class__.tecplot(path + ["tecplot"], service)
                self.cfx = self.__class__.cfx(path + ["cfx"], service)
                self.abaqus = self.__class__.abaqus(path + ["abaqus"], service)
                self.cgns = self.__class__.cgns(path + ["cgns"], service)
                super().__init__(path, service)
            def marc_post(self, *args, **kwargs):
                """
                Reads a MARC POST file as a case file.
                """
                return PyMenu(self.service, "/file/import/marc_post").execute(*args, **kwargs)
            def prebfc_structured(self, *args, **kwargs):
                """
                Imports a formatted PreBFC structured mesh file.
                """
                return PyMenu(self.service, "/file/import/prebfc_structured").execute(*args, **kwargs)
            def ideas_universal(self, *args, **kwargs):
                """
                Imports an I-deas Universal file.
                """
                return PyMenu(self.service, "/file/import/ideas_universal").execute(*args, **kwargs)
            def fidap(self, *args, **kwargs):
                """
                Imports a FIDAP neutral file.
                """
                return PyMenu(self.service, "/file/import/fidap").execute(*args, **kwargs)
            def gambit(self, *args, **kwargs):
                """
                Imports a GAMBIT neutral file.
                """
                return PyMenu(self.service, "/file/import/gambit").execute(*args, **kwargs)
            def flamelet(self, *args, **kwargs):
                """
                Imports a flamelet file.
                """
                return PyMenu(self.service, "/file/import/flamelet").execute(*args, **kwargs)
            def fmu_file(self, *args, **kwargs):
                """
                Enters the import FMU file menu.
                """
                return PyMenu(self.service, "/file/import/fmu_file").execute(*args, **kwargs)
            def ensight(self, *args, **kwargs):
                """
                Reads an EnSight file as a case file.
                """
                return PyMenu(self.service, "/file/import/ensight").execute(*args, **kwargs)
            def ptc_mechanica(self, *args, **kwargs):
                """
                Reads a PTC Mechanica Design file as a case file.
                """
                return PyMenu(self.service, "/file/import/ptc_mechanica").execute(*args, **kwargs)
            def chemkin_mechanism(self, *args, **kwargs):
                """
                Reads a CHEMKIN mechanism file.
                """
                return PyMenu(self.service, "/file/import/chemkin_mechanism").execute(*args, **kwargs)
            def chemkin_report_each_line(self, *args, **kwargs):
                """
                Enables/disables reporting after reading each line.
                """
                return PyMenu(self.service, "/file/import/chemkin_report_each_line").execute(*args, **kwargs)
            def fluent4_case(self, *args, **kwargs):
                """
                Imports a formatted ANSYS Fluent 4 case file.
                """
                return PyMenu(self.service, "/file/import/fluent4_case").execute(*args, **kwargs)
            def hypermesh(self, *args, **kwargs):
                """
                Reads a HYPERMESH file as a case file.
                """
                return PyMenu(self.service, "/file/import/hypermesh").execute(*args, **kwargs)

            class lstc(TUIMenu):
                """
                Imports an LSTC file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def input(self, *args, **kwargs):
                    """
                    Reads an LSTC input file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/lstc/input").execute(*args, **kwargs)
                def state(self, *args, **kwargs):
                    """
                    Reads an LSTC result file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/lstc/state").execute(*args, **kwargs)

            class patran(TUIMenu):
                """
                Imports a PATRAN neutral file (zones defined by named components).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def neutral(self, *args, **kwargs):
                    """
                    Reads a PATRAN Neutral file (zones defined by named components) as a case file.
                    """
                    return PyMenu(self.service, "/file/import/patran/neutral").execute(*args, **kwargs)

            class nastran(TUIMenu):
                """
                Imports a NASTRAN file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def output2(self, *args, **kwargs):
                    """
                    Reads a NASTRAN op2 file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/nastran/output2").execute(*args, **kwargs)
                def bulkdata(self, *args, **kwargs):
                    """
                    Reads a NASTRAN file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/nastran/bulkdata").execute(*args, **kwargs)

            class partition(TUIMenu):
                """
                Enters the partition menu to set conditions for partitioning an ANSYS Fluent case file during read.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def metis_zone(self, *args, **kwargs):
                    """
                    Reads and partitions an ANSYS Fluent case file.
                    """
                    return PyMenu(self.service, "/file/import/partition/metis_zone").execute(*args, **kwargs)
                def metis(self, *args, **kwargs):
                    """
                    Reads and partitions an ANSYS Fluent case file.
                    """
                    return PyMenu(self.service, "/file/import/partition/metis").execute(*args, **kwargs)

            class mechanical_apdl(TUIMenu):
                """
                Imports a Mechanical APDL file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def result(self, *args, **kwargs):
                    """
                    Reads a Mechanical APDL result file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/mechanical_apdl/result").execute(*args, **kwargs)
                def input(self, *args, **kwargs):
                    """
                    Reads a Mechanical APDL file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/mechanical_apdl/input").execute(*args, **kwargs)

            class plot3d(TUIMenu):
                """
                Imports a PLOT3D file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mesh(self, *args, **kwargs):
                    """
                    Reads a PLOT3D file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/plot3d/mesh").execute(*args, **kwargs)

            class tecplot(TUIMenu):
                """
                Enters the Tecplot menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mesh(self, *args, **kwargs):
                    """
                    Reads a Tecplot binary file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/tecplot/mesh").execute(*args, **kwargs)

            class cfx(TUIMenu):
                """
                Imports a CFX file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def result(self, *args, **kwargs):
                    """
                    Reads a CFX definition file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/cfx/result").execute(*args, **kwargs)
                def definition(self, *args, **kwargs):
                    """
                    Reads a CFX definition file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/cfx/definition").execute(*args, **kwargs)

            class abaqus(TUIMenu):
                """
                Imports an ABAQUS file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def odb(self, *args, **kwargs):
                    """
                    Reads an ABAQUS odb file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/abaqus/odb").execute(*args, **kwargs)
                def fil(self, *args, **kwargs):
                    """
                    Reads an ABAQUS .fil result file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/abaqus/fil").execute(*args, **kwargs)
                def input(self, *args, **kwargs):
                    """
                    Reads an ABAQUS input file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/abaqus/input").execute(*args, **kwargs)

            class cgns(TUIMenu):
                """
                Imports a CGNS file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mesh_data(self, *args, **kwargs):
                    """
                    Imports a CGNS mesh file and data file.
                    """
                    return PyMenu(self.service, "/file/import/cgns/mesh_data").execute(*args, **kwargs)
                def mesh(self, *args, **kwargs):
                    """
                    Imports a CGNS mesh file.
                    """
                    return PyMenu(self.service, "/file/import/cgns/mesh").execute(*args, **kwargs)
                def data(self, *args, **kwargs):
                    """
                    Reads data from CGNS file.
                    """
                    return PyMenu(self.service, "/file/import/cgns/data").execute(*args, **kwargs)

        class interpolate(TUIMenu):
            """
            Interpolates data to/from another grid.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def zone_selection(self, *args, **kwargs):
                """
                Defines a list of cell zone IDs. If specified, interpolation data will be read/written for these cell zones only.
                """
                return PyMenu(self.service, "/file/interpolate/zone_selection").execute(*args, **kwargs)
            def read_data(self, *args, **kwargs):
                """
                Reads and interpolates data.
                """
                return PyMenu(self.service, "/file/interpolate/read_data").execute(*args, **kwargs)
            def write_data(self, *args, **kwargs):
                """
                Writes data for interpolation.
                """
                return PyMenu(self.service, "/file/interpolate/write_data").execute(*args, **kwargs)

        class export(TUIMenu):
            """
            Enter the export menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.settings = self.__class__.settings(path + ["settings"], service)
                super().__init__(path, service)
            def cgns(self, *args, **kwargs):
                """
                Write a CGNS file.
                """
                return PyMenu(self.service, "/file/export/cgns").execute(*args, **kwargs)
            def ensight_dvs_surfaces(self, *args, **kwargs):
                """
                Write post-processing data(geometry, velocity and scalars) for surfaces using EnSight Dynamic Visualization Store Interface.
                """
                return PyMenu(self.service, "/file/export/ensight_dvs_surfaces").execute(*args, **kwargs)
            def ensight_dvs_volume(self, *args, **kwargs):
                """
                Write post-processing data(geometry, velocity and scalars) for cell zones and boundaries attached to them using EnSight Dynamic Visualization Store Interface.
                """
                return PyMenu(self.service, "/file/export/ensight_dvs_volume").execute(*args, **kwargs)
            def fast_mesh(self, *args, **kwargs):
                """
                Writes FAST/Plot3D unstructured mesh file.
                """
                return PyMenu(self.service, "/file/export/fast_mesh").execute(*args, **kwargs)
            def system_coupling_definition_file_settings(self, *args, **kwargs):
                """
                Enters the system coupling file (.scp) menu.
                """
                return PyMenu(self.service, "/file/export/system_coupling_definition_file_settings").execute(*args, **kwargs)
            def fieldview_unstruct_mesh(self, *args, **kwargs):
                """
                Writes FIELDVIEW unstructured mesh-only file.
                """
                return PyMenu(self.service, "/file/export/fieldview_unstruct_mesh").execute(*args, **kwargs)
            def fieldview_unstruct_data(self, *args, **kwargs):
                """
                Writes FIELDVIEW unstructured results-only file.
                """
                return PyMenu(self.service, "/file/export/fieldview_unstruct_data").execute(*args, **kwargs)
            def avs(self, *args, **kwargs):
                """
                Writes an AVS UCD file.
                """
                return PyMenu(self.service, "/file/export/avs").execute(*args, **kwargs)
            def fast_velocity(self, *args, **kwargs):
                """
                Writes FAST/Plot3D unstructured vector function file.
                """
                return PyMenu(self.service, "/file/export/fast_velocity").execute(*args, **kwargs)
            def fieldview_unstruct(self, *args, **kwargs):
                """
                Writes FIELDVIEW unstructured combined file.
                """
                return PyMenu(self.service, "/file/export/fieldview_unstruct").execute(*args, **kwargs)
            def icemcfd_for_icepak(self, *args, **kwargs):
                """
                Writes a binary ICEM CFD domain file.
                """
                return PyMenu(self.service, "/file/export/icemcfd_for_icepak").execute(*args, **kwargs)
            def particle_history_data(self, *args, **kwargs):
                """
                Exports particle-history data.
                """
                return PyMenu(self.service, "/file/export/particle_history_data").execute(*args, **kwargs)
            def fieldview_xdb(self, *args, **kwargs):
                """
                Write a FieldView XDB format file.
                """
                return PyMenu(self.service, "/file/export/fieldview_xdb").execute(*args, **kwargs)
            def fieldview_unstruct_surfaces(self, *args, **kwargs):
                """
                Writes FIELDVIEW unstructured file for surfaces. You are prompted to select either [1], [2] or [3] to write either mesh-only, results-only, or combined for surfaces (respectively).
                """
                return PyMenu(self.service, "/file/export/fieldview_unstruct_surfaces").execute(*args, **kwargs)
            def common_fluids_format_post(self, *args, **kwargs):
                """
                Writes common fluids format files (.cas.post and .dat.post) for mesh and data, respectively. These files are saved in the hierarchical data format.
                """
                return PyMenu(self.service, "/file/export/common_fluids_format_post").execute(*args, **kwargs)
            def patran_neutral(self, *args, **kwargs):
                """
                Writes a PATRAN neutral file.
                """
                return PyMenu(self.service, "/file/export/patran_neutral").execute(*args, **kwargs)
            def ensight(self, *args, **kwargs):
                """
                Writes EnSight geometry, velocity, and scalar files.
                """
                return PyMenu(self.service, "/file/export/ensight").execute(*args, **kwargs)
            def tecplot(self, *args, **kwargs):
                """
                Writes a Tecplot+3DV format file.
                """
                return PyMenu(self.service, "/file/export/tecplot").execute(*args, **kwargs)
            def custom_heat_flux(self, *args, **kwargs):
                """
                Writes a generic file for heat transfer.
                """
                return PyMenu(self.service, "/file/export/custom_heat_flux").execute(*args, **kwargs)
            def fieldview_data(self, *args, **kwargs):
                """
                Writes FIELDVIEW case and data files.
                """
                return PyMenu(self.service, "/file/export/fieldview_data").execute(*args, **kwargs)
            def gambit(self, *args, **kwargs):
                """
                Writes GAMBIT neutral file.
                """
                return PyMenu(self.service, "/file/export/gambit").execute(*args, **kwargs)
            def mechanical_apdl_input(self, *args, **kwargs):
                """
                Writes a Mechanical APDL Input file.
                """
                return PyMenu(self.service, "/file/export/mechanical_apdl_input").execute(*args, **kwargs)
            def cdat_for_cfd_post__and__ensight(self, *args, **kwargs):
                """
                Write a CDAT for CFD-Post & EnSight file.
                """
                return PyMenu(self.service, "/file/export/cdat_for_cfd_post__and__ensight").execute(*args, **kwargs)
            def dx(self, *args, **kwargs):
                """
                Writes an IBM Data Explorer format file.
                """
                return PyMenu(self.service, "/file/export/dx").execute(*args, **kwargs)
            def taitherm(self, *args, **kwargs):
                """
                Exports TAITherm file.
                """
                return PyMenu(self.service, "/file/export/taitherm").execute(*args, **kwargs)
            def fieldview(self, *args, **kwargs):
                """
                Writes FIELDVIEW case and data files.
                """
                return PyMenu(self.service, "/file/export/fieldview").execute(*args, **kwargs)
            def ensight_gold(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files.
                """
                return PyMenu(self.service, "/file/export/ensight_gold").execute(*args, **kwargs)
            def fast_solution(self, *args, **kwargs):
                """
                Writes FAST/Plot3D unstructured solution file.
                """
                return PyMenu(self.service, "/file/export/fast_solution").execute(*args, **kwargs)
            def ideas(self, *args, **kwargs):
                """
                Writes an I-deas universal file.
                """
                return PyMenu(self.service, "/file/export/ideas").execute(*args, **kwargs)
            def nastran(self, *args, **kwargs):
                """
                Write a NASTRAN file.
                """
                return PyMenu(self.service, "/file/export/nastran").execute(*args, **kwargs)
            def fast_scalar(self, *args, **kwargs):
                """
                Writes FAST/Plot3D unstructured scalar function file.
                """
                return PyMenu(self.service, "/file/export/fast_scalar").execute(*args, **kwargs)
            def ascii(self, *args, **kwargs):
                """
                Writes an ASCII file.
                """
                return PyMenu(self.service, "/file/export/ascii").execute(*args, **kwargs)
            def mechanical_apdl(self, *args, **kwargs):
                """
                Write an Mechanical APDL file.
                """
                return PyMenu(self.service, "/file/export/mechanical_apdl").execute(*args, **kwargs)
            def abaqus(self, *args, **kwargs):
                """
                Writes an ABAQUS file.
                """
                return PyMenu(self.service, "/file/export/abaqus").execute(*args, **kwargs)
            def ensight_gold_parallel_volume(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files for cell zones in a parallel format suitable for ANSYS Ensight Enterprise.
                """
                return PyMenu(self.service, "/file/export/ensight_gold_parallel_volume").execute(*args, **kwargs)
            def patran_nodal(self, *args, **kwargs):
                """
                Writes a PATRAN nodal results file.
                """
                return PyMenu(self.service, "/file/export/patran_nodal").execute(*args, **kwargs)
            def ensight_gold_parallel_surfaces(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files for surfaces in a parallel format suitable for ANSYS Ensight Enterprise.
                """
                return PyMenu(self.service, "/file/export/ensight_gold_parallel_surfaces").execute(*args, **kwargs)

            class settings(TUIMenu):
                """
                Enter the export settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_cgns_export_filetype(self, *args, **kwargs):
                    """
                    Select HDF5 or ADF as file format for CGNS.
                    """
                    return PyMenu(self.service, "/file/export/settings/set_cgns_export_filetype").execute(*args, **kwargs)

        class cffio_options(TUIMenu):
            """
            Enters the cffio options menu, which provides options for the I/O of case and data files in the Common Fluids Format (CFF).
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def io_mode(self, *args, **kwargs):
                """
                Sets the I/O mode for writing CFF files.
                1. HOST: I/O is done serially by the host process.
                2. NODE0: I/O is done serially by the node 0 process.
                3. PARALLEL INDEPENDENT: I/O is done in parallel using the independent mode of MPI I/O.
                4. PARALLEL COLLECTIVE: I/O is done in parallel using the collective mode of MPI I/O.
                """
                return PyMenu(self.service, "/file/cffio_options/io_mode").execute(*args, **kwargs)
            def single_precision_data(self, *args, **kwargs):
                """
                Specifies whether the double-precision solver saves single-precision data when writing CFF data files, in order to reduce the size of the files.
                """
                return PyMenu(self.service, "/file/cffio_options/single_precision_data").execute(*args, **kwargs)
            def compression_level(self, *args, **kwargs):
                """
                Sets the compression level for CFF files. The compression level can be set between 0 and 9 with 0 being least compression (fastest) and 9 being highest compression (slowest).
                """
                return PyMenu(self.service, "/file/cffio_options/compression_level").execute(*args, **kwargs)

        class table_manager(TUIMenu):
            """
            Enters the table file manager menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def rename(self, *args, **kwargs):
                """
                Renames a locally-stored table.
                """
                return PyMenu(self.service, "/file/table_manager/rename").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a locally-stored table.
                """
                return PyMenu(self.service, "/file/table_manager/list_properties").execute(*args, **kwargs)
            def list_tables(self, *args, **kwargs):
                """
                Lists all locally-stored tables.
                """
                return PyMenu(self.service, "/file/table_manager/list_tables").execute(*args, **kwargs)
            def store_in_case_file(self, *args, **kwargs):
                """
                Sets the persistence mode for RGP tables (embedded in case file or rely on external file).
                """
                return PyMenu(self.service, "/file/table_manager/store_in_case_file").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a table from local storage.
                """
                return PyMenu(self.service, "/file/table_manager/delete").execute(*args, **kwargs)
            def read_matrix_data_file(self, *args, **kwargs):
                """
                Imports a “matrix” type table from a file into local storage.
                """
                return PyMenu(self.service, "/file/table_manager/read_matrix_data_file").execute(*args, **kwargs)
            def read_rgp_file(self, *args, **kwargs):
                """
                Imports a set of Real Gas Property (RGP) tables from a file into local storage.
                """
                return PyMenu(self.service, "/file/table_manager/read_rgp_file").execute(*args, **kwargs)
            def list_matrix_data(self, *args, **kwargs):
                """
                Lists the data of a “matrix” type locally-stored table.
                """
                return PyMenu(self.service, "/file/table_manager/list_matrix_data").execute(*args, **kwargs)

        class project(TUIMenu):
            """
            Enter to create new project, open project, save and archive project.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def new(self, *args, **kwargs):
                """
                Create New Project.
                """
                return PyMenu(self.service, "/file/project[beta]/new").execute(*args, **kwargs)
            def archive(self, *args, **kwargs):
                """
                Archive Project.
                """
                return PyMenu(self.service, "/file/project[beta]/archive").execute(*args, **kwargs)
            def open(self, *args, **kwargs):
                """
                Open project.
                """
                return PyMenu(self.service, "/file/project[beta]/open").execute(*args, **kwargs)
            def save_as_copy(self, *args, **kwargs):
                """
                Save As Copy.
                """
                return PyMenu(self.service, "/file/project[beta]/save_as_copy").execute(*args, **kwargs)
            def save(self, *args, **kwargs):
                """
                Save Project.
                """
                return PyMenu(self.service, "/file/project[beta]/save").execute(*args, **kwargs)
            def save_as(self, *args, **kwargs):
                """
                Save As Project.
                """
                return PyMenu(self.service, "/file/project[beta]/save_as").execute(*args, **kwargs)

        class solution_files(TUIMenu):
            """
            Enters the solution files menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def print_solution_files(self, *args, **kwargs):
                """
                Prints a list of available solution files.
                """
                return PyMenu(self.service, "/file/solution_files/print_solution_files").execute(*args, **kwargs)
            def load_solution(self, *args, **kwargs):
                """
                Loads a solution file.
                """
                return PyMenu(self.service, "/file/solution_files/load_solution").execute(*args, **kwargs)
            def delete_solution(self, *args, **kwargs):
                """
                Deletes solution files.
                """
                return PyMenu(self.service, "/file/solution_files/delete_solution").execute(*args, **kwargs)

    class results(TUIMenu):
        """
        Enter results menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.graphics_window = self.__class__.graphics_window(path + ["graphics_window"], service)
            self.surface = self.__class__.surface(path + ["surface"], service)
            self.report = self.__class__.report(path + ["report"], service)
            self.graphics = self.__class__.graphics(path + ["graphics"], service)
            self.plot = self.__class__.plot(path + ["plot"], service)
            self.animate = self.__class__.animate(path + ["animate"], service)
            super().__init__(path, service)

        class graphics_window(TUIMenu):
            """
            Enter graphics window menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.picture = self.__class__.picture(path + ["picture"], service)
                self.view_sync = self.__class__.view_sync(path + ["view_sync"], service)
                self.titles = self.__class__.titles(path + ["titles"], service)
                self.embedded_windows = self.__class__.embedded_windows(path + ["embedded_windows"], service)
                self.windows = self.__class__.windows(path + ["windows"], service)
                self.display_states = self.__class__.display_states(path + ["display_states"], service)
                self.views = self.__class__.views(path + ["views"], service)
                super().__init__(path, service)
            def open_window(self, *args, **kwargs):
                """
                Open a user graphics window.
                """
                return PyMenu(self.service, "/results/graphics_window/open_window").execute(*args, **kwargs)
            def close_window_by_name(self, *args, **kwargs):
                """
                Close a reserved graphics window by its name.
                """
                return PyMenu(self.service, "/results/graphics_window/close_window_by_name").execute(*args, **kwargs)
            def update_layout(self, *args, **kwargs):
                """
                Update the fluent layout.
                """
                return PyMenu(self.service, "/results/graphics_window/update_layout").execute(*args, **kwargs)
            def close_window(self, *args, **kwargs):
                """
                Close a user graphics window.
                """
                return PyMenu(self.service, "/results/graphics_window/close_window").execute(*args, **kwargs)
            def set_window(self, *args, **kwargs):
                """
                Set a user graphics window to be the active window.
                """
                return PyMenu(self.service, "/results/graphics_window/set_window").execute(*args, **kwargs)
            def set_window_by_name(self, *args, **kwargs):
                """
                Set a reserved graphics window to be the active window by its name.
                """
                return PyMenu(self.service, "/results/graphics_window/set_window_by_name").execute(*args, **kwargs)
            def save_picture(self, *args, **kwargs):
                """
                Generate a "hardcopy" of the active window.
                """
                return PyMenu(self.service, "/results/graphics_window/save_picture").execute(*args, **kwargs)

            class picture(TUIMenu):
                """
                Enter the hardcopy/save-picture options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                    self.driver = self.__class__.driver(path + ["driver"], service)
                    super().__init__(path, service)
                def x_resolution(self, *args, **kwargs):
                    """
                    Set the width of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/x_resolution").execute(*args, **kwargs)
                def preview(self, *args, **kwargs):
                    """
                    Display a preview image of a hardcopy.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/preview").execute(*args, **kwargs)
                def jpeg_hardcopy_quality(self, *args, **kwargs):
                    """
                    To set jpeg hardcopy quality.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/jpeg_hardcopy_quality").execute(*args, **kwargs)
                def set_standard_resolution(self, *args, **kwargs):
                    """
                    Select from pre-defined resolution list.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/set_standard_resolution").execute(*args, **kwargs)
                def use_window_resolution(self, *args, **kwargs):
                    """
                    Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/use_window_resolution").execute(*args, **kwargs)
                def invert_background(self, *args, **kwargs):
                    """
                    Use a white background when the picture is saved.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/invert_background").execute(*args, **kwargs)
                def dpi(self, *args, **kwargs):
                    """
                    Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/dpi").execute(*args, **kwargs)
                def y_resolution(self, *args, **kwargs):
                    """
                    Set the height of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/y_resolution").execute(*args, **kwargs)
                def landscape(self, *args, **kwargs):
                    """
                    Plot hardcopies in landscape or portrait orientation.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/landscape").execute(*args, **kwargs)

                class color_mode(TUIMenu):
                    """
                    Enter the hardcopy color mode menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list(self, *args, **kwargs):
                        """
                        Display the current hardcopy color mode.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/list").execute(*args, **kwargs)
                    def gray_scale(self, *args, **kwargs):
                        """
                        Convert color to grayscale for hardcopy.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/gray_scale").execute(*args, **kwargs)
                    def color(self, *args, **kwargs):
                        """
                        Plot hardcopies in color.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/color").execute(*args, **kwargs)
                    def mono_chrome(self, *args, **kwargs):
                        """
                        Convert color to monochrome (black and white) for hardcopy.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/mono_chrome").execute(*args, **kwargs)

                class driver(TUIMenu):
                    """
                    Enter the set hardcopy driver menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.post_format = self.__class__.post_format(path + ["post_format"], service)
                        super().__init__(path, service)
                    def options(self, *args, **kwargs):
                        """
                        Set the hardcopy options. Available options are:
                        "no gamma correction", disables gamma correction of colors,
                        "physical size = (width,height)", where width and height
                        are the actual measurements of the printable area of the page
                        in centimeters.
                        "subscreen = (left,right,bottom,top)", where left,right,
                        bottom, and top are numbers in [-1,1] describing a subwindow on
                        the page in which to place the hardcopy.
                        The options may be combined by separating them with commas.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/options").execute(*args, **kwargs)
                    def vrml(self, *args, **kwargs):
                        """
                        Use VRML output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/vrml").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the current hardcopy driver.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/list").execute(*args, **kwargs)
                    def jpeg(self, *args, **kwargs):
                        """
                        Produce JPEG output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/jpeg").execute(*args, **kwargs)
                    def hsf(self, *args, **kwargs):
                        """
                        Use HSF output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/hsf").execute(*args, **kwargs)
                    def tiff(self, *args, **kwargs):
                        """
                        Use TIFF output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/tiff").execute(*args, **kwargs)
                    def glb(self, *args, **kwargs):
                        """
                        Use GLB output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/glb").execute(*args, **kwargs)
                    def eps(self, *args, **kwargs):
                        """
                        Produce encapsulated PostScript (EPS) output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/eps").execute(*args, **kwargs)
                    def ppm(self, *args, **kwargs):
                        """
                        Produce PPM output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/ppm").execute(*args, **kwargs)
                    def dump_window(self, *args, **kwargs):
                        """
                        Set the command used to dump the graphics window to a file.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/dump_window").execute(*args, **kwargs)
                    def png(self, *args, **kwargs):
                        """
                        Use PNG output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/png").execute(*args, **kwargs)
                    def avz(self, *args, **kwargs):
                        """
                        Use AVZ output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/avz").execute(*args, **kwargs)
                    def post_script(self, *args, **kwargs):
                        """
                        Produce PostScript output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/post_script").execute(*args, **kwargs)

                    class post_format(TUIMenu):
                        """
                        Enter the PostScript driver format menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vector(self, *args, **kwargs):
                            """
                            Use vector format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/vector").execute(*args, **kwargs)
                        def rle_raster(self, *args, **kwargs):
                            """
                            Use the run-length encoded raster format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/rle_raster").execute(*args, **kwargs)
                        def fast_raster(self, *args, **kwargs):
                            """
                            Use the new raster format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/fast_raster").execute(*args, **kwargs)
                        def raster(self, *args, **kwargs):
                            """
                            Use the original raster format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/raster").execute(*args, **kwargs)

            class view_sync(TUIMenu):
                """
                Enter the display state manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    Print window ids of open windows.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/list").execute(*args, **kwargs)
                def add_all(self, *args, **kwargs):
                    """
                    Synchronize all windows.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/add_all").execute(*args, **kwargs)
                def remove_all(self, *args, **kwargs):
                    """
                    Unsynchronize all windows.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/remove_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add list of window ids for synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/add").execute(*args, **kwargs)
                def stop(self, *args, **kwargs):
                    """
                    Stop view synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/stop").execute(*args, **kwargs)
                def start(self, *args, **kwargs):
                    """
                    Start view synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/start").execute(*args, **kwargs)
                def remove(self, *args, **kwargs):
                    """
                    Remove list of window ids from synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/remove").execute(*args, **kwargs)

            class titles(TUIMenu):
                """
                Set problem title.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def left_top(self, *args, **kwargs):
                    """
                    Set the title text for left top in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/left_top").execute(*args, **kwargs)
                def left_bottom(self, *args, **kwargs):
                    """
                    Set the title text for left bottom in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/left_bottom").execute(*args, **kwargs)
                def right_middle(self, *args, **kwargs):
                    """
                    Set the title text for right middle in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/right_middle").execute(*args, **kwargs)
                def right_top(self, *args, **kwargs):
                    """
                    Set the title text for right top in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/right_top").execute(*args, **kwargs)
                def right_bottom(self, *args, **kwargs):
                    """
                    Set the title text for right bottom in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/right_bottom").execute(*args, **kwargs)

            class embedded_windows(TUIMenu):
                """
                Enter to embed, close, move-out embedded windows.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def move_out(self, *args, **kwargs):
                    """
                    Move out an embedded window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/move_out").execute(*args, **kwargs)
                def close(self, *args, **kwargs):
                    """
                    Close an embedded window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/close").execute(*args, **kwargs)
                def close_all(self, *args, **kwargs):
                    """
                    Close all embedded windows for given parent window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/close_all").execute(*args, **kwargs)
                def move_out_all(self, *args, **kwargs):
                    """
                    Move out all embedded windows for given parent window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/move_out_all").execute(*args, **kwargs)
                def embed_in(self, *args, **kwargs):
                    """
                    Embed Window into another window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/embed_in").execute(*args, **kwargs)

            class windows(TUIMenu):
                """
                Enter the window options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.text = self.__class__.text(path + ["text"], service)
                    self.axes = self.__class__.axes(path + ["axes"], service)
                    self.video = self.__class__.video(path + ["video"], service)
                    self.xy = self.__class__.xy(path + ["xy"], service)
                    self.scale = self.__class__.scale(path + ["scale"], service)
                    self.main = self.__class__.main(path + ["main"], service)
                    super().__init__(path, service)
                def logo(self, *args, **kwargs):
                    """
                    Enable/disable visibility of the logo in graphics window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/logo").execute(*args, **kwargs)
                def logo_color(self, *args, **kwargs):
                    """
                    Set logo color to white/black.
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/logo_color").execute(*args, **kwargs)
                def ruler(self, *args, **kwargs):
                    """
                    Enable/disable ruler visibility.
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/ruler").execute(*args, **kwargs)
                def aspect_ratio(self, *args, **kwargs):
                    """
                    Set the aspect ratio of the active window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/aspect_ratio").execute(*args, **kwargs)

                class text(TUIMenu):
                    """
                    Enter the text window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def border(self, *args, **kwargs):
                        """
                        Enable/disable drawing of borders around the text window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/border").execute(*args, **kwargs)
                    def date(self, *args, **kwargs):
                        """
                        Enable/disable the date in the picture.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/date").execute(*args, **kwargs)
                    def application(self, *args, **kwargs):
                        """
                        Enable/disable the application name in the picture.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/application").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Set the left boundary of the text window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/left").execute(*args, **kwargs)
                    def company(self, *args, **kwargs):
                        """
                        Enable/disable the company name in the picture.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/company").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        Set the top boundary of the text window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/top").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Set the right boundary of the text window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/right").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Enable/disable text window transparency.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/visible").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        Enable/disable text window transparency.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/clear").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Set the bottom boundary of the text window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/bottom").execute(*args, **kwargs)

                class axes(TUIMenu):
                    """
                    Enter the axes window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def visible(self, *args, **kwargs):
                        """
                        Enable/disable axes visibility.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/visible").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Enable/disable drawing of a border around the axes window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/border").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Set the right boundary of the axes window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/right").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Set the bottom boundary of the axes window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/bottom").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        Set the transparency of the axes window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/clear").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enter the video window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def foreground(self, *args, **kwargs):
                        """
                        Set the foreground color in the video picture.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/foreground").execute(*args, **kwargs)
                    def color_filter(self, *args, **kwargs):
                        """
                        Set the color filter options for the picture.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/color_filter").execute(*args, **kwargs)
                    def pixel_size(self, *args, **kwargs):
                        """
                        Set the window size in pixels.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/pixel_size").execute(*args, **kwargs)
                    def on(self, *args, **kwargs):
                        """
                        Enable/disable video picture settings.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/on").execute(*args, **kwargs)
                    def background(self, *args, **kwargs):
                        """
                        Set the background color in the video picture.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/background").execute(*args, **kwargs)

                class xy(TUIMenu):
                    """
                    Enter the X-Y plot window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def top(self, *args, **kwargs):
                        """
                        Set the top boundary of the X-Y plotter window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/top").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Set the bottom boundary of the X-Y plotter window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/bottom").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Set the right boundary of the X-Y plotter window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/right").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Enable/disable X-Y plotter window visibility.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/visible").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Enable/disable drawing of a border around the X-Y plotter window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/border").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Set the left boundary of the X-Y plotter window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/left").execute(*args, **kwargs)

                class scale(TUIMenu):
                    """
                    Enter the color scale window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def font_size(self, *args, **kwargs):
                        """
                        Set the font size of the color scale window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/font_size").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Enable/disable drawing of borders around the color scale window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/border").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        Set the transparency of the scale window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/clear").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Set the bottom boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/bottom").execute(*args, **kwargs)
                    def alignment(self, *args, **kwargs):
                        """
                        Set colormap to bottom/left/top/right.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/alignment").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Set the right boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/right").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set the number format of the color scale window (e.g. %0.2e).
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/format").execute(*args, **kwargs)
                    def margin(self, *args, **kwargs):
                        """
                        Set the margin of the color scale window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/margin").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        Set the top boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/top").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Set the left boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/left").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Enable/disable visibility of the color scale window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/visible").execute(*args, **kwargs)

                class main(TUIMenu):
                    """
                    Enter the main view window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def left(self, *args, **kwargs):
                        """
                        Set the left boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/left").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Set the bottom boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/bottom").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        Set the top boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/top").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Enable/disable drawing of borders around the main viewing window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/border").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Set the right boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/right").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Enable/disable visibility of the main viewing window.
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/visible").execute(*args, **kwargs)

            class display_states(TUIMenu):
                """
                Enter the display state manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write(self, *args, **kwargs):
                    """
                    Write display states to a file.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/write").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create a new display state.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/create").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Create a new display state with settings copied from an existing display state.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/copy").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Print the names of the available display states to the console.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/list").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit a particular display state setting.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/edit").execute(*args, **kwargs)
                def use_active(self, *args, **kwargs):
                    """
                    Update an existing display state's settings to match those of the active graphics window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/use_active").execute(*args, **kwargs)
                def apply(self, *args, **kwargs):
                    """
                    Apply a display state to the active window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/apply").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete a display state.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/delete").execute(*args, **kwargs)
                def read(self, *args, **kwargs):
                    """
                    Read display states from a file.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/read").execute(*args, **kwargs)

            class views(TUIMenu):
                """
                Enter the view manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.camera = self.__class__.camera(path + ["camera"], service)
                    super().__init__(path, service)
                def read_views(self, *args, **kwargs):
                    """
                    Read views from a view file.
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/read_views").execute(*args, **kwargs)
                def restore_view(self, *args, **kwargs):
                    """
                    Use a saved view.
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/restore_view").execute(*args, **kwargs)
                def delete_view(self, *args, **kwargs):
                    """
                    Remove a view from the list.
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/delete_view").execute(*args, **kwargs)
                def save_view(self, *args, **kwargs):
                    """
                    Save the current view to the view list.
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/save_view").execute(*args, **kwargs)
                def list_views(self, *args, **kwargs):
                    """
                    List predefined and saved views.
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/list_views").execute(*args, **kwargs)
                def next_view(self, *args, **kwargs):
                    """
                    Return to the camera position after the current position in the stack.
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/next_view").execute(*args, **kwargs)
                def default_view(self, *args, **kwargs):
                    """
                    Reset view to front and center.
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/default_view").execute(*args, **kwargs)
                def last_view(self, *args, **kwargs):
                    """
                    Return to the camera position before the last manipulation.
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/last_view").execute(*args, **kwargs)
                def auto_scale(self, *args, **kwargs):
                    """
                    Scale and center the current scene.
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/auto_scale").execute(*args, **kwargs)
                def write_views(self, *args, **kwargs):
                    """
                    Write selected views to a view file.
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/write_views").execute(*args, **kwargs)

                class camera(TUIMenu):
                    """
                    Enter the camera menu to modify the current viewing parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def projection(self, *args, **kwargs):
                        """
                        Set the camera projection type.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/projection").execute(*args, **kwargs)
                    def field(self, *args, **kwargs):
                        """
                        Set the field of view (width and height).
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/field").execute(*args, **kwargs)
                    def pan_camera(self, *args, **kwargs):
                        """
                        Adjust the camera target without modifying the position.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/pan_camera").execute(*args, **kwargs)
                    def roll_camera(self, *args, **kwargs):
                        """
                        Adjust the camera up-vector.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/roll_camera").execute(*args, **kwargs)
                    def position(self, *args, **kwargs):
                        """
                        Set the camera position.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/position").execute(*args, **kwargs)
                    def orbit_camera(self, *args, **kwargs):
                        """
                        Adjust the camera position without modifying the target.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/orbit_camera").execute(*args, **kwargs)
                    def target(self, *args, **kwargs):
                        """
                        Set the point to be the center of the camera view.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/target").execute(*args, **kwargs)
                    def zoom_camera(self, *args, **kwargs):
                        """
                        Adjust the camera field of view.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/zoom_camera").execute(*args, **kwargs)
                    def dolly_camera(self, *args, **kwargs):
                        """
                        Adjust the camera position and target.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/dolly_camera").execute(*args, **kwargs)
                    def up_vector(self, *args, **kwargs):
                        """
                        Set the camera up-vector.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/up_vector").execute(*args, **kwargs)

        class surface(TUIMenu):
            """
            Enter the data surface manipulation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.query = self.__class__.query(path + ["query"], service)
                self.post_processing_volume = self.__class__.post_processing_volume(path + ["post_processing_volume"], service)
                super().__init__(path, service)
            def rake_surface(self, *args, **kwargs):
                """
                Define a "rake" surface by specifying the end points.
                """
                return PyMenu(self.service, "/results/surface/rake_surface").execute(*args, **kwargs)
            def zone_surface(self, *args, **kwargs):
                """
                Define a data surface on a mesh zone.
                """
                return PyMenu(self.service, "/results/surface/zone_surface").execute(*args, **kwargs)
            def ungroup_surface(self, *args, **kwargs):
                """
                Ungroup the surface(if grouped).
                """
                return PyMenu(self.service, "/results/surface/ungroup_surface").execute(*args, **kwargs)
            def quadric_slice(self, *args, **kwargs):
                """
                Extract a quadric slice.
                """
                return PyMenu(self.service, "/results/surface/quadric_slice").execute(*args, **kwargs)
            def rename_surface(self, *args, **kwargs):
                """
                Rename a defined data surface.
                """
                return PyMenu(self.service, "/results/surface/rename_surface").execute(*args, **kwargs)
            def cone_slice(self, *args, **kwargs):
                """
                Extract a cone slice.
                """
                return PyMenu(self.service, "/results/surface/cone_slice").execute(*args, **kwargs)
            def reset_zone_surfaces(self, *args, **kwargs):
                """
                Reset case surface list.
                """
                return PyMenu(self.service, "/results/surface/reset_zone_surfaces").execute(*args, **kwargs)
            def plane_slice(self, *args, **kwargs):
                """
                Extract a planar slice.
                """
                return PyMenu(self.service, "/results/surface/plane_slice").execute(*args, **kwargs)
            def line_slice(self, *args, **kwargs):
                """
                Extract a linear slice.
                """
                return PyMenu(self.service, "/results/surface/line_slice").execute(*args, **kwargs)
            def transform_surface(self, *args, **kwargs):
                """
                Transform surface.
                """
                return PyMenu(self.service, "/results/surface/transform_surface").execute(*args, **kwargs)
            def point_array(self, *args, **kwargs):
                """
                Extract a rectangular array of data points.
                """
                return PyMenu(self.service, "/results/surface/point_array").execute(*args, **kwargs)
            def line_surface(self, *args, **kwargs):
                """
                Define a "line" surface by specifying the two endpoint coordinates.
                """
                return PyMenu(self.service, "/results/surface/line_surface").execute(*args, **kwargs)
            def create_imprint_surface(self, *args, **kwargs):
                """
                Imprint surface.
                """
                return PyMenu(self.service, "/results/surface/create_imprint_surface").execute(*args, **kwargs)
            def structural_point_surface(self, *args, **kwargs):
                """
                Define a "structural point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/results/surface/structural_point_surface").execute(*args, **kwargs)
            def group_surfaces(self, *args, **kwargs):
                """
                Group a set of surfaces.
                """
                return PyMenu(self.service, "/results/surface/group_surfaces").execute(*args, **kwargs)
            def list_surfaces(self, *args, **kwargs):
                """
                List the number of facets in the defined surfaces.
                """
                return PyMenu(self.service, "/results/surface/list_surfaces").execute(*args, **kwargs)
            def mouse_line(self, *args, **kwargs):
                """
                Define a line surface using the mouse to select two points.
                """
                return PyMenu(self.service, "/results/surface/mouse_line").execute(*args, **kwargs)
            def sphere_slice(self, *args, **kwargs):
                """
                Extract a spherical slice.
                """
                return PyMenu(self.service, "/results/surface/sphere_slice").execute(*args, **kwargs)
            def multiple_plane_surfaces(self, *args, **kwargs):
                """
                Create multiple plane surfaces at specified spacing.
                """
                return PyMenu(self.service, "/results/surface/multiple_plane_surfaces").execute(*args, **kwargs)
            def plane_surface(self, *args, **kwargs):
                """
                Create a plane from a coordinate plane, point and normal, or three points.
                """
                return PyMenu(self.service, "/results/surface/plane_surface").execute(*args, **kwargs)
            def point_surface(self, *args, **kwargs):
                """
                Define a "point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/results/surface/point_surface").execute(*args, **kwargs)
            def expression_volume(self, *args, **kwargs):
                """
                Create volume with boolean expression.
                """
                return PyMenu(self.service, "/results/surface/expression_volume").execute(*args, **kwargs)
            def iso_clip(self, *args, **kwargs):
                """
                Clip a data surface (surface, curve, or point) between two iso-values.
                """
                return PyMenu(self.service, "/results/surface/iso_clip").execute(*args, **kwargs)
            def partition_surface(self, *args, **kwargs):
                """
                Define a data surface on mesh faces on the partition boundary.
                """
                return PyMenu(self.service, "/results/surface/partition_surface").execute(*args, **kwargs)
            def ellipsoid_slice(self, *args, **kwargs):
                """
                Extract a ellipsoid slice.
                """
                return PyMenu(self.service, "/results/surface/ellipsoid_slice").execute(*args, **kwargs)
            def multiple_iso_surfaces(self, *args, **kwargs):
                """
                Create multiple iso-surfaces from the data field at specified spacing.
                """
                return PyMenu(self.service, "/results/surface/multiple_iso_surfaces").execute(*args, **kwargs)
            def delete_surface(self, *args, **kwargs):
                """
                Remove a defined data surface.
                """
                return PyMenu(self.service, "/results/surface/delete_surface").execute(*args, **kwargs)
            def plane(self, *args, **kwargs):
                """
                Create a plane given 3 points bounded by the domain.
                """
                return PyMenu(self.service, "/results/surface/plane").execute(*args, **kwargs)
            def edit_surface(self, *args, **kwargs):
                """
                Edit a defined data surface.
                """
                return PyMenu(self.service, "/results/surface/edit_surface").execute(*args, **kwargs)
            def iso_surface(self, *args, **kwargs):
                """
                Extract an iso-surface (surface, curve, or point) from the curent data field.
                """
                return PyMenu(self.service, "/results/surface/iso_surface").execute(*args, **kwargs)
            def surface_cells(self, *args, **kwargs):
                """
                Extract all cells intersected by a data surface.
                """
                return PyMenu(self.service, "/results/surface/surface_cells").execute(*args, **kwargs)
            def mouse_rake(self, *args, **kwargs):
                """
                Define a "rake" surface using the mouse to select the end points.
                """
                return PyMenu(self.service, "/results/surface/mouse_rake").execute(*args, **kwargs)
            def multiple_zone_surfaces(self, *args, **kwargs):
                """
                Create multiple data surfaces at a time.
                """
                return PyMenu(self.service, "/results/surface/multiple_zone_surfaces").execute(*args, **kwargs)
            def circle_slice(self, *args, **kwargs):
                """
                Extract a circular slice.
                """
                return PyMenu(self.service, "/results/surface/circle_slice").execute(*args, **kwargs)
            def mouse_plane(self, *args, **kwargs):
                """
                Define a plane surface using the mouse to select three points.
                """
                return PyMenu(self.service, "/results/surface/mouse_plane").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter surface query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list_named_selection(self, *args, **kwargs):
                    """
                    List named selection of surface type.
                    """
                    return PyMenu(self.service, "/results/surface/query/list_named_selection").execute(*args, **kwargs)
                def list_queries(self, *args, **kwargs):
                    """
                    List all saved queries.
                    """
                    return PyMenu(self.service, "/results/surface/query/list_queries").execute(*args, **kwargs)
                def named_surface_list(self, *args, **kwargs):
                    """
                    Create named list of surfaces.
                    """
                    return PyMenu(self.service, "/results/surface/query/named_surface_list").execute(*args, **kwargs)
                def delete_query(self, *args, **kwargs):
                    """
                    Delete saved query.
                    """
                    return PyMenu(self.service, "/results/surface/query/delete_query").execute(*args, **kwargs)
                def list_surfaces(self, *args, **kwargs):
                    """
                    List surfaces.
                    """
                    return PyMenu(self.service, "/results/surface/query/list_surfaces").execute(*args, **kwargs)

            class post_processing_volume(TUIMenu):
                """
                Enter post-processing volume menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create_octree(self, *args, **kwargs):
                    """
                    Create post-processing octree mesh based on current case.
                    """
                    return PyMenu(self.service, "/results/surface/post_processing_volume/create_octree").execute(*args, **kwargs)
                def create_from_file(self, *args, **kwargs):
                    """
                    Read post-processing mesh from file.
                    """
                    return PyMenu(self.service, "/results/surface/post_processing_volume/create_from_file").execute(*args, **kwargs)

        class report(TUIMenu):
            """
            Enter the report menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.icing = self.__class__.icing(path + ["icing"], service)
                self.fluxes = self.__class__.fluxes(path + ["fluxes"], service)
                self.system = self.__class__.system(path + ["system"], service)
                self.modified_setting = self.__class__.modified_setting(path + ["modified_setting"], service)
                self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.forces = self.__class__.forces(path + ["forces"], service)
                self.dpm_histogram = self.__class__.dpm_histogram(path + ["dpm_histogram"], service)
                self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
                self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                super().__init__(path, service)
            def summary(self, *args, **kwargs):
                """
                Print report summary.
                """
                return PyMenu(self.service, "/results/report/summary").execute(*args, **kwargs)
            def volume_integrals(self, *args, **kwargs):
                """
                Volume Integral menu.
                """
                return PyMenu(self.service, "/results/report/volume_integrals").execute(*args, **kwargs)
            def aero_optical_distortions(self, *args, **kwargs):
                """
                Optics report menu.
                """
                return PyMenu(self.service, "/results/report/aero_optical_distortions").execute(*args, **kwargs)
            def mphase_summary(self, *args, **kwargs):
                """
                Multiphase Summary and Recommendations.
                """
                return PyMenu(self.service, "/results/report/mphase_summary").execute(*args, **kwargs)
            def element_mass_flow(self, *args, **kwargs):
                """
                Print list of element mass flow rates at boundaries.
                """
                return PyMenu(self.service, "/results/report/element_mass_flow").execute(*args, **kwargs)
            def particle_summary(self, *args, **kwargs):
                """
                Print summary report for all current particles.
                """
                return PyMenu(self.service, "/results/report/particle_summary").execute(*args, **kwargs)
            def uds_flow(self, *args, **kwargs):
                """
                Print list of UDS flow rate at boundaries.
                """
                return PyMenu(self.service, "/results/report/uds_flow").execute(*args, **kwargs)
            def path_line_summary(self, *args, **kwargs):
                """
                Print path-line-summary report.
                """
                return PyMenu(self.service, "/results/report/path_line_summary").execute(*args, **kwargs)
            def print_histogram(self, *args, **kwargs):
                """
                Print a histogram of a scalar quantity.
                """
                return PyMenu(self.service, "/results/report/print_histogram").execute(*args, **kwargs)
            def projected_surface_area(self, *args, **kwargs):
                """
                Print total area of the projection of a group of surfaces to a plane.
                """
                return PyMenu(self.service, "/results/report/projected_surface_area").execute(*args, **kwargs)
            def species_mass_flow(self, *args, **kwargs):
                """
                Print list of species mass flow rates at boundaries.
                """
                return PyMenu(self.service, "/results/report/species_mass_flow").execute(*args, **kwargs)
            def dpm_extended_summary(self, *args, **kwargs):
                """
                Print extended discrete phase summary report of particle fates, with options.
                """
                return PyMenu(self.service, "/results/report/dpm_extended_summary").execute(*args, **kwargs)
            def dpm_summary(self, *args, **kwargs):
                """
                Print discrete phase summary report of particle fates.
                """
                return PyMenu(self.service, "/results/report/dpm_summary").execute(*args, **kwargs)
            def dpm_sample_output_udf(self, *args, **kwargs):
                """
                Set the DPM sampling output UDF.
                """
                return PyMenu(self.service, "/results/report/dpm_sample_output_udf").execute(*args, **kwargs)
            def dpm_zone_summaries_per_injection(self, *args, **kwargs):
                """
                Enable per-injection zone DPM summaries.
                """
                return PyMenu(self.service, "/results/report/dpm_zone_summaries_per_injection").execute(*args, **kwargs)
            def surface_integrals(self, *args, **kwargs):
                """
                Surface Integral menu.
                """
                return PyMenu(self.service, "/results/report/surface_integrals").execute(*args, **kwargs)
            def dpm_sample_sort_file(self, *args, **kwargs):
                """
                Enable writing of sorted DPM sample files.
                """
                return PyMenu(self.service, "/results/report/dpm_sample_sort_file").execute(*args, **kwargs)
            def dpm_sample(self, *args, **kwargs):
                """
                Sample trajectories at boundaries and lines/planes.
                """
                return PyMenu(self.service, "/results/report/dpm_sample").execute(*args, **kwargs)
            def write_histogram(self, *args, **kwargs):
                """
                Write a histogram of a scalar quantity to a file.
                """
                return PyMenu(self.service, "/results/report/write_histogram").execute(*args, **kwargs)

            class icing(TUIMenu):
                """
                Icing reports menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mass_of_water_impinged(self, *args, **kwargs):
                    """
                    Print Mass of Water Impingement.
                    """
                    return PyMenu(self.service, "/results/report/icing/mass_of_water_impinged").execute(*args, **kwargs)
                def mass_of_ice(self, *args, **kwargs):
                    """
                    Print Mass of Ice Accretion.
                    """
                    return PyMenu(self.service, "/results/report/icing/mass_of_ice").execute(*args, **kwargs)
                def particles_crystals_collection_eff(self, *args, **kwargs):
                    """
                    Print Crystals Collection Efficiency.
                    """
                    return PyMenu(self.service, "/results/report/icing/particles_crystals_collection_eff").execute(*args, **kwargs)
                def icing_energy_of_conduction(self, *args, **kwargs):
                    """
                    Print Energy of Conduction.
                    """
                    return PyMenu(self.service, "/results/report/icing/icing_energy_of_conduction").execute(*args, **kwargs)
                def energy_of_water_impinged(self, *args, **kwargs):
                    """
                    Print Energy of Water Impingement.
                    """
                    return PyMenu(self.service, "/results/report/icing/energy_of_water_impinged").execute(*args, **kwargs)
                def particles_droplets_collection_eff(self, *args, **kwargs):
                    """
                    Print Droplets Collection Efficiency.
                    """
                    return PyMenu(self.service, "/results/report/icing/particles_droplets_collection_eff").execute(*args, **kwargs)
                def energy_of_ice_formation(self, *args, **kwargs):
                    """
                    Print Energy of Ice Formation.
                    """
                    return PyMenu(self.service, "/results/report/icing/energy_of_ice_formation").execute(*args, **kwargs)

            class fluxes(TUIMenu):
                """
                Flux report menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mass_flow(self, *args, **kwargs):
                    """
                    Print mass flow rate at inlets and outlets.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/mass_flow").execute(*args, **kwargs)
                def heat_transfer_sensible(self, *args, **kwargs):
                    """
                    Print sensible heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/heat_transfer_sensible").execute(*args, **kwargs)
                def heat_transfer(self, *args, **kwargs):
                    """
                    Print heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/heat_transfer").execute(*args, **kwargs)
                def film_heat_transfer(self, *args, **kwargs):
                    """
                    Print film heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/film_heat_transfer").execute(*args, **kwargs)
                def film_mass_flow(self, *args, **kwargs):
                    """
                    Print film mass flow rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/film_mass_flow").execute(*args, **kwargs)
                def rad_heat_trans(self, *args, **kwargs):
                    """
                    Print radiation heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/rad_heat_trans").execute(*args, **kwargs)
                def viscous_work(self, *args, **kwargs):
                    """
                    Print viscous work rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/viscous_work").execute(*args, **kwargs)
                def pressure_work(self, *args, **kwargs):
                    """
                    Print pressure work rate at moving boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/pressure_work").execute(*args, **kwargs)

            class system(TUIMenu):
                """
                Sytem menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def proc_stats(self, *args, **kwargs):
                    """
                    Fluent process information.
                    """
                    return PyMenu(self.service, "/results/report/system/proc_stats").execute(*args, **kwargs)
                def sys_stats(self, *args, **kwargs):
                    """
                    System information.
                    """
                    return PyMenu(self.service, "/results/report/system/sys_stats").execute(*args, **kwargs)
                def gpgpu_stats(self, *args, **kwargs):
                    """
                    GPGPU information.
                    """
                    return PyMenu(self.service, "/results/report/system/gpgpu_stats").execute(*args, **kwargs)
                def time_stats(self, *args, **kwargs):
                    """
                    Time usage information.
                    """
                    return PyMenu(self.service, "/results/report/system/time_stats").execute(*args, **kwargs)

            class modified_setting(TUIMenu):
                """
                Enter the menu for setting up the Modified Settings Summary table.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def modified_setting(self, *args, **kwargs):
                    """
                    Specify which settings will be checked for non-default status for generating the Modified Settings Summary table.
                    """
                    return PyMenu(self.service, "/results/report/modified_setting/modified_setting").execute(*args, **kwargs)
                def write_user_setting(self, *args, **kwargs):
                    """
                    Write the contents of the Modified Settings Summary table to a file.
                    """
                    return PyMenu(self.service, "/results/report/modified_setting/write_user_setting").execute(*args, **kwargs)

            class reference_values(TUIMenu):
                """
                Reference value menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.compute = self.__class__.compute(path + ["compute"], service)
                    super().__init__(path, service)
                def area(self, *args, **kwargs):
                    """
                    Set reference area for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/area").execute(*args, **kwargs)
                def temperature(self, *args, **kwargs):
                    """
                    Set reference temperature for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/temperature").execute(*args, **kwargs)
                def velocity(self, *args, **kwargs):
                    """
                    Set reference velocity for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/velocity").execute(*args, **kwargs)
                def density(self, *args, **kwargs):
                    """
                    Set reference density for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/density").execute(*args, **kwargs)
                def length(self, *args, **kwargs):
                    """
                    Set reference length for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/length").execute(*args, **kwargs)
                def viscosity(self, *args, **kwargs):
                    """
                    Set reference viscosity for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/viscosity").execute(*args, **kwargs)
                def enthalpy(self, *args, **kwargs):
                    """
                    Set reference enthalpy for enthalpy damping and normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/enthalpy").execute(*args, **kwargs)
                def depth(self, *args, **kwargs):
                    """
                    Set reference depth for volume calculation.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/depth").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List current reference values.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/list").execute(*args, **kwargs)
                def yplus(self, *args, **kwargs):
                    """
                    Set reference yplus for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/yplus").execute(*args, **kwargs)
                def pressure(self, *args, **kwargs):
                    """
                    Set reference pressure for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/pressure").execute(*args, **kwargs)
                def zone(self, *args, **kwargs):
                    """
                    Set reference zone.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/zone").execute(*args, **kwargs)

                class compute(TUIMenu):
                    """
                    Enter the compute menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def radiator(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/radiator").execute(*args, **kwargs)
                    def inlet_vent(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                    def network_end(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/network_end").execute(*args, **kwargs)
                    def exhaust_fan(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/exhaust_fan").execute(*args, **kwargs)
                    def wall(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/wall").execute(*args, **kwargs)
                    def pressure_outlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                    def recirculation_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                    def rans_les_interface(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                    def dummy_entry(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/dummy_entry").execute(*args, **kwargs)
                    def symmetry(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/symmetry").execute(*args, **kwargs)
                    def network(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/network").execute(*args, **kwargs)
                    def velocity_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/velocity_inlet").execute(*args, **kwargs)
                    def periodic(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/periodic").execute(*args, **kwargs)
                    def axis(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/axis").execute(*args, **kwargs)
                    def solid(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/solid").execute(*args, **kwargs)
                    def pressure_far_field(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                    def fluid(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/fluid").execute(*args, **kwargs)
                    def outlet_vent(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                    def recirculation_outlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)
                    def geometry(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/geometry").execute(*args, **kwargs)
                    def pressure_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                    def mass_flow_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)
                    def degassing(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/degassing").execute(*args, **kwargs)
                    def porous_jump(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/porous_jump").execute(*args, **kwargs)
                    def overset(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/overset").execute(*args, **kwargs)
                    def outflow(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/outflow").execute(*args, **kwargs)
                    def shadow(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/shadow").execute(*args, **kwargs)
                    def interface(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/interface").execute(*args, **kwargs)
                    def mass_flow_outlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)
                    def intake_fan(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/intake_fan").execute(*args, **kwargs)
                    def fan(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/fan").execute(*args, **kwargs)
                    def interior(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/interior").execute(*args, **kwargs)

            class heat_exchanger(TUIMenu):
                """
                Enter the heat exchanger menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def computed_heat_rejection(self, *args, **kwargs):
                    """
                    Print total heat rejection.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/computed_heat_rejection").execute(*args, **kwargs)
                def outlet_temperature(self, *args, **kwargs):
                    """
                    Print outlet temperature.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/outlet_temperature").execute(*args, **kwargs)
                def inlet_temperature(self, *args, **kwargs):
                    """
                    Print inlet temperature.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/inlet_temperature").execute(*args, **kwargs)
                def mass_flow_rate(self, *args, **kwargs):
                    """
                    Print mass flow rate.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/mass_flow_rate").execute(*args, **kwargs)
                def specific_heat(self, *args, **kwargs):
                    """
                    Print fluid's specific heat.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/specific_heat").execute(*args, **kwargs)

            class forces(TUIMenu):
                """
                Force report menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def wall_forces(self, *args, **kwargs):
                    """
                    Print integrated pressure and viscous forces on wall zones.
                    """
                    return PyMenu(self.service, "/results/report/forces/wall_forces").execute(*args, **kwargs)
                def pressure_center(self, *args, **kwargs):
                    """
                    Print center of pressure on wall zones.
                    """
                    return PyMenu(self.service, "/results/report/forces/pressure_center").execute(*args, **kwargs)
                def wall_moments(self, *args, **kwargs):
                    """
                    Print integrated pressure and viscous moments on wall zones.
                    """
                    return PyMenu(self.service, "/results/report/forces/wall_moments").execute(*args, **kwargs)

            class dpm_histogram(TUIMenu):
                """
                Enter the DPM histogram menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.setup_reduction = self.__class__.setup_reduction(path + ["setup_reduction"], service)
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def pick_sample_to_reduce(self, *args, **kwargs):
                    """
                    Pick a sample for which to first set-up and then perform the data reduction.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/pick_sample_to_reduce").execute(*args, **kwargs)
                def write_sample(self, *args, **kwargs):
                    """
                    Write a histogram of a loaded sample into a file.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/write_sample").execute(*args, **kwargs)
                def compute_sample(self, *args, **kwargs):
                    """
                    Compute minimum/maximum of a sample variable.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/compute_sample").execute(*args, **kwargs)
                def list_samples(self, *args, **kwargs):
                    """
                    Show all samples in loaded sample list.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/list_samples").execute(*args, **kwargs)
                def read_sample(self, *args, **kwargs):
                    """
                    Read a sample file and add it to the sample list.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/read_sample").execute(*args, **kwargs)
                def plot_sample(self, *args, **kwargs):
                    """
                    Plot a histogram of a loaded sample.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/plot_sample").execute(*args, **kwargs)
                def reduce_picked_sample(self, *args, **kwargs):
                    """
                    Reduce a sample after first picking it and setting up all data-reduction options and parameters.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/reduce_picked_sample").execute(*args, **kwargs)
                def delete_sample(self, *args, **kwargs):
                    """
                    Delete a sample from loaded sample list.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/delete_sample").execute(*args, **kwargs)

                class setup_reduction(TUIMenu):
                    """
                    Set up the sample data reduction by specifying all relevant options and setting parameters as desired.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def all_variables_number_of_bins(self, *args, **kwargs):
                        """
                        Set the number of bins to be used for ALL variables in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/all_variables_number_of_bins").execute(*args, **kwargs)
                    def logarithmic(self, *args, **kwargs):
                        """
                        Switch on or off logarithmic scaling to be used for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/logarithmic").execute(*args, **kwargs)
                    def maximum(self, *args, **kwargs):
                        """
                        Set the maximum value of the range to be considered for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/maximum").execute(*args, **kwargs)
                    def weighting_variable(self, *args, **kwargs):
                        """
                        Choose the weighting variable for the averaging in each bin in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/weighting_variable").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Set the minimum value of the range to be considered for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/minimum").execute(*args, **kwargs)
                    def list_settings(self, *args, **kwargs):
                        """
                        List all user inputs for the sample picked for data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/list_settings").execute(*args, **kwargs)
                    def reset_min_and_max(self, *args, **kwargs):
                        """
                        Reset the min and max values of the range to be considered for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/reset_min_and_max").execute(*args, **kwargs)
                    def make_steady_from_unsteady_file(self, *args, **kwargs):
                        """
                        Specify whether the unsteady sample is to be reduced into a steady-state injection file.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/make_steady_from_unsteady_file").execute(*args, **kwargs)
                    def number_of_bins(self, *args, **kwargs):
                        """
                        Set the number of bins to be used for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/number_of_bins").execute(*args, **kwargs)
                    def use_weighting(self, *args, **kwargs):
                        """
                        Specify whether to use any weighting in the averaging that is done in each bin in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/use_weighting").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enter the settings menu for the histogram.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def logarithmic(self, *args, **kwargs):
                        """
                        Use logarithmic scaling on the abscissa (variable axis)? -- Will not work unless all values are positive.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/logarithmic").execute(*args, **kwargs)
                    def weighting(self, *args, **kwargs):
                        """
                        Use weighting with additional variable when sorting data into samples.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/weighting").execute(*args, **kwargs)
                    def histogram_mode(self, *args, **kwargs):
                        """
                        Use bars for histogram plot or xy-style.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/histogram_mode").execute(*args, **kwargs)
                    def variable_power_3(self, *args, **kwargs):
                        """
                        Use the cubic of the cumulation variable during computation of the cumulative curve.
                        When the particle mass was not sampled, the diameter can be used instead.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/variable_power_3").execute(*args, **kwargs)
                    def cumulation_curve(self, *args, **kwargs):
                        """
                        Compute a cumulative curve for sampling variable or correlation variable when correlation? was specified.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/cumulation_curve").execute(*args, **kwargs)
                    def percentage(self, *args, **kwargs):
                        """
                        Use percentages of bins to be computed.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/percentage").execute(*args, **kwargs)
                    def correlation(self, *args, **kwargs):
                        """
                        Compute correlation of sampling variable with other variable.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/correlation").execute(*args, **kwargs)
                    def diameter_statistics(self, *args, **kwargs):
                        """
                        Compute Rosin Rammler parameters, Sauter and other mean diameters.
                        Requires specification of diameter as sampling variable.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/diameter_statistics").execute(*args, **kwargs)
                    def maximum(self, *args, **kwargs):
                        """
                        Specify maximum value of x-axis variable for histogram plots.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/maximum").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Specify mimimum value of x-axis variable for histogram plots.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/minimum").execute(*args, **kwargs)
                    def auto_range(self, *args, **kwargs):
                        """
                        Automatically compute range of sampling variable for histogram plots.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/auto_range").execute(*args, **kwargs)
                    def number_of_bins(self, *args, **kwargs):
                        """
                        Specify the number of bins.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/number_of_bins").execute(*args, **kwargs)

            class simulation_reports(TUIMenu):
                """
                Enter the simulation reports menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
                    super().__init__(path, service)
                def read_simulation_report_template_file(self, *args, **kwargs):
                    """
                    Read a JSON template file with existing Simulation Report settings.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
                def export_simulation_report_as_html(self, *args, **kwargs):
                    """
                    Export the provided simulation report as HTML.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
                def write_report_names_to_file(self, *args, **kwargs):
                    """
                    Write the list of currently generated report names to a txt file.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
                def list_simulation_reports(self, *args, **kwargs):
                    """
                    List all report names.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
                def export_simulation_report_as_pdf(self, *args, **kwargs):
                    """
                    Export the provided simulation report as a PDF file.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
                def write_simulation_report_template_file(self, *args, **kwargs):
                    """
                    Write a JSON template file with this case's Simulation Report settings.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
                def rename_simulation_report(self, *args, **kwargs):
                    """
                    Rename a report which has already been generated.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
                def duplicate_simulation_report(self, *args, **kwargs):
                    """
                    Duplicate a report and all of its settings to a new report.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)
                def view_simulation_report(self, *args, **kwargs):
                    """
                    View a simulation report that has already been generated. In batch mode this will print the report's URL.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/view_simulation_report").execute(*args, **kwargs)
                def reset_report_to_defaults(self, *args, **kwargs):
                    """
                    Reset all report settings to default for the provided simulation report.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
                def generate_simulation_report(self, *args, **kwargs):
                    """
                    Generate a new simulation report or regenerate an existing simulation report with the provided name.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
                def delete_simulation_report(self, *args, **kwargs):
                    """
                    Delete the provided simulation report.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/delete_simulation_report").execute(*args, **kwargs)

                class parametric_study(TUIMenu):
                    """
                    Enter the parametric study menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def generate_design_point_report(self, *args, **kwargs):
                        """
                        Generate a simulation report for an updated design point.
                        """
                        return PyMenu(self.service, "/results/report/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)
                    def generate_parametric_report(self, *args, **kwargs):
                        """
                        Generate a parametric report for your study.
                        """
                        return PyMenu(self.service, "/results/report/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)

            class population_balance(TUIMenu):
                """
                Population Balance menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def moments(self, *args, **kwargs):
                    """
                    Set moments for population balance.
                    """
                    return PyMenu(self.service, "/results/report/population_balance/moments").execute(*args, **kwargs)
                def number_density(self, *args, **kwargs):
                    """
                    Set number density functions.
                    """
                    return PyMenu(self.service, "/results/report/population_balance/number_density").execute(*args, **kwargs)

        class graphics(TUIMenu):
            """
            Enter graphics menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.objects = self.__class__.objects(path + ["objects"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                self.lights = self.__class__.lights(path + ["lights"], service)
                self.update_scene = self.__class__.update_scene(path + ["update_scene"], service)
                self.rendering_options = self.__class__.rendering_options(path + ["rendering_options"], service)
                super().__init__(path, service)
            def clear_annotations(self, *args, **kwargs):
                """
                Delete all annotation text.
                """
                return PyMenu(self.service, "/results/graphics/clear_annotations").execute(*args, **kwargs)
            def annotate(self, *args, **kwargs):
                """
                Add a text annotation string to the active graphics window.
                """
                return PyMenu(self.service, "/results/graphics/annotate").execute(*args, **kwargs)
            def hsf_file(self, *args, **kwargs):
                """
                Display hoops stream file data to active graphics window.
                """
                return PyMenu(self.service, "/results/graphics/hsf_file").execute(*args, **kwargs)
            def color_map(self, *args, **kwargs):
                """
                Enter the color-map menu.
                """
                return PyMenu(self.service, "/results/graphics/color_map").execute(*args, **kwargs)

            class objects(TUIMenu):
                """
                Enter to add, edit, delete or display graphics objects.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/edit").execute(*args, **kwargs)
                def add_to_graphics(self, *args, **kwargs):
                    """
                    Add graphics object to existing graphics.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/add_to_graphics").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Display graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/display").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create new graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/create").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copy graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/copy").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/delete").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
                    self.pdf_data = self.__class__.pdf_data(path + ["pdf_data"], service)
                    self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
                    self.flamelet_data = self.__class__.flamelet_data(path + ["flamelet_data"], service)
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def display_custom_vector(self, *args, **kwargs):
                    """
                    Display custom vector.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/display_custom_vector").execute(*args, **kwargs)
                def mesh_outline(self, *args, **kwargs):
                    """
                    Display the mesh boundaries.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/mesh_outline").execute(*args, **kwargs)
                def surface_cells(self, *args, **kwargs):
                    """
                    Draw the cells on the specified surfaces.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/surface_cells").execute(*args, **kwargs)
                def add_custom_vector(self, *args, **kwargs):
                    """
                    Add new custom vector definition.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/add_custom_vector").execute(*args, **kwargs)
                def multigrid_coarsening(self, *args, **kwargs):
                    """
                    Display a coarse mesh level from the last multigrid coarsening.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/multigrid_coarsening").execute(*args, **kwargs)
                def re_scale(self, *args, **kwargs):
                    """
                    Re-render the last contour, profile, or velocity vector plot
                    with updated scale, surfaces, meshes, lights, colormap, rendering options, etc.,
                    without recalculating the field data.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/re_scale").execute(*args, **kwargs)
                def re_render(self, *args, **kwargs):
                    """
                    Re-render the last contour, profile, or velocity vector plot
                    with updated surfaces, meshes, lights, colormap, rendering options, etc.,
                    without recalculating the contour data.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/re_render").execute(*args, **kwargs)
                def vector(self, *args, **kwargs):
                    """
                    Display space vectors.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/vector").execute(*args, **kwargs)
                def mesh(self, *args, **kwargs):
                    """
                    Display the mesh.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/mesh").execute(*args, **kwargs)
                def contour(self, *args, **kwargs):
                    """
                    Display contours of a flow variable.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/contour").execute(*args, **kwargs)
                def zone_mesh(self, *args, **kwargs):
                    """
                    Draw the mesh defined by specified face zones.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/zone_mesh").execute(*args, **kwargs)
                def set_list_tree_separator(self, *args, **kwargs):
                    """
                    Set the separator character for list tree.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/set_list_tree_separator").execute(*args, **kwargs)
                def reacting_channel_curves(self, *args, **kwargs):
                    """
                    Plot/Report the reacting channel variables.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/reacting_channel_curves").execute(*args, **kwargs)
                def mesh_partition_boundary(self, *args, **kwargs):
                    """
                    Display mesh partition boundaries.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/mesh_partition_boundary").execute(*args, **kwargs)
                def profile(self, *args, **kwargs):
                    """
                    Display profiles of a flow variable.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/profile").execute(*args, **kwargs)
                def graphics_window_layout(self, *args, **kwargs):
                    """
                    Arrange the graphics window layout.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/graphics_window_layout").execute(*args, **kwargs)
                def velocity_vector(self, *args, **kwargs):
                    """
                    Display velocity vectors.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/velocity_vector").execute(*args, **kwargs)
                def surface_mesh(self, *args, **kwargs):
                    """
                    Draw the mesh defined by the specified surfaces.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/surface_mesh").execute(*args, **kwargs)

                class particle_tracks(TUIMenu):
                    """
                    Enter the particle tracks menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def plot_write_xy_plot(self, *args, **kwargs):
                        """
                        Plot or write XY plot of particle tracks.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/particle_tracks/plot_write_xy_plot").execute(*args, **kwargs)
                    def particle_tracks(self, *args, **kwargs):
                        """
                        Calculate and display particle tracks from defined injections.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/particle_tracks/particle_tracks").execute(*args, **kwargs)

                class pdf_data(TUIMenu):
                    """
                    Enter the PDF data menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def write_to_file(self, *args, **kwargs):
                        """
                        Enable/disable writing the 1D-slice to file instead of plot.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/write_to_file").execute(*args, **kwargs)
                    def carpet_plot(self, *args, **kwargs):
                        """
                        Enable/disable the display of a carpet plot of a property.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/carpet_plot").execute(*args, **kwargs)
                    def draw_number_box(self, *args, **kwargs):
                        """
                        Enable/disable the display of the numbers box.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/draw_number_box").execute(*args, **kwargs)
                    def plot_1d_slice(self, *args, **kwargs):
                        """
                        Enable/disable a plot of the 1D-slice.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/plot_1d_slice").execute(*args, **kwargs)

                class path_lines(TUIMenu):
                    """
                    Enter the pathlines menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def path_lines(self, *args, **kwargs):
                        """
                        Display pathlines from a surface.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/path_lines/path_lines").execute(*args, **kwargs)
                    def write_to_files(self, *args, **kwargs):
                        """
                        Write Pathlines to a File.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/path_lines/write_to_files").execute(*args, **kwargs)
                    def plot_write_xy_plot(self, *args, **kwargs):
                        """
                        Plot or write XY plot of pathline.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/path_lines/plot_write_xy_plot").execute(*args, **kwargs)

                class flamelet_data(TUIMenu):
                    """
                    Display flamelet data.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def draw_number_box(self, *args, **kwargs):
                        """
                        Enable/disable display of the numbers box.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/draw_number_box").execute(*args, **kwargs)
                    def write_to_file(self, *args, **kwargs):
                        """
                        Enable/disable writing the 1D-slice to file instead of plot.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/write_to_file").execute(*args, **kwargs)
                    def plot_1d_slice(self, *args, **kwargs):
                        """
                        Enable/disable plot of the 1D-slice.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/plot_1d_slice").execute(*args, **kwargs)
                    def carpet_plot(self, *args, **kwargs):
                        """
                        Enable/disable display of carpet plot of a property.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/carpet_plot").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enter the set menu to set display parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
                        self.picture = self.__class__.picture(path + ["picture"], service)
                        self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
                        self.titles = self.__class__.titles(path + ["titles"], service)
                        self.colors = self.__class__.colors(path + ["colors"], service)
                        self.lights = self.__class__.lights(path + ["lights"], service)
                        self.contours = self.__class__.contours(path + ["contours"], service)
                        self.rendering_options = self.__class__.rendering_options(path + ["rendering_options"], service)
                        self.windows = self.__class__.windows(path + ["windows"], service)
                        self.velocity_vectors = self.__class__.velocity_vectors(path + ["velocity_vectors"], service)
                        super().__init__(path, service)
                    def proximity_zones(self, *args, **kwargs):
                        """
                        Set zones to be used for boundary cell distance and boundary proximity.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/proximity_zones").execute(*args, **kwargs)
                    def line_weight(self, *args, **kwargs):
                        """
                        Set the line-weight factor for the window.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/line_weight").execute(*args, **kwargs)
                    def element_shrink(self, *args, **kwargs):
                        """
                        Set percentage to shrink elements.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/element_shrink").execute(*args, **kwargs)
                    def mesh_level(self, *args, **kwargs):
                        """
                        Set coarse mesh level to be drawn.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_level").execute(*args, **kwargs)
                    def mesh_partitions(self, *args, **kwargs):
                        """
                        Enable/disable drawing of the mesh partition boundaries.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_partitions").execute(*args, **kwargs)
                    def n_stream_func(self, *args, **kwargs):
                        """
                        Set the number of iterations used in computing stream function.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/n_stream_func").execute(*args, **kwargs)
                    def marker_symbol(self, *args, **kwargs):
                        """
                        Set the type of markers used to represent points.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/marker_symbol").execute(*args, **kwargs)
                    def reset_graphics(self, *args, **kwargs):
                        """
                        Reset the graphics system.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/reset_graphics").execute(*args, **kwargs)
                    def periodic_instancing(self, *args, **kwargs):
                        """
                        Set periodic instancing.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/periodic_instancing").execute(*args, **kwargs)
                    def duplicate_node_display(self, *args, **kwargs):
                        """
                        Set flag to remove duplicate nodes in mesh display.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/duplicate_node_display").execute(*args, **kwargs)
                    def render_mesh(self, *args, **kwargs):
                        """
                        Enable/disable rendering the mesh on top of contours, vectors, etc.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/render_mesh").execute(*args, **kwargs)
                    def overlays(self, *args, **kwargs):
                        """
                        Enable/disable overlays.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/overlays").execute(*args, **kwargs)
                    def color_map(self, *args, **kwargs):
                        """
                        Enter the color-map menu.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/color_map").execute(*args, **kwargs)
                    def filled_mesh(self, *args, **kwargs):
                        """
                        Enable/disable the filled mesh option.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/filled_mesh").execute(*args, **kwargs)
                    def mesh_display_configuration(self, *args, **kwargs):
                        """
                        Set mesh display configuration.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_display_configuration").execute(*args, **kwargs)
                    def mesh_zones(self, *args, **kwargs):
                        """
                        Set zone IDs to be drawn as mesh.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_zones").execute(*args, **kwargs)
                    def marker_size(self, *args, **kwargs):
                        """
                        Set the size of markers used to represent points.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/marker_size").execute(*args, **kwargs)
                    def nodewt_based_interp(self, *args, **kwargs):
                        """
                        Use more accurate node-weight based interpolation for postprocessing.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/nodewt_based_interp").execute(*args, **kwargs)
                    def mesh_surfaces(self, *args, **kwargs):
                        """
                        Set surface IDs to be drawn as mesh.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_surfaces").execute(*args, **kwargs)
                    def zero_angle_dir(self, *args, **kwargs):
                        """
                        Set the vector having zero angular coordinates.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/zero_angle_dir").execute(*args, **kwargs)
                    def mirror_zones(self, *args, **kwargs):
                        """
                        Set zones to mirror the domain about.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mirror_zones").execute(*args, **kwargs)

                    class path_lines(TUIMenu):
                        """
                        Enter the path-lines menu to set parameters for the display of pathlines.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def arrow_scale(self, *args, **kwargs):
                            """
                            Set the scale factor for arrows drawn on pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/arrow_scale").execute(*args, **kwargs)
                        def reverse(self, *args, **kwargs):
                            """
                            Enable/disable the direction of path tracking.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/reverse").execute(*args, **kwargs)
                        def maximum_steps(self, *args, **kwargs):
                            """
                            Set the maximum number of steps to take for pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/maximum_steps").execute(*args, **kwargs)
                        def arrow_space(self, *args, **kwargs):
                            """
                            Set the spacing factor for arrows drawn on pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/arrow_space").execute(*args, **kwargs)
                        def sphere_attrib(self, *args, **kwargs):
                            """
                            Specify size and no. of slices to be used in drawing sphere for sphere-style.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/sphere_attrib").execute(*args, **kwargs)
                        def step_size(self, *args, **kwargs):
                            """
                            Set the step length between particle positions for path-lines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/step_size").execute(*args, **kwargs)
                        def marker_size(self, *args, **kwargs):
                            """
                            Set the marker size for particle drawing.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/marker_size").execute(*args, **kwargs)
                        def line_width(self, *args, **kwargs):
                            """
                            Set the width for pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/line_width").execute(*args, **kwargs)
                        def twist_factor(self, *args, **kwargs):
                            """
                            Set the scale factor for twisting (ribbons only).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/twist_factor").execute(*args, **kwargs)
                        def relative_pathlines(self, *args, **kwargs):
                            """
                            Enable/disable the tracking of pathlines in a relative coordinate system.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/relative_pathlines").execute(*args, **kwargs)
                        def maximum_error(self, *args, **kwargs):
                            """
                            Set the maximum error allowed while computing the pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/maximum_error").execute(*args, **kwargs)
                        def radius(self, *args, **kwargs):
                            """
                            Set the radius for pathline (ribbons/cylinder only) cross-section.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/radius").execute(*args, **kwargs)
                        def display_steps(self, *args, **kwargs):
                            """
                            Set the display stepping for pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/display_steps").execute(*args, **kwargs)
                        def style(self, *args, **kwargs):
                            """
                            Set display style for pathlines (line/ribbon/cylinder).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/style").execute(*args, **kwargs)
                        def error_control(self, *args, **kwargs):
                            """
                            Set error control during pathline computation.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/error_control").execute(*args, **kwargs)
                        def track_in_phase(self, *args, **kwargs):
                            """
                            Assign phase to display pathlines in.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/track_in_phase").execute(*args, **kwargs)

                    class picture(TUIMenu):
                        """
                        Enter the hardcopy/save-picture options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.driver = self.__class__.driver(path + ["driver"], service)
                            self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                            super().__init__(path, service)
                        def dpi(self, *args, **kwargs):
                            """
                            Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/dpi").execute(*args, **kwargs)
                        def landscape(self, *args, **kwargs):
                            """
                            Plot hardcopies in landscape or portrait orientation.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/landscape").execute(*args, **kwargs)
                        def invert_background(self, *args, **kwargs):
                            """
                            Use a white background when the picture is saved.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/invert_background").execute(*args, **kwargs)
                        def y_resolution(self, *args, **kwargs):
                            """
                            Set the height of raster-formatted images in pixels (0 implies current window size).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/y_resolution").execute(*args, **kwargs)
                        def set_standard_resolution(self, *args, **kwargs):
                            """
                            Select from pre-defined resolution list.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/set_standard_resolution").execute(*args, **kwargs)
                        def x_resolution(self, *args, **kwargs):
                            """
                            Set the width of raster-formatted images in pixels (0 implies current window size).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/x_resolution").execute(*args, **kwargs)
                        def use_window_resolution(self, *args, **kwargs):
                            """
                            Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/use_window_resolution").execute(*args, **kwargs)
                        def jpeg_hardcopy_quality(self, *args, **kwargs):
                            """
                            To set jpeg hardcopy quality.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/jpeg_hardcopy_quality").execute(*args, **kwargs)
                        def preview(self, *args, **kwargs):
                            """
                            Display a preview image of a hardcopy.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/preview").execute(*args, **kwargs)

                        class driver(TUIMenu):
                            """
                            Enter the set hardcopy driver menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.post_format = self.__class__.post_format(path + ["post_format"], service)
                                super().__init__(path, service)
                            def avz(self, *args, **kwargs):
                                """
                                Use AVZ output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/avz").execute(*args, **kwargs)
                            def dump_window(self, *args, **kwargs):
                                """
                                Set the command used to dump the graphics window to a file.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/dump_window").execute(*args, **kwargs)
                            def hsf(self, *args, **kwargs):
                                """
                                Use HSF output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/hsf").execute(*args, **kwargs)
                            def tiff(self, *args, **kwargs):
                                """
                                Use TIFF output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/tiff").execute(*args, **kwargs)
                            def glb(self, *args, **kwargs):
                                """
                                Use GLB output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/glb").execute(*args, **kwargs)
                            def png(self, *args, **kwargs):
                                """
                                Use PNG output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/png").execute(*args, **kwargs)
                            def vrml(self, *args, **kwargs):
                                """
                                Use VRML output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/vrml").execute(*args, **kwargs)
                            def post_script(self, *args, **kwargs):
                                """
                                Produce PostScript output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_script").execute(*args, **kwargs)
                            def options(self, *args, **kwargs):
                                """
                                Set the hardcopy options. Available options are:
                                "no gamma correction", disables gamma correction of colors,
                                "physical size = (width,height)", where width and height
                                are the actual measurements of the printable area of the page
                                in centimeters.
                                "subscreen = (left,right,bottom,top)", where left,right,
                                bottom, and top are numbers in [-1,1] describing a subwindow on
                                the page in which to place the hardcopy.
                                The options may be combined by separating them with commas.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/options").execute(*args, **kwargs)
                            def jpeg(self, *args, **kwargs):
                                """
                                Produce JPEG output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/jpeg").execute(*args, **kwargs)
                            def ppm(self, *args, **kwargs):
                                """
                                Produce PPM output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/ppm").execute(*args, **kwargs)
                            def list(self, *args, **kwargs):
                                """
                                List the current hardcopy driver.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/list").execute(*args, **kwargs)
                            def eps(self, *args, **kwargs):
                                """
                                Produce encapsulated PostScript (EPS) output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/eps").execute(*args, **kwargs)

                            class post_format(TUIMenu):
                                """
                                Enter the PostScript driver format menu.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    super().__init__(path, service)
                                def fast_raster(self, *args, **kwargs):
                                    """
                                    Use the new raster format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/fast_raster").execute(*args, **kwargs)
                                def rle_raster(self, *args, **kwargs):
                                    """
                                    Use the run-length encoded raster format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/rle_raster").execute(*args, **kwargs)
                                def raster(self, *args, **kwargs):
                                    """
                                    Use the original raster format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/raster").execute(*args, **kwargs)
                                def vector(self, *args, **kwargs):
                                    """
                                    Use vector format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/vector").execute(*args, **kwargs)

                        class color_mode(TUIMenu):
                            """
                            Enter the hardcopy color mode menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def mono_chrome(self, *args, **kwargs):
                                """
                                Convert color to monochrome (black and white) for hardcopy.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/mono_chrome").execute(*args, **kwargs)
                            def gray_scale(self, *args, **kwargs):
                                """
                                Convert color to grayscale for hardcopy.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/gray_scale").execute(*args, **kwargs)
                            def list(self, *args, **kwargs):
                                """
                                Display the current hardcopy color mode.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/list").execute(*args, **kwargs)
                            def color(self, *args, **kwargs):
                                """
                                Plot hardcopies in color.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/color").execute(*args, **kwargs)

                    class particle_tracks(TUIMenu):
                        """
                        Enter the particle-tracks menu to set parameters for display of particle tracks.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.vector_settings = self.__class__.vector_settings(path + ["vector_settings"], service)
                            self.filter_settings = self.__class__.filter_settings(path + ["filter_settings"], service)
                            self.sphere_settings = self.__class__.sphere_settings(path + ["sphere_settings"], service)
                            super().__init__(path, service)
                        def radius(self, *args, **kwargs):
                            """
                            Set the radius for particle track (ribbons/cylinder only) cross-section.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/radius").execute(*args, **kwargs)
                        def track_single_particle_stream(self, *args, **kwargs):
                            """
                            Specify the stream ID to be tracked.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/track_single_particle_stream").execute(*args, **kwargs)
                        def arrow_space(self, *args, **kwargs):
                            """
                            Set the spacing factor for arrows drawn on particle tracks.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/arrow_space").execute(*args, **kwargs)
                        def line_width(self, *args, **kwargs):
                            """
                            Set the width for particle track.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/line_width").execute(*args, **kwargs)
                        def coarsen_factor(self, *args, **kwargs):
                            """
                            Set the particle tracks coarsening factor.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/coarsen_factor").execute(*args, **kwargs)
                        def arrow_scale(self, *args, **kwargs):
                            """
                            Set the scale factor for arrows drawn on particle tracks.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/arrow_scale").execute(*args, **kwargs)
                        def history_filename(self, *args, **kwargs):
                            """
                            Specify the name of the particle history file.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/history_filename").execute(*args, **kwargs)
                        def particle_skip(self, *args, **kwargs):
                            """
                            Specify how many particle tracks should be displayed.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/particle_skip").execute(*args, **kwargs)
                        def display(self, *args, **kwargs):
                            """
                            Determine whether particle tracks will be displayed or only tracked.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/display").execute(*args, **kwargs)
                        def sphere_attrib(self, *args, **kwargs):
                            """
                            Specify size and number of slices to be used in drawing spheres.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_attrib").execute(*args, **kwargs)
                        def report_to(self, *args, **kwargs):
                            """
                            Specify the destination for the report (console, file, none).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_to").execute(*args, **kwargs)
                        def report_default_variables(self, *args, **kwargs):
                            """
                            Set the report variables to default.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_default_variables").execute(*args, **kwargs)
                        def style(self, *args, **kwargs):
                            """
                            Set the display style for particle track (line/ribbon/cylinder/sphere).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/style").execute(*args, **kwargs)
                        def report_type(self, *args, **kwargs):
                            """
                            Set the report type for particle tracks.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_type").execute(*args, **kwargs)
                        def twist_factor(self, *args, **kwargs):
                            """
                            Set the scale factor for twisting (ribbons only).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/twist_factor").execute(*args, **kwargs)
                        def marker_size(self, *args, **kwargs):
                            """
                            Set the marker size for particle drawing.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/marker_size").execute(*args, **kwargs)
                        def report_variables(self, *args, **kwargs):
                            """
                            Set the report variables.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_variables").execute(*args, **kwargs)

                        class vector_settings(TUIMenu):
                            """
                            Set vector specific input.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vector_variable(self, *args, **kwargs):
                                """
                                Select a particle vector function to specify vector direction.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/vector_variable").execute(*args, **kwargs)
                            def length_variable(self, *args, **kwargs):
                                """
                                Specify whether the displayed vectors have length varying with another variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/length_variable").execute(*args, **kwargs)
                            def vector_length_variable(self, *args, **kwargs):
                                """
                                Select a particle variable to specify the length of vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/vector_length_variable").execute(*args, **kwargs)
                            def color_variable(self, *args, **kwargs):
                                """
                                Specify whether the vectors should be colored by variable specified in /display/particle-track/particle-track (if false use a constant color).
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/color_variable").execute(*args, **kwargs)
                            def style(self, *args, **kwargs):
                                """
                                Enable and set the display style for particle vectors (none/vector/centered-vector/centered-cylinder).
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/style").execute(*args, **kwargs)
                            def scale_factor(self, *args, **kwargs):
                                """
                                Specify a scale factor to enlarge/reduce the length of vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/scale_factor").execute(*args, **kwargs)
                            def length_to_head_ratio(self, *args, **kwargs):
                                """
                                Specify ratio of length to head for vectors and length to diameter for cylinders.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/length_to_head_ratio").execute(*args, **kwargs)
                            def vector_length(self, *args, **kwargs):
                                """
                                Specify the length of constant vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/vector_length").execute(*args, **kwargs)
                            def constant_color(self, *args, **kwargs):
                                """
                                Specify a constant color for the vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/constant_color").execute(*args, **kwargs)

                        class filter_settings(TUIMenu):
                            """
                            Set filter for particle display.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def maximum(self, *args, **kwargs):
                                """
                                Specify the upper bound for the filter variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/maximum").execute(*args, **kwargs)
                            def inside(self, *args, **kwargs):
                                """
                                Specify whether filter variable needs to be inside min/max to be displayed (else outside min/max).
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/inside").execute(*args, **kwargs)
                            def filter_variable(self, *args, **kwargs):
                                """
                                Select a variable used for filtering of particles.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/filter_variable").execute(*args, **kwargs)
                            def enable_filtering(self, *args, **kwargs):
                                """
                                Specify whether particle display is filtered.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/enable_filtering").execute(*args, **kwargs)
                            def minimum(self, *args, **kwargs):
                                """
                                Specify the lower bound for the filter variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/minimum").execute(*args, **kwargs)

                        class sphere_settings(TUIMenu):
                            """
                            Provide sphere specific input.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def diameter(self, *args, **kwargs):
                                """
                                Diameter of the spheres when vary-diameter? is disabled.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/diameter").execute(*args, **kwargs)
                            def maximum(self, *args, **kwargs):
                                """
                                Set the maximum value of the sphere to be displayed.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/maximum").execute(*args, **kwargs)
                            def vary_diameter(self, *args, **kwargs):
                                """
                                Specify whether the spheres can vary with another variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/vary_diameter").execute(*args, **kwargs)
                            def size_variable(self, *args, **kwargs):
                                """
                                Select a particle variable to size the spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/size_variable").execute(*args, **kwargs)
                            def scale_factor(self, *args, **kwargs):
                                """
                                Specify a scale factor to enlarge/reduce the size of spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/scale_factor").execute(*args, **kwargs)
                            def auto_range(self, *args, **kwargs):
                                """
                                Specify whether displayed spheres should include auto range of variable to size spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/auto_range").execute(*args, **kwargs)
                            def smooth_parameter(self, *args, **kwargs):
                                """
                                Specify number of slices to be used in drawing spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/smooth_parameter").execute(*args, **kwargs)
                            def minimum(self, *args, **kwargs):
                                """
                                Set the minimum value of the sphere to be displayed.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/minimum").execute(*args, **kwargs)

                    class titles(TUIMenu):
                        """
                        Set problem title.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def right_middle(self, *args, **kwargs):
                            """
                            Set the title text for right middle in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/right_middle").execute(*args, **kwargs)
                        def right_bottom(self, *args, **kwargs):
                            """
                            Set the title text for right bottom in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/right_bottom").execute(*args, **kwargs)
                        def left_top(self, *args, **kwargs):
                            """
                            Set the title text for left top in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/left_top").execute(*args, **kwargs)
                        def right_top(self, *args, **kwargs):
                            """
                            Set the title text for right top in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/right_top").execute(*args, **kwargs)
                        def left_bottom(self, *args, **kwargs):
                            """
                            Set the title text for left bottom in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/left_bottom").execute(*args, **kwargs)

                    class colors(TUIMenu):
                        """
                        Enter the color options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.by_type = self.__class__.by_type(path + ["by_type"], service)
                            self.by_surface = self.__class__.by_surface(path + ["by_surface"], service)
                            super().__init__(path, service)
                        def outlet_faces(self, *args, **kwargs):
                            """
                            Set the color of outlet faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/outlet_faces").execute(*args, **kwargs)
                        def background(self, *args, **kwargs):
                            """
                            Set the background (window) color.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/background").execute(*args, **kwargs)
                        def foreground(self, *args, **kwargs):
                            """
                            Set the foreground (text and window frame) color.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/foreground").execute(*args, **kwargs)
                        def user_color(self, *args, **kwargs):
                            """
                            Explicitly set color of display zone.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/user_color").execute(*args, **kwargs)
                        def reset_colors(self, *args, **kwargs):
                            """
                            Reset individual mesh surface colors to the defaults.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/reset_colors").execute(*args, **kwargs)
                        def free_surface_faces(self, *args, **kwargs):
                            """
                            Set the color of free-surface faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/free_surface_faces").execute(*args, **kwargs)
                        def rans_les_interface_faces(self, *args, **kwargs):
                            """
                            Set the color of RANS/LES interface faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/rans_les_interface_faces").execute(*args, **kwargs)
                        def interface_faces(self, *args, **kwargs):
                            """
                            Set the color of mesh Interfaces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/interface_faces").execute(*args, **kwargs)
                        def overset_faces(self, *args, **kwargs):
                            """
                            Set the color of overset faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/overset_faces").execute(*args, **kwargs)
                        def wall_faces(self, *args, **kwargs):
                            """
                            Set the color of wall faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/wall_faces").execute(*args, **kwargs)
                        def skip_label(self, *args, **kwargs):
                            """
                            Set the number of labels to be skipped in the colopmap scale.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/skip_label").execute(*args, **kwargs)
                        def color_by_type(self, *args, **kwargs):
                            """
                            Determine whether to color meshes by type or by surface (ID).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/color_by_type").execute(*args, **kwargs)
                        def axis_faces(self, *args, **kwargs):
                            """
                            Set the color of axisymmetric faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/axis_faces").execute(*args, **kwargs)
                        def reset_user_colors(self, *args, **kwargs):
                            """
                            Reset all user colors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/reset_user_colors").execute(*args, **kwargs)
                        def automatic_skip(self, *args, **kwargs):
                            """
                            Determine whether to skip labels in the colopmap scale automatically.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/automatic_skip").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List available colors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/list").execute(*args, **kwargs)
                        def internal_faces(self, *args, **kwargs):
                            """
                            Set the color of internal interface faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/internal_faces").execute(*args, **kwargs)
                        def surface(self, *args, **kwargs):
                            """
                            Set the color of surfaces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/surface").execute(*args, **kwargs)
                        def traction_faces(self, *args, **kwargs):
                            """
                            Set the color of traction faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/traction_faces").execute(*args, **kwargs)
                        def inlet_faces(self, *args, **kwargs):
                            """
                            Set the color of inlet faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/inlet_faces").execute(*args, **kwargs)
                        def symmetry_faces(self, *args, **kwargs):
                            """
                            Set the color of symmetric faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/symmetry_faces").execute(*args, **kwargs)
                        def graphics_color_theme(self, *args, **kwargs):
                            """
                            Enter the graphics color theme menu.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/graphics_color_theme").execute(*args, **kwargs)
                        def far_field_faces(self, *args, **kwargs):
                            """
                            Set the color of far field faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/far_field_faces").execute(*args, **kwargs)
                        def interior_faces(self, *args, **kwargs):
                            """
                            Set the color of interior faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/interior_faces").execute(*args, **kwargs)
                        def show_user_colors(self, *args, **kwargs):
                            """
                            List currently defined user colors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/show_user_colors").execute(*args, **kwargs)
                        def periodic_faces(self, *args, **kwargs):
                            """
                            Set the color of periodic faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/periodic_faces").execute(*args, **kwargs)

                        class by_type(TUIMenu):
                            """
                            Enter the zone type color and material assignment menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.type_name = self.__class__.type_name(path + ["type_name"], service)
                                super().__init__(path, service)
                            def only_list_case_boundaries(self, *args, **kwargs):
                                """
                                Only list the boundary types that are assigned in this case.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/only_list_case_boundaries").execute(*args, **kwargs)
                            def reset(self, *args, **kwargs):
                                """
                                To reset colors and/or materials to the defaults.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/reset").execute(*args, **kwargs)

                            class type_name(TUIMenu):
                                """
                                Select the boundary type to specify colors and/or materials.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    super().__init__(path, service)
                                def wall(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/wall").execute(*args, **kwargs)
                                def outlet(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/outlet").execute(*args, **kwargs)
                                def surface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/surface").execute(*args, **kwargs)
                                def internal(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/internal").execute(*args, **kwargs)
                                def free_surface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/free_surface").execute(*args, **kwargs)
                                def interior(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/interior").execute(*args, **kwargs)
                                def far_field(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/far_field").execute(*args, **kwargs)
                                def rans_les_interface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/rans_les_interface").execute(*args, **kwargs)
                                def overset(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/overset").execute(*args, **kwargs)
                                def periodic(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/periodic").execute(*args, **kwargs)
                                def interface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/interface").execute(*args, **kwargs)
                                def traction(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/traction").execute(*args, **kwargs)
                                def inlet(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/inlet").execute(*args, **kwargs)
                                def axis(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/axis").execute(*args, **kwargs)
                                def symmetry(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/symmetry").execute(*args, **kwargs)

                        class by_surface(TUIMenu):
                            """
                            Enter the surface(s) color and material assignment menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def list_surfaces_by_color(self, *args, **kwargs):
                                """
                                To list the surfaces by its color.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/list_surfaces_by_color").execute(*args, **kwargs)
                            def list_surfaces_by_material(self, *args, **kwargs):
                                """
                                To list the surfaces by its material.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/list_surfaces_by_material").execute(*args, **kwargs)
                            def surfaces(self, *args, **kwargs):
                                """
                                Select the surface(s) to specify colors and/or materials.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/surfaces").execute(*args, **kwargs)
                            def reset(self, *args, **kwargs):
                                """
                                To reset colors and/or materials to the defaults.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/reset").execute(*args, **kwargs)

                    class lights(TUIMenu):
                        """
                        Enter the lights menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_ambient_color(self, *args, **kwargs):
                            """
                            Set the ambient light color for the scene.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/set_ambient_color").execute(*args, **kwargs)
                        def lights_on(self, *args, **kwargs):
                            """
                            Turn all active lighting on/off.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/lights_on").execute(*args, **kwargs)
                        def lighting_interpolation(self, *args, **kwargs):
                            """
                            Set lighting interpolation method.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/lighting_interpolation").execute(*args, **kwargs)
                        def headlight_on(self, *args, **kwargs):
                            """
                            Turn the light that moves with the camera on or off.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/headlight_on").execute(*args, **kwargs)
                        def set_light(self, *args, **kwargs):
                            """
                            Add or modify a directional, colored light.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/set_light").execute(*args, **kwargs)

                    class contours(TUIMenu):
                        """
                        Enter the contour options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def surfaces(self, *args, **kwargs):
                            """
                            Set surfaces to be contoured.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/surfaces").execute(*args, **kwargs)
                        def global_range(self, *args, **kwargs):
                            """
                            Enable/disable the global range for contours option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/global_range").execute(*args, **kwargs)
                        def render_mesh(self, *args, **kwargs):
                            """
                            Determine whether or not to render the mesh on top of contours, vectors, etc.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/render_mesh").execute(*args, **kwargs)
                        def clip_to_range(self, *args, **kwargs):
                            """
                            Enable/disable the clip to range option for filled contours.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/clip_to_range").execute(*args, **kwargs)
                        def log_scale(self, *args, **kwargs):
                            """
                            Enable/disable the use of a log scale.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/log_scale").execute(*args, **kwargs)
                        def coloring(self, *args, **kwargs):
                            """
                            Select coloring option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/coloring").execute(*args, **kwargs)
                        def n_contour(self, *args, **kwargs):
                            """
                            Set the number of contour levels.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/n_contour").execute(*args, **kwargs)
                        def line_contours(self, *args, **kwargs):
                            """
                            Enable/disable the filled contour option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/line_contours").execute(*args, **kwargs)
                        def auto_range(self, *args, **kwargs):
                            """
                            Enable/disable auto-computation of range for contours.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/auto_range").execute(*args, **kwargs)
                        def filled_contours(self, *args, **kwargs):
                            """
                            Enable/disable the filled contour option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/filled_contours").execute(*args, **kwargs)
                        def node_values(self, *args, **kwargs):
                            """
                            Enable/disable the plot of node values.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/node_values").execute(*args, **kwargs)

                    class rendering_options(TUIMenu):
                        """
                        Enter the rendering options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def outer_face_cull(self, *args, **kwargs):
                            """
                            Enable/disable discarding outer faces during display.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/outer_face_cull").execute(*args, **kwargs)
                        def face_displacement(self, *args, **kwargs):
                            """
                            Set face displacement value in Z-buffer units along the Camera Z-axis.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/face_displacement").execute(*args, **kwargs)
                        def hidden_surface_method(self, *args, **kwargs):
                            """
                            Specify the method to perform hidden line and hidden surface rendering.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/hidden_surface_method").execute(*args, **kwargs)
                        def hidden_surfaces(self, *args, **kwargs):
                            """
                            Enable/disable hidden surface removal.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/hidden_surfaces").execute(*args, **kwargs)
                        def color_map_alignment(self, *args, **kwargs):
                            """
                            Set the color bar alignment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/color_map_alignment").execute(*args, **kwargs)
                        def driver(self, *args, **kwargs):
                            """
                            Change the current graphics driver.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/driver").execute(*args, **kwargs)
                        def show_colormap(self, *args, **kwargs):
                            """
                            Enable/Disable colormap.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/show_colormap").execute(*args, **kwargs)
                        def animation_option(self, *args, **kwargs):
                            """
                            Using Wireframe / All option during animation.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/animation_option").execute(*args, **kwargs)
                        def device_info(self, *args, **kwargs):
                            """
                            List information for the graphics device.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/device_info").execute(*args, **kwargs)
                        def double_buffering(self, *args, **kwargs):
                            """
                            Enable/disable double-buffering.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/double_buffering").execute(*args, **kwargs)
                        def help_text_color(self, *args, **kwargs):
                            """
                            Set the color of screen help text.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/help_text_color").execute(*args, **kwargs)
                        def set_rendering_options(self, *args, **kwargs):
                            """
                            Set the rendering options.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/set_rendering_options").execute(*args, **kwargs)
                        def surface_edge_visibility(self, *args, **kwargs):
                            """
                            Set edge visibility flags for surfaces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/surface_edge_visibility").execute(*args, **kwargs)
                        def auto_spin(self, *args, **kwargs):
                            """
                            Enable/disable mouse view rotations to continue to spin the display after the button is released.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/auto_spin").execute(*args, **kwargs)

                    class windows(TUIMenu):
                        """
                        Enter the window options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.axes = self.__class__.axes(path + ["axes"], service)
                            self.xy = self.__class__.xy(path + ["xy"], service)
                            self.video = self.__class__.video(path + ["video"], service)
                            self.main = self.__class__.main(path + ["main"], service)
                            self.text = self.__class__.text(path + ["text"], service)
                            self.scale = self.__class__.scale(path + ["scale"], service)
                            super().__init__(path, service)
                        def logo(self, *args, **kwargs):
                            """
                            Enable/disable visibility of the logo in graphics window.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/logo").execute(*args, **kwargs)
                        def ruler(self, *args, **kwargs):
                            """
                            Enable/disable ruler visibility.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/ruler").execute(*args, **kwargs)
                        def logo_color(self, *args, **kwargs):
                            """
                            Set logo color to white/black.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/logo_color").execute(*args, **kwargs)
                        def aspect_ratio(self, *args, **kwargs):
                            """
                            Set the aspect ratio of the active window.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/aspect_ratio").execute(*args, **kwargs)

                        class axes(TUIMenu):
                            """
                            Enter the axes window options menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def clear(self, *args, **kwargs):
                                """
                                Set the transparency of the axes window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/clear").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                Enable/disable drawing of a border around the axes window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/border").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                Enable/disable axes visibility.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/visible").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                Set the bottom boundary of the axes window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/bottom").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                Set the right boundary of the axes window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/right").execute(*args, **kwargs)

                        class xy(TUIMenu):
                            """
                            Enter the X-Y plot window options menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def visible(self, *args, **kwargs):
                                """
                                Enable/disable X-Y plotter window visibility.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/visible").execute(*args, **kwargs)
                            def top(self, *args, **kwargs):
                                """
                                Set the top boundary of the X-Y plotter window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/top").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                Enable/disable drawing of a border around the X-Y plotter window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/border").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                Set the right boundary of the X-Y plotter window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/right").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                Set the left boundary of the X-Y plotter window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/left").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                Set the bottom boundary of the X-Y plotter window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/bottom").execute(*args, **kwargs)

                        class video(TUIMenu):
                            """
                            Enter the video window options menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def color_filter(self, *args, **kwargs):
                                """
                                Set the color filter options for the picture.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/color_filter").execute(*args, **kwargs)
                            def on(self, *args, **kwargs):
                                """
                                Enable/disable video picture settings.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/on").execute(*args, **kwargs)
                            def pixel_size(self, *args, **kwargs):
                                """
                                Set the window size in pixels.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/pixel_size").execute(*args, **kwargs)
                            def background(self, *args, **kwargs):
                                """
                                Set the background color in the video picture.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/background").execute(*args, **kwargs)
                            def foreground(self, *args, **kwargs):
                                """
                                Set the foreground color in the video picture.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/foreground").execute(*args, **kwargs)

                        class main(TUIMenu):
                            """
                            Enter the main view window options menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def right(self, *args, **kwargs):
                                """
                                Set the right boundary of the main viewing window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/right").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                Set the bottom boundary of the main viewing window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/bottom").execute(*args, **kwargs)
                            def top(self, *args, **kwargs):
                                """
                                Set the top boundary of the main viewing window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/top").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                Set the left boundary of the main viewing window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/left").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                Enable/disable drawing of borders around the main viewing window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/border").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                Enable/disable visibility of the main viewing window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/visible").execute(*args, **kwargs)

                        class text(TUIMenu):
                            """
                            Enter the text window options menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def right(self, *args, **kwargs):
                                """
                                Set the right boundary of the text window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/right").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                Enable/disable text window transparency.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/visible").execute(*args, **kwargs)
                            def application(self, *args, **kwargs):
                                """
                                Enable/disable the application name in the picture.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/application").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                Set the left boundary of the text window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/left").execute(*args, **kwargs)
                            def top(self, *args, **kwargs):
                                """
                                Set the top boundary of the text window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/top").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                Enable/disable drawing of borders around the text window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/border").execute(*args, **kwargs)
                            def clear(self, *args, **kwargs):
                                """
                                Enable/disable text window transparency.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/clear").execute(*args, **kwargs)
                            def company(self, *args, **kwargs):
                                """
                                Enable/disable the company name in the picture.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/company").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                Set the bottom boundary of the text window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/bottom").execute(*args, **kwargs)
                            def date(self, *args, **kwargs):
                                """
                                Enable/disable the date in the picture.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/date").execute(*args, **kwargs)

                        class scale(TUIMenu):
                            """
                            Enter the color scale window options menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def left(self, *args, **kwargs):
                                """
                                Set the left boundary of the color scale window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/left").execute(*args, **kwargs)
                            def clear(self, *args, **kwargs):
                                """
                                Set the transparency of the scale window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/clear").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                Set the bottom boundary of the color scale window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/bottom").execute(*args, **kwargs)
                            def font_size(self, *args, **kwargs):
                                """
                                Set the font size of the color scale window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/font_size").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                Enable/disable visibility of the color scale window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/visible").execute(*args, **kwargs)
                            def alignment(self, *args, **kwargs):
                                """
                                Set colormap to bottom/left/top/right.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/alignment").execute(*args, **kwargs)
                            def margin(self, *args, **kwargs):
                                """
                                Set the margin of the color scale window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/margin").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                Set the right boundary of the color scale window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/right").execute(*args, **kwargs)
                            def top(self, *args, **kwargs):
                                """
                                Set the top boundary of the color scale window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/top").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                Enable/disable drawing of borders around the color scale window.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/border").execute(*args, **kwargs)
                            def format(self, *args, **kwargs):
                                """
                                Set the number format of the color scale window (e.g. %0.2e).
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/format").execute(*args, **kwargs)

                    class velocity_vectors(TUIMenu):
                        """
                        Enter the menu to set parameters for display of velocity vectors.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def in_plane(self, *args, **kwargs):
                            """
                            Toggle the display of in-plane velocity vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/in_plane").execute(*args, **kwargs)
                        def component_y(self, *args, **kwargs):
                            """
                            Enable/disable use of y-component of vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/component_y").execute(*args, **kwargs)
                        def global_range(self, *args, **kwargs):
                            """
                            Enable/disable the global range for vectors option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/global_range").execute(*args, **kwargs)
                        def color_levels(self, *args, **kwargs):
                            """
                            Set the number of colors used from the color map.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/color_levels").execute(*args, **kwargs)
                        def auto_scale(self, *args, **kwargs):
                            """
                            Enable/disable auto-scale of all vectors so that vector overlap is minimal.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/auto_scale").execute(*args, **kwargs)
                        def relative(self, *args, **kwargs):
                            """
                            Enable/disable the display of relative velocity vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/relative").execute(*args, **kwargs)
                        def constant_length(self, *args, **kwargs):
                            """
                            Enable/disable setting all vectors to have the same length.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/constant_length").execute(*args, **kwargs)
                        def style(self, *args, **kwargs):
                            """
                            Set the style with which the vectors will be drawn.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/style").execute(*args, **kwargs)
                        def scale(self, *args, **kwargs):
                            """
                            Set the value by which the vector length will be scaled.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/scale").execute(*args, **kwargs)
                        def scale_head(self, *args, **kwargs):
                            """
                            Set the value by which the vector head will be scaled.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/scale_head").execute(*args, **kwargs)
                        def node_values(self, *args, **kwargs):
                            """
                            Enable/disable plotting node values. Cell values will be plotted if "no".
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/node_values").execute(*args, **kwargs)
                        def component_x(self, *args, **kwargs):
                            """
                            Enable/disable use of x-component of vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/component_x").execute(*args, **kwargs)
                        def color(self, *args, **kwargs):
                            """
                            Set the color used for all vectors. Set color to the null string to use the color map.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/color").execute(*args, **kwargs)
                        def render_mesh(self, *args, **kwargs):
                            """
                            Enable/disable rendering the mseh on top of contours, vectors, etc.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/render_mesh").execute(*args, **kwargs)
                        def surfaces(self, *args, **kwargs):
                            """
                            Set surfaces on which vectors are drawn.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/surfaces").execute(*args, **kwargs)
                        def component_z(self, *args, **kwargs):
                            """
                            Enable/disable use of z-component of vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/component_z").execute(*args, **kwargs)
                        def log_scale(self, *args, **kwargs):
                            """
                            Enable/disable the use of a log scale.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/log_scale").execute(*args, **kwargs)

            class lights(TUIMenu):
                """
                Enter the lights menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def headlight_on(self, *args, **kwargs):
                    """
                    Turn the light that moves with the camera on or off.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/headlight_on").execute(*args, **kwargs)
                def lighting_interpolation(self, *args, **kwargs):
                    """
                    Set lighting interpolation method.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/lighting_interpolation").execute(*args, **kwargs)
                def set_light(self, *args, **kwargs):
                    """
                    Add or modify a directional, colored light.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/set_light").execute(*args, **kwargs)
                def set_ambient_color(self, *args, **kwargs):
                    """
                    Set the ambient light color for the scene.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/set_ambient_color").execute(*args, **kwargs)
                def lights_on(self, *args, **kwargs):
                    """
                    Turn all active lighting on/off.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/lights_on").execute(*args, **kwargs)

            class update_scene(TUIMenu):
                """
                Enter the scene options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def display(self, *args, **kwargs):
                    """
                    Display selected geometries.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/display").execute(*args, **kwargs)
                def pathline(self, *args, **kwargs):
                    """
                    Change pathline attributes.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/pathline").execute(*args, **kwargs)
                def draw_frame(self, *args, **kwargs):
                    """
                    Enable/disable drawing of the bounding frame.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/draw_frame").execute(*args, **kwargs)
                def overlays(self, *args, **kwargs):
                    """
                    Enable/disable the overlays option.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/overlays").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete selected geometries.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/delete").execute(*args, **kwargs)
                def transform(self, *args, **kwargs):
                    """
                    Apply transformation matrix on selected geometries.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/transform").execute(*args, **kwargs)
                def time(self, *args, **kwargs):
                    """
                    Change time-step value.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/time").execute(*args, **kwargs)
                def iso_sweep(self, *args, **kwargs):
                    """
                    Change iso-sweep values.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/iso_sweep").execute(*args, **kwargs)
                def set_frame(self, *args, **kwargs):
                    """
                    Change frame options.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/set_frame").execute(*args, **kwargs)
                def select_geometry(self, *args, **kwargs):
                    """
                    Select geometry to be updated.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/select_geometry").execute(*args, **kwargs)

            class rendering_options(TUIMenu):
                """
                Enter the rendering options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def outer_face_cull(self, *args, **kwargs):
                    """
                    Enable/disable discarding outer faces during display.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/outer_face_cull").execute(*args, **kwargs)
                def driver(self, *args, **kwargs):
                    """
                    Change the current graphics driver.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/driver").execute(*args, **kwargs)
                def hidden_surface_method(self, *args, **kwargs):
                    """
                    Specify the method to perform hidden line and hidden surface rendering.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/hidden_surface_method").execute(*args, **kwargs)
                def set_rendering_options(self, *args, **kwargs):
                    """
                    Set the rendering options.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/set_rendering_options").execute(*args, **kwargs)
                def double_buffering(self, *args, **kwargs):
                    """
                    Enable/disable double-buffering.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/double_buffering").execute(*args, **kwargs)
                def show_colormap(self, *args, **kwargs):
                    """
                    Enable/Disable colormap.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/show_colormap").execute(*args, **kwargs)
                def device_info(self, *args, **kwargs):
                    """
                    List information for the graphics device.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/device_info").execute(*args, **kwargs)
                def hidden_surfaces(self, *args, **kwargs):
                    """
                    Enable/disable hidden surface removal.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/hidden_surfaces").execute(*args, **kwargs)
                def auto_spin(self, *args, **kwargs):
                    """
                    Enable/disable mouse view rotations to continue to spin the display after the button is released.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/auto_spin").execute(*args, **kwargs)
                def face_displacement(self, *args, **kwargs):
                    """
                    Set face displacement value in Z-buffer units along the Camera Z-axis.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/face_displacement").execute(*args, **kwargs)
                def surface_edge_visibility(self, *args, **kwargs):
                    """
                    Set edge visibility flags for surfaces.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/surface_edge_visibility").execute(*args, **kwargs)
                def color_map_alignment(self, *args, **kwargs):
                    """
                    Set the color bar alignment.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/color_map_alignment").execute(*args, **kwargs)
                def help_text_color(self, *args, **kwargs):
                    """
                    Set the color of screen help text.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/help_text_color").execute(*args, **kwargs)
                def animation_option(self, *args, **kwargs):
                    """
                    Using Wireframe / All option during animation.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/animation_option").execute(*args, **kwargs)

        class plot(TUIMenu):
            """
            Enter the XY plot menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
                self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
                self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
                super().__init__(path, service)
            def file(self, *args, **kwargs):
                """
                Plot data from file.
                """
                return PyMenu(self.service, "/results/plot/file").execute(*args, **kwargs)
            def file_set(self, *args, **kwargs):
                """
                Enter the menu to set file plot parameters.
                """
                return PyMenu(self.service, "/results/plot/file_set").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plot solution on surfaces.
                """
                return PyMenu(self.service, "/results/plot/plot").execute(*args, **kwargs)
            def solution_set(self, *args, **kwargs):
                """
                Enter the menu to set solution plot parameters.
                """
                return PyMenu(self.service, "/results/plot/solution_set").execute(*args, **kwargs)
            def residuals(self, *args, **kwargs):
                """
                Plot equation residual history.
                """
                return PyMenu(self.service, "/results/plot/residuals").execute(*args, **kwargs)
            def circum_avg_radial(self, *args, **kwargs):
                """
                Compute iso-radial band surfaces and plot data vs radius on them.
                """
                return PyMenu(self.service, "/results/plot/circum_avg_radial").execute(*args, **kwargs)
            def fft_set(self, *args, **kwargs):
                """
                Enter the menu to set histogram plot parameters.
                """
                return PyMenu(self.service, "/results/plot/fft_set").execute(*args, **kwargs)
            def residuals_set(self, *args, **kwargs):
                """
                Enter the menu to set residual plot parameters.
                """
                return PyMenu(self.service, "/results/plot/residuals_set").execute(*args, **kwargs)
            def display_profile_data(self, *args, **kwargs):
                """
                Plot profile data.
                """
                return PyMenu(self.service, "/results/plot/display_profile_data").execute(*args, **kwargs)
            def change_fft_ref_pressure(self, *args, **kwargs):
                """
                Change acoustic reference pressure.
                """
                return PyMenu(self.service, "/results/plot/change_fft_ref_pressure").execute(*args, **kwargs)
            def circum_avg_axial(self, *args, **kwargs):
                """
                Compute iso-axial band surfaces and plot data vs axial coordinate on them.
                """
                return PyMenu(self.service, "/results/plot/circum_avg_axial").execute(*args, **kwargs)
            def histogram_set(self, *args, **kwargs):
                """
                Enter the menu to set histogram plot parameters.
                """
                return PyMenu(self.service, "/results/plot/histogram_set").execute(*args, **kwargs)
            def solution(self, *args, **kwargs):
                """
                Plot solution on surfaces and/or zones.
                """
                return PyMenu(self.service, "/results/plot/solution").execute(*args, **kwargs)
            def histogram(self, *args, **kwargs):
                """
                Plot a histogram of a specified scalar quantity.
                """
                return PyMenu(self.service, "/results/plot/histogram").execute(*args, **kwargs)
            def file_list(self, *args, **kwargs):
                """
                Plot data from multiple files.
                """
                return PyMenu(self.service, "/results/plot/file_list").execute(*args, **kwargs)
            def label_alignment(self, *args, **kwargs):
                """
                Set the alignment of xy plot label to horizontal or axis aligned.
                """
                return PyMenu(self.service, "/results/plot/label_alignment").execute(*args, **kwargs)
            def plot_direction(self, *args, **kwargs):
                """
                Set plot direction for xy plot.
                """
                return PyMenu(self.service, "/results/plot/plot_direction").execute(*args, **kwargs)
            def fft(self, *args, **kwargs):
                """
                Plot FFT of file data.
                """
                return PyMenu(self.service, "/results/plot/fft").execute(*args, **kwargs)
            def set_boundary_val_off(self, *args, **kwargs):
                """
                Set boundary value off when node values off for XY/Solution Plot.
                Note: This setting is valid for current Fluent session only.
                """
                return PyMenu(self.service, "/results/plot/set_boundary_val_off").execute(*args, **kwargs)
            def datasources(self, *args, **kwargs):
                """
                Enter the menu to set data sources.
                """
                return PyMenu(self.service, "/results/plot/datasources").execute(*args, **kwargs)

            class flamelet_curves(TUIMenu):
                """
                Plot flamelet curves.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def plot_curves(self, *args, **kwargs):
                    """
                    Plot of a property.
                    """
                    return PyMenu(self.service, "/results/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Write curve to a file instead of plot.
                    """
                    return PyMenu(self.service, "/results/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)

            class cumulative_plot(TUIMenu):
                """
                Plot Cumulative Force and Moments.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def plot(self, *args, **kwargs):
                    """
                    Plot the Cumulative Forces/Moments.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/plot").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/curves").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/add").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Write the Cumulative Forces/Moments.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/write").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Print the Cumulative Forces/Moments.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/print").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/list").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/delete").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/axes").execute(*args, **kwargs)

            class ansys_sound_analysis(TUIMenu):
                """
                Ansys Sound analysis and specification.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def print_indicators(self, *args, **kwargs):
                    """
                    Print Ansys Sound indicators.
                    """
                    return PyMenu(self.service, "/results/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)
                def write_files(self, *args, **kwargs):
                    """
                    Write Ansys Sound out files.
                    """
                    return PyMenu(self.service, "/results/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)

        class animate(TUIMenu):
            """
            Enter the animation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.playback = self.__class__.playback(path + ["playback"], service)
                super().__init__(path, service)

            class playback(TUIMenu):
                """
                Enter animation playback menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def set_custom_frames(self, *args, **kwargs):
                    """
                    Set custom frames start, end, skip frames for video export.
                    """
                    return PyMenu(self.service, "/results/animate/playback/set_custom_frames").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete animation sequence.
                    """
                    return PyMenu(self.service, "/results/animate/playback/delete").execute(*args, **kwargs)
                def play(self, *args, **kwargs):
                    """
                    Play the selected animation.
                    """
                    return PyMenu(self.service, "/results/animate/playback/play").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Write animation sequence to the file.
                    """
                    return PyMenu(self.service, "/results/animate/playback/write").execute(*args, **kwargs)
                def read(self, *args, **kwargs):
                    """
                    Read new animation from file or already-defined animations.
                    """
                    return PyMenu(self.service, "/results/animate/playback/read").execute(*args, **kwargs)
                def stored_view(self, *args, **kwargs):
                    """
                    Play the 3D animation sequence using the view stored in the sequence.
                    """
                    return PyMenu(self.service, "/results/animate/playback/stored_view").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Set options for exporting video file menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/height").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/set_standard_resolution").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/quality").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Enable original resolution.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/use_original_resolution").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Exporting video file name.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/name").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Set the Frame Per Sec(FPS) for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/fps").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/width").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Set scale by which video resolution will expand.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/scale").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set format for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/format").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def keyframe(self, *args, **kwargs):
                            """
                            Set video keyframe rate for exporting video file.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/keyframe").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/compression_method").execute(*args, **kwargs)

    class solve(TUIMenu):
        """
        Enter the solve menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.set = self.__class__.set(path + ["set"], service)
            self.animate = self.__class__.animate(path + ["animate"], service)
            self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
            self.report_files = self.__class__.report_files(path + ["report_files"], service)
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            super().__init__(path, service)
        def mesh_motion(self, *args, **kwargs):
            """
            Performs mesh motion.
            """
            return PyMenu(self.service, "/solve/mesh_motion").execute(*args, **kwargs)
        def multistage_time_iterate(self, *args, **kwargs):
            """
            Perform unsteady iterations.
            """
            return PyMenu(self.service, "/solve/multistage_time_iterate").execute(*args, **kwargs)
        def iterate_steady_2way_fsi(self, *args, **kwargs):
            """
            Perform a specified number of steps.
            """
            return PyMenu(self.service, "/solve/iterate_steady_2way_fsi").execute(*args, **kwargs)
        def dpm_update(self, *args, **kwargs):
            """
            Updates discrete phase source terms.
            """
            return PyMenu(self.service, "/solve/dpm_update").execute(*args, **kwargs)
        def dual_time_iterate(self, *args, **kwargs):
            """
            Performs unsteady iterations for a specified number of time steps.
            """
            return PyMenu(self.service, "/solve/dual_time_iterate").execute(*args, **kwargs)
        def convergence_conditions(self, *args, **kwargs):
            """
            Enters the convergence conditions menu.
            """
            return PyMenu(self.service, "/solve/convergence_conditions").execute(*args, **kwargs)
        def patch(self, *args, **kwargs):
            """
            Patches a value for a flow variable in the domain. You can either provide a numerical value, which you can enter directly, or you can enter an expression, which must be entered within quotation marks.
            """
            return PyMenu(self.service, "/solve/patch").execute(*args, **kwargs)
        def iterate(self, *args, **kwargs):
            """
            Performs a specified number of iterations.  This option is still available during transient simulations, since it can be used to add more iterations to the same time step after interrupting iterations within a time step.
            """
            return PyMenu(self.service, "/solve/iterate").execute(*args, **kwargs)
        def update_physical_time(self, *args, **kwargs):
            """
            Advances the unsteady solution to the next physical time level. Using this command in conjunction with theiterate command allows you to manually advance the solution in time (rather than doing it automatically with the dual-time-iterate command).
            """
            return PyMenu(self.service, "/solve/update_physical_time").execute(*args, **kwargs)

        class set(TUIMenu):
            """
            Enters the set solution parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                super().__init__(path, service)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/adaptive_time_stepping").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation_options").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Specifies whether you want to lock (or “freeze”) the temperature values for all the cells in solid zones (including those to which you have a hooked an energy source through a UDF) and in walls that have shell conduction enabled, so that the values do not change during further solver iterations.
                """
                return PyMenu(self.service, "/solve/set/lock_solid_temperature").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Sets gradient options.
                """
                return PyMenu(self.service, "/solve/set/gradient_scheme").execute(*args, **kwargs)
            def expert(self, *args, **kwargs):
                """
                Sets expert options.
                """
                return PyMenu(self.service, "/solve/set/expert").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Sets anisotropic drag parameters for the Eulerian multiphase model.
                """
                return PyMenu(self.service, "/solve/set/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def slope_limiter_set(self, *args, **kwargs):
                """
                Selects a new Fluent solver slope limiter.
                """
                return PyMenu(self.service, "/solve/set/slope_limiter_set").execute(*args, **kwargs)
            def stiff_chemistry(self, *args, **kwargs):
                """
                Sets solver options for stiff chemistry solutions.
                """
                return PyMenu(self.service, "/solve/set/stiff_chemistry").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension_expert").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Sets surface-tension calculation options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Sets damping function in flow direction. This command appears only when the VOF model is enabled. Select the damping function to be used:
                Index
                Damping Function
                0
                Linear
                1
                Quadratic
                2
                Cubic
                3
                Cosine.
                """
                return PyMenu(self.service, "/solve/set/numerical_beach_controls").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enters the under-relaxation menu, which allows you to set the under-relaxation factor for each equation that is being solved in a segregated manner.
                """
                return PyMenu(self.service, "/solve/set/under_relaxation").execute(*args, **kwargs)
            def open_channel_controls(self, *args, **kwargs):
                """
                For flows that do not transition from sub-critical to super-critical, or vice-versa, you can speed-up the solution calculation by updating the frequency of Froude number during run time.
                """
                return PyMenu(self.service, "/solve/set/open_channel_controls").execute(*args, **kwargs)
            def numerics(self, *args, **kwargs):
                """
                Sets numerics options.
                """
                return PyMenu(self.service, "/solve/set/numerics").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solve/set/material_property_warnings").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Sets phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solve/set/phase_based_vof_discretization").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enters the residual tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/residual_tolerance").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solve/set/flux_type").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Enables data sampling for steady or unsteady flow statistics.
                """
                return PyMenu(self.service, "/solve/set/data_sampling").execute(*args, **kwargs)
            def solution_steering(self, *args, **kwargs):
                """
                Enables solution steering for the density-based solver.
                """
                return PyMenu(self.service, "/solve/set/solution_steering").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Sets the sub time step calculation method for VOF calculations.
                """
                return PyMenu(self.service, "/solve/set/vof_explicit_controls").execute(*args, **kwargs)
            def courant_number(self, *args, **kwargs):
                """
                Sets the fine-grid Courant number (time step factor). This command is available only for the coupled solvers.
                """
                return PyMenu(self.service, "/solve/set/courant_number").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Enables / disables the variable time step size formulation for second-order implicit transient formulations. If you disable the variable time step size formulation, note that any change in the time step size will introduce an error proportional to the change in the time step size ratio.
                """
                return PyMenu(self.service, "/solve/set/second_order_time_options").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Sets solution steering parameters.
                """
                return PyMenu(self.service, "/solve/set/set_solution_steering").execute(*args, **kwargs)
            def equation_ordering(self, *args, **kwargs):
                """
                Sets the order in which the model equations are solved, which can affect the convergence speed when you are using the pressure-based solver. The standard method is enabled by default and corresponds to the ordering shown in  and  in the Theory Guide; alternatively, you can select theoptimized-for-volumetric-expansion method, which is recommended for flows in which the density is strongly dependent on thermal effects, chemical composition, and so on (such as combustion simulations). This text command is not available for steady simulations and/or when a multiphase model is enabled.
                """
                return PyMenu(self.service, "/solve/set/equation_ordering").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Sets the reference density method for the Eulerian multiphase model. The following options are available:
                0 (default): Averaged density of the phase
                1: Cell density of the phase
                1: Constant value of 1
                1: Cell density of the phase
                See  for more information.
                """
                return PyMenu(self.service, "/solve/set/mp_reference_density").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enables convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solve/set/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enables a modified NITA scheme and other setting changes that can speed up the simulation. This option is only available with the Large Eddy Simulation (LES) turbulence model, and is intended for unreacting flow simulations that use a constant-density fluid.
                """
                return PyMenu(self.service, "/solve/set/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enters the max-corrections menu.
                """
                return PyMenu(self.service, "/solve/set/max_corrections").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/variable_time_stepping").execute(*args, **kwargs)
            def multi_grid_fas(self, *args, **kwargs):
                """
                Sets the parameters that control the FAS multigrid solver. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_fas").execute(*args, **kwargs)
            def p_v_controls(self, *args, **kwargs):
                """
                Sets pressure-velocity controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when reversed flow occurs at inlets and outlets, and when mass-flow inlets develop supersonic regions. By default, flow warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/flow_warnings").execute(*args, **kwargs)
            def residual_verbosity(self, *args, **kwargs):
                """
                Sets the amount of residual information to be printed. A value of 0 (the default) prints residuals at the end of each fine grid iteration. A value of 1 prints residuals after every stage of the fine grid iteration. A value of 2 prints residuals after every stage on every grid level.
                """
                return PyMenu(self.service, "/solve/set/residual_verbosity").execute(*args, **kwargs)
            def correction_tolerance(self, *args, **kwargs):
                """
                Enters the correction tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/correction_tolerance").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when quantities are being limited. By default, limiter warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/limiter_warnings").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Sets all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solve/set/set_all_species_together").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Sets pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solve/set/bc_pressure_extrapolations").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solve/set/time_step").execute(*args, **kwargs)
            def reactions(self, *args, **kwargs):
                """
                Enables the species reaction sources and sets relaxation factor.
                """
                return PyMenu(self.service, "/solve/set/reactions").execute(*args, **kwargs)
            def p_v_coupling(self, *args, **kwargs):
                """
                Selects which pressure-velocity coupling scheme is to be used. Five schemes are available:.
                """
                return PyMenu(self.service, "/solve/set/p_v_coupling").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Completely disables reconstruction, resulting in totally first-order accuracy.
                """
                return PyMenu(self.service, "/solve/set/disable_reconstruction").execute(*args, **kwargs)
            def equations(self, *args, **kwargs):
                """
                Selects the equations to be solved.
                """
                return PyMenu(self.service, "/solve/set/equations").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Sets controls to default values.
                """
                return PyMenu(self.service, "/solve/set/set_controls_to_default").execute(*args, **kwargs)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enters the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solve/set/relaxation_factor").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Sets solver limits for various solution variables, in order to improve the stability of the solution.
                """
                return PyMenu(self.service, "/solve/set/limits").execute(*args, **kwargs)
            def heterogeneous_stiff_chemistry(self, *args, **kwargs):
                """
                Sets the heterogeneous stiff-chemistry solver.
                """
                return PyMenu(self.service, "/solve/set/heterogeneous_stiff_chemistry").execute(*args, **kwargs)
            def reporting_interval(self, *args, **kwargs):
                """
                Sets the number of iterations for which convergence monitors are reported. The default is 1 (after every iteration).
                """
                return PyMenu(self.service, "/solve/set/reporting_interval").execute(*args, **kwargs)
            def multi_grid_controls(self, *args, **kwargs):
                """
                Sets multigrid parameters and termination criteria.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_controls").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Sets VOF numeric options.
                """
                return PyMenu(self.service, "/solve/set/vof_numerics").execute(*args, **kwargs)
            def moving_mesh_numerics(self, *args, **kwargs):
                """
                Transient options for sliding, moving, and/or dynamic mesh.
                """
                return PyMenu(self.service, "/solve/set/moving_mesh_numerics").execute(*args, **kwargs)
            def multi_stage(self, *args, **kwargs):
                """
                Sets the multi-stage coefficients and the dissipation and viscous evaluation stages. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_stage").execute(*args, **kwargs)
            def multi_grid_amg(self, *args, **kwargs):
                """
                Sets the parameters that govern the algebraic multigrid procedure.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_amg").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enters the discretization scheme menu. This allows you to select the discretization scheme for the convection terms in the solution equations. The following text commands can make a selection from a subset of the models in the following table:.
                """
                return PyMenu(self.service, "/solve/set/discretization_scheme").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Switches between the modified treatment of node-based gradients at boundary cells and the legacy treatment (R14.5.7 and earlier). If using the density-based solver, you can also specify the extended treatment. For details, see .
                """
                return PyMenu(self.service, "/solve/set/nb_gradient_boundary_option").execute(*args, **kwargs)
            def enable_output_dp_dt(self, *args, **kwargs):
                """
                Controls whether the output field variabledp-dt will be available for transient simulation postprocessing. If you select no, pressure fields at the previous time steps will not be stored in memory which reduces memory usage.
                """
                return PyMenu(self.service, "/solve/set/enable_output_dp_dt").execute(*args, **kwargs)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Sets the solution methods to the default settings.
                """
                return PyMenu(self.service, "/solve/set/set_solution_methods_to_default").execute(*args, **kwargs)
            def p_v_controls_advanced(self, *args, **kwargs):
                """
                Set advanced pressure-velocity coupling controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls_advanced").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Sets the number of iterations for a steady-state simulation without starting the calculation.
                """
                return PyMenu(self.service, "/solve/set/number_of_iterations").execute(*args, **kwargs)
            def relaxation_method(self, *args, **kwargs):
                """
                Sets the solver relaxation method.
                """
                return PyMenu(self.service, "/solve/set/relaxation_method").execute(*args, **kwargs)
            def residual_smoothing(self, *args, **kwargs):
                """
                Sets the implicit residual smoothing parameters. This command is available only for the explicit coupled solver.
                """
                return PyMenu(self.service, "/solve/set/residual_smoothing").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enters the NITA expert control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Enables and sets hybrid NITA options. For more details, see .
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Setting this to 1, enables the verbosity for NITA diagnostics. The default value of 0 disables verbosity output for NITA diagnostics.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/set_verbosity").execute(*args, **kwargs)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Enables/disables coupling of the neighbor and skewness corrections.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Specifies overset meshing solver options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Selects the interpolation method for overset interfaces. Note that the least squares method is recommended for sliding mesh cases.
                    """
                    return PyMenu(self.service, "/solve/set/overset/interpolation_method").execute(*args, **kwargs)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enables/disables a numerical treatment that attempts to assign reasonable data values to orphan cells.
                    """
                    return PyMenu(self.service, "/solve/set/overset/orphan_cell_treatment").execute(*args, **kwargs)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    Uses the pressure gradient of the donor cell in the interpolation of pressure for its receptor cell.
                    """
                    return PyMenu(self.service, "/solve/set/overset/high_order_pressure").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Sets buffer layer height, verbosity, and open channel wave theory formulation.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Specifies which open channel wave theory formulation Fluent uses.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Sets the buffer layer height.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Sets the open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.models = self.__class__.models(path + ["models"], service)
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/verbosity").execute(*args, **kwargs)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enters the transient controls menu, which allows you to define settings related to time advancement for transient flow calculations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the total number of time steps that the simulation will run (which includes any time steps that have already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to1.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which you directly specify the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size used for solid zones is independent from that used for fluid zones. This text command is only available when both a solid zone exists and energy is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solid_time_step_size").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent as the calculation proceeds such that the Courant–Friedrichs–Lewy (CFL) condition is satisfied, using the specified Courant number.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enters the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def solution_status(self, *args, **kwargs):
                    """
                    Allows you to open theSimulation Status dialog box, which reports details about the simulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solution_status").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Sets the total amount of time that the simulation will be run (which includes any time that has already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to2.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_time").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Sets the method by which you will specify the duration of the calculation. The duration can be defined by the total time, the total number of time steps, the incremental time, or the number of incremental time steps. In this context, "total" indicates that Fluent will consider the amount of time / steps that have already been solved and stop appropriately, whereas "incremental" indicates that the solution will proceed for a specified amount of time / steps regardless of what has previously been calculated. This text command is only available when the time stepping is adaptive or based on a user-defined function.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/duration_specification_method").execute(*args, **kwargs)
                def incremental_time(self, *args, **kwargs):
                    """
                    Sets the amount of incremental (that is, additional) time to run the simulation, regardless of how much time has already been run in previous calculations. This text command is only available when the solve/set/transient-controls/duration-specification-method is set to3.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/incremental_time").execute(*args, **kwargs)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing the next time step. The predictor algorithm is a computation that sets a better initial condition for the time step. It uses the rate of change between the prediction and the correction as an indicator for whether the next time step should be larger, smaller, or the same as the current one.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/predict_next_time").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    When enabled, if the truncation error within a time step exceeds the specified tolerance Fluent will automatically undo the current calculation and make another attempt with the time step reduced by 1/2. This will be attempted up to 5 times after which Fluent will accept the result and proceed to the next time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/undo_timestep").execute(*args, **kwargs)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Sets the maximum flow time.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_flow_time").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Specifies the time interval for acoustic data sampling. This text command is only available when both the Ffowcs Williams and Hawkings model is selected and the density-based solver is used with the explicit formulation and explicit transient formulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)
                def time_step_size(self, *args, **kwargs):
                    """
                    Sets the magnitude of the (physical) time step . This text command is only available when the solve/set/transient-controls/fixed-user-specified text command is set toyes.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation without starting the calculation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/number_of_time_steps").execute(*args, **kwargs)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Specifies whether to define the transient advancement either directly by entering a time step size / period / frequency (using the text commands available in thesolve/set/transient-controls menu) or indirectly by entering a Courant number value (using the solve/set/courant-number text command). This text command is only available for the density-based solver when both the explicit formulation and explicit transient formulation are used.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/specified_time_step").execute(*args, **kwargs)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial conditions at time step n+1. The predictor algorithm is a computation that sets a better initial condition for the time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Enables / disables an option that allows for better prediction of the flow field in rotating fluid zones at every time step, in order to speed up the calculation. This text command is only available for transient simulations.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation.  This option is available when automatic initialization and case modification is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size is defined by a user-defined function (UDF) that uses theDEFINE_DELTAT macro.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the convective time scale (global Courant number): the time-step-size calculation depends on the mesh density and velocity in interfacial cells. This method is available for all multiphase models using the implicit or explicit volume fraction formulation, except for the wet steam model.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the specified truncation error tolerance.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which a specified period or frequency is the basis for determining the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_periodic").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Enters the menu for setting multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Enables/disables the physics-driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        When enabled, various time scales (depending on the selection) are  printed to the console window at every time step. This text command is  available with the moving mesh CFL constraint and with the physics-based  constraint.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Enters the menu for choosing the time-scale options. This menu  becomes available after you enable the physics-driven time-step  constraints using the solve/set/transient-controls/multiphase-specific-time-constraints/physics-based-constraint?  text command.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the acoustic time scale. This option is available only for compressible flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the gravitational time scale. This option is available only if gravity is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the surface-tension-driven time scale. This option is available only if the surface tension force modeling is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the viscous time scale. This option is disabled by default. This command is not available with inviscid flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Enter the menu for specifying quantities and zones for steady and unsteady flow statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/remove_dataset").execute(*args, **kwargs)
                def add_rtdft_datasets(self, *args, **kwargs):
                    """
                    Specify zone and quantity combinations for sampling Fourier coefficients of unsteady flows.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_rtdft_datasets").execute(*args, **kwargs)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_datasets").execute(*args, **kwargs)
                def list_datasets(self, *args, **kwargs):
                    """
                    Lists the combinations of zones and quantities that are defined for sampling steady and unsteady flow statistics.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/list_datasets").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enters the pseudo time method menu. This menu is only available for cases that use a pressure-based segregated solver (SIMPLE, SIMPLEC, or PISO) or for steady-state cases that use the pressure-based coupled solver or the density-based implicit solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enters the advanced options menu, which allows you to enable / disable the pseudo time method for individual equations and define their pseudo time scale factors or under-relaxation factors, respectively. These settings only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/advanced_options").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity of the messages related to the pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/verbosity").execute(*args, **kwargs)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
                def formulation(self, *args, **kwargs):
                    """
                    Enables and sets the pseudo time step size formulation or disables the pseudo time method option.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/formulation").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time Courant number when the local time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enters the relaxation factors menu, where you can set the pseudo time explicit relaxation factors for individual equations. These factors only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time settings for the calculation when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enters the poor mesh numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.user_defined_on_register_auto = self.__class__.user_defined_on_register_auto(path + ["user_defined_on_register_auto"], service)
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    super().__init__(path, service)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Sets the orthogonal quality threshold used for applying poor mesh numerics when the solve/set/poor-mesh-numerics/cell-quality-based? text command is enabled. By default, cells with an orthogonal quality of 0.05 or lower are corrected.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Enables/disables the relocation of select cell centroids, to improve the orthogonality metrics and solution stability. It is applied to cells when the criterion value is equal to or less than a threshold value defined as part of the text command. Note that the enhanced metrics are only apparent when reporting the quality in the solution mode of Fluent, and not in the meshing mode.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Prints out a listing of the poor cells for each criterion: default, cell quality, and user-defined, and (if enabled) cell gradient quality and solution and cell quality.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Includes a register for the poor mesh numerics or not.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the solution and cell quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command, and at a specified frequency (of iterations or time steps). This criterion is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Resets the list of poor cells included by the default, cell quality, user-defined, cell gradient quality, and solution and cell quality criteria.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells (those with an orthogonal quality of 0, as well as those identified by other enabled criteria), and defines whether the local solution correction is 0th, 1st, or 2nd order.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enable").execute(*args, **kwargs)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells with an orthogonal quality that is equal to or less than the threshold defined by the solve/set/poor-mesh-numerics/set-quality-threshold text command (which by default is set to 0.05).
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the cell gradient quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command. This criterion is only available with the pressure-based solver, and is not supported for cases that have periodic boundaries.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)

                class user_defined_on_register_auto(TUIMenu):
                    """
                    Set up the application of poor mesh numerics to cells in a register during the calculation at a specified frequency.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_properties(self, *args, **kwargs):
                        """
                        List the properties of a definition for automatic poor mesh numerics.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register_auto/list_properties").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit a definition for automatic poor mesh numerics.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register_auto/edit").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Provides text commands that allow you to undo enhancements to the default solver behavior.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2021 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2022 R1 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R3 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2021 R2 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solve/set/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/expert").execute(*args, **kwargs)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets the relaxation factor.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Selects the variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Sets multiphase numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    super().__init__(path, service)

                class boiling_parameters(TUIMenu):
                    """
                    Enters the menu for the multiphase boiling model parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def thin_film(self, *args, **kwargs):
                        """
                        When enabled, includes multiphase boiling thin film effects using .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        When enabled, considers liquid volume fraction effects by multiplying the heat transfer coefficients by the local liquid volume fraction.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Enters the menu for the stability controls for multiphase flows. For more information about the below option, see  and .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        super().__init__(path, service)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)

                    class anti_diffusion(TUIMenu):
                        """
                        Enters the anti-diffusion menu. This item is available for VOF cases  with the Interfacial Anti-Diffusion option  enabled.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Sets the maximum value of dynamic anti-diffusion strength in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Sets the cosine exponent in the dynamic strength treatment in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enables dynamic strength to reduce compression in the direction tangential to the interface.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            When enabled, solves the flow equation at the end of the iteration. This improves the behavior at the start of new time-step if the solution does not converge properly.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)

                    class hybrid_nita(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Sets the number of outer iterations.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Allows you to change the number of initial time-steps and the number of initial outer iterations to control solution stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Enters the menu for the instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Sets the Courant number limit for detecting unstable  events. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Selects the CFL number type for detection of an unstable  event. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Sets the number of outer iterations for an unstable  event.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enables/disables the instability detector to deal with  possible instability problems. Once this option is enabled,  additional instability detection options become  available.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Sets the velocity limit for detecting unstable events.  This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Enters the menu for the pressure-velocity coupling controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            super().__init__(path, service)

                        class coupled_vof(TUIMenu):
                            """
                            Enters the stability control menu for VOF cases that involve the Coupled pressure-velocity coupling scheme.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Allows you to use the linearized buoyancy force and the  blended treatment for the buoyancy force.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Enters the stability controls menu for the Rhie-Chow interpolation.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Enables/disables the low-order velocity interpolation in  the flux calculation.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                        class skewness_correction(TUIMenu):
                            """
                            Enters the skewness correction menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Enables/disables the limited pressure correction  gradient in skewness terms for the PISO, SIMPLEC, or  fractional step pressure-coupling schemes.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                class compressible_flow(TUIMenu):
                    """
                    Enters the compressible multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Enables an alternative formulation for compressible phases at an  inlet boundary. This formulation calculates static temperature and  pressure using an iterative method based on fundamental thermodynamic  relations.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Enables an enhanced numerical treatment that provides better  stability at startup and during calculation of compressible  flows.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Enters the menu for the multiphase heat mass transfer parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Enables the alternative treatment of the energy sources. For more  information, see .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Enters the menu for the advanced boiling options for the  semi-mechanistic boiling model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Sets the under-relaxation factor for boiling heat flux. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes the expert options for the semi-mechanistic boiling model. For more information about these options, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Enables/disables the two-resistance boiling framework to improve the robustness and accuracy of the solution of cases with multiple boiling mechanisms. For more information about this item, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Enters the cavitation heat mass transfer menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Sets the condensation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 0.2.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Sets the maximum limit on the vapor pressure after the turbulence and thermal correction. The default value is five times the vapor pressure, with consideration of turbulent and thermal effects for each cell and phase.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enables/disables the turbulent diffusion treatment for a cavitating turbulent flow. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Sets the minimum vapor pressure limit for the cavitation mass-transfer model. The default value is 1 Pa.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Sets the evaporation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 1.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Enters the menu for the area density.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Enables/disables the interfacial area density Gradient-Symmetric model. For more information about this model, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Sets the minimum volume fraction for the area density and cavitation. This may be useful, for example, in cases when a species mass transfer model (such as the Symmetric model or Particle model) do not consider evaporation or condensation if the volume fraction of one of the phases is zero. The seeding allows for a phase change to occur in the fluid flow. The default value is 1e-6.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Enters the viscous multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Forces harmonic averaging of cell viscosities to calculate face  viscosity used in momentum equation. This can improve convergence for  highly viscous flow applications (the VOF model only).
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Enters the porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Allows you to fix the saturation (volume fraction) of the phase at  its user-specified residual saturation value.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)

                class default_controls(TUIMenu):
                    """
                    Enters the default controls menu. This menu is available only for multiphase flows.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Applies the multiphase defaults (version 2020 R1) to the loaded case  file.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)

                class solution_stabilization(TUIMenu):
                    """
                    Enters the solution-stabilization numerics menu. This item is available only for the VOF model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        super().__init__(path, service)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        When enabled, uses additional controls for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        When enabled, modifies solver settings for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Enters the menu for the velocity-limiting-treatment.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Specifies the maximum velocity magnitude.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enables/disables the velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            When enabled, the solver prints the number of velocity limited cells at each iteration.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Enters the menu for additional advanced stability controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Enables/disables the blended compressive discretization scheme.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enters the divergence prevention menu. This menu is only available for the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables a divergence prevention option so that Fluent applies under-relaxation to the variables in select cells where the temperature and/or pressure values are approaching the minimum and/or maximum limits.
                    """
                    return PyMenu(self.service, "/solve/set/divergence_prevention/enable").execute(*args, **kwargs)

            class amg_options(TUIMenu):
                """
                Enters the AMG options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def amg_gpgpu_options(self, *args, **kwargs):
                    """
                    Set GPGPU AMG solver options.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                def aggressive_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of a version of the AMG solver that is optimized for high coarsening rates. This option is recommended if the AMG solver diverges with the default settings.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)
                def conservative_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of conservative coarsening techniques for scalar and/or coupled equations that can improve parallel performance and/or convergence for some difficult cases.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                def laplace_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables Laplace coarsening for scalar and/or coupled equations.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/laplace_coarsening").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enters the menu to specify parameters of the acoustics wave equation solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enters the menu to specify the expert parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the explicit relaxation factor. Should be used only with  bad meshes, when iterations do not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the implicit under-relaxation factor. Should be used only  with bad meshes, when the AMG linear solver does not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Speed Numerics.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/enable").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Sets the level of stabilization used to achieve fast convergence. Enter a number 0-5 corresponding to the Mach number range that best characterizes the flow.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/expert").execute(*args, **kwargs)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Makes available the Pressure Discontinuity Sensor which is a binary identifier equal to 1 if a cell is in proximity of a pressure discontinuity.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enters the warped-face gradient correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables gradient enhancement computations and specifies whether Fluent uses fast or memory saving mode.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/enable").execute(*args, **kwargs)

            class fast_transient_settings(TUIMenu):
                """
                Enters the fast transient settings menu. This menu is only available for transient cases that use the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rk2(self, *args, **kwargs):
                    """
                    Allows you to enable the use of a two-stage Runge-Kutta scheme for time integration, or revert to the default multi-stage Runge-Kutta scheme. This text command is only available for transient cases that use the density-based explicit formulation.
                    """
                    return PyMenu(self.service, "/solve/set/fast_transient_settings/rk2").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Enters the advanced settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                    self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                    self.turbo_solver_options = self.__class__.turbo_solver_options(path + ["turbo_solver_options"], service)
                    super().__init__(path, service)
                def energy_numerical_noise_filter(self, *args, **kwargs):
                    """
                    Enables/disables a filter to eliminate non-physical numerical noise in the energy field. Numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present. Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive. This text command is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_numerical_noise_filter").execute(*args, **kwargs)
                def bcd_weights_freeze(self, *args, **kwargs):
                    """
                    Enables/disables freezing of weighting coefficients of the central differencing and the upwind components of the BCD scheme. This dialog command requires the iteration number, after which the BCD scheme weights are to be frozen at each timestep. Freezing the BCD weighting coefficients may help to improve convergence of the timestep iterations as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_weights_freeze").execute(*args, **kwargs)
                def singhal_et_al_cavitation_model(self, *args, **kwargs):
                    """
                    Enables/disables the availability of the Singhal et al. cavitation model option, which can then be enabled in the Multiphase Model dialog box or by using the following text command: define/phases/set-domain-properties/interaction-domain/heat-mass-reaction/cavitation/cavitation?.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/singhal_et_al_cavitation_model").execute(*args, **kwargs)
                def energy_reconstruction_gradient_limiting(self, *args, **kwargs):
                    """
                    Enable limiting of reconstruction gradient for the energy equation.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_reconstruction_gradient_limiting").execute(*args, **kwargs)
                def show_all_discretization_schemes(self, *args, **kwargs):
                    """
                    Enables/disables the availability of all applicable discretization schemes.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/show_all_discretization_schemes").execute(*args, **kwargs)
                def retain_cell_residuals(self, *args, **kwargs):
                    """
                    Enables/disables the retention of cell residuals for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_cell_residuals").execute(*args, **kwargs)
                def linearized_mass_transfer_udf(self, *args, **kwargs):
                    """
                    Enables/disables the use of a linearized mass transfer user-defined function (that is, the DEFINE_LINEARIZED_MASS_TRANSFER macro), as opposed to a mass transfer user-defined function (that is, the DEFINE_MASS_TRANSFER macro).
                    """
                    return PyMenu(self.service, "/solve/set/advanced/linearized_mass_transfer_udf").execute(*args, **kwargs)
                def bcd_boundedness(self, *args, **kwargs):
                    """
                    Specifies the BCD scheme parameter, which controls the boundedness strength of the BCD scheme in the pressure-based solver, as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_boundedness").execute(*args, **kwargs)
                def anisotropic_solid_heat_transfer(self, *args, **kwargs):
                    """
                    Set up the heat transfer for anisotropic solid zones.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/anisotropic_solid_heat_transfer").execute(*args, **kwargs)
                def alternate_wall_temp_formulation(self, *args, **kwargs):
                    """
                    Enables/disables an alternate formulation for wall temperatures.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/alternate_wall_temp_formulation").execute(*args, **kwargs)
                def skewness_correction_enhanced(self, *args, **kwargs):
                    """
                    Enable enhanced skewness correction scheme.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/skewness_correction_enhanced").execute(*args, **kwargs)
                def correction_form(self, *args, **kwargs):
                    """
                    S.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/correction_form").execute(*args, **kwargs)
                def retain_temporary_solver_mem(self, *args, **kwargs):
                    """
                    Enables/disables the retention of temporary solver memory, which retains gradient data and makes some advanced options available for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_temporary_solver_mem").execute(*args, **kwargs)
                def explicit_under_relaxation_value(self, *args, **kwargs):
                    """
                    Explicit under-relaxation value.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/explicit_under_relaxation_value").execute(*args, **kwargs)

                class non_reflecting_boundary_treatment(TUIMenu):
                    """
                    Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)
                    def velocity_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)
                    def pressure_outlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)

                class secondary_gradient_limiting(TUIMenu):
                    """
                    Enters the secondary gradient limiting menu. This menu is only available when the define/models/solver/pressure-based text command is enabled.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mesh_quality_limits(self, *args, **kwargs):
                        """
                        Defines the mesh quality limits used when applying secondary  gradient limiting to faces on coupled two-sided walls. Shifting this  range closer to 1 will decrease the risk of divergence, but at the cost  of accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)
                    def uds(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the user-defined  scalar (UDS) calculations on coupled two-sided walls. This limiting can  help prevent divergence when the cells on such walls have poor  orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/uds").execute(*args, **kwargs)
                    def energy(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the energy  calculations on coupled two-sided walls. This limiting can help prevent  divergence when the cells on such walls have poor orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/energy").execute(*args, **kwargs)

                class turbo_solver_options(TUIMenu):
                    """
                    Enter turbo expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def activate_turbo_specific_numerics(self, *args, **kwargs):
                        """
                        Activate/deactivate turbomachinery specific solver settings.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbo_solver_options/activate_turbo_specific_numerics").execute(*args, **kwargs)
                    def enhanced_linearization(self, *args, **kwargs):
                        """
                        Enable enhanced linearization and set mode.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbo_solver_options/enhanced_linearization").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable/disable turbomachinery expert solver options.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbo_solver_options/enable").execute(*args, **kwargs)
                    def continuity_relaxation_at_walls(self, *args, **kwargs):
                        """
                        Enable and specify options for continuity relaxation at wall boundaries.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbo_solver_options/continuity_relaxation_at_walls").execute(*args, **kwargs)

        class animate(TUIMenu):
            """
            Enters the animation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.objects = self.__class__.objects(path + ["objects"], service)
                self.pulse = self.__class__.pulse(path + ["pulse"], service)
                self.define = self.__class__.define(path + ["define"], service)
                self.playback = self.__class__.playback(path + ["playback"], service)
                super().__init__(path, service)

            class objects(TUIMenu):
                """
                Enters the object manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Deletes solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/delete").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/edit").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copies solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/copy").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Creates new solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/create").execute(*args, **kwargs)
                def clear_history(self, *args, **kwargs):
                    """
                    Clears solution animation object history.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/clear_history").execute(*args, **kwargs)

            class pulse(TUIMenu):
                """
                Enter the pulse animation menu (only available when one or more particle track or pathline graphics objects are defined).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    self.hardcopy = self.__class__.hardcopy(path + ["hardcopy"], service)
                    super().__init__(path, service)
                def pulse_mode(self, *args, **kwargs):
                    """
                    Set whether the pulse is a single pulse or continuous.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/pulse_mode").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Select a pathline or particle track graphics object, specify whether you want to write a video file or picture files, and enter the destination directory for the files. Continuous pulse animations result in a 5 second video. Single pulse animations run for a full cycle.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/write").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enter the video window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/width").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/set_standard_resolution").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/height").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Set the Frame Per Sec(FPS) for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/fps").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Set scale by which video resolution will expand.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/scale").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Enable original resolution.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/use_original_resolution").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/quality").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Exporting video file name.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/name").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set format for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/format").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def keyframe(self, *args, **kwargs):
                            """
                            Set video keyframe rate for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/keyframe").execute(*args, **kwargs)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/compression_method").execute(*args, **kwargs)

                class hardcopy(TUIMenu):
                    """
                    Hardcopy options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.driver = self.__class__.driver(path + ["driver"], service)
                        self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                        super().__init__(path, service)
                    def x_resolution(self, *args, **kwargs):
                        """
                        Set the width of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/x_resolution").execute(*args, **kwargs)
                    def preview(self, *args, **kwargs):
                        """
                        Display a preview image of a hardcopy.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/preview").execute(*args, **kwargs)
                    def use_window_resolution(self, *args, **kwargs):
                        """
                        Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/use_window_resolution").execute(*args, **kwargs)
                    def landscape(self, *args, **kwargs):
                        """
                        Plot hardcopies in landscape or portrait orientation.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/landscape").execute(*args, **kwargs)
                    def dpi(self, *args, **kwargs):
                        """
                        Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/dpi").execute(*args, **kwargs)
                    def y_resolution(self, *args, **kwargs):
                        """
                        Set the height of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/y_resolution").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/set_standard_resolution").execute(*args, **kwargs)
                    def jpeg_hardcopy_quality(self, *args, **kwargs):
                        """
                        To set jpeg hardcopy quality.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/jpeg_hardcopy_quality").execute(*args, **kwargs)
                    def invert_background(self, *args, **kwargs):
                        """
                        Use a white background when the picture is saved.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/invert_background").execute(*args, **kwargs)

                    class driver(TUIMenu):
                        """
                        Enter the set hardcopy driver menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.post_format = self.__class__.post_format(path + ["post_format"], service)
                            super().__init__(path, service)
                        def png(self, *args, **kwargs):
                            """
                            Use PNG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/png").execute(*args, **kwargs)
                        def glb(self, *args, **kwargs):
                            """
                            Use GLB output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/glb").execute(*args, **kwargs)
                        def post_script(self, *args, **kwargs):
                            """
                            Produce PostScript output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_script").execute(*args, **kwargs)
                        def jpeg(self, *args, **kwargs):
                            """
                            Produce JPEG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/jpeg").execute(*args, **kwargs)
                        def dump_window(self, *args, **kwargs):
                            """
                            Set the command used to dump the graphics window to a file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/dump_window").execute(*args, **kwargs)
                        def options(self, *args, **kwargs):
                            """
                            Set the hardcopy options. Available options are:
                            "no gamma correction", disables gamma correction of colors,
                            "physical size = (width,height)", where width and height
                            are the actual measurements of the printable area of the page
                            in centimeters.
                            "subscreen = (left,right,bottom,top)", where left,right,
                            bottom, and top are numbers in [-1,1] describing a subwindow on
                            the page in which to place the hardcopy.
                            The options may be combined by separating them with commas.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/options").execute(*args, **kwargs)
                        def hsf(self, *args, **kwargs):
                            """
                            Use HSF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/hsf").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List the current hardcopy driver.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/list").execute(*args, **kwargs)
                        def ppm(self, *args, **kwargs):
                            """
                            Produce PPM output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/ppm").execute(*args, **kwargs)
                        def tiff(self, *args, **kwargs):
                            """
                            Use TIFF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/tiff").execute(*args, **kwargs)
                        def avz(self, *args, **kwargs):
                            """
                            Use AVZ output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/avz").execute(*args, **kwargs)
                        def eps(self, *args, **kwargs):
                            """
                            Produce encapsulated PostScript (EPS) output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/eps").execute(*args, **kwargs)
                        def vrml(self, *args, **kwargs):
                            """
                            Use VRML output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/vrml").execute(*args, **kwargs)

                        class post_format(TUIMenu):
                            """
                            Enter the PostScript driver format menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vector(self, *args, **kwargs):
                                """
                                Use vector format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/vector").execute(*args, **kwargs)
                            def fast_raster(self, *args, **kwargs):
                                """
                                Use the new raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/fast_raster").execute(*args, **kwargs)
                            def rle_raster(self, *args, **kwargs):
                                """
                                Use the run-length encoded raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/rle_raster").execute(*args, **kwargs)
                            def raster(self, *args, **kwargs):
                                """
                                Use the original raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/raster").execute(*args, **kwargs)

                    class color_mode(TUIMenu):
                        """
                        Enter the hardcopy color mode menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list(self, *args, **kwargs):
                            """
                            Display the current hardcopy color mode.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/list").execute(*args, **kwargs)
                        def color(self, *args, **kwargs):
                            """
                            Plot hardcopies in color.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/color").execute(*args, **kwargs)
                        def gray_scale(self, *args, **kwargs):
                            """
                            Convert color to grayscale for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/gray_scale").execute(*args, **kwargs)
                        def mono_chrome(self, *args, **kwargs):
                            """
                            Convert color to monochrome (black and white) for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/mono_chrome").execute(*args, **kwargs)

            class define(TUIMenu):
                """
                Enters the animation definition menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit_monitor(self, *args, **kwargs):
                    """
                    Changes animation monitor attributes.
                    """
                    return PyMenu(self.service, "/solve/animate/define/edit_monitor").execute(*args, **kwargs)
                def define_monitor(self, *args, **kwargs):
                    """
                    Defines new animation.
                    """
                    return PyMenu(self.service, "/solve/animate/define/define_monitor").execute(*args, **kwargs)

            class playback(TUIMenu):
                """
                Enters the animation playback menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def read(self, *args, **kwargs):
                    """
                    Reads new animation from file or already defined animations.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/read").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes animation sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/delete").execute(*args, **kwargs)
                def stored_view(self, *args, **kwargs):
                    """
                    Plays the 3D animation sequence using the view stored in the sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/stored_view").execute(*args, **kwargs)
                def set_custom_frames(self, *args, **kwargs):
                    """
                    Specify a custom start frame, increment, and end frame for video export.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/set_custom_frames").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Writes animation sequence to the file.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/write").execute(*args, **kwargs)
                def play(self, *args, **kwargs):
                    """
                    Plays the selected animation.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/play").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enters the video menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def scale(self, *args, **kwargs):
                        """
                        Expands or collapses the resolution based on this scaling  factor.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/scale").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/width").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/quality").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Sets the target frames per second (FPS) for the saved video  file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/fps").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/set_standard_resolution").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Specifies what format the video file will be written in (MP4 | AVI |  FLV | MOV | MPEG).
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/format").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Sets the name of the saved video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/name").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/height").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Controls whether the resolution of the saved video file matches that  of the images used to create it.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/use_original_resolution").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/compression_method").execute(*args, **kwargs)
                        def keyframe(self, *args, **kwargs):
                            """
                            Set video keyframe rate for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/keyframe").execute(*args, **kwargs)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate").execute(*args, **kwargs)

        class cell_register_operations(TUIMenu):
            """
            Enters the cell register operations menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/delete").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a new cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/add").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list_properties").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits an existing cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists the currently defined cell register operations.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list").execute(*args, **kwargs)

        class report_definitions(TUIMenu):
            """
            Enters the report definitions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/list_properties").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Renames a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/rename").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes selected report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/compute").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/delete").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solve/report_definitions/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/edit").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report definition objects.
                """
                return PyMenu(self.service, "/solve/report_definitions/delete_all").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report definitions.
                """
                return PyMenu(self.service, "/solve/report_definitions/list").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Creates a copy of a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/copy").execute(*args, **kwargs)

        class report_plots(TUIMenu):
            """
            Enters the report plots menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes a report plot object.
                """
                return PyMenu(self.service, "/solve/report_plots/delete").execute(*args, **kwargs)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/clear_data").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report plot objects.
                """
                return PyMenu(self.service, "/solve/report_plots/delete_all").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report plots.
                """
                return PyMenu(self.service, "/solve/report_plots/list").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plots the specified report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/plot").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/edit").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/add").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Defines the curves for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/curves").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/list_properties").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Defines the axes for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/axes").execute(*args, **kwargs)

        class report_files(TUIMenu):
            """
            Enters the report files menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def edit(self, *args, **kwargs):
                """
                Edits a report file.
                """
                return PyMenu(self.service, "/solve/report_files/edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report file.
                """
                return PyMenu(self.service, "/solve/report_files/list_properties").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report files.
                """
                return PyMenu(self.service, "/solve/report_files/list").execute(*args, **kwargs)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report file.
                """
                return PyMenu(self.service, "/solve/report_files/clear_data").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report file object.
                """
                return PyMenu(self.service, "/solve/report_files/delete").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report file objects.
                """
                return PyMenu(self.service, "/solve/report_files/delete_all").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report file.
                """
                return PyMenu(self.service, "/solve/report_files/add").execute(*args, **kwargs)

        class monitors(TUIMenu):
            """
            Sets solution monitors.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                self.residual = self.__class__.residual(path + ["residual"], service)
                super().__init__(path, service)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solve/monitors/set_average_over").execute(*args, **kwargs)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solve/monitors/convergence_conditions").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/add").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete_all").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/clear_data").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/edit").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list_properties").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete_all").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/axes").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/add").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/curves").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/clear_data").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/plot").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/edit").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enters the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def normalize(self, *args, **kwargs):
                    """
                    Chooses whether to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalize").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Sets convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Sets number of residuals to be saved with data. History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_save").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/print").execute(*args, **kwargs)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Sets the number of iterations through which normalization factors will be maximized.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_maximize_norms").execute(*args, **kwargs)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Sets normalization factors for currently monitored residuals (if normalize? is set to yes).
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalization_factors").execute(*args, **kwargs)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Enables/disables an enhanced formulation for the local scaling of the continuity residuals with the pressure-based solver, so that the absolute mass flow rate at each cell is used. This text command is only available when the computing of the local scale is enabled through the solve/monitors/residual/scale-by-coefficient? text command.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/plot").execute(*args, **kwargs)
                def n_display(self, *args, **kwargs):
                    """
                    Sets the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_display").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Chooses whether to delete the residual history and reset iteration counter to 1.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/reset").execute(*args, **kwargs)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Sets relative convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def criterion_type(self, *args, **kwargs):
                    """
                    Sets convergence criterion type.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/criterion_type").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Chooses which currently monitored residuals should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/check_convergence").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Chooses which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/monitor").execute(*args, **kwargs)
                def re_normalize(self, *args, **kwargs):
                    """
                    Re-normalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/re_normalize").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Chooses whether to scale residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)

        class execute_commands(TUIMenu):
            """
            Enters the execute commands menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/delete").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/enable").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/copy").execute(*args, **kwargs)
            def import_(self, *args, **kwargs):
                """
                Import execute-commands from a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/import").execute(*args, **kwargs)
            def export(self, *args, **kwargs):
                """
                Export execute-commands to a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/export").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/disable").execute(*args, **kwargs)
            def add_edit(self, *args, **kwargs):
                """
                Adds or edits execute commands.
                """
                return PyMenu(self.service, "/solve/execute_commands/add_edit").execute(*args, **kwargs)

        class initialize(TUIMenu):
            """
            Enters the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                super().__init__(path, service)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Opens channel automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/open_channel_auto_init").execute(*args, **kwargs)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initializes using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solve/initialize/hyb_initialization").execute(*args, **kwargs)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solve/initialize/patch").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specifies the number of timesteps for ramping of sound sources and re-initializes the acoustics wave equation solution. For the initialized acoustics solution, Fluent reports the current state of the sound sources ramping.
                """
                return PyMenu(self.service, "/solve/initialize/init_acoustics_options").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Sets reference frame to absolute or relative.
                """
                return PyMenu(self.service, "/solve/initialize/reference_frame").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                Lists default values.
                """
                return PyMenu(self.service, "/solve/initialize/list_defaults").execute(*args, **kwargs)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enters the set full-multigrid for initialization menu. Initial values for each variable can be set within this menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initializes using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solve/initialize/fmg_initialization").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/levelset_auto_init").execute(*args, **kwargs)
            def lwf_initialization(self, *args, **kwargs):
                """
                Deletes wall film particles and initializes wall film variables to zero. This option is available only with the wall-film DPM boundary condition.
                """
                return PyMenu(self.service, "/solve/initialize/lwf_initialization").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Resets discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solve/initialize/dpm_reset").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initializes instantaneous velocity field out of steady state RANS results, for use before enabling a scale resolving simulation such as LES.
                """
                return PyMenu(self.service, "/solve/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)
            def set_defaults(self, *args, **kwargs):
                """
                Sets default initial values.
                """
                return PyMenu(self.service, "/solve/initialize/set_defaults").execute(*args, **kwargs)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Displays the number of iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_iterations_sampled").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Displays the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_time_sampled").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solve/initialize/repair_wall_distance").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initializes unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/init_flow_statistics").execute(*args, **kwargs)
            def set_hyb_initialization(self, *args, **kwargs):
                """
                Enters the hybrid initialization menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_hyb_initialization").execute(*args, **kwargs)
            def initialize_flow(self, *args, **kwargs):
                """
                Initializes the flow field with the current default values.
                """
                return PyMenu(self.service, "/solve/initialize/initialize_flow").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Enters the menu for localized turbulent flow initialization.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Sets values for the turbulent intensity and turbulent viscosity ratio for localized initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables localized initialization of turbulent flow variables.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enters the compute default values menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/outlet_vent").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/radiator").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/wall").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/interior").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/axis").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/degassing").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/mass_flow_inlet").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_far_field").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/network").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/overset").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/periodic").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/velocity_inlet").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/geometry").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/inlet_vent").execute(*args, **kwargs)
                def all_zones(self, *args, **kwargs):
                    """
                    Initializes the flow field with the default values.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/all_zones").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/network_end").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/solid").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/porous_jump").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/interface").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/shadow").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_outlet").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_outlet").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/mass_flow_outlet").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/exhaust_fan").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/fluid").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/dummy_entry").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/fan").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/rans_les_interface").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/intake_fan").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_inlet").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/outflow").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/symmetry").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enters the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)
                def set_options(self, *args, **kwargs):
                    """
                    Sets options for patching and smoothing volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)

        class cell_registers(TUIMenu):
            """
            Enters the cell registers menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def coarsen(self, *args, **kwargs):
                """
                Coarsen the mesh based on a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/coarsen").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solve/cell_registers/add").execute(*args, **kwargs)
            def apply_poor_mesh_numerics(self, *args, **kwargs):
                """
                Applies poor mesh numerics to the mesh of a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/display").execute(*args, **kwargs)
            def adapt(self, *args, **kwargs):
                """
                Adapt cell register objects.
                """
                return PyMenu(self.service, "/solve/cell_registers/adapt").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solve/cell_registers/edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/list_properties").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all of the currently defined cell registers.
                """
                return PyMenu(self.service, "/solve/cell_registers/list").execute(*args, **kwargs)
            def refine(self, *args, **kwargs):
                """
                Refine the mesh based on a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/refine").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/delete").execute(*args, **kwargs)

    class parallel(TUIMenu):
        """
        Enter the parallel processing menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.partition = self.__class__.partition(path + ["partition"], service)
            self.set = self.__class__.set(path + ["set"], service)
            self.network = self.__class__.network(path + ["network"], service)
            self.gpgpu = self.__class__.gpgpu(path + ["gpgpu"], service)
            self.timer = self.__class__.timer(path + ["timer"], service)
            self.multidomain = self.__class__.multidomain(path + ["multidomain"], service)
            self.load_balance = self.__class__.load_balance(path + ["load_balance"], service)
            super().__init__(path, service)
        def thread_number_control(self, *args, **kwargs):
            """
            Thread number control.
            """
            return PyMenu(self.service, "/parallel/thread_number_control").execute(*args, **kwargs)
        def show_connectivity(self, *args, **kwargs):
            """
            Prints the network connectivity for the selected compute node.
            """
            return PyMenu(self.service, "/parallel/show_connectivity").execute(*args, **kwargs)
        def check_verbosity(self, *args, **kwargs):
            """
            Sets verbosity output of the parallel check. Higher verbosity corresponds to more detailed information.
            """
            return PyMenu(self.service, "/parallel/check_verbosity").execute(*args, **kwargs)
        def bandwidth(self, *args, **kwargs):
            """
            Shows network bandwidth.
            """
            return PyMenu(self.service, "/parallel/bandwidth").execute(*args, **kwargs)
        def check(self, *args, **kwargs):
            """
            Performs checks of various factors that affect parallel performance.
            """
            return PyMenu(self.service, "/parallel/check").execute(*args, **kwargs)
        def latency(self, *args, **kwargs):
            """
            Shows network latency.
            """
            return PyMenu(self.service, "/parallel/latency").execute(*args, **kwargs)

        class partition(TUIMenu):
            """
            Enters the partition domain menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                self.automatic = self.__class__.automatic(path + ["automatic"], service)
                super().__init__(path, service)
            def smooth_partition(self, *args, **kwargs):
                """
                Calls the optimizer that attempts to minimize the number of interfaces by modifying the partition boundaries to reduce surface area.
                """
                return PyMenu(self.service, "/parallel/partition/smooth_partition").execute(*args, **kwargs)
            def reorder_partitions_to_architecture(self, *args, **kwargs):
                """
                Reorders partitions to architecture.
                """
                return PyMenu(self.service, "/parallel/partition/reorder_partitions_to_architecture").execute(*args, **kwargs)
            def merge_clusters(self, *args, **kwargs):
                """
                Calls the optimizer that attempts to decrease the number of interfaces by eliminating orphan cell clusters. (An orphan cluster is a group of connected cells such that each member has at least one face that is part of an interface boundary.).
                """
                return PyMenu(self.service, "/parallel/partition/merge_clusters").execute(*args, **kwargs)
            def print_partitions(self, *args, **kwargs):
                """
                Print partition information.
                """
                return PyMenu(self.service, "/parallel/partition/print_partitions").execute(*args, **kwargs)
            def reorder_partitions(self, *args, **kwargs):
                """
                Reorders partitions.
                """
                return PyMenu(self.service, "/parallel/partition/reorder_partitions").execute(*args, **kwargs)
            def print_stored_partitions(self, *args, **kwargs):
                """
                Prints stored partition information (parallel solver).
                """
                return PyMenu(self.service, "/parallel/partition/print_stored_partitions").execute(*args, **kwargs)
            def use_stored_partitions(self, *args, **kwargs):
                """
                Uses this partitioning.
                """
                return PyMenu(self.service, "/parallel/partition/use_stored_partitions").execute(*args, **kwargs)
            def print_active_partitions(self, *args, **kwargs):
                """
                Prints active partition information (parallel solver).
                """
                return PyMenu(self.service, "/parallel/partition/print_active_partitions").execute(*args, **kwargs)
            def method(self, *args, **kwargs):
                """
                Sets the partition method.
                """
                return PyMenu(self.service, "/parallel/partition/method").execute(*args, **kwargs)
            def combine_partition(self, *args, **kwargs):
                """
                Merges every N partitions.
                """
                return PyMenu(self.service, "/parallel/partition/combine_partition").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the set partition parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def laplace_smoothing(self, *args, **kwargs):
                    """
                    Laplace smoothing for mesh with stretched cells.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/laplace_smoothing").execute(*args, **kwargs)
                def all_on(self, *args, **kwargs):
                    """
                    Enables all optimizations.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/all_on").execute(*args, **kwargs)
                def load_distribution(self, *args, **kwargs):
                    """
                    Sets the number of cells desired for each partition. This is useful, for example, when computing on multiple machines with significantly different performance characteristics. If left unset, each partition will contain an approximately equal number of cells. Normalized relative values may be used for the entries.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/load_distribution").execute(*args, **kwargs)
                def dpm_load_balancing(self, *args, **kwargs):
                    """
                    Enables / disables dynamic load balancing for discrete phase model cases that use a second domain for DPM particle tracking (that is, cases for which you have enabled the define/models/dpm/parallel/hybrid-2domain? text command).
                    """
                    return PyMenu(self.service, "/parallel/partition/set/dpm_load_balancing").execute(*args, **kwargs)
                def nfaces_as_weights(self, *args, **kwargs):
                    """
                    Uses number of faces as weights.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/nfaces_as_weights").execute(*args, **kwargs)
                def particle_weight(self, *args, **kwargs):
                    """
                    Sets DPM particle weight.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/particle_weight").execute(*args, **kwargs)
                def smooth(self, *args, **kwargs):
                    """
                    Toggles the optimizer that attempts to minimize the number of interfaces by modifying the partition boundaries to reduce surface area.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/smooth").execute(*args, **kwargs)
                def model_weighted_partition(self, *args, **kwargs):
                    """
                    Enables / disables model-weighted partitioning. This option works with the METIS partitioning method, and specifies that Fluent automatically calculates the weighting based on the cell count and the models and attributes specified as weights (using the parallel/partition/set/isat-weight text command, for example).
                    """
                    return PyMenu(self.service, "/parallel/partition/set/model_weighted_partition").execute(*args, **kwargs)
                def merge(self, *args, **kwargs):
                    """
                    Toggles the optimizer that attempts to decrease the number of interfaces by eliminating orphan cell clusters.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/merge").execute(*args, **kwargs)
                def face_area_as_weights(self, *args, **kwargs):
                    """
                    Uses face area as connection weights.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/face_area_as_weights").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Controls the amount of information that is printed out during partitioning. If set to 1 (the default), a text character. is displayed during each bisection, and partition statistics are displayed once the partitioning completes. If set to 2, additional information about the bisection operation is displayed during each bisection. If set to 0, partition statistics and information during each bisection are not displayed.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/verbosity").execute(*args, **kwargs)
                def all_off(self, *args, **kwargs):
                    """
                    Disables all optimizations.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/all_off").execute(*args, **kwargs)
                def vof_free_surface_weight(self, *args, **kwargs):
                    """
                    Sets VOF free surface weight.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/vof_free_surface_weight").execute(*args, **kwargs)
                def solid_thread_weight(self, *args, **kwargs):
                    """
                    Uses solid thread weights.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/solid_thread_weight").execute(*args, **kwargs)
                def origin(self, *args, **kwargs):
                    """
                    Sets the , , and  coordinate of the origin used by those partitioning functions that require a radial distance. By default, the origin is set to (0, 0, 0).
                    """
                    return PyMenu(self.service, "/parallel/partition/set/origin").execute(*args, **kwargs)
                def isat_weight(self, *args, **kwargs):
                    """
                    Sets ISAT weight.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/isat_weight").execute(*args, **kwargs)
                def layering(self, *args, **kwargs):
                    """
                    Use layering for partitioning.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/layering").execute(*args, **kwargs)
                def pre_test(self, *args, **kwargs):
                    """
                    Enables the operation that determines the best coordinate-splitting direction.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/pre_test").execute(*args, **kwargs)
                def across_zones(self, *args, **kwargs):
                    """
                    Allows partitions to cross zone boundaries (the default). If turned off, it will restrict partitioning to within each cell zone. This is recommended only when cells in different zones require significantly different amounts of computation during the solution phase; for example, if the domain contains both solid and fluid zones.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/across_zones").execute(*args, **kwargs)
                def fluid_solid_rebalance_after_read_case(self, *args, **kwargs):
                    """
                    Use optimal repartitioning after reading case file with significant solid and fluid zones.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/fluid_solid_rebalance_after_read_case").execute(*args, **kwargs)
                def cell_function(self, *args, **kwargs):
                    """
                    Sets cell function.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/cell_function").execute(*args, **kwargs)
                def stretched_mesh_enhancement(self, *args, **kwargs):
                    """
                    Enhancement for mesh with stretched cells.
                    """
                    return PyMenu(self.service, "/parallel/partition/set/stretched_mesh_enhancement").execute(*args, **kwargs)

            class automatic(TUIMenu):
                """
                Enter the menu to set auto partition parameters.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def across_zones(self, *args, **kwargs):
                    """
                    Enable auto partitioning by zone or by domain.
                    """
                    return PyMenu(self.service, "/parallel/partition/automatic/across_zones").execute(*args, **kwargs)
                def method(self, *args, **kwargs):
                    """
                    Set the method for auto partitioning the domain.
                    """
                    return PyMenu(self.service, "/parallel/partition/automatic/method").execute(*args, **kwargs)
                def load_vector(self, *args, **kwargs):
                    """
                    Set auto the partition load vector.
                    """
                    return PyMenu(self.service, "/parallel/partition/automatic/load_vector").execute(*args, **kwargs)
                def pre_test(self, *args, **kwargs):
                    """
                    Set auto partition pre-testing optimization.
                    """
                    return PyMenu(self.service, "/parallel/partition/automatic/pre_test").execute(*args, **kwargs)
                def use_case_file_method(self, *args, **kwargs):
                    """
                    Enable the use-case-file method for auto partitioning.
                    """
                    return PyMenu(self.service, "/parallel/partition/automatic/use_case_file_method").execute(*args, **kwargs)

        class set(TUIMenu):
            """
            Enters the set parallel parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def fast_i_o(self, *args, **kwargs):
                """
                Use fast I/O option.
                """
                return PyMenu(self.service, "/parallel/set/fast_i_o").execute(*args, **kwargs)
            def verbosity(self, *args, **kwargs):
                """
                Sets the parallel verbosity.
                """
                return PyMenu(self.service, "/parallel/set/verbosity").execute(*args, **kwargs)
            def time_out(self, *args, **kwargs):
                """
                Sets spawn time-out in seconds.
                """
                return PyMenu(self.service, "/parallel/set/time_out").execute(*args, **kwargs)
            def partition_mask(self, *args, **kwargs):
                """
                Sets partition mask.
                """
                return PyMenu(self.service, "/parallel/set/partition_mask").execute(*args, **kwargs)

        class network(TUIMenu):
            """
            Enter the network configuration menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def save_hosts(self, *args, **kwargs):
                """
                Write a hosts file.
                """
                return PyMenu(self.service, "/parallel/network/save_hosts").execute(*args, **kwargs)
            def kill_node(self, *args, **kwargs):
                """
                Kill a compute node process specified by ID.
                """
                return PyMenu(self.service, "/parallel/network/kill_node").execute(*args, **kwargs)
            def spawn_node(self, *args, **kwargs):
                """
                Spawn a compute node process on a specified machine.
                """
                return PyMenu(self.service, "/parallel/network/spawn_node").execute(*args, **kwargs)
            def kill_all_nodes(self, *args, **kwargs):
                """
                Delete all compute nodes from virtual machine.
                """
                return PyMenu(self.service, "/parallel/network/kill_all_nodes").execute(*args, **kwargs)
            def path(self, *args, **kwargs):
                """
                Set the Fluent shell script path.
                """
                return PyMenu(self.service, "/parallel/network/path").execute(*args, **kwargs)
            def load_hosts(self, *args, **kwargs):
                """
                Read a hosts file.
                """
                return PyMenu(self.service, "/parallel/network/load_hosts").execute(*args, **kwargs)

        class gpgpu(TUIMenu):
            """
            Enters the GPGPU menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def show(self, *args, **kwargs):
                """
                Lists the available GPGPUs. GPGPUs selected for use are indicated by the presence of an asterisk (\*).
                """
                return PyMenu(self.service, "/parallel/gpgpu/show").execute(*args, **kwargs)
            def select(self, *args, **kwargs):
                """
                Selects which GPGPUs to use for AMG acceleration.
                """
                return PyMenu(self.service, "/parallel/gpgpu/select").execute(*args, **kwargs)

        class timer(TUIMenu):
            """
            Enters the timer menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def usage(self, *args, **kwargs):
                """
                Prints performance statistics in the console window.
                """
                return PyMenu(self.service, "/parallel/timer/usage").execute(*args, **kwargs)
            def reset(self, *args, **kwargs):
                """
                Adjusts domain timers.
                """
                return PyMenu(self.service, "/parallel/timer/reset").execute(*args, **kwargs)

        class multidomain(TUIMenu):
            """
            Enters the multidomain architecture menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.conjugate_heat_transfer = self.__class__.conjugate_heat_transfer(path + ["conjugate_heat_transfer"], service)
                self.solve = self.__class__.solve(path + ["solve"], service)
                super().__init__(path, service)

            class conjugate_heat_transfer(TUIMenu):
                """
                Enters the conjugate heat transfer menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables loosely coupled conjugate heat transfer. This works in conjunction with the solve/set/transient-controls/solid-time-step-size text command (and thereby enables the use of a user-specified time step size for solid zones that can be larger than that used for the fluid zones) to increase the robustness of the energy equation calculation, and specifies that multidomain architecture is used within a single Fluent session to enhance the performance of the simulation.
                    """
                    return PyMenu(self.service, "/parallel/multidomain/conjugate_heat_transfer/enable").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enters the set menu for loosely coupled conjugate heat transfer.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def coupling(self, *args, **kwargs):
                        """
                        Specifies when the fluid and solid zone calculations are coupled,  either at a defined time period or number of fluid time steps.
                        """
                        return PyMenu(self.service, "/parallel/multidomain/conjugate_heat_transfer/set/coupling").execute(*args, **kwargs)
                    def helper_session(self, *args, **kwargs):
                        """
                        Setup helper session for multidomain conjugate heat transfer.
                        """
                        return PyMenu(self.service, "/parallel/multidomain/conjugate_heat_transfer/set/helper_session").execute(*args, **kwargs)
                    def session_mode(self, *args, **kwargs):
                        """
                        Setup session mode (single/multiple) for multidomain conjugate heat transfer.
                        """
                        return PyMenu(self.service, "/parallel/multidomain/conjugate_heat_transfer/set/session_mode").execute(*args, **kwargs)

            class solve(TUIMenu):
                """
                Enter the multi-domain simulation solver menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def iterate(self, *args, **kwargs):
                    """
                    Iteration the multidomain conjugate heat transfer.
                    """
                    return PyMenu(self.service, "/parallel/multidomain/solve/iterate").execute(*args, **kwargs)
                def dual_time_iterate(self, *args, **kwargs):
                    """
                    Dual-time iterate the multidomain conjugate heat transfer.
                    """
                    return PyMenu(self.service, "/parallel/multidomain/solve/dual_time_iterate").execute(*args, **kwargs)

        class load_balance(TUIMenu):
            """
            Enters the load balancing parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def dynamic_mesh(self, *args, **kwargs):
                """
                Uses load balancing for dynamic mesh?.
                """
                return PyMenu(self.service, "/parallel/load_balance/dynamic_mesh").execute(*args, **kwargs)
            def mesh_adaption(self, *args, **kwargs):
                """
                Uses load balancing for mesh adaption?.
                """
                return PyMenu(self.service, "/parallel/load_balance/mesh_adaption").execute(*args, **kwargs)
            def physical_models(self, *args, **kwargs):
                """
                Uses physical-models load balancing?.
                """
                return PyMenu(self.service, "/parallel/load_balance/physical_models").execute(*args, **kwargs)

    class solution(TUIMenu):
        """
        Enter solution menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.run_calculation = self.__class__.run_calculation(path + ["run_calculation"], service)
            self.controls = self.__class__.controls(path + ["controls"], service)
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            self.expert = self.__class__.expert(path + ["expert"], service)
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.calculation_activities = self.__class__.calculation_activities(path + ["calculation_activities"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            self.methods = self.__class__.methods(path + ["methods"], service)
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            super().__init__(path, service)

        class run_calculation(TUIMenu):
            """
            Enter run calculation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                super().__init__(path, service)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/adaptive_time_stepping").execute(*args, **kwargs)
            def reporting_interval(self, *args, **kwargs):
                """
                Set number of solver iterations before returning to scheme.
                """
                return PyMenu(self.service, "/solution/run_calculation/reporting_interval").execute(*args, **kwargs)
            def solution_steering(self, *args, **kwargs):
                """
                Enable solution steering for density-based solver.
                """
                return PyMenu(self.service, "/solution/run_calculation/solution_steering").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Set Solution Steering Parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/set_solution_steering").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Set number of iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/number_of_iterations").execute(*args, **kwargs)
            def multistage_time_iterate(self, *args, **kwargs):
                """
                Perform unsteady iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/multistage_time_iterate").execute(*args, **kwargs)
            def mesh_motion(self, *args, **kwargs):
                """
                Perform mesh motion.
                """
                return PyMenu(self.service, "/solution/run_calculation/mesh_motion").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enter the max-corrections menu.
                """
                return PyMenu(self.service, "/solution/run_calculation/max_corrections").execute(*args, **kwargs)
            def dual_time_iterate(self, *args, **kwargs):
                """
                Perform unsteady iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/dual_time_iterate").execute(*args, **kwargs)
            def summary(self, *args, **kwargs):
                """
                Print report summary.
                """
                return PyMenu(self.service, "/solution/run_calculation/summary").execute(*args, **kwargs)
            def iterate(self, *args, **kwargs):
                """
                Perform a specified number of iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/iterate").execute(*args, **kwargs)
            def update_physical_time(self, *args, **kwargs):
                """
                Update the solution to the next physical time level.
                """
                return PyMenu(self.service, "/solution/run_calculation/update_physical_time").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Set options for second-order time formulation.
                """
                return PyMenu(self.service, "/solution/run_calculation/second_order_time_options").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solution/run_calculation/time_step").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Set iteration options.
                """
                return PyMenu(self.service, "/solution/run_calculation/data_sampling").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/variable_time_stepping").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enter the residual tolerance menu.
                """
                return PyMenu(self.service, "/solution/run_calculation/residual_tolerance").execute(*args, **kwargs)
            def residual_verbosity(self, *args, **kwargs):
                """
                Set the residual report verbosity.
                """
                return PyMenu(self.service, "/solution/run_calculation/residual_verbosity").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enter into the transient controls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Set Multiphase-specific adaptive time stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)
                def time_step_size(self, *args, **kwargs):
                    """
                    Set the physical time step size.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/time_step_size").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Set number of time step size for acoustic export.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Set Max Iterations/Time step.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Use specified time step or courant number.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/specified_time_step").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    Undo the previous time step.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/undo_timestep").execute(*args, **kwargs)
                def incremental_time(self, *args, **kwargs):
                    """
                    Set Incremental Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/incremental_time").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial condition at time step n+1.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/predict_next_time").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Set inceremtal number of Time steps.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/number_of_time_steps").execute(*args, **kwargs)
                def solution_status(self, *args, **kwargs):
                    """
                    Activate the simulation status panel.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/solution_status").execute(*args, **kwargs)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enter the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Set Error-based adaptive time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Set Total Simulation Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/total_time").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Set the time-stepping parameters for user-defined time stepping method.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Specify a different time step size for solid zones.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/solid_time_step_size").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Enable user-specified fixed time stepping method.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Improve prediction of flow field at time step n+1 for rotating mesh.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Set total number of Time steps.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Set maximum flow time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/max_flow_time").execute(*args, **kwargs)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial condition at time step n+1.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Set period- or frequency-based fixed time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/fixed_periodic").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Set Duration Specification Method: [0] Incremental Time Steps, [1] Total Time Steps, [2] Total Time, [3] Incremental Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/duration_specification_method").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Set Multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Include physics driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set verbosity to print multiphase specific time scales.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Set physics based time scale options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Include acoustic time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Include gravity based time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Include surface tension based time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Include viscous time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Data sampling options for statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def add_rtdft_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/add_rtdft_datasets").execute(*args, **kwargs)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/add_datasets").execute(*args, **kwargs)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/remove_dataset").execute(*args, **kwargs)
                def list_datasets(self, *args, **kwargs):
                    """
                    List dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/list_datasets").execute(*args, **kwargs)

        class controls(TUIMenu):
            """
            Enter the controls menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                self.query = self.__class__.query(path + ["query"], service)
                super().__init__(path, service)
            def p_v_controls(self, *args, **kwargs):
                """
                Set P-V-Controls.
                """
                return PyMenu(self.service, "/solution/controls/p_v_controls").execute(*args, **kwargs)
            def courant_number(self, *args, **kwargs):
                """
                Set the fine mesh Courant number (time step factor).
                """
                return PyMenu(self.service, "/solution/controls/courant_number").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Set solver limits for the values of various solution variables.
                """
                return PyMenu(self.service, "/solution/controls/limits").execute(*args, **kwargs)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enter the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solution/controls/relaxation_factor").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Set controls to default values.
                """
                return PyMenu(self.service, "/solution/controls/set_controls_to_default").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enter the under-relaxation menu.
                """
                return PyMenu(self.service, "/solution/controls/under_relaxation").execute(*args, **kwargs)
            def equations(self, *args, **kwargs):
                """
                Enter the equations menu.
                """
                return PyMenu(self.service, "/solution/controls/equations").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enter menu for acoustics wave equation solver controls.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter menu for expert controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specify explicit relaxation factor to be applied to
                        the solution correction when updating solution in the timestep iterations.
                        """
                        return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specify under-relaxation factor to be used in
                        the diagonal matrix elements of implicit solver.
                        """
                        return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    self.models = self.__class__.models(path + ["models"], service)
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/verbosity").execute(*args, **kwargs)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Controls advanced options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                    self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                    super().__init__(path, service)
                def multi_grid_controls(self, *args, **kwargs):
                    """
                    Enter the multi-grid-controls menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_controls").execute(*args, **kwargs)
                def slope_limiter_set(self, *args, **kwargs):
                    """
                    Enter the slope limiter set menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/slope_limiter_set").execute(*args, **kwargs)
                def multi_grid_amg(self, *args, **kwargs):
                    """
                    Set the parameters that govern the algebraic multigrid procedure.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_amg").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Set the solver relaxation method.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/relaxation_method").execute(*args, **kwargs)
                def multi_stage(self, *args, **kwargs):
                    """
                    Set the multiple-stage time stepping scheme coefficients.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_stage").execute(*args, **kwargs)
                def correction_tolerance(self, *args, **kwargs):
                    """
                    Enter the correction tolerance menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/correction_tolerance").execute(*args, **kwargs)
                def multi_grid_fas(self, *args, **kwargs):
                    """
                    Set the coefficients that govern the FAS multigrid procedure.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_fas").execute(*args, **kwargs)

                class fast_transient_settings(TUIMenu):
                    """
                    Enter the fast transient settings menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rk2(self, *args, **kwargs):
                        """
                        Enable the use of a two-stage Runge-Kutta scheme for time integration.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/fast_transient_settings/rk2").execute(*args, **kwargs)

                class amg_options(TUIMenu):
                    """
                    Enter AMG options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def amg_gpgpu_options(self, *args, **kwargs):
                        """
                        Set GPGPU AMG solver options.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                    def conservative_amg_coarsening(self, *args, **kwargs):
                        """
                        Use conservative AMG coarsening?.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                    def laplace_coarsening(self, *args, **kwargs):
                        """
                        Set AMG laplace coarsening options.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/laplace_coarsening").execute(*args, **kwargs)
                    def aggressive_amg_coarsening(self, *args, **kwargs):
                        """
                        Use aggressive AMG coarsening.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter controls query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advanced = self.__class__.advanced(path + ["advanced"], service)
                    self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                    super().__init__(path, service)
                def limits(self, *args, **kwargs):
                    """
                    Get solver limits for the values of various solution variables.
                    """
                    return PyMenu(self.service, "/solution/controls/query/limits").execute(*args, **kwargs)
                def p_v_controls(self, *args, **kwargs):
                    """
                    Get P-V-Controls.
                    """
                    return PyMenu(self.service, "/solution/controls/query/p_v_controls").execute(*args, **kwargs)
                def equations(self, *args, **kwargs):
                    """
                    Enter the equations menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/equations").execute(*args, **kwargs)
                def courant_number(self, *args, **kwargs):
                    """
                    Get the fine mesh Courant number (time step factor).
                    """
                    return PyMenu(self.service, "/solution/controls/query/courant_number").execute(*args, **kwargs)
                def under_relaxation(self, *args, **kwargs):
                    """
                    Enter under relaxation menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/under_relaxation").execute(*args, **kwargs)
                def relaxation_factor(self, *args, **kwargs):
                    """
                    Enter the relaxation-factor menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/relaxation_factor").execute(*args, **kwargs)

                class advanced(TUIMenu):
                    """
                    Controls advanced options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                        super().__init__(path, service)
                    def multi_grid_fas(self, *args, **kwargs):
                        """
                        Get the coefficients that govern the FAS multigrid procedure.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_fas").execute(*args, **kwargs)
                    def relaxation_method(self, *args, **kwargs):
                        """
                        Set the solver relaxation method.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/relaxation_method").execute(*args, **kwargs)
                    def correction_tolerance(self, *args, **kwargs):
                        """
                        Enter the correction tolerance menu.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/correction_tolerance").execute(*args, **kwargs)
                    def multi_grid_amg(self, *args, **kwargs):
                        """
                        Get the parameters that govern the algebraic multigrid procedure.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_amg").execute(*args, **kwargs)
                    def multi_grid_controls(self, *args, **kwargs):
                        """
                        Enter the multi-grid-controls menu.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_controls").execute(*args, **kwargs)
                    def multi_stage(self, *args, **kwargs):
                        """
                        Set the multiple-stage time stepping scheme coefficients.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_stage").execute(*args, **kwargs)

                    class amg_options(TUIMenu):
                        """
                        Enter AMG options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def conservative_amg_coarsening(self, *args, **kwargs):
                            """
                            Use conservative AMG coarsening?.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                        def laplace_coarsening(self, *args, **kwargs):
                            """
                            Get AMG laplace coarsening options.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/laplace_coarsening").execute(*args, **kwargs)
                        def aggressive_amg_coarsening(self, *args, **kwargs):
                            """
                            Use aggressive AMG coarsening.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)
                        def amg_gpgpu_options(self, *args, **kwargs):
                            """
                            Amg gpu options.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/amg_gpgpu_options").execute(*args, **kwargs)

                class acoustics_wave_equation_controls(TUIMenu):
                    """
                    Enter menu for acoustics wave equation solver controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def max_iterations_per_timestep(self, *args, **kwargs):
                        """
                        Specify maximum number of iterations per timestep.
                        """
                        return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                    def relative_convergence_criterion(self, *args, **kwargs):
                        """
                        Specify convergence tolerance for the timestep iterations
                        as the target residual reduction factor.
                        """
                        return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter menu for expert controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def explicit_relaxation_factor(self, *args, **kwargs):
                            """
                            Specify explicit relaxation factor to be applied to
                            the solution correction when updating solution in the timestep iterations.
                            """
                            return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)
                        def under_relaxation_factor(self, *args, **kwargs):
                            """
                            Specify under-relaxation factor to be used in
                            the diagonal matrix elements of implicit solver.
                            """
                            return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)

        class initialize(TUIMenu):
            """
            Enter the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                super().__init__(path, service)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solution/initialize/patch").execute(*args, **kwargs)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enter the set full-multigrid for initialization menu.
                """
                return PyMenu(self.service, "/solution/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                List default values.
                """
                return PyMenu(self.service, "/solution/initialize/list_defaults").execute(*args, **kwargs)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initialize using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solution/initialize/hyb_initialization").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specify number of timesteps for ramping of sources
                and initialize acoustics model variables.
                During ramping the sound sources are multiplied by a factor smoothly growing from 0 to 1.
                """
                return PyMenu(self.service, "/solution/initialize/init_acoustics_options").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initialize statistics.
                """
                return PyMenu(self.service, "/solution/initialize/init_flow_statistics").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Display the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solution/initialize/show_time_sampled").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Correct wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solution/initialize/repair_wall_distance").execute(*args, **kwargs)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Open channel automatic initialization.
                """
                return PyMenu(self.service, "/solution/initialize/open_channel_auto_init").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initialize turbulent velocity fluctuations.
                """
                return PyMenu(self.service, "/solution/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)
            def set_defaults(self, *args, **kwargs):
                """
                Enter the set defaults menu.
                """
                return PyMenu(self.service, "/solution/initialize/set_defaults").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initialize using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solution/initialize/fmg_initialization").execute(*args, **kwargs)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Display the amount of simulated iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solution/initialize/show_iterations_sampled").execute(*args, **kwargs)
            def set_hyb_initialization(self, *args, **kwargs):
                """
                Enter the settings for hybrid initialization method.
                """
                return PyMenu(self.service, "/solution/initialize/set_hyb_initialization").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Set reference frame absolute or relative.
                """
                return PyMenu(self.service, "/solution/initialize/reference_frame").execute(*args, **kwargs)
            def initialize_flow(self, *args, **kwargs):
                """
                Initialize the flow field with the current default values.
                """
                return PyMenu(self.service, "/solution/initialize/initialize_flow").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Reset discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solution/initialize/dpm_reset").execute(*args, **kwargs)
            def lwf_initialization(self, *args, **kwargs):
                """
                Delete wall film particles and initialize wall film variables to zero.
                """
                return PyMenu(self.service, "/solution/initialize/lwf_initialization").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solution/initialize/levelset_auto_init").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Localized initialization of turbulent flow variables for VOF/Mixture multiphase flow models.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Localized initialization of turbulent flow variables for VOF/Mixture multiphase flow models.
                    """
                    return PyMenu(self.service, "/solution/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Turbulent flow parameters for localized initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enter the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solution/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)
                def set_options(self, *args, **kwargs):
                    """
                    Patch and smoothing options for volume fraction.
                    """
                    return PyMenu(self.service, "/solution/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enter the compute defaults menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def fluid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/fluid").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/geometry").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/wall").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/velocity_inlet").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/mass_flow_outlet").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/fan").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/outlet_vent").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/degassing").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/rans_les_interface").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_inlet").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/periodic").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/solid").execute(*args, **kwargs)
                def all_zones(self, *args, **kwargs):
                    """
                    Initialize the flow field with the default values.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/all_zones").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/outflow").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/porous_jump").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_far_field").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/shadow").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/radiator").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/network_end").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/axis").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/symmetry").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/inlet_vent").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/interface").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/dummy_entry").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/exhaust_fan").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/overset").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/interior").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_outlet").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/recirculation_outlet").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/intake_fan").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/mass_flow_inlet").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/network").execute(*args, **kwargs)

        class expert(TUIMenu):
            """
            Enter expert options for solution.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                super().__init__(path, service)
            def energy_numerical_noise_filter(self, *args, **kwargs):
                """
                The energy equation numerical noise filter can be enabled to eliminate non-physical numerical noise in the energy field.
                The numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present.
                Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive.
                """
                return PyMenu(self.service, "/solution/expert/energy_numerical_noise_filter").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Set Explicit VOF controls.
                """
                return PyMenu(self.service, "/solution/expert/vof_explicit_controls").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Set reference density option for Eulerian multiphase.
                """
                return PyMenu(self.service, "/solution/expert/mp_reference_density").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solution/expert/surface_tension_expert").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Set damping function in flow direction.
                """
                return PyMenu(self.service, "/solution/expert/numerical_beach_controls").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Enable/Disable reconstruction. When disabled, accuracy will be first-order.
                """
                return PyMenu(self.service, "/solution/expert/disable_reconstruction").execute(*args, **kwargs)
            def bcd_weights_freeze(self, *args, **kwargs):
                """
                At each timestep, freeze BCD scheme weights after specified iteration
                in order to improve timestep convergence.
                """
                return PyMenu(self.service, "/solution/expert/bcd_weights_freeze").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Set all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solution/expert/set_all_species_together").execute(*args, **kwargs)
            def equation_ordering(self, *args, **kwargs):
                """
                Set the equation order.
                """
                return PyMenu(self.service, "/solution/expert/equation_ordering").execute(*args, **kwargs)
            def explicit_under_relaxation_value(self, *args, **kwargs):
                """
                Explicit under-relaxation value.
                """
                return PyMenu(self.service, "/solution/expert/explicit_under_relaxation_value").execute(*args, **kwargs)
            def singhal_et_al_cavitation_model(self, *args, **kwargs):
                """
                Use Singhal-et-al cavitation model?.
                """
                return PyMenu(self.service, "/solution/expert/singhal_et_al_cavitation_model").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Set surface-tension calculation options.
                """
                return PyMenu(self.service, "/solution/expert/surface_tension").execute(*args, **kwargs)
            def linearized_mass_transfer_udf(self, *args, **kwargs):
                """
                Use linearized mass transfer UDFs?.
                """
                return PyMenu(self.service, "/solution/expert/linearized_mass_transfer_udf").execute(*args, **kwargs)
            def retain_cell_residuals(self, *args, **kwargs):
                """
                Retain cell residuals for postprocessing?.
                """
                return PyMenu(self.service, "/solution/expert/retain_cell_residuals").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Lock the temperature for all solid and shell cell zones in the domain.
                """
                return PyMenu(self.service, "/solution/expert/lock_solid_temperature").execute(*args, **kwargs)
            def show_all_discretization_schemes(self, *args, **kwargs):
                """
                Allow selection of all applicable discretization schemes?.
                """
                return PyMenu(self.service, "/solution/expert/show_all_discretization_schemes").execute(*args, **kwargs)
            def alternate_wall_temp_formulation(self, *args, **kwargs):
                """
                Alternate formulation for wall temperatures?.
                """
                return PyMenu(self.service, "/solution/expert/alternate_wall_temp_formulation").execute(*args, **kwargs)
            def open_channel_controls(self, *args, **kwargs):
                """
                Set additional open channel controls.
                """
                return PyMenu(self.service, "/solution/expert/open_channel_controls").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Setting pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solution/expert/bc_pressure_extrapolations").execute(*args, **kwargs)
            def retain_temporary_solver_mem(self, *args, **kwargs):
                """
                Retain temporary solver memory?.
                """
                return PyMenu(self.service, "/solution/expert/retain_temporary_solver_mem").execute(*args, **kwargs)
            def bcd_boundedness(self, *args, **kwargs):
                """
                BCD scheme boundedness strength, constant or expression (0 to 1).
                """
                return PyMenu(self.service, "/solution/expert/bcd_boundedness").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Set anisotropic drag parameters for Eulerian multiphase.
                """
                return PyMenu(self.service, "/solution/expert/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solution/expert/material_property_warnings").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Control the display of limiter warning diagnostics.
                """
                return PyMenu(self.service, "/solution/expert/limiter_warnings").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Control the display of warning diagnostics for boundaries with reversed flow, etc.
                """
                return PyMenu(self.service, "/solution/expert/flow_warnings").execute(*args, **kwargs)
            def correction_form(self, *args, **kwargs):
                """
                Discretize momentum equations in correction form for the pressure-based solver.
                """
                return PyMenu(self.service, "/solution/expert/correction_form").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Enter previous defaults menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2021R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2022R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2019R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2021R2.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2019R3.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable/disable high-speed-numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/enable").execute(*args, **kwargs)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Enable/disable pressure-discontinuity-sensor visualization.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Expert high-speed-numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/expert").execute(*args, **kwargs)

            class secondary_gradient_limiting(TUIMenu):
                """
                Enter the Secondary Gradient Limiting Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mesh_quality_limits(self, *args, **kwargs):
                    """
                    Specify minimum and maximum mesh quality limits.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)
                def energy(self, *args, **kwargs):
                    """
                    Enable/disable secondary gradient limiting at coupled walls for energy equation.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/energy").execute(*args, **kwargs)
                def uds(self, *args, **kwargs):
                    """
                    Enable/disable secondary gradient limiting at coupled walls for user-defined scalars.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/uds").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enter Poor Mesh Numerics Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.user_defined_on_register_auto = self.__class__.user_defined_on_register_auto(path + ["user_defined_on_register_auto"], service)
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    super().__init__(path, service)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Relocate select cell centroids, to improve orthogonality metrics and solution stability.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics based on cell gradient quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Set quality threshold.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics based on solution and cell quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Include cells in register in poor mesh numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Solution correction on meshes of poor quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/enable").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Print poor cells count.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics on cells with low quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Reset marking of poor cell elements.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)

                class user_defined_on_register_auto(TUIMenu):
                    """
                    Set up the application of poor mesh numerics to cells in a register during the calculation at a specified frequency.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_properties(self, *args, **kwargs):
                        """
                        List the properties of a definition for automatic poor mesh numerics.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register_auto/list_properties").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit a definition for automatic poor mesh numerics.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register_auto/edit").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)

            class non_reflecting_boundary_treatment(TUIMenu):
                """
                Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Enter the open-channel-wave-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Set bufer layer height between phases for segregated velocity inputs.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Set stokes wave theory variants.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enter the divergence prevention menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable divergence prevention.
                    """
                    return PyMenu(self.service, "/solution/expert/divergence_prevention/enable").execute(*args, **kwargs)

        class monitors(TUIMenu):
            """
            Enter the monitors menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                self.residual = self.__class__.residual(path + ["residual"], service)
                super().__init__(path, service)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solution/monitors/set_average_over").execute(*args, **kwargs)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solution/monitors/convergence_conditions").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/clear_data").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/list").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/delete").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/delete_all").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/edit").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/curves").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/axes").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/plot").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/add").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/clear_data").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/delete_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/add").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/edit").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/list_properties").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/delete").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/list").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enter the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def re_normalize(self, *args, **kwargs):
                    """
                    Renormalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/re_normalize").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Choose whether or not residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/plot").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Choose which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/monitor").execute(*args, **kwargs)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Set normalization factors for currently-monitored residuals.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/normalization_factors").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Set convergence criteria for residuals which are
                    currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Scale the continuity residuals locally based on the enhanced formulation.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Set number of residuals to be saved with data.
                    History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_save").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Delete the residual history and reset iteration counter to unity.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/reset").execute(*args, **kwargs)
                def criterion_type(self, *args, **kwargs):
                    """
                    Set convergence criterion type.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/criterion_type").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Enable/disable scaling of residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)
                def normalize(self, *args, **kwargs):
                    """
                    Choose whether or not to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/normalize").execute(*args, **kwargs)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Set the number of iterations through which normalization
                    factors will be maximized.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_maximize_norms").execute(*args, **kwargs)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Set relative convergence criteria for residuals which are
                    currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def n_display(self, *args, **kwargs):
                    """
                    Set the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_display").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Choose whether or not residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/print").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Choose which currently-monitored residuals
                    should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/check_convergence").execute(*args, **kwargs)

        class calculation_activities(TUIMenu):
            """
            Enter calculation activities menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
                self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
                self.animate = self.__class__.animate(path + ["animate"], service)
                self.auto_save = self.__class__.auto_save(path + ["auto_save"], service)
                self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
                super().__init__(path, service)

            class cell_register_operations(TUIMenu):
                """
                Manage Cell Register Operations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/edit").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/add").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/list_properties").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/list").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/delete").execute(*args, **kwargs)

            class execute_commands(TUIMenu):
                """
                Enter the execute-monitor-commands menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def import_(self, *args, **kwargs):
                    """
                    Import execute-commands from a TSV file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/import").execute(*args, **kwargs)
                def export(self, *args, **kwargs):
                    """
                    Export execute-commands to a TSV file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/export").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/delete").execute(*args, **kwargs)
                def add_edit(self, *args, **kwargs):
                    """
                    Add or edit execute-commands.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/add_edit").execute(*args, **kwargs)
                def disable(self, *args, **kwargs):
                    """
                    Disable an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/disable").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/enable").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copy an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/copy").execute(*args, **kwargs)

            class animate(TUIMenu):
                """
                Enter the animation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.objects = self.__class__.objects(path + ["objects"], service)
                    self.define = self.__class__.define(path + ["define"], service)
                    super().__init__(path, service)

                class objects(TUIMenu):
                    """
                    Enter to define, edit, delete solution animation objects.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def copy(self, *args, **kwargs):
                        """
                        Copy graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/copy").execute(*args, **kwargs)
                    def clear_history(self, *args, **kwargs):
                        """
                        Clear object history.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/clear_history").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/delete").execute(*args, **kwargs)
                    def create(self, *args, **kwargs):
                        """
                        Create new graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/create").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/edit").execute(*args, **kwargs)

                class define(TUIMenu):
                    """
                    Enter the animation definition menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def define_monitor(self, *args, **kwargs):
                        """
                        Define new animation.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/define/define_monitor").execute(*args, **kwargs)
                    def edit_monitor(self, *args, **kwargs):
                        """
                        Change animation monitor attributes.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/define/edit_monitor").execute(*args, **kwargs)

            class auto_save(TUIMenu):
                """
                Enter the auto save menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def max_files(self, *args, **kwargs):
                    """
                    Set the maximum number of data files to save. After the maximum is reached, a file will be deleted for each file saved.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/max_files").execute(*args, **kwargs)
                def append_file_name_with(self, *args, **kwargs):
                    """
                    Set the suffix for auto-saved files. The file name can be appended by flow-time, time-step value or by user specified flags in file name.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/append_file_name_with").execute(*args, **kwargs)
                def data_frequency(self, *args, **kwargs):
                    """
                    Set the iteration or time step increment for saving data files.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/data_frequency").execute(*args, **kwargs)
                def root_name(self, *args, **kwargs):
                    """
                    Set the root name for auto-saved files. The number of iterations or time steps will be appended to this root name.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/root_name").execute(*args, **kwargs)
                def save_data_file_every(self, *args, **kwargs):
                    """
                    Set the auto save frequency type to either time-step or crank-angle and set the corresponding frequency.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/save_data_file_every").execute(*args, **kwargs)
                def case_frequency(self, *args, **kwargs):
                    """
                    Set the preference for saving case files.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/case_frequency").execute(*args, **kwargs)
                def retain_most_recent_files(self, *args, **kwargs):
                    """
                    After the maximum (as in max-files) is reached, a file will be deleted for each file saved.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/retain_most_recent_files").execute(*args, **kwargs)

            class solution_strategy(TUIMenu):
                """
                Enter the automatic initialization and case modification strategy menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.automatic_case_modification = self.__class__.automatic_case_modification(path + ["automatic_case_modification"], service)
                    super().__init__(path, service)
                def disable_modification(self, *args, **kwargs):
                    """
                    Disable a single defined case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/disable_modification").execute(*args, **kwargs)
                def copy_modification(self, *args, **kwargs):
                    """
                    Copy a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/copy_modification").execute(*args, **kwargs)
                def add_edit_modification(self, *args, **kwargs):
                    """
                    Define a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/add_edit_modification").execute(*args, **kwargs)
                def enable_modification(self, *args, **kwargs):
                    """
                    Enable a single defined case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/enable_modification").execute(*args, **kwargs)
                def automatic_initialization(self, *args, **kwargs):
                    """
                    Define how the case is to be initialized automatically.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_initialization").execute(*args, **kwargs)
                def delete_modification(self, *args, **kwargs):
                    """
                    Delete a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/delete_modification").execute(*args, **kwargs)
                def execute_strategy(self, *args, **kwargs):
                    """
                    Execute the automatic initialization and case modification strategy defined at present.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/execute_strategy").execute(*args, **kwargs)
                def export_modifications(self, *args, **kwargs):
                    """
                    Export all case modifications to a tsv file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/export_modifications").execute(*args, **kwargs)
                def enable_strategy(self, *args, **kwargs):
                    """
                    Specify whether automatic initialization and case modification should be enabled.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/enable_strategy").execute(*args, **kwargs)
                def import_modifications(self, *args, **kwargs):
                    """
                    Import a list of case modifications from a tsv file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/import_modifications").execute(*args, **kwargs)
                def continue_strategy_execution(self, *args, **kwargs):
                    """
                    Continue execution of the automatic initialization and case modification strategy defined at present.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/continue_strategy_execution").execute(*args, **kwargs)

                class automatic_case_modification(TUIMenu):
                    """
                    Define how the case is to be modified as the solution progresses.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def before_init_modification(self, *args, **kwargs):
                        """
                        Specify modification to be performed before initialization.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/before_init_modification").execute(*args, **kwargs)
                    def original_settings(self, *args, **kwargs):
                        """
                        Specify modification to be performed after initialization to restore to original settings.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/original_settings").execute(*args, **kwargs)
                    def modifications(self, *args, **kwargs):
                        """
                        Specify modifications to be performed during solution.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/modifications").execute(*args, **kwargs)

        class cell_registers(TUIMenu):
            """
            Manage Cell Registers.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def display(self, *args, **kwargs):
                """
                Display cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/display").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/list_properties").execute(*args, **kwargs)
            def refine(self, *args, **kwargs):
                """
                Refine cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/refine").execute(*args, **kwargs)
            def adapt(self, *args, **kwargs):
                """
                Adapt cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/adapt").execute(*args, **kwargs)
            def coarsen(self, *args, **kwargs):
                """
                Coarsen cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/coarsen").execute(*args, **kwargs)
            def apply_poor_mesh_numerics(self, *args, **kwargs):
                """
                Apply poor mesh numerics to cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solution/cell_registers/add").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/edit").execute(*args, **kwargs)

        class methods(TUIMenu):
            """
            Enter the methods menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                self.query = self.__class__.query(path + ["query"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                super().__init__(path, service)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Enable/disable the unsteady global-time-step solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_global_time").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enable/disable frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/solution/methods/frozen_flux").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Set gradient options.
                """
                return PyMenu(self.service, "/solution/methods/gradient_scheme").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enable/disable accelerated non-iterative time marching.
                """
                return PyMenu(self.service, "/solution/methods/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Set VOF numeric options.
                """
                return PyMenu(self.service, "/solution/methods/vof_numerics").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Enable/disable bounded second-order unsteady formulation.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enter the discretization-scheme menu.
                """
                return PyMenu(self.service, "/solution/methods/discretization_scheme").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solution/methods/flux_type").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Enable/disable first-order unsteady solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_1st_order").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Set phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solution/methods/phase_based_vof_discretization").execute(*args, **kwargs)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Set solution methods to default values.
                """
                return PyMenu(self.service, "/solution/methods/set_solution_methods_to_default").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enable/disable the noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/solution/methods/noniterative_time_advance").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Enable/disable the second-order unsteady solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_2nd_order").execute(*args, **kwargs)
            def p_v_coupling(self, *args, **kwargs):
                """
                Select the pressure velocity coupling scheme.
                """
                return PyMenu(self.service, "/solution/methods/p_v_coupling").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solution/methods/reduced_rank_extrapolation_options").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enable convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solution/methods/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
            def residual_smoothing(self, *args, **kwargs):
                """
                Set residual smoothing factor and number of iterations.
                """
                return PyMenu(self.service, "/solution/methods/residual_smoothing").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Set ggnb options.
                """
                return PyMenu(self.service, "/solution/methods/nb_gradient_boundary_option").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solution/methods/reduced_rank_extrapolation").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enter the pseudo time method menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enter the relaxation factors menu to set the pseudo time explicit relaxation factors for equations.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Adjust the settings for the global time step formulation.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Adjust the settings for the local time step formulation.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set the verbosity for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/verbosity").execute(*args, **kwargs)
                def formulation(self, *args, **kwargs):
                    """
                    Select the pseudo time step size formulation for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/formulation").execute(*args, **kwargs)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enter the advanced options menu to define pseudo time settings for equations.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/advanced_options").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Enter the multiphase numerics options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    super().__init__(path, service)

                class default_controls(TUIMenu):
                    """
                    Multiphase default controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Activate multiphase defaults for loaded case.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Multiphase miscellaneous porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Multiphase relative permeability fix option.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)

                class compressible_flow(TUIMenu):
                    """
                    Multiphase compressible numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Multiphase enhanced compressible flow numerics options.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Multiphase compressible flow BC alternate method.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Multiphase interphase heat and mass transfer numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Alternative treatment of latent heat source due to mass transfer.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Boiling advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Allow generalized two-resistance framework for boiling model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes expert options of min/max superheat along with wetting fraction controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Under-relaxation factor for boiling heat flux.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Cavitation numerics options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Condensation coefficient for Schnerr-Sauer model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enable/disable turbulent diffusion treatment between phases participating in cavitation.
                            This treatment is generally recommended for better solution stability.
                            However, in case of numerical difficulties, it can be disabled.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Maximum limit on vapor pressure after turbulence and thermal correction.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Minimum vapor pressure limit for cavitation model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Evaporation coefficient for Schnerr-Sauer model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Interfacial area density menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Interfacial area density gradient-symmetric mechanism.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Minimum vof seeding for non-zero area density in heat and mass transfer.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)

                class solution_stabilization(TUIMenu):
                    """
                    VOF solution stabilization menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        super().__init__(path, service)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        Execute advanced stabilization for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        Execute additional stability controls for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Additional advanced stability controls for VOF.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Blended Compressive discretization scheme for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Velocity limiting related stabiity controls for VOF.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Enter max velocity magnitude.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            Enable verbosity to print number of velocity limited cells during iterations.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enable velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Multiphase viscous flow numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Multiphase options for viscosity averaging.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Stability controls for multiphase flow.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        super().__init__(path, service)

                    class hybrid_nita(TUIMenu):
                        """
                        Hybrid NITA stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Set number of outer iterations in hybrid nita.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Set hybrid nita start-up controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Set Hybrid NITA instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Set Courant Number type for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Set number of outer iterations for unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enable instability detector for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Set velocity limit for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Set Courant Number limit for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Pressure velocity coupling controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            super().__init__(path, service)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Set Rhie-Chow related stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Use low order velocity interpolation in flux calculation.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                        class skewness_correction(TUIMenu):
                            """
                            Skewness correction related stabiity controls for multiphase flow.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Use limited pressure correction gradient in skewness corrections for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                        class coupled_vof(TUIMenu):
                            """
                            Set Coupled VOF stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Set buoynacy force linerization options in coupled vof.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                    class anti_diffusion(TUIMenu):
                        """
                        Anti Diffusion Menu for VOF/Multi-Fluid VOF Models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enable dynamic strength to reduce compression in the tangential direction to the interface.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Set cosine exponent in dynamic strength treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Set maximum value of dynamic anti-diffusion strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Equation Order Menu for Homogeneous Multiphase Flow Models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            Solve flow equation at the end of iteration as an alternative.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)

                class boiling_parameters(TUIMenu):
                    """
                    Multiphase boiling parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        Multiphase boiling liquid volume fraction effects.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)
                    def thin_film(self, *args, **kwargs):
                        """
                        Multiphase boiling thin film effects.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable/Disable High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/expert").execute(*args, **kwargs)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets relaxation factor.
                        """
                        return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Select Variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enter warped-face-gradient-correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solution/methods/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable Warped-Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solution/methods/warped_face_gradient_correction/enable").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enter the nita expert controls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Select a hybrid NITA settings option for faster performance and better robustness.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Set skewness neighbor coupling for nita.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set nita verbosity option.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/set_verbosity").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter methods query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def p_v_coupling(self, *args, **kwargs):
                    """
                    Get the pressure velocity coupling scheme.
                    """
                    return PyMenu(self.service, "/solution/methods/query/p_v_coupling").execute(*args, **kwargs)
                def discretization_scheme(self, *args, **kwargs):
                    """
                    Enter the discretization-scheme menu.
                    """
                    return PyMenu(self.service, "/solution/methods/query/discretization_scheme").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Enter overset solver options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Choose the interpolation method for overset interface(s).
                    """
                    return PyMenu(self.service, "/solution/methods/overset/interpolation_method").execute(*args, **kwargs)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    High order pressure extrapolation at overset interface.
                    """
                    return PyMenu(self.service, "/solution/methods/overset/high_order_pressure").execute(*args, **kwargs)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enable solver to run with orphans present.
                    """
                    return PyMenu(self.service, "/solution/methods/overset/orphan_cell_treatment").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solution/methods/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solution/methods/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def reactions(self, *args, **kwargs):
                    """
                    Enable/disable the species reaction sources and set relaxation factor.
                    """
                    return PyMenu(self.service, "/solution/methods/expert/reactions").execute(*args, **kwargs)
                def numerics(self, *args, **kwargs):
                    """
                    Set numeric options.
                    """
                    return PyMenu(self.service, "/solution/methods/expert/numerics").execute(*args, **kwargs)

        class report_definitions(TUIMenu):
            """
            Manage report definitions.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def rename(self, *args, **kwargs):
                """
                Rename selected report definition with new name.
                """
                return PyMenu(self.service, "/solution/report_definitions/rename").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/delete").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes selected report definition.
                """
                return PyMenu(self.service, "/solution/report_definitions/compute").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/list_properties").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/solution/report_definitions/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solution/report_definitions/add").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all report definition objects.
                """
                return PyMenu(self.service, "/solution/report_definitions/delete_all").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Makes a copy of selected report definition with new name.
                """
                return PyMenu(self.service, "/solution/report_definitions/copy").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/edit").execute(*args, **kwargs)

    class turbo_post(TUIMenu):
        """
        Enter the turbo menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def write_report(self, *args, **kwargs):
            """
            Writes the turbo report to file.
            """
            return PyMenu(self.service, "/turbo_post/write_report").execute(*args, **kwargs)
        def current_topology(self, *args, **kwargs):
            """
            Sets the current turbo topology for global use.
            """
            return PyMenu(self.service, "/turbo_post/current_topology").execute(*args, **kwargs)
        def two_d_contours(self, *args, **kwargs):
            """
            Display 2d contours.
            """
            return PyMenu(self.service, "/turbo_post/two_d_contours").execute(*args, **kwargs)
        def xy_plot_avg(self, *args, **kwargs):
            """
            Displays average XY plots.
            """
            return PyMenu(self.service, "/turbo_post/xy_plot_avg").execute(*args, **kwargs)
        def compute_report(self, *args, **kwargs):
            """
            Computes turbomachinery quantities.
            """
            return PyMenu(self.service, "/turbo_post/compute_report").execute(*args, **kwargs)
        def avg_contours(self, *args, **kwargs):
            """
            Displays average contours.
            """
            return PyMenu(self.service, "/turbo_post/avg_contours").execute(*args, **kwargs)

    class turbo_workflow(TUIMenu):
        """
        Enter the turbo workflow menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.workflow = self.__class__.workflow(path + ["workflow"], service)
            super().__init__(path, service)

        class workflow(TUIMenu):
            """
            Enter the workflow menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def enable(self, *args, **kwargs):
                """
                Enable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/enable").execute(*args, **kwargs)
            def reset(self, *args, **kwargs):
                """
                Reset the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/reset").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/disable").execute(*args, **kwargs)

    class plot(TUIMenu):
        """
        Enter the XY plot menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
            self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
            self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
            super().__init__(path, service)
        def solution_set(self, *args, **kwargs):
            """
            Sets solution plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/solution_set").execute(*args, **kwargs)
        def circum_avg_radial(self, *args, **kwargs):
            """
            Computes iso-radial band surfaces and plots data vs. radius on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_radial").execute(*args, **kwargs)
        def residuals_set(self, *args, **kwargs):
            """
            Sets residual plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/residuals_set").execute(*args, **kwargs)
        def solution(self, *args, **kwargs):
            """
            Plots solution on surfaces and/or zones. Zone and surface names can be indicated using a  wildcard (\*).
            """
            return PyMenu(self.service, "/plot/solution").execute(*args, **kwargs)
        def set_boundary_val_off(self, *args, **kwargs):
            """
            Disables the use of boundary face values when node values are disabled in solution XY plots. This option is disabled by default, that is, boundary face values are used when node values are disabled.
            """
            return PyMenu(self.service, "/plot/set_boundary_val_off").execute(*args, **kwargs)
        def fft(self, *args, **kwargs):
            """
            Plots fast Fourier transform (FFT) of file data. If you respond yes to Acoustic Analysis?, then additional Y axis functions are made available.
            """
            return PyMenu(self.service, "/plot/fft").execute(*args, **kwargs)
        def file_set(self, *args, **kwargs):
            """
            Sets file plot parameters.
            """
            return PyMenu(self.service, "/plot/file_set").execute(*args, **kwargs)
        def plot_direction(self, *args, **kwargs):
            """
            Sets plot direction for XY plot.
            """
            return PyMenu(self.service, "/plot/plot_direction").execute(*args, **kwargs)
        def fft_set(self, *args, **kwargs):
            """
            Enter the menu to set histogram plot parameters.
            """
            return PyMenu(self.service, "/plot/fft_set").execute(*args, **kwargs)
        def label_alignment(self, *args, **kwargs):
            """
            Set the orientation of XY plot axis labels as either horizontal or axis-aligned.
            """
            return PyMenu(self.service, "/plot/label_alignment").execute(*args, **kwargs)
        def file_list(self, *args, **kwargs):
            """
            Plots data from multiple external files.
            """
            return PyMenu(self.service, "/plot/file_list").execute(*args, **kwargs)
        def datasources(self, *args, **kwargs):
            """
            Enters the menu for creating and modifying plots containing multiple data sources.
            """
            return PyMenu(self.service, "/plot/datasources").execute(*args, **kwargs)
        def change_fft_ref_pressure(self, *args, **kwargs):
            """
            Changes reference acoustic pressure.
            """
            return PyMenu(self.service, "/plot/change_fft_ref_pressure").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            Plots data from an external file.
            """
            return PyMenu(self.service, "/plot/file").execute(*args, **kwargs)
        def circum_avg_axial(self, *args, **kwargs):
            """
            Computes iso-axial band surfaces and plots data vs. axial coordinate on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_axial").execute(*args, **kwargs)
        def residuals(self, *args, **kwargs):
            """
            Contains commands that allow you to select the variables for which you want to display XY plots of residual histories in the active graphics window.
            """
            return PyMenu(self.service, "/plot/residuals").execute(*args, **kwargs)
        def histogram_set(self, *args, **kwargs):
            """
            Sets histogram plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/histogram_set").execute(*args, **kwargs)
        def plot(self, *args, **kwargs):
            """
            Plots solution on surfaces.
            """
            return PyMenu(self.service, "/plot/plot").execute(*args, **kwargs)
        def histogram(self, *args, **kwargs):
            """
            Plots a histogram of the specified solution variable using the defined range and number of intervals.
            """
            return PyMenu(self.service, "/plot/histogram").execute(*args, **kwargs)
        def display_profile_data(self, *args, **kwargs):
            """
            Plots profile data.
            """
            return PyMenu(self.service, "/plot/display_profile_data").execute(*args, **kwargs)

        class ansys_sound_analysis(TUIMenu):
            """
            Enter the Ansys sound analysis menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def print_indicators(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before printing the acoustics indicators.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)
            def write_files(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before writing a WAV, output pressure, and/or acoustic indicators file.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)

        class flamelet_curves(TUIMenu):
            """
            Enters the flamelet curves menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot_curves(self, *args, **kwargs):
                """
                Plots of a curve property.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)
            def write_to_file(self, *args, **kwargs):
                """
                Writes curve to a file instead of plot.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)

        class cumulative_plot(TUIMenu):
            """
            Plot the development of force, force coefficient, moment, or moment coefficient across the specified wall zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot(self, *args, **kwargs):
                """
                Plot a cumulative plot in the graphics window.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/plot").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Print the names of the existing cumulative plot objects to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/edit").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Set axes options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/axes").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Print the properties of the specified cumulative plot object to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Create a new cumulative plot.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/add").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Set curves options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/curves").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                Write a cumulative plot to a file.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/write").execute(*args, **kwargs)
            def print(self, *args, **kwargs):
                """
                Print the value of a cumulative plot to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/print").execute(*args, **kwargs)

    class parameters__and__customization(TUIMenu):
        """
        Enter Parameters and custom menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            super().__init__(path, service)

        class user_defined(TUIMenu):
            """
            Enter the user-defined functions and scalars menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.real_gas_models = self.__class__.real_gas_models(path + ["real_gas_models"], service)
                super().__init__(path, service)
            def execute_on_demand(self, *args, **kwargs):
                """
                Execute UDFs on demand.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/execute_on_demand").execute(*args, **kwargs)
            def user_defined_node_memory(self, *args, **kwargs):
                """
                Allocate user-defined node memory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_node_memory").execute(*args, **kwargs)
            def auto_compile_compiled_udfs(self, *args, **kwargs):
                """
                For this Fluent session, specify whether to allow auto-compilation of compiled UDF when a case file (or settings file) is read.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/auto_compile_compiled_udfs").execute(*args, **kwargs)
            def user_defined_scalars(self, *args, **kwargs):
                """
                Define user-defined scalars.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_scalars").execute(*args, **kwargs)
            def use_built_in_compiler(self, *args, **kwargs):
                """
                Enable/disable the use of the built-in compiler.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/use_built_in_compiler").execute(*args, **kwargs)
            def fan_model(self, *args, **kwargs):
                """
                Configure user-defined fan model.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/fan_model").execute(*args, **kwargs)
            def interpreted_functions(self, *args, **kwargs):
                """
                Load interpreted user-defined functions.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/interpreted_functions").execute(*args, **kwargs)
            def user_defined_memory(self, *args, **kwargs):
                """
                Allocate user-defined memory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_memory").execute(*args, **kwargs)
            def function_hooks(self, *args, **kwargs):
                """
                Hook up user-defined functions.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/function_hooks").execute(*args, **kwargs)
            def compiled_functions(self, *args, **kwargs):
                """
                Open user-defined function library.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/compiled_functions").execute(*args, **kwargs)
            def one_D_coupling(self, *args, **kwargs):
                """
                Load 1D library.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/one_D_coupling").execute(*args, **kwargs)
            def use_contributed_cpp(self, *args, **kwargs):
                """
                Enable/disable use of cpp from the Fluent.Inc/contrib directory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/use_contributed_cpp").execute(*args, **kwargs)
            def compile_customized_addon_module(self, *args, **kwargs):
                """
                Compile customized addon module?.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/compile_customized_addon_module").execute(*args, **kwargs)
            def enable_udf_on_gpu(self, *args, **kwargs):
                """
                Compile UDFs with OpenCL support.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/enable_udf_on_gpu").execute(*args, **kwargs)

            class real_gas_models(TUIMenu):
                """
                Enable/configure real gas model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def user_defined_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Load user-defined multispecies real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/user_defined_multispecies_real_gas_model").execute(*args, **kwargs)
                def nist_real_gas_model(self, *args, **kwargs):
                    """
                    Load NIST real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_real_gas_model").execute(*args, **kwargs)
                def nist_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Load NIST real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_multispecies_real_gas_model").execute(*args, **kwargs)
                def user_defined_real_gas_model(self, *args, **kwargs):
                    """
                    Load user-defined real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/user_defined_real_gas_model").execute(*args, **kwargs)
                def set_state(self, *args, **kwargs):
                    """
                    Select state for NIST real gas model.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/set_state").execute(*args, **kwargs)
                def nist_settings(self, *args, **kwargs):
                    """
                    Select refprop library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_settings").execute(*args, **kwargs)

        class parameters(TUIMenu):
            """
            Enter the parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.input_parameters = self.__class__.input_parameters(path + ["input_parameters"], service)
                self.output_parameters = self.__class__.output_parameters(path + ["output_parameters"], service)
                self.list_parameters = self.__class__.list_parameters(path + ["list_parameters"], service)
                super().__init__(path, service)
            def enable_in_TUI(self, *args, **kwargs):
                """
                Enable/disable parameters in the text user interface.
                """
                return PyMenu(self.service, "/parameters__and__customization/parameters/enable_in_TUI").execute(*args, **kwargs)

            class input_parameters(TUIMenu):
                """
                Enter the input-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advance = self.__class__.advance(path + ["advance"], service)
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit an input parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an input parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/delete").execute(*args, **kwargs)

                class advance(TUIMenu):
                    """
                    Define custom variable to use input parameter.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete(self, *args, **kwargs):
                        """
                        Delete selected custom-input-parameters.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/delete").execute(*args, **kwargs)
                    def use_in(self, *args, **kwargs):
                        """
                        Use input parameter in solver-udf or in scheme-procedure.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/use_in").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List of custom-input-parameters.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/list").execute(*args, **kwargs)

            class output_parameters(TUIMenu):
                """
                Enter the output-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_all_to_file(self, *args, **kwargs):
                    """
                    Write all parameter values to file.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/write_all_to_file").execute(*args, **kwargs)
                def rename(self, *args, **kwargs):
                    """
                    Rename an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/rename").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/edit").execute(*args, **kwargs)
                def print_to_console(self, *args, **kwargs):
                    """
                    Print parameter value to console.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/print_to_console").execute(*args, **kwargs)
                def print_all_to_console(self, *args, **kwargs):
                    """
                    Print all parameter values to console.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/print_all_to_console").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/delete").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/create").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Write parameter value to file.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/write_to_file").execute(*args, **kwargs)

            class list_parameters(TUIMenu):
                """
                Enter list-param menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def output_parameters(self, *args, **kwargs):
                    """
                    List all output parameters.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/list_parameters/output_parameters").execute(*args, **kwargs)
                def input_parameters(self, *args, **kwargs):
                    """
                    List all input parameters.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/list_parameters/input_parameters").execute(*args, **kwargs)

    class server(TUIMenu):
        """
        Enter the server menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def stop_web_server(self, *args, **kwargs):
            """
            Stop web server.
            """
            return PyMenu(self.service, "/server/stop_web_server").execute(*args, **kwargs)
        def start_server(self, *args, **kwargs):
            """
            Starts the server for the ANSYS Fluent remote visualization client.
            """
            return PyMenu(self.service, "/server/start_server").execute(*args, **kwargs)
        def print_connected_clients(self, *args, **kwargs):
            """
            Prints the name of the connected client and its IP address to the console.
            """
            return PyMenu(self.service, "/server/print_connected_clients").execute(*args, **kwargs)
        def start_web_server(self, *args, **kwargs):
            """
            Start web server.
            """
            return PyMenu(self.service, "/server/start_web_server").execute(*args, **kwargs)
        def start_client(self, *args, **kwargs):
            """
            Start the ANSYS Fluent remote visualization client.
            """
            return PyMenu(self.service, "/server/start_client").execute(*args, **kwargs)
        def shutdown_server(self, *args, **kwargs):
            """
            Shuts-down the server and disconnects the connected client.
            """
            return PyMenu(self.service, "/server/shutdown_server").execute(*args, **kwargs)
        def print_server_address(self, *args, **kwargs):
            """
            Prints the host address and port number of the server to the console.
            """
            return PyMenu(self.service, "/server/print_server_address").execute(*args, **kwargs)
        def write_or_reset_server_info(self, *args, **kwargs):
            """
            Allows you to create a new server_info.txt file (with any name you specify), which resets the password for connecting to this server session. It does not restart the server.
            """
            return PyMenu(self.service, "/server/write_or_reset_server_info").execute(*args, **kwargs)

    class mesh(TUIMenu):
        """
        Enter the mesh menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.adapt = self.__class__.adapt(path + ["adapt"], service)
            self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
            self.reorder = self.__class__.reorder(path + ["reorder"], service)
            self.polyhedra = self.__class__.polyhedra(path + ["polyhedra"], service)
            self.repair_improve = self.__class__.repair_improve(path + ["repair_improve"], service)
            self.surface_mesh = self.__class__.surface_mesh(path + ["surface_mesh"], service)
            self.geometry = self.__class__.geometry(path + ["geometry"], service)
            super().__init__(path, service)
        def smooth_mesh(self, *args, **kwargs):
            """
            Smooths the mesh using quality-based, Laplacian, or skewness methods.
            """
            return PyMenu(self.service, "/mesh/smooth_mesh").execute(*args, **kwargs)
        def redistribute_boundary_layer(self, *args, **kwargs):
            """
            Redistributes the nodes in a boundary layer zone to achieve a desired growth rate after anisotropic adaption.
            """
            return PyMenu(self.service, "/mesh/redistribute_boundary_layer").execute(*args, **kwargs)
        def translate(self, *args, **kwargs):
            """
            Prompts for the translation offset in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/translate").execute(*args, **kwargs)
        def size_info(self, *args, **kwargs):
            """
            Prints mesh size.
            """
            return PyMenu(self.service, "/mesh/size_info").execute(*args, **kwargs)
        def check(self, *args, **kwargs):
            """
            Performs various mesh consistency checks and displays a report in the console that lists the domain extents, the volume statistics, the face area statistics, and any warnings, as well as details about the various checks and mesh failures (depending on the setting specified for mesh/check-verbosity).
            """
            return PyMenu(self.service, "/mesh/check").execute(*args, **kwargs)
        def swap_mesh_faces(self, *args, **kwargs):
            """
            Swaps mesh faces.
            """
            return PyMenu(self.service, "/mesh/swap_mesh_faces").execute(*args, **kwargs)
        def set_unit_system(self, *args, **kwargs):
            """
            To apply standard set of units to all quantities.
            """
            return PyMenu(self.service, "/mesh/set_unit_system").execute(*args, **kwargs)
        def adjacency(self, *args, **kwargs):
            """
            Views and renames face zones adjacent to selected cell  zones.
            """
            return PyMenu(self.service, "/mesh/adjacency").execute(*args, **kwargs)
        def units(self, *args, **kwargs):
            """
            Set unit conversion factors.
            """
            return PyMenu(self.service, "/mesh/units").execute(*args, **kwargs)
        def mesh_info(self, *args, **kwargs):
            """
            Prints zone information size.
            """
            return PyMenu(self.service, "/mesh/mesh_info").execute(*args, **kwargs)
        def check_before_solve(self, *args, **kwargs):
            """
            The default value for mesh/check-before-solve is “no”. If mesh/check-before-solve is set to “yes”, a mesh check operation will be invoked prior to starting solver. If grid check fails, solver will be interrupted, and relevant information will be printed in the Fluent console.
            """
            return PyMenu(self.service, "/mesh/check_before_solve").execute(*args, **kwargs)
        def enhanced_orthogonal_quality(self, *args, **kwargs):
            """
            Enables / disables an enhanced definition when calculating the orthogonal quality. When enabled, the orthogonal quality is defined using a variety quality measures, including: the orthogonality of a face relative to a vector between the face and cell centroids; a metric that detects poor cell shape at a local edge (such as twisting and/or concavity); and the variation of normals between the faces that can be constructed from the cell face. This enhanced definition is optimal for evaluating thin prism cells.
            """
            return PyMenu(self.service, "/mesh/enhanced_orthogonal_quality").execute(*args, **kwargs)
        def show_periodic_shadow_zones(self, *args, **kwargs):
            """
            Option to show periodic shadow zones in user interface.
            """
            return PyMenu(self.service, "/mesh/show_periodic_shadow_zones").execute(*args, **kwargs)
        def rotate(self, *args, **kwargs):
            """
            Rotates the mesh.
            """
            return PyMenu(self.service, "/mesh/rotate").execute(*args, **kwargs)
        def quality(self, *args, **kwargs):
            """
            Displays information about the quality of the mesh in the console, including the minimum orthogonal quality and the maximum aspect ratio. The level of detail displayed depends on the setting specified for mesh/check-verbosity.
            """
            return PyMenu(self.service, "/mesh/quality").execute(*args, **kwargs)
        def scale(self, *args, **kwargs):
            """
            Prompts for the scaling factors in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/scale").execute(*args, **kwargs)
        def check_verbosity(self, *args, **kwargs):
            """
            Sets the level of details that will be added to the mesh check report generated by mesh/check. A value of 0 (the default) notes when checks are being performed, but does not list them individually. A value of 1 lists the individual checks as they are performed. A value of 2 enables the availability of additional mesh field variables, lists the individual checks as they are performed, and provides additional details (for example, the location of the problem, the affected cells).  The check-verbosity text command can also be used to set the level of detail displayed in the mesh quality report generated by mesh/quality. A value of 0 (the default) or 1 lists the minimum orthogonal quality and the maximum aspect ratio. A value of 2 adds information about the zones that contain the cells with the lowest quality, and additional metrics such as the maximum cell squish index and the minimum expansion ratio.
            """
            return PyMenu(self.service, "/mesh/check_verbosity").execute(*args, **kwargs)
        def replace(self, *args, **kwargs):
            """
            Replace mesh and interpolate data.
            """
            return PyMenu(self.service, "/mesh/replace").execute(*args, **kwargs)
        def memory_usage(self, *args, **kwargs):
            """
            Reports solver memory use.
            """
            return PyMenu(self.service, "/mesh/memory_usage").execute(*args, **kwargs)

        class adapt(TUIMenu):
            """
            Enters the mesh adaption menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
                self.manage_criteria = self.__class__.manage_criteria(path + ["manage_criteria"], service)
                self.set = self.__class__.set(path + ["set"], service)
                self.geometry = self.__class__.geometry(path + ["geometry"], service)
                self.multi_layer_refinement = self.__class__.multi_layer_refinement(path + ["multi_layer_refinement"], service)
                self.profile = self.__class__.profile(path + ["profile"], service)
                super().__init__(path, service)
            def manual_refinement_criteria(self, *args, **kwargs):
                """
                Set expression for manual refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_refinement_criteria").execute(*args, **kwargs)
            def coarsening_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/coarsening_criteria").execute(*args, **kwargs)
            def free_hierarchy(self, *args, **kwargs):
                """
                Deletes the defined adaption hierarchy.
                """
                return PyMenu(self.service, "/mesh/adapt/free_hierarchy").execute(*args, **kwargs)
            def anisotropic_adaption(self, *args, **kwargs):
                """
                Applies legacy anisotropic adaption to refine the boundary layers or registers. Cells will be split in the normal direction to the boundary face. Note that this text command is only available for 3D cases that have the adaption method set to hanging node.
                """
                return PyMenu(self.service, "/mesh/adapt/anisotropic_adaption").execute(*args, **kwargs)
            def manual_coarsening_criteria(self, *args, **kwargs):
                """
                Set expression for manual coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_coarsening_criteria").execute(*args, **kwargs)
            def adapt_mesh(self, *args, **kwargs):
                """
                Performs manual adaption on the mesh according to the methods and settings that you specified.
                """
                return PyMenu(self.service, "/mesh/adapt/adapt_mesh").execute(*args, **kwargs)
            def display_adaption_cells(self, *args, **kwargs):
                """
                Displays the cells that are marked for adaption in the graphics window.
                """
                return PyMenu(self.service, "/mesh/adapt/display_adaption_cells").execute(*args, **kwargs)
            def refinement_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/refinement_criteria").execute(*args, **kwargs)
            def list_adaption_cells(self, *args, **kwargs):
                """
                Prints the number of cells marked for refinement, coarsening, and both to the console.
                """
                return PyMenu(self.service, "/mesh/adapt/list_adaption_cells").execute(*args, **kwargs)

            class cell_registers(TUIMenu):
                """
                Enters the cell registers menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def refine(self, *args, **kwargs):
                    """
                    Refine the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/refine").execute(*args, **kwargs)
                def coarsen(self, *args, **kwargs):
                    """
                    Coarsen the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/coarsen").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists all of the currently defined cell registers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Displays a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/display").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/add").execute(*args, **kwargs)
                def adapt(self, *args, **kwargs):
                    """
                    Adapt cell register objects.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/adapt").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/delete").execute(*args, **kwargs)
                def apply_poor_mesh_numerics(self, *args, **kwargs):
                    """
                    Applies poor mesh numerics to the mesh of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list_properties").execute(*args, **kwargs)

            class manage_criteria(TUIMenu):
                """
                Enters the manage criteria menu, which provides text commands for managing automatic adaption criteria.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def add(self, *args, **kwargs):
                    """
                    Adds a new automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/add").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/delete").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list_properties").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/edit").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists all the existing automatic adaption criteria.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def maximum_refinement_level(self, *args, **kwargs):
                    """
                    Controls the number of levels of refinement used to split cells during the adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                def maximum_cell_count(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the total cell count of the mesh during adaption. Fluent uses this value to determine when to stop marking cells for refinement. A value of zero places no limits on the number of cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_cell_count").execute(*args, **kwargs)
                def encapsulate_children(self, *args, **kwargs):
                    """
                    Encapsulate all children of parent cells on the same partition.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/encapsulate_children").execute(*args, **kwargs)
                def anisotropic_split_ratio(self, *args, **kwargs):
                    """
                    Sets the split ratio for the cells as part of anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_split_ratio").execute(*args, **kwargs)
                def anisotropic_adaption(self, *args, **kwargs):
                    """
                    Enables / disables anisotropic adaption for prismatic cells as part of manual adaption. Note that this text command requires that the adaption method is set to PUMA.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_adaption").execute(*args, **kwargs)
                def dynamic_adaption_frequency(self, *args, **kwargs):
                    """
                    Set frequency for dynamic adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption_frequency").execute(*args, **kwargs)
                def dynamic_adaption(self, *args, **kwargs):
                    """
                    Adapt the mesh during solution.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption").execute(*args, **kwargs)
                def minimum_edge_length(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the edge length for cells that are considered for refinement. Even if a cell is marked for refinement, it will not be refined if (for 3D) its volume is less than the cube of this field or (for 2D) its area is less than the square of this field. The default value of zero places no limits on the size of cells that are refined.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_edge_length").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Allows you set how much information about the adaption is printed to the console.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/verbosity").execute(*args, **kwargs)
                def display_settings(self, *args, **kwargs):
                    """
                    Sets the graphics display options for the refinement, coarsening, and common cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/display_settings").execute(*args, **kwargs)
                def method(self, *args, **kwargs):
                    """
                    Sets the adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/method").execute(*args, **kwargs)
                def minimum_cell_quality(self, *args, **kwargs):
                    """
                    Sets the minimum value allowed for the orthogonal quality of cells during adaption. If your solution diverges, you may find that using a higher minimum quality value resolves the issue. This text command is only available with the PUMA 3D adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_cell_quality").execute(*args, **kwargs)
                def additional_refinement_layers(self, *args, **kwargs):
                    """
                    Allows you to specify additional refinement layers (this is an advanced control).
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/additional_refinement_layers").execute(*args, **kwargs)
                def anisotropic_boundary_zones(self, *args, **kwargs):
                    """
                    Allows you to select the boundary zones that specify directions for anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_boundary_zones").execute(*args, **kwargs)
                def cell_zones(self, *args, **kwargs):
                    """
                    Sets cell zones to be used for marking adaption. An empty list specifies that all zones are considered for adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/cell_zones").execute(*args, **kwargs)
                def overset_adapt_dead_cells(self, *args, **kwargs):
                    """
                    Enables/disables the adaption of dead cells in overset meshes.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/overset_adapt_dead_cells").execute(*args, **kwargs)

            class geometry(TUIMenu):
                """
                Enters the geometry menu. Note that this text command menu is not available unless the adaption method is set to hanging node.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_geometry_controls(self, *args, **kwargs):
                    """
                    Sets geometry controls for wall zones.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/set_geometry_controls").execute(*args, **kwargs)
                def reconstruct_geometry(self, *args, **kwargs):
                    """
                    Enables/disables geometry-based adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/reconstruct_geometry").execute(*args, **kwargs)

            class multi_layer_refinement(TUIMenu):
                """
                Enter the multiple boundary layer refinement menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def refine_mesh(self, *args, **kwargs):
                    """
                    Refine the mesh for multiple boundary layers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/refine_mesh").execute(*args, **kwargs)
                def parameters(self, *args, **kwargs):
                    """
                    Specify parameters for multiple boundary layer refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/parameters").execute(*args, **kwargs)
                def layer_count(self, *args, **kwargs):
                    """
                    Specify the layer count for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/layer_count").execute(*args, **kwargs)
                def boundary_zones(self, *args, **kwargs):
                    """
                    Specify boundary zones for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/boundary_zones").execute(*args, **kwargs)

            class profile(TUIMenu):
                """
                Enters the profile menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/enable").execute(*args, **kwargs)
                def clear(self, *args, **kwargs):
                    """
                    Clears the adaption profiling counters.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/clear").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Prints adaption profiling results.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/print").execute(*args, **kwargs)
                def disable(self, *args, **kwargs):
                    """
                    Disables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/disable").execute(*args, **kwargs)

        class modify_zones(TUIMenu):
            """
            Enters the zone modification menu. For a description of the items in this menu, see define/boundary-conditions/modify-zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def make_periodic(self, *args, **kwargs):
                """
                Attempt to establish conformal periodic face zone connectivity.
                """
                return PyMenu(self.service, "/mesh/modify_zones/make_periodic").execute(*args, **kwargs)
            def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Frame Motion to Mesh Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
            def replace_zone(self, *args, **kwargs):
                """
                Replace a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/replace_zone").execute(*args, **kwargs)
            def sep_face_zone_angle(self, *args, **kwargs):
                """
                Separate a face zone based on significant angle.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)
            def sep_face_zone_mark(self, *args, **kwargs):
                """
                Separate a face zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
            def change_zone_state(self, *args, **kwargs):
                """
                Change the realgas material state for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_state").execute(*args, **kwargs)
            def list_zones(self, *args, **kwargs):
                """
                List zone IDs, types, kinds, and names.
                """
                return PyMenu(self.service, "/mesh/modify_zones/list_zones").execute(*args, **kwargs)
            def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                """
                Change all solid zones motion specification from MRF to solid motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
            def slit_face_zone(self, *args, **kwargs):
                """
                Slit a two-sided wall into two connected wall zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_face_zone").execute(*args, **kwargs)
            def mrf_to_sliding_mesh(self, *args, **kwargs):
                """
                Change motion specification from MRF to moving mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)
            def sep_cell_zone_region(self, *args, **kwargs):
                """
                Separate a cell zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)
            def extrude_face_zone_para(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a distance and a list of parametric locations between 0 and 1 (eg. 0 0.2 0.4 0.8 1.0).
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Set a zone's type.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_type").execute(*args, **kwargs)
            def sep_face_zone_region(self, *args, **kwargs):
                """
                Separate a face zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
            def translate_zone(self, *args, **kwargs):
                """
                Translate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/translate_zone").execute(*args, **kwargs)
            def create_all_shell_threads(self, *args, **kwargs):
                """
                Mark all finite thickness wall for shell creation. Shell zones will be created at the start of iterations.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
            def activate_cell_zone(self, *args, **kwargs):
                """
                Activate a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/activate_cell_zone").execute(*args, **kwargs)
            def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Mesh Motion to Frame Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
            def zone_name(self, *args, **kwargs):
                """
                Give a zone a new name.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_name").execute(*args, **kwargs)
            def extrude_face_zone_delta(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a list of deltas.
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
            def slit_interior_between_diff_solids(self, *args, **kwargs):
                """
                Slit interior created between different solids into coupled walls.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
            def delete_all_shells(self, *args, **kwargs):
                """
                Delete all shell zones and switch off shell conduction on all the walls. These zones can be recreated using the command recreate-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_all_shells").execute(*args, **kwargs)
            def sep_face_zone_face(self, *args, **kwargs):
                """
                Separate each face in a zone into unique zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_face").execute(*args, **kwargs)
            def orient_face_zone(self, *args, **kwargs):
                """
                Orient the face zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/orient_face_zone").execute(*args, **kwargs)
            def copy_move_cell_zone(self, *args, **kwargs):
                """
                Copy and translate or rotate a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
            def matching_tolerance(self, *args, **kwargs):
                """
                Set the normalized tolerance used for finding coincident nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/matching_tolerance").execute(*args, **kwargs)
            def append_mesh_data(self, *args, **kwargs):
                """
                Append new mesh with data.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh_data").execute(*args, **kwargs)
            def create_periodic_interface(self, *args, **kwargs):
                """
                Create a conformal or non-conformal periodic interface.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_periodic_interface").execute(*args, **kwargs)
            def delete_cell_zone(self, *args, **kwargs):
                """
                Delete a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_cell_zone").execute(*args, **kwargs)
            def merge_zones(self, *args, **kwargs):
                """
                Merge zones of the same type and condition into one.
                """
                return PyMenu(self.service, "/mesh/modify_zones/merge_zones").execute(*args, **kwargs)
            def recreate_all_shells(self, *args, **kwargs):
                """
                Create shell on all the walls where which were deleted using the command delete-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/recreate_all_shells").execute(*args, **kwargs)
            def slit_periodic(self, *args, **kwargs):
                """
                Slit a periodic zone into two symmetry zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_periodic").execute(*args, **kwargs)
            def deactivate_cell_zone(self, *args, **kwargs):
                """
                Deactivate cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
            def fuse_face_zones(self, *args, **kwargs):
                """
                Attempt to fuse zones by removing duplicate faces and nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/fuse_face_zones").execute(*args, **kwargs)
            def change_zone_phase(self, *args, **kwargs):
                """
                Change the realgas phase for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_phase").execute(*args, **kwargs)
            def sep_cell_zone_mark(self, *args, **kwargs):
                """
                Separate a cell zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)
            def append_mesh(self, *args, **kwargs):
                """
                Append new mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh").execute(*args, **kwargs)
            def rotate_zone(self, *args, **kwargs):
                """
                Rotate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/rotate_zone").execute(*args, **kwargs)
            def scale_zone(self, *args, **kwargs):
                """
                Scale nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/scale_zone").execute(*args, **kwargs)

        class reorder(TUIMenu):
            """
            Reorders domain menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def reorder_zones(self, *args, **kwargs):
                """
                Reorders zones by partition, type, and ID.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_zones").execute(*args, **kwargs)
            def reorder_domain(self, *args, **kwargs):
                """
                Reorders cells and faces using the reverse Cuthill-McKee algorithm. Note that you must save a new case file (and a data file, if data exists) after reordering with this text command, as well as recreate any ray files and/or surface cluster information.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_domain").execute(*args, **kwargs)
            def band_width(self, *args, **kwargs):
                """
                Prints cell bandwidth.
                """
                return PyMenu(self.service, "/mesh/reorder/band_width").execute(*args, **kwargs)

        class polyhedra(TUIMenu):
            """
            Enters the polyhedra menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.options = self.__class__.options(path + ["options"], service)
                super().__init__(path, service)
            def convert_hanging_nodes_zones(self, *args, **kwargs):
                """
                Convert selected cell zones with hanging nodes and faces to polyhedra.
                The selected cell zones cannot be connected to other zones.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes_zones").execute(*args, **kwargs)
            def convert_domain(self, *args, **kwargs):
                """
                Converts the entire domain to polyhedra cells.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_domain").execute(*args, **kwargs)
            def convert_hanging_nodes(self, *args, **kwargs):
                """
                Converts cells with hanging nodes/edges to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes").execute(*args, **kwargs)
            def convert_skewed_cells(self, *args, **kwargs):
                """
                Converts skewed cells to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_skewed_cells").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enters the polyhedra options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def preserve_interior_zones(self, *args, **kwargs):
                    """
                    Enables the preservation of surfaces (that is, manifold zones of type interior) during the conversion of the domain to polyhedra. Note that only those zones with a name that includes the string you specify will be preserved.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_interior_zones").execute(*args, **kwargs)
                def migrate_and_reorder(self, *args, **kwargs):
                    """
                    Enables / disables the migration of newly created partitions to the compute-nodes and the reordering of the domain as part of polyhedra conversion. This is disabled by default, because it requires significant additional memory; when disabled, it is recommended that you save the case file after conversion, read it in a new Fluent session (so that the new / stored partitions become active), and then manually reorder using the mesh/reorder/reorder-domain text command. If you want to run the calculation in the current Fluent session you can enable the migrate-and-reorder? text command prior to conversion, but you must ensure that no more than half of the available memory of your system is currently used.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/migrate_and_reorder").execute(*args, **kwargs)
                def preserve_boundary_layer(self, *args, **kwargs):
                    """
                    Specifies whether boundary layer cells will be preserved when the domain is converted to polyhedra. When the value is set to 0 (default) ANSYS Fluent checks for high aspect ratio cells at the boundary layer and if any are found, Fluent asks if you want to preserve the boundary layer. When the value is set to 1, the boundary layer cells are never preserved; when it is set to 2, the boundary layer cells are always preserved (regardless of the aspect ratio of the boundary layer cells).
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_boundary_layer").execute(*args, **kwargs)

        class repair_improve(TUIMenu):
            """
            Enter the repair and improve quality menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def report_poor_elements(self, *args, **kwargs):
                """
                Reports invalid and poor quality elements.
                """
                return PyMenu(self.service, "/mesh/repair_improve/report_poor_elements").execute(*args, **kwargs)
            def repair_face_node_order(self, *args, **kwargs):
                """
                Modifies face nodes to repair faces with improper face node order and, therefore, eliminates any resulting left-handed faces.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_node_order").execute(*args, **kwargs)
            def repair(self, *args, **kwargs):
                """
                Repairs mesh problems identified by the mesh check, if possible. The repairs include fixing cells that have the wrong node order, the wrong face handedness, faces that are small or nonexistent, or very poor quality. Only interior nodes are repositioned by default; boundary nodes may be repositioned if the  mesh/repair-improve/allow-repair-at-boundaries text command is enabled. Note that highly skewed cells may be converted into polyhedra, depending on whether the  mesh/repair-improve/include-local-polyhedra-conversion-in-repair text command is enabled.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair").execute(*args, **kwargs)
            def allow_repair_at_boundaries(self, *args, **kwargs):
                """
                Allows the adjustment of the positions of nodes on boundaries as part of the mesh repairs performed by the mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/allow_repair_at_boundaries").execute(*args, **kwargs)
            def include_local_polyhedra_conversion_in_repair(self, *args, **kwargs):
                """
                Enables/disables the local conversion of degenerate cells into polyhedra based on skewness criteria as part of the mesh repairs performed by the  mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/include_local_polyhedra_conversion_in_repair").execute(*args, **kwargs)
            def repair_periodic(self, *args, **kwargs):
                """
                Modifies the mesh to enforce a rotational angle or translational distance for periodic boundaries. For translationally periodic boundaries, the command computes an average translation distance and adjusts the node coordinates on the shadow face zone to match this distance. For rotationally periodic boundaries, the command prompts for an angle and adjusts the node coordinates on the shadow face zone using this angle and the defined rotational axis for the cell zone.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_periodic").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Improves poor quality cells in the mesh, if possible.
                """
                return PyMenu(self.service, "/mesh/repair_improve/improve_quality").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_wall_distance").execute(*args, **kwargs)
            def repair_face_handedness(self, *args, **kwargs):
                """
                Modifies cell centroids to repair meshes that contain left-handed faces without face node order problems.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_handedness").execute(*args, **kwargs)

        class surface_mesh(TUIMenu):
            """
            Enters the Surface Mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def read(self, *args, **kwargs):
                """
                Reads surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/read").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes surface mesh.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/delete").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/display").execute(*args, **kwargs)

        class geometry(TUIMenu):
            """
            Enter the geometry menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def display(self, *args, **kwargs):
                """
                Display geometry.
                """
                return PyMenu(self.service, "/mesh/geometry/display").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/mesh/geometry/delete").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/mesh/geometry/list_properties").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/mesh/geometry/edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/mesh/geometry/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/mesh/geometry/add").execute(*args, **kwargs)

    class define(TUIMenu):
        """
        Enter the define menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            self.curvilinear_coordinate_system = self.__class__.curvilinear_coordinate_system(path + ["curvilinear_coordinate_system"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.phases = self.__class__.phases(path + ["phases"], service)
            self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            self.virtual_boundary = self.__class__.virtual_boundary(path + ["virtual_boundary"], service)
            self.profiles = self.__class__.profiles(path + ["profiles"], service)
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            self.periodic_conditions = self.__class__.periodic_conditions(path + ["periodic_conditions"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.spectral = self.__class__.spectral(path + ["spectral"], service)
            self.models = self.__class__.models(path + ["models"], service)
            self.boundary_conditions = self.__class__.boundary_conditions(path + ["boundary_conditions"], service)
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            self.custom_field_functions = self.__class__.custom_field_functions(path + ["custom_field_functions"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            super().__init__(path, service)
        def set_unit_system(self, *args, **kwargs):
            """
            Applies a standard set of units to all quantities. The options include default,si, british, andcgs.
            """
            return PyMenu(self.service, "/define/set_unit_system").execute(*args, **kwargs)
        def physics(self, *args, **kwargs):
            """
            Manage Physics-regions.
            """
            return PyMenu(self.service, "/define/physics").execute(*args, **kwargs)
        def units(self, *args, **kwargs):
            """
            Sets unit conversion factors.
            """
            return PyMenu(self.service, "/define/units").execute(*args, **kwargs)
        def injections(self, *args, **kwargs):
            """
            Enters the injections menu.  For a description of the items in this menu, see define/models/dpm/injections.
            """
            return PyMenu(self.service, "/define/injections").execute(*args, **kwargs)
        def enable_mesh_morpher_optimizer(self, *args, **kwargs):
            """
            Enables the mesh morpher/optimizer. When the mesh morpher/optimizer is enabled, the define/mesh-morpher-optimizer text command becomes available.
            """
            return PyMenu(self.service, "/define/enable_mesh_morpher_optimizer").execute(*args, **kwargs)
        def beta_feature_access(self, *args, **kwargs):
            """
            Enable access to beta features in the interface.
            """
            return PyMenu(self.service, "/define/beta_feature_access").execute(*args, **kwargs)

        class named_expressions(TUIMenu):
            """
            Enters the named expressions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                Lists the definition of a named expression.
                """
                return PyMenu(self.service, "/define/named_expressions/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a new named expression.
                """
                return PyMenu(self.service, "/define/named_expressions/add").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Allows you to copy an existing named expression.
                """
                return PyMenu(self.service, "/define/named_expressions/copy").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes and prints the value of an expression. This is only available for expressions that evaluate to a single value.
                """
                return PyMenu(self.service, "/define/named_expressions/compute").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Allows you to edit the definition of a named expression.
                """
                return PyMenu(self.service, "/define/named_expressions/edit").execute(*args, **kwargs)
            def export_to_tsv(self, *args, **kwargs):
                """
                Export one or more named expressions to a file in TSV format.
                """
                return PyMenu(self.service, "/define/named_expressions/export_to_tsv").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Allows you to delete a named expression, as long as it is not in use.
                """
                return PyMenu(self.service, "/define/named_expressions/delete").execute(*args, **kwargs)
            def import_from_tsv(self, *args, **kwargs):
                """
                Import one or more named expressions saved in TSV format.
                """
                return PyMenu(self.service, "/define/named_expressions/import_from_tsv").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all of the currently defined named expressions.
                """
                return PyMenu(self.service, "/define/named_expressions/list").execute(*args, **kwargs)

        class dynamic_mesh(TUIMenu):
            """
            Enters the dynamic mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.zones = self.__class__.zones(path + ["zones"], service)
                self.transient_settings = self.__class__.transient_settings(path + ["transient_settings"], service)
                self.controls = self.__class__.controls(path + ["controls"], service)
                self.actions = self.__class__.actions(path + ["actions"], service)
                self.events = self.__class__.events(path + ["events"], service)
                super().__init__(path, service)
            def dynamic_mesh(self, *args, **kwargs):
                """
                Enables/disables the dynamic mesh solver.
                """
                return PyMenu(self.service, "/define/dynamic_mesh/dynamic_mesh").execute(*args, **kwargs)

            class zones(TUIMenu):
                """
                Enters the dynamic mesh zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def insert_boundary_layer(self, *args, **kwargs):
                    """
                    Inserts a new cell zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/insert_boundary_layer").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists the dynamic zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/list").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a dynamic zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/delete").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create dynamic zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/create").execute(*args, **kwargs)
                def remove_interior_layer(self, *args, **kwargs):
                    """
                    Removes an interior layer cell zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/remove_interior_layer").execute(*args, **kwargs)
                def insert_interior_layer(self, *args, **kwargs):
                    """
                    Inserts a new layer cell zone at a specified location.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/insert_interior_layer").execute(*args, **kwargs)
                def remove_boundary_layer(self, *args, **kwargs):
                    """
                    Removes a cell zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/remove_boundary_layer").execute(*args, **kwargs)

            class transient_settings(TUIMenu):
                """
                Enters the transient dynamic mesh settings menu. This text command is only available when you enable dynamic mesh using the prompts of the define/dynamic-mesh/dynamic-mesh? text command. Solver time must also be set to Transient.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    Enables/disables transient scheme verbosity for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/transient_settings/verbosity").execute(*args, **kwargs)
                def allow_second_order(self, *args, **kwargs):
                    """
                    Enables/disables second order transient scheme for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/transient_settings/allow_second_order").execute(*args, **kwargs)

            class controls(TUIMenu):
                """
                Enters the dynamic mesh controls menu. This text command is only available when the define/dynamic-mesh/dynamic-mesh? text command is enabled.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.contact_parameters = self.__class__.contact_parameters(path + ["contact_parameters"], service)
                    self.six_dof_parameters = self.__class__.six_dof_parameters(path + ["six_dof_parameters"], service)
                    self.in_cylinder_parameters = self.__class__.in_cylinder_parameters(path + ["in_cylinder_parameters"], service)
                    self.smoothing_parameters = self.__class__.smoothing_parameters(path + ["smoothing_parameters"], service)
                    self.remeshing_parameters = self.__class__.remeshing_parameters(path + ["remeshing_parameters"], service)
                    self.implicit_update_parameters = self.__class__.implicit_update_parameters(path + ["implicit_update_parameters"], service)
                    self.periodic_displacement_parameters = self.__class__.periodic_displacement_parameters(path + ["periodic_displacement_parameters"], service)
                    self.layering_parameters = self.__class__.layering_parameters(path + ["layering_parameters"], service)
                    super().__init__(path, service)
                def smoothing(self, *args, **kwargs):
                    """
                    Enables/disables smoothing in cell zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing").execute(*args, **kwargs)
                def remeshing(self, *args, **kwargs):
                    """
                    Enables/disables local remeshing in tri/tet and mixed cell zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing").execute(*args, **kwargs)
                def layering(self, *args, **kwargs):
                    """
                    Enables/disables dynamic-layering in quad/hex cell zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/layering").execute(*args, **kwargs)
                def steady_pseudo_time_control(self, *args, **kwargs):
                    """
                    Enables/disables the pseudo time step control in the 	graphical user interface.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/steady_pseudo_time_control").execute(*args, **kwargs)
                def in_cylinder_output(self, *args, **kwargs):
                    """
                    Enables/disables in-cylinder output.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_output").execute(*args, **kwargs)

                class contact_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh contact-parameters menu. This text command is only available 	when you enable contact detection using the prompts of 	the define/dynamic-mesh/dynamic-mesh? 	text command.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.flow_control_parameters = self.__class__.flow_control_parameters(path + ["flow_control_parameters"], service)
                        super().__init__(path, service)
                    def render_contact_cells(self, *args, **kwargs):
                        """
                        Enables/disables the availability of a field variable (contact-cell-mark) that can be used to display contours of cells marked for flow blocking as part of the contact marks method, and allows you to postprocess other field variables on those cells.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/render_contact_cells").execute(*args, **kwargs)
                    def update_contact_marks(self, *args, **kwargs):
                        """
                        Updates which cells are marked in order to block flow in the contact region as part of the contact marks method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/update_contact_marks").execute(*args, **kwargs)
                    def flow_control(self, *args, **kwargs):
                        """
                        Enables/disables flow control in the contact region.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control").execute(*args, **kwargs)
                    def contact_method(self, *args, **kwargs):
                        """
                        Selects the method used for flow control in the contact region. Enter 0 for the contact zones method (which restricts the flow using additional cell zones with porous zone properties) or 1 for the contact marks method (which blocks the flow using zero-mass-flux boundaries).
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_method").execute(*args, **kwargs)
                    def contact_udf(self, *args, **kwargs):
                        """
                        Selects the UDF to be invoked when contact is detected.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_udf").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Sets the level of detail printed in the console regarding contact detection.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/verbosity").execute(*args, **kwargs)
                    def contact_face_zones(self, *args, **kwargs):
                        """
                        Selects face zones involved in contact detection.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_face_zones").execute(*args, **kwargs)
                    def contact_threshold(self, *args, **kwargs):
                        """
                        Specifies threshold distance for contact detection.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_threshold").execute(*args, **kwargs)

                    class flow_control_parameters(TUIMenu):
                        """
                        Enters the flow control parameters menu, which provides settings related to controlling the flow in the contact region.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solution_stabilization(self, *args, **kwargs):
                            """
                            Enables/disables the performance of additional iterations per time step and the application of solution controls to improve the stability of the solver as part of the contact marks method.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control_parameters/solution_stabilization").execute(*args, **kwargs)
                        def delete_flow_control_zone(self, *args, **kwargs):
                            """
                            Deletes a flow control zone as part of the contact zones method.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control_parameters/delete_flow_control_zone").execute(*args, **kwargs)
                        def create_flow_control_zone(self, *args, **kwargs):
                            """
                            Creates a flow control zone as part of the contact zones method.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control_parameters/create_flow_control_zone").execute(*args, **kwargs)

                class six_dof_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh six degrees of freedom (DOF) solver menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def y_component_of_gravity(self, *args, **kwargs):
                        """
                        Specifies y-component of gravity.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/y_component_of_gravity").execute(*args, **kwargs)
                    def z_component_of_gravity(self, *args, **kwargs):
                        """
                        Specifies z-component of gravity.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/z_component_of_gravity").execute(*args, **kwargs)
                    def delete_properties(self, *args, **kwargs):
                        """
                        Deletes a set of six DOF properties for rigid body motion.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/delete_properties").execute(*args, **kwargs)
                    def create_properties(self, *args, **kwargs):
                        """
                        Creates/edits a set of six DOF properties for rigid body motion.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/create_properties").execute(*args, **kwargs)
                    def motion_history(self, *args, **kwargs):
                        """
                        Enables/disables writing position/orientation of six DOF zones to file.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/motion_history").execute(*args, **kwargs)
                    def second_order(self, *args, **kwargs):
                        """
                        Enables/disables the second order six degrees of freedom solver.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/second_order").execute(*args, **kwargs)
                    def x_component_of_gravity(self, *args, **kwargs):
                        """
                        Specifies x-component of gravity.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/x_component_of_gravity").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        Prints summaries of the existing sets of six DOF properties for rigid body motion.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/list_properties").execute(*args, **kwargs)
                    def motion_history_file_name(self, *args, **kwargs):
                        """
                        Specifies the name and location of the six DOF motion history file.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/motion_history_file_name").execute(*args, **kwargs)

                class in_cylinder_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh in-cylinder menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def crank_period(self, *args, **kwargs):
                        """
                        Specifies the crank period.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/crank_period").execute(*args, **kwargs)
                    def starting_crank_angle(self, *args, **kwargs):
                        """
                        Specifies the initial value for the crank angle.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/starting_crank_angle").execute(*args, **kwargs)
                    def modify_lift(self, *args, **kwargs):
                        """
                        Modifies lift curve (shift or scale).
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/modify_lift").execute(*args, **kwargs)
                    def minimum_lift(self, *args, **kwargs):
                        """
                        Specifies minimum lift for in-cylinder valves.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/minimum_lift").execute(*args, **kwargs)
                    def crank_angle_step(self, *args, **kwargs):
                        """
                        Specifies crank angle step size.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/crank_angle_step").execute(*args, **kwargs)
                    def piston_data(self, *args, **kwargs):
                        """
                        Specifies the crank radius and connecting rod length.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/piston_data").execute(*args, **kwargs)
                    def max_crank_angle_step(self, *args, **kwargs):
                        """
                        Specifies maximum crank angle step size.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/max_crank_angle_step").execute(*args, **kwargs)
                    def print_plot_lift(self, *args, **kwargs):
                        """
                        Prints or plot valve lift curve.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/print_plot_lift").execute(*args, **kwargs)
                    def position_starting_mesh(self, *args, **kwargs):
                        """
                        Moves mesh from top dead center to starting crank angle.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/position_starting_mesh").execute(*args, **kwargs)
                    def piston_stroke_cutoff(self, *args, **kwargs):
                        """
                        Specifies the cut off point for in-cylinder piston.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/piston_stroke_cutoff").execute(*args, **kwargs)

                class smoothing_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh smoothing-parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def smooth_from_reference_position(self, *args, **kwargs):
                        """
                        Enables/disables smoothing from a reference position. Such smoothing may produce greater mesh quality consistency for stationary or moving meshes with periodic or quasi-periodic motion, and is only available when the smoothing method is based on diffusion or the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/smooth_from_reference_position").execute(*args, **kwargs)
                    def diffusion_coeff_function(self, *args, **kwargs):
                        """
                        Specifies whether the diffusion coefficient for diffusion-based smoothing is based on the boundary distance or the cell volume.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_function").execute(*args, **kwargs)
                    def diffusion_coeff_parameter(self, *args, **kwargs):
                        """
                        Sets the diffusion coefficient parameter used for diffusion-based smoothing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_parameter").execute(*args, **kwargs)
                    def skew_smooth_all_deforming_boundaries(self, *args, **kwargs):
                        """
                        Enables/disables skewness smoothing for all deforming dynamic boundary zones. This is enabled by default. If disabled, skewness smoothing is only applied to the deforming dynamic boundary zones that have smoothing explicitly enabled or use local face remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_all_deforming_boundaries").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set the verbosity for spring smoothing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/verbosity").execute(*args, **kwargs)
                    def skew_smooth_niter(self, *args, **kwargs):
                        """
                        Sets the number of skewness-based smoothing cycles.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_niter").execute(*args, **kwargs)
                    def boundary_distance_method(self, *args, **kwargs):
                        """
                        Sets the method used to evaluate the boundary distance for the diffusion coefficient calculation, when diffusion-based smoothing is enabled.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/boundary_distance_method").execute(*args, **kwargs)
                    def skew_smooth_cell_skew_max(self, *args, **kwargs):
                        """
                        Sets the skewness threshold, above which cells will be smoothed using the skewness method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_cell_skew_max").execute(*args, **kwargs)
                    def bnd_stiffness_factor(self, *args, **kwargs):
                        """
                        Sets the stiffness factor for springs connected to boundary nodes.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/bnd_stiffness_factor").execute(*args, **kwargs)
                    def bnd_node_relaxation(self, *args, **kwargs):
                        """
                        The boundary node relaxation is used by spring smoothing. The boundary node relaxation allows you to relax the update of the node positions at deforming boundaries. A value of 0 prevents deforming boundary nodes from moving and a value of 1 indicates no under-relaxation.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/bnd_node_relaxation").execute(*args, **kwargs)
                    def diffusion_fvm(self, *args, **kwargs):
                        """
                        Answering yes at the prompt changes the diffusion-based smoothing method to the cell-based finite volume approach that was the default in releases prior to Fluent 15.0. Answering no at the prompt changes the diffusion-based smoothing method to the default node-based finite element method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/diffusion_fvm").execute(*args, **kwargs)
                    def spring_on_simplex_elements(self, *args, **kwargs):
                        """
                        Enable/disable spring-based smoothing for tri/tet elements in mixed element zones.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/spring_on_simplex_elements").execute(*args, **kwargs)
                    def poisson_ratio(self, *args, **kwargs):
                        """
                        Sets the Poisson’s ratio used for smoothing based on the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/poisson_ratio").execute(*args, **kwargs)
                    def convergence_tolerance(self, *args, **kwargs):
                        """
                        Sets the convergence tolerance for spring-based solver.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/convergence_tolerance").execute(*args, **kwargs)
                    def constant_factor(self, *args, **kwargs):
                        """
                        Sets the spring constant relaxation factor.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/constant_factor").execute(*args, **kwargs)
                    def smoothing_method(self, *args, **kwargs):
                        """
                        Specify the smoothing method used by the dynamic mesh model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/smoothing_method").execute(*args, **kwargs)
                    def spring_on_all_elements(self, *args, **kwargs):
                        """
                        Enables/disables spring-based smoothing for all cell shapes; if disabled, the spring-based smoothing is applied based on the setting of the define/dynamic-mesh/controls/smoothing-parameters/spring-on-simplex-shapes? text command.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/spring_on_all_elements").execute(*args, **kwargs)
                    def skew_smooth_face_skew_max(self, *args, **kwargs):
                        """
                        Sets the skewness threshold, above which faces will be smoothed using the skewness method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_face_skew_max").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for spring-based solver.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/max_iter").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for mesh smoothing (FEM).
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/amg_stabilization").execute(*args, **kwargs)
                    def laplace_node_relaxation(self, *args, **kwargs):
                        """
                        Set the Laplace boundary node relaxation factor.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/laplace_node_relaxation").execute(*args, **kwargs)
                    def relative_convergence_tolerance(self, *args, **kwargs):
                        """
                        Sets the relative residual convergence tolerance for smoothing based on diffusion or the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/relative_convergence_tolerance").execute(*args, **kwargs)

                class remeshing_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh remeshing menu to set 	parameters for all remeshing methods.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.prism_controls = self.__class__.prism_controls(path + ["prism_controls"], service)
                        self.sizing_controls = self.__class__.sizing_controls(path + ["sizing_controls"], service)
                        self.prism_layer_parameters = self.__class__.prism_layer_parameters(path + ["prism_layer_parameters"], service)
                        super().__init__(path, service)
                    def remeshing_methods(self, *args, **kwargs):
                        """
                        Enables/disables individual remeshing options as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/remeshing_methods").execute(*args, **kwargs)
                    def sizing_funct_rate(self, *args, **kwargs):
                        """
                        Determines how far from the boundary the increase/decrease happens.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_rate").execute(*args, **kwargs)
                    def length_max(self, *args, **kwargs):
                        """
                        Sets the length threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/length_max").execute(*args, **kwargs)
                    def size_remesh_interval(self, *args, **kwargs):
                        """
                        Sets the interval (in time steps) when remeshing based on size is done for methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/size_remesh_interval").execute(*args, **kwargs)
                    def sizing_function(self, *args, **kwargs):
                        """
                        Enables/disables the sizing function as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_function").execute(*args, **kwargs)
                    def remeshing_after_moving(self, *args, **kwargs):
                        """
                        Enables a second round of remeshing based on the skewness parameters after the boundary has moved as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/remeshing_after_moving").execute(*args, **kwargs)
                    def sizing_funct_resolution(self, *args, **kwargs):
                        """
                        Sets the sizing function resolution with respect to shortest boundary.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_resolution").execute(*args, **kwargs)
                    def cell_skew_max(self, *args, **kwargs):
                        """
                        Sets the cell skewness threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/cell_skew_max").execute(*args, **kwargs)
                    def sizing_funct_variation(self, *args, **kwargs):
                        """
                        Sets the maximum sizing function increase/decrease in the interior.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_variation").execute(*args, **kwargs)
                    def unified_remeshing(self, *args, **kwargs):
                        """
                        Enables/disables unified remeshing, which specifies that an algorithm is used that combines aspects of a variety of remeshing methods. It is applied to triangular or tetrahedral cells and can produce wedge cells in 3D boundary layer meshes. Unified remeshing simplifies the remeshing setup and can provide increased robustness compared to methods-based remeshing, especially for parallel simulations.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/unified_remeshing").execute(*args, **kwargs)
                    def zone_remeshing(self, *args, **kwargs):
                        """
                        Enables/disables the cell zone remeshing method as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/zone_remeshing").execute(*args, **kwargs)
                    def parallel_remeshing(self, *args, **kwargs):
                        """
                        Disables/enables parallel remeshing as part of methods-based remeshing..
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/parallel_remeshing").execute(*args, **kwargs)
                    def length_min(self, *args, **kwargs):
                        """
                        Sets the length threshold below which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/length_min").execute(*args, **kwargs)
                    def poly_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable poly remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/poly_remeshing").execute(*args, **kwargs)
                    def sizing_funct_defaults(self, *args, **kwargs):
                        """
                        Sets sizing function defaults.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_defaults").execute(*args, **kwargs)
                    def face_skew_max(self, *args, **kwargs):
                        """
                        Sets the face skewness threshold above which faces will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/face_skew_max").execute(*args, **kwargs)
                    def retain_size_distribution(self, *args, **kwargs):
                        """
                        Enables/disables the use of local size criteria when marking cells for unified remeshing (in an attempt to maintain the initial mesh size distribution even as the mesh moves), rather than marking cells based on the minimum and maximum length scale values of the cell zone in the initial mesh. Either marking can be overridden if more restrictive values are specified using the define/dynamic-mesh/controls/remeshing-parameters/length-min and define/dynamic-mesh/controls/remeshing-parameters/length-max text commands.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/retain_size_distribution").execute(*args, **kwargs)

                    class prism_controls(TUIMenu):
                        """
                        Enters the dynamic mesh prism controls menu, which provides text commands that can be useful when you want to modify the algorithm that attempts to retain the size distribution during unified remeshing. Each prism control definition is applied to one or more boundary zones, and then affects the height distribution and number of layers of the wedge cells in the adjacent boundary layers.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delete(self, *args, **kwargs):
                            """
                            Deletes an existing prism controls definition.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/delete").execute(*args, **kwargs)
                        def add(self, *args, **kwargs):
                            """
                            Adds a new prism controls definition.   After being prompted for a name, you can enter the following to complete the definition:
                            first-height  Sets the height of the first layer of wedge cells in the boundary layer adjacent to the specified zones.
                            growth-method  Specifies the method used to determine the increase in height of the wedge cell layers beyond the first layer. The only available option is geometric, so that the height of each layer is the height of the previous layer multiplied by the rate.
                            name  Specifies the name of the prism controls definition.
                            nlayers  Sets the number of layers of wedge cells in the boundary layer adjacent to the specified zones.
                            rate  Sets the coefficient for the growth-method used to determine the increase in height of the wedge cell layers beyond the first layer.
                            zones  Specifies all of the boundary zones on which this prism controls definition is applied.
                            Enter q when the definition is complete to return to the text command menu.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/add").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edits an existing prism controls definition. You can revise the fields listed previously for the define/dynamic-mesh/controls/remeshing-parameters/prism-controls/add text command.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/edit").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Prints a list of the existing prism controls definitions in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/list").execute(*args, **kwargs)
                        def list_properties(self, *args, **kwargs):
                            """
                            Prints the properties of an existing prism controls definition of your choice in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/list_properties").execute(*args, **kwargs)

                    class sizing_controls(TUIMenu):
                        """
                        Enters the dynamic mesh sizing controls menu, which provides text commands that can be useful when you want to modify the algorithm that attempts to retain the size distribution during unified remeshing. Each sizing control definition is applied to one or more boundary zones, and then affects the size of the cells throughout the mesh based on their distance from those boundary zone(s) and your settings in the definition.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list(self, *args, **kwargs):
                            """
                            Prints a list of the existing sizing controls definitions in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Deletes an existing sizing controls definition.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/delete").execute(*args, **kwargs)
                        def add(self, *args, **kwargs):
                            """
                            Adds a new sizing controls definition.   After being prompted for a name, you can enter the following to complete the definition:
                            growth-rate  Sets the growth rate of the sizing controls definition.
                            max-length  Sets a maximum length threshold that is used when the type is set to auto or soft.
                            min-length  Sets a maximum length threshold that is used when the type is set to auto.
                            motion  Determines whether the size control definition affects the remeshing based on whether the mesh undergoes motion: auto specifies that it is applied whether or not there is motion; and static specifies that it is only applied if there is no motion.
                            name  Specifies the name of the sizing controls definition.
                            type  Specifies how the sizing is affected by the selected boundary zones: auto specifies that the default size distribution (rather than the initial size distribution in your selected boundary zones) is used, along with your specified max-length and min-length values; soft specifies that the maximum length scale of your selected boundary zones is used, along with your specified min-length value; and meshed specifies that the maximum and minimum length scales of your selected boundary zones are used, in order to respect their initial size distribution. This setting is only relevant if you have more than one sizing controls definition.
                            zones  Specifies all of the boundary zones on which the sizing controls definition is applied.
                            Enter q when the definition is complete to return to the text command menu.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/add").execute(*args, **kwargs)
                        def list_properties(self, *args, **kwargs):
                            """
                            Prints the properties of an existing sizing controls definition of your choice in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list_properties").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edits an existing sizing controls definition. You can revise the fields listed previously for the define/dynamic-mesh/controls/remeshing-parameters/sizing-controls/add text command.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/edit").execute(*args, **kwargs)

                    class prism_layer_parameters(TUIMenu):
                        """
                        Enters the dynamic mesh prism layer parameters menu, where you can define the parameters of the prism layers as part of methods-based remeshing.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def number_of_layers(self, *args, **kwargs):
                            """
                            Sets the number of elements in the prism layer.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/number_of_layers").execute(*args, **kwargs)
                        def growth_rate(self, *args, **kwargs):
                            """
                            Sets the geometric growth rate of the prism layer.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/growth_rate").execute(*args, **kwargs)
                        def first_height(self, *args, **kwargs):
                            """
                            Sets the first cell height in the prism layer.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/first_height").execute(*args, **kwargs)

                class implicit_update_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh implicit update menu. This text command is only available 	when you enable implicit mesh updating using the prompts 	of the define/dynamic-mesh/dynamic-mesh? 	text command.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def motion_relaxation(self, *args, **kwargs):
                        """
                        Specifies a value (within the range of 0 to 1) for the motion relaxation, which is applied during the implicit mesh update.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/implicit_update_parameters/motion_relaxation").execute(*args, **kwargs)
                    def residual_criteria(self, *args, **kwargs):
                        """
                        Specifies the relative residual threshold that is used to check the motion convergence during the implicit mesh update.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/implicit_update_parameters/residual_criteria").execute(*args, **kwargs)
                    def update_interval(self, *args, **kwargs):
                        """
                        Specifies the update interval (that is, the frequency in iterations) at which the mesh is updated within a time step.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/implicit_update_parameters/update_interval").execute(*args, **kwargs)

                class periodic_displacement_parameters(TUIMenu):
                    """
                    Enters the periodic displacement parameters 	menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def create_group(self, *args, **kwargs):
                        """
                        Create Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/create_group").execute(*args, **kwargs)
                    def copy_displacement(self, *args, **kwargs):
                        """
                        Copy Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/copy_displacement").execute(*args, **kwargs)
                    def list_groups(self, *args, **kwargs):
                        """
                        List Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/list_groups").execute(*args, **kwargs)
                    def delete_displacement(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_displacement").execute(*args, **kwargs)
                    def edit_displacement(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/edit_displacement").execute(*args, **kwargs)
                    def create_displacement(self, *args, **kwargs):
                        """
                        Create Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/create_displacement").execute(*args, **kwargs)
                    def delete_all_displacements(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacements.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_displacements").execute(*args, **kwargs)
                    def delete_all_groups(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_groups").execute(*args, **kwargs)
                    def list_displacements(self, *args, **kwargs):
                        """
                        List Periodic Displacements.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/list_displacements").execute(*args, **kwargs)
                    def delete_group(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_group").execute(*args, **kwargs)
                    def edit_group(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/edit_group").execute(*args, **kwargs)
                    def set_active_displacement(self, *args, **kwargs):
                        """
                        Set Active Periodic Displacement in Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/set_active_displacement").execute(*args, **kwargs)

                class layering_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh layering menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def collapse_factor(self, *args, **kwargs):
                        """
                        Sets the factor determining when to collapse dynamic layers.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/layering_parameters/collapse_factor").execute(*args, **kwargs)
                    def split_factor(self, *args, **kwargs):
                        """
                        Sets the factor determining when to split dynamic layers.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/layering_parameters/split_factor").execute(*args, **kwargs)
                    def constant_height(self, *args, **kwargs):
                        """
                        Enables/disables layering based on constant height, else layering based on constant ratio.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/layering_parameters/constant_height").execute(*args, **kwargs)

            class actions(TUIMenu):
                """
                Enters the dynamic mesh action menu, where you can initiate manual remeshing (that is, remeshing without running a calculation).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def remesh_cell_zone(self, *args, **kwargs):
                    """
                    Manually remeshes a cell zone with option to remesh adjacent dynamic face 	zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/actions/remesh_cell_zone").execute(*args, **kwargs)

            class events(TUIMenu):
                """
                Enters the dynamic mesh events menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def import_event_file(self, *args, **kwargs):
                    """
                    Imports dynamic mesh event file.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/events/import_event_file").execute(*args, **kwargs)
                def export_event_file(self, *args, **kwargs):
                    """
                    Exports dynamic mesh events to file.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/events/export_event_file").execute(*args, **kwargs)

        class parameters(TUIMenu):
            """
            Enters the parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.output_parameters = self.__class__.output_parameters(path + ["output_parameters"], service)
                self.list_parameters = self.__class__.list_parameters(path + ["list_parameters"], service)
                self.input_parameters = self.__class__.input_parameters(path + ["input_parameters"], service)
                super().__init__(path, service)
            def enable_in_TUI(self, *args, **kwargs):
                """
                Enables/disables parameters in the text user interface.
                """
                return PyMenu(self.service, "/define/parameters/enable_in_TUI").execute(*args, **kwargs)

            class output_parameters(TUIMenu):
                """
                Enters the output-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def print_to_console(self, *args, **kwargs):
                    """
                    Displays parameter value in the console.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/print_to_console").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Writes parameter value to file.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/write_to_file").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Creates an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/create").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/edit").execute(*args, **kwargs)
                def rename(self, *args, **kwargs):
                    """
                    Renames an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/rename").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/delete").execute(*args, **kwargs)
                def write_all_to_file(self, *args, **kwargs):
                    """
                    Writes all parameter values to file.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/write_all_to_file").execute(*args, **kwargs)
                def print_all_to_console(self, *args, **kwargs):
                    """
                    Displays all parameter values in the console.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/print_all_to_console").execute(*args, **kwargs)

            class list_parameters(TUIMenu):
                """
                Enter list-param menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def output_parameters(self, *args, **kwargs):
                    """
                    List all output parameters.
                    """
                    return PyMenu(self.service, "/define/parameters/list_parameters/output_parameters").execute(*args, **kwargs)
                def input_parameters(self, *args, **kwargs):
                    """
                    List all input parameters.
                    """
                    return PyMenu(self.service, "/define/parameters/list_parameters/input_parameters").execute(*args, **kwargs)

            class input_parameters(TUIMenu):
                """
                Enters the input-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advance = self.__class__.advance(path + ["advance"], service)
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an input parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/input_parameters/delete").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an input parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/input_parameters/edit").execute(*args, **kwargs)

                class advance(TUIMenu):
                    """
                    Define custom variable to use input parameter.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete(self, *args, **kwargs):
                        """
                        Delete selected custom-input-parameters.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/delete").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List of custom-input-parameters.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/list").execute(*args, **kwargs)
                    def use_in(self, *args, **kwargs):
                        """
                        Use input parameter in solver-udf or in scheme-procedure.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/use_in").execute(*args, **kwargs)

        class curvilinear_coordinate_system(TUIMenu):
            """
            Curvilinear Coordinate System.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def display_settings(self, *args, **kwargs):
                """
                Display settings for Curvilinear Coordinate System.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/display_settings").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an existing curvilinear coordinate system.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/edit").execute(*args, **kwargs)
            def new(self, *args, **kwargs):
                """
                Define a new curvilinear coordinate system.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/new").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display Curvilinear Coordinate System.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/display").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete Curvilinear Coordinate System.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/delete").execute(*args, **kwargs)
            def calculation_settings(self, *args, **kwargs):
                """
                Define Settings for curvilinear coordinate system.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/calculation_settings").execute(*args, **kwargs)

        class reference_frames(TUIMenu):
            """
            Enters the reference frames menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of the reference frame you specify.
                """
                return PyMenu(self.service, "/define/reference_frames/list_properties").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays the reference frame you specify.
                """
                return PyMenu(self.service, "/define/reference_frames/display").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Allows you to edit a reference frame.
                """
                return PyMenu(self.service, "/define/reference_frames/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes the reference frame you specify.
                """
                return PyMenu(self.service, "/define/reference_frames/delete").execute(*args, **kwargs)
            def display_edit(self, *args, **kwargs):
                """
                Display and edit reference frame from graphics.
                """
                return PyMenu(self.service, "/define/reference_frames/display_edit").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a new reference frame.
                """
                return PyMenu(self.service, "/define/reference_frames/add").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all of the reference frames.
                """
                return PyMenu(self.service, "/define/reference_frames/list").execute(*args, **kwargs)
            def hide(self, *args, **kwargs):
                """
                Removes the specified reference frame from the graphics window.
                """
                return PyMenu(self.service, "/define/reference_frames/hide").execute(*args, **kwargs)

        class phases(TUIMenu):
            """
            Enters the phases menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                super().__init__(path, service)

            class set_domain_properties(TUIMenu):
                """
                Enters the menu to set phase domain properties.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                    super().__init__(path, service)
                def change_phases_names(self, *args, **kwargs):
                    """
                    Allows you to change the names of all the phases in your simulation.
                    """
                    return PyMenu(self.service, "/define/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)
                def phase_domains(self, *args, **kwargs):
                    """
                    Enters the menu to select a specific phase.
                    """
                    return PyMenu(self.service, "/define/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)

                class interaction_domain(TUIMenu):
                    """
                    Enters the menu to set the interaction domain 	properties.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.numerics = self.__class__.numerics(path + ["numerics"], service)
                        self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                        self.forces = self.__class__.forces(path + ["forces"], service)
                        self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                        self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                        super().__init__(path, service)

                    class numerics(TUIMenu):
                        """
                        Enters the menu to set numerics models. This menu is available for multiphase models with the sharp-dispersed and phase localized discretization interface modeling options (set in define/models/multiphase/interface-modeling-options).
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            super().__init__(path, service)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/visc_disp_factor").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/cavitation").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enters the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specifies the slope limiter to set a specific discretization scheme for each phase pair. A value of 0 corresponds to first order upwind, a value of 1 corresponds to second order upwind, a value of 2 applies the compressive scheme, and a value between 0 and 2 corresponds to a blended scheme. This option is available only wheninterphase-discr? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enables/disables phase localized compressive scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/slope_limiter").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/virtual_mass").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_discr").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/cavitation").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_montoya").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/jump_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/cavitation").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_discr").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_model_type").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift_montoya").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit").execute(*args, **kwargs)

                    class model_transition(TUIMenu):
                        """
                        Enters the menu to set model transition mechanisms.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            super().__init__(path, service)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Sets the VOF-to-DPM model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
       