from unittest.mock import AsyncMock

from aiogram import Bot

from .types import TOKEN


def initialize_bot() -> Bot:
    """
    Get bot with plug (AsyncMock) for main methods
    """
    _bot = Bot(TOKEN)

    _bot.add_sticker_to_set = AsyncMock(name="add_sticker_to_set")
    _bot.answer_callback_query = AsyncMock(name="answer_callback_query")
    _bot.answer_inline_query = AsyncMock(name="answer_inline_query")
    _bot.answer_pre_checkout_query = AsyncMock(name="answer_pre_checkout_query")
    _bot.answer_shipping_query = AsyncMock(name="answer_shipping_query")
    _bot.answer_web_app_query = AsyncMock(name="answer_web_app_query")
    _bot.approve_chat_join_request = AsyncMock(name="approve_chat_join_request")
    _bot.ban_chat_member = AsyncMock(name="ban_chat_member")
    _bot.ban_chat_sender_chat = AsyncMock(name="ban_chat_sender_chat")
    _bot.check_auth_widget = AsyncMock(name="check_auth_widget")
    _bot.copy_message = AsyncMock(name="copy_message")
    _bot.create_chat_invite_link = AsyncMock(name="create_chat_invite_link")
    _bot.create_invoice_link = AsyncMock(name="create_invoice_link")
    _bot.create_new_sticker_set = AsyncMock(name="create_new_sticker_set")
    _bot.decline_chat_join_request = AsyncMock(name="decline_chat_join_request")
    _bot.delete_chat_photo = AsyncMock(name="delete_chat_photo")
    _bot.delete_chat_sticker_set = AsyncMock(name="delete_chat_sticker_set")
    _bot.delete_message = AsyncMock(name="delete_message")
    _bot.delete_my_commands = AsyncMock(name="delete_my_commands")
    _bot.delete_sticker_from_set = AsyncMock(name="delete_sticker_from_set")
    _bot.delete_webhook = AsyncMock(name="delete_webhook")
    _bot.download_file = AsyncMock(name="download_file")
    _bot.download_file_by_id = AsyncMock(name="download_file_by_id")
    _bot.edit_chat_invite_link = AsyncMock(name="edit_chat_invite_link")
    _bot.edit_message_caption = AsyncMock(name="edit_message_caption")
    _bot.edit_message_live_location = AsyncMock(name="edit_message_live_location")
    _bot.edit_message_media = AsyncMock(name="edit_message_media")
    _bot.edit_message_reply_markup = AsyncMock(name="edit_message_reply_markup")
    _bot.edit_message_text = AsyncMock(name="edit_message_text")
    _bot.export_chat_invite_link = AsyncMock(name="export_chat_invite_link")
    _bot.forward_message = AsyncMock(name="forward_message")
    _bot.get = AsyncMock(name="get")
    _bot.get_chat = AsyncMock(name="get_chat")
    _bot.get_chat_administrators = AsyncMock(name="get_chat_administrators")
    _bot.get_chat_member = AsyncMock(name="get_chat_member")
    _bot.get_chat_member_count = AsyncMock(name="get_chat_member_count")
    _bot.get_chat_members_count = AsyncMock(name="get_chat_members_count")
    _bot.get_chat_menu_button = AsyncMock(name="get_chat_menu_button")
    _bot.get_current = AsyncMock(name="get_current")
    _bot.get_custom_emoji_stickers = AsyncMock(name="get_custom_emoji_stickers")
    _bot.get_file = AsyncMock(name="get_file")
    _bot.get_file_url = AsyncMock(name="get_file_url")
    _bot.get_game_high_scores = AsyncMock(name="get_game_high_scores")
    _bot.get_me = AsyncMock(name="get_me")
    _bot.get_my_commands = AsyncMock(name="get_my_commands")
    _bot.get_my_default_administrator_rights = AsyncMock(name="get_my_default_administrator_rights")
    _bot.get_new_session = AsyncMock(name="get_new_session")
    _bot.get_session = AsyncMock(name="get_session")
    _bot.get_sticker_set = AsyncMock(name="get_sticker_set")
    _bot.get_updates = AsyncMock(name="get_updates")
    _bot.get_user_profile_photos = AsyncMock(name="get_user_profile_photos")
    _bot.get_webhook_info = AsyncMock(name="get_webhook_info")
    _bot.kick_chat_member = AsyncMock(name="kick_chat_member")
    _bot.leave_chat = AsyncMock(name="leave_chat")
    _bot.pin_chat_message = AsyncMock(name="pin_chat_message")
    _bot.promote_chat_member = AsyncMock(name="promote_chat_member")
    _bot.request = AsyncMock(name="request")
    _bot.request_timeout = AsyncMock(name="request_timeout")
    _bot.restrict_chat_member = AsyncMock(name="restrict_chat_member")
    _bot.revoke_chat_invite_link = AsyncMock(name="revoke_chat_invite_link")
    _bot.send_animation = AsyncMock(name="send_animation")
    _bot.send_audio = AsyncMock(name="send_audio")
    _bot.send_chat_action = AsyncMock(name="send_chat_action")
    _bot.send_contact = AsyncMock(name="send_contact")
    _bot.send_dice = AsyncMock(name="send_dice")
    _bot.send_document = AsyncMock(name="send_document")
    _bot.send_file = AsyncMock(name="send_file")
    _bot.send_game = AsyncMock(name="send_game")
    _bot.send_invoice = AsyncMock(name="send_invoice")
    _bot.send_location = AsyncMock(name="send_location")
    _bot.send_media_group = AsyncMock(name="send_media_group")
    _bot.send_message = AsyncMock(name="send_message")
    _bot.send_photo = AsyncMock(name="send_photo")
    _bot.send_poll = AsyncMock(name="send_poll")
    _bot.send_sticker = AsyncMock(name="send_sticker")
    _bot.send_venue = AsyncMock(name="send_venue")
    _bot.send_video = AsyncMock(name="send_video")
    _bot.send_video_note = AsyncMock(name="send_video_note")
    _bot.send_voice = AsyncMock(name="send_voice")
    _bot.set_chat_administrator_custom_title = AsyncMock(name="set_chat_administrator_custom_title")
    _bot.set_chat_description = AsyncMock(name="set_chat_description")
    _bot.set_chat_menu_button = AsyncMock(name="set_chat_menu_button")
    _bot.set_chat_permissions = AsyncMock(name="set_chat_permissions")
    _bot.set_chat_photo = AsyncMock(name="set_chat_photo")
    _bot.set_chat_sticker_set = AsyncMock(name="set_chat_sticker_set")
    _bot.set_chat_title = AsyncMock(name="set_chat_title")
    _bot.set_current = AsyncMock(name="set_current")
    _bot.set_game_score = AsyncMock(name="set_game_score")
    _bot.set_my_commands = AsyncMock(name="set_my_commands")
    _bot.set_my_default_administrator_rights = AsyncMock(name="set_my_default_administrator_rights")
    _bot.set_passport_data_errors = AsyncMock(name="set_passport_data_errors")
    _bot.set_sticker_position_in_set = AsyncMock(name="set_sticker_position_in_set")
    _bot.set_sticker_set_thumb = AsyncMock(name="set_sticker_set_thumb")
    _bot.set_webhook = AsyncMock(name="set_webhook")
    _bot.stop_message_live_location = AsyncMock(name="stop_message_live_location")
    _bot.stop_poll = AsyncMock(name="stop_poll")
    _bot.unban_chat_member = AsyncMock(name="unban_chat_member")
    _bot.unban_chat_sender_chat = AsyncMock(name="unban_chat_sender_chat")
    _bot.unpin_all_chat_messages = AsyncMock(name="unpin_all_chat_messages")
    _bot.unpin_chat_message = AsyncMock(name="unpin_chat_message")
    _bot.upload_sticker_file = AsyncMock(name="upload_sticker_file")

    return _bot
