# -*- coding: utf-8 -*-
"""
Tencent is pleased to support the open source community by making 蓝鲸智云PaaS平台社区版 (BlueKing PaaS Community
Edition) available.
Copyright (C) 2017-2021 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the MIT License (the "License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://opensource.org/licenses/MIT
Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.
"""
from django.contrib.auth import get_user_model

from .base import LifeCycleHooksMixin


class SuperUserMixin(LifeCycleHooksMixin):
    MOCK_SUPERUSER_NAME = "admin"
    MOCK_SUPERUSER_PASSWORD = "admin"

    @classmethod
    def set_up_test_data(cls):
        user_model = get_user_model()
        try:
            cls.superuser = user_model.objects.get(username=cls.MOCK_SUPERUSER_NAME)
        except user_model.DoesNotExist:
            cls.superuser = user_model.objects.create(
                username=cls.MOCK_SUPERUSER_NAME,
                password=cls.MOCK_SUPERUSER_PASSWORD,
                is_superuser=True,
                is_staff=True,
                is_active=True,
            )

    def set_up(self):
        self.client.force_login(user=self.superuser)

    def tear_down(self):
        self.client.logout()
