/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl.pool;

import java.net.Inet4Address;
import java.util.Arrays;
import java.util.Random;
import javax.transaction.xa.Xid;

public class JDBCXID
implements Xid {
    private static final int UXID_FORMAT_ID = 65261;
    private static byte[] s_localIp = null;
    private static int s_txnSequenceNumber = 0;
    int formatID;
    byte[] txID;
    byte[] txBranch;
    int hash;
    boolean hashComputed;

    public JDBCXID(int formatID, byte[] txID, byte[] txBranch) {
        this.formatID = formatID;
        this.txID = txID;
        this.txBranch = txBranch;
    }

    private static int nextTxnSequenceNumber() {
        return ++s_txnSequenceNumber;
    }

    private static byte[] getLocalIp() {
        if (null == s_localIp) {
            try {
                s_localIp = Inet4Address.getLocalHost().getAddress();
            }
            catch (Exception ex) {
                s_localIp = new byte[]{127, 0, 0, 1};
            }
        }
        return s_localIp;
    }

    public static Xid getUniqueXid(int threadId) {
        Random random = new Random(System.currentTimeMillis());
        int txnSequenceNumberValue = JDBCXID.nextTxnSequenceNumber();
        int threadIdValue = threadId;
        int randomValue = random.nextInt();
        byte[] globalTransactionId = new byte[64];
        byte[] branchQualifier = new byte[64];
        byte[] localIp = JDBCXID.getLocalIp();
        System.arraycopy(localIp, 0, globalTransactionId, 0, 4);
        System.arraycopy(localIp, 0, branchQualifier, 0, 4);
        for (int i = 0; i <= 3; ++i) {
            globalTransactionId[i + 4] = (byte)(txnSequenceNumberValue % 256);
            branchQualifier[i + 4] = (byte)(txnSequenceNumberValue % 256);
            txnSequenceNumberValue >>= 8;
            globalTransactionId[i + 8] = (byte)(threadIdValue % 256);
            branchQualifier[i + 8] = (byte)(threadIdValue % 256);
            threadIdValue >>= 8;
            globalTransactionId[i + 12] = (byte)(randomValue % 256);
            branchQualifier[i + 12] = (byte)(randomValue % 256);
            randomValue >>= 8;
        }
        return new JDBCXID(65261, globalTransactionId, branchQualifier);
    }

    @Override
    public int getFormatId() {
        return this.formatID;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.txID;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.txBranch;
    }

    public int hashCode() {
        if (!this.hashComputed) {
            this.hash = 7;
            this.hash = 83 * this.hash + this.formatID;
            this.hash = 83 * this.hash + Arrays.hashCode(this.txID);
            this.hash = 83 * this.hash + Arrays.hashCode(this.txBranch);
            this.hashComputed = true;
        }
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other instanceof Xid) {
            Xid o = (Xid)other;
            return this.formatID == o.getFormatId() && Arrays.equals(this.txID, o.getGlobalTransactionId()) && Arrays.equals(this.txBranch, o.getBranchQualifier());
        }
        return false;
    }

    public String toString() {
        int hexVal;
        int i;
        StringBuffer sb = new StringBuffer(512);
        sb.append("formatId=").append(this.getFormatId());
        sb.append(" globalTransactionId(").append(this.txID.length).append(")={0x");
        for (i = 0; i < this.txID.length; ++i) {
            hexVal = this.txID[i] & 0xFF;
            if (hexVal < 16) {
                sb.append("0").append(Integer.toHexString(this.txID[i] & 0xFF));
            }
            sb.append(Integer.toHexString(this.txID[i] & 0xFF));
        }
        sb.append("} branchQualifier(").append(this.txBranch.length).append("))={0x");
        for (i = 0; i < this.txBranch.length; ++i) {
            hexVal = this.txBranch[i] & 0xFF;
            if (hexVal < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(this.txBranch[i] & 0xFF));
        }
        sb.append("}");
        return sb.toString();
    }
}

