/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util.preprocessor;

import com.datapps.linkoopdb.jdbc.util.preprocessor.BasicResolver;
import com.datapps.linkoopdb.jdbc.util.preprocessor.Defines;
import com.datapps.linkoopdb.jdbc.util.preprocessor.Document;
import com.datapps.linkoopdb.jdbc.util.preprocessor.IResolver;
import com.datapps.linkoopdb.jdbc.util.preprocessor.Line;
import com.datapps.linkoopdb.jdbc.util.preprocessor.Option;
import com.datapps.linkoopdb.jdbc.util.preprocessor.PreprocessorException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public class Preprocessor {
    static final int CONDITION_NONE = 0;
    static final int CONDITION_ARMED = 1;
    static final int CONDITION_IN_TRUE = 2;
    static final int CONDITION_TRIGGERED = 3;
    static final Integer[] STATES = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3)};
    private String documentPath;
    private String encoding;
    private int options;
    private IResolver resolver;
    private Document document;
    private Defines defines;
    private Stack stack;
    private int state;

    private Preprocessor(String documentPath, String encoding, int options, IResolver resolver, String predefined) throws PreprocessorException {
        if (resolver == null) {
            File parentDir = new File(documentPath).getParentFile();
            this.resolver = new BasicResolver(parentDir);
        } else {
            this.resolver = resolver;
        }
        if (predefined == null || predefined.trim().length() == 0) {
            this.defines = new Defines();
        } else {
            predefined = this.resolver.resolveProperties(predefined);
            this.defines = new Defines(predefined);
        }
        this.documentPath = documentPath;
        this.encoding = encoding;
        this.options = options;
        this.document = new Document();
        this.stack = new Stack();
        this.state = 0;
    }

    private Preprocessor(Preprocessor other, Document include) {
        this.document = include;
        this.encoding = other.encoding;
        this.stack = new Stack();
        this.state = 0;
        this.options = other.options;
        this.documentPath = other.documentPath;
        this.resolver = other.resolver;
        this.defines = other.defines;
    }

    public static void preprocessBatch(File sourceDir, File targetDir, String[] fileNames, String altExt, String encoding, int options, String defines, IResolver resolver) throws PreprocessorException {
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            try {
                Preprocessor.preprocessFile(sourceDir, targetDir, fileName, altExt, encoding, options, defines, resolver);
                continue;
            }
            catch (PreprocessorException ppe) {
                if (!Option.isVerbose(options)) {
                    Preprocessor.log(fileName + " ... not modified, " + ppe.getMessage());
                }
                throw ppe;
            }
        }
    }

    public static void preprocessFile(File sourceDir, File targetDir, String fileName, String altExt, String encoding, int options, String defines, IResolver resolver) throws PreprocessorException {
        boolean rewrite;
        String sourcePath = Preprocessor.translatePath(sourceDir, fileName, null);
        String targetPath = Preprocessor.translatePath(targetDir, fileName, altExt);
        File targetFile = new File(targetPath);
        File backupFile = new File(targetPath + "~");
        boolean sameDir = sourceDir.equals(targetDir);
        boolean sameExt = altExt == null;
        boolean verbose = Option.isVerbose(options);
        boolean testOnly = Option.isTestOnly(options);
        boolean backup = Option.isBackup(options);
        Preprocessor preprocessor = new Preprocessor(sourcePath, encoding, options, resolver, defines);
        if (verbose) {
            Preprocessor.log("Reading \"" + sourcePath + "\"");
        }
        preprocessor.loadDocument();
        boolean modified = preprocessor.preprocess();
        boolean bl = rewrite = modified || !sameDir || !sameExt;
        if (!rewrite) {
            if (verbose) {
                Preprocessor.log(fileName + " ... not modified");
            }
            return;
        }
        if (verbose) {
            Preprocessor.log(fileName + " ... modified");
        }
        if (testOnly) {
            return;
        }
        try {
            targetFile.getParentFile().mkdirs();
        }
        catch (Exception e) {
            throw new PreprocessorException("mkdirs failed \"" + targetFile + "\": " + e);
        }
        backupFile.delete();
        if (targetFile.exists() && !targetFile.renameTo(backupFile)) {
            throw new PreprocessorException("Rename failed: \"" + targetFile + "\" => \"" + backupFile + "\"");
        }
        if (verbose) {
            Preprocessor.log("Writing \"" + targetPath + "\"");
        }
        preprocessor.saveDocument(targetPath);
        if (!backup) {
            backupFile.delete();
        }
    }

    private static String translatePath(File dir, String fileName, String ext) {
        return new StringBuffer(dir.getPath()).append(File.separatorChar).append(Preprocessor.translateFileExtension(fileName, ext)).toString();
    }

    private static String translateFileExtension(String fileName, String ext) {
        if (ext != null) {
            int pos = fileName.lastIndexOf(46);
            fileName = pos < 0 ? fileName + ext : fileName.substring(0, pos) + ext;
        }
        return fileName;
    }

    private static void log(Object toLog) {
        System.out.println(toLog);
    }

    private boolean preprocess() throws PreprocessorException {
        this.stack.clear();
        this.state = 0;
        if (!this.document.contains("//#")) {
            return false;
        }
        Document originalDocument = new Document(this.document);
        this.preprocessImpl();
        if (this.state != 0) {
            throw new PreprocessorException("Missing final #endif");
        }
        if (Option.isFilter(this.options)) {
            for (int i = this.document.size() - 1; i >= 0; --i) {
                Line line = this.resolveLine(this.document.getSourceLine(i));
                if (line.isType(14)) continue;
                this.document.deleteSourceLine(i);
            }
        }
        return !this.document.equals(originalDocument);
    }

    private void preprocessImpl() throws PreprocessorException {
        boolean includeCount = false;
        int lineCount = 0;
        block6: while (lineCount < this.document.size()) {
            try {
                Line line = this.resolveLine(this.document.getSourceLine(lineCount));
                switch (line.getType()) {
                    case 12: {
                        lineCount = this.processInclude(lineCount, line);
                        continue block6;
                    }
                    case 8: 
                    case 14: {
                        this.document.setSourceLine(lineCount, this.toSourceLine(line));
                        if (Option.isVerbose(this.options)) {
                            Preprocessor.log((this.isHidingLines() ? "Commented: " : "Uncommented: ") + line);
                        }
                        ++lineCount;
                        continue block6;
                    }
                }
                this.processDirective(line);
                ++lineCount;
            }
            catch (PreprocessorException ex) {
                throw new PreprocessorException(ex.getMessage() + " at line " + (lineCount + 1) + " in \"" + this.documentPath + "\"");
            }
        }
    }

    private void processIf(boolean condition) {
        this.statePush();
        this.state = this.isHidingLines() ? 3 : (condition ? 2 : 1);
    }

    private void processElseIf(boolean condition) throws PreprocessorException {
        switch (this.state) {
            case 0: {
                throw new PreprocessorException("Unexpected #elif");
            }
            case 1: {
                if (!condition) break;
                this.state = 2;
                break;
            }
            case 2: {
                this.state = 3;
            }
        }
    }

    private void processElse() throws PreprocessorException {
        switch (this.state) {
            case 0: {
                throw new PreprocessorException("Unexpected #else");
            }
            case 1: {
                this.state = 2;
                break;
            }
            case 2: {
                this.state = 3;
            }
        }
    }

    private void processEndIf() throws PreprocessorException {
        if (this.state == 0) {
            throw new PreprocessorException("Unexpected #endif");
        }
        this.statePop();
    }

    private void processDirective(Line line) throws PreprocessorException {
        switch (line.getType()) {
            case 1: {
                if (this.isHidingLines()) break;
                this.defines.defineSingle(line.getArguments());
                break;
            }
            case 13: {
                if (this.isHidingLines()) break;
                this.defines.undefine(line.getArguments());
                break;
            }
            case 9: {
                this.processIf(this.defines.evaluate(line.getArguments()));
                break;
            }
            case 10: {
                this.processIf(this.defines.isDefined(line.getArguments()));
                break;
            }
            case 11: {
                this.processIf(!this.defines.isDefined(line.getArguments()));
                break;
            }
            case 2: {
                this.processElseIf(this.defines.evaluate(line.getArguments()));
                break;
            }
            case 3: {
                this.processElseIf(this.defines.isDefined(line.getArguments()));
                break;
            }
            case 4: {
                this.processElseIf(!this.defines.isDefined(line.getArguments()));
                break;
            }
            case 5: {
                this.processElse();
                break;
            }
            case 6: {
                this.processEndIf();
                break;
            }
            default: {
                throw new PreprocessorException("Unhandled line type: " + line);
            }
        }
    }

    private int processInclude(int lineCount, Line line) throws PreprocessorException {
        String path = this.resolvePath(line.getArguments());
        boolean hidden = this.isHidingLines();
        ++lineCount;
        while (lineCount < this.document.size() && !(line = this.resolveLine(this.document.getSourceLine(lineCount))).isType(7)) {
            this.document.deleteSourceLine(lineCount);
        }
        if (!line.isType(7)) {
            throw new PreprocessorException("Missing #endinclude");
        }
        if (!hidden) {
            Document include = this.loadInclude(path);
            Preprocessor preprocessor = new Preprocessor(this, include);
            preprocessor.preprocess();
            int count = include.size();
            for (int i = 0; i < count; ++i) {
                String sourceLine = include.getSourceLine(i);
                if (!this.resolveLine(sourceLine).isType(14)) continue;
                this.document.insertSourceLine(lineCount++, sourceLine);
            }
        }
        return ++lineCount;
    }

    private boolean isHidingLines() {
        switch (this.state) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private void statePush() {
        this.stack.push(STATES[this.state]);
    }

    private void statePop() {
        this.state = (Integer)this.stack.pop();
    }

    private Line resolveLine(String line) throws PreprocessorException {
        return new Line(this.resolver.resolveProperties(line));
    }

    private String resolvePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path: null");
        }
        String value = this.resolver.resolveProperties(path);
        File file = this.resolver.resolveFile(value);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            return file.getAbsolutePath();
        }
    }

    private String toSourceLine(Line line) {
        return this.isHidingLines() ? (Option.isIndent(this.options) ? line.indent + "//# " + line.text : "//# " + line.indent + line.text) : line.indent + line.text;
    }

    private File toCanonicalOrAbsoluteFile(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            path = new File(this.documentPath).getParent() + File.separatorChar + path;
            file = new File(path);
        }
        try {
            return file.getCanonicalFile();
        }
        catch (Exception e) {
            return file.getAbsoluteFile();
        }
    }

    private Document loadInclude(String path) throws PreprocessorException {
        Document include = new Document();
        File file = this.toCanonicalOrAbsoluteFile(path);
        try {
            return include.load(file, this.encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PreprocessorException("Unsupported encoding \"" + this.encoding + "\" loading include \"" + file + "\"");
        }
        catch (IOException ioe) {
            throw new PreprocessorException("Unable to load include \"" + file + "\": " + ioe);
        }
    }

    private void loadDocument() throws PreprocessorException {
        try {
            this.document.load(this.documentPath, this.encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PreprocessorException("Unsupported encoding \"" + this.encoding + "\" reading file \"" + this.documentPath + "\"");
        }
        catch (IOException ioe) {
            throw new PreprocessorException("Unable to read file \"" + this.documentPath + "\": " + ioe);
        }
    }

    private void saveDocument(Object target) throws PreprocessorException {
        try {
            if (this.document.size() > 0) {
                this.document.save(target, this.encoding);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new PreprocessorException("Unsupported encoding \"" + this.encoding + "\" writing \"" + target + "\"");
        }
        catch (IOException ioe) {
            throw new PreprocessorException("Unable to write to \"" + target + "\": " + ioe);
        }
    }
}

