# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Body(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'requestor': 'str',
        'parsed_tag_limit': 'int',
        'emv_details_list': 'list[Tssv2transactionsemvTagDetailsEmvDetailsList]'
    }

    attribute_map = {
        'requestor': 'requestor',
        'parsed_tag_limit': 'parsedTagLimit',
        'emv_details_list': 'emvDetailsList'
    }

    def __init__(self, requestor=None, parsed_tag_limit=None, emv_details_list=None):
        """
        Body - a model defined in Swagger
        """

        self._requestor = None
        self._parsed_tag_limit = None
        self._emv_details_list = None

        self.requestor = requestor
        if parsed_tag_limit is not None:
          self.parsed_tag_limit = parsed_tag_limit
        self.emv_details_list = emv_details_list

    @property
    def requestor(self):
        """
        Gets the requestor of this Body.
        Identifies the service requesting parsing 

        :return: The requestor of this Body.
        :rtype: str
        """
        return self._requestor

    @requestor.setter
    def requestor(self, requestor):
        """
        Sets the requestor of this Body.
        Identifies the service requesting parsing 

        :param requestor: The requestor of this Body.
        :type: str
        """
        if requestor is None:
            raise ValueError("Invalid value for `requestor`, must not be `None`")

        self._requestor = requestor

    @property
    def parsed_tag_limit(self):
        """
        Gets the parsed_tag_limit of this Body.
        Number of tags to parse for each EMV tag string provided. 

        :return: The parsed_tag_limit of this Body.
        :rtype: int
        """
        return self._parsed_tag_limit

    @parsed_tag_limit.setter
    def parsed_tag_limit(self, parsed_tag_limit):
        """
        Sets the parsed_tag_limit of this Body.
        Number of tags to parse for each EMV tag string provided. 

        :param parsed_tag_limit: The parsed_tag_limit of this Body.
        :type: int
        """

        self._parsed_tag_limit = parsed_tag_limit

    @property
    def emv_details_list(self):
        """
        Gets the emv_details_list of this Body.
        An array of objects, each containing a requestId and the corresponding emvRequestCombinedTags 

        :return: The emv_details_list of this Body.
        :rtype: list[Tssv2transactionsemvTagDetailsEmvDetailsList]
        """
        return self._emv_details_list

    @emv_details_list.setter
    def emv_details_list(self, emv_details_list):
        """
        Sets the emv_details_list of this Body.
        An array of objects, each containing a requestId and the corresponding emvRequestCombinedTags 

        :param emv_details_list: The emv_details_list of this Body.
        :type: list[Tssv2transactionsemvTagDetailsEmvDetailsList]
        """
        if emv_details_list is None:
            raise ValueError("Invalid value for `emv_details_list`, must not be `None`")

        self._emv_details_list = emv_details_list

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Body):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
