"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const render_options_1 = require("projen/lib/javascript/render-options");
const synth_1 = require("projen/lib/util/synth");
const src_1 = require("../src");
describe("PDK Pipeline TS Unit Tests", () => {
    it("Defaults", () => {
        const project = new src_1.PDKPipelineTsProject({
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "Defaults",
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("projenrc synth correctly", () => {
        const project = new src_1.PDKPipelineTsProject(render_options_1.renderProjenInitOptions("@aws-prototyping-sdk/pipeline.PDKPipelineTsProject", {
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "ProjenRc",
        }));
        expect(synth_1.synthSnapshot(project)[".projenrc.ts"]).toMatchSnapshot();
    });
    it("With Context", () => {
        const project = new src_1.PDKPipelineTsProject({
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "WithContext",
            context: {
                sonarqubeScannerConfig: {
                    sonarqubeEndpoint: "https://my.endpoint",
                    sonarqubeAuthorizedGroup: "group",
                    sonarqubeDefaultProfileOrGateName: "default",
                    sonarqubeSpecificProfileOrGateName: "specific",
                    sonarqubeProjectName: "WithContext",
                    sonarqubeTags: ["sample"],
                    preArchiveCommands: ["echo here"],
                },
            },
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("Custom AppEntrypoint", () => {
        const project = new src_1.PDKPipelineTsProject({
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "CustomAppEntrypoint",
            appEntrypoint: "updated.ts",
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
});
//# sourceMappingURL=data:application/json;base64,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