"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebappConfig = void 0;
const path_1 = require("path");
const config_file_1 = require("../config-file");
class WebappConfig {
    constructor(props) {
        this.props = props;
        this.file = new config_file_1.ConfigFile('config.json', JSON.stringify(this.frontendConfig));
    }
    get frontendConfig() {
        var _a;
        return {
            packageLinks: this.packageLinks,
            packageTags: this.packageTags,
            featuredPackages: this.featuredPackages,
            packageStats: (_a = this.props.showPackageStats) !== null && _a !== void 0 ? _a : true,
            featureFlags: this.props.featureFlags,
            categories: this.props.categories,
            debugInfo: this.debugInfo,
        };
    }
    get packageLinks() {
        var _a;
        const packageLinks = (_a = this.props.packageLinks) !== null && _a !== void 0 ? _a : [];
        // remove allowed domains from frontend config
        return packageLinks.map(({ allowedDomains, ...rest }) => rest);
    }
    get packageTags() {
        var _a;
        const packageTags = (_a = this.props.packageTags) !== null && _a !== void 0 ? _a : [];
        // remove conditional logic from frontend config
        return packageTags.map(({ condition, ...rest }) => rest);
    }
    get featuredPackages() {
        var _a;
        const config = (_a = this.props.featuredPackages) !== null && _a !== void 0 ? _a : {
            sections: [
                {
                    name: 'Recently updated',
                    showLastUpdated: 10,
                },
            ],
        };
        for (const section of config.sections) {
            if ((section.showPackages !== undefined && section.showLastUpdated !== undefined) ||
                (section.showPackages === undefined && section.showLastUpdated === undefined)) {
                throw new Error('Exactly one of \'showPackages\' and \'showPackages\' should be provided.');
            }
        }
        return config;
    }
    get debugInfo() {
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const packageJson = require(path_1.join('..', '..', 'package.json'));
        return {
            constructHubVersion: packageJson.version,
            constructHubWebappVersion: packageJson.devDependencies['construct-hub-webapp'],
        };
    }
}
exports.WebappConfig = WebappConfig;
//# sourceMappingURL=data:application/json;base64,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