"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3ToStepFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_stepfunctions_1 = require("@aws-solutions-constructs/aws-s3-stepfunctions");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
class S3ToStepFunction extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the S3ToStepFunction class.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const convertedProps = { ...props };
        // W (for 'wrapped') is added to the id so that the id's of the constructs with the old and new names don't collide
        // If this character pushes you beyond the 64 character limit, just import the new named construct and instantiate
        // it in place of the older named version. They are functionally identical, aside from the types no other changes
        // will be required.  (eg - new S3ToStepfunctions instead of S3ToStepFunction)
        const wrappedConstruct = new aws_s3_stepfunctions_1.S3ToStepfunctions(this, `${id}W`, convertedProps);
        this.stateMachine = wrappedConstruct.stateMachine;
        this.stateMachineLogGroup = wrappedConstruct.stateMachineLogGroup;
        this.s3Bucket = wrappedConstruct.s3Bucket;
        this.s3LoggingBucket = wrappedConstruct.s3LoggingBucket;
        this.cloudwatchAlarms = wrappedConstruct.cloudwatchAlarms;
        this.s3BucketInterface = wrappedConstruct.s3BucketInterface;
    }
}
exports.S3ToStepFunction = S3ToStepFunction;
_a = JSII_RTTI_SYMBOL_1;
S3ToStepFunction[_a] = { fqn: "@aws-solutions-constructs/aws-s3-step-function.S3ToStepFunction", version: "1.137.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWVBLHlGQUFtRjtBQUNuRix3RkFBd0Y7QUFDeEYsd0NBQTBDO0FBMkIxQyxNQUFhLGdCQUFpQixTQUFRLGdCQUFTOzs7Ozs7OztJQVM3QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsTUFBTSxjQUFjLEdBQTBCLEVBQUUsR0FBRyxLQUFLLEVBQUUsQ0FBQztRQUUzRCxtSEFBbUg7UUFDbkgsa0hBQWtIO1FBQ2xILGlIQUFpSDtRQUNqSCw4RUFBOEU7UUFDOUUsTUFBTSxnQkFBZ0IsR0FBcUIsSUFBSSx3Q0FBaUIsQ0FBQyxJQUFJLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxjQUFjLENBQUMsQ0FBQztRQUVqRyxJQUFJLENBQUMsWUFBWSxHQUFHLGdCQUFnQixDQUFDLFlBQVksQ0FBQztRQUNsRCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsZ0JBQWdCLENBQUMsb0JBQW9CLENBQUM7UUFDbEUsSUFBSSxDQUFDLFFBQVEsR0FBRyxnQkFBZ0IsQ0FBQyxRQUFRLENBQUM7UUFDMUMsSUFBSSxDQUFDLGVBQWUsR0FBRyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUM7UUFDeEQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLGdCQUFnQixDQUFDLGdCQUFnQixDQUFDO1FBQzFELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxnQkFBZ0IsQ0FBQyxpQkFBaUIsQ0FBQztJQUM5RCxDQUFDOztBQXpCSCw0Q0EwQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAyMiBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCAqIGFzIHNmbiBmcm9tICdAYXdzLWNkay9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgUzNUb1N0ZXBmdW5jdGlvbnMgfSBmcm9tICdAYXdzLXNvbHV0aW9ucy1jb25zdHJ1Y3RzL2F3cy1zMy1zdGVwZnVuY3Rpb25zJztcbi8vIE5vdGU6IFRvIGVuc3VyZSBDREt2MiBjb21wYXRpYmlsaXR5LCBrZWVwIHRoZSBpbXBvcnQgc3RhdGVtZW50IGZvciBDb25zdHJ1Y3Qgc2VwYXJhdGVcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgY2xvdWR3YXRjaCBmcm9tICdAYXdzLWNkay9hd3MtY2xvdWR3YXRjaCc7XG5pbXBvcnQgKiBhcyBldmVudHMgZnJvbSAnQGF3cy1jZGsvYXdzLWV2ZW50cyc7XG5pbXBvcnQgKiBhcyBsb2dzIGZyb20gJ0Bhd3MtY2RrL2F3cy1sb2dzJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFMzVG9TdGVwRnVuY3Rpb25Qcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBleGlzdGluZ0J1Y2tldE9iaj86IHMzLklCdWNrZXQsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYnVja2V0UHJvcHM/OiBzMy5CdWNrZXRQcm9wcyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzdGF0ZU1hY2hpbmVQcm9wczogc2ZuLlN0YXRlTWFjaGluZVByb3BzLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGV2ZW50UnVsZVByb3BzPzogZXZlbnRzLlJ1bGVQcm9wcyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkZXBsb3lDbG91ZFRyYWlsPzogYm9vbGVhbixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNyZWF0ZUNsb3VkV2F0Y2hBbGFybXM/OiBib29sZWFuLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbG9nR3JvdXBQcm9wcz86IGxvZ3MuTG9nR3JvdXBQcm9wcyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICByZWFkb25seSBsb2dnaW5nQnVja2V0UHJvcHM/OiBzMy5CdWNrZXRQcm9wcyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbG9nUzNBY2Nlc3NMb2dzPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNsYXNzIFMzVG9TdGVwRnVuY3Rpb24gZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgc3RhdGVNYWNoaW5lOiBzZm4uU3RhdGVNYWNoaW5lO1xuICBwdWJsaWMgcmVhZG9ubHkgc3RhdGVNYWNoaW5lTG9nR3JvdXA6IGxvZ3MuSUxvZ0dyb3VwO1xuICBwdWJsaWMgcmVhZG9ubHkgczNCdWNrZXQ/OiBzMy5CdWNrZXQ7XG4gIHB1YmxpYyByZWFkb25seSBzM0xvZ2dpbmdCdWNrZXQ/OiBzMy5CdWNrZXQ7XG4gIHB1YmxpYyByZWFkb25seSBjbG91ZHdhdGNoQWxhcm1zPzogY2xvdWR3YXRjaC5BbGFybVtdO1xuICBwdWJsaWMgcmVhZG9ubHkgczNCdWNrZXRJbnRlcmZhY2U6IHMzLklCdWNrZXQ7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFMzVG9TdGVwRnVuY3Rpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgY29uc3QgY29udmVydGVkUHJvcHM6IFMzVG9TdGVwRnVuY3Rpb25Qcm9wcyA9IHsgLi4ucHJvcHMgfTtcblxuICAgIC8vIFcgKGZvciAnd3JhcHBlZCcpIGlzIGFkZGVkIHRvIHRoZSBpZCBzbyB0aGF0IHRoZSBpZCdzIG9mIHRoZSBjb25zdHJ1Y3RzIHdpdGggdGhlIG9sZCBhbmQgbmV3IG5hbWVzIGRvbid0IGNvbGxpZGVcbiAgICAvLyBJZiB0aGlzIGNoYXJhY3RlciBwdXNoZXMgeW91IGJleW9uZCB0aGUgNjQgY2hhcmFjdGVyIGxpbWl0LCBqdXN0IGltcG9ydCB0aGUgbmV3IG5hbWVkIGNvbnN0cnVjdCBhbmQgaW5zdGFudGlhdGVcbiAgICAvLyBpdCBpbiBwbGFjZSBvZiB0aGUgb2xkZXIgbmFtZWQgdmVyc2lvbi4gVGhleSBhcmUgZnVuY3Rpb25hbGx5IGlkZW50aWNhbCwgYXNpZGUgZnJvbSB0aGUgdHlwZXMgbm8gb3RoZXIgY2hhbmdlc1xuICAgIC8vIHdpbGwgYmUgcmVxdWlyZWQuICAoZWcgLSBuZXcgUzNUb1N0ZXBmdW5jdGlvbnMgaW5zdGVhZCBvZiBTM1RvU3RlcEZ1bmN0aW9uKVxuICAgIGNvbnN0IHdyYXBwZWRDb25zdHJ1Y3Q6IFMzVG9TdGVwRnVuY3Rpb24gPSBuZXcgUzNUb1N0ZXBmdW5jdGlvbnModGhpcywgYCR7aWR9V2AsIGNvbnZlcnRlZFByb3BzKTtcblxuICAgIHRoaXMuc3RhdGVNYWNoaW5lID0gd3JhcHBlZENvbnN0cnVjdC5zdGF0ZU1hY2hpbmU7XG4gICAgdGhpcy5zdGF0ZU1hY2hpbmVMb2dHcm91cCA9IHdyYXBwZWRDb25zdHJ1Y3Quc3RhdGVNYWNoaW5lTG9nR3JvdXA7XG4gICAgdGhpcy5zM0J1Y2tldCA9IHdyYXBwZWRDb25zdHJ1Y3QuczNCdWNrZXQ7XG4gICAgdGhpcy5zM0xvZ2dpbmdCdWNrZXQgPSB3cmFwcGVkQ29uc3RydWN0LnMzTG9nZ2luZ0J1Y2tldDtcbiAgICB0aGlzLmNsb3Vkd2F0Y2hBbGFybXMgPSB3cmFwcGVkQ29uc3RydWN0LmNsb3Vkd2F0Y2hBbGFybXM7XG4gICAgdGhpcy5zM0J1Y2tldEludGVyZmFjZSA9IHdyYXBwZWRDb25zdHJ1Y3QuczNCdWNrZXRJbnRlcmZhY2U7XG4gIH1cbn0iXX0=