# coding: utf-8

"""
    Xero AppStore API

    These endpoints are for Xero Partners to interact with the App Store Billing platform  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class UsageRecord(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "quantity": "int",
        "subscription_id": "str",
        "subscription_item_id": "str",
        "test_mode": "bool",
        "recorded_at": "datetime",
        "usage_record_id": "str",
        "price_per_unit": "float",
        "product_id": "str",
    }

    attribute_map = {
        "quantity": "quantity",
        "subscription_id": "subscriptionId",
        "subscription_item_id": "subscriptionItemId",
        "test_mode": "testMode",
        "recorded_at": "recordedAt",
        "usage_record_id": "usageRecordId",
        "price_per_unit": "pricePerUnit",
        "product_id": "productId",
    }

    def __init__(
        self,
        quantity=None,
        subscription_id=None,
        subscription_item_id=None,
        test_mode=None,
        recorded_at=None,
        usage_record_id=None,
        price_per_unit=None,
        product_id=None,
    ):  # noqa: E501
        """UsageRecord - a model defined in OpenAPI"""  # noqa: E501

        self._quantity = None
        self._subscription_id = None
        self._subscription_item_id = None
        self._test_mode = None
        self._recorded_at = None
        self._usage_record_id = None
        self._price_per_unit = None
        self._product_id = None
        self.discriminator = None

        self.quantity = quantity
        self.subscription_id = subscription_id
        self.subscription_item_id = subscription_item_id
        self.test_mode = test_mode
        self.recorded_at = recorded_at
        self.usage_record_id = usage_record_id
        self.price_per_unit = price_per_unit
        self.product_id = product_id

    @property
    def quantity(self):
        """Gets the quantity of this UsageRecord.  # noqa: E501

        The quantity recorded  # noqa: E501

        :return: The quantity of this UsageRecord.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this UsageRecord.

        The quantity recorded  # noqa: E501

        :param quantity: The quantity of this UsageRecord.  # noqa: E501
        :type: int
        """
        if quantity is None:
            raise ValueError(
                "Invalid value for `quantity`, must not be `None`"
            )  # noqa: E501

        self._quantity = quantity

    @property
    def subscription_id(self):
        """Gets the subscription_id of this UsageRecord.  # noqa: E501

        The unique identifier of the Subscription.  # noqa: E501

        :return: The subscription_id of this UsageRecord.  # noqa: E501
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """Sets the subscription_id of this UsageRecord.

        The unique identifier of the Subscription.  # noqa: E501

        :param subscription_id: The subscription_id of this UsageRecord.  # noqa: E501
        :type: str
        """
        if subscription_id is None:
            raise ValueError(
                "Invalid value for `subscription_id`, must not be `None`"
            )  # noqa: E501

        self._subscription_id = subscription_id

    @property
    def subscription_item_id(self):
        """Gets the subscription_item_id of this UsageRecord.  # noqa: E501

        The unique identifier of the SubscriptionItem.  # noqa: E501

        :return: The subscription_item_id of this UsageRecord.  # noqa: E501
        :rtype: str
        """
        return self._subscription_item_id

    @subscription_item_id.setter
    def subscription_item_id(self, subscription_item_id):
        """Sets the subscription_item_id of this UsageRecord.

        The unique identifier of the SubscriptionItem.  # noqa: E501

        :param subscription_item_id: The subscription_item_id of this UsageRecord.  # noqa: E501
        :type: str
        """
        if subscription_item_id is None:
            raise ValueError(
                "Invalid value for `subscription_item_id`, must not be `None`"
            )  # noqa: E501

        self._subscription_item_id = subscription_item_id

    @property
    def test_mode(self):
        """Gets the test_mode of this UsageRecord.  # noqa: E501

        If the subscription is a test subscription  # noqa: E501

        :return: The test_mode of this UsageRecord.  # noqa: E501
        :rtype: bool
        """
        return self._test_mode

    @test_mode.setter
    def test_mode(self, test_mode):
        """Sets the test_mode of this UsageRecord.

        If the subscription is a test subscription  # noqa: E501

        :param test_mode: The test_mode of this UsageRecord.  # noqa: E501
        :type: bool
        """
        if test_mode is None:
            raise ValueError(
                "Invalid value for `test_mode`, must not be `None`"
            )  # noqa: E501

        self._test_mode = test_mode

    @property
    def recorded_at(self):
        """Gets the recorded_at of this UsageRecord.  # noqa: E501

        The time when this usage was recorded in UTC  # noqa: E501

        :return: The recorded_at of this UsageRecord.  # noqa: E501
        :rtype: datetime
        """
        return self._recorded_at

    @recorded_at.setter
    def recorded_at(self, recorded_at):
        """Sets the recorded_at of this UsageRecord.

        The time when this usage was recorded in UTC  # noqa: E501

        :param recorded_at: The recorded_at of this UsageRecord.  # noqa: E501
        :type: datetime
        """
        if recorded_at is None:
            raise ValueError(
                "Invalid value for `recorded_at`, must not be `None`"
            )  # noqa: E501

        self._recorded_at = recorded_at

    @property
    def usage_record_id(self):
        """Gets the usage_record_id of this UsageRecord.  # noqa: E501

        The unique identifier of the usageRecord.  # noqa: E501

        :return: The usage_record_id of this UsageRecord.  # noqa: E501
        :rtype: str
        """
        return self._usage_record_id

    @usage_record_id.setter
    def usage_record_id(self, usage_record_id):
        """Sets the usage_record_id of this UsageRecord.

        The unique identifier of the usageRecord.  # noqa: E501

        :param usage_record_id: The usage_record_id of this UsageRecord.  # noqa: E501
        :type: str
        """
        if usage_record_id is None:
            raise ValueError(
                "Invalid value for `usage_record_id`, must not be `None`"
            )  # noqa: E501

        self._usage_record_id = usage_record_id

    @property
    def price_per_unit(self):
        """Gets the price_per_unit of this UsageRecord.  # noqa: E501

        The price per unit  # noqa: E501

        :return: The price_per_unit of this UsageRecord.  # noqa: E501
        :rtype: float
        """
        return self._price_per_unit

    @price_per_unit.setter
    def price_per_unit(self, price_per_unit):
        """Sets the price_per_unit of this UsageRecord.

        The price per unit  # noqa: E501

        :param price_per_unit: The price_per_unit of this UsageRecord.  # noqa: E501
        :type: float
        """
        if price_per_unit is None:
            raise ValueError(
                "Invalid value for `price_per_unit`, must not be `None`"
            )  # noqa: E501

        self._price_per_unit = price_per_unit

    @property
    def product_id(self):
        """Gets the product_id of this UsageRecord.  # noqa: E501

        The unique identifier of the linked Product  # noqa: E501

        :return: The product_id of this UsageRecord.  # noqa: E501
        :rtype: str
        """
        return self._product_id

    @product_id.setter
    def product_id(self, product_id):
        """Sets the product_id of this UsageRecord.

        The unique identifier of the linked Product  # noqa: E501

        :param product_id: The product_id of this UsageRecord.  # noqa: E501
        :type: str
        """
        if product_id is None:
            raise ValueError(
                "Invalid value for `product_id`, must not be `None`"
            )  # noqa: E501

        self._product_id = product_id
