# Generated by Django 2.1.2 on 2018-11-20 02:56

import django.db.models.deletion
from django.db import migrations, models
from rest_framework_apicontrol.utils import (
    DEFAULT_LOGGING_GROUP_CODE,
    get_default_logging_group
)

def generate_default_logging_group(apps, schema_editor):
    # We get the model from the versioned app registry;
    # if we directly import it, it'll be the wrong version
    LoggingGroup = apps.get_model("rest_framework_apicontrol", "LoggingGroup")
    default_logging_group, created = LoggingGroup.objects.get_or_create(
        code=DEFAULT_LOGGING_GROUP_CODE
    )

def remove_default_logging_group(apps, schema_editor):
    LoggingGroup = apps.get_model("rest_framework_apicontrol", "LoggingGroup")
    LoggingGroup.objects.filter(code=DEFAULT_LOGGING_GROUP_CODE).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('rest_framework_apicontrol', '0006_logginggroup_code'),
    ]

    operations = [
        migrations.RunPython(
            generate_default_logging_group,
            remove_default_logging_group
        ),
    ]
