import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 */
export interface CfnDomainProps {
    /**
     * `AWS::Elasticsearch::Domain.AccessPolicies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-accesspolicies
     * @external
     */
    readonly accessPolicies?: any | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.AdvancedOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions
     * @external
     */
    readonly advancedOptions?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.AdvancedSecurityOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedsecurityoptions
     * @external
     */
    readonly advancedSecurityOptions?: CfnDomain.AdvancedSecurityOptionsInputProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.CognitoOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions
     * @external
     */
    readonly cognitoOptions?: CfnDomain.CognitoOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.DomainEndpointOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainendpointoptions
     * @external
     */
    readonly domainEndpointOptions?: CfnDomain.DomainEndpointOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainname
     * @external
     */
    readonly domainName?: string;
    /**
     * `AWS::Elasticsearch::Domain.EBSOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions
     * @external
     */
    readonly ebsOptions?: CfnDomain.EBSOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig
     * @external
     */
    readonly elasticsearchClusterConfig?: CfnDomain.ElasticsearchClusterConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchversion
     * @external
     */
    readonly elasticsearchVersion?: string;
    /**
     * `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions
     * @external
     */
    readonly encryptionAtRestOptions?: CfnDomain.EncryptionAtRestOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.LogPublishingOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions
     * @external
     */
    readonly logPublishingOptions?: {
        [key: string]: (CfnDomain.LogPublishingOptionProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions
     * @external
     */
    readonly nodeToNodeEncryptionOptions?: CfnDomain.NodeToNodeEncryptionOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.SnapshotOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions
     * @external
     */
    readonly snapshotOptions?: CfnDomain.SnapshotOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Elasticsearch::Domain.VPCOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions
     * @external
     */
    readonly vpcOptions?: CfnDomain.VPCOptionsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare class CfnDomain extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Elasticsearch::Domain";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute DomainEndpoint
     */
    readonly attrDomainEndpoint: string;
    /**
     * `AWS::Elasticsearch::Domain.AccessPolicies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-accesspolicies
     * @external
     */
    accessPolicies: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.AdvancedOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions
     * @external
     */
    advancedOptions: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.AdvancedSecurityOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedsecurityoptions
     * @external
     */
    advancedSecurityOptions: CfnDomain.AdvancedSecurityOptionsInputProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.CognitoOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions
     * @external
     */
    cognitoOptions: CfnDomain.CognitoOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.DomainEndpointOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainendpointoptions
     * @external
     */
    domainEndpointOptions: CfnDomain.DomainEndpointOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainname
     * @external
     */
    domainName: string | undefined;
    /**
     * `AWS::Elasticsearch::Domain.EBSOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions
     * @external
     */
    ebsOptions: CfnDomain.EBSOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig
     * @external
     */
    elasticsearchClusterConfig: CfnDomain.ElasticsearchClusterConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchversion
     * @external
     */
    elasticsearchVersion: string | undefined;
    /**
     * `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions
     * @external
     */
    encryptionAtRestOptions: CfnDomain.EncryptionAtRestOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.LogPublishingOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions
     * @external
     */
    logPublishingOptions: {
        [key: string]: (CfnDomain.LogPublishingOptionProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions
     * @external
     */
    nodeToNodeEncryptionOptions: CfnDomain.NodeToNodeEncryptionOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.SnapshotOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions
     * @external
     */
    snapshotOptions: CfnDomain.SnapshotOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Elasticsearch::Domain.VPCOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions
     * @external
     */
    vpcOptions: CfnDomain.VPCOptionsProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Elasticsearch::Domain`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDomainProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html
     * @external
     */
    interface AdvancedSecurityOptionsInputProperty {
        /**
         * `CfnDomain.AdvancedSecurityOptionsInputProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.AdvancedSecurityOptionsInputProperty.InternalUserDatabaseEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-internaluserdatabaseenabled
         * @external
         */
        readonly internalUserDatabaseEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.AdvancedSecurityOptionsInputProperty.MasterUserOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-masteruseroptions
         * @external
         */
        readonly masterUserOptions?: CfnDomain.MasterUserOptionsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html
     * @external
     */
    interface CognitoOptionsProperty {
        /**
         * `CfnDomain.CognitoOptionsProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.CognitoOptionsProperty.IdentityPoolId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-identitypoolid
         * @external
         */
        readonly identityPoolId?: string;
        /**
         * `CfnDomain.CognitoOptionsProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-rolearn
         * @external
         */
        readonly roleArn?: string;
        /**
         * `CfnDomain.CognitoOptionsProperty.UserPoolId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-userpoolid
         * @external
         */
        readonly userPoolId?: string;
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html
     * @external
     */
    interface DomainEndpointOptionsProperty {
        /**
         * `CfnDomain.DomainEndpointOptionsProperty.EnforceHTTPS`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-enforcehttps
         * @external
         */
        readonly enforceHttps?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.DomainEndpointOptionsProperty.TLSSecurityPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-tlssecuritypolicy
         * @external
         */
        readonly tlsSecurityPolicy?: string;
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html
     * @external
     */
    interface EBSOptionsProperty {
        /**
         * `CfnDomain.EBSOptionsProperty.EBSEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-ebsenabled
         * @external
         */
        readonly ebsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.EBSOptionsProperty.Iops`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-iops
         * @external
         */
        readonly iops?: number;
        /**
         * `CfnDomain.EBSOptionsProperty.VolumeSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-volumesize
         * @external
         */
        readonly volumeSize?: number;
        /**
         * `CfnDomain.EBSOptionsProperty.VolumeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-volumetype
         * @external
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html
     * @external
     */
    interface ElasticsearchClusterConfigProperty {
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-dedicatedmastercount
         * @external
         */
        readonly dedicatedMasterCount?: number;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-dedicatedmasterenabled
         * @external
         */
        readonly dedicatedMasterEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-dedicatedmastertype
         * @external
         */
        readonly dedicatedMasterType?: string;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.InstanceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-instancecount
         * @external
         */
        readonly instanceCount?: number;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-instnacetype
         * @external
         */
        readonly instanceType?: string;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.ZoneAwarenessConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-zoneawarenessconfig
         * @external
         */
        readonly zoneAwarenessConfig?: CfnDomain.ZoneAwarenessConfigProperty | cdk.IResolvable;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.ZoneAwarenessEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-zoneawarenessenabled
         * @external
         */
        readonly zoneAwarenessEnabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html
     * @external
     */
    interface EncryptionAtRestOptionsProperty {
        /**
         * `CfnDomain.EncryptionAtRestOptionsProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html#cfn-elasticsearch-domain-encryptionatrestoptions-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.EncryptionAtRestOptionsProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html#cfn-elasticsearch-domain-encryptionatrestoptions-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html
     * @external
     */
    interface LogPublishingOptionProperty {
        /**
         * `CfnDomain.LogPublishingOptionProperty.CloudWatchLogsLogGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html#cfn-elasticsearch-domain-logpublishingoption-cloudwatchlogsloggrouparn
         * @external
         */
        readonly cloudWatchLogsLogGroupArn?: string;
        /**
         * `CfnDomain.LogPublishingOptionProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html#cfn-elasticsearch-domain-logpublishingoption-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html
     * @external
     */
    interface MasterUserOptionsProperty {
        /**
         * `CfnDomain.MasterUserOptionsProperty.MasterUserARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masteruserarn
         * @external
         */
        readonly masterUserArn?: string;
        /**
         * `CfnDomain.MasterUserOptionsProperty.MasterUserName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masterusername
         * @external
         */
        readonly masterUserName?: string;
        /**
         * `CfnDomain.MasterUserOptionsProperty.MasterUserPassword`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masteruserpassword
         * @external
         */
        readonly masterUserPassword?: string;
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-nodetonodeencryptionoptions.html
     * @external
     */
    interface NodeToNodeEncryptionOptionsProperty {
        /**
         * `CfnDomain.NodeToNodeEncryptionOptionsProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-nodetonodeencryptionoptions.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-snapshotoptions.html
     * @external
     */
    interface SnapshotOptionsProperty {
        /**
         * `CfnDomain.SnapshotOptionsProperty.AutomatedSnapshotStartHour`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-snapshotoptions.html#cfn-elasticsearch-domain-snapshotoptions-automatedsnapshotstarthour
         * @external
         */
        readonly automatedSnapshotStartHour?: number;
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html
     * @external
     */
    interface VPCOptionsProperty {
        /**
         * `CfnDomain.VPCOptionsProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html#cfn-elasticsearch-domain-vpcoptions-securitygroupids
         * @external
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnDomain.VPCOptionsProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html#cfn-elasticsearch-domain-vpcoptions-subnetids
         * @external
         */
        readonly subnetIds?: string[];
    }
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 * @external
 * @cloudformationResource AWS::Elasticsearch::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-zoneawarenessconfig.html
     * @external
     */
    interface ZoneAwarenessConfigProperty {
        /**
         * `CfnDomain.ZoneAwarenessConfigProperty.AvailabilityZoneCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-zoneawarenessconfig.html#cfn-elasticsearch-domain-zoneawarenessconfig-availabilityzonecount
         * @external
         */
        readonly availabilityZoneCount?: number;
    }
}
