# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: common.proto
# plugin: python-betterproto
from dataclasses import dataclass

import betterproto


@dataclass
class Backend(betterproto.Message):
    """
    When sent by a chat backend, the ID MAY optionally be used as a hint to the
    frontend to get the same external ID on reconnection. When sent by core to
    a plugin, the ID MUST be an ID pointing to an exact backend instance.
    """

    id: str = betterproto.string_field(1)
    type: str = betterproto.string_field(2)


@dataclass
class User(betterproto.Message):
    """
    When sent by a chat backend, the ID MUST be unique across users in that
    running backend. Failure to follow this will result in incorrect
    information being sent to plugins. When sent by core to a plugin, the ID
    MUST be an ID pointing to an instance of a user on chat backend.
    """

    id: str = betterproto.string_field(1)
    display_name: str = betterproto.string_field(2)


@dataclass
class Channel(betterproto.Message):
    """
    When sent by a chat backend, the ID MUST be unique across channels in that
    running backend. Failure to follow this will result in incorrect
    information being sent to plugins. When sent by core to a plugin, the ID
    MUST be an ID pointing to an instance of a channel on chat backend.
    """

    id: str = betterproto.string_field(1)
    display_name: str = betterproto.string_field(2)
    topic: str = betterproto.string_field(3)


@dataclass
class ChannelSource(betterproto.Message):
    """
    ChannelSource represents where a message came from. Note that User is used
    rather than just an ID so any clients can have access to the name as well.
    This may change in the future.
    """

    channel_id: str = betterproto.string_field(1)
    user: "User" = betterproto.message_field(2)


@dataclass
class MessageEvent(betterproto.Message):
    """MessageEvent will be sent when a user sends a message to a channel."""

    source: "ChannelSource" = betterproto.message_field(1)
    text: str = betterproto.string_field(2)


@dataclass
class PrivateMessageEvent(betterproto.Message):
    """
    PrivateMessageEvent will be sent when a user sends a message directly to
    the chat backend.
    """

    source: "User" = betterproto.message_field(1)
    text: str = betterproto.string_field(2)


@dataclass
class MentionEvent(betterproto.Message):
    """
    MentionEvent will be sent when a user mentions the chat backend's user at
    the start of a message in a channel. Note that this may eventually go away
    when a more general message format is developed.
    """

    source: "ChannelSource" = betterproto.message_field(1)
    text: str = betterproto.string_field(2)


@dataclass
class CommandEvent(betterproto.Message):
    """
    CommandEvent will be sent when a user issues a command in a channel.
    Commands cannot be issued via private message. If a message is parsed as a
    command, it MUST NOT be also sent as another message type.
    """

    source: "ChannelSource" = betterproto.message_field(1)
    command: str = betterproto.string_field(2)
    arg: str = betterproto.string_field(3)


@dataclass
class ActionEvent(betterproto.Message):
    """
    ActionEvent will be sent when a user takes an action in a channel. This is
    often triggered with /me.
    """

    source: "ChannelSource" = betterproto.message_field(1)
    text: str = betterproto.string_field(2)


@dataclass
class PrivateActionEvent(betterproto.Message):
    """
    PrivateActionEvent will be sent when a user takes an action in a private
    message. This is often triggered with /me.
    """

    source: "User" = betterproto.message_field(1)
    text: str = betterproto.string_field(2)
