# coding: utf-8

"""
    Xero Payroll NZ

    This is the Xero Payroll API for orgs in the NZ region.  # noqa: E501

    OpenAPI spec version: 2.3.4
    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class EmployeeTax(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "ird_number": "str",
        "tax_code": "TaxCode",
        "special_tax_rate_percentage": "float",
        "has_special_student_loan_rate": "bool",
        "special_student_loan_rate_percentage": "float",
        "is_eligible_for_kiwi_saver": "bool",
        "esct_rate_percentage": "float",
        "kiwi_saver_contributions": "str",
        "kiwi_saver_employee_contribution_rate_percentage": "float",
        "kiwi_saver_employer_contribution_rate_percentage": "float",
        "kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage": "float",
        "kiwi_saver_opt_out_date": "date",
        "kiwi_saver_contribution_holiday_end_date": "date",
        "has_student_loan_balance": "bool",
        "student_loan_balance": "float",
        "student_loan_as_at": "date",
    }

    attribute_map = {
        "ird_number": "irdNumber",
        "tax_code": "taxCode",
        "special_tax_rate_percentage": "specialTaxRatePercentage",
        "has_special_student_loan_rate": "hasSpecialStudentLoanRate",
        "special_student_loan_rate_percentage": "specialStudentLoanRatePercentage",
        "is_eligible_for_kiwi_saver": "isEligibleForKiwiSaver",
        "esct_rate_percentage": "esctRatePercentage",
        "kiwi_saver_contributions": "kiwiSaverContributions",
        "kiwi_saver_employee_contribution_rate_percentage": "kiwiSaverEmployeeContributionRatePercentage",
        "kiwi_saver_employer_contribution_rate_percentage": "kiwiSaverEmployerContributionRatePercentage",
        "kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage": "kiwiSaverEmployerSalarySacrificeContributionRatePercentage",
        "kiwi_saver_opt_out_date": "kiwiSaverOptOutDate",
        "kiwi_saver_contribution_holiday_end_date": "kiwiSaverContributionHolidayEndDate",
        "has_student_loan_balance": "hasStudentLoanBalance",
        "student_loan_balance": "studentLoanBalance",
        "student_loan_as_at": "studentLoanAsAt",
    }

    def __init__(
        self,
        ird_number=None,
        tax_code=None,
        special_tax_rate_percentage=None,
        has_special_student_loan_rate=None,
        special_student_loan_rate_percentage=None,
        is_eligible_for_kiwi_saver=None,
        esct_rate_percentage=None,
        kiwi_saver_contributions=None,
        kiwi_saver_employee_contribution_rate_percentage=None,
        kiwi_saver_employer_contribution_rate_percentage=None,
        kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage=None,
        kiwi_saver_opt_out_date=None,
        kiwi_saver_contribution_holiday_end_date=None,
        has_student_loan_balance=None,
        student_loan_balance=None,
        student_loan_as_at=None,
    ):  # noqa: E501
        """EmployeeTax - a model defined in OpenAPI"""  # noqa: E501

        self._ird_number = None
        self._tax_code = None
        self._special_tax_rate_percentage = None
        self._has_special_student_loan_rate = None
        self._special_student_loan_rate_percentage = None
        self._is_eligible_for_kiwi_saver = None
        self._esct_rate_percentage = None
        self._kiwi_saver_contributions = None
        self._kiwi_saver_employee_contribution_rate_percentage = None
        self._kiwi_saver_employer_contribution_rate_percentage = None
        self._kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage = None
        self._kiwi_saver_opt_out_date = None
        self._kiwi_saver_contribution_holiday_end_date = None
        self._has_student_loan_balance = None
        self._student_loan_balance = None
        self._student_loan_as_at = None
        self.discriminator = None

        if ird_number is not None:
            self.ird_number = ird_number
        if tax_code is not None:
            self.tax_code = tax_code
        if special_tax_rate_percentage is not None:
            self.special_tax_rate_percentage = special_tax_rate_percentage
        if has_special_student_loan_rate is not None:
            self.has_special_student_loan_rate = has_special_student_loan_rate
        if special_student_loan_rate_percentage is not None:
            self.special_student_loan_rate_percentage = (
                special_student_loan_rate_percentage
            )
        if is_eligible_for_kiwi_saver is not None:
            self.is_eligible_for_kiwi_saver = is_eligible_for_kiwi_saver
        if esct_rate_percentage is not None:
            self.esct_rate_percentage = esct_rate_percentage
        if kiwi_saver_contributions is not None:
            self.kiwi_saver_contributions = kiwi_saver_contributions
        if kiwi_saver_employee_contribution_rate_percentage is not None:
            self.kiwi_saver_employee_contribution_rate_percentage = (
                kiwi_saver_employee_contribution_rate_percentage
            )
        if kiwi_saver_employer_contribution_rate_percentage is not None:
            self.kiwi_saver_employer_contribution_rate_percentage = (
                kiwi_saver_employer_contribution_rate_percentage
            )
        if (
            kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage
            is not None
        ):
            self.kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage = (
                kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage
            )
        if kiwi_saver_opt_out_date is not None:
            self.kiwi_saver_opt_out_date = kiwi_saver_opt_out_date
        if kiwi_saver_contribution_holiday_end_date is not None:
            self.kiwi_saver_contribution_holiday_end_date = (
                kiwi_saver_contribution_holiday_end_date
            )
        if has_student_loan_balance is not None:
            self.has_student_loan_balance = has_student_loan_balance
        if student_loan_balance is not None:
            self.student_loan_balance = student_loan_balance
        if student_loan_as_at is not None:
            self.student_loan_as_at = student_loan_as_at

    @property
    def ird_number(self):
        """Gets the ird_number of this EmployeeTax.  # noqa: E501

        The IRD Number.  # noqa: E501

        :return: The ird_number of this EmployeeTax.  # noqa: E501
        :rtype: str
        """
        return self._ird_number

    @ird_number.setter
    def ird_number(self, ird_number):
        """Sets the ird_number of this EmployeeTax.

        The IRD Number.  # noqa: E501

        :param ird_number: The ird_number of this EmployeeTax.  # noqa: E501
        :type: str
        """

        self._ird_number = ird_number

    @property
    def tax_code(self):
        """Gets the tax_code of this EmployeeTax.  # noqa: E501


        :return: The tax_code of this EmployeeTax.  # noqa: E501
        :rtype: TaxCode
        """
        return self._tax_code

    @tax_code.setter
    def tax_code(self, tax_code):
        """Sets the tax_code of this EmployeeTax.


        :param tax_code: The tax_code of this EmployeeTax.  # noqa: E501
        :type: TaxCode
        """

        self._tax_code = tax_code

    @property
    def special_tax_rate_percentage(self):
        """Gets the special_tax_rate_percentage of this EmployeeTax.  # noqa: E501

        Special tax rate percentage.  # noqa: E501

        :return: The special_tax_rate_percentage of this EmployeeTax.  # noqa: E501
        :rtype: float
        """
        return self._special_tax_rate_percentage

    @special_tax_rate_percentage.setter
    def special_tax_rate_percentage(self, special_tax_rate_percentage):
        """Sets the special_tax_rate_percentage of this EmployeeTax.

        Special tax rate percentage.  # noqa: E501

        :param special_tax_rate_percentage: The special_tax_rate_percentage of this EmployeeTax.  # noqa: E501
        :type: float
        """

        self._special_tax_rate_percentage = special_tax_rate_percentage

    @property
    def has_special_student_loan_rate(self):
        """Gets the has_special_student_loan_rate of this EmployeeTax.  # noqa: E501

        Does the employee has a special student loan rate?  # noqa: E501

        :return: The has_special_student_loan_rate of this EmployeeTax.  # noqa: E501
        :rtype: bool
        """
        return self._has_special_student_loan_rate

    @has_special_student_loan_rate.setter
    def has_special_student_loan_rate(self, has_special_student_loan_rate):
        """Sets the has_special_student_loan_rate of this EmployeeTax.

        Does the employee has a special student loan rate?  # noqa: E501

        :param has_special_student_loan_rate: The has_special_student_loan_rate of this EmployeeTax.  # noqa: E501
        :type: bool
        """

        self._has_special_student_loan_rate = has_special_student_loan_rate

    @property
    def special_student_loan_rate_percentage(self):
        """Gets the special_student_loan_rate_percentage of this EmployeeTax.  # noqa: E501

        The employee student loan rate percentage.  # noqa: E501

        :return: The special_student_loan_rate_percentage of this EmployeeTax.  # noqa: E501
        :rtype: float
        """
        return self._special_student_loan_rate_percentage

    @special_student_loan_rate_percentage.setter
    def special_student_loan_rate_percentage(
        self, special_student_loan_rate_percentage
    ):
        """Sets the special_student_loan_rate_percentage of this EmployeeTax.

        The employee student loan rate percentage.  # noqa: E501

        :param special_student_loan_rate_percentage: The special_student_loan_rate_percentage of this EmployeeTax.  # noqa: E501
        :type: float
        """

        self._special_student_loan_rate_percentage = (
            special_student_loan_rate_percentage
        )

    @property
    def is_eligible_for_kiwi_saver(self):
        """Gets the is_eligible_for_kiwi_saver of this EmployeeTax.  # noqa: E501

        The employee eligibility for KiwiSaver.  # noqa: E501

        :return: The is_eligible_for_kiwi_saver of this EmployeeTax.  # noqa: E501
        :rtype: bool
        """
        return self._is_eligible_for_kiwi_saver

    @is_eligible_for_kiwi_saver.setter
    def is_eligible_for_kiwi_saver(self, is_eligible_for_kiwi_saver):
        """Sets the is_eligible_for_kiwi_saver of this EmployeeTax.

        The employee eligibility for KiwiSaver.  # noqa: E501

        :param is_eligible_for_kiwi_saver: The is_eligible_for_kiwi_saver of this EmployeeTax.  # noqa: E501
        :type: bool
        """

        self._is_eligible_for_kiwi_saver = is_eligible_for_kiwi_saver

    @property
    def esct_rate_percentage(self):
        """Gets the esct_rate_percentage of this EmployeeTax.  # noqa: E501

        Employer superannuation contribution tax rate.  # noqa: E501

        :return: The esct_rate_percentage of this EmployeeTax.  # noqa: E501
        :rtype: float
        """
        return self._esct_rate_percentage

    @esct_rate_percentage.setter
    def esct_rate_percentage(self, esct_rate_percentage):
        """Sets the esct_rate_percentage of this EmployeeTax.

        Employer superannuation contribution tax rate.  # noqa: E501

        :param esct_rate_percentage: The esct_rate_percentage of this EmployeeTax.  # noqa: E501
        :type: float
        """

        self._esct_rate_percentage = esct_rate_percentage

    @property
    def kiwi_saver_contributions(self):
        """Gets the kiwi_saver_contributions of this EmployeeTax.  # noqa: E501

        Contribution Option which can be 'MakeContributions' 'OptOut', 'OnAContributionsHoliday', 'OnASavingsSuspension', 'NotCurrentlyAKiwiSaverMember' for employees without a KiwiSaver membership  # noqa: E501

        :return: The kiwi_saver_contributions of this EmployeeTax.  # noqa: E501
        :rtype: str
        """
        return self._kiwi_saver_contributions

    @kiwi_saver_contributions.setter
    def kiwi_saver_contributions(self, kiwi_saver_contributions):
        """Sets the kiwi_saver_contributions of this EmployeeTax.

        Contribution Option which can be 'MakeContributions' 'OptOut', 'OnAContributionsHoliday', 'OnASavingsSuspension', 'NotCurrentlyAKiwiSaverMember' for employees without a KiwiSaver membership  # noqa: E501

        :param kiwi_saver_contributions: The kiwi_saver_contributions of this EmployeeTax.  # noqa: E501
        :type: str
        """
        allowed_values = [
            "MakeContributions",
            "OptOut",
            "OnAContributionsHoliday",
            "OnASavingsSuspension",
            "NotCurrentlyAKiwiSaverMember",
            "None",
        ]  # noqa: E501
        if kiwi_saver_contributions not in allowed_values:
            raise ValueError(
                "Invalid value for `kiwi_saver_contributions` ({0}), must be one of {1}".format(  # noqa: E501
                    kiwi_saver_contributions, allowed_values
                )
            )

        self._kiwi_saver_contributions = kiwi_saver_contributions

    @property
    def kiwi_saver_employee_contribution_rate_percentage(self):
        """Gets the kiwi_saver_employee_contribution_rate_percentage of this EmployeeTax.  # noqa: E501

        Employee Contribution percentage.  # noqa: E501

        :return: The kiwi_saver_employee_contribution_rate_percentage of this EmployeeTax.  # noqa: E501
        :rtype: float
        """
        return self._kiwi_saver_employee_contribution_rate_percentage

    @kiwi_saver_employee_contribution_rate_percentage.setter
    def kiwi_saver_employee_contribution_rate_percentage(
        self, kiwi_saver_employee_contribution_rate_percentage
    ):
        """Sets the kiwi_saver_employee_contribution_rate_percentage of this EmployeeTax.

        Employee Contribution percentage.  # noqa: E501

        :param kiwi_saver_employee_contribution_rate_percentage: The kiwi_saver_employee_contribution_rate_percentage of this EmployeeTax.  # noqa: E501
        :type: float
        """

        self._kiwi_saver_employee_contribution_rate_percentage = (
            kiwi_saver_employee_contribution_rate_percentage
        )

    @property
    def kiwi_saver_employer_contribution_rate_percentage(self):
        """Gets the kiwi_saver_employer_contribution_rate_percentage of this EmployeeTax.  # noqa: E501

        Employer Contribution percentage.  # noqa: E501

        :return: The kiwi_saver_employer_contribution_rate_percentage of this EmployeeTax.  # noqa: E501
        :rtype: float
        """
        return self._kiwi_saver_employer_contribution_rate_percentage

    @kiwi_saver_employer_contribution_rate_percentage.setter
    def kiwi_saver_employer_contribution_rate_percentage(
        self, kiwi_saver_employer_contribution_rate_percentage
    ):
        """Sets the kiwi_saver_employer_contribution_rate_percentage of this EmployeeTax.

        Employer Contribution percentage.  # noqa: E501

        :param kiwi_saver_employer_contribution_rate_percentage: The kiwi_saver_employer_contribution_rate_percentage of this EmployeeTax.  # noqa: E501
        :type: float
        """

        self._kiwi_saver_employer_contribution_rate_percentage = (
            kiwi_saver_employer_contribution_rate_percentage
        )

    @property
    def kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage(self):
        """Gets the kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage of this EmployeeTax.  # noqa: E501

        Employer Contribution through Salary Sacrifice percentage.  # noqa: E501

        :return: The kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage of this EmployeeTax.  # noqa: E501
        :rtype: float
        """
        return self._kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage

    @kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage.setter
    def kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage(
        self, kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage
    ):
        """Sets the kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage of this EmployeeTax.

        Employer Contribution through Salary Sacrifice percentage.  # noqa: E501

        :param kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage: The kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage of this EmployeeTax.  # noqa: E501
        :type: float
        """

        self._kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage = (
            kiwi_saver_employer_salary_sacrifice_contribution_rate_percentage
        )

    @property
    def kiwi_saver_opt_out_date(self):
        """Gets the kiwi_saver_opt_out_date of this EmployeeTax.  # noqa: E501

        Opt Out Date.  # noqa: E501

        :return: The kiwi_saver_opt_out_date of this EmployeeTax.  # noqa: E501
        :rtype: date
        """
        return self._kiwi_saver_opt_out_date

    @kiwi_saver_opt_out_date.setter
    def kiwi_saver_opt_out_date(self, kiwi_saver_opt_out_date):
        """Sets the kiwi_saver_opt_out_date of this EmployeeTax.

        Opt Out Date.  # noqa: E501

        :param kiwi_saver_opt_out_date: The kiwi_saver_opt_out_date of this EmployeeTax.  # noqa: E501
        :type: date
        """

        self._kiwi_saver_opt_out_date = kiwi_saver_opt_out_date

    @property
    def kiwi_saver_contribution_holiday_end_date(self):
        """Gets the kiwi_saver_contribution_holiday_end_date of this EmployeeTax.  # noqa: E501

        Contribution holiday expiry date or end date.  # noqa: E501

        :return: The kiwi_saver_contribution_holiday_end_date of this EmployeeTax.  # noqa: E501
        :rtype: date
        """
        return self._kiwi_saver_contribution_holiday_end_date

    @kiwi_saver_contribution_holiday_end_date.setter
    def kiwi_saver_contribution_holiday_end_date(
        self, kiwi_saver_contribution_holiday_end_date
    ):
        """Sets the kiwi_saver_contribution_holiday_end_date of this EmployeeTax.

        Contribution holiday expiry date or end date.  # noqa: E501

        :param kiwi_saver_contribution_holiday_end_date: The kiwi_saver_contribution_holiday_end_date of this EmployeeTax.  # noqa: E501
        :type: date
        """

        self._kiwi_saver_contribution_holiday_end_date = (
            kiwi_saver_contribution_holiday_end_date
        )

    @property
    def has_student_loan_balance(self):
        """Gets the has_student_loan_balance of this EmployeeTax.  # noqa: E501

        Does the employee have a remaining student loan balance? Set a remaining balance if you have received a letter from IR.  # noqa: E501

        :return: The has_student_loan_balance of this EmployeeTax.  # noqa: E501
        :rtype: bool
        """
        return self._has_student_loan_balance

    @has_student_loan_balance.setter
    def has_student_loan_balance(self, has_student_loan_balance):
        """Sets the has_student_loan_balance of this EmployeeTax.

        Does the employee have a remaining student loan balance? Set a remaining balance if you have received a letter from IR.  # noqa: E501

        :param has_student_loan_balance: The has_student_loan_balance of this EmployeeTax.  # noqa: E501
        :type: bool
        """

        self._has_student_loan_balance = has_student_loan_balance

    @property
    def student_loan_balance(self):
        """Gets the student_loan_balance of this EmployeeTax.  # noqa: E501

        The employee's student loan balance shown on the letter from IR.  # noqa: E501

        :return: The student_loan_balance of this EmployeeTax.  # noqa: E501
        :rtype: float
        """
        return self._student_loan_balance

    @student_loan_balance.setter
    def student_loan_balance(self, student_loan_balance):
        """Sets the student_loan_balance of this EmployeeTax.

        The employee's student loan balance shown on the letter from IR.  # noqa: E501

        :param student_loan_balance: The student_loan_balance of this EmployeeTax.  # noqa: E501
        :type: float
        """

        self._student_loan_balance = student_loan_balance

    @property
    def student_loan_as_at(self):
        """Gets the student_loan_as_at of this EmployeeTax.  # noqa: E501

        The date of the letter from IR.  # noqa: E501

        :return: The student_loan_as_at of this EmployeeTax.  # noqa: E501
        :rtype: date
        """
        return self._student_loan_as_at

    @student_loan_as_at.setter
    def student_loan_as_at(self, student_loan_as_at):
        """Sets the student_loan_as_at of this EmployeeTax.

        The date of the letter from IR.  # noqa: E501

        :param student_loan_as_at: The student_loan_as_at of this EmployeeTax.  # noqa: E501
        :type: date
        """

        self._student_loan_as_at = student_loan_as_at
