import { DocumentationLanguage } from './language';
/**
 * Key prefix for the package data storage.
 */
export declare const STORAGE_KEY_PREFIX = "data/";
/**
 * Key suffix for storing npm package bundles.
 */
export declare const PACKAGE_KEY_SUFFIX = "/package.tgz";
/**
 * Key suffix for storing npm package metadata.
 */
export declare const METADATA_KEY_SUFFIX = "/metadata.json";
/**
 * The key suffix for (TypeScript) assembly files
 */
export declare const ASSEMBLY_KEY_SUFFIX = "/assembly.json";
/**
 * The key suffix for a TypeScript doc artifact (root module).
 */
export declare const DOCS_KEY_SUFFIX_TYPESCRIPT: string;
/**
 * The key suffix for a Python doc artifact (root module).
 */
export declare const DOCS_KEY_SUFFIX_PYTHON: string;
/**
 * The key suffix for a Python doc artifact (root module).
 */
export declare const DOCS_KEY_SUFFIX_JAVA: string;
/**
 * The key suffix for a Python doc artifact (root module).
 */
export declare const DOCS_KEY_SUFFIX_CSHARP: string;
/**
 * The key suffix matching any documentation artifact.
 */
export declare const DOCS_KEY_SUFFIX_ANY: string;
/**
 * Return the S3 object key prefix for a specific package name and optionally a
 * version. Note that the prefix does not end with a "/" so you will likely want
 * to add that if you want to match a specific set of objects.
 */
export declare function getObjectKeyPrefix(packageName: string, packageVersion?: string): string;
/**
 * Resolves the set of S3 object keys use for a specific package/version.
 */
export declare function getObjectKeys(packageName: string, packageVersion: string): {
    assemblyKey: string;
    packageKey: string;
    metadataKey: string;
};
/**
 * The key suffix for documentation artifacts by language and submodule.
 */
export declare function docsKeySuffix(lang?: DocumentationLanguage | '*', submodule?: string): string;
/**
 * Key suffix for beacon files when a particular feature is not supported for
 * the particular package (i.e: Python docs for a package that does not have a
 * Python target configured).
 */
export declare const NOT_SUPPORTED_SUFFIX = ".not-supported";
/**
 * The key for the catalog document.
 */
export declare const CATALOG_KEY = "catalog.json";
/**
 * A regular expression that can be used to parse out a storage key.
 */
export declare const STORAGE_KEY_FORMAT_REGEX: RegExp;
