# Generated by Django 2.1.4 on 2018-12-29 20:59

from django.conf import settings
import django.core.files.storage
from django.db import migrations, models
import django.db.models.deletion
import rest_mediabrowser.models
import taggit.managers


class Migration(migrations.Migration):

    replaces = [('rest_mediabrowser', '0001_initial'), ('rest_mediabrowser', '0002_auto_20181229_1011'),
                ('rest_mediabrowser', '0003_auto_20181229_1128'), ('rest_mediabrowser', '0004_auto_20181229_1910')]

    initial = True

    dependencies = [
        ('taggit', '0002_auto_20150616_2121'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Collection',
            fields=[
                ('id', models.AutoField(auto_created=True,
                                        primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500, verbose_name='name')),
            ],
        ),
        migrations.CreateModel(
            name='CollectionPermission',
            fields=[
                ('id', models.AutoField(auto_created=True,
                                        primary_key=True, serialize=False, verbose_name='ID')),
                ('permission', models.CharField(choices=[
                 ('e', 'Edit'), ('v', 'View')], max_length=2, verbose_name='permission')),
                ('collection', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, to='rest_mediabrowser.Collection')),
                ('user', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='FilePermission',
            fields=[
                ('id', models.AutoField(auto_created=True,
                                        primary_key=True, serialize=False, verbose_name='ID')),
                ('permission', models.CharField(choices=[
                 ('e', 'Edit'), ('v', 'View')], max_length=2, verbose_name='permission')),
            ],
        ),
        migrations.CreateModel(
            name='ImagePermission',
            fields=[
                ('id', models.AutoField(auto_created=True,
                                        primary_key=True, serialize=False, verbose_name='ID')),
                ('permission', models.CharField(choices=[
                 ('e', 'Edit'), ('v', 'View')], max_length=2, verbose_name='permission')),
            ],
        ),
        migrations.CreateModel(
            name='MediaFile',
            fields=[
                ('id', models.AutoField(auto_created=True,
                                        primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(blank=True,
                                                 max_length=500, verbose_name='description')),
                ('file', models.FileField(max_length=500, storage=django.core.files.storage.FileSystemStorage(
                    location='/app/server/rest_mediabrowser_files'), upload_to=rest_mediabrowser.models.file_upload_path, verbose_name='file')),
                ('collection', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                                 related_name='media_files', to='rest_mediabrowser.Collection', verbose_name='collection')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                            related_name='media_files', to=settings.AUTH_USER_MODEL, verbose_name='owner')),
                ('shared_with', models.ManyToManyField(related_name='shared_files',
                                                       through='rest_mediabrowser.FilePermission', to=settings.AUTH_USER_MODEL, verbose_name='shared_with')),
                ('tags', taggit.managers.TaggableManager(help_text='A comma-separated list of tags.',
                                                         through='taggit.TaggedItem', to='taggit.Tag', verbose_name='Tags')),
                ('published', models.BooleanField(
                    default=False, verbose_name='Status')),
            ],
        ),
        migrations.CreateModel(
            name='MediaImage',
            fields=[
                ('id', models.AutoField(auto_created=True,
                                        primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(blank=True,
                                                 max_length=500, verbose_name='description')),
                ('alt_text', models.CharField(blank=True,
                                              max_length=100, verbose_name='alternative text')),
                ('height', models.IntegerField(blank=True, verbose_name='height')),
                ('width', models.IntegerField(blank=True, verbose_name='width')),
                ('image', models.ImageField(height_field='height', max_length=500, storage=django.core.files.storage.FileSystemStorage(
                    location='/app/server/rest_mediabrowser_files'), upload_to=rest_mediabrowser.models.image_upload_path, verbose_name='image', width_field='width')),
                ('collection', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                                 related_name='image_files', to='rest_mediabrowser.Collection', verbose_name='collection')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                            related_name='media_images', to=settings.AUTH_USER_MODEL, verbose_name='owner')),
                ('shared_with', models.ManyToManyField(related_name='shared_images',
                                                       through='rest_mediabrowser.ImagePermission', to=settings.AUTH_USER_MODEL, verbose_name='shared_with')),
                ('tags', taggit.managers.TaggableManager(blank=True, help_text='A comma-separated list of tags.',
                                                         through='taggit.TaggedItem', to='taggit.Tag', verbose_name='Tags')),
                ('published', models.BooleanField(
                    default=False, verbose_name='Status')),
            ],
        ),
        migrations.AddField(
            model_name='imagepermission',
            name='image',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to='rest_mediabrowser.MediaImage'),
        ),
        migrations.AddField(
            model_name='imagepermission',
            name='user',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='filepermission',
            name='file',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to='rest_mediabrowser.MediaFile'),
        ),
        migrations.AddField(
            model_name='filepermission',
            name='user',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='collection',
            name='shared_with',
            field=models.ManyToManyField(related_name='shared_collections', through='rest_mediabrowser.CollectionPermission',
                                         to=settings.AUTH_USER_MODEL, verbose_name='shared_with'),
        ),
        migrations.AddField(
            model_name='collection',
            name='owner',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='collections', to=settings.AUTH_USER_MODEL, verbose_name='user'),
        ),
    ]
