"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Image = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const _shell_1 = require("./_shell");
const PARSE_DIGEST = /digest:\ (sha256:[0-9a-f]+)/;
/**
 * Represents a docker image built during synthesis from a context directory
 * (`dir`) with a `Dockerfile`.
 *
 * The image will be built using `docker build` and then pushed through `docker
 * push`. The URL of the pushed image can be accessed through `image.url`.
 *
 * If you push to a registry other then docker hub, you can specify the registry
 * URL through the `registry` option.
 */
class Image extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        const registry = (_b = props.registry) !== null && _b !== void 0 ? _b : 'docker.io/library';
        const tag = `${registry}/${cdk8s_1.Names.toDnsLabel(this)}`;
        const buildArgs = (_d = (_c = props.buildArgs) === null || _c === void 0 ? void 0 : _c.map(arg => `--build-arg ${arg.name}=${arg.value}`)) !== null && _d !== void 0 ? _d : [];
        console.error(`building docker image "${props.dir}"...`);
        _shell_1.shell('docker', 'build', '-t', tag, props.dir, ...buildArgs);
        console.error(`pushing docker image "${props.dir}"...`);
        const push = _shell_1.shell('docker', 'push', tag);
        const result = PARSE_DIGEST.exec(push);
        if (!result) {
            throw new Error(`unable to read image digest after push: ${push}`);
        }
        this.url = `${tag}@${result[1]}`;
    }
}
exports.Image = Image;
_a = JSII_RTTI_SYMBOL_1;
Image[_a] = { fqn: "cdk8s-image.Image", version: "0.2.107" };
//# sourceMappingURL=data:application/json;base64,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