# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['uasyncio']

package_data = \
{'': ['*']}

modules = \
['_onewire',
 '_thread',
 '_uasyncio',
 'array',
 'binascii',
 'cmath',
 'dht',
 'errno',
 'ffi',
 'framebuf',
 'gc',
 'hashlib',
 'heapq',
 'json',
 'lcd160cr',
 'lcd160cr_test',
 'logging',
 'machine',
 'math',
 'micropython',
 'network',
 'onewire',
 'os',
 'platform',
 'pyb',
 'pycopy',
 'pycopy_imphook',
 'random',
 'select',
 'socket',
 'stm',
 'struct',
 'sys',
 'time',
 'uarray',
 'ubinascii',
 'ucollections',
 'uctypes',
 'uerrno',
 'uhashlib',
 'uheapq',
 'uio',
 'ujson',
 'ulogging',
 'umachine',
 'uos',
 'uplatform',
 'urandom',
 'ure',
 'uselect',
 'usocket',
 'ussl',
 'ustruct',
 'usys',
 'utime',
 'utimeq',
 'utokenize',
 'uzlib',
 'zlib']
setup_kwargs = {
    'name': 'micropython-stm32-stubs',
    'version': '1.18.post3',
    'description': 'MicroPython stubs',
    'long_description': '# micropython-stm32-stubs\n\n\nThis is a stub-only package for MicroPython.\nIt is intended to be installed in a projects virtual environment to allow static type checkers and intellisense features to be used while writing Micropython code.\n\nThe version of this package is alligned the the version of the MicroPython firmware.\n - Major, Minor and Patch levels are alligned to the same version as the firmware.  \n - The post release level is used to publish new releases of the stubs.\n\nFor `Micropython 1.17` the stubs are published as `1.17.post1` ... `1.17.post2`  \nfor `Micropython 1.18` the stubs are published as `1.18.post1` ... `1.18.post2`  \n\nTo install the latest stubs:  \n`pip install -I  micropython-<port>-stubs` where port is the port of the MicroPython firmware.\n\nTo install the stubs for an older version, such as MicroPython 1.17:  \n`pip install micropython-stm32-stubs==1.17.*` which will install the last post release of the stubs for MicroPython 1.17.\n\n\nAs the creation of the stubs, and merging of the different types is still going though improvements, the stub packages are marked as Beta.\nTo upgrade stubs to the latest stubs for a specific version use `pip install micropython-stm32-stubs==1.17.* --upgrade`\n\nIf you have suggestions or find any issues with the stubs, please report them in the [MicroPython-stubs Discussions](https://github.com/Josverl/micropython-stubs/discussions)\n\nFor an overview of  Micropython Stubs please see: https://micropython-stubs.readthedocs.io/en/main/ \n * List of all stubs : https://micropython-stubs.readthedocs.io/en/main/firmware_grp.html\n\nIncluded stubs:\n* Merged stubs from micropython-v1_18-stm32-merged\n* Frozen stubs from micropython-v1_18-frozen/stm32/GENERIC\n* Core Stubs from cpython_core-pycopy\n',
    'author': 'josverl',
    'author_email': 'josverl@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/josverl/micropython-stubs#micropython-stubs',
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
