import * as acm from '@aws-cdk/aws-certificatemanager';
import * as route53 from '@aws-cdk/aws-route53';
import { Construct as CoreConstruct } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * Props for `DomainRedirect`.
 */
export interface DomainRedirectProps {
    /**
     * Source hosted zone.
     */
    readonly source: DomainRedirectSource;
    /**
     * The domain name to redirect to (e.g. `foo.com`).
     */
    readonly targetDomainName: string;
}
/**
 * Redirects one domain to another domain using S3 and CloudFront.
 */
export declare class DomainRedirect extends CoreConstruct {
    constructor(scope: Construct, id: string, props: DomainRedirectProps);
    /**
     * Gets or creates a bucket which redirects all requests to the given domain name.
     *
     * @param domainName The target domain name
     * @returns An S3 bucket
     */
    private getOrCreateBucket;
    /**
     * Returns a singleton construct scope (stack-level) that includes all the
     * buckets used for domain redirection.
     *
     * @returns A construct
     */
    private getOrCreateBucketsScope;
}
/**
 * (experimental) Source domain of the redirect.
 *
 * @experimental
 */
export interface DomainRedirectSource {
    /**
     * (experimental) The route53 zone which hosts the source domain.
     *
     * @experimental
     */
    readonly hostedZone: route53.IHostedZone;
    /**
     * (experimental) The ACM certificate to use for the CloudFront distribution.
     *
     * @default - a certificate is created for this domain.
     * @experimental
     */
    readonly certificate?: acm.ICertificate;
}
