"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagConditionReadme = exports.TagConditionField = exports.TagConditionLogicType = exports.TagCondition = exports.TagConditionSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * @experimental
 */
var TagConditionSource;
(function (TagConditionSource) {
    TagConditionSource["PACKAGE_JSON"] = "PACKAGE_JSON";
    TagConditionSource["README"] = "README";
})(TagConditionSource = exports.TagConditionSource || (exports.TagConditionSource = {}));
/**
 * (experimental) Condition for applying a custom tag to a package.
 *
 * @experimental
 */
class TagCondition {
    /**
     * (experimental) Create an && condition which applies only when all condition arguments are true.
     *
     * @experimental
     */
    static and(...conds) {
        return new TagConditionLogic(TagConditionLogicType.AND, conds);
    }
    /**
     * (experimental) Create an || condition which applies if any of the condition arguments are true.
     *
     * @experimental
     */
    static or(...conds) {
        return new TagConditionLogic(TagConditionLogicType.OR, conds);
    }
    /**
     * (experimental) Create a !
     *
     * condition which applies if the condition argument is false
     *
     * @experimental
     */
    static not(...conds) {
        return new TagConditionLogic(TagConditionLogicType.NOT, conds);
    }
    /**
     * (experimental) Target a field within the `package.json` to assert against. Nested fields can be accessed by passing multiple keys. `TagCondition.field('key1', 'key2')` will access `packageJson?.key1?.key2`.
     *
     * @experimental
     */
    static field(...keys) {
        return new TagConditionField(keys);
    }
    /**
     * (experimental) Create a condition with logic targeting the README of the package.
     *
     * @experimental
     */
    static readme() {
        return new TagConditionReadme();
    }
}
exports.TagCondition = TagCondition;
_a = JSII_RTTI_SYMBOL_1;
TagCondition[_a] = { fqn: "construct-hub.TagCondition", version: "0.3.196" };
/**
 * (experimental) Logic operators for performing specific conditional logic.
 *
 * @experimental
 */
var TagConditionLogicType;
(function (TagConditionLogicType) {
    TagConditionLogicType["AND"] = "AND";
    TagConditionLogicType["OR"] = "OR";
    TagConditionLogicType["NOT"] = "NOT";
    TagConditionLogicType["EQUALS"] = "EQUALS";
    TagConditionLogicType["INCLUDES"] = "INCLUDES";
    TagConditionLogicType["STARTS_WITH"] = "STARTS_WITH";
})(TagConditionLogicType = exports.TagConditionLogicType || (exports.TagConditionLogicType = {}));
class TagConditionLogic extends TagCondition {
    constructor(type, children) {
        super();
        this.type = type;
        this.children = children;
        this.isLogic = true;
    }
    bind() {
        return {
            type: this.type,
            children: this.children.map((cond) => cond.bind()),
        };
    }
}
class TagConditionPredicate extends TagCondition {
    constructor(type, source, key, value, options) {
        super();
        this.type = type;
        this.source = source;
        this.key = key;
        this.value = value;
        this.options = options;
        this.isPredicate = true;
    }
    bind() {
        return {
            type: this.type,
            source: this.source,
            key: this.key,
            value: this.value,
            options: this.options,
        };
    }
}
/**
 * (experimental) Target a field to use in logic to dictate whether a tag is relevant.
 *
 * @experimental
 */
class TagConditionField {
    /**
     * @experimental
     */
    constructor(field) {
        this.field = field;
    }
    /**
     * (experimental) Create a === condition which applies if the specified field within the package's package.json is equal to the passed value.
     *
     * @experimental
     */
    eq(value) {
        return new TagConditionPredicate(TagConditionLogicType.EQUALS, TagConditionSource.PACKAGE_JSON, this.field, value);
    }
    /**
     * (experimental) Create a `field.includes(value)` condition which applies if the specified field within the package's package.json includes the value. This works for arrays or strings.
     *
     * @experimental
     */
    includes(value, options = {}) {
        return new TagConditionPredicate(TagConditionLogicType.INCLUDES, TagConditionSource.PACKAGE_JSON, this.field, value, options);
    }
    /**
     * (experimental) Create a `field.startsWith(value)` condition which applies if the specified field within the package's package.json begins with the value. This works only for string values.
     *
     * @experimental
     */
    startsWith(value) {
        return new TagConditionPredicate(TagConditionLogicType.STARTS_WITH, TagConditionSource.PACKAGE_JSON, this.field, value);
    }
}
exports.TagConditionField = TagConditionField;
_b = JSII_RTTI_SYMBOL_1;
TagConditionField[_b] = { fqn: "construct-hub.TagConditionField", version: "0.3.196" };
/**
 * (experimental) Target the README of the package to dictate whether a tag is relevant.
 *
 * @experimental
 */
class TagConditionReadme {
    /**
     * @experimental
     */
    constructor() { }
    /**
     * (experimental) Create a `readme.includes(value)` condition which applies if the README includes the specified string.
     *
     * @experimental
     */
    includes(value, options = {}) {
        return new TagConditionPredicate(TagConditionLogicType.INCLUDES, TagConditionSource.README, undefined, // no key
        value, options);
    }
}
exports.TagConditionReadme = TagConditionReadme;
_c = JSII_RTTI_SYMBOL_1;
TagConditionReadme[_c] = { fqn: "construct-hub.TagConditionReadme", version: "0.3.196" };
//# sourceMappingURL=data:application/json;base64,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