# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_hub_sdk', 'django_hub_sdk.migrations']

package_data = \
{'': ['*']}

install_requires = \
['django>=3.0,<4.0', 'djangorestframework', 'requests>=2.27.1,<3.0.0']

setup_kwargs = {
    'name': 'django-hub-sdk',
    'version': '0.1.14',
    'description': 'The ISS (International Space Station) aims to be a space station (client) of connection between the microservices of its ecosystem and the authentication and permissions microservice of the user that here is called in the script as Hub.permissions modules / microservices (Hub)',
    'long_description': '# django-hub-sdk\n\n![PyPI](https://img.shields.io/pypi/v/django-hub-sdk)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/django-hub-sdk)\n[![Django Hub SDK](https://github.com/bildvitta/django-hub-sdk/actions/workflows/main.yml/badge.svg)](https://github.com/bildvitta/django-hub-sdk/actions/workflows/main.yml)\n\n## What Is This?\n\nThe ISS (International Space Station) aims to be a space station (client) of connection between the microservices of its\necosystem and the authentication and permissions microservice of the user that here is called in the script as\nHub.permissions modules / microservices (Hub)\n\n## How To Use This\n\n### Installation\n\n```shell\npip install django-hub-sdk\n```\n\nor if you are using Pipenv or Poetry\n\n```shell\npipenv install django-hub-sdk\n```\n\n```shell\npoetry add django-hub-sdk\n```\n\n### Settings\n\nAdd the app to installed apps\n\n```python\nINSTALLED_APPS = [\n    ...,\n    "django_hub_sdk",\n    ...,\n]\n```\n\nAll settings can be modified through environment variables, so if you are using `.env` please use it.\n\n**Mandatory Settings**\n\n```python\nimport os \n\nHUB_APP_SLUG = "" # project name on the hub\n\nHUB_BASE_URI = os.environ.get("HUB_BASE_URI", "") # HUB backend url\nHUB_BASE_FRONT_URI = os.environ.get(\n    "HUB_BASE_FRONT_URI", "" # HUB frontend url\n)\n\nHUB_PROGRAMMATIC_CLIENT = os.environ.get("HUB_PROGRAMMATIC_CLIENT", "") # Programmatic user access public key\nHUB_PROGRAMMATIC_SECRET = os.environ.get("HUB_PROGRAMMATIC_SECRET", "") # Programmatic user access private key\n\nHUB_OAUTH_CLIENT_ID = os.environ.get("HUB_OAUTH_CLIENT_ID", "") # Public oauth access key\nHUB_OAUTH_CLIENT_SECRET = os.environ.get("HUB_OAUTH_CLIENT_SECRET", "") # Private oauth access key\nHUB_OAUTH_REDIRECT = os.environ.get("HUB_OAUTH_REDIRECT", "") # oauth access return URL\n```\n\n### User Model\n\nTo continue the installation, in your User model extend the class below to be able to create the necessary relationships with the HUB\n\n```python\nfrom django.contrib.auth.models import AbstractUser\n\nfrom django_hub_sdk.models import BaseHubUser # <- Import BaseHubUser\n\n\n# Create your models here.\nclass User(AbstractUser, BaseHubUser): # <- Extends this on model\n    ...\n```\n\n### Urls\n\nAdd this line to your urls.py to work with the frontend SDK\n\n```python\nfrom django.urls import path, include\n\nurlpatterns = [\n    path("api/", include("django_hub_sdk.urls", namespace="django_hub_sdk"))\n]\n```\n\n## Use of Authorization\n\nUse of authorizations to use the JWT generated by the Hub\n\n```python\nfrom django_hub_sdk.authentication import HubJWTAuthentication # Import from package\n\nfrom rest_framework import views\n\nclass LogoutView(views.APIView):\n    authentication_classes = [HubJWTAuthentication] # <- Use on authentication_classes\n```\n\n',
    'author': 'Guilherme Haynes Howe',
    'author_email': 'zerossb@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/bildvitta/django-hub-sdk',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
