# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-07-23 03:33
from __future__ import unicode_literals

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [migrations.swappable_dependency(settings.AUTH_USER_MODEL)]

    operations = [
        migrations.CreateModel(
            name="CronTask",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("cron_job", models.CharField(max_length=255)),
                ("params", models.TextField(blank=True)),
                (
                    "start_at",
                    models.DateTimeField(
                        blank=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("waiting", "Waiting"),
                            ("queued", "Queued"),
                            ("started", "Started"),
                            ("finished", "Finished"),
                            ("failed", "Failed"),
                        ],
                        default="waiting",
                        max_length=16,
                    ),
                ),
                ("pid", models.PositiveIntegerField(blank=True, null=True)),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, null=True),
                ),
                ("started_at", models.DateTimeField(blank=True, null=True)),
                ("finished_at", models.DateTimeField(blank=True, null=True)),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        )
    ]
