"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Source = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ecr_assets = require("aws-cdk-lib/aws-ecr-assets");
/**
 * Specifies docker image deployment source
 *
 * Usage:
 *
 * ```ts
 * import * as path from 'path';
 * const path = path.join(__dirname, 'path/to/directory');
 * const sourceDirectory = Source.directory(path);
 * ```
 *
 */
class Source {
    /**
     * Uses a local image built from a Dockerfile in a local directory as the source.
     *
     * @param path - path to the directory containing your Dockerfile (not a path to a file)
     */
    static directory(path) {
        return new DirectorySource(path);
    }
}
exports.Source = Source;
_a = JSII_RTTI_SYMBOL_1;
Source[_a] = { fqn: "cdk-docker-image-deployment.Source", version: "0.0.167" };
/**
 * Source of docker image deployment is a local image from a directory
 */
class DirectorySource extends Source {
    constructor(path) {
        super();
        this.path = path;
    }
    bind(scope, context) {
        const asset = new ecr_assets.DockerImageAsset(scope, 'asset', {
            directory: this.path,
        });
        const accountId = asset.repository.env.account;
        const region = asset.repository.env.region;
        asset.repository.grantPull(context.handlerRole);
        return {
            imageUri: asset.imageUri,
            loginConfig: {
                loginCommand: `aws ecr get-login-password --region ${region} | docker login --username AWS --password-stdin ${accountId}.dkr.ecr.${region}.amazonaws.com`,
                region: region,
            },
            imageTag: aws_cdk_lib_1.Fn.select(1, aws_cdk_lib_1.Fn.split(':', asset.imageUri)),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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