# Generated by Django 3.0.9 on 2020-10-29 15:09

from django.db import migrations, models


def set_position(apps, schema_editor):
    """
    Set position value for Slideshow.
    """
    Slideshow = apps.get_model("slideshow", "Slideshow")

    position = 1

    for obj in Slideshow.objects.order_by("id"):
        obj.position = position
        obj.save()
        position += 1


class Migration(migrations.Migration):

    dependencies = [
        ("slideshow", "0007_assign_photograph_as_img_field_slideshow_image_model"),
    ]

    operations = [
        migrations.AddField(
            model_name="slideshow",
            name="active",
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name="slideshow",
            name="position",
            field=models.PositiveSmallIntegerField(default=1),
        ),
        migrations.RunPython(set_position, migrations.RunPython.noop),
    ]
