/**
 * Builder options
 */
export interface BuilderOptions {
    /**
     * Entry file
     */
    readonly entry: string;
    /**
     * The output directory
     */
    readonly outDir: string;
    /**
     * The output directory
     */
    readonly buildCmd: string;
    /**
     * The handler name, also name of compiled file, defaults to `main`
     */
    readonly handler: string;
    /**
     * Additional env variables
     */
    readonly extraEnv: string;
}
/**
 * Builder
 */
export declare class Builder {
    private readonly entry;
    private readonly outDir;
    private readonly buildCmd;
    private readonly handler;
    private readonly extraEnv;
    constructor(options: BuilderOptions);
    build(): void;
}
