"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const path = require("path");
/**
 * Builder
 */
class Builder {
    constructor(options) {
        this.entry = options.entry;
        this.outDir = options.outDir;
        this.buildCmd = options.buildCmd;
        this.handler = options.handler;
        this.extraEnv = options.extraEnv;
    }
    build() {
        try {
            const cmd = `${this.buildCmd} -o ${this.outDir}/${this.handler} ${this.entry}`;
            const cwd = path.dirname(this.entry);
            child_process_1.spawnSync(cmd, {
                env: { ...process.env, GOOS: 'linux', ...this.extraEnv },
                shell: true,
                cwd,
            });
        }
        catch (err) {
        }
        finally {
        }
    }
}
exports.Builder = Builder;
//# sourceMappingURL=data:application/json;base64,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