var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toModule = (module2) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};

// node_modules/fs-extra/node_modules/universalify/index.js
var require_universalify = __commonJS({
  "node_modules/fs-extra/node_modules/universalify/index.js"(exports) {
    "use strict";
    exports.fromCallback = function(fn) {
      return Object.defineProperty(function(...args) {
        if (typeof args[args.length - 1] === "function")
          fn.apply(this, args);
        else {
          return new Promise((resolve, reject) => {
            fn.call(this, ...args, (err, res) => err != null ? reject(err) : resolve(res));
          });
        }
      }, "name", { value: fn.name });
    };
    exports.fromPromise = function(fn) {
      return Object.defineProperty(function(...args) {
        const cb = args[args.length - 1];
        if (typeof cb !== "function")
          return fn.apply(this, args);
        else
          fn.apply(this, args.slice(0, -1)).then((r) => cb(null, r), cb);
      }, "name", { value: fn.name });
    };
  }
});

// node_modules/graceful-fs/polyfills.js
var require_polyfills = __commonJS({
  "node_modules/graceful-fs/polyfills.js"(exports, module2) {
    var constants2 = require("constants");
    var origCwd = process.cwd;
    var cwd = null;
    var platform = process.env.GRACEFUL_FS_PLATFORM || process.platform;
    process.cwd = function() {
      if (!cwd)
        cwd = origCwd.call(process);
      return cwd;
    };
    try {
      process.cwd();
    } catch (er) {
    }
    if (typeof process.chdir === "function") {
      chdir = process.chdir;
      process.chdir = function(d) {
        cwd = null;
        chdir.call(process, d);
      };
      if (Object.setPrototypeOf)
        Object.setPrototypeOf(process.chdir, chdir);
    }
    var chdir;
    module2.exports = patch;
    function patch(fs2) {
      if (constants2.hasOwnProperty("O_SYMLINK") && process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)) {
        patchLchmod(fs2);
      }
      if (!fs2.lutimes) {
        patchLutimes(fs2);
      }
      fs2.chown = chownFix(fs2.chown);
      fs2.fchown = chownFix(fs2.fchown);
      fs2.lchown = chownFix(fs2.lchown);
      fs2.chmod = chmodFix(fs2.chmod);
      fs2.fchmod = chmodFix(fs2.fchmod);
      fs2.lchmod = chmodFix(fs2.lchmod);
      fs2.chownSync = chownFixSync(fs2.chownSync);
      fs2.fchownSync = chownFixSync(fs2.fchownSync);
      fs2.lchownSync = chownFixSync(fs2.lchownSync);
      fs2.chmodSync = chmodFixSync(fs2.chmodSync);
      fs2.fchmodSync = chmodFixSync(fs2.fchmodSync);
      fs2.lchmodSync = chmodFixSync(fs2.lchmodSync);
      fs2.stat = statFix(fs2.stat);
      fs2.fstat = statFix(fs2.fstat);
      fs2.lstat = statFix(fs2.lstat);
      fs2.statSync = statFixSync(fs2.statSync);
      fs2.fstatSync = statFixSync(fs2.fstatSync);
      fs2.lstatSync = statFixSync(fs2.lstatSync);
      if (!fs2.lchmod) {
        fs2.lchmod = function(path2, mode, cb) {
          if (cb)
            process.nextTick(cb);
        };
        fs2.lchmodSync = function() {
        };
      }
      if (!fs2.lchown) {
        fs2.lchown = function(path2, uid, gid, cb) {
          if (cb)
            process.nextTick(cb);
        };
        fs2.lchownSync = function() {
        };
      }
      if (platform === "win32") {
        fs2.rename = function(fs$rename) {
          return function(from, to, cb) {
            var start = Date.now();
            var backoff = 0;
            fs$rename(from, to, function CB(er) {
              if (er && (er.code === "EACCES" || er.code === "EPERM") && Date.now() - start < 6e4) {
                setTimeout(function() {
                  fs2.stat(to, function(stater, st) {
                    if (stater && stater.code === "ENOENT")
                      fs$rename(from, to, CB);
                    else
                      cb(er);
                  });
                }, backoff);
                if (backoff < 100)
                  backoff += 10;
                return;
              }
              if (cb)
                cb(er);
            });
          };
        }(fs2.rename);
      }
      fs2.read = function(fs$read) {
        function read(fd, buffer, offset, length, position, callback_) {
          var callback;
          if (callback_ && typeof callback_ === "function") {
            var eagCounter = 0;
            callback = function(er, _, __) {
              if (er && er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                return fs$read.call(fs2, fd, buffer, offset, length, position, callback);
              }
              callback_.apply(this, arguments);
            };
          }
          return fs$read.call(fs2, fd, buffer, offset, length, position, callback);
        }
        if (Object.setPrototypeOf)
          Object.setPrototypeOf(read, fs$read);
        return read;
      }(fs2.read);
      fs2.readSync = function(fs$readSync) {
        return function(fd, buffer, offset, length, position) {
          var eagCounter = 0;
          while (true) {
            try {
              return fs$readSync.call(fs2, fd, buffer, offset, length, position);
            } catch (er) {
              if (er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                continue;
              }
              throw er;
            }
          }
        };
      }(fs2.readSync);
      function patchLchmod(fs3) {
        fs3.lchmod = function(path2, mode, callback) {
          fs3.open(path2, constants2.O_WRONLY | constants2.O_SYMLINK, mode, function(err, fd) {
            if (err) {
              if (callback)
                callback(err);
              return;
            }
            fs3.fchmod(fd, mode, function(err2) {
              fs3.close(fd, function(err22) {
                if (callback)
                  callback(err2 || err22);
              });
            });
          });
        };
        fs3.lchmodSync = function(path2, mode) {
          var fd = fs3.openSync(path2, constants2.O_WRONLY | constants2.O_SYMLINK, mode);
          var threw = true;
          var ret;
          try {
            ret = fs3.fchmodSync(fd, mode);
            threw = false;
          } finally {
            if (threw) {
              try {
                fs3.closeSync(fd);
              } catch (er) {
              }
            } else {
              fs3.closeSync(fd);
            }
          }
          return ret;
        };
      }
      function patchLutimes(fs3) {
        if (constants2.hasOwnProperty("O_SYMLINK")) {
          fs3.lutimes = function(path2, at, mt, cb) {
            fs3.open(path2, constants2.O_SYMLINK, function(er, fd) {
              if (er) {
                if (cb)
                  cb(er);
                return;
              }
              fs3.futimes(fd, at, mt, function(er2) {
                fs3.close(fd, function(er22) {
                  if (cb)
                    cb(er2 || er22);
                });
              });
            });
          };
          fs3.lutimesSync = function(path2, at, mt) {
            var fd = fs3.openSync(path2, constants2.O_SYMLINK);
            var ret;
            var threw = true;
            try {
              ret = fs3.futimesSync(fd, at, mt);
              threw = false;
            } finally {
              if (threw) {
                try {
                  fs3.closeSync(fd);
                } catch (er) {
                }
              } else {
                fs3.closeSync(fd);
              }
            }
            return ret;
          };
        } else {
          fs3.lutimes = function(_a, _b, _c, cb) {
            if (cb)
              process.nextTick(cb);
          };
          fs3.lutimesSync = function() {
          };
        }
      }
      function chmodFix(orig) {
        if (!orig)
          return orig;
        return function(target, mode, cb) {
          return orig.call(fs2, target, mode, function(er) {
            if (chownErOk(er))
              er = null;
            if (cb)
              cb.apply(this, arguments);
          });
        };
      }
      function chmodFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, mode) {
          try {
            return orig.call(fs2, target, mode);
          } catch (er) {
            if (!chownErOk(er))
              throw er;
          }
        };
      }
      function chownFix(orig) {
        if (!orig)
          return orig;
        return function(target, uid, gid, cb) {
          return orig.call(fs2, target, uid, gid, function(er) {
            if (chownErOk(er))
              er = null;
            if (cb)
              cb.apply(this, arguments);
          });
        };
      }
      function chownFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, uid, gid) {
          try {
            return orig.call(fs2, target, uid, gid);
          } catch (er) {
            if (!chownErOk(er))
              throw er;
          }
        };
      }
      function statFix(orig) {
        if (!orig)
          return orig;
        return function(target, options, cb) {
          if (typeof options === "function") {
            cb = options;
            options = null;
          }
          function callback(er, stats) {
            if (stats) {
              if (stats.uid < 0)
                stats.uid += 4294967296;
              if (stats.gid < 0)
                stats.gid += 4294967296;
            }
            if (cb)
              cb.apply(this, arguments);
          }
          return options ? orig.call(fs2, target, options, callback) : orig.call(fs2, target, callback);
        };
      }
      function statFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, options) {
          var stats = options ? orig.call(fs2, target, options) : orig.call(fs2, target);
          if (stats.uid < 0)
            stats.uid += 4294967296;
          if (stats.gid < 0)
            stats.gid += 4294967296;
          return stats;
        };
      }
      function chownErOk(er) {
        if (!er)
          return true;
        if (er.code === "ENOSYS")
          return true;
        var nonroot = !process.getuid || process.getuid() !== 0;
        if (nonroot) {
          if (er.code === "EINVAL" || er.code === "EPERM")
            return true;
        }
        return false;
      }
    }
  }
});

// node_modules/graceful-fs/legacy-streams.js
var require_legacy_streams = __commonJS({
  "node_modules/graceful-fs/legacy-streams.js"(exports, module2) {
    var Stream = require("stream").Stream;
    module2.exports = legacy;
    function legacy(fs2) {
      return {
        ReadStream,
        WriteStream
      };
      function ReadStream(path2, options) {
        if (!(this instanceof ReadStream))
          return new ReadStream(path2, options);
        Stream.call(this);
        var self2 = this;
        this.path = path2;
        this.fd = null;
        this.readable = true;
        this.paused = false;
        this.flags = "r";
        this.mode = 438;
        this.bufferSize = 64 * 1024;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.encoding)
          this.setEncoding(this.encoding);
        if (this.start !== void 0) {
          if (typeof this.start !== "number") {
            throw TypeError("start must be a Number");
          }
          if (this.end === void 0) {
            this.end = Infinity;
          } else if (typeof this.end !== "number") {
            throw TypeError("end must be a Number");
          }
          if (this.start > this.end) {
            throw new Error("start must be <= end");
          }
          this.pos = this.start;
        }
        if (this.fd !== null) {
          process.nextTick(function() {
            self2._read();
          });
          return;
        }
        fs2.open(this.path, this.flags, this.mode, function(err, fd) {
          if (err) {
            self2.emit("error", err);
            self2.readable = false;
            return;
          }
          self2.fd = fd;
          self2.emit("open", fd);
          self2._read();
        });
      }
      function WriteStream(path2, options) {
        if (!(this instanceof WriteStream))
          return new WriteStream(path2, options);
        Stream.call(this);
        this.path = path2;
        this.fd = null;
        this.writable = true;
        this.flags = "w";
        this.encoding = "binary";
        this.mode = 438;
        this.bytesWritten = 0;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.start !== void 0) {
          if (typeof this.start !== "number") {
            throw TypeError("start must be a Number");
          }
          if (this.start < 0) {
            throw new Error("start must be >= zero");
          }
          this.pos = this.start;
        }
        this.busy = false;
        this._queue = [];
        if (this.fd === null) {
          this._open = fs2.open;
          this._queue.push([this._open, this.path, this.flags, this.mode, void 0]);
          this.flush();
        }
      }
    }
  }
});

// node_modules/graceful-fs/clone.js
var require_clone = __commonJS({
  "node_modules/graceful-fs/clone.js"(exports, module2) {
    "use strict";
    module2.exports = clone;
    var getPrototypeOf = Object.getPrototypeOf || function(obj) {
      return obj.__proto__;
    };
    function clone(obj) {
      if (obj === null || typeof obj !== "object")
        return obj;
      if (obj instanceof Object)
        var copy = { __proto__: getPrototypeOf(obj) };
      else
        var copy = Object.create(null);
      Object.getOwnPropertyNames(obj).forEach(function(key) {
        Object.defineProperty(copy, key, Object.getOwnPropertyDescriptor(obj, key));
      });
      return copy;
    }
  }
});

// node_modules/graceful-fs/graceful-fs.js
var require_graceful_fs = __commonJS({
  "node_modules/graceful-fs/graceful-fs.js"(exports, module2) {
    var fs2 = require("fs");
    var polyfills = require_polyfills();
    var legacy = require_legacy_streams();
    var clone = require_clone();
    var util = require("util");
    var gracefulQueue;
    var previousSymbol;
    if (typeof Symbol === "function" && typeof Symbol.for === "function") {
      gracefulQueue = Symbol.for("graceful-fs.queue");
      previousSymbol = Symbol.for("graceful-fs.previous");
    } else {
      gracefulQueue = "___graceful-fs.queue";
      previousSymbol = "___graceful-fs.previous";
    }
    function noop() {
    }
    function publishQueue(context, queue2) {
      Object.defineProperty(context, gracefulQueue, {
        get: function() {
          return queue2;
        }
      });
    }
    var debug = noop;
    if (util.debuglog)
      debug = util.debuglog("gfs4");
    else if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || ""))
      debug = function() {
        var m = util.format.apply(util, arguments);
        m = "GFS4: " + m.split(/\n/).join("\nGFS4: ");
        console.error(m);
      };
    if (!fs2[gracefulQueue]) {
      queue = global[gracefulQueue] || [];
      publishQueue(fs2, queue);
      fs2.close = function(fs$close) {
        function close(fd, cb) {
          return fs$close.call(fs2, fd, function(err) {
            if (!err) {
              resetQueue();
            }
            if (typeof cb === "function")
              cb.apply(this, arguments);
          });
        }
        Object.defineProperty(close, previousSymbol, {
          value: fs$close
        });
        return close;
      }(fs2.close);
      fs2.closeSync = function(fs$closeSync) {
        function closeSync(fd) {
          fs$closeSync.apply(fs2, arguments);
          resetQueue();
        }
        Object.defineProperty(closeSync, previousSymbol, {
          value: fs$closeSync
        });
        return closeSync;
      }(fs2.closeSync);
      if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || "")) {
        process.on("exit", function() {
          debug(fs2[gracefulQueue]);
          require("assert").equal(fs2[gracefulQueue].length, 0);
        });
      }
    }
    var queue;
    if (!global[gracefulQueue]) {
      publishQueue(global, fs2[gracefulQueue]);
    }
    module2.exports = patch(clone(fs2));
    if (process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH && !fs2.__patched) {
      module2.exports = patch(fs2);
      fs2.__patched = true;
    }
    function patch(fs3) {
      polyfills(fs3);
      fs3.gracefulify = patch;
      fs3.createReadStream = createReadStream;
      fs3.createWriteStream = createWriteStream;
      var fs$readFile = fs3.readFile;
      fs3.readFile = readFile;
      function readFile(path2, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$readFile(path2, options, cb);
        function go$readFile(path3, options2, cb2, startTime) {
          return fs$readFile(path3, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$readFile, [path3, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$writeFile = fs3.writeFile;
      fs3.writeFile = writeFile;
      function writeFile(path2, data, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$writeFile(path2, data, options, cb);
        function go$writeFile(path3, data2, options2, cb2, startTime) {
          return fs$writeFile(path3, data2, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$writeFile, [path3, data2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$appendFile = fs3.appendFile;
      if (fs$appendFile)
        fs3.appendFile = appendFile;
      function appendFile(path2, data, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$appendFile(path2, data, options, cb);
        function go$appendFile(path3, data2, options2, cb2, startTime) {
          return fs$appendFile(path3, data2, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$appendFile, [path3, data2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$copyFile = fs3.copyFile;
      if (fs$copyFile)
        fs3.copyFile = copyFile;
      function copyFile(src, dest, flags, cb) {
        if (typeof flags === "function") {
          cb = flags;
          flags = 0;
        }
        return go$copyFile(src, dest, flags, cb);
        function go$copyFile(src2, dest2, flags2, cb2, startTime) {
          return fs$copyFile(src2, dest2, flags2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$copyFile, [src2, dest2, flags2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$readdir = fs3.readdir;
      fs3.readdir = readdir;
      function readdir(path2, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$readdir(path2, options, cb);
        function go$readdir(path3, options2, cb2, startTime) {
          return fs$readdir(path3, options2, function(err, files) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$readdir, [path3, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (files && files.sort)
                files.sort();
              if (typeof cb2 === "function")
                cb2.call(this, err, files);
            }
          });
        }
      }
      if (process.version.substr(0, 4) === "v0.8") {
        var legStreams = legacy(fs3);
        ReadStream = legStreams.ReadStream;
        WriteStream = legStreams.WriteStream;
      }
      var fs$ReadStream = fs3.ReadStream;
      if (fs$ReadStream) {
        ReadStream.prototype = Object.create(fs$ReadStream.prototype);
        ReadStream.prototype.open = ReadStream$open;
      }
      var fs$WriteStream = fs3.WriteStream;
      if (fs$WriteStream) {
        WriteStream.prototype = Object.create(fs$WriteStream.prototype);
        WriteStream.prototype.open = WriteStream$open;
      }
      Object.defineProperty(fs3, "ReadStream", {
        get: function() {
          return ReadStream;
        },
        set: function(val) {
          ReadStream = val;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(fs3, "WriteStream", {
        get: function() {
          return WriteStream;
        },
        set: function(val) {
          WriteStream = val;
        },
        enumerable: true,
        configurable: true
      });
      var FileReadStream = ReadStream;
      Object.defineProperty(fs3, "FileReadStream", {
        get: function() {
          return FileReadStream;
        },
        set: function(val) {
          FileReadStream = val;
        },
        enumerable: true,
        configurable: true
      });
      var FileWriteStream = WriteStream;
      Object.defineProperty(fs3, "FileWriteStream", {
        get: function() {
          return FileWriteStream;
        },
        set: function(val) {
          FileWriteStream = val;
        },
        enumerable: true,
        configurable: true
      });
      function ReadStream(path2, options) {
        if (this instanceof ReadStream)
          return fs$ReadStream.apply(this, arguments), this;
        else
          return ReadStream.apply(Object.create(ReadStream.prototype), arguments);
      }
      function ReadStream$open() {
        var that = this;
        open(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            if (that.autoClose)
              that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
            that.read();
          }
        });
      }
      function WriteStream(path2, options) {
        if (this instanceof WriteStream)
          return fs$WriteStream.apply(this, arguments), this;
        else
          return WriteStream.apply(Object.create(WriteStream.prototype), arguments);
      }
      function WriteStream$open() {
        var that = this;
        open(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
          }
        });
      }
      function createReadStream(path2, options) {
        return new fs3.ReadStream(path2, options);
      }
      function createWriteStream(path2, options) {
        return new fs3.WriteStream(path2, options);
      }
      var fs$open = fs3.open;
      fs3.open = open;
      function open(path2, flags, mode, cb) {
        if (typeof mode === "function")
          cb = mode, mode = null;
        return go$open(path2, flags, mode, cb);
        function go$open(path3, flags2, mode2, cb2, startTime) {
          return fs$open(path3, flags2, mode2, function(err, fd) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$open, [path3, flags2, mode2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      return fs3;
    }
    function enqueue(elem) {
      debug("ENQUEUE", elem[0].name, elem[1]);
      fs2[gracefulQueue].push(elem);
      retry();
    }
    var retryTimer;
    function resetQueue() {
      var now = Date.now();
      for (var i = 0; i < fs2[gracefulQueue].length; ++i) {
        if (fs2[gracefulQueue][i].length > 2) {
          fs2[gracefulQueue][i][3] = now;
          fs2[gracefulQueue][i][4] = now;
        }
      }
      retry();
    }
    function retry() {
      clearTimeout(retryTimer);
      retryTimer = void 0;
      if (fs2[gracefulQueue].length === 0)
        return;
      var elem = fs2[gracefulQueue].shift();
      var fn = elem[0];
      var args = elem[1];
      var err = elem[2];
      var startTime = elem[3];
      var lastTime = elem[4];
      if (startTime === void 0) {
        debug("RETRY", fn.name, args);
        fn.apply(null, args);
      } else if (Date.now() - startTime >= 6e4) {
        debug("TIMEOUT", fn.name, args);
        var cb = args.pop();
        if (typeof cb === "function")
          cb.call(null, err);
      } else {
        var sinceAttempt = Date.now() - lastTime;
        var sinceStart = Math.max(lastTime - startTime, 1);
        var desiredDelay = Math.min(sinceStart * 1.2, 100);
        if (sinceAttempt >= desiredDelay) {
          debug("RETRY", fn.name, args);
          fn.apply(null, args.concat([startTime]));
        } else {
          fs2[gracefulQueue].push(elem);
        }
      }
      if (retryTimer === void 0) {
        retryTimer = setTimeout(retry, 0);
      }
    }
  }
});

// node_modules/fs-extra/lib/fs/index.js
var require_fs = __commonJS({
  "node_modules/fs-extra/lib/fs/index.js"(exports) {
    "use strict";
    var u = require_universalify().fromCallback;
    var fs2 = require_graceful_fs();
    var api = [
      "access",
      "appendFile",
      "chmod",
      "chown",
      "close",
      "copyFile",
      "fchmod",
      "fchown",
      "fdatasync",
      "fstat",
      "fsync",
      "ftruncate",
      "futimes",
      "lchmod",
      "lchown",
      "link",
      "lstat",
      "mkdir",
      "mkdtemp",
      "open",
      "opendir",
      "readdir",
      "readFile",
      "readlink",
      "realpath",
      "rename",
      "rm",
      "rmdir",
      "stat",
      "symlink",
      "truncate",
      "unlink",
      "utimes",
      "writeFile"
    ].filter((key) => {
      return typeof fs2[key] === "function";
    });
    Object.assign(exports, fs2);
    api.forEach((method) => {
      exports[method] = u(fs2[method]);
    });
    exports.realpath.native = u(fs2.realpath.native);
    exports.exists = function(filename, callback) {
      if (typeof callback === "function") {
        return fs2.exists(filename, callback);
      }
      return new Promise((resolve) => {
        return fs2.exists(filename, resolve);
      });
    };
    exports.read = function(fd, buffer, offset, length, position, callback) {
      if (typeof callback === "function") {
        return fs2.read(fd, buffer, offset, length, position, callback);
      }
      return new Promise((resolve, reject) => {
        fs2.read(fd, buffer, offset, length, position, (err, bytesRead, buffer2) => {
          if (err)
            return reject(err);
          resolve({ bytesRead, buffer: buffer2 });
        });
      });
    };
    exports.write = function(fd, buffer, ...args) {
      if (typeof args[args.length - 1] === "function") {
        return fs2.write(fd, buffer, ...args);
      }
      return new Promise((resolve, reject) => {
        fs2.write(fd, buffer, ...args, (err, bytesWritten, buffer2) => {
          if (err)
            return reject(err);
          resolve({ bytesWritten, buffer: buffer2 });
        });
      });
    };
    if (typeof fs2.writev === "function") {
      exports.writev = function(fd, buffers, ...args) {
        if (typeof args[args.length - 1] === "function") {
          return fs2.writev(fd, buffers, ...args);
        }
        return new Promise((resolve, reject) => {
          fs2.writev(fd, buffers, ...args, (err, bytesWritten, buffers2) => {
            if (err)
              return reject(err);
            resolve({ bytesWritten, buffers: buffers2 });
          });
        });
      };
    }
  }
});

// node_modules/fs-extra/lib/mkdirs/utils.js
var require_utils = __commonJS({
  "node_modules/fs-extra/lib/mkdirs/utils.js"(exports, module2) {
    "use strict";
    var path2 = require("path");
    module2.exports.checkPath = function checkPath(pth) {
      if (process.platform === "win32") {
        const pathHasInvalidWinCharacters = /[<>:"|?*]/.test(pth.replace(path2.parse(pth).root, ""));
        if (pathHasInvalidWinCharacters) {
          const error = new Error(`Path contains invalid characters: ${pth}`);
          error.code = "EINVAL";
          throw error;
        }
      }
    };
  }
});

// node_modules/fs-extra/lib/mkdirs/make-dir.js
var require_make_dir = __commonJS({
  "node_modules/fs-extra/lib/mkdirs/make-dir.js"(exports, module2) {
    "use strict";
    var fs2 = require_fs();
    var { checkPath } = require_utils();
    var getMode = (options) => {
      const defaults = { mode: 511 };
      if (typeof options === "number")
        return options;
      return __spreadValues(__spreadValues({}, defaults), options).mode;
    };
    module2.exports.makeDir = async (dir, options) => {
      checkPath(dir);
      return fs2.mkdir(dir, {
        mode: getMode(options),
        recursive: true
      });
    };
    module2.exports.makeDirSync = (dir, options) => {
      checkPath(dir);
      return fs2.mkdirSync(dir, {
        mode: getMode(options),
        recursive: true
      });
    };
  }
});

// node_modules/fs-extra/lib/mkdirs/index.js
var require_mkdirs = __commonJS({
  "node_modules/fs-extra/lib/mkdirs/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromPromise;
    var { makeDir: _makeDir, makeDirSync } = require_make_dir();
    var makeDir = u(_makeDir);
    module2.exports = {
      mkdirs: makeDir,
      mkdirsSync: makeDirSync,
      mkdirp: makeDir,
      mkdirpSync: makeDirSync,
      ensureDir: makeDir,
      ensureDirSync: makeDirSync
    };
  }
});

// node_modules/fs-extra/lib/util/utimes.js
var require_utimes = __commonJS({
  "node_modules/fs-extra/lib/util/utimes.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    function utimesMillis(path2, atime, mtime, callback) {
      fs2.open(path2, "r+", (err, fd) => {
        if (err)
          return callback(err);
        fs2.futimes(fd, atime, mtime, (futimesErr) => {
          fs2.close(fd, (closeErr) => {
            if (callback)
              callback(futimesErr || closeErr);
          });
        });
      });
    }
    function utimesMillisSync(path2, atime, mtime) {
      const fd = fs2.openSync(path2, "r+");
      fs2.futimesSync(fd, atime, mtime);
      return fs2.closeSync(fd);
    }
    module2.exports = {
      utimesMillis,
      utimesMillisSync
    };
  }
});

// node_modules/fs-extra/lib/util/stat.js
var require_stat = __commonJS({
  "node_modules/fs-extra/lib/util/stat.js"(exports, module2) {
    "use strict";
    var fs2 = require_fs();
    var path2 = require("path");
    var util = require("util");
    function getStats(src, dest, opts) {
      const statFunc = opts.dereference ? (file) => fs2.stat(file, { bigint: true }) : (file) => fs2.lstat(file, { bigint: true });
      return Promise.all([
        statFunc(src),
        statFunc(dest).catch((err) => {
          if (err.code === "ENOENT")
            return null;
          throw err;
        })
      ]).then(([srcStat, destStat]) => ({ srcStat, destStat }));
    }
    function getStatsSync(src, dest, opts) {
      let destStat;
      const statFunc = opts.dereference ? (file) => fs2.statSync(file, { bigint: true }) : (file) => fs2.lstatSync(file, { bigint: true });
      const srcStat = statFunc(src);
      try {
        destStat = statFunc(dest);
      } catch (err) {
        if (err.code === "ENOENT")
          return { srcStat, destStat: null };
        throw err;
      }
      return { srcStat, destStat };
    }
    function checkPaths(src, dest, funcName, opts, cb) {
      util.callbackify(getStats)(src, dest, opts, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        if (destStat) {
          if (areIdentical(srcStat, destStat)) {
            const srcBaseName = path2.basename(src);
            const destBaseName = path2.basename(dest);
            if (funcName === "move" && srcBaseName !== destBaseName && srcBaseName.toLowerCase() === destBaseName.toLowerCase()) {
              return cb(null, { srcStat, destStat, isChangingCase: true });
            }
            return cb(new Error("Source and destination must not be the same."));
          }
          if (srcStat.isDirectory() && !destStat.isDirectory()) {
            return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`));
          }
          if (!srcStat.isDirectory() && destStat.isDirectory()) {
            return cb(new Error(`Cannot overwrite directory '${dest}' with non-directory '${src}'.`));
          }
        }
        if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return cb(null, { srcStat, destStat });
      });
    }
    function checkPathsSync(src, dest, funcName, opts) {
      const { srcStat, destStat } = getStatsSync(src, dest, opts);
      if (destStat) {
        if (areIdentical(srcStat, destStat)) {
          const srcBaseName = path2.basename(src);
          const destBaseName = path2.basename(dest);
          if (funcName === "move" && srcBaseName !== destBaseName && srcBaseName.toLowerCase() === destBaseName.toLowerCase()) {
            return { srcStat, destStat, isChangingCase: true };
          }
          throw new Error("Source and destination must not be the same.");
        }
        if (srcStat.isDirectory() && !destStat.isDirectory()) {
          throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`);
        }
        if (!srcStat.isDirectory() && destStat.isDirectory()) {
          throw new Error(`Cannot overwrite directory '${dest}' with non-directory '${src}'.`);
        }
      }
      if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return { srcStat, destStat };
    }
    function checkParentPaths(src, srcStat, dest, funcName, cb) {
      const srcParent = path2.resolve(path2.dirname(src));
      const destParent = path2.resolve(path2.dirname(dest));
      if (destParent === srcParent || destParent === path2.parse(destParent).root)
        return cb();
      fs2.stat(destParent, { bigint: true }, (err, destStat) => {
        if (err) {
          if (err.code === "ENOENT")
            return cb();
          return cb(err);
        }
        if (areIdentical(srcStat, destStat)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return checkParentPaths(src, srcStat, destParent, funcName, cb);
      });
    }
    function checkParentPathsSync(src, srcStat, dest, funcName) {
      const srcParent = path2.resolve(path2.dirname(src));
      const destParent = path2.resolve(path2.dirname(dest));
      if (destParent === srcParent || destParent === path2.parse(destParent).root)
        return;
      let destStat;
      try {
        destStat = fs2.statSync(destParent, { bigint: true });
      } catch (err) {
        if (err.code === "ENOENT")
          return;
        throw err;
      }
      if (areIdentical(srcStat, destStat)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return checkParentPathsSync(src, srcStat, destParent, funcName);
    }
    function areIdentical(srcStat, destStat) {
      return destStat.ino && destStat.dev && destStat.ino === srcStat.ino && destStat.dev === srcStat.dev;
    }
    function isSrcSubdir(src, dest) {
      const srcArr = path2.resolve(src).split(path2.sep).filter((i) => i);
      const destArr = path2.resolve(dest).split(path2.sep).filter((i) => i);
      return srcArr.reduce((acc, cur, i) => acc && destArr[i] === cur, true);
    }
    function errMsg(src, dest, funcName) {
      return `Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`;
    }
    module2.exports = {
      checkPaths,
      checkPathsSync,
      checkParentPaths,
      checkParentPathsSync,
      isSrcSubdir,
      areIdentical
    };
  }
});

// node_modules/fs-extra/lib/copy-sync/copy-sync.js
var require_copy_sync = __commonJS({
  "node_modules/fs-extra/lib/copy-sync/copy-sync.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var mkdirsSync = require_mkdirs().mkdirsSync;
    var utimesMillisSync = require_utimes().utimesMillisSync;
    var stat = require_stat();
    function copySync(src, dest, opts) {
      if (typeof opts === "function") {
        opts = { filter: opts };
      }
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      const { srcStat, destStat } = stat.checkPathsSync(src, dest, "copy", opts);
      stat.checkParentPathsSync(src, srcStat, dest, "copy");
      return handleFilterAndCopy(destStat, src, dest, opts);
    }
    function handleFilterAndCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest))
        return;
      const destParent = path2.dirname(dest);
      if (!fs2.existsSync(destParent))
        mkdirsSync(destParent);
      return getStats(destStat, src, dest, opts);
    }
    function startCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest))
        return;
      return getStats(destStat, src, dest, opts);
    }
    function getStats(destStat, src, dest, opts) {
      const statSync = opts.dereference ? fs2.statSync : fs2.lstatSync;
      const srcStat = statSync(src);
      if (srcStat.isDirectory())
        return onDir(srcStat, destStat, src, dest, opts);
      else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
        return onFile(srcStat, destStat, src, dest, opts);
      else if (srcStat.isSymbolicLink())
        return onLink(destStat, src, dest, opts);
      else if (srcStat.isSocket())
        throw new Error(`Cannot copy a socket file: ${src}`);
      else if (srcStat.isFIFO())
        throw new Error(`Cannot copy a FIFO pipe: ${src}`);
      throw new Error(`Unknown file: ${src}`);
    }
    function onFile(srcStat, destStat, src, dest, opts) {
      if (!destStat)
        return copyFile(srcStat, src, dest, opts);
      return mayCopyFile(srcStat, src, dest, opts);
    }
    function mayCopyFile(srcStat, src, dest, opts) {
      if (opts.overwrite) {
        fs2.unlinkSync(dest);
        return copyFile(srcStat, src, dest, opts);
      } else if (opts.errorOnExist) {
        throw new Error(`'${dest}' already exists`);
      }
    }
    function copyFile(srcStat, src, dest, opts) {
      fs2.copyFileSync(src, dest);
      if (opts.preserveTimestamps)
        handleTimestamps(srcStat.mode, src, dest);
      return setDestMode(dest, srcStat.mode);
    }
    function handleTimestamps(srcMode, src, dest) {
      if (fileIsNotWritable(srcMode))
        makeFileWritable(dest, srcMode);
      return setDestTimestamps(src, dest);
    }
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    function makeFileWritable(dest, srcMode) {
      return setDestMode(dest, srcMode | 128);
    }
    function setDestMode(dest, srcMode) {
      return fs2.chmodSync(dest, srcMode);
    }
    function setDestTimestamps(src, dest) {
      const updatedSrcStat = fs2.statSync(src);
      return utimesMillisSync(dest, updatedSrcStat.atime, updatedSrcStat.mtime);
    }
    function onDir(srcStat, destStat, src, dest, opts) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts);
      return copyDir(src, dest, opts);
    }
    function mkDirAndCopy(srcMode, src, dest, opts) {
      fs2.mkdirSync(dest);
      copyDir(src, dest, opts);
      return setDestMode(dest, srcMode);
    }
    function copyDir(src, dest, opts) {
      fs2.readdirSync(src).forEach((item) => copyDirItem(item, src, dest, opts));
    }
    function copyDirItem(item, src, dest, opts) {
      const srcItem = path2.join(src, item);
      const destItem = path2.join(dest, item);
      const { destStat } = stat.checkPathsSync(srcItem, destItem, "copy", opts);
      return startCopy(destStat, srcItem, destItem, opts);
    }
    function onLink(destStat, src, dest, opts) {
      let resolvedSrc = fs2.readlinkSync(src);
      if (opts.dereference) {
        resolvedSrc = path2.resolve(process.cwd(), resolvedSrc);
      }
      if (!destStat) {
        return fs2.symlinkSync(resolvedSrc, dest);
      } else {
        let resolvedDest;
        try {
          resolvedDest = fs2.readlinkSync(dest);
        } catch (err) {
          if (err.code === "EINVAL" || err.code === "UNKNOWN")
            return fs2.symlinkSync(resolvedSrc, dest);
          throw err;
        }
        if (opts.dereference) {
          resolvedDest = path2.resolve(process.cwd(), resolvedDest);
        }
        if (stat.isSrcSubdir(resolvedSrc, resolvedDest)) {
          throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`);
        }
        if (fs2.statSync(dest).isDirectory() && stat.isSrcSubdir(resolvedDest, resolvedSrc)) {
          throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`);
        }
        return copyLink(resolvedSrc, dest);
      }
    }
    function copyLink(resolvedSrc, dest) {
      fs2.unlinkSync(dest);
      return fs2.symlinkSync(resolvedSrc, dest);
    }
    module2.exports = copySync;
  }
});

// node_modules/fs-extra/lib/copy-sync/index.js
var require_copy_sync2 = __commonJS({
  "node_modules/fs-extra/lib/copy-sync/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      copySync: require_copy_sync()
    };
  }
});

// node_modules/fs-extra/lib/path-exists/index.js
var require_path_exists = __commonJS({
  "node_modules/fs-extra/lib/path-exists/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromPromise;
    var fs2 = require_fs();
    function pathExists(path2) {
      return fs2.access(path2).then(() => true).catch(() => false);
    }
    module2.exports = {
      pathExists: u(pathExists),
      pathExistsSync: fs2.existsSync
    };
  }
});

// node_modules/fs-extra/lib/copy/copy.js
var require_copy = __commonJS({
  "node_modules/fs-extra/lib/copy/copy.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var mkdirs = require_mkdirs().mkdirs;
    var pathExists = require_path_exists().pathExists;
    var utimesMillis = require_utimes().utimesMillis;
    var stat = require_stat();
    function copy(src, dest, opts, cb) {
      if (typeof opts === "function" && !cb) {
        cb = opts;
        opts = {};
      } else if (typeof opts === "function") {
        opts = { filter: opts };
      }
      cb = cb || function() {
      };
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      stat.checkPaths(src, dest, "copy", opts, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        stat.checkParentPaths(src, srcStat, dest, "copy", (err2) => {
          if (err2)
            return cb(err2);
          if (opts.filter)
            return handleFilter(checkParentDir, destStat, src, dest, opts, cb);
          return checkParentDir(destStat, src, dest, opts, cb);
        });
      });
    }
    function checkParentDir(destStat, src, dest, opts, cb) {
      const destParent = path2.dirname(dest);
      pathExists(destParent, (err, dirExists) => {
        if (err)
          return cb(err);
        if (dirExists)
          return getStats(destStat, src, dest, opts, cb);
        mkdirs(destParent, (err2) => {
          if (err2)
            return cb(err2);
          return getStats(destStat, src, dest, opts, cb);
        });
      });
    }
    function handleFilter(onInclude, destStat, src, dest, opts, cb) {
      Promise.resolve(opts.filter(src, dest)).then((include) => {
        if (include)
          return onInclude(destStat, src, dest, opts, cb);
        return cb();
      }, (error) => cb(error));
    }
    function startCopy(destStat, src, dest, opts, cb) {
      if (opts.filter)
        return handleFilter(getStats, destStat, src, dest, opts, cb);
      return getStats(destStat, src, dest, opts, cb);
    }
    function getStats(destStat, src, dest, opts, cb) {
      const stat2 = opts.dereference ? fs2.stat : fs2.lstat;
      stat2(src, (err, srcStat) => {
        if (err)
          return cb(err);
        if (srcStat.isDirectory())
          return onDir(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
          return onFile(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isSymbolicLink())
          return onLink(destStat, src, dest, opts, cb);
        else if (srcStat.isSocket())
          return cb(new Error(`Cannot copy a socket file: ${src}`));
        else if (srcStat.isFIFO())
          return cb(new Error(`Cannot copy a FIFO pipe: ${src}`));
        return cb(new Error(`Unknown file: ${src}`));
      });
    }
    function onFile(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat)
        return copyFile(srcStat, src, dest, opts, cb);
      return mayCopyFile(srcStat, src, dest, opts, cb);
    }
    function mayCopyFile(srcStat, src, dest, opts, cb) {
      if (opts.overwrite) {
        fs2.unlink(dest, (err) => {
          if (err)
            return cb(err);
          return copyFile(srcStat, src, dest, opts, cb);
        });
      } else if (opts.errorOnExist) {
        return cb(new Error(`'${dest}' already exists`));
      } else
        return cb();
    }
    function copyFile(srcStat, src, dest, opts, cb) {
      fs2.copyFile(src, dest, (err) => {
        if (err)
          return cb(err);
        if (opts.preserveTimestamps)
          return handleTimestampsAndMode(srcStat.mode, src, dest, cb);
        return setDestMode(dest, srcStat.mode, cb);
      });
    }
    function handleTimestampsAndMode(srcMode, src, dest, cb) {
      if (fileIsNotWritable(srcMode)) {
        return makeFileWritable(dest, srcMode, (err) => {
          if (err)
            return cb(err);
          return setDestTimestampsAndMode(srcMode, src, dest, cb);
        });
      }
      return setDestTimestampsAndMode(srcMode, src, dest, cb);
    }
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    function makeFileWritable(dest, srcMode, cb) {
      return setDestMode(dest, srcMode | 128, cb);
    }
    function setDestTimestampsAndMode(srcMode, src, dest, cb) {
      setDestTimestamps(src, dest, (err) => {
        if (err)
          return cb(err);
        return setDestMode(dest, srcMode, cb);
      });
    }
    function setDestMode(dest, srcMode, cb) {
      return fs2.chmod(dest, srcMode, cb);
    }
    function setDestTimestamps(src, dest, cb) {
      fs2.stat(src, (err, updatedSrcStat) => {
        if (err)
          return cb(err);
        return utimesMillis(dest, updatedSrcStat.atime, updatedSrcStat.mtime, cb);
      });
    }
    function onDir(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts, cb);
      return copyDir(src, dest, opts, cb);
    }
    function mkDirAndCopy(srcMode, src, dest, opts, cb) {
      fs2.mkdir(dest, (err) => {
        if (err)
          return cb(err);
        copyDir(src, dest, opts, (err2) => {
          if (err2)
            return cb(err2);
          return setDestMode(dest, srcMode, cb);
        });
      });
    }
    function copyDir(src, dest, opts, cb) {
      fs2.readdir(src, (err, items) => {
        if (err)
          return cb(err);
        return copyDirItems(items, src, dest, opts, cb);
      });
    }
    function copyDirItems(items, src, dest, opts, cb) {
      const item = items.pop();
      if (!item)
        return cb();
      return copyDirItem(items, item, src, dest, opts, cb);
    }
    function copyDirItem(items, item, src, dest, opts, cb) {
      const srcItem = path2.join(src, item);
      const destItem = path2.join(dest, item);
      stat.checkPaths(srcItem, destItem, "copy", opts, (err, stats) => {
        if (err)
          return cb(err);
        const { destStat } = stats;
        startCopy(destStat, srcItem, destItem, opts, (err2) => {
          if (err2)
            return cb(err2);
          return copyDirItems(items, src, dest, opts, cb);
        });
      });
    }
    function onLink(destStat, src, dest, opts, cb) {
      fs2.readlink(src, (err, resolvedSrc) => {
        if (err)
          return cb(err);
        if (opts.dereference) {
          resolvedSrc = path2.resolve(process.cwd(), resolvedSrc);
        }
        if (!destStat) {
          return fs2.symlink(resolvedSrc, dest, cb);
        } else {
          fs2.readlink(dest, (err2, resolvedDest) => {
            if (err2) {
              if (err2.code === "EINVAL" || err2.code === "UNKNOWN")
                return fs2.symlink(resolvedSrc, dest, cb);
              return cb(err2);
            }
            if (opts.dereference) {
              resolvedDest = path2.resolve(process.cwd(), resolvedDest);
            }
            if (stat.isSrcSubdir(resolvedSrc, resolvedDest)) {
              return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`));
            }
            if (destStat.isDirectory() && stat.isSrcSubdir(resolvedDest, resolvedSrc)) {
              return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`));
            }
            return copyLink(resolvedSrc, dest, cb);
          });
        }
      });
    }
    function copyLink(resolvedSrc, dest, cb) {
      fs2.unlink(dest, (err) => {
        if (err)
          return cb(err);
        return fs2.symlink(resolvedSrc, dest, cb);
      });
    }
    module2.exports = copy;
  }
});

// node_modules/fs-extra/lib/copy/index.js
var require_copy2 = __commonJS({
  "node_modules/fs-extra/lib/copy/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    module2.exports = {
      copy: u(require_copy())
    };
  }
});

// node_modules/fs-extra/lib/remove/rimraf.js
var require_rimraf = __commonJS({
  "node_modules/fs-extra/lib/remove/rimraf.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var assert = require("assert");
    var isWindows = process.platform === "win32";
    function defaults(options) {
      const methods = [
        "unlink",
        "chmod",
        "stat",
        "lstat",
        "rmdir",
        "readdir"
      ];
      methods.forEach((m) => {
        options[m] = options[m] || fs2[m];
        m = m + "Sync";
        options[m] = options[m] || fs2[m];
      });
      options.maxBusyTries = options.maxBusyTries || 3;
    }
    function rimraf(p, options, cb) {
      let busyTries = 0;
      if (typeof options === "function") {
        cb = options;
        options = {};
      }
      assert(p, "rimraf: missing path");
      assert.strictEqual(typeof p, "string", "rimraf: path should be a string");
      assert.strictEqual(typeof cb, "function", "rimraf: callback function required");
      assert(options, "rimraf: invalid options argument provided");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      defaults(options);
      rimraf_(p, options, function CB(er) {
        if (er) {
          if ((er.code === "EBUSY" || er.code === "ENOTEMPTY" || er.code === "EPERM") && busyTries < options.maxBusyTries) {
            busyTries++;
            const time = busyTries * 100;
            return setTimeout(() => rimraf_(p, options, CB), time);
          }
          if (er.code === "ENOENT")
            er = null;
        }
        cb(er);
      });
    }
    function rimraf_(p, options, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.lstat(p, (er, st) => {
        if (er && er.code === "ENOENT") {
          return cb(null);
        }
        if (er && er.code === "EPERM" && isWindows) {
          return fixWinEPERM(p, options, er, cb);
        }
        if (st && st.isDirectory()) {
          return rmdir(p, options, er, cb);
        }
        options.unlink(p, (er2) => {
          if (er2) {
            if (er2.code === "ENOENT") {
              return cb(null);
            }
            if (er2.code === "EPERM") {
              return isWindows ? fixWinEPERM(p, options, er2, cb) : rmdir(p, options, er2, cb);
            }
            if (er2.code === "EISDIR") {
              return rmdir(p, options, er2, cb);
            }
          }
          return cb(er2);
        });
      });
    }
    function fixWinEPERM(p, options, er, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.chmod(p, 438, (er2) => {
        if (er2) {
          cb(er2.code === "ENOENT" ? null : er);
        } else {
          options.stat(p, (er3, stats) => {
            if (er3) {
              cb(er3.code === "ENOENT" ? null : er);
            } else if (stats.isDirectory()) {
              rmdir(p, options, er, cb);
            } else {
              options.unlink(p, cb);
            }
          });
        }
      });
    }
    function fixWinEPERMSync(p, options, er) {
      let stats;
      assert(p);
      assert(options);
      try {
        options.chmodSync(p, 438);
      } catch (er2) {
        if (er2.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      try {
        stats = options.statSync(p);
      } catch (er3) {
        if (er3.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      if (stats.isDirectory()) {
        rmdirSync(p, options, er);
      } else {
        options.unlinkSync(p);
      }
    }
    function rmdir(p, options, originalEr, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.rmdir(p, (er) => {
        if (er && (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM")) {
          rmkids(p, options, cb);
        } else if (er && er.code === "ENOTDIR") {
          cb(originalEr);
        } else {
          cb(er);
        }
      });
    }
    function rmkids(p, options, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.readdir(p, (er, files) => {
        if (er)
          return cb(er);
        let n = files.length;
        let errState;
        if (n === 0)
          return options.rmdir(p, cb);
        files.forEach((f) => {
          rimraf(path2.join(p, f), options, (er2) => {
            if (errState) {
              return;
            }
            if (er2)
              return cb(errState = er2);
            if (--n === 0) {
              options.rmdir(p, cb);
            }
          });
        });
      });
    }
    function rimrafSync(p, options) {
      let st;
      options = options || {};
      defaults(options);
      assert(p, "rimraf: missing path");
      assert.strictEqual(typeof p, "string", "rimraf: path should be a string");
      assert(options, "rimraf: missing options");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      try {
        st = options.lstatSync(p);
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        }
        if (er.code === "EPERM" && isWindows) {
          fixWinEPERMSync(p, options, er);
        }
      }
      try {
        if (st && st.isDirectory()) {
          rmdirSync(p, options, null);
        } else {
          options.unlinkSync(p);
        }
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        } else if (er.code === "EPERM") {
          return isWindows ? fixWinEPERMSync(p, options, er) : rmdirSync(p, options, er);
        } else if (er.code !== "EISDIR") {
          throw er;
        }
        rmdirSync(p, options, er);
      }
    }
    function rmdirSync(p, options, originalEr) {
      assert(p);
      assert(options);
      try {
        options.rmdirSync(p);
      } catch (er) {
        if (er.code === "ENOTDIR") {
          throw originalEr;
        } else if (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM") {
          rmkidsSync(p, options);
        } else if (er.code !== "ENOENT") {
          throw er;
        }
      }
    }
    function rmkidsSync(p, options) {
      assert(p);
      assert(options);
      options.readdirSync(p).forEach((f) => rimrafSync(path2.join(p, f), options));
      if (isWindows) {
        const startTime = Date.now();
        do {
          try {
            const ret = options.rmdirSync(p, options);
            return ret;
          } catch {
          }
        } while (Date.now() - startTime < 500);
      } else {
        const ret = options.rmdirSync(p, options);
        return ret;
      }
    }
    module2.exports = rimraf;
    rimraf.sync = rimrafSync;
  }
});

// node_modules/fs-extra/lib/remove/index.js
var require_remove = __commonJS({
  "node_modules/fs-extra/lib/remove/index.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var u = require_universalify().fromCallback;
    var rimraf = require_rimraf();
    function remove2(path2, callback) {
      if (fs2.rm)
        return fs2.rm(path2, { recursive: true, force: true }, callback);
      rimraf(path2, callback);
    }
    function removeSync(path2) {
      if (fs2.rmSync)
        return fs2.rmSync(path2, { recursive: true, force: true });
      rimraf.sync(path2);
    }
    module2.exports = {
      remove: u(remove2),
      removeSync
    };
  }
});

// node_modules/fs-extra/lib/empty/index.js
var require_empty = __commonJS({
  "node_modules/fs-extra/lib/empty/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromPromise;
    var fs2 = require_fs();
    var path2 = require("path");
    var mkdir = require_mkdirs();
    var remove2 = require_remove();
    var emptyDir = u(async function emptyDir2(dir) {
      let items;
      try {
        items = await fs2.readdir(dir);
      } catch {
        return mkdir.mkdirs(dir);
      }
      return Promise.all(items.map((item) => remove2.remove(path2.join(dir, item))));
    });
    function emptyDirSync(dir) {
      let items;
      try {
        items = fs2.readdirSync(dir);
      } catch {
        return mkdir.mkdirsSync(dir);
      }
      items.forEach((item) => {
        item = path2.join(dir, item);
        remove2.removeSync(item);
      });
    }
    module2.exports = {
      emptyDirSync,
      emptydirSync: emptyDirSync,
      emptyDir,
      emptydir: emptyDir
    };
  }
});

// node_modules/fs-extra/lib/ensure/file.js
var require_file = __commonJS({
  "node_modules/fs-extra/lib/ensure/file.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var path2 = require("path");
    var fs2 = require_graceful_fs();
    var mkdir = require_mkdirs();
    function createFile(file, callback) {
      function makeFile() {
        fs2.writeFile(file, "", (err) => {
          if (err)
            return callback(err);
          callback();
        });
      }
      fs2.stat(file, (err, stats) => {
        if (!err && stats.isFile())
          return callback();
        const dir = path2.dirname(file);
        fs2.stat(dir, (err2, stats2) => {
          if (err2) {
            if (err2.code === "ENOENT") {
              return mkdir.mkdirs(dir, (err3) => {
                if (err3)
                  return callback(err3);
                makeFile();
              });
            }
            return callback(err2);
          }
          if (stats2.isDirectory())
            makeFile();
          else {
            fs2.readdir(dir, (err3) => {
              if (err3)
                return callback(err3);
            });
          }
        });
      });
    }
    function createFileSync(file) {
      let stats;
      try {
        stats = fs2.statSync(file);
      } catch {
      }
      if (stats && stats.isFile())
        return;
      const dir = path2.dirname(file);
      try {
        if (!fs2.statSync(dir).isDirectory()) {
          fs2.readdirSync(dir);
        }
      } catch (err) {
        if (err && err.code === "ENOENT")
          mkdir.mkdirsSync(dir);
        else
          throw err;
      }
      fs2.writeFileSync(file, "");
    }
    module2.exports = {
      createFile: u(createFile),
      createFileSync
    };
  }
});

// node_modules/fs-extra/lib/ensure/link.js
var require_link = __commonJS({
  "node_modules/fs-extra/lib/ensure/link.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var path2 = require("path");
    var fs2 = require_graceful_fs();
    var mkdir = require_mkdirs();
    var pathExists = require_path_exists().pathExists;
    var { areIdentical } = require_stat();
    function createLink(srcpath, dstpath, callback) {
      function makeLink(srcpath2, dstpath2) {
        fs2.link(srcpath2, dstpath2, (err) => {
          if (err)
            return callback(err);
          callback(null);
        });
      }
      fs2.lstat(dstpath, (_, dstStat) => {
        fs2.lstat(srcpath, (err, srcStat) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureLink");
            return callback(err);
          }
          if (dstStat && areIdentical(srcStat, dstStat))
            return callback(null);
          const dir = path2.dirname(dstpath);
          pathExists(dir, (err2, dirExists) => {
            if (err2)
              return callback(err2);
            if (dirExists)
              return makeLink(srcpath, dstpath);
            mkdir.mkdirs(dir, (err3) => {
              if (err3)
                return callback(err3);
              makeLink(srcpath, dstpath);
            });
          });
        });
      });
    }
    function createLinkSync(srcpath, dstpath) {
      let dstStat;
      try {
        dstStat = fs2.lstatSync(dstpath);
      } catch {
      }
      try {
        const srcStat = fs2.lstatSync(srcpath);
        if (dstStat && areIdentical(srcStat, dstStat))
          return;
      } catch (err) {
        err.message = err.message.replace("lstat", "ensureLink");
        throw err;
      }
      const dir = path2.dirname(dstpath);
      const dirExists = fs2.existsSync(dir);
      if (dirExists)
        return fs2.linkSync(srcpath, dstpath);
      mkdir.mkdirsSync(dir);
      return fs2.linkSync(srcpath, dstpath);
    }
    module2.exports = {
      createLink: u(createLink),
      createLinkSync
    };
  }
});

// node_modules/fs-extra/lib/ensure/symlink-paths.js
var require_symlink_paths = __commonJS({
  "node_modules/fs-extra/lib/ensure/symlink-paths.js"(exports, module2) {
    "use strict";
    var path2 = require("path");
    var fs2 = require_graceful_fs();
    var pathExists = require_path_exists().pathExists;
    function symlinkPaths(srcpath, dstpath, callback) {
      if (path2.isAbsolute(srcpath)) {
        return fs2.lstat(srcpath, (err) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureSymlink");
            return callback(err);
          }
          return callback(null, {
            toCwd: srcpath,
            toDst: srcpath
          });
        });
      } else {
        const dstdir = path2.dirname(dstpath);
        const relativeToDst = path2.join(dstdir, srcpath);
        return pathExists(relativeToDst, (err, exists) => {
          if (err)
            return callback(err);
          if (exists) {
            return callback(null, {
              toCwd: relativeToDst,
              toDst: srcpath
            });
          } else {
            return fs2.lstat(srcpath, (err2) => {
              if (err2) {
                err2.message = err2.message.replace("lstat", "ensureSymlink");
                return callback(err2);
              }
              return callback(null, {
                toCwd: srcpath,
                toDst: path2.relative(dstdir, srcpath)
              });
            });
          }
        });
      }
    }
    function symlinkPathsSync(srcpath, dstpath) {
      let exists;
      if (path2.isAbsolute(srcpath)) {
        exists = fs2.existsSync(srcpath);
        if (!exists)
          throw new Error("absolute srcpath does not exist");
        return {
          toCwd: srcpath,
          toDst: srcpath
        };
      } else {
        const dstdir = path2.dirname(dstpath);
        const relativeToDst = path2.join(dstdir, srcpath);
        exists = fs2.existsSync(relativeToDst);
        if (exists) {
          return {
            toCwd: relativeToDst,
            toDst: srcpath
          };
        } else {
          exists = fs2.existsSync(srcpath);
          if (!exists)
            throw new Error("relative srcpath does not exist");
          return {
            toCwd: srcpath,
            toDst: path2.relative(dstdir, srcpath)
          };
        }
      }
    }
    module2.exports = {
      symlinkPaths,
      symlinkPathsSync
    };
  }
});

// node_modules/fs-extra/lib/ensure/symlink-type.js
var require_symlink_type = __commonJS({
  "node_modules/fs-extra/lib/ensure/symlink-type.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    function symlinkType(srcpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      if (type)
        return callback(null, type);
      fs2.lstat(srcpath, (err, stats) => {
        if (err)
          return callback(null, "file");
        type = stats && stats.isDirectory() ? "dir" : "file";
        callback(null, type);
      });
    }
    function symlinkTypeSync(srcpath, type) {
      let stats;
      if (type)
        return type;
      try {
        stats = fs2.lstatSync(srcpath);
      } catch {
        return "file";
      }
      return stats && stats.isDirectory() ? "dir" : "file";
    }
    module2.exports = {
      symlinkType,
      symlinkTypeSync
    };
  }
});

// node_modules/fs-extra/lib/ensure/symlink.js
var require_symlink = __commonJS({
  "node_modules/fs-extra/lib/ensure/symlink.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var path2 = require("path");
    var fs2 = require_fs();
    var _mkdirs = require_mkdirs();
    var mkdirs = _mkdirs.mkdirs;
    var mkdirsSync = _mkdirs.mkdirsSync;
    var _symlinkPaths = require_symlink_paths();
    var symlinkPaths = _symlinkPaths.symlinkPaths;
    var symlinkPathsSync = _symlinkPaths.symlinkPathsSync;
    var _symlinkType = require_symlink_type();
    var symlinkType = _symlinkType.symlinkType;
    var symlinkTypeSync = _symlinkType.symlinkTypeSync;
    var pathExists = require_path_exists().pathExists;
    var { areIdentical } = require_stat();
    function createSymlink(srcpath, dstpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      fs2.lstat(dstpath, (err, stats) => {
        if (!err && stats.isSymbolicLink()) {
          Promise.all([
            fs2.stat(srcpath),
            fs2.stat(dstpath)
          ]).then(([srcStat, dstStat]) => {
            if (areIdentical(srcStat, dstStat))
              return callback(null);
            _createSymlink(srcpath, dstpath, type, callback);
          });
        } else
          _createSymlink(srcpath, dstpath, type, callback);
      });
    }
    function _createSymlink(srcpath, dstpath, type, callback) {
      symlinkPaths(srcpath, dstpath, (err, relative) => {
        if (err)
          return callback(err);
        srcpath = relative.toDst;
        symlinkType(relative.toCwd, type, (err2, type2) => {
          if (err2)
            return callback(err2);
          const dir = path2.dirname(dstpath);
          pathExists(dir, (err3, dirExists) => {
            if (err3)
              return callback(err3);
            if (dirExists)
              return fs2.symlink(srcpath, dstpath, type2, callback);
            mkdirs(dir, (err4) => {
              if (err4)
                return callback(err4);
              fs2.symlink(srcpath, dstpath, type2, callback);
            });
          });
        });
      });
    }
    function createSymlinkSync(srcpath, dstpath, type) {
      let stats;
      try {
        stats = fs2.lstatSync(dstpath);
      } catch {
      }
      if (stats && stats.isSymbolicLink()) {
        const srcStat = fs2.statSync(srcpath);
        const dstStat = fs2.statSync(dstpath);
        if (areIdentical(srcStat, dstStat))
          return;
      }
      const relative = symlinkPathsSync(srcpath, dstpath);
      srcpath = relative.toDst;
      type = symlinkTypeSync(relative.toCwd, type);
      const dir = path2.dirname(dstpath);
      const exists = fs2.existsSync(dir);
      if (exists)
        return fs2.symlinkSync(srcpath, dstpath, type);
      mkdirsSync(dir);
      return fs2.symlinkSync(srcpath, dstpath, type);
    }
    module2.exports = {
      createSymlink: u(createSymlink),
      createSymlinkSync
    };
  }
});

// node_modules/fs-extra/lib/ensure/index.js
var require_ensure = __commonJS({
  "node_modules/fs-extra/lib/ensure/index.js"(exports, module2) {
    "use strict";
    var file = require_file();
    var link = require_link();
    var symlink = require_symlink();
    module2.exports = {
      createFile: file.createFile,
      createFileSync: file.createFileSync,
      ensureFile: file.createFile,
      ensureFileSync: file.createFileSync,
      createLink: link.createLink,
      createLinkSync: link.createLinkSync,
      ensureLink: link.createLink,
      ensureLinkSync: link.createLinkSync,
      createSymlink: symlink.createSymlink,
      createSymlinkSync: symlink.createSymlinkSync,
      ensureSymlink: symlink.createSymlink,
      ensureSymlinkSync: symlink.createSymlinkSync
    };
  }
});

// node_modules/fs-extra/node_modules/jsonfile/utils.js
var require_utils2 = __commonJS({
  "node_modules/fs-extra/node_modules/jsonfile/utils.js"(exports, module2) {
    function stringify(obj, { EOL = "\n", finalEOL = true, replacer = null, spaces } = {}) {
      const EOF = finalEOL ? EOL : "";
      const str = JSON.stringify(obj, replacer, spaces);
      return str.replace(/\n/g, EOL) + EOF;
    }
    function stripBom(content) {
      if (Buffer.isBuffer(content))
        content = content.toString("utf8");
      return content.replace(/^\uFEFF/, "");
    }
    module2.exports = { stringify, stripBom };
  }
});

// node_modules/fs-extra/node_modules/jsonfile/index.js
var require_jsonfile = __commonJS({
  "node_modules/fs-extra/node_modules/jsonfile/index.js"(exports, module2) {
    var _fs;
    try {
      _fs = require_graceful_fs();
    } catch (_) {
      _fs = require("fs");
    }
    var universalify = require_universalify();
    var { stringify, stripBom } = require_utils2();
    async function _readFile(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs2 = options.fs || _fs;
      const shouldThrow = "throws" in options ? options.throws : true;
      let data = await universalify.fromCallback(fs2.readFile)(file, options);
      data = stripBom(data);
      let obj;
      try {
        obj = JSON.parse(data, options ? options.reviver : null);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
      return obj;
    }
    var readFile = universalify.fromPromise(_readFile);
    function readFileSync(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs2 = options.fs || _fs;
      const shouldThrow = "throws" in options ? options.throws : true;
      try {
        let content = fs2.readFileSync(file, options);
        content = stripBom(content);
        return JSON.parse(content, options.reviver);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
    }
    async function _writeFile(file, obj, options = {}) {
      const fs2 = options.fs || _fs;
      const str = stringify(obj, options);
      await universalify.fromCallback(fs2.writeFile)(file, str, options);
    }
    var writeFile = universalify.fromPromise(_writeFile);
    function writeFileSync(file, obj, options = {}) {
      const fs2 = options.fs || _fs;
      const str = stringify(obj, options);
      return fs2.writeFileSync(file, str, options);
    }
    var jsonfile = {
      readFile,
      readFileSync,
      writeFile,
      writeFileSync
    };
    module2.exports = jsonfile;
  }
});

// node_modules/fs-extra/lib/json/jsonfile.js
var require_jsonfile2 = __commonJS({
  "node_modules/fs-extra/lib/json/jsonfile.js"(exports, module2) {
    "use strict";
    var jsonFile = require_jsonfile();
    module2.exports = {
      readJson: jsonFile.readFile,
      readJsonSync: jsonFile.readFileSync,
      writeJson: jsonFile.writeFile,
      writeJsonSync: jsonFile.writeFileSync
    };
  }
});

// node_modules/fs-extra/lib/output/index.js
var require_output = __commonJS({
  "node_modules/fs-extra/lib/output/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var mkdir = require_mkdirs();
    var pathExists = require_path_exists().pathExists;
    function outputFile(file, data, encoding, callback) {
      if (typeof encoding === "function") {
        callback = encoding;
        encoding = "utf8";
      }
      const dir = path2.dirname(file);
      pathExists(dir, (err, itDoes) => {
        if (err)
          return callback(err);
        if (itDoes)
          return fs2.writeFile(file, data, encoding, callback);
        mkdir.mkdirs(dir, (err2) => {
          if (err2)
            return callback(err2);
          fs2.writeFile(file, data, encoding, callback);
        });
      });
    }
    function outputFileSync(file, ...args) {
      const dir = path2.dirname(file);
      if (fs2.existsSync(dir)) {
        return fs2.writeFileSync(file, ...args);
      }
      mkdir.mkdirsSync(dir);
      fs2.writeFileSync(file, ...args);
    }
    module2.exports = {
      outputFile: u(outputFile),
      outputFileSync
    };
  }
});

// node_modules/fs-extra/lib/json/output-json.js
var require_output_json = __commonJS({
  "node_modules/fs-extra/lib/json/output-json.js"(exports, module2) {
    "use strict";
    var { stringify } = require_utils2();
    var { outputFile } = require_output();
    async function outputJson(file, data, options = {}) {
      const str = stringify(data, options);
      await outputFile(file, str, options);
    }
    module2.exports = outputJson;
  }
});

// node_modules/fs-extra/lib/json/output-json-sync.js
var require_output_json_sync = __commonJS({
  "node_modules/fs-extra/lib/json/output-json-sync.js"(exports, module2) {
    "use strict";
    var { stringify } = require_utils2();
    var { outputFileSync } = require_output();
    function outputJsonSync(file, data, options) {
      const str = stringify(data, options);
      outputFileSync(file, str, options);
    }
    module2.exports = outputJsonSync;
  }
});

// node_modules/fs-extra/lib/json/index.js
var require_json = __commonJS({
  "node_modules/fs-extra/lib/json/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromPromise;
    var jsonFile = require_jsonfile2();
    jsonFile.outputJson = u(require_output_json());
    jsonFile.outputJsonSync = require_output_json_sync();
    jsonFile.outputJSON = jsonFile.outputJson;
    jsonFile.outputJSONSync = jsonFile.outputJsonSync;
    jsonFile.writeJSON = jsonFile.writeJson;
    jsonFile.writeJSONSync = jsonFile.writeJsonSync;
    jsonFile.readJSON = jsonFile.readJson;
    jsonFile.readJSONSync = jsonFile.readJsonSync;
    module2.exports = jsonFile;
  }
});

// node_modules/fs-extra/lib/move-sync/move-sync.js
var require_move_sync = __commonJS({
  "node_modules/fs-extra/lib/move-sync/move-sync.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var copySync = require_copy_sync2().copySync;
    var removeSync = require_remove().removeSync;
    var mkdirpSync = require_mkdirs().mkdirpSync;
    var stat = require_stat();
    function moveSync(src, dest, opts) {
      opts = opts || {};
      const overwrite = opts.overwrite || opts.clobber || false;
      const { srcStat, isChangingCase = false } = stat.checkPathsSync(src, dest, "move", opts);
      stat.checkParentPathsSync(src, srcStat, dest, "move");
      if (!isParentRoot(dest))
        mkdirpSync(path2.dirname(dest));
      return doRename(src, dest, overwrite, isChangingCase);
    }
    function isParentRoot(dest) {
      const parent = path2.dirname(dest);
      const parsedPath = path2.parse(parent);
      return parsedPath.root === parent;
    }
    function doRename(src, dest, overwrite, isChangingCase) {
      if (isChangingCase)
        return rename(src, dest, overwrite);
      if (overwrite) {
        removeSync(dest);
        return rename(src, dest, overwrite);
      }
      if (fs2.existsSync(dest))
        throw new Error("dest already exists.");
      return rename(src, dest, overwrite);
    }
    function rename(src, dest, overwrite) {
      try {
        fs2.renameSync(src, dest);
      } catch (err) {
        if (err.code !== "EXDEV")
          throw err;
        return moveAcrossDevice(src, dest, overwrite);
      }
    }
    function moveAcrossDevice(src, dest, overwrite) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copySync(src, dest, opts);
      return removeSync(src);
    }
    module2.exports = moveSync;
  }
});

// node_modules/fs-extra/lib/move-sync/index.js
var require_move_sync2 = __commonJS({
  "node_modules/fs-extra/lib/move-sync/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      moveSync: require_move_sync()
    };
  }
});

// node_modules/fs-extra/lib/move/move.js
var require_move = __commonJS({
  "node_modules/fs-extra/lib/move/move.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var copy = require_copy2().copy;
    var remove2 = require_remove().remove;
    var mkdirp2 = require_mkdirs().mkdirp;
    var pathExists = require_path_exists().pathExists;
    var stat = require_stat();
    function move(src, dest, opts, cb) {
      if (typeof opts === "function") {
        cb = opts;
        opts = {};
      }
      const overwrite = opts.overwrite || opts.clobber || false;
      stat.checkPaths(src, dest, "move", opts, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, isChangingCase = false } = stats;
        stat.checkParentPaths(src, srcStat, dest, "move", (err2) => {
          if (err2)
            return cb(err2);
          if (isParentRoot(dest))
            return doRename(src, dest, overwrite, isChangingCase, cb);
          mkdirp2(path2.dirname(dest), (err3) => {
            if (err3)
              return cb(err3);
            return doRename(src, dest, overwrite, isChangingCase, cb);
          });
        });
      });
    }
    function isParentRoot(dest) {
      const parent = path2.dirname(dest);
      const parsedPath = path2.parse(parent);
      return parsedPath.root === parent;
    }
    function doRename(src, dest, overwrite, isChangingCase, cb) {
      if (isChangingCase)
        return rename(src, dest, overwrite, cb);
      if (overwrite) {
        return remove2(dest, (err) => {
          if (err)
            return cb(err);
          return rename(src, dest, overwrite, cb);
        });
      }
      pathExists(dest, (err, destExists) => {
        if (err)
          return cb(err);
        if (destExists)
          return cb(new Error("dest already exists."));
        return rename(src, dest, overwrite, cb);
      });
    }
    function rename(src, dest, overwrite, cb) {
      fs2.rename(src, dest, (err) => {
        if (!err)
          return cb();
        if (err.code !== "EXDEV")
          return cb(err);
        return moveAcrossDevice(src, dest, overwrite, cb);
      });
    }
    function moveAcrossDevice(src, dest, overwrite, cb) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copy(src, dest, opts, (err) => {
        if (err)
          return cb(err);
        return remove2(src, cb);
      });
    }
    module2.exports = move;
  }
});

// node_modules/fs-extra/lib/move/index.js
var require_move2 = __commonJS({
  "node_modules/fs-extra/lib/move/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    module2.exports = {
      move: u(require_move())
    };
  }
});

// node_modules/fs-extra/lib/index.js
var require_lib = __commonJS({
  "node_modules/fs-extra/lib/index.js"(exports, module2) {
    "use strict";
    module2.exports = __spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues({}, require_fs()), require_copy_sync2()), require_copy2()), require_empty()), require_ensure()), require_json()), require_mkdirs()), require_move_sync2()), require_move2()), require_output()), require_path_exists()), require_remove());
  }
});

// node_modules/jsii-docgen/node_modules/universalify/index.js
var require_universalify2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/universalify/index.js"(exports) {
    "use strict";
    exports.fromCallback = function(fn) {
      return Object.defineProperty(function(...args) {
        if (typeof args[args.length - 1] === "function")
          fn.apply(this, args);
        else {
          return new Promise((resolve, reject) => {
            fn.call(this, ...args, (err, res) => err != null ? reject(err) : resolve(res));
          });
        }
      }, "name", { value: fn.name });
    };
    exports.fromPromise = function(fn) {
      return Object.defineProperty(function(...args) {
        const cb = args[args.length - 1];
        if (typeof cb !== "function")
          return fn.apply(this, args);
        else
          fn.apply(this, args.slice(0, -1)).then((r) => cb(null, r), cb);
      }, "name", { value: fn.name });
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/fs/index.js
var require_fs2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/fs/index.js"(exports) {
    "use strict";
    var u = require_universalify2().fromCallback;
    var fs2 = require_graceful_fs();
    var api = [
      "access",
      "appendFile",
      "chmod",
      "chown",
      "close",
      "copyFile",
      "fchmod",
      "fchown",
      "fdatasync",
      "fstat",
      "fsync",
      "ftruncate",
      "futimes",
      "lchmod",
      "lchown",
      "link",
      "lstat",
      "mkdir",
      "mkdtemp",
      "open",
      "opendir",
      "readdir",
      "readFile",
      "readlink",
      "realpath",
      "rename",
      "rm",
      "rmdir",
      "stat",
      "symlink",
      "truncate",
      "unlink",
      "utimes",
      "writeFile"
    ].filter((key) => {
      return typeof fs2[key] === "function";
    });
    Object.keys(fs2).forEach((key) => {
      if (key === "promises") {
        return;
      }
      exports[key] = fs2[key];
    });
    api.forEach((method) => {
      exports[method] = u(fs2[method]);
    });
    exports.exists = function(filename, callback) {
      if (typeof callback === "function") {
        return fs2.exists(filename, callback);
      }
      return new Promise((resolve) => {
        return fs2.exists(filename, resolve);
      });
    };
    exports.read = function(fd, buffer, offset, length, position, callback) {
      if (typeof callback === "function") {
        return fs2.read(fd, buffer, offset, length, position, callback);
      }
      return new Promise((resolve, reject) => {
        fs2.read(fd, buffer, offset, length, position, (err, bytesRead, buffer2) => {
          if (err)
            return reject(err);
          resolve({ bytesRead, buffer: buffer2 });
        });
      });
    };
    exports.write = function(fd, buffer, ...args) {
      if (typeof args[args.length - 1] === "function") {
        return fs2.write(fd, buffer, ...args);
      }
      return new Promise((resolve, reject) => {
        fs2.write(fd, buffer, ...args, (err, bytesWritten, buffer2) => {
          if (err)
            return reject(err);
          resolve({ bytesWritten, buffer: buffer2 });
        });
      });
    };
    if (typeof fs2.writev === "function") {
      exports.writev = function(fd, buffers, ...args) {
        if (typeof args[args.length - 1] === "function") {
          return fs2.writev(fd, buffers, ...args);
        }
        return new Promise((resolve, reject) => {
          fs2.writev(fd, buffers, ...args, (err, bytesWritten, buffers2) => {
            if (err)
              return reject(err);
            resolve({ bytesWritten, buffers: buffers2 });
          });
        });
      };
    }
    if (typeof fs2.realpath.native === "function") {
      exports.realpath.native = u(fs2.realpath.native);
    }
  }
});

// node_modules/at-least-node/index.js
var require_at_least_node = __commonJS({
  "node_modules/at-least-node/index.js"(exports, module2) {
    module2.exports = (r) => {
      const n = process.versions.node.split(".").map((x) => parseInt(x, 10));
      r = r.split(".").map((x) => parseInt(x, 10));
      return n[0] > r[0] || n[0] === r[0] && (n[1] > r[1] || n[1] === r[1] && n[2] >= r[2]);
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/mkdirs/make-dir.js
var require_make_dir2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/mkdirs/make-dir.js"(exports, module2) {
    "use strict";
    var fs2 = require_fs2();
    var path2 = require("path");
    var atLeastNode = require_at_least_node();
    var useNativeRecursiveOption = atLeastNode("10.12.0");
    var checkPath = (pth) => {
      if (process.platform === "win32") {
        const pathHasInvalidWinCharacters = /[<>:"|?*]/.test(pth.replace(path2.parse(pth).root, ""));
        if (pathHasInvalidWinCharacters) {
          const error = new Error(`Path contains invalid characters: ${pth}`);
          error.code = "EINVAL";
          throw error;
        }
      }
    };
    var processOptions = (options) => {
      const defaults = { mode: 511 };
      if (typeof options === "number")
        options = { mode: options };
      return __spreadValues(__spreadValues({}, defaults), options);
    };
    var permissionError = (pth) => {
      const error = new Error(`operation not permitted, mkdir '${pth}'`);
      error.code = "EPERM";
      error.errno = -4048;
      error.path = pth;
      error.syscall = "mkdir";
      return error;
    };
    module2.exports.makeDir = async (input, options) => {
      checkPath(input);
      options = processOptions(options);
      if (useNativeRecursiveOption) {
        const pth = path2.resolve(input);
        return fs2.mkdir(pth, {
          mode: options.mode,
          recursive: true
        });
      }
      const make = async (pth) => {
        try {
          await fs2.mkdir(pth, options.mode);
        } catch (error) {
          if (error.code === "EPERM") {
            throw error;
          }
          if (error.code === "ENOENT") {
            if (path2.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error.message.includes("null bytes")) {
              throw error;
            }
            await make(path2.dirname(pth));
            return make(pth);
          }
          try {
            const stats = await fs2.stat(pth);
            if (!stats.isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch {
            throw error;
          }
        }
      };
      return make(path2.resolve(input));
    };
    module2.exports.makeDirSync = (input, options) => {
      checkPath(input);
      options = processOptions(options);
      if (useNativeRecursiveOption) {
        const pth = path2.resolve(input);
        return fs2.mkdirSync(pth, {
          mode: options.mode,
          recursive: true
        });
      }
      const make = (pth) => {
        try {
          fs2.mkdirSync(pth, options.mode);
        } catch (error) {
          if (error.code === "EPERM") {
            throw error;
          }
          if (error.code === "ENOENT") {
            if (path2.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error.message.includes("null bytes")) {
              throw error;
            }
            make(path2.dirname(pth));
            return make(pth);
          }
          try {
            if (!fs2.statSync(pth).isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch {
            throw error;
          }
        }
      };
      return make(path2.resolve(input));
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/mkdirs/index.js
var require_mkdirs2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/mkdirs/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromPromise;
    var { makeDir: _makeDir, makeDirSync } = require_make_dir2();
    var makeDir = u(_makeDir);
    module2.exports = {
      mkdirs: makeDir,
      mkdirsSync: makeDirSync,
      mkdirp: makeDir,
      mkdirpSync: makeDirSync,
      ensureDir: makeDir,
      ensureDirSync: makeDirSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/util/utimes.js
var require_utimes2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/util/utimes.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    function utimesMillis(path2, atime, mtime, callback) {
      fs2.open(path2, "r+", (err, fd) => {
        if (err)
          return callback(err);
        fs2.futimes(fd, atime, mtime, (futimesErr) => {
          fs2.close(fd, (closeErr) => {
            if (callback)
              callback(futimesErr || closeErr);
          });
        });
      });
    }
    function utimesMillisSync(path2, atime, mtime) {
      const fd = fs2.openSync(path2, "r+");
      fs2.futimesSync(fd, atime, mtime);
      return fs2.closeSync(fd);
    }
    module2.exports = {
      utimesMillis,
      utimesMillisSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/util/stat.js
var require_stat2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/util/stat.js"(exports, module2) {
    "use strict";
    var fs2 = require_fs2();
    var path2 = require("path");
    var util = require("util");
    var atLeastNode = require_at_least_node();
    var nodeSupportsBigInt = atLeastNode("10.5.0");
    var stat = (file) => nodeSupportsBigInt ? fs2.stat(file, { bigint: true }) : fs2.stat(file);
    var statSync = (file) => nodeSupportsBigInt ? fs2.statSync(file, { bigint: true }) : fs2.statSync(file);
    function getStats(src, dest) {
      return Promise.all([
        stat(src),
        stat(dest).catch((err) => {
          if (err.code === "ENOENT")
            return null;
          throw err;
        })
      ]).then(([srcStat, destStat]) => ({ srcStat, destStat }));
    }
    function getStatsSync(src, dest) {
      let destStat;
      const srcStat = statSync(src);
      try {
        destStat = statSync(dest);
      } catch (err) {
        if (err.code === "ENOENT")
          return { srcStat, destStat: null };
        throw err;
      }
      return { srcStat, destStat };
    }
    function checkPaths(src, dest, funcName, cb) {
      util.callbackify(getStats)(src, dest, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        if (destStat && areIdentical(srcStat, destStat)) {
          return cb(new Error("Source and destination must not be the same."));
        }
        if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return cb(null, { srcStat, destStat });
      });
    }
    function checkPathsSync(src, dest, funcName) {
      const { srcStat, destStat } = getStatsSync(src, dest);
      if (destStat && areIdentical(srcStat, destStat)) {
        throw new Error("Source and destination must not be the same.");
      }
      if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return { srcStat, destStat };
    }
    function checkParentPaths(src, srcStat, dest, funcName, cb) {
      const srcParent = path2.resolve(path2.dirname(src));
      const destParent = path2.resolve(path2.dirname(dest));
      if (destParent === srcParent || destParent === path2.parse(destParent).root)
        return cb();
      const callback = (err, destStat) => {
        if (err) {
          if (err.code === "ENOENT")
            return cb();
          return cb(err);
        }
        if (areIdentical(srcStat, destStat)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return checkParentPaths(src, srcStat, destParent, funcName, cb);
      };
      if (nodeSupportsBigInt)
        fs2.stat(destParent, { bigint: true }, callback);
      else
        fs2.stat(destParent, callback);
    }
    function checkParentPathsSync(src, srcStat, dest, funcName) {
      const srcParent = path2.resolve(path2.dirname(src));
      const destParent = path2.resolve(path2.dirname(dest));
      if (destParent === srcParent || destParent === path2.parse(destParent).root)
        return;
      let destStat;
      try {
        destStat = statSync(destParent);
      } catch (err) {
        if (err.code === "ENOENT")
          return;
        throw err;
      }
      if (areIdentical(srcStat, destStat)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return checkParentPathsSync(src, srcStat, destParent, funcName);
    }
    function areIdentical(srcStat, destStat) {
      if (destStat.ino && destStat.dev && destStat.ino === srcStat.ino && destStat.dev === srcStat.dev) {
        if (nodeSupportsBigInt || destStat.ino < Number.MAX_SAFE_INTEGER) {
          return true;
        }
        if (destStat.size === srcStat.size && destStat.mode === srcStat.mode && destStat.nlink === srcStat.nlink && destStat.atimeMs === srcStat.atimeMs && destStat.mtimeMs === srcStat.mtimeMs && destStat.ctimeMs === srcStat.ctimeMs && destStat.birthtimeMs === srcStat.birthtimeMs) {
          return true;
        }
      }
      return false;
    }
    function isSrcSubdir(src, dest) {
      const srcArr = path2.resolve(src).split(path2.sep).filter((i) => i);
      const destArr = path2.resolve(dest).split(path2.sep).filter((i) => i);
      return srcArr.reduce((acc, cur, i) => acc && destArr[i] === cur, true);
    }
    function errMsg(src, dest, funcName) {
      return `Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`;
    }
    module2.exports = {
      checkPaths,
      checkPathsSync,
      checkParentPaths,
      checkParentPathsSync,
      isSrcSubdir
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/copy-sync/copy-sync.js
var require_copy_sync3 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/copy-sync/copy-sync.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var mkdirsSync = require_mkdirs2().mkdirsSync;
    var utimesMillisSync = require_utimes2().utimesMillisSync;
    var stat = require_stat2();
    function copySync(src, dest, opts) {
      if (typeof opts === "function") {
        opts = { filter: opts };
      }
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      const { srcStat, destStat } = stat.checkPathsSync(src, dest, "copy");
      stat.checkParentPathsSync(src, srcStat, dest, "copy");
      return handleFilterAndCopy(destStat, src, dest, opts);
    }
    function handleFilterAndCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest))
        return;
      const destParent = path2.dirname(dest);
      if (!fs2.existsSync(destParent))
        mkdirsSync(destParent);
      return startCopy(destStat, src, dest, opts);
    }
    function startCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest))
        return;
      return getStats(destStat, src, dest, opts);
    }
    function getStats(destStat, src, dest, opts) {
      const statSync = opts.dereference ? fs2.statSync : fs2.lstatSync;
      const srcStat = statSync(src);
      if (srcStat.isDirectory())
        return onDir(srcStat, destStat, src, dest, opts);
      else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
        return onFile(srcStat, destStat, src, dest, opts);
      else if (srcStat.isSymbolicLink())
        return onLink(destStat, src, dest, opts);
    }
    function onFile(srcStat, destStat, src, dest, opts) {
      if (!destStat)
        return copyFile(srcStat, src, dest, opts);
      return mayCopyFile(srcStat, src, dest, opts);
    }
    function mayCopyFile(srcStat, src, dest, opts) {
      if (opts.overwrite) {
        fs2.unlinkSync(dest);
        return copyFile(srcStat, src, dest, opts);
      } else if (opts.errorOnExist) {
        throw new Error(`'${dest}' already exists`);
      }
    }
    function copyFile(srcStat, src, dest, opts) {
      fs2.copyFileSync(src, dest);
      if (opts.preserveTimestamps)
        handleTimestamps(srcStat.mode, src, dest);
      return setDestMode(dest, srcStat.mode);
    }
    function handleTimestamps(srcMode, src, dest) {
      if (fileIsNotWritable(srcMode))
        makeFileWritable(dest, srcMode);
      return setDestTimestamps(src, dest);
    }
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    function makeFileWritable(dest, srcMode) {
      return setDestMode(dest, srcMode | 128);
    }
    function setDestMode(dest, srcMode) {
      return fs2.chmodSync(dest, srcMode);
    }
    function setDestTimestamps(src, dest) {
      const updatedSrcStat = fs2.statSync(src);
      return utimesMillisSync(dest, updatedSrcStat.atime, updatedSrcStat.mtime);
    }
    function onDir(srcStat, destStat, src, dest, opts) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts);
      if (destStat && !destStat.isDirectory()) {
        throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`);
      }
      return copyDir(src, dest, opts);
    }
    function mkDirAndCopy(srcMode, src, dest, opts) {
      fs2.mkdirSync(dest);
      copyDir(src, dest, opts);
      return setDestMode(dest, srcMode);
    }
    function copyDir(src, dest, opts) {
      fs2.readdirSync(src).forEach((item) => copyDirItem(item, src, dest, opts));
    }
    function copyDirItem(item, src, dest, opts) {
      const srcItem = path2.join(src, item);
      const destItem = path2.join(dest, item);
      const { destStat } = stat.checkPathsSync(srcItem, destItem, "copy");
      return startCopy(destStat, srcItem, destItem, opts);
    }
    function onLink(destStat, src, dest, opts) {
      let resolvedSrc = fs2.readlinkSync(src);
      if (opts.dereference) {
        resolvedSrc = path2.resolve(process.cwd(), resolvedSrc);
      }
      if (!destStat) {
        return fs2.symlinkSync(resolvedSrc, dest);
      } else {
        let resolvedDest;
        try {
          resolvedDest = fs2.readlinkSync(dest);
        } catch (err) {
          if (err.code === "EINVAL" || err.code === "UNKNOWN")
            return fs2.symlinkSync(resolvedSrc, dest);
          throw err;
        }
        if (opts.dereference) {
          resolvedDest = path2.resolve(process.cwd(), resolvedDest);
        }
        if (stat.isSrcSubdir(resolvedSrc, resolvedDest)) {
          throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`);
        }
        if (fs2.statSync(dest).isDirectory() && stat.isSrcSubdir(resolvedDest, resolvedSrc)) {
          throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`);
        }
        return copyLink(resolvedSrc, dest);
      }
    }
    function copyLink(resolvedSrc, dest) {
      fs2.unlinkSync(dest);
      return fs2.symlinkSync(resolvedSrc, dest);
    }
    module2.exports = copySync;
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/copy-sync/index.js
var require_copy_sync4 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/copy-sync/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      copySync: require_copy_sync3()
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/path-exists/index.js
var require_path_exists2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/path-exists/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromPromise;
    var fs2 = require_fs2();
    function pathExists(path2) {
      return fs2.access(path2).then(() => true).catch(() => false);
    }
    module2.exports = {
      pathExists: u(pathExists),
      pathExistsSync: fs2.existsSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/copy/copy.js
var require_copy3 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/copy/copy.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var mkdirs = require_mkdirs2().mkdirs;
    var pathExists = require_path_exists2().pathExists;
    var utimesMillis = require_utimes2().utimesMillis;
    var stat = require_stat2();
    function copy(src, dest, opts, cb) {
      if (typeof opts === "function" && !cb) {
        cb = opts;
        opts = {};
      } else if (typeof opts === "function") {
        opts = { filter: opts };
      }
      cb = cb || function() {
      };
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      stat.checkPaths(src, dest, "copy", (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        stat.checkParentPaths(src, srcStat, dest, "copy", (err2) => {
          if (err2)
            return cb(err2);
          if (opts.filter)
            return handleFilter(checkParentDir, destStat, src, dest, opts, cb);
          return checkParentDir(destStat, src, dest, opts, cb);
        });
      });
    }
    function checkParentDir(destStat, src, dest, opts, cb) {
      const destParent = path2.dirname(dest);
      pathExists(destParent, (err, dirExists) => {
        if (err)
          return cb(err);
        if (dirExists)
          return startCopy(destStat, src, dest, opts, cb);
        mkdirs(destParent, (err2) => {
          if (err2)
            return cb(err2);
          return startCopy(destStat, src, dest, opts, cb);
        });
      });
    }
    function handleFilter(onInclude, destStat, src, dest, opts, cb) {
      Promise.resolve(opts.filter(src, dest)).then((include) => {
        if (include)
          return onInclude(destStat, src, dest, opts, cb);
        return cb();
      }, (error) => cb(error));
    }
    function startCopy(destStat, src, dest, opts, cb) {
      if (opts.filter)
        return handleFilter(getStats, destStat, src, dest, opts, cb);
      return getStats(destStat, src, dest, opts, cb);
    }
    function getStats(destStat, src, dest, opts, cb) {
      const stat2 = opts.dereference ? fs2.stat : fs2.lstat;
      stat2(src, (err, srcStat) => {
        if (err)
          return cb(err);
        if (srcStat.isDirectory())
          return onDir(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
          return onFile(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isSymbolicLink())
          return onLink(destStat, src, dest, opts, cb);
      });
    }
    function onFile(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat)
        return copyFile(srcStat, src, dest, opts, cb);
      return mayCopyFile(srcStat, src, dest, opts, cb);
    }
    function mayCopyFile(srcStat, src, dest, opts, cb) {
      if (opts.overwrite) {
        fs2.unlink(dest, (err) => {
          if (err)
            return cb(err);
          return copyFile(srcStat, src, dest, opts, cb);
        });
      } else if (opts.errorOnExist) {
        return cb(new Error(`'${dest}' already exists`));
      } else
        return cb();
    }
    function copyFile(srcStat, src, dest, opts, cb) {
      fs2.copyFile(src, dest, (err) => {
        if (err)
          return cb(err);
        if (opts.preserveTimestamps)
          return handleTimestampsAndMode(srcStat.mode, src, dest, cb);
        return setDestMode(dest, srcStat.mode, cb);
      });
    }
    function handleTimestampsAndMode(srcMode, src, dest, cb) {
      if (fileIsNotWritable(srcMode)) {
        return makeFileWritable(dest, srcMode, (err) => {
          if (err)
            return cb(err);
          return setDestTimestampsAndMode(srcMode, src, dest, cb);
        });
      }
      return setDestTimestampsAndMode(srcMode, src, dest, cb);
    }
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    function makeFileWritable(dest, srcMode, cb) {
      return setDestMode(dest, srcMode | 128, cb);
    }
    function setDestTimestampsAndMode(srcMode, src, dest, cb) {
      setDestTimestamps(src, dest, (err) => {
        if (err)
          return cb(err);
        return setDestMode(dest, srcMode, cb);
      });
    }
    function setDestMode(dest, srcMode, cb) {
      return fs2.chmod(dest, srcMode, cb);
    }
    function setDestTimestamps(src, dest, cb) {
      fs2.stat(src, (err, updatedSrcStat) => {
        if (err)
          return cb(err);
        return utimesMillis(dest, updatedSrcStat.atime, updatedSrcStat.mtime, cb);
      });
    }
    function onDir(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts, cb);
      if (destStat && !destStat.isDirectory()) {
        return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`));
      }
      return copyDir(src, dest, opts, cb);
    }
    function mkDirAndCopy(srcMode, src, dest, opts, cb) {
      fs2.mkdir(dest, (err) => {
        if (err)
          return cb(err);
        copyDir(src, dest, opts, (err2) => {
          if (err2)
            return cb(err2);
          return setDestMode(dest, srcMode, cb);
        });
      });
    }
    function copyDir(src, dest, opts, cb) {
      fs2.readdir(src, (err, items) => {
        if (err)
          return cb(err);
        return copyDirItems(items, src, dest, opts, cb);
      });
    }
    function copyDirItems(items, src, dest, opts, cb) {
      const item = items.pop();
      if (!item)
        return cb();
      return copyDirItem(items, item, src, dest, opts, cb);
    }
    function copyDirItem(items, item, src, dest, opts, cb) {
      const srcItem = path2.join(src, item);
      const destItem = path2.join(dest, item);
      stat.checkPaths(srcItem, destItem, "copy", (err, stats) => {
        if (err)
          return cb(err);
        const { destStat } = stats;
        startCopy(destStat, srcItem, destItem, opts, (err2) => {
          if (err2)
            return cb(err2);
          return copyDirItems(items, src, dest, opts, cb);
        });
      });
    }
    function onLink(destStat, src, dest, opts, cb) {
      fs2.readlink(src, (err, resolvedSrc) => {
        if (err)
          return cb(err);
        if (opts.dereference) {
          resolvedSrc = path2.resolve(process.cwd(), resolvedSrc);
        }
        if (!destStat) {
          return fs2.symlink(resolvedSrc, dest, cb);
        } else {
          fs2.readlink(dest, (err2, resolvedDest) => {
            if (err2) {
              if (err2.code === "EINVAL" || err2.code === "UNKNOWN")
                return fs2.symlink(resolvedSrc, dest, cb);
              return cb(err2);
            }
            if (opts.dereference) {
              resolvedDest = path2.resolve(process.cwd(), resolvedDest);
            }
            if (stat.isSrcSubdir(resolvedSrc, resolvedDest)) {
              return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`));
            }
            if (destStat.isDirectory() && stat.isSrcSubdir(resolvedDest, resolvedSrc)) {
              return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`));
            }
            return copyLink(resolvedSrc, dest, cb);
          });
        }
      });
    }
    function copyLink(resolvedSrc, dest, cb) {
      fs2.unlink(dest, (err) => {
        if (err)
          return cb(err);
        return fs2.symlink(resolvedSrc, dest, cb);
      });
    }
    module2.exports = copy;
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/copy/index.js
var require_copy4 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/copy/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromCallback;
    module2.exports = {
      copy: u(require_copy3())
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/remove/rimraf.js
var require_rimraf2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/remove/rimraf.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var assert = require("assert");
    var isWindows = process.platform === "win32";
    function defaults(options) {
      const methods = [
        "unlink",
        "chmod",
        "stat",
        "lstat",
        "rmdir",
        "readdir"
      ];
      methods.forEach((m) => {
        options[m] = options[m] || fs2[m];
        m = m + "Sync";
        options[m] = options[m] || fs2[m];
      });
      options.maxBusyTries = options.maxBusyTries || 3;
    }
    function rimraf(p, options, cb) {
      let busyTries = 0;
      if (typeof options === "function") {
        cb = options;
        options = {};
      }
      assert(p, "rimraf: missing path");
      assert.strictEqual(typeof p, "string", "rimraf: path should be a string");
      assert.strictEqual(typeof cb, "function", "rimraf: callback function required");
      assert(options, "rimraf: invalid options argument provided");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      defaults(options);
      rimraf_(p, options, function CB(er) {
        if (er) {
          if ((er.code === "EBUSY" || er.code === "ENOTEMPTY" || er.code === "EPERM") && busyTries < options.maxBusyTries) {
            busyTries++;
            const time = busyTries * 100;
            return setTimeout(() => rimraf_(p, options, CB), time);
          }
          if (er.code === "ENOENT")
            er = null;
        }
        cb(er);
      });
    }
    function rimraf_(p, options, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.lstat(p, (er, st) => {
        if (er && er.code === "ENOENT") {
          return cb(null);
        }
        if (er && er.code === "EPERM" && isWindows) {
          return fixWinEPERM(p, options, er, cb);
        }
        if (st && st.isDirectory()) {
          return rmdir(p, options, er, cb);
        }
        options.unlink(p, (er2) => {
          if (er2) {
            if (er2.code === "ENOENT") {
              return cb(null);
            }
            if (er2.code === "EPERM") {
              return isWindows ? fixWinEPERM(p, options, er2, cb) : rmdir(p, options, er2, cb);
            }
            if (er2.code === "EISDIR") {
              return rmdir(p, options, er2, cb);
            }
          }
          return cb(er2);
        });
      });
    }
    function fixWinEPERM(p, options, er, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.chmod(p, 438, (er2) => {
        if (er2) {
          cb(er2.code === "ENOENT" ? null : er);
        } else {
          options.stat(p, (er3, stats) => {
            if (er3) {
              cb(er3.code === "ENOENT" ? null : er);
            } else if (stats.isDirectory()) {
              rmdir(p, options, er, cb);
            } else {
              options.unlink(p, cb);
            }
          });
        }
      });
    }
    function fixWinEPERMSync(p, options, er) {
      let stats;
      assert(p);
      assert(options);
      try {
        options.chmodSync(p, 438);
      } catch (er2) {
        if (er2.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      try {
        stats = options.statSync(p);
      } catch (er3) {
        if (er3.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      if (stats.isDirectory()) {
        rmdirSync(p, options, er);
      } else {
        options.unlinkSync(p);
      }
    }
    function rmdir(p, options, originalEr, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.rmdir(p, (er) => {
        if (er && (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM")) {
          rmkids(p, options, cb);
        } else if (er && er.code === "ENOTDIR") {
          cb(originalEr);
        } else {
          cb(er);
        }
      });
    }
    function rmkids(p, options, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.readdir(p, (er, files) => {
        if (er)
          return cb(er);
        let n = files.length;
        let errState;
        if (n === 0)
          return options.rmdir(p, cb);
        files.forEach((f) => {
          rimraf(path2.join(p, f), options, (er2) => {
            if (errState) {
              return;
            }
            if (er2)
              return cb(errState = er2);
            if (--n === 0) {
              options.rmdir(p, cb);
            }
          });
        });
      });
    }
    function rimrafSync(p, options) {
      let st;
      options = options || {};
      defaults(options);
      assert(p, "rimraf: missing path");
      assert.strictEqual(typeof p, "string", "rimraf: path should be a string");
      assert(options, "rimraf: missing options");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      try {
        st = options.lstatSync(p);
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        }
        if (er.code === "EPERM" && isWindows) {
          fixWinEPERMSync(p, options, er);
        }
      }
      try {
        if (st && st.isDirectory()) {
          rmdirSync(p, options, null);
        } else {
          options.unlinkSync(p);
        }
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        } else if (er.code === "EPERM") {
          return isWindows ? fixWinEPERMSync(p, options, er) : rmdirSync(p, options, er);
        } else if (er.code !== "EISDIR") {
          throw er;
        }
        rmdirSync(p, options, er);
      }
    }
    function rmdirSync(p, options, originalEr) {
      assert(p);
      assert(options);
      try {
        options.rmdirSync(p);
      } catch (er) {
        if (er.code === "ENOTDIR") {
          throw originalEr;
        } else if (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM") {
          rmkidsSync(p, options);
        } else if (er.code !== "ENOENT") {
          throw er;
        }
      }
    }
    function rmkidsSync(p, options) {
      assert(p);
      assert(options);
      options.readdirSync(p).forEach((f) => rimrafSync(path2.join(p, f), options));
      if (isWindows) {
        const startTime = Date.now();
        do {
          try {
            const ret = options.rmdirSync(p, options);
            return ret;
          } catch {
          }
        } while (Date.now() - startTime < 500);
      } else {
        const ret = options.rmdirSync(p, options);
        return ret;
      }
    }
    module2.exports = rimraf;
    rimraf.sync = rimrafSync;
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/remove/index.js
var require_remove2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/remove/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromCallback;
    var rimraf = require_rimraf2();
    module2.exports = {
      remove: u(rimraf),
      removeSync: rimraf.sync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/empty/index.js
var require_empty2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/empty/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromCallback;
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var mkdir = require_mkdirs2();
    var remove2 = require_remove2();
    var emptyDir = u(function emptyDir2(dir, callback) {
      callback = callback || function() {
      };
      fs2.readdir(dir, (err, items) => {
        if (err)
          return mkdir.mkdirs(dir, callback);
        items = items.map((item) => path2.join(dir, item));
        deleteItem();
        function deleteItem() {
          const item = items.pop();
          if (!item)
            return callback();
          remove2.remove(item, (err2) => {
            if (err2)
              return callback(err2);
            deleteItem();
          });
        }
      });
    });
    function emptyDirSync(dir) {
      let items;
      try {
        items = fs2.readdirSync(dir);
      } catch {
        return mkdir.mkdirsSync(dir);
      }
      items.forEach((item) => {
        item = path2.join(dir, item);
        remove2.removeSync(item);
      });
    }
    module2.exports = {
      emptyDirSync,
      emptydirSync: emptyDirSync,
      emptyDir,
      emptydir: emptyDir
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/file.js
var require_file2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/file.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromCallback;
    var path2 = require("path");
    var fs2 = require_graceful_fs();
    var mkdir = require_mkdirs2();
    function createFile(file, callback) {
      function makeFile() {
        fs2.writeFile(file, "", (err) => {
          if (err)
            return callback(err);
          callback();
        });
      }
      fs2.stat(file, (err, stats) => {
        if (!err && stats.isFile())
          return callback();
        const dir = path2.dirname(file);
        fs2.stat(dir, (err2, stats2) => {
          if (err2) {
            if (err2.code === "ENOENT") {
              return mkdir.mkdirs(dir, (err3) => {
                if (err3)
                  return callback(err3);
                makeFile();
              });
            }
            return callback(err2);
          }
          if (stats2.isDirectory())
            makeFile();
          else {
            fs2.readdir(dir, (err3) => {
              if (err3)
                return callback(err3);
            });
          }
        });
      });
    }
    function createFileSync(file) {
      let stats;
      try {
        stats = fs2.statSync(file);
      } catch {
      }
      if (stats && stats.isFile())
        return;
      const dir = path2.dirname(file);
      try {
        if (!fs2.statSync(dir).isDirectory()) {
          fs2.readdirSync(dir);
        }
      } catch (err) {
        if (err && err.code === "ENOENT")
          mkdir.mkdirsSync(dir);
        else
          throw err;
      }
      fs2.writeFileSync(file, "");
    }
    module2.exports = {
      createFile: u(createFile),
      createFileSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/link.js
var require_link2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/link.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromCallback;
    var path2 = require("path");
    var fs2 = require_graceful_fs();
    var mkdir = require_mkdirs2();
    var pathExists = require_path_exists2().pathExists;
    function createLink(srcpath, dstpath, callback) {
      function makeLink(srcpath2, dstpath2) {
        fs2.link(srcpath2, dstpath2, (err) => {
          if (err)
            return callback(err);
          callback(null);
        });
      }
      pathExists(dstpath, (err, destinationExists) => {
        if (err)
          return callback(err);
        if (destinationExists)
          return callback(null);
        fs2.lstat(srcpath, (err2) => {
          if (err2) {
            err2.message = err2.message.replace("lstat", "ensureLink");
            return callback(err2);
          }
          const dir = path2.dirname(dstpath);
          pathExists(dir, (err3, dirExists) => {
            if (err3)
              return callback(err3);
            if (dirExists)
              return makeLink(srcpath, dstpath);
            mkdir.mkdirs(dir, (err4) => {
              if (err4)
                return callback(err4);
              makeLink(srcpath, dstpath);
            });
          });
        });
      });
    }
    function createLinkSync(srcpath, dstpath) {
      const destinationExists = fs2.existsSync(dstpath);
      if (destinationExists)
        return void 0;
      try {
        fs2.lstatSync(srcpath);
      } catch (err) {
        err.message = err.message.replace("lstat", "ensureLink");
        throw err;
      }
      const dir = path2.dirname(dstpath);
      const dirExists = fs2.existsSync(dir);
      if (dirExists)
        return fs2.linkSync(srcpath, dstpath);
      mkdir.mkdirsSync(dir);
      return fs2.linkSync(srcpath, dstpath);
    }
    module2.exports = {
      createLink: u(createLink),
      createLinkSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/symlink-paths.js
var require_symlink_paths2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/symlink-paths.js"(exports, module2) {
    "use strict";
    var path2 = require("path");
    var fs2 = require_graceful_fs();
    var pathExists = require_path_exists2().pathExists;
    function symlinkPaths(srcpath, dstpath, callback) {
      if (path2.isAbsolute(srcpath)) {
        return fs2.lstat(srcpath, (err) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureSymlink");
            return callback(err);
          }
          return callback(null, {
            toCwd: srcpath,
            toDst: srcpath
          });
        });
      } else {
        const dstdir = path2.dirname(dstpath);
        const relativeToDst = path2.join(dstdir, srcpath);
        return pathExists(relativeToDst, (err, exists) => {
          if (err)
            return callback(err);
          if (exists) {
            return callback(null, {
              toCwd: relativeToDst,
              toDst: srcpath
            });
          } else {
            return fs2.lstat(srcpath, (err2) => {
              if (err2) {
                err2.message = err2.message.replace("lstat", "ensureSymlink");
                return callback(err2);
              }
              return callback(null, {
                toCwd: srcpath,
                toDst: path2.relative(dstdir, srcpath)
              });
            });
          }
        });
      }
    }
    function symlinkPathsSync(srcpath, dstpath) {
      let exists;
      if (path2.isAbsolute(srcpath)) {
        exists = fs2.existsSync(srcpath);
        if (!exists)
          throw new Error("absolute srcpath does not exist");
        return {
          toCwd: srcpath,
          toDst: srcpath
        };
      } else {
        const dstdir = path2.dirname(dstpath);
        const relativeToDst = path2.join(dstdir, srcpath);
        exists = fs2.existsSync(relativeToDst);
        if (exists) {
          return {
            toCwd: relativeToDst,
            toDst: srcpath
          };
        } else {
          exists = fs2.existsSync(srcpath);
          if (!exists)
            throw new Error("relative srcpath does not exist");
          return {
            toCwd: srcpath,
            toDst: path2.relative(dstdir, srcpath)
          };
        }
      }
    }
    module2.exports = {
      symlinkPaths,
      symlinkPathsSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/symlink-type.js
var require_symlink_type2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/symlink-type.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    function symlinkType(srcpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      if (type)
        return callback(null, type);
      fs2.lstat(srcpath, (err, stats) => {
        if (err)
          return callback(null, "file");
        type = stats && stats.isDirectory() ? "dir" : "file";
        callback(null, type);
      });
    }
    function symlinkTypeSync(srcpath, type) {
      let stats;
      if (type)
        return type;
      try {
        stats = fs2.lstatSync(srcpath);
      } catch {
        return "file";
      }
      return stats && stats.isDirectory() ? "dir" : "file";
    }
    module2.exports = {
      symlinkType,
      symlinkTypeSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/symlink.js
var require_symlink2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/symlink.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromCallback;
    var path2 = require("path");
    var fs2 = require_graceful_fs();
    var _mkdirs = require_mkdirs2();
    var mkdirs = _mkdirs.mkdirs;
    var mkdirsSync = _mkdirs.mkdirsSync;
    var _symlinkPaths = require_symlink_paths2();
    var symlinkPaths = _symlinkPaths.symlinkPaths;
    var symlinkPathsSync = _symlinkPaths.symlinkPathsSync;
    var _symlinkType = require_symlink_type2();
    var symlinkType = _symlinkType.symlinkType;
    var symlinkTypeSync = _symlinkType.symlinkTypeSync;
    var pathExists = require_path_exists2().pathExists;
    function createSymlink(srcpath, dstpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      pathExists(dstpath, (err, destinationExists) => {
        if (err)
          return callback(err);
        if (destinationExists)
          return callback(null);
        symlinkPaths(srcpath, dstpath, (err2, relative) => {
          if (err2)
            return callback(err2);
          srcpath = relative.toDst;
          symlinkType(relative.toCwd, type, (err3, type2) => {
            if (err3)
              return callback(err3);
            const dir = path2.dirname(dstpath);
            pathExists(dir, (err4, dirExists) => {
              if (err4)
                return callback(err4);
              if (dirExists)
                return fs2.symlink(srcpath, dstpath, type2, callback);
              mkdirs(dir, (err5) => {
                if (err5)
                  return callback(err5);
                fs2.symlink(srcpath, dstpath, type2, callback);
              });
            });
          });
        });
      });
    }
    function createSymlinkSync(srcpath, dstpath, type) {
      const destinationExists = fs2.existsSync(dstpath);
      if (destinationExists)
        return void 0;
      const relative = symlinkPathsSync(srcpath, dstpath);
      srcpath = relative.toDst;
      type = symlinkTypeSync(relative.toCwd, type);
      const dir = path2.dirname(dstpath);
      const exists = fs2.existsSync(dir);
      if (exists)
        return fs2.symlinkSync(srcpath, dstpath, type);
      mkdirsSync(dir);
      return fs2.symlinkSync(srcpath, dstpath, type);
    }
    module2.exports = {
      createSymlink: u(createSymlink),
      createSymlinkSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/index.js
var require_ensure2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/ensure/index.js"(exports, module2) {
    "use strict";
    var file = require_file2();
    var link = require_link2();
    var symlink = require_symlink2();
    module2.exports = {
      createFile: file.createFile,
      createFileSync: file.createFileSync,
      ensureFile: file.createFile,
      ensureFileSync: file.createFileSync,
      createLink: link.createLink,
      createLinkSync: link.createLinkSync,
      ensureLink: link.createLink,
      ensureLinkSync: link.createLinkSync,
      createSymlink: symlink.createSymlink,
      createSymlinkSync: symlink.createSymlinkSync,
      ensureSymlink: symlink.createSymlink,
      ensureSymlinkSync: symlink.createSymlinkSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/jsonfile/utils.js
var require_utils3 = __commonJS({
  "node_modules/jsii-docgen/node_modules/jsonfile/utils.js"(exports, module2) {
    function stringify(obj, { EOL = "\n", finalEOL = true, replacer = null, spaces } = {}) {
      const EOF = finalEOL ? EOL : "";
      const str = JSON.stringify(obj, replacer, spaces);
      return str.replace(/\n/g, EOL) + EOF;
    }
    function stripBom(content) {
      if (Buffer.isBuffer(content))
        content = content.toString("utf8");
      return content.replace(/^\uFEFF/, "");
    }
    module2.exports = { stringify, stripBom };
  }
});

// node_modules/jsii-docgen/node_modules/jsonfile/index.js
var require_jsonfile3 = __commonJS({
  "node_modules/jsii-docgen/node_modules/jsonfile/index.js"(exports, module2) {
    var _fs;
    try {
      _fs = require_graceful_fs();
    } catch (_) {
      _fs = require("fs");
    }
    var universalify = require_universalify2();
    var { stringify, stripBom } = require_utils3();
    async function _readFile(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs2 = options.fs || _fs;
      const shouldThrow = "throws" in options ? options.throws : true;
      let data = await universalify.fromCallback(fs2.readFile)(file, options);
      data = stripBom(data);
      let obj;
      try {
        obj = JSON.parse(data, options ? options.reviver : null);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
      return obj;
    }
    var readFile = universalify.fromPromise(_readFile);
    function readFileSync(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs2 = options.fs || _fs;
      const shouldThrow = "throws" in options ? options.throws : true;
      try {
        let content = fs2.readFileSync(file, options);
        content = stripBom(content);
        return JSON.parse(content, options.reviver);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
    }
    async function _writeFile(file, obj, options = {}) {
      const fs2 = options.fs || _fs;
      const str = stringify(obj, options);
      await universalify.fromCallback(fs2.writeFile)(file, str, options);
    }
    var writeFile = universalify.fromPromise(_writeFile);
    function writeFileSync(file, obj, options = {}) {
      const fs2 = options.fs || _fs;
      const str = stringify(obj, options);
      return fs2.writeFileSync(file, str, options);
    }
    var jsonfile = {
      readFile,
      readFileSync,
      writeFile,
      writeFileSync
    };
    module2.exports = jsonfile;
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/json/jsonfile.js
var require_jsonfile4 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/json/jsonfile.js"(exports, module2) {
    "use strict";
    var jsonFile = require_jsonfile3();
    module2.exports = {
      readJson: jsonFile.readFile,
      readJsonSync: jsonFile.readFileSync,
      writeJson: jsonFile.writeFile,
      writeJsonSync: jsonFile.writeFileSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/output/index.js
var require_output2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/output/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromCallback;
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var mkdir = require_mkdirs2();
    var pathExists = require_path_exists2().pathExists;
    function outputFile(file, data, encoding, callback) {
      if (typeof encoding === "function") {
        callback = encoding;
        encoding = "utf8";
      }
      const dir = path2.dirname(file);
      pathExists(dir, (err, itDoes) => {
        if (err)
          return callback(err);
        if (itDoes)
          return fs2.writeFile(file, data, encoding, callback);
        mkdir.mkdirs(dir, (err2) => {
          if (err2)
            return callback(err2);
          fs2.writeFile(file, data, encoding, callback);
        });
      });
    }
    function outputFileSync(file, ...args) {
      const dir = path2.dirname(file);
      if (fs2.existsSync(dir)) {
        return fs2.writeFileSync(file, ...args);
      }
      mkdir.mkdirsSync(dir);
      fs2.writeFileSync(file, ...args);
    }
    module2.exports = {
      outputFile: u(outputFile),
      outputFileSync
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/json/output-json.js
var require_output_json2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/json/output-json.js"(exports, module2) {
    "use strict";
    var { stringify } = require_utils3();
    var { outputFile } = require_output2();
    async function outputJson(file, data, options = {}) {
      const str = stringify(data, options);
      await outputFile(file, str, options);
    }
    module2.exports = outputJson;
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/json/output-json-sync.js
var require_output_json_sync2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/json/output-json-sync.js"(exports, module2) {
    "use strict";
    var { stringify } = require_utils3();
    var { outputFileSync } = require_output2();
    function outputJsonSync(file, data, options) {
      const str = stringify(data, options);
      outputFileSync(file, str, options);
    }
    module2.exports = outputJsonSync;
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/json/index.js
var require_json2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/json/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromPromise;
    var jsonFile = require_jsonfile4();
    jsonFile.outputJson = u(require_output_json2());
    jsonFile.outputJsonSync = require_output_json_sync2();
    jsonFile.outputJSON = jsonFile.outputJson;
    jsonFile.outputJSONSync = jsonFile.outputJsonSync;
    jsonFile.writeJSON = jsonFile.writeJson;
    jsonFile.writeJSONSync = jsonFile.writeJsonSync;
    jsonFile.readJSON = jsonFile.readJson;
    jsonFile.readJSONSync = jsonFile.readJsonSync;
    module2.exports = jsonFile;
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/move-sync/move-sync.js
var require_move_sync3 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/move-sync/move-sync.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var copySync = require_copy_sync4().copySync;
    var removeSync = require_remove2().removeSync;
    var mkdirpSync = require_mkdirs2().mkdirpSync;
    var stat = require_stat2();
    function moveSync(src, dest, opts) {
      opts = opts || {};
      const overwrite = opts.overwrite || opts.clobber || false;
      const { srcStat } = stat.checkPathsSync(src, dest, "move");
      stat.checkParentPathsSync(src, srcStat, dest, "move");
      mkdirpSync(path2.dirname(dest));
      return doRename(src, dest, overwrite);
    }
    function doRename(src, dest, overwrite) {
      if (overwrite) {
        removeSync(dest);
        return rename(src, dest, overwrite);
      }
      if (fs2.existsSync(dest))
        throw new Error("dest already exists.");
      return rename(src, dest, overwrite);
    }
    function rename(src, dest, overwrite) {
      try {
        fs2.renameSync(src, dest);
      } catch (err) {
        if (err.code !== "EXDEV")
          throw err;
        return moveAcrossDevice(src, dest, overwrite);
      }
    }
    function moveAcrossDevice(src, dest, overwrite) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copySync(src, dest, opts);
      return removeSync(src);
    }
    module2.exports = moveSync;
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/move-sync/index.js
var require_move_sync4 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/move-sync/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      moveSync: require_move_sync3()
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/move/move.js
var require_move3 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/move/move.js"(exports, module2) {
    "use strict";
    var fs2 = require_graceful_fs();
    var path2 = require("path");
    var copy = require_copy4().copy;
    var remove2 = require_remove2().remove;
    var mkdirp2 = require_mkdirs2().mkdirp;
    var pathExists = require_path_exists2().pathExists;
    var stat = require_stat2();
    function move(src, dest, opts, cb) {
      if (typeof opts === "function") {
        cb = opts;
        opts = {};
      }
      const overwrite = opts.overwrite || opts.clobber || false;
      stat.checkPaths(src, dest, "move", (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat } = stats;
        stat.checkParentPaths(src, srcStat, dest, "move", (err2) => {
          if (err2)
            return cb(err2);
          mkdirp2(path2.dirname(dest), (err3) => {
            if (err3)
              return cb(err3);
            return doRename(src, dest, overwrite, cb);
          });
        });
      });
    }
    function doRename(src, dest, overwrite, cb) {
      if (overwrite) {
        return remove2(dest, (err) => {
          if (err)
            return cb(err);
          return rename(src, dest, overwrite, cb);
        });
      }
      pathExists(dest, (err, destExists) => {
        if (err)
          return cb(err);
        if (destExists)
          return cb(new Error("dest already exists."));
        return rename(src, dest, overwrite, cb);
      });
    }
    function rename(src, dest, overwrite, cb) {
      fs2.rename(src, dest, (err) => {
        if (!err)
          return cb();
        if (err.code !== "EXDEV")
          return cb(err);
        return moveAcrossDevice(src, dest, overwrite, cb);
      });
    }
    function moveAcrossDevice(src, dest, overwrite, cb) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copy(src, dest, opts, (err) => {
        if (err)
          return cb(err);
        return remove2(src, cb);
      });
    }
    module2.exports = move;
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/move/index.js
var require_move4 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/move/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify2().fromCallback;
    module2.exports = {
      move: u(require_move3())
    };
  }
});

// node_modules/jsii-docgen/node_modules/fs-extra/lib/index.js
var require_lib2 = __commonJS({
  "node_modules/jsii-docgen/node_modules/fs-extra/lib/index.js"(exports, module2) {
    "use strict";
    module2.exports = __spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues({}, require_fs2()), require_copy_sync4()), require_copy4()), require_empty2()), require_ensure2()), require_json2()), require_mkdirs2()), require_move_sync4()), require_move4()), require_output2()), require_path_exists2()), require_remove2());
    var fs2 = require("fs");
    if (Object.getOwnPropertyDescriptor(fs2, "promises")) {
      Object.defineProperty(module2.exports, "promises", {
        get() {
          return fs2.promises;
        }
      });
    }
  }
});

// node_modules/fs.realpath/old.js
var require_old = __commonJS({
  "node_modules/fs.realpath/old.js"(exports) {
    var pathModule = require("path");
    var isWindows = process.platform === "win32";
    var fs2 = require("fs");
    var DEBUG = process.env.NODE_DEBUG && /fs/.test(process.env.NODE_DEBUG);
    function rethrow() {
      var callback;
      if (DEBUG) {
        var backtrace = new Error();
        callback = debugCallback;
      } else
        callback = missingCallback;
      return callback;
      function debugCallback(err) {
        if (err) {
          backtrace.message = err.message;
          err = backtrace;
          missingCallback(err);
        }
      }
      function missingCallback(err) {
        if (err) {
          if (process.throwDeprecation)
            throw err;
          else if (!process.noDeprecation) {
            var msg = "fs: missing callback " + (err.stack || err.message);
            if (process.traceDeprecation)
              console.trace(msg);
            else
              console.error(msg);
          }
        }
      }
    }
    function maybeCallback(cb) {
      return typeof cb === "function" ? cb : rethrow();
    }
    var normalize = pathModule.normalize;
    if (isWindows) {
      nextPartRe = /(.*?)(?:[\/\\]+|$)/g;
    } else {
      nextPartRe = /(.*?)(?:[\/]+|$)/g;
    }
    var nextPartRe;
    if (isWindows) {
      splitRootRe = /^(?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/][^\\\/]+)?[\\\/]*/;
    } else {
      splitRootRe = /^[\/]*/;
    }
    var splitRootRe;
    exports.realpathSync = function realpathSync(p, cache) {
      p = pathModule.resolve(p);
      if (cache && Object.prototype.hasOwnProperty.call(cache, p)) {
        return cache[p];
      }
      var original = p, seenLinks = {}, knownHard = {};
      var pos;
      var current;
      var base;
      var previous;
      start();
      function start() {
        var m = splitRootRe.exec(p);
        pos = m[0].length;
        current = m[0];
        base = m[0];
        previous = "";
        if (isWindows && !knownHard[base]) {
          fs2.lstatSync(base);
          knownHard[base] = true;
        }
      }
      while (pos < p.length) {
        nextPartRe.lastIndex = pos;
        var result = nextPartRe.exec(p);
        previous = current;
        current += result[0];
        base = previous + result[1];
        pos = nextPartRe.lastIndex;
        if (knownHard[base] || cache && cache[base] === base) {
          continue;
        }
        var resolvedLink;
        if (cache && Object.prototype.hasOwnProperty.call(cache, base)) {
          resolvedLink = cache[base];
        } else {
          var stat = fs2.lstatSync(base);
          if (!stat.isSymbolicLink()) {
            knownHard[base] = true;
            if (cache)
              cache[base] = base;
            continue;
          }
          var linkTarget = null;
          if (!isWindows) {
            var id = stat.dev.toString(32) + ":" + stat.ino.toString(32);
            if (seenLinks.hasOwnProperty(id)) {
              linkTarget = seenLinks[id];
            }
          }
          if (linkTarget === null) {
            fs2.statSync(base);
            linkTarget = fs2.readlinkSync(base);
          }
          resolvedLink = pathModule.resolve(previous, linkTarget);
          if (cache)
            cache[base] = resolvedLink;
          if (!isWindows)
            seenLinks[id] = linkTarget;
        }
        p = pathModule.resolve(resolvedLink, p.slice(pos));
        start();
      }
      if (cache)
        cache[original] = p;
      return p;
    };
    exports.realpath = function realpath(p, cache, cb) {
      if (typeof cb !== "function") {
        cb = maybeCallback(cache);
        cache = null;
      }
      p = pathModule.resolve(p);
      if (cache && Object.prototype.hasOwnProperty.call(cache, p)) {
        return process.nextTick(cb.bind(null, null, cache[p]));
      }
      var original = p, seenLinks = {}, knownHard = {};
      var pos;
      var current;
      var base;
      var previous;
      start();
      function start() {
        var m = splitRootRe.exec(p);
        pos = m[0].length;
        current = m[0];
        base = m[0];
        previous = "";
        if (isWindows && !knownHard[base]) {
          fs2.lstat(base, function(err) {
            if (err)
              return cb(err);
            knownHard[base] = true;
            LOOP();
          });
        } else {
          process.nextTick(LOOP);
        }
      }
      function LOOP() {
        if (pos >= p.length) {
          if (cache)
            cache[original] = p;
          return cb(null, p);
        }
        nextPartRe.lastIndex = pos;
        var result = nextPartRe.exec(p);
        previous = current;
        current += result[0];
        base = previous + result[1];
        pos = nextPartRe.lastIndex;
        if (knownHard[base] || cache && cache[base] === base) {
          return process.nextTick(LOOP);
        }
        if (cache && Object.prototype.hasOwnProperty.call(cache, base)) {
          return gotResolvedLink(cache[base]);
        }
        return fs2.lstat(base, gotStat);
      }
      function gotStat(err, stat) {
        if (err)
          return cb(err);
        if (!stat.isSymbolicLink()) {
          knownHard[base] = true;
          if (cache)
            cache[base] = base;
          return process.nextTick(LOOP);
        }
        if (!isWindows) {
          var id = stat.dev.toString(32) + ":" + stat.ino.toString(32);
          if (seenLinks.hasOwnProperty(id)) {
            return gotTarget(null, seenLinks[id], base);
          }
        }
        fs2.stat(base, function(err2) {
          if (err2)
            return cb(err2);
          fs2.readlink(base, function(err3, target) {
            if (!isWindows)
              seenLinks[id] = target;
            gotTarget(err3, target);
          });
        });
      }
      function gotTarget(err, target, base2) {
        if (err)
          return cb(err);
        var resolvedLink = pathModule.resolve(previous, target);
        if (cache)
          cache[base2] = resolvedLink;
        gotResolvedLink(resolvedLink);
      }
      function gotResolvedLink(resolvedLink) {
        p = pathModule.resolve(resolvedLink, p.slice(pos));
        start();
      }
    };
  }
});

// node_modules/fs.realpath/index.js
var require_fs3 = __commonJS({
  "node_modules/fs.realpath/index.js"(exports, module2) {
    module2.exports = realpath;
    realpath.realpath = realpath;
    realpath.sync = realpathSync;
    realpath.realpathSync = realpathSync;
    realpath.monkeypatch = monkeypatch;
    realpath.unmonkeypatch = unmonkeypatch;
    var fs2 = require("fs");
    var origRealpath = fs2.realpath;
    var origRealpathSync = fs2.realpathSync;
    var version = process.version;
    var ok = /^v[0-5]\./.test(version);
    var old = require_old();
    function newError(er) {
      return er && er.syscall === "realpath" && (er.code === "ELOOP" || er.code === "ENOMEM" || er.code === "ENAMETOOLONG");
    }
    function realpath(p, cache, cb) {
      if (ok) {
        return origRealpath(p, cache, cb);
      }
      if (typeof cache === "function") {
        cb = cache;
        cache = null;
      }
      origRealpath(p, cache, function(er, result) {
        if (newError(er)) {
          old.realpath(p, cache, cb);
        } else {
          cb(er, result);
        }
      });
    }
    function realpathSync(p, cache) {
      if (ok) {
        return origRealpathSync(p, cache);
      }
      try {
        return origRealpathSync(p, cache);
      } catch (er) {
        if (newError(er)) {
          return old.realpathSync(p, cache);
        } else {
          throw er;
        }
      }
    }
    function monkeypatch() {
      fs2.realpath = realpath;
      fs2.realpathSync = realpathSync;
    }
    function unmonkeypatch() {
      fs2.realpath = origRealpath;
      fs2.realpathSync = origRealpathSync;
    }
  }
});

// node_modules/concat-map/index.js
var require_concat_map = __commonJS({
  "node_modules/concat-map/index.js"(exports, module2) {
    module2.exports = function(xs, fn) {
      var res = [];
      for (var i = 0; i < xs.length; i++) {
        var x = fn(xs[i], i);
        if (isArray(x))
          res.push.apply(res, x);
        else
          res.push(x);
      }
      return res;
    };
    var isArray = Array.isArray || function(xs) {
      return Object.prototype.toString.call(xs) === "[object Array]";
    };
  }
});

// node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "node_modules/balanced-match/index.js"(exports, module2) {
    "use strict";
    module2.exports = balanced;
    function balanced(a, b, str) {
      if (a instanceof RegExp)
        a = maybeMatch(a, str);
      if (b instanceof RegExp)
        b = maybeMatch(b, str);
      var r = range(a, b, str);
      return r && {
        start: r[0],
        end: r[1],
        pre: str.slice(0, r[0]),
        body: str.slice(r[0] + a.length, r[1]),
        post: str.slice(r[1] + b.length)
      };
    }
    function maybeMatch(reg, str) {
      var m = str.match(reg);
      return m ? m[0] : null;
    }
    balanced.range = range;
    function range(a, b, str) {
      var begs, beg, left, right, result;
      var ai = str.indexOf(a);
      var bi = str.indexOf(b, ai + 1);
      var i = ai;
      if (ai >= 0 && bi > 0) {
        if (a === b) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i >= 0 && !result) {
          if (i == ai) {
            begs.push(i);
            ai = str.indexOf(a, i + 1);
          } else if (begs.length == 1) {
            result = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b, i + 1);
          }
          i = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result = [left, right];
        }
      }
      return result;
    }
  }
});

// node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "node_modules/brace-expansion/index.js"(exports, module2) {
    var concatMap = require_concat_map();
    var balanced = require_balanced_match();
    module2.exports = expandTop;
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    function numeric(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    function escapeBraces(str) {
      return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
    }
    function unescapeBraces(str) {
      return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
    }
    function parseCommaParts(str) {
      if (!str)
        return [""];
      var parts = [];
      var m = balanced("{", "}", str);
      if (!m)
        return str.split(",");
      var pre = m.pre;
      var body = m.body;
      var post = m.post;
      var p = pre.split(",");
      p[p.length - 1] += "{" + body + "}";
      var postParts = parseCommaParts(post);
      if (post.length) {
        p[p.length - 1] += postParts.shift();
        p.push.apply(p, postParts);
      }
      parts.push.apply(parts, p);
      return parts;
    }
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand(escapeBraces(str), true).map(unescapeBraces);
    }
    function embrace(str) {
      return "{" + str + "}";
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    function lte(i, y) {
      return i <= y;
    }
    function gte(i, y) {
      return i >= y;
    }
    function expand(str, isTop) {
      var expansions = [];
      var m = balanced("{", "}", str);
      if (!m || /\$$/.test(m.pre))
        return [str];
      var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
      var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
      var isSequence = isNumericSequence || isAlphaSequence;
      var isOptions = m.body.indexOf(",") >= 0;
      if (!isSequence && !isOptions) {
        if (m.post.match(/,.*\}/)) {
          str = m.pre + "{" + m.body + escClose + m.post;
          return expand(str);
        }
        return [str];
      }
      var n;
      if (isSequence) {
        n = m.body.split(/\.\./);
      } else {
        n = parseCommaParts(m.body);
        if (n.length === 1) {
          n = expand(n[0], false).map(embrace);
          if (n.length === 1) {
            var post = m.post.length ? expand(m.post, false) : [""];
            return post.map(function(p) {
              return m.pre + n[0] + p;
            });
          }
        }
      }
      var pre = m.pre;
      var post = m.post.length ? expand(m.post, false) : [""];
      var N;
      if (isSequence) {
        var x = numeric(n[0]);
        var y = numeric(n[1]);
        var width = Math.max(n[0].length, n[1].length);
        var incr = n.length == 3 ? Math.abs(numeric(n[2])) : 1;
        var test = lte;
        var reverse = y < x;
        if (reverse) {
          incr *= -1;
          test = gte;
        }
        var pad = n.some(isPadded);
        N = [];
        for (var i = x; test(i, y); i += incr) {
          var c;
          if (isAlphaSequence) {
            c = String.fromCharCode(i);
            if (c === "\\")
              c = "";
          } else {
            c = String(i);
            if (pad) {
              var need = width - c.length;
              if (need > 0) {
                var z = new Array(need + 1).join("0");
                if (i < 0)
                  c = "-" + z + c.slice(1);
                else
                  c = z + c;
              }
            }
          }
          N.push(c);
        }
      } else {
        N = concatMap(n, function(el) {
          return expand(el, false);
        });
      }
      for (var j = 0; j < N.length; j++) {
        for (var k = 0; k < post.length; k++) {
          var expansion = pre + N[j] + post[k];
          if (!isTop || isSequence || expansion)
            expansions.push(expansion);
        }
      }
      return expansions;
    }
  }
});

// node_modules/minimatch/minimatch.js
var require_minimatch = __commonJS({
  "node_modules/minimatch/minimatch.js"(exports, module2) {
    module2.exports = minimatch;
    minimatch.Minimatch = Minimatch;
    var path2 = { sep: "/" };
    try {
      path2 = require("path");
    } catch (er) {
    }
    var GLOBSTAR = minimatch.GLOBSTAR = Minimatch.GLOBSTAR = {};
    var expand = require_brace_expansion();
    var plTypes = {
      "!": { open: "(?:(?!(?:", close: "))[^/]*?)" },
      "?": { open: "(?:", close: ")?" },
      "+": { open: "(?:", close: ")+" },
      "*": { open: "(?:", close: ")*" },
      "@": { open: "(?:", close: ")" }
    };
    var qmark = "[^/]";
    var star = qmark + "*?";
    var twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    var twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
    var reSpecials = charSet("().*{}+?[]^$\\!");
    function charSet(s) {
      return s.split("").reduce(function(set, c) {
        set[c] = true;
        return set;
      }, {});
    }
    var slashSplit = /\/+/;
    minimatch.filter = filter;
    function filter(pattern, options) {
      options = options || {};
      return function(p, i, list) {
        return minimatch(p, pattern, options);
      };
    }
    function ext(a, b) {
      a = a || {};
      b = b || {};
      var t = {};
      Object.keys(b).forEach(function(k) {
        t[k] = b[k];
      });
      Object.keys(a).forEach(function(k) {
        t[k] = a[k];
      });
      return t;
    }
    minimatch.defaults = function(def) {
      if (!def || !Object.keys(def).length)
        return minimatch;
      var orig = minimatch;
      var m = function minimatch2(p, pattern, options) {
        return orig.minimatch(p, pattern, ext(def, options));
      };
      m.Minimatch = function Minimatch2(pattern, options) {
        return new orig.Minimatch(pattern, ext(def, options));
      };
      return m;
    };
    Minimatch.defaults = function(def) {
      if (!def || !Object.keys(def).length)
        return Minimatch;
      return minimatch.defaults(def).Minimatch;
    };
    function minimatch(p, pattern, options) {
      if (typeof pattern !== "string") {
        throw new TypeError("glob pattern string required");
      }
      if (!options)
        options = {};
      if (!options.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      if (pattern.trim() === "")
        return p === "";
      return new Minimatch(pattern, options).match(p);
    }
    function Minimatch(pattern, options) {
      if (!(this instanceof Minimatch)) {
        return new Minimatch(pattern, options);
      }
      if (typeof pattern !== "string") {
        throw new TypeError("glob pattern string required");
      }
      if (!options)
        options = {};
      pattern = pattern.trim();
      if (path2.sep !== "/") {
        pattern = pattern.split(path2.sep).join("/");
      }
      this.options = options;
      this.set = [];
      this.pattern = pattern;
      this.regexp = null;
      this.negate = false;
      this.comment = false;
      this.empty = false;
      this.make();
    }
    Minimatch.prototype.debug = function() {
    };
    Minimatch.prototype.make = make;
    function make() {
      if (this._made)
        return;
      var pattern = this.pattern;
      var options = this.options;
      if (!options.nocomment && pattern.charAt(0) === "#") {
        this.comment = true;
        return;
      }
      if (!pattern) {
        this.empty = true;
        return;
      }
      this.parseNegate();
      var set = this.globSet = this.braceExpand();
      if (options.debug)
        this.debug = console.error;
      this.debug(this.pattern, set);
      set = this.globParts = set.map(function(s) {
        return s.split(slashSplit);
      });
      this.debug(this.pattern, set);
      set = set.map(function(s, si, set2) {
        return s.map(this.parse, this);
      }, this);
      this.debug(this.pattern, set);
      set = set.filter(function(s) {
        return s.indexOf(false) === -1;
      });
      this.debug(this.pattern, set);
      this.set = set;
    }
    Minimatch.prototype.parseNegate = parseNegate;
    function parseNegate() {
      var pattern = this.pattern;
      var negate = false;
      var options = this.options;
      var negateOffset = 0;
      if (options.nonegate)
        return;
      for (var i = 0, l = pattern.length; i < l && pattern.charAt(i) === "!"; i++) {
        negate = !negate;
        negateOffset++;
      }
      if (negateOffset)
        this.pattern = pattern.substr(negateOffset);
      this.negate = negate;
    }
    minimatch.braceExpand = function(pattern, options) {
      return braceExpand(pattern, options);
    };
    Minimatch.prototype.braceExpand = braceExpand;
    function braceExpand(pattern, options) {
      if (!options) {
        if (this instanceof Minimatch) {
          options = this.options;
        } else {
          options = {};
        }
      }
      pattern = typeof pattern === "undefined" ? this.pattern : pattern;
      if (typeof pattern === "undefined") {
        throw new TypeError("undefined pattern");
      }
      if (options.nobrace || !pattern.match(/\{.*\}/)) {
        return [pattern];
      }
      return expand(pattern);
    }
    Minimatch.prototype.parse = parse;
    var SUBPARSE = {};
    function parse(pattern, isSub) {
      if (pattern.length > 1024 * 64) {
        throw new TypeError("pattern is too long");
      }
      var options = this.options;
      if (!options.noglobstar && pattern === "**")
        return GLOBSTAR;
      if (pattern === "")
        return "";
      var re = "";
      var hasMagic = !!options.nocase;
      var escaping = false;
      var patternListStack = [];
      var negativeLists = [];
      var stateChar;
      var inClass = false;
      var reClassStart = -1;
      var classStart = -1;
      var patternStart = pattern.charAt(0) === "." ? "" : options.dot ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)";
      var self2 = this;
      function clearStateChar() {
        if (stateChar) {
          switch (stateChar) {
            case "*":
              re += star;
              hasMagic = true;
              break;
            case "?":
              re += qmark;
              hasMagic = true;
              break;
            default:
              re += "\\" + stateChar;
              break;
          }
          self2.debug("clearStateChar %j %j", stateChar, re);
          stateChar = false;
        }
      }
      for (var i = 0, len = pattern.length, c; i < len && (c = pattern.charAt(i)); i++) {
        this.debug("%s	%s %s %j", pattern, i, re, c);
        if (escaping && reSpecials[c]) {
          re += "\\" + c;
          escaping = false;
          continue;
        }
        switch (c) {
          case "/":
            return false;
          case "\\":
            clearStateChar();
            escaping = true;
            continue;
          case "?":
          case "*":
          case "+":
          case "@":
          case "!":
            this.debug("%s	%s %s %j <-- stateChar", pattern, i, re, c);
            if (inClass) {
              this.debug("  in class");
              if (c === "!" && i === classStart + 1)
                c = "^";
              re += c;
              continue;
            }
            self2.debug("call clearStateChar %j", stateChar);
            clearStateChar();
            stateChar = c;
            if (options.noext)
              clearStateChar();
            continue;
          case "(":
            if (inClass) {
              re += "(";
              continue;
            }
            if (!stateChar) {
              re += "\\(";
              continue;
            }
            patternListStack.push({
              type: stateChar,
              start: i - 1,
              reStart: re.length,
              open: plTypes[stateChar].open,
              close: plTypes[stateChar].close
            });
            re += stateChar === "!" ? "(?:(?!(?:" : "(?:";
            this.debug("plType %j %j", stateChar, re);
            stateChar = false;
            continue;
          case ")":
            if (inClass || !patternListStack.length) {
              re += "\\)";
              continue;
            }
            clearStateChar();
            hasMagic = true;
            var pl = patternListStack.pop();
            re += pl.close;
            if (pl.type === "!") {
              negativeLists.push(pl);
            }
            pl.reEnd = re.length;
            continue;
          case "|":
            if (inClass || !patternListStack.length || escaping) {
              re += "\\|";
              escaping = false;
              continue;
            }
            clearStateChar();
            re += "|";
            continue;
          case "[":
            clearStateChar();
            if (inClass) {
              re += "\\" + c;
              continue;
            }
            inClass = true;
            classStart = i;
            reClassStart = re.length;
            re += c;
            continue;
          case "]":
            if (i === classStart + 1 || !inClass) {
              re += "\\" + c;
              escaping = false;
              continue;
            }
            if (inClass) {
              var cs = pattern.substring(classStart + 1, i);
              try {
                RegExp("[" + cs + "]");
              } catch (er) {
                var sp = this.parse(cs, SUBPARSE);
                re = re.substr(0, reClassStart) + "\\[" + sp[0] + "\\]";
                hasMagic = hasMagic || sp[1];
                inClass = false;
                continue;
              }
            }
            hasMagic = true;
            inClass = false;
            re += c;
            continue;
          default:
            clearStateChar();
            if (escaping) {
              escaping = false;
            } else if (reSpecials[c] && !(c === "^" && inClass)) {
              re += "\\";
            }
            re += c;
        }
      }
      if (inClass) {
        cs = pattern.substr(classStart + 1);
        sp = this.parse(cs, SUBPARSE);
        re = re.substr(0, reClassStart) + "\\[" + sp[0];
        hasMagic = hasMagic || sp[1];
      }
      for (pl = patternListStack.pop(); pl; pl = patternListStack.pop()) {
        var tail = re.slice(pl.reStart + pl.open.length);
        this.debug("setting tail", re, pl);
        tail = tail.replace(/((?:\\{2}){0,64})(\\?)\|/g, function(_, $1, $2) {
          if (!$2) {
            $2 = "\\";
          }
          return $1 + $1 + $2 + "|";
        });
        this.debug("tail=%j\n   %s", tail, tail, pl, re);
        var t = pl.type === "*" ? star : pl.type === "?" ? qmark : "\\" + pl.type;
        hasMagic = true;
        re = re.slice(0, pl.reStart) + t + "\\(" + tail;
      }
      clearStateChar();
      if (escaping) {
        re += "\\\\";
      }
      var addPatternStart = false;
      switch (re.charAt(0)) {
        case ".":
        case "[":
        case "(":
          addPatternStart = true;
      }
      for (var n = negativeLists.length - 1; n > -1; n--) {
        var nl = negativeLists[n];
        var nlBefore = re.slice(0, nl.reStart);
        var nlFirst = re.slice(nl.reStart, nl.reEnd - 8);
        var nlLast = re.slice(nl.reEnd - 8, nl.reEnd);
        var nlAfter = re.slice(nl.reEnd);
        nlLast += nlAfter;
        var openParensBefore = nlBefore.split("(").length - 1;
        var cleanAfter = nlAfter;
        for (i = 0; i < openParensBefore; i++) {
          cleanAfter = cleanAfter.replace(/\)[+*?]?/, "");
        }
        nlAfter = cleanAfter;
        var dollar = "";
        if (nlAfter === "" && isSub !== SUBPARSE) {
          dollar = "$";
        }
        var newRe = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        re = newRe;
      }
      if (re !== "" && hasMagic) {
        re = "(?=.)" + re;
      }
      if (addPatternStart) {
        re = patternStart + re;
      }
      if (isSub === SUBPARSE) {
        return [re, hasMagic];
      }
      if (!hasMagic) {
        return globUnescape(pattern);
      }
      var flags = options.nocase ? "i" : "";
      try {
        var regExp = new RegExp("^" + re + "$", flags);
      } catch (er) {
        return new RegExp("$.");
      }
      regExp._glob = pattern;
      regExp._src = re;
      return regExp;
    }
    minimatch.makeRe = function(pattern, options) {
      return new Minimatch(pattern, options || {}).makeRe();
    };
    Minimatch.prototype.makeRe = makeRe;
    function makeRe() {
      if (this.regexp || this.regexp === false)
        return this.regexp;
      var set = this.set;
      if (!set.length) {
        this.regexp = false;
        return this.regexp;
      }
      var options = this.options;
      var twoStar = options.noglobstar ? star : options.dot ? twoStarDot : twoStarNoDot;
      var flags = options.nocase ? "i" : "";
      var re = set.map(function(pattern) {
        return pattern.map(function(p) {
          return p === GLOBSTAR ? twoStar : typeof p === "string" ? regExpEscape(p) : p._src;
        }).join("\\/");
      }).join("|");
      re = "^(?:" + re + ")$";
      if (this.negate)
        re = "^(?!" + re + ").*$";
      try {
        this.regexp = new RegExp(re, flags);
      } catch (ex) {
        this.regexp = false;
      }
      return this.regexp;
    }
    minimatch.match = function(list, pattern, options) {
      options = options || {};
      var mm = new Minimatch(pattern, options);
      list = list.filter(function(f) {
        return mm.match(f);
      });
      if (mm.options.nonull && !list.length) {
        list.push(pattern);
      }
      return list;
    };
    Minimatch.prototype.match = match;
    function match(f, partial) {
      this.debug("match", f, this.pattern);
      if (this.comment)
        return false;
      if (this.empty)
        return f === "";
      if (f === "/" && partial)
        return true;
      var options = this.options;
      if (path2.sep !== "/") {
        f = f.split(path2.sep).join("/");
      }
      f = f.split(slashSplit);
      this.debug(this.pattern, "split", f);
      var set = this.set;
      this.debug(this.pattern, "set", set);
      var filename;
      var i;
      for (i = f.length - 1; i >= 0; i--) {
        filename = f[i];
        if (filename)
          break;
      }
      for (i = 0; i < set.length; i++) {
        var pattern = set[i];
        var file = f;
        if (options.matchBase && pattern.length === 1) {
          file = [filename];
        }
        var hit = this.matchOne(file, pattern, partial);
        if (hit) {
          if (options.flipNegate)
            return true;
          return !this.negate;
        }
      }
      if (options.flipNegate)
        return false;
      return this.negate;
    }
    Minimatch.prototype.matchOne = function(file, pattern, partial) {
      var options = this.options;
      this.debug("matchOne", { "this": this, file, pattern });
      this.debug("matchOne", file.length, pattern.length);
      for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
        this.debug("matchOne loop");
        var p = pattern[pi];
        var f = file[fi];
        this.debug(pattern, p, f);
        if (p === false)
          return false;
        if (p === GLOBSTAR) {
          this.debug("GLOBSTAR", [pattern, p, f]);
          var fr = fi;
          var pr = pi + 1;
          if (pr === pl) {
            this.debug("** at the end");
            for (; fi < fl; fi++) {
              if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".")
                return false;
            }
            return true;
          }
          while (fr < fl) {
            var swallowee = file[fr];
            this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
            if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
              this.debug("globstar found match!", fr, fl, swallowee);
              return true;
            } else {
              if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
                this.debug("dot detected!", file, fr, pattern, pr);
                break;
              }
              this.debug("globstar swallow a segment, and continue");
              fr++;
            }
          }
          if (partial) {
            this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
            if (fr === fl)
              return true;
          }
          return false;
        }
        var hit;
        if (typeof p === "string") {
          if (options.nocase) {
            hit = f.toLowerCase() === p.toLowerCase();
          } else {
            hit = f === p;
          }
          this.debug("string match", p, f, hit);
        } else {
          hit = f.match(p);
          this.debug("pattern match", p, f, hit);
        }
        if (!hit)
          return false;
      }
      if (fi === fl && pi === pl) {
        return true;
      } else if (fi === fl) {
        return partial;
      } else if (pi === pl) {
        var emptyFileEnd = fi === fl - 1 && file[fi] === "";
        return emptyFileEnd;
      }
      throw new Error("wtf?");
    };
    function globUnescape(s) {
      return s.replace(/\\(.)/g, "$1");
    }
    function regExpEscape(s) {
      return s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    }
  }
});

// node_modules/inherits/inherits_browser.js
var require_inherits_browser = __commonJS({
  "node_modules/inherits/inherits_browser.js"(exports, module2) {
    if (typeof Object.create === "function") {
      module2.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          ctor.prototype = Object.create(superCtor.prototype, {
            constructor: {
              value: ctor,
              enumerable: false,
              writable: true,
              configurable: true
            }
          });
        }
      };
    } else {
      module2.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          var TempCtor = function() {
          };
          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        }
      };
    }
  }
});

// node_modules/inherits/inherits.js
var require_inherits = __commonJS({
  "node_modules/inherits/inherits.js"(exports, module2) {
    try {
      util = require("util");
      if (typeof util.inherits !== "function")
        throw "";
      module2.exports = util.inherits;
    } catch (e) {
      module2.exports = require_inherits_browser();
    }
    var util;
  }
});

// node_modules/path-is-absolute/index.js
var require_path_is_absolute = __commonJS({
  "node_modules/path-is-absolute/index.js"(exports, module2) {
    "use strict";
    function posix(path2) {
      return path2.charAt(0) === "/";
    }
    function win32(path2) {
      var splitDeviceRe = /^([a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?([\\\/])?([\s\S]*?)$/;
      var result = splitDeviceRe.exec(path2);
      var device = result[1] || "";
      var isUnc = Boolean(device && device.charAt(1) !== ":");
      return Boolean(result[2] || isUnc);
    }
    module2.exports = process.platform === "win32" ? win32 : posix;
    module2.exports.posix = posix;
    module2.exports.win32 = win32;
  }
});

// node_modules/glob/common.js
var require_common = __commonJS({
  "node_modules/glob/common.js"(exports) {
    exports.setopts = setopts;
    exports.ownProp = ownProp;
    exports.makeAbs = makeAbs;
    exports.finish = finish;
    exports.mark = mark;
    exports.isIgnored = isIgnored;
    exports.childrenIgnored = childrenIgnored;
    function ownProp(obj, field) {
      return Object.prototype.hasOwnProperty.call(obj, field);
    }
    var fs2 = require("fs");
    var path2 = require("path");
    var minimatch = require_minimatch();
    var isAbsolute = require_path_is_absolute();
    var Minimatch = minimatch.Minimatch;
    function alphasort(a, b) {
      return a.localeCompare(b, "en");
    }
    function setupIgnores(self2, options) {
      self2.ignore = options.ignore || [];
      if (!Array.isArray(self2.ignore))
        self2.ignore = [self2.ignore];
      if (self2.ignore.length) {
        self2.ignore = self2.ignore.map(ignoreMap);
      }
    }
    function ignoreMap(pattern) {
      var gmatcher = null;
      if (pattern.slice(-3) === "/**") {
        var gpattern = pattern.replace(/(\/\*\*)+$/, "");
        gmatcher = new Minimatch(gpattern, { dot: true });
      }
      return {
        matcher: new Minimatch(pattern, { dot: true }),
        gmatcher
      };
    }
    function setopts(self2, pattern, options) {
      if (!options)
        options = {};
      if (options.matchBase && pattern.indexOf("/") === -1) {
        if (options.noglobstar) {
          throw new Error("base matching requires globstar");
        }
        pattern = "**/" + pattern;
      }
      self2.silent = !!options.silent;
      self2.pattern = pattern;
      self2.strict = options.strict !== false;
      self2.realpath = !!options.realpath;
      self2.realpathCache = options.realpathCache || Object.create(null);
      self2.follow = !!options.follow;
      self2.dot = !!options.dot;
      self2.mark = !!options.mark;
      self2.nodir = !!options.nodir;
      if (self2.nodir)
        self2.mark = true;
      self2.sync = !!options.sync;
      self2.nounique = !!options.nounique;
      self2.nonull = !!options.nonull;
      self2.nosort = !!options.nosort;
      self2.nocase = !!options.nocase;
      self2.stat = !!options.stat;
      self2.noprocess = !!options.noprocess;
      self2.absolute = !!options.absolute;
      self2.fs = options.fs || fs2;
      self2.maxLength = options.maxLength || Infinity;
      self2.cache = options.cache || Object.create(null);
      self2.statCache = options.statCache || Object.create(null);
      self2.symlinks = options.symlinks || Object.create(null);
      setupIgnores(self2, options);
      self2.changedCwd = false;
      var cwd = process.cwd();
      if (!ownProp(options, "cwd"))
        self2.cwd = cwd;
      else {
        self2.cwd = path2.resolve(options.cwd);
        self2.changedCwd = self2.cwd !== cwd;
      }
      self2.root = options.root || path2.resolve(self2.cwd, "/");
      self2.root = path2.resolve(self2.root);
      if (process.platform === "win32")
        self2.root = self2.root.replace(/\\/g, "/");
      self2.cwdAbs = isAbsolute(self2.cwd) ? self2.cwd : makeAbs(self2, self2.cwd);
      if (process.platform === "win32")
        self2.cwdAbs = self2.cwdAbs.replace(/\\/g, "/");
      self2.nomount = !!options.nomount;
      options.nonegate = true;
      options.nocomment = true;
      self2.minimatch = new Minimatch(pattern, options);
      self2.options = self2.minimatch.options;
    }
    function finish(self2) {
      var nou = self2.nounique;
      var all = nou ? [] : Object.create(null);
      for (var i = 0, l = self2.matches.length; i < l; i++) {
        var matches = self2.matches[i];
        if (!matches || Object.keys(matches).length === 0) {
          if (self2.nonull) {
            var literal = self2.minimatch.globSet[i];
            if (nou)
              all.push(literal);
            else
              all[literal] = true;
          }
        } else {
          var m = Object.keys(matches);
          if (nou)
            all.push.apply(all, m);
          else
            m.forEach(function(m2) {
              all[m2] = true;
            });
        }
      }
      if (!nou)
        all = Object.keys(all);
      if (!self2.nosort)
        all = all.sort(alphasort);
      if (self2.mark) {
        for (var i = 0; i < all.length; i++) {
          all[i] = self2._mark(all[i]);
        }
        if (self2.nodir) {
          all = all.filter(function(e) {
            var notDir = !/\/$/.test(e);
            var c = self2.cache[e] || self2.cache[makeAbs(self2, e)];
            if (notDir && c)
              notDir = c !== "DIR" && !Array.isArray(c);
            return notDir;
          });
        }
      }
      if (self2.ignore.length)
        all = all.filter(function(m2) {
          return !isIgnored(self2, m2);
        });
      self2.found = all;
    }
    function mark(self2, p) {
      var abs = makeAbs(self2, p);
      var c = self2.cache[abs];
      var m = p;
      if (c) {
        var isDir = c === "DIR" || Array.isArray(c);
        var slash = p.slice(-1) === "/";
        if (isDir && !slash)
          m += "/";
        else if (!isDir && slash)
          m = m.slice(0, -1);
        if (m !== p) {
          var mabs = makeAbs(self2, m);
          self2.statCache[mabs] = self2.statCache[abs];
          self2.cache[mabs] = self2.cache[abs];
        }
      }
      return m;
    }
    function makeAbs(self2, f) {
      var abs = f;
      if (f.charAt(0) === "/") {
        abs = path2.join(self2.root, f);
      } else if (isAbsolute(f) || f === "") {
        abs = f;
      } else if (self2.changedCwd) {
        abs = path2.resolve(self2.cwd, f);
      } else {
        abs = path2.resolve(f);
      }
      if (process.platform === "win32")
        abs = abs.replace(/\\/g, "/");
      return abs;
    }
    function isIgnored(self2, path3) {
      if (!self2.ignore.length)
        return false;
      return self2.ignore.some(function(item) {
        return item.matcher.match(path3) || !!(item.gmatcher && item.gmatcher.match(path3));
      });
    }
    function childrenIgnored(self2, path3) {
      if (!self2.ignore.length)
        return false;
      return self2.ignore.some(function(item) {
        return !!(item.gmatcher && item.gmatcher.match(path3));
      });
    }
  }
});

// node_modules/glob/sync.js
var require_sync = __commonJS({
  "node_modules/glob/sync.js"(exports, module2) {
    module2.exports = globSync;
    globSync.GlobSync = GlobSync;
    var rp = require_fs3();
    var minimatch = require_minimatch();
    var Minimatch = minimatch.Minimatch;
    var Glob = require_glob().Glob;
    var util = require("util");
    var path2 = require("path");
    var assert = require("assert");
    var isAbsolute = require_path_is_absolute();
    var common = require_common();
    var setopts = common.setopts;
    var ownProp = common.ownProp;
    var childrenIgnored = common.childrenIgnored;
    var isIgnored = common.isIgnored;
    function globSync(pattern, options) {
      if (typeof options === "function" || arguments.length === 3)
        throw new TypeError("callback provided to sync glob\nSee: https://github.com/isaacs/node-glob/issues/167");
      return new GlobSync(pattern, options).found;
    }
    function GlobSync(pattern, options) {
      if (!pattern)
        throw new Error("must provide pattern");
      if (typeof options === "function" || arguments.length === 3)
        throw new TypeError("callback provided to sync glob\nSee: https://github.com/isaacs/node-glob/issues/167");
      if (!(this instanceof GlobSync))
        return new GlobSync(pattern, options);
      setopts(this, pattern, options);
      if (this.noprocess)
        return this;
      var n = this.minimatch.set.length;
      this.matches = new Array(n);
      for (var i = 0; i < n; i++) {
        this._process(this.minimatch.set[i], i, false);
      }
      this._finish();
    }
    GlobSync.prototype._finish = function() {
      assert(this instanceof GlobSync);
      if (this.realpath) {
        var self2 = this;
        this.matches.forEach(function(matchset, index) {
          var set = self2.matches[index] = Object.create(null);
          for (var p in matchset) {
            try {
              p = self2._makeAbs(p);
              var real = rp.realpathSync(p, self2.realpathCache);
              set[real] = true;
            } catch (er) {
              if (er.syscall === "stat")
                set[self2._makeAbs(p)] = true;
              else
                throw er;
            }
          }
        });
      }
      common.finish(this);
    };
    GlobSync.prototype._process = function(pattern, index, inGlobStar) {
      assert(this instanceof GlobSync);
      var n = 0;
      while (typeof pattern[n] === "string") {
        n++;
      }
      var prefix;
      switch (n) {
        case pattern.length:
          this._processSimple(pattern.join("/"), index);
          return;
        case 0:
          prefix = null;
          break;
        default:
          prefix = pattern.slice(0, n).join("/");
          break;
      }
      var remain = pattern.slice(n);
      var read;
      if (prefix === null)
        read = ".";
      else if (isAbsolute(prefix) || isAbsolute(pattern.join("/"))) {
        if (!prefix || !isAbsolute(prefix))
          prefix = "/" + prefix;
        read = prefix;
      } else
        read = prefix;
      var abs = this._makeAbs(read);
      if (childrenIgnored(this, read))
        return;
      var isGlobStar = remain[0] === minimatch.GLOBSTAR;
      if (isGlobStar)
        this._processGlobStar(prefix, read, abs, remain, index, inGlobStar);
      else
        this._processReaddir(prefix, read, abs, remain, index, inGlobStar);
    };
    GlobSync.prototype._processReaddir = function(prefix, read, abs, remain, index, inGlobStar) {
      var entries = this._readdir(abs, inGlobStar);
      if (!entries)
        return;
      var pn = remain[0];
      var negate = !!this.minimatch.negate;
      var rawGlob = pn._glob;
      var dotOk = this.dot || rawGlob.charAt(0) === ".";
      var matchedEntries = [];
      for (var i = 0; i < entries.length; i++) {
        var e = entries[i];
        if (e.charAt(0) !== "." || dotOk) {
          var m;
          if (negate && !prefix) {
            m = !e.match(pn);
          } else {
            m = e.match(pn);
          }
          if (m)
            matchedEntries.push(e);
        }
      }
      var len = matchedEntries.length;
      if (len === 0)
        return;
      if (remain.length === 1 && !this.mark && !this.stat) {
        if (!this.matches[index])
          this.matches[index] = Object.create(null);
        for (var i = 0; i < len; i++) {
          var e = matchedEntries[i];
          if (prefix) {
            if (prefix.slice(-1) !== "/")
              e = prefix + "/" + e;
            else
              e = prefix + e;
          }
          if (e.charAt(0) === "/" && !this.nomount) {
            e = path2.join(this.root, e);
          }
          this._emitMatch(index, e);
        }
        return;
      }
      remain.shift();
      for (var i = 0; i < len; i++) {
        var e = matchedEntries[i];
        var newPattern;
        if (prefix)
          newPattern = [prefix, e];
        else
          newPattern = [e];
        this._process(newPattern.concat(remain), index, inGlobStar);
      }
    };
    GlobSync.prototype._emitMatch = function(index, e) {
      if (isIgnored(this, e))
        return;
      var abs = this._makeAbs(e);
      if (this.mark)
        e = this._mark(e);
      if (this.absolute) {
        e = abs;
      }
      if (this.matches[index][e])
        return;
      if (this.nodir) {
        var c = this.cache[abs];
        if (c === "DIR" || Array.isArray(c))
          return;
      }
      this.matches[index][e] = true;
      if (this.stat)
        this._stat(e);
    };
    GlobSync.prototype._readdirInGlobStar = function(abs) {
      if (this.follow)
        return this._readdir(abs, false);
      var entries;
      var lstat;
      var stat;
      try {
        lstat = this.fs.lstatSync(abs);
      } catch (er) {
        if (er.code === "ENOENT") {
          return null;
        }
      }
      var isSym = lstat && lstat.isSymbolicLink();
      this.symlinks[abs] = isSym;
      if (!isSym && lstat && !lstat.isDirectory())
        this.cache[abs] = "FILE";
      else
        entries = this._readdir(abs, false);
      return entries;
    };
    GlobSync.prototype._readdir = function(abs, inGlobStar) {
      var entries;
      if (inGlobStar && !ownProp(this.symlinks, abs))
        return this._readdirInGlobStar(abs);
      if (ownProp(this.cache, abs)) {
        var c = this.cache[abs];
        if (!c || c === "FILE")
          return null;
        if (Array.isArray(c))
          return c;
      }
      try {
        return this._readdirEntries(abs, this.fs.readdirSync(abs));
      } catch (er) {
        this._readdirError(abs, er);
        return null;
      }
    };
    GlobSync.prototype._readdirEntries = function(abs, entries) {
      if (!this.mark && !this.stat) {
        for (var i = 0; i < entries.length; i++) {
          var e = entries[i];
          if (abs === "/")
            e = abs + e;
          else
            e = abs + "/" + e;
          this.cache[e] = true;
        }
      }
      this.cache[abs] = entries;
      return entries;
    };
    GlobSync.prototype._readdirError = function(f, er) {
      switch (er.code) {
        case "ENOTSUP":
        case "ENOTDIR":
          var abs = this._makeAbs(f);
          this.cache[abs] = "FILE";
          if (abs === this.cwdAbs) {
            var error = new Error(er.code + " invalid cwd " + this.cwd);
            error.path = this.cwd;
            error.code = er.code;
            throw error;
          }
          break;
        case "ENOENT":
        case "ELOOP":
        case "ENAMETOOLONG":
        case "UNKNOWN":
          this.cache[this._makeAbs(f)] = false;
          break;
        default:
          this.cache[this._makeAbs(f)] = false;
          if (this.strict)
            throw er;
          if (!this.silent)
            console.error("glob error", er);
          break;
      }
    };
    GlobSync.prototype._processGlobStar = function(prefix, read, abs, remain, index, inGlobStar) {
      var entries = this._readdir(abs, inGlobStar);
      if (!entries)
        return;
      var remainWithoutGlobStar = remain.slice(1);
      var gspref = prefix ? [prefix] : [];
      var noGlobStar = gspref.concat(remainWithoutGlobStar);
      this._process(noGlobStar, index, false);
      var len = entries.length;
      var isSym = this.symlinks[abs];
      if (isSym && inGlobStar)
        return;
      for (var i = 0; i < len; i++) {
        var e = entries[i];
        if (e.charAt(0) === "." && !this.dot)
          continue;
        var instead = gspref.concat(entries[i], remainWithoutGlobStar);
        this._process(instead, index, true);
        var below = gspref.concat(entries[i], remain);
        this._process(below, index, true);
      }
    };
    GlobSync.prototype._processSimple = function(prefix, index) {
      var exists = this._stat(prefix);
      if (!this.matches[index])
        this.matches[index] = Object.create(null);
      if (!exists)
        return;
      if (prefix && isAbsolute(prefix) && !this.nomount) {
        var trail = /[\/\\]$/.test(prefix);
        if (prefix.charAt(0) === "/") {
          prefix = path2.join(this.root, prefix);
        } else {
          prefix = path2.resolve(this.root, prefix);
          if (trail)
            prefix += "/";
        }
      }
      if (process.platform === "win32")
        prefix = prefix.replace(/\\/g, "/");
      this._emitMatch(index, prefix);
    };
    GlobSync.prototype._stat = function(f) {
      var abs = this._makeAbs(f);
      var needDir = f.slice(-1) === "/";
      if (f.length > this.maxLength)
        return false;
      if (!this.stat && ownProp(this.cache, abs)) {
        var c = this.cache[abs];
        if (Array.isArray(c))
          c = "DIR";
        if (!needDir || c === "DIR")
          return c;
        if (needDir && c === "FILE")
          return false;
      }
      var exists;
      var stat = this.statCache[abs];
      if (!stat) {
        var lstat;
        try {
          lstat = this.fs.lstatSync(abs);
        } catch (er) {
          if (er && (er.code === "ENOENT" || er.code === "ENOTDIR")) {
            this.statCache[abs] = false;
            return false;
          }
        }
        if (lstat && lstat.isSymbolicLink()) {
          try {
            stat = this.fs.statSync(abs);
          } catch (er) {
            stat = lstat;
          }
        } else {
          stat = lstat;
        }
      }
      this.statCache[abs] = stat;
      var c = true;
      if (stat)
        c = stat.isDirectory() ? "DIR" : "FILE";
      this.cache[abs] = this.cache[abs] || c;
      if (needDir && c === "FILE")
        return false;
      return c;
    };
    GlobSync.prototype._mark = function(p) {
      return common.mark(this, p);
    };
    GlobSync.prototype._makeAbs = function(f) {
      return common.makeAbs(this, f);
    };
  }
});

// node_modules/wrappy/wrappy.js
var require_wrappy = __commonJS({
  "node_modules/wrappy/wrappy.js"(exports, module2) {
    module2.exports = wrappy;
    function wrappy(fn, cb) {
      if (fn && cb)
        return wrappy(fn)(cb);
      if (typeof fn !== "function")
        throw new TypeError("need wrapper function");
      Object.keys(fn).forEach(function(k) {
        wrapper[k] = fn[k];
      });
      return wrapper;
      function wrapper() {
        var args = new Array(arguments.length);
        for (var i = 0; i < args.length; i++) {
          args[i] = arguments[i];
        }
        var ret = fn.apply(this, args);
        var cb2 = args[args.length - 1];
        if (typeof ret === "function" && ret !== cb2) {
          Object.keys(cb2).forEach(function(k) {
            ret[k] = cb2[k];
          });
        }
        return ret;
      }
    }
  }
});

// node_modules/once/once.js
var require_once = __commonJS({
  "node_modules/once/once.js"(exports, module2) {
    var wrappy = require_wrappy();
    module2.exports = wrappy(once);
    module2.exports.strict = wrappy(onceStrict);
    once.proto = once(function() {
      Object.defineProperty(Function.prototype, "once", {
        value: function() {
          return once(this);
        },
        configurable: true
      });
      Object.defineProperty(Function.prototype, "onceStrict", {
        value: function() {
          return onceStrict(this);
        },
        configurable: true
      });
    });
    function once(fn) {
      var f = function() {
        if (f.called)
          return f.value;
        f.called = true;
        return f.value = fn.apply(this, arguments);
      };
      f.called = false;
      return f;
    }
    function onceStrict(fn) {
      var f = function() {
        if (f.called)
          throw new Error(f.onceError);
        f.called = true;
        return f.value = fn.apply(this, arguments);
      };
      var name = fn.name || "Function wrapped with `once`";
      f.onceError = name + " shouldn't be called more than once";
      f.called = false;
      return f;
    }
  }
});

// node_modules/inflight/inflight.js
var require_inflight = __commonJS({
  "node_modules/inflight/inflight.js"(exports, module2) {
    var wrappy = require_wrappy();
    var reqs = Object.create(null);
    var once = require_once();
    module2.exports = wrappy(inflight);
    function inflight(key, cb) {
      if (reqs[key]) {
        reqs[key].push(cb);
        return null;
      } else {
        reqs[key] = [cb];
        return makeres(key);
      }
    }
    function makeres(key) {
      return once(function RES() {
        var cbs = reqs[key];
        var len = cbs.length;
        var args = slice(arguments);
        try {
          for (var i = 0; i < len; i++) {
            cbs[i].apply(null, args);
          }
        } finally {
          if (cbs.length > len) {
            cbs.splice(0, len);
            process.nextTick(function() {
              RES.apply(null, args);
            });
          } else {
            delete reqs[key];
          }
        }
      });
    }
    function slice(args) {
      var length = args.length;
      var array = [];
      for (var i = 0; i < length; i++)
        array[i] = args[i];
      return array;
    }
  }
});

// node_modules/glob/glob.js
var require_glob = __commonJS({
  "node_modules/glob/glob.js"(exports, module2) {
    module2.exports = glob;
    var rp = require_fs3();
    var minimatch = require_minimatch();
    var Minimatch = minimatch.Minimatch;
    var inherits = require_inherits();
    var EE = require("events").EventEmitter;
    var path2 = require("path");
    var assert = require("assert");
    var isAbsolute = require_path_is_absolute();
    var globSync = require_sync();
    var common = require_common();
    var setopts = common.setopts;
    var ownProp = common.ownProp;
    var inflight = require_inflight();
    var util = require("util");
    var childrenIgnored = common.childrenIgnored;
    var isIgnored = common.isIgnored;
    var once = require_once();
    function glob(pattern, options, cb) {
      if (typeof options === "function")
        cb = options, options = {};
      if (!options)
        options = {};
      if (options.sync) {
        if (cb)
          throw new TypeError("callback provided to sync glob");
        return globSync(pattern, options);
      }
      return new Glob(pattern, options, cb);
    }
    glob.sync = globSync;
    var GlobSync = glob.GlobSync = globSync.GlobSync;
    glob.glob = glob;
    function extend(origin, add) {
      if (add === null || typeof add !== "object") {
        return origin;
      }
      var keys = Object.keys(add);
      var i = keys.length;
      while (i--) {
        origin[keys[i]] = add[keys[i]];
      }
      return origin;
    }
    glob.hasMagic = function(pattern, options_) {
      var options = extend({}, options_);
      options.noprocess = true;
      var g = new Glob(pattern, options);
      var set = g.minimatch.set;
      if (!pattern)
        return false;
      if (set.length > 1)
        return true;
      for (var j = 0; j < set[0].length; j++) {
        if (typeof set[0][j] !== "string")
          return true;
      }
      return false;
    };
    glob.Glob = Glob;
    inherits(Glob, EE);
    function Glob(pattern, options, cb) {
      if (typeof options === "function") {
        cb = options;
        options = null;
      }
      if (options && options.sync) {
        if (cb)
          throw new TypeError("callback provided to sync glob");
        return new GlobSync(pattern, options);
      }
      if (!(this instanceof Glob))
        return new Glob(pattern, options, cb);
      setopts(this, pattern, options);
      this._didRealPath = false;
      var n = this.minimatch.set.length;
      this.matches = new Array(n);
      if (typeof cb === "function") {
        cb = once(cb);
        this.on("error", cb);
        this.on("end", function(matches) {
          cb(null, matches);
        });
      }
      var self2 = this;
      this._processing = 0;
      this._emitQueue = [];
      this._processQueue = [];
      this.paused = false;
      if (this.noprocess)
        return this;
      if (n === 0)
        return done();
      var sync = true;
      for (var i = 0; i < n; i++) {
        this._process(this.minimatch.set[i], i, false, done);
      }
      sync = false;
      function done() {
        --self2._processing;
        if (self2._processing <= 0) {
          if (sync) {
            process.nextTick(function() {
              self2._finish();
            });
          } else {
            self2._finish();
          }
        }
      }
    }
    Glob.prototype._finish = function() {
      assert(this instanceof Glob);
      if (this.aborted)
        return;
      if (this.realpath && !this._didRealpath)
        return this._realpath();
      common.finish(this);
      this.emit("end", this.found);
    };
    Glob.prototype._realpath = function() {
      if (this._didRealpath)
        return;
      this._didRealpath = true;
      var n = this.matches.length;
      if (n === 0)
        return this._finish();
      var self2 = this;
      for (var i = 0; i < this.matches.length; i++)
        this._realpathSet(i, next);
      function next() {
        if (--n === 0)
          self2._finish();
      }
    };
    Glob.prototype._realpathSet = function(index, cb) {
      var matchset = this.matches[index];
      if (!matchset)
        return cb();
      var found = Object.keys(matchset);
      var self2 = this;
      var n = found.length;
      if (n === 0)
        return cb();
      var set = this.matches[index] = Object.create(null);
      found.forEach(function(p, i) {
        p = self2._makeAbs(p);
        rp.realpath(p, self2.realpathCache, function(er, real) {
          if (!er)
            set[real] = true;
          else if (er.syscall === "stat")
            set[p] = true;
          else
            self2.emit("error", er);
          if (--n === 0) {
            self2.matches[index] = set;
            cb();
          }
        });
      });
    };
    Glob.prototype._mark = function(p) {
      return common.mark(this, p);
    };
    Glob.prototype._makeAbs = function(f) {
      return common.makeAbs(this, f);
    };
    Glob.prototype.abort = function() {
      this.aborted = true;
      this.emit("abort");
    };
    Glob.prototype.pause = function() {
      if (!this.paused) {
        this.paused = true;
        this.emit("pause");
      }
    };
    Glob.prototype.resume = function() {
      if (this.paused) {
        this.emit("resume");
        this.paused = false;
        if (this._emitQueue.length) {
          var eq = this._emitQueue.slice(0);
          this._emitQueue.length = 0;
          for (var i = 0; i < eq.length; i++) {
            var e = eq[i];
            this._emitMatch(e[0], e[1]);
          }
        }
        if (this._processQueue.length) {
          var pq = this._processQueue.slice(0);
          this._processQueue.length = 0;
          for (var i = 0; i < pq.length; i++) {
            var p = pq[i];
            this._processing--;
            this._process(p[0], p[1], p[2], p[3]);
          }
        }
      }
    };
    Glob.prototype._process = function(pattern, index, inGlobStar, cb) {
      assert(this instanceof Glob);
      assert(typeof cb === "function");
      if (this.aborted)
        return;
      this._processing++;
      if (this.paused) {
        this._processQueue.push([pattern, index, inGlobStar, cb]);
        return;
      }
      var n = 0;
      while (typeof pattern[n] === "string") {
        n++;
      }
      var prefix;
      switch (n) {
        case pattern.length:
          this._processSimple(pattern.join("/"), index, cb);
          return;
        case 0:
          prefix = null;
          break;
        default:
          prefix = pattern.slice(0, n).join("/");
          break;
      }
      var remain = pattern.slice(n);
      var read;
      if (prefix === null)
        read = ".";
      else if (isAbsolute(prefix) || isAbsolute(pattern.join("/"))) {
        if (!prefix || !isAbsolute(prefix))
          prefix = "/" + prefix;
        read = prefix;
      } else
        read = prefix;
      var abs = this._makeAbs(read);
      if (childrenIgnored(this, read))
        return cb();
      var isGlobStar = remain[0] === minimatch.GLOBSTAR;
      if (isGlobStar)
        this._processGlobStar(prefix, read, abs, remain, index, inGlobStar, cb);
      else
        this._processReaddir(prefix, read, abs, remain, index, inGlobStar, cb);
    };
    Glob.prototype._processReaddir = function(prefix, read, abs, remain, index, inGlobStar, cb) {
      var self2 = this;
      this._readdir(abs, inGlobStar, function(er, entries) {
        return self2._processReaddir2(prefix, read, abs, remain, index, inGlobStar, entries, cb);
      });
    };
    Glob.prototype._processReaddir2 = function(prefix, read, abs, remain, index, inGlobStar, entries, cb) {
      if (!entries)
        return cb();
      var pn = remain[0];
      var negate = !!this.minimatch.negate;
      var rawGlob = pn._glob;
      var dotOk = this.dot || rawGlob.charAt(0) === ".";
      var matchedEntries = [];
      for (var i = 0; i < entries.length; i++) {
        var e = entries[i];
        if (e.charAt(0) !== "." || dotOk) {
          var m;
          if (negate && !prefix) {
            m = !e.match(pn);
          } else {
            m = e.match(pn);
          }
          if (m)
            matchedEntries.push(e);
        }
      }
      var len = matchedEntries.length;
      if (len === 0)
        return cb();
      if (remain.length === 1 && !this.mark && !this.stat) {
        if (!this.matches[index])
          this.matches[index] = Object.create(null);
        for (var i = 0; i < len; i++) {
          var e = matchedEntries[i];
          if (prefix) {
            if (prefix !== "/")
              e = prefix + "/" + e;
            else
              e = prefix + e;
          }
          if (e.charAt(0) === "/" && !this.nomount) {
            e = path2.join(this.root, e);
          }
          this._emitMatch(index, e);
        }
        return cb();
      }
      remain.shift();
      for (var i = 0; i < len; i++) {
        var e = matchedEntries[i];
        var newPattern;
        if (prefix) {
          if (prefix !== "/")
            e = prefix + "/" + e;
          else
            e = prefix + e;
        }
        this._process([e].concat(remain), index, inGlobStar, cb);
      }
      cb();
    };
    Glob.prototype._emitMatch = function(index, e) {
      if (this.aborted)
        return;
      if (isIgnored(this, e))
        return;
      if (this.paused) {
        this._emitQueue.push([index, e]);
        return;
      }
      var abs = isAbsolute(e) ? e : this._makeAbs(e);
      if (this.mark)
        e = this._mark(e);
      if (this.absolute)
        e = abs;
      if (this.matches[index][e])
        return;
      if (this.nodir) {
        var c = this.cache[abs];
        if (c === "DIR" || Array.isArray(c))
          return;
      }
      this.matches[index][e] = true;
      var st = this.statCache[abs];
      if (st)
        this.emit("stat", e, st);
      this.emit("match", e);
    };
    Glob.prototype._readdirInGlobStar = function(abs, cb) {
      if (this.aborted)
        return;
      if (this.follow)
        return this._readdir(abs, false, cb);
      var lstatkey = "lstat\0" + abs;
      var self2 = this;
      var lstatcb = inflight(lstatkey, lstatcb_);
      if (lstatcb)
        self2.fs.lstat(abs, lstatcb);
      function lstatcb_(er, lstat) {
        if (er && er.code === "ENOENT")
          return cb();
        var isSym = lstat && lstat.isSymbolicLink();
        self2.symlinks[abs] = isSym;
        if (!isSym && lstat && !lstat.isDirectory()) {
          self2.cache[abs] = "FILE";
          cb();
        } else
          self2._readdir(abs, false, cb);
      }
    };
    Glob.prototype._readdir = function(abs, inGlobStar, cb) {
      if (this.aborted)
        return;
      cb = inflight("readdir\0" + abs + "\0" + inGlobStar, cb);
      if (!cb)
        return;
      if (inGlobStar && !ownProp(this.symlinks, abs))
        return this._readdirInGlobStar(abs, cb);
      if (ownProp(this.cache, abs)) {
        var c = this.cache[abs];
        if (!c || c === "FILE")
          return cb();
        if (Array.isArray(c))
          return cb(null, c);
      }
      var self2 = this;
      self2.fs.readdir(abs, readdirCb(this, abs, cb));
    };
    function readdirCb(self2, abs, cb) {
      return function(er, entries) {
        if (er)
          self2._readdirError(abs, er, cb);
        else
          self2._readdirEntries(abs, entries, cb);
      };
    }
    Glob.prototype._readdirEntries = function(abs, entries, cb) {
      if (this.aborted)
        return;
      if (!this.mark && !this.stat) {
        for (var i = 0; i < entries.length; i++) {
          var e = entries[i];
          if (abs === "/")
            e = abs + e;
          else
            e = abs + "/" + e;
          this.cache[e] = true;
        }
      }
      this.cache[abs] = entries;
      return cb(null, entries);
    };
    Glob.prototype._readdirError = function(f, er, cb) {
      if (this.aborted)
        return;
      switch (er.code) {
        case "ENOTSUP":
        case "ENOTDIR":
          var abs = this._makeAbs(f);
          this.cache[abs] = "FILE";
          if (abs === this.cwdAbs) {
            var error = new Error(er.code + " invalid cwd " + this.cwd);
            error.path = this.cwd;
            error.code = er.code;
            this.emit("error", error);
            this.abort();
          }
          break;
        case "ENOENT":
        case "ELOOP":
        case "ENAMETOOLONG":
        case "UNKNOWN":
          this.cache[this._makeAbs(f)] = false;
          break;
        default:
          this.cache[this._makeAbs(f)] = false;
          if (this.strict) {
            this.emit("error", er);
            this.abort();
          }
          if (!this.silent)
            console.error("glob error", er);
          break;
      }
      return cb();
    };
    Glob.prototype._processGlobStar = function(prefix, read, abs, remain, index, inGlobStar, cb) {
      var self2 = this;
      this._readdir(abs, inGlobStar, function(er, entries) {
        self2._processGlobStar2(prefix, read, abs, remain, index, inGlobStar, entries, cb);
      });
    };
    Glob.prototype._processGlobStar2 = function(prefix, read, abs, remain, index, inGlobStar, entries, cb) {
      if (!entries)
        return cb();
      var remainWithoutGlobStar = remain.slice(1);
      var gspref = prefix ? [prefix] : [];
      var noGlobStar = gspref.concat(remainWithoutGlobStar);
      this._process(noGlobStar, index, false, cb);
      var isSym = this.symlinks[abs];
      var len = entries.length;
      if (isSym && inGlobStar)
        return cb();
      for (var i = 0; i < len; i++) {
        var e = entries[i];
        if (e.charAt(0) === "." && !this.dot)
          continue;
        var instead = gspref.concat(entries[i], remainWithoutGlobStar);
        this._process(instead, index, true, cb);
        var below = gspref.concat(entries[i], remain);
        this._process(below, index, true, cb);
      }
      cb();
    };
    Glob.prototype._processSimple = function(prefix, index, cb) {
      var self2 = this;
      this._stat(prefix, function(er, exists) {
        self2._processSimple2(prefix, index, er, exists, cb);
      });
    };
    Glob.prototype._processSimple2 = function(prefix, index, er, exists, cb) {
      if (!this.matches[index])
        this.matches[index] = Object.create(null);
      if (!exists)
        return cb();
      if (prefix && isAbsolute(prefix) && !this.nomount) {
        var trail = /[\/\\]$/.test(prefix);
        if (prefix.charAt(0) === "/") {
          prefix = path2.join(this.root, prefix);
        } else {
          prefix = path2.resolve(this.root, prefix);
          if (trail)
            prefix += "/";
        }
      }
      if (process.platform === "win32")
        prefix = prefix.replace(/\\/g, "/");
      this._emitMatch(index, prefix);
      cb();
    };
    Glob.prototype._stat = function(f, cb) {
      var abs = this._makeAbs(f);
      var needDir = f.slice(-1) === "/";
      if (f.length > this.maxLength)
        return cb();
      if (!this.stat && ownProp(this.cache, abs)) {
        var c = this.cache[abs];
        if (Array.isArray(c))
          c = "DIR";
        if (!needDir || c === "DIR")
          return cb(null, c);
        if (needDir && c === "FILE")
          return cb();
      }
      var exists;
      var stat = this.statCache[abs];
      if (stat !== void 0) {
        if (stat === false)
          return cb(null, stat);
        else {
          var type = stat.isDirectory() ? "DIR" : "FILE";
          if (needDir && type === "FILE")
            return cb();
          else
            return cb(null, type, stat);
        }
      }
      var self2 = this;
      var statcb = inflight("stat\0" + abs, lstatcb_);
      if (statcb)
        self2.fs.lstat(abs, statcb);
      function lstatcb_(er, lstat) {
        if (lstat && lstat.isSymbolicLink()) {
          return self2.fs.stat(abs, function(er2, stat2) {
            if (er2)
              self2._stat2(f, abs, null, lstat, cb);
            else
              self2._stat2(f, abs, er2, stat2, cb);
          });
        } else {
          self2._stat2(f, abs, er, lstat, cb);
        }
      }
    };
    Glob.prototype._stat2 = function(f, abs, er, stat, cb) {
      if (er && (er.code === "ENOENT" || er.code === "ENOTDIR")) {
        this.statCache[abs] = false;
        return cb();
      }
      var needDir = f.slice(-1) === "/";
      this.statCache[abs] = stat;
      if (abs.slice(-1) === "/" && stat && !stat.isDirectory())
        return cb(null, false, stat);
      var c = true;
      if (stat)
        c = stat.isDirectory() ? "DIR" : "FILE";
      this.cache[abs] = this.cache[abs] || c;
      if (needDir && c === "FILE")
        return cb();
      return cb(null, c, stat);
    };
  }
});

// node_modules/glob-promise/lib/index.js
var require_lib3 = __commonJS({
  "node_modules/glob-promise/lib/index.js"(exports, module2) {
    "use strict";
    var glob = require_glob();
    var promise = function(pattern, options) {
      return new Promise((resolve, reject) => {
        glob(pattern, options, (err, files) => err === null ? resolve(files) : reject(err));
      });
    };
    module2.exports = promise;
    module2.exports.glob = glob;
    module2.exports.Glob = glob.Glob;
    module2.exports.hasMagic = glob.hasMagic;
    module2.exports.promise = promise;
    module2.exports.sync = glob.sync;
  }
});

// node_modules/@jsii/spec/lib/assembly.js
var require_assembly = __commonJS({
  "node_modules/@jsii/spec/lib/assembly.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isDeprecated = exports.describeTypeReference = exports.isClassOrInterfaceType = exports.isEnumType = exports.isInterfaceType = exports.isClassType = exports.TypeKind = exports.isMethod = exports.isUnionTypeReference = exports.isCollectionTypeReference = exports.isPrimitiveTypeReference = exports.isNamedTypeReference = exports.CANONICAL_ANY = exports.PrimitiveType = exports.CollectionKind = exports.Stability = exports.SchemaVersion = exports.SPEC_FILE_NAME = void 0;
    exports.SPEC_FILE_NAME = ".jsii";
    var SchemaVersion;
    (function(SchemaVersion2) {
      SchemaVersion2["LATEST"] = "jsii/0.10.0";
    })(SchemaVersion = exports.SchemaVersion || (exports.SchemaVersion = {}));
    var Stability;
    (function(Stability2) {
      Stability2["Deprecated"] = "deprecated";
      Stability2["Experimental"] = "experimental";
      Stability2["Stable"] = "stable";
      Stability2["External"] = "external";
    })(Stability = exports.Stability || (exports.Stability = {}));
    var CollectionKind;
    (function(CollectionKind2) {
      CollectionKind2["Array"] = "array";
      CollectionKind2["Map"] = "map";
    })(CollectionKind = exports.CollectionKind || (exports.CollectionKind = {}));
    var PrimitiveType;
    (function(PrimitiveType2) {
      PrimitiveType2["Date"] = "date";
      PrimitiveType2["String"] = "string";
      PrimitiveType2["Number"] = "number";
      PrimitiveType2["Boolean"] = "boolean";
      PrimitiveType2["Json"] = "json";
      PrimitiveType2["Any"] = "any";
    })(PrimitiveType = exports.PrimitiveType || (exports.PrimitiveType = {}));
    exports.CANONICAL_ANY = {
      primitive: PrimitiveType.Any
    };
    function isNamedTypeReference(ref) {
      var _a;
      return !!((_a = ref) === null || _a === void 0 ? void 0 : _a.fqn);
    }
    exports.isNamedTypeReference = isNamedTypeReference;
    function isPrimitiveTypeReference(ref) {
      var _a;
      return !!((_a = ref) === null || _a === void 0 ? void 0 : _a.primitive);
    }
    exports.isPrimitiveTypeReference = isPrimitiveTypeReference;
    function isCollectionTypeReference(ref) {
      var _a;
      return !!((_a = ref) === null || _a === void 0 ? void 0 : _a.collection);
    }
    exports.isCollectionTypeReference = isCollectionTypeReference;
    function isUnionTypeReference(ref) {
      var _a;
      return !!((_a = ref) === null || _a === void 0 ? void 0 : _a.union);
    }
    exports.isUnionTypeReference = isUnionTypeReference;
    function isMethod(callable) {
      return !!callable.name;
    }
    exports.isMethod = isMethod;
    var TypeKind;
    (function(TypeKind2) {
      TypeKind2["Class"] = "class";
      TypeKind2["Enum"] = "enum";
      TypeKind2["Interface"] = "interface";
    })(TypeKind = exports.TypeKind || (exports.TypeKind = {}));
    function isClassType(type) {
      return (type === null || type === void 0 ? void 0 : type.kind) === TypeKind.Class;
    }
    exports.isClassType = isClassType;
    function isInterfaceType(type) {
      return (type === null || type === void 0 ? void 0 : type.kind) === TypeKind.Interface;
    }
    exports.isInterfaceType = isInterfaceType;
    function isEnumType(type) {
      return (type === null || type === void 0 ? void 0 : type.kind) === TypeKind.Enum;
    }
    exports.isEnumType = isEnumType;
    function isClassOrInterfaceType(type) {
      return isClassType(type) || isInterfaceType(type);
    }
    exports.isClassOrInterfaceType = isClassOrInterfaceType;
    function describeTypeReference(type) {
      if (type === void 0) {
        return "void";
      }
      if (isNamedTypeReference(type)) {
        return type.fqn;
      }
      if (isPrimitiveTypeReference(type)) {
        return type.primitive;
      }
      if (isCollectionTypeReference(type)) {
        return `${type.collection.kind}<${describeTypeReference(type.collection.elementtype)}>`;
      }
      if (isUnionTypeReference(type)) {
        const unionType = type.union.types.map(describeTypeReference).join(" | ");
        return unionType;
      }
      throw new Error("Unrecognized type reference");
    }
    exports.describeTypeReference = describeTypeReference;
    function isDeprecated(entity) {
      var _a;
      return ((_a = entity === null || entity === void 0 ? void 0 : entity.docs) === null || _a === void 0 ? void 0 : _a.stability) === Stability.Deprecated;
    }
    exports.isDeprecated = isDeprecated;
  }
});

// node_modules/@jsii/spec/lib/configuration.js
var require_configuration = __commonJS({
  "node_modules/@jsii/spec/lib/configuration.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/@jsii/spec/lib/name-tree.js
var require_name_tree = __commonJS({
  "node_modules/@jsii/spec/lib/name-tree.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.NameTree = void 0;
    var NameTree = class {
      constructor() {
        this._children = {};
      }
      static of(assm) {
        var _a;
        const nameTree = new NameTree();
        for (const type of Object.values((_a = assm.types) !== null && _a !== void 0 ? _a : {})) {
          nameTree.register(type.fqn);
        }
        return nameTree;
      }
      get children() {
        return this._children;
      }
      get fqn() {
        return this._fqn;
      }
      register(fqn, path2 = fqn.split(".")) {
        if (path2.length === 0) {
          this._fqn = fqn;
        } else {
          const [head, ...rest] = path2;
          if (!this._children[head]) {
            this._children[head] = new NameTree();
          }
          this._children[head].register(fqn, rest);
        }
        return this;
      }
    };
    exports.NameTree = NameTree;
  }
});

// node_modules/jsonschema/lib/helpers.js
var require_helpers = __commonJS({
  "node_modules/jsonschema/lib/helpers.js"(exports, module2) {
    "use strict";
    var uri = require("url");
    var ValidationError = exports.ValidationError = function ValidationError2(message, instance, schema, path2, name, argument) {
      if (Array.isArray(path2)) {
        this.path = path2;
        this.property = path2.reduce(function(sum, item) {
          return sum + makeSuffix(item);
        }, "instance");
      } else if (path2 !== void 0) {
        this.property = path2;
      }
      if (message) {
        this.message = message;
      }
      if (schema) {
        var id = schema.$id || schema.id;
        this.schema = id || schema;
      }
      if (instance !== void 0) {
        this.instance = instance;
      }
      this.name = name;
      this.argument = argument;
      this.stack = this.toString();
    };
    ValidationError.prototype.toString = function toString() {
      return this.property + " " + this.message;
    };
    var ValidatorResult = exports.ValidatorResult = function ValidatorResult2(instance, schema, options, ctx) {
      this.instance = instance;
      this.schema = schema;
      this.options = options;
      this.path = ctx.path;
      this.propertyPath = ctx.propertyPath;
      this.errors = [];
      this.throwError = options && options.throwError;
      this.throwFirst = options && options.throwFirst;
      this.throwAll = options && options.throwAll;
      this.disableFormat = options && options.disableFormat === true;
    };
    ValidatorResult.prototype.addError = function addError(detail) {
      var err;
      if (typeof detail == "string") {
        err = new ValidationError(detail, this.instance, this.schema, this.path);
      } else {
        if (!detail)
          throw new Error("Missing error detail");
        if (!detail.message)
          throw new Error("Missing error message");
        if (!detail.name)
          throw new Error("Missing validator type");
        err = new ValidationError(detail.message, this.instance, this.schema, this.path, detail.name, detail.argument);
      }
      this.errors.push(err);
      if (this.throwFirst) {
        throw new ValidatorResultError(this);
      } else if (this.throwError) {
        throw err;
      }
      return err;
    };
    ValidatorResult.prototype.importErrors = function importErrors(res) {
      if (typeof res == "string" || res && res.validatorType) {
        this.addError(res);
      } else if (res && res.errors) {
        Array.prototype.push.apply(this.errors, res.errors);
      }
    };
    function stringizer(v, i) {
      return i + ": " + v.toString() + "\n";
    }
    ValidatorResult.prototype.toString = function toString(res) {
      return this.errors.map(stringizer).join("");
    };
    Object.defineProperty(ValidatorResult.prototype, "valid", { get: function() {
      return !this.errors.length;
    } });
    module2.exports.ValidatorResultError = ValidatorResultError;
    function ValidatorResultError(result) {
      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, ValidatorResultError);
      }
      this.instance = result.instance;
      this.schema = result.schema;
      this.options = result.options;
      this.errors = result.errors;
    }
    ValidatorResultError.prototype = new Error();
    ValidatorResultError.prototype.constructor = ValidatorResultError;
    ValidatorResultError.prototype.name = "Validation Error";
    var SchemaError = exports.SchemaError = function SchemaError2(msg, schema) {
      this.message = msg;
      this.schema = schema;
      Error.call(this, msg);
      Error.captureStackTrace(this, SchemaError2);
    };
    SchemaError.prototype = Object.create(Error.prototype, {
      constructor: { value: SchemaError, enumerable: false },
      name: { value: "SchemaError", enumerable: false }
    });
    var SchemaContext = exports.SchemaContext = function SchemaContext2(schema, options, path2, base, schemas) {
      this.schema = schema;
      this.options = options;
      if (Array.isArray(path2)) {
        this.path = path2;
        this.propertyPath = path2.reduce(function(sum, item) {
          return sum + makeSuffix(item);
        }, "instance");
      } else {
        this.propertyPath = path2;
      }
      this.base = base;
      this.schemas = schemas;
    };
    SchemaContext.prototype.resolve = function resolve(target) {
      return uri.resolve(this.base, target);
    };
    SchemaContext.prototype.makeChild = function makeChild(schema, propertyName) {
      var path2 = propertyName === void 0 ? this.path : this.path.concat([propertyName]);
      var id = schema.$id || schema.id;
      var base = uri.resolve(this.base, id || "");
      var ctx = new SchemaContext(schema, this.options, path2, base, Object.create(this.schemas));
      if (id && !ctx.schemas[base]) {
        ctx.schemas[base] = schema;
      }
      return ctx;
    };
    var FORMAT_REGEXPS = exports.FORMAT_REGEXPS = {
      "date-time": /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])[tT ](2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])(\.\d+)?([zZ]|[+-]([0-5][0-9]):(60|[0-5][0-9]))$/,
      "date": /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])$/,
      "time": /^(2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])$/,
      "email": /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/,
      "ip-address": /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,
      "ipv6": /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,
      "uri": /^[a-zA-Z][a-zA-Z0-9+-.]*:[^\s]*$/,
      "uri-reference": /^(((([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:?)?)|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?))#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(([A-Za-z][+\-.0-9A-Za-z]*)?%[0-9A-Fa-f]{2}|[!$&-.0-9;=@_~]|[A-Za-z][+\-.0-9A-Za-z]*[!$&-*,;=@_~])(%[0-9A-Fa-f]{2}|[!$&-.0-9;=@-Z_a-z~])*((([/?](%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?#|[/?])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?|([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)?|[A-Za-z][+\-.0-9A-Za-z]*:?)?$/,
      "color": /^(#?([0-9A-Fa-f]{3}){1,2}\b|aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow|(rgb\(\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*\))|(rgb\(\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*\)))$/,
      "hostname": /^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,
      "host-name": /^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,
      "alpha": /^[a-zA-Z]+$/,
      "alphanumeric": /^[a-zA-Z0-9]+$/,
      "utc-millisec": function(input) {
        return typeof input === "string" && parseFloat(input) === parseInt(input, 10) && !isNaN(input);
      },
      "regex": function(input) {
        var result = true;
        try {
          new RegExp(input);
        } catch (e) {
          result = false;
        }
        return result;
      },
      "style": /\s*(.+?):\s*([^;]+);?/,
      "phone": /^\+(?:[0-9] ?){6,14}[0-9]$/
    };
    FORMAT_REGEXPS.regexp = FORMAT_REGEXPS.regex;
    FORMAT_REGEXPS.pattern = FORMAT_REGEXPS.regex;
    FORMAT_REGEXPS.ipv4 = FORMAT_REGEXPS["ip-address"];
    exports.isFormat = function isFormat(input, format, validator) {
      if (typeof input === "string" && FORMAT_REGEXPS[format] !== void 0) {
        if (FORMAT_REGEXPS[format] instanceof RegExp) {
          return FORMAT_REGEXPS[format].test(input);
        }
        if (typeof FORMAT_REGEXPS[format] === "function") {
          return FORMAT_REGEXPS[format](input);
        }
      } else if (validator && validator.customFormats && typeof validator.customFormats[format] === "function") {
        return validator.customFormats[format](input);
      }
      return true;
    };
    var makeSuffix = exports.makeSuffix = function makeSuffix2(key) {
      key = key.toString();
      if (!key.match(/[.\s\[\]]/) && !key.match(/^[\d]/)) {
        return "." + key;
      }
      if (key.match(/^\d+$/)) {
        return "[" + key + "]";
      }
      return "[" + JSON.stringify(key) + "]";
    };
    exports.deepCompareStrict = function deepCompareStrict(a, b) {
      if (typeof a !== typeof b) {
        return false;
      }
      if (Array.isArray(a)) {
        if (!Array.isArray(b)) {
          return false;
        }
        if (a.length !== b.length) {
          return false;
        }
        return a.every(function(v, i) {
          return deepCompareStrict(a[i], b[i]);
        });
      }
      if (typeof a === "object") {
        if (!a || !b) {
          return a === b;
        }
        var aKeys = Object.keys(a);
        var bKeys = Object.keys(b);
        if (aKeys.length !== bKeys.length) {
          return false;
        }
        return aKeys.every(function(v) {
          return deepCompareStrict(a[v], b[v]);
        });
      }
      return a === b;
    };
    function deepMerger(target, dst, e, i) {
      if (typeof e === "object") {
        dst[i] = deepMerge(target[i], e);
      } else {
        if (target.indexOf(e) === -1) {
          dst.push(e);
        }
      }
    }
    function copyist(src, dst, key) {
      dst[key] = src[key];
    }
    function copyistWithDeepMerge(target, src, dst, key) {
      if (typeof src[key] !== "object" || !src[key]) {
        dst[key] = src[key];
      } else {
        if (!target[key]) {
          dst[key] = src[key];
        } else {
          dst[key] = deepMerge(target[key], src[key]);
        }
      }
    }
    function deepMerge(target, src) {
      var array = Array.isArray(src);
      var dst = array && [] || {};
      if (array) {
        target = target || [];
        dst = dst.concat(target);
        src.forEach(deepMerger.bind(null, target, dst));
      } else {
        if (target && typeof target === "object") {
          Object.keys(target).forEach(copyist.bind(null, target, dst));
        }
        Object.keys(src).forEach(copyistWithDeepMerge.bind(null, target, src, dst));
      }
      return dst;
    }
    module2.exports.deepMerge = deepMerge;
    exports.objectGetPath = function objectGetPath(o, s) {
      var parts = s.split("/").slice(1);
      var k;
      while (typeof (k = parts.shift()) == "string") {
        var n = decodeURIComponent(k.replace(/~0/, "~").replace(/~1/g, "/"));
        if (!(n in o))
          return;
        o = o[n];
      }
      return o;
    };
    function pathEncoder(v) {
      return "/" + encodeURIComponent(v).replace(/~/g, "%7E");
    }
    exports.encodePath = function encodePointer(a) {
      return a.map(pathEncoder).join("");
    };
    exports.getDecimalPlaces = function getDecimalPlaces(number) {
      var decimalPlaces = 0;
      if (isNaN(number))
        return decimalPlaces;
      if (typeof number !== "number") {
        number = Number(number);
      }
      var parts = number.toString().split("e");
      if (parts.length === 2) {
        if (parts[1][0] !== "-") {
          return decimalPlaces;
        } else {
          decimalPlaces = Number(parts[1].slice(1));
        }
      }
      var decimalParts = parts[0].split(".");
      if (decimalParts.length === 2) {
        decimalPlaces += decimalParts[1].length;
      }
      return decimalPlaces;
    };
    exports.isSchema = function isSchema(val) {
      return typeof val === "object" && val || typeof val === "boolean";
    };
  }
});

// node_modules/jsonschema/lib/attribute.js
var require_attribute = __commonJS({
  "node_modules/jsonschema/lib/attribute.js"(exports, module2) {
    "use strict";
    var helpers = require_helpers();
    var ValidatorResult = helpers.ValidatorResult;
    var SchemaError = helpers.SchemaError;
    var attribute = {};
    attribute.ignoreProperties = {
      "id": true,
      "default": true,
      "description": true,
      "title": true,
      "additionalItems": true,
      "then": true,
      "else": true,
      "$schema": true,
      "$ref": true,
      "extends": true
    };
    var validators = attribute.validators = {};
    validators.type = function validateType(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var types = Array.isArray(schema.type) ? schema.type : [schema.type];
      if (!types.some(this.testType.bind(this, instance, schema, options, ctx))) {
        var list = types.map(function(v) {
          if (!v)
            return;
          var id = v.$id || v.id;
          return id ? "<" + id + ">" : v + "";
        });
        result.addError({
          name: "type",
          argument: list,
          message: "is not of a type(s) " + list
        });
      }
      return result;
    };
    function testSchemaNoThrow(instance, options, ctx, callback, schema) {
      var throwError = options.throwError;
      var throwAll = options.throwAll;
      options.throwError = false;
      options.throwAll = false;
      var res = this.validateSchema(instance, schema, options, ctx);
      options.throwError = throwError;
      options.throwAll = throwAll;
      if (!res.valid && callback instanceof Function) {
        callback(res);
      }
      return res.valid;
    }
    validators.anyOf = function validateAnyOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var inner = new ValidatorResult(instance, schema, options, ctx);
      if (!Array.isArray(schema.anyOf)) {
        throw new SchemaError("anyOf must be an array");
      }
      if (!schema.anyOf.some(testSchemaNoThrow.bind(this, instance, options, ctx, function(res) {
        inner.importErrors(res);
      }))) {
        var list = schema.anyOf.map(function(v, i) {
          var id = v.$id || v.id;
          if (id)
            return "<" + id + ">";
          return v.title && JSON.stringify(v.title) || v["$ref"] && "<" + v["$ref"] + ">" || "[subschema " + i + "]";
        });
        if (options.nestedErrors) {
          result.importErrors(inner);
        }
        result.addError({
          name: "anyOf",
          argument: list,
          message: "is not any of " + list.join(",")
        });
      }
      return result;
    };
    validators.allOf = function validateAllOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema.allOf)) {
        throw new SchemaError("allOf must be an array");
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var self2 = this;
      schema.allOf.forEach(function(v, i) {
        var valid = self2.validateSchema(instance, v, options, ctx);
        if (!valid.valid) {
          var id = v.$id || v.id;
          var msg = id || v.title && JSON.stringify(v.title) || v["$ref"] && "<" + v["$ref"] + ">" || "[subschema " + i + "]";
          result.addError({
            name: "allOf",
            argument: { id: msg, length: valid.errors.length, valid },
            message: "does not match allOf schema " + msg + " with " + valid.errors.length + " error[s]:"
          });
          result.importErrors(valid);
        }
      });
      return result;
    };
    validators.oneOf = function validateOneOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema.oneOf)) {
        throw new SchemaError("oneOf must be an array");
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var inner = new ValidatorResult(instance, schema, options, ctx);
      var count = schema.oneOf.filter(testSchemaNoThrow.bind(this, instance, options, ctx, function(res) {
        inner.importErrors(res);
      })).length;
      var list = schema.oneOf.map(function(v, i) {
        var id = v.$id || v.id;
        return id || v.title && JSON.stringify(v.title) || v["$ref"] && "<" + v["$ref"] + ">" || "[subschema " + i + "]";
      });
      if (count !== 1) {
        if (options.nestedErrors) {
          result.importErrors(inner);
        }
        result.addError({
          name: "oneOf",
          argument: list,
          message: "is not exactly one from " + list.join(",")
        });
      }
      return result;
    };
    validators.if = function validateIf(instance, schema, options, ctx) {
      if (instance === void 0)
        return null;
      if (!helpers.isSchema(schema.if))
        throw new Error('Expected "if" keyword to be a schema');
      var ifValid = testSchemaNoThrow.call(this, instance, options, ctx, null, schema.if);
      var result = new ValidatorResult(instance, schema, options, ctx);
      var res;
      if (ifValid) {
        if (schema.then === void 0)
          return;
        if (!helpers.isSchema(schema.then))
          throw new Error('Expected "then" keyword to be a schema');
        res = this.validateSchema(instance, schema.then, options, ctx.makeChild(schema.then));
        result.importErrors(res);
      } else {
        if (schema.else === void 0)
          return;
        if (!helpers.isSchema(schema.else))
          throw new Error('Expected "else" keyword to be a schema');
        res = this.validateSchema(instance, schema.else, options, ctx.makeChild(schema.else));
        result.importErrors(res);
      }
      return result;
    };
    function getEnumerableProperty(object, key) {
      if (Object.hasOwnProperty.call(object, key))
        return object[key];
      if (!(key in object))
        return;
      while (object = Object.getPrototypeOf(object)) {
        if (Object.propertyIsEnumerable.call(object, key))
          return object[key];
      }
    }
    validators.propertyNames = function validatePropertyNames(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var subschema = schema.propertyNames !== void 0 ? schema.propertyNames : {};
      if (!helpers.isSchema(subschema))
        throw new SchemaError('Expected "propertyNames" to be a schema (object or boolean)');
      for (var property in instance) {
        if (getEnumerableProperty(instance, property) !== void 0) {
          var res = this.validateSchema(property, subschema, options, ctx.makeChild(subschema));
          result.importErrors(res);
        }
      }
      return result;
    };
    validators.properties = function validateProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var properties = schema.properties || {};
      for (var property in properties) {
        var subschema = properties[property];
        if (subschema === void 0) {
          continue;
        } else if (subschema === null) {
          throw new SchemaError('Unexpected null, expected schema in "properties"');
        }
        if (typeof options.preValidateProperty == "function") {
          options.preValidateProperty(instance, property, subschema, options, ctx);
        }
        var prop = getEnumerableProperty(instance, property);
        var res = this.validateSchema(prop, subschema, options, ctx.makeChild(subschema, property));
        if (res.instance !== result.instance[property])
          result.instance[property] = res.instance;
        result.importErrors(res);
      }
      return result;
    };
    function testAdditionalProperty(instance, schema, options, ctx, property, result) {
      if (!this.types.object(instance))
        return;
      if (schema.properties && schema.properties[property] !== void 0) {
        return;
      }
      if (schema.additionalProperties === false) {
        result.addError({
          name: "additionalProperties",
          argument: property,
          message: "is not allowed to have the additional property " + JSON.stringify(property)
        });
      } else {
        var additionalProperties = schema.additionalProperties || {};
        if (typeof options.preValidateProperty == "function") {
          options.preValidateProperty(instance, property, additionalProperties, options, ctx);
        }
        var res = this.validateSchema(instance[property], additionalProperties, options, ctx.makeChild(additionalProperties, property));
        if (res.instance !== result.instance[property])
          result.instance[property] = res.instance;
        result.importErrors(res);
      }
    }
    validators.patternProperties = function validatePatternProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var patternProperties = schema.patternProperties || {};
      for (var property in instance) {
        var test = true;
        for (var pattern in patternProperties) {
          var subschema = patternProperties[pattern];
          if (subschema === void 0) {
            continue;
          } else if (subschema === null) {
            throw new SchemaError('Unexpected null, expected schema in "patternProperties"');
          }
          try {
            var regexp = new RegExp(pattern, "u");
          } catch (_e) {
            regexp = new RegExp(pattern);
          }
          if (!regexp.test(property)) {
            continue;
          }
          test = false;
          if (typeof options.preValidateProperty == "function") {
            options.preValidateProperty(instance, property, subschema, options, ctx);
          }
          var res = this.validateSchema(instance[property], subschema, options, ctx.makeChild(subschema, property));
          if (res.instance !== result.instance[property])
            result.instance[property] = res.instance;
          result.importErrors(res);
        }
        if (test) {
          testAdditionalProperty.call(this, instance, schema, options, ctx, property, result);
        }
      }
      return result;
    };
    validators.additionalProperties = function validateAdditionalProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      if (schema.patternProperties) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      for (var property in instance) {
        testAdditionalProperty.call(this, instance, schema, options, ctx, property, result);
      }
      return result;
    };
    validators.minProperties = function validateMinProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var keys = Object.keys(instance);
      if (!(keys.length >= schema.minProperties)) {
        result.addError({
          name: "minProperties",
          argument: schema.minProperties,
          message: "does not meet minimum property length of " + schema.minProperties
        });
      }
      return result;
    };
    validators.maxProperties = function validateMaxProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var keys = Object.keys(instance);
      if (!(keys.length <= schema.maxProperties)) {
        result.addError({
          name: "maxProperties",
          argument: schema.maxProperties,
          message: "does not meet maximum property length of " + schema.maxProperties
        });
      }
      return result;
    };
    validators.items = function validateItems(instance, schema, options, ctx) {
      var self2 = this;
      if (!this.types.array(instance))
        return;
      if (!schema.items)
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      instance.every(function(value, i) {
        var items = Array.isArray(schema.items) ? schema.items[i] || schema.additionalItems : schema.items;
        if (items === void 0) {
          return true;
        }
        if (items === false) {
          result.addError({
            name: "items",
            message: "additionalItems not permitted"
          });
          return false;
        }
        var res = self2.validateSchema(value, items, options, ctx.makeChild(items, i));
        if (res.instance !== result.instance[i])
          result.instance[i] = res.instance;
        result.importErrors(res);
        return true;
      });
      return result;
    };
    validators.minimum = function validateMinimum(instance, schema, options, ctx) {
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (schema.exclusiveMinimum && schema.exclusiveMinimum === true) {
        if (!(instance > schema.minimum)) {
          result.addError({
            name: "minimum",
            argument: schema.minimum,
            message: "must be greater than " + schema.minimum
          });
        }
      } else {
        if (!(instance >= schema.minimum)) {
          result.addError({
            name: "minimum",
            argument: schema.minimum,
            message: "must be greater than or equal to " + schema.minimum
          });
        }
      }
      return result;
    };
    validators.maximum = function validateMaximum(instance, schema, options, ctx) {
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (schema.exclusiveMaximum && schema.exclusiveMaximum === true) {
        if (!(instance < schema.maximum)) {
          result.addError({
            name: "maximum",
            argument: schema.maximum,
            message: "must be less than " + schema.maximum
          });
        }
      } else {
        if (!(instance <= schema.maximum)) {
          result.addError({
            name: "maximum",
            argument: schema.maximum,
            message: "must be less than or equal to " + schema.maximum
          });
        }
      }
      return result;
    };
    validators.exclusiveMinimum = function validateExclusiveMinimum(instance, schema, options, ctx) {
      if (typeof schema.exclusiveMaximum === "boolean")
        return;
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var valid = instance > schema.exclusiveMinimum;
      if (!valid) {
        result.addError({
          name: "exclusiveMinimum",
          argument: schema.exclusiveMinimum,
          message: "must be strictly greater than " + schema.exclusiveMinimum
        });
      }
      return result;
    };
    validators.exclusiveMaximum = function validateExclusiveMaximum(instance, schema, options, ctx) {
      if (typeof schema.exclusiveMaximum === "boolean")
        return;
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var valid = instance < schema.exclusiveMaximum;
      if (!valid) {
        result.addError({
          name: "exclusiveMaximum",
          argument: schema.exclusiveMaximum,
          message: "must be strictly less than " + schema.exclusiveMaximum
        });
      }
      return result;
    };
    var validateMultipleOfOrDivisbleBy = function validateMultipleOfOrDivisbleBy2(instance, schema, options, ctx, validationType, errorMessage) {
      if (!this.types.number(instance))
        return;
      var validationArgument = schema[validationType];
      if (validationArgument == 0) {
        throw new SchemaError(validationType + " cannot be zero");
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var instanceDecimals = helpers.getDecimalPlaces(instance);
      var divisorDecimals = helpers.getDecimalPlaces(validationArgument);
      var maxDecimals = Math.max(instanceDecimals, divisorDecimals);
      var multiplier = Math.pow(10, maxDecimals);
      if (Math.round(instance * multiplier) % Math.round(validationArgument * multiplier) !== 0) {
        result.addError({
          name: validationType,
          argument: validationArgument,
          message: errorMessage + JSON.stringify(validationArgument)
        });
      }
      return result;
    };
    validators.multipleOf = function validateMultipleOf(instance, schema, options, ctx) {
      return validateMultipleOfOrDivisbleBy.call(this, instance, schema, options, ctx, "multipleOf", "is not a multiple of (divisible by) ");
    };
    validators.divisibleBy = function validateDivisibleBy(instance, schema, options, ctx) {
      return validateMultipleOfOrDivisbleBy.call(this, instance, schema, options, ctx, "divisibleBy", "is not divisible by (multiple of) ");
    };
    validators.required = function validateRequired(instance, schema, options, ctx) {
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (instance === void 0 && schema.required === true) {
        result.addError({
          name: "required",
          message: "is required"
        });
      } else if (this.types.object(instance) && Array.isArray(schema.required)) {
        schema.required.forEach(function(n) {
          if (getEnumerableProperty(instance, n) === void 0) {
            result.addError({
              name: "required",
              argument: n,
              message: "requires property " + JSON.stringify(n)
            });
          }
        });
      }
      return result;
    };
    validators.pattern = function validatePattern(instance, schema, options, ctx) {
      if (!this.types.string(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var pattern = schema.pattern;
      try {
        var regexp = new RegExp(pattern, "u");
      } catch (_e) {
        regexp = new RegExp(pattern);
      }
      if (!instance.match(regexp)) {
        result.addError({
          name: "pattern",
          argument: schema.pattern,
          message: "does not match pattern " + JSON.stringify(schema.pattern.toString())
        });
      }
      return result;
    };
    validators.format = function validateFormat(instance, schema, options, ctx) {
      if (instance === void 0)
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!result.disableFormat && !helpers.isFormat(instance, schema.format, this)) {
        result.addError({
          name: "format",
          argument: schema.format,
          message: "does not conform to the " + JSON.stringify(schema.format) + " format"
        });
      }
      return result;
    };
    validators.minLength = function validateMinLength(instance, schema, options, ctx) {
      if (!this.types.string(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var hsp = instance.match(/[\uDC00-\uDFFF]/g);
      var length = instance.length - (hsp ? hsp.length : 0);
      if (!(length >= schema.minLength)) {
        result.addError({
          name: "minLength",
          argument: schema.minLength,
          message: "does not meet minimum length of " + schema.minLength
        });
      }
      return result;
    };
    validators.maxLength = function validateMaxLength(instance, schema, options, ctx) {
      if (!this.types.string(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var hsp = instance.match(/[\uDC00-\uDFFF]/g);
      var length = instance.length - (hsp ? hsp.length : 0);
      if (!(length <= schema.maxLength)) {
        result.addError({
          name: "maxLength",
          argument: schema.maxLength,
          message: "does not meet maximum length of " + schema.maxLength
        });
      }
      return result;
    };
    validators.minItems = function validateMinItems(instance, schema, options, ctx) {
      if (!this.types.array(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!(instance.length >= schema.minItems)) {
        result.addError({
          name: "minItems",
          argument: schema.minItems,
          message: "does not meet minimum length of " + schema.minItems
        });
      }
      return result;
    };
    validators.maxItems = function validateMaxItems(instance, schema, options, ctx) {
      if (!this.types.array(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!(instance.length <= schema.maxItems)) {
        result.addError({
          name: "maxItems",
          argument: schema.maxItems,
          message: "does not meet maximum length of " + schema.maxItems
        });
      }
      return result;
    };
    function testArrays(v, i, a) {
      var j, len = a.length;
      for (j = i + 1, len; j < len; j++) {
        if (helpers.deepCompareStrict(v, a[j])) {
          return false;
        }
      }
      return true;
    }
    validators.uniqueItems = function validateUniqueItems(instance, schema, options, ctx) {
      if (schema.uniqueItems !== true)
        return;
      if (!this.types.array(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!instance.every(testArrays)) {
        result.addError({
          name: "uniqueItems",
          message: "contains duplicate item"
        });
      }
      return result;
    };
    validators.dependencies = function validateDependencies(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      for (var property in schema.dependencies) {
        if (instance[property] === void 0) {
          continue;
        }
        var dep = schema.dependencies[property];
        var childContext = ctx.makeChild(dep, property);
        if (typeof dep == "string") {
          dep = [dep];
        }
        if (Array.isArray(dep)) {
          dep.forEach(function(prop) {
            if (instance[prop] === void 0) {
              result.addError({
                name: "dependencies",
                argument: childContext.propertyPath,
                message: "property " + prop + " not found, required by " + childContext.propertyPath
              });
            }
          });
        } else {
          var res = this.validateSchema(instance, dep, options, childContext);
          if (result.instance !== res.instance)
            result.instance = res.instance;
          if (res && res.errors.length) {
            result.addError({
              name: "dependencies",
              argument: childContext.propertyPath,
              message: "does not meet dependency required by " + childContext.propertyPath
            });
            result.importErrors(res);
          }
        }
      }
      return result;
    };
    validators["enum"] = function validateEnum(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema["enum"])) {
        throw new SchemaError("enum expects an array", schema);
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!schema["enum"].some(helpers.deepCompareStrict.bind(null, instance))) {
        result.addError({
          name: "enum",
          argument: schema["enum"],
          message: "is not one of enum values: " + schema["enum"].map(String).join(",")
        });
      }
      return result;
    };
    validators["const"] = function validateEnum(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!helpers.deepCompareStrict(schema["const"], instance)) {
        result.addError({
          name: "const",
          argument: schema["const"],
          message: "does not exactly match expected constant: " + schema["const"]
        });
      }
      return result;
    };
    validators.not = validators.disallow = function validateNot(instance, schema, options, ctx) {
      var self2 = this;
      if (instance === void 0)
        return null;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var notTypes = schema.not || schema.disallow;
      if (!notTypes)
        return null;
      if (!Array.isArray(notTypes))
        notTypes = [notTypes];
      notTypes.forEach(function(type) {
        if (self2.testType(instance, schema, options, ctx, type)) {
          var id = type && (type.$id || type.id);
          var schemaId = id || type;
          result.addError({
            name: "not",
            argument: schemaId,
            message: "is of prohibited type " + schemaId
          });
        }
      });
      return result;
    };
    module2.exports = attribute;
  }
});

// node_modules/jsonschema/lib/scan.js
var require_scan = __commonJS({
  "node_modules/jsonschema/lib/scan.js"(exports, module2) {
    "use strict";
    var urilib = require("url");
    var helpers = require_helpers();
    module2.exports.SchemaScanResult = SchemaScanResult;
    function SchemaScanResult(found, ref) {
      this.id = found;
      this.ref = ref;
    }
    module2.exports.scan = function scan(base, schema) {
      function scanSchema(baseuri, schema2) {
        if (!schema2 || typeof schema2 != "object")
          return;
        if (schema2.$ref) {
          var resolvedUri = urilib.resolve(baseuri, schema2.$ref);
          ref[resolvedUri] = ref[resolvedUri] ? ref[resolvedUri] + 1 : 0;
          return;
        }
        var id = schema2.$id || schema2.id;
        var ourBase = id ? urilib.resolve(baseuri, id) : baseuri;
        if (ourBase) {
          if (ourBase.indexOf("#") < 0)
            ourBase += "#";
          if (found[ourBase]) {
            if (!helpers.deepCompareStrict(found[ourBase], schema2)) {
              throw new Error("Schema <" + ourBase + "> already exists with different definition");
            }
            return found[ourBase];
          }
          found[ourBase] = schema2;
          if (ourBase[ourBase.length - 1] == "#") {
            found[ourBase.substring(0, ourBase.length - 1)] = schema2;
          }
        }
        scanArray(ourBase + "/items", Array.isArray(schema2.items) ? schema2.items : [schema2.items]);
        scanArray(ourBase + "/extends", Array.isArray(schema2.extends) ? schema2.extends : [schema2.extends]);
        scanSchema(ourBase + "/additionalItems", schema2.additionalItems);
        scanObject(ourBase + "/properties", schema2.properties);
        scanSchema(ourBase + "/additionalProperties", schema2.additionalProperties);
        scanObject(ourBase + "/definitions", schema2.definitions);
        scanObject(ourBase + "/patternProperties", schema2.patternProperties);
        scanObject(ourBase + "/dependencies", schema2.dependencies);
        scanArray(ourBase + "/disallow", schema2.disallow);
        scanArray(ourBase + "/allOf", schema2.allOf);
        scanArray(ourBase + "/anyOf", schema2.anyOf);
        scanArray(ourBase + "/oneOf", schema2.oneOf);
        scanSchema(ourBase + "/not", schema2.not);
      }
      function scanArray(baseuri, schemas) {
        if (!Array.isArray(schemas))
          return;
        for (var i = 0; i < schemas.length; i++) {
          scanSchema(baseuri + "/" + i, schemas[i]);
        }
      }
      function scanObject(baseuri, schemas) {
        if (!schemas || typeof schemas != "object")
          return;
        for (var p in schemas) {
          scanSchema(baseuri + "/" + p, schemas[p]);
        }
      }
      var found = {};
      var ref = {};
      scanSchema(base, schema);
      return new SchemaScanResult(found, ref);
    };
  }
});

// node_modules/jsonschema/lib/validator.js
var require_validator = __commonJS({
  "node_modules/jsonschema/lib/validator.js"(exports, module2) {
    "use strict";
    var urilib = require("url");
    var attribute = require_attribute();
    var helpers = require_helpers();
    var scanSchema = require_scan().scan;
    var ValidatorResult = helpers.ValidatorResult;
    var ValidatorResultError = helpers.ValidatorResultError;
    var SchemaError = helpers.SchemaError;
    var SchemaContext = helpers.SchemaContext;
    var anonymousBase = "/";
    var Validator = function Validator2() {
      this.customFormats = Object.create(Validator2.prototype.customFormats);
      this.schemas = {};
      this.unresolvedRefs = [];
      this.types = Object.create(types);
      this.attributes = Object.create(attribute.validators);
    };
    Validator.prototype.customFormats = {};
    Validator.prototype.schemas = null;
    Validator.prototype.types = null;
    Validator.prototype.attributes = null;
    Validator.prototype.unresolvedRefs = null;
    Validator.prototype.addSchema = function addSchema(schema, base) {
      var self2 = this;
      if (!schema) {
        return null;
      }
      var scan = scanSchema(base || anonymousBase, schema);
      var ourUri = base || schema.$id || schema.id;
      for (var uri in scan.id) {
        this.schemas[uri] = scan.id[uri];
      }
      for (var uri in scan.ref) {
        this.unresolvedRefs.push(uri);
      }
      this.unresolvedRefs = this.unresolvedRefs.filter(function(uri2) {
        return typeof self2.schemas[uri2] === "undefined";
      });
      return this.schemas[ourUri];
    };
    Validator.prototype.addSubSchemaArray = function addSubSchemaArray(baseuri, schemas) {
      if (!Array.isArray(schemas))
        return;
      for (var i = 0; i < schemas.length; i++) {
        this.addSubSchema(baseuri, schemas[i]);
      }
    };
    Validator.prototype.addSubSchemaObject = function addSubSchemaArray(baseuri, schemas) {
      if (!schemas || typeof schemas != "object")
        return;
      for (var p in schemas) {
        this.addSubSchema(baseuri, schemas[p]);
      }
    };
    Validator.prototype.setSchemas = function setSchemas(schemas) {
      this.schemas = schemas;
    };
    Validator.prototype.getSchema = function getSchema(urn) {
      return this.schemas[urn];
    };
    Validator.prototype.validate = function validate(instance, schema, options, ctx) {
      if (typeof schema !== "boolean" && typeof schema !== "object" || schema === null) {
        throw new SchemaError("Expected `schema` to be an object or boolean");
      }
      if (!options) {
        options = {};
      }
      var id = schema.$id || schema.id;
      var base = urilib.resolve(options.base || anonymousBase, id || "");
      if (!ctx) {
        ctx = new SchemaContext(schema, options, [], base, Object.create(this.schemas));
        if (!ctx.schemas[base]) {
          ctx.schemas[base] = schema;
        }
        var found = scanSchema(base, schema);
        for (var n in found.id) {
          var sch = found.id[n];
          ctx.schemas[n] = sch;
        }
      }
      if (options.required && instance === void 0) {
        var result = new ValidatorResult(instance, schema, options, ctx);
        result.addError("is required, but is undefined");
        return result;
      }
      var result = this.validateSchema(instance, schema, options, ctx);
      if (!result) {
        throw new Error("Result undefined");
      } else if (options.throwAll && result.errors.length) {
        throw new ValidatorResultError(result);
      }
      return result;
    };
    function shouldResolve(schema) {
      var ref = typeof schema === "string" ? schema : schema.$ref;
      if (typeof ref == "string")
        return ref;
      return false;
    }
    Validator.prototype.validateSchema = function validateSchema(instance, schema, options, ctx) {
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (typeof schema === "boolean") {
        if (schema === true) {
          schema = {};
        } else if (schema === false) {
          schema = { type: [] };
        }
      } else if (!schema) {
        throw new Error("schema is undefined");
      }
      if (schema["extends"]) {
        if (Array.isArray(schema["extends"])) {
          var schemaobj = { schema, ctx };
          schema["extends"].forEach(this.schemaTraverser.bind(this, schemaobj));
          schema = schemaobj.schema;
          schemaobj.schema = null;
          schemaobj.ctx = null;
          schemaobj = null;
        } else {
          schema = helpers.deepMerge(schema, this.superResolve(schema["extends"], ctx));
        }
      }
      var switchSchema = shouldResolve(schema);
      if (switchSchema) {
        var resolved = this.resolve(schema, switchSchema, ctx);
        var subctx = new SchemaContext(resolved.subschema, options, ctx.path, resolved.switchSchema, ctx.schemas);
        return this.validateSchema(instance, resolved.subschema, options, subctx);
      }
      var skipAttributes = options && options.skipAttributes || [];
      for (var key in schema) {
        if (!attribute.ignoreProperties[key] && skipAttributes.indexOf(key) < 0) {
          var validatorErr = null;
          var validator = this.attributes[key];
          if (validator) {
            validatorErr = validator.call(this, instance, schema, options, ctx);
          } else if (options.allowUnknownAttributes === false) {
            throw new SchemaError("Unsupported attribute: " + key, schema);
          }
          if (validatorErr) {
            result.importErrors(validatorErr);
          }
        }
      }
      if (typeof options.rewrite == "function") {
        var value = options.rewrite.call(this, instance, schema, options, ctx);
        result.instance = value;
      }
      return result;
    };
    Validator.prototype.schemaTraverser = function schemaTraverser(schemaobj, s) {
      schemaobj.schema = helpers.deepMerge(schemaobj.schema, this.superResolve(s, schemaobj.ctx));
    };
    Validator.prototype.superResolve = function superResolve(schema, ctx) {
      var ref = shouldResolve(schema);
      if (ref) {
        return this.resolve(schema, ref, ctx).subschema;
      }
      return schema;
    };
    Validator.prototype.resolve = function resolve(schema, switchSchema, ctx) {
      switchSchema = ctx.resolve(switchSchema);
      if (ctx.schemas[switchSchema]) {
        return { subschema: ctx.schemas[switchSchema], switchSchema };
      }
      var parsed = urilib.parse(switchSchema);
      var fragment = parsed && parsed.hash;
      var document = fragment && fragment.length && switchSchema.substr(0, switchSchema.length - fragment.length);
      if (!document || !ctx.schemas[document]) {
        throw new SchemaError("no such schema <" + switchSchema + ">", schema);
      }
      var subschema = helpers.objectGetPath(ctx.schemas[document], fragment.substr(1));
      if (subschema === void 0) {
        throw new SchemaError("no such schema " + fragment + " located in <" + document + ">", schema);
      }
      return { subschema, switchSchema };
    };
    Validator.prototype.testType = function validateType(instance, schema, options, ctx, type) {
      if (type === void 0) {
        return;
      } else if (type === null) {
        throw new SchemaError('Unexpected null in "type" keyword');
      }
      if (typeof this.types[type] == "function") {
        return this.types[type].call(this, instance);
      }
      if (type && typeof type == "object") {
        var res = this.validateSchema(instance, type, options, ctx);
        return res === void 0 || !(res && res.errors.length);
      }
      return true;
    };
    var types = Validator.prototype.types = {};
    types.string = function testString(instance) {
      return typeof instance == "string";
    };
    types.number = function testNumber(instance) {
      return typeof instance == "number" && isFinite(instance);
    };
    types.integer = function testInteger(instance) {
      return typeof instance == "number" && instance % 1 === 0;
    };
    types.boolean = function testBoolean(instance) {
      return typeof instance == "boolean";
    };
    types.array = function testArray(instance) {
      return Array.isArray(instance);
    };
    types["null"] = function testNull(instance) {
      return instance === null;
    };
    types.date = function testDate(instance) {
      return instance instanceof Date;
    };
    types.any = function testAny(instance) {
      return true;
    };
    types.object = function testObject(instance) {
      return instance && typeof instance === "object" && !Array.isArray(instance) && !(instance instanceof Date);
    };
    module2.exports = Validator;
  }
});

// node_modules/jsonschema/lib/index.js
var require_lib4 = __commonJS({
  "node_modules/jsonschema/lib/index.js"(exports, module2) {
    "use strict";
    var Validator = module2.exports.Validator = require_validator();
    module2.exports.ValidatorResult = require_helpers().ValidatorResult;
    module2.exports.ValidatorResultError = require_helpers().ValidatorResultError;
    module2.exports.ValidationError = require_helpers().ValidationError;
    module2.exports.SchemaError = require_helpers().SchemaError;
    module2.exports.SchemaScanResult = require_scan().SchemaScanResult;
    module2.exports.scan = require_scan().scan;
    module2.exports.validate = function(instance, schema, options) {
      var v = new Validator();
      return v.validate(instance, schema, options);
    };
  }
});

// node_modules/@jsii/spec/schema/jsii-spec.schema.json
var require_jsii_spec_schema = __commonJS({
  "node_modules/@jsii/spec/schema/jsii-spec.schema.json"(exports, module2) {
    module2.exports = {
      $ref: "#/definitions/Assembly",
      $schema: "http://json-schema.org/draft-07/schema#",
      definitions: {
        Assembly: {
          description: "A JSII assembly specification.",
          properties: {
            author: {
              $ref: "#/definitions/Person",
              description: "The main author of this package."
            },
            bin: {
              additionalProperties: {
                type: "string"
              },
              default: "none",
              description: "List of bin-scripts",
              type: "object"
            },
            bundled: {
              additionalProperties: {
                type: "string"
              },
              default: "none",
              description: "List if bundled dependencies (these are not expected to be jsii\nassemblies).",
              type: "object"
            },
            contributors: {
              default: "none",
              description: "Additional contributors to this package.",
              items: {
                $ref: "#/definitions/Person"
              },
              type: "array"
            },
            dependencies: {
              additionalProperties: {
                type: "string"
              },
              default: "none",
              description: "Direct dependencies on other assemblies (with semver), the key is the JSII\nassembly name, and the value is a SemVer expression.",
              type: "object"
            },
            dependencyClosure: {
              additionalProperties: {
                $ref: "#/definitions/AssemblyConfiguration"
              },
              default: "none",
              description: "Target configuration for all the assemblies that are direct or transitive\ndependencies of this assembly. This is needed to generate correct native\ntype names for any transitively inherited member, in certain languages.",
              type: "object"
            },
            description: {
              description: 'Description of the assembly, maps to "description" from package.json\nThis is required since some package managers (like Maven) require it.',
              type: "string"
            },
            docs: {
              $ref: "#/definitions/Docs",
              default: "none",
              description: "Documentation for this entity."
            },
            fingerprint: {
              description: "A fingerprint that can be used to determine if the specification has\nchanged.",
              minLength: 1,
              type: "string"
            },
            homepage: {
              description: 'The url to the project homepage. Maps to "homepage" from package.json.',
              type: "string"
            },
            jsiiVersion: {
              description: "The version of the jsii compiler that was used to produce this Assembly.",
              minLength: 1,
              type: "string"
            },
            keywords: {
              description: "Keywords that help discover or identify this packages with respects to it's\nintended usage, audience, etc... Where possible, this will be rendered in\nthe corresponding metadata section of idiomatic package manifests, for\nexample NuGet package tags.",
              items: {
                type: "string"
              },
              type: "array"
            },
            license: {
              description: "The SPDX name of the license this assembly is distributed on.",
              type: "string"
            },
            metadata: {
              additionalProperties: {},
              default: "none",
              description: "Arbitrary key-value pairs of metadata, which the maintainer chose to\ndocument with the assembly. These entries do not carry normative\nsemantics and their interpretation is up to the assembly maintainer.",
              type: "object"
            },
            name: {
              description: "The name of the assembly",
              minLength: 1,
              type: "string"
            },
            readme: {
              $ref: "#/definitions/ReadMe",
              default: "none",
              description: "The readme document for this module (if any)."
            },
            repository: {
              description: 'The module repository, maps to "repository" from package.json\nThis is required since some package managers (like Maven) require it.',
              properties: {
                directory: {
                  default: "the root of the repository",
                  description: "If the package is not in the root directory (for example, when part\nof a monorepo), you should specify the directory in which it lives.",
                  type: "string"
                },
                type: {
                  description: "The type of the repository (``git``, ``svn``, ...)",
                  type: "string"
                },
                url: {
                  description: "The URL of the repository.",
                  type: "string"
                }
              },
              required: [
                "type",
                "url"
              ],
              type: "object"
            },
            schema: {
              description: "The version of the spec schema",
              enum: [
                "jsii/0.10.0"
              ],
              type: "string"
            },
            submodules: {
              additionalProperties: {
                allOf: [
                  {
                    $ref: "#/definitions/SourceLocatable"
                  },
                  {
                    $ref: "#/definitions/Targetable"
                  }
                ],
                description: "A submodule\n\nThe difference between a top-level module (the assembly) and a submodule is\nthat the submodule is annotated with its location in the repository."
              },
              default: "none",
              description: "Submodules declared in this assembly.",
              type: "object"
            },
            targets: {
              $ref: "#/definitions/AssemblyTargets",
              default: "none",
              description: "A map of target name to configuration, which is used when generating\npackages for various languages."
            },
            types: {
              additionalProperties: {
                anyOf: [
                  {
                    allOf: [
                      {
                        $ref: "#/definitions/TypeBase"
                      },
                      {
                        $ref: "#/definitions/ClassType"
                      }
                    ]
                  },
                  {
                    allOf: [
                      {
                        $ref: "#/definitions/TypeBase"
                      },
                      {
                        $ref: "#/definitions/EnumType"
                      }
                    ]
                  },
                  {
                    allOf: [
                      {
                        $ref: "#/definitions/TypeBase"
                      },
                      {
                        $ref: "#/definitions/InterfaceType"
                      }
                    ]
                  }
                ],
                description: "Represents a type definition (not a type reference)."
              },
              default: "none",
              description: "All types in the assembly, keyed by their fully-qualified-name",
              type: "object"
            },
            version: {
              description: "The version of the assembly",
              minLength: 1,
              type: "string"
            }
          },
          required: [
            "author",
            "description",
            "fingerprint",
            "homepage",
            "jsiiVersion",
            "license",
            "name",
            "repository",
            "schema",
            "version"
          ],
          type: "object"
        },
        AssemblyConfiguration: {
          description: "Shareable configuration of a jsii Assembly.",
          properties: {
            readme: {
              $ref: "#/definitions/ReadMe",
              default: "none",
              description: "The readme document for this module (if any)."
            },
            submodules: {
              additionalProperties: {
                allOf: [
                  {
                    $ref: "#/definitions/SourceLocatable"
                  },
                  {
                    $ref: "#/definitions/Targetable"
                  }
                ],
                description: "A submodule\n\nThe difference between a top-level module (the assembly) and a submodule is\nthat the submodule is annotated with its location in the repository."
              },
              default: "none",
              description: "Submodules declared in this assembly.",
              type: "object"
            },
            targets: {
              $ref: "#/definitions/AssemblyTargets",
              default: "none",
              description: "A map of target name to configuration, which is used when generating\npackages for various languages."
            }
          },
          type: "object"
        },
        AssemblyTargets: {
          additionalProperties: {
            additionalProperties: {},
            type: "object"
          },
          description: "Configurable targets for an asembly.",
          type: "object"
        },
        Callable: {
          description: "An Initializer or a Method.",
          properties: {
            docs: {
              $ref: "#/definitions/Docs",
              default: "none",
              description: "Documentation for this entity."
            },
            locationInModule: {
              $ref: "#/definitions/SourceLocation",
              default: "none",
              description: "Where in the module this definition was found\n\nWhy is this not `locationInAssembly`? Because the assembly is the JSII\nfile combining compiled code and its manifest, whereas this is referring\nto the location of the source in the module the assembly was built from."
            },
            overrides: {
              default: "this member is not overriding anything",
              description: "The FQN of the parent type (class or interface) that this entity\noverrides or implements. If undefined, then this entity is the first in\nit's hierarchy to declare this entity.",
              type: "string"
            },
            parameters: {
              default: "none",
              description: "The parameters of the Initializer or Method.",
              items: {
                $ref: "#/definitions/Parameter"
              },
              type: "array"
            },
            protected: {
              default: false,
              description: "Indicates if this Initializer or Method is protected (otherwise it is\npublic, since private members are not modeled).",
              type: "boolean"
            },
            variadic: {
              default: false,
              description: "Indicates whether this Initializer or Method is variadic or not. When\n``true``, the last element of ``#parameters`` will also be flagged\n``#variadic``.",
              type: "boolean"
            }
          },
          type: "object"
        },
        ClassType: {
          description: "Represents classes.",
          properties: {
            abstract: {
              default: false,
              description: "Indicates if this class is an abstract class.",
              type: "boolean"
            },
            assembly: {
              description: "The name of the assembly the type belongs to.",
              minLength: 1,
              type: "string"
            },
            base: {
              default: "no base class",
              description: "The FQN of the base class of this class, if it has one.",
              type: "string"
            },
            docs: {
              $ref: "#/definitions/Docs",
              default: "none",
              description: "Documentation for this entity."
            },
            fqn: {
              description: "The fully qualified name of the type (``<assembly>.<namespace>.<name>``)",
              minLength: 3,
              type: "string"
            },
            initializer: {
              $ref: "#/definitions/Callable",
              default: "no initializer",
              description: "Initializer (constructor) method."
            },
            interfaces: {
              default: "none",
              description: "The FQNs of the interfaces this class implements, if any.",
              items: {
                type: "string"
              },
              type: "array",
              uniqueItems: true
            },
            kind: {
              description: "The kind of the type.",
              enum: [
                "class"
              ],
              type: "string"
            },
            locationInModule: {
              $ref: "#/definitions/SourceLocation",
              default: "none",
              description: "Where in the module this definition was found\n\nWhy is this not `locationInAssembly`? Because the assembly is the JSII\nfile combining compiled code and its manifest, whereas this is referring\nto the location of the source in the module the assembly was built from."
            },
            methods: {
              default: "none",
              description: "List of methods.",
              items: {
                $ref: "#/definitions/Method"
              },
              type: "array"
            },
            name: {
              description: "The simple name of the type (MyClass).",
              minLength: 1,
              type: "string"
            },
            namespace: {
              default: "none",
              description: "The namespace of the type (`foo.bar.baz`).\n\nWhen undefined, the type is located at the root of the assembly (its\n`fqn` would be like `<assembly>.<name>`).\n\nFor types inside other types or inside submodules, the `<namespace>` corresponds to\nthe namespace-qualified name of the container (can contain multiple segments like:\n`<ns1>.<ns2>.<ns3>`).\n\nIn all cases:\n\n <fqn> = <assembly>[.<namespace>].<name>",
              type: "string"
            },
            properties: {
              default: "none",
              description: "List of properties.",
              items: {
                $ref: "#/definitions/Property"
              },
              type: "array"
            }
          },
          required: [
            "assembly",
            "fqn",
            "kind",
            "name"
          ],
          type: "object"
        },
        CollectionKind: {
          description: "Kinds of collections.",
          enum: [
            "array",
            "map"
          ],
          type: "string"
        },
        CollectionTypeReference: {
          description: "Reference to a collection type.",
          properties: {
            collection: {
              properties: {
                elementtype: {
                  $ref: "#/definitions/TypeReference",
                  description: "The type of an element (map keys are always strings)."
                },
                kind: {
                  $ref: "#/definitions/CollectionKind",
                  description: "The kind of collection."
                }
              },
              required: [
                "elementtype",
                "kind"
              ],
              type: "object"
            }
          },
          required: [
            "collection"
          ],
          type: "object"
        },
        Docs: {
          description: "Key value pairs of documentation nodes.\nBased on TSDoc.",
          properties: {
            custom: {
              additionalProperties: {
                type: "string"
              },
              default: "none",
              description: "Custom tags that are not any of the default ones",
              type: "object"
            },
            default: {
              default: "none",
              description: "Description of the default",
              type: "string"
            },
            deprecated: {
              default: "none",
              description: "If present, this block indicates that an API item is no longer supported\nand may be removed in a future release.  The `@deprecated` tag must be\nfollowed by a sentence describing the recommended alternative.\nDeprecation recursively applies to members of a container. For example,\nif a class is deprecated, then so are all of its members.",
              type: "string"
            },
            example: {
              default: "none",
              description: "Example showing the usage of this API item\n\nStarts off in running text mode, may switch to code using fenced code\nblocks.",
              type: "string"
            },
            remarks: {
              default: "none",
              description: "Detailed information about an API item.\n\nEither the explicitly tagged `@remarks` section, otherwise everything\npast the first paragraph if there is no `@remarks` tag.",
              type: "string"
            },
            returns: {
              default: "none",
              description: "The `@returns` block for this doc comment, or undefined if there is not\none.",
              type: "string"
            },
            see: {
              default: "none",
              description: "A `@see` link with more information",
              type: "string"
            },
            stability: {
              description: "Whether the API item is beta/experimental quality",
              enum: [
                "deprecated",
                "experimental",
                "external",
                "stable"
              ],
              type: "string"
            },
            subclassable: {
              default: false,
              description: "Whether this class or interface was intended to be subclassed/implemented\nby library users.\n\nClasses intended for subclassing, and interfaces intended to be\nimplemented by consumers, are held to stricter standards of API\ncompatibility.",
              type: "boolean"
            },
            summary: {
              default: "none",
              description: "Summary documentation for an API item.\n\nThe first part of the documentation before hitting a `@remarks` tags, or\nthe first line of the doc comment block if there is no `@remarks` tag.",
              type: "string"
            }
          },
          type: "object"
        },
        EnumMember: {
          description: "Represents a member of an enum.",
          properties: {
            docs: {
              $ref: "#/definitions/Docs",
              default: "none",
              description: "Documentation for this entity."
            },
            name: {
              description: "The name/symbol of the member.",
              type: "string"
            }
          },
          required: [
            "name"
          ],
          type: "object"
        },
        EnumType: {
          description: "Represents an enum type.",
          properties: {
            assembly: {
              description: "The name of the assembly the type belongs to.",
              minLength: 1,
              type: "string"
            },
            docs: {
              $ref: "#/definitions/Docs",
              default: "none",
              description: "Documentation for this entity."
            },
            fqn: {
              description: "The fully qualified name of the type (``<assembly>.<namespace>.<name>``)",
              minLength: 3,
              type: "string"
            },
            kind: {
              description: "The kind of the type.",
              enum: [
                "enum"
              ],
              type: "string"
            },
            locationInModule: {
              $ref: "#/definitions/SourceLocation",
              default: "none",
              description: "Where in the module this definition was found\n\nWhy is this not `locationInAssembly`? Because the assembly is the JSII\nfile combining compiled code and its manifest, whereas this is referring\nto the location of the source in the module the assembly was built from."
            },
            members: {
              description: "Members of the enum.",
              items: {
                $ref: "#/definitions/EnumMember"
              },
              type: "array"
            },
            name: {
              description: "The simple name of the type (MyClass).",
              minLength: 1,
              type: "string"
            },
            namespace: {
              default: "none",
              description: "The namespace of the type (`foo.bar.baz`).\n\nWhen undefined, the type is located at the root of the assembly (its\n`fqn` would be like `<assembly>.<name>`).\n\nFor types inside other types or inside submodules, the `<namespace>` corresponds to\nthe namespace-qualified name of the container (can contain multiple segments like:\n`<ns1>.<ns2>.<ns3>`).\n\nIn all cases:\n\n <fqn> = <assembly>[.<namespace>].<name>",
              type: "string"
            }
          },
          required: [
            "assembly",
            "fqn",
            "kind",
            "members",
            "name"
          ],
          type: "object"
        },
        InterfaceType: {
          properties: {
            assembly: {
              description: "The name of the assembly the type belongs to.",
              minLength: 1,
              type: "string"
            },
            datatype: {
              default: false,
              description: "True if this interface only contains properties. Different backends might\nhave idiomatic ways to allow defining concrete instances such interfaces.\nFor example, in Java, the generator will produce a PoJo and a builder\nwhich will allow users to create a concrete object with data which\nadheres to this interface.",
              type: "boolean"
            },
            docs: {
              $ref: "#/definitions/Docs",
              default: "none",
              description: "Documentation for this entity."
            },
            fqn: {
              description: "The fully qualified name of the type (``<assembly>.<namespace>.<name>``)",
              minLength: 3,
              type: "string"
            },
            interfaces: {
              default: "none",
              description: "The FQNs of the interfaces this interface extends, if any.",
              items: {
                type: "string"
              },
              type: "array",
              uniqueItems: true
            },
            kind: {
              description: "The kind of the type.",
              enum: [
                "interface"
              ],
              type: "string"
            },
            locationInModule: {
              $ref: "#/definitions/SourceLocation",
              default: "none",
              description: "Where in the module this definition was found\n\nWhy is this not `locationInAssembly`? Because the assembly is the JSII\nfile combining compiled code and its manifest, whereas this is referring\nto the location of the source in the module the assembly was built from."
            },
            methods: {
              default: "none",
              description: "List of methods.",
              items: {
                $ref: "#/definitions/Method"
              },
              type: "array"
            },
            name: {
              description: "The simple name of the type (MyClass).",
              minLength: 1,
              type: "string"
            },
            namespace: {
              default: "none",
              description: "The namespace of the type (`foo.bar.baz`).\n\nWhen undefined, the type is located at the root of the assembly (its\n`fqn` would be like `<assembly>.<name>`).\n\nFor types inside other types or inside submodules, the `<namespace>` corresponds to\nthe namespace-qualified name of the container (can contain multiple segments like:\n`<ns1>.<ns2>.<ns3>`).\n\nIn all cases:\n\n <fqn> = <assembly>[.<namespace>].<name>",
              type: "string"
            },
            properties: {
              default: "none",
              description: "List of properties.",
              items: {
                $ref: "#/definitions/Property"
              },
              type: "array"
            }
          },
          required: [
            "assembly",
            "fqn",
            "kind",
            "name"
          ],
          type: "object"
        },
        Method: {
          description: "A method with a name (i.e: not an initializer).",
          properties: {
            abstract: {
              default: false,
              description: "Is this method an abstract method (this means the class will also be an abstract class)",
              type: "boolean"
            },
            async: {
              default: false,
              description: "Indicates if this is an asynchronous method (it will return a promise).",
              type: "boolean"
            },
            docs: {
              $ref: "#/definitions/Docs",
              default: "none",
              description: "Documentation for this entity."
            },
            locationInModule: {
              $ref: "#/definitions/SourceLocation",
              default: "none",
              description: "Where in the module this definition was found\n\nWhy is this not `locationInAssembly`? Because the assembly is the JSII\nfile combining compiled code and its manifest, whereas this is referring\nto the location of the source in the module the assembly was built from."
            },
            name: {
              description: "The name of the method. Undefined if this method is a initializer.",
              type: "string"
            },
            overrides: {
              default: "this member is not overriding anything",
              description: "The FQN of the parent type (class or interface) that this entity\noverrides or implements. If undefined, then this entity is the first in\nit's hierarchy to declare this entity.",
              type: "string"
            },
            parameters: {
              default: "none",
              description: "The parameters of the Initializer or Method.",
              items: {
                $ref: "#/definitions/Parameter"
              },
              type: "array"
            },
            protected: {
              default: false,
              description: "Indicates if this Initializer or Method is protected (otherwise it is\npublic, since private members are not modeled).",
              type: "boolean"
            },
            returns: {
              $ref: "#/definitions/OptionalValue",
              default: "void",
              description: "The return type of the method (`undefined` if `void`)"
            },
            static: {
              default: false,
              description: "Indicates if this is a static method.",
              type: "boolean"
            },
            variadic: {
              default: false,
              description: "Indicates whether this Initializer or Method is variadic or not. When\n``true``, the last element of ``#parameters`` will also be flagged\n``#variadic``.",
              type: "boolean"
            }
          },
          required: [
            "name"
          ],
          type: "object"
        },
        NamedTypeReference: {
          description: "Reference to a named type, defined by this assembly or one of its\ndependencies.",
          properties: {
            fqn: {
              description: "The fully-qualified-name of the type (can be located in the\n``spec.types[fqn]``` of the assembly that defines the type).",
              type: "string"
            }
          },
          required: [
            "fqn"
          ],
          type: "object"
        },
        OptionalValue: {
          description: "A value that can possibly be optional.",
          properties: {
            optional: {
              default: false,
              description: "Determines whether the value is, indeed, optional.",
              type: "boolean"
            },
            type: {
              $ref: "#/definitions/TypeReference",
              description: "The declared type of the value, when it's present."
            }
          },
          required: [
            "type"
          ],
          type: "object"
        },
        Parameter: {
          description: "Represents a method parameter.",
          properties: {
            docs: {
              $ref: "#/definitions/Docs",
              default: "none",
              description: "Documentation for this entity."
            },
            name: {
              description: "The name of the parameter.",
              minLength: 1,
              type: "string"
            },
            optional: {
              default: false,
              description: "Determines whether the value is, indeed, optional.",
              type: "boolean"
            },
            type: {
              $ref: "#/definitions/TypeReference",
              description: "The declared type of the value, when it's present."
            },
            variadic: {
              default: false,
              description: "Whether this is the last parameter of a variadic method. In such cases,\nthe `#type` attribute is the type of each individual item of the variadic\narguments list (as opposed to some array type, as for example TypeScript\nwould model it).",
              type: "boolean"
            }
          },
          required: [
            "name",
            "type"
          ],
          type: "object"
        },
        Person: {
          description: "Metadata about people or organizations associated with the project that\nresulted in the Assembly. Some of this metadata is required in order to\npublish to certain package repositories (for example, Maven Central), but is\nnot normalized, and the meaning of fields (role, for example), is up to each\nproject maintainer.",
          properties: {
            email: {
              default: "none",
              description: "The email of the person",
              type: "string"
            },
            name: {
              description: "The name of the person",
              type: "string"
            },
            organization: {
              default: false,
              description: "If true, this person is, in fact, an organization",
              type: "boolean"
            },
            roles: {
              description: "A list of roles this person has in the project, for example `maintainer`,\n`contributor`, `owner`, ...",
              items: {
                type: "string"
              },
              type: "array"
            },
            url: {
              default: "none",
              description: "The URL for the person",
              type: "string"
            }
          },
          required: [
            "name",
            "roles"
          ],
          type: "object"
        },
        PrimitiveType: {
          description: "Kinds of primitive types.",
          enum: [
            "any",
            "boolean",
            "date",
            "json",
            "number",
            "string"
          ],
          type: "string"
        },
        PrimitiveTypeReference: {
          description: "Reference to a primitive type.",
          properties: {
            primitive: {
              $ref: "#/definitions/PrimitiveType",
              description: "If this is a reference to a primitive type, this will include the\nprimitive type kind."
            }
          },
          required: [
            "primitive"
          ],
          type: "object"
        },
        Property: {
          description: "A class property.",
          properties: {
            abstract: {
              default: false,
              description: "Indicates if this property is abstract",
              type: "boolean"
            },
            const: {
              default: false,
              description: 'A hint that indicates that this static, immutable property is initialized\nduring startup. This allows emitting "const" idioms in different target\nlanguages. Implies `static` and `immutable`.',
              type: "boolean"
            },
            docs: {
              $ref: "#/definitions/Docs",
              default: "none",
              description: "Documentation for this entity."
            },
            immutable: {
              default: false,
              description: "Indicates if this property only has a getter (immutable).",
              type: "boolean"
            },
            locationInModule: {
              $ref: "#/definitions/SourceLocation",
              default: "none",
              description: "Where in the module this definition was found\n\nWhy is this not `locationInAssembly`? Because the assembly is the JSII\nfile combining compiled code and its manifest, whereas this is referring\nto the location of the source in the module the assembly was built from."
            },
            name: {
              description: "The name of the property.",
              minLength: 1,
              type: "string"
            },
            optional: {
              default: false,
              description: "Determines whether the value is, indeed, optional.",
              type: "boolean"
            },
            overrides: {
              default: "this member is not overriding anything",
              description: "The FQN of the parent type (class or interface) that this entity\noverrides or implements. If undefined, then this entity is the first in\nit's hierarchy to declare this entity.",
              type: "string"
            },
            protected: {
              default: false,
              description: "Indicates if this property is protected (otherwise it is public)",
              type: "boolean"
            },
            static: {
              default: false,
              description: "Indicates if this is a static property.",
              type: "boolean"
            },
            type: {
              $ref: "#/definitions/TypeReference",
              description: "The declared type of the value, when it's present."
            }
          },
          required: [
            "name",
            "type"
          ],
          type: "object"
        },
        ReadMe: {
          description: "README information",
          properties: {
            markdown: {
              type: "string"
            }
          },
          required: [
            "markdown"
          ],
          type: "object"
        },
        SourceLocatable: {
          description: "Indicates that an entity has a source location",
          properties: {
            locationInModule: {
              $ref: "#/definitions/SourceLocation",
              default: "none",
              description: "Where in the module this definition was found\n\nWhy is this not `locationInAssembly`? Because the assembly is the JSII\nfile combining compiled code and its manifest, whereas this is referring\nto the location of the source in the module the assembly was built from."
            }
          },
          type: "object"
        },
        SourceLocation: {
          description: "Where in the module source the definition for this API item was found",
          properties: {
            filename: {
              description: "Relative filename",
              type: "string"
            },
            line: {
              description: "1-based line number in the indicated file",
              type: "number"
            }
          },
          required: [
            "filename",
            "line"
          ],
          type: "object"
        },
        Targetable: {
          description: "A targetable module-like thing\n\nHas targets and a readme. Used for Assemblies and Submodules.",
          properties: {
            readme: {
              $ref: "#/definitions/ReadMe",
              default: "none",
              description: "The readme document for this module (if any)."
            },
            targets: {
              $ref: "#/definitions/AssemblyTargets",
              default: "none",
              description: "A map of target name to configuration, which is used when generating\npackages for various languages."
            }
          },
          type: "object"
        },
        TypeBase: {
          description: "Common attributes of a type definition.",
          properties: {
            assembly: {
              description: "The name of the assembly the type belongs to.",
              minLength: 1,
              type: "string"
            },
            docs: {
              $ref: "#/definitions/Docs",
              default: "none",
              description: "Documentation for this entity."
            },
            fqn: {
              description: "The fully qualified name of the type (``<assembly>.<namespace>.<name>``)",
              minLength: 3,
              type: "string"
            },
            kind: {
              $ref: "#/definitions/TypeKind",
              description: "The kind of the type."
            },
            locationInModule: {
              $ref: "#/definitions/SourceLocation",
              default: "none",
              description: "Where in the module this definition was found\n\nWhy is this not `locationInAssembly`? Because the assembly is the JSII\nfile combining compiled code and its manifest, whereas this is referring\nto the location of the source in the module the assembly was built from."
            },
            name: {
              description: "The simple name of the type (MyClass).",
              minLength: 1,
              type: "string"
            },
            namespace: {
              default: "none",
              description: "The namespace of the type (`foo.bar.baz`).\n\nWhen undefined, the type is located at the root of the assembly (its\n`fqn` would be like `<assembly>.<name>`).\n\nFor types inside other types or inside submodules, the `<namespace>` corresponds to\nthe namespace-qualified name of the container (can contain multiple segments like:\n`<ns1>.<ns2>.<ns3>`).\n\nIn all cases:\n\n <fqn> = <assembly>[.<namespace>].<name>",
              type: "string"
            }
          },
          required: [
            "assembly",
            "fqn",
            "kind",
            "name"
          ],
          type: "object"
        },
        TypeKind: {
          description: "Kinds of types.",
          enum: [
            "class",
            "enum",
            "interface"
          ],
          type: "string"
        },
        TypeReference: {
          anyOf: [
            {
              $ref: "#/definitions/NamedTypeReference"
            },
            {
              $ref: "#/definitions/PrimitiveTypeReference"
            },
            {
              $ref: "#/definitions/CollectionTypeReference"
            },
            {
              $ref: "#/definitions/UnionTypeReference"
            }
          ],
          description: "A reference to a type (primitive, collection or fqn)."
        },
        UnionTypeReference: {
          description: "Reference to a union type.",
          properties: {
            union: {
              description: "Indicates that this is a union type, which means it can be one of a set\nof types.",
              properties: {
                types: {
                  description: "All the possible types (including the primary type).",
                  items: {
                    $ref: "#/definitions/TypeReference"
                  },
                  minItems: 2,
                  type: "array"
                }
              },
              required: [
                "types"
              ],
              type: "object"
            }
          },
          required: [
            "union"
          ],
          type: "object"
        }
      }
    };
  }
});

// node_modules/@jsii/spec/lib/validate-assembly.js
var require_validate_assembly = __commonJS({
  "node_modules/@jsii/spec/lib/validate-assembly.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.validateAssembly = exports.schema = void 0;
    var jsonschema_1 = require_lib4();
    exports.schema = require_jsii_spec_schema();
    function validateAssembly(obj) {
      const validator = new jsonschema_1.Validator();
      validator.addSchema(exports.schema);
      const result = validator.validate(obj, exports.schema, { nestedErrors: true });
      if (result.valid) {
        return obj;
      }
      throw new Error(`Invalid assembly:
${result.toString()}`);
    }
    exports.validateAssembly = validateAssembly;
  }
});

// node_modules/@jsii/spec/lib/index.js
var require_lib5 = __commonJS({
  "node_modules/@jsii/spec/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_assembly(), exports);
    __exportStar(require_configuration(), exports);
    __exportStar(require_name_tree(), exports);
    __exportStar(require_validate_assembly(), exports);
  }
});

// node_modules/jsii-reflect/lib/docs.js
var require_docs = __commonJS({
  "node_modules/jsii-reflect/lib/docs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Docs = void 0;
    var spec_1 = require_lib5();
    var Docs = class {
      constructor(system, target, spec, parentDocs) {
        this.system = system;
        this.target = target;
        this.parentDocs = parentDocs;
        this.docs = spec !== null && spec !== void 0 ? spec : {};
      }
      toString() {
        return [this.docs.summary, this.docs.remarks].filter((txt) => !!txt).join("\n\n");
      }
      get subclassable() {
        return !!this.docs.subclassable;
      }
      get deprecationReason() {
        if (this.docs.deprecated !== void 0) {
          return this.docs.deprecated;
        }
        if (this.parentDocs) {
          return this.parentDocs.deprecationReason;
        }
        return void 0;
      }
      get deprecated() {
        return this.deprecationReason !== void 0;
      }
      get stability() {
        var _a;
        return lowestStability(this.docs.stability, (_a = this.parentDocs) === null || _a === void 0 ? void 0 : _a.stability);
      }
      customTag(tag) {
        var _a;
        return (_a = this.docs.custom) === null || _a === void 0 ? void 0 : _a[tag];
      }
      get summary() {
        var _a;
        return (_a = this.docs.summary) !== null && _a !== void 0 ? _a : "";
      }
      get remarks() {
        var _a;
        return (_a = this.docs.remarks) !== null && _a !== void 0 ? _a : "";
      }
      get example() {
        var _a;
        return (_a = this.docs.example) !== null && _a !== void 0 ? _a : "";
      }
      get link() {
        var _a;
        return (_a = this.docs.see) !== null && _a !== void 0 ? _a : "";
      }
      get returns() {
        var _a;
        return (_a = this.docs.returns) !== null && _a !== void 0 ? _a : "";
      }
    };
    exports.Docs = Docs;
    var stabilityPrecedence = {
      [spec_1.Stability.Deprecated]: 0,
      [spec_1.Stability.Experimental]: 1,
      [spec_1.Stability.External]: 2,
      [spec_1.Stability.Stable]: 3
    };
    function lowestStability(a, b) {
      if (a === void 0) {
        return b;
      }
      if (b === void 0) {
        return a;
      }
      return stabilityPrecedence[a] < stabilityPrecedence[b] ? a : b;
    }
  }
});

// node_modules/jsii-reflect/lib/type-ref.js
var require_type_ref = __commonJS({
  "node_modules/jsii-reflect/lib/type-ref.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TypeReference = void 0;
    var jsii = require_lib5();
    var TypeReference = class {
      constructor(system, spec) {
        this.system = system;
        this.spec = spec;
      }
      toString() {
        if (this.void) {
          return "void";
        }
        if (this.primitive) {
          return this.primitive;
        }
        if (this.fqn) {
          return this.fqn;
        }
        if (this.arrayOfType) {
          return `Array<${this.arrayOfType.toString()}>`;
        }
        if (this.mapOfType) {
          return `Map<string => ${this.mapOfType.toString()}>`;
        }
        if (this.unionOfTypes) {
          return this.unionOfTypes.map((x) => x.toString()).join(" | ");
        }
        throw new Error("Invalid type reference");
      }
      get void() {
        return !this.spec;
      }
      get isAny() {
        return this.primitive === "any";
      }
      get primitive() {
        if (!jsii.isPrimitiveTypeReference(this.spec)) {
          return void 0;
        }
        return this.spec.primitive;
      }
      get fqn() {
        return jsii.isNamedTypeReference(this.spec) ? this.spec.fqn : void 0;
      }
      get type() {
        if (!jsii.isNamedTypeReference(this.spec)) {
          return void 0;
        }
        return this.system.findFqn(this.spec.fqn);
      }
      get arrayOfType() {
        if (!jsii.isCollectionTypeReference(this.spec)) {
          return void 0;
        }
        if (this.spec.collection.kind !== jsii.CollectionKind.Array) {
          return void 0;
        }
        return new TypeReference(this.system, this.spec.collection.elementtype);
      }
      get mapOfType() {
        if (!jsii.isCollectionTypeReference(this.spec)) {
          return void 0;
        }
        if (this.spec.collection.kind !== jsii.CollectionKind.Map) {
          return void 0;
        }
        return new TypeReference(this.system, this.spec.collection.elementtype);
      }
      get unionOfTypes() {
        if (!jsii.isUnionTypeReference(this.spec)) {
          return void 0;
        }
        return this.spec.union.types.map((t) => new TypeReference(this.system, t));
      }
    };
    exports.TypeReference = TypeReference;
  }
});

// node_modules/jsii-reflect/lib/optional-value.js
var require_optional_value = __commonJS({
  "node_modules/jsii-reflect/lib/optional-value.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.OptionalValue = void 0;
    var type_ref_1 = require_type_ref();
    var OptionalValue = class {
      constructor(system, spec) {
        this.system = system;
        this.spec = spec;
      }
      static describe(optionalValue) {
        let description = optionalValue.type.toString();
        if (optionalValue.optional && !optionalValue.type.isAny) {
          description = `Optional<${description}>`;
        }
        return description;
      }
      toString() {
        return OptionalValue.describe(this);
      }
      get type() {
        var _a;
        return new type_ref_1.TypeReference(this.system, (_a = this.spec) === null || _a === void 0 ? void 0 : _a.type);
      }
      get optional() {
        var _a;
        return !!((_a = this.spec) === null || _a === void 0 ? void 0 : _a.optional);
      }
    };
    exports.OptionalValue = OptionalValue;
  }
});

// node_modules/jsii-reflect/lib/parameter.js
var require_parameter = __commonJS({
  "node_modules/jsii-reflect/lib/parameter.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Parameter = void 0;
    var docs_1 = require_docs();
    var optional_value_1 = require_optional_value();
    var Parameter = class extends optional_value_1.OptionalValue {
      constructor(system, parentType, method, spec) {
        super(system, spec);
        this.parentType = parentType;
        this.method = method;
        this.spec = spec;
      }
      get name() {
        return this.spec.name;
      }
      get variadic() {
        return !!this.spec.variadic;
      }
      get docs() {
        var _a;
        return new docs_1.Docs(this.system, this, (_a = this.spec.docs) !== null && _a !== void 0 ? _a : {});
      }
    };
    exports.Parameter = Parameter;
  }
});

// node_modules/jsii-reflect/lib/source.js
var require_source = __commonJS({
  "node_modules/jsii-reflect/lib/source.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.repositoryUrl = exports.locationInRepository = void 0;
    function locationInRepository(item) {
      const moduleLoc = item.locationInModule;
      if (!moduleLoc) {
        return void 0;
      }
      const moduleDir = item.assembly.repository.directory;
      if (!moduleDir) {
        return moduleLoc;
      }
      return {
        filename: `${moduleDir}/${moduleLoc.filename}`,
        line: moduleLoc.line
      };
    }
    exports.locationInRepository = locationInRepository;
    function repositoryUrl(item, ref = "master") {
      const loc = locationInRepository(item);
      if (!loc) {
        return void 0;
      }
      const repo = item.assembly.repository;
      if (!repo.url.startsWith("https://") || !repo.url.includes("github.com") || !repo.url.endsWith(".git")) {
        return void 0;
      }
      const prefix = repo.url.substr(0, repo.url.length - 4);
      return `${prefix}/blob/${ref}/${loc.filename}#L${loc.line}`;
    }
    exports.repositoryUrl = repositoryUrl;
  }
});

// node_modules/jsii-reflect/lib/callable.js
var require_callable = __commonJS({
  "node_modules/jsii-reflect/lib/callable.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Callable = void 0;
    var docs_1 = require_docs();
    var parameter_1 = require_parameter();
    var source_1 = require_source();
    var Callable = class {
      constructor(system, assembly, parentType, spec) {
        this.system = system;
        this.assembly = assembly;
        this.parentType = parentType;
        this.spec = spec;
      }
      get parameters() {
        var _a;
        return ((_a = this.spec.parameters) !== null && _a !== void 0 ? _a : []).map((p) => new parameter_1.Parameter(this.system, this.parentType, this, p));
      }
      get protected() {
        return !!this.spec.protected;
      }
      get variadic() {
        return !!this.spec.variadic;
      }
      get overrides() {
        if (!this.spec.overrides) {
          return void 0;
        }
        return this.system.findFqn(this.spec.overrides);
      }
      get docs() {
        var _a;
        return new docs_1.Docs(this.system, this, (_a = this.spec.docs) !== null && _a !== void 0 ? _a : {}, this.parentType.docs);
      }
      get locationInModule() {
        return this.spec.locationInModule;
      }
      get locationInRepository() {
        return source_1.locationInRepository(this);
      }
      toString() {
        return `${this.kind}:${this.parentType.fqn}.${this.name}`;
      }
    };
    exports.Callable = Callable;
  }
});

// node_modules/jsii-reflect/lib/type-member.js
var require_type_member = __commonJS({
  "node_modules/jsii-reflect/lib/type-member.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isProperty = exports.isMethod = exports.isInitializer = exports.MemberKind = void 0;
    var MemberKind;
    (function(MemberKind2) {
      MemberKind2["Initializer"] = "initializer";
      MemberKind2["Method"] = "method";
      MemberKind2["Property"] = "property";
    })(MemberKind = exports.MemberKind || (exports.MemberKind = {}));
    function isInitializer(x) {
      return x.kind === MemberKind.Initializer;
    }
    exports.isInitializer = isInitializer;
    function isMethod(x) {
      return x.kind === MemberKind.Method;
    }
    exports.isMethod = isMethod;
    function isProperty(x) {
      return x.kind === MemberKind.Property;
    }
    exports.isProperty = isProperty;
  }
});

// node_modules/jsii-reflect/lib/initializer.js
var require_initializer = __commonJS({
  "node_modules/jsii-reflect/lib/initializer.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Initializer = void 0;
    var callable_1 = require_callable();
    var type_member_1 = require_type_member();
    var Initializer = class extends callable_1.Callable {
      constructor() {
        super(...arguments);
        this.kind = type_member_1.MemberKind.Initializer;
        this.name = "<initializer>";
        this.abstract = false;
      }
      static isInitializer(x) {
        return x instanceof Initializer;
      }
    };
    exports.Initializer = Initializer;
  }
});

// node_modules/jsii-reflect/lib/method.js
var require_method = __commonJS({
  "node_modules/jsii-reflect/lib/method.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Method = exports.INITIALIZER_NAME = void 0;
    var callable_1 = require_callable();
    var optional_value_1 = require_optional_value();
    var type_member_1 = require_type_member();
    exports.INITIALIZER_NAME = "<initializer>";
    var Method = class extends callable_1.Callable {
      constructor(system, assembly, parentType, definingType, spec) {
        super(system, assembly, parentType, spec);
        this.definingType = definingType;
        this.spec = spec;
        this.kind = type_member_1.MemberKind.Method;
      }
      static isMethod(x) {
        return x instanceof Method;
      }
      get name() {
        return this.spec.name;
      }
      get overrides() {
        if (!this.spec.overrides) {
          return void 0;
        }
        return this.system.findFqn(this.spec.overrides);
      }
      get returns() {
        return new optional_value_1.OptionalValue(this.system, this.spec.returns);
      }
      get abstract() {
        return !!this.spec.abstract;
      }
      get async() {
        return !!this.spec.async;
      }
      get static() {
        return !!this.spec.static;
      }
    };
    exports.Method = Method;
  }
});

// node_modules/jsii-reflect/lib/property.js
var require_property = __commonJS({
  "node_modules/jsii-reflect/lib/property.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Property = void 0;
    var docs_1 = require_docs();
    var optional_value_1 = require_optional_value();
    var source_1 = require_source();
    var type_member_1 = require_type_member();
    var Property = class extends optional_value_1.OptionalValue {
      constructor(system, assembly, parentType, definingType, spec) {
        super(system, spec);
        this.assembly = assembly;
        this.parentType = parentType;
        this.definingType = definingType;
        this.spec = spec;
        this.kind = type_member_1.MemberKind.Property;
      }
      toString() {
        return `property:${this.parentType.fqn}.${this.name}`;
      }
      get name() {
        return this.spec.name;
      }
      get immutable() {
        return !!this.spec.immutable;
      }
      get protected() {
        return !!this.spec.protected;
      }
      get abstract() {
        return !!this.spec.abstract;
      }
      get static() {
        return !!this.spec.static;
      }
      get const() {
        return !!this.spec.const;
      }
      get overrides() {
        if (!this.spec.overrides) {
          return void 0;
        }
        return this.system.findFqn(this.spec.overrides);
      }
      get docs() {
        var _a;
        return new docs_1.Docs(this.system, this, (_a = this.spec.docs) !== null && _a !== void 0 ? _a : {}, this.parentType.docs);
      }
      get locationInModule() {
        return this.spec.locationInModule;
      }
      get locationInRepository() {
        return source_1.locationInRepository(this);
      }
    };
    exports.Property = Property;
  }
});

// node_modules/jsii-reflect/lib/_memoized.js
var require_memoized = __commonJS({
  "node_modules/jsii-reflect/lib/_memoized.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.memoized = void 0;
    var CACHE = new WeakMap();
    function memoized(_prototype, propertyKey, descriptor) {
      if (!descriptor.get) {
        throw new Error(`@memoized can only be applied to property getters!`);
      }
      if (descriptor.set) {
        throw new Error(`@memoized can only be applied to readonly properties!`);
      }
      const original = descriptor.get;
      descriptor.get = function memoizedGet() {
        let cache = CACHE.get(this);
        if (cache == null) {
          cache = new Map();
          CACHE.set(this, cache);
        }
        if (cache.has(propertyKey)) {
          const result2 = cache.get(propertyKey);
          if (Array.isArray(result2)) {
            return Array.from(result2);
          }
          return result2;
        }
        const result = original.call(this);
        cache.set(propertyKey, Array.isArray(result) ? Array.from(result) : result);
        return result;
      };
    }
    exports.memoized = memoized;
  }
});

// node_modules/jsii-reflect/lib/type.js
var require_type = __commonJS({
  "node_modules/jsii-reflect/lib/type.js"(exports) {
    "use strict";
    var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
      var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
      if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
      else
        for (var i = decorators.length - 1; i >= 0; i--)
          if (d = decorators[i])
            r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
      return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Type = void 0;
    var _memoized_1 = require_memoized();
    var docs_1 = require_docs();
    var source_1 = require_source();
    var type_ref_1 = require_type_ref();
    var Type = class {
      constructor(system, assembly, spec) {
        this.system = system;
        this.assembly = assembly;
        this.spec = spec;
      }
      toString() {
        return `${this.kind} ${this.fqn}`;
      }
      get fqn() {
        return this.spec.fqn;
      }
      get namespace() {
        return this.spec.namespace;
      }
      get nestingParent() {
        const ns = this.namespace;
        if (ns == null) {
          return void 0;
        }
        return this.assembly.tryFindType(`${this.assembly.name}.${ns}`);
      }
      get name() {
        return this.spec.name;
      }
      get kind() {
        return this.spec.kind;
      }
      get docs() {
        var _a;
        return new docs_1.Docs(this.system, this, (_a = this.spec.docs) !== null && _a !== void 0 ? _a : {});
      }
      get reference() {
        return new type_ref_1.TypeReference(this.system, {
          fqn: this.fqn
        });
      }
      isClassType() {
        return false;
      }
      isDataType() {
        return false;
      }
      isEnumType() {
        return false;
      }
      isInterfaceType() {
        return false;
      }
      extends(base) {
        if (this === base) {
          return true;
        }
        if ((this.isInterfaceType() || this.isClassType()) && base.isInterfaceType()) {
          return this.getInterfaces(true).some((iface) => iface === base);
        }
        if (this.isClassType() && base.isClassType()) {
          return this.getAncestors().some((clazz) => clazz === base);
        }
        return false;
      }
      get allImplementations() {
        if (this.isClassType() || this.isInterfaceType()) {
          return [
            ...this.system.classes.filter((c) => c.extends(this)),
            ...this.system.interfaces.filter((i) => i.extends(this))
          ];
        }
        return [];
      }
      get locationInModule() {
        return this.spec.locationInModule;
      }
      get locationInRepository() {
        return source_1.locationInRepository(this);
      }
    };
    __decorate([
      _memoized_1.memoized
    ], Type.prototype, "nestingParent", null);
    __decorate([
      _memoized_1.memoized
    ], Type.prototype, "allImplementations", null);
    exports.Type = Type;
  }
});

// node_modules/jsii-reflect/lib/reference-type.js
var require_reference_type = __commonJS({
  "node_modules/jsii-reflect/lib/reference-type.js"(exports) {
    "use strict";
    var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
      var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
      if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
      else
        for (var i = decorators.length - 1; i >= 0; i--)
          if (d = decorators[i])
            r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
      return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ReferenceType = void 0;
    var _memoized_1 = require_memoized();
    var type_1 = require_type();
    var ReferenceType = class extends type_1.Type {
      constructor(system, assembly, spec) {
        super(system, assembly, spec);
        this.system = system;
        this.assembly = assembly;
      }
      get interfaces() {
        return this.getInterfaces();
      }
      get ownMethods() {
        return Object.values(this.getMethods(false));
      }
      get allMethods() {
        return Object.values(this.getMethods(true));
      }
      get ownProperties() {
        return Object.values(this.getProperties());
      }
      get allProperties() {
        return Object.values(this.getProperties(true));
      }
      get ownMembers() {
        return Object.values(this.getMembers(false));
      }
      get allMembers() {
        return Object.values(this.getMembers(true));
      }
      getMembers(inherited = false) {
        return Object.assign(this.getMethods(inherited), this.getProperties(inherited));
      }
    };
    __decorate([
      _memoized_1.memoized
    ], ReferenceType.prototype, "interfaces", null);
    __decorate([
      _memoized_1.memoized
    ], ReferenceType.prototype, "ownMethods", null);
    __decorate([
      _memoized_1.memoized
    ], ReferenceType.prototype, "allMethods", null);
    __decorate([
      _memoized_1.memoized
    ], ReferenceType.prototype, "ownProperties", null);
    __decorate([
      _memoized_1.memoized
    ], ReferenceType.prototype, "allProperties", null);
    __decorate([
      _memoized_1.memoized
    ], ReferenceType.prototype, "ownMembers", null);
    __decorate([
      _memoized_1.memoized
    ], ReferenceType.prototype, "allMembers", null);
    exports.ReferenceType = ReferenceType;
  }
});

// node_modules/jsii-reflect/lib/util.js
var require_util = __commonJS({
  "node_modules/jsii-reflect/lib/util.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.indexBy = void 0;
    function indexBy(xs, f) {
      const ret = {};
      for (const x of xs) {
        ret[f(x)] = x;
      }
      return ret;
    }
    exports.indexBy = indexBy;
  }
});

// node_modules/jsii-reflect/lib/class.js
var require_class = __commonJS({
  "node_modules/jsii-reflect/lib/class.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ClassType = void 0;
    var initializer_1 = require_initializer();
    var method_1 = require_method();
    var property_1 = require_property();
    var reference_type_1 = require_reference_type();
    var util_1 = require_util();
    var ClassType = class extends reference_type_1.ReferenceType {
      constructor(system, assembly, spec) {
        super(system, assembly, spec);
        this.system = system;
        this.assembly = assembly;
        this.spec = spec;
      }
      get base() {
        if (!this.spec.base) {
          return void 0;
        }
        const type = this.system.findFqn(this.spec.base);
        if (!(type instanceof ClassType)) {
          throw new Error(`FQN for base class points to a non-class type: ${this.spec.base}`);
        }
        return type;
      }
      get initializer() {
        if (!this.spec.initializer) {
          return void 0;
        }
        return new initializer_1.Initializer(this.system, this.assembly, this, this.spec.initializer);
      }
      get abstract() {
        return !!this.spec.abstract;
      }
      getAncestors() {
        const out = new Array();
        if (this.base) {
          out.push(this.base);
          out.push(...this.base.getAncestors());
        }
        return out;
      }
      getProperties(inherited = false) {
        return this._getProperties(inherited, this);
      }
      getMethods(inherited = false) {
        return this._getMethods(inherited, this);
      }
      getInterfaces(inherited = false) {
        const out = new Array();
        if (inherited && this.base) {
          out.push(...this.base.getInterfaces(inherited));
        }
        if (this.spec.interfaces) {
          out.push(...flatten(this.spec.interfaces.map((fqn) => this.system.findInterface(fqn)).map((iface) => [
            iface,
            ...inherited ? iface.getInterfaces(true) : []
          ])));
        }
        return out;
      }
      isClassType() {
        return true;
      }
      _getProperties(inherited, parentType) {
        var _a;
        const base = inherited && this.base ? this.base._getProperties(inherited, parentType) : {};
        return Object.assign(base, util_1.indexBy(((_a = this.spec.properties) !== null && _a !== void 0 ? _a : []).map((p) => new property_1.Property(this.system, this.assembly, parentType, this, p)), (p) => p.name));
      }
      _getMethods(inherited, parentType) {
        var _a;
        const base = inherited && this.base ? this.base._getMethods(inherited, parentType) : {};
        return Object.assign(base, util_1.indexBy(((_a = this.spec.methods) !== null && _a !== void 0 ? _a : []).map((m) => new method_1.Method(this.system, this.assembly, parentType, this, m)), (m) => m.name));
      }
    };
    exports.ClassType = ClassType;
    function flatten(xs) {
      return Array.prototype.concat([], ...xs);
    }
  }
});

// node_modules/jsii-reflect/lib/dependency.js
var require_dependency = __commonJS({
  "node_modules/jsii-reflect/lib/dependency.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Dependency = void 0;
    var Dependency = class {
      constructor(system, name, version) {
        this.system = system;
        this.name = name;
        this.version = version;
      }
      get assembly() {
        return this.system.findAssembly(this.name);
      }
    };
    exports.Dependency = Dependency;
  }
});

// node_modules/jsii-reflect/lib/enum.js
var require_enum = __commonJS({
  "node_modules/jsii-reflect/lib/enum.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.EnumMember = exports.EnumType = void 0;
    var docs_1 = require_docs();
    var type_1 = require_type();
    var EnumType = class extends type_1.Type {
      constructor(system, assembly, spec) {
        super(system, assembly, spec);
        this.system = system;
        this.assembly = assembly;
        this.spec = spec;
      }
      get members() {
        return this.spec.members.map((m) => new EnumMember(this, m));
      }
      isEnumType() {
        return true;
      }
    };
    exports.EnumType = EnumType;
    var EnumMember = class {
      constructor(enumType, memberSpec) {
        var _a;
        this.enumType = enumType;
        this.name = memberSpec.name;
        this.docs = new docs_1.Docs(this.system, this, (_a = memberSpec.docs) !== null && _a !== void 0 ? _a : {}, this.enumType.docs);
      }
      get system() {
        return this.enumType.system;
      }
      get assembly() {
        return this.enumType.assembly;
      }
    };
    exports.EnumMember = EnumMember;
  }
});

// node_modules/jsii-reflect/lib/interface.js
var require_interface = __commonJS({
  "node_modules/jsii-reflect/lib/interface.js"(exports) {
    "use strict";
    var __classPrivateFieldGet = exports && exports.__classPrivateFieldGet || function(receiver, privateMap) {
      if (!privateMap.has(receiver)) {
        throw new TypeError("attempted to get private field on non-instance");
      }
      return privateMap.get(receiver);
    };
    var _interfaces;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.InterfaceType = void 0;
    var method_1 = require_method();
    var property_1 = require_property();
    var reference_type_1 = require_reference_type();
    var util_1 = require_util();
    var InterfaceType = class extends reference_type_1.ReferenceType {
      constructor(system, assembly, spec) {
        super(system, assembly, spec);
        this.system = system;
        this.assembly = assembly;
        this.spec = spec;
        _interfaces.set(this, new Map());
      }
      get datatype() {
        return this.isDataType();
      }
      getInterfaces(inherited = false) {
        if (!this.spec.interfaces) {
          return [];
        }
        if (__classPrivateFieldGet(this, _interfaces).has(inherited)) {
          return Array.from(__classPrivateFieldGet(this, _interfaces).get(inherited));
        }
        const result = new Set();
        for (const iface of this.spec.interfaces) {
          const ifaceType = this.system.findInterface(iface);
          if (!result.has(ifaceType) && inherited) {
            ifaceType.getInterfaces(inherited).forEach((i) => result.add(i));
          }
          result.add(ifaceType);
        }
        __classPrivateFieldGet(this, _interfaces).set(inherited, Array.from(result));
        return Array.from(result);
      }
      getProperties(inherited = false) {
        return this._getProperties(inherited, this);
      }
      getMethods(inherited = false) {
        return this._getMethods(inherited, this);
      }
      isDataType() {
        return !!this.spec.datatype;
      }
      isInterfaceType() {
        return true;
      }
      _getProperties(inherited, parentType) {
        var _a;
        const base = {};
        if (inherited) {
          for (const parent of this.getInterfaces()) {
            Object.assign(base, parent._getProperties(inherited, parentType));
          }
        }
        return Object.assign(base, util_1.indexBy(((_a = this.spec.properties) !== null && _a !== void 0 ? _a : []).map((p) => new property_1.Property(this.system, this.assembly, parentType, this, p)), (p) => p.name));
      }
      _getMethods(inherited, parentType) {
        var _a;
        const base = {};
        if (inherited) {
          for (const parent of this.getInterfaces()) {
            Object.assign(base, parent._getMethods(inherited, parentType));
          }
        }
        return Object.assign(base, util_1.indexBy(((_a = this.spec.methods) !== null && _a !== void 0 ? _a : []).map((m) => new method_1.Method(this.system, this.assembly, parentType, this, m)), (m) => m.name));
      }
    };
    exports.InterfaceType = InterfaceType;
    _interfaces = new WeakMap();
  }
});

// node_modules/jsii-reflect/lib/module-like.js
var require_module_like = __commonJS({
  "node_modules/jsii-reflect/lib/module-like.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ModuleLike = void 0;
    var class_1 = require_class();
    var enum_1 = require_enum();
    var interface_1 = require_interface();
    var ModuleLike = class {
      constructor(system) {
        this.system = system;
        this.typeLocatorCache = new Map();
      }
      get submodules() {
        return Object.values(this.submoduleMap);
      }
      get types() {
        return Object.values(this.typeMap);
      }
      get classes() {
        return this.types.filter((t) => t instanceof class_1.ClassType).map((t) => t);
      }
      get interfaces() {
        return this.types.filter((t) => t instanceof interface_1.InterfaceType).map((t) => t);
      }
      get enums() {
        return this.types.filter((t) => t instanceof enum_1.EnumType).map((t) => t);
      }
      tryFindType(fqn) {
        if (this.typeLocatorCache.has(fqn)) {
          return this.typeLocatorCache.get(fqn);
        }
        const ownType = this.typeMap[fqn];
        if (ownType != null) {
          this.typeLocatorCache.set(fqn, ownType);
          return ownType;
        }
        if (!fqn.startsWith(`${this.fqn}.`)) {
          this.typeLocatorCache.set(fqn, void 0);
          return void 0;
        }
        const myFqnLength = this.fqn.split(".").length;
        const subFqn = fqn.split(".").slice(0, myFqnLength + 1).join(".");
        const sub = this.submoduleMap[subFqn];
        const submoduleType = sub === null || sub === void 0 ? void 0 : sub.tryFindType(fqn);
        this.typeLocatorCache.set(fqn, submoduleType);
        return submoduleType;
      }
    };
    exports.ModuleLike = ModuleLike;
  }
});

// node_modules/jsii-reflect/lib/submodule.js
var require_submodule = __commonJS({
  "node_modules/jsii-reflect/lib/submodule.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Submodule = void 0;
    var module_like_1 = require_module_like();
    var Submodule = class extends module_like_1.ModuleLike {
      constructor(system, spec, fqn, submoduleMap, typeMap) {
        super(system);
        this.spec = spec;
        this.fqn = fqn;
        this.submoduleMap = submoduleMap;
        this.typeMap = typeMap;
        this.name = fqn.split(".").pop();
      }
      get targets() {
        return this.spec.targets;
      }
      get readme() {
        return this.spec.readme;
      }
    };
    exports.Submodule = Submodule;
  }
});

// node_modules/jsii-reflect/lib/assembly.js
var require_assembly2 = __commonJS({
  "node_modules/jsii-reflect/lib/assembly.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Assembly = void 0;
    var jsii = require_lib5();
    var class_1 = require_class();
    var dependency_1 = require_dependency();
    var enum_1 = require_enum();
    var interface_1 = require_interface();
    var module_like_1 = require_module_like();
    var submodule_1 = require_submodule();
    var Assembly = class extends module_like_1.ModuleLike {
      constructor(system, spec) {
        super(system);
        this.spec = spec;
      }
      get fqn() {
        return this.spec.name;
      }
      get schema() {
        return this.spec.schema;
      }
      get jsiiVersion() {
        return this.spec.jsiiVersion;
      }
      get name() {
        return this.spec.name;
      }
      get description() {
        return this.spec.description;
      }
      get metadata() {
        return this.spec.metadata;
      }
      get homepage() {
        return this.spec.homepage;
      }
      get repository() {
        return this.spec.repository;
      }
      get author() {
        return this.spec.author;
      }
      get contributors() {
        var _a;
        return (_a = this.spec.contributors) !== null && _a !== void 0 ? _a : [];
      }
      get fingerprint() {
        return this.spec.fingerprint;
      }
      get version() {
        return this.spec.version;
      }
      get license() {
        return this.spec.license;
      }
      get targets() {
        return this.spec.targets;
      }
      get dependencies() {
        return Object.keys(this._dependencies).map((name) => this._dependencies[name]);
      }
      findDependency(name) {
        const dep = this._dependencies[name];
        if (!dep) {
          throw new Error(`Dependency ${name} not found for assembly ${this.name}`);
        }
        return dep;
      }
      get bundled() {
        var _a;
        return (_a = this.spec.bundled) !== null && _a !== void 0 ? _a : {};
      }
      get readme() {
        return this.spec.readme;
      }
      get submodules() {
        const { submodules } = this._analyzeTypes();
        return Object.entries(submodules).filter(([name, _]) => name.split(".").length === 2).map(([_, submodule]) => submodule);
      }
      get allSubmodules() {
        const { submodules } = this._analyzeTypes();
        return Object.values(submodules);
      }
      findType(fqn) {
        const type = this.tryFindType(fqn);
        if (!type) {
          throw new Error(`Type '${fqn}' not found in assembly ${this.name}`);
        }
        return type;
      }
      validate() {
        jsii.validateAssembly(this.spec);
      }
      get submoduleMap() {
        return this._analyzeTypes().submodules;
      }
      get typeMap() {
        return this._analyzeTypes().types;
      }
      get _dependencies() {
        if (!this._dependencyCache) {
          this._dependencyCache = {};
          if (this.spec.dependencies) {
            for (const name of Object.keys(this.spec.dependencies)) {
              this._dependencyCache[name] = new dependency_1.Dependency(this.system, name, this.spec.dependencies[name]);
            }
          }
        }
        return this._dependencyCache;
      }
      _analyzeTypes() {
        var _a;
        if (!this._typeCache || !this._submoduleCache) {
          this._typeCache = {};
          const submoduleBuilders = this.discoverSubmodules();
          const ts = (_a = this.spec.types) !== null && _a !== void 0 ? _a : {};
          for (const [fqn, typeSpec] of Object.entries(ts)) {
            let type;
            switch (typeSpec.kind) {
              case jsii.TypeKind.Class:
                type = new class_1.ClassType(this.system, this, typeSpec);
                break;
              case jsii.TypeKind.Interface:
                type = new interface_1.InterfaceType(this.system, this, typeSpec);
                break;
              case jsii.TypeKind.Enum:
                type = new enum_1.EnumType(this.system, this, typeSpec);
                break;
              default:
                throw new Error("Unknown type kind");
            }
            let submodule = typeSpec.namespace;
            while (submodule != null && `${this.spec.name}.${submodule}` in ts) {
              submodule = ts[`${this.spec.name}.${submodule}`].namespace;
            }
            if (submodule != null) {
              const moduleName = `${this.spec.name}.${submodule}`;
              submoduleBuilders[moduleName].addType(type);
            } else {
              this._typeCache[fqn] = type;
            }
          }
          this._submoduleCache = mapValues(submoduleBuilders, (b) => b.build());
        }
        return { types: this._typeCache, submodules: this._submoduleCache };
      }
      discoverSubmodules() {
        var _a;
        const system = this.system;
        const ret = {};
        for (const [submoduleName, submoduleSpec] of Object.entries((_a = this.spec.submodules) !== null && _a !== void 0 ? _a : {})) {
          ret[submoduleName] = new SubmoduleBuilder(system, submoduleSpec, submoduleName, ret);
        }
        return ret;
      }
    };
    exports.Assembly = Assembly;
    var SubmoduleBuilder = class {
      constructor(system, spec, fullName, allModuleBuilders) {
        this.system = system;
        this.spec = spec;
        this.fullName = fullName;
        this.allModuleBuilders = allModuleBuilders;
        this.types = {};
      }
      isChildOf(other) {
        return this.fullName.startsWith(`${other.fullName}.`) && this.fullName.split(".").length === other.fullName.split(".").length + 1;
      }
      build() {
        if (!this._built) {
          this._built = new submodule_1.Submodule(this.system, this.spec, this.fullName, mapValues(this.findSubmoduleBuilders(), (b) => b.build()), this.types);
        }
        return this._built;
      }
      findSubmoduleBuilders() {
        const ret = {};
        for (const [k, child] of Object.entries(this.allModuleBuilders)) {
          if (child.isChildOf(this)) {
            ret[k] = child;
          }
        }
        return ret;
      }
      addType(type) {
        this.types[type.fqn] = type;
      }
    };
    function mapValues(xs, fn) {
      const ret = {};
      for (const [k, v] of Object.entries(xs)) {
        ret[k] = fn(v);
      }
      return ret;
    }
  }
});

// node_modules/jsii-reflect/lib/overridable.js
var require_overridable = __commonJS({
  "node_modules/jsii-reflect/lib/overridable.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/colors/lib/styles.js
var require_styles = __commonJS({
  "node_modules/colors/lib/styles.js"(exports, module2) {
    var styles = {};
    module2["exports"] = styles;
    var codes = {
      reset: [0, 0],
      bold: [1, 22],
      dim: [2, 22],
      italic: [3, 23],
      underline: [4, 24],
      inverse: [7, 27],
      hidden: [8, 28],
      strikethrough: [9, 29],
      black: [30, 39],
      red: [31, 39],
      green: [32, 39],
      yellow: [33, 39],
      blue: [34, 39],
      magenta: [35, 39],
      cyan: [36, 39],
      white: [37, 39],
      gray: [90, 39],
      grey: [90, 39],
      brightRed: [91, 39],
      brightGreen: [92, 39],
      brightYellow: [93, 39],
      brightBlue: [94, 39],
      brightMagenta: [95, 39],
      brightCyan: [96, 39],
      brightWhite: [97, 39],
      bgBlack: [40, 49],
      bgRed: [41, 49],
      bgGreen: [42, 49],
      bgYellow: [43, 49],
      bgBlue: [44, 49],
      bgMagenta: [45, 49],
      bgCyan: [46, 49],
      bgWhite: [47, 49],
      bgGray: [100, 49],
      bgGrey: [100, 49],
      bgBrightRed: [101, 49],
      bgBrightGreen: [102, 49],
      bgBrightYellow: [103, 49],
      bgBrightBlue: [104, 49],
      bgBrightMagenta: [105, 49],
      bgBrightCyan: [106, 49],
      bgBrightWhite: [107, 49],
      blackBG: [40, 49],
      redBG: [41, 49],
      greenBG: [42, 49],
      yellowBG: [43, 49],
      blueBG: [44, 49],
      magentaBG: [45, 49],
      cyanBG: [46, 49],
      whiteBG: [47, 49]
    };
    Object.keys(codes).forEach(function(key) {
      var val = codes[key];
      var style = styles[key] = [];
      style.open = "[" + val[0] + "m";
      style.close = "[" + val[1] + "m";
    });
  }
});

// node_modules/colors/lib/system/has-flag.js
var require_has_flag = __commonJS({
  "node_modules/colors/lib/system/has-flag.js"(exports, module2) {
    "use strict";
    module2.exports = function(flag, argv) {
      argv = argv || process.argv;
      var terminatorPos = argv.indexOf("--");
      var prefix = /^-{1,2}/.test(flag) ? "" : "--";
      var pos = argv.indexOf(prefix + flag);
      return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
    };
  }
});

// node_modules/colors/lib/system/supports-colors.js
var require_supports_colors = __commonJS({
  "node_modules/colors/lib/system/supports-colors.js"(exports, module2) {
    "use strict";
    var os2 = require("os");
    var hasFlag = require_has_flag();
    var env2 = process.env;
    var forceColor = void 0;
    if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false")) {
      forceColor = false;
    } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
      forceColor = true;
    }
    if ("FORCE_COLOR" in env2) {
      forceColor = env2.FORCE_COLOR.length === 0 || parseInt(env2.FORCE_COLOR, 10) !== 0;
    }
    function translateLevel(level) {
      if (level === 0) {
        return false;
      }
      return {
        level,
        hasBasic: true,
        has256: level >= 2,
        has16m: level >= 3
      };
    }
    function supportsColor(stream) {
      if (forceColor === false) {
        return 0;
      }
      if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
        return 3;
      }
      if (hasFlag("color=256")) {
        return 2;
      }
      if (stream && !stream.isTTY && forceColor !== true) {
        return 0;
      }
      var min = forceColor ? 1 : 0;
      if (process.platform === "win32") {
        var osRelease = os2.release().split(".");
        if (Number(process.versions.node.split(".")[0]) >= 8 && Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
          return Number(osRelease[2]) >= 14931 ? 3 : 2;
        }
        return 1;
      }
      if ("CI" in env2) {
        if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI"].some(function(sign) {
          return sign in env2;
        }) || env2.CI_NAME === "codeship") {
          return 1;
        }
        return min;
      }
      if ("TEAMCITY_VERSION" in env2) {
        return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env2.TEAMCITY_VERSION) ? 1 : 0;
      }
      if ("TERM_PROGRAM" in env2) {
        var version = parseInt((env2.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
        switch (env2.TERM_PROGRAM) {
          case "iTerm.app":
            return version >= 3 ? 3 : 2;
          case "Hyper":
            return 3;
          case "Apple_Terminal":
            return 2;
        }
      }
      if (/-256(color)?$/i.test(env2.TERM)) {
        return 2;
      }
      if (/^screen|^xterm|^vt100|^rxvt|color|ansi|cygwin|linux/i.test(env2.TERM)) {
        return 1;
      }
      if ("COLORTERM" in env2) {
        return 1;
      }
      if (env2.TERM === "dumb") {
        return min;
      }
      return min;
    }
    function getSupportLevel(stream) {
      var level = supportsColor(stream);
      return translateLevel(level);
    }
    module2.exports = {
      supportsColor: getSupportLevel,
      stdout: getSupportLevel(process.stdout),
      stderr: getSupportLevel(process.stderr)
    };
  }
});

// node_modules/colors/lib/custom/trap.js
var require_trap = __commonJS({
  "node_modules/colors/lib/custom/trap.js"(exports, module2) {
    module2["exports"] = function runTheTrap(text, options) {
      var result = "";
      text = text || "Run the trap, drop the bass";
      text = text.split("");
      var trap = {
        a: ["@", "\u0104", "\u023A", "\u0245", "\u0394", "\u039B", "\u0414"],
        b: ["\xDF", "\u0181", "\u0243", "\u026E", "\u03B2", "\u0E3F"],
        c: ["\xA9", "\u023B", "\u03FE"],
        d: ["\xD0", "\u018A", "\u0500", "\u0501", "\u0502", "\u0503"],
        e: [
          "\xCB",
          "\u0115",
          "\u018E",
          "\u0258",
          "\u03A3",
          "\u03BE",
          "\u04BC",
          "\u0A6C"
        ],
        f: ["\u04FA"],
        g: ["\u0262"],
        h: ["\u0126", "\u0195", "\u04A2", "\u04BA", "\u04C7", "\u050A"],
        i: ["\u0F0F"],
        j: ["\u0134"],
        k: ["\u0138", "\u04A0", "\u04C3", "\u051E"],
        l: ["\u0139"],
        m: ["\u028D", "\u04CD", "\u04CE", "\u0520", "\u0521", "\u0D69"],
        n: ["\xD1", "\u014B", "\u019D", "\u0376", "\u03A0", "\u048A"],
        o: [
          "\xD8",
          "\xF5",
          "\xF8",
          "\u01FE",
          "\u0298",
          "\u047A",
          "\u05DD",
          "\u06DD",
          "\u0E4F"
        ],
        p: ["\u01F7", "\u048E"],
        q: ["\u09CD"],
        r: ["\xAE", "\u01A6", "\u0210", "\u024C", "\u0280", "\u042F"],
        s: ["\xA7", "\u03DE", "\u03DF", "\u03E8"],
        t: ["\u0141", "\u0166", "\u0373"],
        u: ["\u01B1", "\u054D"],
        v: ["\u05D8"],
        w: ["\u0428", "\u0460", "\u047C", "\u0D70"],
        x: ["\u04B2", "\u04FE", "\u04FC", "\u04FD"],
        y: ["\xA5", "\u04B0", "\u04CB"],
        z: ["\u01B5", "\u0240"]
      };
      text.forEach(function(c) {
        c = c.toLowerCase();
        var chars = trap[c] || [" "];
        var rand = Math.floor(Math.random() * chars.length);
        if (typeof trap[c] !== "undefined") {
          result += trap[c][rand];
        } else {
          result += c;
        }
      });
      return result;
    };
  }
});

// node_modules/colors/lib/custom/zalgo.js
var require_zalgo = __commonJS({
  "node_modules/colors/lib/custom/zalgo.js"(exports, module2) {
    module2["exports"] = function zalgo(text, options) {
      text = text || "   he is here   ";
      var soul = {
        "up": [
          "\u030D",
          "\u030E",
          "\u0304",
          "\u0305",
          "\u033F",
          "\u0311",
          "\u0306",
          "\u0310",
          "\u0352",
          "\u0357",
          "\u0351",
          "\u0307",
          "\u0308",
          "\u030A",
          "\u0342",
          "\u0313",
          "\u0308",
          "\u034A",
          "\u034B",
          "\u034C",
          "\u0303",
          "\u0302",
          "\u030C",
          "\u0350",
          "\u0300",
          "\u0301",
          "\u030B",
          "\u030F",
          "\u0312",
          "\u0313",
          "\u0314",
          "\u033D",
          "\u0309",
          "\u0363",
          "\u0364",
          "\u0365",
          "\u0366",
          "\u0367",
          "\u0368",
          "\u0369",
          "\u036A",
          "\u036B",
          "\u036C",
          "\u036D",
          "\u036E",
          "\u036F",
          "\u033E",
          "\u035B",
          "\u0346",
          "\u031A"
        ],
        "down": [
          "\u0316",
          "\u0317",
          "\u0318",
          "\u0319",
          "\u031C",
          "\u031D",
          "\u031E",
          "\u031F",
          "\u0320",
          "\u0324",
          "\u0325",
          "\u0326",
          "\u0329",
          "\u032A",
          "\u032B",
          "\u032C",
          "\u032D",
          "\u032E",
          "\u032F",
          "\u0330",
          "\u0331",
          "\u0332",
          "\u0333",
          "\u0339",
          "\u033A",
          "\u033B",
          "\u033C",
          "\u0345",
          "\u0347",
          "\u0348",
          "\u0349",
          "\u034D",
          "\u034E",
          "\u0353",
          "\u0354",
          "\u0355",
          "\u0356",
          "\u0359",
          "\u035A",
          "\u0323"
        ],
        "mid": [
          "\u0315",
          "\u031B",
          "\u0300",
          "\u0301",
          "\u0358",
          "\u0321",
          "\u0322",
          "\u0327",
          "\u0328",
          "\u0334",
          "\u0335",
          "\u0336",
          "\u035C",
          "\u035D",
          "\u035E",
          "\u035F",
          "\u0360",
          "\u0362",
          "\u0338",
          "\u0337",
          "\u0361",
          " \u0489"
        ]
      };
      var all = [].concat(soul.up, soul.down, soul.mid);
      function randomNumber(range) {
        var r = Math.floor(Math.random() * range);
        return r;
      }
      function isChar(character) {
        var bool = false;
        all.filter(function(i) {
          bool = i === character;
        });
        return bool;
      }
      function heComes(text2, options2) {
        var result = "";
        var counts;
        var l;
        options2 = options2 || {};
        options2["up"] = typeof options2["up"] !== "undefined" ? options2["up"] : true;
        options2["mid"] = typeof options2["mid"] !== "undefined" ? options2["mid"] : true;
        options2["down"] = typeof options2["down"] !== "undefined" ? options2["down"] : true;
        options2["size"] = typeof options2["size"] !== "undefined" ? options2["size"] : "maxi";
        text2 = text2.split("");
        for (l in text2) {
          if (isChar(l)) {
            continue;
          }
          result = result + text2[l];
          counts = { "up": 0, "down": 0, "mid": 0 };
          switch (options2.size) {
            case "mini":
              counts.up = randomNumber(8);
              counts.mid = randomNumber(2);
              counts.down = randomNumber(8);
              break;
            case "maxi":
              counts.up = randomNumber(16) + 3;
              counts.mid = randomNumber(4) + 1;
              counts.down = randomNumber(64) + 3;
              break;
            default:
              counts.up = randomNumber(8) + 1;
              counts.mid = randomNumber(6) / 2;
              counts.down = randomNumber(8) + 1;
              break;
          }
          var arr = ["up", "mid", "down"];
          for (var d in arr) {
            var index = arr[d];
            for (var i = 0; i <= counts[index]; i++) {
              if (options2[index]) {
                result = result + soul[index][randomNumber(soul[index].length)];
              }
            }
          }
        }
        return result;
      }
      return heComes(text, options);
    };
  }
});

// node_modules/colors/lib/maps/america.js
var require_america = __commonJS({
  "node_modules/colors/lib/maps/america.js"(exports, module2) {
    module2["exports"] = function(colors) {
      return function(letter, i, exploded) {
        if (letter === " ")
          return letter;
        switch (i % 3) {
          case 0:
            return colors.red(letter);
          case 1:
            return colors.white(letter);
          case 2:
            return colors.blue(letter);
        }
      };
    };
  }
});

// node_modules/colors/lib/maps/zebra.js
var require_zebra = __commonJS({
  "node_modules/colors/lib/maps/zebra.js"(exports, module2) {
    module2["exports"] = function(colors) {
      return function(letter, i, exploded) {
        return i % 2 === 0 ? letter : colors.inverse(letter);
      };
    };
  }
});

// node_modules/colors/lib/maps/rainbow.js
var require_rainbow = __commonJS({
  "node_modules/colors/lib/maps/rainbow.js"(exports, module2) {
    module2["exports"] = function(colors) {
      var rainbowColors = ["red", "yellow", "green", "blue", "magenta"];
      return function(letter, i, exploded) {
        if (letter === " ") {
          return letter;
        } else {
          return colors[rainbowColors[i++ % rainbowColors.length]](letter);
        }
      };
    };
  }
});

// node_modules/colors/lib/maps/random.js
var require_random = __commonJS({
  "node_modules/colors/lib/maps/random.js"(exports, module2) {
    module2["exports"] = function(colors) {
      var available = [
        "underline",
        "inverse",
        "grey",
        "yellow",
        "red",
        "green",
        "blue",
        "white",
        "cyan",
        "magenta",
        "brightYellow",
        "brightRed",
        "brightGreen",
        "brightBlue",
        "brightWhite",
        "brightCyan",
        "brightMagenta"
      ];
      return function(letter, i, exploded) {
        return letter === " " ? letter : colors[available[Math.round(Math.random() * (available.length - 2))]](letter);
      };
    };
  }
});

// node_modules/colors/lib/colors.js
var require_colors = __commonJS({
  "node_modules/colors/lib/colors.js"(exports, module2) {
    var colors = {};
    module2["exports"] = colors;
    colors.themes = {};
    var util = require("util");
    var ansiStyles = colors.styles = require_styles();
    var defineProps = Object.defineProperties;
    var newLineRegex = new RegExp(/[\r\n]+/g);
    colors.supportsColor = require_supports_colors().supportsColor;
    if (typeof colors.enabled === "undefined") {
      colors.enabled = colors.supportsColor() !== false;
    }
    colors.enable = function() {
      colors.enabled = true;
    };
    colors.disable = function() {
      colors.enabled = false;
    };
    colors.stripColors = colors.strip = function(str) {
      return ("" + str).replace(/\x1B\[\d+m/g, "");
    };
    var stylize = colors.stylize = function stylize2(str, style) {
      if (!colors.enabled) {
        return str + "";
      }
      var styleMap = ansiStyles[style];
      if (!styleMap && style in colors) {
        return colors[style](str);
      }
      return styleMap.open + str + styleMap.close;
    };
    var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;
    var escapeStringRegexp = function(str) {
      if (typeof str !== "string") {
        throw new TypeError("Expected a string");
      }
      return str.replace(matchOperatorsRe, "\\$&");
    };
    function build(_styles) {
      var builder = function builder2() {
        return applyStyle.apply(builder2, arguments);
      };
      builder._styles = _styles;
      builder.__proto__ = proto;
      return builder;
    }
    var styles = function() {
      var ret = {};
      ansiStyles.grey = ansiStyles.gray;
      Object.keys(ansiStyles).forEach(function(key) {
        ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), "g");
        ret[key] = {
          get: function() {
            return build(this._styles.concat(key));
          }
        };
      });
      return ret;
    }();
    var proto = defineProps(function colors2() {
    }, styles);
    function applyStyle() {
      var args = Array.prototype.slice.call(arguments);
      var str = args.map(function(arg) {
        if (arg != null && arg.constructor === String) {
          return arg;
        } else {
          return util.inspect(arg);
        }
      }).join(" ");
      if (!colors.enabled || !str) {
        return str;
      }
      var newLinesPresent = str.indexOf("\n") != -1;
      var nestedStyles = this._styles;
      var i = nestedStyles.length;
      while (i--) {
        var code = ansiStyles[nestedStyles[i]];
        str = code.open + str.replace(code.closeRe, code.open) + code.close;
        if (newLinesPresent) {
          str = str.replace(newLineRegex, function(match) {
            return code.close + match + code.open;
          });
        }
      }
      return str;
    }
    colors.setTheme = function(theme) {
      if (typeof theme === "string") {
        console.log("colors.setTheme now only accepts an object, not a string.  If you are trying to set a theme from a file, it is now your (the caller's) responsibility to require the file.  The old syntax looked like colors.setTheme(__dirname + '/../themes/generic-logging.js'); The new syntax looks like colors.setTheme(require(__dirname + '/../themes/generic-logging.js'));");
        return;
      }
      for (var style in theme) {
        (function(style2) {
          colors[style2] = function(str) {
            if (typeof theme[style2] === "object") {
              var out = str;
              for (var i in theme[style2]) {
                out = colors[theme[style2][i]](out);
              }
              return out;
            }
            return colors[theme[style2]](str);
          };
        })(style);
      }
    };
    function init() {
      var ret = {};
      Object.keys(styles).forEach(function(name) {
        ret[name] = {
          get: function() {
            return build([name]);
          }
        };
      });
      return ret;
    }
    var sequencer = function sequencer2(map2, str) {
      var exploded = str.split("");
      exploded = exploded.map(map2);
      return exploded.join("");
    };
    colors.trap = require_trap();
    colors.zalgo = require_zalgo();
    colors.maps = {};
    colors.maps.america = require_america()(colors);
    colors.maps.zebra = require_zebra()(colors);
    colors.maps.rainbow = require_rainbow()(colors);
    colors.maps.random = require_random()(colors);
    for (map in colors.maps) {
      (function(map2) {
        colors[map2] = function(str) {
          return sequencer(colors.maps[map2], str);
        };
      })(map);
    }
    var map;
    defineProps(colors, init());
  }
});

// node_modules/colors/safe.js
var require_safe = __commonJS({
  "node_modules/colors/safe.js"(exports, module2) {
    var colors = require_colors();
    module2["exports"] = colors;
  }
});

// node_modules/oo-ascii-tree/lib/ascii-tree.js
var require_ascii_tree = __commonJS({
  "node_modules/oo-ascii-tree/lib/ascii-tree.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.AsciiTree = void 0;
    var AsciiTree = class {
      constructor(text, ...children) {
        this.text = text;
        this._children = new Array();
        for (const child of children) {
          this.add(child);
        }
      }
      printTree(output = process.stdout) {
        let ancestorsPrefix = "";
        for (const parent of this.ancestors) {
          if (parent.level <= 0) {
            continue;
          }
          if (parent.last) {
            ancestorsPrefix += "  ";
          } else {
            ancestorsPrefix += " \u2502";
          }
        }
        let myPrefix = "";
        let multilinePrefix = "";
        if (this.level > 0) {
          if (this.last) {
            if (!this.empty) {
              myPrefix += " \u2514\u2500\u252C ";
              multilinePrefix += " \u2514\u2500\u252C ";
            } else {
              myPrefix += " \u2514\u2500\u2500 ";
              multilinePrefix = "     ";
            }
          } else {
            if (!this.empty) {
              myPrefix += " \u251C\u2500\u252C ";
              multilinePrefix += " \u2502 \u2502 ";
            } else {
              myPrefix += " \u251C\u2500\u2500 ";
              multilinePrefix += " \u2502   ";
            }
          }
        }
        if (this.text) {
          output.write(ancestorsPrefix);
          output.write(myPrefix);
          const lines = this.text.split("\n");
          output.write(lines[0]);
          output.write("\n");
          for (const line of lines.splice(1)) {
            output.write(ancestorsPrefix);
            output.write(multilinePrefix);
            output.write(line);
            output.write("\n");
          }
        }
        for (const child of this._children) {
          child.printTree(output);
        }
      }
      toString() {
        let out = "";
        this.printTree({
          write: (data) => out += data
        });
        return out;
      }
      add(...children) {
        for (const child of children) {
          child.parent = this;
          this._children.push(child);
        }
      }
      get children() {
        return this._children.map((x) => x);
      }
      get root() {
        return !this.parent;
      }
      get last() {
        if (!this.parent) {
          return true;
        }
        return this.parent.children.indexOf(this) === this.parent.children.length - 1;
      }
      get level() {
        if (!this.parent) {
          return this.text ? 0 : -1;
        }
        return this.parent.level + 1;
      }
      get empty() {
        return this.children.length === 0;
      }
      get ancestors() {
        if (!this.parent) {
          return [];
        }
        return [...this.parent.ancestors, this.parent];
      }
    };
    exports.AsciiTree = AsciiTree;
  }
});

// node_modules/oo-ascii-tree/lib/index.js
var require_lib6 = __commonJS({
  "node_modules/oo-ascii-tree/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_ascii_tree(), exports);
  }
});

// node_modules/jsii-reflect/lib/tree.js
var require_tree = __commonJS({
  "node_modules/jsii-reflect/lib/tree.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TypeSystemTree = void 0;
    var spec_1 = require_lib5();
    var colors = require_safe();
    var oo_ascii_tree_1 = require_lib6();
    var method_1 = require_method();
    var optional_value_1 = require_optional_value();
    var property_1 = require_property();
    var TypeSystemTree = class extends oo_ascii_tree_1.AsciiTree {
      constructor(typesys, options = {}) {
        super();
        if (options.showAll) {
          options.dependencies = true;
          options.inheritance = true;
          options.members = true;
          options.signatures = true;
          options.types = true;
        }
        const shouldUseColors = options.colors === void 0 ? true : options.colors;
        withColors(shouldUseColors, () => {
          if (typesys.assemblies.length > 0) {
            const assemblies = new TitleNode("assemblies");
            assemblies.add(...typesys.assemblies.map((a) => new AssemblyNode(a, options)));
            this.add(assemblies);
          }
        });
      }
    };
    exports.TypeSystemTree = TypeSystemTree;
    var AssemblyNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(assembly, options) {
        super(colors.green(assembly.name));
        if (options.dependencies && assembly.dependencies.length > 0) {
          const deps = new TitleNode("dependencies");
          this.add(deps);
          deps.add(...assembly.dependencies.map((d) => new DependencyNode(d, options)));
        }
        const submodules = assembly.submodules;
        if (submodules.length > 0) {
          const title = new TitleNode("submodules");
          this.add(title);
          title.add(...submodules.map((s) => new SubmoduleNode(s, options)));
        }
        if (options.types) {
          const types = new TitleNode("types");
          this.add(types);
          types.add(...assembly.classes.map((c) => new ClassNode(c, options)));
          types.add(...assembly.interfaces.map((c) => new InterfaceNode(c, options)));
          types.add(...assembly.enums.map((c) => new EnumNode(c, options)));
        }
      }
    };
    var SubmoduleNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(submodule, options) {
        super(colors.green(submodule.name));
        const submodules = submodule.submodules;
        if (submodules.length > 0) {
          const title = new TitleNode("submodules");
          this.add(title);
          title.add(...submodules.map((s) => new SubmoduleNode(s, options)));
        }
        if (options.types) {
          const types = new TitleNode("types");
          this.add(types);
          types.add(...submodule.classes.map((c) => new ClassNode(c, options)));
          types.add(...submodule.interfaces.map((i) => new InterfaceNode(i, options)));
          types.add(...submodule.enums.map((e) => new EnumNode(e, options)));
        }
      }
    };
    var MethodNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(method, options) {
        const args = method.parameters.map((p) => p.name).join(",");
        super(`${maybeStatic(method)}${method.name}(${args}) ${colors.gray("method")}${describeStability(method, options)}`);
        if (options.signatures) {
          if (method.abstract) {
            this.add(new FlagNode("abstract"));
          }
          if (method.protected) {
            this.add(new FlagNode("protected"));
          }
          if (method.static) {
            this.add(new FlagNode("static"));
          }
          if (method.variadic) {
            this.add(new FlagNode("variadic"));
          }
          if (method.parameters.length > 0) {
            const params = new TitleNode("parameters");
            this.add(params);
            params.add(...method.parameters.map((p) => new ParameterNode(p, options)));
          }
          this.add(new OptionalValueNode("returns", method.returns, {
            asPromise: method.async
          }));
        }
      }
    };
    var InitializerNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(initializer, options) {
        const args = initializer.parameters.map((p) => p.name).join(",");
        super(`${initializer.name}(${args}) ${colors.gray("initializer")}${describeStability(initializer, options)}`);
        if (options.signatures) {
          if (initializer.protected) {
            this.add(new FlagNode("protected"));
          }
          if (initializer.variadic) {
            this.add(new FlagNode("variadic"));
          }
          if (initializer.parameters.length > 0) {
            const params = new TitleNode("parameters");
            this.add(params);
            params.add(...initializer.parameters.map((p) => new ParameterNode(p, options)));
          }
        }
      }
    };
    var ParameterNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(param, _options) {
        super(param.name);
        this.add(new OptionalValueNode("type", param));
        if (param.variadic) {
          this.add(new FlagNode("variadic"));
        }
      }
    };
    var PropertyNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(property, options) {
        super(`${maybeStatic(property)}${property.name} ${colors.gray("property")}${describeStability(property, options)}`);
        if (options.signatures) {
          if (property.abstract) {
            this.add(new FlagNode("abstract"));
          }
          if (property.const) {
            this.add(new FlagNode("const"));
          }
          if (property.immutable) {
            this.add(new FlagNode("immutable"));
          }
          if (property.protected) {
            this.add(new FlagNode("protected"));
          }
          if (property.static) {
            this.add(new FlagNode("static"));
          }
          this.add(new OptionalValueNode("type", property));
        }
      }
    };
    var OptionalValueNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(name, optionalValue, { asPromise } = { asPromise: false }) {
        let type = optional_value_1.OptionalValue.describe(optionalValue);
        if (asPromise) {
          type = `Promise<${type}>`;
        }
        super(`${colors.underline(name)}: ${type}`);
      }
    };
    var ClassNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(type, options) {
        super(`${colors.gray("class")} ${colors.cyan(type.name)}${describeStability(type, options)}`);
        if (options.inheritance && type.base) {
          this.add(new KeyValueNode("base", type.base.name));
        }
        if (options.inheritance && type.interfaces.length > 0) {
          this.add(new KeyValueNode("interfaces", type.interfaces.map((i) => i.name).join(",")));
        }
        if (options.members) {
          const members = new TitleNode("members");
          this.add(members);
          if (type.initializer) {
            members.add(new InitializerNode(type.initializer, options));
          }
          members.add(...type.ownMethods.map((m) => new MethodNode(m, options)));
          members.add(...type.ownProperties.map((p) => new PropertyNode(p, options)));
        }
      }
    };
    var InterfaceNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(type, options) {
        super(`${colors.gray("interface")} ${colors.cyan(type.name)}${describeStability(type, options)}`);
        if (options.inheritance && type.interfaces.length > 0) {
          const interfaces = new TitleNode("interfaces");
          this.add(interfaces);
          interfaces.add(...type.interfaces.map((i) => new TextNode(i.name)));
        }
        if (options.members) {
          const members = new TitleNode("members");
          members.add(...type.ownMethods.map((m) => new MethodNode(m, options)));
          members.add(...type.ownProperties.map((p) => new PropertyNode(p, options)));
          this.add(members);
        }
      }
    };
    var EnumNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(enumType, options) {
        super(`${colors.gray("enum")} ${colors.cyan(enumType.name)}${describeStability(enumType, options)}`);
        if (options.members) {
          enumType.members.forEach((mem) => {
            this.add(new oo_ascii_tree_1.AsciiTree(mem.name + describeStability(mem, options)));
          });
        }
      }
    };
    var DependencyNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(dep, _options) {
        super(dep.assembly.name);
      }
    };
    var TitleNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(name, children = []) {
        super(colors.underline(name), ...children);
      }
    };
    var KeyValueNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(key, value) {
        super(`${colors.underline(key)}: ${value}`);
      }
    };
    var TextNode = class extends oo_ascii_tree_1.AsciiTree {
    };
    var FlagNode = class extends oo_ascii_tree_1.AsciiTree {
      constructor(flag) {
        super(colors.italic(flag));
      }
    };
    function withColors(enabled, block) {
      const oldEnabled = colors.enabled;
      try {
        if (enabled) {
          colors.enable();
        } else {
          colors.disable();
        }
        block();
      } finally {
        if (oldEnabled) {
          colors.enable();
        } else {
          colors.disable();
        }
      }
    }
    function describeStability(thing, options) {
      if (!options.stabilities || thing.docs.stability == null) {
        return "";
      }
      switch (thing.docs.stability) {
        case spec_1.Stability.Stable:
          return ` (${colors.green("stable")})`;
        case spec_1.Stability.External:
          return ` (${colors.green("external")})`;
        case spec_1.Stability.Experimental:
          return ` (${colors.yellow("experimental")})`;
        case spec_1.Stability.Deprecated:
          return ` (${colors.red("deprecated")})`;
        default:
          return "";
      }
    }
    function maybeStatic(mem) {
      let isStatic;
      if (mem instanceof property_1.Property) {
        isStatic = !!mem.static;
      }
      if (mem instanceof method_1.Method) {
        isStatic = !!mem.static;
      }
      return isStatic ? `${colors.grey("static")} ` : "";
    }
  }
});

// node_modules/jsii-reflect/lib/type-system.js
var require_type_system = __commonJS({
  "node_modules/jsii-reflect/lib/type-system.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TypeSystem = void 0;
    var jsii = require_lib5();
    var path2 = require("path");
    var util_1 = require("util");
    var assembly_1 = require_assembly2();
    var class_1 = require_class();
    var enum_1 = require_enum();
    var interface_1 = require_interface();
    var TypeSystem = class {
      constructor() {
        this.assemblies = new Array();
        this.roots = new Array();
        this._assemblyLookup = {};
      }
      async loadNpmDependencies(packageRoot, options = {}) {
        const pkg = require(path2.resolve(packageRoot, "package.json"));
        for (const dep of dependenciesOf(pkg)) {
          const depPkgJsonPath = require.resolve(`${dep}/package.json`, {
            paths: [packageRoot]
          });
          const depPkgJson = require(depPkgJsonPath);
          if (!depPkgJson.jsii) {
            continue;
          }
          await this.loadModule(path2.dirname(depPkgJsonPath), options);
        }
      }
      async load(fileOrDirectory, options = {}) {
        if ((await stat(fileOrDirectory)).isDirectory()) {
          return this.loadModule(fileOrDirectory, options);
        }
        return this.loadFile(fileOrDirectory, __spreadProps(__spreadValues({}, options), { isRoot: true }));
      }
      async loadModule(dir, options = {}) {
        const out = await _loadModule.call(this, dir, true);
        if (!out) {
          throw new Error(`Unable to load module from directory: ${dir}`);
        }
        return out;
        async function _loadModule(moduleDirectory, isRoot = false) {
          const filePath = path2.join(moduleDirectory, "package.json");
          const pkg = JSON.parse((await readFile(filePath)).toString());
          if (!pkg.jsii) {
            throw new Error(`No "jsii" section in ${filePath}`);
          }
          const asm = await this.loadAssembly(path2.join(moduleDirectory, ".jsii"), false);
          if (this.includesAssembly(asm.name)) {
            const existing = this.findAssembly(asm.name);
            if (existing.version !== asm.version) {
              throw new Error(`Conflicting versions of ${asm.name} in type system: previously loaded ${existing.version}, trying to load ${asm.version}`);
            }
            if (isRoot) {
              this.addRoot(asm);
            }
            return existing;
          }
          if (options.validate !== false) {
            asm.validate();
          }
          const root = this.addAssembly(asm, { isRoot });
          const bundled = pkg.bundledDependencies || pkg.bundleDependencies || [];
          for (const name of dependenciesOf(pkg)) {
            if (bundled.includes(name)) {
              continue;
            }
            const depDir = require.resolve(`${name}/package.json`, {
              paths: [moduleDirectory]
            });
            await _loadModule.call(this, path2.dirname(depDir));
          }
          return root;
        }
      }
      async loadFile(file, options = {}) {
        const assembly = await this.loadAssembly(file, options.validate !== false);
        return this.addAssembly(assembly, options);
      }
      addAssembly(asm, options = {}) {
        if (asm.system !== this) {
          throw new Error("Assembly has been created for different typesystem");
        }
        if (!this._assemblyLookup[asm.name]) {
          this._assemblyLookup[asm.name] = asm;
          this.assemblies.push(asm);
        }
        if (options.isRoot !== false) {
          this.addRoot(asm);
        }
        return asm;
      }
      includesAssembly(name) {
        return name in this._assemblyLookup;
      }
      isRoot(name) {
        return this.roots.map((r) => r.name).includes(name);
      }
      findAssembly(name) {
        const ret = this.tryFindAssembly(name);
        if (!ret) {
          throw new Error(`Assembly "${name}" not found`);
        }
        return ret;
      }
      tryFindAssembly(name) {
        return this._assemblyLookup[name];
      }
      findFqn(fqn) {
        const [assembly] = fqn.split(".");
        const asm = this.findAssembly(assembly);
        return asm.findType(fqn);
      }
      tryFindFqn(fqn) {
        const [assembly] = fqn.split(".");
        const asm = this.tryFindAssembly(assembly);
        return asm === null || asm === void 0 ? void 0 : asm.tryFindType(fqn);
      }
      findClass(fqn) {
        const type = this.findFqn(fqn);
        if (!(type instanceof class_1.ClassType)) {
          throw new Error(`FQN ${fqn} is not a class`);
        }
        return type;
      }
      findInterface(fqn) {
        const type = this.findFqn(fqn);
        if (!(type instanceof interface_1.InterfaceType)) {
          throw new Error(`FQN ${fqn} is not an interface`);
        }
        return type;
      }
      findEnum(fqn) {
        const type = this.findFqn(fqn);
        if (!(type instanceof enum_1.EnumType)) {
          throw new Error(`FQN ${fqn} is not an enum`);
        }
        return type;
      }
      get methods() {
        const getMethods = (mod) => {
          return [
            ...flatMap(mod.submodules, getMethods),
            ...flatMap(mod.interfaces, (iface) => iface.ownMethods),
            ...flatMap(mod.classes, (clazz) => clazz.ownMethods)
          ];
        };
        return flatMap(this.assemblies, getMethods);
      }
      get properties() {
        const getProperties = (mod) => {
          return [
            ...flatMap(mod.submodules, getProperties),
            ...flatMap(mod.interfaces, (iface) => iface.ownProperties),
            ...flatMap(mod.classes, (clazz) => clazz.ownProperties)
          ];
        };
        return flatMap(this.assemblies, getProperties);
      }
      get classes() {
        const out = new Array();
        this.assemblies.forEach((a) => {
          out.push(...collectTypes(a, (item) => item.classes));
        });
        return out;
      }
      get interfaces() {
        const out = new Array();
        this.assemblies.forEach((a) => {
          out.push(...collectTypes(a, (item) => item.interfaces));
        });
        return out;
      }
      get enums() {
        const out = new Array();
        this.assemblies.forEach((a) => {
          out.push(...collectTypes(a, (item) => item.enums));
        });
        return out;
      }
      async loadAssembly(file, validate = true) {
        const spec = JSON.parse((await readFile(file)).toString());
        const ass = validate ? jsii.validateAssembly(spec) : spec;
        return new assembly_1.Assembly(this, ass);
      }
      addRoot(asm) {
        if (!this.roots.map((r) => r.name).includes(asm.name)) {
          this.roots.push(asm);
        }
      }
    };
    exports.TypeSystem = TypeSystem;
    function dependenciesOf(packageJson) {
      var _a, _b;
      const deps = new Set();
      Object.keys((_a = packageJson.dependencies) !== null && _a !== void 0 ? _a : {}).forEach(deps.add.bind(deps));
      Object.keys((_b = packageJson.peerDependencies) !== null && _b !== void 0 ? _b : {}).forEach(deps.add.bind(deps));
      return Array.from(deps);
    }
    function collectTypes(module3, getter) {
      const result = new Array();
      for (const submodule of module3.submodules) {
        result.push(...collectTypes(submodule, getter));
      }
      result.push(...getter(module3));
      return result;
    }
    function flatMap(collection, mapper) {
      return collection.map(mapper).reduce((acc, elt) => acc.concat(elt), new Array());
    }
    function stat(p) {
      const fs2 = require("fs");
      return util_1.promisify(fs2.stat)(p);
    }
    function readFile(p) {
      const fs2 = require("fs");
      return util_1.promisify(fs2.readFile)(p);
    }
  }
});

// node_modules/jsii-reflect/lib/index.js
var require_lib7 = __commonJS({
  "node_modules/jsii-reflect/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_assembly2(), exports);
    __exportStar(require_class(), exports);
    __exportStar(require_callable(), exports);
    __exportStar(require_dependency(), exports);
    __exportStar(require_docs(), exports);
    __exportStar(require_enum(), exports);
    __exportStar(require_initializer(), exports);
    __exportStar(require_interface(), exports);
    __exportStar(require_method(), exports);
    __exportStar(require_module_like(), exports);
    __exportStar(require_optional_value(), exports);
    __exportStar(require_overridable(), exports);
    __exportStar(require_parameter(), exports);
    __exportStar(require_property(), exports);
    __exportStar(require_submodule(), exports);
    __exportStar(require_tree(), exports);
    __exportStar(require_type(), exports);
    __exportStar(require_type_member(), exports);
    __exportStar(require_type_ref(), exports);
    __exportStar(require_type_system(), exports);
    __exportStar(require_reference_type(), exports);
    __exportStar(require_source(), exports);
  }
});

// node_modules/source-map/lib/base64.js
var require_base64 = __commonJS({
  "node_modules/source-map/lib/base64.js"(exports) {
    var intToCharMap = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");
    exports.encode = function(number) {
      if (0 <= number && number < intToCharMap.length) {
        return intToCharMap[number];
      }
      throw new TypeError("Must be between 0 and 63: " + number);
    };
    exports.decode = function(charCode) {
      var bigA = 65;
      var bigZ = 90;
      var littleA = 97;
      var littleZ = 122;
      var zero = 48;
      var nine = 57;
      var plus = 43;
      var slash = 47;
      var littleOffset = 26;
      var numberOffset = 52;
      if (bigA <= charCode && charCode <= bigZ) {
        return charCode - bigA;
      }
      if (littleA <= charCode && charCode <= littleZ) {
        return charCode - littleA + littleOffset;
      }
      if (zero <= charCode && charCode <= nine) {
        return charCode - zero + numberOffset;
      }
      if (charCode == plus) {
        return 62;
      }
      if (charCode == slash) {
        return 63;
      }
      return -1;
    };
  }
});

// node_modules/source-map/lib/base64-vlq.js
var require_base64_vlq = __commonJS({
  "node_modules/source-map/lib/base64-vlq.js"(exports) {
    var base64 = require_base64();
    var VLQ_BASE_SHIFT = 5;
    var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
    var VLQ_BASE_MASK = VLQ_BASE - 1;
    var VLQ_CONTINUATION_BIT = VLQ_BASE;
    function toVLQSigned(aValue) {
      return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
    }
    function fromVLQSigned(aValue) {
      var isNegative = (aValue & 1) === 1;
      var shifted = aValue >> 1;
      return isNegative ? -shifted : shifted;
    }
    exports.encode = function base64VLQ_encode(aValue) {
      var encoded = "";
      var digit;
      var vlq = toVLQSigned(aValue);
      do {
        digit = vlq & VLQ_BASE_MASK;
        vlq >>>= VLQ_BASE_SHIFT;
        if (vlq > 0) {
          digit |= VLQ_CONTINUATION_BIT;
        }
        encoded += base64.encode(digit);
      } while (vlq > 0);
      return encoded;
    };
    exports.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
      var strLen = aStr.length;
      var result = 0;
      var shift = 0;
      var continuation, digit;
      do {
        if (aIndex >= strLen) {
          throw new Error("Expected more digits in base 64 VLQ value.");
        }
        digit = base64.decode(aStr.charCodeAt(aIndex++));
        if (digit === -1) {
          throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
        }
        continuation = !!(digit & VLQ_CONTINUATION_BIT);
        digit &= VLQ_BASE_MASK;
        result = result + (digit << shift);
        shift += VLQ_BASE_SHIFT;
      } while (continuation);
      aOutParam.value = fromVLQSigned(result);
      aOutParam.rest = aIndex;
    };
  }
});

// node_modules/source-map/lib/util.js
var require_util2 = __commonJS({
  "node_modules/source-map/lib/util.js"(exports) {
    function getArg(aArgs, aName, aDefaultValue) {
      if (aName in aArgs) {
        return aArgs[aName];
      } else if (arguments.length === 3) {
        return aDefaultValue;
      } else {
        throw new Error('"' + aName + '" is a required argument.');
      }
    }
    exports.getArg = getArg;
    var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
    var dataUrlRegexp = /^data:.+\,.+$/;
    function urlParse(aUrl) {
      var match = aUrl.match(urlRegexp);
      if (!match) {
        return null;
      }
      return {
        scheme: match[1],
        auth: match[2],
        host: match[3],
        port: match[4],
        path: match[5]
      };
    }
    exports.urlParse = urlParse;
    function urlGenerate(aParsedUrl) {
      var url = "";
      if (aParsedUrl.scheme) {
        url += aParsedUrl.scheme + ":";
      }
      url += "//";
      if (aParsedUrl.auth) {
        url += aParsedUrl.auth + "@";
      }
      if (aParsedUrl.host) {
        url += aParsedUrl.host;
      }
      if (aParsedUrl.port) {
        url += ":" + aParsedUrl.port;
      }
      if (aParsedUrl.path) {
        url += aParsedUrl.path;
      }
      return url;
    }
    exports.urlGenerate = urlGenerate;
    function normalize(aPath) {
      var path2 = aPath;
      var url = urlParse(aPath);
      if (url) {
        if (!url.path) {
          return aPath;
        }
        path2 = url.path;
      }
      var isAbsolute = exports.isAbsolute(path2);
      var parts = path2.split(/\/+/);
      for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
        part = parts[i];
        if (part === ".") {
          parts.splice(i, 1);
        } else if (part === "..") {
          up++;
        } else if (up > 0) {
          if (part === "") {
            parts.splice(i + 1, up);
            up = 0;
          } else {
            parts.splice(i, 2);
            up--;
          }
        }
      }
      path2 = parts.join("/");
      if (path2 === "") {
        path2 = isAbsolute ? "/" : ".";
      }
      if (url) {
        url.path = path2;
        return urlGenerate(url);
      }
      return path2;
    }
    exports.normalize = normalize;
    function join2(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      if (aPath === "") {
        aPath = ".";
      }
      var aPathUrl = urlParse(aPath);
      var aRootUrl = urlParse(aRoot);
      if (aRootUrl) {
        aRoot = aRootUrl.path || "/";
      }
      if (aPathUrl && !aPathUrl.scheme) {
        if (aRootUrl) {
          aPathUrl.scheme = aRootUrl.scheme;
        }
        return urlGenerate(aPathUrl);
      }
      if (aPathUrl || aPath.match(dataUrlRegexp)) {
        return aPath;
      }
      if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
        aRootUrl.host = aPath;
        return urlGenerate(aRootUrl);
      }
      var joined = aPath.charAt(0) === "/" ? aPath : normalize(aRoot.replace(/\/+$/, "") + "/" + aPath);
      if (aRootUrl) {
        aRootUrl.path = joined;
        return urlGenerate(aRootUrl);
      }
      return joined;
    }
    exports.join = join2;
    exports.isAbsolute = function(aPath) {
      return aPath.charAt(0) === "/" || urlRegexp.test(aPath);
    };
    function relative(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      aRoot = aRoot.replace(/\/$/, "");
      var level = 0;
      while (aPath.indexOf(aRoot + "/") !== 0) {
        var index = aRoot.lastIndexOf("/");
        if (index < 0) {
          return aPath;
        }
        aRoot = aRoot.slice(0, index);
        if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
          return aPath;
        }
        ++level;
      }
      return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
    }
    exports.relative = relative;
    var supportsNullProto = function() {
      var obj = Object.create(null);
      return !("__proto__" in obj);
    }();
    function identity(s) {
      return s;
    }
    function toSetString(aStr) {
      if (isProtoString(aStr)) {
        return "$" + aStr;
      }
      return aStr;
    }
    exports.toSetString = supportsNullProto ? identity : toSetString;
    function fromSetString(aStr) {
      if (isProtoString(aStr)) {
        return aStr.slice(1);
      }
      return aStr;
    }
    exports.fromSetString = supportsNullProto ? identity : fromSetString;
    function isProtoString(s) {
      if (!s) {
        return false;
      }
      var length = s.length;
      if (length < 9) {
        return false;
      }
      if (s.charCodeAt(length - 1) !== 95 || s.charCodeAt(length - 2) !== 95 || s.charCodeAt(length - 3) !== 111 || s.charCodeAt(length - 4) !== 116 || s.charCodeAt(length - 5) !== 111 || s.charCodeAt(length - 6) !== 114 || s.charCodeAt(length - 7) !== 112 || s.charCodeAt(length - 8) !== 95 || s.charCodeAt(length - 9) !== 95) {
        return false;
      }
      for (var i = length - 10; i >= 0; i--) {
        if (s.charCodeAt(i) !== 36) {
          return false;
        }
      }
      return true;
    }
    function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
      var cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0 || onlyCompareOriginal) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports.compareByOriginalPositions = compareByOriginalPositions;
    function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0 || onlyCompareGenerated) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;
    function strcmp(aStr1, aStr2) {
      if (aStr1 === aStr2) {
        return 0;
      }
      if (aStr1 === null) {
        return 1;
      }
      if (aStr2 === null) {
        return -1;
      }
      if (aStr1 > aStr2) {
        return 1;
      }
      return -1;
    }
    function compareByGeneratedPositionsInflated(mappingA, mappingB) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
    function parseSourceMapInput(str) {
      return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ""));
    }
    exports.parseSourceMapInput = parseSourceMapInput;
    function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
      sourceURL = sourceURL || "";
      if (sourceRoot) {
        if (sourceRoot[sourceRoot.length - 1] !== "/" && sourceURL[0] !== "/") {
          sourceRoot += "/";
        }
        sourceURL = sourceRoot + sourceURL;
      }
      if (sourceMapURL) {
        var parsed = urlParse(sourceMapURL);
        if (!parsed) {
          throw new Error("sourceMapURL could not be parsed");
        }
        if (parsed.path) {
          var index = parsed.path.lastIndexOf("/");
          if (index >= 0) {
            parsed.path = parsed.path.substring(0, index + 1);
          }
        }
        sourceURL = join2(urlGenerate(parsed), sourceURL);
      }
      return normalize(sourceURL);
    }
    exports.computeSourceURL = computeSourceURL;
  }
});

// node_modules/source-map/lib/array-set.js
var require_array_set = __commonJS({
  "node_modules/source-map/lib/array-set.js"(exports) {
    var util = require_util2();
    var has = Object.prototype.hasOwnProperty;
    var hasNativeMap = typeof Map !== "undefined";
    function ArraySet() {
      this._array = [];
      this._set = hasNativeMap ? new Map() : Object.create(null);
    }
    ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
      var set = new ArraySet();
      for (var i = 0, len = aArray.length; i < len; i++) {
        set.add(aArray[i], aAllowDuplicates);
      }
      return set;
    };
    ArraySet.prototype.size = function ArraySet_size() {
      return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
    };
    ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
      var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
      var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
      var idx = this._array.length;
      if (!isDuplicate || aAllowDuplicates) {
        this._array.push(aStr);
      }
      if (!isDuplicate) {
        if (hasNativeMap) {
          this._set.set(aStr, idx);
        } else {
          this._set[sStr] = idx;
        }
      }
    };
    ArraySet.prototype.has = function ArraySet_has(aStr) {
      if (hasNativeMap) {
        return this._set.has(aStr);
      } else {
        var sStr = util.toSetString(aStr);
        return has.call(this._set, sStr);
      }
    };
    ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
      if (hasNativeMap) {
        var idx = this._set.get(aStr);
        if (idx >= 0) {
          return idx;
        }
      } else {
        var sStr = util.toSetString(aStr);
        if (has.call(this._set, sStr)) {
          return this._set[sStr];
        }
      }
      throw new Error('"' + aStr + '" is not in the set.');
    };
    ArraySet.prototype.at = function ArraySet_at(aIdx) {
      if (aIdx >= 0 && aIdx < this._array.length) {
        return this._array[aIdx];
      }
      throw new Error("No element indexed by " + aIdx);
    };
    ArraySet.prototype.toArray = function ArraySet_toArray() {
      return this._array.slice();
    };
    exports.ArraySet = ArraySet;
  }
});

// node_modules/source-map/lib/mapping-list.js
var require_mapping_list = __commonJS({
  "node_modules/source-map/lib/mapping-list.js"(exports) {
    var util = require_util2();
    function generatedPositionAfter(mappingA, mappingB) {
      var lineA = mappingA.generatedLine;
      var lineB = mappingB.generatedLine;
      var columnA = mappingA.generatedColumn;
      var columnB = mappingB.generatedColumn;
      return lineB > lineA || lineB == lineA && columnB >= columnA || util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
    }
    function MappingList() {
      this._array = [];
      this._sorted = true;
      this._last = { generatedLine: -1, generatedColumn: 0 };
    }
    MappingList.prototype.unsortedForEach = function MappingList_forEach(aCallback, aThisArg) {
      this._array.forEach(aCallback, aThisArg);
    };
    MappingList.prototype.add = function MappingList_add(aMapping) {
      if (generatedPositionAfter(this._last, aMapping)) {
        this._last = aMapping;
        this._array.push(aMapping);
      } else {
        this._sorted = false;
        this._array.push(aMapping);
      }
    };
    MappingList.prototype.toArray = function MappingList_toArray() {
      if (!this._sorted) {
        this._array.sort(util.compareByGeneratedPositionsInflated);
        this._sorted = true;
      }
      return this._array;
    };
    exports.MappingList = MappingList;
  }
});

// node_modules/source-map/lib/source-map-generator.js
var require_source_map_generator = __commonJS({
  "node_modules/source-map/lib/source-map-generator.js"(exports) {
    var base64VLQ = require_base64_vlq();
    var util = require_util2();
    var ArraySet = require_array_set().ArraySet;
    var MappingList = require_mapping_list().MappingList;
    function SourceMapGenerator(aArgs) {
      if (!aArgs) {
        aArgs = {};
      }
      this._file = util.getArg(aArgs, "file", null);
      this._sourceRoot = util.getArg(aArgs, "sourceRoot", null);
      this._skipValidation = util.getArg(aArgs, "skipValidation", false);
      this._sources = new ArraySet();
      this._names = new ArraySet();
      this._mappings = new MappingList();
      this._sourcesContents = null;
    }
    SourceMapGenerator.prototype._version = 3;
    SourceMapGenerator.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
      var sourceRoot = aSourceMapConsumer.sourceRoot;
      var generator = new SourceMapGenerator({
        file: aSourceMapConsumer.file,
        sourceRoot
      });
      aSourceMapConsumer.eachMapping(function(mapping) {
        var newMapping = {
          generated: {
            line: mapping.generatedLine,
            column: mapping.generatedColumn
          }
        };
        if (mapping.source != null) {
          newMapping.source = mapping.source;
          if (sourceRoot != null) {
            newMapping.source = util.relative(sourceRoot, newMapping.source);
          }
          newMapping.original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };
          if (mapping.name != null) {
            newMapping.name = mapping.name;
          }
        }
        generator.addMapping(newMapping);
      });
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var sourceRelative = sourceFile;
        if (sourceRoot !== null) {
          sourceRelative = util.relative(sourceRoot, sourceFile);
        }
        if (!generator._sources.has(sourceRelative)) {
          generator._sources.add(sourceRelative);
        }
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          generator.setSourceContent(sourceFile, content);
        }
      });
      return generator;
    };
    SourceMapGenerator.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
      var generated = util.getArg(aArgs, "generated");
      var original = util.getArg(aArgs, "original", null);
      var source = util.getArg(aArgs, "source", null);
      var name = util.getArg(aArgs, "name", null);
      if (!this._skipValidation) {
        this._validateMapping(generated, original, source, name);
      }
      if (source != null) {
        source = String(source);
        if (!this._sources.has(source)) {
          this._sources.add(source);
        }
      }
      if (name != null) {
        name = String(name);
        if (!this._names.has(name)) {
          this._names.add(name);
        }
      }
      this._mappings.add({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source,
        name
      });
    };
    SourceMapGenerator.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
      var source = aSourceFile;
      if (this._sourceRoot != null) {
        source = util.relative(this._sourceRoot, source);
      }
      if (aSourceContent != null) {
        if (!this._sourcesContents) {
          this._sourcesContents = Object.create(null);
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
      } else if (this._sourcesContents) {
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
          this._sourcesContents = null;
        }
      }
    };
    SourceMapGenerator.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
      var sourceFile = aSourceFile;
      if (aSourceFile == null) {
        if (aSourceMapConsumer.file == null) {
          throw new Error(`SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's "file" property. Both were omitted.`);
        }
        sourceFile = aSourceMapConsumer.file;
      }
      var sourceRoot = this._sourceRoot;
      if (sourceRoot != null) {
        sourceFile = util.relative(sourceRoot, sourceFile);
      }
      var newSources = new ArraySet();
      var newNames = new ArraySet();
      this._mappings.unsortedForEach(function(mapping) {
        if (mapping.source === sourceFile && mapping.originalLine != null) {
          var original = aSourceMapConsumer.originalPositionFor({
            line: mapping.originalLine,
            column: mapping.originalColumn
          });
          if (original.source != null) {
            mapping.source = original.source;
            if (aSourceMapPath != null) {
              mapping.source = util.join(aSourceMapPath, mapping.source);
            }
            if (sourceRoot != null) {
              mapping.source = util.relative(sourceRoot, mapping.source);
            }
            mapping.originalLine = original.line;
            mapping.originalColumn = original.column;
            if (original.name != null) {
              mapping.name = original.name;
            }
          }
        }
        var source = mapping.source;
        if (source != null && !newSources.has(source)) {
          newSources.add(source);
        }
        var name = mapping.name;
        if (name != null && !newNames.has(name)) {
          newNames.add(name);
        }
      }, this);
      this._sources = newSources;
      this._names = newNames;
      aSourceMapConsumer.sources.forEach(function(sourceFile2) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile2);
        if (content != null) {
          if (aSourceMapPath != null) {
            sourceFile2 = util.join(aSourceMapPath, sourceFile2);
          }
          if (sourceRoot != null) {
            sourceFile2 = util.relative(sourceRoot, sourceFile2);
          }
          this.setSourceContent(sourceFile2, content);
        }
      }, this);
    };
    SourceMapGenerator.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
      if (aOriginal && typeof aOriginal.line !== "number" && typeof aOriginal.column !== "number") {
        throw new Error("original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values.");
      }
      if (aGenerated && "line" in aGenerated && "column" in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) {
        return;
      } else if (aGenerated && "line" in aGenerated && "column" in aGenerated && aOriginal && "line" in aOriginal && "column" in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) {
        return;
      } else {
        throw new Error("Invalid mapping: " + JSON.stringify({
          generated: aGenerated,
          source: aSource,
          original: aOriginal,
          name: aName
        }));
      }
    };
    SourceMapGenerator.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
      var previousGeneratedColumn = 0;
      var previousGeneratedLine = 1;
      var previousOriginalColumn = 0;
      var previousOriginalLine = 0;
      var previousName = 0;
      var previousSource = 0;
      var result = "";
      var next;
      var mapping;
      var nameIdx;
      var sourceIdx;
      var mappings = this._mappings.toArray();
      for (var i = 0, len = mappings.length; i < len; i++) {
        mapping = mappings[i];
        next = "";
        if (mapping.generatedLine !== previousGeneratedLine) {
          previousGeneratedColumn = 0;
          while (mapping.generatedLine !== previousGeneratedLine) {
            next += ";";
            previousGeneratedLine++;
          }
        } else {
          if (i > 0) {
            if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
              continue;
            }
            next += ",";
          }
        }
        next += base64VLQ.encode(mapping.generatedColumn - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;
        if (mapping.source != null) {
          sourceIdx = this._sources.indexOf(mapping.source);
          next += base64VLQ.encode(sourceIdx - previousSource);
          previousSource = sourceIdx;
          next += base64VLQ.encode(mapping.originalLine - 1 - previousOriginalLine);
          previousOriginalLine = mapping.originalLine - 1;
          next += base64VLQ.encode(mapping.originalColumn - previousOriginalColumn);
          previousOriginalColumn = mapping.originalColumn;
          if (mapping.name != null) {
            nameIdx = this._names.indexOf(mapping.name);
            next += base64VLQ.encode(nameIdx - previousName);
            previousName = nameIdx;
          }
        }
        result += next;
      }
      return result;
    };
    SourceMapGenerator.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
      return aSources.map(function(source) {
        if (!this._sourcesContents) {
          return null;
        }
        if (aSourceRoot != null) {
          source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
      }, this);
    };
    SourceMapGenerator.prototype.toJSON = function SourceMapGenerator_toJSON() {
      var map = {
        version: this._version,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
      };
      if (this._file != null) {
        map.file = this._file;
      }
      if (this._sourceRoot != null) {
        map.sourceRoot = this._sourceRoot;
      }
      if (this._sourcesContents) {
        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
      }
      return map;
    };
    SourceMapGenerator.prototype.toString = function SourceMapGenerator_toString() {
      return JSON.stringify(this.toJSON());
    };
    exports.SourceMapGenerator = SourceMapGenerator;
  }
});

// node_modules/source-map/lib/binary-search.js
var require_binary_search = __commonJS({
  "node_modules/source-map/lib/binary-search.js"(exports) {
    exports.GREATEST_LOWER_BOUND = 1;
    exports.LEAST_UPPER_BOUND = 2;
    function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
      var mid = Math.floor((aHigh - aLow) / 2) + aLow;
      var cmp = aCompare(aNeedle, aHaystack[mid], true);
      if (cmp === 0) {
        return mid;
      } else if (cmp > 0) {
        if (aHigh - mid > 1) {
          return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports.LEAST_UPPER_BOUND) {
          return aHigh < aHaystack.length ? aHigh : -1;
        } else {
          return mid;
        }
      } else {
        if (mid - aLow > 1) {
          return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports.LEAST_UPPER_BOUND) {
          return mid;
        } else {
          return aLow < 0 ? -1 : aLow;
        }
      }
    }
    exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
      if (aHaystack.length === 0) {
        return -1;
      }
      var index = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack, aCompare, aBias || exports.GREATEST_LOWER_BOUND);
      if (index < 0) {
        return -1;
      }
      while (index - 1 >= 0) {
        if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
          break;
        }
        --index;
      }
      return index;
    };
  }
});

// node_modules/source-map/lib/quick-sort.js
var require_quick_sort = __commonJS({
  "node_modules/source-map/lib/quick-sort.js"(exports) {
    function swap(ary, x, y) {
      var temp = ary[x];
      ary[x] = ary[y];
      ary[y] = temp;
    }
    function randomIntInRange(low, high) {
      return Math.round(low + Math.random() * (high - low));
    }
    function doQuickSort(ary, comparator, p, r) {
      if (p < r) {
        var pivotIndex = randomIntInRange(p, r);
        var i = p - 1;
        swap(ary, pivotIndex, r);
        var pivot = ary[r];
        for (var j = p; j < r; j++) {
          if (comparator(ary[j], pivot) <= 0) {
            i += 1;
            swap(ary, i, j);
          }
        }
        swap(ary, i + 1, j);
        var q = i + 1;
        doQuickSort(ary, comparator, p, q - 1);
        doQuickSort(ary, comparator, q + 1, r);
      }
    }
    exports.quickSort = function(ary, comparator) {
      doQuickSort(ary, comparator, 0, ary.length - 1);
    };
  }
});

// node_modules/source-map/lib/source-map-consumer.js
var require_source_map_consumer = __commonJS({
  "node_modules/source-map/lib/source-map-consumer.js"(exports) {
    var util = require_util2();
    var binarySearch = require_binary_search();
    var ArraySet = require_array_set().ArraySet;
    var base64VLQ = require_base64_vlq();
    var quickSort = require_quick_sort().quickSort;
    function SourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      return sourceMap.sections != null ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL) : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
    }
    SourceMapConsumer.fromSourceMap = function(aSourceMap, aSourceMapURL) {
      return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
    };
    SourceMapConsumer.prototype._version = 3;
    SourceMapConsumer.prototype.__generatedMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, "_generatedMappings", {
      configurable: true,
      enumerable: true,
      get: function() {
        if (!this.__generatedMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__generatedMappings;
      }
    });
    SourceMapConsumer.prototype.__originalMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, "_originalMappings", {
      configurable: true,
      enumerable: true,
      get: function() {
        if (!this.__originalMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__originalMappings;
      }
    });
    SourceMapConsumer.prototype._charIsMappingSeparator = function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
      var c = aStr.charAt(index);
      return c === ";" || c === ",";
    };
    SourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      throw new Error("Subclasses must implement _parseMappings");
    };
    SourceMapConsumer.GENERATED_ORDER = 1;
    SourceMapConsumer.ORIGINAL_ORDER = 2;
    SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
    SourceMapConsumer.LEAST_UPPER_BOUND = 2;
    SourceMapConsumer.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
      var context = aContext || null;
      var order = aOrder || SourceMapConsumer.GENERATED_ORDER;
      var mappings;
      switch (order) {
        case SourceMapConsumer.GENERATED_ORDER:
          mappings = this._generatedMappings;
          break;
        case SourceMapConsumer.ORIGINAL_ORDER:
          mappings = this._originalMappings;
          break;
        default:
          throw new Error("Unknown order of iteration.");
      }
      var sourceRoot = this.sourceRoot;
      mappings.map(function(mapping) {
        var source = mapping.source === null ? null : this._sources.at(mapping.source);
        source = util.computeSourceURL(sourceRoot, source, this._sourceMapURL);
        return {
          source,
          generatedLine: mapping.generatedLine,
          generatedColumn: mapping.generatedColumn,
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: mapping.name === null ? null : this._names.at(mapping.name)
        };
      }, this).forEach(aCallback, context);
    };
    SourceMapConsumer.prototype.allGeneratedPositionsFor = function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
      var line = util.getArg(aArgs, "line");
      var needle = {
        source: util.getArg(aArgs, "source"),
        originalLine: line,
        originalColumn: util.getArg(aArgs, "column", 0)
      };
      needle.source = this._findSourceIndex(needle.source);
      if (needle.source < 0) {
        return [];
      }
      var mappings = [];
      var index = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util.compareByOriginalPositions, binarySearch.LEAST_UPPER_BOUND);
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (aArgs.column === void 0) {
          var originalLine = mapping.originalLine;
          while (mapping && mapping.originalLine === originalLine) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index];
          }
        } else {
          var originalColumn = mapping.originalColumn;
          while (mapping && mapping.originalLine === line && mapping.originalColumn == originalColumn) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index];
          }
        }
      }
      return mappings;
    };
    exports.SourceMapConsumer = SourceMapConsumer;
    function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      var version = util.getArg(sourceMap, "version");
      var sources = util.getArg(sourceMap, "sources");
      var names = util.getArg(sourceMap, "names", []);
      var sourceRoot = util.getArg(sourceMap, "sourceRoot", null);
      var sourcesContent = util.getArg(sourceMap, "sourcesContent", null);
      var mappings = util.getArg(sourceMap, "mappings");
      var file = util.getArg(sourceMap, "file", null);
      if (version != this._version) {
        throw new Error("Unsupported version: " + version);
      }
      if (sourceRoot) {
        sourceRoot = util.normalize(sourceRoot);
      }
      sources = sources.map(String).map(util.normalize).map(function(source) {
        return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source) ? util.relative(sourceRoot, source) : source;
      });
      this._names = ArraySet.fromArray(names.map(String), true);
      this._sources = ArraySet.fromArray(sources, true);
      this._absoluteSources = this._sources.toArray().map(function(s) {
        return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
      });
      this.sourceRoot = sourceRoot;
      this.sourcesContent = sourcesContent;
      this._mappings = mappings;
      this._sourceMapURL = aSourceMapURL;
      this.file = file;
    }
    BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;
    BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }
      if (this._sources.has(relativeSource)) {
        return this._sources.indexOf(relativeSource);
      }
      var i;
      for (i = 0; i < this._absoluteSources.length; ++i) {
        if (this._absoluteSources[i] == aSource) {
          return i;
        }
      }
      return -1;
    };
    BasicSourceMapConsumer.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
      var smc = Object.create(BasicSourceMapConsumer.prototype);
      var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
      var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
      smc.sourceRoot = aSourceMap._sourceRoot;
      smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(), smc.sourceRoot);
      smc.file = aSourceMap._file;
      smc._sourceMapURL = aSourceMapURL;
      smc._absoluteSources = smc._sources.toArray().map(function(s) {
        return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
      });
      var generatedMappings = aSourceMap._mappings.toArray().slice();
      var destGeneratedMappings = smc.__generatedMappings = [];
      var destOriginalMappings = smc.__originalMappings = [];
      for (var i = 0, length = generatedMappings.length; i < length; i++) {
        var srcMapping = generatedMappings[i];
        var destMapping = new Mapping();
        destMapping.generatedLine = srcMapping.generatedLine;
        destMapping.generatedColumn = srcMapping.generatedColumn;
        if (srcMapping.source) {
          destMapping.source = sources.indexOf(srcMapping.source);
          destMapping.originalLine = srcMapping.originalLine;
          destMapping.originalColumn = srcMapping.originalColumn;
          if (srcMapping.name) {
            destMapping.name = names.indexOf(srcMapping.name);
          }
          destOriginalMappings.push(destMapping);
        }
        destGeneratedMappings.push(destMapping);
      }
      quickSort(smc.__originalMappings, util.compareByOriginalPositions);
      return smc;
    };
    BasicSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(BasicSourceMapConsumer.prototype, "sources", {
      get: function() {
        return this._absoluteSources.slice();
      }
    });
    function Mapping() {
      this.generatedLine = 0;
      this.generatedColumn = 0;
      this.source = null;
      this.originalLine = null;
      this.originalColumn = null;
      this.name = null;
    }
    BasicSourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      var generatedLine = 1;
      var previousGeneratedColumn = 0;
      var previousOriginalLine = 0;
      var previousOriginalColumn = 0;
      var previousSource = 0;
      var previousName = 0;
      var length = aStr.length;
      var index = 0;
      var cachedSegments = {};
      var temp = {};
      var originalMappings = [];
      var generatedMappings = [];
      var mapping, str, segment, end, value;
      while (index < length) {
        if (aStr.charAt(index) === ";") {
          generatedLine++;
          index++;
          previousGeneratedColumn = 0;
        } else if (aStr.charAt(index) === ",") {
          index++;
        } else {
          mapping = new Mapping();
          mapping.generatedLine = generatedLine;
          for (end = index; end < length; end++) {
            if (this._charIsMappingSeparator(aStr, end)) {
              break;
            }
          }
          str = aStr.slice(index, end);
          segment = cachedSegments[str];
          if (segment) {
            index += str.length;
          } else {
            segment = [];
            while (index < end) {
              base64VLQ.decode(aStr, index, temp);
              value = temp.value;
              index = temp.rest;
              segment.push(value);
            }
            if (segment.length === 2) {
              throw new Error("Found a source, but no line and column");
            }
            if (segment.length === 3) {
              throw new Error("Found a source and line, but no column");
            }
            cachedSegments[str] = segment;
          }
          mapping.generatedColumn = previousGeneratedColumn + segment[0];
          previousGeneratedColumn = mapping.generatedColumn;
          if (segment.length > 1) {
            mapping.source = previousSource + segment[1];
            previousSource += segment[1];
            mapping.originalLine = previousOriginalLine + segment[2];
            previousOriginalLine = mapping.originalLine;
            mapping.originalLine += 1;
            mapping.originalColumn = previousOriginalColumn + segment[3];
            previousOriginalColumn = mapping.originalColumn;
            if (segment.length > 4) {
              mapping.name = previousName + segment[4];
              previousName += segment[4];
            }
          }
          generatedMappings.push(mapping);
          if (typeof mapping.originalLine === "number") {
            originalMappings.push(mapping);
          }
        }
      }
      quickSort(generatedMappings, util.compareByGeneratedPositionsDeflated);
      this.__generatedMappings = generatedMappings;
      quickSort(originalMappings, util.compareByOriginalPositions);
      this.__originalMappings = originalMappings;
    };
    BasicSourceMapConsumer.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator, aBias) {
      if (aNeedle[aLineName] <= 0) {
        throw new TypeError("Line must be greater than or equal to 1, got " + aNeedle[aLineName]);
      }
      if (aNeedle[aColumnName] < 0) {
        throw new TypeError("Column must be greater than or equal to 0, got " + aNeedle[aColumnName]);
      }
      return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
    };
    BasicSourceMapConsumer.prototype.computeColumnSpans = function SourceMapConsumer_computeColumnSpans() {
      for (var index = 0; index < this._generatedMappings.length; ++index) {
        var mapping = this._generatedMappings[index];
        if (index + 1 < this._generatedMappings.length) {
          var nextMapping = this._generatedMappings[index + 1];
          if (mapping.generatedLine === nextMapping.generatedLine) {
            mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
            continue;
          }
        }
        mapping.lastGeneratedColumn = Infinity;
      }
    };
    BasicSourceMapConsumer.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var index = this._findMapping(needle, this._generatedMappings, "generatedLine", "generatedColumn", util.compareByGeneratedPositionsDeflated, util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND));
      if (index >= 0) {
        var mapping = this._generatedMappings[index];
        if (mapping.generatedLine === needle.generatedLine) {
          var source = util.getArg(mapping, "source", null);
          if (source !== null) {
            source = this._sources.at(source);
            source = util.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
          }
          var name = util.getArg(mapping, "name", null);
          if (name !== null) {
            name = this._names.at(name);
          }
          return {
            source,
            line: util.getArg(mapping, "originalLine", null),
            column: util.getArg(mapping, "originalColumn", null),
            name
          };
        }
      }
      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    };
    BasicSourceMapConsumer.prototype.hasContentsOfAllSources = function BasicSourceMapConsumer_hasContentsOfAllSources() {
      if (!this.sourcesContent) {
        return false;
      }
      return this.sourcesContent.length >= this._sources.size() && !this.sourcesContent.some(function(sc) {
        return sc == null;
      });
    };
    BasicSourceMapConsumer.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      if (!this.sourcesContent) {
        return null;
      }
      var index = this._findSourceIndex(aSource);
      if (index >= 0) {
        return this.sourcesContent[index];
      }
      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }
      var url;
      if (this.sourceRoot != null && (url = util.urlParse(this.sourceRoot))) {
        var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
        if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
        }
        if ((!url.path || url.path == "/") && this._sources.has("/" + relativeSource)) {
          return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + relativeSource + '" is not in the SourceMap.');
      }
    };
    BasicSourceMapConsumer.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
      var source = util.getArg(aArgs, "source");
      source = this._findSourceIndex(source);
      if (source < 0) {
        return {
          line: null,
          column: null,
          lastColumn: null
        };
      }
      var needle = {
        source,
        originalLine: util.getArg(aArgs, "line"),
        originalColumn: util.getArg(aArgs, "column")
      };
      var index = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util.compareByOriginalPositions, util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND));
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (mapping.source === needle.source) {
          return {
            line: util.getArg(mapping, "generatedLine", null),
            column: util.getArg(mapping, "generatedColumn", null),
            lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
          };
        }
      }
      return {
        line: null,
        column: null,
        lastColumn: null
      };
    };
    exports.BasicSourceMapConsumer = BasicSourceMapConsumer;
    function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      var version = util.getArg(sourceMap, "version");
      var sections = util.getArg(sourceMap, "sections");
      if (version != this._version) {
        throw new Error("Unsupported version: " + version);
      }
      this._sources = new ArraySet();
      this._names = new ArraySet();
      var lastOffset = {
        line: -1,
        column: 0
      };
      this._sections = sections.map(function(s) {
        if (s.url) {
          throw new Error("Support for url field in sections not implemented.");
        }
        var offset = util.getArg(s, "offset");
        var offsetLine = util.getArg(offset, "line");
        var offsetColumn = util.getArg(offset, "column");
        if (offsetLine < lastOffset.line || offsetLine === lastOffset.line && offsetColumn < lastOffset.column) {
          throw new Error("Section offsets must be ordered and non-overlapping.");
        }
        lastOffset = offset;
        return {
          generatedOffset: {
            generatedLine: offsetLine + 1,
            generatedColumn: offsetColumn + 1
          },
          consumer: new SourceMapConsumer(util.getArg(s, "map"), aSourceMapURL)
        };
      });
    }
    IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;
    IndexedSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(IndexedSourceMapConsumer.prototype, "sources", {
      get: function() {
        var sources = [];
        for (var i = 0; i < this._sections.length; i++) {
          for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
            sources.push(this._sections[i].consumer.sources[j]);
          }
        }
        return sources;
      }
    });
    IndexedSourceMapConsumer.prototype.originalPositionFor = function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var sectionIndex = binarySearch.search(needle, this._sections, function(needle2, section2) {
        var cmp = needle2.generatedLine - section2.generatedOffset.generatedLine;
        if (cmp) {
          return cmp;
        }
        return needle2.generatedColumn - section2.generatedOffset.generatedColumn;
      });
      var section = this._sections[sectionIndex];
      if (!section) {
        return {
          source: null,
          line: null,
          column: null,
          name: null
        };
      }
      return section.consumer.originalPositionFor({
        line: needle.generatedLine - (section.generatedOffset.generatedLine - 1),
        column: needle.generatedColumn - (section.generatedOffset.generatedLine === needle.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
        bias: aArgs.bias
      });
    };
    IndexedSourceMapConsumer.prototype.hasContentsOfAllSources = function IndexedSourceMapConsumer_hasContentsOfAllSources() {
      return this._sections.every(function(s) {
        return s.consumer.hasContentsOfAllSources();
      });
    };
    IndexedSourceMapConsumer.prototype.sourceContentFor = function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var content = section.consumer.sourceContentFor(aSource, true);
        if (content) {
          return content;
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };
    IndexedSourceMapConsumer.prototype.generatedPositionFor = function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        if (section.consumer._findSourceIndex(util.getArg(aArgs, "source")) === -1) {
          continue;
        }
        var generatedPosition = section.consumer.generatedPositionFor(aArgs);
        if (generatedPosition) {
          var ret = {
            line: generatedPosition.line + (section.generatedOffset.generatedLine - 1),
            column: generatedPosition.column + (section.generatedOffset.generatedLine === generatedPosition.line ? section.generatedOffset.generatedColumn - 1 : 0)
          };
          return ret;
        }
      }
      return {
        line: null,
        column: null
      };
    };
    IndexedSourceMapConsumer.prototype._parseMappings = function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      this.__generatedMappings = [];
      this.__originalMappings = [];
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var sectionMappings = section.consumer._generatedMappings;
        for (var j = 0; j < sectionMappings.length; j++) {
          var mapping = sectionMappings[j];
          var source = section.consumer._sources.at(mapping.source);
          source = util.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
          this._sources.add(source);
          source = this._sources.indexOf(source);
          var name = null;
          if (mapping.name) {
            name = section.consumer._names.at(mapping.name);
            this._names.add(name);
            name = this._names.indexOf(name);
          }
          var adjustedMapping = {
            source,
            generatedLine: mapping.generatedLine + (section.generatedOffset.generatedLine - 1),
            generatedColumn: mapping.generatedColumn + (section.generatedOffset.generatedLine === mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
            originalLine: mapping.originalLine,
            originalColumn: mapping.originalColumn,
            name
          };
          this.__generatedMappings.push(adjustedMapping);
          if (typeof adjustedMapping.originalLine === "number") {
            this.__originalMappings.push(adjustedMapping);
          }
        }
      }
      quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
      quickSort(this.__originalMappings, util.compareByOriginalPositions);
    };
    exports.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
  }
});

// node_modules/source-map/lib/source-node.js
var require_source_node = __commonJS({
  "node_modules/source-map/lib/source-node.js"(exports) {
    var SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    var util = require_util2();
    var REGEX_NEWLINE = /(\r?\n)/;
    var NEWLINE_CODE = 10;
    var isSourceNode = "$$$isSourceNode$$$";
    function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
      this.children = [];
      this.sourceContents = {};
      this.line = aLine == null ? null : aLine;
      this.column = aColumn == null ? null : aColumn;
      this.source = aSource == null ? null : aSource;
      this.name = aName == null ? null : aName;
      this[isSourceNode] = true;
      if (aChunks != null)
        this.add(aChunks);
    }
    SourceNode.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
      var node = new SourceNode();
      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
      var remainingLinesIndex = 0;
      var shiftNextLine = function() {
        var lineContents = getNextLine();
        var newLine = getNextLine() || "";
        return lineContents + newLine;
        function getNextLine() {
          return remainingLinesIndex < remainingLines.length ? remainingLines[remainingLinesIndex++] : void 0;
        }
      };
      var lastGeneratedLine = 1, lastGeneratedColumn = 0;
      var lastMapping = null;
      aSourceMapConsumer.eachMapping(function(mapping) {
        if (lastMapping !== null) {
          if (lastGeneratedLine < mapping.generatedLine) {
            addMappingWithCode(lastMapping, shiftNextLine());
            lastGeneratedLine++;
            lastGeneratedColumn = 0;
          } else {
            var nextLine = remainingLines[remainingLinesIndex] || "";
            var code = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
            remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
            addMappingWithCode(lastMapping, code);
            lastMapping = mapping;
            return;
          }
        }
        while (lastGeneratedLine < mapping.generatedLine) {
          node.add(shiftNextLine());
          lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
          var nextLine = remainingLines[remainingLinesIndex] || "";
          node.add(nextLine.substr(0, mapping.generatedColumn));
          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
      }, this);
      if (remainingLinesIndex < remainingLines.length) {
        if (lastMapping) {
          addMappingWithCode(lastMapping, shiftNextLine());
        }
        node.add(remainingLines.splice(remainingLinesIndex).join(""));
      }
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aRelativePath != null) {
            sourceFile = util.join(aRelativePath, sourceFile);
          }
          node.setSourceContent(sourceFile, content);
        }
      });
      return node;
      function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === void 0) {
          node.add(code);
        } else {
          var source = aRelativePath ? util.join(aRelativePath, mapping.source) : mapping.source;
          node.add(new SourceNode(mapping.originalLine, mapping.originalColumn, source, code, mapping.name));
        }
      }
    };
    SourceNode.prototype.add = function SourceNode_add(aChunk) {
      if (Array.isArray(aChunk)) {
        aChunk.forEach(function(chunk) {
          this.add(chunk);
        }, this);
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        if (aChunk) {
          this.children.push(aChunk);
        }
      } else {
        throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
      }
      return this;
    };
    SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
      if (Array.isArray(aChunk)) {
        for (var i = aChunk.length - 1; i >= 0; i--) {
          this.prepend(aChunk[i]);
        }
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        this.children.unshift(aChunk);
      } else {
        throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
      }
      return this;
    };
    SourceNode.prototype.walk = function SourceNode_walk(aFn) {
      var chunk;
      for (var i = 0, len = this.children.length; i < len; i++) {
        chunk = this.children[i];
        if (chunk[isSourceNode]) {
          chunk.walk(aFn);
        } else {
          if (chunk !== "") {
            aFn(chunk, {
              source: this.source,
              line: this.line,
              column: this.column,
              name: this.name
            });
          }
        }
      }
    };
    SourceNode.prototype.join = function SourceNode_join(aSep) {
      var newChildren;
      var i;
      var len = this.children.length;
      if (len > 0) {
        newChildren = [];
        for (i = 0; i < len - 1; i++) {
          newChildren.push(this.children[i]);
          newChildren.push(aSep);
        }
        newChildren.push(this.children[i]);
        this.children = newChildren;
      }
      return this;
    };
    SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
      var lastChild = this.children[this.children.length - 1];
      if (lastChild[isSourceNode]) {
        lastChild.replaceRight(aPattern, aReplacement);
      } else if (typeof lastChild === "string") {
        this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
      } else {
        this.children.push("".replace(aPattern, aReplacement));
      }
      return this;
    };
    SourceNode.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
    };
    SourceNode.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
      for (var i = 0, len = this.children.length; i < len; i++) {
        if (this.children[i][isSourceNode]) {
          this.children[i].walkSourceContents(aFn);
        }
      }
      var sources = Object.keys(this.sourceContents);
      for (var i = 0, len = sources.length; i < len; i++) {
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
      }
    };
    SourceNode.prototype.toString = function SourceNode_toString() {
      var str = "";
      this.walk(function(chunk) {
        str += chunk;
      });
      return str;
    };
    SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
      var generated = {
        code: "",
        line: 1,
        column: 0
      };
      var map = new SourceMapGenerator(aArgs);
      var sourceMappingActive = false;
      var lastOriginalSource = null;
      var lastOriginalLine = null;
      var lastOriginalColumn = null;
      var lastOriginalName = null;
      this.walk(function(chunk, original) {
        generated.code += chunk;
        if (original.source !== null && original.line !== null && original.column !== null) {
          if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) {
            map.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
          lastOriginalSource = original.source;
          lastOriginalLine = original.line;
          lastOriginalColumn = original.column;
          lastOriginalName = original.name;
          sourceMappingActive = true;
        } else if (sourceMappingActive) {
          map.addMapping({
            generated: {
              line: generated.line,
              column: generated.column
            }
          });
          lastOriginalSource = null;
          sourceMappingActive = false;
        }
        for (var idx = 0, length = chunk.length; idx < length; idx++) {
          if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
            generated.line++;
            generated.column = 0;
            if (idx + 1 === length) {
              lastOriginalSource = null;
              sourceMappingActive = false;
            } else if (sourceMappingActive) {
              map.addMapping({
                source: original.source,
                original: {
                  line: original.line,
                  column: original.column
                },
                generated: {
                  line: generated.line,
                  column: generated.column
                },
                name: original.name
              });
            }
          } else {
            generated.column++;
          }
        }
      });
      this.walkSourceContents(function(sourceFile, sourceContent) {
        map.setSourceContent(sourceFile, sourceContent);
      });
      return { code: generated.code, map };
    };
    exports.SourceNode = SourceNode;
  }
});

// node_modules/source-map/source-map.js
var require_source_map = __commonJS({
  "node_modules/source-map/source-map.js"(exports) {
    exports.SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    exports.SourceMapConsumer = require_source_map_consumer().SourceMapConsumer;
    exports.SourceNode = require_source_node().SourceNode;
  }
});

// node_modules/buffer-from/index.js
var require_buffer_from = __commonJS({
  "node_modules/buffer-from/index.js"(exports, module2) {
    var toString = Object.prototype.toString;
    var isModern = typeof Buffer !== "undefined" && typeof Buffer.alloc === "function" && typeof Buffer.allocUnsafe === "function" && typeof Buffer.from === "function";
    function isArrayBuffer(input) {
      return toString.call(input).slice(8, -1) === "ArrayBuffer";
    }
    function fromArrayBuffer(obj, byteOffset, length) {
      byteOffset >>>= 0;
      var maxLength = obj.byteLength - byteOffset;
      if (maxLength < 0) {
        throw new RangeError("'offset' is out of bounds");
      }
      if (length === void 0) {
        length = maxLength;
      } else {
        length >>>= 0;
        if (length > maxLength) {
          throw new RangeError("'length' is out of bounds");
        }
      }
      return isModern ? Buffer.from(obj.slice(byteOffset, byteOffset + length)) : new Buffer(new Uint8Array(obj.slice(byteOffset, byteOffset + length)));
    }
    function fromString(string, encoding) {
      if (typeof encoding !== "string" || encoding === "") {
        encoding = "utf8";
      }
      if (!Buffer.isEncoding(encoding)) {
        throw new TypeError('"encoding" must be a valid string encoding');
      }
      return isModern ? Buffer.from(string, encoding) : new Buffer(string, encoding);
    }
    function bufferFrom(value, encodingOrOffset, length) {
      if (typeof value === "number") {
        throw new TypeError('"value" argument must not be a number');
      }
      if (isArrayBuffer(value)) {
        return fromArrayBuffer(value, encodingOrOffset, length);
      }
      if (typeof value === "string") {
        return fromString(value, encodingOrOffset);
      }
      return isModern ? Buffer.from(value) : new Buffer(value);
    }
    module2.exports = bufferFrom;
  }
});

// node_modules/source-map-support/source-map-support.js
var require_source_map_support = __commonJS({
  "node_modules/source-map-support/source-map-support.js"(exports, module2) {
    var SourceMapConsumer = require_source_map().SourceMapConsumer;
    var path2 = require("path");
    var fs2;
    try {
      fs2 = require("fs");
      if (!fs2.existsSync || !fs2.readFileSync) {
        fs2 = null;
      }
    } catch (err) {
    }
    var bufferFrom = require_buffer_from();
    function dynamicRequire(mod, request) {
      return mod.require(request);
    }
    var errorFormatterInstalled = false;
    var uncaughtShimInstalled = false;
    var emptyCacheBetweenOperations = false;
    var environment = "auto";
    var fileContentsCache = {};
    var sourceMapCache = {};
    var reSourceMap = /^data:application\/json[^,]+base64,/;
    var retrieveFileHandlers = [];
    var retrieveMapHandlers = [];
    function isInBrowser() {
      if (environment === "browser")
        return true;
      if (environment === "node")
        return false;
      return typeof window !== "undefined" && typeof XMLHttpRequest === "function" && !(window.require && window.module && window.process && window.process.type === "renderer");
    }
    function hasGlobalProcessEventEmitter() {
      return typeof process === "object" && process !== null && typeof process.on === "function";
    }
    function globalProcessVersion() {
      if (typeof process === "object" && process !== null) {
        return process.version;
      } else {
        return "";
      }
    }
    function globalProcessStderr() {
      if (typeof process === "object" && process !== null) {
        return process.stderr;
      }
    }
    function globalProcessExit(code) {
      if (typeof process === "object" && process !== null && typeof process.exit === "function") {
        return process.exit(code);
      }
    }
    function handlerExec(list) {
      return function(arg) {
        for (var i = 0; i < list.length; i++) {
          var ret = list[i](arg);
          if (ret) {
            return ret;
          }
        }
        return null;
      };
    }
    var retrieveFile = handlerExec(retrieveFileHandlers);
    retrieveFileHandlers.push(function(path3) {
      path3 = path3.trim();
      if (/^file:/.test(path3)) {
        path3 = path3.replace(/file:\/\/\/(\w:)?/, function(protocol, drive) {
          return drive ? "" : "/";
        });
      }
      if (path3 in fileContentsCache) {
        return fileContentsCache[path3];
      }
      var contents = "";
      try {
        if (!fs2) {
          var xhr = new XMLHttpRequest();
          xhr.open("GET", path3, false);
          xhr.send(null);
          if (xhr.readyState === 4 && xhr.status === 200) {
            contents = xhr.responseText;
          }
        } else if (fs2.existsSync(path3)) {
          contents = fs2.readFileSync(path3, "utf8");
        }
      } catch (er) {
      }
      return fileContentsCache[path3] = contents;
    });
    function supportRelativeURL(file, url) {
      if (!file)
        return url;
      var dir = path2.dirname(file);
      var match = /^\w+:\/\/[^\/]*/.exec(dir);
      var protocol = match ? match[0] : "";
      var startPath = dir.slice(protocol.length);
      if (protocol && /^\/\w\:/.test(startPath)) {
        protocol += "/";
        return protocol + path2.resolve(dir.slice(protocol.length), url).replace(/\\/g, "/");
      }
      return protocol + path2.resolve(dir.slice(protocol.length), url);
    }
    function retrieveSourceMapURL(source) {
      var fileData;
      if (isInBrowser()) {
        try {
          var xhr = new XMLHttpRequest();
          xhr.open("GET", source, false);
          xhr.send(null);
          fileData = xhr.readyState === 4 ? xhr.responseText : null;
          var sourceMapHeader = xhr.getResponseHeader("SourceMap") || xhr.getResponseHeader("X-SourceMap");
          if (sourceMapHeader) {
            return sourceMapHeader;
          }
        } catch (e) {
        }
      }
      fileData = retrieveFile(source);
      var re = /(?:\/\/[@#][\s]*sourceMappingURL=([^\s'"]+)[\s]*$)|(?:\/\*[@#][\s]*sourceMappingURL=([^\s*'"]+)[\s]*(?:\*\/)[\s]*$)/mg;
      var lastMatch, match;
      while (match = re.exec(fileData))
        lastMatch = match;
      if (!lastMatch)
        return null;
      return lastMatch[1];
    }
    var retrieveSourceMap = handlerExec(retrieveMapHandlers);
    retrieveMapHandlers.push(function(source) {
      var sourceMappingURL = retrieveSourceMapURL(source);
      if (!sourceMappingURL)
        return null;
      var sourceMapData;
      if (reSourceMap.test(sourceMappingURL)) {
        var rawData = sourceMappingURL.slice(sourceMappingURL.indexOf(",") + 1);
        sourceMapData = bufferFrom(rawData, "base64").toString();
        sourceMappingURL = source;
      } else {
        sourceMappingURL = supportRelativeURL(source, sourceMappingURL);
        sourceMapData = retrieveFile(sourceMappingURL);
      }
      if (!sourceMapData) {
        return null;
      }
      return {
        url: sourceMappingURL,
        map: sourceMapData
      };
    });
    function mapSourcePosition(position) {
      var sourceMap = sourceMapCache[position.source];
      if (!sourceMap) {
        var urlAndMap = retrieveSourceMap(position.source);
        if (urlAndMap) {
          sourceMap = sourceMapCache[position.source] = {
            url: urlAndMap.url,
            map: new SourceMapConsumer(urlAndMap.map)
          };
          if (sourceMap.map.sourcesContent) {
            sourceMap.map.sources.forEach(function(source, i) {
              var contents = sourceMap.map.sourcesContent[i];
              if (contents) {
                var url = supportRelativeURL(sourceMap.url, source);
                fileContentsCache[url] = contents;
              }
            });
          }
        } else {
          sourceMap = sourceMapCache[position.source] = {
            url: null,
            map: null
          };
        }
      }
      if (sourceMap && sourceMap.map && typeof sourceMap.map.originalPositionFor === "function") {
        var originalPosition = sourceMap.map.originalPositionFor(position);
        if (originalPosition.source !== null) {
          originalPosition.source = supportRelativeURL(sourceMap.url, originalPosition.source);
          return originalPosition;
        }
      }
      return position;
    }
    function mapEvalOrigin(origin) {
      var match = /^eval at ([^(]+) \((.+):(\d+):(\d+)\)$/.exec(origin);
      if (match) {
        var position = mapSourcePosition({
          source: match[2],
          line: +match[3],
          column: match[4] - 1
        });
        return "eval at " + match[1] + " (" + position.source + ":" + position.line + ":" + (position.column + 1) + ")";
      }
      match = /^eval at ([^(]+) \((.+)\)$/.exec(origin);
      if (match) {
        return "eval at " + match[1] + " (" + mapEvalOrigin(match[2]) + ")";
      }
      return origin;
    }
    function CallSiteToString() {
      var fileName;
      var fileLocation = "";
      if (this.isNative()) {
        fileLocation = "native";
      } else {
        fileName = this.getScriptNameOrSourceURL();
        if (!fileName && this.isEval()) {
          fileLocation = this.getEvalOrigin();
          fileLocation += ", ";
        }
        if (fileName) {
          fileLocation += fileName;
        } else {
          fileLocation += "<anonymous>";
        }
        var lineNumber = this.getLineNumber();
        if (lineNumber != null) {
          fileLocation += ":" + lineNumber;
          var columnNumber = this.getColumnNumber();
          if (columnNumber) {
            fileLocation += ":" + columnNumber;
          }
        }
      }
      var line = "";
      var functionName = this.getFunctionName();
      var addSuffix = true;
      var isConstructor = this.isConstructor();
      var isMethodCall = !(this.isToplevel() || isConstructor);
      if (isMethodCall) {
        var typeName = this.getTypeName();
        if (typeName === "[object Object]") {
          typeName = "null";
        }
        var methodName = this.getMethodName();
        if (functionName) {
          if (typeName && functionName.indexOf(typeName) != 0) {
            line += typeName + ".";
          }
          line += functionName;
          if (methodName && functionName.indexOf("." + methodName) != functionName.length - methodName.length - 1) {
            line += " [as " + methodName + "]";
          }
        } else {
          line += typeName + "." + (methodName || "<anonymous>");
        }
      } else if (isConstructor) {
        line += "new " + (functionName || "<anonymous>");
      } else if (functionName) {
        line += functionName;
      } else {
        line += fileLocation;
        addSuffix = false;
      }
      if (addSuffix) {
        line += " (" + fileLocation + ")";
      }
      return line;
    }
    function cloneCallSite(frame) {
      var object = {};
      Object.getOwnPropertyNames(Object.getPrototypeOf(frame)).forEach(function(name) {
        object[name] = /^(?:is|get)/.test(name) ? function() {
          return frame[name].call(frame);
        } : frame[name];
      });
      object.toString = CallSiteToString;
      return object;
    }
    function wrapCallSite(frame, state) {
      if (state === void 0) {
        state = { nextPosition: null, curPosition: null };
      }
      if (frame.isNative()) {
        state.curPosition = null;
        return frame;
      }
      var source = frame.getFileName() || frame.getScriptNameOrSourceURL();
      if (source) {
        var line = frame.getLineNumber();
        var column = frame.getColumnNumber() - 1;
        var noHeader = /^v(10\.1[6-9]|10\.[2-9][0-9]|10\.[0-9]{3,}|1[2-9]\d*|[2-9]\d|\d{3,}|11\.11)/;
        var headerLength = noHeader.test(globalProcessVersion()) ? 0 : 62;
        if (line === 1 && column > headerLength && !isInBrowser() && !frame.isEval()) {
          column -= headerLength;
        }
        var position = mapSourcePosition({
          source,
          line,
          column
        });
        state.curPosition = position;
        frame = cloneCallSite(frame);
        var originalFunctionName = frame.getFunctionName;
        frame.getFunctionName = function() {
          if (state.nextPosition == null) {
            return originalFunctionName();
          }
          return state.nextPosition.name || originalFunctionName();
        };
        frame.getFileName = function() {
          return position.source;
        };
        frame.getLineNumber = function() {
          return position.line;
        };
        frame.getColumnNumber = function() {
          return position.column + 1;
        };
        frame.getScriptNameOrSourceURL = function() {
          return position.source;
        };
        return frame;
      }
      var origin = frame.isEval() && frame.getEvalOrigin();
      if (origin) {
        origin = mapEvalOrigin(origin);
        frame = cloneCallSite(frame);
        frame.getEvalOrigin = function() {
          return origin;
        };
        return frame;
      }
      return frame;
    }
    function prepareStackTrace(error, stack) {
      if (emptyCacheBetweenOperations) {
        fileContentsCache = {};
        sourceMapCache = {};
      }
      var name = error.name || "Error";
      var message = error.message || "";
      var errorString = name + ": " + message;
      var state = { nextPosition: null, curPosition: null };
      var processedStack = [];
      for (var i = stack.length - 1; i >= 0; i--) {
        processedStack.push("\n    at " + wrapCallSite(stack[i], state));
        state.nextPosition = state.curPosition;
      }
      state.curPosition = state.nextPosition = null;
      return errorString + processedStack.reverse().join("");
    }
    function getErrorSource(error) {
      var match = /\n    at [^(]+ \((.*):(\d+):(\d+)\)/.exec(error.stack);
      if (match) {
        var source = match[1];
        var line = +match[2];
        var column = +match[3];
        var contents = fileContentsCache[source];
        if (!contents && fs2 && fs2.existsSync(source)) {
          try {
            contents = fs2.readFileSync(source, "utf8");
          } catch (er) {
            contents = "";
          }
        }
        if (contents) {
          var code = contents.split(/(?:\r\n|\r|\n)/)[line - 1];
          if (code) {
            return source + ":" + line + "\n" + code + "\n" + new Array(column).join(" ") + "^";
          }
        }
      }
      return null;
    }
    function printErrorAndExit(error) {
      var source = getErrorSource(error);
      var stderr = globalProcessStderr();
      if (stderr && stderr._handle && stderr._handle.setBlocking) {
        stderr._handle.setBlocking(true);
      }
      if (source) {
        console.error();
        console.error(source);
      }
      console.error(error.stack);
      globalProcessExit(1);
    }
    function shimEmitUncaughtException() {
      var origEmit = process.emit;
      process.emit = function(type) {
        if (type === "uncaughtException") {
          var hasStack = arguments[1] && arguments[1].stack;
          var hasListeners = this.listeners(type).length > 0;
          if (hasStack && !hasListeners) {
            return printErrorAndExit(arguments[1]);
          }
        }
        return origEmit.apply(this, arguments);
      };
    }
    var originalRetrieveFileHandlers = retrieveFileHandlers.slice(0);
    var originalRetrieveMapHandlers = retrieveMapHandlers.slice(0);
    exports.wrapCallSite = wrapCallSite;
    exports.getErrorSource = getErrorSource;
    exports.mapSourcePosition = mapSourcePosition;
    exports.retrieveSourceMap = retrieveSourceMap;
    exports.install = function(options) {
      options = options || {};
      if (options.environment) {
        environment = options.environment;
        if (["node", "browser", "auto"].indexOf(environment) === -1) {
          throw new Error("environment " + environment + " was unknown. Available options are {auto, browser, node}");
        }
      }
      if (options.retrieveFile) {
        if (options.overrideRetrieveFile) {
          retrieveFileHandlers.length = 0;
        }
        retrieveFileHandlers.unshift(options.retrieveFile);
      }
      if (options.retrieveSourceMap) {
        if (options.overrideRetrieveSourceMap) {
          retrieveMapHandlers.length = 0;
        }
        retrieveMapHandlers.unshift(options.retrieveSourceMap);
      }
      if (options.hookRequire && !isInBrowser()) {
        var Module = dynamicRequire(module2, "module");
        var $compile = Module.prototype._compile;
        if (!$compile.__sourceMapSupport) {
          Module.prototype._compile = function(content, filename) {
            fileContentsCache[filename] = content;
            sourceMapCache[filename] = void 0;
            return $compile.call(this, content, filename);
          };
          Module.prototype._compile.__sourceMapSupport = true;
        }
      }
      if (!emptyCacheBetweenOperations) {
        emptyCacheBetweenOperations = "emptyCacheBetweenOperations" in options ? options.emptyCacheBetweenOperations : false;
      }
      if (!errorFormatterInstalled) {
        errorFormatterInstalled = true;
        Error.prepareStackTrace = prepareStackTrace;
      }
      if (!uncaughtShimInstalled) {
        var installHandler = "handleUncaughtExceptions" in options ? options.handleUncaughtExceptions : true;
        try {
          var worker_threads = dynamicRequire(module2, "worker_threads");
          if (worker_threads.isMainThread === false) {
            installHandler = false;
          }
        } catch (e) {
        }
        if (installHandler && hasGlobalProcessEventEmitter()) {
          uncaughtShimInstalled = true;
          shimEmitUncaughtException();
        }
      }
    };
    exports.resetRetrieveHandlers = function() {
      retrieveFileHandlers.length = 0;
      retrieveMapHandlers.length = 0;
      retrieveFileHandlers = originalRetrieveFileHandlers.slice(0);
      retrieveMapHandlers = originalRetrieveMapHandlers.slice(0);
      retrieveSourceMap = handlerExec(retrieveMapHandlers);
      retrieveFile = handlerExec(retrieveFileHandlers);
    };
  }
});

// node_modules/jsii-rosetta/node_modules/typescript/lib/typescript.js
var require_typescript = __commonJS({
  "node_modules/jsii-rosetta/node_modules/typescript/lib/typescript.js"(exports, module2) {
    "use strict";
    var __spreadArrays = exports && exports.__spreadArrays || function() {
      for (var s = 0, i = 0, il = arguments.length; i < il; i++)
        s += arguments[i].length;
      for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
          r[k] = a[j];
      return r;
    };
    var __assign = exports && exports.__assign || function() {
      __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p))
              t[p] = s[p];
        }
        return t;
      };
      return __assign.apply(this, arguments);
    };
    var __generator = exports && exports.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1)
          throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f)
          throw new TypeError("Generator is already executing.");
        while (_)
          try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
              return t;
            if (y = 0, t)
              op = [op[0] & 2, t.value];
            switch (op[0]) {
              case 0:
              case 1:
                t = op;
                break;
              case 4:
                _.label++;
                return { value: op[1], done: false };
              case 5:
                _.label++;
                y = op[1];
                op = [0];
                continue;
              case 7:
                op = _.ops.pop();
                _.trys.pop();
                continue;
              default:
                if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                  _ = 0;
                  continue;
                }
                if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                  _.label = op[1];
                  break;
                }
                if (op[0] === 6 && _.label < t[1]) {
                  _.label = t[1];
                  t = op;
                  break;
                }
                if (t && _.label < t[2]) {
                  _.label = t[2];
                  _.ops.push(op);
                  break;
                }
                if (t[2])
                  _.ops.pop();
                _.trys.pop();
                continue;
            }
            op = body.call(thisArg, _);
          } catch (e) {
            op = [6, e];
            y = 0;
          } finally {
            f = t = 0;
          }
        if (op[0] & 5)
          throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    var __makeTemplateObject = exports && exports.__makeTemplateObject || function(cooked, raw) {
      if (Object.defineProperty) {
        Object.defineProperty(cooked, "raw", { value: raw });
      } else {
        cooked.raw = raw;
      }
      return cooked;
    };
    var __rest = exports && exports.__rest || function(s, e) {
      var t = {};
      for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
          t[p] = s[p];
      if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
            t[p[i]] = s[p[i]];
        }
      return t;
    };
    var __extends = exports && exports.__extends || function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2)
            if (b2.hasOwnProperty(p))
              d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    var ts;
    (function(ts2) {
      function createMapShim() {
        function createDictionaryObject() {
          var map = Object.create(null);
          map.__ = void 0;
          delete map.__;
          return map;
        }
        var MapIterator = function() {
          function MapIterator2(currentEntry, selector) {
            this.currentEntry = currentEntry;
            this.selector = selector;
          }
          MapIterator2.prototype.next = function() {
            while (this.currentEntry) {
              var skipNext = !!this.currentEntry.skipNext;
              this.currentEntry = this.currentEntry.nextEntry;
              if (!skipNext) {
                break;
              }
            }
            if (this.currentEntry) {
              return { value: this.selector(this.currentEntry.key, this.currentEntry.value), done: false };
            } else {
              return { value: void 0, done: true };
            }
          };
          return MapIterator2;
        }();
        return function() {
          function class_1() {
            this.data = createDictionaryObject();
            this.size = 0;
            this.firstEntry = {};
            this.lastEntry = this.firstEntry;
          }
          class_1.prototype.get = function(key) {
            var entry = this.data[key];
            return entry && entry.value;
          };
          class_1.prototype.set = function(key, value) {
            if (!this.has(key)) {
              this.size++;
              var newEntry = {
                key,
                value
              };
              this.data[key] = newEntry;
              var previousLastEntry = this.lastEntry;
              previousLastEntry.nextEntry = newEntry;
              newEntry.previousEntry = previousLastEntry;
              this.lastEntry = newEntry;
            } else {
              this.data[key].value = value;
            }
            return this;
          };
          class_1.prototype.has = function(key) {
            return key in this.data;
          };
          class_1.prototype.delete = function(key) {
            if (this.has(key)) {
              this.size--;
              var entry = this.data[key];
              delete this.data[key];
              var previousEntry = entry.previousEntry;
              previousEntry.nextEntry = entry.nextEntry;
              if (entry.nextEntry) {
                entry.nextEntry.previousEntry = previousEntry;
              }
              if (this.lastEntry === entry) {
                this.lastEntry = previousEntry;
              }
              entry.previousEntry = void 0;
              entry.nextEntry = previousEntry;
              entry.skipNext = true;
              return true;
            }
            return false;
          };
          class_1.prototype.clear = function() {
            this.data = createDictionaryObject();
            this.size = 0;
            var firstEntry = this.firstEntry;
            var currentEntry = firstEntry.nextEntry;
            while (currentEntry) {
              var nextEntry = currentEntry.nextEntry;
              currentEntry.previousEntry = void 0;
              currentEntry.nextEntry = firstEntry;
              currentEntry.skipNext = true;
              currentEntry = nextEntry;
            }
            firstEntry.nextEntry = void 0;
            this.lastEntry = firstEntry;
          };
          class_1.prototype.keys = function() {
            return new MapIterator(this.firstEntry, function(key) {
              return key;
            });
          };
          class_1.prototype.values = function() {
            return new MapIterator(this.firstEntry, function(_key, value) {
              return value;
            });
          };
          class_1.prototype.entries = function() {
            return new MapIterator(this.firstEntry, function(key, value) {
              return [key, value];
            });
          };
          class_1.prototype.forEach = function(action) {
            var iterator = this.entries();
            while (true) {
              var iterResult = iterator.next();
              if (iterResult.done) {
                break;
              }
              var _a = iterResult.value, key = _a[0], value = _a[1];
              action(value, key);
            }
          };
          return class_1;
        }();
      }
      ts2.createMapShim = createMapShim;
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      ts2.versionMajorMinor = "3.9";
      ts2.version = "3.9.10";
      function tryGetNativeMap() {
        return typeof Map !== "undefined" && "entries" in Map.prototype ? Map : void 0;
      }
      ts2.tryGetNativeMap = tryGetNativeMap;
      ts2.Map = tryGetNativeMap() || function() {
        if (typeof ts2.createMapShim === "function") {
          return ts2.createMapShim();
        }
        throw new Error("TypeScript requires an environment that provides a compatible native Map implementation.");
      }();
      var Comparison;
      (function(Comparison2) {
        Comparison2[Comparison2["LessThan"] = -1] = "LessThan";
        Comparison2[Comparison2["EqualTo"] = 0] = "EqualTo";
        Comparison2[Comparison2["GreaterThan"] = 1] = "GreaterThan";
      })(Comparison = ts2.Comparison || (ts2.Comparison = {}));
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      ts2.emptyArray = [];
      function createMap() {
        return new ts2.Map();
      }
      ts2.createMap = createMap;
      function createMapFromEntries(entries) {
        var map2 = createMap();
        for (var _i = 0, entries_1 = entries; _i < entries_1.length; _i++) {
          var _a = entries_1[_i], key = _a[0], value = _a[1];
          map2.set(key, value);
        }
        return map2;
      }
      ts2.createMapFromEntries = createMapFromEntries;
      function createMapFromTemplate(template) {
        var map2 = new ts2.Map();
        for (var key in template) {
          if (hasOwnProperty2.call(template, key)) {
            map2.set(key, template[key]);
          }
        }
        return map2;
      }
      ts2.createMapFromTemplate = createMapFromTemplate;
      function length(array) {
        return array ? array.length : 0;
      }
      ts2.length = length;
      function forEach(array, callback) {
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var result = callback(array[i], i);
            if (result) {
              return result;
            }
          }
        }
        return void 0;
      }
      ts2.forEach = forEach;
      function forEachRight(array, callback) {
        if (array) {
          for (var i = array.length - 1; i >= 0; i--) {
            var result = callback(array[i], i);
            if (result) {
              return result;
            }
          }
        }
        return void 0;
      }
      ts2.forEachRight = forEachRight;
      function firstDefined(array, callback) {
        if (array === void 0) {
          return void 0;
        }
        for (var i = 0; i < array.length; i++) {
          var result = callback(array[i], i);
          if (result !== void 0) {
            return result;
          }
        }
        return void 0;
      }
      ts2.firstDefined = firstDefined;
      function firstDefinedIterator(iter, callback) {
        while (true) {
          var iterResult = iter.next();
          if (iterResult.done) {
            return void 0;
          }
          var result = callback(iterResult.value);
          if (result !== void 0) {
            return result;
          }
        }
      }
      ts2.firstDefinedIterator = firstDefinedIterator;
      function zipWith(arrayA, arrayB, callback) {
        var result = [];
        ts2.Debug.assertEqual(arrayA.length, arrayB.length);
        for (var i = 0; i < arrayA.length; i++) {
          result.push(callback(arrayA[i], arrayB[i], i));
        }
        return result;
      }
      ts2.zipWith = zipWith;
      function zipToIterator(arrayA, arrayB) {
        ts2.Debug.assertEqual(arrayA.length, arrayB.length);
        var i = 0;
        return {
          next: function() {
            if (i === arrayA.length) {
              return { value: void 0, done: true };
            }
            i++;
            return { value: [arrayA[i - 1], arrayB[i - 1]], done: false };
          }
        };
      }
      ts2.zipToIterator = zipToIterator;
      function zipToMap(keys, values) {
        ts2.Debug.assert(keys.length === values.length);
        var map2 = createMap();
        for (var i = 0; i < keys.length; ++i) {
          map2.set(keys[i], values[i]);
        }
        return map2;
      }
      ts2.zipToMap = zipToMap;
      function every(array, callback) {
        if (array) {
          for (var i = 0; i < array.length; i++) {
            if (!callback(array[i], i)) {
              return false;
            }
          }
        }
        return true;
      }
      ts2.every = every;
      function find(array, predicate) {
        for (var i = 0; i < array.length; i++) {
          var value = array[i];
          if (predicate(value, i)) {
            return value;
          }
        }
        return void 0;
      }
      ts2.find = find;
      function findLast(array, predicate) {
        for (var i = array.length - 1; i >= 0; i--) {
          var value = array[i];
          if (predicate(value, i)) {
            return value;
          }
        }
        return void 0;
      }
      ts2.findLast = findLast;
      function findIndex(array, predicate, startIndex) {
        for (var i = startIndex || 0; i < array.length; i++) {
          if (predicate(array[i], i)) {
            return i;
          }
        }
        return -1;
      }
      ts2.findIndex = findIndex;
      function findLastIndex(array, predicate, startIndex) {
        for (var i = startIndex === void 0 ? array.length - 1 : startIndex; i >= 0; i--) {
          if (predicate(array[i], i)) {
            return i;
          }
        }
        return -1;
      }
      ts2.findLastIndex = findLastIndex;
      function findMap(array, callback) {
        for (var i = 0; i < array.length; i++) {
          var result = callback(array[i], i);
          if (result) {
            return result;
          }
        }
        return ts2.Debug.fail();
      }
      ts2.findMap = findMap;
      function contains(array, value, equalityComparer) {
        if (equalityComparer === void 0) {
          equalityComparer = equateValues;
        }
        if (array) {
          for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
            var v = array_1[_i];
            if (equalityComparer(v, value)) {
              return true;
            }
          }
        }
        return false;
      }
      ts2.contains = contains;
      function arraysEqual(a, b, equalityComparer) {
        if (equalityComparer === void 0) {
          equalityComparer = equateValues;
        }
        return a.length === b.length && a.every(function(x, i) {
          return equalityComparer(x, b[i]);
        });
      }
      ts2.arraysEqual = arraysEqual;
      function indexOfAnyCharCode(text, charCodes, start) {
        for (var i = start || 0; i < text.length; i++) {
          if (contains(charCodes, text.charCodeAt(i))) {
            return i;
          }
        }
        return -1;
      }
      ts2.indexOfAnyCharCode = indexOfAnyCharCode;
      function countWhere(array, predicate) {
        var count = 0;
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var v = array[i];
            if (predicate(v, i)) {
              count++;
            }
          }
        }
        return count;
      }
      ts2.countWhere = countWhere;
      function filter(array, f) {
        if (array) {
          var len = array.length;
          var i = 0;
          while (i < len && f(array[i]))
            i++;
          if (i < len) {
            var result = array.slice(0, i);
            i++;
            while (i < len) {
              var item = array[i];
              if (f(item)) {
                result.push(item);
              }
              i++;
            }
            return result;
          }
        }
        return array;
      }
      ts2.filter = filter;
      function filterMutate(array, f) {
        var outIndex = 0;
        for (var i = 0; i < array.length; i++) {
          if (f(array[i], i, array)) {
            array[outIndex] = array[i];
            outIndex++;
          }
        }
        array.length = outIndex;
      }
      ts2.filterMutate = filterMutate;
      function clear(array) {
        array.length = 0;
      }
      ts2.clear = clear;
      function map(array, f) {
        var result;
        if (array) {
          result = [];
          for (var i = 0; i < array.length; i++) {
            result.push(f(array[i], i));
          }
        }
        return result;
      }
      ts2.map = map;
      function mapIterator(iter, mapFn) {
        return {
          next: function() {
            var iterRes = iter.next();
            return iterRes.done ? iterRes : { value: mapFn(iterRes.value), done: false };
          }
        };
      }
      ts2.mapIterator = mapIterator;
      function sameMap(array, f) {
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var item = array[i];
            var mapped = f(item, i);
            if (item !== mapped) {
              var result = array.slice(0, i);
              result.push(mapped);
              for (i++; i < array.length; i++) {
                result.push(f(array[i], i));
              }
              return result;
            }
          }
        }
        return array;
      }
      ts2.sameMap = sameMap;
      function flatten(array) {
        var result = [];
        for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
          var v = array_2[_i];
          if (v) {
            if (isArray(v)) {
              addRange(result, v);
            } else {
              result.push(v);
            }
          }
        }
        return result;
      }
      ts2.flatten = flatten;
      function flatMap(array, mapfn) {
        var result;
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var v = mapfn(array[i], i);
            if (v) {
              if (isArray(v)) {
                result = addRange(result, v);
              } else {
                result = append(result, v);
              }
            }
          }
        }
        return result || ts2.emptyArray;
      }
      ts2.flatMap = flatMap;
      function flatMapToMutable(array, mapfn) {
        var result = [];
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var v = mapfn(array[i], i);
            if (v) {
              if (isArray(v)) {
                addRange(result, v);
              } else {
                result.push(v);
              }
            }
          }
        }
        return result;
      }
      ts2.flatMapToMutable = flatMapToMutable;
      function flatMapIterator(iter, mapfn) {
        var first2 = iter.next();
        if (first2.done) {
          return ts2.emptyIterator;
        }
        var currentIter = getIterator(first2.value);
        return {
          next: function() {
            while (true) {
              var currentRes = currentIter.next();
              if (!currentRes.done) {
                return currentRes;
              }
              var iterRes = iter.next();
              if (iterRes.done) {
                return iterRes;
              }
              currentIter = getIterator(iterRes.value);
            }
          }
        };
        function getIterator(x) {
          var res = mapfn(x);
          return res === void 0 ? ts2.emptyIterator : isArray(res) ? arrayIterator(res) : res;
        }
      }
      ts2.flatMapIterator = flatMapIterator;
      function sameFlatMap(array, mapfn) {
        var result;
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var item = array[i];
            var mapped = mapfn(item, i);
            if (result || item !== mapped || isArray(mapped)) {
              if (!result) {
                result = array.slice(0, i);
              }
              if (isArray(mapped)) {
                addRange(result, mapped);
              } else {
                result.push(mapped);
              }
            }
          }
        }
        return result || array;
      }
      ts2.sameFlatMap = sameFlatMap;
      function mapAllOrFail(array, mapFn) {
        var result = [];
        for (var i = 0; i < array.length; i++) {
          var mapped = mapFn(array[i], i);
          if (mapped === void 0) {
            return void 0;
          }
          result.push(mapped);
        }
        return result;
      }
      ts2.mapAllOrFail = mapAllOrFail;
      function mapDefined(array, mapFn) {
        var result = [];
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var mapped = mapFn(array[i], i);
            if (mapped !== void 0) {
              result.push(mapped);
            }
          }
        }
        return result;
      }
      ts2.mapDefined = mapDefined;
      function mapDefinedIterator(iter, mapFn) {
        return {
          next: function() {
            while (true) {
              var res = iter.next();
              if (res.done) {
                return res;
              }
              var value = mapFn(res.value);
              if (value !== void 0) {
                return { value, done: false };
              }
            }
          }
        };
      }
      ts2.mapDefinedIterator = mapDefinedIterator;
      function mapDefinedMap(map2, mapValue, mapKey) {
        if (mapKey === void 0) {
          mapKey = identity;
        }
        var result = createMap();
        map2.forEach(function(value, key) {
          var mapped = mapValue(value, key);
          if (mapped !== void 0) {
            result.set(mapKey(key), mapped);
          }
        });
        return result;
      }
      ts2.mapDefinedMap = mapDefinedMap;
      ts2.emptyIterator = { next: function() {
        return { value: void 0, done: true };
      } };
      function singleIterator(value) {
        var done = false;
        return {
          next: function() {
            var wasDone = done;
            done = true;
            return wasDone ? { value: void 0, done: true } : { value, done: false };
          }
        };
      }
      ts2.singleIterator = singleIterator;
      function spanMap(array, keyfn, mapfn) {
        var result;
        if (array) {
          result = [];
          var len = array.length;
          var previousKey = void 0;
          var key = void 0;
          var start = 0;
          var pos = 0;
          while (start < len) {
            while (pos < len) {
              var value = array[pos];
              key = keyfn(value, pos);
              if (pos === 0) {
                previousKey = key;
              } else if (key !== previousKey) {
                break;
              }
              pos++;
            }
            if (start < pos) {
              var v = mapfn(array.slice(start, pos), previousKey, start, pos);
              if (v) {
                result.push(v);
              }
              start = pos;
            }
            previousKey = key;
            pos++;
          }
        }
        return result;
      }
      ts2.spanMap = spanMap;
      function mapEntries(map2, f) {
        if (!map2) {
          return void 0;
        }
        var result = createMap();
        map2.forEach(function(value, key) {
          var _a = f(key, value), newKey = _a[0], newValue = _a[1];
          result.set(newKey, newValue);
        });
        return result;
      }
      ts2.mapEntries = mapEntries;
      function some(array, predicate) {
        if (array) {
          if (predicate) {
            for (var _i = 0, array_3 = array; _i < array_3.length; _i++) {
              var v = array_3[_i];
              if (predicate(v)) {
                return true;
              }
            }
          } else {
            return array.length > 0;
          }
        }
        return false;
      }
      ts2.some = some;
      function getRangesWhere(arr, pred, cb) {
        var start;
        for (var i = 0; i < arr.length; i++) {
          if (pred(arr[i])) {
            start = start === void 0 ? i : start;
          } else {
            if (start !== void 0) {
              cb(start, i);
              start = void 0;
            }
          }
        }
        if (start !== void 0)
          cb(start, arr.length);
      }
      ts2.getRangesWhere = getRangesWhere;
      function concatenate(array1, array2) {
        if (!some(array2))
          return array1;
        if (!some(array1))
          return array2;
        return __spreadArrays(array1, array2);
      }
      ts2.concatenate = concatenate;
      function selectIndex(_, i) {
        return i;
      }
      function indicesOf(array) {
        return array.map(selectIndex);
      }
      ts2.indicesOf = indicesOf;
      function deduplicateRelational(array, equalityComparer, comparer) {
        var indices = indicesOf(array);
        stableSortIndices(array, indices, comparer);
        var last2 = array[indices[0]];
        var deduplicated = [indices[0]];
        for (var i = 1; i < indices.length; i++) {
          var index = indices[i];
          var item = array[index];
          if (!equalityComparer(last2, item)) {
            deduplicated.push(index);
            last2 = item;
          }
        }
        deduplicated.sort();
        return deduplicated.map(function(i2) {
          return array[i2];
        });
      }
      function deduplicateEquality(array, equalityComparer) {
        var result = [];
        for (var _i = 0, array_4 = array; _i < array_4.length; _i++) {
          var item = array_4[_i];
          pushIfUnique(result, item, equalityComparer);
        }
        return result;
      }
      function deduplicate(array, equalityComparer, comparer) {
        return array.length === 0 ? [] : array.length === 1 ? array.slice() : comparer ? deduplicateRelational(array, equalityComparer, comparer) : deduplicateEquality(array, equalityComparer);
      }
      ts2.deduplicate = deduplicate;
      function deduplicateSorted(array, comparer) {
        if (array.length === 0)
          return ts2.emptyArray;
        var last2 = array[0];
        var deduplicated = [last2];
        for (var i = 1; i < array.length; i++) {
          var next = array[i];
          switch (comparer(next, last2)) {
            case true:
            case 0:
              continue;
            case -1:
              return ts2.Debug.fail("Array is unsorted.");
          }
          deduplicated.push(last2 = next);
        }
        return deduplicated;
      }
      function insertSorted(array, insert, compare) {
        if (array.length === 0) {
          array.push(insert);
          return;
        }
        var insertIndex = binarySearch(array, insert, identity, compare);
        if (insertIndex < 0) {
          array.splice(~insertIndex, 0, insert);
        }
      }
      ts2.insertSorted = insertSorted;
      function sortAndDeduplicate(array, comparer, equalityComparer) {
        return deduplicateSorted(sort(array, comparer), equalityComparer || comparer || compareStringsCaseSensitive);
      }
      ts2.sortAndDeduplicate = sortAndDeduplicate;
      function arrayIsEqualTo(array1, array2, equalityComparer) {
        if (equalityComparer === void 0) {
          equalityComparer = equateValues;
        }
        if (!array1 || !array2) {
          return array1 === array2;
        }
        if (array1.length !== array2.length) {
          return false;
        }
        for (var i = 0; i < array1.length; i++) {
          if (!equalityComparer(array1[i], array2[i], i)) {
            return false;
          }
        }
        return true;
      }
      ts2.arrayIsEqualTo = arrayIsEqualTo;
      function compact(array) {
        var result;
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var v = array[i];
            if (result || !v) {
              if (!result) {
                result = array.slice(0, i);
              }
              if (v) {
                result.push(v);
              }
            }
          }
        }
        return result || array;
      }
      ts2.compact = compact;
      function relativeComplement(arrayA, arrayB, comparer) {
        if (!arrayB || !arrayA || arrayB.length === 0 || arrayA.length === 0)
          return arrayB;
        var result = [];
        loopB:
          for (var offsetA = 0, offsetB = 0; offsetB < arrayB.length; offsetB++) {
            if (offsetB > 0) {
              ts2.Debug.assertGreaterThanOrEqual(comparer(arrayB[offsetB], arrayB[offsetB - 1]), 0);
            }
            loopA:
              for (var startA = offsetA; offsetA < arrayA.length; offsetA++) {
                if (offsetA > startA) {
                  ts2.Debug.assertGreaterThanOrEqual(comparer(arrayA[offsetA], arrayA[offsetA - 1]), 0);
                }
                switch (comparer(arrayB[offsetB], arrayA[offsetA])) {
                  case -1:
                    result.push(arrayB[offsetB]);
                    continue loopB;
                  case 0:
                    continue loopB;
                  case 1:
                    continue loopA;
                }
              }
          }
        return result;
      }
      ts2.relativeComplement = relativeComplement;
      function sum(array, prop) {
        var result = 0;
        for (var _i = 0, array_5 = array; _i < array_5.length; _i++) {
          var v = array_5[_i];
          result += v[prop];
        }
        return result;
      }
      ts2.sum = sum;
      function append(to, value) {
        if (value === void 0)
          return to;
        if (to === void 0)
          return [value];
        to.push(value);
        return to;
      }
      ts2.append = append;
      function combine(xs, ys) {
        if (xs === void 0)
          return ys;
        if (ys === void 0)
          return xs;
        if (isArray(xs))
          return isArray(ys) ? concatenate(xs, ys) : append(xs, ys);
        if (isArray(ys))
          return append(ys, xs);
        return [xs, ys];
      }
      ts2.combine = combine;
      function toOffset(array, offset) {
        return offset < 0 ? array.length + offset : offset;
      }
      function addRange(to, from, start, end) {
        if (from === void 0 || from.length === 0)
          return to;
        if (to === void 0)
          return from.slice(start, end);
        start = start === void 0 ? 0 : toOffset(from, start);
        end = end === void 0 ? from.length : toOffset(from, end);
        for (var i = start; i < end && i < from.length; i++) {
          if (from[i] !== void 0) {
            to.push(from[i]);
          }
        }
        return to;
      }
      ts2.addRange = addRange;
      function pushIfUnique(array, toAdd, equalityComparer) {
        if (contains(array, toAdd, equalityComparer)) {
          return false;
        } else {
          array.push(toAdd);
          return true;
        }
      }
      ts2.pushIfUnique = pushIfUnique;
      function appendIfUnique(array, toAdd, equalityComparer) {
        if (array) {
          pushIfUnique(array, toAdd, equalityComparer);
          return array;
        } else {
          return [toAdd];
        }
      }
      ts2.appendIfUnique = appendIfUnique;
      function stableSortIndices(array, indices, comparer) {
        indices.sort(function(x, y) {
          return comparer(array[x], array[y]) || compareValues(x, y);
        });
      }
      function sort(array, comparer) {
        return array.length === 0 ? array : array.slice().sort(comparer);
      }
      ts2.sort = sort;
      function arrayIterator(array) {
        var i = 0;
        return { next: function() {
          if (i === array.length) {
            return { value: void 0, done: true };
          } else {
            i++;
            return { value: array[i - 1], done: false };
          }
        } };
      }
      ts2.arrayIterator = arrayIterator;
      function arrayReverseIterator(array) {
        var i = array.length;
        return {
          next: function() {
            if (i === 0) {
              return { value: void 0, done: true };
            } else {
              i--;
              return { value: array[i], done: false };
            }
          }
        };
      }
      ts2.arrayReverseIterator = arrayReverseIterator;
      function stableSort(array, comparer) {
        var indices = indicesOf(array);
        stableSortIndices(array, indices, comparer);
        return indices.map(function(i) {
          return array[i];
        });
      }
      ts2.stableSort = stableSort;
      function rangeEquals(array1, array2, pos, end) {
        while (pos < end) {
          if (array1[pos] !== array2[pos]) {
            return false;
          }
          pos++;
        }
        return true;
      }
      ts2.rangeEquals = rangeEquals;
      function elementAt(array, offset) {
        if (array) {
          offset = toOffset(array, offset);
          if (offset < array.length) {
            return array[offset];
          }
        }
        return void 0;
      }
      ts2.elementAt = elementAt;
      function firstOrUndefined(array) {
        return array.length === 0 ? void 0 : array[0];
      }
      ts2.firstOrUndefined = firstOrUndefined;
      function first(array) {
        ts2.Debug.assert(array.length !== 0);
        return array[0];
      }
      ts2.first = first;
      function lastOrUndefined(array) {
        return array.length === 0 ? void 0 : array[array.length - 1];
      }
      ts2.lastOrUndefined = lastOrUndefined;
      function last(array) {
        ts2.Debug.assert(array.length !== 0);
        return array[array.length - 1];
      }
      ts2.last = last;
      function singleOrUndefined(array) {
        return array && array.length === 1 ? array[0] : void 0;
      }
      ts2.singleOrUndefined = singleOrUndefined;
      function singleOrMany(array) {
        return array && array.length === 1 ? array[0] : array;
      }
      ts2.singleOrMany = singleOrMany;
      function replaceElement(array, index, value) {
        var result = array.slice(0);
        result[index] = value;
        return result;
      }
      ts2.replaceElement = replaceElement;
      function binarySearch(array, value, keySelector, keyComparer, offset) {
        return binarySearchKey(array, keySelector(value), keySelector, keyComparer, offset);
      }
      ts2.binarySearch = binarySearch;
      function binarySearchKey(array, key, keySelector, keyComparer, offset) {
        if (!some(array)) {
          return -1;
        }
        var low = offset || 0;
        var high = array.length - 1;
        while (low <= high) {
          var middle = low + (high - low >> 1);
          var midKey = keySelector(array[middle]);
          switch (keyComparer(midKey, key)) {
            case -1:
              low = middle + 1;
              break;
            case 0:
              return middle;
            case 1:
              high = middle - 1;
              break;
          }
        }
        return ~low;
      }
      ts2.binarySearchKey = binarySearchKey;
      function reduceLeft(array, f, initial, start, count) {
        if (array && array.length > 0) {
          var size = array.length;
          if (size > 0) {
            var pos = start === void 0 || start < 0 ? 0 : start;
            var end = count === void 0 || pos + count > size - 1 ? size - 1 : pos + count;
            var result = void 0;
            if (arguments.length <= 2) {
              result = array[pos];
              pos++;
            } else {
              result = initial;
            }
            while (pos <= end) {
              result = f(result, array[pos], pos);
              pos++;
            }
            return result;
          }
        }
        return initial;
      }
      ts2.reduceLeft = reduceLeft;
      var hasOwnProperty2 = Object.prototype.hasOwnProperty;
      function hasProperty(map2, key) {
        return hasOwnProperty2.call(map2, key);
      }
      ts2.hasProperty = hasProperty;
      function getProperty(map2, key) {
        return hasOwnProperty2.call(map2, key) ? map2[key] : void 0;
      }
      ts2.getProperty = getProperty;
      function getOwnKeys(map2) {
        var keys = [];
        for (var key in map2) {
          if (hasOwnProperty2.call(map2, key)) {
            keys.push(key);
          }
        }
        return keys;
      }
      ts2.getOwnKeys = getOwnKeys;
      function getAllKeys(obj) {
        var result = [];
        do {
          var names = Object.getOwnPropertyNames(obj);
          for (var _i = 0, names_1 = names; _i < names_1.length; _i++) {
            var name = names_1[_i];
            pushIfUnique(result, name);
          }
        } while (obj = Object.getPrototypeOf(obj));
        return result;
      }
      ts2.getAllKeys = getAllKeys;
      function getOwnValues(sparseArray) {
        var values = [];
        for (var key in sparseArray) {
          if (hasOwnProperty2.call(sparseArray, key)) {
            values.push(sparseArray[key]);
          }
        }
        return values;
      }
      ts2.getOwnValues = getOwnValues;
      function arrayFrom(iterator, map2) {
        var result = [];
        for (var iterResult = iterator.next(); !iterResult.done; iterResult = iterator.next()) {
          result.push(map2 ? map2(iterResult.value) : iterResult.value);
        }
        return result;
      }
      ts2.arrayFrom = arrayFrom;
      function assign(t) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          args[_i - 1] = arguments[_i];
        }
        for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {
          var arg = args_1[_a];
          if (arg === void 0)
            continue;
          for (var p in arg) {
            if (hasProperty(arg, p)) {
              t[p] = arg[p];
            }
          }
        }
        return t;
      }
      ts2.assign = assign;
      function equalOwnProperties(left, right, equalityComparer) {
        if (equalityComparer === void 0) {
          equalityComparer = equateValues;
        }
        if (left === right)
          return true;
        if (!left || !right)
          return false;
        for (var key in left) {
          if (hasOwnProperty2.call(left, key)) {
            if (!hasOwnProperty2.call(right, key))
              return false;
            if (!equalityComparer(left[key], right[key]))
              return false;
          }
        }
        for (var key in right) {
          if (hasOwnProperty2.call(right, key)) {
            if (!hasOwnProperty2.call(left, key))
              return false;
          }
        }
        return true;
      }
      ts2.equalOwnProperties = equalOwnProperties;
      function arrayToMap(array, makeKey, makeValue) {
        if (makeValue === void 0) {
          makeValue = identity;
        }
        var result = createMap();
        for (var _i = 0, array_6 = array; _i < array_6.length; _i++) {
          var value = array_6[_i];
          var key = makeKey(value);
          if (key !== void 0)
            result.set(key, makeValue(value));
        }
        return result;
      }
      ts2.arrayToMap = arrayToMap;
      function arrayToNumericMap(array, makeKey, makeValue) {
        if (makeValue === void 0) {
          makeValue = identity;
        }
        var result = [];
        for (var _i = 0, array_7 = array; _i < array_7.length; _i++) {
          var value = array_7[_i];
          result[makeKey(value)] = makeValue(value);
        }
        return result;
      }
      ts2.arrayToNumericMap = arrayToNumericMap;
      function arrayToMultiMap(values, makeKey, makeValue) {
        if (makeValue === void 0) {
          makeValue = identity;
        }
        var result = createMultiMap();
        for (var _i = 0, values_1 = values; _i < values_1.length; _i++) {
          var value = values_1[_i];
          result.add(makeKey(value), makeValue(value));
        }
        return result;
      }
      ts2.arrayToMultiMap = arrayToMultiMap;
      function group(values, getGroupId, resultSelector) {
        if (resultSelector === void 0) {
          resultSelector = identity;
        }
        return arrayFrom(arrayToMultiMap(values, getGroupId).values(), resultSelector);
      }
      ts2.group = group;
      function clone(object) {
        var result = {};
        for (var id in object) {
          if (hasOwnProperty2.call(object, id)) {
            result[id] = object[id];
          }
        }
        return result;
      }
      ts2.clone = clone;
      function extend(first2, second) {
        var result = {};
        for (var id in second) {
          if (hasOwnProperty2.call(second, id)) {
            result[id] = second[id];
          }
        }
        for (var id in first2) {
          if (hasOwnProperty2.call(first2, id)) {
            result[id] = first2[id];
          }
        }
        return result;
      }
      ts2.extend = extend;
      function copyProperties(first2, second) {
        for (var id in second) {
          if (hasOwnProperty2.call(second, id)) {
            first2[id] = second[id];
          }
        }
      }
      ts2.copyProperties = copyProperties;
      function maybeBind(obj, fn) {
        return fn ? fn.bind(obj) : void 0;
      }
      ts2.maybeBind = maybeBind;
      function mapMap(map2, f) {
        var result = createMap();
        map2.forEach(function(t, key) {
          return result.set.apply(result, f(t, key));
        });
        return result;
      }
      ts2.mapMap = mapMap;
      function createMultiMap() {
        var map2 = createMap();
        map2.add = multiMapAdd;
        map2.remove = multiMapRemove;
        return map2;
      }
      ts2.createMultiMap = createMultiMap;
      function multiMapAdd(key, value) {
        var values = this.get(key);
        if (values) {
          values.push(value);
        } else {
          this.set(key, values = [value]);
        }
        return values;
      }
      function multiMapRemove(key, value) {
        var values = this.get(key);
        if (values) {
          unorderedRemoveItem(values, value);
          if (!values.length) {
            this.delete(key);
          }
        }
      }
      function createUnderscoreEscapedMultiMap() {
        return createMultiMap();
      }
      ts2.createUnderscoreEscapedMultiMap = createUnderscoreEscapedMultiMap;
      function isArray(value) {
        return Array.isArray ? Array.isArray(value) : value instanceof Array;
      }
      ts2.isArray = isArray;
      function toArray(value) {
        return isArray(value) ? value : [value];
      }
      ts2.toArray = toArray;
      function isString(text) {
        return typeof text === "string";
      }
      ts2.isString = isString;
      function isNumber(x) {
        return typeof x === "number";
      }
      ts2.isNumber = isNumber;
      function tryCast(value, test) {
        return value !== void 0 && test(value) ? value : void 0;
      }
      ts2.tryCast = tryCast;
      function cast(value, test) {
        if (value !== void 0 && test(value))
          return value;
        return ts2.Debug.fail("Invalid cast. The supplied value " + value + " did not pass the test '" + ts2.Debug.getFunctionName(test) + "'.");
      }
      ts2.cast = cast;
      function noop(_) {
      }
      ts2.noop = noop;
      function returnFalse() {
        return false;
      }
      ts2.returnFalse = returnFalse;
      function returnTrue() {
        return true;
      }
      ts2.returnTrue = returnTrue;
      function returnUndefined() {
        return void 0;
      }
      ts2.returnUndefined = returnUndefined;
      function identity(x) {
        return x;
      }
      ts2.identity = identity;
      function toLowerCase(x) {
        return x.toLowerCase();
      }
      ts2.toLowerCase = toLowerCase;
      var fileNameLowerCaseRegExp = /[^\u0130\u0131\u00DFa-z0-9\\/:\-_\. ]+/g;
      function toFileNameLowerCase(x) {
        return fileNameLowerCaseRegExp.test(x) ? x.replace(fileNameLowerCaseRegExp, toLowerCase) : x;
      }
      ts2.toFileNameLowerCase = toFileNameLowerCase;
      function notImplemented() {
        throw new Error("Not implemented");
      }
      ts2.notImplemented = notImplemented;
      function memoize(callback) {
        var value;
        return function() {
          if (callback) {
            value = callback();
            callback = void 0;
          }
          return value;
        };
      }
      ts2.memoize = memoize;
      function compose(a, b, c, d, e) {
        if (!!e) {
          var args_2 = [];
          for (var i = 0; i < arguments.length; i++) {
            args_2[i] = arguments[i];
          }
          return function(t) {
            return reduceLeft(args_2, function(u, f) {
              return f(u);
            }, t);
          };
        } else if (d) {
          return function(t) {
            return d(c(b(a(t))));
          };
        } else if (c) {
          return function(t) {
            return c(b(a(t)));
          };
        } else if (b) {
          return function(t) {
            return b(a(t));
          };
        } else if (a) {
          return function(t) {
            return a(t);
          };
        } else {
          return function(t) {
            return t;
          };
        }
      }
      ts2.compose = compose;
      var AssertionLevel;
      (function(AssertionLevel2) {
        AssertionLevel2[AssertionLevel2["None"] = 0] = "None";
        AssertionLevel2[AssertionLevel2["Normal"] = 1] = "Normal";
        AssertionLevel2[AssertionLevel2["Aggressive"] = 2] = "Aggressive";
        AssertionLevel2[AssertionLevel2["VeryAggressive"] = 3] = "VeryAggressive";
      })(AssertionLevel = ts2.AssertionLevel || (ts2.AssertionLevel = {}));
      function equateValues(a, b) {
        return a === b;
      }
      ts2.equateValues = equateValues;
      function equateStringsCaseInsensitive(a, b) {
        return a === b || a !== void 0 && b !== void 0 && a.toUpperCase() === b.toUpperCase();
      }
      ts2.equateStringsCaseInsensitive = equateStringsCaseInsensitive;
      function equateStringsCaseSensitive(a, b) {
        return equateValues(a, b);
      }
      ts2.equateStringsCaseSensitive = equateStringsCaseSensitive;
      function compareComparableValues(a, b) {
        return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : a < b ? -1 : 1;
      }
      function compareValues(a, b) {
        return compareComparableValues(a, b);
      }
      ts2.compareValues = compareValues;
      function compareTextSpans(a, b) {
        return compareValues(a === null || a === void 0 ? void 0 : a.start, b === null || b === void 0 ? void 0 : b.start) || compareValues(a === null || a === void 0 ? void 0 : a.length, b === null || b === void 0 ? void 0 : b.length);
      }
      ts2.compareTextSpans = compareTextSpans;
      function min(a, b, compare) {
        return compare(a, b) === -1 ? a : b;
      }
      ts2.min = min;
      function compareStringsCaseInsensitive(a, b) {
        if (a === b)
          return 0;
        if (a === void 0)
          return -1;
        if (b === void 0)
          return 1;
        a = a.toUpperCase();
        b = b.toUpperCase();
        return a < b ? -1 : a > b ? 1 : 0;
      }
      ts2.compareStringsCaseInsensitive = compareStringsCaseInsensitive;
      function compareStringsCaseSensitive(a, b) {
        return compareComparableValues(a, b);
      }
      ts2.compareStringsCaseSensitive = compareStringsCaseSensitive;
      function getStringComparer(ignoreCase) {
        return ignoreCase ? compareStringsCaseInsensitive : compareStringsCaseSensitive;
      }
      ts2.getStringComparer = getStringComparer;
      var createUIStringComparer = function() {
        var defaultComparer;
        var enUSComparer;
        var stringComparerFactory = getStringComparerFactory();
        return createStringComparer;
        function compareWithCallback(a, b, comparer) {
          if (a === b)
            return 0;
          if (a === void 0)
            return -1;
          if (b === void 0)
            return 1;
          var value = comparer(a, b);
          return value < 0 ? -1 : value > 0 ? 1 : 0;
        }
        function createIntlCollatorStringComparer(locale) {
          var comparer = new Intl.Collator(locale, { usage: "sort", sensitivity: "variant" }).compare;
          return function(a, b) {
            return compareWithCallback(a, b, comparer);
          };
        }
        function createLocaleCompareStringComparer(locale) {
          if (locale !== void 0)
            return createFallbackStringComparer();
          return function(a, b) {
            return compareWithCallback(a, b, compareStrings);
          };
          function compareStrings(a, b) {
            return a.localeCompare(b);
          }
        }
        function createFallbackStringComparer() {
          return function(a, b) {
            return compareWithCallback(a, b, compareDictionaryOrder);
          };
          function compareDictionaryOrder(a, b) {
            return compareStrings(a.toUpperCase(), b.toUpperCase()) || compareStrings(a, b);
          }
          function compareStrings(a, b) {
            return a < b ? -1 : a > b ? 1 : 0;
          }
        }
        function getStringComparerFactory() {
          if (typeof Intl === "object" && typeof Intl.Collator === "function") {
            return createIntlCollatorStringComparer;
          }
          if (typeof String.prototype.localeCompare === "function" && typeof String.prototype.toLocaleUpperCase === "function" && "a".localeCompare("B") < 0) {
            return createLocaleCompareStringComparer;
          }
          return createFallbackStringComparer;
        }
        function createStringComparer(locale) {
          if (locale === void 0) {
            return defaultComparer || (defaultComparer = stringComparerFactory(locale));
          } else if (locale === "en-US") {
            return enUSComparer || (enUSComparer = stringComparerFactory(locale));
          } else {
            return stringComparerFactory(locale);
          }
        }
      }();
      var uiComparerCaseSensitive;
      var uiLocale;
      function getUILocale() {
        return uiLocale;
      }
      ts2.getUILocale = getUILocale;
      function setUILocale(value) {
        if (uiLocale !== value) {
          uiLocale = value;
          uiComparerCaseSensitive = void 0;
        }
      }
      ts2.setUILocale = setUILocale;
      function compareStringsCaseSensitiveUI(a, b) {
        var comparer = uiComparerCaseSensitive || (uiComparerCaseSensitive = createUIStringComparer(uiLocale));
        return comparer(a, b);
      }
      ts2.compareStringsCaseSensitiveUI = compareStringsCaseSensitiveUI;
      function compareProperties(a, b, key, comparer) {
        return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : comparer(a[key], b[key]);
      }
      ts2.compareProperties = compareProperties;
      function compareBooleans(a, b) {
        return compareValues(a ? 1 : 0, b ? 1 : 0);
      }
      ts2.compareBooleans = compareBooleans;
      function getSpellingSuggestion(name, candidates, getName) {
        var maximumLengthDifference = Math.min(2, Math.floor(name.length * 0.34));
        var bestDistance = Math.floor(name.length * 0.4) + 1;
        var bestCandidate;
        var justCheckExactMatches = false;
        var nameLowerCase = name.toLowerCase();
        for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
          var candidate = candidates_1[_i];
          var candidateName = getName(candidate);
          if (candidateName !== void 0 && Math.abs(candidateName.length - nameLowerCase.length) <= maximumLengthDifference) {
            var candidateNameLowerCase = candidateName.toLowerCase();
            if (candidateNameLowerCase === nameLowerCase) {
              if (candidateName === name) {
                continue;
              }
              return candidate;
            }
            if (justCheckExactMatches) {
              continue;
            }
            if (candidateName.length < 3) {
              continue;
            }
            var distance = levenshteinWithMax(nameLowerCase, candidateNameLowerCase, bestDistance - 1);
            if (distance === void 0) {
              continue;
            }
            if (distance < 3) {
              justCheckExactMatches = true;
              bestCandidate = candidate;
            } else {
              ts2.Debug.assert(distance < bestDistance);
              bestDistance = distance;
              bestCandidate = candidate;
            }
          }
        }
        return bestCandidate;
      }
      ts2.getSpellingSuggestion = getSpellingSuggestion;
      function levenshteinWithMax(s1, s2, max) {
        var previous = new Array(s2.length + 1);
        var current = new Array(s2.length + 1);
        var big = max + 1;
        for (var i = 0; i <= s2.length; i++) {
          previous[i] = i;
        }
        for (var i = 1; i <= s1.length; i++) {
          var c1 = s1.charCodeAt(i - 1);
          var minJ = i > max ? i - max : 1;
          var maxJ = s2.length > max + i ? max + i : s2.length;
          current[0] = i;
          var colMin = i;
          for (var j = 1; j < minJ; j++) {
            current[j] = big;
          }
          for (var j = minJ; j <= maxJ; j++) {
            var dist = c1 === s2.charCodeAt(j - 1) ? previous[j - 1] : Math.min(previous[j] + 1, current[j - 1] + 1, previous[j - 1] + 2);
            current[j] = dist;
            colMin = Math.min(colMin, dist);
          }
          for (var j = maxJ + 1; j <= s2.length; j++) {
            current[j] = big;
          }
          if (colMin > max) {
            return void 0;
          }
          var temp = previous;
          previous = current;
          current = temp;
        }
        var res = previous[s2.length];
        return res > max ? void 0 : res;
      }
      function endsWith(str, suffix) {
        var expectedPos = str.length - suffix.length;
        return expectedPos >= 0 && str.indexOf(suffix, expectedPos) === expectedPos;
      }
      ts2.endsWith = endsWith;
      function removeSuffix(str, suffix) {
        return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : str;
      }
      ts2.removeSuffix = removeSuffix;
      function tryRemoveSuffix(str, suffix) {
        return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : void 0;
      }
      ts2.tryRemoveSuffix = tryRemoveSuffix;
      function stringContains(str, substring) {
        return str.indexOf(substring) !== -1;
      }
      ts2.stringContains = stringContains;
      function removeMinAndVersionNumbers(fileName) {
        var trailingMinOrVersion = /[.-]((min)|(\d+(\.\d+)*))$/;
        return fileName.replace(trailingMinOrVersion, "").replace(trailingMinOrVersion, "");
      }
      ts2.removeMinAndVersionNumbers = removeMinAndVersionNumbers;
      function orderedRemoveItem(array, item) {
        for (var i = 0; i < array.length; i++) {
          if (array[i] === item) {
            orderedRemoveItemAt(array, i);
            return true;
          }
        }
        return false;
      }
      ts2.orderedRemoveItem = orderedRemoveItem;
      function orderedRemoveItemAt(array, index) {
        for (var i = index; i < array.length - 1; i++) {
          array[i] = array[i + 1];
        }
        array.pop();
      }
      ts2.orderedRemoveItemAt = orderedRemoveItemAt;
      function unorderedRemoveItemAt(array, index) {
        array[index] = array[array.length - 1];
        array.pop();
      }
      ts2.unorderedRemoveItemAt = unorderedRemoveItemAt;
      function unorderedRemoveItem(array, item) {
        return unorderedRemoveFirstItemWhere(array, function(element) {
          return element === item;
        });
      }
      ts2.unorderedRemoveItem = unorderedRemoveItem;
      function unorderedRemoveFirstItemWhere(array, predicate) {
        for (var i = 0; i < array.length; i++) {
          if (predicate(array[i])) {
            unorderedRemoveItemAt(array, i);
            return true;
          }
        }
        return false;
      }
      function createGetCanonicalFileName(useCaseSensitiveFileNames) {
        return useCaseSensitiveFileNames ? identity : toFileNameLowerCase;
      }
      ts2.createGetCanonicalFileName = createGetCanonicalFileName;
      function patternText(_a) {
        var prefix = _a.prefix, suffix = _a.suffix;
        return prefix + "*" + suffix;
      }
      ts2.patternText = patternText;
      function matchedText(pattern, candidate) {
        ts2.Debug.assert(isPatternMatch(pattern, candidate));
        return candidate.substring(pattern.prefix.length, candidate.length - pattern.suffix.length);
      }
      ts2.matchedText = matchedText;
      function findBestPatternMatch(values, getPattern, candidate) {
        var matchedValue;
        var longestMatchPrefixLength = -1;
        for (var _i = 0, values_2 = values; _i < values_2.length; _i++) {
          var v = values_2[_i];
          var pattern = getPattern(v);
          if (isPatternMatch(pattern, candidate) && pattern.prefix.length > longestMatchPrefixLength) {
            longestMatchPrefixLength = pattern.prefix.length;
            matchedValue = v;
          }
        }
        return matchedValue;
      }
      ts2.findBestPatternMatch = findBestPatternMatch;
      function startsWith(str, prefix) {
        return str.lastIndexOf(prefix, 0) === 0;
      }
      ts2.startsWith = startsWith;
      function removePrefix(str, prefix) {
        return startsWith(str, prefix) ? str.substr(prefix.length) : str;
      }
      ts2.removePrefix = removePrefix;
      function tryRemovePrefix(str, prefix, getCanonicalFileName) {
        if (getCanonicalFileName === void 0) {
          getCanonicalFileName = identity;
        }
        return startsWith(getCanonicalFileName(str), getCanonicalFileName(prefix)) ? str.substring(prefix.length) : void 0;
      }
      ts2.tryRemovePrefix = tryRemovePrefix;
      function isPatternMatch(_a, candidate) {
        var prefix = _a.prefix, suffix = _a.suffix;
        return candidate.length >= prefix.length + suffix.length && startsWith(candidate, prefix) && endsWith(candidate, suffix);
      }
      function and(f, g) {
        return function(arg) {
          return f(arg) && g(arg);
        };
      }
      ts2.and = and;
      function or() {
        var fs2 = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          fs2[_i] = arguments[_i];
        }
        return function() {
          var args = [];
          for (var _i2 = 0; _i2 < arguments.length; _i2++) {
            args[_i2] = arguments[_i2];
          }
          for (var _a = 0, fs_1 = fs2; _a < fs_1.length; _a++) {
            var f = fs_1[_a];
            if (f.apply(void 0, args)) {
              return true;
            }
          }
          return false;
        };
      }
      ts2.or = or;
      function not(fn) {
        return function() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          return !fn.apply(void 0, args);
        };
      }
      ts2.not = not;
      function assertType(_) {
      }
      ts2.assertType = assertType;
      function singleElementArray(t) {
        return t === void 0 ? void 0 : [t];
      }
      ts2.singleElementArray = singleElementArray;
      function enumerateInsertsAndDeletes(newItems, oldItems, comparer, inserted, deleted, unchanged) {
        unchanged = unchanged || noop;
        var newIndex = 0;
        var oldIndex = 0;
        var newLen = newItems.length;
        var oldLen = oldItems.length;
        while (newIndex < newLen && oldIndex < oldLen) {
          var newItem = newItems[newIndex];
          var oldItem = oldItems[oldIndex];
          var compareResult = comparer(newItem, oldItem);
          if (compareResult === -1) {
            inserted(newItem);
            newIndex++;
          } else if (compareResult === 1) {
            deleted(oldItem);
            oldIndex++;
          } else {
            unchanged(oldItem, newItem);
            newIndex++;
            oldIndex++;
          }
        }
        while (newIndex < newLen) {
          inserted(newItems[newIndex++]);
        }
        while (oldIndex < oldLen) {
          deleted(oldItems[oldIndex++]);
        }
      }
      ts2.enumerateInsertsAndDeletes = enumerateInsertsAndDeletes;
      function fill(length2, cb) {
        var result = Array(length2);
        for (var i = 0; i < length2; i++) {
          result[i] = cb(i);
        }
        return result;
      }
      ts2.fill = fill;
      function cartesianProduct(arrays) {
        var result = [];
        cartesianProductWorker(arrays, result, void 0, 0);
        return result;
      }
      ts2.cartesianProduct = cartesianProduct;
      function cartesianProductWorker(arrays, result, outer, index) {
        for (var _i = 0, _a = arrays[index]; _i < _a.length; _i++) {
          var element = _a[_i];
          var inner = void 0;
          if (outer) {
            inner = outer.slice();
            inner.push(element);
          } else {
            inner = [element];
          }
          if (index === arrays.length - 1) {
            result.push(inner);
          } else {
            cartesianProductWorker(arrays, result, inner, index + 1);
          }
        }
      }
      function padLeft(s, length2) {
        while (s.length < length2) {
          s = " " + s;
        }
        return s;
      }
      ts2.padLeft = padLeft;
      function padRight(s, length2) {
        while (s.length < length2) {
          s = s + " ";
        }
        return s;
      }
      ts2.padRight = padRight;
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var Debug;
      (function(Debug2) {
        var currentAssertionLevel = 0;
        Debug2.isDebugging = false;
        var assertionCache = {};
        function getAssertionLevel() {
          return currentAssertionLevel;
        }
        Debug2.getAssertionLevel = getAssertionLevel;
        function setAssertionLevel(level) {
          var prevAssertionLevel = currentAssertionLevel;
          currentAssertionLevel = level;
          if (level > prevAssertionLevel) {
            for (var _i = 0, _a = ts2.getOwnKeys(assertionCache); _i < _a.length; _i++) {
              var key = _a[_i];
              var cachedFunc = assertionCache[key];
              if (cachedFunc !== void 0 && Debug2[key] !== cachedFunc.assertion && level >= cachedFunc.level) {
                Debug2[key] = cachedFunc;
                assertionCache[key] = void 0;
              }
            }
          }
        }
        Debug2.setAssertionLevel = setAssertionLevel;
        function shouldAssert(level) {
          return currentAssertionLevel >= level;
        }
        Debug2.shouldAssert = shouldAssert;
        function shouldAssertFunction(level, name) {
          if (!shouldAssert(level)) {
            assertionCache[name] = { level, assertion: Debug2[name] };
            Debug2[name] = ts2.noop;
            return false;
          }
          return true;
        }
        function fail(message, stackCrawlMark) {
          debugger;
          var e = new Error(message ? "Debug Failure. " + message : "Debug Failure.");
          if (Error.captureStackTrace) {
            Error.captureStackTrace(e, stackCrawlMark || fail);
          }
          throw e;
        }
        Debug2.fail = fail;
        function failBadSyntaxKind(node, message, stackCrawlMark) {
          return fail((message || "Unexpected node.") + "\r\nNode " + formatSyntaxKind(node.kind) + " was unexpected.", stackCrawlMark || failBadSyntaxKind);
        }
        Debug2.failBadSyntaxKind = failBadSyntaxKind;
        function assert(expression, message, verboseDebugInfo, stackCrawlMark) {
          if (!expression) {
            message = message ? "False expression: " + message : "False expression.";
            if (verboseDebugInfo) {
              message += "\r\nVerbose Debug Information: " + (typeof verboseDebugInfo === "string" ? verboseDebugInfo : verboseDebugInfo());
            }
            fail(message, stackCrawlMark || assert);
          }
        }
        Debug2.assert = assert;
        function assertEqual(a, b, msg, msg2, stackCrawlMark) {
          if (a !== b) {
            var message = msg ? msg2 ? msg + " " + msg2 : msg : "";
            fail("Expected " + a + " === " + b + ". " + message, stackCrawlMark || assertEqual);
          }
        }
        Debug2.assertEqual = assertEqual;
        function assertLessThan(a, b, msg, stackCrawlMark) {
          if (a >= b) {
            fail("Expected " + a + " < " + b + ". " + (msg || ""), stackCrawlMark || assertLessThan);
          }
        }
        Debug2.assertLessThan = assertLessThan;
        function assertLessThanOrEqual(a, b, stackCrawlMark) {
          if (a > b) {
            fail("Expected " + a + " <= " + b, stackCrawlMark || assertLessThanOrEqual);
          }
        }
        Debug2.assertLessThanOrEqual = assertLessThanOrEqual;
        function assertGreaterThanOrEqual(a, b, stackCrawlMark) {
          if (a < b) {
            fail("Expected " + a + " >= " + b, stackCrawlMark || assertGreaterThanOrEqual);
          }
        }
        Debug2.assertGreaterThanOrEqual = assertGreaterThanOrEqual;
        function assertIsDefined(value, message, stackCrawlMark) {
          if (value === void 0 || value === null) {
            fail(message, stackCrawlMark || assertIsDefined);
          }
        }
        Debug2.assertIsDefined = assertIsDefined;
        function checkDefined(value, message, stackCrawlMark) {
          assertIsDefined(value, message, stackCrawlMark || checkDefined);
          return value;
        }
        Debug2.checkDefined = checkDefined;
        Debug2.assertDefined = checkDefined;
        function assertEachIsDefined(value, message, stackCrawlMark) {
          for (var _i = 0, value_1 = value; _i < value_1.length; _i++) {
            var v = value_1[_i];
            assertIsDefined(v, message, stackCrawlMark || assertEachIsDefined);
          }
        }
        Debug2.assertEachIsDefined = assertEachIsDefined;
        function checkEachDefined(value, message, stackCrawlMark) {
          assertEachIsDefined(value, message, stackCrawlMark || checkEachDefined);
          return value;
        }
        Debug2.checkEachDefined = checkEachDefined;
        Debug2.assertEachDefined = checkEachDefined;
        function assertNever(member, message, stackCrawlMark) {
          if (message === void 0) {
            message = "Illegal value:";
          }
          var detail = typeof member === "object" && ts2.hasProperty(member, "kind") && ts2.hasProperty(member, "pos") && formatSyntaxKind ? "SyntaxKind: " + formatSyntaxKind(member.kind) : JSON.stringify(member);
          return fail(message + " " + detail, stackCrawlMark || assertNever);
        }
        Debug2.assertNever = assertNever;
        function assertEachNode(nodes, test, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertEachNode")) {
            assert(test === void 0 || ts2.every(nodes, test), message || "Unexpected node.", function() {
              return "Node array did not pass test '" + getFunctionName(test) + "'.";
            }, stackCrawlMark || assertEachNode);
          }
        }
        Debug2.assertEachNode = assertEachNode;
        function assertNode(node, test, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertNode")) {
            assert(node !== void 0 && (test === void 0 || test(node)), message || "Unexpected node.", function() {
              return "Node " + formatSyntaxKind(node.kind) + " did not pass test '" + getFunctionName(test) + "'.";
            }, stackCrawlMark || assertNode);
          }
        }
        Debug2.assertNode = assertNode;
        function assertNotNode(node, test, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertNotNode")) {
            assert(node === void 0 || test === void 0 || !test(node), message || "Unexpected node.", function() {
              return "Node " + formatSyntaxKind(node.kind) + " should not have passed test '" + getFunctionName(test) + "'.";
            }, stackCrawlMark || assertNotNode);
          }
        }
        Debug2.assertNotNode = assertNotNode;
        function assertOptionalNode(node, test, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertOptionalNode")) {
            assert(test === void 0 || node === void 0 || test(node), message || "Unexpected node.", function() {
              return "Node " + formatSyntaxKind(node.kind) + " did not pass test '" + getFunctionName(test) + "'.";
            }, stackCrawlMark || assertOptionalNode);
          }
        }
        Debug2.assertOptionalNode = assertOptionalNode;
        function assertOptionalToken(node, kind, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertOptionalToken")) {
            assert(kind === void 0 || node === void 0 || node.kind === kind, message || "Unexpected node.", function() {
              return "Node " + formatSyntaxKind(node.kind) + " was not a '" + formatSyntaxKind(kind) + "' token.";
            }, stackCrawlMark || assertOptionalToken);
          }
        }
        Debug2.assertOptionalToken = assertOptionalToken;
        function assertMissingNode(node, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertMissingNode")) {
            assert(node === void 0, message || "Unexpected node.", function() {
              return "Node " + formatSyntaxKind(node.kind) + " was unexpected'.";
            }, stackCrawlMark || assertMissingNode);
          }
        }
        Debug2.assertMissingNode = assertMissingNode;
        function getFunctionName(func) {
          if (typeof func !== "function") {
            return "";
          } else if (func.hasOwnProperty("name")) {
            return func.name;
          } else {
            var text = Function.prototype.toString.call(func);
            var match = /^function\s+([\w\$]+)\s*\(/.exec(text);
            return match ? match[1] : "";
          }
        }
        Debug2.getFunctionName = getFunctionName;
        function formatSymbol(symbol) {
          return "{ name: " + ts2.unescapeLeadingUnderscores(symbol.escapedName) + "; flags: " + formatSymbolFlags(symbol.flags) + "; declarations: " + ts2.map(symbol.declarations, function(node) {
            return formatSyntaxKind(node.kind);
          }) + " }";
        }
        Debug2.formatSymbol = formatSymbol;
        function formatEnum(value, enumObject, isFlags) {
          if (value === void 0) {
            value = 0;
          }
          var members = getEnumMembers(enumObject);
          if (value === 0) {
            return members.length > 0 && members[0][0] === 0 ? members[0][1] : "0";
          }
          if (isFlags) {
            var result = "";
            var remainingFlags = value;
            for (var _i = 0, members_1 = members; _i < members_1.length; _i++) {
              var _a = members_1[_i], enumValue = _a[0], enumName = _a[1];
              if (enumValue > value) {
                break;
              }
              if (enumValue !== 0 && enumValue & value) {
                result = "" + result + (result ? "|" : "") + enumName;
                remainingFlags &= ~enumValue;
              }
            }
            if (remainingFlags === 0) {
              return result;
            }
          } else {
            for (var _b = 0, members_2 = members; _b < members_2.length; _b++) {
              var _c = members_2[_b], enumValue = _c[0], enumName = _c[1];
              if (enumValue === value) {
                return enumName;
              }
            }
          }
          return value.toString();
        }
        Debug2.formatEnum = formatEnum;
        function getEnumMembers(enumObject) {
          var result = [];
          for (var name in enumObject) {
            var value = enumObject[name];
            if (typeof value === "number") {
              result.push([value, name]);
            }
          }
          return ts2.stableSort(result, function(x, y) {
            return ts2.compareValues(x[0], y[0]);
          });
        }
        function formatSyntaxKind(kind) {
          return formatEnum(kind, ts2.SyntaxKind, false);
        }
        Debug2.formatSyntaxKind = formatSyntaxKind;
        function formatNodeFlags(flags) {
          return formatEnum(flags, ts2.NodeFlags, true);
        }
        Debug2.formatNodeFlags = formatNodeFlags;
        function formatModifierFlags(flags) {
          return formatEnum(flags, ts2.ModifierFlags, true);
        }
        Debug2.formatModifierFlags = formatModifierFlags;
        function formatTransformFlags(flags) {
          return formatEnum(flags, ts2.TransformFlags, true);
        }
        Debug2.formatTransformFlags = formatTransformFlags;
        function formatEmitFlags(flags) {
          return formatEnum(flags, ts2.EmitFlags, true);
        }
        Debug2.formatEmitFlags = formatEmitFlags;
        function formatSymbolFlags(flags) {
          return formatEnum(flags, ts2.SymbolFlags, true);
        }
        Debug2.formatSymbolFlags = formatSymbolFlags;
        function formatTypeFlags(flags) {
          return formatEnum(flags, ts2.TypeFlags, true);
        }
        Debug2.formatTypeFlags = formatTypeFlags;
        function formatObjectFlags(flags) {
          return formatEnum(flags, ts2.ObjectFlags, true);
        }
        Debug2.formatObjectFlags = formatObjectFlags;
        var isDebugInfoEnabled = false;
        var extendedDebugModule;
        function extendedDebug() {
          enableDebugInfo();
          if (!extendedDebugModule) {
            throw new Error("Debugging helpers could not be loaded.");
          }
          return extendedDebugModule;
        }
        function printControlFlowGraph(flowNode) {
          return console.log(formatControlFlowGraph(flowNode));
        }
        Debug2.printControlFlowGraph = printControlFlowGraph;
        function formatControlFlowGraph(flowNode) {
          return extendedDebug().formatControlFlowGraph(flowNode);
        }
        Debug2.formatControlFlowGraph = formatControlFlowGraph;
        function attachFlowNodeDebugInfo(flowNode) {
          if (isDebugInfoEnabled) {
            if (!("__debugFlowFlags" in flowNode)) {
              Object.defineProperties(flowNode, {
                __debugFlowFlags: { get: function() {
                  return formatEnum(this.flags, ts2.FlowFlags, true);
                } },
                __debugToString: { value: function() {
                  return formatControlFlowGraph(this);
                } }
              });
            }
          }
        }
        Debug2.attachFlowNodeDebugInfo = attachFlowNodeDebugInfo;
        function enableDebugInfo() {
          if (isDebugInfoEnabled)
            return;
          Object.defineProperties(ts2.objectAllocator.getSymbolConstructor().prototype, {
            __debugFlags: { get: function() {
              return formatSymbolFlags(this.flags);
            } }
          });
          Object.defineProperties(ts2.objectAllocator.getTypeConstructor().prototype, {
            __debugFlags: { get: function() {
              return formatTypeFlags(this.flags);
            } },
            __debugObjectFlags: { get: function() {
              return this.flags & 524288 ? formatObjectFlags(this.objectFlags) : "";
            } },
            __debugTypeToString: { value: function() {
              return this.checker.typeToString(this);
            } }
          });
          var nodeConstructors = [
            ts2.objectAllocator.getNodeConstructor(),
            ts2.objectAllocator.getIdentifierConstructor(),
            ts2.objectAllocator.getTokenConstructor(),
            ts2.objectAllocator.getSourceFileConstructor()
          ];
          for (var _i = 0, nodeConstructors_1 = nodeConstructors; _i < nodeConstructors_1.length; _i++) {
            var ctor = nodeConstructors_1[_i];
            if (!ctor.prototype.hasOwnProperty("__debugKind")) {
              Object.defineProperties(ctor.prototype, {
                __debugKind: { get: function() {
                  return formatSyntaxKind(this.kind);
                } },
                __debugNodeFlags: { get: function() {
                  return formatNodeFlags(this.flags);
                } },
                __debugModifierFlags: { get: function() {
                  return formatModifierFlags(ts2.getModifierFlagsNoCache(this));
                } },
                __debugTransformFlags: { get: function() {
                  return formatTransformFlags(this.transformFlags);
                } },
                __debugIsParseTreeNode: { get: function() {
                  return ts2.isParseTreeNode(this);
                } },
                __debugEmitFlags: { get: function() {
                  return formatEmitFlags(ts2.getEmitFlags(this));
                } },
                __debugGetText: {
                  value: function(includeTrivia) {
                    if (ts2.nodeIsSynthesized(this))
                      return "";
                    var parseNode = ts2.getParseTreeNode(this);
                    var sourceFile = parseNode && ts2.getSourceFileOfNode(parseNode);
                    return sourceFile ? ts2.getSourceTextOfNodeFromSourceFile(sourceFile, parseNode, includeTrivia) : "";
                  }
                }
              });
            }
          }
          try {
            if (ts2.sys && ts2.sys.require) {
              var basePath = ts2.getDirectoryPath(ts2.resolvePath(ts2.sys.getExecutingFilePath()));
              var result = ts2.sys.require(basePath, "./compiler-debug");
              if (!result.error) {
                result.module.init(ts2);
                extendedDebugModule = result.module;
              }
            }
          } catch (_a) {
          }
          isDebugInfoEnabled = true;
        }
        Debug2.enableDebugInfo = enableDebugInfo;
      })(Debug = ts2.Debug || (ts2.Debug = {}));
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      ts2.timestamp = typeof performance !== "undefined" && performance.now ? function() {
        return performance.now();
      } : Date.now ? Date.now : function() {
        return +new Date();
      };
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var performance2;
      (function(performance3) {
        var profilerEvent = typeof onProfilerEvent === "function" && onProfilerEvent.profiler === true ? onProfilerEvent : function() {
        };
        var enabled = false;
        var profilerStart = 0;
        var counts;
        var marks;
        var measures;
        function createTimerIf(condition, measureName, startMarkName, endMarkName) {
          return condition ? createTimer(measureName, startMarkName, endMarkName) : performance3.nullTimer;
        }
        performance3.createTimerIf = createTimerIf;
        function createTimer(measureName, startMarkName, endMarkName) {
          var enterCount = 0;
          return {
            enter,
            exit
          };
          function enter() {
            if (++enterCount === 1) {
              mark(startMarkName);
            }
          }
          function exit() {
            if (--enterCount === 0) {
              mark(endMarkName);
              measure(measureName, startMarkName, endMarkName);
            } else if (enterCount < 0) {
              ts2.Debug.fail("enter/exit count does not match.");
            }
          }
        }
        performance3.createTimer = createTimer;
        performance3.nullTimer = { enter: ts2.noop, exit: ts2.noop };
        function mark(markName) {
          if (enabled) {
            marks.set(markName, ts2.timestamp());
            counts.set(markName, (counts.get(markName) || 0) + 1);
            profilerEvent(markName);
          }
        }
        performance3.mark = mark;
        function measure(measureName, startMarkName, endMarkName) {
          if (enabled) {
            var end = endMarkName && marks.get(endMarkName) || ts2.timestamp();
            var start = startMarkName && marks.get(startMarkName) || profilerStart;
            measures.set(measureName, (measures.get(measureName) || 0) + (end - start));
          }
        }
        performance3.measure = measure;
        function getCount(markName) {
          return counts && counts.get(markName) || 0;
        }
        performance3.getCount = getCount;
        function getDuration(measureName) {
          return measures && measures.get(measureName) || 0;
        }
        performance3.getDuration = getDuration;
        function forEachMeasure(cb) {
          measures.forEach(function(measure2, key) {
            cb(key, measure2);
          });
        }
        performance3.forEachMeasure = forEachMeasure;
        function enable() {
          counts = ts2.createMap();
          marks = ts2.createMap();
          measures = ts2.createMap();
          enabled = true;
          profilerStart = ts2.timestamp();
        }
        performance3.enable = enable;
        function disable() {
          enabled = false;
        }
        performance3.disable = disable;
      })(performance2 = ts2.performance || (ts2.performance = {}));
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var _a;
      var nullLogger = {
        logEvent: ts2.noop,
        logErrEvent: ts2.noop,
        logPerfEvent: ts2.noop,
        logInfoEvent: ts2.noop,
        logStartCommand: ts2.noop,
        logStopCommand: ts2.noop,
        logStartUpdateProgram: ts2.noop,
        logStopUpdateProgram: ts2.noop,
        logStartUpdateGraph: ts2.noop,
        logStopUpdateGraph: ts2.noop,
        logStartResolveModule: ts2.noop,
        logStopResolveModule: ts2.noop,
        logStartParseSourceFile: ts2.noop,
        logStopParseSourceFile: ts2.noop,
        logStartReadFile: ts2.noop,
        logStopReadFile: ts2.noop,
        logStartBindFile: ts2.noop,
        logStopBindFile: ts2.noop,
        logStartScheduledOperation: ts2.noop,
        logStopScheduledOperation: ts2.noop
      };
      var etwModule;
      try {
        var etwModulePath = (_a = process.env.TS_ETW_MODULE_PATH) !== null && _a !== void 0 ? _a : "./node_modules/@microsoft/typescript-etw";
        etwModule = require(etwModulePath);
      } catch (e) {
        etwModule = void 0;
      }
      ts2.perfLogger = etwModule && etwModule.logEvent ? etwModule : nullLogger;
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var versionRegExp = /^(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
      var prereleaseRegExp = /^(?:0|[1-9]\d*|[a-z-][a-z0-9-]*)(?:\.(?:0|[1-9]\d*|[a-z-][a-z0-9-]*))*$/i;
      var buildRegExp = /^[a-z0-9-]+(?:\.[a-z0-9-]+)*$/i;
      var numericIdentifierRegExp = /^(0|[1-9]\d*)$/;
      var Version = function() {
        function Version2(major, minor, patch, prerelease, build) {
          if (minor === void 0) {
            minor = 0;
          }
          if (patch === void 0) {
            patch = 0;
          }
          if (prerelease === void 0) {
            prerelease = "";
          }
          if (build === void 0) {
            build = "";
          }
          if (typeof major === "string") {
            var result = ts2.Debug.checkDefined(tryParseComponents(major), "Invalid version");
            major = result.major, minor = result.minor, patch = result.patch, prerelease = result.prerelease, build = result.build;
          }
          ts2.Debug.assert(major >= 0, "Invalid argument: major");
          ts2.Debug.assert(minor >= 0, "Invalid argument: minor");
          ts2.Debug.assert(patch >= 0, "Invalid argument: patch");
          ts2.Debug.assert(!prerelease || prereleaseRegExp.test(prerelease), "Invalid argument: prerelease");
          ts2.Debug.assert(!build || buildRegExp.test(build), "Invalid argument: build");
          this.major = major;
          this.minor = minor;
          this.patch = patch;
          this.prerelease = prerelease ? prerelease.split(".") : ts2.emptyArray;
          this.build = build ? build.split(".") : ts2.emptyArray;
        }
        Version2.tryParse = function(text) {
          var result = tryParseComponents(text);
          if (!result)
            return void 0;
          var major = result.major, minor = result.minor, patch = result.patch, prerelease = result.prerelease, build = result.build;
          return new Version2(major, minor, patch, prerelease, build);
        };
        Version2.prototype.compareTo = function(other) {
          if (this === other)
            return 0;
          if (other === void 0)
            return 1;
          return ts2.compareValues(this.major, other.major) || ts2.compareValues(this.minor, other.minor) || ts2.compareValues(this.patch, other.patch) || comparePrerelaseIdentifiers(this.prerelease, other.prerelease);
        };
        Version2.prototype.increment = function(field) {
          switch (field) {
            case "major":
              return new Version2(this.major + 1, 0, 0);
            case "minor":
              return new Version2(this.major, this.minor + 1, 0);
            case "patch":
              return new Version2(this.major, this.minor, this.patch + 1);
            default:
              return ts2.Debug.assertNever(field);
          }
        };
        Version2.prototype.toString = function() {
          var result = this.major + "." + this.minor + "." + this.patch;
          if (ts2.some(this.prerelease))
            result += "-" + this.prerelease.join(".");
          if (ts2.some(this.build))
            result += "+" + this.build.join(".");
          return result;
        };
        Version2.zero = new Version2(0, 0, 0);
        return Version2;
      }();
      ts2.Version = Version;
      function tryParseComponents(text) {
        var match = versionRegExp.exec(text);
        if (!match)
          return void 0;
        var major = match[1], _a = match[2], minor = _a === void 0 ? "0" : _a, _b = match[3], patch = _b === void 0 ? "0" : _b, _c = match[4], prerelease = _c === void 0 ? "" : _c, _d = match[5], build = _d === void 0 ? "" : _d;
        if (prerelease && !prereleaseRegExp.test(prerelease))
          return void 0;
        if (build && !buildRegExp.test(build))
          return void 0;
        return {
          major: parseInt(major, 10),
          minor: parseInt(minor, 10),
          patch: parseInt(patch, 10),
          prerelease,
          build
        };
      }
      function comparePrerelaseIdentifiers(left, right) {
        if (left === right)
          return 0;
        if (left.length === 0)
          return right.length === 0 ? 0 : 1;
        if (right.length === 0)
          return -1;
        var length = Math.min(left.length, right.length);
        for (var i = 0; i < length; i++) {
          var leftIdentifier = left[i];
          var rightIdentifier = right[i];
          if (leftIdentifier === rightIdentifier)
            continue;
          var leftIsNumeric = numericIdentifierRegExp.test(leftIdentifier);
          var rightIsNumeric = numericIdentifierRegExp.test(rightIdentifier);
          if (leftIsNumeric || rightIsNumeric) {
            if (leftIsNumeric !== rightIsNumeric)
              return leftIsNumeric ? -1 : 1;
            var result = ts2.compareValues(+leftIdentifier, +rightIdentifier);
            if (result)
              return result;
          } else {
            var result = ts2.compareStringsCaseSensitive(leftIdentifier, rightIdentifier);
            if (result)
              return result;
          }
        }
        return ts2.compareValues(left.length, right.length);
      }
      var VersionRange = function() {
        function VersionRange2(spec) {
          this._alternatives = spec ? ts2.Debug.checkDefined(parseRange(spec), "Invalid range spec.") : ts2.emptyArray;
        }
        VersionRange2.tryParse = function(text) {
          var sets = parseRange(text);
          if (sets) {
            var range = new VersionRange2("");
            range._alternatives = sets;
            return range;
          }
          return void 0;
        };
        VersionRange2.prototype.test = function(version) {
          if (typeof version === "string")
            version = new Version(version);
          return testDisjunction(version, this._alternatives);
        };
        VersionRange2.prototype.toString = function() {
          return formatDisjunction(this._alternatives);
        };
        return VersionRange2;
      }();
      ts2.VersionRange = VersionRange;
      var logicalOrRegExp = /\s*\|\|\s*/g;
      var whitespaceRegExp = /\s+/g;
      var partialRegExp = /^([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
      var hyphenRegExp = /^\s*([a-z0-9-+.*]+)\s+-\s+([a-z0-9-+.*]+)\s*$/i;
      var rangeRegExp = /^\s*(~|\^|<|<=|>|>=|=)?\s*([a-z0-9-+.*]+)$/i;
      function parseRange(text) {
        var alternatives = [];
        for (var _i = 0, _a = text.trim().split(logicalOrRegExp); _i < _a.length; _i++) {
          var range = _a[_i];
          if (!range)
            continue;
          var comparators = [];
          var match = hyphenRegExp.exec(range);
          if (match) {
            if (!parseHyphen(match[1], match[2], comparators))
              return void 0;
          } else {
            for (var _b = 0, _c = range.split(whitespaceRegExp); _b < _c.length; _b++) {
              var simple = _c[_b];
              var match_1 = rangeRegExp.exec(simple);
              if (!match_1 || !parseComparator(match_1[1], match_1[2], comparators))
                return void 0;
            }
          }
          alternatives.push(comparators);
        }
        return alternatives;
      }
      function parsePartial(text) {
        var match = partialRegExp.exec(text);
        if (!match)
          return void 0;
        var major = match[1], _a = match[2], minor = _a === void 0 ? "*" : _a, _b = match[3], patch = _b === void 0 ? "*" : _b, prerelease = match[4], build = match[5];
        var version = new Version(isWildcard(major) ? 0 : parseInt(major, 10), isWildcard(major) || isWildcard(minor) ? 0 : parseInt(minor, 10), isWildcard(major) || isWildcard(minor) || isWildcard(patch) ? 0 : parseInt(patch, 10), prerelease, build);
        return { version, major, minor, patch };
      }
      function parseHyphen(left, right, comparators) {
        var leftResult = parsePartial(left);
        if (!leftResult)
          return false;
        var rightResult = parsePartial(right);
        if (!rightResult)
          return false;
        if (!isWildcard(leftResult.major)) {
          comparators.push(createComparator(">=", leftResult.version));
        }
        if (!isWildcard(rightResult.major)) {
          comparators.push(isWildcard(rightResult.minor) ? createComparator("<", rightResult.version.increment("major")) : isWildcard(rightResult.patch) ? createComparator("<", rightResult.version.increment("minor")) : createComparator("<=", rightResult.version));
        }
        return true;
      }
      function parseComparator(operator, text, comparators) {
        var result = parsePartial(text);
        if (!result)
          return false;
        var version = result.version, major = result.major, minor = result.minor, patch = result.patch;
        if (!isWildcard(major)) {
          switch (operator) {
            case "~":
              comparators.push(createComparator(">=", version));
              comparators.push(createComparator("<", version.increment(isWildcard(minor) ? "major" : "minor")));
              break;
            case "^":
              comparators.push(createComparator(">=", version));
              comparators.push(createComparator("<", version.increment(version.major > 0 || isWildcard(minor) ? "major" : version.minor > 0 || isWildcard(patch) ? "minor" : "patch")));
              break;
            case "<":
            case ">=":
              comparators.push(createComparator(operator, version));
              break;
            case "<=":
            case ">":
              comparators.push(isWildcard(minor) ? createComparator(operator === "<=" ? "<" : ">=", version.increment("major")) : isWildcard(patch) ? createComparator(operator === "<=" ? "<" : ">=", version.increment("minor")) : createComparator(operator, version));
              break;
            case "=":
            case void 0:
              if (isWildcard(minor) || isWildcard(patch)) {
                comparators.push(createComparator(">=", version));
                comparators.push(createComparator("<", version.increment(isWildcard(minor) ? "major" : "minor")));
              } else {
                comparators.push(createComparator("=", version));
              }
              break;
            default:
              return false;
          }
        } else if (operator === "<" || operator === ">") {
          comparators.push(createComparator("<", Version.zero));
        }
        return true;
      }
      function isWildcard(part) {
        return part === "*" || part === "x" || part === "X";
      }
      function createComparator(operator, operand) {
        return { operator, operand };
      }
      function testDisjunction(version, alternatives) {
        if (alternatives.length === 0)
          return true;
        for (var _i = 0, alternatives_1 = alternatives; _i < alternatives_1.length; _i++) {
          var alternative = alternatives_1[_i];
          if (testAlternative(version, alternative))
            return true;
        }
        return false;
      }
      function testAlternative(version, comparators) {
        for (var _i = 0, comparators_1 = comparators; _i < comparators_1.length; _i++) {
          var comparator = comparators_1[_i];
          if (!testComparator(version, comparator.operator, comparator.operand))
            return false;
        }
        return true;
      }
      function testComparator(version, operator, operand) {
        var cmp = version.compareTo(operand);
        switch (operator) {
          case "<":
            return cmp < 0;
          case "<=":
            return cmp <= 0;
          case ">":
            return cmp > 0;
          case ">=":
            return cmp >= 0;
          case "=":
            return cmp === 0;
          default:
            return ts2.Debug.assertNever(operator);
        }
      }
      function formatDisjunction(alternatives) {
        return ts2.map(alternatives, formatAlternative).join(" || ") || "*";
      }
      function formatAlternative(comparators) {
        return ts2.map(comparators, formatComparator).join(" ");
      }
      function formatComparator(comparator) {
        return "" + comparator.operator + comparator.operand;
      }
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var SyntaxKind;
      (function(SyntaxKind2) {
        SyntaxKind2[SyntaxKind2["Unknown"] = 0] = "Unknown";
        SyntaxKind2[SyntaxKind2["EndOfFileToken"] = 1] = "EndOfFileToken";
        SyntaxKind2[SyntaxKind2["SingleLineCommentTrivia"] = 2] = "SingleLineCommentTrivia";
        SyntaxKind2[SyntaxKind2["MultiLineCommentTrivia"] = 3] = "MultiLineCommentTrivia";
        SyntaxKind2[SyntaxKind2["NewLineTrivia"] = 4] = "NewLineTrivia";
        SyntaxKind2[SyntaxKind2["WhitespaceTrivia"] = 5] = "WhitespaceTrivia";
        SyntaxKind2[SyntaxKind2["ShebangTrivia"] = 6] = "ShebangTrivia";
        SyntaxKind2[SyntaxKind2["ConflictMarkerTrivia"] = 7] = "ConflictMarkerTrivia";
        SyntaxKind2[SyntaxKind2["NumericLiteral"] = 8] = "NumericLiteral";
        SyntaxKind2[SyntaxKind2["BigIntLiteral"] = 9] = "BigIntLiteral";
        SyntaxKind2[SyntaxKind2["StringLiteral"] = 10] = "StringLiteral";
        SyntaxKind2[SyntaxKind2["JsxText"] = 11] = "JsxText";
        SyntaxKind2[SyntaxKind2["JsxTextAllWhiteSpaces"] = 12] = "JsxTextAllWhiteSpaces";
        SyntaxKind2[SyntaxKind2["RegularExpressionLiteral"] = 13] = "RegularExpressionLiteral";
        SyntaxKind2[SyntaxKind2["NoSubstitutionTemplateLiteral"] = 14] = "NoSubstitutionTemplateLiteral";
        SyntaxKind2[SyntaxKind2["TemplateHead"] = 15] = "TemplateHead";
        SyntaxKind2[SyntaxKind2["TemplateMiddle"] = 16] = "TemplateMiddle";
        SyntaxKind2[SyntaxKind2["TemplateTail"] = 17] = "TemplateTail";
        SyntaxKind2[SyntaxKind2["OpenBraceToken"] = 18] = "OpenBraceToken";
        SyntaxKind2[SyntaxKind2["CloseBraceToken"] = 19] = "CloseBraceToken";
        SyntaxKind2[SyntaxKind2["OpenParenToken"] = 20] = "OpenParenToken";
        SyntaxKind2[SyntaxKind2["CloseParenToken"] = 21] = "CloseParenToken";
        SyntaxKind2[SyntaxKind2["OpenBracketToken"] = 22] = "OpenBracketToken";
        SyntaxKind2[SyntaxKind2["CloseBracketToken"] = 23] = "CloseBracketToken";
        SyntaxKind2[SyntaxKind2["DotToken"] = 24] = "DotToken";
        SyntaxKind2[SyntaxKind2["DotDotDotToken"] = 25] = "DotDotDotToken";
        SyntaxKind2[SyntaxKind2["SemicolonToken"] = 26] = "SemicolonToken";
        SyntaxKind2[SyntaxKind2["CommaToken"] = 27] = "CommaToken";
        SyntaxKind2[SyntaxKind2["QuestionDotToken"] = 28] = "QuestionDotToken";
        SyntaxKind2[SyntaxKind2["LessThanToken"] = 29] = "LessThanToken";
        SyntaxKind2[SyntaxKind2["LessThanSlashToken"] = 30] = "LessThanSlashToken";
        SyntaxKind2[SyntaxKind2["GreaterThanToken"] = 31] = "GreaterThanToken";
        SyntaxKind2[SyntaxKind2["LessThanEqualsToken"] = 32] = "LessThanEqualsToken";
        SyntaxKind2[SyntaxKind2["GreaterThanEqualsToken"] = 33] = "GreaterThanEqualsToken";
        SyntaxKind2[SyntaxKind2["EqualsEqualsToken"] = 34] = "EqualsEqualsToken";
        SyntaxKind2[SyntaxKind2["ExclamationEqualsToken"] = 35] = "ExclamationEqualsToken";
        SyntaxKind2[SyntaxKind2["EqualsEqualsEqualsToken"] = 36] = "EqualsEqualsEqualsToken";
        SyntaxKind2[SyntaxKind2["ExclamationEqualsEqualsToken"] = 37] = "ExclamationEqualsEqualsToken";
        SyntaxKind2[SyntaxKind2["EqualsGreaterThanToken"] = 38] = "EqualsGreaterThanToken";
        SyntaxKind2[SyntaxKind2["PlusToken"] = 39] = "PlusToken";
        SyntaxKind2[SyntaxKind2["MinusToken"] = 40] = "MinusToken";
        SyntaxKind2[SyntaxKind2["AsteriskToken"] = 41] = "AsteriskToken";
        SyntaxKind2[SyntaxKind2["AsteriskAsteriskToken"] = 42] = "AsteriskAsteriskToken";
        SyntaxKind2[SyntaxKind2["SlashToken"] = 43] = "SlashToken";
        SyntaxKind2[SyntaxKind2["PercentToken"] = 44] = "PercentToken";
        SyntaxKind2[SyntaxKind2["PlusPlusToken"] = 45] = "PlusPlusToken";
        SyntaxKind2[SyntaxKind2["MinusMinusToken"] = 46] = "MinusMinusToken";
        SyntaxKind2[SyntaxKind2["LessThanLessThanToken"] = 47] = "LessThanLessThanToken";
        SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanToken"] = 48] = "GreaterThanGreaterThanToken";
        SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanGreaterThanToken"] = 49] = "GreaterThanGreaterThanGreaterThanToken";
        SyntaxKind2[SyntaxKind2["AmpersandToken"] = 50] = "AmpersandToken";
        SyntaxKind2[SyntaxKind2["BarToken"] = 51] = "BarToken";
        SyntaxKind2[SyntaxKind2["CaretToken"] = 52] = "CaretToken";
        SyntaxKind2[SyntaxKind2["ExclamationToken"] = 53] = "ExclamationToken";
        SyntaxKind2[SyntaxKind2["TildeToken"] = 54] = "TildeToken";
        SyntaxKind2[SyntaxKind2["AmpersandAmpersandToken"] = 55] = "AmpersandAmpersandToken";
        SyntaxKind2[SyntaxKind2["BarBarToken"] = 56] = "BarBarToken";
        SyntaxKind2[SyntaxKind2["QuestionToken"] = 57] = "QuestionToken";
        SyntaxKind2[SyntaxKind2["ColonToken"] = 58] = "ColonToken";
        SyntaxKind2[SyntaxKind2["AtToken"] = 59] = "AtToken";
        SyntaxKind2[SyntaxKind2["QuestionQuestionToken"] = 60] = "QuestionQuestionToken";
        SyntaxKind2[SyntaxKind2["BacktickToken"] = 61] = "BacktickToken";
        SyntaxKind2[SyntaxKind2["EqualsToken"] = 62] = "EqualsToken";
        SyntaxKind2[SyntaxKind2["PlusEqualsToken"] = 63] = "PlusEqualsToken";
        SyntaxKind2[SyntaxKind2["MinusEqualsToken"] = 64] = "MinusEqualsToken";
        SyntaxKind2[SyntaxKind2["AsteriskEqualsToken"] = 65] = "AsteriskEqualsToken";
        SyntaxKind2[SyntaxKind2["AsteriskAsteriskEqualsToken"] = 66] = "AsteriskAsteriskEqualsToken";
        SyntaxKind2[SyntaxKind2["SlashEqualsToken"] = 67] = "SlashEqualsToken";
        SyntaxKind2[SyntaxKind2["PercentEqualsToken"] = 68] = "PercentEqualsToken";
        SyntaxKind2[SyntaxKind2["LessThanLessThanEqualsToken"] = 69] = "LessThanLessThanEqualsToken";
        SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanEqualsToken"] = 70] = "GreaterThanGreaterThanEqualsToken";
        SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanGreaterThanEqualsToken"] = 71] = "GreaterThanGreaterThanGreaterThanEqualsToken";
        SyntaxKind2[SyntaxKind2["AmpersandEqualsToken"] = 72] = "AmpersandEqualsToken";
        SyntaxKind2[SyntaxKind2["BarEqualsToken"] = 73] = "BarEqualsToken";
        SyntaxKind2[SyntaxKind2["CaretEqualsToken"] = 74] = "CaretEqualsToken";
        SyntaxKind2[SyntaxKind2["Identifier"] = 75] = "Identifier";
        SyntaxKind2[SyntaxKind2["PrivateIdentifier"] = 76] = "PrivateIdentifier";
        SyntaxKind2[SyntaxKind2["BreakKeyword"] = 77] = "BreakKeyword";
        SyntaxKind2[SyntaxKind2["CaseKeyword"] = 78] = "CaseKeyword";
        SyntaxKind2[SyntaxKind2["CatchKeyword"] = 79] = "CatchKeyword";
        SyntaxKind2[SyntaxKind2["ClassKeyword"] = 80] = "ClassKeyword";
        SyntaxKind2[SyntaxKind2["ConstKeyword"] = 81] = "ConstKeyword";
        SyntaxKind2[SyntaxKind2["ContinueKeyword"] = 82] = "ContinueKeyword";
        SyntaxKind2[SyntaxKind2["DebuggerKeyword"] = 83] = "DebuggerKeyword";
        SyntaxKind2[SyntaxKind2["DefaultKeyword"] = 84] = "DefaultKeyword";
        SyntaxKind2[SyntaxKind2["DeleteKeyword"] = 85] = "DeleteKeyword";
        SyntaxKind2[SyntaxKind2["DoKeyword"] = 86] = "DoKeyword";
        SyntaxKind2[SyntaxKind2["ElseKeyword"] = 87] = "ElseKeyword";
        SyntaxKind2[SyntaxKind2["EnumKeyword"] = 88] = "EnumKeyword";
        SyntaxKind2[SyntaxKind2["ExportKeyword"] = 89] = "ExportKeyword";
        SyntaxKind2[SyntaxKind2["ExtendsKeyword"] = 90] = "ExtendsKeyword";
        SyntaxKind2[SyntaxKind2["FalseKeyword"] = 91] = "FalseKeyword";
        SyntaxKind2[SyntaxKind2["FinallyKeyword"] = 92] = "FinallyKeyword";
        SyntaxKind2[SyntaxKind2["ForKeyword"] = 93] = "ForKeyword";
        SyntaxKind2[SyntaxKind2["FunctionKeyword"] = 94] = "FunctionKeyword";
        SyntaxKind2[SyntaxKind2["IfKeyword"] = 95] = "IfKeyword";
        SyntaxKind2[SyntaxKind2["ImportKeyword"] = 96] = "ImportKeyword";
        SyntaxKind2[SyntaxKind2["InKeyword"] = 97] = "InKeyword";
        SyntaxKind2[SyntaxKind2["InstanceOfKeyword"] = 98] = "InstanceOfKeyword";
        SyntaxKind2[SyntaxKind2["NewKeyword"] = 99] = "NewKeyword";
        SyntaxKind2[SyntaxKind2["NullKeyword"] = 100] = "NullKeyword";
        SyntaxKind2[SyntaxKind2["ReturnKeyword"] = 101] = "ReturnKeyword";
        SyntaxKind2[SyntaxKind2["SuperKeyword"] = 102] = "SuperKeyword";
        SyntaxKind2[SyntaxKind2["SwitchKeyword"] = 103] = "SwitchKeyword";
        SyntaxKind2[SyntaxKind2["ThisKeyword"] = 104] = "ThisKeyword";
        SyntaxKind2[SyntaxKind2["ThrowKeyword"] = 105] = "ThrowKeyword";
        SyntaxKind2[SyntaxKind2["TrueKeyword"] = 106] = "TrueKeyword";
        SyntaxKind2[SyntaxKind2["TryKeyword"] = 107] = "TryKeyword";
        SyntaxKind2[SyntaxKind2["TypeOfKeyword"] = 108] = "TypeOfKeyword";
        SyntaxKind2[SyntaxKind2["VarKeyword"] = 109] = "VarKeyword";
        SyntaxKind2[SyntaxKind2["VoidKeyword"] = 110] = "VoidKeyword";
        SyntaxKind2[SyntaxKind2["WhileKeyword"] = 111] = "WhileKeyword";
        SyntaxKind2[SyntaxKind2["WithKeyword"] = 112] = "WithKeyword";
        SyntaxKind2[SyntaxKind2["ImplementsKeyword"] = 113] = "ImplementsKeyword";
        SyntaxKind2[SyntaxKind2["InterfaceKeyword"] = 114] = "InterfaceKeyword";
        SyntaxKind2[SyntaxKind2["LetKeyword"] = 115] = "LetKeyword";
        SyntaxKind2[SyntaxKind2["PackageKeyword"] = 116] = "PackageKeyword";
        SyntaxKind2[SyntaxKind2["PrivateKeyword"] = 117] = "PrivateKeyword";
        SyntaxKind2[SyntaxKind2["ProtectedKeyword"] = 118] = "ProtectedKeyword";
        SyntaxKind2[SyntaxKind2["PublicKeyword"] = 119] = "PublicKeyword";
        SyntaxKind2[SyntaxKind2["StaticKeyword"] = 120] = "StaticKeyword";
        SyntaxKind2[SyntaxKind2["YieldKeyword"] = 121] = "YieldKeyword";
        SyntaxKind2[SyntaxKind2["AbstractKeyword"] = 122] = "AbstractKeyword";
        SyntaxKind2[SyntaxKind2["AsKeyword"] = 123] = "AsKeyword";
        SyntaxKind2[SyntaxKind2["AssertsKeyword"] = 124] = "AssertsKeyword";
        SyntaxKind2[SyntaxKind2["AnyKeyword"] = 125] = "AnyKeyword";
        SyntaxKind2[SyntaxKind2["AsyncKeyword"] = 126] = "AsyncKeyword";
        SyntaxKind2[SyntaxKind2["AwaitKeyword"] = 127] = "AwaitKeyword";
        SyntaxKind2[SyntaxKind2["BooleanKeyword"] = 128] = "BooleanKeyword";
        SyntaxKind2[SyntaxKind2["ConstructorKeyword"] = 129] = "ConstructorKeyword";
        SyntaxKind2[SyntaxKind2["DeclareKeyword"] = 130] = "DeclareKeyword";
        SyntaxKind2[SyntaxKind2["GetKeyword"] = 131] = "GetKeyword";
        SyntaxKind2[SyntaxKind2["InferKeyword"] = 132] = "InferKeyword";
        SyntaxKind2[SyntaxKind2["IsKeyword"] = 133] = "IsKeyword";
        SyntaxKind2[SyntaxKind2["KeyOfKeyword"] = 134] = "KeyOfKeyword";
        SyntaxKind2[SyntaxKind2["ModuleKeyword"] = 135] = "ModuleKeyword";
        SyntaxKind2[SyntaxKind2["NamespaceKeyword"] = 136] = "NamespaceKeyword";
        SyntaxKind2[SyntaxKind2["NeverKeyword"] = 137] = "NeverKeyword";
        SyntaxKind2[SyntaxKind2["ReadonlyKeyword"] = 138] = "ReadonlyKeyword";
        SyntaxKind2[SyntaxKind2["RequireKeyword"] = 139] = "RequireKeyword";
        SyntaxKind2[SyntaxKind2["NumberKeyword"] = 140] = "NumberKeyword";
        SyntaxKind2[SyntaxKind2["ObjectKeyword"] = 141] = "ObjectKeyword";
        SyntaxKind2[SyntaxKind2["SetKeyword"] = 142] = "SetKeyword";
        SyntaxKind2[SyntaxKind2["StringKeyword"] = 143] = "StringKeyword";
        SyntaxKind2[SyntaxKind2["SymbolKeyword"] = 144] = "SymbolKeyword";
        SyntaxKind2[SyntaxKind2["TypeKeyword"] = 145] = "TypeKeyword";
        SyntaxKind2[SyntaxKind2["UndefinedKeyword"] = 146] = "UndefinedKeyword";
        SyntaxKind2[SyntaxKind2["UniqueKeyword"] = 147] = "UniqueKeyword";
        SyntaxKind2[SyntaxKind2["UnknownKeyword"] = 148] = "UnknownKeyword";
        SyntaxKind2[SyntaxKind2["FromKeyword"] = 149] = "FromKeyword";
        SyntaxKind2[SyntaxKind2["GlobalKeyword"] = 150] = "GlobalKeyword";
        SyntaxKind2[SyntaxKind2["BigIntKeyword"] = 151] = "BigIntKeyword";
        SyntaxKind2[SyntaxKind2["OfKeyword"] = 152] = "OfKeyword";
        SyntaxKind2[SyntaxKind2["QualifiedName"] = 153] = "QualifiedName";
        SyntaxKind2[SyntaxKind2["ComputedPropertyName"] = 154] = "ComputedPropertyName";
        SyntaxKind2[SyntaxKind2["TypeParameter"] = 155] = "TypeParameter";
        SyntaxKind2[SyntaxKind2["Parameter"] = 156] = "Parameter";
        SyntaxKind2[SyntaxKind2["Decorator"] = 157] = "Decorator";
        SyntaxKind2[SyntaxKind2["PropertySignature"] = 158] = "PropertySignature";
        SyntaxKind2[SyntaxKind2["PropertyDeclaration"] = 159] = "PropertyDeclaration";
        SyntaxKind2[SyntaxKind2["MethodSignature"] = 160] = "MethodSignature";
        SyntaxKind2[SyntaxKind2["MethodDeclaration"] = 161] = "MethodDeclaration";
        SyntaxKind2[SyntaxKind2["Constructor"] = 162] = "Constructor";
        SyntaxKind2[SyntaxKind2["GetAccessor"] = 163] = "GetAccessor";
        SyntaxKind2[SyntaxKind2["SetAccessor"] = 164] = "SetAccessor";
        SyntaxKind2[SyntaxKind2["CallSignature"] = 165] = "CallSignature";
        SyntaxKind2[SyntaxKind2["ConstructSignature"] = 166] = "ConstructSignature";
        SyntaxKind2[SyntaxKind2["IndexSignature"] = 167] = "IndexSignature";
        SyntaxKind2[SyntaxKind2["TypePredicate"] = 168] = "TypePredicate";
        SyntaxKind2[SyntaxKind2["TypeReference"] = 169] = "TypeReference";
        SyntaxKind2[SyntaxKind2["FunctionType"] = 170] = "FunctionType";
        SyntaxKind2[SyntaxKind2["ConstructorType"] = 171] = "ConstructorType";
        SyntaxKind2[SyntaxKind2["TypeQuery"] = 172] = "TypeQuery";
        SyntaxKind2[SyntaxKind2["TypeLiteral"] = 173] = "TypeLiteral";
        SyntaxKind2[SyntaxKind2["ArrayType"] = 174] = "ArrayType";
        SyntaxKind2[SyntaxKind2["TupleType"] = 175] = "TupleType";
        SyntaxKind2[SyntaxKind2["OptionalType"] = 176] = "OptionalType";
        SyntaxKind2[SyntaxKind2["RestType"] = 177] = "RestType";
        SyntaxKind2[SyntaxKind2["UnionType"] = 178] = "UnionType";
        SyntaxKind2[SyntaxKind2["IntersectionType"] = 179] = "IntersectionType";
        SyntaxKind2[SyntaxKind2["ConditionalType"] = 180] = "ConditionalType";
        SyntaxKind2[SyntaxKind2["InferType"] = 181] = "InferType";
        SyntaxKind2[SyntaxKind2["ParenthesizedType"] = 182] = "ParenthesizedType";
        SyntaxKind2[SyntaxKind2["ThisType"] = 183] = "ThisType";
        SyntaxKind2[SyntaxKind2["TypeOperator"] = 184] = "TypeOperator";
        SyntaxKind2[SyntaxKind2["IndexedAccessType"] = 185] = "IndexedAccessType";
        SyntaxKind2[SyntaxKind2["MappedType"] = 186] = "MappedType";
        SyntaxKind2[SyntaxKind2["LiteralType"] = 187] = "LiteralType";
        SyntaxKind2[SyntaxKind2["ImportType"] = 188] = "ImportType";
        SyntaxKind2[SyntaxKind2["ObjectBindingPattern"] = 189] = "ObjectBindingPattern";
        SyntaxKind2[SyntaxKind2["ArrayBindingPattern"] = 190] = "ArrayBindingPattern";
        SyntaxKind2[SyntaxKind2["BindingElement"] = 191] = "BindingElement";
        SyntaxKind2[SyntaxKind2["ArrayLiteralExpression"] = 192] = "ArrayLiteralExpression";
        SyntaxKind2[SyntaxKind2["ObjectLiteralExpression"] = 193] = "ObjectLiteralExpression";
        SyntaxKind2[SyntaxKind2["PropertyAccessExpression"] = 194] = "PropertyAccessExpression";
        SyntaxKind2[SyntaxKind2["ElementAccessExpression"] = 195] = "ElementAccessExpression";
        SyntaxKind2[SyntaxKind2["CallExpression"] = 196] = "CallExpression";
        SyntaxKind2[SyntaxKind2["NewExpression"] = 197] = "NewExpression";
        SyntaxKind2[SyntaxKind2["TaggedTemplateExpression"] = 198] = "TaggedTemplateExpression";
        SyntaxKind2[SyntaxKind2["TypeAssertionExpression"] = 199] = "TypeAssertionExpression";
        SyntaxKind2[SyntaxKind2["ParenthesizedExpression"] = 200] = "ParenthesizedExpression";
        SyntaxKind2[SyntaxKind2["FunctionExpression"] = 201] = "FunctionExpression";
        SyntaxKind2[SyntaxKind2["ArrowFunction"] = 202] = "ArrowFunction";
        SyntaxKind2[SyntaxKind2["DeleteExpression"] = 203] = "DeleteExpression";
        SyntaxKind2[SyntaxKind2["TypeOfExpression"] = 204] = "TypeOfExpression";
        SyntaxKind2[SyntaxKind2["VoidExpression"] = 205] = "VoidExpression";
        SyntaxKind2[SyntaxKind2["AwaitExpression"] = 206] = "AwaitExpression";
        SyntaxKind2[SyntaxKind2["PrefixUnaryExpression"] = 207] = "PrefixUnaryExpression";
        SyntaxKind2[SyntaxKind2["PostfixUnaryExpression"] = 208] = "PostfixUnaryExpression";
        SyntaxKind2[SyntaxKind2["BinaryExpression"] = 209] = "BinaryExpression";
        SyntaxKind2[SyntaxKind2["ConditionalExpression"] = 210] = "ConditionalExpression";
        SyntaxKind2[SyntaxKind2["TemplateExpression"] = 211] = "TemplateExpression";
        SyntaxKind2[SyntaxKind2["YieldExpression"] = 212] = "YieldExpression";
        SyntaxKind2[SyntaxKind2["SpreadElement"] = 213] = "SpreadElement";
        SyntaxKind2[SyntaxKind2["ClassExpression"] = 214] = "ClassExpression";
        SyntaxKind2[SyntaxKind2["OmittedExpression"] = 215] = "OmittedExpression";
        SyntaxKind2[SyntaxKind2["ExpressionWithTypeArguments"] = 216] = "ExpressionWithTypeArguments";
        SyntaxKind2[SyntaxKind2["AsExpression"] = 217] = "AsExpression";
        SyntaxKind2[SyntaxKind2["NonNullExpression"] = 218] = "NonNullExpression";
        SyntaxKind2[SyntaxKind2["MetaProperty"] = 219] = "MetaProperty";
        SyntaxKind2[SyntaxKind2["SyntheticExpression"] = 220] = "SyntheticExpression";
        SyntaxKind2[SyntaxKind2["TemplateSpan"] = 221] = "TemplateSpan";
        SyntaxKind2[SyntaxKind2["SemicolonClassElement"] = 222] = "SemicolonClassElement";
        SyntaxKind2[SyntaxKind2["Block"] = 223] = "Block";
        SyntaxKind2[SyntaxKind2["EmptyStatement"] = 224] = "EmptyStatement";
        SyntaxKind2[SyntaxKind2["VariableStatement"] = 225] = "VariableStatement";
        SyntaxKind2[SyntaxKind2["ExpressionStatement"] = 226] = "ExpressionStatement";
        SyntaxKind2[SyntaxKind2["IfStatement"] = 227] = "IfStatement";
        SyntaxKind2[SyntaxKind2["DoStatement"] = 228] = "DoStatement";
        SyntaxKind2[SyntaxKind2["WhileStatement"] = 229] = "WhileStatement";
        SyntaxKind2[SyntaxKind2["ForStatement"] = 230] = "ForStatement";
        SyntaxKind2[SyntaxKind2["ForInStatement"] = 231] = "ForInStatement";
        SyntaxKind2[SyntaxKind2["ForOfStatement"] = 232] = "ForOfStatement";
        SyntaxKind2[SyntaxKind2["ContinueStatement"] = 233] = "ContinueStatement";
        SyntaxKind2[SyntaxKind2["BreakStatement"] = 234] = "BreakStatement";
        SyntaxKind2[SyntaxKind2["ReturnStatement"] = 235] = "ReturnStatement";
        SyntaxKind2[SyntaxKind2["WithStatement"] = 236] = "WithStatement";
        SyntaxKind2[SyntaxKind2["SwitchStatement"] = 237] = "SwitchStatement";
        SyntaxKind2[SyntaxKind2["LabeledStatement"] = 238] = "LabeledStatement";
        SyntaxKind2[SyntaxKind2["ThrowStatement"] = 239] = "ThrowStatement";
        SyntaxKind2[SyntaxKind2["TryStatement"] = 240] = "TryStatement";
        SyntaxKind2[SyntaxKind2["DebuggerStatement"] = 241] = "DebuggerStatement";
        SyntaxKind2[SyntaxKind2["VariableDeclaration"] = 242] = "VariableDeclaration";
        SyntaxKind2[SyntaxKind2["VariableDeclarationList"] = 243] = "VariableDeclarationList";
        SyntaxKind2[SyntaxKind2["FunctionDeclaration"] = 244] = "FunctionDeclaration";
        SyntaxKind2[SyntaxKind2["ClassDeclaration"] = 245] = "ClassDeclaration";
        SyntaxKind2[SyntaxKind2["InterfaceDeclaration"] = 246] = "InterfaceDeclaration";
        SyntaxKind2[SyntaxKind2["TypeAliasDeclaration"] = 247] = "TypeAliasDeclaration";
        SyntaxKind2[SyntaxKind2["EnumDeclaration"] = 248] = "EnumDeclaration";
        SyntaxKind2[SyntaxKind2["ModuleDeclaration"] = 249] = "ModuleDeclaration";
        SyntaxKind2[SyntaxKind2["ModuleBlock"] = 250] = "ModuleBlock";
        SyntaxKind2[SyntaxKind2["CaseBlock"] = 251] = "CaseBlock";
        SyntaxKind2[SyntaxKind2["NamespaceExportDeclaration"] = 252] = "NamespaceExportDeclaration";
        SyntaxKind2[SyntaxKind2["ImportEqualsDeclaration"] = 253] = "ImportEqualsDeclaration";
        SyntaxKind2[SyntaxKind2["ImportDeclaration"] = 254] = "ImportDeclaration";
        SyntaxKind2[SyntaxKind2["ImportClause"] = 255] = "ImportClause";
        SyntaxKind2[SyntaxKind2["NamespaceImport"] = 256] = "NamespaceImport";
        SyntaxKind2[SyntaxKind2["NamedImports"] = 257] = "NamedImports";
        SyntaxKind2[SyntaxKind2["ImportSpecifier"] = 258] = "ImportSpecifier";
        SyntaxKind2[SyntaxKind2["ExportAssignment"] = 259] = "ExportAssignment";
        SyntaxKind2[SyntaxKind2["ExportDeclaration"] = 260] = "ExportDeclaration";
        SyntaxKind2[SyntaxKind2["NamedExports"] = 261] = "NamedExports";
        SyntaxKind2[SyntaxKind2["NamespaceExport"] = 262] = "NamespaceExport";
        SyntaxKind2[SyntaxKind2["ExportSpecifier"] = 263] = "ExportSpecifier";
        SyntaxKind2[SyntaxKind2["MissingDeclaration"] = 264] = "MissingDeclaration";
        SyntaxKind2[SyntaxKind2["ExternalModuleReference"] = 265] = "ExternalModuleReference";
        SyntaxKind2[SyntaxKind2["JsxElement"] = 266] = "JsxElement";
        SyntaxKind2[SyntaxKind2["JsxSelfClosingElement"] = 267] = "JsxSelfClosingElement";
        SyntaxKind2[SyntaxKind2["JsxOpeningElement"] = 268] = "JsxOpeningElement";
        SyntaxKind2[SyntaxKind2["JsxClosingElement"] = 269] = "JsxClosingElement";
        SyntaxKind2[SyntaxKind2["JsxFragment"] = 270] = "JsxFragment";
        SyntaxKind2[SyntaxKind2["JsxOpeningFragment"] = 271] = "JsxOpeningFragment";
        SyntaxKind2[SyntaxKind2["JsxClosingFragment"] = 272] = "JsxClosingFragment";
        SyntaxKind2[SyntaxKind2["JsxAttribute"] = 273] = "JsxAttribute";
        SyntaxKind2[SyntaxKind2["JsxAttributes"] = 274] = "JsxAttributes";
        SyntaxKind2[SyntaxKind2["JsxSpreadAttribute"] = 275] = "JsxSpreadAttribute";
        SyntaxKind2[SyntaxKind2["JsxExpression"] = 276] = "JsxExpression";
        SyntaxKind2[SyntaxKind2["CaseClause"] = 277] = "CaseClause";
        SyntaxKind2[SyntaxKind2["DefaultClause"] = 278] = "DefaultClause";
        SyntaxKind2[SyntaxKind2["HeritageClause"] = 279] = "HeritageClause";
        SyntaxKind2[SyntaxKind2["CatchClause"] = 280] = "CatchClause";
        SyntaxKind2[SyntaxKind2["PropertyAssignment"] = 281] = "PropertyAssignment";
        SyntaxKind2[SyntaxKind2["ShorthandPropertyAssignment"] = 282] = "ShorthandPropertyAssignment";
        SyntaxKind2[SyntaxKind2["SpreadAssignment"] = 283] = "SpreadAssignment";
        SyntaxKind2[SyntaxKind2["EnumMember"] = 284] = "EnumMember";
        SyntaxKind2[SyntaxKind2["UnparsedPrologue"] = 285] = "UnparsedPrologue";
        SyntaxKind2[SyntaxKind2["UnparsedPrepend"] = 286] = "UnparsedPrepend";
        SyntaxKind2[SyntaxKind2["UnparsedText"] = 287] = "UnparsedText";
        SyntaxKind2[SyntaxKind2["UnparsedInternalText"] = 288] = "UnparsedInternalText";
        SyntaxKind2[SyntaxKind2["UnparsedSyntheticReference"] = 289] = "UnparsedSyntheticReference";
        SyntaxKind2[SyntaxKind2["SourceFile"] = 290] = "SourceFile";
        SyntaxKind2[SyntaxKind2["Bundle"] = 291] = "Bundle";
        SyntaxKind2[SyntaxKind2["UnparsedSource"] = 292] = "UnparsedSource";
        SyntaxKind2[SyntaxKind2["InputFiles"] = 293] = "InputFiles";
        SyntaxKind2[SyntaxKind2["JSDocTypeExpression"] = 294] = "JSDocTypeExpression";
        SyntaxKind2[SyntaxKind2["JSDocAllType"] = 295] = "JSDocAllType";
        SyntaxKind2[SyntaxKind2["JSDocUnknownType"] = 296] = "JSDocUnknownType";
        SyntaxKind2[SyntaxKind2["JSDocNullableType"] = 297] = "JSDocNullableType";
        SyntaxKind2[SyntaxKind2["JSDocNonNullableType"] = 298] = "JSDocNonNullableType";
        SyntaxKind2[SyntaxKind2["JSDocOptionalType"] = 299] = "JSDocOptionalType";
        SyntaxKind2[SyntaxKind2["JSDocFunctionType"] = 300] = "JSDocFunctionType";
        SyntaxKind2[SyntaxKind2["JSDocVariadicType"] = 301] = "JSDocVariadicType";
        SyntaxKind2[SyntaxKind2["JSDocNamepathType"] = 302] = "JSDocNamepathType";
        SyntaxKind2[SyntaxKind2["JSDocComment"] = 303] = "JSDocComment";
        SyntaxKind2[SyntaxKind2["JSDocTypeLiteral"] = 304] = "JSDocTypeLiteral";
        SyntaxKind2[SyntaxKind2["JSDocSignature"] = 305] = "JSDocSignature";
        SyntaxKind2[SyntaxKind2["JSDocTag"] = 306] = "JSDocTag";
        SyntaxKind2[SyntaxKind2["JSDocAugmentsTag"] = 307] = "JSDocAugmentsTag";
        SyntaxKind2[SyntaxKind2["JSDocImplementsTag"] = 308] = "JSDocImplementsTag";
        SyntaxKind2[SyntaxKind2["JSDocAuthorTag"] = 309] = "JSDocAuthorTag";
        SyntaxKind2[SyntaxKind2["JSDocClassTag"] = 310] = "JSDocClassTag";
        SyntaxKind2[SyntaxKind2["JSDocPublicTag"] = 311] = "JSDocPublicTag";
        SyntaxKind2[SyntaxKind2["JSDocPrivateTag"] = 312] = "JSDocPrivateTag";
        SyntaxKind2[SyntaxKind2["JSDocProtectedTag"] = 313] = "JSDocProtectedTag";
        SyntaxKind2[SyntaxKind2["JSDocReadonlyTag"] = 314] = "JSDocReadonlyTag";
        SyntaxKind2[SyntaxKind2["JSDocCallbackTag"] = 315] = "JSDocCallbackTag";
        SyntaxKind2[SyntaxKind2["JSDocEnumTag"] = 316] = "JSDocEnumTag";
        SyntaxKind2[SyntaxKind2["JSDocParameterTag"] = 317] = "JSDocParameterTag";
        SyntaxKind2[SyntaxKind2["JSDocReturnTag"] = 318] = "JSDocReturnTag";
        SyntaxKind2[SyntaxKind2["JSDocThisTag"] = 319] = "JSDocThisTag";
        SyntaxKind2[SyntaxKind2["JSDocTypeTag"] = 320] = "JSDocTypeTag";
        SyntaxKind2[SyntaxKind2["JSDocTemplateTag"] = 321] = "JSDocTemplateTag";
        SyntaxKind2[SyntaxKind2["JSDocTypedefTag"] = 322] = "JSDocTypedefTag";
        SyntaxKind2[SyntaxKind2["JSDocPropertyTag"] = 323] = "JSDocPropertyTag";
        SyntaxKind2[SyntaxKind2["SyntaxList"] = 324] = "SyntaxList";
        SyntaxKind2[SyntaxKind2["NotEmittedStatement"] = 325] = "NotEmittedStatement";
        SyntaxKind2[SyntaxKind2["PartiallyEmittedExpression"] = 326] = "PartiallyEmittedExpression";
        SyntaxKind2[SyntaxKind2["CommaListExpression"] = 327] = "CommaListExpression";
        SyntaxKind2[SyntaxKind2["MergeDeclarationMarker"] = 328] = "MergeDeclarationMarker";
        SyntaxKind2[SyntaxKind2["EndOfDeclarationMarker"] = 329] = "EndOfDeclarationMarker";
        SyntaxKind2[SyntaxKind2["SyntheticReferenceExpression"] = 330] = "SyntheticReferenceExpression";
        SyntaxKind2[SyntaxKind2["Count"] = 331] = "Count";
        SyntaxKind2[SyntaxKind2["FirstAssignment"] = 62] = "FirstAssignment";
        SyntaxKind2[SyntaxKind2["LastAssignment"] = 74] = "LastAssignment";
        SyntaxKind2[SyntaxKind2["FirstCompoundAssignment"] = 63] = "FirstCompoundAssignment";
        SyntaxKind2[SyntaxKind2["LastCompoundAssignment"] = 74] = "LastCompoundAssignment";
        SyntaxKind2[SyntaxKind2["FirstReservedWord"] = 77] = "FirstReservedWord";
        SyntaxKind2[SyntaxKind2["LastReservedWord"] = 112] = "LastReservedWord";
        SyntaxKind2[SyntaxKind2["FirstKeyword"] = 77] = "FirstKeyword";
        SyntaxKind2[SyntaxKind2["LastKeyword"] = 152] = "LastKeyword";
        SyntaxKind2[SyntaxKind2["FirstFutureReservedWord"] = 113] = "FirstFutureReservedWord";
        SyntaxKind2[SyntaxKind2["LastFutureReservedWord"] = 121] = "LastFutureReservedWord";
        SyntaxKind2[SyntaxKind2["FirstTypeNode"] = 168] = "FirstTypeNode";
        SyntaxKind2[SyntaxKind2["LastTypeNode"] = 188] = "LastTypeNode";
        SyntaxKind2[SyntaxKind2["FirstPunctuation"] = 18] = "FirstPunctuation";
        SyntaxKind2[SyntaxKind2["LastPunctuation"] = 74] = "LastPunctuation";
        SyntaxKind2[SyntaxKind2["FirstToken"] = 0] = "FirstToken";
        SyntaxKind2[SyntaxKind2["LastToken"] = 152] = "LastToken";
        SyntaxKind2[SyntaxKind2["FirstTriviaToken"] = 2] = "FirstTriviaToken";
        SyntaxKind2[SyntaxKind2["LastTriviaToken"] = 7] = "LastTriviaToken";
        SyntaxKind2[SyntaxKind2["FirstLiteralToken"] = 8] = "FirstLiteralToken";
        SyntaxKind2[SyntaxKind2["LastLiteralToken"] = 14] = "LastLiteralToken";
        SyntaxKind2[SyntaxKind2["FirstTemplateToken"] = 14] = "FirstTemplateToken";
        SyntaxKind2[SyntaxKind2["LastTemplateToken"] = 17] = "LastTemplateToken";
        SyntaxKind2[SyntaxKind2["FirstBinaryOperator"] = 29] = "FirstBinaryOperator";
        SyntaxKind2[SyntaxKind2["LastBinaryOperator"] = 74] = "LastBinaryOperator";
        SyntaxKind2[SyntaxKind2["FirstStatement"] = 225] = "FirstStatement";
        SyntaxKind2[SyntaxKind2["LastStatement"] = 241] = "LastStatement";
        SyntaxKind2[SyntaxKind2["FirstNode"] = 153] = "FirstNode";
        SyntaxKind2[SyntaxKind2["FirstJSDocNode"] = 294] = "FirstJSDocNode";
        SyntaxKind2[SyntaxKind2["LastJSDocNode"] = 323] = "LastJSDocNode";
        SyntaxKind2[SyntaxKind2["FirstJSDocTagNode"] = 306] = "FirstJSDocTagNode";
        SyntaxKind2[SyntaxKind2["LastJSDocTagNode"] = 323] = "LastJSDocTagNode";
        SyntaxKind2[SyntaxKind2["FirstContextualKeyword"] = 122] = "FirstContextualKeyword";
        SyntaxKind2[SyntaxKind2["LastContextualKeyword"] = 152] = "LastContextualKeyword";
      })(SyntaxKind = ts2.SyntaxKind || (ts2.SyntaxKind = {}));
      var NodeFlags;
      (function(NodeFlags2) {
        NodeFlags2[NodeFlags2["None"] = 0] = "None";
        NodeFlags2[NodeFlags2["Let"] = 1] = "Let";
        NodeFlags2[NodeFlags2["Const"] = 2] = "Const";
        NodeFlags2[NodeFlags2["NestedNamespace"] = 4] = "NestedNamespace";
        NodeFlags2[NodeFlags2["Synthesized"] = 8] = "Synthesized";
        NodeFlags2[NodeFlags2["Namespace"] = 16] = "Namespace";
        NodeFlags2[NodeFlags2["OptionalChain"] = 32] = "OptionalChain";
        NodeFlags2[NodeFlags2["ExportContext"] = 64] = "ExportContext";
        NodeFlags2[NodeFlags2["ContainsThis"] = 128] = "ContainsThis";
        NodeFlags2[NodeFlags2["HasImplicitReturn"] = 256] = "HasImplicitReturn";
        NodeFlags2[NodeFlags2["HasExplicitReturn"] = 512] = "HasExplicitReturn";
        NodeFlags2[NodeFlags2["GlobalAugmentation"] = 1024] = "GlobalAugmentation";
        NodeFlags2[NodeFlags2["HasAsyncFunctions"] = 2048] = "HasAsyncFunctions";
        NodeFlags2[NodeFlags2["DisallowInContext"] = 4096] = "DisallowInContext";
        NodeFlags2[NodeFlags2["YieldContext"] = 8192] = "YieldContext";
        NodeFlags2[NodeFlags2["DecoratorContext"] = 16384] = "DecoratorContext";
        NodeFlags2[NodeFlags2["AwaitContext"] = 32768] = "AwaitContext";
        NodeFlags2[NodeFlags2["ThisNodeHasError"] = 65536] = "ThisNodeHasError";
        NodeFlags2[NodeFlags2["JavaScriptFile"] = 131072] = "JavaScriptFile";
        NodeFlags2[NodeFlags2["ThisNodeOrAnySubNodesHasError"] = 262144] = "ThisNodeOrAnySubNodesHasError";
        NodeFlags2[NodeFlags2["HasAggregatedChildData"] = 524288] = "HasAggregatedChildData";
        NodeFlags2[NodeFlags2["PossiblyContainsDynamicImport"] = 1048576] = "PossiblyContainsDynamicImport";
        NodeFlags2[NodeFlags2["PossiblyContainsImportMeta"] = 2097152] = "PossiblyContainsImportMeta";
        NodeFlags2[NodeFlags2["JSDoc"] = 4194304] = "JSDoc";
        NodeFlags2[NodeFlags2["Ambient"] = 8388608] = "Ambient";
        NodeFlags2[NodeFlags2["InWithStatement"] = 16777216] = "InWithStatement";
        NodeFlags2[NodeFlags2["JsonFile"] = 33554432] = "JsonFile";
        NodeFlags2[NodeFlags2["TypeCached"] = 67108864] = "TypeCached";
        NodeFlags2[NodeFlags2["BlockScoped"] = 3] = "BlockScoped";
        NodeFlags2[NodeFlags2["ReachabilityCheckFlags"] = 768] = "ReachabilityCheckFlags";
        NodeFlags2[NodeFlags2["ReachabilityAndEmitFlags"] = 2816] = "ReachabilityAndEmitFlags";
        NodeFlags2[NodeFlags2["ContextFlags"] = 25358336] = "ContextFlags";
        NodeFlags2[NodeFlags2["TypeExcludesFlags"] = 40960] = "TypeExcludesFlags";
        NodeFlags2[NodeFlags2["PermanentlySetIncrementalFlags"] = 3145728] = "PermanentlySetIncrementalFlags";
      })(NodeFlags = ts2.NodeFlags || (ts2.NodeFlags = {}));
      var ModifierFlags;
      (function(ModifierFlags2) {
        ModifierFlags2[ModifierFlags2["None"] = 0] = "None";
        ModifierFlags2[ModifierFlags2["Export"] = 1] = "Export";
        ModifierFlags2[ModifierFlags2["Ambient"] = 2] = "Ambient";
        ModifierFlags2[ModifierFlags2["Public"] = 4] = "Public";
        ModifierFlags2[ModifierFlags2["Private"] = 8] = "Private";
        ModifierFlags2[ModifierFlags2["Protected"] = 16] = "Protected";
        ModifierFlags2[ModifierFlags2["Static"] = 32] = "Static";
        ModifierFlags2[ModifierFlags2["Readonly"] = 64] = "Readonly";
        ModifierFlags2[ModifierFlags2["Abstract"] = 128] = "Abstract";
        ModifierFlags2[ModifierFlags2["Async"] = 256] = "Async";
        ModifierFlags2[ModifierFlags2["Default"] = 512] = "Default";
        ModifierFlags2[ModifierFlags2["Const"] = 2048] = "Const";
        ModifierFlags2[ModifierFlags2["HasComputedFlags"] = 536870912] = "HasComputedFlags";
        ModifierFlags2[ModifierFlags2["AccessibilityModifier"] = 28] = "AccessibilityModifier";
        ModifierFlags2[ModifierFlags2["ParameterPropertyModifier"] = 92] = "ParameterPropertyModifier";
        ModifierFlags2[ModifierFlags2["NonPublicAccessibilityModifier"] = 24] = "NonPublicAccessibilityModifier";
        ModifierFlags2[ModifierFlags2["TypeScriptModifier"] = 2270] = "TypeScriptModifier";
        ModifierFlags2[ModifierFlags2["ExportDefault"] = 513] = "ExportDefault";
        ModifierFlags2[ModifierFlags2["All"] = 3071] = "All";
      })(ModifierFlags = ts2.ModifierFlags || (ts2.ModifierFlags = {}));
      var JsxFlags;
      (function(JsxFlags2) {
        JsxFlags2[JsxFlags2["None"] = 0] = "None";
        JsxFlags2[JsxFlags2["IntrinsicNamedElement"] = 1] = "IntrinsicNamedElement";
        JsxFlags2[JsxFlags2["IntrinsicIndexedElement"] = 2] = "IntrinsicIndexedElement";
        JsxFlags2[JsxFlags2["IntrinsicElement"] = 3] = "IntrinsicElement";
      })(JsxFlags = ts2.JsxFlags || (ts2.JsxFlags = {}));
      var RelationComparisonResult;
      (function(RelationComparisonResult2) {
        RelationComparisonResult2[RelationComparisonResult2["Succeeded"] = 1] = "Succeeded";
        RelationComparisonResult2[RelationComparisonResult2["Failed"] = 2] = "Failed";
        RelationComparisonResult2[RelationComparisonResult2["Reported"] = 4] = "Reported";
        RelationComparisonResult2[RelationComparisonResult2["ReportsUnmeasurable"] = 8] = "ReportsUnmeasurable";
        RelationComparisonResult2[RelationComparisonResult2["ReportsUnreliable"] = 16] = "ReportsUnreliable";
        RelationComparisonResult2[RelationComparisonResult2["ReportsMask"] = 24] = "ReportsMask";
      })(RelationComparisonResult = ts2.RelationComparisonResult || (ts2.RelationComparisonResult = {}));
      var GeneratedIdentifierFlags;
      (function(GeneratedIdentifierFlags2) {
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["None"] = 0] = "None";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Auto"] = 1] = "Auto";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Loop"] = 2] = "Loop";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Unique"] = 3] = "Unique";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Node"] = 4] = "Node";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["KindMask"] = 7] = "KindMask";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["ReservedInNestedScopes"] = 8] = "ReservedInNestedScopes";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Optimistic"] = 16] = "Optimistic";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["FileLevel"] = 32] = "FileLevel";
      })(GeneratedIdentifierFlags = ts2.GeneratedIdentifierFlags || (ts2.GeneratedIdentifierFlags = {}));
      var TokenFlags;
      (function(TokenFlags2) {
        TokenFlags2[TokenFlags2["None"] = 0] = "None";
        TokenFlags2[TokenFlags2["PrecedingLineBreak"] = 1] = "PrecedingLineBreak";
        TokenFlags2[TokenFlags2["PrecedingJSDocComment"] = 2] = "PrecedingJSDocComment";
        TokenFlags2[TokenFlags2["Unterminated"] = 4] = "Unterminated";
        TokenFlags2[TokenFlags2["ExtendedUnicodeEscape"] = 8] = "ExtendedUnicodeEscape";
        TokenFlags2[TokenFlags2["Scientific"] = 16] = "Scientific";
        TokenFlags2[TokenFlags2["Octal"] = 32] = "Octal";
        TokenFlags2[TokenFlags2["HexSpecifier"] = 64] = "HexSpecifier";
        TokenFlags2[TokenFlags2["BinarySpecifier"] = 128] = "BinarySpecifier";
        TokenFlags2[TokenFlags2["OctalSpecifier"] = 256] = "OctalSpecifier";
        TokenFlags2[TokenFlags2["ContainsSeparator"] = 512] = "ContainsSeparator";
        TokenFlags2[TokenFlags2["UnicodeEscape"] = 1024] = "UnicodeEscape";
        TokenFlags2[TokenFlags2["ContainsInvalidEscape"] = 2048] = "ContainsInvalidEscape";
        TokenFlags2[TokenFlags2["BinaryOrOctalSpecifier"] = 384] = "BinaryOrOctalSpecifier";
        TokenFlags2[TokenFlags2["NumericLiteralFlags"] = 1008] = "NumericLiteralFlags";
      })(TokenFlags = ts2.TokenFlags || (ts2.TokenFlags = {}));
      var FlowFlags;
      (function(FlowFlags2) {
        FlowFlags2[FlowFlags2["Unreachable"] = 1] = "Unreachable";
        FlowFlags2[FlowFlags2["Start"] = 2] = "Start";
        FlowFlags2[FlowFlags2["BranchLabel"] = 4] = "BranchLabel";
        FlowFlags2[FlowFlags2["LoopLabel"] = 8] = "LoopLabel";
        FlowFlags2[FlowFlags2["Assignment"] = 16] = "Assignment";
        FlowFlags2[FlowFlags2["TrueCondition"] = 32] = "TrueCondition";
        FlowFlags2[FlowFlags2["FalseCondition"] = 64] = "FalseCondition";
        FlowFlags2[FlowFlags2["SwitchClause"] = 128] = "SwitchClause";
        FlowFlags2[FlowFlags2["ArrayMutation"] = 256] = "ArrayMutation";
        FlowFlags2[FlowFlags2["Call"] = 512] = "Call";
        FlowFlags2[FlowFlags2["ReduceLabel"] = 1024] = "ReduceLabel";
        FlowFlags2[FlowFlags2["Referenced"] = 2048] = "Referenced";
        FlowFlags2[FlowFlags2["Shared"] = 4096] = "Shared";
        FlowFlags2[FlowFlags2["Label"] = 12] = "Label";
        FlowFlags2[FlowFlags2["Condition"] = 96] = "Condition";
      })(FlowFlags = ts2.FlowFlags || (ts2.FlowFlags = {}));
      var CommentDirectiveType;
      (function(CommentDirectiveType2) {
        CommentDirectiveType2[CommentDirectiveType2["ExpectError"] = 0] = "ExpectError";
        CommentDirectiveType2[CommentDirectiveType2["Ignore"] = 1] = "Ignore";
      })(CommentDirectiveType = ts2.CommentDirectiveType || (ts2.CommentDirectiveType = {}));
      var OperationCanceledException = function() {
        function OperationCanceledException2() {
        }
        return OperationCanceledException2;
      }();
      ts2.OperationCanceledException = OperationCanceledException;
      var RefFileKind;
      (function(RefFileKind2) {
        RefFileKind2[RefFileKind2["Import"] = 0] = "Import";
        RefFileKind2[RefFileKind2["ReferenceFile"] = 1] = "ReferenceFile";
        RefFileKind2[RefFileKind2["TypeReferenceDirective"] = 2] = "TypeReferenceDirective";
      })(RefFileKind = ts2.RefFileKind || (ts2.RefFileKind = {}));
      var StructureIsReused;
      (function(StructureIsReused2) {
        StructureIsReused2[StructureIsReused2["Not"] = 0] = "Not";
        StructureIsReused2[StructureIsReused2["SafeModules"] = 1] = "SafeModules";
        StructureIsReused2[StructureIsReused2["Completely"] = 2] = "Completely";
      })(StructureIsReused = ts2.StructureIsReused || (ts2.StructureIsReused = {}));
      var ExitStatus;
      (function(ExitStatus2) {
        ExitStatus2[ExitStatus2["Success"] = 0] = "Success";
        ExitStatus2[ExitStatus2["DiagnosticsPresent_OutputsSkipped"] = 1] = "DiagnosticsPresent_OutputsSkipped";
        ExitStatus2[ExitStatus2["DiagnosticsPresent_OutputsGenerated"] = 2] = "DiagnosticsPresent_OutputsGenerated";
        ExitStatus2[ExitStatus2["InvalidProject_OutputsSkipped"] = 3] = "InvalidProject_OutputsSkipped";
        ExitStatus2[ExitStatus2["ProjectReferenceCycle_OutputsSkipped"] = 4] = "ProjectReferenceCycle_OutputsSkipped";
        ExitStatus2[ExitStatus2["ProjectReferenceCycle_OutputsSkupped"] = 4] = "ProjectReferenceCycle_OutputsSkupped";
      })(ExitStatus = ts2.ExitStatus || (ts2.ExitStatus = {}));
      var UnionReduction;
      (function(UnionReduction2) {
        UnionReduction2[UnionReduction2["None"] = 0] = "None";
        UnionReduction2[UnionReduction2["Literal"] = 1] = "Literal";
        UnionReduction2[UnionReduction2["Subtype"] = 2] = "Subtype";
      })(UnionReduction = ts2.UnionReduction || (ts2.UnionReduction = {}));
      var ContextFlags;
      (function(ContextFlags2) {
        ContextFlags2[ContextFlags2["None"] = 0] = "None";
        ContextFlags2[ContextFlags2["Signature"] = 1] = "Signature";
        ContextFlags2[ContextFlags2["NoConstraints"] = 2] = "NoConstraints";
        ContextFlags2[ContextFlags2["Completions"] = 4] = "Completions";
      })(ContextFlags = ts2.ContextFlags || (ts2.ContextFlags = {}));
      var NodeBuilderFlags;
      (function(NodeBuilderFlags2) {
        NodeBuilderFlags2[NodeBuilderFlags2["None"] = 0] = "None";
        NodeBuilderFlags2[NodeBuilderFlags2["NoTruncation"] = 1] = "NoTruncation";
        NodeBuilderFlags2[NodeBuilderFlags2["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
        NodeBuilderFlags2[NodeBuilderFlags2["GenerateNamesForShadowedTypeParams"] = 4] = "GenerateNamesForShadowedTypeParams";
        NodeBuilderFlags2[NodeBuilderFlags2["UseStructuralFallback"] = 8] = "UseStructuralFallback";
        NodeBuilderFlags2[NodeBuilderFlags2["ForbidIndexedAccessSymbolReferences"] = 16] = "ForbidIndexedAccessSymbolReferences";
        NodeBuilderFlags2[NodeBuilderFlags2["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
        NodeBuilderFlags2[NodeBuilderFlags2["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
        NodeBuilderFlags2[NodeBuilderFlags2["UseOnlyExternalAliasing"] = 128] = "UseOnlyExternalAliasing";
        NodeBuilderFlags2[NodeBuilderFlags2["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
        NodeBuilderFlags2[NodeBuilderFlags2["WriteTypeParametersInQualifiedName"] = 512] = "WriteTypeParametersInQualifiedName";
        NodeBuilderFlags2[NodeBuilderFlags2["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
        NodeBuilderFlags2[NodeBuilderFlags2["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
        NodeBuilderFlags2[NodeBuilderFlags2["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
        NodeBuilderFlags2[NodeBuilderFlags2["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
        NodeBuilderFlags2[NodeBuilderFlags2["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
        NodeBuilderFlags2[NodeBuilderFlags2["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
        NodeBuilderFlags2[NodeBuilderFlags2["NoTypeReduction"] = 536870912] = "NoTypeReduction";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowThisInObjectLiteral"] = 32768] = "AllowThisInObjectLiteral";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowQualifedNameInPlaceOfIdentifier"] = 65536] = "AllowQualifedNameInPlaceOfIdentifier";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowAnonymousIdentifier"] = 131072] = "AllowAnonymousIdentifier";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyUnionOrIntersection"] = 262144] = "AllowEmptyUnionOrIntersection";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyTuple"] = 524288] = "AllowEmptyTuple";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyIndexInfoType"] = 2097152] = "AllowEmptyIndexInfoType";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowNodeModulesRelativePaths"] = 67108864] = "AllowNodeModulesRelativePaths";
        NodeBuilderFlags2[NodeBuilderFlags2["DoNotIncludeSymbolChain"] = 134217728] = "DoNotIncludeSymbolChain";
        NodeBuilderFlags2[NodeBuilderFlags2["IgnoreErrors"] = 70221824] = "IgnoreErrors";
        NodeBuilderFlags2[NodeBuilderFlags2["InObjectTypeLiteral"] = 4194304] = "InObjectTypeLiteral";
        NodeBuilderFlags2[NodeBuilderFlags2["InTypeAlias"] = 8388608] = "InTypeAlias";
        NodeBuilderFlags2[NodeBuilderFlags2["InInitialEntityName"] = 16777216] = "InInitialEntityName";
        NodeBuilderFlags2[NodeBuilderFlags2["InReverseMappedType"] = 33554432] = "InReverseMappedType";
      })(NodeBuilderFlags = ts2.NodeBuilderFlags || (ts2.NodeBuilderFlags = {}));
      var TypeFormatFlags;
      (function(TypeFormatFlags2) {
        TypeFormatFlags2[TypeFormatFlags2["None"] = 0] = "None";
        TypeFormatFlags2[TypeFormatFlags2["NoTruncation"] = 1] = "NoTruncation";
        TypeFormatFlags2[TypeFormatFlags2["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
        TypeFormatFlags2[TypeFormatFlags2["UseStructuralFallback"] = 8] = "UseStructuralFallback";
        TypeFormatFlags2[TypeFormatFlags2["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
        TypeFormatFlags2[TypeFormatFlags2["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
        TypeFormatFlags2[TypeFormatFlags2["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
        TypeFormatFlags2[TypeFormatFlags2["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
        TypeFormatFlags2[TypeFormatFlags2["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
        TypeFormatFlags2[TypeFormatFlags2["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
        TypeFormatFlags2[TypeFormatFlags2["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
        TypeFormatFlags2[TypeFormatFlags2["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
        TypeFormatFlags2[TypeFormatFlags2["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
        TypeFormatFlags2[TypeFormatFlags2["NoTypeReduction"] = 536870912] = "NoTypeReduction";
        TypeFormatFlags2[TypeFormatFlags2["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
        TypeFormatFlags2[TypeFormatFlags2["AddUndefined"] = 131072] = "AddUndefined";
        TypeFormatFlags2[TypeFormatFlags2["WriteArrowStyleSignature"] = 262144] = "WriteArrowStyleSignature";
        TypeFormatFlags2[TypeFormatFlags2["InArrayType"] = 524288] = "InArrayType";
        TypeFormatFlags2[TypeFormatFlags2["InElementType"] = 2097152] = "InElementType";
        TypeFormatFlags2[TypeFormatFlags2["InFirstTypeArgument"] = 4194304] = "InFirstTypeArgument";
        TypeFormatFlags2[TypeFormatFlags2["InTypeAlias"] = 8388608] = "InTypeAlias";
        TypeFormatFlags2[TypeFormatFlags2["WriteOwnNameForAnyLike"] = 0] = "WriteOwnNameForAnyLike";
        TypeFormatFlags2[TypeFormatFlags2["NodeBuilderFlagsMask"] = 814775659] = "NodeBuilderFlagsMask";
      })(TypeFormatFlags = ts2.TypeFormatFlags || (ts2.TypeFormatFlags = {}));
      var SymbolFormatFlags;
      (function(SymbolFormatFlags2) {
        SymbolFormatFlags2[SymbolFormatFlags2["None"] = 0] = "None";
        SymbolFormatFlags2[SymbolFormatFlags2["WriteTypeParametersOrArguments"] = 1] = "WriteTypeParametersOrArguments";
        SymbolFormatFlags2[SymbolFormatFlags2["UseOnlyExternalAliasing"] = 2] = "UseOnlyExternalAliasing";
        SymbolFormatFlags2[SymbolFormatFlags2["AllowAnyNodeKind"] = 4] = "AllowAnyNodeKind";
        SymbolFormatFlags2[SymbolFormatFlags2["UseAliasDefinedOutsideCurrentScope"] = 8] = "UseAliasDefinedOutsideCurrentScope";
        SymbolFormatFlags2[SymbolFormatFlags2["DoNotIncludeSymbolChain"] = 16] = "DoNotIncludeSymbolChain";
      })(SymbolFormatFlags = ts2.SymbolFormatFlags || (ts2.SymbolFormatFlags = {}));
      var SymbolAccessibility;
      (function(SymbolAccessibility2) {
        SymbolAccessibility2[SymbolAccessibility2["Accessible"] = 0] = "Accessible";
        SymbolAccessibility2[SymbolAccessibility2["NotAccessible"] = 1] = "NotAccessible";
        SymbolAccessibility2[SymbolAccessibility2["CannotBeNamed"] = 2] = "CannotBeNamed";
      })(SymbolAccessibility = ts2.SymbolAccessibility || (ts2.SymbolAccessibility = {}));
      var SyntheticSymbolKind;
      (function(SyntheticSymbolKind2) {
        SyntheticSymbolKind2[SyntheticSymbolKind2["UnionOrIntersection"] = 0] = "UnionOrIntersection";
        SyntheticSymbolKind2[SyntheticSymbolKind2["Spread"] = 1] = "Spread";
      })(SyntheticSymbolKind = ts2.SyntheticSymbolKind || (ts2.SyntheticSymbolKind = {}));
      var TypePredicateKind;
      (function(TypePredicateKind2) {
        TypePredicateKind2[TypePredicateKind2["This"] = 0] = "This";
        TypePredicateKind2[TypePredicateKind2["Identifier"] = 1] = "Identifier";
        TypePredicateKind2[TypePredicateKind2["AssertsThis"] = 2] = "AssertsThis";
        TypePredicateKind2[TypePredicateKind2["AssertsIdentifier"] = 3] = "AssertsIdentifier";
      })(TypePredicateKind = ts2.TypePredicateKind || (ts2.TypePredicateKind = {}));
      var TypeReferenceSerializationKind;
      (function(TypeReferenceSerializationKind2) {
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["Unknown"] = 0] = "Unknown";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["TypeWithConstructSignatureAndValue"] = 1] = "TypeWithConstructSignatureAndValue";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["VoidNullableOrNeverType"] = 2] = "VoidNullableOrNeverType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["NumberLikeType"] = 3] = "NumberLikeType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["BigIntLikeType"] = 4] = "BigIntLikeType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["StringLikeType"] = 5] = "StringLikeType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["BooleanType"] = 6] = "BooleanType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ArrayLikeType"] = 7] = "ArrayLikeType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ESSymbolType"] = 8] = "ESSymbolType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["Promise"] = 9] = "Promise";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["TypeWithCallSignature"] = 10] = "TypeWithCallSignature";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ObjectType"] = 11] = "ObjectType";
      })(TypeReferenceSerializationKind = ts2.TypeReferenceSerializationKind || (ts2.TypeReferenceSerializationKind = {}));
      var SymbolFlags;
      (function(SymbolFlags2) {
        SymbolFlags2[SymbolFlags2["None"] = 0] = "None";
        SymbolFlags2[SymbolFlags2["FunctionScopedVariable"] = 1] = "FunctionScopedVariable";
        SymbolFlags2[SymbolFlags2["BlockScopedVariable"] = 2] = "BlockScopedVariable";
        SymbolFlags2[SymbolFlags2["Property"] = 4] = "Property";
        SymbolFlags2[SymbolFlags2["EnumMember"] = 8] = "EnumMember";
        SymbolFlags2[SymbolFlags2["Function"] = 16] = "Function";
        SymbolFlags2[SymbolFlags2["Class"] = 32] = "Class";
        SymbolFlags2[SymbolFlags2["Interface"] = 64] = "Interface";
        SymbolFlags2[SymbolFlags2["ConstEnum"] = 128] = "ConstEnum";
        SymbolFlags2[SymbolFlags2["RegularEnum"] = 256] = "RegularEnum";
        SymbolFlags2[SymbolFlags2["ValueModule"] = 512] = "ValueModule";
        SymbolFlags2[SymbolFlags2["NamespaceModule"] = 1024] = "NamespaceModule";
        SymbolFlags2[SymbolFlags2["TypeLiteral"] = 2048] = "TypeLiteral";
        SymbolFlags2[SymbolFlags2["ObjectLiteral"] = 4096] = "ObjectLiteral";
        SymbolFlags2[SymbolFlags2["Method"] = 8192] = "Method";
        SymbolFlags2[SymbolFlags2["Constructor"] = 16384] = "Constructor";
        SymbolFlags2[SymbolFlags2["GetAccessor"] = 32768] = "GetAccessor";
        SymbolFlags2[SymbolFlags2["SetAccessor"] = 65536] = "SetAccessor";
        SymbolFlags2[SymbolFlags2["Signature"] = 131072] = "Signature";
        SymbolFlags2[SymbolFlags2["TypeParameter"] = 262144] = "TypeParameter";
        SymbolFlags2[SymbolFlags2["TypeAlias"] = 524288] = "TypeAlias";
        SymbolFlags2[SymbolFlags2["ExportValue"] = 1048576] = "ExportValue";
        SymbolFlags2[SymbolFlags2["Alias"] = 2097152] = "Alias";
        SymbolFlags2[SymbolFlags2["Prototype"] = 4194304] = "Prototype";
        SymbolFlags2[SymbolFlags2["ExportStar"] = 8388608] = "ExportStar";
        SymbolFlags2[SymbolFlags2["Optional"] = 16777216] = "Optional";
        SymbolFlags2[SymbolFlags2["Transient"] = 33554432] = "Transient";
        SymbolFlags2[SymbolFlags2["Assignment"] = 67108864] = "Assignment";
        SymbolFlags2[SymbolFlags2["ModuleExports"] = 134217728] = "ModuleExports";
        SymbolFlags2[SymbolFlags2["All"] = 67108863] = "All";
        SymbolFlags2[SymbolFlags2["Enum"] = 384] = "Enum";
        SymbolFlags2[SymbolFlags2["Variable"] = 3] = "Variable";
        SymbolFlags2[SymbolFlags2["Value"] = 111551] = "Value";
        SymbolFlags2[SymbolFlags2["Type"] = 788968] = "Type";
        SymbolFlags2[SymbolFlags2["Namespace"] = 1920] = "Namespace";
        SymbolFlags2[SymbolFlags2["Module"] = 1536] = "Module";
        SymbolFlags2[SymbolFlags2["Accessor"] = 98304] = "Accessor";
        SymbolFlags2[SymbolFlags2["FunctionScopedVariableExcludes"] = 111550] = "FunctionScopedVariableExcludes";
        SymbolFlags2[SymbolFlags2["BlockScopedVariableExcludes"] = 111551] = "BlockScopedVariableExcludes";
        SymbolFlags2[SymbolFlags2["ParameterExcludes"] = 111551] = "ParameterExcludes";
        SymbolFlags2[SymbolFlags2["PropertyExcludes"] = 0] = "PropertyExcludes";
        SymbolFlags2[SymbolFlags2["EnumMemberExcludes"] = 900095] = "EnumMemberExcludes";
        SymbolFlags2[SymbolFlags2["FunctionExcludes"] = 110991] = "FunctionExcludes";
        SymbolFlags2[SymbolFlags2["ClassExcludes"] = 899503] = "ClassExcludes";
        SymbolFlags2[SymbolFlags2["InterfaceExcludes"] = 788872] = "InterfaceExcludes";
        SymbolFlags2[SymbolFlags2["RegularEnumExcludes"] = 899327] = "RegularEnumExcludes";
        SymbolFlags2[SymbolFlags2["ConstEnumExcludes"] = 899967] = "ConstEnumExcludes";
        SymbolFlags2[SymbolFlags2["ValueModuleExcludes"] = 110735] = "ValueModuleExcludes";
        SymbolFlags2[SymbolFlags2["NamespaceModuleExcludes"] = 0] = "NamespaceModuleExcludes";
        SymbolFlags2[SymbolFlags2["MethodExcludes"] = 103359] = "MethodExcludes";
        SymbolFlags2[SymbolFlags2["GetAccessorExcludes"] = 46015] = "GetAccessorExcludes";
        SymbolFlags2[SymbolFlags2["SetAccessorExcludes"] = 78783] = "SetAccessorExcludes";
        SymbolFlags2[SymbolFlags2["TypeParameterExcludes"] = 526824] = "TypeParameterExcludes";
        SymbolFlags2[SymbolFlags2["TypeAliasExcludes"] = 788968] = "TypeAliasExcludes";
        SymbolFlags2[SymbolFlags2["AliasExcludes"] = 2097152] = "AliasExcludes";
        SymbolFlags2[SymbolFlags2["ModuleMember"] = 2623475] = "ModuleMember";
        SymbolFlags2[SymbolFlags2["ExportHasLocal"] = 944] = "ExportHasLocal";
        SymbolFlags2[SymbolFlags2["BlockScoped"] = 418] = "BlockScoped";
        SymbolFlags2[SymbolFlags2["PropertyOrAccessor"] = 98308] = "PropertyOrAccessor";
        SymbolFlags2[SymbolFlags2["ClassMember"] = 106500] = "ClassMember";
        SymbolFlags2[SymbolFlags2["ExportSupportsDefaultModifier"] = 112] = "ExportSupportsDefaultModifier";
        SymbolFlags2[SymbolFlags2["ExportDoesNotSupportDefaultModifier"] = -113] = "ExportDoesNotSupportDefaultModifier";
        SymbolFlags2[SymbolFlags2["Classifiable"] = 2885600] = "Classifiable";
        SymbolFlags2[SymbolFlags2["LateBindingContainer"] = 6256] = "LateBindingContainer";
      })(SymbolFlags = ts2.SymbolFlags || (ts2.SymbolFlags = {}));
      var EnumKind;
      (function(EnumKind2) {
        EnumKind2[EnumKind2["Numeric"] = 0] = "Numeric";
        EnumKind2[EnumKind2["Literal"] = 1] = "Literal";
      })(EnumKind = ts2.EnumKind || (ts2.EnumKind = {}));
      var CheckFlags;
      (function(CheckFlags2) {
        CheckFlags2[CheckFlags2["Instantiated"] = 1] = "Instantiated";
        CheckFlags2[CheckFlags2["SyntheticProperty"] = 2] = "SyntheticProperty";
        CheckFlags2[CheckFlags2["SyntheticMethod"] = 4] = "SyntheticMethod";
        CheckFlags2[CheckFlags2["Readonly"] = 8] = "Readonly";
        CheckFlags2[CheckFlags2["ReadPartial"] = 16] = "ReadPartial";
        CheckFlags2[CheckFlags2["WritePartial"] = 32] = "WritePartial";
        CheckFlags2[CheckFlags2["HasNonUniformType"] = 64] = "HasNonUniformType";
        CheckFlags2[CheckFlags2["HasLiteralType"] = 128] = "HasLiteralType";
        CheckFlags2[CheckFlags2["ContainsPublic"] = 256] = "ContainsPublic";
        CheckFlags2[CheckFlags2["ContainsProtected"] = 512] = "ContainsProtected";
        CheckFlags2[CheckFlags2["ContainsPrivate"] = 1024] = "ContainsPrivate";
        CheckFlags2[CheckFlags2["ContainsStatic"] = 2048] = "ContainsStatic";
        CheckFlags2[CheckFlags2["Late"] = 4096] = "Late";
        CheckFlags2[CheckFlags2["ReverseMapped"] = 8192] = "ReverseMapped";
        CheckFlags2[CheckFlags2["OptionalParameter"] = 16384] = "OptionalParameter";
        CheckFlags2[CheckFlags2["RestParameter"] = 32768] = "RestParameter";
        CheckFlags2[CheckFlags2["DeferredType"] = 65536] = "DeferredType";
        CheckFlags2[CheckFlags2["HasNeverType"] = 131072] = "HasNeverType";
        CheckFlags2[CheckFlags2["Mapped"] = 262144] = "Mapped";
        CheckFlags2[CheckFlags2["StripOptional"] = 524288] = "StripOptional";
        CheckFlags2[CheckFlags2["Synthetic"] = 6] = "Synthetic";
        CheckFlags2[CheckFlags2["Discriminant"] = 192] = "Discriminant";
        CheckFlags2[CheckFlags2["Partial"] = 48] = "Partial";
      })(CheckFlags = ts2.CheckFlags || (ts2.CheckFlags = {}));
      var InternalSymbolName;
      (function(InternalSymbolName2) {
        InternalSymbolName2["Call"] = "__call";
        InternalSymbolName2["Constructor"] = "__constructor";
        InternalSymbolName2["New"] = "__new";
        InternalSymbolName2["Index"] = "__index";
        InternalSymbolName2["ExportStar"] = "__export";
        InternalSymbolName2["Global"] = "__global";
        InternalSymbolName2["Missing"] = "__missing";
        InternalSymbolName2["Type"] = "__type";
        InternalSymbolName2["Object"] = "__object";
        InternalSymbolName2["JSXAttributes"] = "__jsxAttributes";
        InternalSymbolName2["Class"] = "__class";
        InternalSymbolName2["Function"] = "__function";
        InternalSymbolName2["Computed"] = "__computed";
        InternalSymbolName2["Resolving"] = "__resolving__";
        InternalSymbolName2["ExportEquals"] = "export=";
        InternalSymbolName2["Default"] = "default";
        InternalSymbolName2["This"] = "this";
      })(InternalSymbolName = ts2.InternalSymbolName || (ts2.InternalSymbolName = {}));
      var NodeCheckFlags;
      (function(NodeCheckFlags2) {
        NodeCheckFlags2[NodeCheckFlags2["TypeChecked"] = 1] = "TypeChecked";
        NodeCheckFlags2[NodeCheckFlags2["LexicalThis"] = 2] = "LexicalThis";
        NodeCheckFlags2[NodeCheckFlags2["CaptureThis"] = 4] = "CaptureThis";
        NodeCheckFlags2[NodeCheckFlags2["CaptureNewTarget"] = 8] = "CaptureNewTarget";
        NodeCheckFlags2[NodeCheckFlags2["SuperInstance"] = 256] = "SuperInstance";
        NodeCheckFlags2[NodeCheckFlags2["SuperStatic"] = 512] = "SuperStatic";
        NodeCheckFlags2[NodeCheckFlags2["ContextChecked"] = 1024] = "ContextChecked";
        NodeCheckFlags2[NodeCheckFlags2["AsyncMethodWithSuper"] = 2048] = "AsyncMethodWithSuper";
        NodeCheckFlags2[NodeCheckFlags2["AsyncMethodWithSuperBinding"] = 4096] = "AsyncMethodWithSuperBinding";
        NodeCheckFlags2[NodeCheckFlags2["CaptureArguments"] = 8192] = "CaptureArguments";
        NodeCheckFlags2[NodeCheckFlags2["EnumValuesComputed"] = 16384] = "EnumValuesComputed";
        NodeCheckFlags2[NodeCheckFlags2["LexicalModuleMergesWithClass"] = 32768] = "LexicalModuleMergesWithClass";
        NodeCheckFlags2[NodeCheckFlags2["LoopWithCapturedBlockScopedBinding"] = 65536] = "LoopWithCapturedBlockScopedBinding";
        NodeCheckFlags2[NodeCheckFlags2["ContainsCapturedBlockScopeBinding"] = 131072] = "ContainsCapturedBlockScopeBinding";
        NodeCheckFlags2[NodeCheckFlags2["CapturedBlockScopedBinding"] = 262144] = "CapturedBlockScopedBinding";
        NodeCheckFlags2[NodeCheckFlags2["BlockScopedBindingInLoop"] = 524288] = "BlockScopedBindingInLoop";
        NodeCheckFlags2[NodeCheckFlags2["ClassWithBodyScopedClassBinding"] = 1048576] = "ClassWithBodyScopedClassBinding";
        NodeCheckFlags2[NodeCheckFlags2["BodyScopedClassBinding"] = 2097152] = "BodyScopedClassBinding";
        NodeCheckFlags2[NodeCheckFlags2["NeedsLoopOutParameter"] = 4194304] = "NeedsLoopOutParameter";
        NodeCheckFlags2[NodeCheckFlags2["AssignmentsMarked"] = 8388608] = "AssignmentsMarked";
        NodeCheckFlags2[NodeCheckFlags2["ClassWithConstructorReference"] = 16777216] = "ClassWithConstructorReference";
        NodeCheckFlags2[NodeCheckFlags2["ConstructorReferenceInClass"] = 33554432] = "ConstructorReferenceInClass";
        NodeCheckFlags2[NodeCheckFlags2["ContainsClassWithPrivateIdentifiers"] = 67108864] = "ContainsClassWithPrivateIdentifiers";
      })(NodeCheckFlags = ts2.NodeCheckFlags || (ts2.NodeCheckFlags = {}));
      var TypeFlags;
      (function(TypeFlags2) {
        TypeFlags2[TypeFlags2["Any"] = 1] = "Any";
        TypeFlags2[TypeFlags2["Unknown"] = 2] = "Unknown";
        TypeFlags2[TypeFlags2["String"] = 4] = "String";
        TypeFlags2[TypeFlags2["Number"] = 8] = "Number";
        TypeFlags2[TypeFlags2["Boolean"] = 16] = "Boolean";
        TypeFlags2[TypeFlags2["Enum"] = 32] = "Enum";
        TypeFlags2[TypeFlags2["BigInt"] = 64] = "BigInt";
        TypeFlags2[TypeFlags2["StringLiteral"] = 128] = "StringLiteral";
        TypeFlags2[TypeFlags2["NumberLiteral"] = 256] = "NumberLiteral";
        TypeFlags2[TypeFlags2["BooleanLiteral"] = 512] = "BooleanLiteral";
        TypeFlags2[TypeFlags2["EnumLiteral"] = 1024] = "EnumLiteral";
        TypeFlags2[TypeFlags2["BigIntLiteral"] = 2048] = "BigIntLiteral";
        TypeFlags2[TypeFlags2["ESSymbol"] = 4096] = "ESSymbol";
        TypeFlags2[TypeFlags2["UniqueESSymbol"] = 8192] = "UniqueESSymbol";
        TypeFlags2[TypeFlags2["Void"] = 16384] = "Void";
        TypeFlags2[TypeFlags2["Undefined"] = 32768] = "Undefined";
        TypeFlags2[TypeFlags2["Null"] = 65536] = "Null";
        TypeFlags2[TypeFlags2["Never"] = 131072] = "Never";
        TypeFlags2[TypeFlags2["TypeParameter"] = 262144] = "TypeParameter";
        TypeFlags2[TypeFlags2["Object"] = 524288] = "Object";
        TypeFlags2[TypeFlags2["Union"] = 1048576] = "Union";
        TypeFlags2[TypeFlags2["Intersection"] = 2097152] = "Intersection";
        TypeFlags2[TypeFlags2["Index"] = 4194304] = "Index";
        TypeFlags2[TypeFlags2["IndexedAccess"] = 8388608] = "IndexedAccess";
        TypeFlags2[TypeFlags2["Conditional"] = 16777216] = "Conditional";
        TypeFlags2[TypeFlags2["Substitution"] = 33554432] = "Substitution";
        TypeFlags2[TypeFlags2["NonPrimitive"] = 67108864] = "NonPrimitive";
        TypeFlags2[TypeFlags2["AnyOrUnknown"] = 3] = "AnyOrUnknown";
        TypeFlags2[TypeFlags2["Nullable"] = 98304] = "Nullable";
        TypeFlags2[TypeFlags2["Literal"] = 2944] = "Literal";
        TypeFlags2[TypeFlags2["Unit"] = 109440] = "Unit";
        TypeFlags2[TypeFlags2["StringOrNumberLiteral"] = 384] = "StringOrNumberLiteral";
        TypeFlags2[TypeFlags2["StringOrNumberLiteralOrUnique"] = 8576] = "StringOrNumberLiteralOrUnique";
        TypeFlags2[TypeFlags2["DefinitelyFalsy"] = 117632] = "DefinitelyFalsy";
        TypeFlags2[TypeFlags2["PossiblyFalsy"] = 117724] = "PossiblyFalsy";
        TypeFlags2[TypeFlags2["Intrinsic"] = 67359327] = "Intrinsic";
        TypeFlags2[TypeFlags2["Primitive"] = 131068] = "Primitive";
        TypeFlags2[TypeFlags2["StringLike"] = 132] = "StringLike";
        TypeFlags2[TypeFlags2["NumberLike"] = 296] = "NumberLike";
        TypeFlags2[TypeFlags2["BigIntLike"] = 2112] = "BigIntLike";
        TypeFlags2[TypeFlags2["BooleanLike"] = 528] = "BooleanLike";
        TypeFlags2[TypeFlags2["EnumLike"] = 1056] = "EnumLike";
        TypeFlags2[TypeFlags2["ESSymbolLike"] = 12288] = "ESSymbolLike";
        TypeFlags2[TypeFlags2["VoidLike"] = 49152] = "VoidLike";
        TypeFlags2[TypeFlags2["DisjointDomains"] = 67238908] = "DisjointDomains";
        TypeFlags2[TypeFlags2["UnionOrIntersection"] = 3145728] = "UnionOrIntersection";
        TypeFlags2[TypeFlags2["StructuredType"] = 3670016] = "StructuredType";
        TypeFlags2[TypeFlags2["TypeVariable"] = 8650752] = "TypeVariable";
        TypeFlags2[TypeFlags2["InstantiableNonPrimitive"] = 58982400] = "InstantiableNonPrimitive";
        TypeFlags2[TypeFlags2["InstantiablePrimitive"] = 4194304] = "InstantiablePrimitive";
        TypeFlags2[TypeFlags2["Instantiable"] = 63176704] = "Instantiable";
        TypeFlags2[TypeFlags2["StructuredOrInstantiable"] = 66846720] = "StructuredOrInstantiable";
        TypeFlags2[TypeFlags2["ObjectFlagsType"] = 3899393] = "ObjectFlagsType";
        TypeFlags2[TypeFlags2["Simplifiable"] = 25165824] = "Simplifiable";
        TypeFlags2[TypeFlags2["Substructure"] = 66584576] = "Substructure";
        TypeFlags2[TypeFlags2["Narrowable"] = 133970943] = "Narrowable";
        TypeFlags2[TypeFlags2["NotUnionOrUnit"] = 67637251] = "NotUnionOrUnit";
        TypeFlags2[TypeFlags2["NotPrimitiveUnion"] = 66994211] = "NotPrimitiveUnion";
        TypeFlags2[TypeFlags2["IncludesMask"] = 71041023] = "IncludesMask";
        TypeFlags2[TypeFlags2["IncludesStructuredOrInstantiable"] = 262144] = "IncludesStructuredOrInstantiable";
        TypeFlags2[TypeFlags2["IncludesNonWideningType"] = 4194304] = "IncludesNonWideningType";
        TypeFlags2[TypeFlags2["IncludesWildcard"] = 8388608] = "IncludesWildcard";
        TypeFlags2[TypeFlags2["IncludesEmptyObject"] = 16777216] = "IncludesEmptyObject";
      })(TypeFlags = ts2.TypeFlags || (ts2.TypeFlags = {}));
      var ObjectFlags;
      (function(ObjectFlags2) {
        ObjectFlags2[ObjectFlags2["Class"] = 1] = "Class";
        ObjectFlags2[ObjectFlags2["Interface"] = 2] = "Interface";
        ObjectFlags2[ObjectFlags2["Reference"] = 4] = "Reference";
        ObjectFlags2[ObjectFlags2["Tuple"] = 8] = "Tuple";
        ObjectFlags2[ObjectFlags2["Anonymous"] = 16] = "Anonymous";
        ObjectFlags2[ObjectFlags2["Mapped"] = 32] = "Mapped";
        ObjectFlags2[ObjectFlags2["Instantiated"] = 64] = "Instantiated";
        ObjectFlags2[ObjectFlags2["ObjectLiteral"] = 128] = "ObjectLiteral";
        ObjectFlags2[ObjectFlags2["EvolvingArray"] = 256] = "EvolvingArray";
        ObjectFlags2[ObjectFlags2["ObjectLiteralPatternWithComputedProperties"] = 512] = "ObjectLiteralPatternWithComputedProperties";
        ObjectFlags2[ObjectFlags2["ContainsSpread"] = 1024] = "ContainsSpread";
        ObjectFlags2[ObjectFlags2["ReverseMapped"] = 2048] = "ReverseMapped";
        ObjectFlags2[ObjectFlags2["JsxAttributes"] = 4096] = "JsxAttributes";
        ObjectFlags2[ObjectFlags2["MarkerType"] = 8192] = "MarkerType";
        ObjectFlags2[ObjectFlags2["JSLiteral"] = 16384] = "JSLiteral";
        ObjectFlags2[ObjectFlags2["FreshLiteral"] = 32768] = "FreshLiteral";
        ObjectFlags2[ObjectFlags2["ArrayLiteral"] = 65536] = "ArrayLiteral";
        ObjectFlags2[ObjectFlags2["ObjectRestType"] = 131072] = "ObjectRestType";
        ObjectFlags2[ObjectFlags2["PrimitiveUnion"] = 262144] = "PrimitiveUnion";
        ObjectFlags2[ObjectFlags2["ContainsWideningType"] = 524288] = "ContainsWideningType";
        ObjectFlags2[ObjectFlags2["ContainsObjectOrArrayLiteral"] = 1048576] = "ContainsObjectOrArrayLiteral";
        ObjectFlags2[ObjectFlags2["NonInferrableType"] = 2097152] = "NonInferrableType";
        ObjectFlags2[ObjectFlags2["IsGenericObjectTypeComputed"] = 4194304] = "IsGenericObjectTypeComputed";
        ObjectFlags2[ObjectFlags2["IsGenericObjectType"] = 8388608] = "IsGenericObjectType";
        ObjectFlags2[ObjectFlags2["IsGenericIndexTypeComputed"] = 16777216] = "IsGenericIndexTypeComputed";
        ObjectFlags2[ObjectFlags2["IsGenericIndexType"] = 33554432] = "IsGenericIndexType";
        ObjectFlags2[ObjectFlags2["CouldContainTypeVariablesComputed"] = 67108864] = "CouldContainTypeVariablesComputed";
        ObjectFlags2[ObjectFlags2["CouldContainTypeVariables"] = 134217728] = "CouldContainTypeVariables";
        ObjectFlags2[ObjectFlags2["ContainsIntersections"] = 268435456] = "ContainsIntersections";
        ObjectFlags2[ObjectFlags2["IsNeverIntersectionComputed"] = 268435456] = "IsNeverIntersectionComputed";
        ObjectFlags2[ObjectFlags2["IsNeverIntersection"] = 536870912] = "IsNeverIntersection";
        ObjectFlags2[ObjectFlags2["ClassOrInterface"] = 3] = "ClassOrInterface";
        ObjectFlags2[ObjectFlags2["RequiresWidening"] = 1572864] = "RequiresWidening";
        ObjectFlags2[ObjectFlags2["PropagatingFlags"] = 3670016] = "PropagatingFlags";
      })(ObjectFlags = ts2.ObjectFlags || (ts2.ObjectFlags = {}));
      var VarianceFlags;
      (function(VarianceFlags2) {
        VarianceFlags2[VarianceFlags2["Invariant"] = 0] = "Invariant";
        VarianceFlags2[VarianceFlags2["Covariant"] = 1] = "Covariant";
        VarianceFlags2[VarianceFlags2["Contravariant"] = 2] = "Contravariant";
        VarianceFlags2[VarianceFlags2["Bivariant"] = 3] = "Bivariant";
        VarianceFlags2[VarianceFlags2["Independent"] = 4] = "Independent";
        VarianceFlags2[VarianceFlags2["VarianceMask"] = 7] = "VarianceMask";
        VarianceFlags2[VarianceFlags2["Unmeasurable"] = 8] = "Unmeasurable";
        VarianceFlags2[VarianceFlags2["Unreliable"] = 16] = "Unreliable";
        VarianceFlags2[VarianceFlags2["AllowsStructuralFallback"] = 24] = "AllowsStructuralFallback";
      })(VarianceFlags = ts2.VarianceFlags || (ts2.VarianceFlags = {}));
      var JsxReferenceKind;
      (function(JsxReferenceKind2) {
        JsxReferenceKind2[JsxReferenceKind2["Component"] = 0] = "Component";
        JsxReferenceKind2[JsxReferenceKind2["Function"] = 1] = "Function";
        JsxReferenceKind2[JsxReferenceKind2["Mixed"] = 2] = "Mixed";
      })(JsxReferenceKind = ts2.JsxReferenceKind || (ts2.JsxReferenceKind = {}));
      var SignatureKind;
      (function(SignatureKind2) {
        SignatureKind2[SignatureKind2["Call"] = 0] = "Call";
        SignatureKind2[SignatureKind2["Construct"] = 1] = "Construct";
      })(SignatureKind = ts2.SignatureKind || (ts2.SignatureKind = {}));
      var SignatureFlags;
      (function(SignatureFlags2) {
        SignatureFlags2[SignatureFlags2["None"] = 0] = "None";
        SignatureFlags2[SignatureFlags2["HasRestParameter"] = 1] = "HasRestParameter";
        SignatureFlags2[SignatureFlags2["HasLiteralTypes"] = 2] = "HasLiteralTypes";
        SignatureFlags2[SignatureFlags2["IsInnerCallChain"] = 4] = "IsInnerCallChain";
        SignatureFlags2[SignatureFlags2["IsOuterCallChain"] = 8] = "IsOuterCallChain";
        SignatureFlags2[SignatureFlags2["IsUntypedSignatureInJSFile"] = 16] = "IsUntypedSignatureInJSFile";
        SignatureFlags2[SignatureFlags2["PropagatingFlags"] = 3] = "PropagatingFlags";
        SignatureFlags2[SignatureFlags2["CallChainFlags"] = 12] = "CallChainFlags";
      })(SignatureFlags = ts2.SignatureFlags || (ts2.SignatureFlags = {}));
      var IndexKind;
      (function(IndexKind2) {
        IndexKind2[IndexKind2["String"] = 0] = "String";
        IndexKind2[IndexKind2["Number"] = 1] = "Number";
      })(IndexKind = ts2.IndexKind || (ts2.IndexKind = {}));
      var TypeMapKind;
      (function(TypeMapKind2) {
        TypeMapKind2[TypeMapKind2["Simple"] = 0] = "Simple";
        TypeMapKind2[TypeMapKind2["Array"] = 1] = "Array";
        TypeMapKind2[TypeMapKind2["Function"] = 2] = "Function";
        TypeMapKind2[TypeMapKind2["Composite"] = 3] = "Composite";
        TypeMapKind2[TypeMapKind2["Merged"] = 4] = "Merged";
      })(TypeMapKind = ts2.TypeMapKind || (ts2.TypeMapKind = {}));
      var InferencePriority;
      (function(InferencePriority2) {
        InferencePriority2[InferencePriority2["NakedTypeVariable"] = 1] = "NakedTypeVariable";
        InferencePriority2[InferencePriority2["HomomorphicMappedType"] = 2] = "HomomorphicMappedType";
        InferencePriority2[InferencePriority2["PartialHomomorphicMappedType"] = 4] = "PartialHomomorphicMappedType";
        InferencePriority2[InferencePriority2["MappedTypeConstraint"] = 8] = "MappedTypeConstraint";
        InferencePriority2[InferencePriority2["ContravariantConditional"] = 16] = "ContravariantConditional";
        InferencePriority2[InferencePriority2["ReturnType"] = 32] = "ReturnType";
        InferencePriority2[InferencePriority2["LiteralKeyof"] = 64] = "LiteralKeyof";
        InferencePriority2[InferencePriority2["NoConstraints"] = 128] = "NoConstraints";
        InferencePriority2[InferencePriority2["AlwaysStrict"] = 256] = "AlwaysStrict";
        InferencePriority2[InferencePriority2["MaxValue"] = 512] = "MaxValue";
        InferencePriority2[InferencePriority2["PriorityImpliesCombination"] = 104] = "PriorityImpliesCombination";
        InferencePriority2[InferencePriority2["Circularity"] = -1] = "Circularity";
      })(InferencePriority = ts2.InferencePriority || (ts2.InferencePriority = {}));
      var InferenceFlags;
      (function(InferenceFlags2) {
        InferenceFlags2[InferenceFlags2["None"] = 0] = "None";
        InferenceFlags2[InferenceFlags2["NoDefault"] = 1] = "NoDefault";
        InferenceFlags2[InferenceFlags2["AnyDefault"] = 2] = "AnyDefault";
        InferenceFlags2[InferenceFlags2["SkippedGenericFunction"] = 4] = "SkippedGenericFunction";
      })(InferenceFlags = ts2.InferenceFlags || (ts2.InferenceFlags = {}));
      var Ternary;
      (function(Ternary2) {
        Ternary2[Ternary2["False"] = 0] = "False";
        Ternary2[Ternary2["Maybe"] = 1] = "Maybe";
        Ternary2[Ternary2["True"] = -1] = "True";
      })(Ternary = ts2.Ternary || (ts2.Ternary = {}));
      var AssignmentDeclarationKind;
      (function(AssignmentDeclarationKind2) {
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["None"] = 0] = "None";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ExportsProperty"] = 1] = "ExportsProperty";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ModuleExports"] = 2] = "ModuleExports";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["PrototypeProperty"] = 3] = "PrototypeProperty";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ThisProperty"] = 4] = "ThisProperty";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["Property"] = 5] = "Property";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["Prototype"] = 6] = "Prototype";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePropertyValue"] = 7] = "ObjectDefinePropertyValue";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePropertyExports"] = 8] = "ObjectDefinePropertyExports";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePrototypeProperty"] = 9] = "ObjectDefinePrototypeProperty";
      })(AssignmentDeclarationKind = ts2.AssignmentDeclarationKind || (ts2.AssignmentDeclarationKind = {}));
      var DiagnosticCategory;
      (function(DiagnosticCategory2) {
        DiagnosticCategory2[DiagnosticCategory2["Warning"] = 0] = "Warning";
        DiagnosticCategory2[DiagnosticCategory2["Error"] = 1] = "Error";
        DiagnosticCategory2[DiagnosticCategory2["Suggestion"] = 2] = "Suggestion";
        DiagnosticCategory2[DiagnosticCategory2["Message"] = 3] = "Message";
      })(DiagnosticCategory = ts2.DiagnosticCategory || (ts2.DiagnosticCategory = {}));
      function diagnosticCategoryName(d, lowerCase) {
        if (lowerCase === void 0) {
          lowerCase = true;
        }
        var name = DiagnosticCategory[d.category];
        return lowerCase ? name.toLowerCase() : name;
      }
      ts2.diagnosticCategoryName = diagnosticCategoryName;
      var ModuleResolutionKind;
      (function(ModuleResolutionKind2) {
        ModuleResolutionKind2[ModuleResolutionKind2["Classic"] = 1] = "Classic";
        ModuleResolutionKind2[ModuleResolutionKind2["NodeJs"] = 2] = "NodeJs";
      })(ModuleResolutionKind = ts2.ModuleResolutionKind || (ts2.ModuleResolutionKind = {}));
      var WatchFileKind;
      (function(WatchFileKind2) {
        WatchFileKind2[WatchFileKind2["FixedPollingInterval"] = 0] = "FixedPollingInterval";
        WatchFileKind2[WatchFileKind2["PriorityPollingInterval"] = 1] = "PriorityPollingInterval";
        WatchFileKind2[WatchFileKind2["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
        WatchFileKind2[WatchFileKind2["UseFsEvents"] = 3] = "UseFsEvents";
        WatchFileKind2[WatchFileKind2["UseFsEventsOnParentDirectory"] = 4] = "UseFsEventsOnParentDirectory";
      })(WatchFileKind = ts2.WatchFileKind || (ts2.WatchFileKind = {}));
      var WatchDirectoryKind;
      (function(WatchDirectoryKind2) {
        WatchDirectoryKind2[WatchDirectoryKind2["UseFsEvents"] = 0] = "UseFsEvents";
        WatchDirectoryKind2[WatchDirectoryKind2["FixedPollingInterval"] = 1] = "FixedPollingInterval";
        WatchDirectoryKind2[WatchDirectoryKind2["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
      })(WatchDirectoryKind = ts2.WatchDirectoryKind || (ts2.WatchDirectoryKind = {}));
      var PollingWatchKind;
      (function(PollingWatchKind2) {
        PollingWatchKind2[PollingWatchKind2["FixedInterval"] = 0] = "FixedInterval";
        PollingWatchKind2[PollingWatchKind2["PriorityInterval"] = 1] = "PriorityInterval";
        PollingWatchKind2[PollingWatchKind2["DynamicPriority"] = 2] = "DynamicPriority";
      })(PollingWatchKind = ts2.PollingWatchKind || (ts2.PollingWatchKind = {}));
      var ModuleKind;
      (function(ModuleKind2) {
        ModuleKind2[ModuleKind2["None"] = 0] = "None";
        ModuleKind2[ModuleKind2["CommonJS"] = 1] = "CommonJS";
        ModuleKind2[ModuleKind2["AMD"] = 2] = "AMD";
        ModuleKind2[ModuleKind2["UMD"] = 3] = "UMD";
        ModuleKind2[ModuleKind2["System"] = 4] = "System";
        ModuleKind2[ModuleKind2["ES2015"] = 5] = "ES2015";
        ModuleKind2[ModuleKind2["ES2020"] = 6] = "ES2020";
        ModuleKind2[ModuleKind2["ESNext"] = 99] = "ESNext";
      })(ModuleKind = ts2.ModuleKind || (ts2.ModuleKind = {}));
      var JsxEmit;
      (function(JsxEmit2) {
        JsxEmit2[JsxEmit2["None"] = 0] = "None";
        JsxEmit2[JsxEmit2["Preserve"] = 1] = "Preserve";
        JsxEmit2[JsxEmit2["React"] = 2] = "React";
        JsxEmit2[JsxEmit2["ReactNative"] = 3] = "ReactNative";
      })(JsxEmit = ts2.JsxEmit || (ts2.JsxEmit = {}));
      var ImportsNotUsedAsValues;
      (function(ImportsNotUsedAsValues2) {
        ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Remove"] = 0] = "Remove";
        ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Preserve"] = 1] = "Preserve";
        ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Error"] = 2] = "Error";
      })(ImportsNotUsedAsValues = ts2.ImportsNotUsedAsValues || (ts2.ImportsNotUsedAsValues = {}));
      var NewLineKind;
      (function(NewLineKind2) {
        NewLineKind2[NewLineKind2["CarriageReturnLineFeed"] = 0] = "CarriageReturnLineFeed";
        NewLineKind2[NewLineKind2["LineFeed"] = 1] = "LineFeed";
      })(NewLineKind = ts2.NewLineKind || (ts2.NewLineKind = {}));
      var ScriptKind;
      (function(ScriptKind2) {
        ScriptKind2[ScriptKind2["Unknown"] = 0] = "Unknown";
        ScriptKind2[ScriptKind2["JS"] = 1] = "JS";
        ScriptKind2[ScriptKind2["JSX"] = 2] = "JSX";
        ScriptKind2[ScriptKind2["TS"] = 3] = "TS";
        ScriptKind2[ScriptKind2["TSX"] = 4] = "TSX";
        ScriptKind2[ScriptKind2["External"] = 5] = "External";
        ScriptKind2[ScriptKind2["JSON"] = 6] = "JSON";
        ScriptKind2[ScriptKind2["Deferred"] = 7] = "Deferred";
      })(ScriptKind = ts2.ScriptKind || (ts2.ScriptKind = {}));
      var ScriptTarget;
      (function(ScriptTarget2) {
        ScriptTarget2[ScriptTarget2["ES3"] = 0] = "ES3";
        ScriptTarget2[ScriptTarget2["ES5"] = 1] = "ES5";
        ScriptTarget2[ScriptTarget2["ES2015"] = 2] = "ES2015";
        ScriptTarget2[ScriptTarget2["ES2016"] = 3] = "ES2016";
        ScriptTarget2[ScriptTarget2["ES2017"] = 4] = "ES2017";
        ScriptTarget2[ScriptTarget2["ES2018"] = 5] = "ES2018";
        ScriptTarget2[ScriptTarget2["ES2019"] = 6] = "ES2019";
        ScriptTarget2[ScriptTarget2["ES2020"] = 7] = "ES2020";
        ScriptTarget2[ScriptTarget2["ESNext"] = 99] = "ESNext";
        ScriptTarget2[ScriptTarget2["JSON"] = 100] = "JSON";
        ScriptTarget2[ScriptTarget2["Latest"] = 99] = "Latest";
      })(ScriptTarget = ts2.ScriptTarget || (ts2.ScriptTarget = {}));
      var LanguageVariant;
      (function(LanguageVariant2) {
        LanguageVariant2[LanguageVariant2["Standard"] = 0] = "Standard";
        LanguageVariant2[LanguageVariant2["JSX"] = 1] = "JSX";
      })(LanguageVariant = ts2.LanguageVariant || (ts2.LanguageVariant = {}));
      var WatchDirectoryFlags;
      (function(WatchDirectoryFlags2) {
        WatchDirectoryFlags2[WatchDirectoryFlags2["None"] = 0] = "None";
        WatchDirectoryFlags2[WatchDirectoryFlags2["Recursive"] = 1] = "Recursive";
      })(WatchDirectoryFlags = ts2.WatchDirectoryFlags || (ts2.WatchDirectoryFlags = {}));
      var CharacterCodes;
      (function(CharacterCodes2) {
        CharacterCodes2[CharacterCodes2["nullCharacter"] = 0] = "nullCharacter";
        CharacterCodes2[CharacterCodes2["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";
        CharacterCodes2[CharacterCodes2["lineFeed"] = 10] = "lineFeed";
        CharacterCodes2[CharacterCodes2["carriageReturn"] = 13] = "carriageReturn";
        CharacterCodes2[CharacterCodes2["lineSeparator"] = 8232] = "lineSeparator";
        CharacterCodes2[CharacterCodes2["paragraphSeparator"] = 8233] = "paragraphSeparator";
        CharacterCodes2[CharacterCodes2["nextLine"] = 133] = "nextLine";
        CharacterCodes2[CharacterCodes2["space"] = 32] = "space";
        CharacterCodes2[CharacterCodes2["nonBreakingSpace"] = 160] = "nonBreakingSpace";
        CharacterCodes2[CharacterCodes2["enQuad"] = 8192] = "enQuad";
        CharacterCodes2[CharacterCodes2["emQuad"] = 8193] = "emQuad";
        CharacterCodes2[CharacterCodes2["enSpace"] = 8194] = "enSpace";
        CharacterCodes2[CharacterCodes2["emSpace"] = 8195] = "emSpace";
        CharacterCodes2[CharacterCodes2["threePerEmSpace"] = 8196] = "threePerEmSpace";
        CharacterCodes2[CharacterCodes2["fourPerEmSpace"] = 8197] = "fourPerEmSpace";
        CharacterCodes2[CharacterCodes2["sixPerEmSpace"] = 8198] = "sixPerEmSpace";
        CharacterCodes2[CharacterCodes2["figureSpace"] = 8199] = "figureSpace";
        CharacterCodes2[CharacterCodes2["punctuationSpace"] = 8200] = "punctuationSpace";
        CharacterCodes2[CharacterCodes2["thinSpace"] = 8201] = "thinSpace";
        CharacterCodes2[CharacterCodes2["hairSpace"] = 8202] = "hairSpace";
        CharacterCodes2[CharacterCodes2["zeroWidthSpace"] = 8203] = "zeroWidthSpace";
        CharacterCodes2[CharacterCodes2["narrowNoBreakSpace"] = 8239] = "narrowNoBreakSpace";
        CharacterCodes2[CharacterCodes2["ideographicSpace"] = 12288] = "ideographicSpace";
        CharacterCodes2[CharacterCodes2["mathematicalSpace"] = 8287] = "mathematicalSpace";
        CharacterCodes2[CharacterCodes2["ogham"] = 5760] = "ogham";
        CharacterCodes2[CharacterCodes2["_"] = 95] = "_";
        CharacterCodes2[CharacterCodes2["$"] = 36] = "$";
        CharacterCodes2[CharacterCodes2["_0"] = 48] = "_0";
        CharacterCodes2[CharacterCodes2["_1"] = 49] = "_1";
        CharacterCodes2[CharacterCodes2["_2"] = 50] = "_2";
        CharacterCodes2[CharacterCodes2["_3"] = 51] = "_3";
        CharacterCodes2[CharacterCodes2["_4"] = 52] = "_4";
        CharacterCodes2[CharacterCodes2["_5"] = 53] = "_5";
        CharacterCodes2[CharacterCodes2["_6"] = 54] = "_6";
        CharacterCodes2[CharacterCodes2["_7"] = 55] = "_7";
        CharacterCodes2[CharacterCodes2["_8"] = 56] = "_8";
        CharacterCodes2[CharacterCodes2["_9"] = 57] = "_9";
        CharacterCodes2[CharacterCodes2["a"] = 97] = "a";
        CharacterCodes2[CharacterCodes2["b"] = 98] = "b";
        CharacterCodes2[CharacterCodes2["c"] = 99] = "c";
        CharacterCodes2[CharacterCodes2["d"] = 100] = "d";
        CharacterCodes2[CharacterCodes2["e"] = 101] = "e";
        CharacterCodes2[CharacterCodes2["f"] = 102] = "f";
        CharacterCodes2[CharacterCodes2["g"] = 103] = "g";
        CharacterCodes2[CharacterCodes2["h"] = 104] = "h";
        CharacterCodes2[CharacterCodes2["i"] = 105] = "i";
        CharacterCodes2[CharacterCodes2["j"] = 106] = "j";
        CharacterCodes2[CharacterCodes2["k"] = 107] = "k";
        CharacterCodes2[CharacterCodes2["l"] = 108] = "l";
        CharacterCodes2[CharacterCodes2["m"] = 109] = "m";
        CharacterCodes2[CharacterCodes2["n"] = 110] = "n";
        CharacterCodes2[CharacterCodes2["o"] = 111] = "o";
        CharacterCodes2[CharacterCodes2["p"] = 112] = "p";
        CharacterCodes2[CharacterCodes2["q"] = 113] = "q";
        CharacterCodes2[CharacterCodes2["r"] = 114] = "r";
        CharacterCodes2[CharacterCodes2["s"] = 115] = "s";
        CharacterCodes2[CharacterCodes2["t"] = 116] = "t";
        CharacterCodes2[CharacterCodes2["u"] = 117] = "u";
        CharacterCodes2[CharacterCodes2["v"] = 118] = "v";
        CharacterCodes2[CharacterCodes2["w"] = 119] = "w";
        CharacterCodes2[CharacterCodes2["x"] = 120] = "x";
        CharacterCodes2[CharacterCodes2["y"] = 121] = "y";
        CharacterCodes2[CharacterCodes2["z"] = 122] = "z";
        CharacterCodes2[CharacterCodes2["A"] = 65] = "A";
        CharacterCodes2[CharacterCodes2["B"] = 66] = "B";
        CharacterCodes2[CharacterCodes2["C"] = 67] = "C";
        CharacterCodes2[CharacterCodes2["D"] = 68] = "D";
        CharacterCodes2[CharacterCodes2["E"] = 69] = "E";
        CharacterCodes2[CharacterCodes2["F"] = 70] = "F";
        CharacterCodes2[CharacterCodes2["G"] = 71] = "G";
        CharacterCodes2[CharacterCodes2["H"] = 72] = "H";
        CharacterCodes2[CharacterCodes2["I"] = 73] = "I";
        CharacterCodes2[CharacterCodes2["J"] = 74] = "J";
        CharacterCodes2[CharacterCodes2["K"] = 75] = "K";
        CharacterCodes2[CharacterCodes2["L"] = 76] = "L";
        CharacterCodes2[CharacterCodes2["M"] = 77] = "M";
        CharacterCodes2[CharacterCodes2["N"] = 78] = "N";
        CharacterCodes2[CharacterCodes2["O"] = 79] = "O";
        CharacterCodes2[CharacterCodes2["P"] = 80] = "P";
        CharacterCodes2[CharacterCodes2["Q"] = 81] = "Q";
        CharacterCodes2[CharacterCodes2["R"] = 82] = "R";
        CharacterCodes2[CharacterCodes2["S"] = 83] = "S";
        CharacterCodes2[CharacterCodes2["T"] = 84] = "T";
        CharacterCodes2[CharacterCodes2["U"] = 85] = "U";
        CharacterCodes2[CharacterCodes2["V"] = 86] = "V";
        CharacterCodes2[CharacterCodes2["W"] = 87] = "W";
        CharacterCodes2[CharacterCodes2["X"] = 88] = "X";
        CharacterCodes2[CharacterCodes2["Y"] = 89] = "Y";
        CharacterCodes2[CharacterCodes2["Z"] = 90] = "Z";
        CharacterCodes2[CharacterCodes2["ampersand"] = 38] = "ampersand";
        CharacterCodes2[CharacterCodes2["asterisk"] = 42] = "asterisk";
        CharacterCodes2[CharacterCodes2["at"] = 64] = "at";
        CharacterCodes2[CharacterCodes2["backslash"] = 92] = "backslash";
        CharacterCodes2[CharacterCodes2["backtick"] = 96] = "backtick";
        CharacterCodes2[CharacterCodes2["bar"] = 124] = "bar";
        CharacterCodes2[CharacterCodes2["caret"] = 94] = "caret";
        CharacterCodes2[CharacterCodes2["closeBrace"] = 125] = "closeBrace";
        CharacterCodes2[CharacterCodes2["closeBracket"] = 93] = "closeBracket";
        CharacterCodes2[CharacterCodes2["closeParen"] = 41] = "closeParen";
        CharacterCodes2[CharacterCodes2["colon"] = 58] = "colon";
        CharacterCodes2[CharacterCodes2["comma"] = 44] = "comma";
        CharacterCodes2[CharacterCodes2["dot"] = 46] = "dot";
        CharacterCodes2[CharacterCodes2["doubleQuote"] = 34] = "doubleQuote";
        CharacterCodes2[CharacterCodes2["equals"] = 61] = "equals";
        CharacterCodes2[CharacterCodes2["exclamation"] = 33] = "exclamation";
        CharacterCodes2[CharacterCodes2["greaterThan"] = 62] = "greaterThan";
        CharacterCodes2[CharacterCodes2["hash"] = 35] = "hash";
        CharacterCodes2[CharacterCodes2["lessThan"] = 60] = "lessThan";
        CharacterCodes2[CharacterCodes2["minus"] = 45] = "minus";
        CharacterCodes2[CharacterCodes2["openBrace"] = 123] = "openBrace";
        CharacterCodes2[CharacterCodes2["openBracket"] = 91] = "openBracket";
        CharacterCodes2[CharacterCodes2["openParen"] = 40] = "openParen";
        CharacterCodes2[CharacterCodes2["percent"] = 37] = "percent";
        CharacterCodes2[CharacterCodes2["plus"] = 43] = "plus";
        CharacterCodes2[CharacterCodes2["question"] = 63] = "question";
        CharacterCodes2[CharacterCodes2["semicolon"] = 59] = "semicolon";
        CharacterCodes2[CharacterCodes2["singleQuote"] = 39] = "singleQuote";
        CharacterCodes2[CharacterCodes2["slash"] = 47] = "slash";
        CharacterCodes2[CharacterCodes2["tilde"] = 126] = "tilde";
        CharacterCodes2[CharacterCodes2["backspace"] = 8] = "backspace";
        CharacterCodes2[CharacterCodes2["formFeed"] = 12] = "formFeed";
        CharacterCodes2[CharacterCodes2["byteOrderMark"] = 65279] = "byteOrderMark";
        CharacterCodes2[CharacterCodes2["tab"] = 9] = "tab";
        CharacterCodes2[CharacterCodes2["verticalTab"] = 11] = "verticalTab";
      })(CharacterCodes = ts2.CharacterCodes || (ts2.CharacterCodes = {}));
      var Extension;
      (function(Extension2) {
        Extension2["Ts"] = ".ts";
        Extension2["Tsx"] = ".tsx";
        Extension2["Dts"] = ".d.ts";
        Extension2["Js"] = ".js";
        Extension2["Jsx"] = ".jsx";
        Extension2["Json"] = ".json";
        Extension2["TsBuildInfo"] = ".tsbuildinfo";
      })(Extension = ts2.Extension || (ts2.Extension = {}));
      var TransformFlags;
      (function(TransformFlags2) {
        TransformFlags2[TransformFlags2["None"] = 0] = "None";
        TransformFlags2[TransformFlags2["ContainsTypeScript"] = 1] = "ContainsTypeScript";
        TransformFlags2[TransformFlags2["ContainsJsx"] = 2] = "ContainsJsx";
        TransformFlags2[TransformFlags2["ContainsESNext"] = 4] = "ContainsESNext";
        TransformFlags2[TransformFlags2["ContainsES2020"] = 8] = "ContainsES2020";
        TransformFlags2[TransformFlags2["ContainsES2019"] = 16] = "ContainsES2019";
        TransformFlags2[TransformFlags2["ContainsES2018"] = 32] = "ContainsES2018";
        TransformFlags2[TransformFlags2["ContainsES2017"] = 64] = "ContainsES2017";
        TransformFlags2[TransformFlags2["ContainsES2016"] = 128] = "ContainsES2016";
        TransformFlags2[TransformFlags2["ContainsES2015"] = 256] = "ContainsES2015";
        TransformFlags2[TransformFlags2["ContainsGenerator"] = 512] = "ContainsGenerator";
        TransformFlags2[TransformFlags2["ContainsDestructuringAssignment"] = 1024] = "ContainsDestructuringAssignment";
        TransformFlags2[TransformFlags2["ContainsTypeScriptClassSyntax"] = 2048] = "ContainsTypeScriptClassSyntax";
        TransformFlags2[TransformFlags2["ContainsLexicalThis"] = 4096] = "ContainsLexicalThis";
        TransformFlags2[TransformFlags2["ContainsRestOrSpread"] = 8192] = "ContainsRestOrSpread";
        TransformFlags2[TransformFlags2["ContainsObjectRestOrSpread"] = 16384] = "ContainsObjectRestOrSpread";
        TransformFlags2[TransformFlags2["ContainsComputedPropertyName"] = 32768] = "ContainsComputedPropertyName";
        TransformFlags2[TransformFlags2["ContainsBlockScopedBinding"] = 65536] = "ContainsBlockScopedBinding";
        TransformFlags2[TransformFlags2["ContainsBindingPattern"] = 131072] = "ContainsBindingPattern";
        TransformFlags2[TransformFlags2["ContainsYield"] = 262144] = "ContainsYield";
        TransformFlags2[TransformFlags2["ContainsAwait"] = 524288] = "ContainsAwait";
        TransformFlags2[TransformFlags2["ContainsHoistedDeclarationOrCompletion"] = 1048576] = "ContainsHoistedDeclarationOrCompletion";
        TransformFlags2[TransformFlags2["ContainsDynamicImport"] = 2097152] = "ContainsDynamicImport";
        TransformFlags2[TransformFlags2["ContainsClassFields"] = 4194304] = "ContainsClassFields";
        TransformFlags2[TransformFlags2["HasComputedFlags"] = 536870912] = "HasComputedFlags";
        TransformFlags2[TransformFlags2["AssertTypeScript"] = 1] = "AssertTypeScript";
        TransformFlags2[TransformFlags2["AssertJsx"] = 2] = "AssertJsx";
        TransformFlags2[TransformFlags2["AssertESNext"] = 4] = "AssertESNext";
        TransformFlags2[TransformFlags2["AssertES2020"] = 8] = "AssertES2020";
        TransformFlags2[TransformFlags2["AssertES2019"] = 16] = "AssertES2019";
        TransformFlags2[TransformFlags2["AssertES2018"] = 32] = "AssertES2018";
        TransformFlags2[TransformFlags2["AssertES2017"] = 64] = "AssertES2017";
        TransformFlags2[TransformFlags2["AssertES2016"] = 128] = "AssertES2016";
        TransformFlags2[TransformFlags2["AssertES2015"] = 256] = "AssertES2015";
        TransformFlags2[TransformFlags2["AssertGenerator"] = 512] = "AssertGenerator";
        TransformFlags2[TransformFlags2["AssertDestructuringAssignment"] = 1024] = "AssertDestructuringAssignment";
        TransformFlags2[TransformFlags2["OuterExpressionExcludes"] = 536870912] = "OuterExpressionExcludes";
        TransformFlags2[TransformFlags2["PropertyAccessExcludes"] = 536870912] = "PropertyAccessExcludes";
        TransformFlags2[TransformFlags2["NodeExcludes"] = 536870912] = "NodeExcludes";
        TransformFlags2[TransformFlags2["ArrowFunctionExcludes"] = 538920960] = "ArrowFunctionExcludes";
        TransformFlags2[TransformFlags2["FunctionExcludes"] = 538925056] = "FunctionExcludes";
        TransformFlags2[TransformFlags2["ConstructorExcludes"] = 538923008] = "ConstructorExcludes";
        TransformFlags2[TransformFlags2["MethodOrAccessorExcludes"] = 538923008] = "MethodOrAccessorExcludes";
        TransformFlags2[TransformFlags2["PropertyExcludes"] = 536875008] = "PropertyExcludes";
        TransformFlags2[TransformFlags2["ClassExcludes"] = 536905728] = "ClassExcludes";
        TransformFlags2[TransformFlags2["ModuleExcludes"] = 537991168] = "ModuleExcludes";
        TransformFlags2[TransformFlags2["TypeExcludes"] = -2] = "TypeExcludes";
        TransformFlags2[TransformFlags2["ObjectLiteralExcludes"] = 536922112] = "ObjectLiteralExcludes";
        TransformFlags2[TransformFlags2["ArrayLiteralOrCallOrNewExcludes"] = 536879104] = "ArrayLiteralOrCallOrNewExcludes";
        TransformFlags2[TransformFlags2["VariableDeclarationListExcludes"] = 537018368] = "VariableDeclarationListExcludes";
        TransformFlags2[TransformFlags2["ParameterExcludes"] = 536870912] = "ParameterExcludes";
        TransformFlags2[TransformFlags2["CatchClauseExcludes"] = 536887296] = "CatchClauseExcludes";
        TransformFlags2[TransformFlags2["BindingPatternExcludes"] = 536879104] = "BindingPatternExcludes";
        TransformFlags2[TransformFlags2["PropertyNamePropagatingFlags"] = 4096] = "PropertyNamePropagatingFlags";
      })(TransformFlags = ts2.TransformFlags || (ts2.TransformFlags = {}));
      var EmitFlags;
      (function(EmitFlags2) {
        EmitFlags2[EmitFlags2["None"] = 0] = "None";
        EmitFlags2[EmitFlags2["SingleLine"] = 1] = "SingleLine";
        EmitFlags2[EmitFlags2["AdviseOnEmitNode"] = 2] = "AdviseOnEmitNode";
        EmitFlags2[EmitFlags2["NoSubstitution"] = 4] = "NoSubstitution";
        EmitFlags2[EmitFlags2["CapturesThis"] = 8] = "CapturesThis";
        EmitFlags2[EmitFlags2["NoLeadingSourceMap"] = 16] = "NoLeadingSourceMap";
        EmitFlags2[EmitFlags2["NoTrailingSourceMap"] = 32] = "NoTrailingSourceMap";
        EmitFlags2[EmitFlags2["NoSourceMap"] = 48] = "NoSourceMap";
        EmitFlags2[EmitFlags2["NoNestedSourceMaps"] = 64] = "NoNestedSourceMaps";
        EmitFlags2[EmitFlags2["NoTokenLeadingSourceMaps"] = 128] = "NoTokenLeadingSourceMaps";
        EmitFlags2[EmitFlags2["NoTokenTrailingSourceMaps"] = 256] = "NoTokenTrailingSourceMaps";
        EmitFlags2[EmitFlags2["NoTokenSourceMaps"] = 384] = "NoTokenSourceMaps";
        EmitFlags2[EmitFlags2["NoLeadingComments"] = 512] = "NoLeadingComments";
        EmitFlags2[EmitFlags2["NoTrailingComments"] = 1024] = "NoTrailingComments";
        EmitFlags2[EmitFlags2["NoComments"] = 1536] = "NoComments";
        EmitFlags2[EmitFlags2["NoNestedComments"] = 2048] = "NoNestedComments";
        EmitFlags2[EmitFlags2["HelperName"] = 4096] = "HelperName";
        EmitFlags2[EmitFlags2["ExportName"] = 8192] = "ExportName";
        EmitFlags2[EmitFlags2["LocalName"] = 16384] = "LocalName";
        EmitFlags2[EmitFlags2["InternalName"] = 32768] = "InternalName";
        EmitFlags2[EmitFlags2["Indented"] = 65536] = "Indented";
        EmitFlags2[EmitFlags2["NoIndentation"] = 131072] = "NoIndentation";
        EmitFlags2[EmitFlags2["AsyncFunctionBody"] = 262144] = "AsyncFunctionBody";
        EmitFlags2[EmitFlags2["ReuseTempVariableScope"] = 524288] = "ReuseTempVariableScope";
        EmitFlags2[EmitFlags2["CustomPrologue"] = 1048576] = "CustomPrologue";
        EmitFlags2[EmitFlags2["NoHoisting"] = 2097152] = "NoHoisting";
        EmitFlags2[EmitFlags2["HasEndOfDeclarationMarker"] = 4194304] = "HasEndOfDeclarationMarker";
        EmitFlags2[EmitFlags2["Iterator"] = 8388608] = "Iterator";
        EmitFlags2[EmitFlags2["NoAsciiEscaping"] = 16777216] = "NoAsciiEscaping";
        EmitFlags2[EmitFlags2["TypeScriptClassWrapper"] = 33554432] = "TypeScriptClassWrapper";
        EmitFlags2[EmitFlags2["NeverApplyImportHelper"] = 67108864] = "NeverApplyImportHelper";
        EmitFlags2[EmitFlags2["IgnoreSourceNewlines"] = 134217728] = "IgnoreSourceNewlines";
      })(EmitFlags = ts2.EmitFlags || (ts2.EmitFlags = {}));
      var ExternalEmitHelpers;
      (function(ExternalEmitHelpers2) {
        ExternalEmitHelpers2[ExternalEmitHelpers2["Extends"] = 1] = "Extends";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Assign"] = 2] = "Assign";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Rest"] = 4] = "Rest";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Decorate"] = 8] = "Decorate";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Metadata"] = 16] = "Metadata";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Param"] = 32] = "Param";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Awaiter"] = 64] = "Awaiter";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Generator"] = 128] = "Generator";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Values"] = 256] = "Values";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Read"] = 512] = "Read";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Spread"] = 1024] = "Spread";
        ExternalEmitHelpers2[ExternalEmitHelpers2["SpreadArrays"] = 2048] = "SpreadArrays";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Await"] = 4096] = "Await";
        ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncGenerator"] = 8192] = "AsyncGenerator";
        ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncDelegator"] = 16384] = "AsyncDelegator";
        ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncValues"] = 32768] = "AsyncValues";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ExportStar"] = 65536] = "ExportStar";
        ExternalEmitHelpers2[ExternalEmitHelpers2["MakeTemplateObject"] = 131072] = "MakeTemplateObject";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldGet"] = 262144] = "ClassPrivateFieldGet";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldSet"] = 524288] = "ClassPrivateFieldSet";
        ExternalEmitHelpers2[ExternalEmitHelpers2["CreateBinding"] = 1048576] = "CreateBinding";
        ExternalEmitHelpers2[ExternalEmitHelpers2["FirstEmitHelper"] = 1] = "FirstEmitHelper";
        ExternalEmitHelpers2[ExternalEmitHelpers2["LastEmitHelper"] = 1048576] = "LastEmitHelper";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ForOfIncludes"] = 256] = "ForOfIncludes";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ForAwaitOfIncludes"] = 32768] = "ForAwaitOfIncludes";
        ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncGeneratorIncludes"] = 12288] = "AsyncGeneratorIncludes";
        ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncDelegatorIncludes"] = 53248] = "AsyncDelegatorIncludes";
        ExternalEmitHelpers2[ExternalEmitHelpers2["SpreadIncludes"] = 1536] = "SpreadIncludes";
      })(ExternalEmitHelpers = ts2.ExternalEmitHelpers || (ts2.ExternalEmitHelpers = {}));
      var EmitHint;
      (function(EmitHint2) {
        EmitHint2[EmitHint2["SourceFile"] = 0] = "SourceFile";
        EmitHint2[EmitHint2["Expression"] = 1] = "Expression";
        EmitHint2[EmitHint2["IdentifierName"] = 2] = "IdentifierName";
        EmitHint2[EmitHint2["MappedTypeParameter"] = 3] = "MappedTypeParameter";
        EmitHint2[EmitHint2["Unspecified"] = 4] = "Unspecified";
        EmitHint2[EmitHint2["EmbeddedStatement"] = 5] = "EmbeddedStatement";
        EmitHint2[EmitHint2["JsxAttributeValue"] = 6] = "JsxAttributeValue";
      })(EmitHint = ts2.EmitHint || (ts2.EmitHint = {}));
      var LexicalEnvironmentFlags;
      (function(LexicalEnvironmentFlags2) {
        LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["None"] = 0] = "None";
        LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["InParameters"] = 1] = "InParameters";
        LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["VariablesHoistedInParameters"] = 2] = "VariablesHoistedInParameters";
      })(LexicalEnvironmentFlags = ts2.LexicalEnvironmentFlags || (ts2.LexicalEnvironmentFlags = {}));
      var BundleFileSectionKind;
      (function(BundleFileSectionKind2) {
        BundleFileSectionKind2["Prologue"] = "prologue";
        BundleFileSectionKind2["EmitHelpers"] = "emitHelpers";
        BundleFileSectionKind2["NoDefaultLib"] = "no-default-lib";
        BundleFileSectionKind2["Reference"] = "reference";
        BundleFileSectionKind2["Type"] = "type";
        BundleFileSectionKind2["Lib"] = "lib";
        BundleFileSectionKind2["Prepend"] = "prepend";
        BundleFileSectionKind2["Text"] = "text";
        BundleFileSectionKind2["Internal"] = "internal";
      })(BundleFileSectionKind = ts2.BundleFileSectionKind || (ts2.BundleFileSectionKind = {}));
      var ListFormat;
      (function(ListFormat2) {
        ListFormat2[ListFormat2["None"] = 0] = "None";
        ListFormat2[ListFormat2["SingleLine"] = 0] = "SingleLine";
        ListFormat2[ListFormat2["MultiLine"] = 1] = "MultiLine";
        ListFormat2[ListFormat2["PreserveLines"] = 2] = "PreserveLines";
        ListFormat2[ListFormat2["LinesMask"] = 3] = "LinesMask";
        ListFormat2[ListFormat2["NotDelimited"] = 0] = "NotDelimited";
        ListFormat2[ListFormat2["BarDelimited"] = 4] = "BarDelimited";
        ListFormat2[ListFormat2["AmpersandDelimited"] = 8] = "AmpersandDelimited";
        ListFormat2[ListFormat2["CommaDelimited"] = 16] = "CommaDelimited";
        ListFormat2[ListFormat2["AsteriskDelimited"] = 32] = "AsteriskDelimited";
        ListFormat2[ListFormat2["DelimitersMask"] = 60] = "DelimitersMask";
        ListFormat2[ListFormat2["AllowTrailingComma"] = 64] = "AllowTrailingComma";
        ListFormat2[ListFormat2["Indented"] = 128] = "Indented";
        ListFormat2[ListFormat2["SpaceBetweenBraces"] = 256] = "SpaceBetweenBraces";
        ListFormat2[ListFormat2["SpaceBetweenSiblings"] = 512] = "SpaceBetweenSiblings";
        ListFormat2[ListFormat2["Braces"] = 1024] = "Braces";
        ListFormat2[ListFormat2["Parenthesis"] = 2048] = "Parenthesis";
        ListFormat2[ListFormat2["AngleBrackets"] = 4096] = "AngleBrackets";
        ListFormat2[ListFormat2["SquareBrackets"] = 8192] = "SquareBrackets";
        ListFormat2[ListFormat2["BracketsMask"] = 15360] = "BracketsMask";
        ListFormat2[ListFormat2["OptionalIfUndefined"] = 16384] = "OptionalIfUndefined";
        ListFormat2[ListFormat2["OptionalIfEmpty"] = 32768] = "OptionalIfEmpty";
        ListFormat2[ListFormat2["Optional"] = 49152] = "Optional";
        ListFormat2[ListFormat2["PreferNewLine"] = 65536] = "PreferNewLine";
        ListFormat2[ListFormat2["NoTrailingNewLine"] = 131072] = "NoTrailingNewLine";
        ListFormat2[ListFormat2["NoInterveningComments"] = 262144] = "NoInterveningComments";
        ListFormat2[ListFormat2["NoSpaceIfEmpty"] = 524288] = "NoSpaceIfEmpty";
        ListFormat2[ListFormat2["SingleElement"] = 1048576] = "SingleElement";
        ListFormat2[ListFormat2["SpaceAfterList"] = 2097152] = "SpaceAfterList";
        ListFormat2[ListFormat2["Modifiers"] = 262656] = "Modifiers";
        ListFormat2[ListFormat2["HeritageClauses"] = 512] = "HeritageClauses";
        ListFormat2[ListFormat2["SingleLineTypeLiteralMembers"] = 768] = "SingleLineTypeLiteralMembers";
        ListFormat2[ListFormat2["MultiLineTypeLiteralMembers"] = 32897] = "MultiLineTypeLiteralMembers";
        ListFormat2[ListFormat2["TupleTypeElements"] = 528] = "TupleTypeElements";
        ListFormat2[ListFormat2["UnionTypeConstituents"] = 516] = "UnionTypeConstituents";
        ListFormat2[ListFormat2["IntersectionTypeConstituents"] = 520] = "IntersectionTypeConstituents";
        ListFormat2[ListFormat2["ObjectBindingPatternElements"] = 525136] = "ObjectBindingPatternElements";
        ListFormat2[ListFormat2["ArrayBindingPatternElements"] = 524880] = "ArrayBindingPatternElements";
        ListFormat2[ListFormat2["ObjectLiteralExpressionProperties"] = 526226] = "ObjectLiteralExpressionProperties";
        ListFormat2[ListFormat2["ArrayLiteralExpressionElements"] = 8914] = "ArrayLiteralExpressionElements";
        ListFormat2[ListFormat2["CommaListElements"] = 528] = "CommaListElements";
        ListFormat2[ListFormat2["CallExpressionArguments"] = 2576] = "CallExpressionArguments";
        ListFormat2[ListFormat2["NewExpressionArguments"] = 18960] = "NewExpressionArguments";
        ListFormat2[ListFormat2["TemplateExpressionSpans"] = 262144] = "TemplateExpressionSpans";
        ListFormat2[ListFormat2["SingleLineBlockStatements"] = 768] = "SingleLineBlockStatements";
        ListFormat2[ListFormat2["MultiLineBlockStatements"] = 129] = "MultiLineBlockStatements";
        ListFormat2[ListFormat2["VariableDeclarationList"] = 528] = "VariableDeclarationList";
        ListFormat2[ListFormat2["SingleLineFunctionBodyStatements"] = 768] = "SingleLineFunctionBodyStatements";
        ListFormat2[ListFormat2["MultiLineFunctionBodyStatements"] = 1] = "MultiLineFunctionBodyStatements";
        ListFormat2[ListFormat2["ClassHeritageClauses"] = 0] = "ClassHeritageClauses";
        ListFormat2[ListFormat2["ClassMembers"] = 129] = "ClassMembers";
        ListFormat2[ListFormat2["InterfaceMembers"] = 129] = "InterfaceMembers";
        ListFormat2[ListFormat2["EnumMembers"] = 145] = "EnumMembers";
        ListFormat2[ListFormat2["CaseBlockClauses"] = 129] = "CaseBlockClauses";
        ListFormat2[ListFormat2["NamedImportsOrExportsElements"] = 525136] = "NamedImportsOrExportsElements";
        ListFormat2[ListFormat2["JsxElementOrFragmentChildren"] = 262144] = "JsxElementOrFragmentChildren";
        ListFormat2[ListFormat2["JsxElementAttributes"] = 262656] = "JsxElementAttributes";
        ListFormat2[ListFormat2["CaseOrDefaultClauseStatements"] = 163969] = "CaseOrDefaultClauseStatements";
        ListFormat2[ListFormat2["HeritageClauseTypes"] = 528] = "HeritageClauseTypes";
        ListFormat2[ListFormat2["SourceFileStatements"] = 131073] = "SourceFileStatements";
        ListFormat2[ListFormat2["Decorators"] = 2146305] = "Decorators";
        ListFormat2[ListFormat2["TypeArguments"] = 53776] = "TypeArguments";
        ListFormat2[ListFormat2["TypeParameters"] = 53776] = "TypeParameters";
        ListFormat2[ListFormat2["Parameters"] = 2576] = "Parameters";
        ListFormat2[ListFormat2["IndexSignatureParameters"] = 8848] = "IndexSignatureParameters";
        ListFormat2[ListFormat2["JSDocComment"] = 33] = "JSDocComment";
      })(ListFormat = ts2.ListFormat || (ts2.ListFormat = {}));
      var PragmaKindFlags;
      (function(PragmaKindFlags2) {
        PragmaKindFlags2[PragmaKindFlags2["None"] = 0] = "None";
        PragmaKindFlags2[PragmaKindFlags2["TripleSlashXML"] = 1] = "TripleSlashXML";
        PragmaKindFlags2[PragmaKindFlags2["SingleLine"] = 2] = "SingleLine";
        PragmaKindFlags2[PragmaKindFlags2["MultiLine"] = 4] = "MultiLine";
        PragmaKindFlags2[PragmaKindFlags2["All"] = 7] = "All";
        PragmaKindFlags2[PragmaKindFlags2["Default"] = 7] = "Default";
      })(PragmaKindFlags = ts2.PragmaKindFlags || (ts2.PragmaKindFlags = {}));
      ts2.commentPragmas = {
        "reference": {
          args: [
            { name: "types", optional: true, captureSpan: true },
            { name: "lib", optional: true, captureSpan: true },
            { name: "path", optional: true, captureSpan: true },
            { name: "no-default-lib", optional: true }
          ],
          kind: 1
        },
        "amd-dependency": {
          args: [{ name: "path" }, { name: "name", optional: true }],
          kind: 1
        },
        "amd-module": {
          args: [{ name: "name" }],
          kind: 1
        },
        "ts-check": {
          kind: 2
        },
        "ts-nocheck": {
          kind: 2
        },
        "jsx": {
          args: [{ name: "factory" }],
          kind: 4
        }
      };
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      function generateDjb2Hash(data) {
        var acc = 5381;
        for (var i = 0; i < data.length; i++) {
          acc = (acc << 5) + acc + data.charCodeAt(i);
        }
        return acc.toString();
      }
      ts2.generateDjb2Hash = generateDjb2Hash;
      function setStackTraceLimit() {
        if (Error.stackTraceLimit < 100) {
          Error.stackTraceLimit = 100;
        }
      }
      ts2.setStackTraceLimit = setStackTraceLimit;
      var FileWatcherEventKind;
      (function(FileWatcherEventKind2) {
        FileWatcherEventKind2[FileWatcherEventKind2["Created"] = 0] = "Created";
        FileWatcherEventKind2[FileWatcherEventKind2["Changed"] = 1] = "Changed";
        FileWatcherEventKind2[FileWatcherEventKind2["Deleted"] = 2] = "Deleted";
      })(FileWatcherEventKind = ts2.FileWatcherEventKind || (ts2.FileWatcherEventKind = {}));
      var PollingInterval;
      (function(PollingInterval2) {
        PollingInterval2[PollingInterval2["High"] = 2e3] = "High";
        PollingInterval2[PollingInterval2["Medium"] = 500] = "Medium";
        PollingInterval2[PollingInterval2["Low"] = 250] = "Low";
      })(PollingInterval = ts2.PollingInterval || (ts2.PollingInterval = {}));
      ts2.missingFileModifiedTime = new Date(0);
      function createPollingIntervalBasedLevels(levels) {
        var _a;
        return _a = {}, _a[PollingInterval.Low] = levels.Low, _a[PollingInterval.Medium] = levels.Medium, _a[PollingInterval.High] = levels.High, _a;
      }
      var defaultChunkLevels = { Low: 32, Medium: 64, High: 256 };
      var pollingChunkSize = createPollingIntervalBasedLevels(defaultChunkLevels);
      ts2.unchangedPollThresholds = createPollingIntervalBasedLevels(defaultChunkLevels);
      function setCustomPollingValues(system) {
        if (!system.getEnvironmentVariable) {
          return;
        }
        var pollingIntervalChanged = setCustomLevels("TSC_WATCH_POLLINGINTERVAL", PollingInterval);
        pollingChunkSize = getCustomPollingBasedLevels("TSC_WATCH_POLLINGCHUNKSIZE", defaultChunkLevels) || pollingChunkSize;
        ts2.unchangedPollThresholds = getCustomPollingBasedLevels("TSC_WATCH_UNCHANGEDPOLLTHRESHOLDS", defaultChunkLevels) || ts2.unchangedPollThresholds;
        function getLevel(envVar, level) {
          return system.getEnvironmentVariable(envVar + "_" + level.toUpperCase());
        }
        function getCustomLevels(baseVariable) {
          var customLevels;
          setCustomLevel("Low");
          setCustomLevel("Medium");
          setCustomLevel("High");
          return customLevels;
          function setCustomLevel(level) {
            var customLevel = getLevel(baseVariable, level);
            if (customLevel) {
              (customLevels || (customLevels = {}))[level] = Number(customLevel);
            }
          }
        }
        function setCustomLevels(baseVariable, levels) {
          var customLevels = getCustomLevels(baseVariable);
          if (customLevels) {
            setLevel("Low");
            setLevel("Medium");
            setLevel("High");
            return true;
          }
          return false;
          function setLevel(level) {
            levels[level] = customLevels[level] || levels[level];
          }
        }
        function getCustomPollingBasedLevels(baseVariable, defaultLevels) {
          var customLevels = getCustomLevels(baseVariable);
          return (pollingIntervalChanged || customLevels) && createPollingIntervalBasedLevels(customLevels ? __assign(__assign({}, defaultLevels), customLevels) : defaultLevels);
        }
      }
      ts2.setCustomPollingValues = setCustomPollingValues;
      function createDynamicPriorityPollingWatchFile(host) {
        var watchedFiles = [];
        var changedFilesInLastPoll = [];
        var lowPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.Low);
        var mediumPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.Medium);
        var highPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.High);
        return watchFile;
        function watchFile(fileName, callback, defaultPollingInterval) {
          var file = {
            fileName,
            callback,
            unchangedPolls: 0,
            mtime: getModifiedTime(fileName)
          };
          watchedFiles.push(file);
          addToPollingIntervalQueue(file, defaultPollingInterval);
          return {
            close: function() {
              file.isClosed = true;
              ts2.unorderedRemoveItem(watchedFiles, file);
            }
          };
        }
        function createPollingIntervalQueue(pollingInterval) {
          var queue = [];
          queue.pollingInterval = pollingInterval;
          queue.pollIndex = 0;
          queue.pollScheduled = false;
          return queue;
        }
        function pollPollingIntervalQueue(queue) {
          queue.pollIndex = pollQueue(queue, queue.pollingInterval, queue.pollIndex, pollingChunkSize[queue.pollingInterval]);
          if (queue.length) {
            scheduleNextPoll(queue.pollingInterval);
          } else {
            ts2.Debug.assert(queue.pollIndex === 0);
            queue.pollScheduled = false;
          }
        }
        function pollLowPollingIntervalQueue(queue) {
          pollQueue(changedFilesInLastPoll, PollingInterval.Low, 0, changedFilesInLastPoll.length);
          pollPollingIntervalQueue(queue);
          if (!queue.pollScheduled && changedFilesInLastPoll.length) {
            scheduleNextPoll(PollingInterval.Low);
          }
        }
        function pollQueue(queue, pollingInterval, pollIndex, chunkSize) {
          var needsVisit = queue.length;
          var definedValueCopyToIndex = pollIndex;
          for (var polled = 0; polled < chunkSize && needsVisit > 0; nextPollIndex(), needsVisit--) {
            var watchedFile = queue[pollIndex];
            if (!watchedFile) {
              continue;
            } else if (watchedFile.isClosed) {
              queue[pollIndex] = void 0;
              continue;
            }
            polled++;
            var fileChanged = onWatchedFileStat(watchedFile, getModifiedTime(watchedFile.fileName));
            if (watchedFile.isClosed) {
              queue[pollIndex] = void 0;
            } else if (fileChanged) {
              watchedFile.unchangedPolls = 0;
              if (queue !== changedFilesInLastPoll) {
                queue[pollIndex] = void 0;
                addChangedFileToLowPollingIntervalQueue(watchedFile);
              }
            } else if (watchedFile.unchangedPolls !== ts2.unchangedPollThresholds[pollingInterval]) {
              watchedFile.unchangedPolls++;
            } else if (queue === changedFilesInLastPoll) {
              watchedFile.unchangedPolls = 1;
              queue[pollIndex] = void 0;
              addToPollingIntervalQueue(watchedFile, PollingInterval.Low);
            } else if (pollingInterval !== PollingInterval.High) {
              watchedFile.unchangedPolls++;
              queue[pollIndex] = void 0;
              addToPollingIntervalQueue(watchedFile, pollingInterval === PollingInterval.Low ? PollingInterval.Medium : PollingInterval.High);
            }
            if (queue[pollIndex]) {
              if (definedValueCopyToIndex < pollIndex) {
                queue[definedValueCopyToIndex] = watchedFile;
                queue[pollIndex] = void 0;
              }
              definedValueCopyToIndex++;
            }
          }
          return pollIndex;
          function nextPollIndex() {
            pollIndex++;
            if (pollIndex === queue.length) {
              if (definedValueCopyToIndex < pollIndex) {
                queue.length = definedValueCopyToIndex;
              }
              pollIndex = 0;
              definedValueCopyToIndex = 0;
            }
          }
        }
        function pollingIntervalQueue(pollingInterval) {
          switch (pollingInterval) {
            case PollingInterval.Low:
              return lowPollingIntervalQueue;
            case PollingInterval.Medium:
              return mediumPollingIntervalQueue;
            case PollingInterval.High:
              return highPollingIntervalQueue;
          }
        }
        function addToPollingIntervalQueue(file, pollingInterval) {
          pollingIntervalQueue(pollingInterval).push(file);
          scheduleNextPollIfNotAlreadyScheduled(pollingInterval);
        }
        function addChangedFileToLowPollingIntervalQueue(file) {
          changedFilesInLastPoll.push(file);
          scheduleNextPollIfNotAlreadyScheduled(PollingInterval.Low);
        }
        function scheduleNextPollIfNotAlreadyScheduled(pollingInterval) {
          if (!pollingIntervalQueue(pollingInterval).pollScheduled) {
            scheduleNextPoll(pollingInterval);
          }
        }
        function scheduleNextPoll(pollingInterval) {
          pollingIntervalQueue(pollingInterval).pollScheduled = host.setTimeout(pollingInterval === PollingInterval.Low ? pollLowPollingIntervalQueue : pollPollingIntervalQueue, pollingInterval, pollingIntervalQueue(pollingInterval));
        }
        function getModifiedTime(fileName) {
          return host.getModifiedTime(fileName) || ts2.missingFileModifiedTime;
        }
      }
      ts2.createDynamicPriorityPollingWatchFile = createDynamicPriorityPollingWatchFile;
      function createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames) {
        var fileWatcherCallbacks = ts2.createMultiMap();
        var dirWatchers = ts2.createMap();
        var toCanonicalName = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
        return nonPollingWatchFile;
        function nonPollingWatchFile(fileName, callback, _pollingInterval, fallbackOptions) {
          var filePath = toCanonicalName(fileName);
          fileWatcherCallbacks.add(filePath, callback);
          var dirPath = ts2.getDirectoryPath(filePath) || ".";
          var watcher = dirWatchers.get(dirPath) || createDirectoryWatcher(ts2.getDirectoryPath(fileName) || ".", dirPath, fallbackOptions);
          watcher.referenceCount++;
          return {
            close: function() {
              if (watcher.referenceCount === 1) {
                watcher.close();
                dirWatchers.delete(dirPath);
              } else {
                watcher.referenceCount--;
              }
              fileWatcherCallbacks.remove(filePath, callback);
            }
          };
        }
        function createDirectoryWatcher(dirName, dirPath, fallbackOptions) {
          var watcher = fsWatch(dirName, 1, function(_eventName, relativeFileName) {
            if (!ts2.isString(relativeFileName)) {
              return;
            }
            var fileName = ts2.getNormalizedAbsolutePath(relativeFileName, dirName);
            var callbacks = fileName && fileWatcherCallbacks.get(toCanonicalName(fileName));
            if (callbacks) {
              for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
                var fileCallback = callbacks_1[_i];
                fileCallback(fileName, FileWatcherEventKind.Changed);
              }
            }
          }, false, PollingInterval.Medium, fallbackOptions);
          watcher.referenceCount = 0;
          dirWatchers.set(dirPath, watcher);
          return watcher;
        }
      }
      function createSingleFileWatcherPerName(watchFile, useCaseSensitiveFileNames) {
        var cache = ts2.createMap();
        var callbacksCache = ts2.createMultiMap();
        var toCanonicalFileName = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
        return function(fileName, callback, pollingInterval, options) {
          var path2 = toCanonicalFileName(fileName);
          var existing = cache.get(path2);
          if (existing) {
            existing.refCount++;
          } else {
            cache.set(path2, {
              watcher: watchFile(fileName, function(fileName2, eventKind) {
                return ts2.forEach(callbacksCache.get(path2), function(cb) {
                  return cb(fileName2, eventKind);
                });
              }, pollingInterval, options),
              refCount: 1
            });
          }
          callbacksCache.add(path2, callback);
          return {
            close: function() {
              var watcher = ts2.Debug.checkDefined(cache.get(path2));
              callbacksCache.remove(path2, callback);
              watcher.refCount--;
              if (watcher.refCount)
                return;
              cache.delete(path2);
              ts2.closeFileWatcherOf(watcher);
            }
          };
        };
      }
      ts2.createSingleFileWatcherPerName = createSingleFileWatcherPerName;
      function onWatchedFileStat(watchedFile, modifiedTime) {
        var oldTime = watchedFile.mtime.getTime();
        var newTime = modifiedTime.getTime();
        if (oldTime !== newTime) {
          watchedFile.mtime = modifiedTime;
          watchedFile.callback(watchedFile.fileName, getFileWatcherEventKind(oldTime, newTime));
          return true;
        }
        return false;
      }
      ts2.onWatchedFileStat = onWatchedFileStat;
      function getFileWatcherEventKind(oldTime, newTime) {
        return oldTime === 0 ? FileWatcherEventKind.Created : newTime === 0 ? FileWatcherEventKind.Deleted : FileWatcherEventKind.Changed;
      }
      ts2.getFileWatcherEventKind = getFileWatcherEventKind;
      ts2.ignoredPaths = ["/node_modules/.", "/.git", "/.#"];
      ts2.sysLog = ts2.noop;
      function setSysLog(logger) {
        ts2.sysLog = logger;
      }
      ts2.setSysLog = setSysLog;
      function createDirectoryWatcherSupportingRecursive(host) {
        var cache = ts2.createMap();
        var callbackCache = ts2.createMultiMap();
        var cacheToUpdateChildWatches = ts2.createMap();
        var timerToUpdateChildWatches;
        var filePathComparer = ts2.getStringComparer(!host.useCaseSensitiveFileNames);
        var toCanonicalFilePath = ts2.createGetCanonicalFileName(host.useCaseSensitiveFileNames);
        return function(dirName, callback, recursive, options) {
          return recursive ? createDirectoryWatcher(dirName, options, callback) : host.watchDirectory(dirName, callback, recursive, options);
        };
        function createDirectoryWatcher(dirName, options, callback) {
          var dirPath = toCanonicalFilePath(dirName);
          var directoryWatcher = cache.get(dirPath);
          if (directoryWatcher) {
            directoryWatcher.refCount++;
          } else {
            directoryWatcher = {
              watcher: host.watchDirectory(dirName, function(fileName) {
                if (isIgnoredPath(fileName))
                  return;
                if (options === null || options === void 0 ? void 0 : options.synchronousWatchDirectory) {
                  invokeCallbacks(dirPath, fileName);
                  updateChildWatches(dirName, dirPath, options);
                } else {
                  nonSyncUpdateChildWatches(dirName, dirPath, fileName, options);
                }
              }, false, options),
              refCount: 1,
              childWatches: ts2.emptyArray
            };
            cache.set(dirPath, directoryWatcher);
            updateChildWatches(dirName, dirPath, options);
          }
          var callbackToAdd = callback && { dirName, callback };
          if (callbackToAdd) {
            callbackCache.add(dirPath, callbackToAdd);
          }
          return {
            dirName,
            close: function() {
              var directoryWatcher2 = ts2.Debug.checkDefined(cache.get(dirPath));
              if (callbackToAdd)
                callbackCache.remove(dirPath, callbackToAdd);
              directoryWatcher2.refCount--;
              if (directoryWatcher2.refCount)
                return;
              cache.delete(dirPath);
              ts2.closeFileWatcherOf(directoryWatcher2);
              directoryWatcher2.childWatches.forEach(ts2.closeFileWatcher);
            }
          };
        }
        function invokeCallbacks(dirPath, fileNameOrInvokeMap) {
          var fileName;
          var invokeMap;
          if (ts2.isString(fileNameOrInvokeMap)) {
            fileName = fileNameOrInvokeMap;
          } else {
            invokeMap = fileNameOrInvokeMap;
          }
          callbackCache.forEach(function(callbacks, rootDirName) {
            if (invokeMap && invokeMap.has(rootDirName))
              return;
            if (rootDirName === dirPath || ts2.startsWith(dirPath, rootDirName) && dirPath[rootDirName.length] === ts2.directorySeparator) {
              if (invokeMap) {
                invokeMap.set(rootDirName, true);
              } else {
                callbacks.forEach(function(_a) {
                  var callback = _a.callback;
                  return callback(fileName);
                });
              }
            }
          });
        }
        function nonSyncUpdateChildWatches(dirName, dirPath, fileName, options) {
          var parentWatcher = cache.get(dirPath);
          if (parentWatcher && host.directoryExists(dirName)) {
            scheduleUpdateChildWatches(dirName, dirPath, options);
            return;
          }
          invokeCallbacks(dirPath, fileName);
          removeChildWatches(parentWatcher);
        }
        function scheduleUpdateChildWatches(dirName, dirPath, options) {
          if (!cacheToUpdateChildWatches.has(dirPath)) {
            cacheToUpdateChildWatches.set(dirPath, { dirName, options });
          }
          if (timerToUpdateChildWatches) {
            host.clearTimeout(timerToUpdateChildWatches);
            timerToUpdateChildWatches = void 0;
          }
          timerToUpdateChildWatches = host.setTimeout(onTimerToUpdateChildWatches, 1e3);
        }
        function onTimerToUpdateChildWatches() {
          timerToUpdateChildWatches = void 0;
          ts2.sysLog("sysLog:: onTimerToUpdateChildWatches:: " + cacheToUpdateChildWatches.size);
          var start = ts2.timestamp();
          var invokeMap = ts2.createMap();
          while (!timerToUpdateChildWatches && cacheToUpdateChildWatches.size) {
            var _a = cacheToUpdateChildWatches.entries().next(), _b = _a.value, dirPath = _b[0], _c = _b[1], dirName = _c.dirName, options = _c.options, done = _a.done;
            ts2.Debug.assert(!done);
            cacheToUpdateChildWatches.delete(dirPath);
            invokeCallbacks(dirPath, invokeMap);
            updateChildWatches(dirName, dirPath, options);
          }
          ts2.sysLog("sysLog:: invokingWatchers:: " + (ts2.timestamp() - start) + "ms:: " + cacheToUpdateChildWatches.size);
          callbackCache.forEach(function(callbacks, rootDirName) {
            if (invokeMap.has(rootDirName)) {
              callbacks.forEach(function(_a2) {
                var callback = _a2.callback, dirName2 = _a2.dirName;
                return callback(dirName2);
              });
            }
          });
          var elapsed = ts2.timestamp() - start;
          ts2.sysLog("sysLog:: Elapsed " + elapsed + "ms:: onTimerToUpdateChildWatches:: " + cacheToUpdateChildWatches.size + " " + timerToUpdateChildWatches);
        }
        function removeChildWatches(parentWatcher) {
          if (!parentWatcher)
            return;
          var existingChildWatches = parentWatcher.childWatches;
          parentWatcher.childWatches = ts2.emptyArray;
          for (var _i = 0, existingChildWatches_1 = existingChildWatches; _i < existingChildWatches_1.length; _i++) {
            var childWatcher = existingChildWatches_1[_i];
            childWatcher.close();
            removeChildWatches(cache.get(toCanonicalFilePath(childWatcher.dirName)));
          }
        }
        function updateChildWatches(dirName, dirPath, options) {
          var parentWatcher = cache.get(dirPath);
          if (parentWatcher) {
            parentWatcher.childWatches = watchChildDirectories(dirName, parentWatcher.childWatches, options);
          }
        }
        function watchChildDirectories(parentDir, existingChildWatches, options) {
          var newChildWatches;
          ts2.enumerateInsertsAndDeletes(host.directoryExists(parentDir) ? ts2.mapDefined(host.getAccessibleSortedChildDirectories(parentDir), function(child) {
            var childFullName = ts2.getNormalizedAbsolutePath(child, parentDir);
            return !isIgnoredPath(childFullName) && filePathComparer(childFullName, ts2.normalizePath(host.realpath(childFullName))) === 0 ? childFullName : void 0;
          }) : ts2.emptyArray, existingChildWatches, function(child, childWatcher) {
            return filePathComparer(child, childWatcher.dirName);
          }, createAndAddChildDirectoryWatcher, ts2.closeFileWatcher, addChildDirectoryWatcher);
          return newChildWatches || ts2.emptyArray;
          function createAndAddChildDirectoryWatcher(childName) {
            var result = createDirectoryWatcher(childName, options);
            addChildDirectoryWatcher(result);
          }
          function addChildDirectoryWatcher(childWatcher) {
            (newChildWatches || (newChildWatches = [])).push(childWatcher);
          }
        }
        function isIgnoredPath(path2) {
          return ts2.some(ts2.ignoredPaths, function(searchPath) {
            return isInPath(path2, searchPath);
          });
        }
        function isInPath(path2, searchPath) {
          if (ts2.stringContains(path2, searchPath))
            return true;
          if (host.useCaseSensitiveFileNames)
            return false;
          return ts2.stringContains(toCanonicalFilePath(path2), searchPath);
        }
      }
      ts2.createDirectoryWatcherSupportingRecursive = createDirectoryWatcherSupportingRecursive;
      var FileSystemEntryKind;
      (function(FileSystemEntryKind2) {
        FileSystemEntryKind2[FileSystemEntryKind2["File"] = 0] = "File";
        FileSystemEntryKind2[FileSystemEntryKind2["Directory"] = 1] = "Directory";
      })(FileSystemEntryKind = ts2.FileSystemEntryKind || (ts2.FileSystemEntryKind = {}));
      function createFileWatcherCallback(callback) {
        return function(_fileName, eventKind) {
          return callback(eventKind === FileWatcherEventKind.Changed ? "change" : "rename", "");
        };
      }
      ts2.createFileWatcherCallback = createFileWatcherCallback;
      function createFsWatchCallbackForFileWatcherCallback(fileName, callback, fileExists) {
        return function(eventName) {
          if (eventName === "rename") {
            callback(fileName, fileExists(fileName) ? FileWatcherEventKind.Created : FileWatcherEventKind.Deleted);
          } else {
            callback(fileName, FileWatcherEventKind.Changed);
          }
        };
      }
      function createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback) {
        return function(eventName, relativeFileName) {
          if (eventName === "rename") {
            callback(!relativeFileName ? directoryName : ts2.normalizePath(ts2.combinePaths(directoryName, relativeFileName)));
          }
        };
      }
      function createSystemWatchFunctions(_a) {
        var pollingWatchFile = _a.pollingWatchFile, getModifiedTime = _a.getModifiedTime, setTimeout2 = _a.setTimeout, clearTimeout2 = _a.clearTimeout, fsWatch = _a.fsWatch, fileExists = _a.fileExists, useCaseSensitiveFileNames = _a.useCaseSensitiveFileNames, fsSupportsRecursiveFsWatch = _a.fsSupportsRecursiveFsWatch, directoryExists = _a.directoryExists, getAccessibleSortedChildDirectories = _a.getAccessibleSortedChildDirectories, realpath = _a.realpath, tscWatchFile = _a.tscWatchFile, useNonPollingWatchers = _a.useNonPollingWatchers, tscWatchDirectory = _a.tscWatchDirectory;
        var dynamicPollingWatchFile;
        var nonPollingWatchFile;
        var hostRecursiveDirectoryWatcher;
        return {
          watchFile,
          watchDirectory
        };
        function watchFile(fileName, callback, pollingInterval, options) {
          options = updateOptionsForWatchFile(options, useNonPollingWatchers);
          var watchFileKind = ts2.Debug.checkDefined(options.watchFile);
          switch (watchFileKind) {
            case ts2.WatchFileKind.FixedPollingInterval:
              return pollingWatchFile(fileName, callback, PollingInterval.Low, void 0);
            case ts2.WatchFileKind.PriorityPollingInterval:
              return pollingWatchFile(fileName, callback, pollingInterval, void 0);
            case ts2.WatchFileKind.DynamicPriorityPolling:
              return ensureDynamicPollingWatchFile()(fileName, callback, pollingInterval, void 0);
            case ts2.WatchFileKind.UseFsEvents:
              return fsWatch(fileName, 0, createFsWatchCallbackForFileWatcherCallback(fileName, callback, fileExists), false, pollingInterval, ts2.getFallbackOptions(options));
            case ts2.WatchFileKind.UseFsEventsOnParentDirectory:
              if (!nonPollingWatchFile) {
                nonPollingWatchFile = createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames);
              }
              return nonPollingWatchFile(fileName, callback, pollingInterval, ts2.getFallbackOptions(options));
            default:
              ts2.Debug.assertNever(watchFileKind);
          }
        }
        function ensureDynamicPollingWatchFile() {
          return dynamicPollingWatchFile || (dynamicPollingWatchFile = createDynamicPriorityPollingWatchFile({ getModifiedTime, setTimeout: setTimeout2 }));
        }
        function updateOptionsForWatchFile(options, useNonPollingWatchers2) {
          if (options && options.watchFile !== void 0)
            return options;
          switch (tscWatchFile) {
            case "PriorityPollingInterval":
              return { watchFile: ts2.WatchFileKind.PriorityPollingInterval };
            case "DynamicPriorityPolling":
              return { watchFile: ts2.WatchFileKind.DynamicPriorityPolling };
            case "UseFsEvents":
              return generateWatchFileOptions(ts2.WatchFileKind.UseFsEvents, ts2.PollingWatchKind.PriorityInterval, options);
            case "UseFsEventsWithFallbackDynamicPolling":
              return generateWatchFileOptions(ts2.WatchFileKind.UseFsEvents, ts2.PollingWatchKind.DynamicPriority, options);
            case "UseFsEventsOnParentDirectory":
              useNonPollingWatchers2 = true;
            default:
              return useNonPollingWatchers2 ? generateWatchFileOptions(ts2.WatchFileKind.UseFsEventsOnParentDirectory, ts2.PollingWatchKind.PriorityInterval, options) : { watchFile: ts2.WatchFileKind.FixedPollingInterval };
          }
        }
        function generateWatchFileOptions(watchFile2, fallbackPolling, options) {
          var defaultFallbackPolling = options === null || options === void 0 ? void 0 : options.fallbackPolling;
          return {
            watchFile: watchFile2,
            fallbackPolling: defaultFallbackPolling === void 0 ? fallbackPolling : defaultFallbackPolling
          };
        }
        function watchDirectory(directoryName, callback, recursive, options) {
          if (fsSupportsRecursiveFsWatch) {
            return fsWatch(directoryName, 1, createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback), recursive, PollingInterval.Medium, ts2.getFallbackOptions(options));
          }
          if (!hostRecursiveDirectoryWatcher) {
            hostRecursiveDirectoryWatcher = createDirectoryWatcherSupportingRecursive({
              useCaseSensitiveFileNames,
              directoryExists,
              getAccessibleSortedChildDirectories,
              watchDirectory: nonRecursiveWatchDirectory,
              realpath,
              setTimeout: setTimeout2,
              clearTimeout: clearTimeout2
            });
          }
          return hostRecursiveDirectoryWatcher(directoryName, callback, recursive, options);
        }
        function nonRecursiveWatchDirectory(directoryName, callback, recursive, options) {
          ts2.Debug.assert(!recursive);
          options = updateOptionsForWatchDirectory(options);
          var watchDirectoryKind = ts2.Debug.checkDefined(options.watchDirectory);
          switch (watchDirectoryKind) {
            case ts2.WatchDirectoryKind.FixedPollingInterval:
              return pollingWatchFile(directoryName, function() {
                return callback(directoryName);
              }, PollingInterval.Medium, void 0);
            case ts2.WatchDirectoryKind.DynamicPriorityPolling:
              return ensureDynamicPollingWatchFile()(directoryName, function() {
                return callback(directoryName);
              }, PollingInterval.Medium, void 0);
            case ts2.WatchDirectoryKind.UseFsEvents:
              return fsWatch(directoryName, 1, createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback), recursive, PollingInterval.Medium, ts2.getFallbackOptions(options));
            default:
              ts2.Debug.assertNever(watchDirectoryKind);
          }
        }
        function updateOptionsForWatchDirectory(options) {
          if (options && options.watchDirectory !== void 0)
            return options;
          switch (tscWatchDirectory) {
            case "RecursiveDirectoryUsingFsWatchFile":
              return { watchDirectory: ts2.WatchDirectoryKind.FixedPollingInterval };
            case "RecursiveDirectoryUsingDynamicPriorityPolling":
              return { watchDirectory: ts2.WatchDirectoryKind.DynamicPriorityPolling };
            default:
              var defaultFallbackPolling = options === null || options === void 0 ? void 0 : options.fallbackPolling;
              return {
                watchDirectory: ts2.WatchDirectoryKind.UseFsEvents,
                fallbackPolling: defaultFallbackPolling !== void 0 ? defaultFallbackPolling : void 0
              };
          }
        }
      }
      ts2.createSystemWatchFunctions = createSystemWatchFunctions;
      function patchWriteFileEnsuringDirectory(sys) {
        var originalWriteFile = sys.writeFile;
        sys.writeFile = function(path2, data, writeBom) {
          return ts2.writeFileEnsuringDirectories(path2, data, !!writeBom, function(path3, data2, writeByteOrderMark) {
            return originalWriteFile.call(sys, path3, data2, writeByteOrderMark);
          }, function(path3) {
            return sys.createDirectory(path3);
          }, function(path3) {
            return sys.directoryExists(path3);
          });
        };
      }
      ts2.patchWriteFileEnsuringDirectory = patchWriteFileEnsuringDirectory;
      function getNodeMajorVersion() {
        if (typeof process === "undefined") {
          return void 0;
        }
        var version = process.version;
        if (!version) {
          return void 0;
        }
        var dot = version.indexOf(".");
        if (dot === -1) {
          return void 0;
        }
        return parseInt(version.substring(1, dot));
      }
      ts2.getNodeMajorVersion = getNodeMajorVersion;
      ts2.sys = function() {
        var byteOrderMarkIndicator = "\uFEFF";
        function getNodeSystem() {
          var nativePattern = /^native |^\([^)]+\)$|^(internal[\\/]|[a-zA-Z0-9_\s]+(\.js)?$)/;
          var _fs = require("fs");
          var _path = require("path");
          var _os = require("os");
          var _crypto;
          try {
            _crypto = require("crypto");
          } catch (_a) {
            _crypto = void 0;
          }
          var activeSession;
          var profilePath = "./profile.cpuprofile";
          var Buffer2 = require("buffer").Buffer;
          var nodeVersion = getNodeMajorVersion();
          var isNode4OrLater = nodeVersion >= 4;
          var isLinuxOrMacOs = process.platform === "linux" || process.platform === "darwin";
          var platform = _os.platform();
          var useCaseSensitiveFileNames = isFileSystemCaseSensitive();
          var fsSupportsRecursiveFsWatch = isNode4OrLater && (process.platform === "win32" || process.platform === "darwin");
          var _b = createSystemWatchFunctions({
            pollingWatchFile: createSingleFileWatcherPerName(fsWatchFileWorker, useCaseSensitiveFileNames),
            getModifiedTime,
            setTimeout,
            clearTimeout,
            fsWatch,
            useCaseSensitiveFileNames,
            fileExists,
            fsSupportsRecursiveFsWatch,
            directoryExists,
            getAccessibleSortedChildDirectories: function(path2) {
              return getAccessibleFileSystemEntries(path2).directories;
            },
            realpath,
            tscWatchFile: process.env.TSC_WATCHFILE,
            useNonPollingWatchers: process.env.TSC_NONPOLLING_WATCHER,
            tscWatchDirectory: process.env.TSC_WATCHDIRECTORY
          }), watchFile = _b.watchFile, watchDirectory = _b.watchDirectory;
          var nodeSystem = {
            args: process.argv.slice(2),
            newLine: _os.EOL,
            useCaseSensitiveFileNames,
            write: function(s) {
              process.stdout.write(s);
            },
            writeOutputIsTTY: function() {
              return process.stdout.isTTY;
            },
            readFile,
            writeFile,
            watchFile,
            watchDirectory,
            resolvePath: function(path2) {
              return _path.resolve(path2);
            },
            fileExists,
            directoryExists,
            createDirectory: function(directoryName) {
              if (!nodeSystem.directoryExists(directoryName)) {
                try {
                  _fs.mkdirSync(directoryName);
                } catch (e) {
                  if (e.code !== "EEXIST") {
                    throw e;
                  }
                }
              }
            },
            getExecutingFilePath: function() {
              return __filename;
            },
            getCurrentDirectory: function() {
              return process.cwd();
            },
            getDirectories,
            getEnvironmentVariable: function(name) {
              return process.env[name] || "";
            },
            readDirectory,
            getModifiedTime,
            setModifiedTime,
            deleteFile,
            createHash: _crypto ? createSHA256Hash : generateDjb2Hash,
            createSHA256Hash: _crypto ? createSHA256Hash : void 0,
            getMemoryUsage: function() {
              if (global.gc) {
                global.gc();
              }
              return process.memoryUsage().heapUsed;
            },
            getFileSize: function(path2) {
              try {
                var stat = statSync(path2);
                if (stat === null || stat === void 0 ? void 0 : stat.isFile()) {
                  return stat.size;
                }
              } catch (_a) {
              }
              return 0;
            },
            exit: function(exitCode) {
              disableCPUProfiler(function() {
                return process.exit(exitCode);
              });
            },
            enableCPUProfiler,
            disableCPUProfiler,
            realpath,
            debugMode: !!process.env.NODE_INSPECTOR_IPC || ts2.some(process.execArgv, function(arg) {
              return /^--(inspect|debug)(-brk)?(=\d+)?$/i.test(arg);
            }),
            tryEnableSourceMapsForHost: function() {
              try {
                require_source_map_support().install();
              } catch (_a) {
              }
            },
            setTimeout,
            clearTimeout,
            clearScreen: function() {
              process.stdout.write("c");
            },
            setBlocking: function() {
              if (process.stdout && process.stdout._handle && process.stdout._handle.setBlocking) {
                process.stdout._handle.setBlocking(true);
              }
            },
            bufferFrom,
            base64decode: function(input) {
              return bufferFrom(input, "base64").toString("utf8");
            },
            base64encode: function(input) {
              return bufferFrom(input).toString("base64");
            },
            require: function(baseDir, moduleName) {
              try {
                var modulePath = ts2.resolveJSModule(moduleName, baseDir, nodeSystem);
                return { module: require(modulePath), modulePath, error: void 0 };
              } catch (error) {
                return { module: void 0, modulePath: void 0, error };
              }
            }
          };
          return nodeSystem;
          function statSync(path2) {
            return _fs.statSync(path2, { throwIfNoEntry: false });
          }
          function enableCPUProfiler(path2, cb) {
            if (activeSession) {
              cb();
              return false;
            }
            var inspector = require("inspector");
            if (!inspector || !inspector.Session) {
              cb();
              return false;
            }
            var session = new inspector.Session();
            session.connect();
            session.post("Profiler.enable", function() {
              session.post("Profiler.start", function() {
                activeSession = session;
                profilePath = path2;
                cb();
              });
            });
            return true;
          }
          function cleanupPaths(profile) {
            var externalFileCounter = 0;
            var remappedPaths = ts2.createMap();
            var normalizedDir = ts2.normalizeSlashes(__dirname);
            var fileUrlRoot = "file://" + (ts2.getRootLength(normalizedDir) === 1 ? "" : "/") + normalizedDir;
            for (var _i = 0, _a = profile.nodes; _i < _a.length; _i++) {
              var node = _a[_i];
              if (node.callFrame.url) {
                var url = ts2.normalizeSlashes(node.callFrame.url);
                if (ts2.containsPath(fileUrlRoot, url, useCaseSensitiveFileNames)) {
                  node.callFrame.url = ts2.getRelativePathToDirectoryOrUrl(fileUrlRoot, url, fileUrlRoot, ts2.createGetCanonicalFileName(useCaseSensitiveFileNames), true);
                } else if (!nativePattern.test(url)) {
                  node.callFrame.url = (remappedPaths.has(url) ? remappedPaths : remappedPaths.set(url, "external" + externalFileCounter + ".js")).get(url);
                  externalFileCounter++;
                }
              }
            }
            return profile;
          }
          function disableCPUProfiler(cb) {
            if (activeSession && activeSession !== "stopping") {
              var s_1 = activeSession;
              activeSession.post("Profiler.stop", function(err, _a) {
                var _b2;
                var profile = _a.profile;
                if (!err) {
                  try {
                    if ((_b2 = statSync(profilePath)) === null || _b2 === void 0 ? void 0 : _b2.isDirectory()) {
                      profilePath = _path.join(profilePath, new Date().toISOString().replace(/:/g, "-") + "+P" + process.pid + ".cpuprofile");
                    }
                  } catch (_c) {
                  }
                  try {
                    _fs.mkdirSync(_path.dirname(profilePath), { recursive: true });
                  } catch (_d) {
                  }
                  _fs.writeFileSync(profilePath, JSON.stringify(cleanupPaths(profile)));
                }
                activeSession = void 0;
                s_1.disconnect();
                cb();
              });
              activeSession = "stopping";
              return true;
            } else {
              cb();
              return false;
            }
          }
          function bufferFrom(input, encoding) {
            return Buffer2.from && Buffer2.from !== Int8Array.from ? Buffer2.from(input, encoding) : new Buffer2(input, encoding);
          }
          function isFileSystemCaseSensitive() {
            if (platform === "win32" || platform === "win64") {
              return false;
            }
            return !fileExists(swapCase(__filename));
          }
          function swapCase(s) {
            return s.replace(/\w/g, function(ch) {
              var up = ch.toUpperCase();
              return ch === up ? ch.toLowerCase() : up;
            });
          }
          function fsWatchFileWorker(fileName, callback, pollingInterval) {
            _fs.watchFile(fileName, { persistent: true, interval: pollingInterval }, fileChanged);
            var eventKind;
            return {
              close: function() {
                return _fs.unwatchFile(fileName, fileChanged);
              }
            };
            function fileChanged(curr, prev) {
              var isPreviouslyDeleted = +prev.mtime === 0 || eventKind === FileWatcherEventKind.Deleted;
              if (+curr.mtime === 0) {
                if (isPreviouslyDeleted) {
                  return;
                }
                eventKind = FileWatcherEventKind.Deleted;
              } else if (isPreviouslyDeleted) {
                eventKind = FileWatcherEventKind.Created;
              } else if (+curr.mtime === +prev.mtime) {
                return;
              } else {
                eventKind = FileWatcherEventKind.Changed;
              }
              callback(fileName, eventKind);
            }
          }
          function fsWatch(fileOrDirectory, entryKind, callback, recursive, fallbackPollingInterval, fallbackOptions) {
            var options;
            var lastDirectoryPartWithDirectorySeparator;
            var lastDirectoryPart;
            if (isLinuxOrMacOs) {
              lastDirectoryPartWithDirectorySeparator = fileOrDirectory.substr(fileOrDirectory.lastIndexOf(ts2.directorySeparator));
              lastDirectoryPart = lastDirectoryPartWithDirectorySeparator.slice(ts2.directorySeparator.length);
            }
            var watcher = !fileSystemEntryExists(fileOrDirectory, entryKind) ? watchMissingFileSystemEntry() : watchPresentFileSystemEntry();
            return {
              close: function() {
                watcher.close();
                watcher = void 0;
              }
            };
            function invokeCallbackAndUpdateWatcher(createWatcher) {
              ts2.sysLog("sysLog:: " + fileOrDirectory + ":: Changing watcher to " + (createWatcher === watchPresentFileSystemEntry ? "Present" : "Missing") + "FileSystemEntryWatcher");
              callback("rename", "");
              if (watcher) {
                watcher.close();
                watcher = createWatcher();
              }
            }
            function watchPresentFileSystemEntry() {
              if (options === void 0) {
                if (fsSupportsRecursiveFsWatch) {
                  options = { persistent: true, recursive: !!recursive };
                } else {
                  options = { persistent: true };
                }
              }
              try {
                var presentWatcher = _fs.watch(fileOrDirectory, options, isLinuxOrMacOs ? callbackChangingToMissingFileSystemEntry : callback);
                presentWatcher.on("error", function() {
                  return invokeCallbackAndUpdateWatcher(watchMissingFileSystemEntry);
                });
                return presentWatcher;
              } catch (e) {
                return watchPresentFileSystemEntryWithFsWatchFile();
              }
            }
            function callbackChangingToMissingFileSystemEntry(event, relativeName) {
              return event === "rename" && (!relativeName || relativeName === lastDirectoryPart || relativeName.lastIndexOf(lastDirectoryPartWithDirectorySeparator) === relativeName.length - lastDirectoryPartWithDirectorySeparator.length) && !fileSystemEntryExists(fileOrDirectory, entryKind) ? invokeCallbackAndUpdateWatcher(watchMissingFileSystemEntry) : callback(event, relativeName);
            }
            function watchPresentFileSystemEntryWithFsWatchFile() {
              ts2.sysLog("sysLog:: " + fileOrDirectory + ":: Changing to fsWatchFile");
              return watchFile(fileOrDirectory, createFileWatcherCallback(callback), fallbackPollingInterval, fallbackOptions);
            }
            function watchMissingFileSystemEntry() {
              return watchFile(fileOrDirectory, function(_fileName, eventKind) {
                if (eventKind === FileWatcherEventKind.Created && fileSystemEntryExists(fileOrDirectory, entryKind)) {
                  invokeCallbackAndUpdateWatcher(watchPresentFileSystemEntry);
                }
              }, fallbackPollingInterval, fallbackOptions);
            }
          }
          function readFileWorker(fileName, _encoding) {
            var buffer;
            try {
              buffer = _fs.readFileSync(fileName);
            } catch (e) {
              return void 0;
            }
            var len = buffer.length;
            if (len >= 2 && buffer[0] === 254 && buffer[1] === 255) {
              len &= ~1;
              for (var i = 0; i < len; i += 2) {
                var temp = buffer[i];
                buffer[i] = buffer[i + 1];
                buffer[i + 1] = temp;
              }
              return buffer.toString("utf16le", 2);
            }
            if (len >= 2 && buffer[0] === 255 && buffer[1] === 254) {
              return buffer.toString("utf16le", 2);
            }
            if (len >= 3 && buffer[0] === 239 && buffer[1] === 187 && buffer[2] === 191) {
              return buffer.toString("utf8", 3);
            }
            return buffer.toString("utf8");
          }
          function readFile(fileName, _encoding) {
            ts2.perfLogger.logStartReadFile(fileName);
            var file = readFileWorker(fileName, _encoding);
            ts2.perfLogger.logStopReadFile();
            return file;
          }
          function writeFile(fileName, data, writeByteOrderMark) {
            ts2.perfLogger.logEvent("WriteFile: " + fileName);
            if (writeByteOrderMark) {
              data = byteOrderMarkIndicator + data;
            }
            var fd;
            try {
              fd = _fs.openSync(fileName, "w");
              _fs.writeSync(fd, data, void 0, "utf8");
            } finally {
              if (fd !== void 0) {
                _fs.closeSync(fd);
              }
            }
          }
          function getAccessibleFileSystemEntries(path2) {
            ts2.perfLogger.logEvent("ReadDir: " + (path2 || "."));
            try {
              var entries = _fs.readdirSync(path2 || ".", { withFileTypes: true });
              var files = [];
              var directories = [];
              for (var _i = 0, entries_2 = entries; _i < entries_2.length; _i++) {
                var dirent = entries_2[_i];
                var entry = typeof dirent === "string" ? dirent : dirent.name;
                if (entry === "." || entry === "..") {
                  continue;
                }
                var stat = void 0;
                if (typeof dirent === "string" || dirent.isSymbolicLink()) {
                  var name = ts2.combinePaths(path2, entry);
                  try {
                    stat = statSync(name);
                    if (!stat) {
                      continue;
                    }
                  } catch (e) {
                    continue;
                  }
                } else {
                  stat = dirent;
                }
                if (stat.isFile()) {
                  files.push(entry);
                } else if (stat.isDirectory()) {
                  directories.push(entry);
                }
              }
              files.sort();
              directories.sort();
              return { files, directories };
            } catch (e) {
              return ts2.emptyFileSystemEntries;
            }
          }
          function readDirectory(path2, extensions, excludes, includes, depth) {
            return ts2.matchFiles(path2, extensions, excludes, includes, useCaseSensitiveFileNames, process.cwd(), depth, getAccessibleFileSystemEntries, realpath);
          }
          function fileSystemEntryExists(path2, entryKind) {
            try {
              var stat = statSync(path2);
              if (!stat) {
                return false;
              }
              switch (entryKind) {
                case 0:
                  return stat.isFile();
                case 1:
                  return stat.isDirectory();
                default:
                  return false;
              }
            } catch (e) {
              return false;
            }
          }
          function fileExists(path2) {
            return fileSystemEntryExists(path2, 0);
          }
          function directoryExists(path2) {
            return fileSystemEntryExists(path2, 1);
          }
          function getDirectories(path2) {
            return getAccessibleFileSystemEntries(path2).directories.slice();
          }
          function realpath(path2) {
            try {
              return _fs.realpathSync(path2);
            } catch (_a) {
              return path2;
            }
          }
          function getModifiedTime(path2) {
            var _a;
            try {
              return (_a = statSync(path2)) === null || _a === void 0 ? void 0 : _a.mtime;
            } catch (e) {
              return void 0;
            }
          }
          function setModifiedTime(path2, time) {
            try {
              _fs.utimesSync(path2, time, time);
            } catch (e) {
              return;
            }
          }
          function deleteFile(path2) {
            try {
              return _fs.unlinkSync(path2);
            } catch (e) {
              return;
            }
          }
          function createSHA256Hash(data) {
            var hash = _crypto.createHash("sha256");
            hash.update(data);
            return hash.digest("hex");
          }
        }
        var sys;
        if (typeof process !== "undefined" && process.nextTick && !process.browser && typeof require !== "undefined") {
          sys = getNodeSystem();
        }
        if (sys) {
          patchWriteFileEnsuringDirectory(sys);
        }
        return sys;
      }();
      if (ts2.sys && ts2.sys.getEnvironmentVariable) {
        setCustomPollingValues(ts2.sys);
        ts2.Debug.setAssertionLevel(/^development$/i.test(ts2.sys.getEnvironmentVariable("NODE_ENV")) ? 1 : 0);
      }
      if (ts2.sys && ts2.sys.debugMode) {
        ts2.Debug.isDebugging = true;
      }
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      ts2.directorySeparator = "/";
      var altDirectorySeparator = "\\";
      var urlSchemeSeparator = "://";
      var backslashRegExp = /\\/g;
      function isAnyDirectorySeparator(charCode) {
        return charCode === 47 || charCode === 92;
      }
      ts2.isAnyDirectorySeparator = isAnyDirectorySeparator;
      function isUrl(path2) {
        return getEncodedRootLength(path2) < 0;
      }
      ts2.isUrl = isUrl;
      function isRootedDiskPath(path2) {
        return getEncodedRootLength(path2) > 0;
      }
      ts2.isRootedDiskPath = isRootedDiskPath;
      function isDiskPathRoot(path2) {
        var rootLength = getEncodedRootLength(path2);
        return rootLength > 0 && rootLength === path2.length;
      }
      ts2.isDiskPathRoot = isDiskPathRoot;
      function pathIsAbsolute(path2) {
        return getEncodedRootLength(path2) !== 0;
      }
      ts2.pathIsAbsolute = pathIsAbsolute;
      function pathIsRelative(path2) {
        return /^\.\.?($|[\\/])/.test(path2);
      }
      ts2.pathIsRelative = pathIsRelative;
      function hasExtension(fileName) {
        return ts2.stringContains(getBaseFileName(fileName), ".");
      }
      ts2.hasExtension = hasExtension;
      function fileExtensionIs(path2, extension) {
        return path2.length > extension.length && ts2.endsWith(path2, extension);
      }
      ts2.fileExtensionIs = fileExtensionIs;
      function fileExtensionIsOneOf(path2, extensions) {
        for (var _i = 0, extensions_1 = extensions; _i < extensions_1.length; _i++) {
          var extension = extensions_1[_i];
          if (fileExtensionIs(path2, extension)) {
            return true;
          }
        }
        return false;
      }
      ts2.fileExtensionIsOneOf = fileExtensionIsOneOf;
      function hasTrailingDirectorySeparator(path2) {
        return path2.length > 0 && isAnyDirectorySeparator(path2.charCodeAt(path2.length - 1));
      }
      ts2.hasTrailingDirectorySeparator = hasTrailingDirectorySeparator;
      function isVolumeCharacter(charCode) {
        return charCode >= 97 && charCode <= 122 || charCode >= 65 && charCode <= 90;
      }
      function getFileUrlVolumeSeparatorEnd(url, start) {
        var ch0 = url.charCodeAt(start);
        if (ch0 === 58)
          return start + 1;
        if (ch0 === 37 && url.charCodeAt(start + 1) === 51) {
          var ch2 = url.charCodeAt(start + 2);
          if (ch2 === 97 || ch2 === 65)
            return start + 3;
        }
        return -1;
      }
      function getEncodedRootLength(path2) {
        if (!path2)
          return 0;
        var ch0 = path2.charCodeAt(0);
        if (ch0 === 47 || ch0 === 92) {
          if (path2.charCodeAt(1) !== ch0)
            return 1;
          var p1 = path2.indexOf(ch0 === 47 ? ts2.directorySeparator : altDirectorySeparator, 2);
          if (p1 < 0)
            return path2.length;
          return p1 + 1;
        }
        if (isVolumeCharacter(ch0) && path2.charCodeAt(1) === 58) {
          var ch2 = path2.charCodeAt(2);
          if (ch2 === 47 || ch2 === 92)
            return 3;
          if (path2.length === 2)
            return 2;
        }
        var schemeEnd = path2.indexOf(urlSchemeSeparator);
        if (schemeEnd !== -1) {
          var authorityStart = schemeEnd + urlSchemeSeparator.length;
          var authorityEnd = path2.indexOf(ts2.directorySeparator, authorityStart);
          if (authorityEnd !== -1) {
            var scheme = path2.slice(0, schemeEnd);
            var authority = path2.slice(authorityStart, authorityEnd);
            if (scheme === "file" && (authority === "" || authority === "localhost") && isVolumeCharacter(path2.charCodeAt(authorityEnd + 1))) {
              var volumeSeparatorEnd = getFileUrlVolumeSeparatorEnd(path2, authorityEnd + 2);
              if (volumeSeparatorEnd !== -1) {
                if (path2.charCodeAt(volumeSeparatorEnd) === 47) {
                  return ~(volumeSeparatorEnd + 1);
                }
                if (volumeSeparatorEnd === path2.length) {
                  return ~volumeSeparatorEnd;
                }
              }
            }
            return ~(authorityEnd + 1);
          }
          return ~path2.length;
        }
        return 0;
      }
      function getRootLength(path2) {
        var rootLength = getEncodedRootLength(path2);
        return rootLength < 0 ? ~rootLength : rootLength;
      }
      ts2.getRootLength = getRootLength;
      function getDirectoryPath(path2) {
        path2 = normalizeSlashes(path2);
        var rootLength = getRootLength(path2);
        if (rootLength === path2.length)
          return path2;
        path2 = removeTrailingDirectorySeparator(path2);
        return path2.slice(0, Math.max(rootLength, path2.lastIndexOf(ts2.directorySeparator)));
      }
      ts2.getDirectoryPath = getDirectoryPath;
      function getBaseFileName(path2, extensions, ignoreCase) {
        path2 = normalizeSlashes(path2);
        var rootLength = getRootLength(path2);
        if (rootLength === path2.length)
          return "";
        path2 = removeTrailingDirectorySeparator(path2);
        var name = path2.slice(Math.max(getRootLength(path2), path2.lastIndexOf(ts2.directorySeparator) + 1));
        var extension = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(name, extensions, ignoreCase) : void 0;
        return extension ? name.slice(0, name.length - extension.length) : name;
      }
      ts2.getBaseFileName = getBaseFileName;
      function tryGetExtensionFromPath(path2, extension, stringEqualityComparer) {
        if (!ts2.startsWith(extension, "."))
          extension = "." + extension;
        if (path2.length >= extension.length && path2.charCodeAt(path2.length - extension.length) === 46) {
          var pathExtension = path2.slice(path2.length - extension.length);
          if (stringEqualityComparer(pathExtension, extension)) {
            return pathExtension;
          }
        }
      }
      function getAnyExtensionFromPathWorker(path2, extensions, stringEqualityComparer) {
        if (typeof extensions === "string") {
          return tryGetExtensionFromPath(path2, extensions, stringEqualityComparer) || "";
        }
        for (var _i = 0, extensions_2 = extensions; _i < extensions_2.length; _i++) {
          var extension = extensions_2[_i];
          var result = tryGetExtensionFromPath(path2, extension, stringEqualityComparer);
          if (result)
            return result;
        }
        return "";
      }
      function getAnyExtensionFromPath(path2, extensions, ignoreCase) {
        if (extensions) {
          return getAnyExtensionFromPathWorker(removeTrailingDirectorySeparator(path2), extensions, ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive);
        }
        var baseFileName = getBaseFileName(path2);
        var extensionIndex = baseFileName.lastIndexOf(".");
        if (extensionIndex >= 0) {
          return baseFileName.substring(extensionIndex);
        }
        return "";
      }
      ts2.getAnyExtensionFromPath = getAnyExtensionFromPath;
      function pathComponents(path2, rootLength) {
        var root = path2.substring(0, rootLength);
        var rest = path2.substring(rootLength).split(ts2.directorySeparator);
        if (rest.length && !ts2.lastOrUndefined(rest))
          rest.pop();
        return __spreadArrays([root], rest);
      }
      function getPathComponents(path2, currentDirectory) {
        if (currentDirectory === void 0) {
          currentDirectory = "";
        }
        path2 = combinePaths(currentDirectory, path2);
        return pathComponents(path2, getRootLength(path2));
      }
      ts2.getPathComponents = getPathComponents;
      function getPathFromPathComponents(pathComponents2) {
        if (pathComponents2.length === 0)
          return "";
        var root = pathComponents2[0] && ensureTrailingDirectorySeparator(pathComponents2[0]);
        return root + pathComponents2.slice(1).join(ts2.directorySeparator);
      }
      ts2.getPathFromPathComponents = getPathFromPathComponents;
      function normalizeSlashes(path2) {
        return path2.replace(backslashRegExp, ts2.directorySeparator);
      }
      ts2.normalizeSlashes = normalizeSlashes;
      function reducePathComponents(components) {
        if (!ts2.some(components))
          return [];
        var reduced = [components[0]];
        for (var i = 1; i < components.length; i++) {
          var component = components[i];
          if (!component)
            continue;
          if (component === ".")
            continue;
          if (component === "..") {
            if (reduced.length > 1) {
              if (reduced[reduced.length - 1] !== "..") {
                reduced.pop();
                continue;
              }
            } else if (reduced[0])
              continue;
          }
          reduced.push(component);
        }
        return reduced;
      }
      ts2.reducePathComponents = reducePathComponents;
      function combinePaths(path2) {
        var paths = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          paths[_i - 1] = arguments[_i];
        }
        if (path2)
          path2 = normalizeSlashes(path2);
        for (var _a = 0, paths_1 = paths; _a < paths_1.length; _a++) {
          var relativePath = paths_1[_a];
          if (!relativePath)
            continue;
          relativePath = normalizeSlashes(relativePath);
          if (!path2 || getRootLength(relativePath) !== 0) {
            path2 = relativePath;
          } else {
            path2 = ensureTrailingDirectorySeparator(path2) + relativePath;
          }
        }
        return path2;
      }
      ts2.combinePaths = combinePaths;
      function resolvePath(path2) {
        var paths = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          paths[_i - 1] = arguments[_i];
        }
        return normalizePath(ts2.some(paths) ? combinePaths.apply(void 0, __spreadArrays([path2], paths)) : normalizeSlashes(path2));
      }
      ts2.resolvePath = resolvePath;
      function getNormalizedPathComponents(path2, currentDirectory) {
        return reducePathComponents(getPathComponents(path2, currentDirectory));
      }
      ts2.getNormalizedPathComponents = getNormalizedPathComponents;
      function getNormalizedAbsolutePath(fileName, currentDirectory) {
        return getPathFromPathComponents(getNormalizedPathComponents(fileName, currentDirectory));
      }
      ts2.getNormalizedAbsolutePath = getNormalizedAbsolutePath;
      function normalizePath(path2) {
        path2 = normalizeSlashes(path2);
        var normalized = getPathFromPathComponents(reducePathComponents(getPathComponents(path2)));
        return normalized && hasTrailingDirectorySeparator(path2) ? ensureTrailingDirectorySeparator(normalized) : normalized;
      }
      ts2.normalizePath = normalizePath;
      function getPathWithoutRoot(pathComponents2) {
        if (pathComponents2.length === 0)
          return "";
        return pathComponents2.slice(1).join(ts2.directorySeparator);
      }
      function getNormalizedAbsolutePathWithoutRoot(fileName, currentDirectory) {
        return getPathWithoutRoot(getNormalizedPathComponents(fileName, currentDirectory));
      }
      ts2.getNormalizedAbsolutePathWithoutRoot = getNormalizedAbsolutePathWithoutRoot;
      function toPath(fileName, basePath, getCanonicalFileName) {
        var nonCanonicalizedPath = isRootedDiskPath(fileName) ? normalizePath(fileName) : getNormalizedAbsolutePath(fileName, basePath);
        return getCanonicalFileName(nonCanonicalizedPath);
      }
      ts2.toPath = toPath;
      function normalizePathAndParts(path2) {
        path2 = normalizeSlashes(path2);
        var _a = reducePathComponents(getPathComponents(path2)), root = _a[0], parts = _a.slice(1);
        if (parts.length) {
          var joinedParts = root + parts.join(ts2.directorySeparator);
          return { path: hasTrailingDirectorySeparator(path2) ? ensureTrailingDirectorySeparator(joinedParts) : joinedParts, parts };
        } else {
          return { path: root, parts };
        }
      }
      ts2.normalizePathAndParts = normalizePathAndParts;
      function removeTrailingDirectorySeparator(path2) {
        if (hasTrailingDirectorySeparator(path2)) {
          return path2.substr(0, path2.length - 1);
        }
        return path2;
      }
      ts2.removeTrailingDirectorySeparator = removeTrailingDirectorySeparator;
      function ensureTrailingDirectorySeparator(path2) {
        if (!hasTrailingDirectorySeparator(path2)) {
          return path2 + ts2.directorySeparator;
        }
        return path2;
      }
      ts2.ensureTrailingDirectorySeparator = ensureTrailingDirectorySeparator;
      function ensurePathIsNonModuleName(path2) {
        return !pathIsAbsolute(path2) && !pathIsRelative(path2) ? "./" + path2 : path2;
      }
      ts2.ensurePathIsNonModuleName = ensurePathIsNonModuleName;
      function changeAnyExtension(path2, ext, extensions, ignoreCase) {
        var pathext = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(path2, extensions, ignoreCase) : getAnyExtensionFromPath(path2);
        return pathext ? path2.slice(0, path2.length - pathext.length) + (ts2.startsWith(ext, ".") ? ext : "." + ext) : path2;
      }
      ts2.changeAnyExtension = changeAnyExtension;
      var relativePathSegmentRegExp = /(^|\/)\.{0,2}($|\/)/;
      function comparePathsWorker(a, b, componentComparer) {
        if (a === b)
          return 0;
        if (a === void 0)
          return -1;
        if (b === void 0)
          return 1;
        var aRoot = a.substring(0, getRootLength(a));
        var bRoot = b.substring(0, getRootLength(b));
        var result = ts2.compareStringsCaseInsensitive(aRoot, bRoot);
        if (result !== 0) {
          return result;
        }
        var aRest = a.substring(aRoot.length);
        var bRest = b.substring(bRoot.length);
        if (!relativePathSegmentRegExp.test(aRest) && !relativePathSegmentRegExp.test(bRest)) {
          return componentComparer(aRest, bRest);
        }
        var aComponents = reducePathComponents(getPathComponents(a));
        var bComponents = reducePathComponents(getPathComponents(b));
        var sharedLength = Math.min(aComponents.length, bComponents.length);
        for (var i = 1; i < sharedLength; i++) {
          var result_1 = componentComparer(aComponents[i], bComponents[i]);
          if (result_1 !== 0) {
            return result_1;
          }
        }
        return ts2.compareValues(aComponents.length, bComponents.length);
      }
      function comparePathsCaseSensitive(a, b) {
        return comparePathsWorker(a, b, ts2.compareStringsCaseSensitive);
      }
      ts2.comparePathsCaseSensitive = comparePathsCaseSensitive;
      function comparePathsCaseInsensitive(a, b) {
        return comparePathsWorker(a, b, ts2.compareStringsCaseInsensitive);
      }
      ts2.comparePathsCaseInsensitive = comparePathsCaseInsensitive;
      function comparePaths(a, b, currentDirectory, ignoreCase) {
        if (typeof currentDirectory === "string") {
          a = combinePaths(currentDirectory, a);
          b = combinePaths(currentDirectory, b);
        } else if (typeof currentDirectory === "boolean") {
          ignoreCase = currentDirectory;
        }
        return comparePathsWorker(a, b, ts2.getStringComparer(ignoreCase));
      }
      ts2.comparePaths = comparePaths;
      function containsPath(parent, child, currentDirectory, ignoreCase) {
        if (typeof currentDirectory === "string") {
          parent = combinePaths(currentDirectory, parent);
          child = combinePaths(currentDirectory, child);
        } else if (typeof currentDirectory === "boolean") {
          ignoreCase = currentDirectory;
        }
        if (parent === void 0 || child === void 0)
          return false;
        if (parent === child)
          return true;
        var parentComponents = reducePathComponents(getPathComponents(parent));
        var childComponents = reducePathComponents(getPathComponents(child));
        if (childComponents.length < parentComponents.length) {
          return false;
        }
        var componentEqualityComparer = ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive;
        for (var i = 0; i < parentComponents.length; i++) {
          var equalityComparer = i === 0 ? ts2.equateStringsCaseInsensitive : componentEqualityComparer;
          if (!equalityComparer(parentComponents[i], childComponents[i])) {
            return false;
          }
        }
        return true;
      }
      ts2.containsPath = containsPath;
      function startsWithDirectory(fileName, directoryName, getCanonicalFileName) {
        var canonicalFileName = getCanonicalFileName(fileName);
        var canonicalDirectoryName = getCanonicalFileName(directoryName);
        return ts2.startsWith(canonicalFileName, canonicalDirectoryName + "/") || ts2.startsWith(canonicalFileName, canonicalDirectoryName + "\\");
      }
      ts2.startsWithDirectory = startsWithDirectory;
      function getPathComponentsRelativeTo(from, to, stringEqualityComparer, getCanonicalFileName) {
        var fromComponents = reducePathComponents(getPathComponents(from));
        var toComponents = reducePathComponents(getPathComponents(to));
        var start;
        for (start = 0; start < fromComponents.length && start < toComponents.length; start++) {
          var fromComponent = getCanonicalFileName(fromComponents[start]);
          var toComponent = getCanonicalFileName(toComponents[start]);
          var comparer = start === 0 ? ts2.equateStringsCaseInsensitive : stringEqualityComparer;
          if (!comparer(fromComponent, toComponent))
            break;
        }
        if (start === 0) {
          return toComponents;
        }
        var components = toComponents.slice(start);
        var relative = [];
        for (; start < fromComponents.length; start++) {
          relative.push("..");
        }
        return __spreadArrays([""], relative, components);
      }
      ts2.getPathComponentsRelativeTo = getPathComponentsRelativeTo;
      function getRelativePathFromDirectory(fromDirectory, to, getCanonicalFileNameOrIgnoreCase) {
        ts2.Debug.assert(getRootLength(fromDirectory) > 0 === getRootLength(to) > 0, "Paths must either both be absolute or both be relative");
        var getCanonicalFileName = typeof getCanonicalFileNameOrIgnoreCase === "function" ? getCanonicalFileNameOrIgnoreCase : ts2.identity;
        var ignoreCase = typeof getCanonicalFileNameOrIgnoreCase === "boolean" ? getCanonicalFileNameOrIgnoreCase : false;
        var pathComponents2 = getPathComponentsRelativeTo(fromDirectory, to, ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive, getCanonicalFileName);
        return getPathFromPathComponents(pathComponents2);
      }
      ts2.getRelativePathFromDirectory = getRelativePathFromDirectory;
      function convertToRelativePath(absoluteOrRelativePath, basePath, getCanonicalFileName) {
        return !isRootedDiskPath(absoluteOrRelativePath) ? absoluteOrRelativePath : getRelativePathToDirectoryOrUrl(basePath, absoluteOrRelativePath, basePath, getCanonicalFileName, false);
      }
      ts2.convertToRelativePath = convertToRelativePath;
      function getRelativePathFromFile(from, to, getCanonicalFileName) {
        return ensurePathIsNonModuleName(getRelativePathFromDirectory(getDirectoryPath(from), to, getCanonicalFileName));
      }
      ts2.getRelativePathFromFile = getRelativePathFromFile;
      function getRelativePathToDirectoryOrUrl(directoryPathOrUrl, relativeOrAbsolutePath, currentDirectory, getCanonicalFileName, isAbsolutePathAnUrl) {
        var pathComponents2 = getPathComponentsRelativeTo(resolvePath(currentDirectory, directoryPathOrUrl), resolvePath(currentDirectory, relativeOrAbsolutePath), ts2.equateStringsCaseSensitive, getCanonicalFileName);
        var firstComponent = pathComponents2[0];
        if (isAbsolutePathAnUrl && isRootedDiskPath(firstComponent)) {
          var prefix = firstComponent.charAt(0) === ts2.directorySeparator ? "file://" : "file:///";
          pathComponents2[0] = prefix + firstComponent;
        }
        return getPathFromPathComponents(pathComponents2);
      }
      ts2.getRelativePathToDirectoryOrUrl = getRelativePathToDirectoryOrUrl;
      function forEachAncestorDirectory(directory, callback) {
        while (true) {
          var result = callback(directory);
          if (result !== void 0) {
            return result;
          }
          var parentPath = getDirectoryPath(directory);
          if (parentPath === directory) {
            return void 0;
          }
          directory = parentPath;
        }
      }
      ts2.forEachAncestorDirectory = forEachAncestorDirectory;
      function isNodeModulesDirectory(dirPath) {
        return ts2.endsWith(dirPath, "/node_modules");
      }
      ts2.isNodeModulesDirectory = isNodeModulesDirectory;
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      function diag(code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid) {
        return { code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid };
      }
      ts2.Diagnostics = {
        Unterminated_string_literal: diag(1002, ts2.DiagnosticCategory.Error, "Unterminated_string_literal_1002", "Unterminated string literal."),
        Identifier_expected: diag(1003, ts2.DiagnosticCategory.Error, "Identifier_expected_1003", "Identifier expected."),
        _0_expected: diag(1005, ts2.DiagnosticCategory.Error, "_0_expected_1005", "'{0}' expected."),
        A_file_cannot_have_a_reference_to_itself: diag(1006, ts2.DiagnosticCategory.Error, "A_file_cannot_have_a_reference_to_itself_1006", "A file cannot have a reference to itself."),
        The_parser_expected_to_find_a_to_match_the_token_here: diag(1007, ts2.DiagnosticCategory.Error, "The_parser_expected_to_find_a_to_match_the_token_here_1007", "The parser expected to find a '}' to match the '{' token here."),
        Trailing_comma_not_allowed: diag(1009, ts2.DiagnosticCategory.Error, "Trailing_comma_not_allowed_1009", "Trailing comma not allowed."),
        Asterisk_Slash_expected: diag(1010, ts2.DiagnosticCategory.Error, "Asterisk_Slash_expected_1010", "'*/' expected."),
        An_element_access_expression_should_take_an_argument: diag(1011, ts2.DiagnosticCategory.Error, "An_element_access_expression_should_take_an_argument_1011", "An element access expression should take an argument."),
        Unexpected_token: diag(1012, ts2.DiagnosticCategory.Error, "Unexpected_token_1012", "Unexpected token."),
        A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma: diag(1013, ts2.DiagnosticCategory.Error, "A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma_1013", "A rest parameter or binding pattern may not have a trailing comma."),
        A_rest_parameter_must_be_last_in_a_parameter_list: diag(1014, ts2.DiagnosticCategory.Error, "A_rest_parameter_must_be_last_in_a_parameter_list_1014", "A rest parameter must be last in a parameter list."),
        Parameter_cannot_have_question_mark_and_initializer: diag(1015, ts2.DiagnosticCategory.Error, "Parameter_cannot_have_question_mark_and_initializer_1015", "Parameter cannot have question mark and initializer."),
        A_required_parameter_cannot_follow_an_optional_parameter: diag(1016, ts2.DiagnosticCategory.Error, "A_required_parameter_cannot_follow_an_optional_parameter_1016", "A required parameter cannot follow an optional parameter."),
        An_index_signature_cannot_have_a_rest_parameter: diag(1017, ts2.DiagnosticCategory.Error, "An_index_signature_cannot_have_a_rest_parameter_1017", "An index signature cannot have a rest parameter."),
        An_index_signature_parameter_cannot_have_an_accessibility_modifier: diag(1018, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_an_accessibility_modifier_1018", "An index signature parameter cannot have an accessibility modifier."),
        An_index_signature_parameter_cannot_have_a_question_mark: diag(1019, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_a_question_mark_1019", "An index signature parameter cannot have a question mark."),
        An_index_signature_parameter_cannot_have_an_initializer: diag(1020, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_an_initializer_1020", "An index signature parameter cannot have an initializer."),
        An_index_signature_must_have_a_type_annotation: diag(1021, ts2.DiagnosticCategory.Error, "An_index_signature_must_have_a_type_annotation_1021", "An index signature must have a type annotation."),
        An_index_signature_parameter_must_have_a_type_annotation: diag(1022, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_must_have_a_type_annotation_1022", "An index signature parameter must have a type annotation."),
        An_index_signature_parameter_type_must_be_either_string_or_number: diag(1023, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_type_must_be_either_string_or_number_1023", "An index signature parameter type must be either 'string' or 'number'."),
        readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature: diag(1024, ts2.DiagnosticCategory.Error, "readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature_1024", "'readonly' modifier can only appear on a property declaration or index signature."),
        An_index_signature_cannot_have_a_trailing_comma: diag(1025, ts2.DiagnosticCategory.Error, "An_index_signature_cannot_have_a_trailing_comma_1025", "An index signature cannot have a trailing comma."),
        Accessibility_modifier_already_seen: diag(1028, ts2.DiagnosticCategory.Error, "Accessibility_modifier_already_seen_1028", "Accessibility modifier already seen."),
        _0_modifier_must_precede_1_modifier: diag(1029, ts2.DiagnosticCategory.Error, "_0_modifier_must_precede_1_modifier_1029", "'{0}' modifier must precede '{1}' modifier."),
        _0_modifier_already_seen: diag(1030, ts2.DiagnosticCategory.Error, "_0_modifier_already_seen_1030", "'{0}' modifier already seen."),
        _0_modifier_cannot_appear_on_a_class_element: diag(1031, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_class_element_1031", "'{0}' modifier cannot appear on a class element."),
        super_must_be_followed_by_an_argument_list_or_member_access: diag(1034, ts2.DiagnosticCategory.Error, "super_must_be_followed_by_an_argument_list_or_member_access_1034", "'super' must be followed by an argument list or member access."),
        Only_ambient_modules_can_use_quoted_names: diag(1035, ts2.DiagnosticCategory.Error, "Only_ambient_modules_can_use_quoted_names_1035", "Only ambient modules can use quoted names."),
        Statements_are_not_allowed_in_ambient_contexts: diag(1036, ts2.DiagnosticCategory.Error, "Statements_are_not_allowed_in_ambient_contexts_1036", "Statements are not allowed in ambient contexts."),
        A_declare_modifier_cannot_be_used_in_an_already_ambient_context: diag(1038, ts2.DiagnosticCategory.Error, "A_declare_modifier_cannot_be_used_in_an_already_ambient_context_1038", "A 'declare' modifier cannot be used in an already ambient context."),
        Initializers_are_not_allowed_in_ambient_contexts: diag(1039, ts2.DiagnosticCategory.Error, "Initializers_are_not_allowed_in_ambient_contexts_1039", "Initializers are not allowed in ambient contexts."),
        _0_modifier_cannot_be_used_in_an_ambient_context: diag(1040, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_in_an_ambient_context_1040", "'{0}' modifier cannot be used in an ambient context."),
        _0_modifier_cannot_be_used_with_a_class_declaration: diag(1041, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_with_a_class_declaration_1041", "'{0}' modifier cannot be used with a class declaration."),
        _0_modifier_cannot_be_used_here: diag(1042, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_here_1042", "'{0}' modifier cannot be used here."),
        _0_modifier_cannot_appear_on_a_data_property: diag(1043, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_data_property_1043", "'{0}' modifier cannot appear on a data property."),
        _0_modifier_cannot_appear_on_a_module_or_namespace_element: diag(1044, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_module_or_namespace_element_1044", "'{0}' modifier cannot appear on a module or namespace element."),
        A_0_modifier_cannot_be_used_with_an_interface_declaration: diag(1045, ts2.DiagnosticCategory.Error, "A_0_modifier_cannot_be_used_with_an_interface_declaration_1045", "A '{0}' modifier cannot be used with an interface declaration."),
        Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier: diag(1046, ts2.DiagnosticCategory.Error, "Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier_1046", "Top-level declarations in .d.ts files must start with either a 'declare' or 'export' modifier."),
        A_rest_parameter_cannot_be_optional: diag(1047, ts2.DiagnosticCategory.Error, "A_rest_parameter_cannot_be_optional_1047", "A rest parameter cannot be optional."),
        A_rest_parameter_cannot_have_an_initializer: diag(1048, ts2.DiagnosticCategory.Error, "A_rest_parameter_cannot_have_an_initializer_1048", "A rest parameter cannot have an initializer."),
        A_set_accessor_must_have_exactly_one_parameter: diag(1049, ts2.DiagnosticCategory.Error, "A_set_accessor_must_have_exactly_one_parameter_1049", "A 'set' accessor must have exactly one parameter."),
        A_set_accessor_cannot_have_an_optional_parameter: diag(1051, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_an_optional_parameter_1051", "A 'set' accessor cannot have an optional parameter."),
        A_set_accessor_parameter_cannot_have_an_initializer: diag(1052, ts2.DiagnosticCategory.Error, "A_set_accessor_parameter_cannot_have_an_initializer_1052", "A 'set' accessor parameter cannot have an initializer."),
        A_set_accessor_cannot_have_rest_parameter: diag(1053, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_rest_parameter_1053", "A 'set' accessor cannot have rest parameter."),
        A_get_accessor_cannot_have_parameters: diag(1054, ts2.DiagnosticCategory.Error, "A_get_accessor_cannot_have_parameters_1054", "A 'get' accessor cannot have parameters."),
        Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value: diag(1055, ts2.DiagnosticCategory.Error, "Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Prom_1055", "Type '{0}' is not a valid async function return type in ES5/ES3 because it does not refer to a Promise-compatible constructor value."),
        Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher: diag(1056, ts2.DiagnosticCategory.Error, "Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher_1056", "Accessors are only available when targeting ECMAScript 5 and higher."),
        An_async_function_or_method_must_have_a_valid_awaitable_return_type: diag(1057, ts2.DiagnosticCategory.Error, "An_async_function_or_method_must_have_a_valid_awaitable_return_type_1057", "An async function or method must have a valid awaitable return type."),
        The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1058, ts2.DiagnosticCategory.Error, "The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_t_1058", "The return type of an async function must either be a valid promise or must not contain a callable 'then' member."),
        A_promise_must_have_a_then_method: diag(1059, ts2.DiagnosticCategory.Error, "A_promise_must_have_a_then_method_1059", "A promise must have a 'then' method."),
        The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback: diag(1060, ts2.DiagnosticCategory.Error, "The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback_1060", "The first parameter of the 'then' method of a promise must be a callback."),
        Enum_member_must_have_initializer: diag(1061, ts2.DiagnosticCategory.Error, "Enum_member_must_have_initializer_1061", "Enum member must have initializer."),
        Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method: diag(1062, ts2.DiagnosticCategory.Error, "Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method_1062", "Type is referenced directly or indirectly in the fulfillment callback of its own 'then' method."),
        An_export_assignment_cannot_be_used_in_a_namespace: diag(1063, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_be_used_in_a_namespace_1063", "An export assignment cannot be used in a namespace."),
        The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type: diag(1064, ts2.DiagnosticCategory.Error, "The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_1064", "The return type of an async function or method must be the global Promise<T> type."),
        In_ambient_enum_declarations_member_initializer_must_be_constant_expression: diag(1066, ts2.DiagnosticCategory.Error, "In_ambient_enum_declarations_member_initializer_must_be_constant_expression_1066", "In ambient enum declarations member initializer must be constant expression."),
        Unexpected_token_A_constructor_method_accessor_or_property_was_expected: diag(1068, ts2.DiagnosticCategory.Error, "Unexpected_token_A_constructor_method_accessor_or_property_was_expected_1068", "Unexpected token. A constructor, method, accessor, or property was expected."),
        Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces: diag(1069, ts2.DiagnosticCategory.Error, "Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces_1069", "Unexpected token. A type parameter name was expected without curly braces."),
        _0_modifier_cannot_appear_on_a_type_member: diag(1070, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_type_member_1070", "'{0}' modifier cannot appear on a type member."),
        _0_modifier_cannot_appear_on_an_index_signature: diag(1071, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_an_index_signature_1071", "'{0}' modifier cannot appear on an index signature."),
        A_0_modifier_cannot_be_used_with_an_import_declaration: diag(1079, ts2.DiagnosticCategory.Error, "A_0_modifier_cannot_be_used_with_an_import_declaration_1079", "A '{0}' modifier cannot be used with an import declaration."),
        Invalid_reference_directive_syntax: diag(1084, ts2.DiagnosticCategory.Error, "Invalid_reference_directive_syntax_1084", "Invalid 'reference' directive syntax."),
        Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0: diag(1085, ts2.DiagnosticCategory.Error, "Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0_1085", "Octal literals are not available when targeting ECMAScript 5 and higher. Use the syntax '{0}'."),
        _0_modifier_cannot_appear_on_a_constructor_declaration: diag(1089, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_constructor_declaration_1089", "'{0}' modifier cannot appear on a constructor declaration."),
        _0_modifier_cannot_appear_on_a_parameter: diag(1090, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_parameter_1090", "'{0}' modifier cannot appear on a parameter."),
        Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement: diag(1091, ts2.DiagnosticCategory.Error, "Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement_1091", "Only a single variable declaration is allowed in a 'for...in' statement."),
        Type_parameters_cannot_appear_on_a_constructor_declaration: diag(1092, ts2.DiagnosticCategory.Error, "Type_parameters_cannot_appear_on_a_constructor_declaration_1092", "Type parameters cannot appear on a constructor declaration."),
        Type_annotation_cannot_appear_on_a_constructor_declaration: diag(1093, ts2.DiagnosticCategory.Error, "Type_annotation_cannot_appear_on_a_constructor_declaration_1093", "Type annotation cannot appear on a constructor declaration."),
        An_accessor_cannot_have_type_parameters: diag(1094, ts2.DiagnosticCategory.Error, "An_accessor_cannot_have_type_parameters_1094", "An accessor cannot have type parameters."),
        A_set_accessor_cannot_have_a_return_type_annotation: diag(1095, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_a_return_type_annotation_1095", "A 'set' accessor cannot have a return type annotation."),
        An_index_signature_must_have_exactly_one_parameter: diag(1096, ts2.DiagnosticCategory.Error, "An_index_signature_must_have_exactly_one_parameter_1096", "An index signature must have exactly one parameter."),
        _0_list_cannot_be_empty: diag(1097, ts2.DiagnosticCategory.Error, "_0_list_cannot_be_empty_1097", "'{0}' list cannot be empty."),
        Type_parameter_list_cannot_be_empty: diag(1098, ts2.DiagnosticCategory.Error, "Type_parameter_list_cannot_be_empty_1098", "Type parameter list cannot be empty."),
        Type_argument_list_cannot_be_empty: diag(1099, ts2.DiagnosticCategory.Error, "Type_argument_list_cannot_be_empty_1099", "Type argument list cannot be empty."),
        Invalid_use_of_0_in_strict_mode: diag(1100, ts2.DiagnosticCategory.Error, "Invalid_use_of_0_in_strict_mode_1100", "Invalid use of '{0}' in strict mode."),
        with_statements_are_not_allowed_in_strict_mode: diag(1101, ts2.DiagnosticCategory.Error, "with_statements_are_not_allowed_in_strict_mode_1101", "'with' statements are not allowed in strict mode."),
        delete_cannot_be_called_on_an_identifier_in_strict_mode: diag(1102, ts2.DiagnosticCategory.Error, "delete_cannot_be_called_on_an_identifier_in_strict_mode_1102", "'delete' cannot be called on an identifier in strict mode."),
        A_for_await_of_statement_is_only_allowed_within_an_async_function_or_async_generator: diag(1103, ts2.DiagnosticCategory.Error, "A_for_await_of_statement_is_only_allowed_within_an_async_function_or_async_generator_1103", "A 'for-await-of' statement is only allowed within an async function or async generator."),
        A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement: diag(1104, ts2.DiagnosticCategory.Error, "A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement_1104", "A 'continue' statement can only be used within an enclosing iteration statement."),
        A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement: diag(1105, ts2.DiagnosticCategory.Error, "A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement_1105", "A 'break' statement can only be used within an enclosing iteration or switch statement."),
        Jump_target_cannot_cross_function_boundary: diag(1107, ts2.DiagnosticCategory.Error, "Jump_target_cannot_cross_function_boundary_1107", "Jump target cannot cross function boundary."),
        A_return_statement_can_only_be_used_within_a_function_body: diag(1108, ts2.DiagnosticCategory.Error, "A_return_statement_can_only_be_used_within_a_function_body_1108", "A 'return' statement can only be used within a function body."),
        Expression_expected: diag(1109, ts2.DiagnosticCategory.Error, "Expression_expected_1109", "Expression expected."),
        Type_expected: diag(1110, ts2.DiagnosticCategory.Error, "Type_expected_1110", "Type expected."),
        A_default_clause_cannot_appear_more_than_once_in_a_switch_statement: diag(1113, ts2.DiagnosticCategory.Error, "A_default_clause_cannot_appear_more_than_once_in_a_switch_statement_1113", "A 'default' clause cannot appear more than once in a 'switch' statement."),
        Duplicate_label_0: diag(1114, ts2.DiagnosticCategory.Error, "Duplicate_label_0_1114", "Duplicate label '{0}'."),
        A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement: diag(1115, ts2.DiagnosticCategory.Error, "A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement_1115", "A 'continue' statement can only jump to a label of an enclosing iteration statement."),
        A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement: diag(1116, ts2.DiagnosticCategory.Error, "A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement_1116", "A 'break' statement can only jump to a label of an enclosing statement."),
        An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode: diag(1117, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode_1117", "An object literal cannot have multiple properties with the same name in strict mode."),
        An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name: diag(1118, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name_1118", "An object literal cannot have multiple get/set accessors with the same name."),
        An_object_literal_cannot_have_property_and_accessor_with_the_same_name: diag(1119, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_property_and_accessor_with_the_same_name_1119", "An object literal cannot have property and accessor with the same name."),
        An_export_assignment_cannot_have_modifiers: diag(1120, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_have_modifiers_1120", "An export assignment cannot have modifiers."),
        Octal_literals_are_not_allowed_in_strict_mode: diag(1121, ts2.DiagnosticCategory.Error, "Octal_literals_are_not_allowed_in_strict_mode_1121", "Octal literals are not allowed in strict mode."),
        Variable_declaration_list_cannot_be_empty: diag(1123, ts2.DiagnosticCategory.Error, "Variable_declaration_list_cannot_be_empty_1123", "Variable declaration list cannot be empty."),
        Digit_expected: diag(1124, ts2.DiagnosticCategory.Error, "Digit_expected_1124", "Digit expected."),
        Hexadecimal_digit_expected: diag(1125, ts2.DiagnosticCategory.Error, "Hexadecimal_digit_expected_1125", "Hexadecimal digit expected."),
        Unexpected_end_of_text: diag(1126, ts2.DiagnosticCategory.Error, "Unexpected_end_of_text_1126", "Unexpected end of text."),
        Invalid_character: diag(1127, ts2.DiagnosticCategory.Error, "Invalid_character_1127", "Invalid character."),
        Declaration_or_statement_expected: diag(1128, ts2.DiagnosticCategory.Error, "Declaration_or_statement_expected_1128", "Declaration or statement expected."),
        Statement_expected: diag(1129, ts2.DiagnosticCategory.Error, "Statement_expected_1129", "Statement expected."),
        case_or_default_expected: diag(1130, ts2.DiagnosticCategory.Error, "case_or_default_expected_1130", "'case' or 'default' expected."),
        Property_or_signature_expected: diag(1131, ts2.DiagnosticCategory.Error, "Property_or_signature_expected_1131", "Property or signature expected."),
        Enum_member_expected: diag(1132, ts2.DiagnosticCategory.Error, "Enum_member_expected_1132", "Enum member expected."),
        Variable_declaration_expected: diag(1134, ts2.DiagnosticCategory.Error, "Variable_declaration_expected_1134", "Variable declaration expected."),
        Argument_expression_expected: diag(1135, ts2.DiagnosticCategory.Error, "Argument_expression_expected_1135", "Argument expression expected."),
        Property_assignment_expected: diag(1136, ts2.DiagnosticCategory.Error, "Property_assignment_expected_1136", "Property assignment expected."),
        Expression_or_comma_expected: diag(1137, ts2.DiagnosticCategory.Error, "Expression_or_comma_expected_1137", "Expression or comma expected."),
        Parameter_declaration_expected: diag(1138, ts2.DiagnosticCategory.Error, "Parameter_declaration_expected_1138", "Parameter declaration expected."),
        Type_parameter_declaration_expected: diag(1139, ts2.DiagnosticCategory.Error, "Type_parameter_declaration_expected_1139", "Type parameter declaration expected."),
        Type_argument_expected: diag(1140, ts2.DiagnosticCategory.Error, "Type_argument_expected_1140", "Type argument expected."),
        String_literal_expected: diag(1141, ts2.DiagnosticCategory.Error, "String_literal_expected_1141", "String literal expected."),
        Line_break_not_permitted_here: diag(1142, ts2.DiagnosticCategory.Error, "Line_break_not_permitted_here_1142", "Line break not permitted here."),
        or_expected: diag(1144, ts2.DiagnosticCategory.Error, "or_expected_1144", "'{' or ';' expected."),
        Declaration_expected: diag(1146, ts2.DiagnosticCategory.Error, "Declaration_expected_1146", "Declaration expected."),
        Import_declarations_in_a_namespace_cannot_reference_a_module: diag(1147, ts2.DiagnosticCategory.Error, "Import_declarations_in_a_namespace_cannot_reference_a_module_1147", "Import declarations in a namespace cannot reference a module."),
        Cannot_use_imports_exports_or_module_augmentations_when_module_is_none: diag(1148, ts2.DiagnosticCategory.Error, "Cannot_use_imports_exports_or_module_augmentations_when_module_is_none_1148", "Cannot use imports, exports, or module augmentations when '--module' is 'none'."),
        File_name_0_differs_from_already_included_file_name_1_only_in_casing: diag(1149, ts2.DiagnosticCategory.Error, "File_name_0_differs_from_already_included_file_name_1_only_in_casing_1149", "File name '{0}' differs from already included file name '{1}' only in casing."),
        const_declarations_must_be_initialized: diag(1155, ts2.DiagnosticCategory.Error, "const_declarations_must_be_initialized_1155", "'const' declarations must be initialized."),
        const_declarations_can_only_be_declared_inside_a_block: diag(1156, ts2.DiagnosticCategory.Error, "const_declarations_can_only_be_declared_inside_a_block_1156", "'const' declarations can only be declared inside a block."),
        let_declarations_can_only_be_declared_inside_a_block: diag(1157, ts2.DiagnosticCategory.Error, "let_declarations_can_only_be_declared_inside_a_block_1157", "'let' declarations can only be declared inside a block."),
        Unterminated_template_literal: diag(1160, ts2.DiagnosticCategory.Error, "Unterminated_template_literal_1160", "Unterminated template literal."),
        Unterminated_regular_expression_literal: diag(1161, ts2.DiagnosticCategory.Error, "Unterminated_regular_expression_literal_1161", "Unterminated regular expression literal."),
        An_object_member_cannot_be_declared_optional: diag(1162, ts2.DiagnosticCategory.Error, "An_object_member_cannot_be_declared_optional_1162", "An object member cannot be declared optional."),
        A_yield_expression_is_only_allowed_in_a_generator_body: diag(1163, ts2.DiagnosticCategory.Error, "A_yield_expression_is_only_allowed_in_a_generator_body_1163", "A 'yield' expression is only allowed in a generator body."),
        Computed_property_names_are_not_allowed_in_enums: diag(1164, ts2.DiagnosticCategory.Error, "Computed_property_names_are_not_allowed_in_enums_1164", "Computed property names are not allowed in enums."),
        A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1165, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_t_1165", "A computed property name in an ambient context must refer to an expression whose type is a literal type or a 'unique symbol' type."),
        A_computed_property_name_in_a_class_property_declaration_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1166, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_class_property_declaration_must_refer_to_an_expression_whose_type_is_a_1166", "A computed property name in a class property declaration must refer to an expression whose type is a literal type or a 'unique symbol' type."),
        A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1168, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_ty_1168", "A computed property name in a method overload must refer to an expression whose type is a literal type or a 'unique symbol' type."),
        A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1169, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_1169", "A computed property name in an interface must refer to an expression whose type is a literal type or a 'unique symbol' type."),
        A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1170, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type__1170", "A computed property name in a type literal must refer to an expression whose type is a literal type or a 'unique symbol' type."),
        A_comma_expression_is_not_allowed_in_a_computed_property_name: diag(1171, ts2.DiagnosticCategory.Error, "A_comma_expression_is_not_allowed_in_a_computed_property_name_1171", "A comma expression is not allowed in a computed property name."),
        extends_clause_already_seen: diag(1172, ts2.DiagnosticCategory.Error, "extends_clause_already_seen_1172", "'extends' clause already seen."),
        extends_clause_must_precede_implements_clause: diag(1173, ts2.DiagnosticCategory.Error, "extends_clause_must_precede_implements_clause_1173", "'extends' clause must precede 'implements' clause."),
        Classes_can_only_extend_a_single_class: diag(1174, ts2.DiagnosticCategory.Error, "Classes_can_only_extend_a_single_class_1174", "Classes can only extend a single class."),
        implements_clause_already_seen: diag(1175, ts2.DiagnosticCategory.Error, "implements_clause_already_seen_1175", "'implements' clause already seen."),
        Interface_declaration_cannot_have_implements_clause: diag(1176, ts2.DiagnosticCategory.Error, "Interface_declaration_cannot_have_implements_clause_1176", "Interface declaration cannot have 'implements' clause."),
        Binary_digit_expected: diag(1177, ts2.DiagnosticCategory.Error, "Binary_digit_expected_1177", "Binary digit expected."),
        Octal_digit_expected: diag(1178, ts2.DiagnosticCategory.Error, "Octal_digit_expected_1178", "Octal digit expected."),
        Unexpected_token_expected: diag(1179, ts2.DiagnosticCategory.Error, "Unexpected_token_expected_1179", "Unexpected token. '{' expected."),
        Property_destructuring_pattern_expected: diag(1180, ts2.DiagnosticCategory.Error, "Property_destructuring_pattern_expected_1180", "Property destructuring pattern expected."),
        Array_element_destructuring_pattern_expected: diag(1181, ts2.DiagnosticCategory.Error, "Array_element_destructuring_pattern_expected_1181", "Array element destructuring pattern expected."),
        A_destructuring_declaration_must_have_an_initializer: diag(1182, ts2.DiagnosticCategory.Error, "A_destructuring_declaration_must_have_an_initializer_1182", "A destructuring declaration must have an initializer."),
        An_implementation_cannot_be_declared_in_ambient_contexts: diag(1183, ts2.DiagnosticCategory.Error, "An_implementation_cannot_be_declared_in_ambient_contexts_1183", "An implementation cannot be declared in ambient contexts."),
        Modifiers_cannot_appear_here: diag(1184, ts2.DiagnosticCategory.Error, "Modifiers_cannot_appear_here_1184", "Modifiers cannot appear here."),
        Merge_conflict_marker_encountered: diag(1185, ts2.DiagnosticCategory.Error, "Merge_conflict_marker_encountered_1185", "Merge conflict marker encountered."),
        A_rest_element_cannot_have_an_initializer: diag(1186, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_have_an_initializer_1186", "A rest element cannot have an initializer."),
        A_parameter_property_may_not_be_declared_using_a_binding_pattern: diag(1187, ts2.DiagnosticCategory.Error, "A_parameter_property_may_not_be_declared_using_a_binding_pattern_1187", "A parameter property may not be declared using a binding pattern."),
        Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement: diag(1188, ts2.DiagnosticCategory.Error, "Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement_1188", "Only a single variable declaration is allowed in a 'for...of' statement."),
        The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer: diag(1189, ts2.DiagnosticCategory.Error, "The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer_1189", "The variable declaration of a 'for...in' statement cannot have an initializer."),
        The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer: diag(1190, ts2.DiagnosticCategory.Error, "The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer_1190", "The variable declaration of a 'for...of' statement cannot have an initializer."),
        An_import_declaration_cannot_have_modifiers: diag(1191, ts2.DiagnosticCategory.Error, "An_import_declaration_cannot_have_modifiers_1191", "An import declaration cannot have modifiers."),
        Module_0_has_no_default_export: diag(1192, ts2.DiagnosticCategory.Error, "Module_0_has_no_default_export_1192", "Module '{0}' has no default export."),
        An_export_declaration_cannot_have_modifiers: diag(1193, ts2.DiagnosticCategory.Error, "An_export_declaration_cannot_have_modifiers_1193", "An export declaration cannot have modifiers."),
        Export_declarations_are_not_permitted_in_a_namespace: diag(1194, ts2.DiagnosticCategory.Error, "Export_declarations_are_not_permitted_in_a_namespace_1194", "Export declarations are not permitted in a namespace."),
        export_Asterisk_does_not_re_export_a_default: diag(1195, ts2.DiagnosticCategory.Error, "export_Asterisk_does_not_re_export_a_default_1195", "'export *' does not re-export a default."),
        Catch_clause_variable_cannot_have_a_type_annotation: diag(1196, ts2.DiagnosticCategory.Error, "Catch_clause_variable_cannot_have_a_type_annotation_1196", "Catch clause variable cannot have a type annotation."),
        Catch_clause_variable_cannot_have_an_initializer: diag(1197, ts2.DiagnosticCategory.Error, "Catch_clause_variable_cannot_have_an_initializer_1197", "Catch clause variable cannot have an initializer."),
        An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive: diag(1198, ts2.DiagnosticCategory.Error, "An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive_1198", "An extended Unicode escape value must be between 0x0 and 0x10FFFF inclusive."),
        Unterminated_Unicode_escape_sequence: diag(1199, ts2.DiagnosticCategory.Error, "Unterminated_Unicode_escape_sequence_1199", "Unterminated Unicode escape sequence."),
        Line_terminator_not_permitted_before_arrow: diag(1200, ts2.DiagnosticCategory.Error, "Line_terminator_not_permitted_before_arrow_1200", "Line terminator not permitted before arrow."),
        Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_import_d_from_mod_or_another_module_format_instead: diag(1202, ts2.DiagnosticCategory.Error, "Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_1202", `Import assignment cannot be used when targeting ECMAScript modules. Consider using 'import * as ns from "mod"', 'import {a} from "mod"', 'import d from "mod"', or another module format instead.`),
        Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or_another_module_format_instead: diag(1203, ts2.DiagnosticCategory.Error, "Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or__1203", "Export assignment cannot be used when targeting ECMAScript modules. Consider using 'export default' or another module format instead."),
        Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type: diag(1205, ts2.DiagnosticCategory.Error, "Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type_1205", "Re-exporting a type when the '--isolatedModules' flag is provided requires using 'export type'."),
        Decorators_are_not_valid_here: diag(1206, ts2.DiagnosticCategory.Error, "Decorators_are_not_valid_here_1206", "Decorators are not valid here."),
        Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name: diag(1207, ts2.DiagnosticCategory.Error, "Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name_1207", "Decorators cannot be applied to multiple get/set accessors of the same name."),
        All_files_must_be_modules_when_the_isolatedModules_flag_is_provided: diag(1208, ts2.DiagnosticCategory.Error, "All_files_must_be_modules_when_the_isolatedModules_flag_is_provided_1208", "All files must be modules when the '--isolatedModules' flag is provided."),
        Invalid_use_of_0_Class_definitions_are_automatically_in_strict_mode: diag(1210, ts2.DiagnosticCategory.Error, "Invalid_use_of_0_Class_definitions_are_automatically_in_strict_mode_1210", "Invalid use of '{0}'. Class definitions are automatically in strict mode."),
        A_class_declaration_without_the_default_modifier_must_have_a_name: diag(1211, ts2.DiagnosticCategory.Error, "A_class_declaration_without_the_default_modifier_must_have_a_name_1211", "A class declaration without the 'default' modifier must have a name."),
        Identifier_expected_0_is_a_reserved_word_in_strict_mode: diag(1212, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_1212", "Identifier expected. '{0}' is a reserved word in strict mode."),
        Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode: diag(1213, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_stric_1213", "Identifier expected. '{0}' is a reserved word in strict mode. Class definitions are automatically in strict mode."),
        Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode: diag(1214, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode_1214", "Identifier expected. '{0}' is a reserved word in strict mode. Modules are automatically in strict mode."),
        Invalid_use_of_0_Modules_are_automatically_in_strict_mode: diag(1215, ts2.DiagnosticCategory.Error, "Invalid_use_of_0_Modules_are_automatically_in_strict_mode_1215", "Invalid use of '{0}'. Modules are automatically in strict mode."),
        Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules: diag(1216, ts2.DiagnosticCategory.Error, "Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules_1216", "Identifier expected. '__esModule' is reserved as an exported marker when transforming ECMAScript modules."),
        Export_assignment_is_not_supported_when_module_flag_is_system: diag(1218, ts2.DiagnosticCategory.Error, "Export_assignment_is_not_supported_when_module_flag_is_system_1218", "Export assignment is not supported when '--module' flag is 'system'."),
        Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_the_experimentalDecorators_option_in_your_tsconfig_or_jsconfig_to_remove_this_warning: diag(1219, ts2.DiagnosticCategory.Error, "Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_t_1219", "Experimental support for decorators is a feature that is subject to change in a future release. Set the 'experimentalDecorators' option in your 'tsconfig' or 'jsconfig' to remove this warning."),
        Generators_are_only_available_when_targeting_ECMAScript_2015_or_higher: diag(1220, ts2.DiagnosticCategory.Error, "Generators_are_only_available_when_targeting_ECMAScript_2015_or_higher_1220", "Generators are only available when targeting ECMAScript 2015 or higher."),
        Generators_are_not_allowed_in_an_ambient_context: diag(1221, ts2.DiagnosticCategory.Error, "Generators_are_not_allowed_in_an_ambient_context_1221", "Generators are not allowed in an ambient context."),
        An_overload_signature_cannot_be_declared_as_a_generator: diag(1222, ts2.DiagnosticCategory.Error, "An_overload_signature_cannot_be_declared_as_a_generator_1222", "An overload signature cannot be declared as a generator."),
        _0_tag_already_specified: diag(1223, ts2.DiagnosticCategory.Error, "_0_tag_already_specified_1223", "'{0}' tag already specified."),
        Signature_0_must_be_a_type_predicate: diag(1224, ts2.DiagnosticCategory.Error, "Signature_0_must_be_a_type_predicate_1224", "Signature '{0}' must be a type predicate."),
        Cannot_find_parameter_0: diag(1225, ts2.DiagnosticCategory.Error, "Cannot_find_parameter_0_1225", "Cannot find parameter '{0}'."),
        Type_predicate_0_is_not_assignable_to_1: diag(1226, ts2.DiagnosticCategory.Error, "Type_predicate_0_is_not_assignable_to_1_1226", "Type predicate '{0}' is not assignable to '{1}'."),
        Parameter_0_is_not_in_the_same_position_as_parameter_1: diag(1227, ts2.DiagnosticCategory.Error, "Parameter_0_is_not_in_the_same_position_as_parameter_1_1227", "Parameter '{0}' is not in the same position as parameter '{1}'."),
        A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods: diag(1228, ts2.DiagnosticCategory.Error, "A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods_1228", "A type predicate is only allowed in return type position for functions and methods."),
        A_type_predicate_cannot_reference_a_rest_parameter: diag(1229, ts2.DiagnosticCategory.Error, "A_type_predicate_cannot_reference_a_rest_parameter_1229", "A type predicate cannot reference a rest parameter."),
        A_type_predicate_cannot_reference_element_0_in_a_binding_pattern: diag(1230, ts2.DiagnosticCategory.Error, "A_type_predicate_cannot_reference_element_0_in_a_binding_pattern_1230", "A type predicate cannot reference element '{0}' in a binding pattern."),
        An_export_assignment_can_only_be_used_in_a_module: diag(1231, ts2.DiagnosticCategory.Error, "An_export_assignment_can_only_be_used_in_a_module_1231", "An export assignment can only be used in a module."),
        An_import_declaration_can_only_be_used_in_a_namespace_or_module: diag(1232, ts2.DiagnosticCategory.Error, "An_import_declaration_can_only_be_used_in_a_namespace_or_module_1232", "An import declaration can only be used in a namespace or module."),
        An_export_declaration_can_only_be_used_in_a_module: diag(1233, ts2.DiagnosticCategory.Error, "An_export_declaration_can_only_be_used_in_a_module_1233", "An export declaration can only be used in a module."),
        An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file: diag(1234, ts2.DiagnosticCategory.Error, "An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file_1234", "An ambient module declaration is only allowed at the top level in a file."),
        A_namespace_declaration_is_only_allowed_in_a_namespace_or_module: diag(1235, ts2.DiagnosticCategory.Error, "A_namespace_declaration_is_only_allowed_in_a_namespace_or_module_1235", "A namespace declaration is only allowed in a namespace or module."),
        The_return_type_of_a_property_decorator_function_must_be_either_void_or_any: diag(1236, ts2.DiagnosticCategory.Error, "The_return_type_of_a_property_decorator_function_must_be_either_void_or_any_1236", "The return type of a property decorator function must be either 'void' or 'any'."),
        The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any: diag(1237, ts2.DiagnosticCategory.Error, "The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any_1237", "The return type of a parameter decorator function must be either 'void' or 'any'."),
        Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression: diag(1238, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression_1238", "Unable to resolve signature of class decorator when called as an expression."),
        Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression: diag(1239, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression_1239", "Unable to resolve signature of parameter decorator when called as an expression."),
        Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression: diag(1240, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression_1240", "Unable to resolve signature of property decorator when called as an expression."),
        Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression: diag(1241, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression_1241", "Unable to resolve signature of method decorator when called as an expression."),
        abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration: diag(1242, ts2.DiagnosticCategory.Error, "abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration_1242", "'abstract' modifier can only appear on a class, method, or property declaration."),
        _0_modifier_cannot_be_used_with_1_modifier: diag(1243, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_with_1_modifier_1243", "'{0}' modifier cannot be used with '{1}' modifier."),
        Abstract_methods_can_only_appear_within_an_abstract_class: diag(1244, ts2.DiagnosticCategory.Error, "Abstract_methods_can_only_appear_within_an_abstract_class_1244", "Abstract methods can only appear within an abstract class."),
        Method_0_cannot_have_an_implementation_because_it_is_marked_abstract: diag(1245, ts2.DiagnosticCategory.Error, "Method_0_cannot_have_an_implementation_because_it_is_marked_abstract_1245", "Method '{0}' cannot have an implementation because it is marked abstract."),
        An_interface_property_cannot_have_an_initializer: diag(1246, ts2.DiagnosticCategory.Error, "An_interface_property_cannot_have_an_initializer_1246", "An interface property cannot have an initializer."),
        A_type_literal_property_cannot_have_an_initializer: diag(1247, ts2.DiagnosticCategory.Error, "A_type_literal_property_cannot_have_an_initializer_1247", "A type literal property cannot have an initializer."),
        A_class_member_cannot_have_the_0_keyword: diag(1248, ts2.DiagnosticCategory.Error, "A_class_member_cannot_have_the_0_keyword_1248", "A class member cannot have the '{0}' keyword."),
        A_decorator_can_only_decorate_a_method_implementation_not_an_overload: diag(1249, ts2.DiagnosticCategory.Error, "A_decorator_can_only_decorate_a_method_implementation_not_an_overload_1249", "A decorator can only decorate a method implementation, not an overload."),
        Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5: diag(1250, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_1250", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'."),
        Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_definitions_are_automatically_in_strict_mode: diag(1251, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_d_1251", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Class definitions are automatically in strict mode."),
        Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_are_automatically_in_strict_mode: diag(1252, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_1252", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Modules are automatically in strict mode."),
        _0_tag_cannot_be_used_independently_as_a_top_level_JSDoc_tag: diag(1253, ts2.DiagnosticCategory.Error, "_0_tag_cannot_be_used_independently_as_a_top_level_JSDoc_tag_1253", "'{0}' tag cannot be used independently as a top level JSDoc tag."),
        A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_reference: diag(1254, ts2.DiagnosticCategory.Error, "A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_refere_1254", "A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference."),
        A_definite_assignment_assertion_is_not_permitted_in_this_context: diag(1255, ts2.DiagnosticCategory.Error, "A_definite_assignment_assertion_is_not_permitted_in_this_context_1255", "A definite assignment assertion '!' is not permitted in this context."),
        A_rest_element_must_be_last_in_a_tuple_type: diag(1256, ts2.DiagnosticCategory.Error, "A_rest_element_must_be_last_in_a_tuple_type_1256", "A rest element must be last in a tuple type."),
        A_required_element_cannot_follow_an_optional_element: diag(1257, ts2.DiagnosticCategory.Error, "A_required_element_cannot_follow_an_optional_element_1257", "A required element cannot follow an optional element."),
        Definite_assignment_assertions_can_only_be_used_along_with_a_type_annotation: diag(1258, ts2.DiagnosticCategory.Error, "Definite_assignment_assertions_can_only_be_used_along_with_a_type_annotation_1258", "Definite assignment assertions can only be used along with a type annotation."),
        Module_0_can_only_be_default_imported_using_the_1_flag: diag(1259, ts2.DiagnosticCategory.Error, "Module_0_can_only_be_default_imported_using_the_1_flag_1259", "Module '{0}' can only be default-imported using the '{1}' flag"),
        Keywords_cannot_contain_escape_characters: diag(1260, ts2.DiagnosticCategory.Error, "Keywords_cannot_contain_escape_characters_1260", "Keywords cannot contain escape characters."),
        Already_included_file_name_0_differs_from_file_name_1_only_in_casing: diag(1261, ts2.DiagnosticCategory.Error, "Already_included_file_name_0_differs_from_file_name_1_only_in_casing_1261", "Already included file name '{0}' differs from file name '{1}' only in casing."),
        with_statements_are_not_allowed_in_an_async_function_block: diag(1300, ts2.DiagnosticCategory.Error, "with_statements_are_not_allowed_in_an_async_function_block_1300", "'with' statements are not allowed in an async function block."),
        await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(1308, ts2.DiagnosticCategory.Error, "await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1308", "'await' expressions are only allowed within async functions and at the top levels of modules."),
        can_only_be_used_in_an_object_literal_property_inside_a_destructuring_assignment: diag(1312, ts2.DiagnosticCategory.Error, "can_only_be_used_in_an_object_literal_property_inside_a_destructuring_assignment_1312", "'=' can only be used in an object literal property inside a destructuring assignment."),
        The_body_of_an_if_statement_cannot_be_the_empty_statement: diag(1313, ts2.DiagnosticCategory.Error, "The_body_of_an_if_statement_cannot_be_the_empty_statement_1313", "The body of an 'if' statement cannot be the empty statement."),
        Global_module_exports_may_only_appear_in_module_files: diag(1314, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_in_module_files_1314", "Global module exports may only appear in module files."),
        Global_module_exports_may_only_appear_in_declaration_files: diag(1315, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_in_declaration_files_1315", "Global module exports may only appear in declaration files."),
        Global_module_exports_may_only_appear_at_top_level: diag(1316, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_at_top_level_1316", "Global module exports may only appear at top level."),
        A_parameter_property_cannot_be_declared_using_a_rest_parameter: diag(1317, ts2.DiagnosticCategory.Error, "A_parameter_property_cannot_be_declared_using_a_rest_parameter_1317", "A parameter property cannot be declared using a rest parameter."),
        An_abstract_accessor_cannot_have_an_implementation: diag(1318, ts2.DiagnosticCategory.Error, "An_abstract_accessor_cannot_have_an_implementation_1318", "An abstract accessor cannot have an implementation."),
        A_default_export_can_only_be_used_in_an_ECMAScript_style_module: diag(1319, ts2.DiagnosticCategory.Error, "A_default_export_can_only_be_used_in_an_ECMAScript_style_module_1319", "A default export can only be used in an ECMAScript-style module."),
        Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1320, ts2.DiagnosticCategory.Error, "Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member_1320", "Type of 'await' operand must either be a valid promise or must not contain a callable 'then' member."),
        Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1321, ts2.DiagnosticCategory.Error, "Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_cal_1321", "Type of 'yield' operand in an async generator must either be a valid promise or must not contain a callable 'then' member."),
        Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1322, ts2.DiagnosticCategory.Error, "Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_con_1322", "Type of iterated elements of a 'yield*' operand must either be a valid promise or must not contain a callable 'then' member."),
        Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_esnext_commonjs_amd_system_or_umd: diag(1323, ts2.DiagnosticCategory.Error, "Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_esnext_commonjs_amd_system__1323", "Dynamic imports are only supported when the '--module' flag is set to 'es2020', 'esnext', 'commonjs', 'amd', 'system', or 'umd'."),
        Dynamic_import_must_have_one_specifier_as_an_argument: diag(1324, ts2.DiagnosticCategory.Error, "Dynamic_import_must_have_one_specifier_as_an_argument_1324", "Dynamic import must have one specifier as an argument."),
        Specifier_of_dynamic_import_cannot_be_spread_element: diag(1325, ts2.DiagnosticCategory.Error, "Specifier_of_dynamic_import_cannot_be_spread_element_1325", "Specifier of dynamic import cannot be spread element."),
        Dynamic_import_cannot_have_type_arguments: diag(1326, ts2.DiagnosticCategory.Error, "Dynamic_import_cannot_have_type_arguments_1326", "Dynamic import cannot have type arguments"),
        String_literal_with_double_quotes_expected: diag(1327, ts2.DiagnosticCategory.Error, "String_literal_with_double_quotes_expected_1327", "String literal with double quotes expected."),
        Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_literal: diag(1328, ts2.DiagnosticCategory.Error, "Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_li_1328", "Property value can only be string literal, numeric literal, 'true', 'false', 'null', object literal or array literal."),
        _0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write_0: diag(1329, ts2.DiagnosticCategory.Error, "_0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write__1329", "'{0}' accepts too few arguments to be used as a decorator here. Did you mean to call it first and write '@{0}()'?"),
        A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly: diag(1330, ts2.DiagnosticCategory.Error, "A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly_1330", "A property of an interface or type literal whose type is a 'unique symbol' type must be 'readonly'."),
        A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly: diag(1331, ts2.DiagnosticCategory.Error, "A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly_1331", "A property of a class whose type is a 'unique symbol' type must be both 'static' and 'readonly'."),
        A_variable_whose_type_is_a_unique_symbol_type_must_be_const: diag(1332, ts2.DiagnosticCategory.Error, "A_variable_whose_type_is_a_unique_symbol_type_must_be_const_1332", "A variable whose type is a 'unique symbol' type must be 'const'."),
        unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name: diag(1333, ts2.DiagnosticCategory.Error, "unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name_1333", "'unique symbol' types may not be used on a variable declaration with a binding name."),
        unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement: diag(1334, ts2.DiagnosticCategory.Error, "unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement_1334", "'unique symbol' types are only allowed on variables in a variable statement."),
        unique_symbol_types_are_not_allowed_here: diag(1335, ts2.DiagnosticCategory.Error, "unique_symbol_types_are_not_allowed_here_1335", "'unique symbol' types are not allowed here."),
        An_index_signature_parameter_type_cannot_be_a_type_alias_Consider_writing_0_Colon_1_Colon_2_instead: diag(1336, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_type_cannot_be_a_type_alias_Consider_writing_0_Colon_1_Colon_2_instead_1336", "An index signature parameter type cannot be a type alias. Consider writing '[{0}: {1}]: {2}' instead."),
        An_index_signature_parameter_type_cannot_be_a_union_type_Consider_using_a_mapped_object_type_instead: diag(1337, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_type_cannot_be_a_union_type_Consider_using_a_mapped_object_type_instead_1337", "An index signature parameter type cannot be a union type. Consider using a mapped object type instead."),
        infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type: diag(1338, ts2.DiagnosticCategory.Error, "infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type_1338", "'infer' declarations are only permitted in the 'extends' clause of a conditional type."),
        Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here: diag(1339, ts2.DiagnosticCategory.Error, "Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here_1339", "Module '{0}' does not refer to a value, but is used as a value here."),
        Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0: diag(1340, ts2.DiagnosticCategory.Error, "Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0_1340", "Module '{0}' does not refer to a type, but is used as a type here. Did you mean 'typeof import('{0}')'?"),
        Type_arguments_cannot_be_used_here: diag(1342, ts2.DiagnosticCategory.Error, "Type_arguments_cannot_be_used_here_1342", "Type arguments cannot be used here."),
        The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_esnext_or_system: diag(1343, ts2.DiagnosticCategory.Error, "The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_esnext_or_system_1343", "The 'import.meta' meta-property is only allowed when the '--module' option is 'esnext' or 'system'."),
        A_label_is_not_allowed_here: diag(1344, ts2.DiagnosticCategory.Error, "A_label_is_not_allowed_here_1344", "'A label is not allowed here."),
        An_expression_of_type_void_cannot_be_tested_for_truthiness: diag(1345, ts2.DiagnosticCategory.Error, "An_expression_of_type_void_cannot_be_tested_for_truthiness_1345", "An expression of type 'void' cannot be tested for truthiness"),
        This_parameter_is_not_allowed_with_use_strict_directive: diag(1346, ts2.DiagnosticCategory.Error, "This_parameter_is_not_allowed_with_use_strict_directive_1346", "This parameter is not allowed with 'use strict' directive."),
        use_strict_directive_cannot_be_used_with_non_simple_parameter_list: diag(1347, ts2.DiagnosticCategory.Error, "use_strict_directive_cannot_be_used_with_non_simple_parameter_list_1347", "'use strict' directive cannot be used with non-simple parameter list."),
        Non_simple_parameter_declared_here: diag(1348, ts2.DiagnosticCategory.Error, "Non_simple_parameter_declared_here_1348", "Non-simple parameter declared here."),
        use_strict_directive_used_here: diag(1349, ts2.DiagnosticCategory.Error, "use_strict_directive_used_here_1349", "'use strict' directive used here."),
        Print_the_final_configuration_instead_of_building: diag(1350, ts2.DiagnosticCategory.Message, "Print_the_final_configuration_instead_of_building_1350", "Print the final configuration instead of building."),
        An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal: diag(1351, ts2.DiagnosticCategory.Error, "An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal_1351", "An identifier or keyword cannot immediately follow a numeric literal."),
        A_bigint_literal_cannot_use_exponential_notation: diag(1352, ts2.DiagnosticCategory.Error, "A_bigint_literal_cannot_use_exponential_notation_1352", "A bigint literal cannot use exponential notation."),
        A_bigint_literal_must_be_an_integer: diag(1353, ts2.DiagnosticCategory.Error, "A_bigint_literal_must_be_an_integer_1353", "A bigint literal must be an integer."),
        readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types: diag(1354, ts2.DiagnosticCategory.Error, "readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types_1354", "'readonly' type modifier is only permitted on array and tuple literal types."),
        A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array_or_object_literals: diag(1355, ts2.DiagnosticCategory.Error, "A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array__1355", "A 'const' assertions can only be applied to references to enum members, or string, number, boolean, array, or object literals."),
        Did_you_mean_to_mark_this_function_as_async: diag(1356, ts2.DiagnosticCategory.Error, "Did_you_mean_to_mark_this_function_as_async_1356", "Did you mean to mark this function as 'async'?"),
        An_enum_member_name_must_be_followed_by_a_or: diag(1357, ts2.DiagnosticCategory.Error, "An_enum_member_name_must_be_followed_by_a_or_1357", "An enum member name must be followed by a ',', '=', or '}'."),
        Tagged_template_expressions_are_not_permitted_in_an_optional_chain: diag(1358, ts2.DiagnosticCategory.Error, "Tagged_template_expressions_are_not_permitted_in_an_optional_chain_1358", "Tagged template expressions are not permitted in an optional chain."),
        Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here: diag(1359, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here_1359", "Identifier expected. '{0}' is a reserved word that cannot be used here."),
        Did_you_mean_to_parenthesize_this_function_type: diag(1360, ts2.DiagnosticCategory.Error, "Did_you_mean_to_parenthesize_this_function_type_1360", "Did you mean to parenthesize this function type?"),
        _0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type: diag(1361, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type_1361", "'{0}' cannot be used as a value because it was imported using 'import type'."),
        _0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type: diag(1362, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type_1362", "'{0}' cannot be used as a value because it was exported using 'export type'."),
        A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both: diag(1363, ts2.DiagnosticCategory.Error, "A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both_1363", "A type-only import can specify a default import or named bindings, but not both."),
        Convert_to_type_only_export: diag(1364, ts2.DiagnosticCategory.Message, "Convert_to_type_only_export_1364", "Convert to type-only export"),
        Convert_all_re_exported_types_to_type_only_exports: diag(1365, ts2.DiagnosticCategory.Message, "Convert_all_re_exported_types_to_type_only_exports_1365", "Convert all re-exported types to type-only exports"),
        Split_into_two_separate_import_declarations: diag(1366, ts2.DiagnosticCategory.Message, "Split_into_two_separate_import_declarations_1366", "Split into two separate import declarations"),
        Split_all_invalid_type_only_imports: diag(1367, ts2.DiagnosticCategory.Message, "Split_all_invalid_type_only_imports_1367", "Split all invalid type-only imports"),
        Specify_emit_Slashchecking_behavior_for_imports_that_are_only_used_for_types: diag(1368, ts2.DiagnosticCategory.Message, "Specify_emit_Slashchecking_behavior_for_imports_that_are_only_used_for_types_1368", "Specify emit/checking behavior for imports that are only used for types"),
        Did_you_mean_0: diag(1369, ts2.DiagnosticCategory.Message, "Did_you_mean_0_1369", "Did you mean '{0}'?"),
        Only_ECMAScript_imports_may_use_import_type: diag(1370, ts2.DiagnosticCategory.Error, "Only_ECMAScript_imports_may_use_import_type_1370", "Only ECMAScript imports may use 'import type'."),
        This_import_is_never_used_as_a_value_and_must_use_import_type_because_the_importsNotUsedAsValues_is_set_to_error: diag(1371, ts2.DiagnosticCategory.Error, "This_import_is_never_used_as_a_value_and_must_use_import_type_because_the_importsNotUsedAsValues_is__1371", "This import is never used as a value and must use 'import type' because the 'importsNotUsedAsValues' is set to 'error'."),
        Convert_to_type_only_import: diag(1373, ts2.DiagnosticCategory.Message, "Convert_to_type_only_import_1373", "Convert to type-only import"),
        Convert_all_imports_not_used_as_a_value_to_type_only_imports: diag(1374, ts2.DiagnosticCategory.Message, "Convert_all_imports_not_used_as_a_value_to_type_only_imports_1374", "Convert all imports not used as a value to type-only imports"),
        await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(1375, ts2.DiagnosticCategory.Error, "await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_fi_1375", "'await' expressions are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
        _0_was_imported_here: diag(1376, ts2.DiagnosticCategory.Message, "_0_was_imported_here_1376", "'{0}' was imported here."),
        _0_was_exported_here: diag(1377, ts2.DiagnosticCategory.Message, "_0_was_exported_here_1377", "'{0}' was exported here."),
        Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_esnext_or_system_and_the_target_option_is_set_to_es2017_or_higher: diag(1378, ts2.DiagnosticCategory.Error, "Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_esnext_or_system_and_t_1378", "Top-level 'await' expressions are only allowed when the 'module' option is set to 'esnext' or 'system', and the 'target' option is set to 'es2017' or higher."),
        An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type: diag(1379, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type_1379", "An import alias cannot reference a declaration that was exported using 'export type'."),
        An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type: diag(1380, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type_1380", "An import alias cannot reference a declaration that was imported using 'import type'."),
        Unexpected_token_Did_you_mean_or_rbrace: diag(1381, ts2.DiagnosticCategory.Error, "Unexpected_token_Did_you_mean_or_rbrace_1381", "Unexpected token. Did you mean `{'}'}` or `&rbrace;`?"),
        Unexpected_token_Did_you_mean_or_gt: diag(1382, ts2.DiagnosticCategory.Error, "Unexpected_token_Did_you_mean_or_gt_1382", "Unexpected token. Did you mean `{'>'}` or `&gt;`?"),
        Only_named_exports_may_use_export_type: diag(1383, ts2.DiagnosticCategory.Error, "Only_named_exports_may_use_export_type_1383", "Only named exports may use 'export type'."),
        A_new_expression_with_type_arguments_must_always_be_followed_by_a_parenthesized_argument_list: diag(1384, ts2.DiagnosticCategory.Error, "A_new_expression_with_type_arguments_must_always_be_followed_by_a_parenthesized_argument_list_1384", "A 'new' expression with type arguments must always be followed by a parenthesized argument list."),
        The_types_of_0_are_incompatible_between_these_types: diag(2200, ts2.DiagnosticCategory.Error, "The_types_of_0_are_incompatible_between_these_types_2200", "The types of '{0}' are incompatible between these types."),
        The_types_returned_by_0_are_incompatible_between_these_types: diag(2201, ts2.DiagnosticCategory.Error, "The_types_returned_by_0_are_incompatible_between_these_types_2201", "The types returned by '{0}' are incompatible between these types."),
        Call_signature_return_types_0_and_1_are_incompatible: diag(2202, ts2.DiagnosticCategory.Error, "Call_signature_return_types_0_and_1_are_incompatible_2202", "Call signature return types '{0}' and '{1}' are incompatible.", void 0, true),
        Construct_signature_return_types_0_and_1_are_incompatible: diag(2203, ts2.DiagnosticCategory.Error, "Construct_signature_return_types_0_and_1_are_incompatible_2203", "Construct signature return types '{0}' and '{1}' are incompatible.", void 0, true),
        Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(2204, ts2.DiagnosticCategory.Error, "Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2204", "Call signatures with no arguments have incompatible return types '{0}' and '{1}'.", void 0, true),
        Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(2205, ts2.DiagnosticCategory.Error, "Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2205", "Construct signatures with no arguments have incompatible return types '{0}' and '{1}'.", void 0, true),
        Duplicate_identifier_0: diag(2300, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_2300", "Duplicate identifier '{0}'."),
        Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor: diag(2301, ts2.DiagnosticCategory.Error, "Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor_2301", "Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."),
        Static_members_cannot_reference_class_type_parameters: diag(2302, ts2.DiagnosticCategory.Error, "Static_members_cannot_reference_class_type_parameters_2302", "Static members cannot reference class type parameters."),
        Circular_definition_of_import_alias_0: diag(2303, ts2.DiagnosticCategory.Error, "Circular_definition_of_import_alias_0_2303", "Circular definition of import alias '{0}'."),
        Cannot_find_name_0: diag(2304, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_2304", "Cannot find name '{0}'."),
        Module_0_has_no_exported_member_1: diag(2305, ts2.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_2305", "Module '{0}' has no exported member '{1}'."),
        File_0_is_not_a_module: diag(2306, ts2.DiagnosticCategory.Error, "File_0_is_not_a_module_2306", "File '{0}' is not a module."),
        Cannot_find_module_0_or_its_corresponding_type_declarations: diag(2307, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_or_its_corresponding_type_declarations_2307", "Cannot find module '{0}' or its corresponding type declarations."),
        Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambiguity: diag(2308, ts2.DiagnosticCategory.Error, "Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambig_2308", "Module {0} has already exported a member named '{1}'. Consider explicitly re-exporting to resolve the ambiguity."),
        An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements: diag(2309, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements_2309", "An export assignment cannot be used in a module with other exported elements."),
        Type_0_recursively_references_itself_as_a_base_type: diag(2310, ts2.DiagnosticCategory.Error, "Type_0_recursively_references_itself_as_a_base_type_2310", "Type '{0}' recursively references itself as a base type."),
        A_class_may_only_extend_another_class: diag(2311, ts2.DiagnosticCategory.Error, "A_class_may_only_extend_another_class_2311", "A class may only extend another class."),
        An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2312, ts2.DiagnosticCategory.Error, "An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_me_2312", "An interface can only extend an object type or intersection of object types with statically known members."),
        Type_parameter_0_has_a_circular_constraint: diag(2313, ts2.DiagnosticCategory.Error, "Type_parameter_0_has_a_circular_constraint_2313", "Type parameter '{0}' has a circular constraint."),
        Generic_type_0_requires_1_type_argument_s: diag(2314, ts2.DiagnosticCategory.Error, "Generic_type_0_requires_1_type_argument_s_2314", "Generic type '{0}' requires {1} type argument(s)."),
        Type_0_is_not_generic: diag(2315, ts2.DiagnosticCategory.Error, "Type_0_is_not_generic_2315", "Type '{0}' is not generic."),
        Global_type_0_must_be_a_class_or_interface_type: diag(2316, ts2.DiagnosticCategory.Error, "Global_type_0_must_be_a_class_or_interface_type_2316", "Global type '{0}' must be a class or interface type."),
        Global_type_0_must_have_1_type_parameter_s: diag(2317, ts2.DiagnosticCategory.Error, "Global_type_0_must_have_1_type_parameter_s_2317", "Global type '{0}' must have {1} type parameter(s)."),
        Cannot_find_global_type_0: diag(2318, ts2.DiagnosticCategory.Error, "Cannot_find_global_type_0_2318", "Cannot find global type '{0}'."),
        Named_property_0_of_types_1_and_2_are_not_identical: diag(2319, ts2.DiagnosticCategory.Error, "Named_property_0_of_types_1_and_2_are_not_identical_2319", "Named property '{0}' of types '{1}' and '{2}' are not identical."),
        Interface_0_cannot_simultaneously_extend_types_1_and_2: diag(2320, ts2.DiagnosticCategory.Error, "Interface_0_cannot_simultaneously_extend_types_1_and_2_2320", "Interface '{0}' cannot simultaneously extend types '{1}' and '{2}'."),
        Excessive_stack_depth_comparing_types_0_and_1: diag(2321, ts2.DiagnosticCategory.Error, "Excessive_stack_depth_comparing_types_0_and_1_2321", "Excessive stack depth comparing types '{0}' and '{1}'."),
        Type_0_is_not_assignable_to_type_1: diag(2322, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_2322", "Type '{0}' is not assignable to type '{1}'."),
        Cannot_redeclare_exported_variable_0: diag(2323, ts2.DiagnosticCategory.Error, "Cannot_redeclare_exported_variable_0_2323", "Cannot redeclare exported variable '{0}'."),
        Property_0_is_missing_in_type_1: diag(2324, ts2.DiagnosticCategory.Error, "Property_0_is_missing_in_type_1_2324", "Property '{0}' is missing in type '{1}'."),
        Property_0_is_private_in_type_1_but_not_in_type_2: diag(2325, ts2.DiagnosticCategory.Error, "Property_0_is_private_in_type_1_but_not_in_type_2_2325", "Property '{0}' is private in type '{1}' but not in type '{2}'."),
        Types_of_property_0_are_incompatible: diag(2326, ts2.DiagnosticCategory.Error, "Types_of_property_0_are_incompatible_2326", "Types of property '{0}' are incompatible."),
        Property_0_is_optional_in_type_1_but_required_in_type_2: diag(2327, ts2.DiagnosticCategory.Error, "Property_0_is_optional_in_type_1_but_required_in_type_2_2327", "Property '{0}' is optional in type '{1}' but required in type '{2}'."),
        Types_of_parameters_0_and_1_are_incompatible: diag(2328, ts2.DiagnosticCategory.Error, "Types_of_parameters_0_and_1_are_incompatible_2328", "Types of parameters '{0}' and '{1}' are incompatible."),
        Index_signature_is_missing_in_type_0: diag(2329, ts2.DiagnosticCategory.Error, "Index_signature_is_missing_in_type_0_2329", "Index signature is missing in type '{0}'."),
        Index_signatures_are_incompatible: diag(2330, ts2.DiagnosticCategory.Error, "Index_signatures_are_incompatible_2330", "Index signatures are incompatible."),
        this_cannot_be_referenced_in_a_module_or_namespace_body: diag(2331, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_module_or_namespace_body_2331", "'this' cannot be referenced in a module or namespace body."),
        this_cannot_be_referenced_in_current_location: diag(2332, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_current_location_2332", "'this' cannot be referenced in current location."),
        this_cannot_be_referenced_in_constructor_arguments: diag(2333, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_constructor_arguments_2333", "'this' cannot be referenced in constructor arguments."),
        this_cannot_be_referenced_in_a_static_property_initializer: diag(2334, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_static_property_initializer_2334", "'this' cannot be referenced in a static property initializer."),
        super_can_only_be_referenced_in_a_derived_class: diag(2335, ts2.DiagnosticCategory.Error, "super_can_only_be_referenced_in_a_derived_class_2335", "'super' can only be referenced in a derived class."),
        super_cannot_be_referenced_in_constructor_arguments: diag(2336, ts2.DiagnosticCategory.Error, "super_cannot_be_referenced_in_constructor_arguments_2336", "'super' cannot be referenced in constructor arguments."),
        Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors: diag(2337, ts2.DiagnosticCategory.Error, "Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors_2337", "Super calls are not permitted outside constructors or in nested functions inside constructors."),
        super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class: diag(2338, ts2.DiagnosticCategory.Error, "super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_der_2338", "'super' property access is permitted only in a constructor, member function, or member accessor of a derived class."),
        Property_0_does_not_exist_on_type_1: diag(2339, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_2339", "Property '{0}' does not exist on type '{1}'."),
        Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword: diag(2340, ts2.DiagnosticCategory.Error, "Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword_2340", "Only public and protected methods of the base class are accessible via the 'super' keyword."),
        Property_0_is_private_and_only_accessible_within_class_1: diag(2341, ts2.DiagnosticCategory.Error, "Property_0_is_private_and_only_accessible_within_class_1_2341", "Property '{0}' is private and only accessible within class '{1}'."),
        An_index_expression_argument_must_be_of_type_string_number_symbol_or_any: diag(2342, ts2.DiagnosticCategory.Error, "An_index_expression_argument_must_be_of_type_string_number_symbol_or_any_2342", "An index expression argument must be of type 'string', 'number', 'symbol', or 'any'."),
        This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_version_of_0: diag(2343, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_ve_2343", "This syntax requires an imported helper named '{1}' which does not exist in '{0}'. Consider upgrading your version of '{0}'."),
        Type_0_does_not_satisfy_the_constraint_1: diag(2344, ts2.DiagnosticCategory.Error, "Type_0_does_not_satisfy_the_constraint_1_2344", "Type '{0}' does not satisfy the constraint '{1}'."),
        Argument_of_type_0_is_not_assignable_to_parameter_of_type_1: diag(2345, ts2.DiagnosticCategory.Error, "Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_2345", "Argument of type '{0}' is not assignable to parameter of type '{1}'."),
        Call_target_does_not_contain_any_signatures: diag(2346, ts2.DiagnosticCategory.Error, "Call_target_does_not_contain_any_signatures_2346", "Call target does not contain any signatures."),
        Untyped_function_calls_may_not_accept_type_arguments: diag(2347, ts2.DiagnosticCategory.Error, "Untyped_function_calls_may_not_accept_type_arguments_2347", "Untyped function calls may not accept type arguments."),
        Value_of_type_0_is_not_callable_Did_you_mean_to_include_new: diag(2348, ts2.DiagnosticCategory.Error, "Value_of_type_0_is_not_callable_Did_you_mean_to_include_new_2348", "Value of type '{0}' is not callable. Did you mean to include 'new'?"),
        This_expression_is_not_callable: diag(2349, ts2.DiagnosticCategory.Error, "This_expression_is_not_callable_2349", "This expression is not callable."),
        Only_a_void_function_can_be_called_with_the_new_keyword: diag(2350, ts2.DiagnosticCategory.Error, "Only_a_void_function_can_be_called_with_the_new_keyword_2350", "Only a void function can be called with the 'new' keyword."),
        This_expression_is_not_constructable: diag(2351, ts2.DiagnosticCategory.Error, "This_expression_is_not_constructable_2351", "This expression is not constructable."),
        Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the_other_If_this_was_intentional_convert_the_expression_to_unknown_first: diag(2352, ts2.DiagnosticCategory.Error, "Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the__2352", "Conversion of type '{0}' to type '{1}' may be a mistake because neither type sufficiently overlaps with the other. If this was intentional, convert the expression to 'unknown' first."),
        Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1: diag(2353, ts2.DiagnosticCategory.Error, "Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1_2353", "Object literal may only specify known properties, and '{0}' does not exist in type '{1}'."),
        This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found: diag(2354, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found_2354", "This syntax requires an imported helper but module '{0}' cannot be found."),
        A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value: diag(2355, ts2.DiagnosticCategory.Error, "A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value_2355", "A function whose declared type is neither 'void' nor 'any' must return a value."),
        An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2356, ts2.DiagnosticCategory.Error, "An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type_2356", "An arithmetic operand must be of type 'any', 'number', 'bigint' or an enum type."),
        The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access: diag(2357, ts2.DiagnosticCategory.Error, "The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access_2357", "The operand of an increment or decrement operator must be a variable or a property access."),
        The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: diag(2358, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_paramete_2358", "The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter."),
        The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type: diag(2359, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_F_2359", "The right-hand side of an 'instanceof' expression must be of type 'any' or of a type assignable to the 'Function' interface type."),
        The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol: diag(2360, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol_2360", "The left-hand side of an 'in' expression must be of type 'any', 'string', 'number', or 'symbol'."),
        The_right_hand_side_of_an_in_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: diag(2361, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_in_expression_must_be_of_type_any_an_object_type_or_a_type_parameter_2361", "The right-hand side of an 'in' expression must be of type 'any', an object type or a type parameter."),
        The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2362, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2362", "The left-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
        The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2363, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2363", "The right-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
        The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access: diag(2364, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access_2364", "The left-hand side of an assignment expression must be a variable or a property access."),
        Operator_0_cannot_be_applied_to_types_1_and_2: diag(2365, ts2.DiagnosticCategory.Error, "Operator_0_cannot_be_applied_to_types_1_and_2_2365", "Operator '{0}' cannot be applied to types '{1}' and '{2}'."),
        Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined: diag(2366, ts2.DiagnosticCategory.Error, "Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined_2366", "Function lacks ending return statement and return type does not include 'undefined'."),
        This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap: diag(2367, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap_2367", "This condition will always return '{0}' since the types '{1}' and '{2}' have no overlap."),
        Type_parameter_name_cannot_be_0: diag(2368, ts2.DiagnosticCategory.Error, "Type_parameter_name_cannot_be_0_2368", "Type parameter name cannot be '{0}'."),
        A_parameter_property_is_only_allowed_in_a_constructor_implementation: diag(2369, ts2.DiagnosticCategory.Error, "A_parameter_property_is_only_allowed_in_a_constructor_implementation_2369", "A parameter property is only allowed in a constructor implementation."),
        A_rest_parameter_must_be_of_an_array_type: diag(2370, ts2.DiagnosticCategory.Error, "A_rest_parameter_must_be_of_an_array_type_2370", "A rest parameter must be of an array type."),
        A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation: diag(2371, ts2.DiagnosticCategory.Error, "A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation_2371", "A parameter initializer is only allowed in a function or constructor implementation."),
        Parameter_0_cannot_reference_itself: diag(2372, ts2.DiagnosticCategory.Error, "Parameter_0_cannot_reference_itself_2372", "Parameter '{0}' cannot reference itself."),
        Parameter_0_cannot_reference_identifier_1_declared_after_it: diag(2373, ts2.DiagnosticCategory.Error, "Parameter_0_cannot_reference_identifier_1_declared_after_it_2373", "Parameter '{0}' cannot reference identifier '{1}' declared after it."),
        Duplicate_string_index_signature: diag(2374, ts2.DiagnosticCategory.Error, "Duplicate_string_index_signature_2374", "Duplicate string index signature."),
        Duplicate_number_index_signature: diag(2375, ts2.DiagnosticCategory.Error, "Duplicate_number_index_signature_2375", "Duplicate number index signature."),
        A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_properties_parameter_properties_or_private_identifiers: diag(2376, ts2.DiagnosticCategory.Error, "A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_proper_2376", "A 'super' call must be the first statement in the constructor when a class contains initialized properties, parameter properties, or private identifiers."),
        Constructors_for_derived_classes_must_contain_a_super_call: diag(2377, ts2.DiagnosticCategory.Error, "Constructors_for_derived_classes_must_contain_a_super_call_2377", "Constructors for derived classes must contain a 'super' call."),
        A_get_accessor_must_return_a_value: diag(2378, ts2.DiagnosticCategory.Error, "A_get_accessor_must_return_a_value_2378", "A 'get' accessor must return a value."),
        Getter_and_setter_accessors_do_not_agree_in_visibility: diag(2379, ts2.DiagnosticCategory.Error, "Getter_and_setter_accessors_do_not_agree_in_visibility_2379", "Getter and setter accessors do not agree in visibility."),
        get_and_set_accessor_must_have_the_same_type: diag(2380, ts2.DiagnosticCategory.Error, "get_and_set_accessor_must_have_the_same_type_2380", "'get' and 'set' accessor must have the same type."),
        A_signature_with_an_implementation_cannot_use_a_string_literal_type: diag(2381, ts2.DiagnosticCategory.Error, "A_signature_with_an_implementation_cannot_use_a_string_literal_type_2381", "A signature with an implementation cannot use a string literal type."),
        Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature: diag(2382, ts2.DiagnosticCategory.Error, "Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature_2382", "Specialized overload signature is not assignable to any non-specialized signature."),
        Overload_signatures_must_all_be_exported_or_non_exported: diag(2383, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_exported_or_non_exported_2383", "Overload signatures must all be exported or non-exported."),
        Overload_signatures_must_all_be_ambient_or_non_ambient: diag(2384, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_ambient_or_non_ambient_2384", "Overload signatures must all be ambient or non-ambient."),
        Overload_signatures_must_all_be_public_private_or_protected: diag(2385, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_public_private_or_protected_2385", "Overload signatures must all be public, private or protected."),
        Overload_signatures_must_all_be_optional_or_required: diag(2386, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_optional_or_required_2386", "Overload signatures must all be optional or required."),
        Function_overload_must_be_static: diag(2387, ts2.DiagnosticCategory.Error, "Function_overload_must_be_static_2387", "Function overload must be static."),
        Function_overload_must_not_be_static: diag(2388, ts2.DiagnosticCategory.Error, "Function_overload_must_not_be_static_2388", "Function overload must not be static."),
        Function_implementation_name_must_be_0: diag(2389, ts2.DiagnosticCategory.Error, "Function_implementation_name_must_be_0_2389", "Function implementation name must be '{0}'."),
        Constructor_implementation_is_missing: diag(2390, ts2.DiagnosticCategory.Error, "Constructor_implementation_is_missing_2390", "Constructor implementation is missing."),
        Function_implementation_is_missing_or_not_immediately_following_the_declaration: diag(2391, ts2.DiagnosticCategory.Error, "Function_implementation_is_missing_or_not_immediately_following_the_declaration_2391", "Function implementation is missing or not immediately following the declaration."),
        Multiple_constructor_implementations_are_not_allowed: diag(2392, ts2.DiagnosticCategory.Error, "Multiple_constructor_implementations_are_not_allowed_2392", "Multiple constructor implementations are not allowed."),
        Duplicate_function_implementation: diag(2393, ts2.DiagnosticCategory.Error, "Duplicate_function_implementation_2393", "Duplicate function implementation."),
        This_overload_signature_is_not_compatible_with_its_implementation_signature: diag(2394, ts2.DiagnosticCategory.Error, "This_overload_signature_is_not_compatible_with_its_implementation_signature_2394", "This overload signature is not compatible with its implementation signature."),
        Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local: diag(2395, ts2.DiagnosticCategory.Error, "Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local_2395", "Individual declarations in merged declaration '{0}' must be all exported or all local."),
        Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters: diag(2396, ts2.DiagnosticCategory.Error, "Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters_2396", "Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters."),
        Declaration_name_conflicts_with_built_in_global_identifier_0: diag(2397, ts2.DiagnosticCategory.Error, "Declaration_name_conflicts_with_built_in_global_identifier_0_2397", "Declaration name conflicts with built-in global identifier '{0}'."),
        constructor_cannot_be_used_as_a_parameter_property_name: diag(2398, ts2.DiagnosticCategory.Error, "constructor_cannot_be_used_as_a_parameter_property_name_2398", "'constructor' cannot be used as a parameter property name."),
        Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference: diag(2399, ts2.DiagnosticCategory.Error, "Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference_2399", "Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference."),
        Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference: diag(2400, ts2.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference_2400", "Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference."),
        Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference: diag(2401, ts2.DiagnosticCategory.Error, "Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference_2401", "Duplicate identifier '_super'. Compiler uses '_super' to capture base class reference."),
        Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference: diag(2402, ts2.DiagnosticCategory.Error, "Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference_2402", "Expression resolves to '_super' that compiler uses to capture base class reference."),
        Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2: diag(2403, ts2.DiagnosticCategory.Error, "Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_t_2403", "Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'."),
        The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation: diag(2404, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation_2404", "The left-hand side of a 'for...in' statement cannot use a type annotation."),
        The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any: diag(2405, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any_2405", "The left-hand side of a 'for...in' statement must be of type 'string' or 'any'."),
        The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access: diag(2406, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access_2406", "The left-hand side of a 'for...in' statement must be a variable or a property access."),
        The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_here_has_type_0: diag(2407, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_2407", "The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter, but here has type '{0}'."),
        Setters_cannot_return_a_value: diag(2408, ts2.DiagnosticCategory.Error, "Setters_cannot_return_a_value_2408", "Setters cannot return a value."),
        Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class: diag(2409, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class_2409", "Return type of constructor signature must be assignable to the instance type of the class."),
        The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any: diag(2410, ts2.DiagnosticCategory.Error, "The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any_2410", "The 'with' statement is not supported. All symbols in a 'with' block will have type 'any'."),
        Property_0_of_type_1_is_not_assignable_to_string_index_type_2: diag(2411, ts2.DiagnosticCategory.Error, "Property_0_of_type_1_is_not_assignable_to_string_index_type_2_2411", "Property '{0}' of type '{1}' is not assignable to string index type '{2}'."),
        Property_0_of_type_1_is_not_assignable_to_numeric_index_type_2: diag(2412, ts2.DiagnosticCategory.Error, "Property_0_of_type_1_is_not_assignable_to_numeric_index_type_2_2412", "Property '{0}' of type '{1}' is not assignable to numeric index type '{2}'."),
        Numeric_index_type_0_is_not_assignable_to_string_index_type_1: diag(2413, ts2.DiagnosticCategory.Error, "Numeric_index_type_0_is_not_assignable_to_string_index_type_1_2413", "Numeric index type '{0}' is not assignable to string index type '{1}'."),
        Class_name_cannot_be_0: diag(2414, ts2.DiagnosticCategory.Error, "Class_name_cannot_be_0_2414", "Class name cannot be '{0}'."),
        Class_0_incorrectly_extends_base_class_1: diag(2415, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_extends_base_class_1_2415", "Class '{0}' incorrectly extends base class '{1}'."),
        Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2: diag(2416, ts2.DiagnosticCategory.Error, "Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2_2416", "Property '{0}' in type '{1}' is not assignable to the same property in base type '{2}'."),
        Class_static_side_0_incorrectly_extends_base_class_static_side_1: diag(2417, ts2.DiagnosticCategory.Error, "Class_static_side_0_incorrectly_extends_base_class_static_side_1_2417", "Class static side '{0}' incorrectly extends base class static side '{1}'."),
        Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1: diag(2418, ts2.DiagnosticCategory.Error, "Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1_2418", "Type of computed property's value is '{0}', which is not assignable to type '{1}'."),
        Class_0_incorrectly_implements_interface_1: diag(2420, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_implements_interface_1_2420", "Class '{0}' incorrectly implements interface '{1}'."),
        A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2422, ts2.DiagnosticCategory.Error, "A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_memb_2422", "A class can only implement an object type or intersection of object types with statically known members."),
        Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor: diag(2423, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_access_2423", "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor."),
        Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2425, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_functi_2425", "Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function."),
        Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2426, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_functi_2426", "Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function."),
        Interface_name_cannot_be_0: diag(2427, ts2.DiagnosticCategory.Error, "Interface_name_cannot_be_0_2427", "Interface name cannot be '{0}'."),
        All_declarations_of_0_must_have_identical_type_parameters: diag(2428, ts2.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_type_parameters_2428", "All declarations of '{0}' must have identical type parameters."),
        Interface_0_incorrectly_extends_interface_1: diag(2430, ts2.DiagnosticCategory.Error, "Interface_0_incorrectly_extends_interface_1_2430", "Interface '{0}' incorrectly extends interface '{1}'."),
        Enum_name_cannot_be_0: diag(2431, ts2.DiagnosticCategory.Error, "Enum_name_cannot_be_0_2431", "Enum name cannot be '{0}'."),
        In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element: diag(2432, ts2.DiagnosticCategory.Error, "In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enu_2432", "In an enum with multiple declarations, only one declaration can omit an initializer for its first enum element."),
        A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged: diag(2433, ts2.DiagnosticCategory.Error, "A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merg_2433", "A namespace declaration cannot be in a different file from a class or function with which it is merged."),
        A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged: diag(2434, ts2.DiagnosticCategory.Error, "A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged_2434", "A namespace declaration cannot be located prior to a class or function with which it is merged."),
        Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces: diag(2435, ts2.DiagnosticCategory.Error, "Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces_2435", "Ambient modules cannot be nested in other modules or namespaces."),
        Ambient_module_declaration_cannot_specify_relative_module_name: diag(2436, ts2.DiagnosticCategory.Error, "Ambient_module_declaration_cannot_specify_relative_module_name_2436", "Ambient module declaration cannot specify relative module name."),
        Module_0_is_hidden_by_a_local_declaration_with_the_same_name: diag(2437, ts2.DiagnosticCategory.Error, "Module_0_is_hidden_by_a_local_declaration_with_the_same_name_2437", "Module '{0}' is hidden by a local declaration with the same name."),
        Import_name_cannot_be_0: diag(2438, ts2.DiagnosticCategory.Error, "Import_name_cannot_be_0_2438", "Import name cannot be '{0}'."),
        Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name: diag(2439, ts2.DiagnosticCategory.Error, "Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relati_2439", "Import or export declaration in an ambient module declaration cannot reference module through relative module name."),
        Import_declaration_conflicts_with_local_declaration_of_0: diag(2440, ts2.DiagnosticCategory.Error, "Import_declaration_conflicts_with_local_declaration_of_0_2440", "Import declaration conflicts with local declaration of '{0}'."),
        Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module: diag(2441, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_2441", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module."),
        Types_have_separate_declarations_of_a_private_property_0: diag(2442, ts2.DiagnosticCategory.Error, "Types_have_separate_declarations_of_a_private_property_0_2442", "Types have separate declarations of a private property '{0}'."),
        Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2: diag(2443, ts2.DiagnosticCategory.Error, "Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2_2443", "Property '{0}' is protected but type '{1}' is not a class derived from '{2}'."),
        Property_0_is_protected_in_type_1_but_public_in_type_2: diag(2444, ts2.DiagnosticCategory.Error, "Property_0_is_protected_in_type_1_but_public_in_type_2_2444", "Property '{0}' is protected in type '{1}' but public in type '{2}'."),
        Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses: diag(2445, ts2.DiagnosticCategory.Error, "Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses_2445", "Property '{0}' is protected and only accessible within class '{1}' and its subclasses."),
        Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1: diag(2446, ts2.DiagnosticCategory.Error, "Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_2446", "Property '{0}' is protected and only accessible through an instance of class '{1}'."),
        The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead: diag(2447, ts2.DiagnosticCategory.Error, "The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead_2447", "The '{0}' operator is not allowed for boolean types. Consider using '{1}' instead."),
        Block_scoped_variable_0_used_before_its_declaration: diag(2448, ts2.DiagnosticCategory.Error, "Block_scoped_variable_0_used_before_its_declaration_2448", "Block-scoped variable '{0}' used before its declaration."),
        Class_0_used_before_its_declaration: diag(2449, ts2.DiagnosticCategory.Error, "Class_0_used_before_its_declaration_2449", "Class '{0}' used before its declaration."),
        Enum_0_used_before_its_declaration: diag(2450, ts2.DiagnosticCategory.Error, "Enum_0_used_before_its_declaration_2450", "Enum '{0}' used before its declaration."),
        Cannot_redeclare_block_scoped_variable_0: diag(2451, ts2.DiagnosticCategory.Error, "Cannot_redeclare_block_scoped_variable_0_2451", "Cannot redeclare block-scoped variable '{0}'."),
        An_enum_member_cannot_have_a_numeric_name: diag(2452, ts2.DiagnosticCategory.Error, "An_enum_member_cannot_have_a_numeric_name_2452", "An enum member cannot have a numeric name."),
        The_type_argument_for_type_parameter_0_cannot_be_inferred_from_the_usage_Consider_specifying_the_type_arguments_explicitly: diag(2453, ts2.DiagnosticCategory.Error, "The_type_argument_for_type_parameter_0_cannot_be_inferred_from_the_usage_Consider_specifying_the_typ_2453", "The type argument for type parameter '{0}' cannot be inferred from the usage. Consider specifying the type arguments explicitly."),
        Variable_0_is_used_before_being_assigned: diag(2454, ts2.DiagnosticCategory.Error, "Variable_0_is_used_before_being_assigned_2454", "Variable '{0}' is used before being assigned."),
        Type_argument_candidate_1_is_not_a_valid_type_argument_because_it_is_not_a_supertype_of_candidate_0: diag(2455, ts2.DiagnosticCategory.Error, "Type_argument_candidate_1_is_not_a_valid_type_argument_because_it_is_not_a_supertype_of_candidate_0_2455", "Type argument candidate '{1}' is not a valid type argument because it is not a supertype of candidate '{0}'."),
        Type_alias_0_circularly_references_itself: diag(2456, ts2.DiagnosticCategory.Error, "Type_alias_0_circularly_references_itself_2456", "Type alias '{0}' circularly references itself."),
        Type_alias_name_cannot_be_0: diag(2457, ts2.DiagnosticCategory.Error, "Type_alias_name_cannot_be_0_2457", "Type alias name cannot be '{0}'."),
        An_AMD_module_cannot_have_multiple_name_assignments: diag(2458, ts2.DiagnosticCategory.Error, "An_AMD_module_cannot_have_multiple_name_assignments_2458", "An AMD module cannot have multiple name assignments."),
        Module_0_declares_1_locally_but_it_is_not_exported: diag(2459, ts2.DiagnosticCategory.Error, "Module_0_declares_1_locally_but_it_is_not_exported_2459", "Module '{0}' declares '{1}' locally, but it is not exported."),
        Module_0_declares_1_locally_but_it_is_exported_as_2: diag(2460, ts2.DiagnosticCategory.Error, "Module_0_declares_1_locally_but_it_is_exported_as_2_2460", "Module '{0}' declares '{1}' locally, but it is exported as '{2}'."),
        Type_0_is_not_an_array_type: diag(2461, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_2461", "Type '{0}' is not an array type."),
        A_rest_element_must_be_last_in_a_destructuring_pattern: diag(2462, ts2.DiagnosticCategory.Error, "A_rest_element_must_be_last_in_a_destructuring_pattern_2462", "A rest element must be last in a destructuring pattern."),
        A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature: diag(2463, ts2.DiagnosticCategory.Error, "A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature_2463", "A binding pattern parameter cannot be optional in an implementation signature."),
        A_computed_property_name_must_be_of_type_string_number_symbol_or_any: diag(2464, ts2.DiagnosticCategory.Error, "A_computed_property_name_must_be_of_type_string_number_symbol_or_any_2464", "A computed property name must be of type 'string', 'number', 'symbol', or 'any'."),
        this_cannot_be_referenced_in_a_computed_property_name: diag(2465, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_computed_property_name_2465", "'this' cannot be referenced in a computed property name."),
        super_cannot_be_referenced_in_a_computed_property_name: diag(2466, ts2.DiagnosticCategory.Error, "super_cannot_be_referenced_in_a_computed_property_name_2466", "'super' cannot be referenced in a computed property name."),
        A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type: diag(2467, ts2.DiagnosticCategory.Error, "A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type_2467", "A computed property name cannot reference a type parameter from its containing type."),
        Cannot_find_global_value_0: diag(2468, ts2.DiagnosticCategory.Error, "Cannot_find_global_value_0_2468", "Cannot find global value '{0}'."),
        The_0_operator_cannot_be_applied_to_type_symbol: diag(2469, ts2.DiagnosticCategory.Error, "The_0_operator_cannot_be_applied_to_type_symbol_2469", "The '{0}' operator cannot be applied to type 'symbol'."),
        Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object: diag(2470, ts2.DiagnosticCategory.Error, "Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object_2470", "'Symbol' reference does not refer to the global Symbol constructor object."),
        A_computed_property_name_of_the_form_0_must_be_of_type_symbol: diag(2471, ts2.DiagnosticCategory.Error, "A_computed_property_name_of_the_form_0_must_be_of_type_symbol_2471", "A computed property name of the form '{0}' must be of type 'symbol'."),
        Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher: diag(2472, ts2.DiagnosticCategory.Error, "Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher_2472", "Spread operator in 'new' expressions is only available when targeting ECMAScript 5 and higher."),
        Enum_declarations_must_all_be_const_or_non_const: diag(2473, ts2.DiagnosticCategory.Error, "Enum_declarations_must_all_be_const_or_non_const_2473", "Enum declarations must all be const or non-const."),
        const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values: diag(2474, ts2.DiagnosticCategory.Error, "const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values_2474", "const enum member initializers can only contain literal values and other computed enum values."),
        const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment_or_type_query: diag(2475, ts2.DiagnosticCategory.Error, "const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_im_2475", "'const' enums can only be used in property or index access expressions or the right hand side of an import declaration or export assignment or type query."),
        A_const_enum_member_can_only_be_accessed_using_a_string_literal: diag(2476, ts2.DiagnosticCategory.Error, "A_const_enum_member_can_only_be_accessed_using_a_string_literal_2476", "A const enum member can only be accessed using a string literal."),
        const_enum_member_initializer_was_evaluated_to_a_non_finite_value: diag(2477, ts2.DiagnosticCategory.Error, "const_enum_member_initializer_was_evaluated_to_a_non_finite_value_2477", "'const' enum member initializer was evaluated to a non-finite value."),
        const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN: diag(2478, ts2.DiagnosticCategory.Error, "const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN_2478", "'const' enum member initializer was evaluated to disallowed value 'NaN'."),
        Property_0_does_not_exist_on_const_enum_1: diag(2479, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_const_enum_1_2479", "Property '{0}' does not exist on 'const' enum '{1}'."),
        let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations: diag(2480, ts2.DiagnosticCategory.Error, "let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations_2480", "'let' is not allowed to be used as a name in 'let' or 'const' declarations."),
        Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1: diag(2481, ts2.DiagnosticCategory.Error, "Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1_2481", "Cannot initialize outer scoped variable '{0}' in the same scope as block scoped declaration '{1}'."),
        The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation: diag(2483, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation_2483", "The left-hand side of a 'for...of' statement cannot use a type annotation."),
        Export_declaration_conflicts_with_exported_declaration_of_0: diag(2484, ts2.DiagnosticCategory.Error, "Export_declaration_conflicts_with_exported_declaration_of_0_2484", "Export declaration conflicts with exported declaration of '{0}'."),
        The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access: diag(2487, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access_2487", "The left-hand side of a 'for...of' statement must be a variable or a property access."),
        Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2488, ts2.DiagnosticCategory.Error, "Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator_2488", "Type '{0}' must have a '[Symbol.iterator]()' method that returns an iterator."),
        An_iterator_must_have_a_next_method: diag(2489, ts2.DiagnosticCategory.Error, "An_iterator_must_have_a_next_method_2489", "An iterator must have a 'next()' method."),
        The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property: diag(2490, ts2.DiagnosticCategory.Error, "The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property_2490", "The type returned by the '{0}()' method of an iterator must have a 'value' property."),
        The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern: diag(2491, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern_2491", "The left-hand side of a 'for...in' statement cannot be a destructuring pattern."),
        Cannot_redeclare_identifier_0_in_catch_clause: diag(2492, ts2.DiagnosticCategory.Error, "Cannot_redeclare_identifier_0_in_catch_clause_2492", "Cannot redeclare identifier '{0}' in catch clause."),
        Tuple_type_0_of_length_1_has_no_element_at_index_2: diag(2493, ts2.DiagnosticCategory.Error, "Tuple_type_0_of_length_1_has_no_element_at_index_2_2493", "Tuple type '{0}' of length '{1}' has no element at index '{2}'."),
        Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher: diag(2494, ts2.DiagnosticCategory.Error, "Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher_2494", "Using a string in a 'for...of' statement is only supported in ECMAScript 5 and higher."),
        Type_0_is_not_an_array_type_or_a_string_type: diag(2495, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_2495", "Type '{0}' is not an array type or a string type."),
        The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression: diag(2496, ts2.DiagnosticCategory.Error, "The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_stand_2496", "The 'arguments' object cannot be referenced in an arrow function in ES3 and ES5. Consider using a standard function expression."),
        This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_referencing_its_default_export: diag(2497, ts2.DiagnosticCategory.Error, "This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_2497", "This module can only be referenced with ECMAScript imports/exports by turning on the '{0}' flag and referencing its default export."),
        Module_0_uses_export_and_cannot_be_used_with_export_Asterisk: diag(2498, ts2.DiagnosticCategory.Error, "Module_0_uses_export_and_cannot_be_used_with_export_Asterisk_2498", "Module '{0}' uses 'export =' and cannot be used with 'export *'."),
        An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2499, ts2.DiagnosticCategory.Error, "An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments_2499", "An interface can only extend an identifier/qualified-name with optional type arguments."),
        A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2500, ts2.DiagnosticCategory.Error, "A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments_2500", "A class can only implement an identifier/qualified-name with optional type arguments."),
        A_rest_element_cannot_contain_a_binding_pattern: diag(2501, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_contain_a_binding_pattern_2501", "A rest element cannot contain a binding pattern."),
        _0_is_referenced_directly_or_indirectly_in_its_own_type_annotation: diag(2502, ts2.DiagnosticCategory.Error, "_0_is_referenced_directly_or_indirectly_in_its_own_type_annotation_2502", "'{0}' is referenced directly or indirectly in its own type annotation."),
        Cannot_find_namespace_0: diag(2503, ts2.DiagnosticCategory.Error, "Cannot_find_namespace_0_2503", "Cannot find namespace '{0}'."),
        Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator: diag(2504, ts2.DiagnosticCategory.Error, "Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator_2504", "Type '{0}' must have a '[Symbol.asyncIterator]()' method that returns an async iterator."),
        A_generator_cannot_have_a_void_type_annotation: diag(2505, ts2.DiagnosticCategory.Error, "A_generator_cannot_have_a_void_type_annotation_2505", "A generator cannot have a 'void' type annotation."),
        _0_is_referenced_directly_or_indirectly_in_its_own_base_expression: diag(2506, ts2.DiagnosticCategory.Error, "_0_is_referenced_directly_or_indirectly_in_its_own_base_expression_2506", "'{0}' is referenced directly or indirectly in its own base expression."),
        Type_0_is_not_a_constructor_function_type: diag(2507, ts2.DiagnosticCategory.Error, "Type_0_is_not_a_constructor_function_type_2507", "Type '{0}' is not a constructor function type."),
        No_base_constructor_has_the_specified_number_of_type_arguments: diag(2508, ts2.DiagnosticCategory.Error, "No_base_constructor_has_the_specified_number_of_type_arguments_2508", "No base constructor has the specified number of type arguments."),
        Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2509, ts2.DiagnosticCategory.Error, "Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_2509", "Base constructor return type '{0}' is not an object type or intersection of object types with statically known members."),
        Base_constructors_must_all_have_the_same_return_type: diag(2510, ts2.DiagnosticCategory.Error, "Base_constructors_must_all_have_the_same_return_type_2510", "Base constructors must all have the same return type."),
        Cannot_create_an_instance_of_an_abstract_class: diag(2511, ts2.DiagnosticCategory.Error, "Cannot_create_an_instance_of_an_abstract_class_2511", "Cannot create an instance of an abstract class."),
        Overload_signatures_must_all_be_abstract_or_non_abstract: diag(2512, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_abstract_or_non_abstract_2512", "Overload signatures must all be abstract or non-abstract."),
        Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression: diag(2513, ts2.DiagnosticCategory.Error, "Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression_2513", "Abstract method '{0}' in class '{1}' cannot be accessed via super expression."),
        Classes_containing_abstract_methods_must_be_marked_abstract: diag(2514, ts2.DiagnosticCategory.Error, "Classes_containing_abstract_methods_must_be_marked_abstract_2514", "Classes containing abstract methods must be marked abstract."),
        Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2: diag(2515, ts2.DiagnosticCategory.Error, "Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2_2515", "Non-abstract class '{0}' does not implement inherited abstract member '{1}' from class '{2}'."),
        All_declarations_of_an_abstract_method_must_be_consecutive: diag(2516, ts2.DiagnosticCategory.Error, "All_declarations_of_an_abstract_method_must_be_consecutive_2516", "All declarations of an abstract method must be consecutive."),
        Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type: diag(2517, ts2.DiagnosticCategory.Error, "Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type_2517", "Cannot assign an abstract constructor type to a non-abstract constructor type."),
        A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard: diag(2518, ts2.DiagnosticCategory.Error, "A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard_2518", "A 'this'-based type guard is not compatible with a parameter-based type guard."),
        An_async_iterator_must_have_a_next_method: diag(2519, ts2.DiagnosticCategory.Error, "An_async_iterator_must_have_a_next_method_2519", "An async iterator must have a 'next()' method."),
        Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions: diag(2520, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions_2520", "Duplicate identifier '{0}'. Compiler uses declaration '{1}' to support async functions."),
        Expression_resolves_to_variable_declaration_0_that_compiler_uses_to_support_async_functions: diag(2521, ts2.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_0_that_compiler_uses_to_support_async_functions_2521", "Expression resolves to variable declaration '{0}' that compiler uses to support async functions."),
        The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_using_a_standard_function_or_method: diag(2522, ts2.DiagnosticCategory.Error, "The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_usi_2522", "The 'arguments' object cannot be referenced in an async function or method in ES3 and ES5. Consider using a standard function or method."),
        yield_expressions_cannot_be_used_in_a_parameter_initializer: diag(2523, ts2.DiagnosticCategory.Error, "yield_expressions_cannot_be_used_in_a_parameter_initializer_2523", "'yield' expressions cannot be used in a parameter initializer."),
        await_expressions_cannot_be_used_in_a_parameter_initializer: diag(2524, ts2.DiagnosticCategory.Error, "await_expressions_cannot_be_used_in_a_parameter_initializer_2524", "'await' expressions cannot be used in a parameter initializer."),
        Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value: diag(2525, ts2.DiagnosticCategory.Error, "Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value_2525", "Initializer provides no value for this binding element and the binding element has no default value."),
        A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface: diag(2526, ts2.DiagnosticCategory.Error, "A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface_2526", "A 'this' type is available only in a non-static member of a class or interface."),
        The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary: diag(2527, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary_2527", "The inferred type of '{0}' references an inaccessible '{1}' type. A type annotation is necessary."),
        A_module_cannot_have_multiple_default_exports: diag(2528, ts2.DiagnosticCategory.Error, "A_module_cannot_have_multiple_default_exports_2528", "A module cannot have multiple default exports."),
        Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_functions: diag(2529, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_func_2529", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module containing async functions."),
        Property_0_is_incompatible_with_index_signature: diag(2530, ts2.DiagnosticCategory.Error, "Property_0_is_incompatible_with_index_signature_2530", "Property '{0}' is incompatible with index signature."),
        Object_is_possibly_null: diag(2531, ts2.DiagnosticCategory.Error, "Object_is_possibly_null_2531", "Object is possibly 'null'."),
        Object_is_possibly_undefined: diag(2532, ts2.DiagnosticCategory.Error, "Object_is_possibly_undefined_2532", "Object is possibly 'undefined'."),
        Object_is_possibly_null_or_undefined: diag(2533, ts2.DiagnosticCategory.Error, "Object_is_possibly_null_or_undefined_2533", "Object is possibly 'null' or 'undefined'."),
        A_function_returning_never_cannot_have_a_reachable_end_point: diag(2534, ts2.DiagnosticCategory.Error, "A_function_returning_never_cannot_have_a_reachable_end_point_2534", "A function returning 'never' cannot have a reachable end point."),
        Enum_type_0_has_members_with_initializers_that_are_not_literals: diag(2535, ts2.DiagnosticCategory.Error, "Enum_type_0_has_members_with_initializers_that_are_not_literals_2535", "Enum type '{0}' has members with initializers that are not literals."),
        Type_0_cannot_be_used_to_index_type_1: diag(2536, ts2.DiagnosticCategory.Error, "Type_0_cannot_be_used_to_index_type_1_2536", "Type '{0}' cannot be used to index type '{1}'."),
        Type_0_has_no_matching_index_signature_for_type_1: diag(2537, ts2.DiagnosticCategory.Error, "Type_0_has_no_matching_index_signature_for_type_1_2537", "Type '{0}' has no matching index signature for type '{1}'."),
        Type_0_cannot_be_used_as_an_index_type: diag(2538, ts2.DiagnosticCategory.Error, "Type_0_cannot_be_used_as_an_index_type_2538", "Type '{0}' cannot be used as an index type."),
        Cannot_assign_to_0_because_it_is_not_a_variable: diag(2539, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_not_a_variable_2539", "Cannot assign to '{0}' because it is not a variable."),
        Cannot_assign_to_0_because_it_is_a_read_only_property: diag(2540, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_read_only_property_2540", "Cannot assign to '{0}' because it is a read-only property."),
        The_target_of_an_assignment_must_be_a_variable_or_a_property_access: diag(2541, ts2.DiagnosticCategory.Error, "The_target_of_an_assignment_must_be_a_variable_or_a_property_access_2541", "The target of an assignment must be a variable or a property access."),
        Index_signature_in_type_0_only_permits_reading: diag(2542, ts2.DiagnosticCategory.Error, "Index_signature_in_type_0_only_permits_reading_2542", "Index signature in type '{0}' only permits reading."),
        Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_meta_property_reference: diag(2543, ts2.DiagnosticCategory.Error, "Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_me_2543", "Duplicate identifier '_newTarget'. Compiler uses variable declaration '_newTarget' to capture 'new.target' meta-property reference."),
        Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta_property_reference: diag(2544, ts2.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta__2544", "Expression resolves to variable declaration '_newTarget' that compiler uses to capture 'new.target' meta-property reference."),
        A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any: diag(2545, ts2.DiagnosticCategory.Error, "A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any_2545", "A mixin class must have a constructor with a single rest parameter of type 'any[]'."),
        The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_property: diag(2547, ts2.DiagnosticCategory.Error, "The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_pro_2547", "The type returned by the '{0}()' method of an async iterator must be a promise for a type with a 'value' property."),
        Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2548, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator_2548", "Type '{0}' is not an array type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
        Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2549, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns__2549", "Type '{0}' is not an array type or a string type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
        Property_0_does_not_exist_on_type_1_Did_you_mean_2: diag(2551, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Did_you_mean_2_2551", "Property '{0}' does not exist on type '{1}'. Did you mean '{2}'?"),
        Cannot_find_name_0_Did_you_mean_1: diag(2552, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_1_2552", "Cannot find name '{0}'. Did you mean '{1}'?"),
        Computed_values_are_not_permitted_in_an_enum_with_string_valued_members: diag(2553, ts2.DiagnosticCategory.Error, "Computed_values_are_not_permitted_in_an_enum_with_string_valued_members_2553", "Computed values are not permitted in an enum with string valued members."),
        Expected_0_arguments_but_got_1: diag(2554, ts2.DiagnosticCategory.Error, "Expected_0_arguments_but_got_1_2554", "Expected {0} arguments, but got {1}."),
        Expected_at_least_0_arguments_but_got_1: diag(2555, ts2.DiagnosticCategory.Error, "Expected_at_least_0_arguments_but_got_1_2555", "Expected at least {0} arguments, but got {1}."),
        Expected_0_arguments_but_got_1_or_more: diag(2556, ts2.DiagnosticCategory.Error, "Expected_0_arguments_but_got_1_or_more_2556", "Expected {0} arguments, but got {1} or more."),
        Expected_at_least_0_arguments_but_got_1_or_more: diag(2557, ts2.DiagnosticCategory.Error, "Expected_at_least_0_arguments_but_got_1_or_more_2557", "Expected at least {0} arguments, but got {1} or more."),
        Expected_0_type_arguments_but_got_1: diag(2558, ts2.DiagnosticCategory.Error, "Expected_0_type_arguments_but_got_1_2558", "Expected {0} type arguments, but got {1}."),
        Type_0_has_no_properties_in_common_with_type_1: diag(2559, ts2.DiagnosticCategory.Error, "Type_0_has_no_properties_in_common_with_type_1_2559", "Type '{0}' has no properties in common with type '{1}'."),
        Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it: diag(2560, ts2.DiagnosticCategory.Error, "Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it_2560", "Value of type '{0}' has no properties in common with type '{1}'. Did you mean to call it?"),
        Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_write_2: diag(2561, ts2.DiagnosticCategory.Error, "Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_writ_2561", "Object literal may only specify known properties, but '{0}' does not exist in type '{1}'. Did you mean to write '{2}'?"),
        Base_class_expressions_cannot_reference_class_type_parameters: diag(2562, ts2.DiagnosticCategory.Error, "Base_class_expressions_cannot_reference_class_type_parameters_2562", "Base class expressions cannot reference class type parameters."),
        The_containing_function_or_module_body_is_too_large_for_control_flow_analysis: diag(2563, ts2.DiagnosticCategory.Error, "The_containing_function_or_module_body_is_too_large_for_control_flow_analysis_2563", "The containing function or module body is too large for control flow analysis."),
        Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor: diag(2564, ts2.DiagnosticCategory.Error, "Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor_2564", "Property '{0}' has no initializer and is not definitely assigned in the constructor."),
        Property_0_is_used_before_being_assigned: diag(2565, ts2.DiagnosticCategory.Error, "Property_0_is_used_before_being_assigned_2565", "Property '{0}' is used before being assigned."),
        A_rest_element_cannot_have_a_property_name: diag(2566, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_have_a_property_name_2566", "A rest element cannot have a property name."),
        Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations: diag(2567, ts2.DiagnosticCategory.Error, "Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations_2567", "Enum declarations can only merge with namespace or other enum declarations."),
        Type_0_is_not_an_array_type_or_a_string_type_Use_compiler_option_downlevelIteration_to_allow_iterating_of_iterators: diag(2569, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_Use_compiler_option_downlevelIteration_to_allow_iterati_2569", "Type '{0}' is not an array type or a string type. Use compiler option '--downlevelIteration' to allow iterating of iterators."),
        Object_is_of_type_unknown: diag(2571, ts2.DiagnosticCategory.Error, "Object_is_of_type_unknown_2571", "Object is of type 'unknown'."),
        Rest_signatures_are_incompatible: diag(2572, ts2.DiagnosticCategory.Error, "Rest_signatures_are_incompatible_2572", "Rest signatures are incompatible."),
        Property_0_is_incompatible_with_rest_element_type: diag(2573, ts2.DiagnosticCategory.Error, "Property_0_is_incompatible_with_rest_element_type_2573", "Property '{0}' is incompatible with rest element type."),
        A_rest_element_type_must_be_an_array_type: diag(2574, ts2.DiagnosticCategory.Error, "A_rest_element_type_must_be_an_array_type_2574", "A rest element type must be an array type."),
        No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments: diag(2575, ts2.DiagnosticCategory.Error, "No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments_2575", "No overload expects {0} arguments, but overloads do exist that expect either {1} or {2} arguments."),
        Property_0_is_a_static_member_of_type_1: diag(2576, ts2.DiagnosticCategory.Error, "Property_0_is_a_static_member_of_type_1_2576", "Property '{0}' is a static member of type '{1}'"),
        Return_type_annotation_circularly_references_itself: diag(2577, ts2.DiagnosticCategory.Error, "Return_type_annotation_circularly_references_itself_2577", "Return type annotation circularly references itself."),
        Unused_ts_expect_error_directive: diag(2578, ts2.DiagnosticCategory.Error, "Unused_ts_expect_error_directive_2578", "Unused '@ts-expect-error' directive."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_types_Slashnode: diag(2580, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_types_Slashnode_2580", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i @types/node`."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_types_Slashjquery: diag(2581, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_types_Slashjquery_2581", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i @types/jquery`."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_types_Slashjest_or_npm_i_types_Slashmocha: diag(2582, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_types_Slashje_2582", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i @types/jest` or `npm i @types/mocha`."),
        Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_es2015_or_later: diag(2583, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2583", "Cannot find name '{0}'. Do you need to change your target library? Try changing the `lib` compiler option to es2015 or later."),
        Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_include_dom: diag(2584, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2584", "Cannot find name '{0}'. Do you need to change your target library? Try changing the `lib` compiler option to include 'dom'."),
        _0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_es2015_or_later: diag(2585, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_2585", "'{0}' only refers to a type, but is being used as a value here. Do you need to change your target library? Try changing the `lib` compiler option to es2015 or later."),
        Enum_type_0_circularly_references_itself: diag(2586, ts2.DiagnosticCategory.Error, "Enum_type_0_circularly_references_itself_2586", "Enum type '{0}' circularly references itself."),
        JSDoc_type_0_circularly_references_itself: diag(2587, ts2.DiagnosticCategory.Error, "JSDoc_type_0_circularly_references_itself_2587", "JSDoc type '{0}' circularly references itself."),
        Cannot_assign_to_0_because_it_is_a_constant: diag(2588, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_constant_2588", "Cannot assign to '{0}' because it is a constant."),
        Type_instantiation_is_excessively_deep_and_possibly_infinite: diag(2589, ts2.DiagnosticCategory.Error, "Type_instantiation_is_excessively_deep_and_possibly_infinite_2589", "Type instantiation is excessively deep and possibly infinite."),
        Expression_produces_a_union_type_that_is_too_complex_to_represent: diag(2590, ts2.DiagnosticCategory.Error, "Expression_produces_a_union_type_that_is_too_complex_to_represent_2590", "Expression produces a union type that is too complex to represent."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_types_Slashnode_and_then_add_node_to_the_types_field_in_your_tsconfig: diag(2591, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_types_Slashnode_and_th_2591", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i @types/node` and then add `node` to the types field in your tsconfig."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_types_Slashjquery_and_then_add_jquery_to_the_types_field_in_your_tsconfig: diag(2592, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_types_Slashjquery_an_2592", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i @types/jquery` and then add `jquery` to the types field in your tsconfig."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_types_Slashjest_or_npm_i_types_Slashmocha_and_then_add_jest_or_mocha_to_the_types_field_in_your_tsconfig: diag(2593, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_types_Slashje_2593", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i @types/jest` or `npm i @types/mocha` and then add `jest` or `mocha` to the types field in your tsconfig."),
        This_module_is_declared_with_using_export_and_can_only_be_used_with_a_default_import_when_using_the_0_flag: diag(2594, ts2.DiagnosticCategory.Error, "This_module_is_declared_with_using_export_and_can_only_be_used_with_a_default_import_when_using_the__2594", "This module is declared with using 'export =', and can only be used with a default import when using the '{0}' flag."),
        _0_can_only_be_imported_by_using_a_default_import: diag(2595, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_default_import_2595", "'{0}' can only be imported by using a default import."),
        _0_can_only_be_imported_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2596, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import_2596", "'{0}' can only be imported by turning on the 'esModuleInterop' flag and using a default import."),
        _0_can_only_be_imported_by_using_a_require_call_or_by_using_a_default_import: diag(2597, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_require_call_or_by_using_a_default_import_2597", "'{0}' can only be imported by using a 'require' call or by using a default import."),
        _0_can_only_be_imported_by_using_a_require_call_or_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2598, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_require_call_or_by_turning_on_the_esModuleInterop_flag_and_using__2598", "'{0}' can only be imported by using a 'require' call or by turning on the 'esModuleInterop' flag and using a default import."),
        JSX_element_attributes_type_0_may_not_be_a_union_type: diag(2600, ts2.DiagnosticCategory.Error, "JSX_element_attributes_type_0_may_not_be_a_union_type_2600", "JSX element attributes type '{0}' may not be a union type."),
        The_return_type_of_a_JSX_element_constructor_must_return_an_object_type: diag(2601, ts2.DiagnosticCategory.Error, "The_return_type_of_a_JSX_element_constructor_must_return_an_object_type_2601", "The return type of a JSX element constructor must return an object type."),
        JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist: diag(2602, ts2.DiagnosticCategory.Error, "JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist_2602", "JSX element implicitly has type 'any' because the global type 'JSX.Element' does not exist."),
        Property_0_in_type_1_is_not_assignable_to_type_2: diag(2603, ts2.DiagnosticCategory.Error, "Property_0_in_type_1_is_not_assignable_to_type_2_2603", "Property '{0}' in type '{1}' is not assignable to type '{2}'."),
        JSX_element_type_0_does_not_have_any_construct_or_call_signatures: diag(2604, ts2.DiagnosticCategory.Error, "JSX_element_type_0_does_not_have_any_construct_or_call_signatures_2604", "JSX element type '{0}' does not have any construct or call signatures."),
        JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements: diag(2605, ts2.DiagnosticCategory.Error, "JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements_2605", "JSX element type '{0}' is not a constructor function for JSX elements."),
        Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property: diag(2606, ts2.DiagnosticCategory.Error, "Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property_2606", "Property '{0}' of JSX spread attribute is not assignable to target property."),
        JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property: diag(2607, ts2.DiagnosticCategory.Error, "JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property_2607", "JSX element class does not support attributes because it does not have a '{0}' property."),
        The_global_type_JSX_0_may_not_have_more_than_one_property: diag(2608, ts2.DiagnosticCategory.Error, "The_global_type_JSX_0_may_not_have_more_than_one_property_2608", "The global type 'JSX.{0}' may not have more than one property."),
        JSX_spread_child_must_be_an_array_type: diag(2609, ts2.DiagnosticCategory.Error, "JSX_spread_child_must_be_an_array_type_2609", "JSX spread child must be an array type."),
        _0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property: diag(2610, ts2.DiagnosticCategory.Error, "_0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property_2610", "'{0}' is defined as an accessor in class '{1}', but is overridden here in '{2}' as an instance property."),
        _0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor: diag(2611, ts2.DiagnosticCategory.Error, "_0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor_2611", "'{0}' is defined as a property in class '{1}', but is overridden here in '{2}' as an accessor."),
        Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_add_a_declare_modifier_or_remove_the_redundant_declaration: diag(2612, ts2.DiagnosticCategory.Error, "Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_2612", "Property '{0}' will overwrite the base property in '{1}'. If this is intentional, add an initializer. Otherwise, add a 'declare' modifier or remove the redundant declaration."),
        Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead: diag(2613, ts2.DiagnosticCategory.Error, "Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead_2613", "Module '{0}' has no default export. Did you mean to use 'import { {1} } from {0}' instead?"),
        Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead: diag(2614, ts2.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead_2614", "Module '{0}' has no exported member '{1}'. Did you mean to use 'import {1} from {0}' instead?"),
        Type_of_property_0_circularly_references_itself_in_mapped_type_1: diag(2615, ts2.DiagnosticCategory.Error, "Type_of_property_0_circularly_references_itself_in_mapped_type_1_2615", "Type of property '{0}' circularly references itself in mapped type '{1}'."),
        _0_can_only_be_imported_by_using_import_1_require_2_or_a_default_import: diag(2616, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_import_1_require_2_or_a_default_import_2616", "'{0}' can only be imported by using 'import {1} = require({2})' or a default import."),
        _0_can_only_be_imported_by_using_import_1_require_2_or_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2617, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_import_1_require_2_or_by_turning_on_the_esModuleInterop_flag_and_us_2617", "'{0}' can only be imported by using 'import {1} = require({2})' or by turning on the 'esModuleInterop' flag and using a default import."),
        Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity: diag(2649, ts2.DiagnosticCategory.Error, "Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity_2649", "Cannot augment module '{0}' with value exports because it resolves to a non-module entity."),
        A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_members_defined_in_other_enums: diag(2651, ts2.DiagnosticCategory.Error, "A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_memb_2651", "A member initializer in a enum declaration cannot reference members declared after it, including members defined in other enums."),
        Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_default_0_declaration_instead: diag(2652, ts2.DiagnosticCategory.Error, "Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_d_2652", "Merged declaration '{0}' cannot include a default export declaration. Consider adding a separate 'export default {0}' declaration instead."),
        Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1: diag(2653, ts2.DiagnosticCategory.Error, "Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1_2653", "Non-abstract class expression does not implement inherited abstract member '{0}' from class '{1}'."),
        Exported_external_package_typings_file_cannot_contain_tripleslash_references_Please_contact_the_package_author_to_update_the_package_definition: diag(2654, ts2.DiagnosticCategory.Error, "Exported_external_package_typings_file_cannot_contain_tripleslash_references_Please_contact_the_pack_2654", "Exported external package typings file cannot contain tripleslash references. Please contact the package author to update the package definition."),
        Exported_external_package_typings_file_0_is_not_a_module_Please_contact_the_package_author_to_update_the_package_definition: diag(2656, ts2.DiagnosticCategory.Error, "Exported_external_package_typings_file_0_is_not_a_module_Please_contact_the_package_author_to_update_2656", "Exported external package typings file '{0}' is not a module. Please contact the package author to update the package definition."),
        JSX_expressions_must_have_one_parent_element: diag(2657, ts2.DiagnosticCategory.Error, "JSX_expressions_must_have_one_parent_element_2657", "JSX expressions must have one parent element."),
        Type_0_provides_no_match_for_the_signature_1: diag(2658, ts2.DiagnosticCategory.Error, "Type_0_provides_no_match_for_the_signature_1_2658", "Type '{0}' provides no match for the signature '{1}'."),
        super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_higher: diag(2659, ts2.DiagnosticCategory.Error, "super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_highe_2659", "'super' is only allowed in members of object literal expressions when option 'target' is 'ES2015' or higher."),
        super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions: diag(2660, ts2.DiagnosticCategory.Error, "super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions_2660", "'super' can only be referenced in members of derived classes or object literal expressions."),
        Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module: diag(2661, ts2.DiagnosticCategory.Error, "Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module_2661", "Cannot export '{0}'. Only local declarations can be exported from a module."),
        Cannot_find_name_0_Did_you_mean_the_static_member_1_0: diag(2662, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_the_static_member_1_0_2662", "Cannot find name '{0}'. Did you mean the static member '{1}.{0}'?"),
        Cannot_find_name_0_Did_you_mean_the_instance_member_this_0: diag(2663, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_the_instance_member_this_0_2663", "Cannot find name '{0}'. Did you mean the instance member 'this.{0}'?"),
        Invalid_module_name_in_augmentation_module_0_cannot_be_found: diag(2664, ts2.DiagnosticCategory.Error, "Invalid_module_name_in_augmentation_module_0_cannot_be_found_2664", "Invalid module name in augmentation, module '{0}' cannot be found."),
        Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augmented: diag(2665, ts2.DiagnosticCategory.Error, "Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augm_2665", "Invalid module name in augmentation. Module '{0}' resolves to an untyped module at '{1}', which cannot be augmented."),
        Exports_and_export_assignments_are_not_permitted_in_module_augmentations: diag(2666, ts2.DiagnosticCategory.Error, "Exports_and_export_assignments_are_not_permitted_in_module_augmentations_2666", "Exports and export assignments are not permitted in module augmentations."),
        Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_module: diag(2667, ts2.DiagnosticCategory.Error, "Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_mod_2667", "Imports are not permitted in module augmentations. Consider moving them to the enclosing external module."),
        export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always_visible: diag(2668, ts2.DiagnosticCategory.Error, "export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always__2668", "'export' modifier cannot be applied to ambient modules and module augmentations since they are always visible."),
        Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_declarations: diag(2669, ts2.DiagnosticCategory.Error, "Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_2669", "Augmentations for the global scope can only be directly nested in external modules or ambient module declarations."),
        Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambient_context: diag(2670, ts2.DiagnosticCategory.Error, "Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambien_2670", "Augmentations for the global scope should have 'declare' modifier unless they appear in already ambient context."),
        Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity: diag(2671, ts2.DiagnosticCategory.Error, "Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity_2671", "Cannot augment module '{0}' because it resolves to a non-module entity."),
        Cannot_assign_a_0_constructor_type_to_a_1_constructor_type: diag(2672, ts2.DiagnosticCategory.Error, "Cannot_assign_a_0_constructor_type_to_a_1_constructor_type_2672", "Cannot assign a '{0}' constructor type to a '{1}' constructor type."),
        Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration: diag(2673, ts2.DiagnosticCategory.Error, "Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration_2673", "Constructor of class '{0}' is private and only accessible within the class declaration."),
        Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration: diag(2674, ts2.DiagnosticCategory.Error, "Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration_2674", "Constructor of class '{0}' is protected and only accessible within the class declaration."),
        Cannot_extend_a_class_0_Class_constructor_is_marked_as_private: diag(2675, ts2.DiagnosticCategory.Error, "Cannot_extend_a_class_0_Class_constructor_is_marked_as_private_2675", "Cannot extend a class '{0}'. Class constructor is marked as private."),
        Accessors_must_both_be_abstract_or_non_abstract: diag(2676, ts2.DiagnosticCategory.Error, "Accessors_must_both_be_abstract_or_non_abstract_2676", "Accessors must both be abstract or non-abstract."),
        A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type: diag(2677, ts2.DiagnosticCategory.Error, "A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type_2677", "A type predicate's type must be assignable to its parameter's type."),
        Type_0_is_not_comparable_to_type_1: diag(2678, ts2.DiagnosticCategory.Error, "Type_0_is_not_comparable_to_type_1_2678", "Type '{0}' is not comparable to type '{1}'."),
        A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void: diag(2679, ts2.DiagnosticCategory.Error, "A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void_2679", "A function that is called with the 'new' keyword cannot have a 'this' type that is 'void'."),
        A_0_parameter_must_be_the_first_parameter: diag(2680, ts2.DiagnosticCategory.Error, "A_0_parameter_must_be_the_first_parameter_2680", "A '{0}' parameter must be the first parameter."),
        A_constructor_cannot_have_a_this_parameter: diag(2681, ts2.DiagnosticCategory.Error, "A_constructor_cannot_have_a_this_parameter_2681", "A constructor cannot have a 'this' parameter."),
        get_and_set_accessor_must_have_the_same_this_type: diag(2682, ts2.DiagnosticCategory.Error, "get_and_set_accessor_must_have_the_same_this_type_2682", "'get' and 'set' accessor must have the same 'this' type."),
        this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation: diag(2683, ts2.DiagnosticCategory.Error, "this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_2683", "'this' implicitly has type 'any' because it does not have a type annotation."),
        The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1: diag(2684, ts2.DiagnosticCategory.Error, "The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1_2684", "The 'this' context of type '{0}' is not assignable to method's 'this' of type '{1}'."),
        The_this_types_of_each_signature_are_incompatible: diag(2685, ts2.DiagnosticCategory.Error, "The_this_types_of_each_signature_are_incompatible_2685", "The 'this' types of each signature are incompatible."),
        _0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead: diag(2686, ts2.DiagnosticCategory.Error, "_0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead_2686", "'{0}' refers to a UMD global, but the current file is a module. Consider adding an import instead."),
        All_declarations_of_0_must_have_identical_modifiers: diag(2687, ts2.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_modifiers_2687", "All declarations of '{0}' must have identical modifiers."),
        Cannot_find_type_definition_file_for_0: diag(2688, ts2.DiagnosticCategory.Error, "Cannot_find_type_definition_file_for_0_2688", "Cannot find type definition file for '{0}'."),
        Cannot_extend_an_interface_0_Did_you_mean_implements: diag(2689, ts2.DiagnosticCategory.Error, "Cannot_extend_an_interface_0_Did_you_mean_implements_2689", "Cannot extend an interface '{0}'. Did you mean 'implements'?"),
        An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead: diag(2691, ts2.DiagnosticCategory.Error, "An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead_2691", "An import path cannot end with a '{0}' extension. Consider importing '{1}' instead."),
        _0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible: diag(2692, ts2.DiagnosticCategory.Error, "_0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible_2692", "'{0}' is a primitive, but '{1}' is a wrapper object. Prefer using '{0}' when possible."),
        _0_only_refers_to_a_type_but_is_being_used_as_a_value_here: diag(2693, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_2693", "'{0}' only refers to a type, but is being used as a value here."),
        Namespace_0_has_no_exported_member_1: diag(2694, ts2.DiagnosticCategory.Error, "Namespace_0_has_no_exported_member_1_2694", "Namespace '{0}' has no exported member '{1}'."),
        Left_side_of_comma_operator_is_unused_and_has_no_side_effects: diag(2695, ts2.DiagnosticCategory.Error, "Left_side_of_comma_operator_is_unused_and_has_no_side_effects_2695", "Left side of comma operator is unused and has no side effects.", true),
        The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead: diag(2696, ts2.DiagnosticCategory.Error, "The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead_2696", "The 'Object' type is assignable to very few other types. Did you mean to use the 'any' type instead?"),
        An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2697, ts2.DiagnosticCategory.Error, "An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_in_2697", "An async function or method must return a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your `--lib` option."),
        Spread_types_may_only_be_created_from_object_types: diag(2698, ts2.DiagnosticCategory.Error, "Spread_types_may_only_be_created_from_object_types_2698", "Spread types may only be created from object types."),
        Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1: diag(2699, ts2.DiagnosticCategory.Error, "Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1_2699", "Static property '{0}' conflicts with built-in property 'Function.{0}' of constructor function '{1}'."),
        Rest_types_may_only_be_created_from_object_types: diag(2700, ts2.DiagnosticCategory.Error, "Rest_types_may_only_be_created_from_object_types_2700", "Rest types may only be created from object types."),
        The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access: diag(2701, ts2.DiagnosticCategory.Error, "The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access_2701", "The target of an object rest assignment must be a variable or a property access."),
        _0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here: diag(2702, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here_2702", "'{0}' only refers to a type, but is being used as a namespace here."),
        The_operand_of_a_delete_operator_must_be_a_property_reference: diag(2703, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_must_be_a_property_reference_2703", "The operand of a 'delete' operator must be a property reference."),
        The_operand_of_a_delete_operator_cannot_be_a_read_only_property: diag(2704, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_cannot_be_a_read_only_property_2704", "The operand of a 'delete' operator cannot be a read-only property."),
        An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2705, ts2.DiagnosticCategory.Error, "An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_de_2705", "An async function or method in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your `--lib` option."),
        Required_type_parameters_may_not_follow_optional_type_parameters: diag(2706, ts2.DiagnosticCategory.Error, "Required_type_parameters_may_not_follow_optional_type_parameters_2706", "Required type parameters may not follow optional type parameters."),
        Generic_type_0_requires_between_1_and_2_type_arguments: diag(2707, ts2.DiagnosticCategory.Error, "Generic_type_0_requires_between_1_and_2_type_arguments_2707", "Generic type '{0}' requires between {1} and {2} type arguments."),
        Cannot_use_namespace_0_as_a_value: diag(2708, ts2.DiagnosticCategory.Error, "Cannot_use_namespace_0_as_a_value_2708", "Cannot use namespace '{0}' as a value."),
        Cannot_use_namespace_0_as_a_type: diag(2709, ts2.DiagnosticCategory.Error, "Cannot_use_namespace_0_as_a_type_2709", "Cannot use namespace '{0}' as a type."),
        _0_are_specified_twice_The_attribute_named_0_will_be_overwritten: diag(2710, ts2.DiagnosticCategory.Error, "_0_are_specified_twice_The_attribute_named_0_will_be_overwritten_2710", "'{0}' are specified twice. The attribute named '{0}' will be overwritten."),
        A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2711, ts2.DiagnosticCategory.Error, "A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES20_2711", "A dynamic import call returns a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your `--lib` option."),
        A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2712, ts2.DiagnosticCategory.Error, "A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declarat_2712", "A dynamic import call in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your `--lib` option."),
        Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_property_1_in_0_with_0_1: diag(2713, ts2.DiagnosticCategory.Error, "Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_p_2713", `Cannot access '{0}.{1}' because '{0}' is a type, but not a namespace. Did you mean to retrieve the type of the property '{1}' in '{0}' with '{0}["{1}"]'?`),
        The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context: diag(2714, ts2.DiagnosticCategory.Error, "The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context_2714", "The expression of an export assignment must be an identifier or qualified name in an ambient context."),
        Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor: diag(2715, ts2.DiagnosticCategory.Error, "Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor_2715", "Abstract property '{0}' in class '{1}' cannot be accessed in the constructor."),
        Type_parameter_0_has_a_circular_default: diag(2716, ts2.DiagnosticCategory.Error, "Type_parameter_0_has_a_circular_default_2716", "Type parameter '{0}' has a circular default."),
        Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_type_2: diag(2717, ts2.DiagnosticCategory.Error, "Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_t_2717", "Subsequent property declarations must have the same type.  Property '{0}' must be of type '{1}', but here has type '{2}'."),
        Duplicate_property_0: diag(2718, ts2.DiagnosticCategory.Error, "Duplicate_property_0_2718", "Duplicate property '{0}'."),
        Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated: diag(2719, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated_2719", "Type '{0}' is not assignable to type '{1}'. Two different types with this name exist, but they are unrelated."),
        Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclass: diag(2720, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclas_2720", "Class '{0}' incorrectly implements class '{1}'. Did you mean to extend '{1}' and inherit its members as a subclass?"),
        Cannot_invoke_an_object_which_is_possibly_null: diag(2721, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_null_2721", "Cannot invoke an object which is possibly 'null'."),
        Cannot_invoke_an_object_which_is_possibly_undefined: diag(2722, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_undefined_2722", "Cannot invoke an object which is possibly 'undefined'."),
        Cannot_invoke_an_object_which_is_possibly_null_or_undefined: diag(2723, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_null_or_undefined_2723", "Cannot invoke an object which is possibly 'null' or 'undefined'."),
        Module_0_has_no_exported_member_1_Did_you_mean_2: diag(2724, ts2.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_Did_you_mean_2_2724", "Module '{0}' has no exported member '{1}'. Did you mean '{2}'?"),
        Class_name_cannot_be_Object_when_targeting_ES5_with_module_0: diag(2725, ts2.DiagnosticCategory.Error, "Class_name_cannot_be_Object_when_targeting_ES5_with_module_0_2725", "Class name cannot be 'Object' when targeting ES5 with module {0}."),
        Cannot_find_lib_definition_for_0: diag(2726, ts2.DiagnosticCategory.Error, "Cannot_find_lib_definition_for_0_2726", "Cannot find lib definition for '{0}'."),
        Cannot_find_lib_definition_for_0_Did_you_mean_1: diag(2727, ts2.DiagnosticCategory.Error, "Cannot_find_lib_definition_for_0_Did_you_mean_1_2727", "Cannot find lib definition for '{0}'. Did you mean '{1}'?"),
        _0_is_declared_here: diag(2728, ts2.DiagnosticCategory.Message, "_0_is_declared_here_2728", "'{0}' is declared here."),
        Property_0_is_used_before_its_initialization: diag(2729, ts2.DiagnosticCategory.Error, "Property_0_is_used_before_its_initialization_2729", "Property '{0}' is used before its initialization."),
        An_arrow_function_cannot_have_a_this_parameter: diag(2730, ts2.DiagnosticCategory.Error, "An_arrow_function_cannot_have_a_this_parameter_2730", "An arrow function cannot have a 'this' parameter."),
        Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_in_String: diag(2731, ts2.DiagnosticCategory.Error, "Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_i_2731", "Implicit conversion of a 'symbol' to a 'string' will fail at runtime. Consider wrapping this expression in 'String(...)'."),
        Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension: diag(2732, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension_2732", "Cannot find module '{0}'. Consider using '--resolveJsonModule' to import module with '.json' extension"),
        Property_0_was_also_declared_here: diag(2733, ts2.DiagnosticCategory.Error, "Property_0_was_also_declared_here_2733", "Property '{0}' was also declared here."),
        Are_you_missing_a_semicolon: diag(2734, ts2.DiagnosticCategory.Error, "Are_you_missing_a_semicolon_2734", "Are you missing a semicolon?"),
        Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1: diag(2735, ts2.DiagnosticCategory.Error, "Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1_2735", "Did you mean for '{0}' to be constrained to type 'new (...args: any[]) => {1}'?"),
        Operator_0_cannot_be_applied_to_type_1: diag(2736, ts2.DiagnosticCategory.Error, "Operator_0_cannot_be_applied_to_type_1_2736", "Operator '{0}' cannot be applied to type '{1}'."),
        BigInt_literals_are_not_available_when_targeting_lower_than_ES2020: diag(2737, ts2.DiagnosticCategory.Error, "BigInt_literals_are_not_available_when_targeting_lower_than_ES2020_2737", "BigInt literals are not available when targeting lower than ES2020."),
        An_outer_value_of_this_is_shadowed_by_this_container: diag(2738, ts2.DiagnosticCategory.Message, "An_outer_value_of_this_is_shadowed_by_this_container_2738", "An outer value of 'this' is shadowed by this container."),
        Type_0_is_missing_the_following_properties_from_type_1_Colon_2: diag(2739, ts2.DiagnosticCategory.Error, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_2739", "Type '{0}' is missing the following properties from type '{1}': {2}"),
        Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more: diag(2740, ts2.DiagnosticCategory.Error, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more_2740", "Type '{0}' is missing the following properties from type '{1}': {2}, and {3} more."),
        Property_0_is_missing_in_type_1_but_required_in_type_2: diag(2741, ts2.DiagnosticCategory.Error, "Property_0_is_missing_in_type_1_but_required_in_type_2_2741", "Property '{0}' is missing in type '{1}' but required in type '{2}'."),
        The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_annotation_is_necessary: diag(2742, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_a_2742", "The inferred type of '{0}' cannot be named without a reference to '{1}'. This is likely not portable. A type annotation is necessary."),
        No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments: diag(2743, ts2.DiagnosticCategory.Error, "No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments_2743", "No overload expects {0} type arguments, but overloads do exist that expect either {1} or {2} type arguments."),
        Type_parameter_defaults_can_only_reference_previously_declared_type_parameters: diag(2744, ts2.DiagnosticCategory.Error, "Type_parameter_defaults_can_only_reference_previously_declared_type_parameters_2744", "Type parameter defaults can only reference previously declared type parameters."),
        This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_provided: diag(2745, ts2.DiagnosticCategory.Error, "This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_pr_2745", "This JSX tag's '{0}' prop expects type '{1}' which requires multiple children, but only a single child was provided."),
        This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided: diag(2746, ts2.DiagnosticCategory.Error, "This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided_2746", "This JSX tag's '{0}' prop expects a single child of type '{1}', but multiple children were provided."),
        _0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_type_of_1_is_2: diag(2747, ts2.DiagnosticCategory.Error, "_0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_t_2747", "'{0}' components don't accept text as child elements. Text in JSX has the type 'string', but the expected type of '{1}' is '{2}'."),
        Cannot_access_ambient_const_enums_when_the_isolatedModules_flag_is_provided: diag(2748, ts2.DiagnosticCategory.Error, "Cannot_access_ambient_const_enums_when_the_isolatedModules_flag_is_provided_2748", "Cannot access ambient const enums when the '--isolatedModules' flag is provided."),
        _0_refers_to_a_value_but_is_being_used_as_a_type_here_Did_you_mean_typeof_0: diag(2749, ts2.DiagnosticCategory.Error, "_0_refers_to_a_value_but_is_being_used_as_a_type_here_Did_you_mean_typeof_0_2749", "'{0}' refers to a value, but is being used as a type here. Did you mean 'typeof {0}'?"),
        The_implementation_signature_is_declared_here: diag(2750, ts2.DiagnosticCategory.Error, "The_implementation_signature_is_declared_here_2750", "The implementation signature is declared here."),
        Circularity_originates_in_type_at_this_location: diag(2751, ts2.DiagnosticCategory.Error, "Circularity_originates_in_type_at_this_location_2751", "Circularity originates in type at this location."),
        The_first_export_default_is_here: diag(2752, ts2.DiagnosticCategory.Error, "The_first_export_default_is_here_2752", "The first export default is here."),
        Another_export_default_is_here: diag(2753, ts2.DiagnosticCategory.Error, "Another_export_default_is_here_2753", "Another export default is here."),
        super_may_not_use_type_arguments: diag(2754, ts2.DiagnosticCategory.Error, "super_may_not_use_type_arguments_2754", "'super' may not use type arguments."),
        No_constituent_of_type_0_is_callable: diag(2755, ts2.DiagnosticCategory.Error, "No_constituent_of_type_0_is_callable_2755", "No constituent of type '{0}' is callable."),
        Not_all_constituents_of_type_0_are_callable: diag(2756, ts2.DiagnosticCategory.Error, "Not_all_constituents_of_type_0_are_callable_2756", "Not all constituents of type '{0}' are callable."),
        Type_0_has_no_call_signatures: diag(2757, ts2.DiagnosticCategory.Error, "Type_0_has_no_call_signatures_2757", "Type '{0}' has no call signatures."),
        Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2758, ts2.DiagnosticCategory.Error, "Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_2758", "Each member of the union type '{0}' has signatures, but none of those signatures are compatible with each other."),
        No_constituent_of_type_0_is_constructable: diag(2759, ts2.DiagnosticCategory.Error, "No_constituent_of_type_0_is_constructable_2759", "No constituent of type '{0}' is constructable."),
        Not_all_constituents_of_type_0_are_constructable: diag(2760, ts2.DiagnosticCategory.Error, "Not_all_constituents_of_type_0_are_constructable_2760", "Not all constituents of type '{0}' are constructable."),
        Type_0_has_no_construct_signatures: diag(2761, ts2.DiagnosticCategory.Error, "Type_0_has_no_construct_signatures_2761", "Type '{0}' has no construct signatures."),
        Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2762, ts2.DiagnosticCategory.Error, "Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_2762", "Each member of the union type '{0}' has construct signatures, but none of those signatures are compatible with each other."),
        Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_send_0: diag(2763, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_s_2763", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but for-of will always send '{0}'."),
        Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_always_send_0: diag(2764, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_al_2764", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array spread will always send '{0}'."),
        Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring_will_always_send_0: diag(2765, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring__2765", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array destructuring will always send '{0}'."),
        Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_containing_generator_will_always_send_0: diag(2766, ts2.DiagnosticCategory.Error, "Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_co_2766", "Cannot delegate iteration to value because the 'next' method of its iterator expects type '{1}', but the containing generator will always send '{0}'."),
        The_0_property_of_an_iterator_must_be_a_method: diag(2767, ts2.DiagnosticCategory.Error, "The_0_property_of_an_iterator_must_be_a_method_2767", "The '{0}' property of an iterator must be a method."),
        The_0_property_of_an_async_iterator_must_be_a_method: diag(2768, ts2.DiagnosticCategory.Error, "The_0_property_of_an_async_iterator_must_be_a_method_2768", "The '{0}' property of an async iterator must be a method."),
        No_overload_matches_this_call: diag(2769, ts2.DiagnosticCategory.Error, "No_overload_matches_this_call_2769", "No overload matches this call."),
        The_last_overload_gave_the_following_error: diag(2770, ts2.DiagnosticCategory.Error, "The_last_overload_gave_the_following_error_2770", "The last overload gave the following error."),
        The_last_overload_is_declared_here: diag(2771, ts2.DiagnosticCategory.Error, "The_last_overload_is_declared_here_2771", "The last overload is declared here."),
        Overload_0_of_1_2_gave_the_following_error: diag(2772, ts2.DiagnosticCategory.Error, "Overload_0_of_1_2_gave_the_following_error_2772", "Overload {0} of {1}, '{2}', gave the following error."),
        Did_you_forget_to_use_await: diag(2773, ts2.DiagnosticCategory.Error, "Did_you_forget_to_use_await_2773", "Did you forget to use 'await'?"),
        This_condition_will_always_return_true_since_the_function_is_always_defined_Did_you_mean_to_call_it_instead: diag(2774, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_true_since_the_function_is_always_defined_Did_you_mean_to_call_it__2774", "This condition will always return true since the function is always defined. Did you mean to call it instead?"),
        Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation: diag(2775, ts2.DiagnosticCategory.Error, "Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation_2775", "Assertions require every name in the call target to be declared with an explicit type annotation."),
        Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name: diag(2776, ts2.DiagnosticCategory.Error, "Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name_2776", "Assertions require the call target to be an identifier or qualified name."),
        The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access: diag(2777, ts2.DiagnosticCategory.Error, "The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access_2777", "The operand of an increment or decrement operator may not be an optional property access."),
        The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access: diag(2778, ts2.DiagnosticCategory.Error, "The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access_2778", "The target of an object rest assignment may not be an optional property access."),
        The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access: diag(2779, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access_2779", "The left-hand side of an assignment expression may not be an optional property access."),
        The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access: diag(2780, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access_2780", "The left-hand side of a 'for...in' statement may not be an optional property access."),
        The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access: diag(2781, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access_2781", "The left-hand side of a 'for...of' statement may not be an optional property access."),
        _0_needs_an_explicit_type_annotation: diag(2782, ts2.DiagnosticCategory.Message, "_0_needs_an_explicit_type_annotation_2782", "'{0}' needs an explicit type annotation."),
        _0_is_specified_more_than_once_so_this_usage_will_be_overwritten: diag(2783, ts2.DiagnosticCategory.Error, "_0_is_specified_more_than_once_so_this_usage_will_be_overwritten_2783", "'{0}' is specified more than once, so this usage will be overwritten."),
        get_and_set_accessors_cannot_declare_this_parameters: diag(2784, ts2.DiagnosticCategory.Error, "get_and_set_accessors_cannot_declare_this_parameters_2784", "'get' and 'set' accessors cannot declare 'this' parameters."),
        This_spread_always_overwrites_this_property: diag(2785, ts2.DiagnosticCategory.Error, "This_spread_always_overwrites_this_property_2785", "This spread always overwrites this property."),
        _0_cannot_be_used_as_a_JSX_component: diag(2786, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_JSX_component_2786", "'{0}' cannot be used as a JSX component."),
        Its_return_type_0_is_not_a_valid_JSX_element: diag(2787, ts2.DiagnosticCategory.Error, "Its_return_type_0_is_not_a_valid_JSX_element_2787", "Its return type '{0}' is not a valid JSX element."),
        Its_instance_type_0_is_not_a_valid_JSX_element: diag(2788, ts2.DiagnosticCategory.Error, "Its_instance_type_0_is_not_a_valid_JSX_element_2788", "Its instance type '{0}' is not a valid JSX element."),
        Its_element_type_0_is_not_a_valid_JSX_element: diag(2789, ts2.DiagnosticCategory.Error, "Its_element_type_0_is_not_a_valid_JSX_element_2789", "Its element type '{0}' is not a valid JSX element."),
        Import_declaration_0_is_using_private_name_1: diag(4e3, ts2.DiagnosticCategory.Error, "Import_declaration_0_is_using_private_name_1_4000", "Import declaration '{0}' is using private name '{1}'."),
        Type_parameter_0_of_exported_class_has_or_is_using_private_name_1: diag(4002, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_class_has_or_is_using_private_name_1_4002", "Type parameter '{0}' of exported class has or is using private name '{1}'."),
        Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1: diag(4004, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1_4004", "Type parameter '{0}' of exported interface has or is using private name '{1}'."),
        Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4006, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4006", "Type parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
        Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4008, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4008", "Type parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
        Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4010, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4010", "Type parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
        Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4012, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4012", "Type parameter '{0}' of public method from exported class has or is using private name '{1}'."),
        Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4014, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4014", "Type parameter '{0}' of method from exported interface has or is using private name '{1}'."),
        Type_parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4016, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_function_has_or_is_using_private_name_1_4016", "Type parameter '{0}' of exported function has or is using private name '{1}'."),
        Implements_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4019, ts2.DiagnosticCategory.Error, "Implements_clause_of_exported_class_0_has_or_is_using_private_name_1_4019", "Implements clause of exported class '{0}' has or is using private name '{1}'."),
        extends_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4020, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_class_0_has_or_is_using_private_name_1_4020", "'extends' clause of exported class '{0}' has or is using private name '{1}'."),
        extends_clause_of_exported_interface_0_has_or_is_using_private_name_1: diag(4022, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_interface_0_has_or_is_using_private_name_1_4022", "'extends' clause of exported interface '{0}' has or is using private name '{1}'."),
        Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4023, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4023", "Exported variable '{0}' has or is using name '{1}' from external module {2} but cannot be named."),
        Exported_variable_0_has_or_is_using_name_1_from_private_module_2: diag(4024, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_name_1_from_private_module_2_4024", "Exported variable '{0}' has or is using name '{1}' from private module '{2}'."),
        Exported_variable_0_has_or_is_using_private_name_1: diag(4025, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_private_name_1_4025", "Exported variable '{0}' has or is using private name '{1}'."),
        Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4026, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot__4026", "Public static property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4027, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4027", "Public static property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
        Public_static_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4028, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_private_name_1_4028", "Public static property '{0}' of exported class has or is using private name '{1}'."),
        Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4029, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_name_4029", "Public property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4030, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4030", "Public property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
        Public_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4031, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_private_name_1_4031", "Public property '{0}' of exported class has or is using private name '{1}'."),
        Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4032, ts2.DiagnosticCategory.Error, "Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4032", "Property '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
        Property_0_of_exported_interface_has_or_is_using_private_name_1: diag(4033, ts2.DiagnosticCategory.Error, "Property_0_of_exported_interface_has_or_is_using_private_name_1_4033", "Property '{0}' of exported interface has or is using private name '{1}'."),
        Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4034, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_mod_4034", "Parameter type of public static setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
        Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4035, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1_4035", "Parameter type of public static setter '{0}' from exported class has or is using private name '{1}'."),
        Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4036, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4036", "Parameter type of public setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
        Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4037, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1_4037", "Parameter type of public setter '{0}' from exported class has or is using private name '{1}'."),
        Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4038, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_modul_4038", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4039, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_4039", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
        Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4040, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1_4040", "Return type of public static getter '{0}' from exported class has or is using private name '{1}'."),
        Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4041, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_4041", "Return type of public getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4042, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4042", "Return type of public getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
        Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4043, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1_4043", "Return type of public getter '{0}' from exported class has or is using private name '{1}'."),
        Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4044, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_mod_4044", "Return type of constructor signature from exported interface has or is using name '{0}' from private module '{1}'."),
        Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4045, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0_4045", "Return type of constructor signature from exported interface has or is using private name '{0}'."),
        Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4046, ts2.DiagnosticCategory.Error, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4046", "Return type of call signature from exported interface has or is using name '{0}' from private module '{1}'."),
        Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4047, ts2.DiagnosticCategory.Error, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0_4047", "Return type of call signature from exported interface has or is using private name '{0}'."),
        Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4048, ts2.DiagnosticCategory.Error, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4048", "Return type of index signature from exported interface has or is using name '{0}' from private module '{1}'."),
        Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4049, ts2.DiagnosticCategory.Error, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0_4049", "Return type of index signature from exported interface has or is using private name '{0}'."),
        Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4050, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module__4050", "Return type of public static method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
        Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4051, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4051", "Return type of public static method from exported class has or is using name '{0}' from private module '{1}'."),
        Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0: diag(4052, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0_4052", "Return type of public static method from exported class has or is using private name '{0}'."),
        Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4053, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_c_4053", "Return type of public method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
        Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4054, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4054", "Return type of public method from exported class has or is using name '{0}' from private module '{1}'."),
        Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0: diag(4055, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0_4055", "Return type of public method from exported class has or is using private name '{0}'."),
        Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4056, ts2.DiagnosticCategory.Error, "Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4056", "Return type of method from exported interface has or is using name '{0}' from private module '{1}'."),
        Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0: diag(4057, ts2.DiagnosticCategory.Error, "Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0_4057", "Return type of method from exported interface has or is using private name '{0}'."),
        Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4058, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named_4058", "Return type of exported function has or is using name '{0}' from external module {1} but cannot be named."),
        Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1: diag(4059, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1_4059", "Return type of exported function has or is using name '{0}' from private module '{1}'."),
        Return_type_of_exported_function_has_or_is_using_private_name_0: diag(4060, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_private_name_0_4060", "Return type of exported function has or is using private name '{0}'."),
        Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4061, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_can_4061", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4062, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2_4062", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1: diag(4063, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1_4063", "Parameter '{0}' of constructor from exported class has or is using private name '{1}'."),
        Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4064, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_mod_4064", "Parameter '{0}' of constructor signature from exported interface has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4065, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4065", "Parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
        Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4066, ts2.DiagnosticCategory.Error, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4066", "Parameter '{0}' of call signature from exported interface has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4067, ts2.DiagnosticCategory.Error, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4067", "Parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
        Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4068, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module__4068", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4069, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4069", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4070, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4070", "Parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
        Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4071, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_c_4071", "Parameter '{0}' of public method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4072, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4072", "Parameter '{0}' of public method from exported class has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4073, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4073", "Parameter '{0}' of public method from exported class has or is using private name '{1}'."),
        Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4074, ts2.DiagnosticCategory.Error, "Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4074", "Parameter '{0}' of method from exported interface has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4075, ts2.DiagnosticCategory.Error, "Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4075", "Parameter '{0}' of method from exported interface has or is using private name '{1}'."),
        Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4076, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4076", "Parameter '{0}' of exported function has or is using name '{1}' from external module {2} but cannot be named."),
        Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2: diag(4077, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2_4077", "Parameter '{0}' of exported function has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4078, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_private_name_1_4078", "Parameter '{0}' of exported function has or is using private name '{1}'."),
        Exported_type_alias_0_has_or_is_using_private_name_1: diag(4081, ts2.DiagnosticCategory.Error, "Exported_type_alias_0_has_or_is_using_private_name_1_4081", "Exported type alias '{0}' has or is using private name '{1}'."),
        Default_export_of_the_module_has_or_is_using_private_name_0: diag(4082, ts2.DiagnosticCategory.Error, "Default_export_of_the_module_has_or_is_using_private_name_0_4082", "Default export of the module has or is using private name '{0}'."),
        Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1: diag(4083, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1_4083", "Type parameter '{0}' of exported type alias has or is using private name '{1}'."),
        Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_library_to_resolve_the_conflict: diag(4090, ts2.DiagnosticCategory.Error, "Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_librar_4090", "Conflicting definitions for '{0}' found at '{1}' and '{2}'. Consider installing a specific version of this library to resolve the conflict."),
        Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4091, ts2.DiagnosticCategory.Error, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4091", "Parameter '{0}' of index signature from exported interface has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4092, ts2.DiagnosticCategory.Error, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1_4092", "Parameter '{0}' of index signature from exported interface has or is using private name '{1}'."),
        Property_0_of_exported_class_expression_may_not_be_private_or_protected: diag(4094, ts2.DiagnosticCategory.Error, "Property_0_of_exported_class_expression_may_not_be_private_or_protected_4094", "Property '{0}' of exported class expression may not be private or protected."),
        Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4095, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_4095", "Public static method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4096, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4096", "Public static method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
        Public_static_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4097, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_private_name_1_4097", "Public static method '{0}' of exported class has or is using private name '{1}'."),
        Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4098, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4098", "Public method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4099, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4099", "Public method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
        Public_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4100, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_private_name_1_4100", "Public method '{0}' of exported class has or is using private name '{1}'."),
        Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4101, ts2.DiagnosticCategory.Error, "Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4101", "Method '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
        Method_0_of_exported_interface_has_or_is_using_private_name_1: diag(4102, ts2.DiagnosticCategory.Error, "Method_0_of_exported_interface_has_or_is_using_private_name_1_4102", "Method '{0}' of exported interface has or is using private name '{1}'."),
        Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1: diag(4103, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1_4103", "Type parameter '{0}' of exported mapped object type is using private name '{1}'."),
        The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1: diag(4104, ts2.DiagnosticCategory.Error, "The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1_4104", "The type '{0}' is 'readonly' and cannot be assigned to the mutable type '{1}'."),
        Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter: diag(4105, ts2.DiagnosticCategory.Error, "Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter_4105", "Private or protected member '{0}' cannot be accessed on a type parameter."),
        Parameter_0_of_accessor_has_or_is_using_private_name_1: diag(4106, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_private_name_1_4106", "Parameter '{0}' of accessor has or is using private name '{1}'."),
        Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2: diag(4107, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2_4107", "Parameter '{0}' of accessor has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4108, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4108", "Parameter '{0}' of accessor has or is using name '{1}' from external module '{2}' but cannot be named."),
        Type_arguments_for_0_circularly_reference_themselves: diag(4109, ts2.DiagnosticCategory.Error, "Type_arguments_for_0_circularly_reference_themselves_4109", "Type arguments for '{0}' circularly reference themselves."),
        Tuple_type_arguments_circularly_reference_themselves: diag(4110, ts2.DiagnosticCategory.Error, "Tuple_type_arguments_circularly_reference_themselves_4110", "Tuple type arguments circularly reference themselves."),
        The_current_host_does_not_support_the_0_option: diag(5001, ts2.DiagnosticCategory.Error, "The_current_host_does_not_support_the_0_option_5001", "The current host does not support the '{0}' option."),
        Cannot_find_the_common_subdirectory_path_for_the_input_files: diag(5009, ts2.DiagnosticCategory.Error, "Cannot_find_the_common_subdirectory_path_for_the_input_files_5009", "Cannot find the common subdirectory path for the input files."),
        File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5010, ts2.DiagnosticCategory.Error, "File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0_5010", "File specification cannot end in a recursive directory wildcard ('**'): '{0}'."),
        Cannot_read_file_0_Colon_1: diag(5012, ts2.DiagnosticCategory.Error, "Cannot_read_file_0_Colon_1_5012", "Cannot read file '{0}': {1}."),
        Failed_to_parse_file_0_Colon_1: diag(5014, ts2.DiagnosticCategory.Error, "Failed_to_parse_file_0_Colon_1_5014", "Failed to parse file '{0}': {1}."),
        Unknown_compiler_option_0: diag(5023, ts2.DiagnosticCategory.Error, "Unknown_compiler_option_0_5023", "Unknown compiler option '{0}'."),
        Compiler_option_0_requires_a_value_of_type_1: diag(5024, ts2.DiagnosticCategory.Error, "Compiler_option_0_requires_a_value_of_type_1_5024", "Compiler option '{0}' requires a value of type {1}."),
        Unknown_compiler_option_0_Did_you_mean_1: diag(5025, ts2.DiagnosticCategory.Error, "Unknown_compiler_option_0_Did_you_mean_1_5025", "Unknown compiler option '{0}'. Did you mean '{1}'?"),
        Could_not_write_file_0_Colon_1: diag(5033, ts2.DiagnosticCategory.Error, "Could_not_write_file_0_Colon_1_5033", "Could not write file '{0}': {1}."),
        Option_project_cannot_be_mixed_with_source_files_on_a_command_line: diag(5042, ts2.DiagnosticCategory.Error, "Option_project_cannot_be_mixed_with_source_files_on_a_command_line_5042", "Option 'project' cannot be mixed with source files on a command line."),
        Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES2015_or_higher: diag(5047, ts2.DiagnosticCategory.Error, "Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES_5047", "Option 'isolatedModules' can only be used when either option '--module' is provided or option 'target' is 'ES2015' or higher."),
        Option_0_cannot_be_specified_when_option_target_is_ES3: diag(5048, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_when_option_target_is_ES3_5048", "Option '{0}' cannot be specified when option 'target' is 'ES3'."),
        Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided: diag(5051, ts2.DiagnosticCategory.Error, "Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided_5051", "Option '{0} can only be used when either option '--inlineSourceMap' or option '--sourceMap' is provided."),
        Option_0_cannot_be_specified_without_specifying_option_1: diag(5052, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_without_specifying_option_1_5052", "Option '{0}' cannot be specified without specifying option '{1}'."),
        Option_0_cannot_be_specified_with_option_1: diag(5053, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_with_option_1_5053", "Option '{0}' cannot be specified with option '{1}'."),
        A_tsconfig_json_file_is_already_defined_at_Colon_0: diag(5054, ts2.DiagnosticCategory.Error, "A_tsconfig_json_file_is_already_defined_at_Colon_0_5054", "A 'tsconfig.json' file is already defined at: '{0}'."),
        Cannot_write_file_0_because_it_would_overwrite_input_file: diag(5055, ts2.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_would_overwrite_input_file_5055", "Cannot write file '{0}' because it would overwrite input file."),
        Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files: diag(5056, ts2.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files_5056", "Cannot write file '{0}' because it would be overwritten by multiple input files."),
        Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0: diag(5057, ts2.DiagnosticCategory.Error, "Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0_5057", "Cannot find a tsconfig.json file at the specified directory: '{0}'."),
        The_specified_path_does_not_exist_Colon_0: diag(5058, ts2.DiagnosticCategory.Error, "The_specified_path_does_not_exist_Colon_0_5058", "The specified path does not exist: '{0}'."),
        Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier: diag(5059, ts2.DiagnosticCategory.Error, "Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier_5059", "Invalid value for '--reactNamespace'. '{0}' is not a valid identifier."),
        Option_paths_cannot_be_used_without_specifying_baseUrl_option: diag(5060, ts2.DiagnosticCategory.Error, "Option_paths_cannot_be_used_without_specifying_baseUrl_option_5060", "Option 'paths' cannot be used without specifying '--baseUrl' option."),
        Pattern_0_can_have_at_most_one_Asterisk_character: diag(5061, ts2.DiagnosticCategory.Error, "Pattern_0_can_have_at_most_one_Asterisk_character_5061", "Pattern '{0}' can have at most one '*' character."),
        Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character: diag(5062, ts2.DiagnosticCategory.Error, "Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character_5062", "Substitution '{0}' in pattern '{1}' can have at most one '*' character."),
        Substitutions_for_pattern_0_should_be_an_array: diag(5063, ts2.DiagnosticCategory.Error, "Substitutions_for_pattern_0_should_be_an_array_5063", "Substitutions for pattern '{0}' should be an array."),
        Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2: diag(5064, ts2.DiagnosticCategory.Error, "Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2_5064", "Substitution '{0}' for pattern '{1}' has incorrect type, expected 'string', got '{2}'."),
        File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5065, ts2.DiagnosticCategory.Error, "File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildca_5065", "File specification cannot contain a parent directory ('..') that appears after a recursive directory wildcard ('**'): '{0}'."),
        Substitutions_for_pattern_0_shouldn_t_be_an_empty_array: diag(5066, ts2.DiagnosticCategory.Error, "Substitutions_for_pattern_0_shouldn_t_be_an_empty_array_5066", "Substitutions for pattern '{0}' shouldn't be an empty array."),
        Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name: diag(5067, ts2.DiagnosticCategory.Error, "Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name_5067", "Invalid value for 'jsxFactory'. '{0}' is not a valid identifier or qualified-name."),
        Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript_files_Learn_more_at_https_Colon_Slash_Slashaka_ms_Slashtsconfig: diag(5068, ts2.DiagnosticCategory.Error, "Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript__5068", "Adding a tsconfig.json file will help organize projects that contain both TypeScript and JavaScript files. Learn more at https://aka.ms/tsconfig."),
        Option_0_cannot_be_specified_without_specifying_option_1_or_option_2: diag(5069, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_without_specifying_option_1_or_option_2_5069", "Option '{0}' cannot be specified without specifying option '{1}' or option '{2}'."),
        Option_resolveJsonModule_cannot_be_specified_without_node_module_resolution_strategy: diag(5070, ts2.DiagnosticCategory.Error, "Option_resolveJsonModule_cannot_be_specified_without_node_module_resolution_strategy_5070", "Option '--resolveJsonModule' cannot be specified without 'node' module resolution strategy."),
        Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_esNext: diag(5071, ts2.DiagnosticCategory.Error, "Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_5071", "Option '--resolveJsonModule' can only be specified when module code generation is 'commonjs', 'amd', 'es2015' or 'esNext'."),
        Unknown_build_option_0: diag(5072, ts2.DiagnosticCategory.Error, "Unknown_build_option_0_5072", "Unknown build option '{0}'."),
        Build_option_0_requires_a_value_of_type_1: diag(5073, ts2.DiagnosticCategory.Error, "Build_option_0_requires_a_value_of_type_1_5073", "Build option '{0}' requires a value of type {1}."),
        Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBuildInfoFile_is_specified: diag(5074, ts2.DiagnosticCategory.Error, "Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBui_5074", "Option '--incremental' can only be specified using tsconfig, emitting to single file or when option `--tsBuildInfoFile` is specified."),
        _0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_constraint_2: diag(5075, ts2.DiagnosticCategory.Error, "_0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_5075", "'{0}' is assignable to the constraint of type '{1}', but '{1}' could be instantiated with a different subtype of constraint '{2}'."),
        _0_and_1_operations_cannot_be_mixed_without_parentheses: diag(5076, ts2.DiagnosticCategory.Error, "_0_and_1_operations_cannot_be_mixed_without_parentheses_5076", "'{0}' and '{1}' operations cannot be mixed without parentheses."),
        Unknown_build_option_0_Did_you_mean_1: diag(5077, ts2.DiagnosticCategory.Error, "Unknown_build_option_0_Did_you_mean_1_5077", "Unknown build option '{0}'. Did you mean '{1}'?"),
        Unknown_watch_option_0: diag(5078, ts2.DiagnosticCategory.Error, "Unknown_watch_option_0_5078", "Unknown watch option '{0}'."),
        Unknown_watch_option_0_Did_you_mean_1: diag(5079, ts2.DiagnosticCategory.Error, "Unknown_watch_option_0_Did_you_mean_1_5079", "Unknown watch option '{0}'. Did you mean '{1}'?"),
        Watch_option_0_requires_a_value_of_type_1: diag(5080, ts2.DiagnosticCategory.Error, "Watch_option_0_requires_a_value_of_type_1_5080", "Watch option '{0}' requires a value of type {1}."),
        Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0: diag(5081, ts2.DiagnosticCategory.Error, "Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0_5081", "Cannot find a tsconfig.json file at the current directory: {0}."),
        _0_could_be_instantiated_with_an_arbitrary_type_which_could_be_unrelated_to_1: diag(5082, ts2.DiagnosticCategory.Error, "_0_could_be_instantiated_with_an_arbitrary_type_which_could_be_unrelated_to_1_5082", "'{0}' could be instantiated with an arbitrary type which could be unrelated to '{1}'."),
        Cannot_read_file_0: diag(5083, ts2.DiagnosticCategory.Error, "Cannot_read_file_0_5083", "Cannot read file '{0}'."),
        The_inferred_type_of_0_references_a_type_with_a_cyclic_structure_which_cannot_be_trivially_serialized_A_type_annotation_is_necessary: diag(5088, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_references_a_type_with_a_cyclic_structure_which_cannot_be_trivially_serialize_5088", "The inferred type of '{0}' references a type with a cyclic structure which cannot be trivially serialized. A type annotation is necessary."),
        Generates_a_sourcemap_for_each_corresponding_d_ts_file: diag(6e3, ts2.DiagnosticCategory.Message, "Generates_a_sourcemap_for_each_corresponding_d_ts_file_6000", "Generates a sourcemap for each corresponding '.d.ts' file."),
        Concatenate_and_emit_output_to_single_file: diag(6001, ts2.DiagnosticCategory.Message, "Concatenate_and_emit_output_to_single_file_6001", "Concatenate and emit output to single file."),
        Generates_corresponding_d_ts_file: diag(6002, ts2.DiagnosticCategory.Message, "Generates_corresponding_d_ts_file_6002", "Generates corresponding '.d.ts' file."),
        Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations: diag(6003, ts2.DiagnosticCategory.Message, "Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations_6003", "Specify the location where debugger should locate map files instead of generated locations."),
        Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations: diag(6004, ts2.DiagnosticCategory.Message, "Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations_6004", "Specify the location where debugger should locate TypeScript files instead of source locations."),
        Watch_input_files: diag(6005, ts2.DiagnosticCategory.Message, "Watch_input_files_6005", "Watch input files."),
        Redirect_output_structure_to_the_directory: diag(6006, ts2.DiagnosticCategory.Message, "Redirect_output_structure_to_the_directory_6006", "Redirect output structure to the directory."),
        Do_not_erase_const_enum_declarations_in_generated_code: diag(6007, ts2.DiagnosticCategory.Message, "Do_not_erase_const_enum_declarations_in_generated_code_6007", "Do not erase const enum declarations in generated code."),
        Do_not_emit_outputs_if_any_errors_were_reported: diag(6008, ts2.DiagnosticCategory.Message, "Do_not_emit_outputs_if_any_errors_were_reported_6008", "Do not emit outputs if any errors were reported."),
        Do_not_emit_comments_to_output: diag(6009, ts2.DiagnosticCategory.Message, "Do_not_emit_comments_to_output_6009", "Do not emit comments to output."),
        Do_not_emit_outputs: diag(6010, ts2.DiagnosticCategory.Message, "Do_not_emit_outputs_6010", "Do not emit outputs."),
        Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typechecking: diag(6011, ts2.DiagnosticCategory.Message, "Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typech_6011", "Allow default imports from modules with no default export. This does not affect code emit, just typechecking."),
        Skip_type_checking_of_declaration_files: diag(6012, ts2.DiagnosticCategory.Message, "Skip_type_checking_of_declaration_files_6012", "Skip type checking of declaration files."),
        Do_not_resolve_the_real_path_of_symlinks: diag(6013, ts2.DiagnosticCategory.Message, "Do_not_resolve_the_real_path_of_symlinks_6013", "Do not resolve the real path of symlinks."),
        Only_emit_d_ts_declaration_files: diag(6014, ts2.DiagnosticCategory.Message, "Only_emit_d_ts_declaration_files_6014", "Only emit '.d.ts' declaration files."),
        Specify_ECMAScript_target_version_Colon_ES3_default_ES5_ES2015_ES2016_ES2017_ES2018_ES2019_ES2020_or_ESNEXT: diag(6015, ts2.DiagnosticCategory.Message, "Specify_ECMAScript_target_version_Colon_ES3_default_ES5_ES2015_ES2016_ES2017_ES2018_ES2019_ES2020_or_6015", "Specify ECMAScript target version: 'ES3' (default), 'ES5', 'ES2015', 'ES2016', 'ES2017', 'ES2018', 'ES2019', 'ES2020', or 'ESNEXT'."),
        Specify_module_code_generation_Colon_none_commonjs_amd_system_umd_es2015_es2020_or_ESNext: diag(6016, ts2.DiagnosticCategory.Message, "Specify_module_code_generation_Colon_none_commonjs_amd_system_umd_es2015_es2020_or_ESNext_6016", "Specify module code generation: 'none', 'commonjs', 'amd', 'system', 'umd', 'es2015', 'es2020', or 'ESNext'."),
        Print_this_message: diag(6017, ts2.DiagnosticCategory.Message, "Print_this_message_6017", "Print this message."),
        Print_the_compiler_s_version: diag(6019, ts2.DiagnosticCategory.Message, "Print_the_compiler_s_version_6019", "Print the compiler's version."),
        Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json: diag(6020, ts2.DiagnosticCategory.Message, "Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json_6020", "Compile the project given the path to its configuration file, or to a folder with a 'tsconfig.json'."),
        Syntax_Colon_0: diag(6023, ts2.DiagnosticCategory.Message, "Syntax_Colon_0_6023", "Syntax: {0}"),
        options: diag(6024, ts2.DiagnosticCategory.Message, "options_6024", "options"),
        file: diag(6025, ts2.DiagnosticCategory.Message, "file_6025", "file"),
        Examples_Colon_0: diag(6026, ts2.DiagnosticCategory.Message, "Examples_Colon_0_6026", "Examples: {0}"),
        Options_Colon: diag(6027, ts2.DiagnosticCategory.Message, "Options_Colon_6027", "Options:"),
        Version_0: diag(6029, ts2.DiagnosticCategory.Message, "Version_0_6029", "Version {0}"),
        Insert_command_line_options_and_files_from_a_file: diag(6030, ts2.DiagnosticCategory.Message, "Insert_command_line_options_and_files_from_a_file_6030", "Insert command line options and files from a file."),
        Starting_compilation_in_watch_mode: diag(6031, ts2.DiagnosticCategory.Message, "Starting_compilation_in_watch_mode_6031", "Starting compilation in watch mode..."),
        File_change_detected_Starting_incremental_compilation: diag(6032, ts2.DiagnosticCategory.Message, "File_change_detected_Starting_incremental_compilation_6032", "File change detected. Starting incremental compilation..."),
        KIND: diag(6034, ts2.DiagnosticCategory.Message, "KIND_6034", "KIND"),
        FILE: diag(6035, ts2.DiagnosticCategory.Message, "FILE_6035", "FILE"),
        VERSION: diag(6036, ts2.DiagnosticCategory.Message, "VERSION_6036", "VERSION"),
        LOCATION: diag(6037, ts2.DiagnosticCategory.Message, "LOCATION_6037", "LOCATION"),
        DIRECTORY: diag(6038, ts2.DiagnosticCategory.Message, "DIRECTORY_6038", "DIRECTORY"),
        STRATEGY: diag(6039, ts2.DiagnosticCategory.Message, "STRATEGY_6039", "STRATEGY"),
        FILE_OR_DIRECTORY: diag(60