"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const constants_1 = require("./backend/shared/constants");
const repository_1 = require("./codeartifact/repository");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(scope, id);
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = new s3.Bucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                {
                    noncurrentVersionTransitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: core_1.Duration.days(31),
                        },
                    ],
                },
                // Permanently delete non-current object versions after 3 months
                {
                    noncurrentVersionExpiration: core_1.Duration.days(90),
                    expiredObjectDeleteMarker: true,
                },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const codeArtifact = new repository_1.Repository(this, 'CodeArtifact', {
            description: 'Proxy to npmjs.com for ConstructHub',
            domainName: (_b = props.codeArtifactDomain) === null || _b === void 0 ? void 0 : _b.name,
            domainExists: props.codeArtifactDomain != null,
            upstreams: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.upstreams,
        });
        const { vpc, vpcEndpoints, vpcSubnets } = this.createVpc(props, codeArtifact);
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_d = props.denyList) !== null && _d !== void 0 ? _d : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            logRetention: props.logRetention,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets,
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder);
        const packageTagsSerialized = (_f = (_e = props.packageTags) === null || _e === void 0 ? void 0 : _e.map((config) => {
            return {
                ...config,
                condition: config.condition.bind(),
            };
        })) !== null && _f !== void 0 ? _f : [];
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', {
            bucket: packageData,
            orchestration,
            logRetention: props.logRetention,
            monitoring,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
        });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_g = props.allowedLicenses) !== null && _g !== void 0 ? _g : [
                ...spdx_license_1.SpdxLicense.apache(),
                ...spdx_license_1.SpdxLicense.bsd(),
                ...spdx_license_1.SpdxLicense.mit(),
            ],
        });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_h = props.packageSources) !== null && _h !== void 0 ? _h : [new package_sources_1.NpmJs()]).map((source) => source.bind(sources, {
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, logRetention: props.logRetention, monitoring });
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
        });
        new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
            featuredPackages: props.featuredPackages,
        });
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
    createVpc(props, codeArtifact) {
        if (props.isolateSensitiveTasks === false) {
            return { vpc: undefined, vpcEndpoints: undefined, vpcSubnets: undefined };
        }
        const vpc = new ec2.Vpc(this, 'Lambda-VPC', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 0,
            // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
            // a whole new VPC if we ever need to introduce subnets of these types.
            subnetConfiguration: [
                // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                { name: 'Public', subnetType: ec2.SubnetType.PUBLIC, reserved: true },
                { name: 'Private', subnetType: ec2.SubnetType.PRIVATE, reserved: true },
                { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED },
            ],
        });
        const vpcSubnets = { subnetType: ec2.SubnetType.ISOLATED };
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: vpcSubnets,
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: vpcSubnets,
            }),
            // This is needed so that ECS workloads can use the awslogs driver
            cloudWatchLogs: vpc.addInterfaceEndpoint('CloudWatch.Logs', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
                subnets: vpcSubnets,
            }),
            // These are needed for ECS workloads to be able to pull images
            ecrApi: vpc.addInterfaceEndpoint('ECR.API', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR,
                subnets: vpcSubnets,
            }),
            ecr: vpc.addInterfaceEndpoint('ECR.Docker', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
                subnets: vpcSubnets,
            }),
            // This is needed (among others) for CodeArtifact registry usage
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [vpcSubnets],
            }),
            // This is useful for getting results from ECS tasks within workflows
            stepFunctions: vpc.addInterfaceEndpoint('StepFunctions', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.STEP_FUNCTIONS,
                subnets: vpcSubnets,
            }),
        };
        // The S3 access is necessary for the CodeArtifact Repository and ECR Docker
        // endpoints to be used (they serve objects from S3).
        vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [
                // The in-region CodeArtifact S3 Bucket
                `${codeArtifact.s3BucketArn}/*`,
                // The in-region ECR layer bucket
                `arn:aws:s3:::prod-${core_1.Stack.of(this).region}-starport-layer-bucket/*`,
            ],
            // It doesn't seem we can constrain principals for these grants (unclear
            // which principal those calls are made from, or if that is something we
            // could name here).
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-and-ECR',
        }));
        return { vpc, vpcEndpoints, vpcSubnets };
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.2.32" };
//# sourceMappingURL=data:application/json;base64,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