import type { Alarm } from '@aws-cdk/aws-cloudwatch';
/**
 * (experimental) ConstructHub monitoring features exposed to extension points.
 *
 * @experimental
 */
export interface IMonitoring {
    /**
     * (experimental) Adds a high-severity alarm.
     *
     * If this alarm goes off, the action specified in
     * `highSeverityAlarmActionArn` is triggered.
     *
     * @param title a user-friendly title for the alarm (will be rendered on the high-severity CloudWatch dashboard).
     * @param alarm the alarm to be added to the high-severity dashboard.
     * @experimental
     */
    addHighSeverityAlarm(title: string, alarm: Alarm): void;
    /**
     * (experimental) Adds a low-severity alarm.
     *
     * If this alarm goes off, the action specified in
     * `normalAlarmAction` is triggered.
     *
     * @param title a user-friendly title for the alarm (not currently used).
     * @param alarm the alarm to be added.
     * @experimental
     */
    addLowSeverityAlarm(title: string, alarm: Alarm): void;
}
