"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_embedded_metrics_1 = require("aws-embedded-metrics");
const AWS = require("aws-sdk");
const env_lambda_shared_1 = require("../../backend/shared/env.lambda-shared");
const constants_1 = require("./constants");
const DISTRIBUTION_ID = env_lambda_shared_1.requireEnv('DISTRIBUTION_ID');
const PATH_PREFIX = env_lambda_shared_1.requireEnv('PATH_PREFIX');
async function handler(event, context) {
    console.log(`Event: ${JSON.stringify(event, null, 2)}`);
    if (event.Records.length === 0) {
        return;
    }
    await aws_embedded_metrics_1.metricScope((metrics) => () => {
        // Clear default dimensions, we don't need those.
        metrics.setDimensions();
        metrics.setNamespace(constants_1.METRICS_NAMESPACE);
        const now = Date.now();
        for (const record of event.Records) {
            const age = now - new Date(record.eventTime).getTime();
            metrics.putMetric("S3EventAge" /* S3_EVENT_AGE */, age, aws_embedded_metrics_1.Unit.Milliseconds);
        }
    })();
    const cf = new AWS.CloudFront();
    const invalidationRequest = {
        DistributionId: DISTRIBUTION_ID,
        InvalidationBatch: {
            Paths: {
                Quantity: event.Records.length,
                Items: event.Records.map((record) => `${PATH_PREFIX}${record.s3.object.key}`),
            },
            CallerReference: context.awsRequestId,
        },
    };
    console.log(JSON.stringify({ invalidationRequet: invalidationRequest }));
    const invalidationResponse = cf.createInvalidation(invalidationRequest).promise();
    console.log(JSON.stringify({ invalidationResponse }));
    return invalidationResponse;
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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